/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class CurrencyNames_cs extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_BGL = "BGL";
        final Object[][] data = new Object[][] {
            { "UGS", "UGS" },
            { "mwk", "malawijsk\u00e1 kwacha" },
            { "FJD", "FJD" },
            { "lul", "lucembursk\u00fd finan\u010dn\u00ed frank" },
            { "LVL", "LVL" },
            { "SCR", "SCR" },
            { "CDF", "CDF" },
            { "MXP", "MXP" },
            { "bad", "bosensk\u00fd din\u00e1r (1992\u20131994)" },
            { "BBD", "BBD" },
            { "HNL", "HNL" },
            { "UGX", "UGX" },
            { "LVR", "LVR" },
            { "MXV", "MXV" },
            { "fim", "finsk\u00e1 marka" },
            { "dem", "n\u011bmeck\u00e1 marka" },
            { "ban", "bosensk\u00fd nov\u00fd din\u00e1r (1994\u20131997)" },
            { "bam", "bosensk\u00e1 konvertibiln\u00ed marka" },
            { "egp", "egyptsk\u00e1 libra" },
            { "SDD", "SDD" },
            { "SDG", "SDG" },
            { "ZRN", "ZRN" },
            { "nzd", "novoz\u00e9landsk\u00fd dolar" },
            { "IQD", "IQD" },
            { "SDP", "SDP" },
            { "GMD", "GMD" },
            { "ugs", "ugandsk\u00fd \u0161ilink (1966\u20131987)" },
            { "fjd", "fid\u017eijsk\u00fd dolar" },
            { "mxn", "mexick\u00e9 peso" },
            { "ZRZ", "ZRZ" },
            { "lvl", "loty\u0161sk\u00fd lat" },
            { "scr", "seychelsk\u00e1 rupie" },
            { "cdf", "kon\u017esk\u00fd frank" },
            { "mxp", "mexick\u00e9 st\u0159\u00edbrn\u00e9 peso (1861\u20131992)" },
            { "bbd", "barbadosk\u00fd dolar" },
            { "MYR", "MYR" },
            { "hnl", "hondurask\u00e1 lempira" },
            { "ugx", "ugandsk\u00fd \u0161ilink" },
            { "lvr", "loty\u0161sk\u00fd rubl" },
            { "FKP", "FKP" },
            { "mxv", "mexick\u00e1 investi\u010dn\u00ed jednotka" },
            { "sdd", "s\u00fad\u00e1nsk\u00fd din\u00e1r (1992\u20132007)" },
            { "sdg", "s\u00fad\u00e1nsk\u00e1 libra" },
            { "zrn", "zairsk\u00fd nov\u00fd zaire (1993\u20131998)" },
            { "SEK", "SEK" },
            { "MZE", "MZE" },
            { "iqd", "ir\u00e1ck\u00fd din\u00e1r" },
            { "GNF", "GNF" },
            { "sdp", "s\u00fad\u00e1nsk\u00e1 libra (1957\u20131998)" },
            { "gmd", "gambijsk\u00fd dalasi" },
            { "MZN", "MZN" },
            { "MZM", "MZM" },
            { "QAR", "QAR" },
            { "zrz", "zairsk\u00fd zaire (1971\u20131993)" },
            { "myr", "malajsijsk\u00fd ringgit" },
            { "IRR", "IRR" },
            { "fkp", "falklandsk\u00e1 libra" },
            { "GNS", "GNS" },
            { "XPD", "XPD" },
            { "xof", "CFA/BCEAO frank" },
            { "THB", "THB" },
            { "BDT", "BDT" },
            { "LYD", "LYD" },
            { "sek", "\u0161v\u00e9dsk\u00e1 koruna" },
            { "KWD", "KWD" },
            { "mze", "mosambick\u00fd escudo" },
            { "XPT", "XPT" },
            { "gnf", "guinejsk\u00fd frank" },
            { "ISK", "ISK" },
            { "mzn", "mozambick\u00fd metical" },
            { "BEC", "BEC" },
            { "ISJ", "ISJ" },
            { "mzm", "mosambick\u00fd metical (1980\u20132006)" },
            { "BEF", "BEF" },
            { "qar", "katarsk\u00fd rij\u00e1l" },
            { "BEL", "BEL" },
            { "irr", "\u00edr\u00e1nsk\u00fd rij\u00e1l" },
            { "gns", "guinejsk\u00fd syli" },
            { "xpd", "palladium" },
            { "thb", "thajsk\u00fd baht" },
            { "xpf", "CFP frank" },
            { "PAB", "PAB" },
            { "SGD", "SGD" },
            { "bdt", "banglad\u00e9\u0161sk\u00e1 taka" },
            { "lyd", "libyjsk\u00fd din\u00e1r" },
            { "kwd", "kuvajtsk\u00fd din\u00e1r" },
            { "HRD", "HRD" },
            { "xpt", "platina" },
            { "CHF", "CHF" },
            { "HRK", "HRK" },
            { "ITL", "ITL" },
            { "isk", "islandsk\u00e1 koruna" },
            { "CHE", "CHE" },
            { "DJF", "DJF" },
            { "bec", "belgick\u00fd konvertibiln\u00ed frank" },
            { "isj", "islandsk\u00e1 koruna (1918\u20131981)" },
            { "bef", "belgick\u00fd frank" },
            { "bel", "belgick\u00fd finan\u010dn\u00ed frank" },
            { "XRE", "XRE" },
            { "ADP", "ADP" },
            { "VND", "VND" },
            { "pab", "panamsk\u00e1 balboa" },
            { "sgd", "singapursk\u00fd dolar" },
            { "CHW", "CHW" },
            { "KYD", "KYD" },
            { "VNN", "VNN" },
            { "GQE", "GQE" },
            { "SHP", "SHP" },
            { "hrd", "chorvatsk\u00fd din\u00e1r" },
            { "TJS", "TJS" },
            { "TJR", "TJR" },
            { "AED", "AED" },
            { "chf", "\u0161v\u00fdcarsk\u00fd frank" },
            { "hrk", "chorvatsk\u00e1 kuna" },
            { "itl", "italsk\u00e1 lira" },
            { "che", "\u0161v\u00fdcarsk\u00e9 WIR-euro" },
            { "djf", "d\u017eibutsk\u00fd frank" },
            { "DKK", "DKK" },
            { "BGL", metaValue_BGL },
            { "ZWD", "ZWD" },
            { "BGN", "BGN" },
            { "BGM", "BGM" },
            { "YUD", "YUD" },
            { "xre", "k\u00f3d fond\u016f RINET" },
            { "BGO", "BGO" },
            { "adp", "andorrsk\u00e1 peseta" },
            { "vnd", "vietnamsk\u00fd dong" },
            { "ZWL", "ZWL" },
            { "YUM", "YUM" },
            { "YUN", "YUN" },
            { "chw", "\u0161v\u00fdcarsk\u00fd WIR-frank" },
            { "ZWR", "ZWR" },
            { "YUR", "YUR" },
            { "kyd", "kajmansk\u00fd dolar" },
            { "vnn", "vietnamsk\u00fd dong (1978\u20131985)" },
            { "GRD", "GRD" },
            { "HTG", "HTG" },
            { "gqe", "rovn\u00edkovoguinejsk\u00fd ekwele" },
            { "shp", "svatohelensk\u00e1 libra" },
            { "XSU", "XSU" },
            { "AFA", "AFA" },
            { "tjs", "t\u00e1d\u017eick\u00e9 somoni" },
            { "tjr", "t\u00e1d\u017eick\u00fd rubl" },
            { "BHD", "BHD" },
            { "SIT", "SIT" },
            { "aed", "SAE dirham" },
            { "KZT", "KZT" },
            { "dkk", "d\u00e1nsk\u00e1 koruna" },
            { "bgl", metaValue_BGL },
            { "zwd", "zimbabwsk\u00fd dolar (1980\u20132008)" },
            { "bgn", "bulharsk\u00fd lev" },
            { "AFN", "AFN" },
            { "yud", "jugosl\u00e1vsk\u00fd din\u00e1r (1966\u20131990)" },
            { "bgo", "bulharsk\u00fd lev (1879\u20131952)" },
            { "zwl", "zimbabwsk\u00fd dolar (2009)" },
            { "RHD", "RHD" },
            { "yum", "jugosl\u00e1vsk\u00fd nov\u00fd din\u00e1r (1994\u20132002)" },
            { "yun", "jugosl\u00e1vsk\u00fd konvertibiln\u00ed din\u00e1r (1990\u20131992)" },
            { "zwr", "zimbabwsk\u00fd dolar (2008)" },
            { "XTS", "XTS" },
            { "yur", "jugosl\u00e1vsk\u00fd reformovan\u00fd din\u00e1r (1992\u20131993)" },
            { "HUF", "HUF" },
            { "grd", "\u0159eck\u00e1 drachma" },
            { "htg", "haitsk\u00fd gourde" },
            { "xsu", "sucre" },
            { "afa", "afgh\u00e1nsk\u00fd afgh\u00e1n (1927\u20132002)" },
            { "BIF", "BIF" },
            { "bhd", "bahrajnsk\u00fd din\u00e1r" },
            { "sit", "slovinsk\u00fd tolar" },
            { "kzt", "kaza\u0161sk\u00e9 tenge" },
            { "XUA", "XUA" },
            { "afn", "afgh\u00e1nsk\u00fd afgh\u00e1n" },
            { "rhd", "rhod\u00e9sk\u00fd dolar" },
            { "NAD", "NAD" },
            { "SKK", "SKK" },
            { "PEI", "PEI" },
            { "TMM", "TMM" },
            { "xts", "k\u00f3d zvl\u00e1\u0161\u0165 vyhrazen\u00fd pro testovac\u00ed \u00fa\u010dely" },
            { "PEN", "PEN" },
            { "huf", "ma\u010farsk\u00fd forint" },
            { "WST", "WST" },
            { "TMT", "TMT" },
            { "FRF", "FRF" },
            { "CLF", "CLF" },
            { "CLE", "CLE" },
            { "bif", "burundsk\u00fd frank" },
            { "PES", "PES" },
            { "GTQ", "GTQ" },
            { "CLP", "CLP" },
            { "TND", "TND" },
            { "nad", "namibijsk\u00fd dolar" },
            { "SLL", "SLL" },
            { "skk", "slovensk\u00e1 koruna" },
            { "pei", "peru\u00e1nsk\u00e1 inti" },
            { "tmm", "turkmensk\u00fd manat (1993\u20132009)" },
            { "pen", "peru\u00e1nsk\u00fd nov\u00fd sol" },
            { "wst", "samojsk\u00e1 tala" },
            { "tmt", "turkmensk\u00fd manat" },
            { "frf", "francouzsk\u00fd frank" },
            { "clf", "chilsk\u00e1 \u00fa\u010detn\u00ed jednotka (UF)" },
            { "cle", "chilsk\u00e9 escudo" },
            { "pes", "peru\u00e1nsk\u00fd sol (1863\u20131965)" },
            { "DOP", "DOP" },
            { "gtq", "guatemalsk\u00fd quetzal" },
            { "clp", "chilsk\u00e9 peso" },
            { "tnd", "tunisk\u00fd din\u00e1r" },
            { "MAD", "MAD" },
            { "sll", "sierro-leonsk\u00fd leone" },
            { "MAF", "MAF" },
            { "TOP", "TOP" },
            { "PGK", "PGK" },
            { "ERN", "ERN" },
            { "dop", "dominik\u00e1nsk\u00e9 peso" },
            { "TPE", "TPE" },
            { "mad", "marock\u00fd din\u00e1r" },
            { "ESA", "ESA" },
            { "maf", "marock\u00fd frank" },
            { "GWE", "GWE" },
            { "top", "ton\u017esk\u00e1 paanga" },
            { "ESB", "ESB" },
            { "pgk", "papu\u00e1nsk\u00e1 nov\u00e1 kina" },
            { "BMD", "BMD" },
            { "PHP", "PHP" },
            { "XXX", "XXX" },
            { "ern", "eritrejsk\u00e1 nakfa" },
            { "GWP", "GWP" },
            { "ESP", "ESP" },
            { "COP", "COP" },
            { "COU", "COU" },
            { "tpe", "timorsk\u00e9 escudo" },
            { "cny", "\u010d\u00ednsk\u00fd j\u00fcan" },
            { "MCF", "MCF" },
            { "USN", "USN" },
            { "ETB", "ETB" },
            { "esa", "\u0161pan\u011blsk\u00e1 peseta (\u201eA\u201c \u00fa\u010det)" },
            { "USS", "USS" },
            { "gwe", "portugalskoguinejsk\u00e9 escudo" },
            { "esb", "\u0161pan\u011blsk\u00e1 peseta (konvertibiln\u00ed \u00fa\u010det)" },
            { "SOS", "SOS" },
            { "VUV", "VUV" },
            { "LAK", "LAK" },
            { "bmd", "bermudsk\u00fd dolar" },
            { "BND", "BND" },
            { "php", "filip\u00ednsk\u00e9 peso" },
            { "xxx", "nezn\u00e1m\u00e1 m\u011bna" },
            { "ALK", "ALK" },
            { "ALL", "ALL" },
            { "gwp", "guinejsko-bissausk\u00e9 peso" },
            { "esp", "\u0161pan\u011blsk\u00e1 peseta" },
            { "cop", "kolumbijsk\u00e9 peso" },
            { "usd", "americk\u00fd dolar" },
            { "cou", "kolumbijsk\u00e1 jednotka re\u00e1ln\u00e9 hodnoty" },
            { "MDC", "MDC" },
            { "TRL", "TRL" },
            { "mcf", "monack\u00fd frank" },
            { "usn", "americk\u00fd dolar (p\u0159\u00ed\u0161t\u00ed den)" },
            { "etb", "etiopsk\u00fd birr" },
            { "GYD", "GYD" },
            { "BOB", "BOB" },
            { "MDL", "MDL" },
            { "uss", "americk\u00fd dolar (t\u00fd\u017e den)" },
            { "sos", "som\u00e1lsk\u00fd \u0161ilink" },
            { "vuv", "vanuatsk\u00fd vatu" },
            { "lak", "laosk\u00fd kip" },
            { "AMD", "AMD" },
            { "bnd", "brunejsk\u00fd dolar" },
            { "TRY", "TRY" },
            { "LBP", "LBP" },
            { "BOL", "BOL" },
            { "all", "alb\u00e1nsk\u00fd lek" },
            { "alk", "alb\u00e1nsk\u00fd lek (1946\u20131965)" },
            { "BOP", "BOP" },
            { "BOV", "BOV" },
            { "mdc", "moldavsk\u00fd kupon" },
            { "ROL", "ROL" },
            { "trl", "tureck\u00e1 lira (1922\u20132005)" },
            { "RON", "RON" },
            { "gyd", "guyansk\u00fd dolar" },
            { "NGN", "NGN" },
            { "bob", "bolivijsk\u00fd boliviano" },
            { "mdl", "moldavsk\u00fd leu" },
            { "CRC", "CRC" },
            { "PKR", "PKR" },
            { "amd", "arm\u00e9nsk\u00fd dram" },
            { "ANG", "ANG" },
            { "try", "tureck\u00e1 lira" },
            { "lbp", "libanonsk\u00e1 libra" },
            { "bol", "bolivijsk\u00fd boliviano (1863\u20131963)" },
            { "bop", "bolivijsk\u00e9 peso" },
            { "eur", "euro" },
            { "SRD", "SRD" },
            { "TTD", "TTD" },
            { "bov", "bolivijsk\u00fd mvdol" },
            { "SRG", "SRG" },
            { "rol", "rumunsk\u00e9 leu (1952\u20132006)" },
            { "ron", "rumunsk\u00e9 leu" },
            { "AOA", "AOA" },
            { "PLN", "PLN" },
            { "ngn", "nigerijsk\u00e1 naira" },
            { "CSD", "CSD" },
            { "crc", "kostarick\u00fd col\u00f3n" },
            { "pkr", "p\u00e1kist\u00e1nsk\u00e1 rupie" },
            { "CSK", "K\u010ds" },
            { "ang", "nizozemskoantilsk\u00fd gulden" },
            { "AOK", "AOK" },
            { "PLZ", "PLZ" },
            { "AON", "AON" },
            { "AOR", "AOR" },
            { "srd", "surinamsk\u00fd dolar" },
            { "ttd", "trinidadsk\u00fd dolar" },
            { "MGA", "MGA" },
            { "NIC", "NIC" },
            { "srg", "surinamsk\u00fd zlat\u00fd" },
            { "MGF", "MGF" },
            { "SSP", "SSP" },
            { "BRC", "BRC" },
            { "aoa", "angolsk\u00e1 kwanza" },
            { "BRB", "BRB" },
            { "pln", "polsk\u00fd zlot\u00fd" },
            { "BRE", "BRE" },
            { "NIO", "NIO" },
            { "csd", "srbsk\u00fd din\u00e1r (2002\u20132006)" },
            { "csk", "\u010deskoslovensk\u00e1 koruna" },
            { "aok", "angolsk\u00e1 kwanza (1977\u20131991)" },
            { "BRN", "BRN" },
            { "plz", "polsk\u00fd zlot\u00fd (1950\u20131995)" },
            { "aon", "angolsk\u00e1 kwanza (1990\u20132000)" },
            { "STD", "STD" },
            { "BRR", "BRR" },
            { "ZAL", "ZAL" },
            { "aor", "angolsk\u00e1 kwanza (1995\u20131999)" },
            { "mga", "madagaskarsk\u00fd ariary" },
            { "nic", "nikaragujsk\u00e1 c\u00f3rdoba (1988\u20131991)" },
            { "ZAR", "ZAR" },
            { "BRZ", "BRZ" },
            { "mgf", "madagaskarsk\u00fd frank" },
            { "CUC", "CUC" },
            { "ssp", "jihos\u00fad\u00e1nsk\u00e1 libra" },
            { "BSD", "BSD" },
            { "brc", "brazilsk\u00e9 cruzado (1986\u20131989)" },
            { "brb", "brazilsk\u00e9 nov\u00e9 cruzeiro (1967\u20131986)" },
            { "bre", "brazilsk\u00e9 cruzeiro (1990\u20131993)" },
            { "nio", "nikaragujsk\u00e1 c\u00f3rdoba" },
            { "brl", "brazilsk\u00fd real" },
            { "CUP", "CUP" },
            { "brn", "brazilsk\u00e9 nov\u00e9 cruzado (1989\u20131990)" },
            { "RSD", "RSD" },
            { "std", "svatotom\u00e1\u0161sk\u00e1 dobra" },
            { "brr", "brazilsk\u00e9 cruzeiro (1993\u20131994)" },
            { "UYI", "UYI" },
            { "zal", "jihoafrick\u00fd finan\u010dn\u00ed rand" },
            { "zar", "jihoafrick\u00fd rand" },
            { "brz", "brazilsk\u00e9 cruzeiro (1942\u20131967)" },
            { "UYP", "UYP" },
            { "ARA", "ARA" },
            { "UYU", "UYU" },
            { "cuc", "kub\u00e1nsk\u00e9 konvertibiln\u00ed peso" },
            { "SUR", "SUR" },
            { "bsd", "bahamsk\u00fd dolar" },
            { "CVE", "CVE" },
            { "OMR", "OMR" },
            { "KES", "KES" },
            { "ARL", "ARL" },
            { "ARM", "ARM" },
            { "BTN", "BTN" },
            { "ARP", "ARP" },
            { "cup", "kub\u00e1nsk\u00e9 peso" },
            { "twd", "tchajwansk\u00fd dolar" },
            { "SVC", "SVC" },
            { "ARS", "ARS" },
            { "rsd", "srbsk\u00fd din\u00e1r" },
            { "uyi", "uruguaysk\u00e9 peso (v indexovan\u00fdch jednotk\u00e1ch)" },
            { "NLG", "NLG" },
            { "uyp", "uruguaysk\u00e9 peso (1975\u20131993)" },
            { "UZS", "UZS" },
            { "uyu", "uruguaysk\u00e9 peso" },
            { "ara", "argentinsk\u00fd austral" },
            { "sur", "sov\u011btsk\u00fd rubl" },
            { "cve", "kapverdsk\u00e9 escudo" },
            { "omr", "om\u00e1nsk\u00fd rij\u00e1l" },
            { "kes", "ke\u0148sk\u00fd \u0161ilink" },
            { "BUK", "BUK" },
            { "arl", "argentinsk\u00e9 peso ley (1970\u20131983)" },
            { "arm", "argentinsk\u00e9 peso (1881\u20131970)" },
            { "btn", "bh\u00fat\u00e1nsk\u00fd ngultrum" },
            { "RUB", "RUB" },
            { "arp", "argentinsk\u00e9 peso (1983\u20131985)" },
            { "svc", "salvadorsk\u00fd col\u00f3n" },
            { "ars", "argentinsk\u00e9 peso" },
            { "MKD", "MKD" },
            { "nlg", "nizozemsk\u00fd gulden" },
            { "RUR", "RUR" },
            { "DZD", "DZD" },
            { "uzs", "uzbeck\u00fd sum" },
            { "MKN", "MKN" },
            { "KGS", "KGS" },
            { "buk", "barmsk\u00fd kyat" },
            { "rub", "rusk\u00fd rubl" },
            { "XAG", "XAG" },
            { "ATS", "ATS" },
            { "MLF", "MLF" },
            { "mkd", "makedonsk\u00fd den\u00e1r" },
            { "TZS", "TZS" },
            { "XAU", "XAU" },
            { "rur", "rusk\u00fd rubl (1991\u20131998)" },
            { "dzd", "al\u017e\u00edrsk\u00fd din\u00e1r" },
            { "AUD", "AU$" },
            { "mkn", "makedonsk\u00fd den\u00e1r (1992\u20131993)" },
            { "KHR", "KHR" },
            { "IDR", "IDR" },
            { "XBA", "XBA" },
            { "kgs", "kyrgyzsk\u00fd som" },
            { "XBC", "XBC" },
            { "YDD", "YDD" },
            { "XBB", "XBB" },
            { "BWP", "BWP" },
            { "CYP", "CYP" },
            { "XBD", "XBD" },
            { "xaf", "CFA/BEAC frank" },
            { "xag", "st\u0159\u00edbro" },
            { "RWF", "RWF" },
            { "ats", "rakousk\u00fd \u0161ilink" },
            { "mlf", "malijsk\u00fd frank" },
            { "MMK", "MMK" },
            { "NOK", "NOK" },
            { "SYP", "SYP" },
            { "tzs", "tanzansk\u00fd \u0161ilink" },
            { "xau", "zlato" },
            { "aud", "australsk\u00fd dolar" },
            { "LKR", "LKR" },
            { "khr", "kambod\u017esk\u00fd riel" },
            { "CZK", "K\u010d" },
            { "IEP", "IEP" },
            { "idr", "indon\u00e9sk\u00e1 rupie" },
            { "xba", "evropsk\u00e1 sm\u00ed\u0161en\u00e1 jednotka" },
            { "xbc", "evropsk\u00e1 jednotka \u00fa\u010dtu 9 (XBC)" },
            { "ydd", "jemensk\u00fd din\u00e1r" },
            { "xbb", "evropsk\u00e1 pen\u011b\u017en\u00ed jednotka" },
            { "bwp", "botswansk\u00e1 pula" },
            { "cyp", "kypersk\u00e1 libra" },
            { "xbd", "evropsk\u00e1 jednotka \u00fa\u010dtu 17 (XBD)" },
            { "PTE", "PTE" },
            { "rwf", "rwandsk\u00fd frank" },
            { "SZL", "SZL" },
            { "YER", "YER" },
            { "BYB", "BYB" },
            { "mmk", "myanmarsk\u00fd kyat" },
            { "nok", "norsk\u00e1 koruna" },
            { "syp", "syrsk\u00e1 libra" },
            { "AWG", "AWG" },
            { "NPR", "NPR" },
            { "MNT", "MNT" },
            { "lkr", "sr\u00edlansk\u00e1 rupie" },
            { "czk", "\u010desk\u00e1 koruna" },
            { "iep", "irsk\u00e1 libra" },
            { "xcd", "v\u00fdchodokaribsk\u00fd dolar" },
            { "BYR", "BYR" },
            { "pte", "portugalsk\u00e9 escudo" },
            { "szl", "svazijsk\u00fd lilangeni" },
            { "XDR", "XDR" },
            { "yer", "jemensk\u00fd rij\u00e1l" },
            { "byb", "b\u011blorusk\u00fd rubl (1994\u20131999)" },
            { "BZD", "BZD" },
            { "MOP", "MOP" },
            { "awg", "arubsk\u00fd zlat\u00fd" },
            { "npr", "nep\u00e1lsk\u00e1 rupie" },
            { "mnt", "mongolsk\u00fd tugrik" },
            { "gbp", "britsk\u00e1 libra" },
            { "byr", "b\u011blorusk\u00fd rubl" },
            { "xdr", "SDR" },
            { "XEU", "ECU" },
            { "bzd", "belizsk\u00fd dolar" },
            { "mop", "macajsk\u00e1 pataca" },
            { "XFO", "XFO" },
            { "KMF", "KMF" },
            { "XFU", "XFU" },
            { "xeu", "evropsk\u00e1 m\u011bnov\u00e1 jednotka" },
            { "GEK", "GEK" },
            { "GEL", "GEL" },
            { "AZM", "AZM" },
            { "AZN", "AZN" },
            { "UAH", "UAH" },
            { "UAK", "UAK" },
            { "xfo", "francouzsk\u00fd zlat\u00fd frank" },
            { "kmf", "komorsk\u00fd frank" },
            { "xfu", "francouzsk\u00fd UIC frank" },
            { "MRO", "MRO" },
            { "gek", "gruz\u00ednsk\u00e9 kuponov\u00e9 lari" },
            { "gel", "gruz\u00ednsk\u00e9 lari" },
            { "azn", "\u00e1zerb\u00e1jd\u017e\u00e1nsk\u00fd manat" },
            { "azm", "\u00e1zerb\u00e1jd\u017e\u00e1nsk\u00fd manat (1993\u20132006)" },
            { "uah", "ukrajinsk\u00e1 h\u0159ivna" },
            { "uak", "ukrajinsk\u00fd karbovanec" },
            { "PYG", "PYG" },
            { "JMD", "JMD" },
            { "mro", "maurit\u00e1nsk\u00e1 ouguiya" },
            { "VEB", "VEB" },
            { "ECS", "ECS" },
            { "VEF", "VEF" },
            { "ECV", "ECV" },
            { "ZMK", "ZMK" },
            { "LRD", "LRD" },
            { "pyg", "paraguajsk\u00e9 guarani" },
            { "jmd", "jamajsk\u00fd dolar" },
            { "GHC", "GHC" },
            { "MTL", "MTL" },
            { "ZMW", "ZMW" },
            { "MTP", "MTP" },
            { "ILP", "ILP" },
            { "ILR", "ILR" },
            { "ILS", "ILS" },
            { "veb", "venezuelsk\u00fd bol\u00edvar (1871\u20132008)" },
            { "GHS", "GHS" },
            { "KPW", "KPW" },
            { "ecs", "ekv\u00e1dorsk\u00fd sucre" },
            { "vef", "venezuelsk\u00fd bol\u00edvar" },
            { "ecv", "ekv\u00e1dorsk\u00e1 jednotka konstantn\u00ed hodnoty" },
            { "zmk", "zambijsk\u00e1 kwacha (1968\u20132012)" },
            { "JOD", "JOD" },
            { "lrd", "liberijsk\u00fd dolar" },
            { "ghc", "ghansk\u00fd cedi (1979\u20132007)" },
            { "LSL", "LSL" },
            { "mtl", "maltsk\u00e1 lira" },
            { "zmw", "zambijsk\u00e1 kwacha" },
            { "mtp", "maltsk\u00e1 libra" },
            { "EEK", "EEK" },
            { "MUR", "MUR" },
            { "ilp", "izraelsk\u00e1 libra" },
            { "ilr", "izraelsk\u00fd \u0161ekel (1980\u20131985)" },
            { "GIP", "GIP" },
            { "ils", "izraelsk\u00fd nov\u00fd \u0161ekel" },
            { "ghs", "ghansk\u00fd cedi" },
            { "kpw", "severokorejsk\u00fd won" },
            { "jod", "jord\u00e1nsk\u00fd din\u00e1r" },
            { "KRH", "KRH" },
            { "hkd", "hongkongsk\u00fd dolar" },
            { "lsl", "lesothsk\u00fd loti" },
            { "LTL", "LTL" },
            { "SAR", "SAR" },
            { "MVP", "MVP" },
            { "cad", "kanadsk\u00fd dolar" },
            { "MVR", "MVR" },
            { "KRO", "KRO" },
            { "eek", "estonsk\u00e1 koruna" },
            { "mur", "mauricijsk\u00e1 rupie" },
            { "DDM", "DDM" },
            { "INR", "INR" },
            { "LTT", "LTT" },
            { "gip", "gibraltarsk\u00e1 libra" },
            { "SBD", "SBD" },
            { "LUC", "LUC" },
            { "LUF", "LUF" },
            { "MWK", "MWK" },
            { "krh", "jihokorejsk\u00fd hwan (1953\u20131962)" },
            { "LUL", "LUL" },
            { "BAD", "BAD" },
            { "ltl", "litevsk\u00fd litas" },
            { "sar", "sa\u00fadsk\u00fd rij\u00e1l" },
            { "mvp", "maledivsk\u00e1 rupie (1947\u20131981)" },
            { "mvr", "maledivsk\u00e1 rupie" },
            { "kro", "jihokorejsk\u00fd won (1945\u20131953)" },
            { "FIM", "FIM" },
            { "ddm", "v\u00fdchodon\u011bmeck\u00e1 marka" },
            { "inr", "indick\u00e1 rupie" },
            { "DEM", "DEM" },
            { "ltt", "litevsk\u00fd talonas" },
            { "BAM", "BAM" },
            { "BAN", "BAN" },
            { "EGP", "EGP" },
            { "krw", "jihokorejsk\u00fd won" },
            { "jpy", "japonsk\u00fd jen" },
            { "sbd", "\u0161alamounsk\u00fd dolar" },
            { "luc", "lucembursk\u00fd konvertibiln\u00ed frank" },
            { "luf", "lucembursk\u00fd frank" },
        };
        return data;
    }
}
