/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_et extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ae = "avesta";
        final String metaValue_ar = "araabia";
        final String metaValue_bn = "bengali";
        final String metaValue_bo = "tiibeti";
        final String metaValue_el = "kreeka";
        final String metaValue_gu = "gud\u017earati";
        final String metaValue_he = "heebrea";
        final String metaValue_hy = "armeenia";
        final String metaValue_ja = "jaapani";
        final String metaValue_jv = "jaava";
        final String metaValue_ka = "gruusia";
        final String metaValue_km = "khmeeri";
        final String metaValue_kn = "kannada";
        final String metaValue_ko = "korea";
        final String metaValue_la = "ladina";
        final String metaValue_lo = "lao";
        final String metaValue_ml = "malajalami";
        final String metaValue_mn = "mongoli";
        final String metaValue_my = "birma";
        final String metaValue_or = "oria";
        final String metaValue_si = "singali";
        final String metaValue_su = "sunda";
        final String metaValue_ta = "tamili";
        final String metaValue_te = "telugu";
        final String metaValue_th = "tai";
        final String metaValue_tl = "tagalogi";
        final String metaValue_ban = "bali";
        final String metaValue_bbc = "bataki";
        final String metaValue_bug = "bugi";
        final String metaValue_chr = "t\u0161erokii";
        final String metaValue_cop = "kopti";
        final String metaValue_gez = "etioopia";
        final String metaValue_got = "gooti";
        final String metaValue_kpe = "kpelle";
        final String metaValue_men = "mende";
        final String metaValue_nqo = "nkoo";
        final String metaValue_peo = "vanap\u00e4rsia";
        final String metaValue_phn = "foiniikia";
        final String metaValue_sat = "santali";
        final String metaValue_saz = "saura\u0161tra";
        final String metaValue_syr = "s\u00fc\u00fcria";
        final String metaValue_uga = "ugariti";
        final String metaValue_vai = "vai";
        final String metaValue_zbl = "Blissi s\u00fcmbolid";
        final Object[][] data = new Object[][] {
            { "ksh", "k\u00f6lni" },
            { "Ogam", "ogam" },
            { "mwl", "miranda" },
            { "key.colStrength", "j\u00e4rjestuskaalud" },
            { "Zsym", "s\u00fcmbolid" },
            { "cch", "atsami" },
            { "mwr", "marvari" },
            { "egl", "emiilia" },
            { "mwv", "mentavei" },
            { "Tagb", "tagbanva" },
            { "%%NJIVA", "Gniva/Njiva murre" },
            { "xmf", "megreli" },
            { "egy", "egiptuse" },
            { "raj", "rad\u017eastani" },
            { "Phag", "phakpa" },
            { "tem", "temne" },
            { "teo", "teso" },
            { "rap", "rapanui" },
            { "ter", "tereno" },
            { "AC", "Ascensioni saar" },
            { "rar", "rarotonga" },
            { "tet", "tetumi" },
            { "AD", "Andorra" },
            { "AE", "Araabia \u00dchendemiraadid" },
            { "nl_BE", "flaami" },
            { "AF", "Afganistan" },
            { "AG", "Antigua ja Barbuda" },
            { "type.ca.ethiopic", "Etioopia kalender" },
            { "glk", "gilaki" },
            { "AI", "Anguilla" },
            { "key.tz", "ajav\u00f6\u00f6nd" },
            { "AL", "Albaania" },
            { "AM", "Armeenia" },
            { "Teng", "Tengwari" },
            { "AO", "Angola" },
            { "AQ", "Antarktis" },
            { "AR", "Argentina" },
            { "Prti", "partia raidkiri" },
            { "AS", "Ameerika Samoa" },
            { "AT", "Austria" },
            { "AU", "Austraalia" },
            { "AW", "Aruba" },
            { "en_US", "Ameerika inglise" },
            { "AX", "Ahvenamaa" },
            { "key.colNormalization", "normaliseeritud j\u00e4rjestus" },
            { "mye", "mjene" },
            { "AZ", "Aserbaid\u017eaan" },
            { "%%AREVELA", "idaarmeenia" },
            { "BA", "Bosnia ja Hertsegoviina" },
            { "BB", "Barbados" },
            { "ceb", "sebu" },
            { "BD", "Bangladesh" },
            { "kum", "kum\u00f5ki" },
            { "BE", "Belgia" },
            { "gmh", "kesk\u00fclemsaksa" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaaria" },
            { "BH", "Bahrein" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Saint Barth\u00e9lemy" },
            { "BM", "Bermuda" },
            { "kut", "kutenai" },
            { "myv", "ersa" },
            { "BN", "Brunei" },
            { "BO", "Boliivia" },
            { "BQ", "Hollandi Kariibi mere saared" },
            { "BR", "Brasiilia" },
            { "BS", "Bahama" },
            { "xog", "soga" },
            { "BT", "Bhutan" },
            { "BV", "Bouvet\u2019 saar" },
            { "BW", "Botswana" },
            { "BY", "Valgevene" },
            { "BZ", "Belize" },
            { "Visp", "n\u00e4htava k\u00f5ne" },
            { "type.ca.persian", "P\u00e4rsia kalender" },
            { "type.nu.hebr", "heebrea numbrid" },
            { "CA", "Kanada" },
            { "CC", "Kookossaared" },
            { "mzn", "mazandaraani" },
            { "CD", "Kongo DV" },
            { "CF", "Kesk-Aafrika Vabariik" },
            { "CG", "Kongo Vabariik" },
            { "CH", "\u0160veits" },
            { "CI", "C\u00f4te d\u2019Ivoire" },
            { "CK", "Cooki saared" },
            { "CL", "T\u0161iili" },
            { "Kthi", "kaithi" },
            { "CM", "Kamerun" },
            { "CN", "Hiina" },
            { "CO", "Colombia" },
            { "CP", "Clippertoni saar" },
            { "CR", "Costa Rica" },
            { "CU", "Kuuba" },
            { "CV", "Roheneemesaared" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "J\u00f5ulusaar" },
            { "CY", "K\u00fcpros" },
            { "type.nu.bali", "bali numbrid" },
            { "CZ", "T\u0161ehhi" },
            { "eka", "ekad\u017euki" },
            { "Ahom", "ahomi" },
            { "vls", "l\u00e4\u00e4neflaami" },
            { "DE", "Saksamaa" },
            { "goh", "vana\u00fclemsaksa" },
            { "ace", "at\u0161ehi" },
            { "cgg", "t\u0161iga" },
            { "DG", "Diego Garcia" },
            { "type.nu.deva", "devanaagari numbrid" },
            { "DJ", "Djibouti" },
            { "type.colNumeric.no", "j\u00e4rjesta numbrid eraldi" },
            { "DK", "Taani" },
            { "ach", "at\u0161oli" },
            { "gon", "gondi" },
            { "Brai", "punktkiri" },
            { "Brah", "braahmi" },
            { "DM", "Dominica" },
            { "type.nu.armnlow", "v\u00e4iket\u00e4helised armeenia numbrid" },
            { "DO", "Dominikaani Vabariik" },
            { "gor", "gorontalo" },
            { "got", metaValue_got },
            { "vmf", "Maini frangi" },
            { "Mtei", "meitei" },
            { "key.variableTop", "s\u00fcmbolite alusel j\u00e4rjestamine" },
            { "zun", "sunji" },
            { "tig", "tigree" },
            { "Takr", "taakri" },
            { "DZ", "Al\u017eeeria" },
            { "pag", "pangasinani" },
            { "pal", "pahlavi" },
            { "EA", "Ceuta ja Melilla" },
            { "chb", "t\u0161ibt\u0161a" },
            { "pam", "pampanga" },
            { "EC", "Ecuador" },
            { "pap", "papiamento" },
            { "ada", "adangme" },
            { "EE", "Eesti" },
            { "tiv", "tivi" },
            { "EG", "Egiptus" },
            { "EH", "L\u00e4\u00e4ne-Sahara" },
            { "chg", "t\u0161agatai" },
            { "pau", "belau" },
            { "type.colNormalization.yes", "j\u00e4rjesta Unicode\u2019i normaliseerimisega" },
            { "chk", "t\u0161uugi" },
            { "chn", "t\u0161inuki \u017eargoon" },
            { "chm", "mari" },
            { "chp", "t\u0161ipevai" },
            { "cho", "t\u0161okto" },
            { "chr", metaValue_chr },
            { "ER", "Eritrea" },
            { "ES", "Hispaania" },
            { "ET", "Etioopia" },
            { "EU", "Euroopa Liit" },
            { "elx", "eelami" },
            { "type.ca.gregorian", "Gregoriuse kalender" },
            { "chy", "\u0161aieeni" },
            { "type.nu.gujr", "gud\u017earati numbrid" },
            { "Inds", "Induse" },
            { "ady", "ad\u00f5gee" },
            { "aeb", "Tuneesia araabia" },
            { "FI", "Soome" },
            { "FJ", "Fid\u017ei" },
            { "FK", "Falklandi saared" },
            { "FM", "Mikroneesia" },
            { "key.va", "lokaadi variant" },
            { "FO", "F\u00e4\u00e4ri saared" },
            { "Taml", metaValue_ta },
            { "FR", "Prantsusmaa" },
            { "Kpel", metaValue_kpe },
            { "pcd", "pikardi" },
            { "tkl", "tokelau" },
            { "grb", "grebo" },
            { "root", "root" },
            { "type.ca.indian", "India rahvuslik kalender" },
            { "rgn", "romanja" },
            { "grc", "vanakreeka" },
            { "GA", "Gabon" },
            { "tkr", "tsahhi" },
            { "vot", "vadja" },
            { "GB", "Suurbritannia" },
            { "GD", "Grenada" },
            { "GE", "Gruusia" },
            { "GF", "Prantsuse Guajaana" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "Tale", "tai-l\u00f6\u00f6" },
            { "GI", "Gibraltar" },
            { "afh", "afrihili" },
            { "GL", "Gr\u00f6\u00f6nimaa" },
            { "enm", "keskinglise" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadeloupe" },
            { "GQ", "Ekvatoriaal-Guinea" },
            { "GR", "Kreeka" },
            { "GS", "L\u00f5una-Georgia ja L\u00f5una-Sandwichi saared" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "pdc", "Pennsylvania saksa" },
            { "GW", "Guinea-Bissau" },
            { "tli", "tlingiti" },
            { "tlh", "klingoni" },
            { "Talu", "uus tai-l\u00f5\u00f5" },
            { "GY", "Guyana" },
            { "ckb", "sorani" },
            { "zxx", "mittekeeleline" },
            { "Jurc", "t\u0161urt\u0161eni" },
            { "tly", "tal\u00f5\u0161i" },
            { "pdt", "mennoniidisaksa" },
            { "de_AT", "Austria saksa" },
            { "Vaii", metaValue_vai },
            { "HK", "Hongkongi erihalduspiirkond" },
            { "HM", "Heardi ja McDonaldi saared" },
            { "HN", "Honduras" },
            { "HR", "Horvaatia" },
            { "agq", "aghemi" },
            { "gsw", "\u0161veitsisaksa" },
            { "HT", "Haiti" },
            { "HU", "Ungari" },
            { "rif", "riifi" },
            { "tmh", "tama\u0161eki" },
            { "IC", "Kanaari saared" },
            { "nan", "l\u00f5unamini" },
            { "peo", metaValue_peo },
            { "ID", "Indoneesia" },
            { "type.nu.kali", "kaja-lii numbrid" },
            { "IE", "Iirimaa" },
            { "nap", "napoli" },
            { "naq", "nama" },
            { "type.nu.sora", "sora numbrid" },
            { "zza", "zaza" },
            { "Tang", "tanguudi" },
            { "IL", "Iisrael" },
            { "Nbat", "Nabatea" },
            { "IM", "Mani saar" },
            { "IN", "India" },
            { "type.co.eor", "Euroopa j\u00e4rjestusreeglid" },
            { "IO", "Briti India ookeani ala" },
            { "IQ", "Iraak" },
            { "IR", "Iraan" },
            { "IS", "Island" },
            { "IT", "Itaalia" },
            { "Zmth", "matemaatiline t\u00e4histus" },
            { "type.nu.thai", "tai numbrid" },
            { "vro", "v\u00f5ru" },
            { "guc", "vajuu" },
            { "%%POSIX", "arvuti" },
            { "type.nu.beng", "bengali numbrid" },
            { "pfl", "Pfalzi" },
            { "JE", "Jersey" },
            { "type.ca.islamic", "islamikalender" },
            { "Beng", metaValue_bn },
            { "JM", "Jamaica" },
            { "%%EKAVSK", "\u0161tokavi e-line murrak" },
            { "JO", "Jordaania" },
            { "gur", "farefare" },
            { "JP", "Jaapan" },
            { "%%1606NICT", "hiliskeskprantsuse (kuni 1606)" },
            { "ain", "ainu" },
            { "Mend", metaValue_men },
            { "guz", "gusii" },
            { "tog", "t\u0161itonga" },
            { "type.nu.knda", "kannada numbrid" },
            { "Kali", "kaja-lii" },
            { "Sidd", "siddhami" },
            { "de_CH", "\u0160veitsi \u00fclemsaksa" },
            { "type.co.phonetic", "foneetiline sortimisj\u00e4rjestus" },
            { "izh", "isuri" },
            { "type.ca.buddhist", "budistlik kalender" },
            { "KE", "Keenia" },
            { "419", "Ladina-Ameerika" },
            { "KG", "K\u00f5rg\u00f5zstan" },
            { "KH", "Kambod\u017ea" },
            { "KI", "Kiribati" },
            { "KM", "Komoorid" },
            { "Knda", metaValue_kn },
            { "KN", "Saint Kitts ja Nevis" },
            { "Zinh", "p\u00e4ritud" },
            { "fr_CA", "Kanada prantsuse" },
            { "KP", "P\u00f5hja-Korea" },
            { "KR", "L\u00f5una-Korea" },
            { "Plrd", "Pollardi miao" },
            { "fr_CH", "\u0160veitsi prantsuse" },
            { "KW", "Kuveit" },
            { "tpi", "uusmelaneesia" },
            { "KY", "Kaimanisaared" },
            { "KZ", "Kasahstan" },
            { "Cyrl", "kirillitsa" },
            { "LA", "Laos" },
            { "LB", "Liibanon" },
            { "phn", metaValue_phn },
            { "LC", "Saint Lucia" },
            { "Cyrs", "k\u00fcrilliline kirikuslaavi" },
            { "gwi", "gvit\u0161ini" },
            { "nds", "alamsaksa" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "akk", "akadi" },
            { "cop", metaValue_cop },
            { "LR", "Libeeria" },
            { "esu", "keskjupiki" },
            { "LS", "Lesotho" },
            { "Phlv", "pahlavi raamatukiri" },
            { "LT", "Leedu" },
            { "LU", "Luksemburg" },
            { "LV", "L\u00e4ti" },
            { "Kana", "katakana" },
            { "Sora", "sora" },
            { "LY", "Liib\u00fca" },
            { "lad", "ladiino" },
            { "vun", "vund\u017eo" },
            { "akz", "alabama" },
            { "lah", "lahnda" },
            { "Mahj", "mahaad\u017eani" },
            { "lag", "langi" },
            { "Thaa", "taana" },
            { "MA", "Maroko" },
            { "MC", "Monaco" },
            { "MD", "Moldova" },
            { "Nshu", "n\u00fc\u0161u" },
            { "ME", "Montenegro" },
            { "MF", "Saint-Martin" },
            { "lam", "lamba" },
            { "MG", "Madagaskar" },
            { "Thai", metaValue_th },
            { "MH", "Marshalli Saared" },
            { "ale", "aleuudi" },
            { "type.nu.vaii", "vai numbrid" },
            { "MK", "Makedoonia" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Birma)" },
            { "MN", "Mongoolia" },
            { "new", "nevari" },
            { "MO", "Macau erihalduspiirkond" },
            { "aln", "geegi" },
            { "MP", "P\u00f5hja-Mariaanid" },
            { "MQ", "Martinique" },
            { "MR", "Mauritaania" },
            { "MS", "Montserrat" },
            { "type.colAlternate.non-ignorable", "j\u00e4rjesta s\u00fcmbolid" },
            { "MT", "Malta" },
            { "cps", "kapisnoni" },
            { "MU", "Mauritius" },
            { "alt", "altai" },
            { "MV", "Maldiivid" },
            { "MW", "Malawi" },
            { "MX", "Mehhiko" },
            { "type.ca.japanese", "Jaapani kalender" },
            { "MY", "Malaisia" },
            { "MZ", "Mosambiik" },
            { "Phli", "pahlavi raidkiri" },
            { "NA", "Namiibia" },
            { "type.ca.hebrew", "juudi kalender" },
            { "type.co.dictionary", "s\u00f5nastiku sortimisj\u00e4rjestus" },
            { "NC", "Uus-Kaledoonia" },
            { "%%WADEGILE", "Wade\u2019i-Gilesi latinisatsioon" },
            { "tru", "turojo" },
            { "%%UCRCOR", "\u00fchtlustatud redigeeritud ortograafia" },
            { "NE", "Niger" },
            { "NF", "Norfolk" },
            { "NG", "Nigeeria" },
            { "trv", "taroko" },
            { "Phlp", "pahlavi psalmikiri" },
            { "NI", "Nicaragua" },
            { "Hmng", "phahau-hmongi kiri" },
            { "NL", "Holland" },
            { "NO", "Norra" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "tsd", "tsakoonia" },
            { "Phnx", metaValue_phn },
            { "NU", "Niue" },
            { "rof", "rombo" },
            { "tsi", "t\u0161im\u0161i" },
            { "NZ", "Uus-Meremaa" },
            { "Merc", "meroe kursiivkiri" },
            { "rom", "mustlaskeel" },
            { "Mero", "meroe" },
            { "crh", "krimmitatari" },
            { "type.colAlternate.shifted", "eira j\u00e4rjestuses s\u00fcmboleid" },
            { "ang", "vanainglise" },
            { "OM", "Omaan" },
            { "anp", "angika" },
            { "Xpeo", metaValue_peo },
            { "PA", "Panama" },
            { "type.ca.islamic-civil", "islami ilmalik kalender" },
            { "csb", "ka\u0161uubi" },
            { "en_GB", "Briti inglise" },
            { "PE", "Peruu" },
            { "ttt", "l\u00f5unataadi" },
            { "PF", "Prantsuse Pol\u00fcneesia" },
            { "PG", "Paapua Uus-Guinea" },
            { "PH", "Filipiinid" },
            { "PK", "Pakistan" },
            { "PL", "Poola" },
            { "ewo", "evondo" },
            { "PM", "Saint Pierre ja Miquelon" },
            { "PN", "Pitcairni saared" },
            { "type.colBackwards.yes", "diakriitikud p\u00f6\u00f6rdj\u00e4rjestuses" },
            { "PR", "Puerto Rico" },
            { "Bali", metaValue_ban },
            { "PS", "Palestiina alad" },
            { "PT", "Portugal" },
            { "PW", "Belau" },
            { "nia", "niasi" },
            { "type.nu.greklow", "v\u00e4iket\u00e4helised kreeka numbrid" },
            { "PY", "Paraguay" },
            { "tum", "tumbuka" },
            { "Hebr", metaValue_he },
            { "QA", "Katar" },
            { "%%SCOTLAND", "\u0161oti tavainglise" },
            { "jam", "Jamaica kreoolkeel" },
            { "pms", "piemonte" },
            { "niu", "niue" },
            { "QO", "Okeaania hajasaared" },
            { "ext", "estremenju" },
            { "lez", "lesgi" },
            { "%%FONUPA", "UPA foneetika" },
            { "type.nu.takr", "taakri numbrid" },
            { "tvl", "tuvalu" },
            { "Tavt", "tai-vieti" },
            { "001", "maailm" },
            { "002", "Aafrika" },
            { "njo", "ao" },
            { "003", "P\u00f5hja-Ameerika" },
            { "RE", "R\u00e9union" },
            { "type.colNormalization.no", "j\u00e4rjesta normaliseerimata" },
            { "005", "L\u00f5una-Ameerika" },
            { "jbo", "lo\u017eban" },
            { "pnt", "pontose" },
            { "Rjng", "red\u017eangi" },
            { "009", "Okeaania" },
            { "RO", "Rumeenia" },
            { "RS", "Serbia" },
            { "Mroo", "mruu" },
            { "RU", "Venemaa" },
            { "RW", "Rwanda" },
            { "type.nu.talu", "uue tai-l\u00f5\u00f5 numbrid" },
            { "Ugar", metaValue_uga },
            { "Mani", "mani" },
            { "key.colAlternate", "s\u00fcmbolite eiramine j\u00e4rjestuses" },
            { "Khar", "kharoshthi" },
            { "SA", "Saudi Araabia" },
            { "pon", "poonpei" },
            { "Mand", "mandea" },
            { "SB", "Saalomoni Saared" },
            { "twq", "taswaqi" },
            { "011", "L\u00e4\u00e4ne-Aafrika" },
            { "SC", "Sei\u0161ellid" },
            { "SD", "Sudaan" },
            { "013", "Kesk-Ameerika" },
            { "SE", "Rootsi" },
            { "014", "Ida-Aafrika" },
            { "arc", "aramea" },
            { "Loma", "loma" },
            { "015", "P\u00f5hja-Aafrika" },
            { "SG", "Singapur" },
            { "SH", "Saint Helena" },
            { "type.lb.strict", "j\u00e4ik reavahetuse laad" },
            { "017", "Kesk-Aafrika" },
            { "SI", "Sloveenia" },
            { "018", "L\u00f5una-Aafrika" },
            { "SJ", "Svalbard ja Jan Mayen" },
            { "019", "Ameerika" },
            { "SK", "Slovakkia" },
            { "Bamu", "bamumi" },
            { "Wole", "voleai" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somaalia" },
            { "arn", "mapudunguni" },
            { "arp", "arapaho" },
            { "type.nu.taml", "traditsioonilised tamili numbrid" },
            { "SR", "Suriname" },
            { "aro", "araona" },
            { "SS", "L\u00f5una-Sudaan" },
            { "ST", "S\u00e3o Tom\u00e9 ja Pr\u00edncipe" },
            { "arq", "Al\u017eeeria araabia" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "S\u00fc\u00fcria" },
            { "yao", "jao" },
            { "SZ", "Svaasimaa" },
            { "arw", "aravaki" },
            { "arz", "Egiptuse araabia" },
            { "ary", "Maroko araabia" },
            { "yap", "japi" },
            { "rtm", "rotuma" },
            { "TA", "Tristan da Cunha" },
            { "asa", "asu" },
            { "type.ms.ussystem", "USA m\u00f5\u00f5dustik" },
            { "021", "Ameerika p\u00f5hjaosa" },
            { "TC", "Turks ja Caicos" },
            { "yav", "yangbeni" },
            { "TD", "T\u0161aad" },
            { "TF", "Prantsuse L\u00f5unaalad" },
            { "ase", "Ameerika viipekeel" },
            { "TG", "Togo" },
            { "TH", "Tai" },
            { "TJ", "Tad\u017eikistan" },
            { "029", "Kariibi piirkond" },
            { "TK", "Tokelau" },
            { "TL", "Ida-Timor" },
            { "ybb", "jemba" },
            { "type.co.searchjl", "otsing korea alguskonsonandi j\u00e4rgi" },
            { "TM", "T\u00fcrkmenistan" },
            { "%%BOONT", "boontlingi" },
            { "TN", "Tuneesia" },
            { "TO", "Tonga" },
            { "TR", "T\u00fcrgi" },
            { "TT", "Trinidad ja Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "ast", "astuuria" },
            { "rue", "russiini" },
            { "rug", "roviana" },
            { "Orkh", "Orhoni" },
            { "TZ", "Tansaania" },
            { "nmg", "kwasio" },
            { "Zzzz", "m\u00e4\u00e4ramata kiri" },
            { "Sind", "hudavadi" },
            { "UA", "Ukraina" },
            { "lij", "liguuri" },
            { "rup", "aromuuni" },
            { "030", "Ida-Aasia" },
            { "tyv", "t\u00f5va" },
            { "sw_CD", "Kongo suahiili" },
            { "034", "L\u00f5una-Aasia" },
            { "hai", "haida" },
            { "035", "Kagu-Aasia" },
            { "UG", "Uganda" },
            { "type.co.pinyin", "pinyin\u2019i sortimisj\u00e4rjestus" },
            { "type.colHiraganaQuaternary.yes", "j\u00e4rjesta kana erinevalt" },
            { "039", "L\u00f5una-Euroopa" },
            { "Sinh", metaValue_si },
            { "UM", "\u00dchendriikide hajasaared" },
            { "liv", "liivi" },
            { "US", "Ameerika \u00dchendriigid" },
            { "haw", "havai" },
            { "%%1959ACAD", "akadeemiline" },
            { "type.co.gb2312han", "hiina lihtsustatud sortimisj\u00e4rjestus (GB2312)" },
            { "UY", "Uruguay" },
            { "prg", "preisi" },
            { "UZ", "Usbekistan" },
            { "tzm", "tamasikti" },
            { "type.co.stroke", "kriipsude sortimisj\u00e4rjestus" },
            { "nnh", "ngiembooni" },
            { "VA", "Vatikan" },
            { "pro", "vanaprovansi" },
            { "VC", "Saint Vincent ja Grenadiinid" },
            { "VE", "Venezuela" },
            { "VG", "Briti Neitsisaared" },
            { "VI", "USA Neitsisaared" },
            { "VN", "Vietnam" },
            { "type.colBackwards.no", "diakriitikud tavaj\u00e4rjestuses" },
            { "VU", "Vanuatu" },
            { "nog", "nogai" },
            { "rwk", "rvaa" },
            { "non", "vanap\u00f5hjala" },
            { "053", "Australaasia" },
            { "%%AREVMDA", "l\u00e4\u00e4nearmeenia" },
            { "054", "Melaneesia" },
            { "WF", "Wallis ja Futuna" },
            { "type.co.traditional", "traditsiooniline sortimisj\u00e4rjestus" },
            { "057", "Mikroneesia (piirkond)" },
            { "jgo", "ngomba" },
            { "lkt", "lakota" },
            { "nov", "noviaal" },
            { "type.nu.finance", "finantsnumbrid" },
            { "%%HEPBURN", "Hepburni latinisatsioon" },
            { "type.co.compat", "varasem sortimisj\u00e4rjestus (\u00fchilduvuse jaoks)" },
            { "wae", "walseri" },
            { "WS", "Samoa" },
            { "Bass", "bassa" },
            { "type.nu.mtei", "meitei numbrid" },
            { "wal", "volaita" },
            { "was", "va\u0161o" },
            { "war", "varai" },
            { "awa", "avadhi" },
            { "061", "Pol\u00fcneesia" },
            { "%%KSCOR", "normitud kirjaviis" },
            { "XK", "Kosovo" },
            { "type.nu.brah", "braahmi numbrid" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "kirjakeeleta" },
            { "Olck", metaValue_sat },
            { "wbp", "varlpiri" },
            { "Batk", metaValue_bbc },
            { "Blis", metaValue_zbl },
            { "YE", "Jeemen" },
            { "nqo", metaValue_nqo },
            { "type.co.standard", "standardne sortimisj\u00e4rjestus" },
            { "lmo", "lombardi" },
            { "fan", "fangi" },
            { "%%ROZAJ", "Resia murre" },
            { "fat", "fanti" },
            { "Sgnw", "viipekiri" },
            { "YT", "Mayotte" },
            { "type.nu.cham", "t\u0161aami numbrid" },
            { "ZA", "L\u00f5una-Aafrika Vabariik" },
            { "type.nu.sund", "sunda numbrid" },
            { "type.lb.loose", "paindlik reavahetuse laad" },
            { "Deva", "devanaagari" },
            { "type.nu.geor", "gruusia numbrid" },
            { "type.co.zhuyin", "zhuyin\u2019i sortimisj\u00e4rjestus" },
            { "Hira", "hiragana" },
            { "ZM", "Sambia" },
            { "%%PINYIN", "pinyin" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "Tundmatu piirkond" },
            { "Runr", "ruunikiri" },
            { "type.ms.metric", "meeterm\u00f5\u00f5dustik" },
            { "type.ca.iso8601", "ISO-8601 kalender" },
            { "lol", "mongo" },
            { "nso", "pedi" },
            { "type.nu.telu", "telugu numbrid" },
            { "loz", "lozi" },
            { "Nkgb", "nasi" },
            { "type.colHiraganaQuaternary.no", "j\u00e4rjesta kana eraldi" },
            { "jmc", "mat\u0161ame" },
            { "hif", "Fid\u017ei hindi" },
            { "type.nu.hansfin", "lihtsustatud hiina keele finantsnumbrid" },
            { "type.colStrength.secondary", "j\u00e4rjesta diakriitikud" },
            { "hil", "hiligainoni" },
            { "type.nu.arabext", "laiendatud idaaraabia numbrid" },
            { "nus", "nueri" },
            { "dak", "siuu" },
            { "type.nu.fullwide", "t\u00e4islaiusega numbrid" },
            { "hit", "heti" },
            { "dar", "dargi" },
            { "dav", "davida" },
            { "Maya", "maaja hierogl\u00fc\u00fcfkiri" },
            { "lrc", "p\u00f5hjaluri" },
            { "type.co.emoji", "emoji sortimisj\u00e4rjestus" },
            { "Copt", metaValue_cop },
            { "nwc", "vananevari" },
            { "udm", "udmurdi" },
            { "Khmr", metaValue_km },
            { "Limb", "limbu" },
            { "sad", "sandave" },
            { "type.nu.roman", "Rooma numbrid" },
            { "sah", "jakuudi" },
            { "type.nu.shrd", "\u0161aarada numbrid" },
            { "ltg", "latgali" },
            { "sam", "Samaaria aramea" },
            { "Aghb", "albaani" },
            { "%%SCOUSE", "scouse" },
            { "saq", "samburu" },
            { "sas", "sasaki" },
            { "sat", metaValue_sat },
            { "Tfng", "tifinagi" },
            { "saz", metaValue_saz },
            { "jpr", "juudip\u00e4rsia" },
            { "type.nu.native", "kohalikud numbrid" },
            { "sba", "ngambai" },
            { "Guru", "gurmukhi" },
            { "lua", "lulua" },
            { "sbp", "sangu" },
            { "lui", "luisenjo" },
            { "nyn", "nkole" },
            { "nym", "njamvesi" },
            { "lun", "lunda" },
            { "nyo", "njoro" },
            { "luo", "luo" },
            { "fil", "filipiini" },
            { "hmn", "hmongi" },
            { "del", "delavari" },
            { "lus", "lu\u0161ei" },
            { "bal", "belut\u0161i" },
            { "den", "sleivi" },
            { "ban", metaValue_ban },
            { "uga", metaValue_uga },
            { "fit", "me\u00e4" },
            { "luy", "luhja" },
            { "bar", "baieri" },
            { "bas", "basa" },
            { "bax", "bamuni" },
            { "jrb", "juudiaraabia" },
            { "es_ES", "Euroopa hispaania" },
            { "nzi", "nzima" },
            { "sco", "\u0161oti" },
            { "scn", "sitsiilia" },
            { "aa", "afari" },
            { "ab", "abhaasi" },
            { "bbc", metaValue_bbc },
            { "key.colCaseFirst", "suur- ja v\u00e4iket\u00e4he j\u00e4rjestus" },
            { "ae", metaValue_ae },
            { "af", "afrikaani" },
            { "ak", "akani" },
            { "type.nu.cakm", "t\u0161aakma numbrid" },
            { "bbj", "ghomala" },
            { "am", "amhari" },
            { "Arab", metaValue_ar },
            { "an", "aragoni" },
            { "%%SOLBA", "Stolvizza/Solbica murre" },
            { "Jpan", metaValue_ja },
            { "ar", metaValue_ar },
            { "Hrkt", "jaapani silpkirjad" },
            { "as", "assami" },
            { "Lina", "lineaarkiri A" },
            { "av", "avaari" },
            { "Linb", "lineaarkiri B" },
            { "sdh", "l\u00f5unakurdi" },
            { "ay", "aimara" },
            { "az", "aserbaid\u017eaani" },
            { "Khoj", "hod\u017eki" },
            { "%%OSOJS", "Oseacco/Osojane murre" },
            { "ba", "ba\u0161kiiri" },
            { "type.co.unihan", "v\u00f5tmete-kriipsude sortimisj\u00e4rjestus" },
            { "be", "valgevene" },
            { "bg", "bulgaaria" },
            { "bi", "bislama" },
            { "type.nu.java", "jaava numbrid" },
            { "bm", "bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "dgr", "dogribi" },
            { "br", "bretooni" },
            { "bs", "bosnia" },
            { "see", "seneka" },
            { "Mymr", metaValue_my },
            { "sei", "seri" },
            { "type.nu.laoo", "lao numbrid" },
            { "seh", "sena" },
            { "Nkoo", metaValue_nqo },
            { "sel", "s\u00f6lkupi" },
            { "ca", "katalaani" },
            { "ses", "koyraboro senni" },
            { "ce", "t\u0161et\u0161eeni" },
            { "ch", "t\u0161amorro" },
            { "%%REVISED", "uus kirjaviis" },
            { "co", "korsika" },
            { "Orya", metaValue_or },
            { "cr", "krii" },
            { "cs", "t\u0161ehhi" },
            { "cu", "kirikuslaavi" },
            { "yrl", "njengatu" },
            { "cv", "t\u0161uva\u0161i" },
            { "cy", "k\u00f5mri" },
            { "type.nu.ethi", "etioopia numbrid" },
            { "Yiii", "jii" },
            { "da", "taani" },
            { "pt_PT", "Euroopa portugali" },
            { "de", "saksa" },
            { "bej", "bed\u017ea" },
            { "din", "dinka" },
            { "jut", "j\u00fc\u00fcti" },
            { "Bugi", metaValue_bug },
            { "bem", "bemba" },
            { "sga", "vanaiiri" },
            { "type.nu.mong", "mongoli numbrid" },
            { "dv", "maldiivi" },
            { "es_419", "Ladina-Ameerika hispaania" },
            { "bew", "betavi" },
            { "dz", "dzongkha" },
            { "bez", "bena" },
            { "type.ca.chinese", "Hiina kalender" },
            { "lzh", "klassikaline hiina" },
            { "Lisu", "lisu" },
            { "dje", "zarma" },
            { "sgs", "\u017eemaidi" },
            { "type.nu.grek", "kreeka numbrid" },
            { "ee", "eve" },
            { "bfd", "bafuti" },
            { "type.lb.normal", "harilik reavahetuse laad" },
            { "ro_MD", "moldova" },
            { "el", metaValue_el },
            { "en", "inglise" },
            { "eo", "esperanto" },
            { "bfq", "badaga" },
            { "lzz", "lazi" },
            { "type.co.big5han", "hiina traditsiooniline sortimisj\u00e4rjestus (Big5)" },
            { "es", "hispaania" },
            { "et", "eesti" },
            { "Hang", metaValue_ko },
            { "eu", "baski" },
            { "Buhd", "buhidi" },
            { "Samr", "Samaaria" },
            { "shi", "\u0161ilha" },
            { "hsb", "\u00fclemsorbi" },
            { "Hani", "hani" },
            { "shn", "\u0161ani" },
            { "Hano", "hanunoo" },
            { "fa", "p\u00e4rsia" },
            { "Hans", "hiina lihtsustatud" },
            { "type.nu.latn", "araabia numbrid" },
            { "Hant", "hiina traditsiooniline" },
            { "ff", "fula" },
            { "shu", "T\u0161aadi araabia" },
            { "hsn", "sjangi" },
            { "fi", "soome" },
            { "fj", "fid\u017ei" },
            { "fon", "foni" },
            { "bgn", "l\u00e4\u00e4nebelut\u0161i" },
            { "yue", "kantoni" },
            { "fo", "f\u00e4\u00e4ri" },
            { "umb", "umbundu" },
            { "fr", "prantsuse" },
            { "sid", "sidamo" },
            { "fy", "l\u00e4\u00e4nefriisi" },
            { "ga", "iiri" },
            { "gd", "gaeli" },
            { "key.colCaseLevel", "j\u00e4rjestuse t\u00f5stutundlikkus" },
            { "gl", "galeegi" },
            { "gn", "guaranii" },
            { "bho", "bhod\u017epuri" },
            { "und", "m\u00e4\u00e4ramata keel" },
            { "type.ca.ethiopic-amete-alem", "Etioopia amete alemi kalender" },
            { "gu", metaValue_gu },
            { "gv", "m\u00e4nksi" },
            { "type.nu.osma", "osmani numbrid" },
            { "ha", "hausa" },
            { "he", metaValue_he },
            { "hi", "hindi" },
            { "hup", "hupa" },
            { "bik", "bikoli" },
            { "bin", "edo" },
            { "ho", "hirimotu" },
            { "hr", "horvaadi" },
            { "ht", "haiti" },
            { "hu", "ungari" },
            { "hy", metaValue_hy },
            { "hz", "herero" },
            { "frc", "cajun\u2019i" },
            { "%%FONIPA", "IPA foneetika" },
            { "ia", "interlingua" },
            { "id", "indoneesia" },
            { "type.nu.tibt", "tiibeti numbrid" },
            { "ie", "interlingue" },
            { "ig", "ibo" },
            { "ii", "Sichuani jii" },
            { "frm", "keskprantsuse" },
            { "ik", "injupiaki" },
            { "fro", "vanaprantsuse" },
            { "frp", "frankoprovansi" },
            { "io", "ido" },
            { "frs", "idafriisi" },
            { "bjn", "band\u017eari" },
            { "frr", "p\u00f5hjafriisi" },
            { "is", "islandi" },
            { "it", "itaalia" },
            { "iu", "inuktituti" },
            { "sli", "alamsileesia" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "Sarb", "L\u00f5una-Araabia" },
            { "Sara", "sarati" },
            { "doi", "dogri" },
            { "sly", "selajari" },
            { "type.nu.lepc", "lept\u0161a numbrid" },
            { "bkm", "komi (Aafrika)" },
            { "sma", "l\u00f5unasaami" },
            { "jv", metaValue_jv },
            { "Shaw", "Shaw\u2019 kiri" },
            { "mad", "madura" },
            { "smj", "Lule saami" },
            { "mag", "magahi" },
            { "maf", "mafa" },
            { "mai", "maithili" },
            { "smn", "Inari saami" },
            { "ka", metaValue_ka },
            { "bla", "mustjalaindiaani" },
            { "mak", "makassari" },
            { "wuu", "uu" },
            { "sms", "koltasaami" },
            { "man", "malinke" },
            { "kg", "kongo" },
            { "Goth", metaValue_got },
            { "ki", "kikuju" },
            { "mas", "masai" },
            { "kj", "kvanjama" },
            { "kk", "kasahhi" },
            { "kl", "gr\u00f6\u00f6ni" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "type.colStrength.identical", "j\u00e4rjesta k\u00f5ik" },
            { "ko", metaValue_ko },
            { "kr", "kanuri" },
            { "ks", "ka\u0161miiri" },
            { "Cirt", "Cirthi" },
            { "Lepc", "lept\u0161a" },
            { "Avst", metaValue_ae },
            { "ku", "kurdi" },
            { "kv", "komi" },
            { "kw", "korni" },
            { "ky", "kirgiisi" },
            { "snk", "soninke" },
            { "type.colStrength.primary", "j\u00e4rjesta ainult alust\u00e4hed" },
            { "Mult", "Multani" },
            { "la", metaValue_la },
            { "Hatr", "Hatra" },
            { "lb", "letseburgi" },
            { "type.nu.mlym", "malajalami numbrid" },
            { "lg", "ganda" },
            { "Roro", "rongorongo" },
            { "li", "limburgi" },
            { "Tibt", metaValue_bo },
            { "ln", "lingala" },
            { "fur", "friuuli" },
            { "type.colCaseLevel.no", "t\u00f5stutundetu j\u00e4rjestus" },
            { "lo", metaValue_lo },
            { "type.ms.uksystem", "inglise m\u00f5\u00f5dustik" },
            { "type.colStrength.tertiary", "j\u00e4rjesta diakriitikud, algust\u00e4hed ja laius" },
            { "lt", "leedu" },
            { "lu", "luba" },
            { "lv", "l\u00e4ti" },
            { "sog", "sogdi" },
            { "mg", "malagassi" },
            { "mh", "mar\u0161alli" },
            { "type.co.ducet", "Unicode\u2019i sortimise vaikej\u00e4rjestus" },
            { "mi", "maoori" },
            { "mk", "makedoonia" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "marathi" },
            { "ms", "malai" },
            { "mt", "malta" },
            { "my", metaValue_my },
            { "Saur", metaValue_saz },
            { "Armn", metaValue_hy },
            { "mdf", "mok\u0161a" },
            { "mde", "maba" },
            { "dsb", "alamsorbi" },
            { "Armi", "vanaaramea" },
            { "na", "nauru" },
            { "type.co.search", "\u00fcldeesm\u00e4rgiline otsing" },
            { "nb", "norra bokm\u00e5l" },
            { "nd", "p\u00f5hjandebele" },
            { "ne", "nepali" },
            { "ng", "ndonga" },
            { "mdr", "mandari" },
            { "nl", "hollandi" },
            { "nn", "uusnorra" },
            { "no", "norra" },
            { "nr", "l\u00f5unandebele" },
            { "nv", "navaho" },
            { "kaa", "karakalpaki" },
            { "ny", "njand\u017ea" },
            { "kac", "kat\u0161ini" },
            { "kab", "kabiili" },
            { "%%POLYTON", "pol\u00fctooniline" },
            { "type.colCaseFirst.lower", "v\u00e4iket\u00e4ht j\u00e4rjestuses eespool" },
            { "oc", "provansi" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "men", metaValue_men },
            { "oj", "od\u017eibvei" },
            { "mer", "meru" },
            { "type.nu.armn", "armeenia numbrid" },
            { "om", "oromo" },
            { "kaw", "kaavi" },
            { "dtp", "keskdusuni" },
            { "or", metaValue_or },
            { "Modi", "modi" },
            { "os", "osseedi" },
            { "%%ALALC97", "ALA-LC latinisatsioon (1997)" },
            { "bpy", "bi\u0161nuprija" },
            { "kbd", "kabardi-t\u0161erkessi" },
            { "mfe", "Mauritiuse kreoolkeel" },
            { "srn", "sranani" },
            { "pa", "pand\u017eabi" },
            { "dua", "duala" },
            { "srr", "sereri" },
            { "%%LIPAW", "Resia Lipovaz\u2019i murre" },
            { "kbl", "kanembu" },
            { "pi", "paali" },
            { "bqi", "bahtiari" },
            { "pl", "poola" },
            { "dum", "keskhollandi" },
            { "type.nu.saur", "saura\u0161tra numbrid" },
            { "type.ca.dangi", "dangi kalender" },
            { "ps", "pu\u0161tu" },
            { "pt", "portugali" },
            { "mga", "keskiiri" },
            { "key.co", "sortimisj\u00e4rjestus" },
            { "pt_BR", "Brasiilia portugali" },
            { "kcg", "tjapi" },
            { "mgh", "makhuwa-meetto" },
            { "type.nu.nkoo", "nkoo numbrid" },
            { "bra", "brad\u017ei" },
            { "key.ca", "kalender" },
            { "Laoo", metaValue_lo },
            { "mgo", "meta" },
            { "type.hc.h23", "24-tunnine s\u00fcsteem (0\u201323)" },
            { "type.hc.h24", "24-tunnine s\u00fcsteem (1\u201324)" },
            { "ssy", "saho" },
            { "brh", "brahui" },
            { "type.nu.mymr", "birma numbrid" },
            { "qu", "ket\u0161ua" },
            { "zap", "sapoteegi" },
            { "brx", "bodo" },
            { "Lana", "tai-thami" },
            { "kde", "makonde" },
            { "Ethi", metaValue_gez },
            { "stq", "saterfriisi" },
            { "type.hc.h12", "12-tunnine s\u00fcsteem (1\u201312)" },
            { "type.hc.h11", "12-tunnine s\u00fcsteem (0\u201311)" },
            { "rm", "roman\u0161i" },
            { "rn", "rundi" },
            { "key.cu", "v\u00e4\u00e4ring" },
            { "ro", "rumeenia" },
            { "%%SAAHO", "saho murre" },
            { "type.nu.orya", "oria numbrid" },
            { "type.nu.hanidec", "hiina k\u00fcmnendnumbrid" },
            { "ru", "vene" },
            { "bss", "akoose" },
            { "zbl", metaValue_zbl },
            { "rw", "ruanda" },
            { "kea", "kabuverdianu" },
            { "mic", "mikmaki" },
            { "suk", "sukuma" },
            { "en_AU", "Austraalia inglise" },
            { "Dupl", "Duploy\u00e9 kiirkiri" },
            { "sa", "sanskriti" },
            { "%%UCCOR", "\u00fchtlustatud ortograafia" },
            { "sc", "sardi" },
            { "sus", "susu" },
            { "sd", "sindhi" },
            { "se", "p\u00f5hjasaami" },
            { "min", "minangkabau" },
            { "sg", "sango" },
            { "sh", "serbia-horvaadi" },
            { "si", metaValue_si },
            { "sux", "sumeri" },
            { "sk", "slovaki" },
            { "sl", "sloveeni" },
            { "Gran", "grantha" },
            { "sm", "samoa" },
            { "sn", "\u0161ona" },
            { "so", "somaali" },
            { "type.nu.arab", "idaaraabia numbrid" },
            { "sq", "albaania" },
            { "sr", "serbia" },
            { "ss", "svaasi" },
            { "Java", metaValue_jv },
            { "st", "l\u00f5unasotho" },
            { "su", metaValue_su },
            { "%%NEDIS", "Natisone murre" },
            { "sv", "rootsi" },
            { "sw", "suahiili" },
            { "type.nu.hantfin", "traditsioonilise hiina keele finantsnumbrid" },
            { "ibb", "ibibio" },
            { "iba", "ibani" },
            { "ta", metaValue_ta },
            { "142", "Aasia" },
            { "bua", "burjaadi" },
            { "143", "Kesk-Aasia" },
            { "te", metaValue_te },
            { "145", "L\u00e4\u00e4ne-Aasia" },
            { "tg", "tad\u017eiki" },
            { "th", metaValue_th },
            { "bug", metaValue_bug },
            { "ti", "tigrinja" },
            { "kfo", "koro" },
            { "type.colNumeric.yes", "j\u00e4rjesta numbrid arvuliselt" },
            { "en_CA", "Kanada inglise" },
            { "tk", "t\u00fcrkmeeni" },
            { "tl", metaValue_tl },
            { "tn", "tsvana" },
            { "to", "tonga" },
            { "bum", "bulu" },
            { "dyo", "fonji" },
            { "type.nu.jpan", "jaapani numbrid" },
            { "tr", "t\u00fcrgi" },
            { "ts", "tsonga" },
            { "swb", "komoori" },
            { "Cakm", "t\u0161aakma" },
            { "tt", "tatari" },
            { "dyu", "djula" },
            { "tw", "tvii" },
            { "ty", "tahiti" },
            { "%%BISKE", "San Giorgio/Bila murre" },
            { "150", "Euroopa" },
            { "key.colHiraganaQuaternary", "kana kirja j\u00e4rjestus" },
            { "151", "Ida-Euroopa" },
            { "154", "P\u00f5hja-Euroopa" },
            { "dzg", "daza" },
            { "155", "L\u00e4\u00e4ne-Euroopa" },
            { "ug", "uiguuri" },
            { "Ital", "vanaitali" },
            { "Kore", "korea segakiri" },
            { "kgp", "kaingangi" },
            { "Zyyy", "\u00fcldine" },
            { "uk", "ukraina" },
            { "zea", "zeelandi" },
            { "type.colCaseFirst.no", "harilik j\u00e4rjestus" },
            { "type.colStrength.quaternary", "j\u00e4rjesta diakriitikud, algust\u00e4hed, laius ja kana kiri" },
            { "type.ca.coptic", "kopti kalender" },
            { "ur", "urdu" },
            { "%%1994", "normitud Resia kirjaviis" },
            { "xal", "kalm\u00f5ki" },
            { "zen", "zenaga" },
            { "uz", "usbeki" },
            { "kha", "khasi" },
            { "%%1996", "saksa reformitud kirjaviis" },
            { "nds_NL", "Hollandi alamsaksa" },
            { "Sylo", "siloti" },
            { "ve", "venda" },
            { "Wara", "hoo" },
            { "type.ca.roc", "Hiina Vabariigi kalender" },
            { "vi", "vietnami" },
            { "kho", "saka" },
            { "khq", "koyra chiini" },
            { "key.hc", "12 v\u00f5i 24 tunni s\u00fcsteem" },
            { "%%TARASK", "Taraskievica ortograafia" },
            { "vo", "volap\u00fcki" },
            { "key.x", "erakasutus" },
            { "khw", "khovari" },
            { "syc", "vanas\u00fc\u00fcria" },
            { "Osma", "osmani" },
            { "quc", "kit\u0161e" },
            { "gaa", "gaa" },
            { "wa", "vallooni" },
            { "gag", "gagauusi" },
            { "syr", metaValue_syr },
            { "Grek", metaValue_el },
            { "gan", "kani" },
            { "kiu", "k\u00f5rmand\u017eki" },
            { "Lydi", "l\u00fc\u00fcdia" },
            { "Xsux", "sumeri-akadi kiilkiri" },
            { "wo", "volofi" },
            { "zgh", "tamasikti (Maroko)" },
            { "ar_001", "araabia (t\u00e4nap\u00e4evane)" },
            { "Cans", "Kanada p\u00f5lisrahvaste \u00fchtlustatud silpkiri" },
            { "gay", "gajo" },
            { "key.colNumeric", "numbrite j\u00e4rjestus" },
            { "Mong", metaValue_mn },
            { "mnc", "mand\u017eu" },
            { "Latf", "ladina fraktuurkiri" },
            { "szl", "sileesia" },
            { "Hluw", "Anatoolia hierogl\u00fc\u00fcfkiri" },
            { "gba", "gbaja" },
            { "mni", "manipuri" },
            { "Latn", metaValue_la },
            { "Latg", "ladina gaeli" },
            { "type.nu.hans", "lihtsustatud hiina keele numbrid" },
            { "type.nu.hant", "traditsioonilise hiina keele numbrid" },
            { "xh", "koosa" },
            { "type.nu.romanlow", "v\u00e4iket\u00e4helised Rooma numbrid" },
            { "byn", "bilini" },
            { "Lyci", "l\u00fc\u00fckia" },
            { "osa", "oseid\u017ei" },
            { "byv", "medumba" },
            { "Moon", "Mooni" },
            { "moh", "mohoogi" },
            { "kkj", "kako" },
            { "%%1694ACAD", "varajane moodne prantsuse" },
            { "Syrc", metaValue_syr },
            { "yi", "jidi\u0161i" },
            { "mos", "more" },
            { "Dsrt", "desereti" },
            { "yo", "joruba" },
            { "type.nu.traditional", "traditsioonilised numbrid" },
            { "es_MX", "Mehhiko hispaania" },
            { "Syrj", "l\u00e4\u00e4nes\u00fc\u00fcria" },
            { "ota", "osmanit\u00fcrgi" },
            { "Syre", "s\u00fc\u00fcria estrangelo" },
            { "vai", metaValue_vai },
            { "za", "t\u0161uangi" },
            { "Cari", "kaaria" },
            { "kln", "kalend\u017eini" },
            { "zh", "hiina" },
            { "Afak", "afaka" },
            { "Bopo", "bopomofo" },
            { "Perm", "vanapermi" },
            { "key.lb", "reavahetuse laad" },
            { "zu", "suulu" },
            { "type.co.phonebook", "telefoniraamatu sortimisj\u00e4rjestus" },
            { "%%MONOTON", "monotoonne" },
            { "Geor", metaValue_ka },
            { "Shrd", "\u0161aarada" },
            { "kmb", "mbundu" },
            { "type.colCaseLevel.yes", "t\u00f5stutundlik j\u00e4rjestus" },
            { "type.nu.jpanfin", "jaapani finantsnumbrid" },
            { "Cham", "t\u0161aami" },
            { "gez", metaValue_gez },
            { "mrj", "m\u00e4emari" },
            { "Syrn", "idas\u00fc\u00fcria" },
            { "Elba", "Elbasani" },
            { "Narb", "P\u00f5hja-Araabia" },
            { "type.nu.olck", "santali numbrid" },
            { "type.co.reformed", "reformitud sortimisj\u00e4rjestus" },
            { "Tglg", metaValue_tl },
            { "Egyd", "egiptuse demootiline" },
            { "key.colBackwards", "diakriitikute p\u00f6\u00f6rdj\u00e4rjestus" },
            { "Egyh", "egiptuse hieraatiline" },
            { "Palm", "Palmyra" },
            { "ebu", "embu" },
            { "Egyp", "egiptuse hierogl\u00fc\u00fcfkiri" },
            { "Geok", "hutsuri" },
            { "zh_Hans", "hiina (lihtsustatud)" },
            { "koi", "permikomi" },
            { "Hung", "vanaungari" },
            { "kok", "konkani" },
            { "%%1901", "saksa traditsiooniline kirjaviis" },
            { "kos", "kosrae" },
            { "vec", "veneti" },
            { "type.nu.limb", "limbu numbrid" },
            { "zh_Hant", "hiina (traditsiooniline)" },
            { "Sund", metaValue_su },
            { "vep", "vepsa" },
            { "kpe", metaValue_kpe },
            { "type.nu.khmr", "khmeeri numbrid" },
            { "Tirh", "tirhuta" },
            { "ilo", "iloko" },
            { "%%VALENCIA", "valentsia" },
            { "Cprt", "K\u00fcprose silpkiri" },
            { "%%BAKU1926", "\u00fchtlustatud t\u00fcrgi-ladina t\u00e4hestik" },
            { "%%IJEKAVSK", "\u0161tokavi ije-line murrak" },
            { "mua", "mundangi" },
            { "type.nu.guru", "gurmukhi numbrid" },
            { "mul", "mitu keelt" },
            { "cad", "kado" },
            { "key.ms", "m\u00f5\u00f5dustik" },
            { "mus", "maskogi" },
            { "Glag", "glagoolitsa" },
            { "gil", "kiribati" },
            { "%%KKCOR", "\u00fcldlevinud kirjaviis" },
            { "Cher", metaValue_chr },
            { "car", "kariibi" },
            { "cay", "kajuka" },
            { "type.nu.tamldec", "tamili numbrid" },
            { "krc", "karat\u0161ai-balkaari" },
            { "inh", "ingu\u0161i" },
            { "krj", "kinaraia" },
            { "kri", "krio" },
            { "krl", "karjala" },
            { "efi", "efiki" },
            { "tcy", "tulu" },
            { "key.nu", "numbrid" },
            { "kru", "kuruhhi" },
            { "ksb", "\u0161ambala" },
            { "type.colCaseFirst.upper", "suurt\u00e4ht j\u00e4rjestuses eespool" },
            { "Telu", metaValue_te },
            { "ksf", "bafia" },
        };
        return data;
    }
}
