/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_it extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "arabo";
        final String metaValue_bn = "bengalese";
        final String metaValue_bo = "tibetano";
        final String metaValue_el = "greco";
        final String metaValue_gu = "gujarati";
        final String metaValue_he = "ebraico";
        final String metaValue_hy = "armeno";
        final String metaValue_ja = "giapponese";
        final String metaValue_ka = "georgiano";
        final String metaValue_km = "khmer";
        final String metaValue_kn = "kannada";
        final String metaValue_ko = "coreano";
        final String metaValue_la = "latino";
        final String metaValue_lo = "lao";
        final String metaValue_ml = "malayalam";
        final String metaValue_mn = "mongolo";
        final String metaValue_my = "birmano";
        final String metaValue_or = "oriya";
        final String metaValue_si = "singalese";
        final String metaValue_su = "sundanese";
        final String metaValue_ta = "tamil";
        final String metaValue_te = "telugu";
        final String metaValue_tl = "tagalog";
        final String metaValue_ban = "balinese";
        final String metaValue_chr = "cherokee";
        final String metaValue_cop = "copto";
        final String metaValue_got = "gotico";
        final String metaValue_men = "mende";
        final String metaValue_nqo = "n\u2019ko";
        final String metaValue_peo = "persiano antico";
        final String metaValue_phn = "fenicio";
        final String metaValue_saz = "saurashtra";
        final String metaValue_ssy = "saho";
        final String metaValue_zh_Hans = "cinese semplificato";
        final String metaValue_zh_Hant = "cinese tradizionale";
        final String metaValue_type_colCaseFirst_lower = "Ordina prima lettere minuscole";
        final Object[][] data = new Object[][] {
            { "ksh", "coloniese" },
            { "Ogam", "ogham" },
            { "mwl", "mirandese" },
            { "key.colStrength", "Sicurezza ordinamento" },
            { "Zsym", "simboli" },
            { "cch", "atsam" },
            { "mwr", "marwari" },
            { "type.nu.lanatham", "Cifre tai tham tham" },
            { "egl", "emiliano" },
            { "mwv", "mentawai" },
            { "Tagb", "tagbanwa" },
            { "%%NJIVA", "dialetto Gniva/Njiva" },
            { "xmf", "mengrelio" },
            { "egy", "egiziano antico" },
            { "raj", "rajasthani" },
            { "Phag", "phags-pa" },
            { "tem", "temne" },
            { "teo", "teso" },
            { "rap", "rapanui" },
            { "ter", "tereno" },
            { "AC", "Isola Ascensione" },
            { "rar", "rarotonga" },
            { "tet", "tetum" },
            { "AD", "Andorra" },
            { "AE", "Emirati Arabi Uniti" },
            { "nl_BE", "fiammingo" },
            { "AF", "Afghanistan" },
            { "AG", "Antigua e Barbuda" },
            { "type.ca.ethiopic", "Calendario etiope" },
            { "glk", "gilaki" },
            { "AI", "Anguilla" },
            { "key.tz", "Fuso orario" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "Teng", "tengwar" },
            { "AO", "Angola" },
            { "AQ", "Antartide" },
            { "AR", "Argentina" },
            { "Prti", "partico delle iscrizioni" },
            { "AS", "Samoa americane" },
            { "AT", "Austria" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "en_US", "inglese americano" },
            { "AX", "Isole \u00c5land" },
            { "key.colNormalization", "Ordinamento normalizzato" },
            { "mye", "myene" },
            { "AZ", "Azerbaigian" },
            { "%%AREVELA", "armeno orientale" },
            { "BA", "Bosnia ed Erzegovina" },
            { "BB", "Barbados" },
            { "ceb", "cebuano" },
            { "BD", "Bangladesh" },
            { "kum", "kumyk" },
            { "BE", "Belgio" },
            { "gmh", "tedesco medio alto" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaria" },
            { "BH", "Bahrein" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Saint-Barth\u00e9lemy" },
            { "BM", "Bermuda" },
            { "kut", "kutenai" },
            { "myv", "erzya" },
            { "BN", "Brunei" },
            { "BO", "Bolivia" },
            { "BQ", "Caraibi Olandesi" },
            { "BR", "Brasile" },
            { "BS", "Bahamas" },
            { "xog", "soga" },
            { "BT", "Bhutan" },
            { "BV", "Isola Bouvet" },
            { "BW", "Botswana" },
            { "BY", "Bielorussia" },
            { "BZ", "Belize" },
            { "Visp", "alfabeto visivo" },
            { "type.ca.persian", "Calendario persiano" },
            { "type.nu.hebr", "Numeri ebraici" },
            { "CA", "Canada" },
            { "CC", "Isole Cocos (Keeling)" },
            { "mzn", "mazandarani" },
            { "CD", "Congo - Kinshasa" },
            { "CF", "Repubblica Centrafricana" },
            { "CG", "Congo-Brazzaville" },
            { "CH", "Svizzera" },
            { "CI", "Costa d\u2019Avorio" },
            { "CK", "Isole Cook" },
            { "CL", "Cile" },
            { "Kthi", "kaithi" },
            { "CM", "Camerun" },
            { "CN", "Cina" },
            { "CO", "Colombia" },
            { "CP", "Isola di Clipperton" },
            { "CR", "Costa Rica" },
            { "CU", "Cuba" },
            { "CV", "Capo Verde" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Isola Christmas" },
            { "CY", "Cipro" },
            { "type.nu.bali", "Cifre balinesi" },
            { "CZ", "Repubblica Ceca" },
            { "eka", "ekajuka" },
            { "vls", "fiammingo occidentale" },
            { "%%RIGIK", "Volap\u00fck classico" },
            { "DE", "Germania" },
            { "goh", "tedesco antico alto" },
            { "ace", "accinese" },
            { "cgg", "chiga" },
            { "DG", "Diego Garcia" },
            { "gom", "konkani goano" },
            { "type.nu.deva", "Cifre devanagari" },
            { "DJ", "Gibuti" },
            { "type.colNumeric.no", "Ordina cifre individualmente" },
            { "DK", "Danimarca" },
            { "ach", "acioli" },
            { "gon", "gondi" },
            { "Brai", "braille" },
            { "Brah", "brahmi" },
            { "DM", "Dominica" },
            { "type.nu.armnlow", "Numeri armeni minuscoli" },
            { "DO", "Repubblica Dominicana" },
            { "gor", "gorontalo" },
            { "got", metaValue_got },
            { "Mtei", "meetei mayek" },
            { "key.variableTop", "Ordina come simboli" },
            { "zun", "zuni" },
            { "tig", "tigre" },
            { "Takr", "takri" },
            { "DZ", "Algeria" },
            { "pag", "pangasinan" },
            { "pal", "pahlavi" },
            { "EA", "Ceuta e Melilla" },
            { "chb", "chibcha" },
            { "pam", "pampanga" },
            { "EC", "Ecuador" },
            { "pap", "papiamento" },
            { "ada", "adangme" },
            { "EE", "Estonia" },
            { "tiv", "tiv" },
            { "EG", "Egitto" },
            { "EH", "Sahara occidentale" },
            { "chg", "ciagataico" },
            { "pau", "palau" },
            { "type.colNormalization.yes", "Ordina Unicode normalizzato" },
            { "chk", "chuukese" },
            { "chn", "gergo chinook" },
            { "chm", "mari" },
            { "chp", "chipewyan" },
            { "cho", "choctaw" },
            { "chr", metaValue_chr },
            { "ER", "Eritrea" },
            { "ES", "Spagna" },
            { "ET", "Etiopia" },
            { "EU", "Unione Europea" },
            { "elx", "elamitico" },
            { "type.ca.gregorian", "Calendario gregoriano" },
            { "chy", "cheyenne" },
            { "type.nu.gujr", "Cifre gujarati" },
            { "Inds", "indu" },
            { "ady", "adyghe" },
            { "aeb", "arabo tunisino" },
            { "FI", "Finlandia" },
            { "FJ", "Figi" },
            { "FK", "Isole Falkland" },
            { "FM", "Micronesia" },
            { "key.va", "Variante lingua" },
            { "FO", "Isole F\u00e6r \u00d8er" },
            { "Taml", metaValue_ta },
            { "FR", "Francia" },
            { "Kpel", "Kpelle" },
            { "pcd", "piccardo" },
            { "tkl", "tokelau" },
            { "grb", "gerbo" },
            { "root", "root" },
            { "%%DAJNKO", "alfabeto Dajnko" },
            { "type.ca.indian", "calendario nazionale indiano" },
            { "rgn", "romagnolo" },
            { "grc", "greco antico" },
            { "GA", "Gabon" },
            { "tkr", "tsakhur" },
            { "vot", "voto" },
            { "GB", "Regno Unito" },
            { "GD", "Grenada" },
            { "GE", "Georgia" },
            { "GF", "Guyana francese" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "Tale", "tai le" },
            { "GI", "Gibilterra" },
            { "afh", "afrihili" },
            { "GL", "Groenlandia" },
            { "enm", "inglese medio" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadalupa" },
            { "GQ", "Guinea Equatoriale" },
            { "GR", "Grecia" },
            { "GS", "Georgia del Sud e isole Sandwich australi" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "pdc", "tedesco della Pennsylvania" },
            { "GW", "Guinea-Bissau" },
            { "tli", "tlingit" },
            { "tlh", "klingon" },
            { "Talu", "tai lue" },
            { "GY", "Guyana" },
            { "ckb", "curdo sorani" },
            { "zxx", "nessun contenuto linguistico" },
            { "Jurc", "jurchen" },
            { "tly", "taliscio" },
            { "de_AT", "tedesco austriaco" },
            { "HK", "RAS di Hong Kong" },
            { "Vaii", "vaii" },
            { "HM", "Isole Heard e McDonald" },
            { "HN", "Honduras" },
            { "HR", "Croazia" },
            { "agq", "aghem" },
            { "gsw", "tedesco svizzero" },
            { "type.ca.islamic-umalqura", "Calendario islamico (Umm al-Qura)" },
            { "HT", "Haiti" },
            { "HU", "Ungheria" },
            { "rif", "tarifit" },
            { "tmh", "tamashek" },
            { "IC", "Isole Canarie" },
            { "nan", "min nan" },
            { "peo", metaValue_peo },
            { "ID", "Indonesia" },
            { "type.nu.kali", "Cifre Kayah Li" },
            { "IE", "Irlanda" },
            { "nap", "napoletano" },
            { "%%NDYUKA", "dialetto Ndyuka" },
            { "naq", "nama" },
            { "type.nu.sora", "Cifre Sora Sompeng" },
            { "zza", "zaza" },
            { "Tang", "tangut" },
            { "IL", "Israele" },
            { "Nbat", "nabateo" },
            { "IM", "Isola di Man" },
            { "IN", "India" },
            { "type.co.eor", "eor" },
            { "IO", "Territorio britannico dell\u2019Oceano Indiano" },
            { "IQ", "Iraq" },
            { "IR", "Iran" },
            { "IS", "Islanda" },
            { "IT", "Italia" },
            { "Zmth", "notazione matematica" },
            { "type.nu.thai", "Cifre thailandesi" },
            { "vro", "v\u00f5ro" },
            { "guc", "wayuu" },
            { "%%POSIX", "computer" },
            { "type.nu.beng", "Cifre bengalesi" },
            { "pfl", "tedesco palatino" },
            { "JE", "Jersey" },
            { "type.ca.islamic", "Calendario islamico" },
            { "Beng", metaValue_bn },
            { "JM", "Giamaica" },
            { "JO", "Giordania" },
            { "JP", "Giappone" },
            { "%%1606NICT", "francese medio-tardo fino al 1606" },
            { "ain", "ainu" },
            { "Mend", metaValue_men },
            { "guz", "gusii" },
            { "tog", "nyasa del Tonga" },
            { "type.nu.knda", "Cifre kannada" },
            { "Kali", "kayah li" },
            { "de_CH", "alto tedesco svizzero" },
            { "type.co.phonetic", "Ordinamento fonetico" },
            { "izh", "ingrico" },
            { "type.ca.buddhist", "Calendario buddista" },
            { "KE", "Kenya" },
            { "419", "America Latina" },
            { "KG", "Kirghizistan" },
            { "KH", "Cambogia" },
            { "KI", "Kiribati" },
            { "KM", "Comore" },
            { "Knda", metaValue_kn },
            { "KN", "Saint Kitts e Nevis" },
            { "Zinh", "ereditato" },
            { "fr_CA", "francese canadese" },
            { "KP", "Corea del Nord" },
            { "KR", "Corea del Sud" },
            { "Plrd", "fonetica di pollard" },
            { "fr_CH", "francese svizzero" },
            { "KW", "Kuwait" },
            { "tpi", "tok pisin" },
            { "KY", "Isole Cayman" },
            { "KZ", "Kazakistan" },
            { "Cyrl", "cirillico" },
            { "LA", "Laos" },
            { "LB", "Libano" },
            { "phn", metaValue_phn },
            { "LC", "Saint Lucia" },
            { "Cyrs", "cirillico antica chiesa slavonica" },
            { "gwi", "gwich\u02bcin" },
            { "nds", "basso tedesco" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "akk", "accado" },
            { "cop", metaValue_cop },
            { "LR", "Liberia" },
            { "esu", "yupik centrale" },
            { "LS", "Lesotho" },
            { "Phlv", "pahlavi book" },
            { "LT", "Lituania" },
            { "LU", "Lussemburgo" },
            { "LV", "Lettonia" },
            { "Kana", "katakana" },
            { "Sora", "sora sompeng" },
            { "LY", "Libia" },
            { "lad", "giudeo-spagnolo" },
            { "vun", "vunjo" },
            { "akz", "alabama" },
            { "lah", "lahnda" },
            { "lag", "langi" },
            { "Thaa", "thaana" },
            { "MA", "Marocco" },
            { "MC", "Monaco" },
            { "MD", "Moldavia" },
            { "Nshu", "nushu" },
            { "ME", "Montenegro" },
            { "MF", "Saint Martin" },
            { "lam", "lamba" },
            { "MG", "Madagascar" },
            { "MH", "Isole Marshall" },
            { "ale", "aleuto" },
            { "Thai", "thailandese" },
            { "type.nu.vaii", "Cifre Vai" },
            { "MK", "Repubblica di Macedonia" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Birmania)" },
            { "MN", "Mongolia" },
            { "new", "newari" },
            { "MO", "RAS di Macao" },
            { "aln", "albanese ghego" },
            { "MP", "Isole Marianne settentrionali" },
            { "MQ", "Martinica" },
            { "MR", "Mauritania" },
            { "MS", "Montserrat" },
            { "type.colAlternate.non-ignorable", "Ordina simboli" },
            { "MT", "Malta" },
            { "cps", "capiznon" },
            { "MU", "Mauritius" },
            { "alt", "altai meridionale" },
            { "MV", "Maldive" },
            { "MW", "Malawi" },
            { "MX", "Messico" },
            { "type.ca.japanese", "Calendario giapponese" },
            { "MY", "Malaysia" },
            { "MZ", "Mozambico" },
            { "Phli", "pahlavi delle iscrizioni" },
            { "NA", "Namibia" },
            { "type.ca.hebrew", "Calendario ebraico" },
            { "type.co.dictionary", "Ordinamento dizionario" },
            { "NC", "Nuova Caledonia" },
            { "%%WADEGILE", "romanizzazione Wade-Giles" },
            { "tru", "turoyo" },
            { "%%UCRCOR", "ortografia rivista unificata" },
            { "NE", "Niger" },
            { "NF", "Isola Norfolk" },
            { "NG", "Nigeria" },
            { "trv", "taroko" },
            { "Phlp", "pahlavi psalter" },
            { "NI", "Nicaragua" },
            { "Hmng", "pahawn hmong" },
            { "NL", "Paesi Bassi" },
            { "NO", "Norvegia" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "tsd", "zaconico" },
            { "Phnx", metaValue_phn },
            { "NU", "Niue" },
            { "rof", "rombo" },
            { "tsi", "tsimshian" },
            { "NZ", "Nuova Zelanda" },
            { "Merc", "corsivo meroitico" },
            { "rom", "romani" },
            { "Mero", "meroitico" },
            { "crh", "turco crimeo" },
            { "type.colAlternate.shifted", "Ordina ignorando i simboli" },
            { "ang", "inglese antico" },
            { "OM", "Oman" },
            { "anp", "angika" },
            { "Xpeo", metaValue_peo },
            { "PA", "Panam\u00e1" },
            { "type.ca.islamic-civil", "calendario civile islamico" },
            { "csb", "kashubian" },
            { "en_GB", "inglese britannico" },
            { "PE", "Per\u00f9" },
            { "ttt", "tat islamico" },
            { "PF", "Polinesia francese" },
            { "PG", "Papua Nuova Guinea" },
            { "PH", "Filippine" },
            { "PK", "Pakistan" },
            { "PL", "Polonia" },
            { "ewo", "ewondo" },
            { "PM", "Saint Pierre e Miquelon" },
            { "PN", "Isole Pitcairn" },
            { "type.colBackwards.yes", "Ordina accenti capovolti" },
            { "PR", "Portorico" },
            { "Bali", metaValue_ban },
            { "PS", "Territori palestinesi" },
            { "PT", "Portogallo" },
            { "PW", "Palau" },
            { "nia", "nias" },
            { "type.nu.greklow", "Numeri greci minuscoli" },
            { "PY", "Paraguay" },
            { "tum", "tumbuka" },
            { "Hebr", metaValue_he },
            { "QA", "Qatar" },
            { "%%SCOTLAND", "inglese scozzese standard" },
            { "jam", "creolo giamaicano" },
            { "pms", "piemontese" },
            { "niu", "niue" },
            { "QO", "Oceania lontana" },
            { "ext", "estremegno" },
            { "lez", "lezghian" },
            { "%%FONUPA", "alfabeto fonetico uralico UPA" },
            { "type.nu.takr", "Cifre takri" },
            { "tvl", "tuvalu" },
            { "Tavt", "tai viet" },
            { "001", "Mondo" },
            { "002", "Africa" },
            { "njo", "ao" },
            { "003", "Nord America" },
            { "RE", "Riunione" },
            { "type.colNormalization.no", "Ordina senza normalizzazione" },
            { "005", "America del Sud" },
            { "lfn", "Lingua Franca Nova" },
            { "jbo", "lojban" },
            { "pnt", "pontico" },
            { "Rjng", "rejang" },
            { "009", "Oceania" },
            { "RO", "Romania" },
            { "RS", "Serbia" },
            { "Mroo", "mro" },
            { "RU", "Russia" },
            { "RW", "Ruanda" },
            { "type.nu.talu", "Cifre nuovo Tai Lue" },
            { "%%METELKO", "alfabeto Metelko" },
            { "Mani", "manicheo" },
            { "Ugar", "ugarita" },
            { "key.colAlternate", "Ordinamento Ignora simboli" },
            { "Khar", "kharoshthi" },
            { "SA", "Arabia Saudita" },
            { "pon", "ponape" },
            { "Mand", "mandaico" },
            { "SB", "Isole Salomone" },
            { "twq", "tasawaq" },
            { "011", "Africa occidentale" },
            { "SC", "Seychelles" },
            { "SD", "Sudan" },
            { "013", "America Centrale" },
            { "SE", "Svezia" },
            { "014", "Africa orientale" },
            { "arc", "aramaico" },
            { "Loma", "loma" },
            { "015", "Nordafrica" },
            { "SG", "Singapore" },
            { "SH", "Sant\u2019Elena" },
            { "type.lb.strict", "Interruzione di riga forzata" },
            { "017", "Africa centrale" },
            { "SI", "Slovenia" },
            { "018", "Africa del Sud" },
            { "SJ", "Svalbard e Jan Mayen" },
            { "019", "Americhe" },
            { "SK", "Slovacchia" },
            { "Bamu", "bamum" },
            { "Wole", "woleai" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "arn", "araucano" },
            { "arp", "arapaho" },
            { "type.nu.taml", "Numeri tamil tradizionali" },
            { "SR", "Suriname" },
            { "aro", "araona" },
            { "SS", "Sud Sudan" },
            { "ST", "S\u00e3o Tom\u00e9 e Pr\u00edncipe" },
            { "arq", "arabo algerino" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Siria" },
            { "yao", "yao (bantu)" },
            { "SZ", "Swaziland" },
            { "arw", "aruaco" },
            { "arz", "arabo egiziano" },
            { "ary", "arabo marocchino" },
            { "yap", "yapese" },
            { "rtm", "rotumano" },
            { "TA", "Tristan da Cunha" },
            { "asa", "asu" },
            { "type.ms.ussystem", "Sistema consuetudinario statunitense" },
            { "021", "America del Nord" },
            { "TC", "Isole Turks e Caicos" },
            { "yav", "yangben" },
            { "TD", "Ciad" },
            { "TF", "Terre australi francesi" },
            { "ase", "lingua dei segni americana" },
            { "TG", "Togo" },
            { "TH", "Thailandia" },
            { "TJ", "Tagikistan" },
            { "029", "Caraibi" },
            { "TK", "Tokelau" },
            { "TL", "Timor Leste" },
            { "ybb", "yemba" },
            { "type.co.searchjl", "Cerca per consonante hangul iniziale" },
            { "TM", "Turkmenistan" },
            { "%%BOONT", "boontling" },
            { "TN", "Tunisia" },
            { "TO", "Tonga" },
            { "%%NULIK", "volap\u00fck moderno" },
            { "TR", "Turchia" },
            { "TT", "Trinidad e Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "ast", "asturiano" },
            { "rue", "ruteno" },
            { "rug", "roviana" },
            { "Orkh", "orkhon" },
            { "TZ", "Tanzania" },
            { "nmg", "kwasio" },
            { "Zzzz", "scrittura sconosciuta" },
            { "Sind", "khudawadi" },
            { "UA", "Ucraina" },
            { "lij", "ligure" },
            { "rup", "arumeno" },
            { "030", "Asia orientale" },
            { "tyv", "tuvinian" },
            { "sw_CD", "congo swahili" },
            { "034", "Asia del Sud" },
            { "hai", "haida" },
            { "035", "Sud-est asiatico" },
            { "UG", "Uganda" },
            { "hak", "hakka" },
            { "type.co.pinyin", "ordine pinyin" },
            { "type.colHiraganaQuaternary.yes", "Ordina Kana diversamente" },
            { "039", "Europa meridionale" },
            { "Sinh", metaValue_si },
            { "UM", "Altre isole americane del Pacifico" },
            { "liv", "livone" },
            { "US", "Stati Uniti" },
            { "haw", "hawaiano" },
            { "%%1959ACAD", "accademico" },
            { "type.co.gb2312han", metaValue_zh_Hans },
            { "UY", "Uruguay" },
            { "prg", "prussiano" },
            { "UZ", "Uzbekistan" },
            { "tzm", "tamazight" },
            { "type.co.stroke", "ordine segni" },
            { "nnh", "ngiemboon" },
            { "VA", "Citt\u00e0 del Vaticano" },
            { "pro", "provenzale antico" },
            { "VC", "Saint Vincent e Grenadines" },
            { "VE", "Venezuela" },
            { "VG", "Isole Vergini Britanniche" },
            { "VI", "Isole Vergini Americane" },
            { "VN", "Vietnam" },
            { "type.colBackwards.no", "Ordina accenti normalmente" },
            { "VU", "Vanuatu" },
            { "nog", "nogai" },
            { "rwk", "rwa" },
            { "non", "norse antico" },
            { "053", "Australasia" },
            { "%%AREVMDA", "armeno occidentale" },
            { "054", "Melanesia" },
            { "WF", "Wallis e Futuna" },
            { "type.co.traditional", "ordine tradizionale" },
            { "057", "Regione Micronesiana" },
            { "jgo", "ngamambo" },
            { "lkt", "lakota" },
            { "nov", "novial" },
            { "type.nu.finance", "Numeri finanziari" },
            { "avk", "kotava" },
            { "%%HEPBURN", "romanizzazione Hepburn" },
            { "wae", "walser" },
            { "WS", "Samoa" },
            { "Bass", "Bassa Vah" },
            { "type.nu.mtei", "Cifre Meetei Mayek" },
            { "wal", "walamo" },
            { "was", "washo" },
            { "war", "waray" },
            { "awa", "awadhi" },
            { "061", "Polinesia" },
            { "%%KSCOR", "ortografia standard" },
            { "XK", "Kosovo" },
            { "type.nu.brah", "Cifre brahmi" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "non scritto" },
            { "Olck", "ol chiki" },
            { "wbp", "warlpiri" },
            { "Batk", "batak" },
            { "Blis", "simboli bliss" },
            { "YE", "Yemen" },
            { "nqo", metaValue_nqo },
            { "type.co.standard", "Ordinamento standard" },
            { "lmo", "lombardo" },
            { "fan", "fang" },
            { "%%ROZAJ", "resiano" },
            { "fat", "fanti" },
            { "Sgnw", "linguaggio dei segni" },
            { "YT", "Mayotte" },
            { "type.nu.cham", "Cifre cham" },
            { "ZA", "Sudafrica" },
            { "type.nu.sund", "Cifre sundanesi" },
            { "type.lb.loose", "Interruzione di riga facoltativa" },
            { "Deva", "devanagari" },
            { "type.nu.geor", "Numeri georgiani" },
            { "type.co.zhuyin", "Ordinamento Zhuyin" },
            { "Hira", "hiragana" },
            { "ZM", "Zambia" },
            { "%%PINYIN", "romanizzazione Pinyin" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "Regione sconosciuta" },
            { "Runr", "runico" },
            { "type.ms.metric", "Sistema metrico" },
            { "type.ca.iso8601", "Calendario ISO-8601" },
            { "lol", "lolo bantu" },
            { "nso", "sotho del nord" },
            { "type.nu.telu", "Cifre telugu" },
            { "loz", "lozi" },
            { "Nkgb", "geba naxi" },
            { "type.colHiraganaQuaternary.no", "Ordina Kana separatamente" },
            { "jmc", "machame" },
            { "hif", "hindi figiano" },
            { "type.nu.hansfin", "Numeri finanziari in cinese semplificato" },
            { "type.colStrength.secondary", "Ordina accenti" },
            { "hil", "hiligayna" },
            { "type.nu.arabext", "Cifre indo-arabe estese" },
            { "nus", "nuer" },
            { "dak", "dakota" },
            { "type.nu.fullwide", "Cifre a larghezza intera" },
            { "hit", "hittite" },
            { "dar", "dargwa" },
            { "dav", "taita" },
            { "Maya", "geroglifici maya" },
            { "lrc", "luri settentrionale" },
            { "Copt", metaValue_cop },
            { "nwc", "newari classico" },
            { "udm", "udmurt" },
            { "Khmr", metaValue_km },
            { "type.ca.islamic-rgsa", "Calendario islamico (Arabia Saudita, osservazione)" },
            { "Limb", "limbu" },
            { "sad", "sandawe" },
            { "type.nu.roman", "Numeri romani" },
            { "sah", "yakut" },
            { "type.nu.shrd", "Cifre sharada" },
            { "ltg", "letgallo" },
            { "sam", "aramaico samaritano" },
            { "%%SCOUSE", "scouse" },
            { "saq", "samburu" },
            { "sas", "sasak" },
            { "sat", "santali" },
            { "Tfng", "tifinagh" },
            { "saz", metaValue_saz },
            { "jpr", "giudeo persiano" },
            { "type.nu.native", "Cifre native" },
            { "sba", "ngambay" },
            { "Guru", "gurmukhi" },
            { "%%ALUKU", "dialetto aluku" },
            { "lua", "luba-lulua" },
            { "sbp", "sangu" },
            { "lui", "luiseno" },
            { "nyn", "nyankole" },
            { "nym", "nyamwezi" },
            { "lun", "lunda" },
            { "nyo", "nyoro" },
            { "luo", "luo" },
            { "fil", "filippino" },
            { "hmn", "hmong" },
            { "del", "delaware" },
            { "lus", "lushai" },
            { "bal", "beluci" },
            { "den", "slave" },
            { "ban", metaValue_ban },
            { "uga", "ugaritico" },
            { "fit", "finlandese del Tornedalen" },
            { "luy", "luyia" },
            { "bar", "bavarese" },
            { "bas", "basa" },
            { "bax", "bamun" },
            { "jrb", "giudeo arabo" },
            { "es_ES", "spagnolo europeo" },
            { "nzi", "nzima" },
            { "sco", "scozzese" },
            { "scn", "siciliano" },
            { "aa", "afar" },
            { "ab", "abcaso" },
            { "bbc", "batak toba" },
            { "key.colCaseFirst", "Ordinamento Maiuscole/Minuscole" },
            { "ae", "avestan" },
            { "af", "afrikaans" },
            { "ak", "akan" },
            { "type.nu.cakm", "Cifre chakma" },
            { "bbj", "ghomala" },
            { "am", "amarico" },
            { "Arab", metaValue_ar },
            { "an", "aragonese" },
            { "%%SOLBA", "dialetto Stolvizza/Solbica" },
            { "Jpan", metaValue_ja },
            { "ar", metaValue_ar },
            { "Hrkt", "katanaka o hiragana" },
            { "as", "assamese" },
            { "sdc", "sassarese" },
            { "Lina", "lineare A" },
            { "av", "avaro" },
            { "Linb", "lineare B" },
            { "sdh", "curdo meridionale" },
            { "ay", "aymara" },
            { "az", "azerbaigiano" },
            { "Khoj", "khojki" },
            { "%%OSOJS", "dialetto Oseacco/Osojane" },
            { "ba", "baschiro" },
            { "type.co.unihan", "Ordinamento in base ai radicali" },
            { "be", "bielorusso" },
            { "bg", "bulgaro" },
            { "bi", "bislama" },
            { "type.nu.java", "Cifre giavanesi" },
            { "bm", "bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "dgr", "dogrib" },
            { "br", "bretone" },
            { "bs", "bosniaco" },
            { "see", "seneca" },
            { "Mymr", metaValue_my },
            { "sei", "seri" },
            { "type.nu.laoo", "Cifre lao" },
            { "seh", "sena" },
            { "Nkoo", metaValue_nqo },
            { "sel", "selkup" },
            { "ca", "catalano" },
            { "ses", "koyraboro senni" },
            { "ce", "ceceno" },
            { "ch", "chamorro" },
            { "%%REVISED", "ortografia revisionata" },
            { "co", "corso" },
            { "Orya", metaValue_or },
            { "cr", "cree" },
            { "cs", "ceco" },
            { "cu", "slavo della Chiesa" },
            { "yrl", "nheengatu" },
            { "cv", "ciuvascio" },
            { "cy", "gallese" },
            { "type.nu.ethi", "Numeri etiopi" },
            { "Yiii", "yi" },
            { "da", "danese" },
            { "pt_PT", "portoghese europeo" },
            { "de", "tedesco" },
            { "bej", "begia" },
            { "din", "dinca" },
            { "jut", "jutlandico" },
            { "Bugi", "buginese" },
            { "bem", "wemba" },
            { "sga", "irlandese antico" },
            { "type.nu.mong", "Numeri mongoli" },
            { "dv", "divehi" },
            { "es_419", "spagnolo latinoamericano" },
            { "bew", "betawi" },
            { "dz", "dzongkha" },
            { "bez", "bena" },
            { "type.ca.chinese", "Calendario cinese" },
            { "lzh", "cinese classico" },
            { "Lisu", "lisu" },
            { "dje", "zarma" },
            { "sgs", "samogitico" },
            { "type.nu.grek", "Numeri greci" },
            { "ee", "ewe" },
            { "bfd", "bafut" },
            { "type.lb.normal", "Interruzione di riga normale" },
            { "ro_MD", "moldavo" },
            { "el", metaValue_el },
            { "en", "inglese" },
            { "eo", "esperanto" },
            { "bfq", "badaga" },
            { "type.co.big5han", metaValue_zh_Hant },
            { "lzz", "laz" },
            { "es", "spagnolo" },
            { "et", "estone" },
            { "eu", "basco" },
            { "Buhd", "buhid" },
            { "Hang", "hangul" },
            { "Samr", "samaritano" },
            { "shi", "tashelhit" },
            { "hsb", "alto sorabo" },
            { "Hani", "han" },
            { "shn", "shan" },
            { "Hano", "hanunoo" },
            { "fa", "persiano" },
            { "Hans", "semplificato" },
            { "type.nu.latn", "Cifre occidentali" },
            { "Hant", "tradizionale" },
            { "ff", "fulah" },
            { "shu", "chadian arabic" },
            { "hsn", "xiang" },
            { "fi", "finlandese" },
            { "fj", "figiano" },
            { "fon", "fon" },
            { "bgn", "beluci occidentale" },
            { "yue", "cantonese" },
            { "fo", "faroese" },
            { "umb", "mbundu" },
            { "fr", "francese" },
            { "sid", "sidamo" },
            { "fy", "frisone occidentale" },
            { "ga", "irlandese" },
            { "gd", "gaelico scozzese" },
            { "key.colCaseLevel", "Ordinamento Distinzione fra maiuscole e minuscole" },
            { "gl", "galiziano" },
            { "gn", "guaran\u00ed" },
            { "bho", "bhojpuri" },
            { "und", "lingua imprecisata" },
            { "type.ca.ethiopic-amete-alem", "Calendario etiope Amete Alem" },
            { "gu", metaValue_gu },
            { "type.ca.islamic-tbla", "Calendario islamico (tabulare, era astronomica)" },
            { "gv", "mannese" },
            { "type.nu.osma", "Cifre osmanya" },
            { "ha", "hausa" },
            { "he", metaValue_he },
            { "hi", "hindi" },
            { "hup", "hupa" },
            { "bik", "bicol" },
            { "bin", "bini" },
            { "ho", "hiri motu" },
            { "hr", "croato" },
            { "ht", "haitiano" },
            { "hu", "ungherese" },
            { "hy", metaValue_hy },
            { "hz", "herero" },
            { "frc", "francese cajun" },
            { "%%FONIPA", "alfabeto fonetico internazionale IPA" },
            { "ia", "interlingua" },
            { "id", "indonesiano" },
            { "type.nu.tibt", "Cifre tibetane" },
            { "ie", "interlingue" },
            { "ig", "igbo" },
            { "ii", "sichuan yi" },
            { "frm", "francese medio" },
            { "ik", "inupiak" },
            { "fro", "francese antico" },
            { "frp", "francoprovenzale" },
            { "io", "ido" },
            { "frs", "frisone orientale" },
            { "bjn", "banjar" },
            { "frr", "frisone settentrionale" },
            { "is", "islandese" },
            { "it", "italiano" },
            { "iu", "inuktitut" },
            { "sli", "tedesco slesiano" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "Sarb", "arabo meridionale antico" },
            { "Sara", "sarati" },
            { "doi", "dogri" },
            { "sly", "selayar" },
            { "type.nu.lepc", "Cifre lepcha" },
            { "bkm", "kom" },
            { "sma", "sami del sud" },
            { "jv", "giavanese" },
            { "Shaw", "shaviano" },
            { "mad", "madurese" },
            { "smj", "sami di Lule" },
            { "mag", "magahi" },
            { "maf", "mafa" },
            { "mai", "maithili" },
            { "smn", "sami di Inari" },
            { "ka", metaValue_ka },
            { "bla", "siksika" },
            { "mak", "makasar" },
            { "wuu", "wu" },
            { "sms", "sami skolt" },
            { "man", "mandingo" },
            { "kg", "kongo" },
            { "Goth", metaValue_got },
            { "ki", "kikuyu" },
            { "mas", "masai" },
            { "kj", "kuanyama" },
            { "kk", "kazako" },
            { "kl", "groenlandese" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "type.colStrength.identical", "Ordina tutto" },
            { "ko", metaValue_ko },
            { "kr", "kanuri" },
            { "ks", "kashmiri" },
            { "Cirt", "cirth" },
            { "Lepc", "lepcha" },
            { "Avst", "avestico" },
            { "ku", "curdo" },
            { "kv", "komi" },
            { "kw", "cornico" },
            { "ky", "chirghiso" },
            { "snk", "soninke" },
            { "type.colStrength.primary", "Ordina solo lettere di base" },
            { "la", metaValue_la },
            { "lb", "lussemburghese" },
            { "type.nu.mlym", "Cifre malayalam" },
            { "lg", "ganda" },
            { "Roro", "rongorongo" },
            { "li", "limburgese" },
            { "Tibt", metaValue_bo },
            { "ln", "lingala" },
            { "fur", "friulano" },
            { "type.colCaseLevel.no", "Ordina senza distinzione tra maiuscole e minuscole" },
            { "lo", metaValue_lo },
            { "type.ms.uksystem", "Sistema imperiale britannico" },
            { "type.colStrength.tertiary", "Ordina accenti/lettere/larghezza" },
            { "type.nu.lana", "Cifre tai tham hora" },
            { "lt", "lituano" },
            { "lu", "luba-katanga" },
            { "lv", "lettone" },
            { "sog", "sogdiano" },
            { "mg", "malgascio" },
            { "mh", "marshallese" },
            { "type.co.ducet", "Ordinamento Unicode predefinito" },
            { "mi", "maori" },
            { "mk", "macedone" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "marathi" },
            { "ms", "malese" },
            { "mt", "maltese" },
            { "my", metaValue_my },
            { "Saur", metaValue_saz },
            { "Armn", metaValue_hy },
            { "mdf", "moksha" },
            { "mde", "maba" },
            { "dsb", "basso sorabo" },
            { "Armi", "aramaico imperiale" },
            { "na", "nauru" },
            { "type.co.search", "Ricerca generica" },
            { "nb", "norvegese bokm\u00e5l" },
            { "nd", "ndebele del nord" },
            { "ne", "nepalese" },
            { "ng", "ndonga" },
            { "mdr", "mandar" },
            { "nl", "olandese" },
            { "nn", "norvegese nynorsk" },
            { "no", "norvegese" },
            { "nr", "ndebele del sud" },
            { "nv", "navajo" },
            { "kaa", "kara-kalpak" },
            { "ny", "nyanja" },
            { "kac", "kachin" },
            { "kab", "cabilo" },
            { "%%POLYTON", "politonico" },
            { "type.colCaseFirst.lower", metaValue_type_colCaseFirst_lower },
            { "oc", "occitano" },
            { "kaj", "kai" },
            { "kam", "kamba" },
            { "men", metaValue_men },
            { "%%EMODENG", "primo inglese moderno" },
            { "oj", "ojibwa" },
            { "mer", "meru" },
            { "type.nu.armn", "Numeri armeni" },
            { "om", "oromo" },
            { "kaw", "kawi" },
            { "dtp", "dusun centrale" },
            { "or", metaValue_or },
            { "os", "ossetico" },
            { "%%ALALC97", "romanizzazione di ALA-LC, versione 1997" },
            { "bpy", "bishnupriya" },
            { "kbd", "kabardia" },
            { "mfe", "creolo mauriziano" },
            { "srn", "sranan tongo" },
            { "pa", "punjabi" },
            { "dua", "duala" },
            { "srr", "serer" },
            { "%%LIPAW", "dialetto resiano di Lipovaz" },
            { "kbl", "kanembu" },
            { "pi", "pali" },
            { "bqi", "bakhtiari" },
            { "pl", "polacco" },
            { "dum", "olandese medio" },
            { "type.nu.saur", "Cifre saurashtra" },
            { "type.ca.dangi", "Calendario Dangi" },
            { "ps", "pashto" },
            { "pt", "portoghese" },
            { "mga", "irlandese medio" },
            { "key.co", "Ordinamento" },
            { "pt_BR", "portoghese brasiliano" },
            { "%%BOHORIC", "alfabeto bohori\u010d" },
            { "kcg", "tyap" },
            { "mgh", "makhuwa-meetto" },
            { "type.nu.nkoo", "Cifre N\u2019Ko" },
            { "bra", "braj" },
            { "key.ca", "Calendario" },
            { "Laoo", metaValue_lo },
            { "mgo", "meta\u2019" },
            { "type.hc.h23", "Sistema orario a 24 ore (0\u201323)" },
            { "type.hc.h24", "Sistema orario a 24 ore (1\u201324)" },
            { "ssy", metaValue_ssy },
            { "brh", "brahui" },
            { "type.nu.mymr", "Cifre birmane" },
            { "qu", "quechua" },
            { "zap", "zapotec" },
            { "brx", "bodo" },
            { "Lana", "lanna" },
            { "kde", "makonde" },
            { "stq", "saterfriesisch" },
            { "Ethi", "etiope" },
            { "type.hc.h12", "Sistema orario a 12 ore (1\u201312)" },
            { "type.hc.h11", "Sistema orario a 12 ore (0\u201311)" },
            { "rm", "romancio" },
            { "rn", "rundi" },
            { "key.cu", "Valuta" },
            { "ro", "rumeno" },
            { "%%SAAHO", metaValue_ssy },
            { "type.nu.orya", "Cifre oriya" },
            { "type.nu.hanidec", "Numeri decimali cinesi" },
            { "ru", "russo" },
            { "bss", "akoose" },
            { "rw", "kinyarwanda" },
            { "zbl", "blissymbol" },
            { "kea", "capoverdiano" },
            { "mic", "micmac" },
            { "suk", "sukuma" },
            { "en_AU", "inglese australiano" },
            { "Dupl", "stenografia duployan" },
            { "sa", "sanscrito" },
            { "%%UCCOR", "ortografia unificata" },
            { "sc", "sardo" },
            { "sus", "susu" },
            { "sd", "sindhi" },
            { "se", "sami del nord" },
            { "min", "menangkabau" },
            { "sg", "sango" },
            { "sh", "serbo-croato" },
            { "si", metaValue_si },
            { "sux", "sumero" },
            { "sk", "slovacco" },
            { "sl", "sloveno" },
            { "Gran", "grantha" },
            { "sm", "samoano" },
            { "sn", "shona" },
            { "so", "somalo" },
            { "type.nu.arab", "Cifre indo-arabe" },
            { "sq", "albanese" },
            { "sr", "serbo" },
            { "ss", "swati" },
            { "st", "sotho del sud" },
            { "Java", "javanese" },
            { "su", metaValue_su },
            { "%%NEDIS", "dialetto del Natisone" },
            { "sv", "svedese" },
            { "sw", "swahili" },
            { "type.nu.hantfin", "Numeri finanziari in cinese tradizionale" },
            { "ibb", "ibibio" },
            { "iba", "iban" },
            { "ta", metaValue_ta },
            { "142", "Asia" },
            { "bua", "buriat" },
            { "143", "Asia centrale" },
            { "te", metaValue_te },
            { "145", "Asia occidentale" },
            { "tg", "tagico" },
            { "th", "thai" },
            { "ti", "tigrino" },
            { "bug", "bugi" },
            { "kfo", "koro" },
            { "type.colNumeric.yes", "Ordina cifre numericamente" },
            { "en_CA", "inglese canadese" },
            { "tk", "turcomanno" },
            { "tl", metaValue_tl },
            { "tn", "tswana" },
            { "to", "tongano" },
            { "bum", "bulu" },
            { "dyo", "jola-fony" },
            { "type.nu.jpan", "Numeri giapponesi" },
            { "tr", "turco" },
            { "ts", "tsonga" },
            { "swb", "comoriano" },
            { "Cakm", "chakma" },
            { "tt", "tataro" },
            { "dyu", "diula" },
            { "tw", "ci" },
            { "ty", "taitiano" },
            { "%%BISKE", "dialetto San Giorgio/Bila" },
            { "150", "Europa" },
            { "key.colHiraganaQuaternary", "Ordinamento Kana" },
            { "151", "Europa orientale" },
            { "154", "Europa settentrionale" },
            { "dzg", "dazaga" },
            { "155", "Europa occidentale" },
            { "ug", "uiguro" },
            { "Kore", metaValue_ko },
            { "Ital", "italico antico" },
            { "kgp", "kaingang" },
            { "Zyyy", "comune" },
            { "uk", "ucraino" },
            { "zea", "zelandese" },
            { "type.colCaseFirst.no", "Ordina lettere maiuscole/minuscole normalmente" },
            { "type.colStrength.quaternary", "Ordina accenti/lettere/larghezza/Kana" },
            { "type.ca.coptic", "Calendario copto" },
            { "ur", "urdu" },
            { "%%1994", "ortografia resiana standard" },
            { "xal", "kalmyk" },
            { "zen", "zenaga" },
            { "uz", "usbeco" },
            { "kha", "khasi" },
            { "%%1996", "ortografia tedesca del 1996" },
            { "nds_NL", "basso tedesco olandese" },
            { "Sylo", "syloti nagri" },
            { "ve", "venda" },
            { "Wara", "varang kshiti" },
            { "type.ca.roc", "Calendario Minguo" },
            { "vi", "vietnamita" },
            { "kho", "khotanese" },
            { "khq", "koyra chiini" },
            { "key.hc", "Sistema orario (12 o 24 ore)" },
            { "%%TARASK", "ortografia taraskievica" },
            { "vo", "volap\u00fck" },
            { "key.x", "Uso privato" },
            { "khw", "khowar" },
            { "syc", "siriaco classico" },
            { "Osma", "osmanya" },
            { "quc", "k\u2019iche\u2019" },
            { "qug", "quechua dell\u2019altopiano del Chimborazo" },
            { "gaa", "ga" },
            { "wa", "vallone" },
            { "gag", "gagauzo" },
            { "syr", "siriaco" },
            { "Grek", metaValue_el },
            { "gan", "gan" },
            { "kiu", "kirmanjki" },
            { "Lydi", "lydi" },
            { "Xsux", "sumero-accadiano cuneiforme" },
            { "wo", "wolof" },
            { "zgh", "tamazight del Marocco standard" },
            { "ar_001", "arabo moderno standard" },
            { "Cans", "simboli aborigeni canadesi unificati" },
            { "gay", "gayo" },
            { "key.colNumeric", "Ordinamento numerico" },
            { "Mong", metaValue_mn },
            { "mnc", "manchu" },
            { "Latf", "variante fraktur del latino" },
            { "szl", "slesiano" },
            { "Hluw", "geroglifici anatolici" },
            { "gba", "gbaya" },
            { "mni", "manipuri" },
            { "Latn", metaValue_la },
            { "Latg", "variante gaelica del latino" },
            { "type.nu.hans", "Numeri in cinese semplificato" },
            { "type.nu.hant", "Numeri in cinese tradizionale" },
            { "xh", "xhosa" },
            { "type.nu.romanlow", "Numeri romani minuscoli" },
            { "byn", "blin" },
            { "%%PAMAKA", "dialetto Pamaka" },
            { "Lyci", "lyci" },
            { "osa", "osage" },
            { "byv", "medumba" },
            { "gbz", "dari zoroastriano" },
            { "Moon", "moon" },
            { "moh", "mohawk" },
            { "kkj", "kako" },
            { "%%1694ACAD", "primo francese moderno" },
            { "yi", "yiddish" },
            { "mos", "mossi" },
            { "Syrc", "siriano" },
            { "Dsrt", "deseret" },
            { "yo", "yoruba" },
            { "type.nu.traditional", "Numeri tradizionali" },
            { "es_MX", "spagnolo messicano" },
            { "Syrj", "siriaco occidentale" },
            { "ota", "turco ottomano" },
            { "Syre", "siriaco estrangelo" },
            { "vai", "vai" },
            { "za", "zhuang" },
            { "Cari", "carian" },
            { "kln", "kalenjin" },
            { "zh", "cinese" },
            { "Afak", "afaka" },
            { "Bopo", "bopomofo" },
            { "Perm", "permico antico" },
            { "key.lb", "Tipo di interruzione di riga" },
            { "zu", "zulu" },
            { "type.co.phonebook", "ordine elenco telefonico" },
            { "%%MONOTON", "monotonico" },
            { "Geor", metaValue_ka },
            { "Shrd", "sharada" },
            { "kmb", "kimbundu" },
            { "type.colCaseLevel.yes", "Ordina distinzione tra maiuscole e minuscole" },
            { "type.nu.jpanfin", "Numeri finanziari giapponesi" },
            { "Cham", "cham" },
            { "gez", "geez" },
            { "mrj", "mari occidentale" },
            { "Syrn", "siriaco orientale" },
            { "type.nu.mymrshan", "Cifre shan birmane" },
            { "Narb", "arabo settentrionale antico" },
            { "type.nu.olck", "Cifre Ol Chiki" },
            { "type.co.reformed", "Ordinamento riformato" },
            { "Tglg", metaValue_tl },
            { "Egyd", "egiziano demotico" },
            { "key.colBackwards", "Ordinamento Accento capovolto" },
            { "Egyh", "ieratico egiziano" },
            { "Palm", "palmireno" },
            { "ebu", "embu" },
            { "Egyp", "geroglifici egiziani" },
            { "Geok", "kutsuri" },
            { "zh_Hans", metaValue_zh_Hans },
            { "koi", "permiaco" },
            { "Hung", "antico ungherese" },
            { "kok", "konkani" },
            { "%%1901", "ortografia tradizionale tedesca" },
            { "kos", "kosraean" },
            { "vec", "veneto" },
            { "type.nu.limb", "Cifre limbu" },
            { "zh_Hant", metaValue_zh_Hant },
            { "Sund", metaValue_su },
            { "vep", "vepso" },
            { "kpe", "kpelle" },
            { "type.nu.khmr", "Cifre khmer" },
            { "Tirh", "tirhuta" },
            { "ilo", "ilocano" },
            { "%%VALENCIA", "valenziano" },
            { "Cprt", "cipriota" },
            { "%%BAKU1926", "alfabeto latino altaico unificato" },
            { "mua", "mundang" },
            { "type.nu.guru", "Cifre gurmukhi" },
            { "mul", "multilingua" },
            { "cad", "caddo" },
            { "key.ms", "Sistema di misurazione" },
            { "mus", "creek" },
            { "Glag", "glagolitico" },
            { "gil", "gilbertese" },
            { "%%KKCOR", "ortografia comune" },
            { "Cher", metaValue_chr },
            { "car", "caribico" },
            { "cay", "cayuga" },
            { "type.nu.tamldec", "Cifre tamil" },
            { "krc", "karachay-Balkar" },
            { "inh", "ingush" },
            { "krl", "careliano" },
            { "efi", "efik" },
            { "tcy", "tulu" },
            { "key.nu", "Numeri" },
            { "kru", "kurukh" },
            { "ksb", "shambala" },
            { "type.colCaseFirst.upper", metaValue_type_colCaseFirst_lower },
            { "Telu", metaValue_te },
            { "ksf", "bafia" },
        };
        return data;
    }
}
