/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_my extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_BG = "\u1018\u1030\u1002\u1031\u1038\u101b\u102e\u1038\u101a\u102c\u1038";
        final String metaValue_CN = "\u1010\u101b\u102f\u1010\u103a";
        final String metaValue_DK = "\u1012\u102d\u1014\u103a\u1038\u1019\u1010\u103a";
        final String metaValue_ES = "\u1005\u1015\u102d\u1014\u103a";
        final String metaValue_ET = "\u1021\u102e\u101e\u102e\u101a\u102d\u102f\u1038\u1015\u102e\u1038\u101a\u102c\u1038";
        final String metaValue_FJ = "\u1016\u102e\u1002\u103b\u102e";
        final String metaValue_FR = "\u1015\u103c\u1004\u103a\u101e\u1005\u103a";
        final String metaValue_GR = "\u1002\u101b\u102d";
        final String metaValue_HU = "\u101f\u1014\u103a\u1002\u1031\u101b\u102e";
        final String metaValue_ID = "\u1021\u1004\u103a\u1012\u102d\u102f\u1014\u102e\u1038\u101b\u103e\u102c\u1038";
        final String metaValue_IT = "\u1021\u102e\u1010\u101c\u102e";
        final String metaValue_JP = "\u1002\u103b\u1015\u1014\u103a";
        final String metaValue_LA = "\u101c\u102c\u1021\u102d\u102f";
        final String metaValue_MM = "\u1019\u103c\u1014\u103a\u1019\u102c";
        final String metaValue_PL = "\u1015\u102d\u102f\u101c\u1014\u103a";
        final String metaValue_PT = "\u1015\u1031\u102b\u103a\u1010\u1030\u1002\u102e";
        final String metaValue_RU = "\u101b\u102f\u101b\u103e";
        final String metaValue_SE = "\u1006\u103d\u102e\u1012\u1004\u103a";
        final String metaValue_TH = "\u1011\u102d\u102f\u1004\u103a\u1038";
        final String metaValue_TO = "\u1010\u103d\u1014\u103a\u1002\u102b";
        final String metaValue_UA = "\u101a\u1030\u1000\u101b\u102d\u1014\u103a\u1038";
        final String metaValue_VN = "\u1017\u102e\u101a\u1000\u103a\u1014\u1019\u103a";
        final String metaValue_bn = "\u1018\u1004\u103a\u1039\u1002\u102b\u101c\u102e";
        final String metaValue_bo = "\u1010\u102d\u1018\u1000\u103a";
        final String metaValue_jv = "\u1002\u103b\u102c\u1017\u102c\u1038\u1014\u102e\u1038\u1005\u103a";
        final String metaValue_ka = "\u1002\u103b\u1031\u102c\u103a\u1002\u103b\u102e\u101a\u1014\u103a";
        final String metaValue_km = "\u1001\u1019\u102c";
        final String metaValue_ko = "\u1000\u102d\u102f\u1038\u101b\u102e\u1038\u101a\u102c\u1038";
        final String metaValue_la = "\u101c\u1000\u103a\u1010\u1004\u103a";
        final String metaValue_si = "\u1006\u1004\u103a\u101f\u102c\u101c";
        final String metaValue_ta = "\u1010\u1019\u102e\u1038\u101c\u103a";
        final String metaValue_peo = "\u1015\u102b\u101b\u103e\u1014\u103a \u1021\u101f\u1031\u102c\u1004\u103a\u1038";
        final String metaValue_Hans = "\u101b\u102d\u102f\u1038\u101b\u103e\u1004\u103a\u1038\u101e\u1031\u102c \u1010\u101b\u102f\u1010\u103a";
        final String metaValue_Hant = "\u101b\u103e\u1031\u1038\u101b\u102d\u102f\u1038\u1005\u1009\u103a\u101c\u102c \u1010\u101b\u102f\u1010\u103a";
        final Object[][] data = new Object[][] {
            { "sbp", "\u1006\u1014\u103a\u1002\u102f" },
            { "nyn", "\u101a\u1014\u103a\u1000\u102d\u102f\u101c\u102e" },
            { "luo", "\u101c\u1030\u1021\u102d\u102f" },
            { "Zsym", "\u101e\u1004\u103a\u1039\u1000\u1031\u1010" },
            { "fil", "\u1016\u102d\u101c\u1005\u103a\u1015\u102e\u1014\u102d\u102f" },
            { "del", "\u1012\u102e\u101c\u102c\u101d\u1032" },
            { "ban", "\u1018\u102c\u101c\u102e" },
            { "luy", "\u101c\u1030\u101b\u102e\u1021\u102c" },
            { "bas", "\u1018\u102c\u1006\u102c" },
            { "egy", "\u101b\u103e\u1031\u1038\u101f\u1031\u102c\u1004\u103a\u1038 \u1021\u102e\u1002\u103b\u1005\u103a" },
            { "jrb", "\u1002\u103b\u1030\u1012\u102e\u101a\u102d\u102f-\u1021\u102c\u101b\u1031\u1017\u103b" },
            { "es_ES", "\u1005\u1015\u102d\u1014\u103a(\u1025\u101b\u1031\u102c\u1015)" },
            { "sco", "\u1005\u1000\u1031\u102c\u1037" },
            { "teo", "\u1010\u102e\u1006\u102d\u102f" },
            { "ab", "\u1021\u1018\u103a\u1001\u102b\u1007\u102e\u101b\u1014\u103a" },
            { "AC", "\u1021\u1000\u103a\u1005\u103a\u1005\u1004\u103a\u101b\u103e\u102e\u1021\u103d\u1014\u103a\u1000\u103b\u103d\u1014\u103a\u1038" },
            { "AD", "\u1021\u1014\u103a\u1012\u102d\u102f\u101b\u102c" },
            { "AE", "\u101a\u1030\u1021\u1031\u1021\u102e\u1038" },
            { "nl_BE", "\u1016\u101c\u102e\u1019\u1005\u103a\u101b\u103e\u103a" },
            { "AF", "\u1021\u102c\u1016\u1002\u1014\u103a\u1014\u1005\u1039\u1005\u1010\u1014\u103a" },
            { "af", "\u1021\u102c\u1016\u101b\u102d\u1000\u1014\u103a\u1038\u1005\u103a" },
            { "AG", "\u1021\u1014\u103a\u1010\u102e\u1002\u102f\u1021\u102c\u1014\u103e\u1004\u1037\u103a\u1018\u102c\u1018\u102f\u1012\u102b" },
            { "type.ca.ethiopic", "\u1021\u102e\u101e\u102e\u101a\u102d\u102f\u1038\u1015\u102e\u1038\u101a\u102c\u1038 \u1015\u103c\u1000\u1039\u1001\u1012\u102d\u1014\u103a" },
            { "AI", "\u1021\u1014\u103a\u1002\u103d\u102e\u101c\u102c" },
            { "ak", "\u1021\u102c\u1000\u102d\u1014\u103a" },
            { "AL", "\u1021\u1032\u101c\u103a\u1018\u102c\u1014\u102e\u1021\u102c" },
            { "AM", "\u1021\u102c\u1019\u1031\u1014\u102e\u1038\u101a\u102c\u1038" },
            { "am", "\u1021\u1014\u103a\u101f\u102c\u101b\u1005\u103b\u1001\u103b" },
            { "Arab", "\u1021\u102c\u101b\u1031\u1017\u103b" },
            { "AO", "\u1021\u1004\u103a\u1002\u102d\u102f\u101c\u102c" },
            { "Jpan", metaValue_JP },
            { "AQ", "\u1021\u1014\u1039\u1010\u102c\u1010\u102d\u1000" },
            { "AR", "\u1021\u102c\u1002\u103b\u1004\u103a\u1010\u102e\u1038\u1014\u102c\u1038" },
            { "ar", "\u1021\u102c\u101b\u1031\u1017\u102e" },
            { "Hrkt", "\u1001\u1010\u1001\u100f \u101e\u102d\u102f\u1037\u1019\u101f\u102f\u1010\u103a \u101f\u102d\u101b\u1002\u100f" },
            { "AS", "\u1021\u1019\u1031\u101b\u102d\u1000\u1014\u103a \u1005\u1019\u102d\u102f\u1021" },
            { "as", "\u1021\u1000\u1039\u1005\u1019\u102e\u1005\u103a" },
            { "AT", "\u1029\u1005\u1010\u103c\u102e\u1038\u101a\u102c\u1038" },
            { "AU", "\u1029\u1005\u1010\u103c\u1031\u1038\u101c\u103b" },
            { "AW", "\u1021\u102c\u101b\u102f\u1018\u102c" },
            { "en_US", "\u1021\u1019\u1031\u101b\u102d\u1000\u1014\u103a \u1021\u1004\u103a\u1039\u1002\u101c\u102d\u1015\u103a" },
            { "AX", "\u1021\u102c\u101c\u1014\u103a\u1000\u103b\u103d\u1014\u103a\u1038" },
            { "AZ", "\u1021\u1007\u102c\u1018\u102d\u102f\u1004\u103a\u1002\u103b\u1014\u103a" },
            { "az", "\u1021\u1031\u102c\u103a\u1007\u1031\u102c\u1018\u102d\u102f\u1004\u103a\u1002\u103b\u1031\u102c\u1014\u102e" },
            { "%%AREVELA", "\u1021\u101b\u103e\u1031\u1037\u1015\u102d\u102f\u1004\u103a\u1038\u1021\u102c\u1019\u1031\u1038\u1014\u102e\u1038\u101a\u1014\u103a\u1038" },
            { "BA", "\u1018\u1031\u102c\u1037\u1005\u1014\u102e\u1038\u101a\u102c\u1038 \u1014\u103e\u1004\u1037\u103a \u101f\u102c\u1007\u102e\u1002\u102d\u102f\u1018\u102e\u1038\u1014\u102c\u1038" },
            { "ba", "\u1018\u1000\u103a\u101b\u103e\u103a\u1000\u102e\u1021\u102c" },
            { "BB", "\u1018\u102c\u1018\u1012\u102d\u102f\u1038\u1005\u103a" },
            { "BD", "\u1018\u1004\u103a\u1039\u1002\u101c\u102c\u1038\u1012\u1031\u1037\u101b\u103e\u103a" },
            { "BE", "\u1018\u101a\u103a\u101c\u103a\u1002\u103b\u102e\u101a\u1019\u103a" },
            { "be", "\u1018\u102e\u101c\u102c\u101b\u102f" },
            { "gmh", "\u1021\u101c\u101a\u103a\u1015\u102d\u102f\u1004\u103a\u1038\u1021\u1019\u103c\u1004\u1037\u103a\u1002\u103b\u102c\u1019\u1014\u103a" },
            { "BF", "\u1018\u102c\u1000\u102e\u1014\u102c \u1016\u102c\u1006\u102d\u102f" },
            { "bg", metaValue_BG },
            { "BG", metaValue_BG },
            { "BH", "\u1018\u102c\u101b\u102d\u1014\u103a\u1038" },
            { "BI", "\u1018\u1030\u101b\u103d\u1014\u103a\u1012\u102e" },
            { "BJ", "\u1018\u102e\u1014\u1004\u103a" },
            { "BL", "\u1005\u102d\u1014\u1037\u103a\u1018\u102c\u101e\u102e\u101c\u102e\u1019\u102d\u102f\u1004\u103a" },
            { "BM", "\u1018\u102c\u1019\u1030\u1012\u102b" },
            { "bm", "\u1018\u1014\u103a\u1018\u102c\u101b\u102c" },
            { "bn", metaValue_bn },
            { "BN", "\u1018\u101b\u1030\u1014\u102d\u102f\u1004\u103a\u1038" },
            { "bo", metaValue_bo },
            { "BO", "\u1018\u102d\u102f\u101c\u102e\u1038\u1018\u102e\u1038\u101a\u102c\u1038" },
            { "BQ", "\u1000\u102c\u101b\u102e\u1018\u102e\u101a\u1036\u1014\u101a\u103a\u101e\u102c\u101c\u1014\u103a" },
            { "BR", "\u1018\u101b\u102c\u1007\u102e\u1038" },
            { "br", "\u1018\u101b\u102e\u1010\u103d\u1014\u103a" },
            { "BS", "\u1018\u101f\u102c\u1038\u1019\u102c\u1038" },
            { "bs", "\u1018\u1031\u102c\u1037\u1005\u103a\u1014\u102e\u1038\u101a\u102c\u1038" },
            { "xog", "\u1006\u102d\u102f\u1002\u102b" },
            { "BT", "\u1018\u1030\u1010\u1014\u103a" },
            { "BV", "\u1018\u1030\u1017\u1000\u103a\u1000\u103b\u103d\u1014\u103a\u1038" },
            { "Mymr", metaValue_MM },
            { "BW", "\u1018\u1031\u102c\u1037\u1005\u103a\u101d\u102b\u1014\u102c" },
            { "type.nu.laoo", "\u101c\u102c\u1021\u102d\u102f\u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "BY", "\u1018\u102e\u101c\u102c\u101b\u102f\u1005\u103a" },
            { "seh", "\u1005\u102e\u1014\u102c" },
            { "BZ", "\u1018\u1031\u101c\u102e\u1007\u103a" },
            { "Visp", "\u1019\u103c\u1004\u103a\u1014\u102d\u102f\u1004\u103a\u101e\u1031\u102c \u1005\u1000\u102c\u1038" },
            { "type.ca.persian", "\u1015\u102b\u101b\u103e\u102c\u1038 \u1015\u103c\u1000\u1039\u1001\u1012\u102d\u1014\u103a" },
            { "type.nu.hebr", "\u101f\u1031\u1017\u103c\u1032\u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "CA", "\u1000\u1014\u1031\u1012\u102b" },
            { "ca", "\u1000\u102c\u1010\u102c\u101c\u1014\u103a" },
            { "CC", "\u1000\u102d\u102f\u1000\u102d\u102f\u1038 \u1000\u103b\u103d\u1014\u103a\u1038\u1005\u102f" },
            { "mzn", "\u1019\u102c\u1007\u1014\u103a\u1012\u102b\u101b\u1014\u103a\u1014\u102e" },
            { "ses", "\u1001\u102d\u102f\u101b\u102c\u1018\u102d\u102f\u101b\u102d\u102f \u1006\u1019\u103a\u1014\u102e" },
            { "CD", "\u1000\u103d\u1014\u103a\u1002\u102d\u102f-\u1000\u1004\u103a\u101b\u103e\u102c\u1005" },
            { "ce", "\u1001\u103b\u1031\u1001\u103b\u1004\u103a\u1038" },
            { "CF", "\u1021\u101c\u101a\u103a\u1015\u102d\u102f\u1004\u103a\u1038 \u1021\u102c\u1016\u101b\u102d\u1000 \u1015\u103c\u100a\u103a\u1011\u1031\u102c\u1004\u103a\u1005\u102f" },
            { "CG", "\u1000\u103d\u1014\u103a\u1002\u102d\u102f-\u1018\u101b\u102c\u1007\u102c\u1017\u102e\u101c\u103a" },
            { "CH", "\u1006\u103d\u1005\u103a\u1007\u101c\u1014\u103a" },
            { "CI", "\u1021\u102d\u102f\u1004\u103a\u1017\u101b\u102e\u1000\u102d\u102f\u1005\u1037\u103a" },
            { "%%REVISED", "\u1015\u103c\u1014\u103a\u101c\u100a\u103a\u1005\u102e\u1005\u1005\u103a\u1011\u102c\u1038\u101e\u1031\u102c \u101b\u1031\u1038\u1011\u102f\u1036\u1038" },
            { "CK", "\u1000\u103d\u1010\u103a \u1000\u103b\u103d\u1014\u103a\u1038\u1005\u102f" },
            { "CL", "\u1001\u103b\u102e\u101c\u102e" },
            { "CM", "\u1000\u1004\u103a\u1019\u101b\u103d\u1014\u103a\u1038" },
            { "CN", metaValue_CN },
            { "CO", "\u1000\u102d\u102f\u101c\u1036\u1018\u102e\u101a\u102c" },
            { "co", "\u1001\u102d\u102f\u1005\u102e\u1000\u1014\u103a" },
            { "CP", "\u1000\u101c\u1005\u103a\u1015\u102b\u1010\u1014\u103a\u1000\u103b\u103d\u1014\u103a\u1038" },
            { "Orya", "\u1021\u102d\u102f\u101b\u102c" },
            { "CR", "\u1000\u1031\u102c\u1037\u1005\u103a\u1010\u102c\u101b\u102e\u1000\u102c" },
            { "cr", "\u1001\u101b\u102e\u1038" },
            { "cs", "\u1001\u103b\u1000\u103a" },
            { "CU", "\u1000\u103b\u1030\u1038\u1018\u102c\u1038" },
            { "CV", "\u1001\u1031\u1037\u1015\u103a\u1017\u102c\u1012\u1030" },
            { "cv", "\u1001\u103b\u1030\u1017\u1000\u103a\u101b\u103e\u103a" },
            { "CW", "\u1001\u1030\u101b\u102c\u1000\u102c\u1021\u102d\u102f" },
            { "CX", "\u1001\u101b\u1005\u103a\u1005\u1019\u1010\u103a \u1000\u103b\u103d\u1014\u103a\u1038" },
            { "CY", "\u1006\u102d\u102f\u1000\u103a\u1015\u101b\u1000\u103a\u1005\u103a" },
            { "cy", "\u101d\u1031\u101c" },
            { "CZ", "\u1001\u103b\u1000\u103a \u1015\u103c\u100a\u103a\u1011\u1031\u102c\u1004\u103a\u1005\u102f" },
            { "type.nu.ethi", "\u1021\u102e\u101e\u102e\u1021\u102d\u102f\u1015\u102e\u1038\u101a\u102c\u1038\u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "Yiii", "\u101b\u102e" },
            { "da", metaValue_DK },
            { "pt_PT", "\u1025\u101b\u1031\u102c\u1015 \u1015\u1031\u102b\u103a\u1010\u1030\u1002\u102e" },
            { "DE", "\u1002\u103b\u102c\u1019\u100f\u102e" },
            { "de", "\u1002\u103b\u102c\u1019\u1014\u103a" },
            { "cgg", "\u1001\u103b\u102e\u1002\u102b" },
            { "DG", "\u1012\u102e\u1021\u1031\u1002\u102d\u102f\u1002\u101b\u102c\u1005\u102e\u1021\u102c" },
            { "type.nu.deva", "\u1012\u102e\u1015\u102b\u1014\u102c\u1002\u102b\u101b\u102e\u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "DJ", "\u1002\u103b\u102e\u1018\u1030\u1010\u102e" },
            { "DK", metaValue_DK },
            { "Brai", "\u1018\u101b\u1031" },
            { "Brah", "\u1017\u103c\u101f\u1039\u1019\u1019\u102e" },
            { "DM", "\u1012\u102d\u102f\u1019\u102e\u1014\u102e\u1000\u102c" },
            { "type.nu.armnlow", "\u1021\u102c\u1019\u1031\u1014\u102e\u101a\u1014\u103a\u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031\u1021\u101e\u1031\u1038" },
            { "DO", "\u1012\u102d\u102f\u1019\u102e\u1014\u102e\u1000\u1014\u103a" },
            { "bem", "\u1018\u102d\u1014\u103a\u1018\u102c" },
            { "sga", "\u1021\u102d\u102f\u1004\u103a\u1038\u101b\u1005\u103a \u101f\u1031\u102c\u1004\u103a\u1038" },
            { "es_419", "\u101c\u1000\u103a\u1010\u1004\u103a\u1021\u1019\u1031\u101b\u102d\u1000 \u1005\u1015\u102d\u1014\u103a" },
            { "DZ", "\u1021\u101a\u103a\u101c\u103a\u1002\u103b\u102e\u1038\u101b\u102e\u1038\u101a\u102c\u1038" },
            { "dz", "\u1012\u103d\u1014\u103a\u1000\u102c" },
            { "bez", "\u1018\u102e\u1014\u102c" },
            { "type.ca.chinese", "\u1010\u101b\u102f\u1010\u103a \u1015\u103c\u1000\u1039\u1001\u1012\u102d\u1014\u103a" },
            { "EA", "\u1006\u101a\u103a\u1025\u1010\u102c\u1014\u103e\u1004\u1037\u103a\u1019\u101a\u103a\u101c\u102e\u101c\u103a\u101c\u102c" },
            { "EC", "\u1021\u102e\u1000\u103d\u1031\u1012\u1031\u102b" },
            { "dje", "\u1007\u102c\u1019\u102c" },
            { "type.nu.grek", "\u1002\u101b\u102d\u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "EE", "\u1021\u1000\u103a\u1005\u1010\u102d\u102f\u1038\u1014\u102e\u1038\u101a\u102c\u1038" },
            { "ee", "\u101d\u102e" },
            { "type.lb.normal", "\u1015\u102f\u1036\u1019\u103e\u1014\u103a\u101c\u102d\u102f\u1004\u103a\u1038\u1016\u103c\u1010\u103a\u1010\u1031\u102c\u1000\u103a\u1019\u103e\u102f\u1015\u102f\u1036\u1005\u1036" },
            { "EG", "\u1021\u102e\u1002\u103b\u1005\u103a" },
            { "EH", "\u1021\u1014\u1031\u102c\u1000\u103a\u1015\u102d\u102f\u1004\u103a\u1038 \u1006\u102c\u101f\u102c\u101b" },
            { "el", metaValue_GR },
            { "en", "\u1021\u1004\u103a\u1039\u1002\u101c\u102d\u1015\u103a" },
            { "eo", "\u1021\u1000\u1039\u1005\u1015\u101b\u1014\u1039\u1010\u102d\u102f" },
            { "chr", "\u1001\u103b\u102c\u101b\u102d\u102f\u1000\u102e" },
            { "ER", "\u1021\u102e\u101b\u102e\u1010\u101b\u102e\u1021\u102c" },
            { "es", metaValue_ES },
            { "ES", metaValue_ES },
            { "ET", metaValue_ET },
            { "et", "\u1021\u1000\u103a\u1005\u103a\u1010\u102d\u102f\u1038\u1014\u102e\u1038\u101b\u1014\u103a\u1038" },
            { "EU", "\u1025\u101b\u1031\u102c\u1015\u101e\u1019\u1002\u1039\u1002" },
            { "eu", "\u1018\u1005\u103a\u1000\u1039\u1000\u102e" },
            { "Hang", "\u101f\u1014\u103a\u1002\u1030\u1038\u101c\u103a" },
            { "type.ca.gregorian", "\u1014\u102d\u102f\u1004\u103a\u1004\u1036\u1010\u1000\u102c\u101e\u102f\u1036\u1038 \u1015\u103c\u1000\u1039\u1001\u1012\u102d\u1014\u103a" },
            { "shi", "\u1010\u102c\u1001\u103b\u101a\u103a\u101c\u103a\u101f\u1005\u103a" },
            { "type.nu.gujr", "\u1002\u102f\u1002\u103b\u102c\u101b\u102c\u1010\u102e\u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "hsb", "\u1021\u1015\u1031\u102b\u103a\u1006\u102d\u102f\u1018\u102e\u1021\u1019\u103a" },
            { "Hani", "\u101f\u1014\u103a" },
            { "shn", "\u101b\u103e\u1019\u103a\u1038" },
            { "fa", "\u1015\u102b\u101b\u103e\u1014\u103a" },
            { "Hans", metaValue_Hans },
            { "type.nu.latn", "\u1021\u1014\u1031\u102c\u1000\u103a\u1010\u102d\u102f\u1004\u103a\u1038\u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "Hant", metaValue_Hant },
            { "FI", "\u1016\u1004\u103a\u101c\u1014\u103a" },
            { "fi", "\u1016\u1004\u103a\u1014\u1005\u103a\u101b\u103e\u103a" },
            { "fj", metaValue_FJ },
            { "FJ", metaValue_FJ },
            { "FK", "\u1016\u1031\u102c\u1000\u103a\u1000\u101c\u1014\u103a \u1000\u103b\u103d\u1014\u103a\u1038\u1005\u102f" },
            { "FM", "\u1019\u102d\u102f\u1004\u103a\u1001\u101b\u102d\u102f\u1014\u102e\u101b\u103e\u102c\u1038" },
            { "bgn", "\u1021\u1014\u1031\u102c\u1000\u103a\u1015\u102d\u102f\u1004\u103a\u1038\u1018\u1032\u101c\u102d\u102f\u1001\u103b\u102e" },
            { "FO", "\u1016\u102c\u101b\u102d\u102f\u1038 \u1000\u103b\u103d\u1014\u103a\u1038\u1005\u102f\u1019\u103b\u102c\u1038" },
            { "fo", "\u1016\u102c\u101b\u102d\u102f\u1021\u102d\u1005\u103a" },
            { "Taml", metaValue_ta },
            { "fr", metaValue_FR },
            { "FR", metaValue_FR },
            { "fy", "\u1021\u1014\u1031\u102c\u1000\u103a\u1015\u102d\u102f\u1004\u103a\u1038 \u1016\u101b\u102e\u1005\u102e\u101b\u1014\u103a" },
            { "root", "\u1019\u1030\u101c\u101b\u1004\u103a\u1038\u1019\u103c\u1005\u103a" },
            { "type.ca.indian", "\u1021\u102d\u1014\u1039\u1012\u103c\u102d\u101a \u1021\u1019\u103b\u102d\u102f\u1038\u101e\u102c\u1038 \u1015\u103c\u1000\u1039\u1001\u1012\u102d\u1014\u103a" },
            { "grc", "\u101b\u103e\u1031\u1038\u101f\u1031\u102c\u1004\u103a\u1038 \u1002\u101b\u102d" },
            { "GA", "\u1002\u102b\u1018\u103d\u1014\u103a" },
            { "ga", "\u1021\u102d\u102f\u1004\u103a\u1038\u101b\u1005\u103a" },
            { "GB", "\u101a\u1030\u1014\u102d\u102f\u1000\u103a\u1010\u1000\u103a\u1000\u1004\u103a\u1038\u1012\u1019\u103a\u1038" },
            { "GD", "\u1002\u101b\u102e\u1014\u102c\u1012\u102b" },
            { "GE", "\u1002\u103b\u1031\u102c\u103a\u1002\u103b\u102e\u101a\u102c" },
            { "GF", "\u1015\u103c\u1004\u103a\u101e\u1005\u103a \u1002\u102e\u101a\u102c\u1014\u102c" },
            { "GG", "\u1002\u103d\u1014\u103a\u1038\u1007\u102e" },
            { "GH", "\u1002\u102b\u1014\u102c" },
            { "Tale", "\u1010\u102d\u102f\u1004\u103a\u101c\u102e" },
            { "GI", "\u1002\u103b\u102e\u1018\u101b\u1031\u102c\u103a\u101c\u103a\u1010\u102c" },
            { "GL", "\u1002\u101b\u1004\u103a\u1038\u101c\u1014\u103a\u1038" },
            { "gl", "\u1002\u102b\u101c\u102c\u1005\u102e\u101a\u1036" },
            { "enm", "\u1021\u101c\u101a\u103a\u1015\u102d\u102f\u1004\u103a\u1038 \u1021\u1004\u103a\u1039\u1002\u101c\u102d\u1015\u103a" },
            { "GM", "\u1002\u1014\u103a\u1018\u102e\u101b\u102c" },
            { "GN", "\u1002\u102e\u1038\u1014\u102e" },
            { "gn", "\u1002\u1030\u1021\u102c\u101b\u102c\u1014\u102e" },
            { "GP", "\u1002\u1030\u1021\u102c\u1012\u102e\u101c\u102f\u1015\u103a" },
            { "GQ", "\u1021\u102e\u1000\u103d\u1031\u1010\u102c \u1002\u102e\u101b\u102c\u1014\u102c" },
            { "und", "\u1019\u101e\u102d \u101e\u102d\u102f\u1037\u1019\u101f\u102f\u1010\u103a \u1019\u101b\u103e\u102d \u101e\u1031\u102c \u1018\u102c\u101e\u102c\u1005\u1000\u102c\u1038" },
            { "GR", metaValue_GR },
            { "GS", "\u1010\u1031\u102c\u1004\u103a \u1002\u103b\u1031\u102c\u103a\u1002\u103b\u102e\u101a\u102c \u1014\u103e\u1004\u1037\u103a \u1010\u1031\u102c\u1004\u103a \u1006\u1004\u103a\u1038\u1012\u101d\u1005\u103a\u1002\u103b\u103a \u1000\u103b\u103d\u1014\u103a\u1038\u1005\u102f\u1019\u103b\u102c\u1038" },
            { "GT", "\u1002\u103d\u102c\u1010\u102e\u1019\u102c\u101c\u102c" },
            { "GU", "\u1002\u1030\u1021\u1019\u103a" },
            { "gu", "\u1002\u1030\u1002\u103b\u102c\u101b\u101e\u102e" },
            { "gv", "\u1019\u1014\u103a\u1038\u1007\u103a" },
            { "GW", "\u1002\u102e\u101b\u102c\u1014\u102c-\u1018\u102e\u1005\u103a\u1005\u102c\u1025" },
            { "GY", "\u1002\u1030\u101b\u102c\u1014\u102c" },
            { "ha", "\u101f\u102c\u1025\u1005\u102c" },
            { "ckb", "\u1006\u102d\u102f\u101b\u102c\u1014\u102e \u1000\u1030\u1012\u1005\u103a\u101b\u103e\u103a" },
            { "zxx", "\u1018\u102c\u101e\u102c\u1005\u1000\u102c\u1038 \u1014\u103e\u1004\u1037\u103a \u1015\u1010\u103a\u101e\u1000\u103a \u101e\u1031\u102c\u1021\u101b\u102c\u1019\u101b\u103e\u102d" },
            { "he", "\u101f\u102e\u1038\u1018\u101b\u1030\u1038" },
            { "hi", "\u101f\u102d\u1014\u1039\u1012\u102e" },
            { "de_AT", "\u1029\u1005\u1010\u103c\u102e\u1038\u101a \u1002\u103b\u102c\u1019\u1014\u103a" },
            { "HK", "\u1010\u101b\u102f\u1010\u103a\u104f \u1021\u1011\u1030\u1038\u1021\u102f\u1015\u103a\u1001\u103b\u102f\u1015\u103a\u1001\u103d\u1004\u1037\u103a\u101b \u101f\u1031\u102c\u1004\u103a\u1000\u1031\u102c\u1004\u103a" },
            { "HM", "\u101f\u1010\u103a\u1000\u103b\u103d\u1014\u103a\u1038\u1014\u103e\u1004\u1037\u103a\u1019\u1000\u103a\u1012\u1031\u102b\u1014\u101a\u103a\u1000\u103b\u103d\u1014\u103a\u1038\u1005\u102f" },
            { "HN", "\u101f\u103d\u1014\u103a\u1012\u1030\u1038\u101b\u1015\u103a\u1005\u103a" },
            { "HR", "\u1001\u101b\u102d\u102f\u1021\u1031\u1038\u101b\u103e\u102c\u1038" },
            { "hr", "\u1001\u101b\u102d\u102f\u1021\u1031\u101b\u103e\u1014\u103a" },
            { "agq", "\u1021\u102c\u1002\u103a\u101f\u102d\u1014\u103a\u1038" },
            { "gsw", "\u1006\u103d\u1005\u103a \u1002\u103b\u102c\u1019\u1014\u103a" },
            { "HT", "\u101f\u1031\u1010\u102e" },
            { "ht", "\u101f\u102c\u1021\u102e\u1010\u102e\u1021\u1014\u103a" },
            { "hu", metaValue_HU },
            { "HU", metaValue_HU },
            { "hy", "\u1021\u102c\u1019\u1031\u1014\u102e\u1021\u1014\u103a" },
            { "%%FONIPA", "IPA \u1021\u101e\u1036\u1011\u103d\u1000\u103a" },
            { "IC", "\u1000\u102c\u1014\u102c\u101b\u102e\u1000\u103b\u103d\u1014\u103a\u1038\u1005\u102f" },
            { "id", metaValue_ID },
            { "ID", metaValue_ID },
            { "peo", metaValue_peo },
            { "type.nu.tibt", "\u1010\u102d\u1018\u1000\u103a\u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "IE", "\u1021\u102d\u102f\u1004\u103a\u101a\u102c\u101c\u1014\u103a" },
            { "ig", "\u1021\u1005\u1039\u1002\u1018\u102d\u102f" },
            { "naq", "\u1014\u102c\u1019\u102c" },
            { "ii", "\u1005\u102e\u1001\u103b\u103d\u1019\u103a \u101b\u102e" },
            { "frm", "\u1021\u101c\u101a\u103a\u1015\u102d\u102f\u1004\u103a\u1038\u1015\u103c\u1004\u103a\u101e\u1005\u103a" },
            { "fro", "\u1015\u103c\u1004\u103a\u101e\u1005\u103a\u101f\u1031\u102c\u1004\u103a\u1038" },
            { "IL", "\u1021\u1005\u1039\u1005\u101b\u1031\u1038" },
            { "IM", "\u1019\u1014\u103a\u1000\u103b\u103d\u1014\u103a\u1038" },
            { "IN", "\u1021\u102d\u1014\u1039\u1012\u102d\u101a" },
            { "IO", "\u1017\u103c\u102d\u1010\u102d\u101e\u103b\u103e \u1021\u102d\u1014\u1039\u1012\u103c\u102d\u101a \u101e\u1019\u102f\u1012\u1039\u1012\u101b\u102c \u1015\u102d\u102f\u1004\u103a\u1014\u1000\u103a" },
            { "frs", "\u1021\u101b\u103e\u1031\u1037\u1015\u102d\u102f\u1004\u103a\u1038 \u1016\u101b\u102e\u1005\u102e\u101b\u1014\u103a" },
            { "frr", "\u1019\u103c\u1031\u102c\u1000\u103a\u1015\u102d\u102f\u1004\u103a\u1038 \u1016\u101b\u102e\u1005\u102e\u101b\u1014\u103a" },
            { "IQ", "\u1021\u102e\u101b\u1010\u103a" },
            { "IR", "\u1021\u102e\u101b\u1014\u103a" },
            { "IS", "\u1021\u102d\u102f\u1000\u103a\u1005\u101c\u1014\u103a" },
            { "is", "\u1021\u102d\u102f\u1004\u103a\u1005\u103a\u101c\u1014\u1039\u1012\u102e" },
            { "it", metaValue_IT },
            { "IT", metaValue_IT },
            { "iu", "\u1021\u102e\u1014\u102f\u1001\u103a\u1010\u102e\u1010\u102f" },
            { "type.nu.thai", "\u1011\u102d\u102f\u1004\u103a\u1038\u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "%%POSIX", "\u1000\u103d\u1014\u103a\u1015\u103b\u1030\u1010\u102c" },
            { "type.nu.beng", "\u1018\u1014\u103a\u1002\u102b\u101c\u102e\u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "ja", metaValue_JP },
            { "Mlym", "\u1019\u102c\u101c\u102c\u101b\u102c\u101c\u1014\u103a" },
            { "JE", "\u1002\u103b\u102c\u1005\u102e" },
            { "type.ca.islamic", "\u1021\u1005\u1039\u1005\u101c\u102c\u1019\u103a \u1015\u103c\u1000\u1039\u1001\u1012\u102d\u1014\u103a" },
            { "Beng", metaValue_bn },
            { "JM", "\u1002\u103b\u1019\u1031\u1000\u102c" },
            { "JO", "\u1002\u103b\u1031\u102c\u103a\u1012\u1014\u103a" },
            { "JP", metaValue_JP },
            { "sma", "\u1010\u1031\u102c\u1004\u103a\u1015\u102d\u102f\u1004\u103a\u1038 \u1006\u102c\u1019\u102d" },
            { "%%1606NICT", "\u1021\u101c\u101a\u103a\u1015\u102d\u102f\u1004\u103a\u1038\u1014\u1031\u102c\u1000\u103a\u1000\u103b\u101e\u1031\u102c\u1015\u103c\u1004\u103a\u101e\u1005\u103a\u1019\u103e \u1041\u1046\u1040\u1046" },
            { "jv", metaValue_jv },
            { "guz", "\u1002\u1030\u1005\u102e\u1038" },
            { "type.nu.knda", "\u1001\u1014\u1039\u1014\u1012\u102b\u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "Kali", "\u1000\u101a\u102c\u1038\u101c\u102e" },
            { "smj", "\u101c\u1030\u101c\u102e \u1006\u102c\u1019\u102d" },
            { "de_CH", "\u1006\u103d\u1005\u103a \u1021\u1019\u103c\u1004\u1037\u103a \u1002\u103b\u102c\u1019\u1014\u103a" },
            { "smn", "\u1021\u102e\u1014\u102c\u101b\u102e \u1006\u102c\u1019\u102d" },
            { "ka", metaValue_ka },
            { "type.ca.buddhist", "\u1017\u102f\u1012\u1039\u1013 \u1015\u103c\u1000\u1039\u1001\u1012\u102d\u1014\u103a" },
            { "sms", "\u1001\u102d\u102f\u101c\u103a \u1006\u102c\u1019\u102d" },
            { "KE", "\u1000\u1004\u103a\u100a\u102c" },
            { "419", "\u101c\u1000\u103a\u1010\u1004\u103a\u1021\u1019\u1031\u101b\u102d\u1000" },
            { "KG", "\u1001\u101b\u1030\u1002\u1005\u103a\u1005\u1010\u1014\u103a" },
            { "kg", "\u1000\u103d\u1014\u103a\u1002\u102d\u102f" },
            { "KH", "\u1000\u1019\u1039\u1018\u1031\u102c\u1012\u102e\u1038\u101a\u102c\u1038" },
            { "KI", "\u1001\u102e\u101b\u102e\u1018\u102c\u1010\u102e" },
            { "ki", "\u1001\u102e\u1001\u1030\u101a\u1030" },
            { "mas", "\u1019\u102c\u1006\u102d\u102f\u1004\u103a" },
            { "kk", "\u1001\u102b\u1007\u102b\u1001\u103a" },
            { "kl", "\u1001\u101c\u102c\u1021\u103a\u101c\u102e\u1006\u1015\u103a" },
            { "km", metaValue_km },
            { "KM", "\u1000\u102d\u102f\u1019\u102d\u102f\u101b\u102d\u102f\u1005\u103a" },
            { "KN", "\u1005\u102d\u1014\u1037\u103a\u1000\u1005\u103a\u1014\u103e\u1004\u1037\u103a\u1014\u102e\u1017\u102e\u1005\u103a" },
            { "kn", "\u1000\u1014\u1039\u1014\u102c\u1012\u102b" },
            { "Knda", "\u1001\u1014\u1039\u1014\u102c\u1012\u102b" },
            { "fr_CA", "\u1000\u1014\u1031\u1012\u102b \u1015\u103c\u1004\u103a\u101e\u1005\u103a" },
            { "ko", metaValue_ko },
            { "KP", "\u1019\u103c\u1031\u102c\u1000\u103a\u1000\u102d\u102f\u101b\u102e\u1038\u101a\u102c\u1038" },
            { "KR", "\u1010\u1031\u102c\u1004\u103a\u1000\u102d\u102f\u101b\u102e\u1038\u101a\u102c\u1038" },
            { "ks", "\u1000\u1000\u103a\u101b\u103e\u103a\u1019\u102e\u101b\u102e" },
            { "ku", "\u1000\u1012\u103a" },
            { "fr_CH", "\u1006\u103d\u1005\u103a \u1015\u103c\u1004\u103a\u101e\u1005\u103a" },
            { "KW", "\u1000\u1030\u101d\u102d\u1010\u103a" },
            { "kw", "\u1001\u102d\u102f\u1014\u102e\u101b\u103e\u103a" },
            { "KY", "\u1000\u1031\u1019\u1014\u103a \u1000\u103b\u103d\u1014\u103a\u1038\u1005\u102f" },
            { "ky", "\u1001\u101b\u1030\u1002\u1005\u103a" },
            { "KZ", "\u1000\u102c\u1007\u1000\u103a\u1005\u1010\u1014\u103a" },
            { "Cyrl", "\u1005\u1005\u103a\u101b\u102d\u101c\u1005\u103a" },
            { "LA", metaValue_LA },
            { "la", metaValue_la },
            { "LB", "\u101c\u1000\u103a\u1018\u1014\u103d\u1014\u103a" },
            { "lb", "\u101c\u1030\u1007\u1004\u103a\u1018\u1010\u103a\u1000\u103a" },
            { "LC", "\u1005\u102d\u1014\u1037\u103a\u101c\u1030\u1005\u102e\u1021\u102c" },
            { "type.nu.mlym", "\u1019\u101c\u102c\u101b\u102c\u101c\u1019\u103a\u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "lg", "\u1002\u1014\u103a\u1012\u102e" },
            { "nds", "\u1021\u1014\u102d\u1019\u1037\u103a \u1002\u103b\u102c\u1019\u1014\u103a" },
            { "LI", "\u101c\u1005\u103a\u1001\u103a\u1011\u1004\u103a\u1005\u1010\u102d\u102f\u1004\u103a" },
            { "LK", "\u101e\u102e\u101b\u102d\u101c\u1004\u103a\u1039\u1000\u102c" },
            { "Tibt", metaValue_bo },
            { "ln", "\u101c\u1004\u103a\u1002\u102b\u101c\u102c" },
            { "lo", metaValue_LA },
            { "type.ms.uksystem", "\u1017\u103c\u102d\u1010\u102d\u101e\u103b\u103e\u1010\u102d\u102f\u1004\u103a\u1038\u1010\u102c\u1005\u1014\u1005\u103a" },
            { "LR", "\u101c\u102d\u102f\u1004\u103a\u1018\u1031\u1038\u101b\u102e\u1038\u101a\u102c\u1038" },
            { "LS", "\u101c\u102e\u1006\u102d\u102f\u101e\u102d\u102f" },
            { "LT", "\u101c\u1005\u103a\u101e\u1030\u101a\u1031\u1038\u1014\u102e\u1038\u101a\u102c\u1038" },
            { "lt", "\u101c\u1005\u1039\u101e\u1030\u1021\u102c\u1014\u102e\u101a\u1036" },
            { "LU", "\u101c\u1030\u1007\u1004\u103a\u1018\u1010\u103a" },
            { "lu", "\u101c\u1030\u1018\u102c-\u1001\u102b\u1010\u1014\u103a\u1002\u102b" },
            { "LV", "\u101c\u1010\u103a\u1017\u102e\u1038\u101a\u102c\u1038" },
            { "lv", "\u101c\u1000\u1039\u1018\u102e\u1021\u1036" },
            { "Kana", "\u1001\u1010\u1001\u100f" },
            { "LY", "\u101c\u102e\u1017\u101b\u102c" },
            { "ListCompositionPattern", "{0}\u104a{1}" },
            { "vun", "\u1017\u1014\u103a\u1002\u103b\u102d\u102f" },
            { "lag", "\u101c\u1014\u103a\u1002\u102e" },
            { "Thaa", "\u101e\u102c\u1021\u103a" },
            { "MA", "\u1019\u1031\u102c\u103a\u101b\u102d\u102f\u1000\u102d\u102f" },
            { "MC", "\u1019\u102d\u102f\u1014\u102c\u1000\u102d\u102f" },
            { "MD", "\u1019\u1031\u102c\u101c\u103a\u1012\u102d\u102f\u1017\u102c" },
            { "ME", "\u1019\u103d\u1014\u103a\u1010\u102e\u1014\u102d\u1002\u101b\u102d\u102f\u1038" },
            { "MF", "\u1005\u102d\u1014\u1037\u103a\u1019\u102c\u1010\u1004\u103a" },
            { "MG", "\u1019\u102c\u1012\u102b\u1002\u1010\u103a\u1005\u1000\u102c" },
            { "mg", "\u1021\u102c\u101c\u102c\u1002\u102b\u1005\u102e" },
            { "Thai", metaValue_TH },
            { "MH", "\u1019\u102c\u101b\u103e\u101a\u103a \u1000\u103b\u103d\u1014\u103a\u1038\u1005\u102f" },
            { "type.co.ducet", "\u101a\u1030\u1014\u102e\u1000\u102f\u1010\u103a\u1021\u1005\u1009\u103a\u101c\u102d\u102f\u1000\u103a\u1005\u102e\u1011\u102c\u1038\u101e\u1031\u102c" },
            { "mi", "\u1019\u1031\u102c\u1004\u103a\u1038\u101b\u102e (\u1014\u101a\u1030\u1038\u1007\u102e\u101c\u1014\u103a\u1000\u103b\u103d\u1014\u103a\u1038\u101b\u103e\u102d \u1015\u1004\u103a\u101b\u1004\u103a\u1038\u1010\u102d\u102f\u1004\u103a\u1038\u101b\u1004\u103a\u1038\u101e\u102c\u1038\u101c\u1030\u1019\u103b\u102d\u102f\u1038)" },
            { "MK", "\u1019\u102c\u1005\u102e\u1012\u102d\u102f\u1038\u1014\u102e\u1038\u101a\u102c\u1038" },
            { "mk", "\u1019\u102c\u1005\u102e\u1012\u102d\u102f\u1014\u102e\u101a\u1036" },
            { "ML", "\u1019\u102c\u101c\u102e" },
            { "ml", "\u1019\u101c\u1031\u1038\u101b\u102c\u101c\u1019\u103a" },
            { "MM", metaValue_MM },
            { "MN", "\u1019\u103d\u1014\u103a\u1002\u102d\u102f\u1038\u101c\u102e\u1038\u101a\u102c\u1038" },
            { "mn", "\u1019\u103d\u1014\u103a\u1002\u102d\u102f\u101c\u102e\u1038\u101a\u1014\u103a\u1038" },
            { "MO", "\u1010\u101b\u102f\u1010\u103a\u104f \u1021\u1011\u1030\u1038\u1021\u102f\u1015\u103a\u1001\u103b\u102f\u1015\u103a\u1001\u103d\u1004\u1037\u103a\u101b \u1019\u1000\u102c\u1021\u102d\u102f" },
            { "MP", "\u1010\u1031\u102c\u1004\u103a\u1015\u102d\u102f\u1004\u103a\u1038\u1019\u102c\u101b\u102e\u1021\u102c\u1014\u102c\u1000\u103b\u103d\u1014\u103a\u1038\u1005\u102f" },
            { "MQ", "\u1019\u102c\u1010\u102e\u1014\u102e\u1000\u102e" },
            { "MR", "\u1019\u1031\u102c\u101b\u102e\u1010\u102c\u1014\u102e\u1021\u102c" },
            { "mr", "\u1019\u102c\u101b\u101e\u102e" },
            { "MS", "\u1019\u1031\u102c\u1004\u1037\u103a\u1005\u1032\u101b\u1000\u103a" },
            { "ms", "\u1019\u101c\u1031\u1038" },
            { "MT", "\u1019\u1031\u102c\u101c\u103a\u1010\u102c" },
            { "mt", "\u1019\u1031\u102c\u101c\u1039\u1010\u102e\u1005\u103a" },
            { "MU", "\u1019\u1031\u102c\u103a\u101b\u1031\u101b\u103e\u102c\u1038\u1005\u103a" },
            { "MV", "\u1019\u1031\u102c\u103a\u101c\u103a\u1012\u102d\u102f\u1000\u103a" },
            { "MW", "\u1019\u102c\u101c\u102c\u101d\u102e" },
            { "MX", "\u1019\u1000\u1039\u1000\u1006\u102e\u1000\u102d\u102f" },
            { "type.ca.japanese", "\u1002\u103b\u1015\u1014\u103a \u1015\u103c\u1000\u1039\u1001\u1012\u102d\u1014\u103a" },
            { "MY", "\u1019\u101c\u1031\u1038\u101b\u103e\u102c\u1038" },
            { "my", "\u1017\u1019\u102c" },
            { "MZ", "\u1019\u102d\u102f\u1007\u1014\u103a\u1018\u1005\u103a" },
            { "Armn", "\u1021\u102c\u1019\u1031\u1038\u1014\u102e\u1038\u101a\u102c\u1038" },
            { "dsb", "\u1021\u1031\u102c\u1000\u103a\u1006\u102d\u102f\u1018\u102e\u1021\u1019\u103a" },
            { "NA", "\u1014\u1019\u103a\u1019\u102e\u1038\u1018\u102e\u1038\u101a\u102c\u1038" },
            { "type.co.search", "\u101a\u1031\u1018\u102f\u101a\u103b\u101b\u103e\u102c\u1001\u103c\u1004\u103a\u1038" },
            { "nb", "\u1018\u103d\u1010\u103a\u1019\u1031\u102c\u103a\u101c\u103a" },
            { "type.ca.hebrew", "\u101f\u102e\u1017\u101b\u1030\u1038 \u1015\u103c\u1000\u1039\u1001\u1012\u102d\u1014\u103a" },
            { "NC", "\u1014\u101a\u1030\u1038 \u1000\u101a\u103a\u101c\u102e\u1012\u102d\u102f\u1014\u102e\u1038\u101a\u102c\u1038" },
            { "nd", "\u1010\u1031\u102c\u1004\u103a\u1012\u102e\u1018\u102e\u101c\u102e" },
            { "NE", "\u1014\u102d\u102f\u1004\u103a\u1002\u103b\u102c" },
            { "ne", "\u1014\u102e\u1015\u102b\u101c\u102e" },
            { "NF", "\u1014\u1031\u102c\u1016\u1031\u102c\u1037\u1001\u103a\u1000\u103b\u103d\u1014\u103a\u1038" },
            { "NG", "\u1014\u102d\u102f\u1004\u103a\u1002\u103b\u102e\u1038\u101b\u102e\u1038\u101a\u102c\u1038" },
            { "NI", "\u1014\u102e\u1000\u102c\u101b\u102c\u1002\u103d\u102c" },
            { "NL", "\u1014\u101a\u103a\u101e\u102c\u101c\u1014\u103a" },
            { "nl", "\u1012\u1010\u103a\u1001\u103b\u103a" },
            { "nn", "\u1014\u1031\u102c\u103a\u101d\u1031\u1038 \u1014\u102e\u1038\u1014\u1031\u102c\u103a\u1005\u103a\u1001\u103a" },
            { "NO", "\u1014\u1031\u102c\u103a\u101d\u1031" },
            { "no", "\u1014\u1031\u102c\u103a\u101d\u1031\u1038" },
            { "NP", "\u1014\u102e\u1015\u1031\u102b" },
            { "NR", "\u1014\u102c\u1025\u1030\u101b\u1030" },
            { "NU", "\u1014\u102e\u1025\u1030\u1021\u1031" },
            { "rof", "\u101b\u103d\u1019\u103a\u1018\u102d\u102f" },
            { "NZ", "\u1014\u101a\u1030\u1038\u1007\u102e\u101c\u1014\u103a" },
            { "kac", "\u1000\u1001\u103b\u1004\u103a" },
            { "kab", "\u1001\u1018\u102d\u102f\u1004\u103a\u101c\u103a" },
            { "kam", "\u1001\u1019\u103a\u1018\u102c" },
            { "ang", "\u1021\u1004\u103a\u1039\u1002\u101c\u102d\u1015\u103a\u1005\u102c\u101f\u1031\u102c\u1004\u103a\u1038" },
            { "mer", "\u1019\u102e\u101b\u102f" },
            { "type.nu.armn", "\u1021\u102c\u1019\u1031\u1014\u102e\u101a\u1014\u103a\u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "OM", "\u1021\u102d\u102f\u1019\u1014\u103a" },
            { "om", "\u1021\u102d\u102f\u101b\u102d\u102f\u1019\u102d\u102f" },
            { "or", "\u1021\u102d\u102f\u101b\u102e\u101b\u102c" },
            { "Xpeo", metaValue_peo },
            { "mfe", "\u1019\u102d\u102f\u101b\u103e\u102e\u1005\u103a\u101a\u1014\u103a\u1038" },
            { "PA", "\u1015\u1014\u102c\u1038\u1019\u102c\u1038" },
            { "pa", "\u1015\u1014\u103a\u1001\u103b\u102c\u1015\u102e" },
            { "dua", "\u1012\u1030\u1021\u101c\u102c" },
            { "en_GB", "\u1017\u103c\u102d\u1010\u102d\u101e\u103b\u103e \u1021\u1004\u103a\u1039\u1002\u101c\u102d\u1015\u103a" },
            { "PE", "\u1015\u102e\u101b\u1030\u1038" },
            { "PF", "\u1015\u103c\u1004\u103a\u101e\u1005\u103a \u1015\u1031\u102b\u103a\u101c\u102e\u1014\u1031\u1038\u101b\u103e\u102c\u1038" },
            { "PG", "\u1015\u102b\u1015\u1030\u101b\u102c\u1014\u101a\u1030\u1038\u1002\u102e\u1014\u102e" },
            { "PH", "\u1016\u102d\u101c\u1005\u103a\u1015\u102d\u102f\u1004\u103a" },
            { "pi", "\u1015\u102b\u1020\u102d" },
            { "PK", "\u1015\u102b\u1000\u1005\u1039\u1005\u1010\u1014\u103a" },
            { "pl", metaValue_PL },
            { "PL", metaValue_PL },
            { "PM", "\u1005\u102d\u1014\u1037\u103a\u1015\u102e\u1021\u1032\u101b\u102e\u1014\u103e\u1004\u1037\u103a\u1019\u102e\u1000\u103d\u102e\u101c\u103d\u1014\u103a" },
            { "dum", "\u1021\u101c\u101a\u103a\u1015\u102d\u102f\u1004\u103a\u1038 \u1012\u1010\u103a\u1001\u103b\u103a" },
            { "PN", "\u1015\u1005\u103a\u1010\u103a\u1000\u102d\u1014\u103a\u1038\u1000\u103b\u103d\u1014\u103a\u1038\u1005\u102f" },
            { "type.ca.dangi", "\u1012\u1014\u103a\u1038\u1002\u102d \u1015\u103c\u1000\u1039\u1001\u1012\u102d\u1014\u103a" },
            { "PR", "\u1015\u1031\u102b\u103a\u1010\u1030\u101b\u102e\u1000\u102d\u102f" },
            { "PS", "\u1015\u102b\u101c\u1000\u103a\u1005\u1010\u102d\u102f\u1004\u103a\u1038 \u1015\u102d\u102f\u1004\u103a\u1014\u1000\u103a" },
            { "ps", "\u1015\u102b\u101b\u103e\u103a\u1010\u102d\u102f" },
            { "pt", metaValue_PT },
            { "PT", metaValue_PT },
            { "mga", "\u1021\u101c\u101a\u103a\u1015\u102d\u102f\u1004\u103a\u1038 \u1021\u102d\u102f\u1004\u103a\u1038\u101b\u1005\u103a" },
            { "key.co", "\u1005\u1014\u1005\u103a\u1010\u1000\u103b\u1005\u102e\u101e\u1031\u102c" },
            { "PW", "\u1015\u101c\u1031\u102c\u1004\u103a" },
            { "type.nu.greklow", "\u1002\u101b\u102d\u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031\u1021\u101e\u1031\u1038" },
            { "PY", "\u1015\u102b\u101b\u102c\u1002\u103d\u1031\u1038" },
            { "pt_BR", "\u1018\u101b\u102c\u1007\u102e\u1038 \u1015\u1031\u102b\u103a\u1010\u1030\u1002\u102e" },
            { "mgh", "\u1019\u102c\u1001\u1030\u101d\u102b-\u1019\u102e\u1021\u102e\u1010\u102d\u102f" },
            { "Hebr", "\u101f\u102e\u1017\u101b\u1030\u1038" },
            { "QA", "\u1000\u102c\u1010\u102c" },
            { "key.ca", "\u1015\u103c\u1000\u1039\u1001\u1012\u102d\u1014\u103a" },
            { "Laoo", metaValue_LA },
            { "mgo", "\u1019\u102e\u1010\u102c" },
            { "type.hc.h23", "\u1042\u1044 \u1014\u102c\u101b\u102e \u1005\u1014\u1005\u103a (\u1040\u2013\u1042\u1043)" },
            { "type.hc.h24", "\u1042\u1044 \u1014\u102c\u101b\u102e \u1005\u1014\u1005\u103a(\u1041\u2013\u1042\u1044)" },
            { "%%SCOTLAND", "\u1005\u1000\u1031\u102c\u1037 \u1005\u1036 \u1021\u1004\u103a\u1039\u1002\u101c\u102d\u1015\u103a" },
            { "type.nu.mymr", "\u1019\u103c\u1014\u103a\u1019\u102c\u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "QO", "\u101e\u1019\u102f\u1012\u1039\u1012\u101b\u102c\u1012\u1031\u101e\u1021\u1015\u103c\u1004\u103a\u1011\u103d\u1000\u103a\u1014\u1031\u101e\u1031\u102c\u1012\u1031\u101e\u1019\u103b\u102c\u1038" },
            { "%%FONUPA", "UPA \u1021\u101e\u1036\u1011\u103d\u1000\u103a" },
            { "qu", "\u1001\u1000\u103a\u1001\u103b\u103a\u101d\u102b" },
            { "brx", "\u1017\u102d\u102f\u1012\u102d\u102f" },
            { "kde", "\u1019\u102c\u1001\u103d\u1014\u103a\u1012\u102e" },
            { "Ethi", metaValue_ET },
            { "001", "\u1000\u1019\u1039\u1018\u102c" },
            { "002", "\u1021\u102c\u1016\u101b\u102d\u1000" },
            { "003", "\u1019\u103c\u1031\u102c\u1000\u103a \u1021\u1019\u1031\u101b\u102d\u1000" },
            { "RE", "\u101b\u1032\u1021\u1030\u1014\u102e\u101b\u103d\u1014\u103a" },
            { "type.hc.h12", "\u1041\u1042 \u1014\u102c\u101b\u102e\u1005\u1014\u1005\u103a (\u1041\u2013\u1041\u1042)" },
            { "005", "\u1010\u1031\u102c\u1004\u103a \u1021\u1019\u1031\u101b\u102d\u1000" },
            { "type.hc.h11", "\u1041\u1042 \u1014\u102c\u101b\u102e \u1005\u1014\u1005\u103a (\u1040\u2013\u1041\u1041)" },
            { "009", "\u101e\u1019\u102f\u1012\u1039\u1012\u101b\u102c\u1012\u1031\u101e" },
            { "rm", "\u101b\u1031\u102c\u1019" },
            { "rn", "\u101b\u103d\u1014\u103a\u1012\u102e" },
            { "key.cu", "\u1004\u103d\u1031\u1000\u103c\u1031\u1038" },
            { "RO", "\u101b\u102d\u102f\u1019\u1031\u1038\u1014\u102e\u1038\u101a\u102c\u1038" },
            { "ro", "\u101b\u102d\u102f\u1019\u1031\u1014\u102e\u101a\u102c\u1038" },
            { "RS", "\u1006\u102c\u1038\u1018\u102e\u1038\u101a\u102c\u1038" },
            { "type.nu.orya", "\u1029\u101b\u102e\u101b\u102c\u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "type.nu.hanidec", "\u1010\u101b\u102f\u1010\u103a\u1006\u101a\u103a\u101c\u102e\u1005\u1014\u1005\u103a\u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "ru", metaValue_RU },
            { "RU", metaValue_RU },
            { "RW", "\u101b\u101d\u1014\u103a\u1012\u102b" },
            { "rw", "\u1000\u1004\u103a\u101b\u102c\u101d\u1014\u103a\u1012\u102b" },
            { "kea", "\u1001\u1018\u1030\u1017\u102c\u1012\u102e\u1021\u102c\u1014\u1030" },
            { "en_AU", "\u1029\u1005\u1010\u103c\u1031\u1038\u101c\u103b\u103e \u1021\u1004\u103a\u1039\u1002\u101c\u102d\u1015\u103a" },
            { "SA", "\u1006\u1031\u102c\u103a\u1012\u102e\u1021\u102c\u101b\u1031\u1038\u1017\u102e\u1038\u101a\u102c\u1038" },
            { "sa", "\u101e\u1004\u103a\u1039\u101e\u1000\u101b\u102d\u102f\u1000\u103a" },
            { "SB", "\u1006\u1031\u102c\u103a\u101c\u1019\u103d\u1014\u103a\u1000\u103b\u103d\u1014\u103a\u1038\u1005\u102f" },
            { "twq", "\u1010\u102c\u1006\u102c\u101d\u102b\u1001\u103a" },
            { "011", "\u1021\u1014\u1031\u102c\u1000\u103a \u1021\u102c\u1016\u101b\u102d\u1000" },
            { "SC", "\u1006\u1031\u1038\u101b\u103e\u101c\u103a" },
            { "SD", "\u1006\u1030\u1012\u1014\u103a" },
            { "sd", "\u1005\u1004\u103a\u1012\u102e" },
            { "SE", metaValue_SE },
            { "013", "\u1021\u101c\u101a\u103a\u1015\u102d\u102f\u1004\u103a\u1038 \u1021\u1019\u1031\u101b\u102d\u1000" },
            { "se", "\u1010\u1031\u102c\u1004\u103a\u1006\u102c\u1019\u102d" },
            { "014", "\u1021\u101b\u103e\u1031\u1037\u1015\u102d\u102f\u1004\u103a\u1038 \u1021\u102c\u1016\u101b\u102d\u1000" },
            { "015", "\u1019\u103c\u1031\u102c\u1000\u103a\u1015\u102d\u102f\u1004\u103a\u1038 \u1021\u102c\u1016\u101b\u102d\u1000" },
            { "SG", "\u1005\u1004\u103a\u1039\u1000\u102c\u1015\u1030" },
            { "sg", "\u1006\u1019\u103a\u1002\u102d\u102f" },
            { "SH", "\u1005\u102d\u1014\u1037\u103a\u101f\u1032\u101c\u102e\u1014\u102c" },
            { "type.lb.strict", "\u1010\u1004\u103a\u1038\u1000\u103c\u1015\u103a\u101e\u1031\u102c\u101c\u102d\u102f\u1004\u103a\u1038\u1016\u103c\u1010\u103a\u1010\u1031\u102c\u1000\u103a\u1019\u103e\u102f\u1015\u102f\u1036\u1005\u1036" },
            { "si", metaValue_si },
            { "017", "\u1021\u101c\u101a\u103a\u1015\u102d\u102f\u1004\u103a\u1038 \u1021\u102c\u1016\u101b\u102d\u1000" },
            { "SI", "\u1005\u101c\u102d\u102f\u1017\u1031\u1038\u1014\u102e\u1038\u101a\u102c\u1038" },
            { "018", "\u1010\u1031\u102c\u1004\u103a\u1015\u102d\u102f\u1004\u103a\u1038 \u1021\u102c\u1016\u101b\u102d\u1000" },
            { "SJ", "\u1005\u1017\u102d\u102f\u101c\u103a\u1018\u1010\u103a\u1014\u103e\u1004\u1037\u103a\u1002\u103b\u1014\u103a\u1019\u1031\u101b\u1014\u103a" },
            { "019", "\u1021\u1019\u1031\u101b\u102d\u1000\u1019\u103b\u102c\u1038" },
            { "SK", "\u1005\u101c\u102d\u102f\u1017\u1031\u1038\u1000\u102e\u1038\u101a\u102c\u1038" },
            { "sk", "\u1005\u101c\u102d\u102f\u1017\u1000\u103a" },
            { "SL", "\u1006\u102e\u1021\u1032\u101b\u102c \u101c\u102e\u1021\u102d\u102f\u1014\u102e" },
            { "sl", "\u1005\u101c\u102d\u102f\u1017\u1031\u1038\u1014\u102e\u1038\u101a\u1019\u103a\u1038" },
            { "SM", "\u1006\u1031\u102c\u1037\u1014\u103a\u1019\u102c\u101b\u102e\u1014\u102d\u102f" },
            { "SN", "\u1006\u102e\u1014\u102e\u1002\u1031\u102b" },
            { "sn", "\u101b\u103e\u102d\u1014\u102c" },
            { "SO", "\u1006\u102d\u102f\u1019\u102c\u101c\u102e\u101a\u102c" },
            { "so", "\u1006\u102d\u102f\u1019\u102c\u101c\u102e" },
            { "arn", "\u1019\u102c\u1015\u102f\u1001\u103b\u102e" },
            { "type.nu.arab", "\u1021\u102c\u101b\u1015\u103a\u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "sq", "\u1021\u101a\u103a\u101c\u103a\u1018\u1031\u1038\u1014\u102e\u1038\u101a\u1014\u103a\u1038" },
            { "type.nu.taml", "\u101b\u102d\u102f\u1038\u101b\u102c\u1010\u1019\u102e\u1038\u101c\u103a\u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "SR", "\u1006\u1030\u101b\u102e\u1014\u102d\u1019\u103a\u1038" },
            { "sr", "\u1006\u102c\u1038\u1017\u102e\u1038\u101a\u1014\u103a\u1038" },
            { "ListKeyTypePattern", "{0} \u104a {1}" },
            { "SS", "\u1019\u103c\u1031\u102c\u1000\u103a\u1006\u1030\u1012\u1014\u103a" },
            { "Java", metaValue_jv },
            { "ST", "\u1005\u102d\u1014\u1037\u103a\u1010\u102d\u102f\u1019\u102e\u1014\u103e\u1004\u1037\u103a\u1015\u101b\u1004\u103a\u1005\u102e\u1015\u1037\u103a" },
            { "sv", metaValue_SE },
            { "SV", "\u1021\u101a\u103a\u101c\u103a\u1006\u102c\u1017\u1031\u1038\u1012\u102d\u102f\u1038" },
            { "sw", "\u1006\u103c\u102c\u101f\u102e\u101c\u102e" },
            { "SX", "\u1006\u1004\u1037\u103a\u1019\u102c\u1021\u102c\u1010\u1004\u103a" },
            { "SY", "\u1006\u102e\u1038\u101b\u102e\u1038\u101a\u102c\u1038" },
            { "type.nu.hantfin", "\u101b\u102d\u102f\u1038\u101b\u102c\u1010\u101b\u102f\u1010\u103a\u1018\u100f\u1039\u100f\u102c\u101b\u1031\u1038\u101e\u102f\u1036\u1038\u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "SZ", "\u1005\u103d\u102c\u1007\u102e\u101c\u1014\u103a" },
            { "ta", metaValue_ta },
            { "TA", "\u1011\u101b\u1005\u103a\u1010\u1014\u103a\u1012\u102b\u1000\u103d\u1014\u103a\u101f\u102c" },
            { "asa", "\u1021\u102c\u1005\u102f" },
            { "type.ms.ussystem", "\u1021\u1019\u1031\u101b\u102d\u1000\u1014\u103a\u1010\u102d\u102f\u1004\u103a\u1038\u1010\u102c\u1005\u1014\u1005\u103a" },
            { "021", "\u1019\u103c\u1031\u102c\u1000\u103a\u1015\u102d\u102f\u1004\u103a\u1038 \u1021\u1019\u1031\u101b\u102d\u1000" },
            { "142", "\u1021\u102c\u101b\u103e" },
            { "TC", "\u1010\u1001\u103a\u1005\u103a\u1014\u103e\u1004\u1037\u103a\u1000\u102c\u1021\u102e\u1000\u102d\u102f\u1005\u103a\u1000\u103b\u103d\u1014\u103a\u1038\u1005\u102f" },
            { "143", "\u1021\u101c\u101a\u103a \u1021\u102c\u101b\u103e" },
            { "TD", "\u1001\u103b\u1012\u103a" },
            { "te", "\u1010\u102e\u101c\u102e\u1002\u102f" },
            { "145", "\u1021\u1014\u1031\u102c\u1000\u103a \u1021\u102c\u101b\u103e" },
            { "TF", "\u1015\u103c\u1004\u103a\u101e\u1005\u103a \u1010\u1031\u102c\u1004\u103a\u1015\u102d\u102f\u1004\u103a\u1038 \u1015\u102d\u102f\u1004\u103a\u1014\u1000\u103a\u1019\u103b\u102c\u1038" },
            { "TG", "\u1010\u102d\u102f\u1002\u102d\u102f" },
            { "tg", "\u1010\u102c\u1002\u103b\u1005\u103a" },
            { "th", metaValue_TH },
            { "TH", metaValue_TH },
            { "ti", "\u1010\u102e\u1002\u103a\u101b\u1004\u103a\u101b\u102c" },
            { "TJ", "\u1010\u102c\u1002\u103b\u102e\u1000\u1005\u1039\u1005\u1010\u1014\u103a" },
            { "en_CA", "\u1000\u1014\u1031\u1012\u102b \u1021\u1004\u103a\u1039\u1002\u101c\u102d\u1015\u103a" },
            { "029", "\u1000\u102c\u101b\u102e\u1018\u102e\u101a\u1036" },
            { "TK", "\u1011\u102d\u102f\u1038\u1001\u102b\u101c\u1030" },
            { "tk", "\u1010\u1001\u1039\u1019\u1004\u103a" },
            { "TL", "\u1021\u101b\u103e\u1031\u1037\u1010\u102e\u1019\u1031\u102c" },
            { "TM", "\u1010\u102c\u1001\u103a\u1019\u102e\u1014\u1037\u1005\u103a\u1010\u1014\u103a" },
            { "TN", "\u1010\u1030\u1014\u102e\u1038\u101b\u103e\u102c\u1038" },
            { "to", metaValue_TO },
            { "TO", metaValue_TO },
            { "dyo", "\u1002\u103b\u102d\u102f\u101c\u102c-\u1016\u103d\u1014\u103a\u101b\u102e" },
            { "type.nu.jpan", "\u1002\u103b\u1015\u1014\u103a\u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "TR", "\u1010\u1030\u101b\u1000\u102e" },
            { "tr", "\u1010\u102c\u1000\u1005\u103a" },
            { "TT", "\u1011\u101b\u102d\u102f\u1004\u103a\u1014\u102e\u1012\u1010\u103a\u1014\u103e\u1004\u1037\u103a\u1010\u102d\u102f\u1018\u102c\u1002\u102d\u102f" },
            { "tt", "\u1010\u1010\u102c" },
            { "TV", "\u1011\u1030\u1038\u1017\u101c\u1030" },
            { "TW", "\u1011\u102d\u102f\u1004\u103a\u101d\u1019\u103a" },
            { "TZ", "\u1010\u1014\u103a\u1007\u1014\u103a\u1038\u1014\u102e\u1038\u101a\u102c\u1038" },
            { "nmg", "\u101d\u102b\u1006\u102e\u1021\u102d\u102f" },
            { "Zzzz", "\u1019\u101e\u102d \u101e\u102d\u102f\u1037\u1019\u101f\u102f\u1010\u103a \u1019\u101b\u103e\u102d\u101e\u1031\u102c \u1005\u1000\u102c\u1038\u101c\u102f\u1036\u1038" },
            { "UA", metaValue_UA },
            { "150", "\u1025\u101b\u1031\u102c\u1015" },
            { "030", "\u1021\u101b\u103e\u1031\u1037\u1015\u102d\u102f\u1004\u103a\u1038 \u1021\u102c\u101b\u103e" },
            { "151", "\u1021\u101b\u103e\u1031\u1037\u1015\u102d\u102f\u1004\u103a\u1038 \u1025\u101b\u1031\u102c\u1015" },
            { "154", "\u1019\u103c\u1031\u102c\u1000\u103a\u1015\u102d\u102f\u1004\u103a\u1038 \u1025\u101b\u1031\u102c\u1015" },
            { "sw_CD", "\u1001\u103d\u1014\u103a\u1002\u102d\u102f \u1005\u103d\u102c\u101f\u102e\u101c\u102e" },
            { "034", "\u1010\u1031\u102c\u1004\u103a\u1015\u102d\u102f\u1004\u103a\u1038 \u1021\u102c\u101b\u103e" },
            { "155", "\u1021\u1014\u1031\u102c\u1000\u103a\u1015\u102d\u102f\u1004\u103a\u1038 \u1025\u101b\u1031\u102c\u1015" },
            { "035", "\u1021\u101b\u103e\u1031\u1037\u1010\u1031\u102c\u1004\u103a\u1015\u102d\u102f\u1004\u103a\u1038\u1021\u102c\u101b\u103e" },
            { "UG", "\u101a\u1030\u1002\u1014\u1039\u1013\u102c" },
            { "ug", "\u101d\u102e\u1002\u102b" },
            { "Kore", metaValue_ko },
            { "Zyyy", "\u1021\u1019\u103b\u102c\u1038\u1014\u103e\u1004\u1037\u103a\u101e\u1000\u103a\u1006\u102d\u102f\u1004\u103a\u101e\u1031\u102c" },
            { "uk", metaValue_UA },
            { "039", "\u1010\u1031\u102c\u1004\u103a\u1015\u102d\u102f\u1004\u103a\u1038 \u1025\u101b\u1031\u102c\u1015" },
            { "Sinh", metaValue_si },
            { "UM", "\u101a\u1030\u1014\u102d\u102f\u1000\u103a\u1010\u1000\u103a\u1005\u1010\u102d\u1010\u103a \u1021\u1015\u103c\u1004\u103a\u1011\u103d\u1000\u103a \u1014\u1031\u101e\u100a\u1037\u103a \u101e\u1031\u1038\u1004\u101a\u103a\u101e\u1031\u102c\u1000\u103b\u103d\u1014\u103a\u1038\u1019\u103b\u102c\u1038" },
            { "ur", "\u1021\u1031\u102c\u103a\u1012\u1030" },
            { "US", "\u101a\u1030\u1014\u102d\u102f\u1000\u103a\u1010\u1000\u103a\u1005\u1010\u102d\u1010\u103a" },
            { "haw", "\u101f\u102c\u101d\u1031\u101a\u1036" },
            { "UY", "\u1025\u101b\u102f\u1002\u103d\u1031\u1038" },
            { "UZ", "\u1025\u1018\u1000\u103a\u1000\u1005\u1039\u1005\u1010\u1014\u103a" },
            { "uz", "\u1026\u1038\u1007\u103a\u1018\u1000\u103a" },
            { "kha", "\u1001\u102b\u1005\u102e" },
            { "tzm", "\u1021\u101c\u101a\u103a\u1021\u1000\u103a\u1010\u103a\u101c\u1000\u103a\u1005\u103a \u1010\u102c\u1019\u102c\u1007\u102d\u102f\u1000\u103a" },
            { "%%1996", "\u1041\u1049\u1049\u1046 \u1002\u103b\u102c\u1019\u1014\u103a \u101b\u1031\u1038\u1011\u102f\u1036\u1038" },
            { "VA", "\u1017\u102c\u1010\u102e\u1000\u1014\u103a\u1005\u102e\u1010\u102e\u1038" },
            { "VC", "\u1005\u102d\u1014\u1037\u103a\u1017\u1004\u1037\u103a\u1006\u1004\u1037\u103a\u1014\u103e\u1004\u1037\u103a \u101e\u100a\u103a\u1002\u101b\u1032\u1014\u102c\u1012\u1004\u103a\u1038\u1005\u103a" },
            { "VE", "\u1017\u1004\u103a\u1014\u102e\u1007\u103d\u1032\u101c\u102c\u1038" },
            { "type.ca.roc", "\u1019\u1004\u103a\u1002\u102f\u1021\u102d\u102f \u1015\u103c\u1000\u1039\u1001\u1012\u102d\u1014\u103a" },
            { "VG", "\u1017\u103c\u102d\u1010\u102d\u101e\u103b\u103e \u1017\u102c\u1002\u103b\u1004\u103a\u1038 \u1000\u103b\u103d\u1014\u103a\u1038\u1005\u102f" },
            { "vi", metaValue_VN },
            { "VI", "\u101a\u1030\u1021\u1000\u103a\u1005\u103a \u1017\u102c\u1002\u103b\u1004\u103a\u1038 \u1000\u103b\u103d\u1014\u103a\u1038\u1005\u102f" },
            { "khq", "\u1001\u102d\u102f\u101b\u102c \u1001\u103b\u102e\u1021\u102e\u1014\u102e" },
            { "key.hc", "\u1014\u102c\u101b\u102e\u1005\u1000\u103a\u101d\u1014\u103a\u1038(\u1041\u1042 \u1021\u1015\u103c\u102d\u102f\u1004\u103a \u1042\u1044)" },
            { "VN", metaValue_VN },
            { "quc", "\u1001\u102e\u1001\u103a\u1021\u102e\u1001\u103b\u102e" },
            { "VU", "\u1017\u102c\u1014\u102f\u1021\u102c\u1010\u1030" },
            { "rwk", "\u101d\u102b" },
            { "gag", "\u1002\u102b\u1002\u102b\u1007\u103a" },
            { "053", "\u1029\u1005\u1010\u103c\u1031\u1038\u101c\u103b\u1014\u103e\u1004\u1037\u103a \u1014\u101a\u1030\u1038\u1007\u102e\u101c\u1014\u103a" },
            { "054", "\u1019\u102e\u101c\u102c\u1014\u102e\u1038\u101b\u103e\u102c\u1038" },
            { "WF", "\u101d\u1031\u102b\u101c\u1005\u103a\u1014\u103e\u1004\u1037\u103a\u1016\u1030\u1011\u1030\u1038\u1014\u102c\u1038" },
            { "Grek", metaValue_GR },
            { "057", "\u1019\u102d\u102f\u1004\u103a\u1001\u101b\u102d\u102f\u1014\u102e\u101b\u103e\u102c\u1038\u1014\u101a\u103a" },
            { "jgo", "\u1002\u103d\u1019\u103a\u1018\u102c" },
            { "lkt", "\u101c\u102c\u1000\u102d\u102f\u1010\u102c" },
            { "wo", "\u101d\u1030\u101c\u102d\u102f\u1016\u103a" },
            { "zgh", "\u1019\u102d\u102f\u101b\u102d\u102f\u1000\u1014\u103a \u1010\u103d\u1019\u103a\u1019\u1007\u102d\u102f\u1010\u103a \u1005\u1036" },
            { "ar_001", "\u1021\u101b\u1031\u1017\u102e(\u1015\u102f\u1036\u1019\u103e\u1014\u103a)" },
            { "WS", "\u1006\u102c\u1019\u102d\u102f\u1021\u102c" },
            { "Mong", "\u1019\u103d\u1014\u103a\u1002\u102d\u102f\u101c\u102e\u1038\u101a\u102c\u1038" },
            { "mnc", "\u1019\u1014\u103a\u1001\u103b\u1030\u1038" },
            { "Latn", metaValue_la },
            { "061", "\u1015\u102d\u102f\u101c\u102e\u1014\u102e\u101b\u103e\u102c\u1038" },
            { "type.nu.hans", "\u101b\u102d\u102f\u1038\u101b\u103e\u1004\u103a\u1038\u101e\u1031\u102c\u1010\u101b\u102f\u1010\u103a\u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "type.nu.hant", "\u101b\u102d\u102f\u1038\u101b\u102c\u1010\u101b\u102f\u1010\u103a\u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "xh", "\u1007\u102d\u102f\u1005\u102c" },
            { "XK", "\u1000\u102d\u102f\u1006\u102d\u102f\u1017\u102d\u102f" },
            { "type.nu.romanlow", "\u101b\u1031\u102c\u1019\u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031\u1021\u101e\u1031\u1038" },
            { "Gujr", "\u1002\u102f\u1002\u103b\u102c\u101b\u101e\u102e" },
            { "Zxxx", "\u1019\u101b\u1031\u1038\u1011\u102c\u1038\u101e\u1031\u102c" },
            { "wbp", "\u101d\u1031\u102b\u101c\u103a\u1015\u102b\u101b\u102e" },
            { "moh", "\u1019\u102d\u102f\u101f\u1031\u102c\u1037\u1001\u103a" },
            { "YE", "\u101a\u102e\u1019\u1004\u103a" },
            { "nqo", "\u1014\u1000\u102d\u102f" },
            { "%%1694ACAD", "\u1041\u1046\u1049\u1044ACAD" },
            { "type.co.standard", "\u1015\u102f\u1036\u1019\u103e\u1014\u103a\u1005\u102e\u101e\u1031\u102c" },
            { "yo", "\u101b\u102d\u102f\u101b\u102f\u1018\u102c" },
            { "YT", "\u1019\u1031\u1021\u102d\u102f\u1010\u102e" },
            { "vai", "\u1017\u102d\u102f\u1004\u103a" },
            { "ZA", "\u1010\u1031\u102c\u1004\u103a\u1021\u102c\u1016\u101b\u102d\u1000" },
            { "type.lb.loose", "\u101c\u103b\u1031\u102c\u1037\u101b\u1032\u101e\u1031\u102c \u101c\u102d\u102f\u1004\u103a\u1038\u1016\u103c\u1010\u103a\u1010\u1031\u102c\u1004\u103a\u1019\u103e\u102f\u1015\u102f\u1036\u1005\u1036" },
            { "kln", "\u1001\u102b\u101c\u102d\u1019\u103a\u1002\u103b\u1004\u103a" },
            { "Deva", "\u1012\u102e\u1017\u1014\u102c\u1002\u101b\u102e" },
            { "zh", metaValue_CN },
            { "type.nu.geor", "\u1014\u102d\u102f\u1004\u103a\u1004\u1036\u1010\u1000\u102c\u101e\u102f\u1036\u1038\u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "Hira", "\u101f\u102d\u101b\u1002\u100f" },
            { "ZM", "\u1007\u1019\u103a\u1018\u102e\u101a\u102c" },
            { "Bopo", "\u1018\u102d\u102f\u1015\u102d\u102f" },
            { "key.lb", "\u101c\u102d\u102f\u1004\u103a\u1038\u1016\u103c\u1010\u103a\u1010\u1031\u102c\u1000\u103a\u1019\u103e\u102f\u1015\u102f\u1036\u1005\u1036" },
            { "zu", "\u1007\u1030\u101c\u1030" },
            { "ZW", "\u1007\u1004\u103a\u1018\u102c\u1018\u103d\u1031" },
            { "type.co.phonebook", "\u1016\u102f\u1014\u103a\u1038\u1005\u102c\u1021\u102f\u1015\u103a \u1021\u1005\u102e\u1021\u1005\u1009\u103a" },
            { "Geor", metaValue_ka },
            { "ZZ", "\u1019\u101e\u102d \u101e\u102d\u102f\u1037\u1019\u101f\u102f\u1010\u103a \u1019\u101b\u103e\u102d \u101e\u1031\u102c \u1014\u1031\u101b\u102c" },
            { "type.ms.metric", "\u1019\u1000\u103a\u1011\u101b\u1005\u103a\u1005\u1014\u1005\u103a" },
            { "type.ca.iso8601", "ISO-8601 \u1015\u103c\u1000\u1039\u1001\u1012\u102d\u1014\u103a" },
            { "type.nu.telu", "\u1010\u102e\u101b\u102e\u1002\u102f\u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "type.nu.jpanfin", "\u1002\u103b\u1015\u1014\u103a\u1018\u100f\u1039\u100f\u102c\u101b\u1031\u1038\u101e\u102f\u1036\u1038\u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "type.nu.mymrshan", "\u101b\u103e\u1019\u103a\u1038\u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "Tglg", "\u1010\u1002\u101c\u1031\u102c\u1037\u1002\u103a" },
            { "ebu", "\u1021\u1019\u103a\u1018\u1030" },
            { "jmc", "\u1019\u1001\u103b\u102c\u1019\u102e" },
            { "zh_Hans", metaValue_Hans },
            { "koi", "\u1000\u102d\u102f\u1019\u102e-\u1015\u102b\u1019\u103c\u1000\u103a" },
            { "type.nu.hansfin", "\u101b\u102d\u102f\u1038\u101b\u103e\u1004\u103a\u1038\u101e\u1031\u102c\u1010\u101b\u102f\u1010\u103a\u1018\u100f\u1039\u100f\u102c\u101b\u1031\u1038\u101e\u102f\u1036\u1038\u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "kok", "\u1000\u103d\u1014\u103a\u1000\u1014\u102e" },
            { "%%1901", "\u101b\u103e\u1031\u1038\u101b\u102d\u102f\u1038\u1005\u1009\u103a\u101c\u102c \u1002\u103b\u102c\u1019\u1014\u103a \u101b\u1031\u1038\u1011\u102f\u1036\u1038" },
            { "type.nu.arabext", "\u1010\u102d\u102f\u1038\u1001\u103b\u1032\u1037\u1021\u102c\u101b\u1015\u103a\u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "nus", "\u1014\u1030\u1021\u102c" },
            { "dak", "\u1012\u102b\u1000\u102d\u102f\u1010\u102c" },
            { "type.nu.fullwide", "\u1021\u1014\u1036\u1021\u1015\u103c\u100a\u1037\u103a\u1014\u103e\u1004\u1037\u103a\u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "dav", "\u1010\u102d\u102f\u1004\u103a\u1010\u102c" },
            { "lrc", "\u1019\u103c\u1031\u102c\u1000\u103a\u101c\u1030\u101b\u102e" },
            { "zh_Hant", metaValue_Hant },
            { "type.nu.khmr", "\u1001\u1019\u102c\u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "%%BAKU1926", "\u1015\u1031\u102b\u1004\u103a\u1038\u1005\u1015\u103a\u1011\u102c\u1038\u101e\u1031\u102c \u1010\u1030\u101b\u1000\u102e \u101c\u1000\u103a\u1010\u1004\u103a\u1005\u1000\u102c\u1038\u101c\u102f\u1036\u1038" },
            { "mua", "\u1019\u1014\u103a\u1012\u1014\u103a\u1038" },
            { "type.nu.guru", "\u1002\u1030\u1019\u1030\u1001\u102e\u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "Khmr", metaValue_km },
            { "mul", "\u1021\u1000\u103c\u102d\u1019\u103a\u1019\u103b\u102c\u1038\u1005\u103d\u102c \u1018\u102c\u101e\u102c\u1005\u1000\u102c\u1038\u1019\u103b\u102c\u1038" },
            { "key.ms", "\u1010\u102d\u102f\u1004\u103a\u1038\u1010\u102c\u101b\u1031\u1038\u1005\u1014\u1005\u103a" },
            { "type.nu.roman", "\u101b\u1031\u102c\u1019\u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "type.nu.tamldec", "\u1010\u1019\u102e\u1038\u101c\u103a\u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "saq", "\u1006\u1014\u103a\u1018\u1030\u101b\u102f" },
            { "key.nu", "\u1002\u100f\u1014\u103a\u1038\u1014\u1036\u1015\u102b\u1010\u103a" },
            { "jpr", "\u1002\u103b\u1030\u1012\u102e\u101a\u102d\u102f-\u1015\u102b\u101b\u103e\u1014\u103a" },
            { "Guru", "\u1002\u1030\u101b\u1030" },
            { "ksb", "\u101b\u103e\u1014\u103a\u1018\u102c\u101c\u102c" },
            { "Telu", "\u1010\u102e\u101c\u102f" },
            { "ksf", "\u1018\u102c\u1016\u102e\u1021\u102c" },
        };
        return data;
    }
}
