/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_nn extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ae = "avestisk";
        final String metaValue_ar = "arabisk";
        final String metaValue_bn = "bengali";
        final String metaValue_bo = "tibetansk";
        final String metaValue_el = "gresk";
        final String metaValue_gu = "gujarati";
        final String metaValue_he = "hebraisk";
        final String metaValue_hy = "armensk";
        final String metaValue_ja = "japansk";
        final String metaValue_jv = "javanesisk";
        final String metaValue_ka = "georgisk";
        final String metaValue_km = "khmer";
        final String metaValue_kn = "kannada";
        final String metaValue_ko = "koreansk";
        final String metaValue_lo = "laotisk";
        final String metaValue_ml = "malayalam";
        final String metaValue_mn = "mongolsk";
        final String metaValue_or = "oriya";
        final String metaValue_su = "sundanesisk";
        final String metaValue_te = "telugu";
        final String metaValue_th = "thai";
        final String metaValue_tl = "tagalog";
        final String metaValue_ban = "balinesisk";
        final String metaValue_bug = "buginesisk";
        final String metaValue_chr = "cherokee";
        final String metaValue_cop = "koptisk";
        final String metaValue_got = "gotisk";
        final String metaValue_nqo = "n\u2019ko";
        final String metaValue_pal = "pahlavi";
        final String metaValue_peo = "gammalpersisk";
        final String metaValue_phn = "f\u00f8nikisk";
        final String metaValue_uga = "ugaritisk";
        final String metaValue_vai = "vai";
        final String metaValue_zbl = "blissymbol";
        final String metaValue_Hans = "forenkla kinesisk";
        final String metaValue_Hant = "tradisjonell kinesisk";
        final Object[][] data = new Object[][] {
            { "Ogam", "ogham" },
            { "mwl", "mirandesisk" },
            { "Zsym", "symbol" },
            { "cch", "atsam" },
            { "mwr", "marwari" },
            { "Tagb", "tagbanwa" },
            { "%%NJIVA", "gniva- og njivadialekt" },
            { "egy", "gammalegyptisk" },
            { "raj", "rajasthani" },
            { "Phag", "phags-pa" },
            { "tem", "temne" },
            { "rap", "rapanui" },
            { "ter", "tereno" },
            { "AC", "Ascension" },
            { "rar", "rarotongansk" },
            { "tet", "tetum" },
            { "AD", "Andorra" },
            { "AE", "Dei sameinte arabiske emirata" },
            { "nl_BE", "flamsk" },
            { "AF", "Afghanistan" },
            { "AG", "Antigua og Barbuda" },
            { "type.ca.ethiopic", "etiopisk kalender" },
            { "AI", "Anguilla" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "Teng", "tengwar" },
            { "AO", "Angola" },
            { "AQ", "Antarktis" },
            { "AR", "Argentina" },
            { "Prti", "inskripsjonsparthisk" },
            { "AS", "Amerikansk Samoa" },
            { "AT", "Austerrike" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "en_US", "engelsk (amerikansk)" },
            { "AX", "\u00c5land" },
            { "AZ", "Aserbajdsjan" },
            { "%%AREVELA", "austarmensk" },
            { "BA", "Bosnia og Hercegovina" },
            { "BB", "Barbados" },
            { "ceb", "cebuansk" },
            { "BD", "Bangladesh" },
            { "kum", "kumyk" },
            { "BE", "Belgia" },
            { "gmh", "mellomh\u00f8gtysk" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaria" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Saint Barth\u00e9lemy" },
            { "BM", "Bermuda" },
            { "kut", "kutenai" },
            { "myv", "erzya" },
            { "BN", "Brunei Darussalam" },
            { "BO", "Bolivia" },
            { "BR", "Brasil" },
            { "BS", "Bahamas" },
            { "BT", "Bhutan" },
            { "BV", "Bouvet\u00f8ya" },
            { "BW", "Botswana" },
            { "BY", "Kviterussland" },
            { "BZ", "Belize" },
            { "Visp", "synleg tale" },
            { "type.ca.persian", "persisk kalender" },
            { "CA", "Canada" },
            { "CC", "Kokos\u00f8yane" },
            { "CD", "Kongo-Kinshasa" },
            { "CF", "Den sentralafrikanske republikken" },
            { "CG", "Kongo-Brazzaville" },
            { "CH", "Sveits" },
            { "CI", "Elfenbeinskysten" },
            { "CK", "Cook\u00f8yane" },
            { "CL", "Chile" },
            { "Kthi", "kaithisk" },
            { "CM", "Kamerun" },
            { "CN", "Kina" },
            { "CO", "Colombia" },
            { "CP", "Clipperton\u00f8ya" },
            { "CR", "Costa Rica" },
            { "CU", "Cuba" },
            { "CV", "Kapp Verde" },
            { "CX", "Christmas\u00f8ya" },
            { "CY", "Kypros" },
            { "CZ", "Tsjekkia" },
            { "eka", "ekajuk" },
            { "DE", "Tyskland" },
            { "goh", "gammalh\u00f8gtysk" },
            { "ace", "achinesisk" },
            { "DG", "Diego Garcia" },
            { "DJ", "Djibouti" },
            { "DK", "Danmark" },
            { "ach", "acoli" },
            { "gon", "gondi" },
            { "Brai", "braille" },
            { "Brah", "brahmi" },
            { "DM", "Dominica" },
            { "DO", "Den dominikanske republikken" },
            { "gor", "gorontalo" },
            { "got", metaValue_got },
            { "Mtei", "meitei-mayek" },
            { "zun", "zuni" },
            { "tig", "tigr\u00e9" },
            { "DZ", "Algerie" },
            { "pag", "pangasinan" },
            { "pal", metaValue_pal },
            { "EA", "Ceuta og Melilla" },
            { "chb", "chibcha" },
            { "pam", "pampanga" },
            { "EC", "Ecuador" },
            { "pap", "papiamento" },
            { "ada", "adangme" },
            { "EE", "Estland" },
            { "tiv", "tivi" },
            { "EG", "Egypt" },
            { "EH", "Vest-Sahara" },
            { "chg", "chagatai" },
            { "pau", "palauisk" },
            { "chk", "chuukesisk" },
            { "chn", "chinook" },
            { "chm", "mari" },
            { "chp", "chipewiansk" },
            { "cho", "choctaw" },
            { "chr", metaValue_chr },
            { "ER", "Eritrea" },
            { "ES", "Spania" },
            { "ET", "Etiopia" },
            { "EU", "Den europeiske unionen" },
            { "elx", "elamittisk" },
            { "type.ca.gregorian", "gregoriansk kalender" },
            { "chy", "cheyenne" },
            { "Inds", "indus" },
            { "ady", "adyghe" },
            { "FI", "Finland" },
            { "FJ", "Fiji" },
            { "FK", "Falklands\u00f8yane" },
            { "FM", "Mikronesiaf\u00f8derasjonen" },
            { "FO", "F\u00e6r\u00f8yane" },
            { "Taml", "tamilsk" },
            { "FR", "Frankrike" },
            { "tkl", "tokelau" },
            { "grb", "grebo" },
            { "root", "rot" },
            { "type.ca.indian", "indisk nasjonalkalender" },
            { "grc", "gammalgresk" },
            { "GA", "Gabon" },
            { "vot", "votisk" },
            { "GB", "Storbritannia" },
            { "GD", "Grenada" },
            { "GE", "Georgia" },
            { "GF", "Fransk Guyana" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "Tale", "tai le" },
            { "GI", "Gibraltar" },
            { "afh", "afrihili" },
            { "GL", "Gr\u00f8nland" },
            { "enm", "mellomengelsk" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadeloupe" },
            { "GQ", "Ekvatorial-Guinea" },
            { "GR", "Hellas" },
            { "GS", "S\u00f8r-Georgia og S\u00f8r-Sandwich-\u00f8yane" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guinea-Bissau" },
            { "tli", "tlingit" },
            { "tlh", "klingon" },
            { "Talu", "ny tai lue" },
            { "GY", "Guyana" },
            { "zxx", "utan spr\u00e5kleg innhald" },
            { "de_AT", "austerriksk tysk" },
            { "Vaii", metaValue_vai },
            { "HK", "Hongkong S.A.R. Kina" },
            { "HM", "Heard- og McDonalds\u00f8yane" },
            { "HN", "Honduras" },
            { "HR", "Kroatia" },
            { "agq", "aghem" },
            { "gsw", "sveitsertysk" },
            { "HT", "Haiti" },
            { "HU", "Ungarn" },
            { "tmh", "tamasjek" },
            { "IC", "Kanari\u00f8yane" },
            { "peo", metaValue_peo },
            { "ID", "Indonesia" },
            { "IE", "Irland" },
            { "nap", "napolitansk" },
            { "zza", "zaza" },
            { "IL", "Israel" },
            { "IM", "Man" },
            { "IN", "India" },
            { "IO", "Britiske omr\u00e5de i Det indiske hav" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Island" },
            { "IT", "Italia" },
            { "Zmth", "matematisk notasjon" },
            { "%%POSIX", "dataspr\u00e5k" },
            { "JE", "Jersey" },
            { "type.ca.islamic", "islamsk kalender" },
            { "Beng", metaValue_bn },
            { "JM", "Jamaica" },
            { "JO", "Jordan" },
            { "JP", "Japan" },
            { "%%1606NICT", "nyare mellomfransk til 1606" },
            { "ain", "ainu" },
            { "tog", "tonga (Nyasa)" },
            { "Kali", "kayah li" },
            { "de_CH", "sveitsisk h\u00f8gtysk" },
            { "type.ca.buddhist", "buddhistisk kalender" },
            { "KE", "Kenya" },
            { "419", "Latin-Amerika" },
            { "KG", "Kirgisistan" },
            { "KH", "Kambodsja" },
            { "KI", "Kiribati" },
            { "KM", "Komorene" },
            { "Knda", metaValue_kn },
            { "KN", "St. Christopher og Nevis" },
            { "Zinh", "nedarva" },
            { "fr_CA", "kanadisk fransk" },
            { "KP", "Nord-Korea" },
            { "KR", "S\u00f8r-Korea" },
            { "Plrd", "pollard-fonetisk" },
            { "fr_CH", "sveitsisk fransk" },
            { "KW", "Kuwait" },
            { "tpi", "tok pisin" },
            { "KY", "Cayman\u00f8yane" },
            { "KZ", "Kasakhstan" },
            { "Cyrl", "kyrillisk" },
            { "LA", "Laos" },
            { "LB", "Libanon" },
            { "phn", metaValue_phn },
            { "LC", "St. Lucia" },
            { "Cyrs", "kyrillisk (kyrkjeslavisk variant)" },
            { "gwi", "gwichin" },
            { "nds", "l\u00e5gtysk" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "akk", "akkadisk" },
            { "cop", metaValue_cop },
            { "LR", "Liberia" },
            { "Phlv", metaValue_pal },
            { "LS", "Lesotho" },
            { "LT", "Litauen" },
            { "LU", "Luxembourg" },
            { "LV", "Latvia" },
            { "Kana", "katakana" },
            { "LY", "Libya" },
            { "lad", "ladinsk" },
            { "lah", "lahnda" },
            { "Thaa", "thaana" },
            { "MA", "Marokko" },
            { "MC", "Monaco" },
            { "MD", "Moldova" },
            { "ME", "Montenegro" },
            { "MF", "Saint Martin" },
            { "lam", "lamba" },
            { "MG", "Madagaskar" },
            { "Thai", metaValue_th },
            { "MH", "Marshall\u00f8yane" },
            { "ale", "aleutisk" },
            { "MK", "Makedonia" },
            { "ML", "Mali" },
            { "MM", "Myanmar" },
            { "MN", "Mongolia" },
            { "new", "newari" },
            { "MO", "Macao S.A.R. Kina" },
            { "MP", "Nord-Marianane" },
            { "MQ", "Martinique" },
            { "MR", "Mauritania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauritius" },
            { "alt", "s\u00f8r-altai" },
            { "MV", "Maldivane" },
            { "MW", "Malawi" },
            { "MX", "Mexico" },
            { "type.ca.japanese", "japansk kalender" },
            { "MY", "Malaysia" },
            { "MZ", "Mosambik" },
            { "Phli", "inskripsjonspahlavi" },
            { "NA", "Namibia" },
            { "type.ca.hebrew", "hebraisk kalender" },
            { "NC", "Ny-Caledonia" },
            { "NE", "Niger" },
            { "NF", "Norfolk\u00f8yane" },
            { "NG", "Nigeria" },
            { "Phlp", "salmepahlavi" },
            { "NI", "Nicaragua" },
            { "Hmng", "pahawk hmong" },
            { "NL", "Nederland" },
            { "NO", "Noreg" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "Phnx", metaValue_phn },
            { "NU", "Niue" },
            { "rof", "rombo" },
            { "tsi", "tsimshian" },
            { "NZ", "New Zealand" },
            { "rom", "romani" },
            { "Mero", "meroitisk" },
            { "crh", "krimtatarisk" },
            { "ang", "gammalengelsk" },
            { "OM", "Oman" },
            { "anp", "angika" },
            { "Xpeo", metaValue_peo },
            { "PA", "Panama" },
            { "type.ca.islamic-civil", "islamsk sivil kalender" },
            { "csb", "kasjubisk" },
            { "en_GB", "britisk engelsk" },
            { "PE", "Peru" },
            { "PF", "Fransk Polynesia" },
            { "PG", "Papua Ny-Guinea" },
            { "PH", "Filippinane" },
            { "PK", "Pakistan" },
            { "PL", "Polen" },
            { "ewo", "ewondo" },
            { "PM", "St. Pierre og Miquelon" },
            { "PN", "Pitcairn" },
            { "PR", "Puerto Rico" },
            { "Bali", metaValue_ban },
            { "PS", "Palestinsk territorium" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "nia", "nias" },
            { "PY", "Paraguay" },
            { "tum", "tumbuka" },
            { "Hebr", metaValue_he },
            { "QA", "Qatar" },
            { "%%SCOTLAND", "skotsk standard engelsk" },
            { "niu", "niueansk" },
            { "QO", "Ytre Oseania" },
            { "lez", "lezghian" },
            { "%%FONUPA", "det uralske fonetiske alfabetet UPA" },
            { "tvl", "tuvalu" },
            { "Tavt", "tai viet" },
            { "001", "verda" },
            { "002", "Afrika" },
            { "003", "Nord-Amerika" },
            { "RE", "R\u00e9union" },
            { "005", "S\u00f8r-Amerika" },
            { "jbo", "lojban" },
            { "Rjng", "rejang" },
            { "009", "Oseania" },
            { "RO", "Romania" },
            { "RS", "Serbia" },
            { "RU", "Russland" },
            { "RW", "Rwanda" },
            { "Ugar", metaValue_uga },
            { "Mani", "manikeisk" },
            { "Khar", "kharoshthi" },
            { "SA", "Saudi Arabia" },
            { "pon", "ponapisk" },
            { "Mand", "mandaisk" },
            { "SB", "Salomon\u00f8yane" },
            { "twq", "tasawaq" },
            { "011", "Vest-Afrika" },
            { "SC", "Seychellane" },
            { "SD", "Sudan" },
            { "013", "Sentral-Amerika" },
            { "SE", "Sverige" },
            { "014", "Aust-Afrika" },
            { "arc", "arameisk" },
            { "015", "Nord-Afrika" },
            { "SG", "Singapore" },
            { "SH", "Saint Helena" },
            { "017", "Sentral-Afrika" },
            { "SI", "Slovenia" },
            { "018", "S\u00f8rlege Afrika" },
            { "SJ", "Svalbard og Jan Mayen" },
            { "019", "Amerika" },
            { "SK", "Slovakia" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "arn", "araukansk" },
            { "arp", "arapaho" },
            { "SR", "Surinam" },
            { "ST", "S\u00e3o Tom\u00e9 og Pr\u00edncipe" },
            { "SV", "El Salvador" },
            { "SY", "Syria" },
            { "yao", "yao" },
            { "SZ", "Swaziland" },
            { "arw", "arawak" },
            { "yap", "yapesisk" },
            { "TA", "Tristan da Cunha" },
            { "asa", "asu (Tanzania)" },
            { "021", "nordlege Amerika" },
            { "TC", "Turks- og Caicos\u00f8yane" },
            { "yav", "yangben" },
            { "TD", "Tchad" },
            { "TF", "Franske s\u00f8romr\u00e5de" },
            { "TG", "Togo" },
            { "TH", "Thailand" },
            { "TJ", "Tadsjikistan" },
            { "029", "Karibia" },
            { "TK", "Tokelau" },
            { "TL", "Aust-Timor" },
            { "TM", "Turkmenistan" },
            { "%%BOONT", "boontling" },
            { "TN", "Tunisia" },
            { "TO", "Tonga" },
            { "TR", "Tyrkia" },
            { "TT", "Trinidad og Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "ast", "asturisk" },
            { "Orkh", "orkhon" },
            { "TZ", "Tanzania" },
            { "nmg", "kwasio" },
            { "Zzzz", "ukjend skrift" },
            { "UA", "Ukraina" },
            { "rup", "aromansk" },
            { "030", "Aust-Asia" },
            { "tyv", "tuvinisk" },
            { "034", "S\u00f8r-Asia" },
            { "hai", "haida" },
            { "035", "S\u00f8raust-Asia" },
            { "UG", "Uganda" },
            { "type.co.pinyin", "pinyin-sortering" },
            { "039", "S\u00f8r-Europa" },
            { "Sinh", "sinhala" },
            { "UM", "USAs ytre sm\u00e5\u00f8yar" },
            { "US", "USA" },
            { "haw", "hawaiisk" },
            { "type.co.gb2312han", "forenkla kinesisk sortering" },
            { "UY", "Uruguay" },
            { "UZ", "Usbekistan" },
            { "type.co.stroke", "streksortering" },
            { "VA", "Vatikanstaten" },
            { "pro", "gammalproven\u00e7alsk" },
            { "VC", "St. Vincent og Grenadinane" },
            { "VE", "Venezuela" },
            { "VG", "Dei britiske jomfru\u00f8yane" },
            { "VI", "Dei amerikanske jomfru\u00f8yane" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "nog", "nogai" },
            { "rwk", "rwa" },
            { "non", "gammalnorsk" },
            { "053", "Australia og New Zealand" },
            { "%%AREVMDA", "vestarmensk" },
            { "054", "Melanesia" },
            { "WF", "Wallis og Futuna" },
            { "type.co.traditional", "tradisjonell sortering" },
            { "057", "Mikronesia" },
            { "WS", "Samoa" },
            { "wal", "walamo" },
            { "was", "washo" },
            { "war", "waray" },
            { "awa", "awadhi" },
            { "061", "Polynesia" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "kode for spr\u00e5k utan skrift" },
            { "Olck", "ol-chiki" },
            { "Batk", "batak" },
            { "Blis", metaValue_zbl },
            { "YE", "Yemen" },
            { "nqo", metaValue_nqo },
            { "fan", "fang" },
            { "%%ROZAJ", "resisk dialekt" },
            { "fat", "fanti" },
            { "Sgnw", "teiknskrift" },
            { "YT", "Mayotte" },
            { "ZA", "S\u00f8r-Afrika" },
            { "Deva", "devanagari" },
            { "Hira", "hiragana" },
            { "ZM", "Zambia" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "ukjent omr\u00e5de" },
            { "Runr", "runer" },
            { "lol", "mongo" },
            { "nso", "nordsotho" },
            { "loz", "lozi" },
            { "hil", "hiligaynon" },
            { "nus", "nuer" },
            { "dak", "dakota" },
            { "hit", "hettittisk" },
            { "dar", "dargwa" },
            { "Maya", "maya-hieroglyfar" },
            { "Copt", metaValue_cop },
            { "nwc", "klassisk newarisk" },
            { "udm", "udmurt" },
            { "Khmr", metaValue_km },
            { "Limb", "lumbu" },
            { "sad", "sandawe" },
            { "sah", "jakutsk" },
            { "sam", "samaritansk arameisk" },
            { "%%SCOUSE", "scouse-dialekt" },
            { "sas", "sasak" },
            { "sat", "santali" },
            { "Tfng", "tifinagh" },
            { "jpr", "j\u00f8depersisk" },
            { "Guru", "gurmukhi" },
            { "lua", "luba-lulua" },
            { "sbp", "sangu" },
            { "lui", "luiseno" },
            { "nyn", "nyankole" },
            { "nym", "nyamwezi" },
            { "lun", "lunda" },
            { "nyo", "nyoro" },
            { "luo", "luo" },
            { "fil", "filippinsk" },
            { "hmn", "hmong" },
            { "del", "delaware" },
            { "lus", "lushai" },
            { "bal", "baluchi" },
            { "den", "slavej" },
            { "ban", metaValue_ban },
            { "uga", metaValue_uga },
            { "bas", "basa" },
            { "jrb", "j\u00f8dearabisk" },
            { "es_ES", "iberisk spansk" },
            { "nzi", "nzima" },
            { "sco", "skotsk" },
            { "scn", "siciliansk" },
            { "aa", "afar" },
            { "ab", "abkhasisk" },
            { "ae", metaValue_ae },
            { "af", "afrikaans" },
            { "ak", "akan" },
            { "am", "amharisk" },
            { "Arab", metaValue_ar },
            { "an", "aragonsk" },
            { "%%SOLBA", "stolvizza- og solbicadialekt" },
            { "Jpan", metaValue_ja },
            { "ar", metaValue_ar },
            { "Hrkt", "katakana eller hiragana" },
            { "as", "assamisk" },
            { "Lina", "line\u00e6r A" },
            { "av", "avarisk" },
            { "Linb", "line\u00e6r B" },
            { "ay", "aymara" },
            { "az", "aserbajdsjansk" },
            { "%%OSOJS", "oseacco- og osojanedialekt" },
            { "ba", "basjkirsk" },
            { "be", "kviterussisk" },
            { "bg", "bulgarsk" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "dgr", "dogrib" },
            { "br", "bretonsk" },
            { "bs", "bosnisk" },
            { "Mymr", "myanmar" },
            { "Nkoo", metaValue_nqo },
            { "sel", "selkupisk" },
            { "ca", "katalansk" },
            { "ce", "tsjetsjensk" },
            { "ch", "chamorro" },
            { "%%REVISED", "revidert rettskriving" },
            { "co", "korsikansk" },
            { "Orya", metaValue_or },
            { "cr", "cree" },
            { "cs", "tsjekkisk" },
            { "cu", "kyrkjeslavisk" },
            { "cv", "tsjuvansk" },
            { "cy", "walisisk" },
            { "Yiii", "yi" },
            { "da", "dansk" },
            { "pt_PT", "europeisk portugisisk" },
            { "de", "tysk" },
            { "bej", "beja" },
            { "din", "dinka" },
            { "Bugi", metaValue_bug },
            { "bem", "bemba" },
            { "sga", "gammalirsk" },
            { "dv", "divehi" },
            { "es_419", "latinamerikansk spansk" },
            { "dz", "dzongkha" },
            { "bez", "bena (Tanzania)" },
            { "type.ca.chinese", "kinesisk kalender" },
            { "dje", "zarma" },
            { "ee", "ewe" },
            { "ro_MD", "moldavisk" },
            { "el", metaValue_el },
            { "en", "engelsk" },
            { "eo", "esperanto" },
            { "type.co.big5han", "tradisjonell kinesisk sortering" },
            { "es", "spansk" },
            { "et", "estisk" },
            { "eu", "baskisk" },
            { "Buhd", "buhid" },
            { "Hang", "hangul" },
            { "Samr", "samaritansk" },
            { "hsb", "h\u00f8gsorbisk" },
            { "Hani", "han" },
            { "shn", "shan" },
            { "Hano", "hanunoo" },
            { "fa", "persisk" },
            { "Hans", metaValue_Hans },
            { "Hant", metaValue_Hant },
            { "ff", "fulani" },
            { "fi", "finsk" },
            { "fj", "fijiansk" },
            { "fon", "fon" },
            { "yue", "kantonesisk" },
            { "fo", "f\u00e6r\u00f8ysk" },
            { "umb", "umbundu" },
            { "fr", "fransk" },
            { "sid", "sidamo" },
            { "fy", "vestfrisisk" },
            { "ga", "irsk" },
            { "gd", "skotsk-g\u00e6lisk" },
            { "gl", "galicisk" },
            { "gn", "guarani" },
            { "bho", "bhojpuri" },
            { "und", "ukjent spr\u00e5k" },
            { "type.ca.ethiopic-amete-alem", "etiopisk amete-alem-kalender" },
            { "gu", metaValue_gu },
            { "gv", "manx" },
            { "ha", "hausa" },
            { "he", metaValue_he },
            { "hi", "hindi" },
            { "hup", "hupa" },
            { "bik", "bikol" },
            { "bin", "bini" },
            { "ho", "hiri motu" },
            { "hr", "kroatisk" },
            { "ht", "haitisk" },
            { "hu", "ungarsk" },
            { "hy", metaValue_hy },
            { "hz", "herero" },
            { "%%FONIPA", "det internasjonale fonetiske alfabetet (IPA)" },
            { "ia", "interlingua" },
            { "id", "indonesisk" },
            { "ie", "interlingue" },
            { "ig", "ibo" },
            { "ii", "sichuan-yi" },
            { "frm", "mellomfransk" },
            { "ik", "inupiak" },
            { "fro", "gammalfransk" },
            { "io", "ido" },
            { "frs", "austfrisisk" },
            { "frr", "nordfrisisk" },
            { "is", "islandsk" },
            { "it", "italiensk" },
            { "iu", "inuktitut" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "Sara", "sarati" },
            { "doi", "dogri" },
            { "sma", "s\u00f8rsamisk" },
            { "jv", metaValue_jv },
            { "Shaw", "shavisk" },
            { "mad", "maduresisk" },
            { "smj", "lulesamisk" },
            { "mag", "magahi" },
            { "mai", "maithili" },
            { "smn", "enaresamisk" },
            { "ka", metaValue_ka },
            { "bla", "siksika" },
            { "mak", "makasar" },
            { "sms", "skoltesamisk" },
            { "man", "mandingo" },
            { "kg", "kikongo" },
            { "Goth", metaValue_got },
            { "ki", "kikuyu" },
            { "mas", "masai" },
            { "kj", "kuanyama" },
            { "kk", "kasakhisk" },
            { "kl", "kalaallisut; gr\u00f8nlandsk" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "kanuri" },
            { "ks", "kasjmiri" },
            { "Cirt", "cirth" },
            { "Lepc", "lepcha" },
            { "Avst", metaValue_ae },
            { "ku", "kurdisk" },
            { "kv", "komi" },
            { "kw", "kornisk" },
            { "ky", "kirgisisk" },
            { "snk", "soninke" },
            { "la", "latin" },
            { "lb", "luxemburgsk" },
            { "lg", "ganda" },
            { "Roro", "rongorongo" },
            { "li", "limburgisk" },
            { "Tibt", metaValue_bo },
            { "ln", "lingala" },
            { "fur", "friuliansk" },
            { "lo", metaValue_lo },
            { "lt", "litauisk" },
            { "lu", "luba-katanga" },
            { "lv", "latvisk" },
            { "sog", "sogdisk" },
            { "mg", "madagassisk" },
            { "mh", "marshallesisk" },
            { "type.co.ducet", "grunnleggjande Unicode-sorteringsrekkjef\u00f8lgje" },
            { "mi", "maori" },
            { "mk", "makedonsk" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "marathi" },
            { "ms", "malayisk" },
            { "mt", "maltesisk" },
            { "my", "burmesisk" },
            { "Saur", "saurashtra" },
            { "Armn", metaValue_hy },
            { "mdf", "moksha" },
            { "dsb", "l\u00e5gsorbisk" },
            { "Armi", "armisk" },
            { "na", "nauru" },
            { "type.co.search", "s\u00f8ksorteringsrekkjef\u00f8lgje etter CLDR" },
            { "nb", "bokm\u00e5l" },
            { "nd", "nord-ndebele" },
            { "ne", "nepalsk" },
            { "ng", "ndonga" },
            { "mdr", "mandar" },
            { "nl", "nederlandsk" },
            { "nn", "nynorsk" },
            { "no", "norsk" },
            { "nr", "s\u00f8r-ndebele" },
            { "nv", "navajo" },
            { "kaa", "karakalpakisk" },
            { "ny", "nyanja" },
            { "kac", "kachin" },
            { "kab", "kabylsk" },
            { "%%POLYTON", "polytonisk rettskriving" },
            { "oc", "oksitansk" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "men", "mende" },
            { "oj", "ojibwa" },
            { "om", "oromo" },
            { "kaw", "kawi" },
            { "or", metaValue_or },
            { "os", "ossetisk" },
            { "kbd", "kabardisk" },
            { "srn", "sranan tongo" },
            { "pa", "panjabi" },
            { "dua", "duala" },
            { "srr", "serer" },
            { "%%LIPAW", "resian, lipovazdialekt" },
            { "pi", "pali" },
            { "pl", "polsk" },
            { "dum", "mellumnederlandsk" },
            { "ps", "pashto" },
            { "pt", "portugisisk" },
            { "mga", "mellomirsk" },
            { "key.co", "kollasjon" },
            { "pt_BR", "brasiliansk portugisisk" },
            { "kcg", "tyap" },
            { "bra", "braj" },
            { "key.ca", "kalender" },
            { "Laoo", metaValue_lo },
            { "qu", "quechua" },
            { "zap", "zapotec" },
            { "brx", "bodo" },
            { "Lana", "lanna" },
            { "Ethi", "etiopisk" },
            { "rm", "retoromansk" },
            { "rn", "rundi" },
            { "key.cu", "valuta" },
            { "ro", "rumensk" },
            { "%%SAAHO", "saaho-dialekt" },
            { "ru", "russisk" },
            { "zbl", metaValue_zbl },
            { "rw", "kinjarwanda" },
            { "kea", "kapverdisk" },
            { "mic", "micmac" },
            { "suk", "sukuma" },
            { "en_AU", "australisk engelsk" },
            { "sa", "sanskrit" },
            { "sc", "sardinsk" },
            { "sus", "susu" },
            { "sd", "sindhi" },
            { "se", "nordsamisk" },
            { "min", "minangkabau" },
            { "sg", "sango" },
            { "sh", "serbokroatisk" },
            { "si", "singalesisk" },
            { "sux", "sumerisk" },
            { "sk", "slovakisk" },
            { "sl", "slovensk" },
            { "sm", "samoansk" },
            { "sn", "shona" },
            { "so", "somali" },
            { "sq", "albansk" },
            { "sr", "serbisk" },
            { "ss", "swati" },
            { "Java", metaValue_jv },
            { "st", "s\u00f8rsotho" },
            { "su", metaValue_su },
            { "%%NEDIS", "natisonedialekt" },
            { "sv", "svensk" },
            { "sw", "swahili" },
            { "iba", "iban" },
            { "ta", "tamil" },
            { "142", "Asia" },
            { "bua", "burjatisk" },
            { "143", "Sentral-Asia" },
            { "te", metaValue_te },
            { "145", "Vest-Asia" },
            { "tg", "tatsjikisk" },
            { "th", metaValue_th },
            { "bug", metaValue_bug },
            { "ti", "tigrinja" },
            { "kfo", "koro" },
            { "en_CA", "kanadisk engelsk" },
            { "tk", "turkmensk" },
            { "tl", metaValue_tl },
            { "tn", "tswana" },
            { "to", "tonga (Tonga-\u00f8yane)" },
            { "dyo", "jola-fonyi" },
            { "tr", "tyrkisk" },
            { "ts", "tsonga" },
            { "swb", "shimaore" },
            { "Cakm", "chakma" },
            { "tt", "tatarisk" },
            { "dyu", "dyula" },
            { "tw", "twi" },
            { "ty", "tahitisk" },
            { "%%BISKE", "san giorgio- og biladialekt" },
            { "150", "Europa" },
            { "151", "Aust-Europa" },
            { "154", "Nord-Europa" },
            { "155", "Vest-Europa" },
            { "ug", "uigurisk" },
            { "Kore", metaValue_ko },
            { "Ital", "gammalitalisk" },
            { "Zyyy", "felles" },
            { "uk", "ukrainsk" },
            { "ur", "urdu" },
            { "%%1994", "standardisert resisk ortografi" },
            { "xal", "kalmyk" },
            { "zen", "zenaga" },
            { "uz", "usbekisk" },
            { "kha", "khasi" },
            { "%%1996", "tysk ortografi fr\u00e5 1996" },
            { "Sylo", "syloti nagri" },
            { "ve", "venda" },
            { "type.ca.roc", "kalender for Republikken Kina" },
            { "vi", "vietnamesisk" },
            { "kho", "khotanesisk" },
            { "%%TARASK", "taraskievica-ortografi" },
            { "vo", "volapyk" },
            { "syc", "klassisk syrisk" },
            { "Osma", "osmanya" },
            { "gaa", "ga" },
            { "wa", "vallonsk" },
            { "syr", "syrisk" },
            { "Grek", metaValue_el },
            { "Lydi", "lydisk" },
            { "Xsux", "sumero-akkadisk kileskrift" },
            { "wo", "wolof" },
            { "Cans", "felles kanadiske urspr\u00e5ksstavingar" },
            { "gay", "gayo" },
            { "Mong", metaValue_mn },
            { "mnc", "mandsju" },
            { "Latf", "latinsk (frakturvariant)" },
            { "gba", "gbaya" },
            { "mni", "manipuri" },
            { "Latn", "latinsk" },
            { "Latg", "latinsk (g\u00e6lisk variant)" },
            { "xh", "xhosa" },
            { "byn", "blin" },
            { "Lyci", "lykisk" },
            { "osa", "osage" },
            { "Moon", "moon" },
            { "moh", "mohawk" },
            { "%%1694ACAD", "eldre nyfransk" },
            { "yi", "jiddisk" },
            { "mos", "mossi" },
            { "Syrc", "syriakisk" },
            { "Dsrt", "deseret" },
            { "yo", "joruba" },
            { "Syrj", "syriakisk (vestleg variant)" },
            { "ota", "ottomansk tyrkisk" },
            { "Syre", "syriakisk (estrangelo-variant)" },
            { "vai", metaValue_vai },
            { "za", "zhuang" },
            { "Cari", "karisk" },
            { "zh", "kinesisk" },
            { "Bopo", "bopomofo" },
            { "Perm", "gammalpermisk" },
            { "zu", "zulu" },
            { "type.co.phonebook", "telefonkatalogsortering" },
            { "%%MONOTON", "monotonisk rettskriving" },
            { "Geor", metaValue_ka },
            { "kmb", "kimbundu" },
            { "Cham", "cham" },
            { "gez", "ges" },
            { "Syrn", "syriakisk (austleg variant)" },
            { "Tglg", metaValue_tl },
            { "Egyd", "egyptisk demotisk" },
            { "Egyh", "egyptisk hieratisk" },
            { "ebu", "kiembu" },
            { "Egyp", "egyptiske hieroglyfar" },
            { "Geok", "khutsuri (asomtavruli og nuskhuri)" },
            { "zh_Hans", metaValue_Hans },
            { "Hung", "gammalungarsk" },
            { "kok", "konkani" },
            { "%%1901", "tradisjonell tysk ortografi" },
            { "kos", "kosraeansk" },
            { "zh_Hant", metaValue_Hant },
            { "Sund", metaValue_su },
            { "kpe", "kpelle" },
            { "ilo", "iloko" },
            { "%%VALENCIA", "valensisk dialekt" },
            { "Cprt", "kypriotisk" },
            { "%%BAKU1926", "samla tyrkisk-latinsk alfabet" },
            { "mua", "mundang" },
            { "mul", "fleire spr\u00e5k" },
            { "cad", "caddo" },
            { "mus", "creek" },
            { "Glag", "glagolittisk" },
            { "gil", "kiribatisk" },
            { "Cher", metaValue_chr },
            { "car", "karibisk" },
            { "krc", "karachay-balkar" },
            { "inh", "ingusjisk" },
            { "krl", "karelsk" },
            { "efi", "efik" },
            { "key.nu", "tal" },
            { "kru", "kurukh" },
            { "Telu", metaValue_te },
            { "ksf", "bafia" },
        };
        return data;
    }
}
