/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_sr_Latn extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_NR = "Nauru";
        final String metaValue_TK = "Tokelau";
        final String metaValue_TV = "Tuvalu";
        final String metaValue_key_colAlternate = "Sortiranje uz ignorisanje simbola";
        final Object[][] data = new Object[][] {
            { "Ogam", "ogamsko pismo" },
            { "mwl", "Mirande\u0161ki" },
            { "key.colStrength", "Sortiranje prema ja\u010dini" },
            { "Zsym", "simboli" },
            { "cch", "Atsamski" },
            { "mwr", "Marvari" },
            { "Tagb", "tagbanva pismo" },
            { "%%NJIVA", "Gnjiva/Njiva dijalkekt" },
            { "egy", "Staroegipatski" },
            { "raj", "Ra\u0111astani" },
            { "Phag", "pags-pa pismo" },
            { "tem", "Timne" },
            { "teo", "teso" },
            { "rap", "Rapanui" },
            { "ter", "Tereno" },
            { "AC", "Ostrvo Asension" },
            { "rar", "Rarotongan" },
            { "tet", "Tetum" },
            { "AD", "Andora" },
            { "AE", "Ujedinjeni Arapski Emirati" },
            { "nl_BE", "flamanski" },
            { "AF", "Avganistan" },
            { "AG", "Antigva i Barbuda" },
            { "type.ca.ethiopic", "etiopski kalendar" },
            { "AI", "Angvila" },
            { "key.tz", "Vremenska zona" },
            { "AL", "Albanija" },
            { "AM", "Jermenija" },
            { "Teng", "tengvar pismo" },
            { "AO", "Angola" },
            { "AQ", "Antarktik" },
            { "AR", "Argentina" },
            { "Prti", "pisani partian" },
            { "AS", "Ameri\u010dka Samoa" },
            { "AT", "Austrija" },
            { "AU", "Australija" },
            { "AW", "Aruba" },
            { "AX", "Olandska ostrva" },
            { "key.colNormalization", "Normalizovano sortiranje" },
            { "AZ", "Azerbejd\u017ean" },
            { "%%AREVELA", "Isto\u010dni armenijski" },
            { "BA", "Bosna i Hercegovina" },
            { "BB", "Barbados" },
            { "ceb", "Cebuano" },
            { "BD", "Banglade\u0161" },
            { "kum", "Kumik" },
            { "BE", "Belgija" },
            { "gmh", "Srednji visoki nema\u010dki" },
            { "BF", "Burkina Faso" },
            { "BG", "Bugarska" },
            { "BH", "Bahrein" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Sveti Bartolomej" },
            { "BM", "Bermuda" },
            { "kut", "Kutenai" },
            { "myv", "Erzija" },
            { "BN", "Brunej" },
            { "BO", "Bolivija" },
            { "BQ", "Karipska Holandija" },
            { "BR", "Brazil" },
            { "BS", "Bahami" },
            { "xog", "soga" },
            { "BT", "Butan" },
            { "BV", "Ostrvo Buve" },
            { "BW", "Bocvana" },
            { "BY", "Belorusija" },
            { "BZ", "Belize" },
            { "Visp", "vidljivi govor" },
            { "type.ca.persian", "persijski kalendar" },
            { "type.nu.hebr", "hebrejski brojevi" },
            { "CA", "Kanada" },
            { "CC", "Kokosova (Kilingova) Ostrva" },
            { "mzn", "mazanderanski" },
            { "CD", "Kongo - Kin\u0161asa" },
            { "CF", "Centralnoafri\u010dka Republika" },
            { "CG", "Kongo - Brazavil" },
            { "CH", "\u0160vajcarska" },
            { "CI", "Obala Slonova\u010de" },
            { "CK", "Kukova Ostrva" },
            { "CL", "\u010cile" },
            { "Kthi", "kaiti" },
            { "CM", "Kamerun" },
            { "CN", "Kina" },
            { "CO", "Kolumbija" },
            { "CP", "Ostrvo Kliperton" },
            { "CR", "Kostarika" },
            { "CU", "Kuba" },
            { "CV", "Zelenortska Ostrva" },
            { "CW", "Kurasao" },
            { "CX", "Bo\u017ei\u0107no ostrvo" },
            { "CY", "Kipar" },
            { "CZ", "\u010ce\u0161ka" },
            { "eka", "Ekajuk" },
            { "DE", "Nema\u010dka" },
            { "goh", "Staronema\u010dki" },
            { "ace", "A\u010dineski" },
            { "cgg", "\u010diga" },
            { "DG", "Dijego Garsija" },
            { "type.nu.deva", "devangari cifre" },
            { "DJ", "D\u017eibuti" },
            { "type.colNumeric.no", "Sortiraj cifre pojedina\u010dno" },
            { "DK", "Danska" },
            { "ach", "Akoli" },
            { "gon", "Gondi" },
            { "Brai", "Brajevo pismo" },
            { "Brah", "bramansko pismo" },
            { "DM", "Dominika" },
            { "type.nu.armnlow", "mali jermenski brojevi" },
            { "DO", "Dominikanska Republika" },
            { "gor", "Gorontalo" },
            { "got", "Gotski" },
            { "Mtei", "meitei majek pismo" },
            { "key.variableTop", "Sortiraj kao simbole" },
            { "zun", "Zuni" },
            { "tig", "Tigre" },
            { "DZ", "Al\u017eir" },
            { "pag", "Pangasinski" },
            { "pal", "Pahlavi" },
            { "EA", "Seuta i Melilja" },
            { "chb", "\u010cib\u010da" },
            { "pam", "Pampanga" },
            { "EC", "Ekvador" },
            { "pap", "Papiamento" },
            { "ada", "Adangmejski" },
            { "EE", "Estonija" },
            { "tiv", "Tiv" },
            { "EG", "Egipat" },
            { "EH", "Zapadna Sahara" },
            { "chg", "\u010cagatai" },
            { "pau", "Palauanski" },
            { "type.colNormalization.yes", "Sortiraj Unicode normalizovano" },
            { "chk", "\u010cukeski" },
            { "chn", "\u010cinukski" },
            { "chm", "Mari" },
            { "chp", "\u010cipvijanski" },
            { "cho", "\u010coktavski" },
            { "chr", "\u010deroki" },
            { "ER", "Eritreja" },
            { "ES", "\u0160panija" },
            { "ET", "Etiopija" },
            { "EU", "Evropska Unija" },
            { "elx", "Elamitski" },
            { "type.ca.gregorian", "gregorijanski kalendar" },
            { "chy", "\u010cejenski" },
            { "type.nu.gujr", "gud\u017earatske cifre" },
            { "Inds", "indu\u0161ko pismo" },
            { "ady", "Adigejski" },
            { "FI", "Finska" },
            { "FJ", "Fid\u017ei" },
            { "FK", "Foklandska ostrva" },
            { "FM", "Mikronezija" },
            { "key.va", "Varijanta lokaliteta" },
            { "FO", "Farska Ostrva" },
            { "Taml", "tamilsko pismo" },
            { "FR", "Francuska" },
            { "tkl", metaValue_TK },
            { "grb", "Grebo" },
            { "root", "Rut" },
            { "type.ca.indian", "Indijski nacionalni kalendar" },
            { "grc", "Starogr\u010dki" },
            { "GA", "Gabon" },
            { "vot", "Votski" },
            { "GB", "Velika Britanija" },
            { "GD", "Grenada" },
            { "GE", "Gruzija" },
            { "GF", "Francuska Gvajana" },
            { "GG", "Gurnsi" },
            { "GH", "Gana" },
            { "Tale", "tai le pismo" },
            { "GI", "Gibraltar" },
            { "afh", "Afrihili" },
            { "GL", "Grenland" },
            { "enm", "Srednji engleski" },
            { "GM", "Gambija" },
            { "GN", "Gvineja" },
            { "GP", "Gvadelupe" },
            { "GQ", "Ekvatorijalna Gvineja" },
            { "GR", "Gr\u010dka" },
            { "GS", "Ju\u017ena D\u017eord\u017eija i Ju\u017ena Sendvi\u010d Ostrva" },
            { "GT", "Gvatemala" },
            { "GU", "Guam" },
            { "GW", "Gvineja-Bisao" },
            { "tli", "Tlingit" },
            { "tlh", "Klingonski" },
            { "Talu", "novi tai lue" },
            { "GY", "Gvajana" },
            { "ckb", "sorani kurdski" },
            { "zxx", "bez lingvisti\u010dkog sadr\u017eaja" },
            { "HK", "SAR Hongkong (Kina)" },
            { "Vaii", "vai pismo" },
            { "HM", "Ostrva Herd i Mekdonald" },
            { "HN", "Honduras" },
            { "HR", "Hrvatska" },
            { "agq", "agem" },
            { "gsw", "\u0160vajcarski nema\u010dki" },
            { "HT", "Haiti" },
            { "HU", "Ma\u0111arska" },
            { "tmh", "Tama\u0161ek" },
            { "IC", "Kanarska ostrva" },
            { "ID", "Indonezija" },
            { "peo", "Staropersijski" },
            { "IE", "Irska" },
            { "nap", "Neapolitanski" },
            { "naq", "nama" },
            { "zza", "Zaza" },
            { "IL", "Izrael" },
            { "IM", "Ostrvo Man" },
            { "IN", "Indija" },
            { "IO", "Britanska teritorija u Indijskom okeanu" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Island" },
            { "IT", "Italija" },
            { "Zmth", "matemati\u010dka notacija" },
            { "type.nu.thai", "tajske cifre" },
            { "%%POSIX", "Kompjuter" },
            { "type.nu.beng", "bengalske cifre" },
            { "JE", "D\u017eersi" },
            { "type.ca.islamic", "islamski kalendar" },
            { "JM", "Jamajka" },
            { "Beng", "bengalsko pismo" },
            { "JO", "Jordan" },
            { "JP", "Japan" },
            { "%%1606NICT", "Francuski iz kasnog srednjeg veka do 1606." },
            { "ain", "Ainu" },
            { "guz", "gusi" },
            { "tog", "Njasa tonga" },
            { "type.nu.knda", "kanada cifre" },
            { "Kali", "kajah-li pismo" },
            { "de_CH", "\u0161vajcarski visoki nema\u010dki" },
            { "type.co.phonetic", "Fonetski redosled sortiranja" },
            { "type.ca.buddhist", "budisti\u010dki kalendar" },
            { "KE", "Kenija" },
            { "419", "Latinska Amerika" },
            { "KG", "Kirgistan" },
            { "KH", "Kambod\u017ea" },
            { "KI", "Kiribati" },
            { "KM", "Komorska Ostrva" },
            { "KN", "Sent Kits i Nevis" },
            { "Knda", "kanada pismo" },
            { "Zinh", "nasledno pismo" },
            { "KP", "Severna Koreja" },
            { "KR", "Ju\u017ena Koreja" },
            { "Plrd", "porald fonetsko pismo" },
            { "KW", "Kuvajt" },
            { "tpi", "Tok Pisin" },
            { "KY", "Kajmanska Ostrva" },
            { "KZ", "Kazahstan" },
            { "Cyrl", "\u0107irilica" },
            { "LA", "Laos" },
            { "LB", "Liban" },
            { "LC", "Sveta Lucija" },
            { "phn", "Feni\u010danski" },
            { "Cyrs", "Staroslovenska crkvena \u0107irilica" },
            { "gwi", "Gvi\u010d\u2019in" },
            { "nds", "Niski nema\u010dki" },
            { "LI", "Lihten\u0161tajn" },
            { "LK", "\u0160ri Lanka" },
            { "akk", "Akadijski" },
            { "cop", "Koptski" },
            { "LR", "Liberija" },
            { "LS", "Lesoto" },
            { "Phlv", "pahlavi pismo" },
            { "LT", "Litvanija" },
            { "LU", "Luksemburg" },
            { "LV", "Letonija" },
            { "Kana", "katakana" },
            { "LY", "Libija" },
            { "lad", "Ladino" },
            { "vun", "vund\u017eo" },
            { "lah", "Landa" },
            { "lag", "langi" },
            { "Thaa", "thana pismo" },
            { "MA", "Maroko" },
            { "MC", "Monako" },
            { "MD", "Moldavija" },
            { "ME", "Crna Gora" },
            { "MF", "Sent Martin" },
            { "lam", "Lamba" },
            { "MG", "Madagaskar" },
            { "MH", "Mar\u0161alska Ostrva" },
            { "ale", "Aljut" },
            { "Thai", "tajlandsko pismo" },
            { "type.nu.vaii", "Vai cifre" },
            { "MK", "Makedonija" },
            { "ML", "Mali" },
            { "MM", "Mijanmar (Burma)" },
            { "MN", "Mongolija" },
            { "new", "Nevari" },
            { "MO", "SAR Makao (Kina)" },
            { "MP", "Severna Marijanska Ostrva" },
            { "MQ", "Martinik" },
            { "MR", "Mauritanija" },
            { "MS", "Monserat" },
            { "type.colAlternate.non-ignorable", "Sortiraj simbole" },
            { "MT", "Malta" },
            { "MU", "Mauricijus" },
            { "alt", "Ju\u017eni altai" },
            { "MV", "Maldivi" },
            { "MW", "Malavi" },
            { "MX", "Meksiko" },
            { "type.ca.japanese", "japanski kalendar" },
            { "MY", "Malezija" },
            { "MZ", "Mozambik" },
            { "Phli", "pisani pahlavi" },
            { "NA", "Namibija" },
            { "type.ca.hebrew", "hebrejski kalendar" },
            { "type.co.dictionary", "Redosled sortiranja u re\u010dniku" },
            { "NC", "Nova Kaledonija" },
            { "NE", "Niger" },
            { "NF", "Ostrvo Norfok" },
            { "NG", "Nigerija" },
            { "Phlp", "psalter pahlavi" },
            { "NI", "Nikaragva" },
            { "Hmng", "pahav hmong pismo" },
            { "NL", "Holandija" },
            { "NO", "Norve\u0161ka" },
            { "NP", "Nepal" },
            { "NR", metaValue_NR },
            { "NU", "Niue" },
            { "Phnx", "Feni\u010dansko pismo" },
            { "rof", "rombo" },
            { "tsi", "Tsim\u0161ian" },
            { "NZ", "Novi Zeland" },
            { "rom", "Romani" },
            { "Mero", "meroitik pismo" },
            { "type.colAlternate.shifted", metaValue_key_colAlternate },
            { "crh", "Krimeanski turski" },
            { "ang", "Staroengleski" },
            { "OM", "Oman" },
            { "anp", "Angika" },
            { "Xpeo", "staropersijsko pismo" },
            { "PA", "Panama" },
            { "type.ca.islamic-civil", "Islamski civilni kalendar" },
            { "csb", "Ka\u0161ubijanski" },
            { "PE", "Peru" },
            { "PF", "Francuska Polinezija" },
            { "PG", "Papua Nova Gvineja" },
            { "PH", "Filipini" },
            { "PK", "Pakistan" },
            { "PL", "Poljska" },
            { "ewo", "Evondo" },
            { "PM", "Sen Pjer i Mikelon" },
            { "PN", "Pitkern" },
            { "type.colBackwards.yes", "Sortiraj akcente obrnuto" },
            { "PR", "Portoriko" },
            { "PS", "Palestinske teritorije" },
            { "Bali", "balijsko pismo" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "nia", "Nias" },
            { "type.nu.greklow", "mali gr\u010dki brojevi" },
            { "PY", "Paragvaj" },
            { "tum", "Tumbuka" },
            { "Hebr", "hebrejsko pismo" },
            { "QA", "Katar" },
            { "%%SCOTLAND", "\u0160kotski standardni Engleski" },
            { "niu", "Niuean" },
            { "QO", "Okeanija (udaljena ostrva)" },
            { "lez", "Lezgian" },
            { "%%FONUPA", "UPA fonetika" },
            { "tvl", metaValue_TV },
            { "Tavt", "tai viet pismo" },
            { "001", "svet" },
            { "002", "Afrika" },
            { "003", "Severnoameri\u010dki kontinent" },
            { "RE", "Reinion" },
            { "type.colNormalization.no", "Sortiraj bez normalizacije" },
            { "005", "Ju\u017ena Amerika" },
            { "jbo", "Lojban" },
            { "Rjng", "rejang pismo" },
            { "009", "Okeanija" },
            { "RO", "Rumunija" },
            { "RS", "Srbija" },
            { "RU", "Rusija" },
            { "RW", "Ruanda" },
            { "Mani", "manihejsko pismo" },
            { "Ugar", "ugaritsko pismo" },
            { "key.colAlternate", metaValue_key_colAlternate },
            { "Khar", "karo\u0161ti pismo" },
            { "SA", "Saudijska Arabija" },
            { "pon", "Ponpejski" },
            { "Mand", "mandeansko pismo" },
            { "SB", "Solomonska Ostrva" },
            { "twq", "tasavak" },
            { "011", "Zapadna Afrika" },
            { "SC", "Sej\u0161eli" },
            { "SD", "Sudan" },
            { "013", "Centralna Amerika" },
            { "SE", "\u0160vedska" },
            { "014", "Isto\u010dna Afrika" },
            { "arc", "Armajski" },
            { "015", "Severna Afrika" },
            { "SG", "Singapur" },
            { "SH", "Sveta Jelena" },
            { "017", "Centralna Afrika" },
            { "SI", "Slovenija" },
            { "018", "Ju\u017ena Afrika" },
            { "SJ", "Svalbard i Jan Majen" },
            { "019", "Severna i Ju\u017ena Amerika" },
            { "SK", "Slova\u010dka" },
            { "SL", "Sijera Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalija" },
            { "arn", "mapu\u010de" },
            { "arp", "Arapaho" },
            { "type.nu.taml", "tamilski brojevi" },
            { "SR", "Surinam" },
            { "SS", "Ju\u017eni Sudan" },
            { "ST", "Sao Tome i Principe" },
            { "SV", "Salvador" },
            { "SX", "Sveti Martin" },
            { "SY", "Sirija" },
            { "yao", "Jao" },
            { "SZ", "Svazilend" },
            { "arw", "Aravak" },
            { "yap", "Jape\u0161ki" },
            { "TA", "Tristan da Kunja" },
            { "asa", "asu" },
            { "021", "Severna Amerika" },
            { "TC", "Ostrva Turks i Kaikos" },
            { "TD", "\u010cad" },
            { "TF", "Francuske Ju\u017ene Teritorije" },
            { "TG", "Togo" },
            { "TH", "Tajland" },
            { "TJ", "Tad\u017eikistan" },
            { "TK", metaValue_TK },
            { "029", "Karibi" },
            { "TL", "Isto\u010dni Timor" },
            { "type.co.searchjl", "Pretraga prema hangul po\u010detnom suglasniku" },
            { "TM", "Turkmenistan" },
            { "%%BOONT", "Buntling" },
            { "TN", "Tunis" },
            { "TO", "Tonga" },
            { "TR", "Turska" },
            { "TT", "Trinidad i Tobago" },
            { "TV", metaValue_TV },
            { "TW", "Tajvan" },
            { "ast", "Asturijski" },
            { "Orkh", "orkonsko pismo" },
            { "TZ", "Tanzanija" },
            { "nmg", "kvasio" },
            { "Zzzz", "nepoznato pismo" },
            { "UA", "Ukrajina" },
            { "rup", "Aromanijski" },
            { "030", "Isto\u010dna Azija" },
            { "tyv", "Tuvinijski" },
            { "sw_CD", "kongo svahili" },
            { "034", "Ju\u017ena Azija" },
            { "hai", "Haida" },
            { "035", "Jugoisto\u010dna Azija" },
            { "UG", "Uganda" },
            { "type.co.pinyin", "Pinjin sortiranje" },
            { "type.colHiraganaQuaternary.yes", "Sortiraj kana simbole druga\u010dije" },
            { "039", "Ju\u017ena Evropa" },
            { "Sinh", "sinhalsko pismo" },
            { "UM", "Udaljena ostrva SAD" },
            { "US", "Sjedinjene Ameri\u010dke Dr\u017eave" },
            { "haw", "havajski" },
            { "type.co.gb2312han", "Pojednostavljeno kinesko sortiranje" },
            { "UY", "Urugvaj" },
            { "UZ", "Uzbekistan" },
            { "tzm", "centralnoatlaski tamazigt" },
            { "type.co.stroke", "Sortiranje po broju crta" },
            { "VA", "Vatikan" },
            { "pro", "Staroprovansalski" },
            { "VC", "Sent Vinsent i Grenadini" },
            { "VE", "Venecuela" },
            { "VG", "Britanska Devi\u010danska Ostrva" },
            { "VI", "Ameri\u010dka Devi\u010danska Ostrva" },
            { "VN", "Vijetnam" },
            { "type.colBackwards.no", "Sortiraj akcente normalno" },
            { "VU", "Vanuatu" },
            { "nog", "Nogai" },
            { "rwk", "rua" },
            { "non", "Stari norski" },
            { "053", "Australija i Novi Zeland" },
            { "%%AREVMDA", "Zapadno jermenska" },
            { "054", "Melanezija" },
            { "WF", "Valis i Futuna" },
            { "type.co.traditional", "Tradicionalno sortiranje" },
            { "057", "Mikronezijski region" },
            { "jgo", "ngomba" },
            { "lkt", "lakota" },
            { "type.nu.finance", "Finansijski brojevi" },
            { "WS", "Samoa" },
            { "wal", "Valamo" },
            { "was", "Va\u0161o" },
            { "war", "Varaj" },
            { "awa", "Avadhi" },
            { "061", "Polinezija" },
            { "XK", "Kosovo" },
            { "Gujr", "gud\u017earatsko pismo" },
            { "Zxxx", "nepisani jezik" },
            { "Olck", "ol \u010diki pismo" },
            { "wbp", "varlpiri" },
            { "Batk", "batak pismo" },
            { "Blis", "blisimboli\u010dno pismo" },
            { "YE", "Jemen" },
            { "nqo", "n\u2019ko" },
            { "type.co.standard", "standardni redosled sortiranja" },
            { "fan", "Fang" },
            { "%%ROZAJ", "Resijan" },
            { "fat", "Fanti" },
            { "Sgnw", "znakovno pismo" },
            { "YT", "Majot" },
            { "ZA", "Ju\u017enoafri\u010dka Republika" },
            { "Deva", "devanagari" },
            { "type.nu.geor", "gruzijski brojevi" },
            { "Hira", "hiragana" },
            { "ZM", "Zambija" },
            { "ZW", "Zimbabve" },
            { "ZZ", "Nepoznat region" },
            { "Runr", "runsko pismo" },
            { "type.ca.iso8601", "ISO-8601 kalendar" },
            { "lol", "Mongo" },
            { "nso", "Severni soto" },
            { "type.nu.telu", "telugu cifre" },
            { "loz", "Lozi" },
            { "type.colHiraganaQuaternary.no", "Sortiraj kana simbole odvojeno" },
            { "jmc", "ma\u010dame" },
            { "type.nu.hansfin", "pojednostavljeni kineski finansijski brojevi" },
            { "type.colStrength.secondary", "Sortiraj akcente" },
            { "hil", "Hiligajnon" },
            { "type.nu.arabext", "produ\u017eene arapsko-indijske cifre" },
            { "nus", "nuer" },
            { "dak", "Dakota" },
            { "type.nu.fullwide", "cifre pune \u0161irine" },
            { "hit", "Hitite" },
            { "dar", "Dargva" },
            { "dav", "taita" },
            { "Maya", "majanski hijeroglifi" },
            { "lrc", "severni luri" },
            { "Copt", "kopti\u010dko pismo" },
            { "nwc", "Klasi\u010dni nevari" },
            { "udm", "Udmurt" },
            { "Khmr", "kmersko pismo" },
            { "Limb", "limbu pismo" },
            { "sad", "Sandave" },
            { "type.nu.roman", "rimski brojevi" },
            { "sah", "Jakut" },
            { "sam", "Samaritanski aramejski" },
            { "%%SCOUSE", "Skauz" },
            { "saq", "samburu" },
            { "sas", "Sasak" },
            { "sat", "Santali" },
            { "Tfng", "tifinag pismo" },
            { "jpr", "Judeo-persijski" },
            { "type.nu.native", "Lokalne cifre" },
            { "Guru", "gurmuki pismo" },
            { "lua", "Luba-lulua" },
            { "sbp", "sangu" },
            { "lui", "Luiseno" },
            { "nyn", "njankole" },
            { "nym", "Njamvezi" },
            { "lun", "Lunda" },
            { "nyo", "Njoro" },
            { "luo", "luo" },
            { "fil", "filipinski" },
            { "hmn", "Hmong" },
            { "del", "Delaver" },
            { "lus", "Lu\u0161ai" },
            { "bal", "Balu\u010di" },
            { "den", "Slavski" },
            { "ban", "Balinezijski" },
            { "uga", "Ugaritski" },
            { "luy", "lujia" },
            { "bas", "Basa" },
            { "jrb", "Judeo-arapski" },
            { "nzi", "Nzima" },
            { "sco", "\u0160kotski" },
            { "scn", "Sicilijanski" },
            { "aa", "Afarski" },
            { "ab", "abhaski" },
            { "key.colCaseFirst", "Re\u0111anje prema malom/velikom slovu" },
            { "ae", "Avestanski" },
            { "af", "afrikans" },
            { "ak", "akan" },
            { "am", "amharski" },
            { "an", "Aragone\u017eanski" },
            { "Arab", "arapsko pismo" },
            { "%%SOLBA", "Stolvica/Solbica dijalekt" },
            { "Jpan", "japansko pismo" },
            { "ar", "arapski" },
            { "Hrkt", "Katakana ili Hiragana" },
            { "as", "asamski" },
            { "Lina", "linearno A pismo" },
            { "av", "Avarski" },
            { "Linb", "linearno B pismo" },
            { "sdh", "ju\u017enokurdski" },
            { "ay", "Ajmara" },
            { "az", "azerbejd\u017eanski" },
            { "%%OSOJS", "Oseako/Osojane dijalekt" },
            { "ba", "ba\u0161kirski" },
            { "type.co.unihan", "Redosled sortiranja radikalnim crticama" },
            { "be", "beloruski" },
            { "bg", "bugarski" },
            { "bi", "Bislama" },
            { "bm", "bambara" },
            { "bn", "bengalski" },
            { "bo", "tibetanski" },
            { "dgr", "Dogrib" },
            { "br", "bretonski" },
            { "bs", "bosanski" },
            { "Mymr", "mijanmarsko pismo" },
            { "type.nu.laoo", "lao\u0161ke cifre" },
            { "seh", "sena" },
            { "Nkoo", "n\u2019ko pismo" },
            { "sel", "Selkap" },
            { "ca", "katalonski" },
            { "ses", "kojraboro seni" },
            { "ce", "\u010ce\u010denski" },
            { "ch", "\u010camoro" },
            { "%%REVISED", "Revidirana ortografija" },
            { "co", "korzikanski" },
            { "Orya", "orijansko pismo" },
            { "cr", "Kri" },
            { "cs", "\u010de\u0161ki" },
            { "cu", "Staroslovenski" },
            { "cv", "\u010cuva\u0161ki" },
            { "cy", "vel\u0161ki" },
            { "type.nu.ethi", "etiopski brojevi" },
            { "Yiii", "ji pismo" },
            { "da", "danski" },
            { "pt_PT", "Iberijski portugalski" },
            { "de", "nema\u010dki" },
            { "bej", "Beja" },
            { "din", "Dinka" },
            { "Bugi", "buginsko pismo" },
            { "bem", "bemba" },
            { "sga", "Staroirski" },
            { "type.nu.mong", "mongolske cifre" },
            { "dv", "Divehijski" },
            { "dz", "d\u017eonga" },
            { "bez", "bena" },
            { "type.ca.chinese", "kineski kalendar" },
            { "dje", "zarma" },
            { "type.nu.grek", "gr\u010dki brojevi" },
            { "ee", "eve" },
            { "ro_MD", "moldavski" },
            { "el", "gr\u010dki" },
            { "en", "engleski" },
            { "eo", "esperanto" },
            { "type.co.big5han", "Tradicionalno kinesko sortiranje" },
            { "es", "\u0161panski" },
            { "et", "estonski" },
            { "eu", "baskijski" },
            { "Buhd", "buhidsko pismo" },
            { "Hang", "hangul" },
            { "Samr", "samaritansko pismo" },
            { "shi", "ta\u0161elhit" },
            { "hsb", "gornji lu\u017ei\u010dkosrpski" },
            { "Hani", "han" },
            { "shn", "\u0160an" },
            { "Hano", "hanuno" },
            { "fa", "persijski" },
            { "Hans", "pojednostavljeno kinesko pismo" },
            { "type.nu.latn", "zapadne cifre" },
            { "Hant", "tradicionalno kinesko pismo" },
            { "ff", "Fulah" },
            { "fi", "finski" },
            { "fj", "fid\u017eijski" },
            { "fon", "Fon" },
            { "bgn", "zapadni belu\u010dki" },
            { "yue", "Kantonski" },
            { "fo", "farski" },
            { "umb", "Umbundu" },
            { "fr", "francuski" },
            { "sid", "Sidamo" },
            { "fy", "zapadni frizijski" },
            { "ga", "irski" },
            { "gd", "\u0160kotski Galski" },
            { "key.colCaseLevel", "Sortiranje prema malom/velikom slovu" },
            { "gl", "galicijski" },
            { "gn", "gvarani" },
            { "bho", "Bojpuri" },
            { "und", "nepoznat jezik" },
            { "type.ca.ethiopic-amete-alem", "etiopski amet alem kalendar" },
            { "gu", "gud\u017earati" },
            { "gv", "manski" },
            { "ha", "hausa" },
            { "he", "hebrejski" },
            { "hi", "hindi" },
            { "hup", "Hupa" },
            { "bik", "Bikol" },
            { "bin", "Bini" },
            { "ho", "Hiri Motu" },
            { "hr", "hrvatski" },
            { "ht", "hai\u0107anski" },
            { "hu", "ma\u0111arski" },
            { "hy", "jermenski" },
            { "hz", "Herero" },
            { "%%FONIPA", "IPA fonetika" },
            { "ia", "Interlingva" },
            { "id", "indone\u017eanski" },
            { "type.nu.tibt", "tibetanske cifre" },
            { "ie", "Me\u0111ujezi\u010dki" },
            { "ig", "igbo" },
            { "ii", "se\u010duan ji" },
            { "frm", "Srednji francuski" },
            { "ik", "Unupiak" },
            { "fro", "Starofrancuski" },
            { "io", "Ido" },
            { "frs", "Isto\u010dni frizijski" },
            { "frr", "Severno-frizijski" },
            { "is", "islandski" },
            { "it", "italijanski" },
            { "iu", "inuktitut" },
            { "ja", "japanski" },
            { "Mlym", "malajalam pismo" },
            { "Sara", "sarati pismo" },
            { "doi", "Dogri" },
            { "sma", "ju\u017eni sami" },
            { "jv", "javanski" },
            { "Shaw", "\u0161avijansko pismo" },
            { "mad", "Madure\u0161ki" },
            { "smj", "lule sami" },
            { "mag", "Magahi" },
            { "mai", "Maitili" },
            { "smn", "inari sami" },
            { "ka", "gruzijski" },
            { "bla", "Sisika" },
            { "mak", "Makasar" },
            { "sms", "skolt sami" },
            { "man", "Mandingo" },
            { "kg", "Kongo" },
            { "Goth", "Gotika" },
            { "ki", "kikuju" },
            { "mas", "masai" },
            { "kj", "Kuanjama" },
            { "kk", "kaza\u0161ki" },
            { "kl", "kalalisut" },
            { "km", "kmerski" },
            { "kn", "kanada" },
            { "type.colStrength.identical", "Sortiraj sve" },
            { "ko", "korejski" },
            { "kr", "Kanuri" },
            { "ks", "ka\u0161mirski" },
            { "Cirt", "cirt pismo" },
            { "Lepc", "lep\u010da pismo" },
            { "Avst", "avestansko pismo" },
            { "ku", "kurdski" },
            { "kv", "Komi" },
            { "kw", "kornvolski" },
            { "ky", "kirgiski" },
            { "snk", "Soninke" },
            { "type.colStrength.primary", "Sortiraj samo osnovna slova" },
            { "la", "latinski" },
            { "lb", "luksembur\u0161ki" },
            { "type.nu.mlym", "malajalam cifre" },
            { "lg", "ganda" },
            { "Roro", "rongorongo pismo" },
            { "li", "Limburgi\u0161" },
            { "Tibt", "tibetansko pismo" },
            { "ln", "lingala" },
            { "fur", "Friulijski" },
            { "type.colCaseLevel.no", "Sortiraj bez obzira na velika i mala slova" },
            { "lo", "lao\u0161ki" },
            { "type.colStrength.tertiary", "Sortiraj akcente/mala i velika slova/\u0161irinu" },
            { "lt", "litvanski" },
            { "lu", "luba-katanga" },
            { "lv", "letonski" },
            { "sog", "Sod\u017eijenski" },
            { "mg", "malga\u0161ki" },
            { "mh", "Mar\u0161alski" },
            { "type.co.ducet", "Podrazumevani Unicode redosled sortiranja" },
            { "mi", "maorski" },
            { "mk", "makedonski" },
            { "ml", "malajalam" },
            { "mn", "mongolski" },
            { "mr", "marati" },
            { "ms", "malajski" },
            { "mt", "malte\u0161ki" },
            { "my", "burmanski" },
            { "Saur", "saura\u0161tra pismo" },
            { "Armn", "jermensko pismo" },
            { "mdf", "Mok\u0161a" },
            { "dsb", "donji lu\u017ei\u010dkosrpski" },
            { "Armi", "imperijsko aramejsko pismo" },
            { "na", metaValue_NR },
            { "type.co.search", "pretraga op\u0161te namene" },
            { "nb", "norve\u0161ki bokmal" },
            { "nd", "severni ndebele" },
            { "ne", "nepalski" },
            { "ng", "Ndonga" },
            { "mdr", "Mandar" },
            { "nl", "holandski" },
            { "nn", "norve\u0161ki ninorsk" },
            { "no", "Norve\u0161ki" },
            { "nr", "Ju\u017eni ndebele" },
            { "nv", "Navaho" },
            { "kaa", "Kara-kalpa\u0161ki" },
            { "ny", "Njanja" },
            { "kac", "Ka\u010din" },
            { "kab", "kabile" },
            { "%%POLYTON", "Politonik" },
            { "type.colCaseFirst.lower", "Sortiraj prvo mala slova" },
            { "oc", "Provansalski" },
            { "kaj", "\u0110u" },
            { "kam", "kamba" },
            { "men", "Mende" },
            { "oj", "Ojibva" },
            { "mer", "meru" },
            { "type.nu.armn", "jermenski brojevi" },
            { "om", "oromo" },
            { "kaw", "Kavi" },
            { "or", "orija" },
            { "os", "Osetski" },
            { "kbd", "Kabardijski" },
            { "mfe", "morisjen" },
            { "srn", "Srananski tongo" },
            { "pa", "pand\u017eabi" },
            { "dua", "duala" },
            { "srr", "Serer" },
            { "%%LIPAW", "Lipovi\u010dki dijalekt resijanski" },
            { "pi", "Pali" },
            { "pl", "poljski" },
            { "dum", "Srednji holandski" },
            { "type.ca.dangi", "dangi kalendar" },
            { "ps", "pa\u0161tunski" },
            { "pt", "portugalski" },
            { "mga", "Srednji irski" },
            { "key.co", "Sortiranje" },
            { "pt_BR", "Brazilski portugalski" },
            { "kcg", "Tjap" },
            { "mgh", "makuva-meeto" },
            { "bra", "Braj" },
            { "key.ca", "kalendar" },
            { "Laoo", "lao\u0161ko pismo" },
            { "mgo", "meta" },
            { "type.nu.mymr", "mijanmarske cifre" },
            { "qu", "ke\u010dua" },
            { "zap", "Zapote\u010dki" },
            { "brx", "bodo" },
            { "Lana", "lanna pismo" },
            { "kde", "makonde" },
            { "Ethi", "etiopsko pismo" },
            { "rm", "reto-romanski" },
            { "rn", "rundi" },
            { "key.cu", "valuta" },
            { "ro", "rumunski" },
            { "%%SAAHO", "Saho" },
            { "type.nu.orya", "orija cifre" },
            { "type.nu.hanidec", "kineski decimalni brojevi" },
            { "ru", "ruski" },
            { "rw", "kinjaruanda" },
            { "zbl", "Blisimboli" },
            { "kea", "zelenortski kreolski" },
            { "mic", "Mikmak" },
            { "suk", "Sukuma" },
            { "sa", "sanskrit" },
            { "sc", "Sardinjaski" },
            { "sus", "Susu" },
            { "sd", "sindi" },
            { "se", "severni sami" },
            { "min", "Minangkabau" },
            { "sg", "sango" },
            { "sh", "Srpskohrvatski" },
            { "si", "sinhalski" },
            { "sux", "Sumerski" },
            { "sk", "slova\u010dki" },
            { "sl", "slovena\u010dki" },
            { "sm", "Samoanski" },
            { "sn", "\u0161ona" },
            { "so", "somalski" },
            { "type.nu.arab", "arapsko-indijske cifre" },
            { "sq", "albanski" },
            { "sr", "srpski" },
            { "ss", "Svati" },
            { "st", "Sesoto" },
            { "Java", "javansko pismo" },
            { "su", "sundanski" },
            { "%%NEDIS", "Natisone dijalekt" },
            { "sv", "\u0161vedski" },
            { "sw", "svahili" },
            { "type.nu.hantfin", "tradicionalni kineski finansijski brojevi" },
            { "iba", "Iban" },
            { "ta", "tamilski" },
            { "142", "Azija" },
            { "bua", "Buriat" },
            { "143", "Centralna Azija" },
            { "te", "telugu" },
            { "145", "Zapadna Azija" },
            { "tg", "tad\u017ei\u010dki" },
            { "th", "tajlandski" },
            { "ti", "tigrinja" },
            { "bug", "Bugine\u017eanski" },
            { "kfo", "Koro" },
            { "type.colNumeric.yes", "Sortiraj cifre numeri\u010dki" },
            { "tk", "turkmenski" },
            { "tl", "Tagalski" },
            { "tn", "Tsvana" },
            { "to", "tonga" },
            { "dyo", "d\u017eola fonji" },
            { "type.nu.jpan", "japanski brojevi" },
            { "tr", "turski" },
            { "ts", "Tsonga" },
            { "swb", "Komorski" },
            { "Cakm", "\u010dakmansko pismo" },
            { "tt", "tatarski" },
            { "dyu", "\u0110ula" },
            { "tw", "Tvi" },
            { "ty", "Tahi\u0107anski" },
            { "%%BISKE", "San \u0110or\u0111io/Bila dijalekt" },
            { "150", "Evropa" },
            { "key.colHiraganaQuaternary", "Sortiranje prema kana simbolima" },
            { "151", "Isto\u010dna Evropa" },
            { "154", "Severna Evropa" },
            { "155", "Zapadna Evropa" },
            { "ug", "ujgurski" },
            { "Ital", "stari italik" },
            { "Kore", "korejsko pismo" },
            { "Zyyy", "zajedni\u010dko pismo" },
            { "uk", "ukrajinski" },
            { "type.colCaseFirst.no", "Sortiraj normalan redosled velikih i malih slova" },
            { "type.colStrength.quaternary", "Sortiraj akcente/mala i velika slova/\u0161irinu/kana simbole" },
            { "type.ca.coptic", "koptski kalendar" },
            { "ur", "urdu" },
            { "%%1994", "Standardnizovana resijanska ortografija" },
            { "xal", "Kalmik" },
            { "zen", "Zenaga" },
            { "uz", "uzbe\u010dki" },
            { "kha", "Kasi" },
            { "%%1996", "Nema\u010dka ortografija iz 1996" },
            { "nds_NL", "niskosaksonski" },
            { "Sylo", "siloti nagri pismo" },
            { "ve", "Venda" },
            { "type.ca.roc", "kalendar Republike Kine" },
            { "vi", "vijetnamski" },
            { "kho", "Kotane\u0161ki" },
            { "khq", "kojra \u010diini" },
            { "%%TARASK", "Taraskijevi\u010dka ortografija" },
            { "vo", "Volapuk" },
            { "key.x", "Privatna upotreba" },
            { "syc", "Klasi\u010dni sirijski" },
            { "Osma", "osmanjansko pismo" },
            { "quc", "k\u2019i\u010de" },
            { "gaa", "Ga" },
            { "wa", "Valun" },
            { "gag", "gagauz" },
            { "syr", "Sirijski" },
            { "Grek", "gr\u010dko pismo" },
            { "Lydi", "lidijsko pismo" },
            { "Xsux", "sumersko-akadsko kuneiform pismo" },
            { "wo", "volof" },
            { "zgh", "standardni marokanski tamazigt" },
            { "ar_001", "moderan standardni arapski" },
            { "Cans", "ujedinjeni kanadski aborid\u017einski silabici" },
            { "gay", "Gajo" },
            { "key.colNumeric", "Numeri\u010dko sortiranje" },
            { "Mong", "mongolsko pismo" },
            { "mnc", "Man\u010du" },
            { "Latf", "latinica (fraktur varijanta)" },
            { "gba", "Gbaja" },
            { "mni", "Manipuri" },
            { "Latn", "latinica" },
            { "Latg", "galska latinica" },
            { "type.nu.hans", "pojednostavljeni kineski brojevi" },
            { "type.nu.hant", "tradicionalni kineski brojevi" },
            { "xh", "kosa" },
            { "type.nu.romanlow", "mali rimski brojevi" },
            { "byn", "Blin" },
            { "Lyci", "lisijsko pismo" },
            { "osa", "Osage" },
            { "Moon", "mese\u010devo pismo" },
            { "moh", "mohok" },
            { "%%1694ACAD", "Rani moderni francuski" },
            { "yi", "Jidi\u0161" },
            { "mos", "Mosi" },
            { "Syrc", "sirijsko pismo" },
            { "Dsrt", "Dezeret" },
            { "yo", "joruba" },
            { "type.nu.traditional", "Tradicionalni brojevi" },
            { "Syrj", "zapadnosirijsko pismo" },
            { "ota", "Otomanski turski" },
            { "Syre", "sirijsko estrangelo pismo" },
            { "vai", "vai" },
            { "za", "\u017duang" },
            { "Cari", "karijsko pismo" },
            { "kln", "kalend\u017ein" },
            { "zh", "kineski" },
            { "Bopo", "bopomofo pismo" },
            { "Perm", "staro permiksko pismo" },
            { "key.lb", "stil preloma reda" },
            { "zu", "zulu" },
            { "type.co.phonebook", "Sortiranje kao telefonski imenik" },
            { "%%MONOTON", "Monotonik" },
            { "Geor", "gruzijsko pismo" },
            { "kmb", "Kimbundu" },
            { "type.colCaseLevel.yes", "Sortiraj mala i velika slova" },
            { "type.nu.jpanfin", "japanski finansijski brojevi" },
            { "Cham", "\u010damsko pismo" },
            { "gez", "D\u017eiz" },
            { "Syrn", "pismo isto\u010dne Sirije" },
            { "type.co.reformed", "Reformisani redosled sortiranja" },
            { "Tglg", "Tagalog" },
            { "Egyd", "egipatsko narodno pismo" },
            { "key.colBackwards", "Sortiranje prema obrnutim akcentima" },
            { "Egyh", "egipatsko hijeratsko pismo" },
            { "ebu", "embu" },
            { "Egyp", "egipatski hijeroglifi" },
            { "Geok", "gruzijsko khutsuri pismo" },
            { "koi", "komi-permski" },
            { "Hung", "staroma\u0111arsko pismo" },
            { "kok", "konkani" },
            { "%%1901", "Tradicionalna nema\u010dka ortografija" },
            { "kos", "Kosreanski" },
            { "Sund", "sundansko pismo" },
            { "kpe", "Kpele" },
            { "type.nu.khmr", "kmerske cifre" },
            { "ilo", "Iloko" },
            { "%%VALENCIA", "Valencijska" },
            { "Cprt", "kiparsko pismo" },
            { "%%BAKU1926", "Ujedinjen turski latini\u010dni alfabet" },
            { "mua", "mundang" },
            { "type.nu.guru", "gurmuki cifre" },
            { "mul", "Vi\u0161e jezika" },
            { "cad", "Kado" },
            { "mus", "Kri\u0161ki" },
            { "Glag", "glagoljica" },
            { "gil", "Gilbert\u0161ki" },
            { "Cher", "\u010ceroki" },
            { "car", "Karipski" },
            { "type.nu.tamldec", "tamilske cifre" },
            { "krc", "Kara\u010daj-balkar" },
            { "inh", "Ingvi\u0161ki" },
            { "krl", "Karelijski" },
            { "efi", "Efikski" },
            { "key.nu", "brojevi" },
            { "kru", "Kurukh" },
            { "ksb", "\u0161ambala" },
            { "type.colCaseFirst.upper", "Sortiraj prvo velika slova" },
            { "Telu", "telugu pismo" },
            { "ksf", "bafija" },
        };
        return data;
    }
}
