/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ur extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_FJ = "\u0641\u062c\u06cc";
        final String metaValue_HT = "\u06c1\u06cc\u062a\u06cc";
        final String metaValue_MD = "\u0645\u0627\u0644\u062f\u0648\u0648\u0627";
        final String metaValue_TR = "\u062a\u0631\u06a9\u06cc";
        final String metaValue_ar = "\u0639\u0631\u0628\u06cc";
        final String metaValue_bn = "\u0628\u0646\u06af\u0627\u0644\u06cc";
        final String metaValue_bo = "\u062a\u0628\u062a\u06cc";
        final String metaValue_el = "\u06cc\u0648\u0646\u0627\u0646\u06cc";
        final String metaValue_gu = "\u06af\u062c\u0631\u0627\u062a\u06cc";
        final String metaValue_he = "\u0639\u0628\u0631\u0627\u0646\u06cc";
        final String metaValue_ja = "\u062c\u0627\u067e\u0627\u0646\u06cc";
        final String metaValue_km = "\u062e\u0645\u06cc\u0631";
        final String metaValue_ko = "\u06a9\u0648\u0631\u06cc\u0627\u0626\u06cc";
        final String metaValue_la = "\u0644\u0627\u0637\u06cc\u0646\u06cc";
        final String metaValue_lo = "\u0644\u0627\u0624";
        final String metaValue_si = "\u0633\u0646\u06c1\u0627\u0644\u0627";
        final String metaValue_ta = "\u062a\u0645\u0644";
        final String metaValue_te = "\u062a\u06cc\u0644\u06af\u0648";
        final String metaValue_th = "\u062a\u06be\u0627\u0626\u06cc";
        final Object[][] data = new Object[][] {
            { "sbp", "\u0633\u0627\u0646\u06af\u0648" },
            { "nyn", "\u0646\u06cc\u0646\u06a9\u0648\u0644" },
            { "key.colStrength", "\u0686\u06be\u0679\u0627\u0626\u06cc \u06a9\u06cc \u0642\u0648\u062a" },
            { "luo", "\u0644\u0648" },
            { "Zsym", "\u0639\u0644\u0627\u0645\u0627\u062a" },
            { "fil", "\u0641\u0644\u06cc\u067e\u06cc\u0646\u0648" },
            { "luy", "\u0644\u0648\u06cc\u0627" },
            { "es_ES", "\u06cc\u0648\u0631\u067e\u06cc \u06c1\u0633\u067e\u0627\u0646\u0648\u06cc" },
            { "teo", "\u062a\u06cc\u0633\u0648" },
            { "ab", "\u0627\u0628\u0642\u0627\u0632\u06cc\u0627\u0646" },
            { "AC", "\u0627\u0633\u06cc\u0646\u0634\u0646 \u0622\u0626\u0644\u06cc\u0646\u0688" },
            { "tet", "\u0679\u06cc\u0679\u0645" },
            { "key.colCaseFirst", "\u0628\u0691\u06d2 \u062d\u0631\u0648\u0641/ \u0686\u06be\u0648\u0679\u06d2 \u062d\u0631\u0648\u0641 \u06a9\u06cc \u062a\u0631\u062a\u06cc\u0628 \u0628\u0646\u062f\u06cc" },
            { "AD", "\u0627\u0646\u0688\u0648\u0631\u0627" },
            { "AE", "\u0645\u062a\u062d\u062f\u06c1 \u0639\u0631\u0628 \u0627\u0645\u0627\u0631\u0627\u062a" },
            { "nl_BE", "\u0641\u0644\u06cc\u0645\u0650\u0634" },
            { "AF", "\u0627\u0641\u063a\u0627\u0646\u0633\u062a\u0627\u0646" },
            { "af", "\u0627\u06cc\u0641\u0631\u06cc\u06a9\u0627\u0646\u0632" },
            { "AG", "\u0627\u0646\u0679\u06cc\u06af\u0648\u0627 \u0627\u0648\u0631 \u0628\u0627\u0631\u0628\u0648\u062f\u0627" },
            { "type.ca.ethiopic", "\u0627\u06cc\u062a\u06be\u0648\u067e\u06cc\u0627\u0626\u06cc \u06a9\u06cc\u0644\u0646\u0688\u0631" },
            { "AI", "\u0627\u0646\u06af\u0648\u0626\u06cc\u0644\u0627" },
            { "key.tz", "\u0645\u0646\u0637\u0642\u06c2 \u0648\u0642\u062a" },
            { "ak", "\u0627\u06a9\u0627\u0646" },
            { "AL", "\u0627\u0644\u0628\u0627\u0646\u06cc\u06c1" },
            { "AM", "\u0622\u0631\u0645\u06cc\u0646\u06cc\u0627" },
            { "am", "\u0627\u0645\u06c1\u0627\u0631\u06cc" },
            { "Arab", metaValue_ar },
            { "AO", "\u0627\u0646\u06af\u0648\u0644\u0627" },
            { "Jpan", metaValue_ja },
            { "AQ", "\u0627\u0646\u0679\u0627\u0631\u06a9\u0679\u06cc\u06a9\u0627" },
            { "ar", metaValue_ar },
            { "AR", "\u0627\u0631\u062c\u0646\u0679\u06cc\u0646\u0627" },
            { "AS", "\u0627\u0645\u0631\u06cc\u06a9\u06cc \u0633\u0627\u0645\u0648\u0622" },
            { "as", "\u0622\u0633\u0627\u0645\u06cc" },
            { "AT", "\u0622\u0633\u0679\u0631\u06cc\u0627" },
            { "AU", "\u0622\u0633\u0679\u0631\u06cc\u0644\u06cc\u0627" },
            { "AW", "\u0627\u0631\u0648\u0628\u0627" },
            { "sdh", "\u062c\u0646\u0648\u0628\u06cc \u06a9\u0631\u062f" },
            { "en_US", "\u0627\u0645\u0631\u06cc\u06a9\u06cc \u0627\u0646\u06af\u0631\u06cc\u0632\u06cc" },
            { "AX", "\u0622\u0644\u06cc\u0646\u0688 \u0622\u0626\u0644\u06cc\u0646\u0688\u0632" },
            { "key.colNormalization", "\u0645\u0639\u0645\u0648\u0644 \u06a9\u06cc \u0686\u06be\u0679\u0627\u0626\u06cc" },
            { "ay", "\u0627\u06cc\u0645\u0627\u0631\u0627" },
            { "AZ", "\u0622\u0630\u0631\u0628\u0627\u0626\u062c\u0627\u0646" },
            { "az", "\u0622\u0632\u0631\u0628\u0627\u0626\u06cc\u062c\u0627\u0646\u06cc" },
            { "BA", "\u0628\u0648\u0633\u0646\u06cc\u0627 \u0627\u0648\u0631 \u06c1\u0631\u0632\u06cc\u06af\u0648\u0648\u06cc\u0646\u0627" },
            { "ba", "\u0628\u0627\u0634\u06a9\u06cc\u0631" },
            { "BB", "\u0628\u0627\u0631\u0628\u0627\u0688\u0648\u0633" },
            { "BD", "\u0628\u0646\u06af\u0644\u06c1 \u062f\u06cc\u0634" },
            { "type.co.unihan", "\u0627\u0633\u0627\u0633\u06cc-\u0633\u0679\u0631\u0648\u06a9 \u06a9\u06cc \u0686\u06be\u0679\u0646\u06cc \u06a9\u06cc \u062a\u0631\u062a\u06cc\u0628" },
            { "BE", "\u0628\u06cc\u0644\u062c\u06cc\u0645" },
            { "be", "\u0628\u06cc\u0644\u0627\u0631\u0648\u0633\u06cc" },
            { "BF", "\u0628\u0631\u06a9\u06cc\u0646\u0627 \u0641\u0627\u0633\u0648" },
            { "BG", "\u0628\u0644\u063a\u0627\u0631\u06cc\u06c1" },
            { "bg", "\u0628\u0644\u063a\u0627\u0631\u06cc" },
            { "BH", "\u0628\u062d\u0631\u06cc\u0646" },
            { "BI", "\u0628\u0631\u0648\u0646\u0688\u06cc" },
            { "BJ", "\u0628\u06cc\u0646\u0646" },
            { "BL", "\u0633\u06cc\u0646\u0679 \u0628\u0631\u062a\u06be\u0644\u06cc\u0645\u06cc" },
            { "BM", "\u0628\u0631\u0645\u0648\u062f\u0627" },
            { "bm", "\u0628\u0645\u0628\u0627\u0631\u0627" },
            { "bn", metaValue_bn },
            { "BN", "\u0628\u0631\u0648\u0646\u0626\u06cc" },
            { "bo", metaValue_bo },
            { "BO", "\u0628\u0648\u0644\u06cc\u0648\u06cc\u0627" },
            { "BQ", "\u06a9\u0631\u06cc\u0628\u06cc\u0627\u0626\u06cc \u0646\u06cc\u062f\u0631\u0644\u06cc\u0646\u0688\u0632" },
            { "BR", "\u0628\u0631\u0627\u0632\u06cc\u0644" },
            { "br", "\u0628\u0631\u06cc\u0679\u0646" },
            { "BS", "\u0628\u06c1\u0627\u0645\u0627\u0633" },
            { "bs", "\u0628\u0648\u0633\u0646\u06cc" },
            { "xog", "\u0633\u0648\u06af\u0627" },
            { "BT", "\u0628\u06be\u0648\u0679\u0627\u0646" },
            { "BV", "\u0628\u0624\u0648\u06cc\u0679 \u0622\u0626\u0644\u06cc\u0646\u0688" },
            { "BW", "\u0628\u0648\u062a\u0633\u0648\u0627\u0646\u0627" },
            { "Mymr", "\u0645\u06cc\u0627\u0646\u0645\u0627\u0631" },
            { "type.nu.laoo", "\u0644\u0627\u0624 \u06c1\u0646\u062f\u0633\u06d2" },
            { "BY", "\u0628\u06cc\u0644\u0627\u0631\u0648\u0633" },
            { "seh", "\u0633\u06cc\u0646\u0627" },
            { "BZ", "\u0628\u06cc\u0644\u0627\u0626\u0632" },
            { "type.ca.persian", "\u0641\u0627\u0631\u0633\u06cc \u06a9\u06cc\u0644\u0646\u0688\u0631" },
            { "type.nu.hebr", "\u0639\u0628\u0631\u0627\u0646\u06cc \u0627\u0639\u062f\u0627\u062f" },
            { "CA", "\u06a9\u06cc\u0646\u06cc\u0688\u0627" },
            { "ca", "\u06a9\u06cc\u0679\u0627\u0644\u0627\u0646" },
            { "CC", "\u06a9\u0648\u06a9\u0648\u0633 (\u06a9\u06cc\u0644\u0646\u06af) \u062c\u0632\u0627\u0626\u0631" },
            { "mzn", "\u0645\u0632\u0646\u062f\u0631\u0627\u0646\u06cc" },
            { "ses", "\u0643\u0648\u064a\u0631\u0627\u0628\u0648\u0631\u0648 \u0633\u064a\u0646\u06cc" },
            { "CD", "\u06a9\u0627\u0646\u06af\u0648 - \u06a9\u0646\u0634\u0627\u0633\u0627" },
            { "ce", "\u0686\u06cc\u0686\u0646" },
            { "CF", "\u0648\u0633\u0637 \u0627\u0641\u0631\u06cc\u0642\u06cc \u062c\u0645\u06c1\u0648\u0631\u06cc\u06c1" },
            { "CG", "\u06a9\u0627\u0646\u06af\u0648 - \u0628\u0631\u0627\u0632\u0627\u0648\u06cc\u0644\u06d2" },
            { "CH", "\u0633\u0648\u0626\u0679\u0632\u0631 \u0644\u06cc\u0646\u0688" },
            { "CI", "\u06a9\u0648\u0679 \u0688\u06cc \u0622\u0626\u06cc\u0648\u0631\u06cc" },
            { "CK", "\u06a9\u06a9 \u0622\u0626\u0644\u06cc\u0646\u0688\u0632" },
            { "CL", "\u0686\u0644\u06cc" },
            { "CM", "\u06a9\u06cc\u0645\u0631\u0648\u0646" },
            { "CN", "\u0686\u06cc\u0646" },
            { "CO", "\u06a9\u0648\u0644\u0645\u0628\u06cc\u0627" },
            { "co", "\u06a9\u0648\u0631\u0627\u0633\u06cc\u06a9\u0646" },
            { "CP", "\u06a9\u0644\u067e\u0631\u0679\u0646 \u0622\u0626\u0644\u06cc\u0646\u0688" },
            { "Orya", "\u0627\u0691\u06cc\u06c1" },
            { "CR", "\u06a9\u0648\u0633\u0679\u0627 \u0631\u06cc\u06a9\u0627" },
            { "cs", "\u0686\u06cc\u06a9" },
            { "CU", "\u06a9\u06cc\u0648\u0628\u0627" },
            { "CV", "\u06a9\u06cc\u067e \u0648\u0631\u0688\u06cc" },
            { "cv", "\u0686\u0648\u0648\u0627\u0634" },
            { "CW", "\u06a9\u06cc\u0648\u0631\u0627\u06a9\u0627\u0624" },
            { "CX", "\u06a9\u0631\u0633\u0645\u0633 \u0622\u0626\u0644\u06cc\u0646\u0688" },
            { "CY", "\u0642\u0628\u0631\u0635" },
            { "cy", "\u0648\u06cc\u0644\u0634" },
            { "CZ", "\u0686\u06cc\u06a9 \u062c\u0645\u06c1\u0648\u0631\u06cc\u06c1" },
            { "type.nu.ethi", "\u0627\u06cc\u062a\u06be\u0648\u067e\u06cc\u0627\u0626\u06cc \u0627\u0639\u062f\u0627\u062f" },
            { "da", "\u0688\u06cc\u0646\u0634" },
            { "pt_PT", "\u06cc\u0648\u0631\u067e\u06cc \u067e\u0631\u062a\u06af\u0627\u0644\u06cc" },
            { "DE", "\u062c\u0631\u0645\u0646\u06cc" },
            { "de", "\u062c\u0631\u0645\u0646" },
            { "cgg", "\u0686\u06cc\u06af\u0627" },
            { "DG", "\u0688\u0627\u0626\u062c\u0648 \u06af\u0627\u0631\u0633\u06cc\u0627" },
            { "type.nu.deva", "\u062f\u06cc\u0648\u0646\u0627\u06af\u0631\u06cc \u06c1\u0646\u062f\u0633\u06d2" },
            { "DJ", "\u062c\u0628\u0648\u062a\u06cc" },
            { "type.colNumeric.no", "\u0627\u0646\u0641\u0631\u0627\u062f\u06cc \u0637\u0648\u0631 \u067e\u0631 \u06c1\u0646\u062f\u0633\u0648\u06ba \u06a9\u06cc \u0686\u06be\u0679\u0627\u0626\u06cc \u06a9\u0631\u06cc\u06ba" },
            { "DK", "\u0688\u0646\u0645\u0627\u0631\u06a9" },
            { "ach", "\u0627\u06a9\u0648\u0644\u06cc" },
            { "Brai", "\u0628\u0631\u06cc\u0644" },
            { "DM", "\u0688\u0648\u0645\u0646\u06cc\u06a9\u0627" },
            { "type.nu.armnlow", "\u0622\u0631\u0645\u06cc\u0646\u06cc\u0627\u0626\u06cc \u0632\u06cc\u0631\u06cc\u06ba \u0627\u0639\u062f\u0627\u062f" },
            { "DO", "\u0688\u0648\u0645\u0646\u06cc\u06a9\u0646 \u062c\u0645\u06c1\u0648\u0631\u06cc\u06c1" },
            { "bem", "\u0628\u06cc\u0645\u0628\u0627" },
            { "type.nu.mong", "\u0645\u0646\u06af\u0648\u0644\u06cc\u0627\u0626\u06cc \u06c1\u0646\u062f\u0633\u06d2" },
            { "key.variableTop", "\u0628\u0637\u0648\u0631 \u0639\u0644\u0627\u0645\u0627\u062a \u0686\u06be\u0679\u0627\u0626\u06cc \u06a9\u0631\u06cc\u06ba" },
            { "dv", "\u0688\u06cc\u0648\u06cc\u06c1\u06cc" },
            { "es_419", "\u0644\u0627\u0637\u06cc\u0646\u06cc \u0627\u0645\u0631\u06cc\u06a9\u06cc \u06c1\u0633\u067e\u0627\u0646\u0648\u06cc" },
            { "DZ", "\u0627\u0644\u062c\u06cc\u0631\u06cc\u0627" },
            { "dz", "\u0698\u0648\u0646\u06af\u06a9\u06be\u0627" },
            { "bez", "\u0628\u06cc\u0646\u0627" },
            { "type.ca.chinese", "\u0686\u06cc\u0646\u06cc \u06a9\u06cc\u0644\u0646\u0688\u0631" },
            { "EA", "\u0633\u06cc\u0626\u0648\u0679\u0627 \u0627\u0648\u0631 \u0645\u06cc\u0644\u06cc\u0644\u0627" },
            { "EC", "\u0627\u06cc\u06a9\u0648\u0627\u0688\u0648\u0631" },
            { "dje", "\u0632\u0631\u0645\u0627" },
            { "type.nu.grek", "\u06cc\u0648\u0646\u0627\u0646\u06cc \u0627\u0639\u062f\u0627\u062f" },
            { "EE", "\u0627\u0633\u0679\u0648\u0646\u06cc\u0627" },
            { "ee", "\u0627\u06cc\u0648" },
            { "type.lb.normal", "\u0639\u0645\u0648\u0645\u06cc \u0644\u0627\u0626\u0646 \u0628\u0631\u06cc\u06a9 \u0627\u0646\u062f\u0627\u0632" },
            { "EG", "\u0645\u0635\u0631" },
            { "ro_MD", metaValue_MD },
            { "EH", "\u0645\u063a\u0631\u0628\u06cc \u0635\u062d\u0627\u0631\u0627" },
            { "type.colNormalization.yes", "\u0645\u0639\u0645\u0648\u0644 \u06a9\u06d2 \u06cc\u0648\u0646\u06cc\u06a9\u0648\u0688 \u06a9\u06cc \u0686\u06be\u0679\u0627\u0626\u06cc \u06a9\u0631\u06cc\u06ba" },
            { "el", metaValue_el },
            { "en", "\u0627\u0646\u06af\u0631\u06cc\u0632\u06cc" },
            { "eo", "\u0627\u06cc\u0633\u067e\u0631\u0627\u0646\u0679\u0648" },
            { "chr", "\u0686\u06cc\u0631\u0648\u06a9\u06cc" },
            { "ER", "\u0627\u0631\u06cc\u0679\u06cc\u0631\u06cc\u0627" },
            { "type.co.big5han", "\u0631\u0648\u0627\u06cc\u062a\u06cc \u0686\u06cc\u0646\u06cc \u06a9\u06cc \u0686\u06be\u0679\u0627\u0626\u06cc \u06a9\u06cc \u062a\u0631\u062a\u06cc\u0628 - Big5" },
            { "ES", "\u06c1\u0633\u067e\u0627\u0646\u06cc\u06c1" },
            { "es", "\u06c1\u0633\u067e\u0627\u0646\u0648\u06cc" },
            { "ET", "\u0627\u06cc\u062a\u06be\u0648\u067e\u06cc\u0627" },
            { "et", "\u0627\u0633\u0679\u0648\u0646\u06cc\u0646" },
            { "EU", "\u06cc\u0648\u0631\u0648\u067e\u06cc \u06cc\u0648\u0646\u06cc\u0646" },
            { "eu", "\u0628\u0627\u0633\u06a9\u06cc" },
            { "Hang", "\u06c1\u0646\u06af\u0648\u0644" },
            { "type.ca.gregorian", "\u062c\u0627\u0631\u062c\u06cc\u0627\u0626\u06cc \u06a9\u06cc\u0644\u0646\u0688\u0631" },
            { "shi", "\u062a\u0634\u0644\u062d\u064a\u062a" },
            { "type.nu.gujr", "\u06af\u062c\u0631\u0627\u062a\u06cc \u06c1\u0646\u062f\u0633\u06d2" },
            { "hsb", "\u0627\u067e\u0631 \u0633\u0631\u0628\u06cc\u0627\u0626\u06cc" },
            { "Hani", "\u06c1\u0627\u0646" },
            { "fa", "\u0641\u0627\u0631\u0633\u06cc" },
            { "Hans", "\u0622\u0633\u0627\u0646" },
            { "type.nu.latn", "\u0645\u063a\u0631\u0628\u06cc \u06c1\u0646\u062f\u0633\u06d2" },
            { "Hant", "\u0631\u0648\u0627\u06cc\u062a\u06cc" },
            { "az_Arab", "\u062c\u0646\u0648\u0628\u06cc \u0622\u0632\u0631\u0628\u0627\u0626\u06cc\u062c\u0627\u0646\u06cc" },
            { "FI", "\u0641\u0646 \u0644\u06cc\u0646\u0688" },
            { "fi", "\u0641\u06cc\u0646\u06cc\u0634" },
            { "fj", metaValue_FJ },
            { "FJ", metaValue_FJ },
            { "FK", "\u0641\u0627\u06a9\u0644\u06cc\u0646\u0688 \u062c\u0632\u0627\u0626\u0631" },
            { "FM", "\u0645\u0627\u0626\u06a9\u0631\u0648\u0646\u06cc\u0634\u06cc\u0627" },
            { "key.va", "\u0645\u0642\u0627\u0645 \u06a9\u0627 \u0645\u062a\u063a\u06cc\u0631\u06c1" },
            { "bgn", "\u0645\u063a\u0631\u0628\u06cc \u0628\u0644\u0648\u0686\u06cc" },
            { "FO", "\u062c\u0632\u0627\u0626\u0631 \u0641\u0627\u0631\u0648" },
            { "fo", "\u0641\u06cc\u0631\u0648\u0626\u06cc\u0632" },
            { "Taml", metaValue_ta },
            { "FR", "\u0641\u0631\u0627\u0646\u0633" },
            { "fr", "\u0641\u0631\u0627\u0646\u0633\u06cc\u0633\u06cc" },
            { "fy", "\u0645\u063a\u0631\u0628\u06cc \u0641\u0631\u06cc\u0633\u06cc\u0626\u0646" },
            { "type.ca.indian", "\u06c1\u0646\u062f\u0648\u0633\u062a\u0627\u0646\u06cc \u0642\u0648\u0645\u06cc \u06a9\u06cc\u0644\u0646\u0688\u0631" },
            { "GA", "\u06af\u06cc\u0628\u0648\u0646" },
            { "ga", "\u0622\u0626\u06cc\u0631\u0650\u0634" },
            { "GB", "\u0633\u0644\u0637\u0646\u062a \u0645\u062a\u062d\u062f\u06c1" },
            { "GD", "\u06af\u0631\u06cc\u0646\u0627\u0688\u0627" },
            { "gd", "\u0633\u06a9\u0627\u0679 \u06af\u06cc\u0644\u0650\u06a9" },
            { "GE", "\u062c\u0627\u0631\u062c\u06cc\u0627" },
            { "GF", "\u0641\u0631\u06cc\u0646\u0686 \u06af\u06cc\u0627\u0646\u0627" },
            { "GG", "\u06af\u0648\u0626\u0631\u0646\u0633\u06cc" },
            { "GH", "\u06af\u06be\u0627\u0646\u0627" },
            { "GI", "\u062c\u0628\u0644 \u0627\u0644\u0637\u0627\u0631\u0642" },
            { "key.colCaseLevel", "\u062d\u0631\u0648\u0641 \u06a9\u06d2 \u062a\u0626\u06cc\u06ba \u062d\u0633\u0627\u0633 \u0686\u06be\u0679\u0627\u0626\u06cc" },
            { "GL", "\u06af\u0631\u06cc\u0646 \u0644\u06cc\u0646\u0688" },
            { "gl", "\u06af\u0627\u0644\u06cc\u0634\u06cc\u0627\u0626\u06cc" },
            { "GM", "\u06af\u0627\u0645\u0628\u06cc\u0627" },
            { "GN", "\u06af\u0646\u06cc" },
            { "gn", "\u06af\u064f\u0627\u0631\u0627\u0646\u06cc" },
            { "GP", "\u06af\u0648\u0627\u0688\u06cc\u0644\u0648\u067e" },
            { "GQ", "\u0627\u0633\u062a\u0648\u0627\u0626\u06cc \u06af\u06cc\u0627\u0646\u0627" },
            { "und", "\u0646\u0627\u0645\u0639\u0644\u0648\u0645 \u0632\u0628\u0627\u0646" },
            { "GR", "\u06cc\u0648\u0646\u0627\u0646" },
            { "type.ca.ethiopic-amete-alem", "\u0627\u06cc\u062a\u06be\u0648\u067e\u06a9 \u0627\u0645\u06cc\u0679 \u0627\u0644\u06cc\u0645 \u06a9\u06cc\u0644\u0646\u0688\u0631" },
            { "GS", "\u062c\u0646\u0648\u0628\u06cc \u062c\u0627\u0631\u062c\u06cc\u0627 \u0627\u0648\u0631 \u062c\u0646\u0648\u0628\u06cc \u0633\u06cc\u0646\u0688\u0648\u0686 \u062c\u0632\u0627\u0626\u0631" },
            { "GT", "\u06af\u0648\u0627\u0679\u06d2 \u0645\u0627\u0644\u0627" },
            { "gu", metaValue_gu },
            { "GU", "\u06af\u0648\u0622\u0645" },
            { "gv", "\u0645\u06cc\u0646\u06a9\u0633" },
            { "GW", "\u06af\u0646\u06cc \u0628\u0633\u0627\u0624" },
            { "tlh", "\u06a9\u0644\u0646\u06af\u0646" },
            { "GY", "\u06af\u06cc\u0627\u0646\u0627" },
            { "ha", "\u06c1\u0624\u0633\u0627" },
            { "ckb", "\u0633\u0648\u0631\u0627\u0646\u06cc \u06a9\u0631\u062f\u0634" },
            { "zxx", "\u06a9\u0648\u0626\u06cc \u0644\u0633\u0627\u0646\u06cc \u0645\u0648\u0627\u062f \u0646\u06c1\u06cc\u06ba" },
            { "he", metaValue_he },
            { "hi", "\u06c1\u0646\u062f\u06cc" },
            { "de_AT", "\u0622\u0633\u0679\u0631\u06cc\u0627\u0626\u06cc \u062c\u0631\u0645\u0646" },
            { "HK", "\u06c1\u0627\u0646\u06af \u06a9\u0627\u0646\u06af SAR \u0686\u06cc\u0646" },
            { "HM", "\u06c1\u06cc\u0626\u0631\u0688 \u0622\u0626\u0644\u06cc\u0646\u0688 \u0627\u0648\u0631 \u0645\u06cc\u06a9\u0688\u0648\u0646\u0627\u0644\u0688 \u0622\u0626\u0644\u06cc\u0646\u0688\u0632" },
            { "HN", "\u06c1\u0648\u0646\u0688\u0627\u0631\u0648\u0633" },
            { "HR", "\u06a9\u0631\u0648\u0634\u06cc\u0627" },
            { "hr", "\u06a9\u0631\u0627\u062a\u06cc" },
            { "agq", "\u0627\u063a\u0645" },
            { "gsw", "\u0633\u0648\u0626\u0633 \u062c\u0631\u0645\u0646" },
            { "ht", metaValue_HT },
            { "HT", metaValue_HT },
            { "HU", "\u06c1\u0646\u06af\u0631\u06cc" },
            { "hu", "\u06c1\u0646\u06af\u06cc\u0631\u06cc\u0646" },
            { "hy", "\u0627\u0631\u0645\u06cc\u0646\u06cc" },
            { "ia", "\u0628\u06cc\u0646 \u0644\u0633\u0627\u0646\u06cc\u0627\u062a" },
            { "IC", "\u06a9\u06cc\u0646\u0631\u06cc \u0622\u0626\u0644\u06cc\u0646\u0688\u0632" },
            { "ID", "\u0627\u0646\u0688\u0648\u0646\u06cc\u0634\u06cc\u0627" },
            { "id", "\u0627\u0646\u0688\u0648\u0646\u06cc\u062b\u06cc\u0627\u0626\u06cc" },
            { "type.nu.tibt", "\u062a\u0628\u062a\u06cc \u0627\u0639\u062f\u0627\u062f" },
            { "IE", "\u0622\u0626\u0631\u0644\u06cc\u0646\u0688" },
            { "ig", "\u0627\u0650\u06af\u0628\u0648" },
            { "naq", "\u0646\u0627\u0645\u0627" },
            { "ii", "\u0633\u0686\u0648\u0627\u0646 \u0627\u06cc" },
            { "IL", "\u0627\u0633\u0631\u0627\u0626\u06cc\u0644" },
            { "IM", "\u0622\u0626\u0644 \u0622\u0641 \u0645\u06cc\u0646" },
            { "IN", "\u0628\u06be\u0627\u0631\u062a" },
            { "IO", "\u0628\u0631\u0637\u0627\u0646\u0648\u06cc \u06c1\u0646\u062f\u0648\u0633\u062a\u0627\u0646\u06cc \u0633\u0645\u0646\u062f\u0631\u06cc \u062e\u0637\u06c1" },
            { "IQ", "\u0639\u0631\u0627\u0642" },
            { "IR", "\u0627\u06cc\u0631\u0627\u0646" },
            { "IS", "\u0622\u0626\u0633 \u0644\u06cc\u0646\u0688" },
            { "is", "\u0622\u0626\u0633 \u0644\u06cc\u0646\u0688\u06a9" },
            { "IT", "\u0627\u0679\u0644\u06cc" },
            { "it", "\u0627\u0637\u0627\u0644\u0648\u06cc" },
            { "iu", "\u0627\u06cc\u0646\u064f\u06a9\u0679\u06cc\u0679\u0679" },
            { "type.nu.thai", "\u062a\u06be\u0627\u0626\u06cc \u06c1\u0646\u062f\u0633\u06d2" },
            { "type.nu.beng", "\u0628\u0646\u06af\u0627\u0644\u06cc \u06c1\u0646\u062f\u0633\u06d2" },
            { "ja", metaValue_ja },
            { "Mlym", "\u0645\u0644\u06cc\u0627\u0644\u0645" },
            { "JE", "\u062c\u0631\u0633\u06cc" },
            { "type.ca.islamic", "\u0627\u0633\u0644\u0627\u0645\u06cc \u06a9\u06cc\u0644\u0646\u0688\u0631" },
            { "Beng", metaValue_bn },
            { "JM", "\u062c\u0645\u0627\u0626\u06cc\u06a9\u0627" },
            { "JO", "\u0627\u0631\u062f\u0646" },
            { "JP", "\u062c\u0627\u067e\u0627\u0646" },
            { "sma", "\u062c\u0646\u0648\u0628\u06cc \u0633\u0627\u0645\u06cc" },
            { "jv", "\u062c\u0627\u0648\u06cc" },
            { "guz", "\u06af\u0633\u06cc" },
            { "type.nu.knda", "\u06a9\u0646\u0691 \u06c1\u0646\u062f\u0633\u06d2" },
            { "smj", "\u0644\u0648\u0644 \u0633\u0627\u0645\u06cc" },
            { "de_CH", "\u0633\u0648\u0626\u0633 \u06c1\u0627\u0626\u06cc \u062c\u0631\u0645\u0646" },
            { "smn", "\u0627\u0646\u0627\u0631\u06cc \u0633\u0627\u0645\u06cc" },
            { "type.co.phonetic", "\u0635\u0648\u062a\u06cc \u0686\u06be\u0679\u0627\u0626\u06cc \u06a9\u06cc \u062a\u0631\u062a\u06cc\u0628" },
            { "ka", "\u062c\u0627\u0631\u062c\u06cc" },
            { "type.ca.buddhist", "\u0628\u0648\u062f\u06be \u06a9\u0644\u06cc\u0646\u0688\u0631" },
            { "sms", "\u0633\u06a9\u0648\u0644\u0679 \u0633\u0627\u0645\u06cc" },
            { "KE", "\u06a9\u06cc\u0646\u06cc\u0627" },
            { "419", "\u0644\u0627\u0637\u06cc\u0646\u06cc \u0627\u0645\u0631\u06cc\u06a9\u06c1" },
            { "KG", "\u06a9\u0631\u063a\u0632\u0633\u062a\u0627\u0646" },
            { "kg", "\u06a9\u0627\u0646\u06af\u0648" },
            { "KH", "\u06a9\u0645\u0628\u0648\u0688\u06cc\u0627" },
            { "KI", "\u06a9\u0631\u06cc\u0628\u0627\u062a\u06cc" },
            { "ki", "\u06a9\u06cc\u06a9\u0648\u06cc\u0648" },
            { "mas", "\u0645\u0627\u0633\u0627\u06cc" },
            { "kk", "\u0642\u0632\u0627\u062e" },
            { "kl", "\u0643\u0627\u0644\u0627\u0644\u064a\u0633\u062a" },
            { "km", metaValue_km },
            { "KM", "\u06a9\u0648\u0645\u0648\u0631\u0648\u0633" },
            { "KN", "\u0633\u06cc\u0646\u0679 \u06a9\u0679\u0633 \u0627\u0648\u0631 \u0646\u06cc\u0648\u06cc\u0633" },
            { "kn", "\u06a9\u0646\u0651\u0627\u0688\u0627" },
            { "Knda", "\u06a9\u0646\u0691" },
            { "fr_CA", "\u06a9\u06cc\u0646\u06cc\u0688\u06cc\u0646 \u0641\u0631\u0627\u0646\u0633\u06cc\u0633\u06cc" },
            { "type.colStrength.identical", "\u0633\u0628\u06be\u06cc \u06a9\u06cc \u0686\u06be\u0679\u0627\u0626\u06cc \u06a9\u0631\u06cc\u06ba" },
            { "ko", metaValue_ko },
            { "KP", "\u0634\u0645\u0627\u0644\u06cc \u06a9\u0648\u0631\u06cc\u0627" },
            { "KR", "\u062c\u0646\u0648\u0628\u06cc \u06a9\u0648\u0631\u06cc\u0627" },
            { "ks", "\u06a9\u0634\u0645\u06cc\u0631\u06cc" },
            { "ku", "\u06a9\u0631\u062f\u0634" },
            { "fr_CH", "\u0633\u0648\u0626\u0633 \u0641\u0631\u06cc\u0646\u0686" },
            { "KW", "\u06a9\u0648\u06cc\u062a" },
            { "kw", "\u06a9\u0648\u0631\u0646\u0634" },
            { "tpi", "\u0679\u0648\u06a9 \u067e\u0650\u0633\u0650\u0646" },
            { "KY", "\u06a9\u06cc\u0645\u06cc\u0646 \u0622\u0626\u0644\u06cc\u0646\u0688\u0632" },
            { "ky", "\u06a9\u0631\u063a\u06cc\u0632\u06cc" },
            { "KZ", "\u0642\u0632\u0627\u062e\u0633\u062a\u0627\u0646" },
            { "Cyrl", "\u0633\u06cc\u0631\u06cc\u0644\u06a9" },
            { "type.colStrength.primary", "\u0635\u0631\u0641 \u0627\u0633\u0627\u0633\u06cc \u062d\u0631\u0648\u0641 \u06a9\u06cc \u0686\u06be\u0679\u0627\u0626\u06cc \u06a9\u0631\u06cc\u06ba" },
            { "la", metaValue_la },
            { "LA", "\u0644\u0627\u0624\u0633" },
            { "LB", "\u0644\u0628\u0646\u0627\u0646" },
            { "lb", "\u0644\u06af\u0698\u0645\u0628\u0631\u06af\u0634" },
            { "LC", "\u0633\u06cc\u0646\u0679 \u0644\u0648\u0633\u06cc\u0627" },
            { "type.nu.mlym", "\u0645\u0644\u06cc\u0627\u0644\u0645 \u06c1\u0646\u062f\u0633\u06d2" },
            { "lg", "\u06af\u06cc\u0646\u0688\u0627" },
            { "nds", "\u0627\u062f\u0646\u06cc \u062c\u0631\u0645\u0646" },
            { "LI", "\u0644\u06cc\u0634\u0679\u0646\u0633\u0679\u0627\u0626\u0646" },
            { "LK", "\u0633\u0631\u06cc \u0644\u0646\u06a9\u0627" },
            { "Tibt", metaValue_bo },
            { "ln", "\u0644\u0650\u0646\u06af\u064e\u0644\u0627" },
            { "type.colCaseLevel.no", "\u062d\u0631\u0648\u0641 \u06a9\u06cc \u0639\u062f\u0645 \u062d\u0633\u0627\u0633\u06cc\u062a \u06a9\u06cc \u0686\u06be\u0679\u0627\u0626\u06cc \u06a9\u0631\u06cc\u06ba" },
            { "lo", metaValue_lo },
            { "type.ms.uksystem", "\u067e\u06cc\u0645\u0627\u0626\u0634 \u06a9\u0627 \u0627\u0645\u067e\u06cc\u0631\u06cc\u0644 \u0646\u0638\u0627\u0645" },
            { "type.colStrength.tertiary", "\u0644\u06c1\u062c\u0648\u06ba/\u062d\u0631\u0648\u0641/\u0686\u0648\u0691\u0627\u0626\u06cc \u06a9\u06cc \u0686\u06be\u0679\u0627\u0626\u06cc \u06a9\u0631\u06cc\u06ba" },
            { "LR", "\u0644\u0627\u0626\u0628\u06cc\u0631\u06cc\u0627" },
            { "LS", "\u0644\u06cc\u0633\u0648\u062a\u06be\u0648" },
            { "LT", "\u0644\u062a\u06be\u0648\u0627\u0646\u06cc\u0627" },
            { "lt", "\u0644\u062a\u06be\u064f\u0648\u0627\u06cc\u0646\u06cc\u0646" },
            { "LU", "\u0644\u06af\u0698\u0645\u0628\u0631\u06af" },
            { "lu", "\u0644\u0628\u0627-\u0643\u0627\u062a\u0627\u0646\u062c\u0627" },
            { "LV", "\u0644\u0679\u0648\u06cc\u0627" },
            { "lv", "\u0644\u06cc\u0679\u0648\u06cc\u0646" },
            { "Kana", "\u06a9\u0679\u0627\u06a9\u0627\u0646\u0627" },
            { "LY", "\u0644\u06cc\u0628\u06cc\u0627" },
            { "ListCompositionPattern", "{0}\u060c{1}" },
            { "vun", "\u0648\u0646\u062c\u0648" },
            { "lag", "\u0644\u0627\u0646\u06af\u06cc" },
            { "Thaa", "\u062a\u06be\u0627\u0646\u0627" },
            { "MA", "\u0645\u0631\u0627\u0642\u0634" },
            { "MC", "\u0645\u0648\u0646\u0627\u06a9\u0648" },
            { "MD", metaValue_MD },
            { "ME", "\u0645\u0648\u0646\u0679\u06d2 \u0646\u06cc\u06af\u0631\u0648" },
            { "MF", "\u0633\u06cc\u0646\u0679 \u0645\u0627\u0631\u0679\u0646" },
            { "MG", "\u0645\u0688\u063a\u0627\u0633\u06a9\u0631" },
            { "mg", "\u0645\u0644\u0627\u06af\u0627\u0633\u06cc" },
            { "Thai", metaValue_th },
            { "MH", "\u0645\u0627\u0631\u0634\u0644 \u0622\u0626\u0644\u06cc\u0646\u0688\u0632" },
            { "type.co.ducet", "\u0688\u06cc\u0641\u0627\u0644\u0679 \u06cc\u0648\u0646\u06cc\u06a9\u0648\u0688 \u06a9\u06cc \u0686\u06be\u0679\u0646\u06cc \u06a9\u06cc \u062a\u0631\u062a\u06cc\u0628" },
            { "mi", "\u0645\u0627\u0624\u0631\u06cc" },
            { "type.nu.vaii", "\u0648\u0627\u0626\u06cc \u06c1\u0646\u062f\u0633\u06d2" },
            { "MK", "\u0645\u0642\u062f\u0648\u0646\u06cc\u06c1" },
            { "mk", "\u0645\u0642\u062f\u0648\u0646\u06cc\u0627\u0626\u06cc" },
            { "ML", "\u0645\u0627\u0644\u06cc" },
            { "ml", "\u0645\u0627\u0644\u0627\u06cc\u0627\u0644\u0645" },
            { "MM", "\u0645\u06cc\u0627\u0646\u0645\u0627\u0631 (\u0628\u0631\u0645\u0627)" },
            { "MN", "\u0645\u0646\u06af\u0648\u0644\u06cc\u0627" },
            { "mn", "\u0645\u0646\u06af\u0624\u0644\u06cc" },
            { "MO", "\u0645\u06a9\u0627\u0624 SAR \u0686\u06cc\u0646" },
            { "MP", "\u0634\u0645\u0627\u0644\u06cc \u0645\u0627\u0631\u06cc\u0627\u0646\u0627 \u0622\u0626\u0644\u06cc\u0646\u0688\u0632" },
            { "MQ", "\u0645\u0627\u0631\u0679\u06cc\u0646\u06a9" },
            { "MR", "\u0645\u0648\u0631\u06cc\u0637\u0627\u0646\u06cc\u06c1" },
            { "mr", "\u0645\u0631\u0627\u0679\u0647\u06cc" },
            { "MS", "\u0645\u0648\u0646\u0679\u0633\u06cc\u0631\u0627\u0679" },
            { "ms", "\u0645\u0627\u0644\u0627\u0626\u06cc" },
            { "type.colAlternate.non-ignorable", "\u0639\u0644\u0627\u0645\u0627\u062a \u06a9\u06cc \u0686\u06be\u0679\u0627\u0626\u06cc \u06a9\u0631\u06cc\u06ba" },
            { "MT", "\u0645\u0627\u0644\u0679\u0627" },
            { "mt", "\u0645\u0627\u0644\u0679\u06cc" },
            { "MU", "\u0645\u0627\u0631\u06cc\u0634\u0633" },
            { "MV", "\u0645\u0627\u0644\u062f\u06cc\u067e" },
            { "MW", "\u0645\u0644\u0627\u0648\u06cc" },
            { "MX", "\u0645\u06cc\u06a9\u0633\u06cc\u06a9\u0648" },
            { "type.ca.japanese", "\u062c\u0627\u067e\u0627\u0646\u06cc \u06a9\u06cc\u0644\u0646\u0688\u0631" },
            { "MY", "\u0645\u0644\u06cc\u0634\u06cc\u0627" },
            { "my", "\u0628\u0631\u0645\u06cc" },
            { "MZ", "\u0645\u0648\u0632\u0645\u0628\u06cc\u0642" },
            { "Armn", "\u0622\u0631\u0645\u06cc\u0646\u06cc\u0627\u0626\u06cc" },
            { "dsb", "\u0630\u06cc\u0644\u06cc \u0633\u0631\u0628\u06cc\u0627\u0626\u06cc" },
            { "NA", "\u0646\u0627\u0645\u06cc\u0628\u06cc\u0627" },
            { "type.co.search", "\u0639\u0627\u0645-\u0645\u0642\u0635\u062f \u06a9\u06cc \u062a\u0644\u0627\u0634" },
            { "nb", "\u0646\u0627\u0631\u0648\u06cc\u062c\u06cc\u0646 \u0628\u0648\u06a9\u0645\u0644" },
            { "type.ca.hebrew", "\u0639\u0628\u0631\u0627\u0646\u06cc \u06a9\u06cc\u0644\u0646\u0688\u0631" },
            { "type.co.dictionary", "\u0644\u063a\u062a \u06a9\u06cc \u0686\u06be\u0679\u0646\u06cc \u06a9\u06cc \u062a\u0631\u062a\u06cc\u0628" },
            { "NC", "\u0646\u06cc\u0648 \u06a9\u0644\u06cc\u0688\u0648\u0646\u06cc\u0627" },
            { "nd", "\u0634\u0645\u0627\u0644\u06cc \u062f\u0628\u06cc\u0644" },
            { "NE", "\u0646\u0627\u0626\u062c\u0631" },
            { "ne", "\u0646\u06cc\u067e\u0627\u0644\u06cc" },
            { "NF", "\u0646\u0627\u0631\u0641\u0648\u06a9 \u0622\u0626\u0644\u06cc\u0646\u0688" },
            { "NG", "\u0646\u0627\u0626\u062c\u06cc\u0631\u06cc\u0627" },
            { "NI", "\u0646\u06a9\u0627\u0631\u0627\u06af\u0648\u0648\u0627" },
            { "NL", "\u0646\u06cc\u062f\u0631 \u0644\u06cc\u0646\u0688\u0632" },
            { "nl", "\u0688\u0686" },
            { "nn", "\u0646\u0648\u0631\u0648\u06cc\u062c\u06cc\u0646\u06cc \u0646\u06cc\u0646\u0648\u0631\u0633\u06a9" },
            { "NO", "\u0646\u0627\u0631\u0648\u06d2" },
            { "no", "\u0646\u0627\u0631\u0648\u06cc\u062c\u06cc\u0646" },
            { "NP", "\u0646\u06cc\u067e\u0627\u0644" },
            { "NR", "\u0646\u0624\u0631\u0648" },
            { "NU", "\u0646\u06cc\u0626\u0648" },
            { "rof", "\u0631\u0648\u0645\u0628\u0648" },
            { "ny", "\u0646\u06cc\u0627\u0646\u062c\u0627" },
            { "NZ", "\u0646\u06cc\u0648\u0632\u06cc \u06cc\u0646\u0688" },
            { "kab", "\u0642\u0628\u0627\u0626\u0644\u06cc" },
            { "type.colCaseFirst.lower", "\u067e\u06c1\u0644\u06d2 \u0686\u06be\u0648\u0679\u06d2 \u062d\u0631\u0648\u0641 \u06a9\u06cc \u0686\u06be\u0679\u0627\u0626\u06cc \u06a9\u0631\u06cc\u06ba" },
            { "oc", "\u0622\u0643\u0633\u06cc\u0679\u0627\u0646" },
            { "kam", "\u06a9\u0627\u0645\u0628\u0627" },
            { "type.colAlternate.shifted", "\u0639\u0644\u0627\u0645\u0627\u062a \u06a9\u0648 \u0646\u0638\u0631\u0627\u0646\u062f\u0627\u0632 \u06a9\u0631\u06a9\u06d2 \u0686\u06be\u0679\u0627\u0626\u06cc \u06a9\u0631\u06cc\u06ba" },
            { "mer", "\u0645\u06cc\u0631\u0648" },
            { "type.nu.armn", "\u0622\u0631\u0645\u06cc\u0646\u06cc\u0627\u0626\u06cc \u0627\u0639\u062f\u0627\u062f" },
            { "OM", "\u0639\u0645\u0627\u0646" },
            { "om", "\u0627\u0648\u0631\u0648\u0645\u0648" },
            { "or", "\u0627\u0648\u0631\u0650\u06cc\u0627" },
            { "os", "\u0627\u0648\u0633\u06cc\u0679\u06a9" },
            { "mfe", "\u0645\u0648\u0631\u06cc\u0633\u06cc\u06cc\u0646" },
            { "PA", "\u067e\u0646\u0627\u0645\u06c1" },
            { "pa", "\u067e\u0646\u062c\u0627\u0628\u06cc" },
            { "dua", "\u062f\u0648\u0627\u0644\u0627" },
            { "type.ca.islamic-civil", "\u0627\u0633\u0644\u0627\u0645\u06cc \u0634\u06c1\u0631\u06cc \u06a9\u06cc\u0644\u0646\u0688\u0631" },
            { "en_GB", "\u0628\u0631\u0637\u0627\u0646\u0648\u06cc \u0627\u0646\u06af\u0631\u06cc\u0632\u06cc" },
            { "PE", "\u067e\u06cc\u0631\u0648" },
            { "PF", "\u0641\u0631\u0627\u0646\u0633\u06cc\u0633\u06cc \u067e\u0648\u0644\u06cc\u0646\u06cc\u0634\u06cc\u0627" },
            { "PG", "\u067e\u0627\u067e\u0648\u0622 \u0646\u06cc\u0648 \u06af\u0646\u06cc" },
            { "PH", "\u0641\u0644\u067e\u0627\u0626\u0646\u06cc" },
            { "PK", "\u067e\u0627\u06a9\u0633\u062a\u0627\u0646" },
            { "PL", "\u067e\u0648\u0644\u06cc\u0646\u0688" },
            { "pl", "\u067e\u0648\u0644\u0633\u062a\u0627\u0646\u06cc" },
            { "PM", "\u0633\u06cc\u0646\u0679 \u067e\u06cc\u0626\u0631 \u0627\u0648\u0631 \u0645\u06cc\u06a9\u0644\u06cc\u0626\u0648\u0646" },
            { "PN", "\u067e\u0679\u06a9\u0627\u0626\u0631\u0646 \u062c\u0632\u0627\u0626\u0631" },
            { "type.ca.dangi", "\u0688\u0627\u0646\u06af\u06cc \u06a9\u06cc\u0644\u0646\u0688\u0631" },
            { "type.colBackwards.yes", "\u0644\u06c1\u062c\u0648\u06ba \u06a9\u06cc \u0645\u0639\u06a9\u0648\u0633 \u0686\u06be\u0679\u0627\u0626\u06cc \u06a9\u0631\u06cc\u06ba" },
            { "PR", "\u067e\u06cc\u0648\u0631\u0679\u0648 \u0631\u06cc\u06a9\u0648" },
            { "PS", "\u0641\u0644\u0633\u0637\u06cc\u0646\u06cc \u062e\u0637\u06d2" },
            { "ps", "\u067e\u0634\u062a\u0648" },
            { "PT", "\u067e\u0631\u062a\u06af\u0627\u0644" },
            { "pt", "\u067e\u064f\u0631\u062a\u06af\u0627\u0644\u06cc" },
            { "key.co", "\u0686\u06be\u0679\u0627\u0626\u06cc \u06a9\u06cc \u062a\u0631\u062a\u06cc\u0628" },
            { "PW", "\u067e\u0644\u0627\u0624" },
            { "type.nu.greklow", "\u06cc\u0648\u0646\u0627\u0646\u06cc \u0632\u06cc\u0631\u06cc\u06ba \u0627\u0639\u062f\u0627\u062f" },
            { "PY", "\u067e\u06cc\u0631\u0627\u06af\u0648\u0626\u06d2" },
            { "pt_BR", "\u0628\u0631\u0627\u0632\u06cc\u0644\u06cc \u067e\u0631\u062a\u06af\u0627\u0644\u06cc" },
            { "tum", "\u0679\u0645\u0628\u0648\u06a9\u0627" },
            { "Hebr", metaValue_he },
            { "mgh", "\u0645\u0627\u062e\u0627\u0648\u0627-\u0645\u064a\u062a\u0648" },
            { "QA", "\u0642\u0637\u0631" },
            { "key.ca", "\u06a9\u06cc\u0644\u0646\u0688\u0631" },
            { "Laoo", metaValue_lo },
            { "mgo", "\u0645\u06cc\u0679\u0627" },
            { "type.hc.h23", "24 \u06af\u06be\u0646\u0679\u06d2 \u06a9\u0627 \u0646\u0638\u0627\u0645 (0\u201323)" },
            { "type.hc.h24", "24 \u06af\u06be\u0646\u0679\u06d2 \u06a9\u0627 \u0646\u0638\u0627\u0645 (1\u201324)" },
            { "type.nu.mymr", "\u0645\u06cc\u0627\u0646\u0645\u0627\u0631 \u06a9\u06d2 \u06c1\u0646\u062f\u0633\u06d2" },
            { "QO", "\u0628\u06cc\u0631\u0648\u0646\u06cc \u0627\u0648\u0634\u06cc\u0627\u0646\u06cc\u0627" },
            { "qu", "\u06a9\u0648\u06cc\u0686\u0648\u0622" },
            { "brx", "\u0628\u0648\u0688\u0648" },
            { "kde", "\u0645\u0627\u0643\u0648\u0646\u062f\u0647" },
            { "001", "\u062f\u0646\u06cc\u0627" },
            { "Ethi", "\u0627\u06cc\u062a\u06be\u0648\u067e\u06cc\u0627\u0626\u06cc" },
            { "002", "\u0627\u0641\u0631\u06cc\u0642\u06c1" },
            { "003", "\u0634\u0645\u0627\u0644\u06cc \u0627\u0645\u0631\u06cc\u06a9\u06c1" },
            { "RE", "\u0631\u06cc \u06cc\u0648\u0646\u06cc\u0646" },
            { "type.colNormalization.no", "\u062d\u0633\u0628 \u0645\u0639\u0645\u0648\u0644 \u0628\u0646\u0627\u0626\u06d2 \u0628\u063a\u06cc\u0631 \u0686\u06be\u0679\u0627\u0626\u06cc \u06a9\u0631\u06cc\u06ba" },
            { "type.hc.h12", "12 \u06af\u06be\u0646\u0679\u06d2 \u06a9\u0627 \u0646\u0638\u0627\u0645 (1\u201312)" },
            { "005", "\u062c\u0646\u0648\u0628\u06cc \u0627\u0645\u0631\u06cc\u06a9\u06c1" },
            { "type.hc.h11", "12 \u06af\u06be\u0646\u0679\u06d2 \u06a9\u0627 \u0646\u0638\u0627\u0645 (0\u201311)" },
            { "009", "\u0627\u0648\u0634\u06cc\u0627\u0646\u06cc\u0627" },
            { "rm", "\u0631\u0648\u0645\u0627\u0646\u0634" },
            { "rn", "\u0631\u0648\u0646\u0688\u06cc" },
            { "key.cu", "\u06a9\u0631\u0646\u0633\u06cc" },
            { "RO", "\u0631\u0648\u0645\u0627\u0646\u06cc\u0627" },
            { "ro", "\u0631\u0648\u0645\u06cc\u0646\u06cc\u0646" },
            { "RS", "\u0633\u0631\u0628\u06cc\u0627" },
            { "type.nu.orya", "\u0627\u0691\u06cc\u06c1 \u06c1\u0646\u062f\u0633\u06d2" },
            { "type.nu.hanidec", "\u0686\u06cc\u0646\u06cc \u0627\u0639\u0634\u0627\u0631\u06cc \u0627\u0639\u062f\u0627\u062f" },
            { "RU", "\u0631\u0648\u0633" },
            { "ru", "\u0631\u0648\u0633\u06cc" },
            { "RW", "\u0631\u0648\u0627\u0646\u0688\u0627" },
            { "rw", "\u06a9\u06cc\u0646\u06cc\u0627\u0631\u0648\u0627\u0646\u0688\u0627" },
            { "kea", "\u0643\u0627\u0628\u0648\u064a\u0631\u062f\u064a\u0627\u0646\u0648" },
            { "en_AU", "\u0622\u0633\u0679\u0631\u06cc\u0644\u06cc\u0627\u0626\u06cc \u0627\u0646\u06af\u0631\u06cc\u0632\u06cc" },
            { "key.colAlternate", "\u0639\u0644\u0627\u0645\u0627\u062a \u06a9\u06cc \u0686\u06be\u0679\u0627\u0626\u06cc \u0646\u0638\u0631\u0627\u0646\u062f\u0627\u0632 \u06a9\u0631\u06cc\u06ba" },
            { "SA", "\u0633\u0639\u0648\u062f\u06cc \u0639\u0631\u0628" },
            { "sa", "\u0633\u064e\u0646\u0633\u06a9\u0631\u0650\u062a" },
            { "SB", "\u0633\u0648\u0644\u0648\u0645\u0646 \u0622\u0626\u0644\u06cc\u0646\u0688\u0632" },
            { "twq", "\u062a\u0627\u0633\u0627\u0648\u0627\u0642" },
            { "011", "\u0645\u063a\u0631\u0628\u06cc \u0627\u0641\u0631\u06cc\u0642\u06c1" },
            { "SC", "\u0633\u0634\u0644\u06cc\u0632" },
            { "SD", "\u0633\u0648\u0688\u0627\u0646" },
            { "sd", "\u0633\u0646\u062f\u06be\u06cc" },
            { "013", "\u0648\u0633\u0637\u06cc \u0627\u0645\u0631\u06cc\u06a9\u06c1" },
            { "SE", "\u0633\u0648\u06cc\u0688\u0646" },
            { "se", "\u0634\u0645\u0627\u0644\u06cc \u0633\u0627\u0645\u06cc" },
            { "014", "\u0645\u0634\u0631\u0642\u06cc \u0627\u0641\u0631\u06cc\u0642\u06c1" },
            { "015", "\u0634\u0645\u0627\u0644\u06cc \u0627\u0641\u0631\u06cc\u0642\u06c1" },
            { "SG", "\u0633\u0646\u06af\u0627\u067e\u0648\u0631" },
            { "sg", "\u0633\u0627\u06ba\u063a\u0648" },
            { "SH", "\u0633\u06cc\u0646\u0679 \u06c1\u06cc\u0644\u06cc\u0646\u0627" },
            { "sh", "\u0633\u0631\u0628\u0648-\u06a9\u0631\u0648\u0626\u06cc\u0634\u06cc\u0646" },
            { "type.lb.strict", "\u0633\u062e\u062a \u0644\u0627\u0626\u0646 \u0628\u0631\u06cc\u06a9 \u0627\u0646\u062f\u0627\u0632" },
            { "si", metaValue_si },
            { "017", "\u0648\u0633\u0637\u06cc \u0627\u0641\u0631\u06cc\u0642\u06c1" },
            { "SI", "\u0633\u0644\u0648\u0648\u06cc\u0646\u06cc\u0627" },
            { "018", "\u062c\u0646\u0648\u0628\u06cc \u0627\u0641\u0631\u06cc\u0642\u06c1 \u06a9\u06d2 \u0639\u0644\u0627\u0642\u06c1" },
            { "SJ", "\u0633\u0648\u0627\u0644\u0628\u0631\u0688 \u0627\u0648\u0631 \u062c\u0627\u0646 \u0645\u0627\u06cc\u0646" },
            { "019", "\u0627\u0645\u06cc\u0631\u06cc\u06a9\u0627\u0632" },
            { "SK", "\u0633\u0644\u0648\u0648\u0627\u06a9\u06cc\u06c1" },
            { "sk", "\u0633\u0644\u0648\u0648\u0627\u06a9" },
            { "SL", "\u0633\u06cc\u0626\u0631 \u0644\u06cc\u0648\u0646" },
            { "sl", "\u0633\u0644\u0648\u0648\u06cc\u0646\u06cc\u0627\u0626\u06cc" },
            { "SM", "\u0633\u0627\u0646 \u0645\u0627\u0631\u06cc\u0646\u0648" },
            { "sm", "\u0633\u0627\u0645\u0648\u0622\u0646" },
            { "SN", "\u0633\u06cc\u0646\u06cc\u06af\u0644" },
            { "sn", "\u0634\u0648\u0646\u0627" },
            { "SO", "\u0635\u0648\u0645\u0627\u0644\u06cc\u06c1" },
            { "so", "\u0635\u0648\u0645\u0627\u0644\u06cc" },
            { "arn", "\u0645\u0627\u067e\u0648\u0686\u06d2" },
            { "type.nu.arab", "\u0639\u0631\u0628\u06cc \u06c1\u0646\u062f\u06cc \u06c1\u0646\u062f\u0633\u06d2" },
            { "sq", "\u0627\u0644\u0628\u0627\u0646\u06cc" },
            { "type.nu.taml", "\u0631\u0648\u0627\u06cc\u062a\u06cc \u062a\u0645\u0644 \u0627\u0639\u062f\u0627\u062f" },
            { "SR", "\u0633\u0648\u0631\u06cc\u0646\u0627\u0645" },
            { "sr", "\u0635\u0631\u0628\u06cc" },
            { "SS", "\u062c\u0646\u0648\u0628\u06cc \u0633\u0648\u0688\u0627\u0646" },
            { "ss", "\u0633\u0648\u0627\u062a\u06cc" },
            { "ST", "\u0633\u0627\u0624 \u0679\u0648\u0645 \u0627\u0648\u0631 \u067e\u0631\u0646\u0633\u067e\u06d2" },
            { "st", "\u062c\u0646\u0648\u0628\u06cc \u0633\u0648\u062a\u06be\u0648" },
            { "su", "\u0633\u0646\u0688\u0627\u0646\u06cc\u0632" },
            { "SV", "\u0627\u0644 \u0633\u0644\u0648\u0627\u0688\u0648\u0631" },
            { "sv", "\u0633\u0648\u06cc\u0688\u0634" },
            { "sw", "\u0633\u0648\u0627\u062d\u0644\u06cc" },
            { "SX", "\u0633\u0646\u0679 \u0645\u0627\u0631\u0679\u0646" },
            { "SY", "\u0634\u0627\u0645" },
            { "type.nu.hantfin", "\u0631\u0648\u0627\u06cc\u062a\u06cc \u0686\u06cc\u0646\u06cc \u0645\u0627\u0644\u06cc \u0627\u0639\u062f\u0627\u062f" },
            { "SZ", "\u0633\u0648\u0627\u0632\u06cc \u0644\u06cc\u0646\u0688" },
            { "ta", metaValue_ta },
            { "TA", "\u0679\u0631\u0633\u0679\u0646 \u0688\u0627 \u06a9\u06cc\u0648\u0646\u06c1\u0627" },
            { "asa", "\u0622\u0633\u0648" },
            { "type.ms.ussystem", "\u067e\u06cc\u0645\u0627\u0626\u0634 \u06a9\u0627 \u0628\u0631\u0637\u0627\u0646\u0648\u06cc \u0646\u0638\u0627\u0645" },
            { "021", "\u0634\u0645\u0627\u0644\u06cc \u0627\u0645\u0631\u06cc\u06a9\u06c1 \u06a9\u0627 \u0639\u0644\u0627\u0642\u06c1" },
            { "142", "\u0627\u06cc\u0634\u06cc\u0627" },
            { "TC", "\u062a\u0631\u06a9\u0633 \u0627\u0648\u0631 \u06a9\u06cc\u06a9\u0627\u0624\u0633 \u062c\u0632\u0627\u0626\u0631" },
            { "143", "\u0648\u0633\u0637\u06cc \u0627\u06cc\u0634\u06cc\u0627" },
            { "TD", "\u0686\u0627\u0688" },
            { "te", metaValue_te },
            { "145", "\u0645\u063a\u0631\u0628\u06cc \u0627\u06cc\u0634\u06cc\u0627" },
            { "TF", "\u0641\u0631\u0627\u0646\u0633\u06cc\u0633\u06cc \u062c\u0646\u0648\u0628\u06cc \u062e\u0637\u06d2" },
            { "TG", "\u0679\u0648\u06af\u0648" },
            { "tg", "\u062a\u0627\u062c\u06a9" },
            { "th", metaValue_th },
            { "TH", "\u062a\u06be\u0627\u0626\u06cc \u0644\u06cc\u0646\u0688" },
            { "ti", "\u0679\u06af\u0631\u06cc\u0646\u06cc\u0627" },
            { "type.colNumeric.yes", "\u0627\u0639\u062f\u0627\u062f \u06a9\u06d2 \u0644\u062d\u0627\u0638 \u0633\u06d2 \u06c1\u0646\u062f\u0633\u0648\u06ba \u06a9\u06cc \u0686\u06be\u0679\u0627\u0626\u06cc \u06a9\u0631\u06cc\u06ba" },
            { "TJ", "\u062a\u0627\u062c\u06a9\u0633\u062a\u0627\u0646" },
            { "en_CA", "\u06a9\u06cc\u0646\u06cc\u0688\u06cc\u0646 \u0627\u0646\u06af\u0631\u06cc\u0632\u06cc" },
            { "029", "\u06a9\u0631\u06cc\u0628\u06cc\u0627\u0626\u06cc" },
            { "TK", "\u0679\u0648\u06a9\u06cc\u0644\u0627\u0624" },
            { "tk", "\u062a\u0631\u06a9\u0645\u0627\u0646" },
            { "TL", "\u062a\u06cc\u0645\u0648\u0631 \u0644\u06cc\u0633\u0679" },
            { "type.co.searchjl", "Hangul Initial Consonant \u06a9\u06d2 \u0644\u062d\u0627\u0638 \u0633\u06d2 \u062a\u0644\u0627\u0634 \u06a9\u0631\u06cc\u06ba" },
            { "TM", "\u062a\u0631\u06a9\u0645\u0627\u0646\u0633\u062a\u0627\u0646" },
            { "TN", "\u062a\u06cc\u0648\u0646\u06cc\u0633\u06cc\u0627" },
            { "tn", "\u0633\u0648\u0627\u0646\u0627" },
            { "TO", "\u0679\u0648\u0646\u06af\u0627" },
            { "to", "\u0679\u0648\u0646\u06af\u0646" },
            { "dyo", "\u062c\u0648\u0644\u0627 \u0641\u0648\u0646\u064a\u0627" },
            { "type.nu.jpan", "\u062c\u0627\u067e\u0627\u0646\u06cc \u0627\u0639\u062f\u0627\u062f" },
            { "tr", metaValue_TR },
            { "TR", metaValue_TR },
            { "ts", "\u0632\u0648\u0646\u06af\u0627" },
            { "TT", "\u062a\u0631\u06cc\u0646\u06cc\u062f\u0627\u062f \u0627\u0648\u0631 \u0679\u0648\u0628\u0627\u06af\u0648" },
            { "tt", "\u062a\u0627\u062a\u0627\u0631" },
            { "TV", "\u0679\u0648\u0648\u0627\u0644\u0648" },
            { "TW", "\u062a\u0627\u0626\u06cc\u0648\u0627\u0646" },
            { "ty", "\u062a\u0627\u06c1\u06cc\u062a\u06cc" },
            { "TZ", "\u062a\u0646\u0632\u0627\u0646\u06cc\u06c1" },
            { "nmg", "\u0643\u0648\u0627\u064a\u0633\u0648" },
            { "Zzzz", "\u0646\u0627\u0645\u0639\u0644\u0648\u0645 \u0631\u0633\u0645 \u0627\u0644\u062e\u0637" },
            { "150", "\u06cc\u0648\u0631\u067e" },
            { "UA", "\u06cc\u0648\u06a9\u0631\u06cc\u0646" },
            { "key.colHiraganaQuaternary", "Kena \u0686\u06be\u0679\u0627\u0626\u06cc" },
            { "030", "\u0645\u0634\u0631\u0642\u06cc \u0627\u06cc\u0634\u06cc\u0627" },
            { "151", "\u0645\u0634\u0631\u0642\u06cc \u06cc\u0648\u0631\u067e" },
            { "154", "\u0634\u0645\u0627\u0644\u06cc \u06cc\u0648\u0631\u067e" },
            { "sw_CD", "\u06a9\u0627\u0646\u06af\u0648 \u0633\u0648\u0627\u062d\u0644\u06cc" },
            { "034", "\u062c\u0646\u0648\u0628\u06cc \u0627\u06cc\u0634\u06cc\u0627" },
            { "155", "\u0645\u063a\u0631\u0628\u06cc \u06cc\u0648\u0631\u067e" },
            { "035", "\u062c\u0646\u0648\u0628 \u0645\u0634\u0631\u0642\u06cc \u0627\u06cc\u0634\u06cc\u0627" },
            { "UG", "\u06cc\u0648\u06af\u0627\u0646\u0688\u0627" },
            { "ug", "\u06cc\u0648\u0626\u06af\u06c1\u0631" },
            { "type.co.pinyin", "\u067e\u0646 \u06cc\u0646 \u06a9\u06cc \u0686\u06be\u0679\u0646\u06cc \u06a9\u06cc \u062a\u0631\u062a\u06cc\u0628" },
            { "Kore", metaValue_ko },
            { "Zyyy", "\u0639\u0627\u0645" },
            { "type.colHiraganaQuaternary.yes", "Kana \u06a9\u06cc \u0645\u062e\u062a\u0644\u0641 \u0637\u0631\u06cc\u0642\u06d2 \u0633\u06d2 \u0686\u06be\u0679\u0627\u0626\u06cc \u06a9\u0631\u06cc\u06ba" },
            { "039", "\u062c\u0646\u0648\u0628\u06cc \u06cc\u0648\u0631\u067e" },
            { "uk", "\u06cc\u0648\u06a9\u0631\u06cc\u0646\u06cc\u0627\u0626\u06cc" },
            { "Sinh", metaValue_si },
            { "type.colCaseFirst.no", "\u0645\u0639\u0645\u0648\u0644 \u06a9\u06d2 \u062d\u0631\u0648\u0641 \u06a9\u06cc \u062a\u0631\u062a\u06cc\u0628 \u06a9\u06cc \u0686\u06be\u0679\u0627\u0626\u06cc \u06a9\u0631\u06cc\u06ba" },
            { "UM", "\u0627\u0645\u0631\u06cc\u06a9\u06c1 \u0633\u06d2 \u0628\u0627\u06c1\u0631 \u06a9\u06d2 \u0686\u06be\u0648\u0679\u06d2 \u062c\u0632\u0627\u0626\u0632" },
            { "type.colStrength.quaternary", "\u0644\u06c1\u062c\u06c1/ \u0628\u0691\u06d2 \u0686\u06be\u0648\u0679\u06d2 \u062d\u0631\u0648\u0641/\u0686\u0648\u0691\u0627\u0626\u06cc/Kana \u06a9\u06cc \u0686\u06be\u0679\u0627\u0626\u06cc \u06a9\u0631\u06cc\u06ba" },
            { "type.ca.coptic", "\u06a9\u0627\u067e\u0679\u06a9 \u06a9\u06cc\u0644\u0646\u0688\u0631" },
            { "ur", "\u0627\u0631\u062f\u0648" },
            { "US", "\u0631\u06cc\u0627\u0633\u062a\u06c1\u0627\u0626\u06d2 \u0645\u062a\u062d\u062f\u06c1" },
            { "haw", "\u06c1\u0648\u0627\u0626\u06cc" },
            { "type.co.gb2312han", "\u0622\u0633\u0627\u0646 \u0686\u06cc\u0646\u06cc \u06a9\u06cc \u0686\u06be\u0679\u0627\u0626\u06cc \u06a9\u06cc \u062a\u0631\u062a\u06cc\u0628 - GB2312" },
            { "UY", "\u06cc\u0648\u0631\u0648\u06af\u0648\u0626\u06d2" },
            { "UZ", "\u0627\u0632\u0628\u06a9\u0633\u062a\u0627\u0646" },
            { "uz", "\u0627\u0632\u0628\u06cc\u06a9" },
            { "tzm", "\u0633\u06cc\u0646\u0679\u0631\u0644 \u0627\u06cc\u0679\u0644\u0633 \u0679\u0645\u0627\u0632\u0627\u0626\u0679" },
            { "type.co.stroke", "\u0633\u0679\u0631\u0648\u06a9 \u06a9\u06cc \u0686\u06be\u0679\u0646\u06cc \u06a9\u06cc \u062a\u0631\u062a\u06cc\u0628" },
            { "VA", "\u0648\u0627\u0679\u06cc\u06a9\u0646 \u0633\u0679\u06cc" },
            { "nds_NL", "\u0627\u062f\u0646\u06cc \u0633\u06cc\u06a9\u0633\u0646" },
            { "VC", "\u0633\u06cc\u0646\u0679 \u0648\u0646\u0633\u0646\u0679 \u0627\u0648\u0631 \u06af\u0631\u06cc\u0646\u06cc\u0688\u0627\u0626\u0646\u0632" },
            { "VE", "\u0648\u06cc\u0646\u0632\u0648\u0626\u06cc\u0644\u0627" },
            { "ve", "\u0648\u06cc\u0646\u0688\u0627" },
            { "type.ca.roc", "\u0645\u0646\u06af\u0648\u0648 \u06a9\u06cc\u0644\u0646\u0688\u0631" },
            { "VG", "\u0628\u0631\u0679\u0634 \u0648\u0631\u062c\u0646 \u0622\u0626\u0644\u06cc\u0646\u0688\u0632" },
            { "VI", "\u0627\u0645\u0631\u06cc\u06a9\u06cc \u0648\u0631\u062c\u0646 \u0622\u0626\u0644\u06cc\u0646\u0688\u0632" },
            { "vi", "\u0648\u06cc\u062a\u0646\u0627\u0645\u06cc" },
            { "khq", "\u0643\u0648\u064a\u0631\u0627 \u0634\u064a\u0646\u064a" },
            { "key.hc", "\u06af\u06be\u0646\u0679\u06c1 \u0633\u0627\u0626\u06cc\u06a9\u0644 (12 \u0628\u0646\u0627\u0645 24)" },
            { "VN", "\u0648\u06cc\u062a\u0646\u0627\u0645" },
            { "type.colBackwards.no", "\u0644\u06c1\u062c\u0648\u06ba \u06a9\u06cc \u0686\u06be\u0679\u0627\u0626\u06cc \u0645\u0639\u0645\u0648\u0644 \u06a9\u06d2 \u0627\u0646\u062f\u0627\u0632 \u0645\u06cc\u06ba \u06a9\u0631\u06cc\u06ba" },
            { "key.x", "\u0646\u062c\u06cc-\u0627\u0633\u062a\u0639\u0645\u0627\u0644" },
            { "quc", "\u0643\u064a\u0634\u06cc" },
            { "VU", "\u0648\u06cc\u0646\u0648\u0622\u0679\u0648" },
            { "gaa", "\u06af\u0627" },
            { "rwk", "\u0631\u0648\u0627" },
            { "gag", "\u063a\u0627\u063a\u0627\u0648\u0632" },
            { "053", "\u0622\u0633\u0679\u0631\u06cc\u0644\u06cc\u0634\u06cc\u0627" },
            { "054", "\u0645\u0627\u0644\u06cc\u0646\u06cc\u0634\u06cc\u0627" },
            { "WF", "\u0648\u06cc\u0644\u06cc\u0632 \u0627\u0648\u0631 \u0641\u06cc\u0648\u0679\u06cc\u0648\u0646\u0627" },
            { "Grek", metaValue_el },
            { "type.co.traditional", "\u0631\u0648\u0627\u06cc\u062a\u06cc \u0686\u06be\u0679\u0646\u06cc \u06a9\u06cc \u062a\u0631\u062a\u06cc\u0628" },
            { "057", "\u0645\u0627\u0626\u06a9\u0631\u0648\u0646\u06cc\u0634\u06cc\u0627\u0626\u06cc \u0639\u0644\u0627\u0642\u06c1" },
            { "jgo", "\u0646\u06af\u0648\u0645\u0628\u0627" },
            { "lkt", "\u0644\u0627\u06a9\u0648\u0679\u0627" },
            { "type.nu.finance", "\u0645\u0627\u0644\u06cc\u0627\u062a\u06cc \u06c1\u0646\u062f\u0633\u06d2" },
            { "wo", "\u0648\u0648\u0644\u0648\u0641" },
            { "zgh", "\u0627\u0633\u0679\u06cc\u0646\u0688\u0631\u0688 \u0645\u0631\u0627\u0642\u0634\u06cc \u062a\u0645\u0627\u0632\u06cc\u0642\u06cc" },
            { "ar_001", "\u0645\u0627\u0688\u0631\u0646 \u0627\u0633\u0679\u06cc\u0646\u0688\u0631\u0688 \u0639\u0631\u0628\u06cc" },
            { "WS", "\u0633\u0627\u0645\u0648\u0622" },
            { "key.colNumeric", "\u0639\u062f\u062f\u06cc \u0686\u06be\u0679\u0627\u0626\u06cc" },
            { "Mong", "\u0645\u0646\u06af\u0648\u0644\u06cc\u0627\u0626\u06cc" },
            { "Latn", metaValue_la },
            { "061", "\u067e\u0648\u0644\u06cc\u0646\u06cc\u0634\u06cc\u0627" },
            { "type.nu.hans", "\u0622\u0633\u0627\u0646 \u0686\u06cc\u0646\u06cc \u0627\u0639\u062f\u0627\u062f" },
            { "type.nu.hant", "\u0631\u0648\u0627\u06cc\u062a\u06cc \u0686\u06cc\u0646\u06cc \u0627\u0639\u062f\u0627\u062f" },
            { "xh", "\u0698\u0648\u0633\u0627" },
            { "XK", "\u06a9\u0648\u0633\u0648\u0648\u0648" },
            { "type.nu.romanlow", "\u0631\u0648\u0645\u0646 \u0632\u06cc\u0631\u06cc\u06ba \u0627\u0639\u062f\u0627\u062f" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "\u063a\u06cc\u0631 \u062a\u062d\u0631\u06cc\u0631 \u0634\u062f\u06c1" },
            { "wbp", "\u0648\u0627\u0631\u0644\u067e\u06cc\u0631\u06cc" },
            { "moh", "\u0645\u0648\u06c1\u0627\u06a9" },
            { "YE", "\u06cc\u0645\u0646" },
            { "nqo", "\u0627\u06cc\u0646\u06a9\u0648" },
            { "type.co.standard", "\u0645\u0639\u06cc\u0627\u0631\u06cc \u0686\u06be\u0646\u0679\u0627\u0626\u06cc \u06a9\u06cc \u062a\u0631\u062a\u06cc\u0628" },
            { "yi", "\u06cc\u062f\u0634" },
            { "yo", "\u06cc\u0648\u0631\u0648\u0628\u0627" },
            { "type.nu.traditional", "\u0631\u0648\u0627\u06cc\u062a\u06cc \u0627\u0639\u062f\u0627\u062f" },
            { "es_MX", "\u0645\u06cc\u06a9\u0633\u06cc\u06a9\u0646 \u06c1\u0633\u067e\u0627\u0646\u0648\u06cc" },
            { "YT", "\u0645\u0627\u06cc\u0648\u0679" },
            { "vai", "\u0648\u0627\u0626\u06cc" },
            { "ZA", "\u062c\u0646\u0648\u0628\u06cc \u0627\u0641\u0631\u06cc\u0642\u06c1" },
            { "type.lb.loose", "\u0688\u06be\u06cc\u0644\u0627 \u0644\u0627\u0626\u0646 \u0628\u0631\u06cc\u06a9 \u0627\u0646\u062f\u0627\u0632" },
            { "kln", "\u0643\u0627\u0644\u064a\u0646\u062c\u064a\u0646" },
            { "Deva", "\u062f\u06cc\u0648\u0646\u0627\u06af\u0631\u06cc" },
            { "zh", "\u0686\u06cc\u0646\u06cc" },
            { "type.nu.geor", "\u062c\u0627\u0631\u062c\u06cc\u0627\u0626\u06cc \u0627\u0639\u062f\u0627\u062f" },
            { "Hira", "\u06c1\u06cc\u0631\u0627\u06af\u06cc\u0646\u0627" },
            { "ZM", "\u0632\u0627\u0645\u0628\u06cc\u0627" },
            { "Bopo", "\u0628\u0648\u067e\u0648\u0645\u0648\u0641\u0648" },
            { "key.lb", "\u0644\u0627\u0626\u0646 \u0628\u0631\u06cc\u06a9 \u0627\u0646\u062f\u0627\u0632" },
            { "zu", "\u0632\u0648\u0644\u0648" },
            { "ZW", "\u0632\u0645\u0628\u0627\u0628\u0648\u06d2" },
            { "type.co.phonebook", "\u0641\u0648\u0646 \u0628\u06a9 \u06a9\u06cc \u0686\u06be\u0679\u0646\u06cc \u06a9\u06cc \u062a\u0631\u062a\u06cc\u0628" },
            { "ZZ", "\u0646\u0627\u0645\u0639\u0644\u0648\u0645 \u0639\u0644\u0627\u0642\u06c1" },
            { "Geor", "\u062c\u0627\u0631\u062c\u06cc\u0627\u0626\u06cc" },
            { "type.colCaseLevel.yes", "\u062d\u0631\u0648\u0641 \u06a9\u06d2 \u062a\u0626\u06cc\u06ba \u062d\u0633\u0627\u0633 \u06a9\u06cc \u0686\u06be\u0679\u0627\u0626\u06cc \u06a9\u0631\u06cc\u06ba" },
            { "type.ca.iso8601", "ISO-8601 \u06a9\u06cc\u0644\u0646\u0688\u0631" },
            { "nso", "\u0634\u0645\u0627\u0644\u06cc \u0633\u0648\u062a\u06be\u0648" },
            { "type.nu.telu", "\u062a\u06cc\u0644\u06af\u0648 \u06c1\u0646\u062f\u0633\u06d2" },
            { "type.nu.jpanfin", "\u062c\u0627\u067e\u0627\u0646\u06cc \u0645\u0627\u0644\u06cc \u0627\u0639\u062f\u0627\u062f" },
            { "loz", "\u0644\u0648\u0632\u06cc" },
            { "type.co.reformed", "\u062f\u0648\u0628\u0627\u0631\u06c1 \u062a\u0634\u06a9\u06cc\u0644 \u0634\u062f\u06c1 \u0686\u06be\u0679\u0646\u06cc \u06a9\u06cc \u062a\u0631\u062a\u06cc\u0628" },
            { "key.colBackwards", "\u0645\u0639\u06a9\u0648\u0633 \u062a\u0644\u0641\u0638 \u06a9\u06cc \u0686\u06be\u0679\u0627\u0626\u06cc" },
            { "type.colHiraganaQuaternary.no", "Kana \u06a9\u06cc \u0686\u06be\u0679\u0627\u0626\u06cc \u0627\u0644\u06af \u0627\u0644\u06af \u06a9\u0631\u06cc\u06ba" },
            { "ebu", "\u0627\u0645\u0628\u0648" },
            { "jmc", "\u0645\u0627\u0634\u06cc\u0645" },
            { "zh_Hans", "\u0686\u06cc\u0646\u06cc (\u0622\u0633\u0627\u0646 \u06a9\u0631\u062f\u06c1)" },
            { "koi", "\u06a9\u0648\u0645\u06cc \u067e\u0631\u0645\u06cc\u0627\u06a9" },
            { "type.nu.hansfin", "\u0622\u0633\u0627\u0646 \u0686\u06cc\u0646\u06cc \u0645\u0627\u0644\u06cc \u0627\u0639\u062f\u0627\u062f" },
            { "type.colStrength.secondary", "\u0644\u06c1\u062c\u0648\u06ba \u06a9\u06cc \u0686\u06be\u0679\u0627\u0626\u06cc \u06a9\u0631\u06cc\u06ba" },
            { "kok", "\u06a9\u0648\u0646\u06a9\u0646\u06cc" },
            { "type.nu.arabext", "\u062a\u0648\u0633\u06cc\u0639 \u0634\u062f\u06c1 \u0639\u0631\u0628\u06cc \u06c1\u0646\u062f\u06cc \u06c1\u0646\u062f\u0633\u06d2" },
            { "nus", "\u0646\u0648\u06cc\u0631" },
            { "type.nu.fullwide", "\u067e\u0648\u0631\u06d2 \u0639\u0631\u0636 \u0648\u0627\u0644\u06d2 \u06c1\u0646\u062f\u0633\u06d2" },
            { "dav", "\u062a\u0627\u0626\u062a\u0627" },
            { "lrc", "\u0634\u0645\u0627\u0644\u06cc \u0644\u0631\u06cc" },
            { "zh_Hant", "\u0631\u0648\u0627\u06cc\u062a\u06cc \u0686\u06cc\u0646\u06cc" },
            { "type.nu.khmr", "\u062e\u0645\u06cc\u0631 \u06c1\u0646\u062f\u0633\u06d2" },
            { "mua", "\u0645\u0646\u0688\u0627\u0646\u06af" },
            { "type.nu.guru", "\u06af\u0631\u0645\u06a9\u06be\u06cc \u06c1\u0646\u062f\u0633\u06d2" },
            { "Khmr", metaValue_km },
            { "key.ms", "\u067e\u06cc\u0645\u0627\u0626\u0634 \u06a9\u0627 \u0646\u0638\u0627\u0645" },
            { "type.nu.roman", "\u0631\u0648\u0645\u0646 \u0627\u0639\u062f\u0627\u062f" },
            { "type.nu.tamldec", "\u062a\u0645\u0644 \u0627\u0639\u062f\u0627\u062f" },
            { "saq", "\u0633\u0627\u0645\u0628\u0648\u0631\u0648" },
            { "efi", "\u0627\u06cc\u0641\u0650\u06a9" },
            { "key.nu", "\u0627\u0639\u062f\u0627\u062f" },
            { "type.nu.native", "\u0627\u0635\u0644 \u06c1\u0646\u062f\u0633\u06d2" },
            { "Guru", "\u06af\u0631\u0645\u06a9\u06be\u06cc" },
            { "lua", "\u0644\u06cc\u0648\u0628\u0627 \u0644\u0648\u0644\u0648\u0622" },
            { "ksb", "\u0634\u0627\u0645\u0628\u0627\u0644\u0627" },
            { "type.colCaseFirst.upper", "\u067e\u06c1\u0644\u06d2 \u0628\u0627\u0644\u0627\u0626\u06cc \u062d\u0631\u0648\u0641 \u06a9\u06cc \u0686\u06be\u0679\u0627\u0626\u06cc \u06a9\u0631\u06cc\u06ba" },
            { "Telu", metaValue_te },
            { "ksf", "\u0628\u0627\u0641\u064a\u0627" },
        };
        return data;
    }
}
