/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_af extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "Sentraal-Afrika-tyd",
               "CAT",
               "Central African Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "Moskou-standaardtyd",
               "MSK",
               "Moskou-somertyd",
               "MSD",
               "Moskou-tyd",
               "MT",
            };
        final String[] Japan = new String[] {
               "Japan-standaardtyd",
               "JST",
               "Japan-dagligtyd",
               "JDT",
               "Japan-tyd",
               "JT",
            };
        final String[] Pakistan = new String[] {
               "Pakistan-standaardtyd",
               "PKT",
               "Pakistan-somertyd",
               "PKST",
               "Pakistan-tyd",
               "PKT",
            };
        final String[] Taipei = new String[] {
               "Taipei-standaardtyd",
               "CST",
               "Taipei-dagligtyd",
               "CDT",
               "Taipei-tyd",
               "CT",
            };
        final String[] Hovd = new String[] {
               "Hovd-standaardtyd",
               "HOVT",
               "Hovd-somertyd",
               "HOVST",
               "Hovd-tyd",
               "HOVT",
            };
        final String[] Magadan = new String[] {
               "Magadan-standaardtyd",
               "MAGT",
               "Magadan-somertyd",
               "MAGST",
               "Magadan-tyd",
               "MAGT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Australiese sentraal-Westelike standaard-tyd",
               "ACWST",
               "Australiese sentraal-Westelike dagligtyd",
               "ACWDT",
               "Australiese sentraal-Westelike tyd",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "Sentraal-Europese standaardtyd",
               "CET",
               "Sentraal-Europese somertyd",
               "CEST",
               "Sentraal-Europese tyd",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "Sakhalin-standaardtyd",
               "SAKT",
               "Sakhalin-somertyd",
               "SAKST",
               "Sakhalin-tyd",
               "SAKT",
            };
        final String[] Paraguay = new String[] {
               "Paraguay-standaardtyd",
               "PYT",
               "Paraguay-somertyd",
               "PYST",
               "Paraguay-tyd",
               "PYT",
            };
        final String[] Malaysia = new String[] {
               "Maleisi\u00eb-tyd",
               "MYT",
               "Malaysia Summer Time",
               "MYST",
               "Malaysia Time",
               "MYT",
            };
        final String[] America_Eastern = new String[] {
               "Oostelike standaardtyd",
               "EST",
               "Oostelike dagligtyd",
               "EDT",
               "Oostelike tyd",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "Lord Howe-standaardtyd",
               "LHST",
               "Lord Howe-dagligtyd",
               "LHDT",
               "Lord Howe-tyd",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "Nieu-Seeland-standaardtyd",
               "NZST",
               "Nieu-Seeland-dagligtyd",
               "NZDT",
               "Nieu-Seeland-tyd",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "Indiese Oseaan-tyd",
               "IOT",
               "Indian Ocean Territory Summer Time",
               "IOST",
               "Indian Ocean Territory Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "Jakoetsk-standaardtyd",
               "YAKT",
               "Jakoetsk-somertyd",
               "YAKST",
               "Jakoetsk-tyd",
               "YAKT",
            };
        final String[] Mauritius = new String[] {
               "Mauritius-standaardtyd",
               "MUT",
               "Mauritius-somertyd",
               "MUST",
               "Mauritius-tyd",
               "MUT",
            };
        final String[] Africa_Eastern = new String[] {
               "Oos-Afrika-tyd",
               "EAT",
               "Eastern African Summer Time",
               "EAST",
               "Eastern Africa Time",
               "EAT",
            };
        final String[] East_Timor = new String[] {
               "Oos-Timor-tyd",
               "TLT",
               "Timor-Leste Summer Time",
               "TLST",
               "Timor-Leste Time",
               "TLT",
            };
        final String[] Solomon = new String[] {
               "Solomoneilande-tyd",
               "SBT",
               "Solomon Is. Summer Time",
               "SBST",
               "Solomon Is. Time",
               "SBT",
            };
        final String[] Kosrae = new String[] {
               "Kosrae-tyd",
               "KOST",
               "Kosrae Summer Time",
               "KOSST",
               "Kosrae Time",
               "KOST",
            };
        final String[] Marshall_Islands = new String[] {
               "Marshalleilande-tyd",
               "MHT",
               "Marshall Islands Summer Time",
               "MHST",
               "Marshall Islands Time",
               "MHT",
            };
        final String[] Europe_Eastern = new String[] {
               "Oos-Europese standaardtyd",
               "EET",
               "Oos-Europese somertyd",
               "EEST",
               "Oos-Europese tyd",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "Newfoundland-standaardtyd",
               "NST",
               "Newfoundland-dagligtyd",
               "NDT",
               "Newfoundland-tyd",
               "NT",
            };
        final String[] Afghanistan = new String[] {
               "Afghanistan-tyd",
               "AFT",
               "Afghanistan Summer Time",
               "AFST",
               "Afghanistan Time",
               "AFT",
            };
        final String[] Hong_Kong = new String[] {
               "Hongkong-standaardtyd",
               "HKT",
               "Hongkong-somertyd",
               "HKST",
               "Hongkong-tyd",
               "HKT",
            };
        final String[] Argentina_Western = new String[] {
               "Wes-Argentini\u00eb-standaardtyd",
               "ART",
               "Wes-Argentini\u00eb-somertyd",
               "ARST",
               "Wes-Argentini\u00eb-tyd",
               "ART",
            };
        final String[] Atlantic = new String[] {
               "Atlantiese standaardtyd",
               "AST",
               "Atlantiese dagligtyd",
               "ADT",
               "Atlantiese tyd",
               "AT",
            };
        final String[] Ponape = new String[] {
               "Ponape-tyd",
               "PONT",
               "Pohnpei Summer Time",
               "PONST",
               "Ponape Time",
               "PONT",
            };
        final String[] Bolivia = new String[] {
               "Bolivia-tyd",
               "BOT",
               "Bolivia Summer Time",
               "BOST",
               "Bolivia Time",
               "BOT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Sint-Pierre en Miquelon-standaardtyd",
               "PMST",
               "Sint-Pierre en Miquelon-dagligtyd",
               "PMDT",
               "Sint-Pierre en Miquelon-tyd",
               "PMT",
            };
        final String[] Indochina = new String[] {
               "Indosjina-tyd",
               "ICT",
               "Indochina Summer Time",
               "ICST",
               "Indochina Time",
               "ICT",
            };
        final String[] Yekaterinburg = new String[] {
               "Jekaterinburg-standaardtyd",
               "YEKT",
               "Jekaterinburg-somertyd",
               "YEKST",
               "Jekaterinburg-tyd",
               "YEKT",
            };
        final String[] Maldives = new String[] {
               "Maledive-tyd",
               "MVT",
               "Maldives Summer Time",
               "MVST",
               "Maldives Time",
               "MVT",
            };
        final String[] Tahiti = new String[] {
               "Tahiti-tyd",
               "TAHT",
               "Tahiti Summer Time",
               "TAHST",
               "Tahiti Time",
               "TAHT",
            };
        final String[] Israel = new String[] {
               "Israel-standaardtyd",
               "IST",
               "Israel-dagligtyd",
               "IDT",
               "Israel-tyd",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "Sentraal Indonesi\u00eb-tyd",
               "WITA",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "WITA",
            };
        final String[] Wallis = new String[] {
               "Wallis en Futuna-tyd",
               "WFT",
               "Wallis & Futuna Summer Time",
               "WFST",
               "Wallis & Futuna Time",
               "WFT",
            };
        final String[] Africa_Southern = new String[] {
               "Suid-Afrika-standaardtyd",
               "SAST",
               "South Africa Summer Time",
               "SAST",
               "South Africa Time",
               "SAT",
            };
        final String[] Syowa = new String[] {
               "Syowa-tyd",
               "SYOT",
               "Syowa Summer Time",
               "SYOST",
               "Syowa Time",
               "SYOT",
            };
        final String[] Line_Islands = new String[] {
               "Line-eilande-tyd",
               "LINT",
               "Line Is. Summer Time",
               "LINST",
               "Line Is. Time",
               "LINT",
            };
        final String[] Uzbekistan = new String[] {
               "Oesbekistan-standaardtyd",
               "UZT",
               "Oesbekistan-somertyd",
               "UZST",
               "Oesbekistan-tyd",
               "UZT",
            };
        final String[] Omsk = new String[] {
               "Omsk-standaardtyd",
               "OMST",
               "Omsk-somertyd",
               "OMSST",
               "Omsk-tyd",
               "OMST",
            };
        final String[] Seychelles = new String[] {
               "Seychelle-tyd",
               "SCT",
               "Seychelles Summer Time",
               "SCST",
               "Seychelles Time",
               "SCT",
            };
        final String[] Uruguay = new String[] {
               "Uruguay-standaardtyd",
               "UYT",
               "Uruguay-somertyd",
               "UYST",
               "Uruguay-tyd",
               "UYT",
            };
        final String[] Nepal = new String[] {
               "Nepal-tyd",
               "NPT",
               "Nepal Summer Time",
               "NPST",
               "Nepal Time",
               "NPT",
            };
        final String[] Mongolia = new String[] {
               "Ulaanbatar-standaardtyd",
               "ULAT",
               "Ulaanbatar-somertyd",
               "ULAST",
               "Ulaanbatar-tyd",
               "ULAT",
            };
        final String[] America_Central = new String[] {
               "Sentrale standaardtyd",
               "CST",
               "Sentrale dagligtyd",
               "CDT",
               "Sentrale tyd",
               "CT",
            };
        final String[] Truk = new String[] {
               "Chuuk-tyd",
               "CHUT",
               "Chuuk Summer Time",
               "CHUST",
               "Chuuk Time",
               "CHUT",
            };
        final String[] Niue = new String[] {
               "Niue-tyd",
               "NUT",
               "Niue Summer Time",
               "NUST",
               "Niue Time",
               "NUT",
            };
        final String[] Wake = new String[] {
               "Wake-eiland-tyd",
               "WAKT",
               "Wake Summer Time",
               "WAKST",
               "Wake Time",
               "WAKT",
            };
        final String[] Falkland = new String[] {
               "Falklandeilande-standaardtyd",
               "FKT",
               "Falklandeilande-somertyd",
               "FKST",
               "Falklandeilande-tyd",
               "FKT",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatu-standaardtyd",
               "VUT",
               "Vanuatu-somertyd",
               "VUST",
               "Vanuatu-tyd",
               "VUT",
            };
        final String[] Novosibirsk = new String[] {
               "Novosibirsk-standaardtyd",
               "NOVT",
               "Novosibirsk-somertyd",
               "NOVST",
               "Novosibirsk-tyd",
               "NOVT",
            };
        final String[] Singapore = new String[] {
               "Singapoer-standaardtyd",
               "SRET",
               "Srednekolymsk Daylight Time",
               "SREDT",
               "Srednekolymsk Time",
               "SRET",
            };
        final String[] Azores = new String[] {
               "Asore-standaardtyd",
               "AZOT",
               "Asore-somertyd",
               "AZOST",
               "Asore-tyd",
               "AZOT",
            };
        final String[] Apia = new String[] {
               "Apia-standaardtyd",
               "WSST",
               "Apia-dagligtyd",
               "WSDT",
               "Apia-tyd",
               "WST",
            };
        final String[] Bhutan = new String[] {
               "Bhoetan-tyd",
               "BTT",
               "Bhutan Summer Time",
               "BTST",
               "Bhutan Time",
               "BTT",
            };
        final String[] Suriname = new String[] {
               "Suriname-tyd",
               "SRT",
               "Suriname Summer Time",
               "SRST",
               "Suriname Time",
               "SRT",
            };
        final String[] Nauru = new String[] {
               "Nauru-tyd",
               "NRT",
               "Nauru Summer Time",
               "NRST",
               "Nauru Time",
               "NRT",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnojarsk-standaardtyd",
               "KRAT",
               "Krasnojarsk-somertyd",
               "KRAST",
               "Krasnojarsk-tyd",
               "KRAT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Wes-Kazakstan-tyd",
               "AQTT",
               "Aqtau Summer Time",
               "AQTST",
               "Aqtau Time",
               "AQTT",
            };
        final String[] Myanmar = new String[] {
               "Mianmar-tyd",
               "MMT",
               "Myanmar Summer Time",
               "MMST",
               "Myanmar Time",
               "MMT",
            };
        final String[] Christmas = new String[] {
               "Kersfeeseiland-tyd",
               "CXT",
               "Christmas Island Summer Time",
               "CXST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Amazon = new String[] {
               "Amasone-standaardtyd",
               "AMT",
               "Amasone-somertyd",
               "AMST",
               "Amasone-tyd",
               "AMT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Oos-Kazakstan-tyd",
               "ALMT",
               "Alma-Ata Summer Time",
               "ALMST",
               "Alma-Ata Time",
               "ALMT",
            };
        final String[] Fiji = new String[] {
               "Fidji-standaardtyd",
               "FJT",
               "Fidji-somertyd",
               "FJST",
               "Fidji-tyd",
               "FJT",
            };
        final String[] Reunion = new String[] {
               "Reunion-tyd",
               "RET",
               "Reunion Summer Time",
               "REST",
               "Reunion Time",
               "RET",
            };
        final String[] Cocos = new String[] {
               "Cocoseilande-tyd",
               "CCT",
               "Cocos Islands Summer Time",
               "CCST",
               "Cocos Islands Time",
               "CCT",
            };
        final String[] Chatham = new String[] {
               "Chatham-standaardtyd",
               "CHAST",
               "Chatham-dagligtyd",
               "CHADT",
               "Chatham-tyd",
               "CHAT",
            };
        final String[] Vostok = new String[] {
               "Vostok-tyd",
               "VOST",
               "Vostok Summer Time",
               "VOSST",
               "Vostok Time",
               "VOST",
            };
        final String[] Argentina = new String[] {
               "Argentini\u00eb-standaardtyd",
               "ART",
               "Argentini\u00eb-somertyd",
               "ARST",
               "Argentini\u00eb-tyd",
               "ART",
            };
        final String[] Gambier = new String[] {
               "Gambier-tyd",
               "GAMT",
               "Gambier Summer Time",
               "GAMST",
               "Gambier Time",
               "GAMT",
            };
        final String[] Kamchatka = new String[] {
               "Petropavlovsk-Kamchatski-standaardtyd",
               "PETT",
               "Petropavlovsk-Kamchatski-somertyd",
               "PETST",
               "Petropavlovsk-Kamchatski-tyd",
               "PETT",
            };
        final String[] Tuvalu = new String[] {
               "Tuvalu-tyd",
               "TVT",
               "Tuvalu Summer Time",
               "TVST",
               "Tuvalu Time",
               "TVT",
            };
        final String[] Galapagos = new String[] {
               "Galapagos-tyd",
               "GALT",
               "Galapagos Summer Time",
               "GALST",
               "Galapagos Time",
               "GALT",
            };
        final String[] Macquarie = new String[] {
               "Macquarie-eiland-tyd",
               "MIST",
               "Macquarie Island Daylight Time",
               "MIDT",
               "Macquarie Island Time",
               "MIST",
            };
        final String[] Venezuela = new String[] {
               "Venezuela-tyd",
               "VET",
               "Venezuela Summer Time",
               "VEST",
               "Venezuela Time",
               "VET",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hawaii-Aleusi\u00ebr-standaardtyd",
               "HAST",
               "Hawaii-Aleusi\u00ebr-dagligtyd",
               "HADT",
               "Hawaii-Aleusi\u00ebr-tyd",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "Australiese sentraal-standaardtyd",
               "ACST",
               "Australiese sentrale dagligtyd",
               "ACDT",
               "Sentraal-Australi\u00eb-tyd",
               "ACT",
            };
        final String[] America_Pacific = new String[] {
               "Pasifiese standaardtyd",
               "PST",
               "Pasifiese dagligtyd",
               "PDT",
               "Pasifiese tyd",
               "PT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Fenikseilande-tyd",
               "PHOT",
               "Phoenix Is. Summer Time",
               "PHOST",
               "Phoenix Is. Time",
               "PHOT",
            };
        final String[] Turkmenistan = new String[] {
               "Turkmenistan-standaardtyd",
               "TMT",
               "Turkmenistan-somertyd",
               "TMST",
               "Turkmenistan-tyd",
               "TMT",
            };
        final String[] Europe_Western = new String[] {
               "Wes-Europese standaardtyd",
               "WET",
               "Wes-Europese somertyd",
               "WEST",
               "Wes-Europese tyd",
               "WET",
            };
        final String[] Cape_Verde = new String[] {
               "Kaap Verde-standaardtyd",
               "CVT",
               "Kaap Verde-somertyd",
               "CVST",
               "Kaap Verde-tyd",
               "CVT",
            };
        final String[] Norfolk = new String[] {
               "Norfolkeilande-tyd",
               "NFT",
               "Norfolk Summer Time",
               "NFST",
               "Norfolk Time",
               "NFT",
            };
        final String[] Guyana = new String[] {
               "Guyana-tyd",
               "GYT",
               "Guyana Summer Time",
               "GYST",
               "Guyana Time",
               "GYT",
            };
        final String[] Pitcairn = new String[] {
               "Pitcairn-tyd",
               "PST",
               "Pitcairn Daylight Time",
               "PDT",
               "Pitcairn Time",
               "PT",
            };
        final String[] Rothera = new String[] {
               "Rothera-tyd",
               "ROTT",
               "Rothera Summer Time",
               "ROTST",
               "Rothera Time",
               "ROTT",
            };
        final String[] Samoa = new String[] {
               "Samoa-standaardtyd",
               "SST",
               "Samoa-dagligtyd",
               "SDT",
               "Samoa-tyd",
               "ST",
            };
        final String[] Palau = new String[] {
               "Palau-tyd",
               "PWT",
               "Palau Summer Time",
               "PWST",
               "Palau Time",
               "PWT",
            };
        final String[] Europe_Further_Eastern = new String[] {
               "Verder-oosterse Europese Tyd",
               "MSK",
               "Moscow Daylight Time",
               "MSD",
               "Moscow Time",
               "MT",
            };
        final String[] Azerbaijan = new String[] {
               "Aserbeidjan-standaardtyd",
               "AZT",
               "Aserbeidjan-somertyd",
               "AZST",
               "Aserbeidjan-tyd",
               "AZT",
            };
        final String[] Mawson = new String[] {
               "Mawson-tyd",
               "MAWT",
               "Mawson Summer Time",
               "MAWST",
               "Mawson Time",
               "MAWT",
            };
        final String[] Mexico_Pacific = new String[] {
               "Meksikaanse Pasifiese standaardtyd",
               "MST",
               "Meksikaanse Pasifiese dagligtyd",
               "MDT",
               "Meksikaanse Pasifiese tyd",
               "MT",
            };
        final String[] Davis = new String[] {
               "Davis-tyd",
               "DAVT",
               "Davis Summer Time",
               "DAVST",
               "Davis Time",
               "DAVT",
            };
        final String[] Cuba = new String[] {
               "Kuba-standaardtyd",
               "CST",
               "Kuba-dagligtyd",
               "CDT",
               "Kuba-tyd",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "Wes-Afrika-standaardtyd",
               "WAT",
               "Wes-Afrika-somertyd",
               "WAST",
               "Wes-Afrika-tyd",
               "WAT",
            };
        final String[] GMT = new String[] {
               "Greenwich-mediaantyd",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
            };
        final String[] Philippines = new String[] {
               "Filippynse standaardtyd",
               "PHT",
               "Filippynse somertyd",
               "PHST",
               "Filippynse tyd",
               "PHT",
            };
        final String[] French_Southern = new String[] {
               "Franse Suider- en Antarktiese tyd",
               "TFT",
               "French Southern & Antarctic Lands Summer Time",
               "TFST",
               "French Southern & Antarctic Lands Time",
               "TFT",
            };
        final String[] South_Georgia = new String[] {
               "Suid-Georgi\u00eb-tyd",
               "GST",
               "South Georgia Daylight Time",
               "GDT",
               "South Georgia Time",
               "GT",
            };
        final String[] New_Caledonia = new String[] {
               "Nieu-Kaledoni\u00eb-standaardtyd",
               "NCT",
               "Nieu-Kaledoni\u00eb-somertyd",
               "NCST",
               "Nieu-Kaledoni\u00eb-tyd",
               "NCT",
            };
        final String[] Brunei = new String[] {
               "Broenei Darussalam-tyd",
               "BNT",
               "Brunei Summer Time",
               "BNST",
               "Brunei Time",
               "BNT",
            };
        final String[] Iran = new String[] {
               "Iran-standaardtyd",
               "IRST",
               "Iran-dagligtyd",
               "IRDT",
               "Iran-tyd",
               "IRT",
            };
        final String[] Easter = new String[] {
               "Paaseiland-standaardtyd",
               "EAST",
               "Paaseiland-somertyd",
               "EASST",
               "Paaseiland-tyd",
               "EAST",
            };
        final String[] Mexico_Northwest = new String[] {
               "Noordwes-Meksiko-standaardtyd",
               "PST",
               "Noordwes-Meksiko-dagligtyd",
               "PDT",
               "Noordwes-Meksiko-tyd",
               "PT",
            };
        final String[] DumontDUrville = new String[] {
               "Dumont-d\u2019Urville-tyd",
               "DDUT",
               "Dumont-d'Urville Summer Time",
               "DDUST",
               "Dumont-d'Urville Time",
               "DDUT",
            };
        final String[] Tajikistan = new String[] {
               "Tadjikistan-tyd",
               "TJT",
               "Tajikistan Summer Time",
               "TJST",
               "Tajikistan Time",
               "TJT",
            };
        final String[] Tonga = new String[] {
               "Tonga-standaardtyd",
               "TOT",
               "Tonga-somertyd",
               "TOST",
               "Tonga-tyd",
               "TOT",
            };
        final String[] Bangladesh = new String[] {
               "Bangladesj-standaardtyd",
               "BDT",
               "Bangladesj-somertyd",
               "BDST",
               "Bangladesj-tyd",
               "BDT",
            };
        final String[] Peru = new String[] {
               "Peru-standaardtyd",
               "PET",
               "Peru-somertyd",
               "PEST",
               "Peru-tyd",
               "PET",
            };
        final String[] Greenland_Western = new String[] {
               "Wes-Groenland-standaardtyd",
               "WGT",
               "Wes-Groenland-somertyd",
               "WGST",
               "Wes-Groenland-tyd",
               "WGT",
            };
        final String[] Ecuador = new String[] {
               "Ecuador-tyd",
               "ECT",
               "Ecuador Summer Time",
               "ECST",
               "Ecuador Time",
               "ECT",
            };
        final String[] Greenland_Eastern = new String[] {
               "Oos-Groenland-standaardtyd",
               "EGT",
               "Oos-Groenland-somertyd",
               "EGST",
               "Oos-Groenland-tyd",
               "EGT",
            };
        final String[] Gulf = new String[] {
               "Golf-standaardtyd",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Oos-Indonesi\u00eb-tyd",
               "WIT",
               "East Indonesia Summer Time",
               "EIST",
               "East Indonesia Time",
               "WIT",
            };
        final String[] Korea = new String[] {
               "Koreaanse standaardtyd",
               "KST",
               "Koreaanse dagligtyd",
               "KDT",
               "Koreaanse tyd",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "Australiese Westelike standaardtyd",
               "AWST",
               "Australiese Westelike dagligtyd",
               "AWDT",
               "Westelike Australi\u00eb-tyd",
               "AWT",
            };
        final String[] Kyrgystan = new String[] {
               "Kirgistan-tyd",
               "KGT",
               "Kirgizstan Summer Time",
               "KGST",
               "Kirgizstan Time",
               "KGT",
            };
        final String[] Indonesia_Western = new String[] {
               "Wes-Indonesi\u00eb-tyd",
               "WIB",
               "West Indonesia Summer Time",
               "WIST",
               "West Indonesia Time",
               "WIB",
            };
        final String[] Australia_Eastern = new String[] {
               "Australiese Oostelike standaardtyd",
               "AEST",
               "Australiese Oostelike dagligtyd",
               "AEDT",
               "Oostelike Australiese tyd",
               "AET",
            };
        final String[] French_Guiana = new String[] {
               "Frans-Guiana-tyd",
               "GFT",
               "French Guiana Summer Time",
               "GFST",
               "French Guiana Time",
               "GFT",
            };
        final String[] Colombia = new String[] {
               "Colombi\u00eb-standaardtyd",
               "COT",
               "Colombi\u00eb-somertyd",
               "COST",
               "Colombi\u00eb-tyd",
               "COT",
            };
        final String[] Chile = new String[] {
               "Chili-standaardtyd",
               "CLT",
               "Chili-somertyd",
               "CLST",
               "Chili-tyd",
               "CLT",
            };
        final String[] Gilbert_Islands = new String[] {
               "Gilberteilande-tyd",
               "GILT",
               "Gilbert Is. Summer Time",
               "GILST",
               "Gilbert Is. Time",
               "GILT",
            };
        final String[] America_Mountain = new String[] {
               "Berg-standaardtyd",
               "MST",
               "Berg-dagligtyd",
               "MDT",
               "Bergtyd",
               "MT",
            };
        final String[] Marquesas = new String[] {
               "Marquesas-tyd",
               "MART",
               "Marquesas Summer Time",
               "MARST",
               "Marquesas Time",
               "MART",
            };
        final String[] Arabian = new String[] {
               "Arabiese standaardtyd",
               "AST",
               "Arabiese dagligtyd",
               "ADT",
               "Arabiese tyd",
               "AT",
            };
        final String[] Alaska = new String[] {
               "Alaska-standaardtyd",
               "AKST",
               "Alaska-dagligtyd",
               "AKDT",
               "Alaska-tyd",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "Vladivostok-standaardtyd",
               "VLAT",
               "Vladivostok-somertyd",
               "VLAST",
               "Vladivostok-tyd",
               "VLAT",
            };
        final String[] Chamorro = new String[] {
               "Chamorro-standaardtyd",
               "ChST",
               "Chamorro Daylight Time",
               "ChDT",
               "Chamorro Time",
               "ChT",
            };
        final String[] Irkutsk = new String[] {
               "Irkutsk-standaardtyd",
               "IRKT",
               "Irkutsk-somertyd",
               "IRKST",
               "Irkutsk-tyd",
               "IRKT",
            };
        final String[] Georgia = new String[] {
               "Georgi\u00eb-standaardtyd",
               "GET",
               "Georgi\u00eb-somertyd",
               "GEST",
               "Georgi\u00eb-tyd",
               "GET",
            };
        final String[] Tokelau = new String[] {
               "Tokelau-tyd",
               "TKT",
               "Tokelau Summer Time",
               "TKST",
               "Tokelau Time",
               "TKT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Papoea-Nieu-Guinee-tyd",
               "PGT",
               "Papua New Guinea Summer Time",
               "PGST",
               "Papua New Guinea Time",
               "PGT",
            };
        final String[] Noronha = new String[] {
               "Fernando de Noronha-standaardtyd",
               "FNT",
               "Fernando de Noronha-somertyd",
               "FNST",
               "Fernando de Noronha-tyd",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "Choibalsan-standaardtyd",
               "CHOT",
               "Choibalsan-somertyd",
               "CHOST",
               "Choibalsan-tyd",
               "CHOT",
            };
        final String[] Brasilia = new String[] {
               "Brasili\u00eb-standaardtyd",
               "BRT",
               "Brasili\u00eb somertyd",
               "BRST",
               "Brasili\u00eb-tyd",
               "BRT",
            };
        final String[] China = new String[] {
               "China-standaardtyd",
               "CST",
               "China-dagligtyd",
               "CDT",
               "China-tyd",
               "CT",
            };
        final String[] Armenia = new String[] {
               "Armeni\u00eb-standaardtyd",
               "AMT",
               "Armeni\u00eb-somertyd",
               "AMST",
               "Armeni\u00eb-tyd",
               "AMT",
            };
        final String[] Samara = new String[] {
               "Samara-standaardtyd",
               "SAMT",
               "Samara-dagligtyd",
               "SAMST",
               "Samara-tyd",
               "SAMT",
            };
        final String[] India = new String[] {
               "Indi\u00eb-standaardtyd",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Cook = new String[] {
               "Cookeilande-standaardtyd",
               "CKT",
               "Cookeilande-halfsomertyd",
               "CKHST",
               "Cookeilande-tyd",
               "CKT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London",
                new String[] {
                    "Greenwich-mediaantyd",
                    "GMT",
                    "Britse somertyd",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", Atlantic },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Antarctica/Syowa", Syowa },
            { "Indian/Reunion", Reunion },
            { "Pacific/Palau", Palau },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Western },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Africa/Bamako", GMT },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Pacific/Bougainville", New_Zealand },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", Alaska },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Antarctica/Troll", GMT },
            { "Europe/Samara", Samara },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "Greenwich-mediaantyd",
                    "GMT",
                    "Ierse standaardtyd",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "Pacific/Truk", Truk },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Saipan", Chamorro },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Taipei", Taipei },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Further_Eastern },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Cancun", America_Eastern },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Kamchatka },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Tehran", Iran },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "Asia/Srednekolymsk", Singapore },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "Australia/Lindeman", Australia_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
