/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_br extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "eur Kreizafrika",
               "CAT",
               "Central African Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "eur c\u02bchoa\u00f1v Moskov",
               "MSK",
               "eur ha\u00f1v Moskov",
               "MSD",
               "eur Moskov",
               "MT",
            };
        final String[] Japan = new String[] {
               "eur c\u02bchoa\u00f1v Japan",
               "JST",
               "eur ha\u00f1v Japan",
               "JDT",
               "eur Japan",
               "JT",
            };
        final String[] Pakistan = new String[] {
               "eur c\u02bchoa\u00f1v Pakistan",
               "PKT",
               "eur ha\u00f1v Pakistan",
               "PKST",
               "eur Pakistan",
               "PKT",
            };
        final String[] Taipei = new String[] {
               "eur c\u02bchoa\u00f1v Taipei",
               "CST",
               "eur ha\u00f1v Taipei",
               "CDT",
               "eur Taipei",
               "CT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "eur c\u02bchoa\u00f1v Kreizaostralia ar C\u02bchorn\u00f4g",
               "ACWST",
               "eur ha\u00f1v Kreizaostralia ar C\u02bchorn\u00f4g",
               "ACWDT",
               "eur Kreizaostralia ar C\u02bchorn\u00f4g",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "eur c\u02bchoa\u00f1v Kreizeuropa",
               "CET",
               "eur ha\u00f1v Kreizeuropa",
               "CEST",
               "eur Kreizeuropa",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "eur c\u02bchoa\u00f1v Sakhalin",
               "SAKT",
               "eur ha\u00f1v Sakhalin",
               "SAKST",
               "eur Sakhalin",
               "SAKT",
            };
        final String[] Paraguay = new String[] {
               "eur c\u02bchoa\u00f1v Paraguay",
               "PYT",
               "eur ha\u00f1v Paraguay",
               "PYST",
               "eur Paraguay",
               "PYT",
            };
        final String[] Malaysia = new String[] {
               "eur Malaysia",
               "MYT",
               "Malaysia Summer Time",
               "MYST",
               "Malaysia Time",
               "MYT",
            };
        final String[] America_Eastern = new String[] {
               "eur c\u02bchoa\u00f1v ar Reter",
               "EST",
               "eur ha\u00f1v ar Reter",
               "EDT",
               "eur ar Reter",
               "ET",
            };
        final String[] New_Zealand = new String[] {
               "eur c\u02bchoa\u00f1v Zeland-Nevez",
               "NZST",
               "eur ha\u00f1v Zeland-Nevez",
               "NZDT",
               "eur Zeland-Nevez",
               "NZT",
            };
        final String[] Yakutsk = new String[] {
               "eur c\u02bchoa\u00f1v Yakutsk",
               "YAKT",
               "eur ha\u00f1v Yakutsk",
               "YAKST",
               "eur Yakutsk",
               "YAKT",
            };
        final String[] Mauritius = new String[] {
               "eur c\u02bchoa\u00f1v Moris",
               "MUT",
               "eur ha\u00f1v Moris",
               "MUST",
               "eur Moris",
               "MUT",
            };
        final String[] Africa_Eastern = new String[] {
               "eur Afrika ar Reter",
               "EAT",
               "Eastern African Summer Time",
               "EAST",
               "Eastern Africa Time",
               "EAT",
            };
        final String[] East_Timor = new String[] {
               "eur Timor ar Reter",
               "TLT",
               "Timor-Leste Summer Time",
               "TLST",
               "Timor-Leste Time",
               "TLT",
            };
        final String[] Solomon = new String[] {
               "eur Inizi Salomon",
               "SBT",
               "Solomon Is. Summer Time",
               "SBST",
               "Solomon Is. Time",
               "SBT",
            };
        final String[] Marshall_Islands = new String[] {
               "eur Inizi Marshall",
               "MHT",
               "Marshall Islands Summer Time",
               "MHST",
               "Marshall Islands Time",
               "MHT",
            };
        final String[] Europe_Eastern = new String[] {
               "eur c\u02bchoa\u00f1v Europa ar Reter",
               "EET",
               "eur ha\u00f1v Europa ar Reter",
               "EEST",
               "eur Europa ar Reter",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "eur c\u02bchoa\u00f1v Newfoundland",
               "NST",
               "eur ha\u00f1v Newfoundland",
               "NDT",
               "eur Newfoundland",
               "NT",
            };
        final String[] Afghanistan = new String[] {
               "eur Afghanistan",
               "AFT",
               "Afghanistan Summer Time",
               "AFST",
               "Afghanistan Time",
               "AFT",
            };
        final String[] Hong_Kong = new String[] {
               "eur c\u02bchoa\u00f1v Hong Kong",
               "HKT",
               "eur ha\u00f1v Hong Kong",
               "HKST",
               "eur Hong Kong",
               "HKT",
            };
        final String[] Argentina_Western = new String[] {
               "eur c\u02bchoa\u00f1v Arc\u02bchantina ar C\u02bchorn\u00f4g",
               "ART",
               "eur ha\u00f1v Arc\u02bchantina ar C\u02bchorn\u00f4g",
               "ARST",
               "eur Arc\u02bchantina ar C\u02bchorn\u00f4g",
               "ART",
            };
        final String[] Bolivia = new String[] {
               "eur Bolivia",
               "BOT",
               "Bolivia Summer Time",
               "BOST",
               "Bolivia Time",
               "BOT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "eur c\u02bchoa\u00f1v Sant-P\u00ear-ha-Mikelon",
               "PMST",
               "eur ha\u00f1v Sant-P\u00ear-ha-Mikelon",
               "PMDT",
               "eur Sant-P\u00ear-ha-Mikelon",
               "PMT",
            };
        final String[] Indochina = new String[] {
               "eur Indez-Sina",
               "ICT",
               "Indochina Summer Time",
               "ICST",
               "Indochina Time",
               "ICT",
            };
        final String[] Yekaterinburg = new String[] {
               "eur c\u02bchoa\u00f1v Yekaterinbourg",
               "YEKT",
               "eur ha\u00f1v Yekaterinbourg",
               "YEKST",
               "eur Yekaterinbourg",
               "YEKT",
            };
        final String[] Maldives = new String[] {
               "eur ar Maldivez",
               "MVT",
               "Maldives Summer Time",
               "MVST",
               "Maldives Time",
               "MVT",
            };
        final String[] Tahiti = new String[] {
               "eur Tahiti",
               "TAHT",
               "Tahiti Summer Time",
               "TAHST",
               "Tahiti Time",
               "TAHT",
            };
        final String[] Israel = new String[] {
               "eur c\u02bchoa\u00f1v Israel",
               "IST",
               "eur ha\u00f1v Israel",
               "IDT",
               "eur Israel",
               "IT",
            };
        final String[] Wallis = new String[] {
               "eur Wallis ha Futuna",
               "WFT",
               "Wallis & Futuna Summer Time",
               "WFST",
               "Wallis & Futuna Time",
               "WFT",
            };
        final String[] Africa_Southern = new String[] {
               "eur c\u02bchoa\u00f1v Suafrika",
               "SAST",
               "South Africa Summer Time",
               "SAST",
               "South Africa Time",
               "SAT",
            };
        final String[] Uzbekistan = new String[] {
               "eur c\u02bchoa\u00f1v Ouzbekistan",
               "UZT",
               "eur ha\u00f1v Ouzbekistan",
               "UZST",
               "eur Ouzbekistan",
               "UZT",
            };
        final String[] Seychelles = new String[] {
               "eur Sechelez",
               "SCT",
               "Seychelles Summer Time",
               "SCST",
               "Seychelles Time",
               "SCT",
            };
        final String[] Uruguay = new String[] {
               "eur c\u02bchoa\u00f1v Uruguay",
               "UYT",
               "eur ha\u00f1v Uruguay",
               "UYST",
               "eur Uruguay",
               "UYT",
            };
        final String[] Nepal = new String[] {
               "eur Nepal",
               "NPT",
               "Nepal Summer Time",
               "NPST",
               "Nepal Time",
               "NPT",
            };
        final String[] Mongolia = new String[] {
               "eur c\u02bchoa\u00f1v Ulaanbaatar",
               "ULAT",
               "eur ha\u00f1v Ulaanbaatar",
               "ULAST",
               "eur Ulaanbaatar",
               "ULAT",
            };
        final String[] Niue = new String[] {
               "eur Niue",
               "NUT",
               "Niue Summer Time",
               "NUST",
               "Niue Time",
               "NUT",
            };
        final String[] Falkland = new String[] {
               "eur c\u02bchoa\u00f1v Inizi Falkland",
               "FKT",
               "eur ha\u00f1v Inizi Falkland",
               "FKST",
               "eur Inizi Falkland",
               "FKT",
            };
        final String[] Vanuatu = new String[] {
               "eur c\u02bchoa\u00f1v Vanuatu",
               "VUT",
               "eur ha\u00f1v Vanuatu",
               "VUST",
               "eur Vanuatu",
               "VUT",
            };
        final String[] Novosibirsk = new String[] {
               "eur c\u02bchoa\u00f1v Novosibirsk",
               "NOVT",
               "eur ha\u00f1v Novosibirsk",
               "NOVST",
               "eur Novosibirsk",
               "NOVT",
            };
        final String[] Singapore = new String[] {
               "eur c\u02bchoa\u00f1v Singapour",
               "SRET",
               "Srednekolymsk Daylight Time",
               "SREDT",
               "Srednekolymsk Time",
               "SRET",
            };
        final String[] Azores = new String[] {
               "eur c\u02bchoa\u00f1v an Azorez",
               "AZOT",
               "eur ha\u00f1v an Azorez",
               "AZOST",
               "eur an Azorez",
               "AZOT",
            };
        final String[] Apia = new String[] {
               "eur c\u02bchoa\u00f1v Apia",
               "WSST",
               "eur ha\u00f1v Apia",
               "WSDT",
               "eur Apia",
               "WST",
            };
        final String[] Bhutan = new String[] {
               "eur Bhoutan",
               "BTT",
               "Bhutan Summer Time",
               "BTST",
               "Bhutan Time",
               "BTT",
            };
        final String[] Suriname = new String[] {
               "eur Surinam",
               "SRT",
               "Suriname Summer Time",
               "SRST",
               "Suriname Time",
               "SRT",
            };
        final String[] Nauru = new String[] {
               "eur Nauru",
               "NRT",
               "Nauru Summer Time",
               "NRST",
               "Nauru Time",
               "NRT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "eur Kazakstan ar C\u02bchorn\u00f4g",
               "AQTT",
               "Aqtau Summer Time",
               "AQTST",
               "Aqtau Time",
               "AQTT",
            };
        final String[] Myanmar = new String[] {
               "eur Myanmar",
               "MMT",
               "Myanmar Summer Time",
               "MMST",
               "Myanmar Time",
               "MMT",
            };
        final String[] Christmas = new String[] {
               "eur Enez Christmas",
               "CXT",
               "Christmas Island Summer Time",
               "CXST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Amazon = new String[] {
               "eur c\u02bchoa\u00f1v an Amazon",
               "AMT",
               "eur ha\u00f1v an Amazon",
               "AMST",
               "eur an Amazon",
               "AMT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "eur Kazakstan ar Reter",
               "ALMT",
               "Alma-Ata Summer Time",
               "ALMST",
               "Alma-Ata Time",
               "ALMT",
            };
        final String[] Fiji = new String[] {
               "eur c\u02bchoa\u00f1v Fidji",
               "FJT",
               "eur ha\u00f1v Fidji",
               "FJST",
               "eur Fidji",
               "FJT",
            };
        final String[] Reunion = new String[] {
               "eur ar Re\u00fcnion",
               "RET",
               "Reunion Summer Time",
               "REST",
               "Reunion Time",
               "RET",
            };
        final String[] Cocos = new String[] {
               "eur Inizi Kokoz",
               "CCT",
               "Cocos Islands Summer Time",
               "CCST",
               "Cocos Islands Time",
               "CCT",
            };
        final String[] Chatham = new String[] {
               "eur c\u02bchoa\u00f1v Chatham",
               "CHAST",
               "eur ha\u00f1v Chatham",
               "CHADT",
               "eur Chatham",
               "CHAT",
            };
        final String[] Argentina = new String[] {
               "eur c\u02bchoa\u00f1v Arc\u02bchantina",
               "ART",
               "eur ha\u00f1v Arc\u02bchantina",
               "ARST",
               "eur Arc\u02bchantina",
               "ART",
            };
        final String[] Gambier = new String[] {
               "eur Gambier",
               "GAMT",
               "Gambier Summer Time",
               "GAMST",
               "Gambier Time",
               "GAMT",
            };
        final String[] Tuvalu = new String[] {
               "eur Tuvalu",
               "TVT",
               "Tuvalu Summer Time",
               "TVST",
               "Tuvalu Time",
               "TVT",
            };
        final String[] Galapagos = new String[] {
               "eur Inizi Gal\u00e1pagos",
               "GALT",
               "Galapagos Summer Time",
               "GALST",
               "Galapagos Time",
               "GALT",
            };
        final String[] Macquarie = new String[] {
               "eur Enez Macquarie",
               "MIST",
               "Macquarie Island Daylight Time",
               "MIDT",
               "Macquarie Island Time",
               "MIST",
            };
        final String[] Venezuela = new String[] {
               "eur Venezuela",
               "VET",
               "Venezuela Summer Time",
               "VEST",
               "Venezuela Time",
               "VET",
            };
        final String[] Australia_Central = new String[] {
               "eur c\u02bchoa\u00f1v Kreizaostralia",
               "ACST",
               "eur ha\u00f1v Kreizaostralia",
               "ACDT",
               "eur Kreizaostralia",
               "ACT",
            };
        final String[] Turkmenistan = new String[] {
               "eur c\u02bchoa\u00f1v Turkmenistan",
               "TMT",
               "eur ha\u00f1v Turkmenistan",
               "TMST",
               "eur Turkmenistan",
               "TMT",
            };
        final String[] Europe_Western = new String[] {
               "eur c\u02bchoa\u00f1v Europa ar C\u02bchorn\u00f4g",
               "WET",
               "eur ha\u00f1v Europa ar C\u02bchorn\u00f4g",
               "WEST",
               "eur Europa ar C\u02bchorn\u00f4g",
               "WET",
            };
        final String[] Cape_Verde = new String[] {
               "eur c\u02bchoa\u00f1v ar C\u02bchab-Glas",
               "CVT",
               "eur ha\u00f1v ar C\u02bchab-Glas",
               "CVST",
               "eur ar C\u02bchab-Glas",
               "CVT",
            };
        final String[] Norfolk = new String[] {
               "eur Enez Norfolk",
               "NFT",
               "Norfolk Summer Time",
               "NFST",
               "Norfolk Time",
               "NFT",
            };
        final String[] Guyana = new String[] {
               "eur Guyana",
               "GYT",
               "Guyana Summer Time",
               "GYST",
               "Guyana Time",
               "GYT",
            };
        final String[] Pitcairn = new String[] {
               "eur Pitcairn",
               "PST",
               "Pitcairn Daylight Time",
               "PDT",
               "Pitcairn Time",
               "PT",
            };
        final String[] Samoa = new String[] {
               "eur c\u02bchoa\u00f1v Samoa",
               "SST",
               "eur ha\u00f1v Samoa",
               "SDT",
               "eur Samoa",
               "ST",
            };
        final String[] Palau = new String[] {
               "eur Palau",
               "PWT",
               "Palau Summer Time",
               "PWST",
               "Palau Time",
               "PWT",
            };
        final String[] Azerbaijan = new String[] {
               "eur c\u02bchoa\u00f1v Azerbaidjan",
               "AZT",
               "eur ha\u00f1v Azerbaidjan",
               "AZST",
               "eur Azerbaidjan",
               "AZT",
            };
        final String[] Cuba = new String[] {
               "eur c\u02bchoa\u00f1v Kuba",
               "CST",
               "eur ha\u00f1v Kuba",
               "CDT",
               "eur Kuba",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "eur c\u02bchoa\u00f1v Afrika ar C\u02bchorn\u00f4g",
               "CAT",
               "eur ha\u00f1v Afrika ar C\u02bchorn\u00f4g",
               "CAST",
               "eur Afrika ar C\u02bchorn\u00f4g",
               "CAT",
            };
        final String[] GMT = new String[] {
               "Amzer keitat Greenwich (AKG)",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
            };
        final String[] Philippines = new String[] {
               "eur c\u02bchoa\u00f1v ar Filipinez",
               "PHT",
               "eur ha\u00f1v ar Filipinez",
               "PHST",
               "eur ar Filipinez",
               "PHT",
            };
        final String[] French_Southern = new String[] {
               "eur Douaro\u00f9 aostral Fra\u00f1s hag Antarktika",
               "TFT",
               "French Southern & Antarctic Lands Summer Time",
               "TFST",
               "French Southern & Antarctic Lands Time",
               "TFT",
            };
        final String[] South_Georgia = new String[] {
               "eur Georgia ar Su",
               "GST",
               "South Georgia Daylight Time",
               "GDT",
               "South Georgia Time",
               "GT",
            };
        final String[] New_Caledonia = new String[] {
               "eur c\u02bchoa\u00f1v Kaledonia Nevez",
               "NCT",
               "eur ha\u00f1v Kaledonia Nevez",
               "NCST",
               "eur Kaledonia Nevez",
               "NCT",
            };
        final String[] Brunei = new String[] {
               "eur Brunei Darussalam",
               "BNT",
               "Brunei Summer Time",
               "BNST",
               "Brunei Time",
               "BNT",
            };
        final String[] Iran = new String[] {
               "eur c\u02bchoa\u00f1v Iran",
               "IRST",
               "eur ha\u00f1v Iran",
               "IRDT",
               "eur Iran",
               "IRT",
            };
        final String[] Easter = new String[] {
               "eur c\u02bchoa\u00f1v Enez Pask",
               "EAST",
               "eur ha\u00f1v Enez Pask",
               "EASST",
               "eur Enez Pask",
               "EAST",
            };
        final String[] Mexico_Northwest = new String[] {
               "eur c\u02bchoa\u00f1v Gwalarn Mec\u02bchiko",
               "PST",
               "eur ha\u00f1v Gwalarn Mec\u02bchiko",
               "PDT",
               "eur Gwalarn Mec\u02bchiko",
               "PT",
            };
        final String[] Tajikistan = new String[] {
               "eur Tadjikistan",
               "TJT",
               "Tajikistan Summer Time",
               "TJST",
               "Tajikistan Time",
               "TJT",
            };
        final String[] Tonga = new String[] {
               "eur c\u02bchoa\u00f1v Tonga",
               "TOT",
               "eur ha\u00f1v Tonga",
               "TOST",
               "eur Tonga",
               "TOT",
            };
        final String[] Bangladesh = new String[] {
               "eur c\u02bchoa\u00f1v Bangladesh",
               "BDT",
               "eur ha\u00f1v Bangladesh",
               "BDST",
               "eur Bangladesh",
               "BDT",
            };
        final String[] Peru = new String[] {
               "eur c\u02bchoa\u00f1v Perou",
               "PET",
               "eur ha\u00f1v Perou",
               "PEST",
               "eur Perou",
               "PET",
            };
        final String[] Greenland_Western = new String[] {
               "eur c\u02bchoa\u00f1v Greunland ar C\u02bchorn\u00f4g",
               "WGT",
               "eur ha\u00f1v Greunland ar C\u02bchorn\u00f4g",
               "WGST",
               "eur Greunland ar C\u02bchorn\u00f4g",
               "WGT",
            };
        final String[] Ecuador = new String[] {
               "eur Ecuador",
               "ECT",
               "Ecuador Summer Time",
               "ECST",
               "Ecuador Time",
               "ECT",
            };
        final String[] Greenland_Eastern = new String[] {
               "eur c\u02bchoa\u00f1v Greunland ar Reter",
               "EGT",
               "eur ha\u00f1v Greunland ar Reter",
               "EGST",
               "eur Greunland ar Reter",
               "EGT",
            };
        final String[] Gulf = new String[] {
               "eur c\u02bchoa\u00f1v ar Pleg-mor Arab-ha-Pers",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "eur Indonezia ar Reter",
               "WIT",
               "East Indonesia Summer Time",
               "EIST",
               "East Indonesia Time",
               "WIT",
            };
        final String[] Korea = new String[] {
               "eur c\u02bchoa\u00f1v Korea",
               "KST",
               "eur ha\u00f1v Korea",
               "KDT",
               "eur Korea",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "eur c\u02bchoa\u00f1v Aostralia ar C\u02bchorn\u00f4g",
               "AWST",
               "eur ha\u00f1v Aostralia ar C\u02bchorn\u00f4g",
               "AWDT",
               "eur Aostralia ar C\u02bchorn\u00f4g",
               "AWT",
            };
        final String[] Kyrgystan = new String[] {
               "eur Kyrgyzstan",
               "KGT",
               "Kirgizstan Summer Time",
               "KGST",
               "Kirgizstan Time",
               "KGT",
            };
        final String[] Indonesia_Western = new String[] {
               "eur Indonezia ar C\u02bchorn\u00f4g",
               "WIB",
               "West Indonesia Summer Time",
               "WIST",
               "West Indonesia Time",
               "WIB",
            };
        final String[] Australia_Eastern = new String[] {
               "eur c\u02bchoa\u00f1v Aostralia ar Reter",
               "AEST",
               "eur ha\u00f1v Aostralia ar Reter",
               "AEDT",
               "eur Aostralia ar Reter",
               "AET",
            };
        final String[] French_Guiana = new String[] {
               "eur Gwiana c\u02bchall",
               "GFT",
               "French Guiana Summer Time",
               "GFST",
               "French Guiana Time",
               "GFT",
            };
        final String[] Colombia = new String[] {
               "eur c\u02bchoa\u00f1v Kolombia",
               "COT",
               "eur ha\u00f1v Kolombia",
               "COST",
               "eur Kolombia",
               "COT",
            };
        final String[] Chile = new String[] {
               "eur c\u02bchoa\u00f1v Chile",
               "CLT",
               "eur ha\u00f1v Chile",
               "CLST",
               "eur Chile",
               "CLT",
            };
        final String[] America_Mountain = new String[] {
               "eur c\u02bchoa\u00f1v ar Menezio\u00f9",
               "MST",
               "eur ha\u00f1v ar Menezio\u00f9",
               "MDT",
               "eur ar Menezio\u00f9",
               "MT",
            };
        final String[] Marquesas = new String[] {
               "eur Inizi Markiz",
               "MART",
               "Marquesas Summer Time",
               "MARST",
               "Marquesas Time",
               "MART",
            };
        final String[] Arabian = new String[] {
               "eur c\u02bchoa\u00f1v Arabia",
               "AST",
               "eur ha\u00f1v Arabia",
               "ADT",
               "eur Arabia",
               "AT",
            };
        final String[] Alaska = new String[] {
               "eur c\u02bchoa\u00f1v Alaska",
               "AKST",
               "eur ha\u00f1v Alaska",
               "AKDT",
               "eur Alaska",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "eur c\u02bchoa\u00f1v Vladivostok",
               "VLAT",
               "eur ha\u00f1v Vladivostok",
               "VLAST",
               "eur Vladivostok",
               "VLAT",
            };
        final String[] Irkutsk = new String[] {
               "eur c\u02bchoa\u00f1v Irkutsk",
               "IRKT",
               "eur ha\u00f1v Irkutsk",
               "IRKST",
               "eur Irkutsk",
               "IRKT",
            };
        final String[] Georgia = new String[] {
               "eur c\u02bchoa\u00f1v Jorjia",
               "GET",
               "eur ha\u00f1v Jorjia",
               "GEST",
               "eur Jorjia",
               "GET",
            };
        final String[] Tokelau = new String[] {
               "eur Tokelau",
               "TKT",
               "Tokelau Summer Time",
               "TKST",
               "Tokelau Time",
               "TKT",
            };
        final String[] Brasilia = new String[] {
               "eur c\u02bchoa\u00f1v Bras\u00edlia",
               "BRT",
               "eur ha\u00f1v Bras\u00edlia",
               "BRST",
               "eur Bras\u00edlia",
               "BRT",
            };
        final String[] China = new String[] {
               "eur c\u02bchoa\u00f1v Sina",
               "CST",
               "eur ha\u00f1v Sina",
               "CDT",
               "eur Sina",
               "CT",
            };
        final String[] Armenia = new String[] {
               "eur c\u02bchoa\u00f1v Armenia",
               "AMT",
               "eur ha\u00f1v Armenia",
               "AMST",
               "eur Armenia",
               "AMT",
            };
        final String[] India = new String[] {
               "eur c\u02bchoa\u00f1v India",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Cook = new String[] {
               "eur c\u02bchoa\u00f1v Inizi Cook",
               "CKT",
               "eur ha\u00f1v Inizi Cook",
               "CKHST",
               "eur Inizi Cook",
               "CKT",
            };
        final Object[][] data = new Object[][] {
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "America/Anchorage", Alaska },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Rarotonga", Cook },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London",
                new String[] {
                    "Amzer keitat Greenwich (AKG)",
                    "GMT",
                    "eur ha\u00f1v Breizh-Veur",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "America/Panama", America_Eastern },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Jersey", GMT },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Pacific/Palau", Palau },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Western },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Zurich", Europe_Central },
            { "Asia/Dili", East_Timor },
            { "Africa/Bamako", GMT },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Pacific/Bougainville", New_Zealand },
            { "Africa/Sao_Tome", GMT },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "Indian/Maldives", Maldives },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", Alaska },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Troll", GMT },
            { "Indian/Christmas", Christmas },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "Africa/Gaborone", Africa_Central },
            { "Asia/Gaza", Europe_Eastern },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "Pacific/Pitcairn", Pitcairn },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Europe/Amsterdam", Europe_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "Europe/Dublin",
                new String[] {
                    "Amzer keitat Greenwich (AKG)",
                    "GMT",
                    "eur c\u02bchoa\u00f1v Iwerzhon",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "MST7MDT", America_Mountain },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "Africa/Douala", Africa_Western },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Asia/Taipei", Taipei },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/Oslo", Europe_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "Pacific/Norfolk", Norfolk },
            { "Africa/Kampala", Africa_Eastern },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "Pacific/Auckland", New_Zealand },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "America/Port-au-Prince", America_Eastern },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Cancun", America_Eastern },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "Europe/Madrid", Europe_Central },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Europe/Volgograd", Moscow },
            { "Africa/Blantyre", Africa_Central },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Tehran", Iran },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "Asia/Srednekolymsk", Singapore },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "Australia/Lindeman", Australia_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
