/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_cs extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "St\u0159edoafrick\u00fd \u010das",
               "CAT",
               "Central African Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "Moskevsk\u00fd standardn\u00ed \u010das",
               "MSK",
               "Moskevsk\u00fd letn\u00ed \u010das",
               "MSD",
               "Moskevsk\u00fd \u010das",
               "MT",
            };
        final String[] Japan = new String[] {
               "Japonsk\u00fd standardn\u00ed \u010das",
               "JST",
               "Japonsk\u00fd letn\u00ed \u010das",
               "JDT",
               "Japonsk\u00fd \u010das",
               "JT",
            };
        final String[] Pakistan = new String[] {
               "P\u00e1kist\u00e1nsk\u00fd standardn\u00ed \u010das",
               "PKT",
               "P\u00e1kist\u00e1nsk\u00fd letn\u00ed \u010das",
               "PKST",
               "P\u00e1kist\u00e1nsk\u00fd \u010das",
               "PKT",
            };
        final String[] Taipei = new String[] {
               "Tchajpejsk\u00fd standardn\u00ed \u010das",
               "CST",
               "Tchajpejsk\u00fd letn\u00ed \u010das",
               "CDT",
               "Tchajpejsk\u00fd \u010das",
               "CT",
            };
        final String[] Hovd = new String[] {
               "Hovdsk\u00fd standardn\u00ed \u010das",
               "HOVT",
               "Hovdsk\u00fd letn\u00ed \u010das",
               "HOVST",
               "Hovdsk\u00fd \u010das",
               "HOVT",
            };
        final String[] Magadan = new String[] {
               "Magadansk\u00fd standardn\u00ed \u010das",
               "MAGT",
               "Magadansk\u00fd letn\u00ed \u010das",
               "MAGST",
               "Magadansk\u00fd \u010das",
               "MAGT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "St\u0159edoz\u00e1padn\u00ed australsk\u00fd standardn\u00ed \u010das",
               "ACWST",
               "St\u0159edoz\u00e1padn\u00ed australsk\u00fd letn\u00ed \u010das",
               "ACWDT",
               "St\u0159edoz\u00e1padn\u00ed australsk\u00fd \u010das",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "St\u0159edoevropsk\u00fd standardn\u00ed \u010das",
               "SE\u010c",
               "St\u0159edoevropsk\u00fd letn\u00ed \u010das",
               "SEL\u010c",
               "St\u0159edoevropsk\u00fd \u010das",
               "SE\u010c",
            };
        final String[] Sakhalin = new String[] {
               "Sachalinsk\u00fd standardn\u00ed \u010das",
               "SAKT",
               "Sachalinsk\u00fd letn\u00ed \u010das",
               "SAKST",
               "Sachalinsk\u00fd \u010das",
               "SAKT",
            };
        final String[] Paraguay = new String[] {
               "Paraguaysk\u00fd standardn\u00ed \u010das",
               "PYT",
               "Paraguaysk\u00fd letn\u00ed \u010das",
               "PYST",
               "Paraguaysk\u00fd \u010das",
               "PYT",
            };
        final String[] Acre = new String[] {
               "Acrejsk\u00fd standardn\u00ed \u010das",
               "ACT",
               "Acrejsk\u00fd letn\u00ed \u010das",
               "ACST",
               "Acrejsk\u00fd \u010das",
               "ACT",
            };
        final String[] Malaysia = new String[] {
               "Malajsk\u00fd \u010das",
               "MYT",
               "Malaysia Summer Time",
               "MYST",
               "Malaysia Time",
               "MYT",
            };
        final String[] America_Eastern = new String[] {
               "Severoamerick\u00fd v\u00fdchodn\u00ed standardn\u00ed \u010das",
               "EST",
               "Severoamerick\u00fd v\u00fdchodn\u00ed letn\u00ed \u010das",
               "EDT",
               "Severoamerick\u00fd v\u00fdchodn\u00ed \u010das",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "Standardn\u00ed \u010das ostrova lorda Howa",
               "LHST",
               "Letn\u00ed \u010das ostrova lorda Howa",
               "LHDT",
               "\u010cas ostrova lorda Howa",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "Novoz\u00e9landsk\u00fd standardn\u00ed \u010das",
               "NZST",
               "Novoz\u00e9landsk\u00fd letn\u00ed \u010das",
               "NZDT",
               "Novoz\u00e9landsk\u00fd \u010das",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "Indickooce\u00e1nsk\u00fd \u010das",
               "IOT",
               "Indian Ocean Territory Summer Time",
               "IOST",
               "Indian Ocean Territory Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "Jakutsk\u00fd standardn\u00ed \u010das",
               "YAKT",
               "Jakutsk\u00fd letn\u00ed \u010das",
               "YAKST",
               "Jakutsk\u00fd \u010das",
               "YAKT",
            };
        final String[] Mauritius = new String[] {
               "Mauricijsk\u00fd standardn\u00ed \u010das",
               "MUT",
               "Mauricijsk\u00fd letn\u00ed \u010das",
               "MUST",
               "Mauricijsk\u00fd \u010das",
               "MUT",
            };
        final String[] Africa_Eastern = new String[] {
               "V\u00fdchodoafrick\u00fd \u010das",
               "EAT",
               "Eastern African Summer Time",
               "EAST",
               "Eastern Africa Time",
               "EAT",
            };
        final String[] East_Timor = new String[] {
               "V\u00fdchodotimorsk\u00fd \u010das",
               "TLT",
               "Timor-Leste Summer Time",
               "TLST",
               "Timor-Leste Time",
               "TLT",
            };
        final String[] Solomon = new String[] {
               "\u010cas \u0160alamounov\u00fdch ostrov\u016f",
               "SBT",
               "Solomon Is. Summer Time",
               "SBST",
               "Solomon Is. Time",
               "SBT",
            };
        final String[] Kosrae = new String[] {
               "Kosrajsk\u00fd \u010das",
               "KOST",
               "Kosrae Summer Time",
               "KOSST",
               "Kosrae Time",
               "KOST",
            };
        final String[] Marshall_Islands = new String[] {
               "\u010cas Marshallov\u00fdch ostrov\u016f",
               "MHT",
               "Marshall Islands Summer Time",
               "MHST",
               "Marshall Islands Time",
               "MHT",
            };
        final String[] Europe_Eastern = new String[] {
               "V\u00fdchodoevropsk\u00fd standardn\u00ed \u010das",
               "EET",
               "V\u00fdchodoevropsk\u00fd letn\u00ed \u010das",
               "EEST",
               "V\u00fdchodoevropsk\u00fd \u010das",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "Newfoundlandsk\u00fd standardn\u00ed \u010das",
               "NST",
               "Newfoundlandsk\u00fd letn\u00ed \u010das",
               "NDT",
               "Newfoundlandsk\u00fd \u010das",
               "NT",
            };
        final String[] Afghanistan = new String[] {
               "Afgh\u00e1nsk\u00fd \u010das",
               "AFT",
               "Afghanistan Summer Time",
               "AFST",
               "Afghanistan Time",
               "AFT",
            };
        final String[] Hong_Kong = new String[] {
               "Hongkongsk\u00fd standardn\u00ed \u010das",
               "HKT",
               "Hongkongsk\u00fd letn\u00ed \u010das",
               "HKST",
               "Hongkongsk\u00fd \u010das",
               "HKT",
            };
        final String[] Argentina_Western = new String[] {
               "Z\u00e1padoargentinsk\u00fd standardn\u00ed \u010das",
               "ART",
               "Z\u00e1padoargentinsk\u00fd letn\u00ed \u010das",
               "ARST",
               "Z\u00e1padoargentinsk\u00fd \u010das",
               "ART",
            };
        final String[] Atlantic = new String[] {
               "Atlantick\u00fd standardn\u00ed \u010das",
               "AST",
               "Atlantick\u00fd letn\u00ed \u010das",
               "ADT",
               "Atlantick\u00fd \u010das",
               "AT",
            };
        final String[] Ponape = new String[] {
               "Ponapsk\u00fd \u010das",
               "PONT",
               "Pohnpei Summer Time",
               "PONST",
               "Ponape Time",
               "PONT",
            };
        final String[] Bolivia = new String[] {
               "Bolivijsk\u00fd \u010das",
               "BOT",
               "Bolivia Summer Time",
               "BOST",
               "Bolivia Time",
               "BOT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Pierre-miquelonsk\u00fd standardn\u00ed \u010das",
               "PMST",
               "Pierre-miquelonsk\u00fd letn\u00ed \u010das",
               "PMDT",
               "Pierre-miquelonsk\u00fd \u010das",
               "PMT",
            };
        final String[] Indochina = new String[] {
               "Indo\u010d\u00ednsk\u00fd \u010das",
               "ICT",
               "Indochina Summer Time",
               "ICST",
               "Indochina Time",
               "ICT",
            };
        final String[] Yekaterinburg = new String[] {
               "Jekat\u011brinbursk\u00fd standardn\u00ed \u010das",
               "YEKT",
               "Jekat\u011brinbursk\u00fd letn\u00ed \u010das",
               "YEKST",
               "Jekat\u011brinbursk\u00fd \u010das",
               "YEKT",
            };
        final String[] Maldives = new String[] {
               "Maledivsk\u00fd \u010das",
               "MVT",
               "Maldives Summer Time",
               "MVST",
               "Maldives Time",
               "MVT",
            };
        final String[] Tahiti = new String[] {
               "Tahitsk\u00fd \u010das",
               "TAHT",
               "Tahiti Summer Time",
               "TAHST",
               "Tahiti Time",
               "TAHT",
            };
        final String[] Israel = new String[] {
               "Izraelsk\u00fd standardn\u00ed \u010das",
               "IST",
               "Izraelsk\u00fd letn\u00ed \u010das",
               "IDT",
               "Izraelsk\u00fd \u010das",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "St\u0159edoindon\u00e9sk\u00fd \u010das",
               "WITA",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "WITA",
            };
        final String[] Wallis = new String[] {
               "\u010cas ostrov\u016f Wallis a Futuna",
               "WFT",
               "Wallis & Futuna Summer Time",
               "WFST",
               "Wallis & Futuna Time",
               "WFT",
            };
        final String[] Africa_Southern = new String[] {
               "Jihoafrick\u00fd \u010das",
               "SAST",
               "South Africa Summer Time",
               "SAST",
               "South Africa Time",
               "SAT",
            };
        final String[] Syowa = new String[] {
               "\u010cas stanice \u0160\u00f3wa",
               "SYOT",
               "Syowa Summer Time",
               "SYOST",
               "Syowa Time",
               "SYOT",
            };
        final String[] Line_Islands = new String[] {
               "\u010cas Rovn\u00edkov\u00fdch ostrov\u016f",
               "LINT",
               "Line Is. Summer Time",
               "LINST",
               "Line Is. Time",
               "LINT",
            };
        final String[] Uzbekistan = new String[] {
               "Uzbeck\u00fd standardn\u00ed \u010das",
               "UZT",
               "Uzbeck\u00fd letn\u00ed \u010das",
               "UZST",
               "Uzbeck\u00fd \u010das",
               "UZT",
            };
        final String[] Omsk = new String[] {
               "Omsk\u00fd standardn\u00ed \u010das",
               "OMST",
               "Omsk\u00fd letn\u00ed \u010das",
               "OMSST",
               "Omsk\u00fd \u010das",
               "OMST",
            };
        final String[] Seychelles = new String[] {
               "Seychelsk\u00fd \u010das",
               "SCT",
               "Seychelles Summer Time",
               "SCST",
               "Seychelles Time",
               "SCT",
            };
        final String[] Uruguay = new String[] {
               "Uruguaysk\u00fd standardn\u00ed \u010das",
               "UYT",
               "Uruguaysk\u00fd letn\u00ed \u010das",
               "UYST",
               "Uruguaysk\u00fd \u010das",
               "UYT",
            };
        final String[] Nepal = new String[] {
               "Nep\u00e1lsk\u00fd \u010das",
               "NPT",
               "Nepal Summer Time",
               "NPST",
               "Nepal Time",
               "NPT",
            };
        final String[] Mongolia = new String[] {
               "Ul\u00e1nb\u00e1tarsk\u00fd standardn\u00ed \u010das",
               "ULAT",
               "Ul\u00e1nb\u00e1tarsk\u00fd letn\u00ed \u010das",
               "ULAST",
               "Ul\u00e1nb\u00e1tarsk\u00fd \u010das",
               "ULAT",
            };
        final String[] America_Central = new String[] {
               "Severoamerick\u00fd centr\u00e1ln\u00ed standardn\u00ed \u010das",
               "CST",
               "Severoamerick\u00fd centr\u00e1ln\u00ed letn\u00ed \u010das",
               "CDT",
               "Severoamerick\u00fd centr\u00e1ln\u00ed \u010das",
               "CT",
            };
        final String[] Truk = new String[] {
               "Chuuksk\u00fd \u010das",
               "CHUT",
               "Chuuk Summer Time",
               "CHUST",
               "Chuuk Time",
               "CHUT",
            };
        final String[] Niue = new String[] {
               "Niuejsk\u00fd \u010das",
               "NUT",
               "Niue Summer Time",
               "NUST",
               "Niue Time",
               "NUT",
            };
        final String[] Wake = new String[] {
               "\u010cas ostrova Wake",
               "WAKT",
               "Wake Summer Time",
               "WAKST",
               "Wake Time",
               "WAKT",
            };
        final String[] Falkland = new String[] {
               "Falklandsk\u00fd standardn\u00ed \u010das",
               "FKT",
               "Falklandsk\u00fd letn\u00ed \u010das",
               "FKST",
               "Falklandsk\u00fd \u010das",
               "FKT",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatsk\u00fd standardn\u00ed \u010das",
               "VUT",
               "Vanuatsk\u00fd letn\u00ed \u010das",
               "VUST",
               "Vanuatsk\u00fd \u010das",
               "VUT",
            };
        final String[] Novosibirsk = new String[] {
               "Novosibirsk\u00fd standardn\u00ed \u010das",
               "NOVT",
               "Novosibirsk\u00fd letn\u00ed \u010das",
               "NOVST",
               "Novosibirsk\u00fd \u010das",
               "NOVT",
            };
        final String[] Singapore = new String[] {
               "Singapursk\u00fd \u010das",
               "SRET",
               "Srednekolymsk Daylight Time",
               "SREDT",
               "Srednekolymsk Time",
               "SRET",
            };
        final String[] Azores = new String[] {
               "Azorsk\u00fd standardn\u00ed \u010das",
               "AZOT",
               "Azorsk\u00fd letn\u00ed \u010das",
               "AZOST",
               "Azorsk\u00fd \u010das",
               "AZOT",
            };
        final String[] Apia = new String[] {
               "Apijsk\u00fd standardn\u00ed \u010das",
               "WSST",
               "Apijsk\u00fd letn\u00ed \u010das",
               "WSDT",
               "Apijsk\u00fd \u010das",
               "WST",
            };
        final String[] Bhutan = new String[] {
               "Bh\u00fat\u00e1nsk\u00fd \u010das",
               "BTT",
               "Bhutan Summer Time",
               "BTST",
               "Bhutan Time",
               "BTT",
            };
        final String[] Suriname = new String[] {
               "Surinamsk\u00fd \u010das",
               "SRT",
               "Suriname Summer Time",
               "SRST",
               "Suriname Time",
               "SRT",
            };
        final String[] Nauru = new String[] {
               "Naursk\u00fd \u010das",
               "NRT",
               "Nauru Summer Time",
               "NRST",
               "Nauru Time",
               "NRT",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnojarsk\u00fd standardn\u00ed \u010das",
               "KRAT",
               "Krasnojarsk\u00fd letn\u00ed \u010das",
               "KRAST",
               "Krasnojarsk\u00fd \u010das",
               "KRAT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Z\u00e1padokazachst\u00e1nsk\u00fd \u010das",
               "AQTT",
               "Aqtau Summer Time",
               "AQTST",
               "Aqtau Time",
               "AQTT",
            };
        final String[] Myanmar = new String[] {
               "Myanmarsk\u00fd \u010das",
               "MMT",
               "Myanmar Summer Time",
               "MMST",
               "Myanmar Time",
               "MMT",
            };
        final String[] Christmas = new String[] {
               "\u010cas V\u00e1no\u010dn\u00edho ostrova",
               "CXT",
               "Christmas Island Summer Time",
               "CXST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Amazon = new String[] {
               "Amazonsk\u00fd standardn\u00ed \u010das",
               "AMT",
               "Amazonsk\u00fd letn\u00ed \u010das",
               "AMST",
               "Amazonsk\u00fd \u010das",
               "AMT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "V\u00fdchodokazachst\u00e1nsk\u00fd \u010das",
               "ALMT",
               "Alma-Ata Summer Time",
               "ALMST",
               "Alma-Ata Time",
               "ALMT",
            };
        final String[] Fiji = new String[] {
               "Fid\u017eijsk\u00fd standardn\u00ed \u010das",
               "FJT",
               "Fid\u017eijsk\u00fd letn\u00ed \u010das",
               "FJST",
               "Fid\u017eijsk\u00fd \u010das",
               "FJT",
            };
        final String[] Reunion = new String[] {
               "R\u00e9unionsk\u00fd \u010das",
               "RET",
               "Reunion Summer Time",
               "REST",
               "Reunion Time",
               "RET",
            };
        final String[] Cocos = new String[] {
               "\u010cas Kokosov\u00fdch ostrov\u016f",
               "CCT",
               "Cocos Islands Summer Time",
               "CCST",
               "Cocos Islands Time",
               "CCT",
            };
        final String[] Chatham = new String[] {
               "Chathamsk\u00fd standardn\u00ed \u010das",
               "CHAST",
               "Chathamsk\u00fd letn\u00ed \u010das",
               "CHADT",
               "Chathamsk\u00fd \u010das",
               "CHAT",
            };
        final String[] Vostok = new String[] {
               "\u010cas stanice Vostok",
               "VOST",
               "Vostok Summer Time",
               "VOSST",
               "Vostok Time",
               "VOST",
            };
        final String[] Argentina = new String[] {
               "Argentinsk\u00fd standardn\u00ed \u010das",
               "ART",
               "Argentinsk\u00fd letn\u00ed \u010das",
               "ARST",
               "Argentinsk\u00fd \u010das",
               "ART",
            };
        final String[] Gambier = new String[] {
               "Gambiersk\u00fd \u010das",
               "GAMT",
               "Gambier Summer Time",
               "GAMST",
               "Gambier Time",
               "GAMT",
            };
        final String[] Kamchatka = new String[] {
               "Petropavlovsko-kam\u010datsk\u00fd standardn\u00ed \u010das",
               "PETT",
               "Petropavlovsko-kam\u010datsk\u00fd letn\u00ed \u010das",
               "PETST",
               "Petropavlovsko-kam\u010datsk\u00fd \u010das",
               "PETT",
            };
        final String[] Tuvalu = new String[] {
               "Tuvalsk\u00fd \u010das",
               "TVT",
               "Tuvalu Summer Time",
               "TVST",
               "Tuvalu Time",
               "TVT",
            };
        final String[] Galapagos = new String[] {
               "Galap\u00e1\u017esk\u00fd \u010das",
               "GALT",
               "Galapagos Summer Time",
               "GALST",
               "Galapagos Time",
               "GALT",
            };
        final String[] Macquarie = new String[] {
               "\u010cas ostrova Macquarie",
               "MIST",
               "Macquarie Island Daylight Time",
               "MIDT",
               "Macquarie Island Time",
               "MIST",
            };
        final String[] Venezuela = new String[] {
               "Venezuelsk\u00fd \u010das",
               "VET",
               "Venezuela Summer Time",
               "VEST",
               "Venezuela Time",
               "VET",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Havajsko-aleutsk\u00fd standardn\u00ed \u010das",
               "HAST",
               "Havajsko-aleutsk\u00fd letn\u00ed \u010das",
               "HADT",
               "Havajsko-aleutsk\u00fd \u010das",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "St\u0159edoaustralsk\u00fd standardn\u00ed \u010das",
               "ACST",
               "St\u0159edoaustralsk\u00fd letn\u00ed \u010das",
               "ACDT",
               "St\u0159edoaustralsk\u00fd \u010das",
               "ACT",
            };
        final String[] America_Pacific = new String[] {
               "Severoamerick\u00fd pacifick\u00fd standardn\u00ed \u010das",
               "PST",
               "Severoamerick\u00fd pacifick\u00fd letn\u00ed \u010das",
               "PDT",
               "Severoamerick\u00fd pacifick\u00fd \u010das",
               "PT",
            };
        final String[] Phoenix_Islands = new String[] {
               "\u010cas F\u00e9nixov\u00fdch ostrov\u016f",
               "PHOT",
               "Phoenix Is. Summer Time",
               "PHOST",
               "Phoenix Is. Time",
               "PHOT",
            };
        final String[] Turkmenistan = new String[] {
               "Turkmensk\u00fd standardn\u00ed \u010das",
               "TMT",
               "Turkmensk\u00fd letn\u00ed \u010das",
               "TMST",
               "Turkmensk\u00fd \u010das",
               "TMT",
            };
        final String[] Europe_Western = new String[] {
               "Z\u00e1padoevropsk\u00fd standardn\u00ed \u010das",
               "WET",
               "Z\u00e1padoevropsk\u00fd letn\u00ed \u010das",
               "WEST",
               "Z\u00e1padoevropsk\u00fd \u010das",
               "WET",
            };
        final String[] Cape_Verde = new String[] {
               "Kapverdsk\u00fd standardn\u00ed \u010das",
               "CVT",
               "Kapverdsk\u00fd letn\u00ed \u010das",
               "CVST",
               "Kapverdsk\u00fd \u010das",
               "CVT",
            };
        final String[] Norfolk = new String[] {
               "Norfolsk\u00fd \u010das",
               "NFT",
               "Norfolk Summer Time",
               "NFST",
               "Norfolk Time",
               "NFT",
            };
        final String[] Guyana = new String[] {
               "Guyansk\u00fd \u010das",
               "GYT",
               "Guyana Summer Time",
               "GYST",
               "Guyana Time",
               "GYT",
            };
        final String[] Pitcairn = new String[] {
               "\u010cas Pitcairnova ostrova",
               "PST",
               "Pitcairn Daylight Time",
               "PDT",
               "Pitcairn Time",
               "PT",
            };
        final String[] Rothera = new String[] {
               "\u010cas Rotherovy stanice",
               "ROTT",
               "Rothera Summer Time",
               "ROTST",
               "Rothera Time",
               "ROTT",
            };
        final String[] Samoa = new String[] {
               "Samojsk\u00fd standardn\u00ed \u010das",
               "SST",
               "Samojsk\u00fd letn\u00ed \u010das",
               "SDT",
               "Samojsk\u00fd \u010das",
               "ST",
            };
        final String[] Palau = new String[] {
               "Palausk\u00fd \u010das",
               "PWT",
               "Palau Summer Time",
               "PWST",
               "Palau Time",
               "PWT",
            };
        final String[] Europe_Further_Eastern = new String[] {
               "D\u00e1ln\u011bv\u00fdchodoevropsk\u00fd \u010das",
               "MSK",
               "Moscow Daylight Time",
               "MSD",
               "Moscow Time",
               "MT",
            };
        final String[] Azerbaijan = new String[] {
               "\u00c1zerb\u00e1jd\u017e\u00e1nsk\u00fd standardn\u00ed \u010das",
               "AZT",
               "\u00c1zerb\u00e1jd\u017e\u00e1nsk\u00fd letn\u00ed \u010das",
               "AZST",
               "\u00c1zerb\u00e1jd\u017e\u00e1nsk\u00fd \u010das",
               "AZT",
            };
        final String[] Mawson = new String[] {
               "\u010cas Mawsonovy stanice",
               "MAWT",
               "Mawson Summer Time",
               "MAWST",
               "Mawson Time",
               "MAWT",
            };
        final String[] Mexico_Pacific = new String[] {
               "Mexick\u00fd pacifick\u00fd standardn\u00ed \u010das",
               "MST",
               "Mexick\u00fd pacifick\u00fd letn\u00ed \u010das",
               "MDT",
               "Mexick\u00fd pacifick\u00fd \u010das",
               "MT",
            };
        final String[] Davis = new String[] {
               "\u010cas Davisovy stanice",
               "DAVT",
               "Davis Summer Time",
               "DAVST",
               "Davis Time",
               "DAVT",
            };
        final String[] Cuba = new String[] {
               "Kub\u00e1nsk\u00fd standardn\u00ed \u010das",
               "CST",
               "Kub\u00e1nsk\u00fd letn\u00ed \u010das",
               "CDT",
               "Kub\u00e1nsk\u00fd \u010das",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "Z\u00e1padoafrick\u00fd standardn\u00ed \u010das",
               "CAT",
               "Z\u00e1padoafrick\u00fd letn\u00ed \u010das",
               "CAST",
               "Z\u00e1padoafrick\u00fd \u010das",
               "CAT",
            };
        final String[] GMT = new String[] {
               "Greenwichsk\u00fd st\u0159edn\u00ed \u010das",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
            };
        final String[] Philippines = new String[] {
               "Filip\u00ednsk\u00fd standardn\u00ed \u010das",
               "PHT",
               "Filip\u00ednsk\u00fd letn\u00ed \u010das",
               "PHST",
               "Filip\u00ednsk\u00fd \u010das",
               "PHT",
            };
        final String[] French_Southern = new String[] {
               "\u010cas Francouzsk\u00fdch ji\u017en\u00edch a antarktick\u00fdch \u00fazem\u00ed",
               "TFT",
               "French Southern & Antarctic Lands Summer Time",
               "TFST",
               "French Southern & Antarctic Lands Time",
               "TFT",
            };
        final String[] South_Georgia = new String[] {
               "\u010cas Ji\u017en\u00ed Georgie",
               "GST",
               "South Georgia Daylight Time",
               "GDT",
               "South Georgia Time",
               "GT",
            };
        final String[] New_Caledonia = new String[] {
               "Novokaledonsk\u00fd standardn\u00ed \u010das",
               "NCT",
               "Novokaledonsk\u00fd letn\u00ed \u010das",
               "NCST",
               "Novokaledonsk\u00fd \u010das",
               "NCT",
            };
        final String[] Brunei = new String[] {
               "Brunejsk\u00fd \u010das",
               "BNT",
               "Brunei Summer Time",
               "BNST",
               "Brunei Time",
               "BNT",
            };
        final String[] Iran = new String[] {
               "\u00cdr\u00e1nsk\u00fd standardn\u00ed \u010das",
               "IRST",
               "\u00cdr\u00e1nsk\u00fd letn\u00ed \u010das",
               "IRDT",
               "\u00cdr\u00e1nsk\u00fd \u010das",
               "IRT",
            };
        final String[] Easter = new String[] {
               "Standardn\u00ed \u010das Velikono\u010dn\u00edho ostrova",
               "EAST",
               "Letn\u00ed \u010das Velikono\u010dn\u00edho ostrova",
               "EASST",
               "\u010cas Velikono\u010dn\u00edho ostrova",
               "EAST",
            };
        final String[] Mexico_Northwest = new String[] {
               "Severoz\u00e1padn\u00ed mexick\u00fd standardn\u00ed \u010das",
               "PST",
               "Severoz\u00e1padn\u00ed mexick\u00fd letn\u00ed \u010das",
               "PDT",
               "Severoz\u00e1padn\u00ed mexick\u00fd \u010das",
               "PT",
            };
        final String[] DumontDUrville = new String[] {
               "\u010cas stanice Dumonta d\u2019Urvilla",
               "DDUT",
               "Dumont-d'Urville Summer Time",
               "DDUST",
               "Dumont-d'Urville Time",
               "DDUT",
            };
        final String[] Tajikistan = new String[] {
               "T\u00e1d\u017eick\u00fd \u010das",
               "TJT",
               "Tajikistan Summer Time",
               "TJST",
               "Tajikistan Time",
               "TJT",
            };
        final String[] Tonga = new String[] {
               "Ton\u017esk\u00fd standardn\u00ed \u010das",
               "TOT",
               "Ton\u017esk\u00fd letn\u00ed \u010das",
               "TOST",
               "Ton\u017esk\u00fd \u010das",
               "TOT",
            };
        final String[] Bangladesh = new String[] {
               "Banglad\u00e9\u0161sk\u00fd standardn\u00ed \u010das",
               "BDT",
               "Banglad\u00e9\u0161sk\u00fd letn\u00ed \u010das",
               "BDST",
               "Banglad\u00e9\u0161sk\u00fd \u010das",
               "BDT",
            };
        final String[] Peru = new String[] {
               "Peru\u00e1nsk\u00fd standardn\u00ed \u010das",
               "PET",
               "Peru\u00e1nsk\u00fd letn\u00ed \u010das",
               "PEST",
               "Peru\u00e1nsk\u00fd \u010das",
               "PET",
            };
        final String[] Greenland_Western = new String[] {
               "Z\u00e1padogr\u00f3nsk\u00fd standardn\u00ed \u010das",
               "WGT",
               "Z\u00e1padogr\u00f3nsk\u00fd letn\u00ed \u010das",
               "WGST",
               "Z\u00e1padogr\u00f3nsk\u00fd \u010das",
               "WGT",
            };
        final String[] Ecuador = new String[] {
               "Ekv\u00e1dorsk\u00fd \u010das",
               "ECT",
               "Ecuador Summer Time",
               "ECST",
               "Ecuador Time",
               "ECT",
            };
        final String[] Greenland_Eastern = new String[] {
               "V\u00fdchodogr\u00f3nsk\u00fd standardn\u00ed \u010das",
               "EGT",
               "V\u00fdchodogr\u00f3nsk\u00fd letn\u00ed \u010das",
               "EGST",
               "V\u00fdchodogr\u00f3nsk\u00fd \u010das",
               "EGT",
            };
        final String[] Gulf = new String[] {
               "Standardn\u00ed \u010das Persk\u00e9ho z\u00e1livu",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "V\u00fdchodoindon\u00e9sk\u00fd \u010das",
               "WIT",
               "East Indonesia Summer Time",
               "EIST",
               "East Indonesia Time",
               "WIT",
            };
        final String[] Korea = new String[] {
               "Korejsk\u00fd standardn\u00ed \u010das",
               "KST",
               "Korejsk\u00fd letn\u00ed \u010das",
               "KDT",
               "Korejsk\u00fd \u010das",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "Z\u00e1padoaustralsk\u00fd standardn\u00ed \u010das",
               "AWST",
               "Z\u00e1padoaustralsk\u00fd letn\u00ed \u010das",
               "AWDT",
               "Z\u00e1padoaustralsk\u00fd \u010das",
               "AWT",
            };
        final String[] Kyrgystan = new String[] {
               "Kyrgyzsk\u00fd \u010das",
               "KGT",
               "Kirgizstan Summer Time",
               "KGST",
               "Kirgizstan Time",
               "KGT",
            };
        final String[] Indonesia_Western = new String[] {
               "Z\u00e1padoindon\u00e9sk\u00fd \u010das",
               "WIB",
               "West Indonesia Summer Time",
               "WIST",
               "West Indonesia Time",
               "WIB",
            };
        final String[] Australia_Eastern = new String[] {
               "V\u00fdchodoaustralsk\u00fd standardn\u00ed \u010das",
               "AEST",
               "V\u00fdchodoaustralsk\u00fd letn\u00ed \u010das",
               "AEDT",
               "V\u00fdchodoaustralsk\u00fd \u010das",
               "AET",
            };
        final String[] French_Guiana = new String[] {
               "Francouzskoguyansk\u00fd \u010das",
               "GFT",
               "French Guiana Summer Time",
               "GFST",
               "French Guiana Time",
               "GFT",
            };
        final String[] Colombia = new String[] {
               "Kolumbijsk\u00fd standardn\u00ed \u010das",
               "COT",
               "Kolumbijsk\u00fd letn\u00ed \u010das",
               "COST",
               "Kolumbijsk\u00fd \u010das",
               "COT",
            };
        final String[] Chile = new String[] {
               "Chilsk\u00fd standardn\u00ed \u010das",
               "CLT",
               "Chilsk\u00fd letn\u00ed \u010das",
               "CLST",
               "Chilsk\u00fd \u010das",
               "CLT",
            };
        final String[] Gilbert_Islands = new String[] {
               "\u010cas Gilbertov\u00fdch ostrov\u016f",
               "GILT",
               "Gilbert Is. Summer Time",
               "GILST",
               "Gilbert Is. Time",
               "GILT",
            };
        final String[] America_Mountain = new String[] {
               "Severoamerick\u00fd horsk\u00fd standardn\u00ed \u010das",
               "MST",
               "Severoamerick\u00fd horsk\u00fd letn\u00ed \u010das",
               "MDT",
               "Severoamerick\u00fd horsk\u00fd \u010das",
               "MT",
            };
        final String[] Marquesas = new String[] {
               "Mark\u00e9zsk\u00fd \u010das",
               "MART",
               "Marquesas Summer Time",
               "MARST",
               "Marquesas Time",
               "MART",
            };
        final String[] Arabian = new String[] {
               "Arabsk\u00fd standardn\u00ed \u010das",
               "AST",
               "Arabsk\u00fd letn\u00ed \u010das",
               "ADT",
               "Arabsk\u00fd \u010das",
               "AT",
            };
        final String[] Alaska = new String[] {
               "Alja\u0161sk\u00fd standardn\u00ed \u010das",
               "AKST",
               "Alja\u0161sk\u00fd letn\u00ed \u010das",
               "AKDT",
               "Alja\u0161sk\u00fd \u010das",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "Vladivostock\u00fd standardn\u00ed \u010das",
               "VLAT",
               "Vladivostock\u00fd letn\u00ed \u010das",
               "VLAST",
               "Vladivostock\u00fd \u010das",
               "VLAT",
            };
        final String[] Chamorro = new String[] {
               "Chamorrsk\u00fd \u010das",
               "ChST",
               "Chamorro Daylight Time",
               "ChDT",
               "Chamorro Time",
               "ChT",
            };
        final String[] Irkutsk = new String[] {
               "Irkutsk\u00fd standardn\u00ed \u010das",
               "IRKT",
               "Irkutsk\u00fd letn\u00ed \u010das",
               "IRKST",
               "Irkutsk\u00fd \u010das",
               "IRKT",
            };
        final String[] Georgia = new String[] {
               "Gruz\u00ednsk\u00fd standardn\u00ed \u010das",
               "GET",
               "Gruz\u00ednsk\u00fd letn\u00ed \u010das",
               "GEST",
               "Gruz\u00ednsk\u00fd \u010das",
               "GET",
            };
        final String[] Tokelau = new String[] {
               "Tokelausk\u00fd \u010das",
               "TKT",
               "Tokelau Summer Time",
               "TKST",
               "Tokelau Time",
               "TKT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "\u010cas Papuy-Nov\u00e9 Guiney",
               "PGT",
               "Papua New Guinea Summer Time",
               "PGST",
               "Papua New Guinea Time",
               "PGT",
            };
        final String[] Noronha = new String[] {
               "Standardn\u00ed \u010das souostrov\u00ed Fernando de Noronha",
               "FNT",
               "Letn\u00ed \u010das souostrov\u00ed Fernando de Noronha",
               "FNST",
               "\u010cas souostrov\u00ed Fernando de Noronha",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "\u010cojbalsansk\u00fd standardn\u00ed \u010das",
               "CHOT",
               "\u010cojbalsansk\u00fd letn\u00ed \u010das",
               "CHOST",
               "\u010cojbalsansk\u00fd \u010das",
               "CHOT",
            };
        final String[] Brasilia = new String[] {
               "Brasilijsk\u00fd standardn\u00ed \u010das",
               "BRT",
               "Brasilijsk\u00fd letn\u00ed \u010das",
               "BRST",
               "Brasilijsk\u00fd \u010das",
               "BRT",
            };
        final String[] China = new String[] {
               "\u010c\u00ednsk\u00fd standardn\u00ed \u010das",
               "CST",
               "\u010c\u00ednsk\u00fd letn\u00ed \u010das",
               "CDT",
               "\u010c\u00ednsk\u00fd \u010das",
               "CT",
            };
        final String[] Armenia = new String[] {
               "Arm\u00e9nsk\u00fd standardn\u00ed \u010das",
               "AMT",
               "Arm\u00e9nsk\u00fd letn\u00ed \u010das",
               "AMST",
               "Arm\u00e9nsk\u00fd \u010das",
               "AMT",
            };
        final String[] Samara = new String[] {
               "Samarsk\u00fd standardn\u00ed \u010das",
               "SAMT",
               "Samarsk\u00fd letn\u00ed \u010das",
               "SAMST",
               "Samarsk\u00fd \u010das",
               "SAMT",
            };
        final String[] India = new String[] {
               "Indick\u00fd \u010das",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Cook = new String[] {
               "Standardn\u00ed \u010das Cookov\u00fdch ostrov\u016f",
               "CKT",
               "Letn\u00ed \u010das Cookov\u00fdch ostrov\u016f",
               "CKHST",
               "\u010cas Cookov\u00fdch ostrov\u016f",
               "CKT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London",
                new String[] {
                    "Greenwichsk\u00fd st\u0159edn\u00ed \u010das",
                    "GMT",
                    "Britsk\u00fd letn\u00ed \u010das",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Eirunepe", Acre },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", Atlantic },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Antarctica/Syowa", Syowa },
            { "Indian/Reunion", Reunion },
            { "Pacific/Palau", Palau },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Western },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Africa/Bamako", GMT },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Pacific/Bougainville", New_Zealand },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", Alaska },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Antarctica/Troll", GMT },
            { "Europe/Samara", Samara },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "Greenwichsk\u00fd st\u0159edn\u00ed \u010das",
                    "GMT",
                    "Irsk\u00fd letn\u00ed \u010das",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "Pacific/Truk", Truk },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Saipan", Chamorro },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Taipei", Taipei },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Further_Eastern },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Cancun", America_Eastern },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Rio_Branco", Acre },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Kamchatka },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Tehran", Iran },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "Asia/Srednekolymsk", Singapore },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "Australia/Lindeman", Australia_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
