/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_es extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "hora de \u00c1frica central",
               "CAT",
               "Central African Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "hora est\u00e1ndar de Mosc\u00fa",
               "MSK",
               "hora de verano de Mosc\u00fa",
               "MSD",
               "hora de Mosc\u00fa",
               "MT",
            };
        final String[] Japan = new String[] {
               "hora est\u00e1ndar de Jap\u00f3n",
               "JST",
               "hora de verano de Jap\u00f3n",
               "JDT",
               "hora de Jap\u00f3n",
               "JT",
            };
        final String[] Pakistan = new String[] {
               "hora est\u00e1ndar de Pakist\u00e1n",
               "PKT",
               "hora de verano de Pakist\u00e1n",
               "PKST",
               "hora de Pakist\u00e1n",
               "PKT",
            };
        final String[] Taipei = new String[] {
               "hora est\u00e1ndar de Taip\u00e9i",
               "CST",
               "hora de verano de Taip\u00e9i",
               "CDT",
               "hora de Taip\u00e9i",
               "CT",
            };
        final String[] Hovd = new String[] {
               "hora est\u00e1ndar de Hovd",
               "HOVT",
               "hora de verano de Hovd",
               "HOVST",
               "hora de Hovd",
               "HOVT",
            };
        final String[] Magadan = new String[] {
               "hora est\u00e1ndar de Magad\u00e1n",
               "MAGT",
               "hora de verano de Magad\u00e1n",
               "MAGST",
               "hora de Magad\u00e1n",
               "MAGT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "hora est\u00e1ndar de Australia centroccidental",
               "ACWST",
               "hora de verano de Australia centroccidental",
               "ACWDT",
               "hora de Australia centroccidental",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "hora est\u00e1ndar de Europa central",
               "CET",
               "hora de verano de Europa central",
               "CEST",
               "hora de Europa central",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "hora est\u00e1ndar de Sajal\u00edn",
               "SAKT",
               "hora de verano de Sajal\u00edn",
               "SAKST",
               "hora de Sajal\u00edn",
               "SAKT",
            };
        final String[] Paraguay = new String[] {
               "hora est\u00e1ndar de Paraguay",
               "PYT",
               "hora de verano de Paraguay",
               "PYST",
               "hora de Paraguay",
               "PYT",
            };
        final String[] Acre = new String[] {
               "Hora est\u00e1ndar de Acre",
               "ACT",
               "Hora de verano de Acre",
               "ACST",
               "Hora de Acre",
               "ACT",
            };
        final String[] Malaysia = new String[] {
               "hora de Malasia",
               "MYT",
               "Malaysia Summer Time",
               "MYST",
               "Malaysia Time",
               "MYT",
            };
        final String[] America_Eastern = new String[] {
               "hora est\u00e1ndar oriental",
               "EST",
               "hora de verano oriental",
               "EDT",
               "hora oriental",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "hora est\u00e1ndar de Lord Howe",
               "LHST",
               "hora de verano de Lord Howe",
               "LHDT",
               "hora de Lord Howe",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "hora est\u00e1ndar de Nueva Zelanda",
               "NZST",
               "hora de verano de Nueva Zelanda",
               "NZDT",
               "hora de Nueva Zelanda",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "hora del oc\u00e9ano \u00cdndico",
               "IOT",
               "Indian Ocean Territory Summer Time",
               "IOST",
               "Indian Ocean Territory Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "hora est\u00e1ndar de Yakutsk",
               "YAKT",
               "hora de verano de Yakutsk",
               "YAKST",
               "hora de Yakutsk",
               "YAKT",
            };
        final String[] Mauritius = new String[] {
               "hora est\u00e1ndar de Mauricio",
               "MUT",
               "hora de verano de Mauricio",
               "MUST",
               "hora de Mauricio",
               "MUT",
            };
        final String[] Africa_Eastern = new String[] {
               "hora de \u00c1frica oriental",
               "EAT",
               "Eastern African Summer Time",
               "EAST",
               "Eastern Africa Time",
               "EAT",
            };
        final String[] East_Timor = new String[] {
               "hora de Timor Oriental",
               "TLT",
               "Timor-Leste Summer Time",
               "TLST",
               "Timor-Leste Time",
               "TLT",
            };
        final String[] Solomon = new String[] {
               "hora de las Islas Salom\u00f3n",
               "SBT",
               "Solomon Is. Summer Time",
               "SBST",
               "Solomon Is. Time",
               "SBT",
            };
        final String[] Kosrae = new String[] {
               "hora de Kosrae",
               "KOST",
               "Kosrae Summer Time",
               "KOSST",
               "Kosrae Time",
               "KOST",
            };
        final String[] Marshall_Islands = new String[] {
               "hora de las Islas Marshall",
               "MHT",
               "Marshall Islands Summer Time",
               "MHST",
               "Marshall Islands Time",
               "MHT",
            };
        final String[] Europe_Eastern = new String[] {
               "hora est\u00e1ndar de Europa oriental",
               "EET",
               "hora de verano de Europa oriental",
               "EEST",
               "hora de Europa oriental",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "hora est\u00e1ndar de Terranova",
               "NST",
               "hora de verano de Terranova",
               "NDT",
               "hora de Terranova",
               "NT",
            };
        final String[] Afghanistan = new String[] {
               "hora de Afganist\u00e1n",
               "AFT",
               "Afghanistan Summer Time",
               "AFST",
               "Afghanistan Time",
               "AFT",
            };
        final String[] Hong_Kong = new String[] {
               "hora est\u00e1ndar de Hong Kong",
               "HKT",
               "hora de verano de Hong Kong",
               "HKST",
               "hora de Hong Kong",
               "HKT",
            };
        final String[] Argentina_Western = new String[] {
               "hora est\u00e1ndar de Argentina occidental",
               "ART",
               "hora de verano de Argentina occidental",
               "ARST",
               "hora de Argentina occidental",
               "ART",
            };
        final String[] Atlantic = new String[] {
               "hora est\u00e1ndar del Atl\u00e1ntico",
               "AST",
               "hora de verano del Atl\u00e1ntico",
               "ADT",
               "hora del Atl\u00e1ntico",
               "AT",
            };
        final String[] Ponape = new String[] {
               "hora de Pohnpei",
               "PONT",
               "Pohnpei Summer Time",
               "PONST",
               "Ponape Time",
               "PONT",
            };
        final String[] Bolivia = new String[] {
               "hora de Bolivia",
               "BOT",
               "Bolivia Summer Time",
               "BOST",
               "Bolivia Time",
               "BOT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "hora est\u00e1ndar de San Pedro y Miquel\u00f3n",
               "PMST",
               "hora de verano de San Pedro y Miquel\u00f3n",
               "PMDT",
               "hora de San Pedro y Miquel\u00f3n",
               "PMT",
            };
        final String[] Indochina = new String[] {
               "hora de Indochina",
               "ICT",
               "Indochina Summer Time",
               "ICST",
               "Indochina Time",
               "ICT",
            };
        final String[] Yekaterinburg = new String[] {
               "hora est\u00e1ndar de Ekaterimburgo",
               "YEKT",
               "hora de verano de Ekaterimburgo",
               "YEKST",
               "hora de Ekaterimburgo",
               "YEKT",
            };
        final String[] Maldives = new String[] {
               "hora de Maldivas",
               "MVT",
               "Maldives Summer Time",
               "MVST",
               "Maldives Time",
               "MVT",
            };
        final String[] Tahiti = new String[] {
               "hora de Tahit\u00ed",
               "TAHT",
               "Tahiti Summer Time",
               "TAHST",
               "Tahiti Time",
               "TAHT",
            };
        final String[] Israel = new String[] {
               "hora est\u00e1ndar de Israel",
               "IST",
               "hora de verano de Israel",
               "IDT",
               "hora de Israel",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "hora de Indonesia central",
               "WITA",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "WITA",
            };
        final String[] Wallis = new String[] {
               "hora de Wallis y Futuna",
               "WFT",
               "Wallis & Futuna Summer Time",
               "WFST",
               "Wallis & Futuna Time",
               "WFT",
            };
        final String[] Africa_Southern = new String[] {
               "hora de Sud\u00e1frica",
               "SAST",
               "South Africa Summer Time",
               "SAST",
               "South Africa Time",
               "SAT",
            };
        final String[] Syowa = new String[] {
               "hora de Syowa",
               "SYOT",
               "Syowa Summer Time",
               "SYOST",
               "Syowa Time",
               "SYOT",
            };
        final String[] Line_Islands = new String[] {
               "hora de las Esp\u00f3radas Ecuatoriales",
               "LINT",
               "Line Is. Summer Time",
               "LINST",
               "Line Is. Time",
               "LINT",
            };
        final String[] Uzbekistan = new String[] {
               "hora est\u00e1ndar de Uzbekist\u00e1n",
               "UZT",
               "hora de verano de Uzbekist\u00e1n",
               "UZST",
               "hora de Uzbekist\u00e1n",
               "UZT",
            };
        final String[] Omsk = new String[] {
               "hora est\u00e1ndar de Omsk",
               "OMST",
               "hora de verano de Omsk",
               "OMSST",
               "hora de Omsk",
               "OMST",
            };
        final String[] Seychelles = new String[] {
               "hora de Seychelles",
               "SCT",
               "Seychelles Summer Time",
               "SCST",
               "Seychelles Time",
               "SCT",
            };
        final String[] Uruguay = new String[] {
               "hora est\u00e1ndar de Uruguay",
               "UYT",
               "hora de verano de Uruguay",
               "UYST",
               "hora de Uruguay",
               "UYT",
            };
        final String[] Nepal = new String[] {
               "hora de Nepal",
               "NPT",
               "Nepal Summer Time",
               "NPST",
               "Nepal Time",
               "NPT",
            };
        final String[] Mongolia = new String[] {
               "hora est\u00e1ndar de Ul\u00e1n Bator",
               "ULAT",
               "hora de verano de Ul\u00e1n Bator",
               "ULAST",
               "hora de Ul\u00e1n Bator",
               "ULAT",
            };
        final String[] America_Central = new String[] {
               "hora est\u00e1ndar central",
               "CST",
               "hora de verano central",
               "CDT",
               "hora central",
               "CT",
            };
        final String[] Truk = new String[] {
               "hora de Chuuk",
               "CHUT",
               "Chuuk Summer Time",
               "CHUST",
               "Chuuk Time",
               "CHUT",
            };
        final String[] Niue = new String[] {
               "hora de Niue",
               "NUT",
               "Niue Summer Time",
               "NUST",
               "Niue Time",
               "NUT",
            };
        final String[] Wake = new String[] {
               "hora de la isla Wake",
               "WAKT",
               "Wake Summer Time",
               "WAKST",
               "Wake Time",
               "WAKT",
            };
        final String[] Falkland = new String[] {
               "hora est\u00e1ndar de las islas Malvinas",
               "FKT",
               "hora de verano de las islas Malvinas",
               "FKST",
               "hora de las islas Malvinas",
               "FKT",
            };
        final String[] Vanuatu = new String[] {
               "hora est\u00e1ndar de Vanuatu",
               "VUT",
               "hora de verano de Vanuatu",
               "VUST",
               "hora de Vanuatu",
               "VUT",
            };
        final String[] Novosibirsk = new String[] {
               "hora est\u00e1ndar de Novosibirsk",
               "NOVT",
               "hora de verano de Novosibirsk",
               "NOVST",
               "hora de Novosibirsk",
               "NOVT",
            };
        final String[] Singapore = new String[] {
               "hora de Singapur",
               "SRET",
               "Srednekolymsk Daylight Time",
               "SREDT",
               "Srednekolymsk Time",
               "SRET",
            };
        final String[] Azores = new String[] {
               "hora est\u00e1ndar de las Azores",
               "AZOT",
               "hora de verano de las Azores",
               "AZOST",
               "hora de las Azores",
               "AZOT",
            };
        final String[] Apia = new String[] {
               "hora est\u00e1ndar de Apia",
               "WSST",
               "horario de verano de Apia",
               "WSDT",
               "hora de Apia",
               "WST",
            };
        final String[] Bhutan = new String[] {
               "hora de But\u00e1n",
               "BTT",
               "Bhutan Summer Time",
               "BTST",
               "Bhutan Time",
               "BTT",
            };
        final String[] Suriname = new String[] {
               "hora de Surinam",
               "SRT",
               "Suriname Summer Time",
               "SRST",
               "Suriname Time",
               "SRT",
            };
        final String[] Nauru = new String[] {
               "hora de Nauru",
               "NRT",
               "Nauru Summer Time",
               "NRST",
               "Nauru Time",
               "NRT",
            };
        final String[] Krasnoyarsk = new String[] {
               "hora est\u00e1ndar de Krasnoyarsk",
               "KRAT",
               "hora de verano de Krasnoyarsk",
               "KRAST",
               "hora de Krasnoyarsk",
               "KRAT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "hora de Kazajist\u00e1n occidental",
               "AQTT",
               "Aqtau Summer Time",
               "AQTST",
               "Aqtau Time",
               "AQTT",
            };
        final String[] Myanmar = new String[] {
               "hora de Birmania",
               "MMT",
               "Myanmar Summer Time",
               "MMST",
               "Myanmar Time",
               "MMT",
            };
        final String[] Christmas = new String[] {
               "hora de la Isla de Navidad",
               "CXT",
               "Christmas Island Summer Time",
               "CXST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Amazon = new String[] {
               "hora est\u00e1ndar del Amazonas",
               "AMT",
               "hora de verano del Amazonas",
               "AMST",
               "hora del Amazonas",
               "AMT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "hora de Kazajist\u00e1n oriental",
               "ALMT",
               "Alma-Ata Summer Time",
               "ALMST",
               "Alma-Ata Time",
               "ALMT",
            };
        final String[] Fiji = new String[] {
               "hora est\u00e1ndar de Fiyi",
               "FJT",
               "hora de verano de Fiyi",
               "FJST",
               "hora de Fiyi",
               "FJT",
            };
        final String[] Reunion = new String[] {
               "hora de Reuni\u00f3n",
               "RET",
               "Reunion Summer Time",
               "REST",
               "Reunion Time",
               "RET",
            };
        final String[] Cocos = new String[] {
               "hora de las Islas Cocos",
               "CCT",
               "Cocos Islands Summer Time",
               "CCST",
               "Cocos Islands Time",
               "CCT",
            };
        final String[] Chatham = new String[] {
               "hora est\u00e1ndar de Chatham",
               "CHAST",
               "hora de verano de Chatham",
               "CHADT",
               "hora de Chatham",
               "CHAT",
            };
        final String[] Vostok = new String[] {
               "hora de Vostok",
               "VOST",
               "Vostok Summer Time",
               "VOSST",
               "Vostok Time",
               "VOST",
            };
        final String[] Argentina = new String[] {
               "hora est\u00e1ndar de Argentina",
               "ART",
               "hora de verano de Argentina",
               "ARST",
               "hora de Argentina",
               "ART",
            };
        final String[] Gambier = new String[] {
               "hora de Gambier",
               "GAMT",
               "Gambier Summer Time",
               "GAMST",
               "Gambier Time",
               "GAMT",
            };
        final String[] Kamchatka = new String[] {
               "Hora de est\u00e1ndar de Kamchatka",
               "PETT",
               "Hora de verano de Kamchatka",
               "PETST",
               "Hora de Kamchatka",
               "PETT",
            };
        final String[] Tuvalu = new String[] {
               "hora de Tuvalu",
               "TVT",
               "Tuvalu Summer Time",
               "TVST",
               "Tuvalu Time",
               "TVT",
            };
        final String[] Galapagos = new String[] {
               "hora de Gal\u00e1pagos",
               "GALT",
               "Galapagos Summer Time",
               "GALST",
               "Galapagos Time",
               "GALT",
            };
        final String[] Macquarie = new String[] {
               "hora de la isla Macquarie",
               "MIST",
               "Macquarie Island Daylight Time",
               "MIDT",
               "Macquarie Island Time",
               "MIST",
            };
        final String[] Venezuela = new String[] {
               "hora de Venezuela",
               "VET",
               "Venezuela Summer Time",
               "VEST",
               "Venezuela Time",
               "VET",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "hora est\u00e1ndar de Haw\u00e1i-Aleutiano",
               "HAST",
               "hora de verano de Haw\u00e1i-Aleutiano",
               "HADT",
               "hora de Haw\u00e1i-Aleutiano",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "hora est\u00e1ndar de Australia central",
               "ACST",
               "hora de verano de Australia central",
               "ACDT",
               "hora de Australia central",
               "ACT",
            };
        final String[] America_Pacific = new String[] {
               "hora est\u00e1ndar del Pac\u00edfico",
               "PST",
               "hora de verano del Pac\u00edfico",
               "PDT",
               "hora del Pac\u00edfico",
               "PT",
            };
        final String[] Phoenix_Islands = new String[] {
               "hora de las Islas F\u00e9nix",
               "PHOT",
               "Phoenix Is. Summer Time",
               "PHOST",
               "Phoenix Is. Time",
               "PHOT",
            };
        final String[] Turkmenistan = new String[] {
               "hora est\u00e1ndar de Turkmenist\u00e1n",
               "TMT",
               "hora de verano de Turkmenist\u00e1n",
               "TMST",
               "hora de Turkmenist\u00e1n",
               "TMT",
            };
        final String[] Europe_Western = new String[] {
               "hora est\u00e1ndar de Europa occidental",
               "WET",
               "hora de verano de Europa occidental",
               "WEST",
               "hora de Europa occidental",
               "WET",
            };
        final String[] Cape_Verde = new String[] {
               "hora est\u00e1ndar de Cabo Verde",
               "CVT",
               "hora de verano de Cabo Verde",
               "CVST",
               "hora de Cabo Verde",
               "CVT",
            };
        final String[] Norfolk = new String[] {
               "hora de la isla Norfolk",
               "NFT",
               "Norfolk Summer Time",
               "NFST",
               "Norfolk Time",
               "NFT",
            };
        final String[] Guyana = new String[] {
               "hora de Guyana",
               "GYT",
               "Guyana Summer Time",
               "GYST",
               "Guyana Time",
               "GYT",
            };
        final String[] Pitcairn = new String[] {
               "hora de Pitcairn",
               "PST",
               "Pitcairn Daylight Time",
               "PDT",
               "Pitcairn Time",
               "PT",
            };
        final String[] Rothera = new String[] {
               "hora de Rothera",
               "ROTT",
               "Rothera Summer Time",
               "ROTST",
               "Rothera Time",
               "ROTT",
            };
        final String[] Samoa = new String[] {
               "hora est\u00e1ndar de Samoa",
               "SST",
               "hora de verano de Samoa",
               "SDT",
               "hora de Samoa",
               "ST",
            };
        final String[] Palau = new String[] {
               "hora de Palaos",
               "PWT",
               "Palau Summer Time",
               "PWST",
               "Palau Time",
               "PWT",
            };
        final String[] Europe_Further_Eastern = new String[] {
               "hora de Europa oriental lejana",
               "MSK",
               "Moscow Daylight Time",
               "MSD",
               "Moscow Time",
               "MT",
            };
        final String[] Azerbaijan = new String[] {
               "hora est\u00e1ndar de Azerbaiy\u00e1n",
               "AZT",
               "hora de verano de Azerbaiy\u00e1n",
               "AZST",
               "hora de Azerbaiy\u00e1n",
               "AZT",
            };
        final String[] Mawson = new String[] {
               "hora de Mawson",
               "MAWT",
               "Mawson Summer Time",
               "MAWST",
               "Mawson Time",
               "MAWT",
            };
        final String[] Mexico_Pacific = new String[] {
               "hora est\u00e1ndar del Pac\u00edfico de M\u00e9xico",
               "MST",
               "hora de verano del Pac\u00edfico de M\u00e9xico",
               "MDT",
               "hora del Pac\u00edfico de M\u00e9xico",
               "MT",
            };
        final String[] Davis = new String[] {
               "hora de Davis",
               "DAVT",
               "Davis Summer Time",
               "DAVST",
               "Davis Time",
               "DAVT",
            };
        final String[] Cuba = new String[] {
               "hora est\u00e1ndar de Cuba",
               "CST",
               "hora de verano de Cuba",
               "CDT",
               "hora de Cuba",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "hora est\u00e1ndar de \u00c1frica occidental",
               "CAT",
               "hora de verano de \u00c1frica occidental",
               "CAST",
               "hora de \u00c1frica occidental",
               "CAT",
            };
        final String[] GMT = new String[] {
               "hora del meridiano de Greenwich",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
            };
        final String[] Philippines = new String[] {
               "hora est\u00e1ndar de Filipinas",
               "PHT",
               "hora de verano de Filipinas",
               "PHST",
               "hora de Filipinas",
               "PHT",
            };
        final String[] French_Southern = new String[] {
               "hora de las Tierras Australes y Ant\u00e1rticas Francesas",
               "TFT",
               "French Southern & Antarctic Lands Summer Time",
               "TFST",
               "French Southern & Antarctic Lands Time",
               "TFT",
            };
        final String[] South_Georgia = new String[] {
               "hora de Georgia meridional",
               "GST",
               "South Georgia Daylight Time",
               "GDT",
               "South Georgia Time",
               "GT",
            };
        final String[] New_Caledonia = new String[] {
               "hora est\u00e1ndar de Nueva Caledonia",
               "NCT",
               "hora de verano de Nueva Caledonia",
               "NCST",
               "hora de Nueva Caledonia",
               "NCT",
            };
        final String[] Brunei = new String[] {
               "hora de Brun\u00e9i",
               "BNT",
               "Brunei Summer Time",
               "BNST",
               "Brunei Time",
               "BNT",
            };
        final String[] Iran = new String[] {
               "hora est\u00e1ndar de Ir\u00e1n",
               "IRST",
               "hora de verano de Ir\u00e1n",
               "IRDT",
               "hora de Ir\u00e1n",
               "IRT",
            };
        final String[] Easter = new String[] {
               "hora est\u00e1ndar de la isla de Pascua",
               "EAST",
               "hora de verano de la isla de Pascua",
               "EASST",
               "hora de la isla de Pascua",
               "EAST",
            };
        final String[] Mexico_Northwest = new String[] {
               "hora est\u00e1ndar del noroeste de M\u00e9xico",
               "PST",
               "hora de verano del noroeste de M\u00e9xico",
               "PDT",
               "hora del noroeste de M\u00e9xico",
               "PT",
            };
        final String[] DumontDUrville = new String[] {
               "hora de Dumont-d\u2019Urville",
               "DDUT",
               "Dumont-d'Urville Summer Time",
               "DDUST",
               "Dumont-d'Urville Time",
               "DDUT",
            };
        final String[] Tajikistan = new String[] {
               "hora de Tayikist\u00e1n",
               "TJT",
               "Tajikistan Summer Time",
               "TJST",
               "Tajikistan Time",
               "TJT",
            };
        final String[] Tonga = new String[] {
               "hora est\u00e1ndar de Tonga",
               "TOT",
               "hora de verano de Tonga",
               "TOST",
               "hora de Tonga",
               "TOT",
            };
        final String[] Bangladesh = new String[] {
               "hora est\u00e1ndar de Banglad\u00e9s",
               "BDT",
               "hora de verano de Banglad\u00e9s",
               "BDST",
               "hora de Banglad\u00e9s",
               "BDT",
            };
        final String[] Peru = new String[] {
               "hora est\u00e1ndar de Per\u00fa",
               "PET",
               "hora de verano de Per\u00fa",
               "PEST",
               "hora de Per\u00fa",
               "PET",
            };
        final String[] Greenland_Western = new String[] {
               "hora est\u00e1ndar de Groenlandia occidental",
               "WGT",
               "hora de verano de Groenlandia occidental",
               "WGST",
               "hora de Groenlandia occidental",
               "WGT",
            };
        final String[] Ecuador = new String[] {
               "hora de Ecuador",
               "ECT",
               "Ecuador Summer Time",
               "ECST",
               "Ecuador Time",
               "ECT",
            };
        final String[] Greenland_Eastern = new String[] {
               "hora est\u00e1ndar de Groenlandia oriental",
               "EGT",
               "hora de verano de Groenlandia oriental",
               "EGST",
               "hora de Groenlandia oriental",
               "EGT",
            };
        final String[] Gulf = new String[] {
               "hora est\u00e1ndar del Golfo",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "hora de Indonesia oriental",
               "WIT",
               "East Indonesia Summer Time",
               "EIST",
               "East Indonesia Time",
               "WIT",
            };
        final String[] Korea = new String[] {
               "hora est\u00e1ndar de Corea",
               "KST",
               "hora de verano de Corea",
               "KDT",
               "hora de Corea",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "hora est\u00e1ndar de Australia occidental",
               "AWST",
               "hora de verano de Australia occidental",
               "AWDT",
               "hora de Australia occidental",
               "AWT",
            };
        final String[] Kyrgystan = new String[] {
               "hora de Kirguist\u00e1n",
               "KGT",
               "Kirgizstan Summer Time",
               "KGST",
               "Kirgizstan Time",
               "KGT",
            };
        final String[] Indonesia_Western = new String[] {
               "hora de Indonesia occidental",
               "WIB",
               "West Indonesia Summer Time",
               "WIST",
               "West Indonesia Time",
               "WIB",
            };
        final String[] Australia_Eastern = new String[] {
               "hora est\u00e1ndar de Australia oriental",
               "AEST",
               "hora de verano de Australia oriental",
               "AEDT",
               "hora de Australia oriental",
               "AET",
            };
        final String[] French_Guiana = new String[] {
               "hora de la Guayana Francesa",
               "GFT",
               "French Guiana Summer Time",
               "GFST",
               "French Guiana Time",
               "GFT",
            };
        final String[] Colombia = new String[] {
               "hora est\u00e1ndar de Colombia",
               "COT",
               "hora de verano de Colombia",
               "COST",
               "hora de Colombia",
               "COT",
            };
        final String[] Chile = new String[] {
               "hora est\u00e1ndar de Chile",
               "CLT",
               "hora de verano de Chile",
               "CLST",
               "hora de Chile",
               "CLT",
            };
        final String[] Gilbert_Islands = new String[] {
               "hora de las islas Gilbert",
               "GILT",
               "Gilbert Is. Summer Time",
               "GILST",
               "Gilbert Is. Time",
               "GILT",
            };
        final String[] America_Mountain = new String[] {
               "hora est\u00e1ndar de las Monta\u00f1as",
               "MST",
               "hora de verano de las Monta\u00f1as",
               "MDT",
               "hora de las Monta\u00f1as",
               "MT",
            };
        final String[] Marquesas = new String[] {
               "hora de Marquesas",
               "MART",
               "Marquesas Summer Time",
               "MARST",
               "Marquesas Time",
               "MART",
            };
        final String[] Arabian = new String[] {
               "hora est\u00e1ndar de Arabia",
               "AST",
               "hora de verano de Arabia",
               "ADT",
               "hora de Arabia",
               "AT",
            };
        final String[] Alaska = new String[] {
               "hora est\u00e1ndar de Alaska",
               "AKST",
               "hora de verano de Alaska",
               "AKDT",
               "hora de Alaska",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "hora est\u00e1ndar de Vladivostok",
               "VLAT",
               "hora de verano de Vladivostok",
               "VLAST",
               "hora de Vladivostok",
               "VLAT",
            };
        final String[] Chamorro = new String[] {
               "hora est\u00e1ndar de Chamorro",
               "ChST",
               "Chamorro Daylight Time",
               "ChDT",
               "Chamorro Time",
               "ChT",
            };
        final String[] Irkutsk = new String[] {
               "hora est\u00e1ndar de Irkutsk",
               "IRKT",
               "hora de verano de Irkutsk",
               "IRKST",
               "hora de Irkutsk",
               "IRKT",
            };
        final String[] Georgia = new String[] {
               "hora est\u00e1ndar de Georgia",
               "GET",
               "hora de verano de Georgia",
               "GEST",
               "hora de Georgia",
               "GET",
            };
        final String[] Tokelau = new String[] {
               "hora de Tokelau",
               "TKT",
               "Tokelau Summer Time",
               "TKST",
               "Tokelau Time",
               "TKT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "hora de Pap\u00faa Nueva Guinea",
               "PGT",
               "Papua New Guinea Summer Time",
               "PGST",
               "Papua New Guinea Time",
               "PGT",
            };
        final String[] Noronha = new String[] {
               "hora est\u00e1ndar de Fernando de Noronha",
               "FNT",
               "hora de verano de Fernando de Noronha",
               "FNST",
               "hora de Fernando de Noronha",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "hora est\u00e1ndar de Choibalsan",
               "CHOT",
               "hora de verano de Choibalsan",
               "CHOST",
               "hora de Choibalsan",
               "CHOT",
            };
        final String[] Brasilia = new String[] {
               "hora est\u00e1ndar de Brasilia",
               "BRT",
               "hora de verano de Brasilia",
               "BRST",
               "hora de Brasilia",
               "BRT",
            };
        final String[] China = new String[] {
               "hora est\u00e1ndar de China",
               "CST",
               "hora de verano de China",
               "CDT",
               "hora de China",
               "CT",
            };
        final String[] Armenia = new String[] {
               "hora est\u00e1ndar de Armenia",
               "AMT",
               "hora de verano de Armenia",
               "AMST",
               "hora de Armenia",
               "AMT",
            };
        final String[] Samara = new String[] {
               "Hora est\u00e1ndar de Samara",
               "SAMT",
               "Hora de verano de Samara",
               "SAMST",
               "Hora de Samara",
               "SAMT",
            };
        final String[] India = new String[] {
               "hora est\u00e1ndar de la India",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Cook = new String[] {
               "hora est\u00e1ndar de las Islas Cook",
               "CKT",
               "hora de verano media de las Islas Cook",
               "CKHST",
               "hora de las Islas Cook",
               "CKT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London",
                new String[] {
                    "hora del meridiano de Greenwich",
                    "GMT",
                    "hora de verano brit\u00e1nica",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Eirunepe", Acre },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", Atlantic },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Antarctica/Syowa", Syowa },
            { "Indian/Reunion", Reunion },
            { "Pacific/Palau", Palau },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Western },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Africa/Bamako", GMT },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Pacific/Bougainville", New_Zealand },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", Alaska },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Antarctica/Troll", GMT },
            { "Europe/Samara", Samara },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "hora del meridiano de Greenwich",
                    "GMT",
                    "hora de verano de Irlanda",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "Pacific/Truk", Truk },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Saipan", Chamorro },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Taipei", Taipei },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Further_Eastern },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Cancun", America_Eastern },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Rio_Branco", Acre },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Kamchatka },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Tehran", Iran },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "Asia/Srednekolymsk", Singapore },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "Australia/Lindeman", Australia_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
