/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_et extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "Kesk-Aafrika aeg",
               "CAT",
               "Central African Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "Moskva standardaeg",
               "MSK",
               "Moskva suveaeg",
               "MSD",
               "Moskva aeg",
               "MT",
            };
        final String[] Japan = new String[] {
               "Jaapani standardaeg",
               "JST",
               "Jaapani suveaeg",
               "JDT",
               "Jaapani aeg",
               "JT",
            };
        final String[] Pakistan = new String[] {
               "Pakistani standardaeg",
               "PKT",
               "Pakistani suveaeg",
               "PKST",
               "Pakistani aeg",
               "PKT",
            };
        final String[] Taipei = new String[] {
               "Taipei standardaeg",
               "CST",
               "Taipei suveaeg",
               "CDT",
               "Taipei aeg",
               "CT",
            };
        final String[] Hovd = new String[] {
               "Hovdi standardaeg",
               "HOVT",
               "Hovdi suveaeg",
               "HOVST",
               "Hovdi aeg",
               "HOVT",
            };
        final String[] Magadan = new String[] {
               "Magadani standardaeg",
               "MAGT",
               "Magadani suveaeg",
               "MAGST",
               "Magadani aeg",
               "MAGT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Kesk-L\u00e4\u00e4ne Austraalia standardaeg",
               "ACWST",
               "Kesk-L\u00e4\u00e4ne Austraalia suveaeg",
               "ACWDT",
               "Kesk-L\u00e4\u00e4ne Austraalia aeg",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "Kesk-Euroopa standardaeg",
               "CET",
               "Kesk-Euroopa suveaeg",
               "CEST",
               "Kesk-Euroopa aeg",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "Sahhalini standardaeg",
               "SAKT",
               "Sahhalini suveaeg",
               "SAKST",
               "Sahhalini aeg",
               "SAKT",
            };
        final String[] Paraguay = new String[] {
               "Paraguay standardaeg",
               "PYT",
               "Paraguay suveaeg",
               "PYST",
               "Paraguay aeg",
               "PYT",
            };
        final String[] Acre = new String[] {
               "Acre standardaeg",
               "ACT",
               "Acre suveaeg",
               "ACST",
               "Acre aeg",
               "ACT",
            };
        final String[] Malaysia = new String[] {
               "Malaisia \u200b\u200baeg",
               "MYT",
               "Malaysia Summer Time",
               "MYST",
               "Malaysia Time",
               "MYT",
            };
        final String[] America_Eastern = new String[] {
               "Idaranniku standardaeg",
               "EST",
               "Idaranniku suveaeg",
               "EDT",
               "Idaranniku aeg",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "Lord Howe standardaeg",
               "LHST",
               "Lord Howe suveaeg",
               "LHDT",
               "Lord Howe aeg",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "Uus-Meremaa standardaeg",
               "NZST",
               "Uus-Meremaa suveaeg",
               "NZDT",
               "Uus-Meremaa aeg",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "India ookeani aeg",
               "IOT",
               "Indian Ocean Territory Summer Time",
               "IOST",
               "Indian Ocean Territory Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "Jakutski standardaeg",
               "YAKT",
               "Jakutski suveaeg",
               "YAKST",
               "Jakutski aeg",
               "YAKT",
            };
        final String[] Mauritius = new String[] {
               "Mauritiuse standardaeg",
               "MUT",
               "Mauritiuse suveaeg",
               "MUST",
               "Mauritiuse aeg",
               "MUT",
            };
        final String[] Africa_Eastern = new String[] {
               "Ida-Aafrika aeg",
               "EAT",
               "Eastern African Summer Time",
               "EAST",
               "Eastern Africa Time",
               "EAT",
            };
        final String[] East_Timor = new String[] {
               "Ida-Timori aeg",
               "TLT",
               "Timor-Leste Summer Time",
               "TLST",
               "Timor-Leste Time",
               "TLT",
            };
        final String[] Solomon = new String[] {
               "Saalomoni Saarte aeg",
               "SBT",
               "Solomon Is. Summer Time",
               "SBST",
               "Solomon Is. Time",
               "SBT",
            };
        final String[] Kosrae = new String[] {
               "Kosrae aeg",
               "KOST",
               "Kosrae Summer Time",
               "KOSST",
               "Kosrae Time",
               "KOST",
            };
        final String[] Marshall_Islands = new String[] {
               "Marshalli Saarte aeg",
               "MHT",
               "Marshall Islands Summer Time",
               "MHST",
               "Marshall Islands Time",
               "MHT",
            };
        final String[] Europe_Eastern = new String[] {
               "Ida-Euroopa standardaeg",
               "EET",
               "Ida-Euroopa suveaeg",
               "EEST",
               "Ida-Euroopa aeg",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "Newfoundlandi standardaeg",
               "NST",
               "Newfoundlandi suveaeg",
               "NDT",
               "Newfoundlandi aeg",
               "NT",
            };
        final String[] Afghanistan = new String[] {
               "Afganistani aeg",
               "AFT",
               "Afghanistan Summer Time",
               "AFST",
               "Afghanistan Time",
               "AFT",
            };
        final String[] Hong_Kong = new String[] {
               "Hongkongi standardaeg",
               "HKT",
               "Hongkongi suveaeg",
               "HKST",
               "Hongkongi aeg",
               "HKT",
            };
        final String[] Argentina_Western = new String[] {
               "L\u00e4\u00e4ne-Argentina standardaeg",
               "ART",
               "L\u00e4\u00e4ne-Argentina suveaeg",
               "ARST",
               "L\u00e4\u00e4ne-Argentina aeg",
               "ART",
            };
        final String[] Atlantic = new String[] {
               "Atlandi standardaeg",
               "AST",
               "Atlandi suveaeg",
               "ADT",
               "Atlandi aeg",
               "AT",
            };
        final String[] Ponape = new String[] {
               "Pohnpei aeg",
               "PONT",
               "Pohnpei Summer Time",
               "PONST",
               "Ponape Time",
               "PONT",
            };
        final String[] Bolivia = new String[] {
               "Boliivia aeg",
               "BOT",
               "Bolivia Summer Time",
               "BOST",
               "Bolivia Time",
               "BOT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Saint-Pierre\u2019i ja Miqueloni standardaeg",
               "PMST",
               "Saint-Pierre\u2019i ja Miqueloni suveaeg",
               "PMDT",
               "Saint-Pierre\u2019i ja Miqueloni aeg",
               "PMT",
            };
        final String[] Indochina = new String[] {
               "Indohiina aeg",
               "ICT",
               "Indochina Summer Time",
               "ICST",
               "Indochina Time",
               "ICT",
            };
        final String[] Yekaterinburg = new String[] {
               "Jekaterinburgi standardaeg",
               "YEKT",
               "Jakaterinburgi suveaeg",
               "YEKST",
               "Jakaterinburgi aeg",
               "YEKT",
            };
        final String[] Maldives = new String[] {
               "Maldiivi aeg",
               "MVT",
               "Maldives Summer Time",
               "MVST",
               "Maldives Time",
               "MVT",
            };
        final String[] Tahiti = new String[] {
               "Tahiti aeg",
               "TAHT",
               "Tahiti Summer Time",
               "TAHST",
               "Tahiti Time",
               "TAHT",
            };
        final String[] Israel = new String[] {
               "Iisraeli standardaeg",
               "IST",
               "Iisraeli suveaeg",
               "IDT",
               "Iisraeli aeg",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "Kesk-Indoneesia aeg",
               "WITA",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "WITA",
            };
        final String[] Wallis = new String[] {
               "Wallise ja Futuna aeg",
               "WFT",
               "Wallis & Futuna Summer Time",
               "WFST",
               "Wallis & Futuna Time",
               "WFT",
            };
        final String[] Africa_Southern = new String[] {
               "L\u00f5una-Aafrika standardaeg",
               "SAST",
               "South Africa Summer Time",
               "SAST",
               "South Africa Time",
               "SAT",
            };
        final String[] Syowa = new String[] {
               "Syowa aeg",
               "SYOT",
               "Syowa Summer Time",
               "SYOST",
               "Syowa Time",
               "SYOT",
            };
        final String[] Line_Islands = new String[] {
               "Line\u2019i saarte aeg",
               "LINT",
               "Line Is. Summer Time",
               "LINST",
               "Line Is. Time",
               "LINT",
            };
        final String[] Uzbekistan = new String[] {
               "Usbekistani standardaeg",
               "UZT",
               "Usbekistani suveaeg",
               "UZST",
               "Usbekistani aeg",
               "UZT",
            };
        final String[] Omsk = new String[] {
               "Omski standardaeg",
               "OMST",
               "Omski suveaeg",
               "OMSST",
               "Omski aeg",
               "OMST",
            };
        final String[] Seychelles = new String[] {
               "Sei\u0161elli aeg",
               "SCT",
               "Seychelles Summer Time",
               "SCST",
               "Seychelles Time",
               "SCT",
            };
        final String[] Uruguay = new String[] {
               "Uruguay standardaeg",
               "UYT",
               "Uruguay suveaeg",
               "UYST",
               "Uruguay aeg",
               "UYT",
            };
        final String[] Nepal = new String[] {
               "Nepali aeg",
               "NPT",
               "Nepal Summer Time",
               "NPST",
               "Nepal Time",
               "NPT",
            };
        final String[] Mongolia = new String[] {
               "Ulaanbaatari standardaeg",
               "ULAT",
               "Ulaanbaatari suveaeg",
               "ULAST",
               "Ulaanbaatari aeg",
               "ULAT",
            };
        final String[] America_Central = new String[] {
               "Kesk-Ameerika standardaeg",
               "CST",
               "Kesk-Ameerika suveaeg",
               "CDT",
               "Kesk-Ameerika aeg",
               "CT",
            };
        final String[] Truk = new String[] {
               "Chuuki aeg",
               "CHUT",
               "Chuuk Summer Time",
               "CHUST",
               "Chuuk Time",
               "CHUT",
            };
        final String[] Niue = new String[] {
               "Niue aeg",
               "NUT",
               "Niue Summer Time",
               "NUST",
               "Niue Time",
               "NUT",
            };
        final String[] Wake = new String[] {
               "Wake\u2019i aeg",
               "WAKT",
               "Wake Summer Time",
               "WAKST",
               "Wake Time",
               "WAKT",
            };
        final String[] Falkland = new String[] {
               "Falklandi saarte standardaeg",
               "FKT",
               "Falklandi saarte suveaeg",
               "FKST",
               "Falklandi saarte aeg",
               "FKT",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatu standardaeg",
               "VUT",
               "Vanuatu suveaeg",
               "VUST",
               "Vanuatu aeg",
               "VUT",
            };
        final String[] Novosibirsk = new String[] {
               "Novosibirski standardaeg",
               "NOVT",
               "Novosibirski suveaeg",
               "NOVST",
               "Novosibirski aeg",
               "NOVT",
            };
        final String[] Singapore = new String[] {
               "Singapuri standardaeg",
               "SRET",
               "Srednekolymsk Daylight Time",
               "SREDT",
               "Srednekolymsk Time",
               "SRET",
            };
        final String[] Azores = new String[] {
               "Assooride standardaeg",
               "AZOT",
               "Assooride suveaeg",
               "AZOST",
               "Assooride aeg",
               "AZOT",
            };
        final String[] Apia = new String[] {
               "Apia standardaeg",
               "WSST",
               "Apia suveaeg",
               "WSDT",
               "Apia aeg",
               "WST",
            };
        final String[] Bhutan = new String[] {
               "Bhutani aeg",
               "BTT",
               "Bhutan Summer Time",
               "BTST",
               "Bhutan Time",
               "BTT",
            };
        final String[] Suriname = new String[] {
               "Suriname aeg",
               "SRT",
               "Suriname Summer Time",
               "SRST",
               "Suriname Time",
               "SRT",
            };
        final String[] Nauru = new String[] {
               "Nauru aeg",
               "NRT",
               "Nauru Summer Time",
               "NRST",
               "Nauru Time",
               "NRT",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnojarski standardaeg",
               "KRAT",
               "Krasnojarski suveaeg",
               "KRAST",
               "Krasnojarski aeg",
               "KRAT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "L\u00e4\u00e4ne-Kasahstani aeg",
               "AQTT",
               "Aqtau Summer Time",
               "AQTST",
               "Aqtau Time",
               "AQTT",
            };
        final String[] Myanmar = new String[] {
               "Birma aeg",
               "MMT",
               "Myanmar Summer Time",
               "MMST",
               "Myanmar Time",
               "MMT",
            };
        final String[] Christmas = new String[] {
               "J\u00f5ulusaare aeg",
               "CXT",
               "Christmas Island Summer Time",
               "CXST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Amazon = new String[] {
               "Amazonase standardaeg",
               "AMT",
               "Amazonase suveaeg",
               "AMST",
               "Amazonase aeg",
               "AMT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Ida-Kasahstani aeg",
               "ALMT",
               "Alma-Ata Summer Time",
               "ALMST",
               "Alma-Ata Time",
               "ALMT",
            };
        final String[] Fiji = new String[] {
               "Fid\u017ei standardaeg",
               "FJT",
               "Fid\u017ei suveaeg",
               "FJST",
               "Fid\u017ei aeg",
               "FJT",
            };
        final String[] Reunion = new String[] {
               "R\u00e9unioni aeg",
               "RET",
               "Reunion Summer Time",
               "REST",
               "Reunion Time",
               "RET",
            };
        final String[] Cocos = new String[] {
               "Kookossaarte aeg",
               "CCT",
               "Cocos Islands Summer Time",
               "CCST",
               "Cocos Islands Time",
               "CCT",
            };
        final String[] Chatham = new String[] {
               "Chathami standardaeg",
               "CHAST",
               "Chathami suveaeg",
               "CHADT",
               "Chathami aeg",
               "CHAT",
            };
        final String[] Vostok = new String[] {
               "Vostoki aeg",
               "VOST",
               "Vostok Summer Time",
               "VOSST",
               "Vostok Time",
               "VOST",
            };
        final String[] Argentina = new String[] {
               "Argentina standardaeg",
               "ART",
               "Argentina suveaeg",
               "ARST",
               "Argentina aeg",
               "ART",
            };
        final String[] Gambier = new String[] {
               "Gambier\u2019 aeg",
               "GAMT",
               "Gambier Summer Time",
               "GAMST",
               "Gambier Time",
               "GAMT",
            };
        final String[] Kamchatka = new String[] {
               "Kamt\u0161atka standardaeg",
               "PETT",
               "Kamt\u0161atka suveaeg",
               "PETST",
               "Petropavlovsk-Kamt\u0161atski aeg",
               "PETT",
            };
        final String[] Tuvalu = new String[] {
               "Tuvalu aeg",
               "TVT",
               "Tuvalu Summer Time",
               "TVST",
               "Tuvalu Time",
               "TVT",
            };
        final String[] Galapagos = new String[] {
               "Galapagose aeg",
               "GALT",
               "Galapagos Summer Time",
               "GALST",
               "Galapagos Time",
               "GALT",
            };
        final String[] Macquarie = new String[] {
               "Macquarie saare aeg",
               "MIST",
               "Macquarie Island Daylight Time",
               "MIDT",
               "Macquarie Island Time",
               "MIST",
            };
        final String[] Venezuela = new String[] {
               "Venezuela aeg",
               "VET",
               "Venezuela Summer Time",
               "VEST",
               "Venezuela Time",
               "VET",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hawaii-Aleuudi standardaeg",
               "HAST",
               "Hawaii-Aleuudi suveaeg",
               "HADT",
               "Hawaii-aleuudi aeg",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "Kesk-Austraalia standardaeg",
               "ACST",
               "Kesk-Austraalia suveaeg",
               "ACDT",
               "Kesk-Austraalia aeg",
               "ACT",
            };
        final String[] America_Pacific = new String[] {
               "Vaikse ookeani standardaeg",
               "PST",
               "Vaikse ookeani suveaeg",
               "PDT",
               "Vaikse ookeani aeg",
               "PT",
            };
        final String[] Phoenix_Islands = new String[] {
               "F\u00f6\u00f6niksisaarte aeg",
               "PHOT",
               "Phoenix Is. Summer Time",
               "PHOST",
               "Phoenix Is. Time",
               "PHOT",
            };
        final String[] Turkmenistan = new String[] {
               "T\u00fcrkmenistani standardaeg",
               "TMT",
               "T\u00fcrkmenistani suveaeg",
               "TMST",
               "T\u00fcrkmenistani aeg",
               "TMT",
            };
        final String[] Europe_Western = new String[] {
               "L\u00e4\u00e4ne-Euroopa standardaeg",
               "WET",
               "L\u00e4\u00e4ne-Euroopa suveaeg",
               "WEST",
               "L\u00e4\u00e4ne-Euroopa aeg",
               "WET",
            };
        final String[] Cape_Verde = new String[] {
               "Roheneemesaarte standardaeg",
               "CVT",
               "Roheneemesaarte suveaeg",
               "CVST",
               "Roheneemesaarte aeg",
               "CVT",
            };
        final String[] Norfolk = new String[] {
               "Norfolki saarte aeg",
               "NFT",
               "Norfolk Summer Time",
               "NFST",
               "Norfolk Time",
               "NFT",
            };
        final String[] Guyana = new String[] {
               "Guyana aeg",
               "GYT",
               "Guyana Summer Time",
               "GYST",
               "Guyana Time",
               "GYT",
            };
        final String[] Pitcairn = new String[] {
               "Pitcairni aeg",
               "PST",
               "Pitcairn Daylight Time",
               "PDT",
               "Pitcairn Time",
               "PT",
            };
        final String[] Rothera = new String[] {
               "Rothera aeg",
               "ROTT",
               "Rothera Summer Time",
               "ROTST",
               "Rothera Time",
               "ROTT",
            };
        final String[] Samoa = new String[] {
               "Samoa standardaeg",
               "SST",
               "Samoa suveaeg",
               "SDT",
               "Samoa aeg",
               "ST",
            };
        final String[] Palau = new String[] {
               "Belau aeg",
               "PWT",
               "Palau Summer Time",
               "PWST",
               "Palau Time",
               "PWT",
            };
        final String[] Europe_Further_Eastern = new String[] {
               "Kaliningradi ja Valgevene aeg",
               "MSK",
               "Moscow Daylight Time",
               "MSD",
               "Moscow Time",
               "MT",
            };
        final String[] Azerbaijan = new String[] {
               "Aserbaid\u017eaani standardaeg",
               "AZT",
               "Aserbaid\u017eaani suveaeg",
               "AZST",
               "Aserbaid\u017eaani aeg",
               "AZT",
            };
        final String[] Mawson = new String[] {
               "Mawsoni aeg",
               "MAWT",
               "Mawson Summer Time",
               "MAWST",
               "Mawson Time",
               "MAWT",
            };
        final String[] Mexico_Pacific = new String[] {
               "Mehhiko Vaikse ookeani standardaeg",
               "MST",
               "Mehhiko Vaikse ookeani suveaeg",
               "MDT",
               "Mehhiko Vaikse ookeani aeg",
               "MT",
            };
        final String[] Davis = new String[] {
               "Davise aeg",
               "DAVT",
               "Davis Summer Time",
               "DAVST",
               "Davis Time",
               "DAVT",
            };
        final String[] Cuba = new String[] {
               "Kuuba standardaeg",
               "CST",
               "Kuuba suveaeg",
               "CDT",
               "Kuuba aeg",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "L\u00e4\u00e4ne-Aafrika standardaeg",
               "CAT",
               "L\u00e4\u00e4ne-Aafrika suveaeg",
               "CAST",
               "L\u00e4\u00e4ne-Aafrika aeg",
               "CAT",
            };
        final String[] GMT = new String[] {
               "Greenwichi aeg",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
            };
        final String[] Philippines = new String[] {
               "Filipiini standardaeg",
               "PHT",
               "Filipiini suveaeg",
               "PHST",
               "Filipiini aeg",
               "PHT",
            };
        final String[] French_Southern = new String[] {
               "Prantsuse Antarktiliste ja L\u00f5unaalade aeg",
               "TFT",
               "French Southern & Antarctic Lands Summer Time",
               "TFST",
               "French Southern & Antarctic Lands Time",
               "TFT",
            };
        final String[] South_Georgia = new String[] {
               "L\u00f5una-Georgia aeg",
               "GST",
               "South Georgia Daylight Time",
               "GDT",
               "South Georgia Time",
               "GT",
            };
        final String[] New_Caledonia = new String[] {
               "Uus-Kaledoonia standardaeg",
               "NCT",
               "Uus-Kaledoonia suveaeg",
               "NCST",
               "Uus-Kaledoonia aeg",
               "NCT",
            };
        final String[] Brunei = new String[] {
               "Brunei aeg",
               "BNT",
               "Brunei Summer Time",
               "BNST",
               "Brunei Time",
               "BNT",
            };
        final String[] Iran = new String[] {
               "Iraani standardaeg",
               "IRST",
               "Iraani suveaeg",
               "IRDT",
               "Iraani aeg",
               "IRT",
            };
        final String[] Easter = new String[] {
               "Lihav\u00f5ttesaare standardaeg",
               "EAST",
               "Lihav\u00f5ttesaare suveaeg",
               "EASST",
               "Lihav\u00f5ttesaare aeg",
               "EAST",
            };
        final String[] Mexico_Northwest = new String[] {
               "Loode-Mehhiko standardaeg",
               "PST",
               "Loode-Mehhiko suveaeg",
               "PDT",
               "Loode-Mehhiko aeg",
               "PT",
            };
        final String[] DumontDUrville = new String[] {
               "Dumont-d\u2019Urville\u2019i aeg",
               "DDUT",
               "Dumont-d'Urville Summer Time",
               "DDUST",
               "Dumont-d'Urville Time",
               "DDUT",
            };
        final String[] Tajikistan = new String[] {
               "Tad\u017eikistani aeg",
               "TJT",
               "Tajikistan Summer Time",
               "TJST",
               "Tajikistan Time",
               "TJT",
            };
        final String[] Tonga = new String[] {
               "Tonga standardaeg",
               "TOT",
               "Tonga suveaeg",
               "TOST",
               "Tonga aeg",
               "TOT",
            };
        final String[] Bangladesh = new String[] {
               "Bangladeshi standardaeg",
               "BDT",
               "Bangladeshi suveaeg",
               "BDST",
               "Bangladeshi aeg",
               "BDT",
            };
        final String[] Peru = new String[] {
               "Peruu standardaeg",
               "PET",
               "Peruu suveaeg",
               "PEST",
               "Peruu aeg",
               "PET",
            };
        final String[] Greenland_Western = new String[] {
               "L\u00e4\u00e4ne-Gr\u00f6\u00f6nimaa standardaeg",
               "WGT",
               "L\u00e4\u00e4ne-Gr\u00f6\u00f6nimaa suveaeg",
               "WGST",
               "L\u00e4\u00e4ne-Gr\u00f6\u00f6nimaa aeg",
               "WGT",
            };
        final String[] Ecuador = new String[] {
               "Ecuadori aeg",
               "ECT",
               "Ecuador Summer Time",
               "ECST",
               "Ecuador Time",
               "ECT",
            };
        final String[] Greenland_Eastern = new String[] {
               "Ida-Gr\u00f6\u00f6nimaa standardaeg",
               "EGT",
               "Ida-Gr\u00f6\u00f6nimaa suveaeg",
               "EGST",
               "Ida-Gr\u00f6\u00f6nimaa aeg",
               "EGT",
            };
        final String[] Gulf = new String[] {
               "P\u00e4rsia lahe standardaeg",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Ida-Indoneesia aeg",
               "WIT",
               "East Indonesia Summer Time",
               "EIST",
               "East Indonesia Time",
               "WIT",
            };
        final String[] Korea = new String[] {
               "Korea standardaeg",
               "KST",
               "Korea suveaeg",
               "KDT",
               "Korea aeg",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "L\u00e4\u00e4ne-Austraalia standardaeg",
               "AWST",
               "L\u00e4\u00e4ne-Austraalia suveaeg",
               "AWDT",
               "L\u00e4\u00e4ne-Austraalia aeg",
               "AWT",
            };
        final String[] Kyrgystan = new String[] {
               "K\u00f5rg\u00f5zstani aeg",
               "KGT",
               "Kirgizstan Summer Time",
               "KGST",
               "Kirgizstan Time",
               "KGT",
            };
        final String[] Indonesia_Western = new String[] {
               "L\u00e4\u00e4ne-Indoneesia aeg",
               "WIB",
               "West Indonesia Summer Time",
               "WIST",
               "West Indonesia Time",
               "WIB",
            };
        final String[] Australia_Eastern = new String[] {
               "Ida-Austraalia standardaeg",
               "AEST",
               "Ida-Austraalia suveaeg",
               "AEDT",
               "Ida-Austraalia aeg",
               "AET",
            };
        final String[] French_Guiana = new String[] {
               "Prantsuse Guajaana aeg",
               "GFT",
               "French Guiana Summer Time",
               "GFST",
               "French Guiana Time",
               "GFT",
            };
        final String[] Colombia = new String[] {
               "Colombia standardaeg",
               "COT",
               "Colombia suveaeg",
               "COST",
               "Colombia aeg",
               "COT",
            };
        final String[] Chile = new String[] {
               "T\u0161iili standardaeg",
               "CLT",
               "T\u0161iili suveaeg",
               "CLST",
               "T\u0161iili aeg",
               "CLT",
            };
        final String[] Gilbert_Islands = new String[] {
               "Gilberti saarte aeg",
               "GILT",
               "Gilbert Is. Summer Time",
               "GILST",
               "Gilbert Is. Time",
               "GILT",
            };
        final String[] America_Mountain = new String[] {
               "M\u00e4estikuv\u00f6\u00f6ndi standardaeg",
               "MST",
               "M\u00e4estikuv\u00f6\u00f6ndi suveaeg",
               "MDT",
               "M\u00e4estikuv\u00f6\u00f6ndi aeg",
               "MT",
            };
        final String[] Marquesas = new String[] {
               "Markiisaarte aeg",
               "MART",
               "Marquesas Summer Time",
               "MARST",
               "Marquesas Time",
               "MART",
            };
        final String[] Arabian = new String[] {
               "Araabia standardaeg",
               "AST",
               "Araabia suveaeg",
               "ADT",
               "Araabia aeg",
               "AT",
            };
        final String[] Alaska = new String[] {
               "Alaska standardaeg",
               "AKST",
               "Alaska suveaeg",
               "AKDT",
               "Alaska aeg",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "Vladivostoki standardaeg",
               "VLAT",
               "Vladivostoki suveaeg",
               "VLAST",
               "Vladivostoki aeg",
               "VLAT",
            };
        final String[] Chamorro = new String[] {
               "T\u0161amorro standardaeg",
               "ChST",
               "Chamorro Daylight Time",
               "ChDT",
               "Chamorro Time",
               "ChT",
            };
        final String[] Irkutsk = new String[] {
               "Irkutski standardaeg",
               "IRKT",
               "Irkutski suveaeg",
               "IRKST",
               "Irkutski aeg",
               "IRKT",
            };
        final String[] Georgia = new String[] {
               "Gruusia standardaeg",
               "GET",
               "Gruusia suveaeg",
               "GEST",
               "Gruusia aeg",
               "GET",
            };
        final String[] Tokelau = new String[] {
               "Tokelau aeg",
               "TKT",
               "Tokelau Summer Time",
               "TKST",
               "Tokelau Time",
               "TKT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Paapua Uus-Guinea aeg",
               "PGT",
               "Papua New Guinea Summer Time",
               "PGST",
               "Papua New Guinea Time",
               "PGT",
            };
        final String[] Noronha = new String[] {
               "Fernando de Noronha standardaeg",
               "FNT",
               "Fernando de Noronha suveaeg",
               "FNST",
               "Fernando de Noronha aeg",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "T\u0161ojbalsani standardaeg",
               "CHOT",
               "T\u0161ojbalsani suveaeg",
               "CHOST",
               "T\u0161ojbalsani aeg",
               "CHOT",
            };
        final String[] Brasilia = new String[] {
               "Brasiilia standardaeg",
               "BRT",
               "Brasiilia suveaeg",
               "BRST",
               "Brasiilia aeg",
               "BRT",
            };
        final String[] China = new String[] {
               "Hiina standardaeg",
               "CST",
               "Hiina suveaeg",
               "CDT",
               "Hiina aeg",
               "CT",
            };
        final String[] Armenia = new String[] {
               "Armeenia standardaeg",
               "AMT",
               "Armeenia suveaeg",
               "AMST",
               "Armeenia aeg",
               "AMT",
            };
        final String[] Samara = new String[] {
               "Samara standardaeg",
               "SAMT",
               "Samara suveaeg",
               "SAMST",
               "Samara aeg",
               "SAMT",
            };
        final String[] India = new String[] {
               "India aeg",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Cook = new String[] {
               "Cooki saarte standardaeg",
               "CKT",
               "Cooki saarte osaline suveaeg",
               "CKHST",
               "Cooki saarte aeg",
               "CKT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London",
                new String[] {
                    "Greenwichi aeg",
                    "GMT",
                    "Briti suveaeg",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Eirunepe", Acre },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", Atlantic },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Antarctica/Syowa", Syowa },
            { "Indian/Reunion", Reunion },
            { "Pacific/Palau", Palau },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Western },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Africa/Bamako", GMT },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Pacific/Bougainville", New_Zealand },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", Alaska },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Antarctica/Troll", GMT },
            { "Europe/Samara", Samara },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "Greenwichi aeg",
                    "GMT",
                    "Iiri suveaeg",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "Pacific/Truk", Truk },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Saipan", Chamorro },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Taipei", Taipei },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Further_Eastern },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Cancun", America_Eastern },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Rio_Branco", Acre },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Kamchatka },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Tehran", Iran },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "Asia/Srednekolymsk", Singapore },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "Australia/Lindeman", Australia_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
