/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_fil extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "Oras sa Gitnang Africa",
               "CAT",
               "Central African Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "Standard na Oras sa Moscow",
               "MSK",
               "Oras sa Tag-init ng Moscow",
               "MSD",
               "Oras sa Moscow",
               "MT",
            };
        final String[] Japan = new String[] {
               "Standard na Oras sa Japan",
               "JST",
               "Daylight Time sa Japan",
               "JDT",
               "Oras sa Japan",
               "JT",
            };
        final String[] Pakistan = new String[] {
               "Standard na Oras sa Pakistan",
               "PKT",
               "Oras sa Tag-init ng Pakistan",
               "PKST",
               "Oras sa Pakistan",
               "PKT",
            };
        final String[] Taipei = new String[] {
               "Standard na Oras sa Taipei",
               "CST",
               "Daylight Time sa Taipei",
               "CDT",
               "Oras sa Taipei",
               "CT",
            };
        final String[] Hovd = new String[] {
               "Standard na Oras sa Hovd",
               "HOVT",
               "Oras sa Tag-init ng Hovd",
               "HOVST",
               "Oras sa Hovd",
               "HOVT",
            };
        final String[] Magadan = new String[] {
               "Standard na Oras sa Magadan",
               "MAGT",
               "Oras sa Tag-init ng Magadan",
               "MAGST",
               "Oras sa Magadan",
               "MAGT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Standard Time ng Gitnang Kanluran ng Australya",
               "ACWST",
               "Daylight Time ng Gitnang Kanluran ng Australya",
               "ACWDT",
               "Oras ng Gitnang Kanluran ng Australya",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "Standard na Oras sa Gitnang Europe",
               "CET",
               "Oras sa Tag-init ng Gitnang Europe",
               "CEST",
               "Oras sa Gitnang Europe",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "Standard na Oras sa Sakhalin",
               "SAKT",
               "Oras sa Tag-init ng Sakhalin",
               "SAKST",
               "Oras sa Sakhalin",
               "SAKT",
            };
        final String[] Paraguay = new String[] {
               "Standard na Oras sa Paraguay",
               "PYT",
               "Oras sa Tag-init ng Paraguay",
               "PYST",
               "Oras sa Paraguay",
               "PYT",
            };
        final String[] Malaysia = new String[] {
               "Oras ng Malaysia",
               "MYT",
               "Malaysia Summer Time",
               "MYST",
               "Malaysia Time",
               "MYT",
            };
        final String[] America_Eastern = new String[] {
               "Eastern na Standard na Oras",
               "EST",
               "Eastern Daylight Time",
               "EDT",
               "Eastern Time",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "Standard na Oras sa Lord Howe",
               "LHST",
               "Daylight Time sa Lorde Howe",
               "LHDT",
               "Oras sa Lord Howe",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "Standard na Oras sa New Zealand",
               "NZST",
               "Daylight Time sa New Zealand",
               "NZDT",
               "Oras sa New Zealand",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "Oras sa Indian Ocean",
               "IOT",
               "Indian Ocean Territory Summer Time",
               "IOST",
               "Indian Ocean Territory Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "Standard na Oras sa Yakutsk",
               "YAKT",
               "Oras sa Tag-init ng Yakutsk",
               "YAKST",
               "Oras sa Yakutsk",
               "YAKT",
            };
        final String[] Mauritius = new String[] {
               "Standard na Oras sa Mauritius",
               "MUT",
               "Oras sa Tag-init ng Mauritius",
               "MUST",
               "Oras sa Mauritius",
               "MUT",
            };
        final String[] Africa_Eastern = new String[] {
               "Oras sa Silangang Africa",
               "EAT",
               "Eastern African Summer Time",
               "EAST",
               "Eastern Africa Time",
               "EAT",
            };
        final String[] East_Timor = new String[] {
               "Oras ng East Timor",
               "TLT",
               "Timor-Leste Summer Time",
               "TLST",
               "Timor-Leste Time",
               "TLT",
            };
        final String[] Solomon = new String[] {
               "Oras sa Solomon Islands",
               "SBT",
               "Solomon Is. Summer Time",
               "SBST",
               "Solomon Is. Time",
               "SBT",
            };
        final String[] Kosrae = new String[] {
               "Oras sa Kosrae",
               "KOST",
               "Kosrae Summer Time",
               "KOSST",
               "Kosrae Time",
               "KOST",
            };
        final String[] Marshall_Islands = new String[] {
               "Oras sa Marshall Islands",
               "MHT",
               "Marshall Islands Summer Time",
               "MHST",
               "Marshall Islands Time",
               "MHT",
            };
        final String[] Europe_Eastern = new String[] {
               "Standard na Oras sa Silangang Europe",
               "EET",
               "Oras sa Tag-init ng Silangang Europe",
               "EEST",
               "Oras sa Silangang Europe",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "Standard na Oras sa Newfoundland",
               "NST",
               "Daylight Time sa Newfoundland",
               "NDT",
               "Oras sa Newfoundland",
               "NT",
            };
        final String[] Afghanistan = new String[] {
               "Oras sa Afghanistan",
               "AFT",
               "Afghanistan Summer Time",
               "AFST",
               "Afghanistan Time",
               "AFT",
            };
        final String[] Hong_Kong = new String[] {
               "Standard na Oras sa Hong Kong",
               "HKT",
               "Oras sa Tag-init ng Hong Kong",
               "HKST",
               "Oras sa Hong Kong",
               "HKT",
            };
        final String[] Argentina_Western = new String[] {
               "Standard na Oras sa Kanlurang Argentina",
               "ART",
               "Oras sa Tag-init ng Kanlurang Argentina",
               "ARST",
               "Oras sa Kanlurang Argentina",
               "ART",
            };
        final String[] Atlantic = new String[] {
               "Standard na Oras sa Atlantiko",
               "AST",
               "Daylight Time sa Atlantiko",
               "ADT",
               "Oras sa Atlantiko",
               "AT",
            };
        final String[] Ponape = new String[] {
               "Oras sa Ponape",
               "PONT",
               "Pohnpei Summer Time",
               "PONST",
               "Ponape Time",
               "PONT",
            };
        final String[] Bolivia = new String[] {
               "Oras sa Bolivia",
               "BOT",
               "Bolivia Summer Time",
               "BOST",
               "Bolivia Time",
               "BOT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Standard na Oras sa Saint Pierre and Miquelon",
               "PMST",
               "Daylight Time sa Saint Pierre and Miquelon",
               "PMDT",
               "Oras sa Saint Pierre and Miquelon",
               "PMT",
            };
        final String[] Indochina = new String[] {
               "Oras ng Indochina",
               "ICT",
               "Indochina Summer Time",
               "ICST",
               "Indochina Time",
               "ICT",
            };
        final String[] Yekaterinburg = new String[] {
               "Standard na Oras sa Yekaterinburg",
               "YEKT",
               "Oras sa Tag-init ng Yekaterinburg",
               "YEKST",
               "Oras sa Yekaterinburg",
               "YEKT",
            };
        final String[] Maldives = new String[] {
               "Oras sa Maldives",
               "MVT",
               "Maldives Summer Time",
               "MVST",
               "Maldives Time",
               "MVT",
            };
        final String[] Tahiti = new String[] {
               "Oras sa Tahiti",
               "TAHT",
               "Tahiti Summer Time",
               "TAHST",
               "Tahiti Time",
               "TAHT",
            };
        final String[] Israel = new String[] {
               "Standard na Oras sa Israel",
               "IST",
               "Daylight Time sa Israel",
               "IDT",
               "Oras sa Israel",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "Oras ng Gitnang Indonesiya",
               "WITA",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "WITA",
            };
        final String[] Wallis = new String[] {
               "Oras sa Wallis and Futuna",
               "WFT",
               "Wallis & Futuna Summer Time",
               "WFST",
               "Wallis & Futuna Time",
               "WFT",
            };
        final String[] Africa_Southern = new String[] {
               "Oras sa Timog Africa",
               "SAST",
               "South Africa Summer Time",
               "SAST",
               "South Africa Time",
               "SAT",
            };
        final String[] Syowa = new String[] {
               "Oras sa Syowa",
               "SYOT",
               "Syowa Summer Time",
               "SYOST",
               "Syowa Time",
               "SYOT",
            };
        final String[] Line_Islands = new String[] {
               "Oras sa Line Islands",
               "LINT",
               "Line Is. Summer Time",
               "LINST",
               "Line Is. Time",
               "LINT",
            };
        final String[] Uzbekistan = new String[] {
               "Standard na Oras sa Uzbekistan",
               "UZT",
               "Oras sa Tag-init ng Uzbekistan",
               "UZST",
               "Oras sa Uzbekistan",
               "UZT",
            };
        final String[] Omsk = new String[] {
               "Standard na Oras sa Omsk",
               "OMST",
               "Oras sa Tag-init ng Omsk",
               "OMSST",
               "Oras sa Omsk",
               "OMST",
            };
        final String[] Seychelles = new String[] {
               "Oras sa Seychelles",
               "SCT",
               "Seychelles Summer Time",
               "SCST",
               "Seychelles Time",
               "SCT",
            };
        final String[] Uruguay = new String[] {
               "Standard na Oras sa Uruguay",
               "UYT",
               "Oras sa Tag-init ng Uruguay",
               "UYST",
               "Oras sa Uruguay",
               "UYT",
            };
        final String[] Nepal = new String[] {
               "Oras sa Nepal",
               "NPT",
               "Nepal Summer Time",
               "NPST",
               "Nepal Time",
               "NPT",
            };
        final String[] Mongolia = new String[] {
               "Standard na Oras sa Ulan Bator",
               "ULAT",
               "Oras sa Tag-init ng Ulan Bator",
               "ULAST",
               "Oras sa Ulan Bator",
               "ULAT",
            };
        final String[] America_Central = new String[] {
               "Sentral na Standard na Oras",
               "CST",
               "Sentral na Daylight Time",
               "CDT",
               "Sentral na Oras",
               "CT",
            };
        final String[] Truk = new String[] {
               "Oras sa Chuuk",
               "CHUT",
               "Chuuk Summer Time",
               "CHUST",
               "Chuuk Time",
               "CHUT",
            };
        final String[] Niue = new String[] {
               "Oras sa Niue",
               "NUT",
               "Niue Summer Time",
               "NUST",
               "Niue Time",
               "NUT",
            };
        final String[] Wake = new String[] {
               "Oras sa Wake Island",
               "WAKT",
               "Wake Summer Time",
               "WAKST",
               "Wake Time",
               "WAKT",
            };
        final String[] Falkland = new String[] {
               "Standard na Oras sa Falkland Islands",
               "FKT",
               "Oras sa Tag-init ng Falkland Islands",
               "FKST",
               "Oras sa Falkland Islands",
               "FKT",
            };
        final String[] Vanuatu = new String[] {
               "Standard na Oras sa Vanuatu",
               "VUT",
               "Oras sa Tag-init ng Vanuatu",
               "VUST",
               "Oras sa Vanuatu",
               "VUT",
            };
        final String[] Novosibirsk = new String[] {
               "Standard na Oras sa Novosibirsk",
               "NOVT",
               "Oras sa Tag-init ng Novosibirsk",
               "NOVST",
               "Oras sa Novosibirsk",
               "NOVT",
            };
        final String[] Singapore = new String[] {
               "Standard na Oras sa Singapore",
               "SRET",
               "Srednekolymsk Daylight Time",
               "SREDT",
               "Srednekolymsk Time",
               "SRET",
            };
        final String[] Azores = new String[] {
               "Standard na Oras sa Azores",
               "AZOT",
               "Oras sa Tag-init ng Azores",
               "AZOST",
               "Oras sa Azores",
               "AZOT",
            };
        final String[] Apia = new String[] {
               "Apia Standard Time",
               "WSST",
               "Apia Daylight Time",
               "WSDT",
               "Oras sa Apia",
               "WST",
            };
        final String[] Bhutan = new String[] {
               "Oras sa Bhutan",
               "BTT",
               "Bhutan Summer Time",
               "BTST",
               "Bhutan Time",
               "BTT",
            };
        final String[] Suriname = new String[] {
               "Oras sa Suriname",
               "SRT",
               "Suriname Summer Time",
               "SRST",
               "Suriname Time",
               "SRT",
            };
        final String[] Nauru = new String[] {
               "Oras sa Nauru",
               "NRT",
               "Nauru Summer Time",
               "NRST",
               "Nauru Time",
               "NRT",
            };
        final String[] Krasnoyarsk = new String[] {
               "Standard na Oras sa Krasnoyarsk",
               "KRAT",
               "Oras sa Tag-init ng Krasnoyarsk",
               "KRAST",
               "Oras sa Krasnoyarsk",
               "KRAT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Oras sa Kanlurang Kazakhstan",
               "AQTT",
               "Aqtau Summer Time",
               "AQTST",
               "Aqtau Time",
               "AQTT",
            };
        final String[] Myanmar = new String[] {
               "Oras ng Myanmar",
               "MMT",
               "Myanmar Summer Time",
               "MMST",
               "Myanmar Time",
               "MMT",
            };
        final String[] Christmas = new String[] {
               "Oras sa Christmas Island",
               "CXT",
               "Christmas Island Summer Time",
               "CXST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Amazon = new String[] {
               "Standard na Oras sa Amazon",
               "AMT",
               "Oras sa Tag-init ng Amazon",
               "AMST",
               "Oras sa Amazon",
               "AMT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Oras sa Silangang Kazakhstan",
               "ALMT",
               "Alma-Ata Summer Time",
               "ALMST",
               "Alma-Ata Time",
               "ALMT",
            };
        final String[] Fiji = new String[] {
               "Standard na Oras sa Fiji",
               "FJT",
               "Oras sa Tag-init ng Fiji",
               "FJST",
               "Oras sa Fiji",
               "FJT",
            };
        final String[] Reunion = new String[] {
               "Oras sa Reunion",
               "RET",
               "Reunion Summer Time",
               "REST",
               "Reunion Time",
               "RET",
            };
        final String[] Cocos = new String[] {
               "Oras sa Cocos Islands",
               "CCT",
               "Cocos Islands Summer Time",
               "CCST",
               "Cocos Islands Time",
               "CCT",
            };
        final String[] Chatham = new String[] {
               "Standard na Oras sa Chatham",
               "CHAST",
               "Daylight Time sa Chatham",
               "CHADT",
               "Oras sa Chatham",
               "CHAT",
            };
        final String[] Vostok = new String[] {
               "Oras sa Vostok",
               "VOST",
               "Vostok Summer Time",
               "VOSST",
               "Vostok Time",
               "VOST",
            };
        final String[] Argentina = new String[] {
               "Standard na Oras sa Argentina",
               "ART",
               "Oras sa Tag-init ng Argentina",
               "ARST",
               "Oras sa Argentina",
               "ART",
            };
        final String[] Gambier = new String[] {
               "Oras sa Gambier",
               "GAMT",
               "Gambier Summer Time",
               "GAMST",
               "Gambier Time",
               "GAMT",
            };
        final String[] Kamchatka = new String[] {
               "Standard Time sa Petropavlovsk-Kamchatski",
               "PETT",
               "Summer Time sa Petropavlovsk-Kamchatski",
               "PETST",
               "Oras sa Petropavlovsk-Kamchatski",
               "PETT",
            };
        final String[] Tuvalu = new String[] {
               "Oras sa Tuvalu",
               "TVT",
               "Tuvalu Summer Time",
               "TVST",
               "Tuvalu Time",
               "TVT",
            };
        final String[] Galapagos = new String[] {
               "Oras sa Galapagos",
               "GALT",
               "Galapagos Summer Time",
               "GALST",
               "Galapagos Time",
               "GALT",
            };
        final String[] Macquarie = new String[] {
               "Oras sa Macquarie Island",
               "MIST",
               "Macquarie Island Daylight Time",
               "MIDT",
               "Macquarie Island Time",
               "MIST",
            };
        final String[] Venezuela = new String[] {
               "Oras sa Venezuela",
               "VET",
               "Venezuela Summer Time",
               "VEST",
               "Venezuela Time",
               "VET",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Standard na Oras sa Hawaii-Aleutian",
               "HAST",
               "Oras sa Tag-init ng Hawaii-Aleutian",
               "HADT",
               "Oras sa Hawaii-Aleutian",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "Standard Time ng Gitnang Australya",
               "ACST",
               "Daylight Time ng Gitnang Australya",
               "ACDT",
               "Oras ng Gitnang Australya",
               "ACT",
            };
        final String[] America_Pacific = new String[] {
               "Standard na Oras sa Pasipiko",
               "PST",
               "Daylight Time sa Pasipiko",
               "PDT",
               "Oras sa Pasipiko",
               "PT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Oras sa Phoenix Islands",
               "PHOT",
               "Phoenix Is. Summer Time",
               "PHOST",
               "Phoenix Is. Time",
               "PHOT",
            };
        final String[] Turkmenistan = new String[] {
               "Standard na Oras sa Turkmenistan",
               "TMT",
               "Oras sa Tag-init ng Turkmenistan",
               "TMST",
               "Oras sa Turkmenistan",
               "TMT",
            };
        final String[] Europe_Western = new String[] {
               "Standard na Oras sa Kanlurang Europe",
               "WET",
               "Oras sa Tag-init ng Kanlurang Europe",
               "WEST",
               "Oras sa Kanlurang Europe",
               "WET",
            };
        final String[] Cape_Verde = new String[] {
               "Standard na Oras sa Cape Verde",
               "CVT",
               "Oras sa Tag-init ng Cape Verde",
               "CVST",
               "Oras sa Cape Verde",
               "CVT",
            };
        final String[] Norfolk = new String[] {
               "Oras sa Norfolk Island",
               "NFT",
               "Norfolk Summer Time",
               "NFST",
               "Norfolk Time",
               "NFT",
            };
        final String[] Guyana = new String[] {
               "Oras sa Guyana",
               "GYT",
               "Guyana Summer Time",
               "GYST",
               "Guyana Time",
               "GYT",
            };
        final String[] Pitcairn = new String[] {
               "Oras sa Pitcairn",
               "PST",
               "Pitcairn Daylight Time",
               "PDT",
               "Pitcairn Time",
               "PT",
            };
        final String[] Rothera = new String[] {
               "Oras sa Rothera",
               "ROTT",
               "Rothera Summer Time",
               "ROTST",
               "Rothera Time",
               "ROTT",
            };
        final String[] Samoa = new String[] {
               "Standard na Oras sa Samoa",
               "SST",
               "Daylight Time sa Samoa",
               "SDT",
               "Oras sa Samoa",
               "ST",
            };
        final String[] Palau = new String[] {
               "Oras sa Palau",
               "PWT",
               "Palau Summer Time",
               "PWST",
               "Palau Time",
               "PWT",
            };
        final String[] Europe_Further_Eastern = new String[] {
               "Oras sa Pinaka-silangang Europe",
               "MSK",
               "Moscow Daylight Time",
               "MSD",
               "Moscow Time",
               "MT",
            };
        final String[] Azerbaijan = new String[] {
               "Standard na Oras sa Azerbaijan",
               "AZT",
               "Oras sa Tag-init ng Azerbaijan",
               "AZST",
               "Oras sa Azerbaijan",
               "AZT",
            };
        final String[] Mawson = new String[] {
               "Oras sa Mawson",
               "MAWT",
               "Mawson Summer Time",
               "MAWST",
               "Mawson Time",
               "MAWT",
            };
        final String[] Mexico_Pacific = new String[] {
               "Standard na Oras sa Pasipiko ng Mexico",
               "MST",
               "Daylight Time sa Pasipiko ng Mexico",
               "MDT",
               "Oras sa Pasipiko ng Mexico",
               "MT",
            };
        final String[] Davis = new String[] {
               "Oras sa Davis",
               "DAVT",
               "Davis Summer Time",
               "DAVST",
               "Davis Time",
               "DAVT",
            };
        final String[] Cuba = new String[] {
               "Standard na Oras sa Cuba",
               "CST",
               "Daylight Time sa Cuba",
               "CDT",
               "Oras sa Cuba",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "Standard na Oras sa Kanlurang Africa",
               "CAT",
               "Oras sa Tag-init ng Kanlurang Africa",
               "CAST",
               "Oras sa Kanlurang Africa",
               "CAT",
            };
        final String[] GMT = new String[] {
               "Greenwich Mean Time",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
            };
        final String[] Philippines = new String[] {
               "Standard na Oras sa Pilipinas",
               "PHT",
               "Oras sa Tag-init ng Pilipinas",
               "PHST",
               "Oras sa Pilipinas",
               "PHT",
            };
        final String[] French_Southern = new String[] {
               "Oras sa Katimugang France at Antartiko",
               "TFT",
               "French Southern & Antarctic Lands Summer Time",
               "TFST",
               "French Southern & Antarctic Lands Time",
               "TFT",
            };
        final String[] South_Georgia = new String[] {
               "Oras sa Timog Georgia",
               "GST",
               "South Georgia Daylight Time",
               "GDT",
               "South Georgia Time",
               "GT",
            };
        final String[] New_Caledonia = new String[] {
               "Standard na Oras sa New Caledonia",
               "NCT",
               "Oras sa Tag-init ng New Caledonia",
               "NCST",
               "Oras sa New Caledonia",
               "NCT",
            };
        final String[] Brunei = new String[] {
               "Oras ng Brunei Darussalam",
               "BNT",
               "Brunei Summer Time",
               "BNST",
               "Brunei Time",
               "BNT",
            };
        final String[] Iran = new String[] {
               "Standard na Oras sa Iran",
               "IRST",
               "Daylight Time sa Iran",
               "IRDT",
               "Oras sa Iran",
               "IRT",
            };
        final String[] Easter = new String[] {
               "Standard na Oras sa Easter Island",
               "EAST",
               "Oras sa Tag-init ng Easter Island",
               "EASST",
               "Oras sa Easter Island",
               "EAST",
            };
        final String[] Mexico_Northwest = new String[] {
               "Standard na Oras sa Hilagang-kanlurang Mexico",
               "PST",
               "Daylight Time sa Hilagang-kanlurang Mexico",
               "PDT",
               "Oras sa Hilagang-kanlurang Mexico",
               "PT",
            };
        final String[] DumontDUrville = new String[] {
               "Oras sa Dumont-d\u2019Urville",
               "DDUT",
               "Dumont-d'Urville Summer Time",
               "DDUST",
               "Dumont-d'Urville Time",
               "DDUT",
            };
        final String[] Tajikistan = new String[] {
               "Oras sa Tajikistan",
               "TJT",
               "Tajikistan Summer Time",
               "TJST",
               "Tajikistan Time",
               "TJT",
            };
        final String[] Tonga = new String[] {
               "Standard na Oras sa Tonga",
               "TOT",
               "Oras sa Tag-init ng Tonga",
               "TOST",
               "Oras sa Tonga",
               "TOT",
            };
        final String[] Bangladesh = new String[] {
               "Standard na Oras sa Bangladesh",
               "BDT",
               "Oras sa Tag-init ng Bangladesh",
               "BDST",
               "Oras sa Bangladesh",
               "BDT",
            };
        final String[] Peru = new String[] {
               "Standard na Oras sa Peru",
               "PET",
               "Oras sa Tag-init ng Peru",
               "PEST",
               "Oras sa Peru",
               "PET",
            };
        final String[] Greenland_Western = new String[] {
               "Standard na Oras sa Kanlurang Greenland",
               "WGT",
               "Oras sa Tag-init ng Kanlurang Greenland",
               "WGST",
               "Oras sa Kanlurang Greenland",
               "WGT",
            };
        final String[] Ecuador = new String[] {
               "Oras sa Ecuador",
               "ECT",
               "Ecuador Summer Time",
               "ECST",
               "Ecuador Time",
               "ECT",
            };
        final String[] Greenland_Eastern = new String[] {
               "Standard na Oras sa Silangang Greenland",
               "EGT",
               "Oras sa Tag-init ng Silangang Greenland",
               "EGST",
               "Oras sa Silangang Greenland",
               "EGT",
            };
        final String[] Gulf = new String[] {
               "Oras sa Gulf",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Oras ng Silangang Indonesiya",
               "WIT",
               "East Indonesia Summer Time",
               "EIST",
               "East Indonesia Time",
               "WIT",
            };
        final String[] Korea = new String[] {
               "Standard na Oras sa Korea",
               "KST",
               "Daylight Time sa Korea",
               "KDT",
               "Oras sa Korea",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "Standard Time ng Kanlurang Australya",
               "AWST",
               "Daylight Time sa Kanlurang Australya",
               "AWDT",
               "Oras ng Kanlurang Australya",
               "AWT",
            };
        final String[] Kyrgystan = new String[] {
               "Oras sa Kyrgystan",
               "KGT",
               "Kirgizstan Summer Time",
               "KGST",
               "Kirgizstan Time",
               "KGT",
            };
        final String[] Indonesia_Western = new String[] {
               "Oras ng Kanlurang Indonesiya",
               "WIB",
               "West Indonesia Summer Time",
               "WIST",
               "West Indonesia Time",
               "WIB",
            };
        final String[] Australia_Eastern = new String[] {
               "Standard Time ng Silangang Australya",
               "AEST",
               "Daylight Time ng Silangang Australya",
               "AEDT",
               "Oras ng Silangang Australya",
               "AET",
            };
        final String[] French_Guiana = new String[] {
               "Oras sa French Guiana",
               "GFT",
               "French Guiana Summer Time",
               "GFST",
               "French Guiana Time",
               "GFT",
            };
        final String[] Colombia = new String[] {
               "Standard na Oras sa Colombia",
               "COT",
               "Oras sa Tag-init ng Colombia",
               "COST",
               "Oras sa Colombia",
               "COT",
            };
        final String[] Chile = new String[] {
               "Standard na Oras sa Chile",
               "CLT",
               "Oras sa Tag-init ng Chile",
               "CLST",
               "Oras sa Chile",
               "CLT",
            };
        final String[] Gilbert_Islands = new String[] {
               "Oras sa Gilbert Islands",
               "GILT",
               "Gilbert Is. Summer Time",
               "GILST",
               "Gilbert Is. Time",
               "GILT",
            };
        final String[] America_Mountain = new String[] {
               "Standard na Oras sa Bundok",
               "MST",
               "Daylight Time sa Bundok",
               "MDT",
               "Oras sa Bundok",
               "MT",
            };
        final String[] Marquesas = new String[] {
               "Oras sa Marquesas",
               "MART",
               "Marquesas Summer Time",
               "MARST",
               "Marquesas Time",
               "MART",
            };
        final String[] Arabian = new String[] {
               "Standard na Oras sa Arabia",
               "AST",
               "Daylight Time sa Arabia",
               "ADT",
               "Oras sa Arabia",
               "AT",
            };
        final String[] Alaska = new String[] {
               "Standard na Oras sa Alaska",
               "AKST",
               "Daylight Time sa Alaska",
               "AKDT",
               "Oras sa Alaska",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "Standard na Oras sa Vladivostok",
               "VLAT",
               "Oras sa Tag-init ng Vladivostok",
               "VLAST",
               "Oras sa Vladivostok",
               "VLAT",
            };
        final String[] Chamorro = new String[] {
               "Standard na Oras sa Chamorro",
               "ChST",
               "Chamorro Daylight Time",
               "ChDT",
               "Chamorro Time",
               "ChT",
            };
        final String[] Irkutsk = new String[] {
               "Standard na Oras sa Irkutsk",
               "IRKT",
               "Oras sa Tag-init ng Irkutsk",
               "IRKST",
               "Oras sa Irkutsk",
               "IRKT",
            };
        final String[] Georgia = new String[] {
               "Standard na Oras sa Georgia",
               "GET",
               "Oras sa Tag-init ng Georgia",
               "GEST",
               "Oras sa Georgia",
               "GET",
            };
        final String[] Tokelau = new String[] {
               "Oras sa Tokelau",
               "TKT",
               "Tokelau Summer Time",
               "TKST",
               "Tokelau Time",
               "TKT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Oras sa Papua New Guinea",
               "PGT",
               "Papua New Guinea Summer Time",
               "PGST",
               "Papua New Guinea Time",
               "PGT",
            };
        final String[] Noronha = new String[] {
               "Standard na Oras sa Fernando de Noronha",
               "FNT",
               "Oras sa Tag-init ng Fernando de Noronha",
               "FNST",
               "Oras sa Fernando de Noronha",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "Standard na Oras sa Choibalsan",
               "CHOT",
               "Oras sa Tag-init ng Choibalsan",
               "CHOST",
               "Oras sa Choibalsan",
               "CHOT",
            };
        final String[] Brasilia = new String[] {
               "Standard na Oras sa Brasilia",
               "BRT",
               "Oras sa Tag-init ng Brasilia",
               "BRST",
               "Oras sa Brasilia",
               "BRT",
            };
        final String[] China = new String[] {
               "Standard na Oras sa China",
               "CST",
               "Daylight Time sa China",
               "CDT",
               "Oras sa China",
               "CT",
            };
        final String[] Armenia = new String[] {
               "Standard na Oras sa Armenia",
               "AMT",
               "Oras sa Tag-init ng Armenia",
               "AMST",
               "Oras sa Armenia",
               "AMT",
            };
        final String[] Samara = new String[] {
               "Standard Time sa Samara",
               "SAMT",
               "Samara Daylight",
               "SAMST",
               "Oras sa Samara",
               "SAMT",
            };
        final String[] India = new String[] {
               "Standard na Oras sa Bhutan",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Cook = new String[] {
               "Standard na Oras sa Cook Islands",
               "CKT",
               "Oras sa Kalahati ng Tag-init ng Cook Islands",
               "CKHST",
               "Oras sa Cook Islands",
               "CKT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "Oras sa Tag-init ng Britain",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", Atlantic },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Antarctica/Syowa", Syowa },
            { "Indian/Reunion", Reunion },
            { "Pacific/Palau", Palau },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Western },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Africa/Bamako", GMT },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Pacific/Bougainville", New_Zealand },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", Alaska },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Antarctica/Troll", GMT },
            { "Europe/Samara", Samara },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "Standard na Oras sa Ireland",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "Pacific/Truk", Truk },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Saipan", Chamorro },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Taipei", Taipei },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Further_Eastern },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Cancun", America_Eastern },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Kamchatka },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Tehran", Iran },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "Asia/Srednekolymsk", Singapore },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "Australia/Lindeman", Australia_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
