/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_fr extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "heure normale d\u2019Afrique centrale",
               "CAT",
               "Central African Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "heure normale de Moscou",
               "MSK",
               "heure d\u2019\u00e9t\u00e9 de Moscou",
               "MSD",
               "heure de Moscou",
               "MT",
            };
        final String[] Japan = new String[] {
               "heure normale du Japon",
               "JST",
               "heure d\u2019\u00e9t\u00e9 du Japon",
               "JDT",
               "heure du Japon",
               "JT",
            };
        final String[] Pakistan = new String[] {
               "heure normale du Pakistan",
               "PKT",
               "heure d\u2019\u00e9t\u00e9 du Pakistan",
               "PKST",
               "heure du Pakistan",
               "PKT",
            };
        final String[] Taipei = new String[] {
               "heure normale de Taipei",
               "CST",
               "heure d\u2019\u00e9t\u00e9 de Taipei",
               "CDT",
               "heure de Taipei",
               "CT",
            };
        final String[] Hovd = new String[] {
               "heure normale de Hovd",
               "HOVT",
               "heure d\u2019\u00e9t\u00e9 de Hovd",
               "HOVST",
               "heure de Hovd",
               "HOVT",
            };
        final String[] Magadan = new String[] {
               "heure normale de Magadan",
               "MAGT",
               "heure d\u2019\u00e9t\u00e9 de Magadan",
               "MAGST",
               "heure de Magadan",
               "MAGT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "heure normale du centre-ouest de l\u2019Australie",
               "ACWST",
               "heure d\u2019\u00e9t\u00e9 du centre-ouest de l\u2019Australie",
               "ACWDT",
               "heure du centre-ouest de l\u2019Australie",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "heure normale d\u2019Europe centrale",
               "CET",
               "heure d\u2019\u00e9t\u00e9 d\u2019Europe centrale",
               "CEST",
               "heure d\u2019Europe centrale",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "heure normale de Sakhaline",
               "SAKT",
               "heure d\u2019\u00e9t\u00e9 de Sakhaline",
               "SAKST",
               "heure de Sakhaline",
               "SAKT",
            };
        final String[] Paraguay = new String[] {
               "heure normale du Paraguay",
               "PYT",
               "heure d\u2019\u00e9t\u00e9 du Paraguay",
               "PYST",
               "heure du Paraguay",
               "PYT",
            };
        final String[] Acre = new String[] {
               "heure normale de l\u2019Acre",
               "ACT",
               "heure d\u2019\u00e9t\u00e9 de l\u2019Acre",
               "ACST",
               "heure de l\u2019Acre",
               "ACT",
            };
        final String[] Malaysia = new String[] {
               "heure de la Malaisie",
               "MYT",
               "Malaysia Summer Time",
               "MYST",
               "Malaysia Time",
               "MYT",
            };
        final String[] America_Eastern = new String[] {
               "heure normale de l\u2019Est nord-am\u00e9ricain",
               "EST",
               "heure d\u2019\u00e9t\u00e9 de l\u2019Est",
               "EDT",
               "heure de l\u2019Est nord-am\u00e9ricain",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "heure normale de Lord Howe",
               "LHST",
               "heure d\u2019\u00e9t\u00e9 de Lord Howe",
               "LHDT",
               "heure de Lord Howe",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "heure normale de la Nouvelle-Z\u00e9lande",
               "NZST",
               "heure d\u2019\u00e9t\u00e9 de la Nouvelle-Z\u00e9lande",
               "NZDT",
               "heure de la Nouvelle-Z\u00e9lande",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "heure de l\u2019Oc\u00e9an Indien",
               "IOT",
               "Indian Ocean Territory Summer Time",
               "IOST",
               "Indian Ocean Territory Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "heure normale de Iakoutsk",
               "YAKT",
               "heure d\u2019\u00e9t\u00e9 de Iakoutsk",
               "YAKST",
               "heure de Iakoutsk",
               "YAKT",
            };
        final String[] Mauritius = new String[] {
               "heure normale de Maurice",
               "MUT",
               "heure d\u2019\u00e9t\u00e9 de Maurice",
               "MUST",
               "heure de Maurice",
               "MUT",
            };
        final String[] Africa_Eastern = new String[] {
               "heure normale d\u2019Afrique de l\u2019Est",
               "EAT",
               "Eastern African Summer Time",
               "EAST",
               "Eastern Africa Time",
               "EAT",
            };
        final String[] East_Timor = new String[] {
               "heure du Timor oriental",
               "TLT",
               "Timor-Leste Summer Time",
               "TLST",
               "Timor-Leste Time",
               "TLT",
            };
        final String[] Solomon = new String[] {
               "heure des \u00eeles Salomon",
               "SBT",
               "Solomon Is. Summer Time",
               "SBST",
               "Solomon Is. Time",
               "SBT",
            };
        final String[] Kosrae = new String[] {
               "heure de Kosrae",
               "KOST",
               "Kosrae Summer Time",
               "KOSST",
               "Kosrae Time",
               "KOST",
            };
        final String[] Marshall_Islands = new String[] {
               "heure des \u00eeles Marshall",
               "MHT",
               "Marshall Islands Summer Time",
               "MHST",
               "Marshall Islands Time",
               "MHT",
            };
        final String[] Europe_Eastern = new String[] {
               "heure normale d\u2019Europe de l\u2019Est",
               "EET",
               "heure d\u2019\u00e9t\u00e9 d\u2019Europe de l\u2019Est",
               "EEST",
               "heure d\u2019Europe de l\u2019Est",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "heure normale de Terre-Neuve",
               "NST",
               "heure d\u2019\u00e9t\u00e9 de Terre-Neuve",
               "NDT",
               "heure de Terre-Neuve",
               "NT",
            };
        final String[] Afghanistan = new String[] {
               "heure de l\u2019Afghanistan",
               "AFT",
               "Afghanistan Summer Time",
               "AFST",
               "Afghanistan Time",
               "AFT",
            };
        final String[] Hong_Kong = new String[] {
               "heure normale de Hong Kong",
               "HKT",
               "heure d\u2019\u00e9t\u00e9 de Hong Kong",
               "HKST",
               "heure de Hong Kong",
               "HKT",
            };
        final String[] Argentina_Western = new String[] {
               "heure normale de l\u2019Ouest argentin",
               "ART",
               "heure d\u2019\u00e9t\u00e9 de l\u2019Ouest argentin",
               "ARST",
               "heure de l\u2019Ouest argentin",
               "ART",
            };
        final String[] Atlantic = new String[] {
               "heure normale de l\u2019Atlantique",
               "AST",
               "heure d\u2019\u00e9t\u00e9 de l\u2019Atlantique",
               "ADT",
               "heure de l\u2019Atlantique",
               "AT",
            };
        final String[] Ponape = new String[] {
               "heure de l\u2019\u00eele de Pohnpei",
               "PONT",
               "Pohnpei Summer Time",
               "PONST",
               "Ponape Time",
               "PONT",
            };
        final String[] Bolivia = new String[] {
               "heure de Bolivie",
               "BOT",
               "Bolivia Summer Time",
               "BOST",
               "Bolivia Time",
               "BOT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "heure normale de Saint-Pierre-et-Miquelon",
               "PMST",
               "heure d\u2019\u00e9t\u00e9 de Saint-Pierre-et-Miquelon",
               "PMDT",
               "heure de Saint-Pierre-et-Miquelon",
               "PMT",
            };
        final String[] Indochina = new String[] {
               "heure d\u2019Indochine",
               "ICT",
               "Indochina Summer Time",
               "ICST",
               "Indochina Time",
               "ICT",
            };
        final String[] Yekaterinburg = new String[] {
               "heure normale d\u2019Ekaterinbourg",
               "YEKT",
               "heure d\u2019\u00e9t\u00e9 d\u2019Ekaterinbourg",
               "YEKST",
               "heure d\u2019Ekaterinbourg",
               "YEKT",
            };
        final String[] Maldives = new String[] {
               "heure des Maldives",
               "MVT",
               "Maldives Summer Time",
               "MVST",
               "Maldives Time",
               "MVT",
            };
        final String[] Tahiti = new String[] {
               "heure de Tahiti",
               "TAHT",
               "Tahiti Summer Time",
               "TAHST",
               "Tahiti Time",
               "TAHT",
            };
        final String[] Israel = new String[] {
               "heure normale d\u2019Isra\u00ebl",
               "IST",
               "heure d\u2019\u00e9t\u00e9 d\u2019Isra\u00ebl",
               "IDT",
               "heure d\u2019Isra\u00ebl",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "heure du Centre indon\u00e9sien",
               "WITA",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "WITA",
            };
        final String[] Wallis = new String[] {
               "heure de Wallis-et-Futuna",
               "WFT",
               "Wallis & Futuna Summer Time",
               "WFST",
               "Wallis & Futuna Time",
               "WFT",
            };
        final String[] Africa_Southern = new String[] {
               "heure normale d\u2019Afrique m\u00e9ridionale",
               "SAST",
               "South Africa Summer Time",
               "SAST",
               "South Africa Time",
               "SAT",
            };
        final String[] Syowa = new String[] {
               "heure de Syowa",
               "SYOT",
               "Syowa Summer Time",
               "SYOST",
               "Syowa Time",
               "SYOT",
            };
        final String[] Line_Islands = new String[] {
               "heure des \u00eeles de la Ligne",
               "LINT",
               "Line Is. Summer Time",
               "LINST",
               "Line Is. Time",
               "LINT",
            };
        final String[] Uzbekistan = new String[] {
               "heure normale de l\u2019Ouzb\u00e9kistan",
               "UZT",
               "heure d\u2019\u00e9t\u00e9 de l\u2019Ouzb\u00e9kistan",
               "UZST",
               "heure de l\u2019Ouzb\u00e9kistan",
               "UZT",
            };
        final String[] Omsk = new String[] {
               "heure normale de Omsk",
               "OMST",
               "heure d\u2019\u00e9t\u00e9 de Omsk",
               "OMSST",
               "heure de Omsk",
               "OMST",
            };
        final String[] Seychelles = new String[] {
               "heure des Seychelles",
               "SCT",
               "Seychelles Summer Time",
               "SCST",
               "Seychelles Time",
               "SCT",
            };
        final String[] Uruguay = new String[] {
               "heure normale de l\u2019Uruguay",
               "UYT",
               "heure d\u2019\u00e9t\u00e9 de l\u2019Uruguay",
               "UYST",
               "heure de l\u2019Uruguay",
               "UYT",
            };
        final String[] Nepal = new String[] {
               "heure du N\u00e9pal",
               "NPT",
               "Nepal Summer Time",
               "NPST",
               "Nepal Time",
               "NPT",
            };
        final String[] Mongolia = new String[] {
               "heure normale d\u2019Oulan-Bator",
               "ULAT",
               "heure d\u2019\u00e9t\u00e9 d\u2019Oulan-Bator",
               "ULAST",
               "heure d\u2019Oulan-Bator",
               "ULAT",
            };
        final String[] America_Central = new String[] {
               "heure normale du centre nord-am\u00e9ricain",
               "CST",
               "heure d\u2019\u00e9t\u00e9 du Centre",
               "CDT",
               "heure du centre nord-am\u00e9ricain",
               "CT",
            };
        final String[] Truk = new String[] {
               "heure de Chuuk",
               "CHUT",
               "Chuuk Summer Time",
               "CHUST",
               "Chuuk Time",
               "CHUT",
            };
        final String[] Niue = new String[] {
               "heure de Niou\u00e9",
               "NUT",
               "Niue Summer Time",
               "NUST",
               "Niue Time",
               "NUT",
            };
        final String[] Wake = new String[] {
               "heure de l\u2019\u00eele Wake",
               "WAKT",
               "Wake Summer Time",
               "WAKST",
               "Wake Time",
               "WAKT",
            };
        final String[] Falkland = new String[] {
               "heure normale des \u00eeles Malouines",
               "FKT",
               "heure d\u2019\u00e9t\u00e9 des \u00eeles Malouines",
               "FKST",
               "heure des \u00eeles Malouines",
               "FKT",
            };
        final String[] Vanuatu = new String[] {
               "heure normale du Vanuatu",
               "VUT",
               "heure d\u2019\u00e9t\u00e9 de Vanuatu",
               "VUST",
               "heure du Vanuatu",
               "VUT",
            };
        final String[] Novosibirsk = new String[] {
               "heure normale de Novossibirsk",
               "NOVT",
               "heure d\u2019\u00e9t\u00e9 de Novossibirsk",
               "NOVST",
               "heure de Novossibirsk",
               "NOVT",
            };
        final String[] Singapore = new String[] {
               "heure de Singapour",
               "SRET",
               "Srednekolymsk Daylight Time",
               "SREDT",
               "Srednekolymsk Time",
               "SRET",
            };
        final String[] Azores = new String[] {
               "heure normale des A\u00e7ores",
               "AZOT",
               "heure d\u2019\u00e9t\u00e9 des A\u00e7ores",
               "AZOST",
               "heure des A\u00e7ores",
               "AZOT",
            };
        final String[] Apia = new String[] {
               "heure normale d\u2019Apia",
               "WSST",
               "heure d\u2019\u00e9t\u00e9 d\u2019Apia",
               "WSDT",
               "heure d\u2019Apia",
               "WST",
            };
        final String[] Bhutan = new String[] {
               "heure du Bhoutan",
               "BTT",
               "Bhutan Summer Time",
               "BTST",
               "Bhutan Time",
               "BTT",
            };
        final String[] Suriname = new String[] {
               "heure du Suriname",
               "SRT",
               "Suriname Summer Time",
               "SRST",
               "Suriname Time",
               "SRT",
            };
        final String[] Nauru = new String[] {
               "heure de Nauru",
               "NRT",
               "Nauru Summer Time",
               "NRST",
               "Nauru Time",
               "NRT",
            };
        final String[] Krasnoyarsk = new String[] {
               "heure normale de Krasno\u00efarsk",
               "KRAT",
               "heure d\u2019\u00e9t\u00e9 de Krasno\u00efarsk",
               "KRAST",
               "heure de Krasno\u00efarsk",
               "KRAT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "heure de l\u2019Ouest du Kazakhstan",
               "AQTT",
               "Aqtau Summer Time",
               "AQTST",
               "Aqtau Time",
               "AQTT",
            };
        final String[] Myanmar = new String[] {
               "heure du Myanmar",
               "MMT",
               "Myanmar Summer Time",
               "MMST",
               "Myanmar Time",
               "MMT",
            };
        final String[] Christmas = new String[] {
               "heure de l\u2019\u00eele Christmas",
               "CXT",
               "Christmas Island Summer Time",
               "CXST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Amazon = new String[] {
               "heure normale de l\u2019Amazonie",
               "AMT",
               "heure d\u2019\u00e9t\u00e9 de l\u2019Amazonie",
               "AMST",
               "heure de l\u2019Amazonie",
               "AMT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "heure de l\u2019Est du Kazakhstan",
               "ALMT",
               "Alma-Ata Summer Time",
               "ALMST",
               "Alma-Ata Time",
               "ALMT",
            };
        final String[] Fiji = new String[] {
               "heure normale des \u00eeles Fidji",
               "FJT",
               "heure d\u2019\u00e9t\u00e9 des \u00eeles Fidji",
               "FJST",
               "heure des \u00eeles Fidji",
               "FJT",
            };
        final String[] Reunion = new String[] {
               "heure de la R\u00e9union",
               "RET",
               "Reunion Summer Time",
               "REST",
               "Reunion Time",
               "RET",
            };
        final String[] Cocos = new String[] {
               "heure des \u00eeles Cocos",
               "CCT",
               "Cocos Islands Summer Time",
               "CCST",
               "Cocos Islands Time",
               "CCT",
            };
        final String[] Chatham = new String[] {
               "heure normale des \u00eeles Chatham",
               "CHAST",
               "heure d\u2019\u00e9t\u00e9 des \u00eeles Chatham",
               "CHADT",
               "heure des \u00eeles Chatham",
               "CHAT",
            };
        final String[] Vostok = new String[] {
               "heure de Vostok",
               "VOST",
               "Vostok Summer Time",
               "VOSST",
               "Vostok Time",
               "VOST",
            };
        final String[] Argentina = new String[] {
               "heure normale d\u2019Argentine",
               "ART",
               "heure d\u2019\u00e9t\u00e9 de l\u2019Argentine",
               "ARST",
               "heure de l\u2019Argentine",
               "ART",
            };
        final String[] Gambier = new String[] {
               "heure des \u00eeles Gambier",
               "GAMT",
               "Gambier Summer Time",
               "GAMST",
               "Gambier Time",
               "GAMT",
            };
        final String[] Kamchatka = new String[] {
               "heure normale de Petropavlovsk-Kamchatski",
               "PETT",
               "heure d\u2019\u00e9t\u00e9 de Petropavlovsk-Kamchatski",
               "PETST",
               "heure de Petropavlovsk-Kamchatski",
               "PETT",
            };
        final String[] Tuvalu = new String[] {
               "heure des Tuvalu",
               "TVT",
               "Tuvalu Summer Time",
               "TVST",
               "Tuvalu Time",
               "TVT",
            };
        final String[] Galapagos = new String[] {
               "heure des \u00eeles Gal\u00e1pagos",
               "GALT",
               "Galapagos Summer Time",
               "GALST",
               "Galapagos Time",
               "GALT",
            };
        final String[] Macquarie = new String[] {
               "heure de l\u2019\u00eele Macquarie",
               "MIST",
               "Macquarie Island Daylight Time",
               "MIDT",
               "Macquarie Island Time",
               "MIST",
            };
        final String[] Venezuela = new String[] {
               "heure du Venezuela",
               "VET",
               "Venezuela Summer Time",
               "VEST",
               "Venezuela Time",
               "VET",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "heure normale d\u2019Hawaii - Al\u00e9outiennes",
               "HAST",
               "heure d\u2019\u00e9t\u00e9 d\u2019Hawaii - Al\u00e9outiennes",
               "HADT",
               "heure d\u2019Hawaii - Al\u00e9outiennes",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "heure normale du centre de l\u2019Australie",
               "ACST",
               "heure d\u2019\u00e9t\u00e9 du centre de l\u2019Australie",
               "ACDT",
               "heure du centre de l\u2019Australie",
               "ACT",
            };
        final String[] America_Pacific = new String[] {
               "heure normale du Pacifique nord-am\u00e9ricain",
               "PST",
               "heure d\u2019\u00e9t\u00e9 du Pacifique",
               "PDT",
               "heure du Pacifique nord-am\u00e9ricain",
               "PT",
            };
        final String[] Phoenix_Islands = new String[] {
               "heure des \u00eeles Phoenix",
               "PHOT",
               "Phoenix Is. Summer Time",
               "PHOST",
               "Phoenix Is. Time",
               "PHOT",
            };
        final String[] Turkmenistan = new String[] {
               "heure normale du Turkm\u00e9nistan",
               "TMT",
               "heure d\u2019\u00e9t\u00e9 du Turkm\u00e9nistan",
               "TMST",
               "heure du Turkm\u00e9nistan",
               "TMT",
            };
        final String[] Europe_Western = new String[] {
               "heure normale d\u2019Europe de l\u2019Ouest",
               "WET",
               "heure d\u2019\u00e9t\u00e9 d\u2019Europe de l\u2019Ouest",
               "WEST",
               "heure d\u2019Europe de l\u2019Ouest",
               "WET",
            };
        final String[] Cape_Verde = new String[] {
               "heure normale du Cap-Vert",
               "CVT",
               "heure d\u2019\u00e9t\u00e9 du Cap-Vert",
               "CVST",
               "heure du Cap-Vert",
               "CVT",
            };
        final String[] Norfolk = new String[] {
               "heure de l\u2019\u00eele Norfolk",
               "NFT",
               "Norfolk Summer Time",
               "NFST",
               "Norfolk Time",
               "NFT",
            };
        final String[] Guyana = new String[] {
               "heure du Guyana",
               "GYT",
               "Guyana Summer Time",
               "GYST",
               "Guyana Time",
               "GYT",
            };
        final String[] Pitcairn = new String[] {
               "heure des \u00eeles Pitcairn",
               "PST",
               "Pitcairn Daylight Time",
               "PDT",
               "Pitcairn Time",
               "PT",
            };
        final String[] Rothera = new String[] {
               "heure de Rothera",
               "ROTT",
               "Rothera Summer Time",
               "ROTST",
               "Rothera Time",
               "ROTT",
            };
        final String[] Samoa = new String[] {
               "heure normale des Samoa",
               "SST",
               "heure d\u2019\u00e9t\u00e9 des Samoa",
               "SDT",
               "heure des Samoa",
               "ST",
            };
        final String[] Palau = new String[] {
               "heure des Palaos",
               "PWT",
               "Palau Summer Time",
               "PWST",
               "Palau Time",
               "PWT",
            };
        final String[] Europe_Further_Eastern = new String[] {
               "heure de Kaliningrad",
               "MSK",
               "Moscow Daylight Time",
               "MSD",
               "Moscow Time",
               "MT",
            };
        final String[] Azerbaijan = new String[] {
               "heure normale de l\u2019Azerba\u00efdjan",
               "AZT",
               "heure d\u2019\u00e9t\u00e9 d\u2019Azerba\u00efdjan",
               "AZST",
               "heure de l\u2019Azerba\u00efdjan",
               "AZT",
            };
        final String[] Mawson = new String[] {
               "heure de Mawson",
               "MAWT",
               "Mawson Summer Time",
               "MAWST",
               "Mawson Time",
               "MAWT",
            };
        final String[] Mexico_Pacific = new String[] {
               "heure normale du Pacifique mexicain",
               "MST",
               "heure d\u2019\u00e9t\u00e9 du Pacifique mexicain",
               "MDT",
               "heure du Pacifique mexicain",
               "MT",
            };
        final String[] Davis = new String[] {
               "heure de Davis",
               "DAVT",
               "Davis Summer Time",
               "DAVST",
               "Davis Time",
               "DAVT",
            };
        final String[] Cuba = new String[] {
               "heure normale de Cuba",
               "CST",
               "heure d\u2019\u00e9t\u00e9 de Cuba",
               "CDT",
               "heure de Cuba",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "heure normale d\u2019Afrique de l\u2019Ouest",
               "CAT",
               "heure d\u2019\u00e9t\u00e9 d\u2019Afrique de l\u2019Ouest",
               "CAST",
               "heure d\u2019Afrique de l\u2019Ouest",
               "CAT",
            };
        final String[] GMT = new String[] {
               "heure moyenne de Greenwich",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
            };
        final String[] Philippines = new String[] {
               "heure normale des Philippines",
               "PHT",
               "heure d\u2019\u00e9t\u00e9 des Philippines",
               "PHST",
               "heure des Philippines",
               "PHT",
            };
        final String[] French_Southern = new String[] {
               "heure des Terres australes et antarctiques fran\u00e7aises",
               "TFT",
               "French Southern & Antarctic Lands Summer Time",
               "TFST",
               "French Southern & Antarctic Lands Time",
               "TFT",
            };
        final String[] South_Georgia = new String[] {
               "heure de G\u00e9orgie du Sud",
               "GST",
               "South Georgia Daylight Time",
               "GDT",
               "South Georgia Time",
               "GT",
            };
        final String[] New_Caledonia = new String[] {
               "heure normale de la Nouvelle-Cal\u00e9donie",
               "NCT",
               "heure d\u2019\u00e9t\u00e9 de Nouvelle-Cal\u00e9donie",
               "NCST",
               "heure de la Nouvelle-Cal\u00e9donie",
               "NCT",
            };
        final String[] Brunei = new String[] {
               "heure du Brun\u00e9i",
               "BNT",
               "Brunei Summer Time",
               "BNST",
               "Brunei Time",
               "BNT",
            };
        final String[] Iran = new String[] {
               "heure normale d\u2019Iran",
               "IRST",
               "heure d\u2019\u00e9t\u00e9 d\u2019Iran",
               "IRDT",
               "heure de l\u2019Iran",
               "IRT",
            };
        final String[] Easter = new String[] {
               "heure normale de l\u2019\u00eele de P\u00e2ques",
               "EAST",
               "heure d\u2019\u00e9t\u00e9 de l\u2019\u00eele de P\u00e2ques",
               "EASST",
               "heure de l\u2019\u00eele de P\u00e2ques",
               "EAST",
            };
        final String[] Mexico_Northwest = new String[] {
               "heure normale du Nord-Ouest du Mexique",
               "PST",
               "heure d\u2019\u00e9t\u00e9 du Nord-Ouest du Mexique",
               "PDT",
               "heure du Nord-Ouest du Mexique",
               "PT",
            };
        final String[] DumontDUrville = new String[] {
               "heure de Dumont-d\u2019Urville",
               "DDUT",
               "Dumont-d'Urville Summer Time",
               "DDUST",
               "Dumont-d'Urville Time",
               "DDUT",
            };
        final String[] Tajikistan = new String[] {
               "heure du Tadjikistan",
               "TJT",
               "Tajikistan Summer Time",
               "TJST",
               "Tajikistan Time",
               "TJT",
            };
        final String[] Tonga = new String[] {
               "heure normale des Tonga",
               "TOT",
               "heure d\u2019\u00e9t\u00e9 de Tonga",
               "TOST",
               "heure des Tonga",
               "TOT",
            };
        final String[] Bangladesh = new String[] {
               "heure normale du Bangladesh",
               "BDT",
               "heure d\u2019\u00e9t\u00e9 du Bangladesh",
               "BDST",
               "heure du Bangladesh",
               "BDT",
            };
        final String[] Peru = new String[] {
               "heure normale du P\u00e9rou",
               "PET",
               "heure d\u2019\u00e9t\u00e9 du P\u00e9rou",
               "PEST",
               "heure du P\u00e9rou",
               "PET",
            };
        final String[] Greenland_Western = new String[] {
               "heure normale de l\u2019Ouest du Groenland",
               "WGT",
               "heure d\u2019\u00e9t\u00e9 de l\u2019Ouest du Groenland",
               "WGST",
               "heure de l\u2019Ouest du Groenland",
               "WGT",
            };
        final String[] Ecuador = new String[] {
               "heure de l\u2019\u00c9quateur",
               "ECT",
               "Ecuador Summer Time",
               "ECST",
               "Ecuador Time",
               "ECT",
            };
        final String[] Greenland_Eastern = new String[] {
               "heure normale de l\u2019Est du Groenland",
               "EGT",
               "heure d\u2019\u00e9t\u00e9 de l\u2019Est du Groenland",
               "EGST",
               "heure de l\u2019Est du Groenland",
               "EGT",
            };
        final String[] Gulf = new String[] {
               "heure du Golfe",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "heure de l\u2019Est indon\u00e9sien",
               "WIT",
               "East Indonesia Summer Time",
               "EIST",
               "East Indonesia Time",
               "WIT",
            };
        final String[] Korea = new String[] {
               "heure normale de la Cor\u00e9e",
               "KST",
               "heure d\u2019\u00e9t\u00e9 de Cor\u00e9e",
               "KDT",
               "heure de la Cor\u00e9e",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "heure normale de l\u2019Ouest de l\u2019Australie",
               "AWST",
               "heure d\u2019\u00e9t\u00e9 de l\u2019Ouest de l\u2019Australie",
               "AWDT",
               "heure de l\u2019Ouest de l\u2019Australie",
               "AWT",
            };
        final String[] Kyrgystan = new String[] {
               "heure du Kirghizistan",
               "KGT",
               "Kirgizstan Summer Time",
               "KGST",
               "Kirgizstan Time",
               "KGT",
            };
        final String[] Indonesia_Western = new String[] {
               "heure de l\u2019Ouest indon\u00e9sien",
               "WIB",
               "West Indonesia Summer Time",
               "WIST",
               "West Indonesia Time",
               "WIB",
            };
        final String[] Australia_Eastern = new String[] {
               "heure normale de l\u2019Est de l\u2019Australie",
               "AEST",
               "heure d\u2019\u00e9t\u00e9 de l\u2019Est de l\u2019Australie",
               "AEDT",
               "heure de l\u2019Est de l\u2019Australie",
               "AET",
            };
        final String[] French_Guiana = new String[] {
               "heure de la Guyane fran\u00e7aise",
               "GFT",
               "French Guiana Summer Time",
               "GFST",
               "French Guiana Time",
               "GFT",
            };
        final String[] Colombia = new String[] {
               "heure normale de Colombie",
               "COT",
               "heure d\u2019\u00e9t\u00e9 de Colombie",
               "COST",
               "heure de Colombie",
               "COT",
            };
        final String[] Chile = new String[] {
               "heure normale du Chili",
               "CLT",
               "heure d\u2019\u00e9t\u00e9 du Chili",
               "CLST",
               "heure du Chili",
               "CLT",
            };
        final String[] Gilbert_Islands = new String[] {
               "heure des \u00eeles Gilbert",
               "GILT",
               "Gilbert Is. Summer Time",
               "GILST",
               "Gilbert Is. Time",
               "GILT",
            };
        final String[] America_Mountain = new String[] {
               "heure normale des Rocheuses",
               "MST",
               "heure d\u2019\u00e9t\u00e9 des Rocheuses",
               "MDT",
               "heure des Rocheuses",
               "MT",
            };
        final String[] Marquesas = new String[] {
               "heure des \u00eeles Marquises",
               "MART",
               "Marquesas Summer Time",
               "MARST",
               "Marquesas Time",
               "MART",
            };
        final String[] Arabian = new String[] {
               "heure normale de l\u2019Arabie",
               "AST",
               "heure d\u2019\u00e9t\u00e9 de l\u2019Arabie",
               "ADT",
               "heure de l\u2019Arabie",
               "AT",
            };
        final String[] Alaska = new String[] {
               "heure normale de l\u2019Alaska",
               "AKST",
               "heure d\u2019\u00e9t\u00e9 de l\u2019Alaska",
               "AKDT",
               "heure de l\u2019Alaska",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "heure normale de Vladivostok",
               "VLAT",
               "heure d\u2019\u00e9t\u00e9 de Vladivostok",
               "VLAST",
               "heure de Vladivostok",
               "VLAT",
            };
        final String[] Chamorro = new String[] {
               "heure des Chamorro",
               "ChST",
               "Chamorro Daylight Time",
               "ChDT",
               "Chamorro Time",
               "ChT",
            };
        final String[] Irkutsk = new String[] {
               "heure normale d\u2019Irkoutsk",
               "IRKT",
               "heure d\u2019\u00e9t\u00e9 d\u2019Irkoutsk",
               "IRKST",
               "heure d\u2019Irkoutsk",
               "IRKT",
            };
        final String[] Georgia = new String[] {
               "heure normale de la G\u00e9orgie",
               "GET",
               "heure d\u2019\u00e9t\u00e9 de G\u00e9orgie",
               "GEST",
               "heure de la G\u00e9orgie",
               "GET",
            };
        final String[] Tokelau = new String[] {
               "heure de Tokelau",
               "TKT",
               "Tokelau Summer Time",
               "TKST",
               "Tokelau Time",
               "TKT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "heure de la Papouasie-Nouvelle-Guin\u00e9e",
               "PGT",
               "Papua New Guinea Summer Time",
               "PGST",
               "Papua New Guinea Time",
               "PGT",
            };
        final String[] Noronha = new String[] {
               "heure normale de Fernando de Noronha",
               "FNT",
               "heure d\u2019\u00e9t\u00e9 de Fernando de Noronha",
               "FNST",
               "heure de Fernando de Noronha",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "heure normale de Choibalsan",
               "CHOT",
               "heure d\u2019\u00e9t\u00e9 de Choibalsan",
               "CHOST",
               "heure de Choibalsan",
               "CHOT",
            };
        final String[] Brasilia = new String[] {
               "heure normale de Brasilia",
               "BRT",
               "heure d\u2019\u00e9t\u00e9 de Brasilia",
               "BRST",
               "heure de Brasilia",
               "BRT",
            };
        final String[] China = new String[] {
               "heure normale de la Chine",
               "CST",
               "heure d\u2019\u00e9t\u00e9 de Chine",
               "CDT",
               "heure de la Chine",
               "CT",
            };
        final String[] Armenia = new String[] {
               "heure normale de l\u2019Arm\u00e9nie",
               "AMT",
               "heure d\u2019\u00e9t\u00e9 d\u2019Arm\u00e9nie",
               "AMST",
               "heure de l\u2019Arm\u00e9nie",
               "AMT",
            };
        final String[] Samara = new String[] {
               "heure normale de Samara",
               "SAMT",
               "heure d\u2019\u00e9t\u00e9 de Samara",
               "SAMST",
               "heure de Samara",
               "SAMT",
            };
        final String[] India = new String[] {
               "heure de l\u2019Inde",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Cook = new String[] {
               "heure normale des \u00eeles Cook",
               "CKT",
               "heure d\u2019\u00e9t\u00e9 des \u00eeles Cook",
               "CKHST",
               "heure des \u00eeles Cook",
               "CKT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London",
                new String[] {
                    "heure moyenne de Greenwich",
                    "GMT",
                    "heure d\u2019\u00e9t\u00e9 britannique",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Eirunepe", Acre },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", Atlantic },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Antarctica/Syowa", Syowa },
            { "Indian/Reunion", Reunion },
            { "Pacific/Palau", Palau },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Western },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Africa/Bamako", GMT },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Pacific/Bougainville", New_Zealand },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", Alaska },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Antarctica/Troll", GMT },
            { "Europe/Samara", Samara },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "heure moyenne de Greenwich",
                    "GMT",
                    "heure d\u2019\u00e9t\u00e9 irlandaise",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "Pacific/Truk", Truk },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Saipan", Chamorro },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Taipei", Taipei },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Further_Eastern },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Cancun", America_Eastern },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Rio_Branco", Acre },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Kamchatka },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Tehran", Iran },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "Asia/Srednekolymsk", Singapore },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "Australia/Lindeman", Australia_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
