/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_hsb extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "centralnoafriski \u010das",
               "CAT",
               "Central African Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "Moskowski standardny \u010das",
               "MSK",
               "Moskowski l\u011btni \u010das",
               "MSD",
               "Moskowski \u010das",
               "MT",
            };
        final String[] Japan = new String[] {
               "japanski standardny \u010das",
               "JST",
               "japanski l\u011btni \u010das",
               "JDT",
               "japanski \u010das",
               "JT",
            };
        final String[] Pakistan = new String[] {
               "pakistanski standardny \u010das",
               "PKT",
               "pakistanski l\u011btni \u010das",
               "PKST",
               "pakistanski \u010das",
               "PKT",
            };
        final String[] Taipei = new String[] {
               "Taipehski standardny \u010das",
               "CST",
               "Taipehski l\u011btni \u010das",
               "CDT",
               "Taipehski \u010das",
               "CT",
            };
        final String[] Hovd = new String[] {
               "Chowdski standardny \u010das",
               "HOVT",
               "Chowdski l\u011btni \u010das",
               "HOVST",
               "Chowdski \u010das",
               "HOVT",
            };
        final String[] Magadan = new String[] {
               "Magadanski standardny \u010das",
               "MAGT",
               "Magadanski l\u011btni \u010das",
               "MAGST",
               "Magadanski \u010das",
               "MAGT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "srjed\u017aozapadny awstralski standardny \u010das",
               "ACWST",
               "sjed\u017aozapadny awstralski l\u011btni \u010das",
               "ACWDT",
               "srjed\u017aozapadny awstralski \u010das",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "srjed\u017aoeuropski standardny \u010das",
               "MEZ",
               "srjed\u017aoeuropski l\u011btni \u010das",
               "MESZ",
               "srjed\u017aoeuropski \u010das",
               "MEZ",
            };
        final String[] Sakhalin = new String[] {
               "sachalinski standardny \u010das",
               "SAKT",
               "sachalinski l\u011btni \u010das",
               "SAKST",
               "sachalinski \u010das",
               "SAKT",
            };
        final String[] Paraguay = new String[] {
               "Paraguayski standardny \u010das",
               "PYT",
               "Paraguayski l\u011btni \u010das",
               "PYST",
               "Paraguayski \u010das",
               "PYT",
            };
        final String[] Malaysia = new String[] {
               "malajziski \u010das",
               "MYT",
               "Malaysia Summer Time",
               "MYST",
               "Malaysia Time",
               "MYT",
            };
        final String[] America_Eastern = new String[] {
               "sewjeroameriski wuchodny standardny \u010das",
               "EST",
               "sewjeroameriski wuchodny l\u011btni \u010das",
               "EDT",
               "sewjeroameriski wuchodny \u010das",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "standardny \u010das kupy Lord-Howe",
               "LHST",
               "l\u011btni \u010das kupy Lord-Howe",
               "LHDT",
               "\u010das kupy Lord-Howe",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "nowoseelandski standardny \u010das",
               "NZST",
               "nowoseelandski l\u011btni \u010das",
               "NZDT",
               "nowoseelandski \u010das",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "indiskooceanski \u010das",
               "IOT",
               "Indian Ocean Territory Summer Time",
               "IOST",
               "Indian Ocean Territory Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "Jakutski standardny \u010das",
               "YAKT",
               "Jakutski l\u011btni \u010das",
               "YAKST",
               "Jakutski \u010das",
               "YAKT",
            };
        final String[] Mauritius = new String[] {
               "mauritiuski standardny \u010das",
               "MUT",
               "mauritiuski l\u011btni \u010das",
               "MUST",
               "mauritiuski \u010das",
               "MUT",
            };
        final String[] Africa_Eastern = new String[] {
               "wuchodoafriski \u010das",
               "EAT",
               "Eastern African Summer Time",
               "EAST",
               "Eastern Africa Time",
               "EAT",
            };
        final String[] East_Timor = new String[] {
               "wuchodnotimorski \u010das",
               "TLT",
               "Timor-Leste Summer Time",
               "TLST",
               "Timor-Leste Time",
               "TLT",
            };
        final String[] Solomon = new String[] {
               "\u010das Salomonskich kupow",
               "SBT",
               "Solomon Is. Summer Time",
               "SBST",
               "Solomon Is. Time",
               "SBT",
            };
        final String[] Kosrae = new String[] {
               "kosraeski \u010das",
               "KOST",
               "Kosrae Summer Time",
               "KOSST",
               "Kosrae Time",
               "KOST",
            };
        final String[] Marshall_Islands = new String[] {
               "\u010das Marshallowych kupow",
               "MHT",
               "Marshall Islands Summer Time",
               "MHST",
               "Marshall Islands Time",
               "MHT",
            };
        final String[] Europe_Eastern = new String[] {
               "wuchodoeuropski standardny \u010das",
               "OEZ",
               "wuchodoeuropski l\u011btni \u010das",
               "OESZ",
               "wuchodoeuropski \u010das",
               "OEZ",
            };
        final String[] Newfoundland = new String[] {
               "nowofundlandski standardny \u010das",
               "NST",
               "nowofundlandski l\u011btni \u010das",
               "NDT",
               "nowofundlandski \u010das",
               "NT",
            };
        final String[] Afghanistan = new String[] {
               "afghanski \u010das",
               "AFT",
               "Afghanistan Summer Time",
               "AFST",
               "Afghanistan Time",
               "AFT",
            };
        final String[] Hong_Kong = new String[] {
               "Hongkongski standardny \u010das",
               "HKT",
               "Hongkongski l\u011btni \u010das",
               "HKST",
               "Hongkongski \u010das",
               "HKT",
            };
        final String[] Argentina_Western = new String[] {
               "zapadoargentinski standardny \u010das",
               "ART",
               "zapadoargentinski l\u011btni \u010das",
               "ARST",
               "zapadoargentinski \u010das",
               "ART",
            };
        final String[] Atlantic = new String[] {
               "atlantiski standardny \u010das",
               "AST",
               "atlantiski l\u011btni \u010das",
               "ADT",
               "atlantiski \u010das",
               "AT",
            };
        final String[] Ponape = new String[] {
               "ponapeski \u010das",
               "PONT",
               "Pohnpei Summer Time",
               "PONST",
               "Ponape Time",
               "PONT",
            };
        final String[] Bolivia = new String[] {
               "boliwiski \u010das",
               "BOT",
               "Bolivia Summer Time",
               "BOST",
               "Bolivia Time",
               "BOT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "standardny \u010das kupow St. Pierre a Miquelon",
               "PMST",
               "l\u011btni \u010das kupow St. Pierre a Miquelon",
               "PMDT",
               "\u010das kupow St. Pierre a Miquelon",
               "PMT",
            };
        final String[] Indochina = new String[] {
               "indochinski \u010das",
               "ICT",
               "Indochina Summer Time",
               "ICST",
               "Indochina Time",
               "ICT",
            };
        final String[] Yekaterinburg = new String[] {
               "Jekaterinburgski standardny \u010das",
               "YEKT",
               "Jekaterinburgski l\u011btni \u010das",
               "YEKST",
               "Jekaterinburgski \u010das",
               "YEKT",
            };
        final String[] Maldives = new String[] {
               "malediwski \u010das",
               "MVT",
               "Maldives Summer Time",
               "MVST",
               "Maldives Time",
               "MVT",
            };
        final String[] Tahiti = new String[] {
               "tahitiski \u010das",
               "TAHT",
               "Tahiti Summer Time",
               "TAHST",
               "Tahiti Time",
               "TAHT",
            };
        final String[] Israel = new String[] {
               "israelski standardny \u010das",
               "IST",
               "israelski l\u011btni \u010das",
               "IDT",
               "israelski \u010das",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "srjed\u017aoindoneski \u010das",
               "WITA",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "WITA",
            };
        final String[] Wallis = new String[] {
               "\u010das kupow Wallis a Futuna",
               "WFT",
               "Wallis & Futuna Summer Time",
               "WFST",
               "Wallis & Futuna Time",
               "WFT",
            };
        final String[] Africa_Southern = new String[] {
               "ju\u017enoafriski \u010das",
               "SAST",
               "South Africa Summer Time",
               "SAST",
               "South Africa Time",
               "SAT",
            };
        final String[] Syowa = new String[] {
               "Syowaski \u010das",
               "SYOT",
               "Syowa Summer Time",
               "SYOST",
               "Syowa Time",
               "SYOT",
            };
        final String[] Line_Islands = new String[] {
               "\u010das Linijowych kupow",
               "LINT",
               "Line Is. Summer Time",
               "LINST",
               "Line Is. Time",
               "LINT",
            };
        final String[] Uzbekistan = new String[] {
               "uzbekski standardny \u010das",
               "UZT",
               "uzbekski l\u011btni \u010das",
               "UZST",
               "uzbekski \u010das",
               "UZT",
            };
        final String[] Omsk = new String[] {
               "Omski standardny \u010das",
               "OMST",
               "Omski l\u011btni \u010das",
               "OMSST",
               "Omski \u010das",
               "OMST",
            };
        final String[] Seychelles = new String[] {
               "seychellski \u010das",
               "SCT",
               "Seychelles Summer Time",
               "SCST",
               "Seychelles Time",
               "SCT",
            };
        final String[] Uruguay = new String[] {
               "uruguayski standardny \u010das",
               "UYT",
               "uruguayski l\u011btni \u010das",
               "UYST",
               "uruguayski \u010das",
               "UYT",
            };
        final String[] Nepal = new String[] {
               "nepalski \u010das",
               "NPT",
               "Nepal Summer Time",
               "NPST",
               "Nepal Time",
               "NPT",
            };
        final String[] Mongolia = new String[] {
               "Ulan-Batorski standardny \u010das",
               "ULAT",
               "Ulan-Batorski l\u011btni \u010das",
               "ULAST",
               "Ulan-Batorski \u010das",
               "ULAT",
            };
        final String[] America_Central = new String[] {
               "sewjeroameriski centralny standardny \u010das",
               "CST",
               "sewjeroameriski centralny l\u011btni \u010das",
               "CDT",
               "sewjeroameriski centralny \u010das",
               "CT",
            };
        final String[] Truk = new String[] {
               "chuukski \u010das",
               "CHUT",
               "Chuuk Summer Time",
               "CHUST",
               "Chuuk Time",
               "CHUT",
            };
        final String[] Niue = new String[] {
               "niueski \u010das",
               "NUT",
               "Niue Summer Time",
               "NUST",
               "Niue Time",
               "NUT",
            };
        final String[] Wake = new String[] {
               "\u010das kupy Wake",
               "WAKT",
               "Wake Summer Time",
               "WAKST",
               "Wake Time",
               "WAKT",
            };
        final String[] Falkland = new String[] {
               "falklandski standardny \u010das",
               "FKT",
               "falklandski l\u011btni \u010das",
               "FKST",
               "falklandski \u010das",
               "FKT",
            };
        final String[] Vanuatu = new String[] {
               "vanuatuski standardny \u010das",
               "VUT",
               "vanuatuski l\u011btni \u010das",
               "VUST",
               "vanuatuski \u010das",
               "VUT",
            };
        final String[] Novosibirsk = new String[] {
               "Nowosibirski standardny \u010das",
               "NOVT",
               "Nowosibirski l\u011btni \u010das",
               "NOVST",
               "Nowosibirski \u010das",
               "NOVT",
            };
        final String[] Singapore = new String[] {
               "Singapurski \u010das",
               "SRET",
               "Srednekolymsk Daylight Time",
               "SREDT",
               "Srednekolymsk Time",
               "SRET",
            };
        final String[] Azores = new String[] {
               "acorski standardny \u010das",
               "AZOT",
               "acorski l\u011btni \u010das",
               "AZOST",
               "acorski \u010das",
               "AZOT",
            };
        final String[] Apia = new String[] {
               "Apiaski standardny \u010das",
               "WSST",
               "Apiaski l\u011btni \u010das",
               "WSDT",
               "Apiaski \u010das",
               "WST",
            };
        final String[] Bhutan = new String[] {
               "bhutanski \u010das",
               "BTT",
               "Bhutan Summer Time",
               "BTST",
               "Bhutan Time",
               "BTT",
            };
        final String[] Suriname = new String[] {
               "surinamski \u010das",
               "SRT",
               "Suriname Summer Time",
               "SRST",
               "Suriname Time",
               "SRT",
            };
        final String[] Nauru = new String[] {
               "nauruski \u010das",
               "NRT",
               "Nauru Summer Time",
               "NRST",
               "Nauru Time",
               "NRT",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnojarski standardny \u010das",
               "KRAT",
               "Krasnojarski l\u011btni \u010das",
               "KRAST",
               "Krasnojarski \u010das",
               "KRAT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "zapadnokazachski \u010das",
               "AQTT",
               "Aqtau Summer Time",
               "AQTST",
               "Aqtau Time",
               "AQTT",
            };
        final String[] Myanmar = new String[] {
               "myanmarski \u010das",
               "MMT",
               "Myanmar Summer Time",
               "MMST",
               "Myanmar Time",
               "MMT",
            };
        final String[] Christmas = new String[] {
               "\u010das Hodowneje kupy",
               "CXT",
               "Christmas Island Summer Time",
               "CXST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Amazon = new String[] {
               "Amaconaski standardny \u010das",
               "AMT",
               "Amaconaski l\u011btni \u010das",
               "AMST",
               "Amaconaski \u010das",
               "AMT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "wuchodnokazachski \u010das",
               "ALMT",
               "Alma-Ata Summer Time",
               "ALMST",
               "Alma-Ata Time",
               "ALMT",
            };
        final String[] Fiji = new String[] {
               "fid\u017aiski standardny \u010das",
               "FJT",
               "fid\u017aiski l\u011btni \u010das",
               "FJST",
               "fid\u017aiski \u010das",
               "FJT",
            };
        final String[] Reunion = new String[] {
               "reunionski \u010das",
               "RET",
               "Reunion Summer Time",
               "REST",
               "Reunion Time",
               "RET",
            };
        final String[] Cocos = new String[] {
               "\u010das Kokosowych kupow",
               "CCT",
               "Cocos Islands Summer Time",
               "CCST",
               "Cocos Islands Time",
               "CCT",
            };
        final String[] Chatham = new String[] {
               "chathamski standardny \u010das",
               "CHAST",
               "chathamski l\u011btni \u010das",
               "CHADT",
               "chathamski \u010das",
               "CHAT",
            };
        final String[] Vostok = new String[] {
               "Wostokski \u010das",
               "VOST",
               "Vostok Summer Time",
               "VOSST",
               "Vostok Time",
               "VOST",
            };
        final String[] Argentina = new String[] {
               "argentinski standardny \u010das",
               "ART",
               "argentinski l\u011btni \u010das",
               "ARST",
               "argentinski \u010das",
               "ART",
            };
        final String[] Gambier = new String[] {
               "gambierski \u010das",
               "GAMT",
               "Gambier Summer Time",
               "GAMST",
               "Gambier Time",
               "GAMT",
            };
        final String[] Tuvalu = new String[] {
               "tuvaluski \u010das",
               "TVT",
               "Tuvalu Summer Time",
               "TVST",
               "Tuvalu Time",
               "TVT",
            };
        final String[] Galapagos = new String[] {
               "galapagoski \u010das",
               "GALT",
               "Galapagos Summer Time",
               "GALST",
               "Galapagos Time",
               "GALT",
            };
        final String[] Macquarie = new String[] {
               "\u010das kupy Macquarie",
               "MIST",
               "Macquarie Island Daylight Time",
               "MIDT",
               "Macquarie Island Time",
               "MIST",
            };
        final String[] Venezuela = new String[] {
               "venezuelski \u010das",
               "VET",
               "Venezuela Summer Time",
               "VEST",
               "Venezuela Time",
               "VET",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "hawaiisko-aleutski standardny \u010das",
               "HAST",
               "hawaiisko-aleutski l\u011btni \u010das",
               "HADT",
               "hawaiisko-aleutski \u010das",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "srjed\u017aoawstralski standardny \u010das",
               "ACST",
               "srjed\u017aoawstralski l\u011btni \u010das",
               "ACDT",
               "srjed\u017aoawstralski \u010das",
               "ACT",
            };
        final String[] America_Pacific = new String[] {
               "sewjeroameriski pacifiski standardny \u010das",
               "PST",
               "sewjeroameriski pacifiski l\u011btni \u010das",
               "PDT",
               "sewjeroameriski pacifiski \u010das",
               "PT",
            };
        final String[] Phoenix_Islands = new String[] {
               "\u010das Phoenixowych kupow",
               "PHOT",
               "Phoenix Is. Summer Time",
               "PHOST",
               "Phoenix Is. Time",
               "PHOT",
            };
        final String[] Turkmenistan = new String[] {
               "turkmenski standardny \u010das",
               "TMT",
               "turkmenski l\u011btni \u010das",
               "TMST",
               "turkmenski \u010das",
               "TMT",
            };
        final String[] Europe_Western = new String[] {
               "zapadoeuropski standardny \u010das",
               "WEZ",
               "zapadoeuropski l\u011btni \u010das",
               "WESZ",
               "zapadoeuropski \u010das",
               "WEZ",
            };
        final String[] Cape_Verde = new String[] {
               "kapverdski standardny \u010das",
               "CVT",
               "kapverdski l\u011btni \u010das",
               "CVST",
               "kapverdski \u010das",
               "CVT",
            };
        final String[] Norfolk = new String[] {
               "\u010das kupy Norfolk",
               "NFT",
               "Norfolk Summer Time",
               "NFST",
               "Norfolk Time",
               "NFT",
            };
        final String[] Guyana = new String[] {
               "guyanski \u010das",
               "GYT",
               "Guyana Summer Time",
               "GYST",
               "Guyana Time",
               "GYT",
            };
        final String[] Pitcairn = new String[] {
               "\u010das Pitcairnowych kupow",
               "PST",
               "Pitcairn Daylight Time",
               "PDT",
               "Pitcairn Time",
               "PT",
            };
        final String[] Rothera = new String[] {
               "Rotheraski \u010das",
               "ROTT",
               "Rothera Summer Time",
               "ROTST",
               "Rothera Time",
               "ROTT",
            };
        final String[] Samoa = new String[] {
               "samoaski standardny \u010das",
               "SST",
               "samoaski l\u011btni \u010das",
               "SDT",
               "samoaski \u010das",
               "ST",
            };
        final String[] Palau = new String[] {
               "palauski \u010das",
               "PWT",
               "Palau Summer Time",
               "PWST",
               "Palau Time",
               "PWT",
            };
        final String[] Europe_Further_Eastern = new String[] {
               "Kaliningradski \u010das",
               "MSK",
               "Moscow Daylight Time",
               "MSD",
               "Moscow Time",
               "MT",
            };
        final String[] Azerbaijan = new String[] {
               "azerbajd\u017aanski standardny \u010das",
               "AZT",
               "azerbajd\u017aanski l\u011btni \u010das",
               "AZST",
               "azerbajd\u017aanski \u010das",
               "AZT",
            };
        final String[] Mawson = new String[] {
               "Mawsonski \u010das",
               "MAWT",
               "Mawson Summer Time",
               "MAWST",
               "Mawson Time",
               "MAWT",
            };
        final String[] Mexico_Pacific = new String[] {
               "mexiski pacifiski standardny \u010das",
               "MST",
               "mexiski pacifiski l\u011btni \u010das",
               "MDT",
               "mexiski pacifiski \u010das",
               "MT",
            };
        final String[] Davis = new String[] {
               "Daviski \u010das",
               "DAVT",
               "Davis Summer Time",
               "DAVST",
               "Davis Time",
               "DAVT",
            };
        final String[] Cuba = new String[] {
               "kubaski standardny \u010das",
               "CST",
               "kubaski l\u011btni \u010das",
               "CDT",
               "kubaski \u010das",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "zapadoafriski standardny \u010das",
               "CAT",
               "zapadoafriski l\u011btni \u010das",
               "CAST",
               "zapadoafriski \u010das",
               "CAT",
            };
        final String[] GMT = new String[] {
               "Greenwichski \u010das",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
            };
        final String[] Philippines = new String[] {
               "filipinski standardny \u010das",
               "PHT",
               "filipinski l\u011btni \u010das",
               "PHST",
               "filipinski \u010das",
               "PHT",
            };
        final String[] French_Southern = new String[] {
               "\u010das Francoskeho ju\u017eneho a antarktiskeho teritorija",
               "TFT",
               "French Southern & Antarctic Lands Summer Time",
               "TFST",
               "French Southern & Antarctic Lands Time",
               "TFT",
            };
        final String[] South_Georgia = new String[] {
               "ju\u017enogeorgiski \u010das",
               "GST",
               "South Georgia Daylight Time",
               "GDT",
               "South Georgia Time",
               "GT",
            };
        final String[] New_Caledonia = new String[] {
               "nowokaledonski standardny \u010das",
               "NCT",
               "nowokaledonski l\u011btni \u010das",
               "NCST",
               "nowokaledonski \u010das",
               "NCT",
            };
        final String[] Brunei = new String[] {
               "bruneiski \u010das",
               "BNT",
               "Brunei Summer Time",
               "BNST",
               "Brunei Time",
               "BNT",
            };
        final String[] Iran = new String[] {
               "iranski standardny \u010das",
               "IRST",
               "iranski l\u011btni \u010das",
               "IRDT",
               "iranski \u010das",
               "IRT",
            };
        final String[] Easter = new String[] {
               "standardny \u010das Jutrowneje kupy",
               "EAST",
               "l\u011btni \u010das Jutrowneje kupy",
               "EASST",
               "\u010das Jutrowneje kupy",
               "EAST",
            };
        final String[] Mexico_Northwest = new String[] {
               "mexiski sewjerozapadny standardny \u010das",
               "PST",
               "mexiski sewjerozapadny l\u011btni \u010das",
               "PDT",
               "mexiski sewjerozapadny \u010das",
               "PT",
            };
        final String[] DumontDUrville = new String[] {
               "Dumont d\u00b4 Urvilleski \u010das",
               "DDUT",
               "Dumont-d'Urville Summer Time",
               "DDUST",
               "Dumont-d'Urville Time",
               "DDUT",
            };
        final String[] Tajikistan = new String[] {
               "tad\u017aikski \u010das",
               "TJT",
               "Tajikistan Summer Time",
               "TJST",
               "Tajikistan Time",
               "TJT",
            };
        final String[] Tonga = new String[] {
               "tongaski standardny \u010das",
               "TOT",
               "tongaski l\u011btni \u010das",
               "TOST",
               "tongaski \u010das",
               "TOT",
            };
        final String[] Bangladesh = new String[] {
               "banglade\u0161ski standardny \u010das",
               "BDT",
               "banglade\u0161ski l\u011btni \u010das",
               "BDST",
               "banglade\u0161ski \u010das",
               "BDT",
            };
        final String[] Peru = new String[] {
               "peruski standardny \u010das",
               "PET",
               "peruski l\u011btni \u010das",
               "PEST",
               "peruski \u010das",
               "PET",
            };
        final String[] Greenland_Western = new String[] {
               "zapadogr\u00f6nlandski standardny \u010das",
               "WGT",
               "zapadogr\u00f6nlandski l\u011btni \u010das",
               "WGST",
               "zapadogr\u00f6nlandski \u010das",
               "WGT",
            };
        final String[] Ecuador = new String[] {
               "ekwadorski \u010das",
               "ECT",
               "Ecuador Summer Time",
               "ECST",
               "Ecuador Time",
               "ECT",
            };
        final String[] Greenland_Eastern = new String[] {
               "wuchodogr\u00f6nlandski standardny \u010das",
               "EGT",
               "wuchodogr\u00f6nlandski l\u011btni \u010das",
               "EGST",
               "wuchodogr\u00f6nlandski \u010das",
               "EGT",
            };
        final String[] Gulf = new String[] {
               "\u010das Persiskeho golfa",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "wuchodoindoneski",
               "WIT",
               "East Indonesia Summer Time",
               "EIST",
               "East Indonesia Time",
               "WIT",
            };
        final String[] Korea = new String[] {
               "korejski standardny \u010das",
               "KST",
               "korejski l\u011btni \u010das",
               "KDT",
               "korejski \u010das",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "zapadoawstralski standardny \u010das",
               "AWST",
               "zapadoawstralski l\u011btni \u010das",
               "AWDT",
               "zapadoawstralski \u010das",
               "AWT",
            };
        final String[] Kyrgystan = new String[] {
               "kirgiski \u010das",
               "KGT",
               "Kirgizstan Summer Time",
               "KGST",
               "Kirgizstan Time",
               "KGT",
            };
        final String[] Indonesia_Western = new String[] {
               "zapadoindoneski \u010das",
               "WIB",
               "West Indonesia Summer Time",
               "WIST",
               "West Indonesia Time",
               "WIB",
            };
        final String[] Australia_Eastern = new String[] {
               "wuchodoawstralski standardny \u010das",
               "AEST",
               "wuchodoawstralski l\u011btni \u010das",
               "AEDT",
               "wuchodoawstralski \u010das",
               "AET",
            };
        final String[] French_Guiana = new String[] {
               "francoskoguyanski \u010das",
               "GFT",
               "French Guiana Summer Time",
               "GFST",
               "French Guiana Time",
               "GFT",
            };
        final String[] Colombia = new String[] {
               "kolumbiski standardny \u010das",
               "COT",
               "kolumbiski l\u011btni \u010das",
               "COST",
               "kolumbiski \u010das",
               "COT",
            };
        final String[] Chile = new String[] {
               "chilski standardny \u010das",
               "CLT",
               "chilski l\u011btni \u010das",
               "CLST",
               "chilski \u010das",
               "CLT",
            };
        final String[] Gilbert_Islands = new String[] {
               "\u010das Gilbertowych kupow",
               "GILT",
               "Gilbert Is. Summer Time",
               "GILST",
               "Gilbert Is. Time",
               "GILT",
            };
        final String[] America_Mountain = new String[] {
               "sewjeroameriski h\u00f3rski standardny \u010das",
               "MST",
               "sewjeroameriski h\u00f3rski l\u011btni \u010das",
               "MDT",
               "sewjeroameriski h\u00f3rski \u010das",
               "MT",
            };
        final String[] Marquesas = new String[] {
               "marquesaski \u010das",
               "MART",
               "Marquesas Summer Time",
               "MARST",
               "Marquesas Time",
               "MART",
            };
        final String[] Arabian = new String[] {
               "arabski standardny \u010das",
               "AST",
               "arabski l\u011btni \u010das",
               "ADT",
               "arabski \u010das",
               "AT",
            };
        final String[] Alaska = new String[] {
               "alaskaski standardny \u010das",
               "AKST",
               "alaskaski l\u011btni \u010das",
               "AKDT",
               "alaskaski \u010das",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "Wladiwostokski standardny \u010das",
               "VLAT",
               "Wladiwostokski l\u011btni \u010das",
               "VLAST",
               "Wladiwostokski \u010das",
               "VLAT",
            };
        final String[] Chamorro = new String[] {
               "chamorroski \u010das",
               "ChST",
               "Chamorro Daylight Time",
               "ChDT",
               "Chamorro Time",
               "ChT",
            };
        final String[] Irkutsk = new String[] {
               "Irkutski standardny \u010das",
               "IRKT",
               "Irkutski l\u011btni \u010das",
               "IRKST",
               "Irkutski \u010das",
               "IRKT",
            };
        final String[] Georgia = new String[] {
               "georgiski standardny \u010das",
               "GET",
               "georgiski l\u011btni \u010das",
               "GEST",
               "georgiski \u010das",
               "GET",
            };
        final String[] Tokelau = new String[] {
               "tokelauski \u010das",
               "TKT",
               "Tokelau Summer Time",
               "TKST",
               "Tokelau Time",
               "TKT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "papua-nowoginejski \u010das",
               "PGT",
               "Papua New Guinea Summer Time",
               "PGST",
               "Papua New Guinea Time",
               "PGT",
            };
        final String[] Noronha = new String[] {
               "standardny \u010das kupow Fernando de Noronha",
               "FNT",
               "l\u011btni \u010das kupow Fernando de Noronha",
               "FNST",
               "\u010das kupow Fernando de Noronha",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "\u010cojbalsanski standardny \u010das",
               "CHOT",
               "\u010cojbalsanski l\u011btni \u010das",
               "CHOST",
               "\u010cojbalsanski \u010das",
               "CHOT",
            };
        final String[] Brasilia = new String[] {
               "Brasiliski standardny \u010das",
               "BRT",
               "Brasiliski l\u011btni \u010das",
               "BRST",
               "Brasiliski \u010das",
               "BRT",
            };
        final String[] China = new String[] {
               "chinski standardny \u010das",
               "CST",
               "chinski l\u011btni \u010das",
               "CDT",
               "chinski \u010das",
               "CT",
            };
        final String[] Armenia = new String[] {
               "armenski standardny \u010das",
               "AMT",
               "armenski l\u011btni \u010das",
               "AMST",
               "armenski \u010das",
               "AMT",
            };
        final String[] India = new String[] {
               "indiski \u010das",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Cook = new String[] {
               "standardny \u010das Cookowych kupow",
               "CKT",
               "l\u011btni \u010das Cookowych kupow",
               "CKHST",
               "\u010das Cookowych kupow",
               "CKT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London",
                new String[] {
                    "Greenwichski \u010das",
                    "GMT",
                    "Britiski l\u011btni \u010das",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", Atlantic },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Antarctica/Syowa", Syowa },
            { "Indian/Reunion", Reunion },
            { "Pacific/Palau", Palau },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Western },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Africa/Bamako", GMT },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Pacific/Bougainville", New_Zealand },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", Alaska },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Antarctica/Troll", GMT },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "Greenwichski \u010das",
                    "GMT",
                    "Irski l\u011btni \u010das",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "Pacific/Truk", Truk },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Saipan", Chamorro },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Taipei", Taipei },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Further_Eastern },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Cancun", America_Eastern },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Tehran", Iran },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "Asia/Srednekolymsk", Singapore },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "Australia/Lindeman", Australia_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
