/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_hu extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "k\u00f6z\u00e9p-afrikai t\u00e9li id\u0151",
               "CAT",
               "Central African Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "moszkvai t\u00e9li id\u0151",
               "MSK",
               "moszkvai ny\u00e1ri id\u0151",
               "MSD",
               "moszkvai id\u0151",
               "MT",
            };
        final String[] Japan = new String[] {
               "jap\u00e1n t\u00e9li id\u0151",
               "JST",
               "jap\u00e1n ny\u00e1ri id\u0151",
               "JDT",
               "jap\u00e1n id\u0151",
               "JT",
            };
        final String[] Pakistan = new String[] {
               "pakiszt\u00e1ni t\u00e9li id\u0151",
               "PKT",
               "pakiszt\u00e1ni ny\u00e1ri id\u0151",
               "PKST",
               "pakiszt\u00e1ni id\u0151",
               "PKT",
            };
        final String[] Taipei = new String[] {
               "taipei t\u00e9li id\u0151",
               "CST",
               "taipei ny\u00e1ri id\u0151",
               "CDT",
               "taipei id\u0151",
               "CT",
            };
        final String[] Hovd = new String[] {
               "hovdi t\u00e9li id\u0151",
               "HOVT",
               "hovdi ny\u00e1ri id\u0151",
               "HOVST",
               "hovdi id\u0151",
               "HOVT",
            };
        final String[] Magadan = new String[] {
               "magadani t\u00e9li id\u0151",
               "MAGT",
               "magad\u00e1ni ny\u00e1ri id\u0151",
               "MAGST",
               "magad\u00e1ni id\u0151",
               "MAGT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "k\u00f6z\u00e9p-nyugat-ausztr\u00e1liai t\u00e9li id\u0151",
               "ACWST",
               "k\u00f6z\u00e9p-nyugat-ausztr\u00e1liai ny\u00e1ri id\u0151",
               "ACWDT",
               "k\u00f6z\u00e9p-nyugat-ausztr\u00e1liai id\u0151",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "k\u00f6z\u00e9p-eur\u00f3pai t\u00e9li id\u0151",
               "CET",
               "k\u00f6z\u00e9p-eur\u00f3pai ny\u00e1ri id\u0151",
               "CEST",
               "k\u00f6z\u00e9p-eur\u00f3pai id\u0151z\u00f3na",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "szahalini t\u00e9li id\u0151",
               "SAKT",
               "szahalini ny\u00e1ri id\u0151",
               "SAKST",
               "szahalini id\u0151",
               "SAKT",
            };
        final String[] Paraguay = new String[] {
               "paraguayi t\u00e9li id\u0151",
               "PYT",
               "paraguayi ny\u00e1ri id\u0151",
               "PYST",
               "paraguayi id\u0151",
               "PYT",
            };
        final String[] Acre = new String[] {
               "Acre z\u00f3naid\u0151",
               "ACT",
               "Acre ny\u00e1ri id\u0151",
               "ACST",
               "Acre id\u0151",
               "ACT",
            };
        final String[] Malaysia = new String[] {
               "malajziai id\u0151",
               "MYT",
               "Malaysia Summer Time",
               "MYST",
               "Malaysia Time",
               "MYT",
            };
        final String[] America_Eastern = new String[] {
               "keleti \u00e1llamokbeli z\u00f3naid\u0151",
               "EST",
               "keleti \u00e1llamokbeli ny\u00e1ri id\u0151",
               "EDT",
               "keleti \u00e1llamokbeli id\u0151",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "Lord Howe-szigeti t\u00e9li id\u0151",
               "LHST",
               "Lord Howe-szigeti ny\u00e1ri id\u0151",
               "LHDT",
               "Lord Howe-szigeti id\u0151",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "\u00faj-z\u00e9landi t\u00e9li id\u0151",
               "NZST",
               "\u00faj-z\u00e9landi ny\u00e1ri id\u0151",
               "NZDT",
               "\u00faj-z\u00e9landi id\u0151",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "indiai-\u00f3ce\u00e1ni id\u0151",
               "IOT",
               "Indian Ocean Territory Summer Time",
               "IOST",
               "Indian Ocean Territory Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "jakutszki t\u00e9li id\u0151",
               "YAKT",
               "Jakutszki ny\u00e1ri id\u0151",
               "YAKST",
               "jakutszki id\u0151",
               "YAKT",
            };
        final String[] Mauritius = new String[] {
               "mauritiusi t\u00e9li id\u0151",
               "MUT",
               "mauritiusi ny\u00e1ri id\u0151",
               "MUST",
               "mauritiusi id\u0151z\u00f3na",
               "MUT",
            };
        final String[] Africa_Eastern = new String[] {
               "kelet-afrikai t\u00e9li id\u0151",
               "EAT",
               "Eastern African Summer Time",
               "EAST",
               "Eastern Africa Time",
               "EAT",
            };
        final String[] East_Timor = new String[] {
               "kelet-timori t\u00e9li id\u0151",
               "TLT",
               "Timor-Leste Summer Time",
               "TLST",
               "Timor-Leste Time",
               "TLT",
            };
        final String[] Solomon = new String[] {
               "salamon-szigeteki id\u0151",
               "SBT",
               "Solomon Is. Summer Time",
               "SBST",
               "Solomon Is. Time",
               "SBT",
            };
        final String[] Kosrae = new String[] {
               "kosraei id\u0151",
               "KOST",
               "Kosrae Summer Time",
               "KOSST",
               "Kosrae Time",
               "KOST",
            };
        final String[] Marshall_Islands = new String[] {
               "marshall-szigeteki id\u0151",
               "MHT",
               "Marshall Islands Summer Time",
               "MHST",
               "Marshall Islands Time",
               "MHT",
            };
        final String[] Europe_Eastern = new String[] {
               "kelet-eur\u00f3pai t\u00e9li id\u0151",
               "EET",
               "kelet-eur\u00f3pai ny\u00e1ri id\u0151",
               "EEST",
               "kelet-eur\u00f3pai id\u0151z\u00f3na",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "\u00faj-fundlandi z\u00f3naid\u0151",
               "NST",
               "\u00faj-fundlandi ny\u00e1ri id\u0151",
               "NDT",
               "\u00faj-fundlandi id\u0151",
               "NT",
            };
        final String[] Afghanistan = new String[] {
               "afganiszt\u00e1ni id\u0151",
               "AFT",
               "Afghanistan Summer Time",
               "AFST",
               "Afghanistan Time",
               "AFT",
            };
        final String[] Hong_Kong = new String[] {
               "hongkongi t\u00e9li id\u0151",
               "HKT",
               "hongkongi ny\u00e1ri id\u0151",
               "HKST",
               "hongkongi id\u0151z\u00f3na",
               "HKT",
            };
        final String[] Argentina_Western = new String[] {
               "nyugat-argent\u00ednai t\u00e9li id\u0151",
               "ART",
               "nyugat-argent\u00ednai ny\u00e1ri id\u0151",
               "ARST",
               "nyugat-argent\u00ednai id\u0151z\u00f3na",
               "ART",
            };
        final String[] Atlantic = new String[] {
               "atlanti-\u00f3ce\u00e1ni z\u00f3naid\u0151",
               "AST",
               "atlanti-\u00f3ce\u00e1ni ny\u00e1ri id\u0151",
               "ADT",
               "atlanti-\u00f3ce\u00e1ni id\u0151",
               "AT",
            };
        final String[] Ponape = new String[] {
               "ponape-szigeti id\u0151",
               "PONT",
               "Pohnpei Summer Time",
               "PONST",
               "Ponape Time",
               "PONT",
            };
        final String[] Bolivia = new String[] {
               "bol\u00edviai t\u00e9li id\u0151",
               "BOT",
               "Bolivia Summer Time",
               "BOST",
               "Bolivia Time",
               "BOT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Saint Pierre \u00e9s Miquelon-i z\u00f3naid\u0151",
               "PMST",
               "Saint Pierre \u00e9s Miquelon-i ny\u00e1ri id\u0151",
               "PMDT",
               "Saint Pierre \u00e9s Miquelon-i id\u0151",
               "PMT",
            };
        final String[] Indochina = new String[] {
               "indok\u00ednai id\u0151",
               "ICT",
               "Indochina Summer Time",
               "ICST",
               "Indochina Time",
               "ICT",
            };
        final String[] Yekaterinburg = new String[] {
               "jekatyerinburgi t\u00e9li id\u0151",
               "YEKT",
               "Jekatyerinburgi ny\u00e1ri id\u0151",
               "YEKST",
               "Jekatyerinburgi id\u0151",
               "YEKT",
            };
        final String[] Maldives = new String[] {
               "mald\u00edv-szigeteki id\u0151",
               "MVT",
               "Maldives Summer Time",
               "MVST",
               "Maldives Time",
               "MVT",
            };
        final String[] Tahiti = new String[] {
               "tahiti id\u0151",
               "TAHT",
               "Tahiti Summer Time",
               "TAHST",
               "Tahiti Time",
               "TAHT",
            };
        final String[] Israel = new String[] {
               "izraeli t\u00e9li id\u0151",
               "IST",
               "izraeli ny\u00e1ri id\u0151",
               "IDT",
               "izraeli id\u0151",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "k\u00f6z\u00e9p-indon\u00e9ziai id\u0151",
               "WITA",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "WITA",
            };
        final String[] Wallis = new String[] {
               "Wallis \u00e9s Futuna-i id\u0151",
               "WFT",
               "Wallis & Futuna Summer Time",
               "WFST",
               "Wallis & Futuna Time",
               "WFT",
            };
        final String[] Africa_Southern = new String[] {
               "d\u00e9l-afrikai t\u00e9li id\u0151",
               "SAST",
               "South Africa Summer Time",
               "SAST",
               "South Africa Time",
               "SAT",
            };
        final String[] Syowa = new String[] {
               "syowai id\u0151",
               "SYOT",
               "Syowa Summer Time",
               "SYOST",
               "Syowa Time",
               "SYOT",
            };
        final String[] Line_Islands = new String[] {
               "sor-szigeteki id\u0151",
               "LINT",
               "Line Is. Summer Time",
               "LINST",
               "Line Is. Time",
               "LINT",
            };
        final String[] Uzbekistan = new String[] {
               "\u00fczbegiszt\u00e1ni t\u00e9li id\u0151",
               "UZT",
               "\u00fczbegiszt\u00e1ni ny\u00e1ri id\u0151",
               "UZST",
               "\u00fczbegiszt\u00e1ni id\u0151",
               "UZT",
            };
        final String[] Omsk = new String[] {
               "omszki t\u00e9li id\u0151",
               "OMST",
               "omszki ny\u00e1ri id\u0151",
               "OMSST",
               "omszki id\u0151",
               "OMST",
            };
        final String[] Seychelles = new String[] {
               "seychelle-szigeteki id\u0151",
               "SCT",
               "Seychelles Summer Time",
               "SCST",
               "Seychelles Time",
               "SCT",
            };
        final String[] Uruguay = new String[] {
               "uruguayi t\u00e9li id\u0151",
               "UYT",
               "uruguayi ny\u00e1ri id\u0151",
               "UYST",
               "uruguayi id\u0151",
               "UYT",
            };
        final String[] Nepal = new String[] {
               "nep\u00e1li id\u0151",
               "NPT",
               "Nepal Summer Time",
               "NPST",
               "Nepal Time",
               "NPT",
            };
        final String[] Mongolia = new String[] {
               "ul\u00e1nb\u00e1tori t\u00e9li id\u0151",
               "ULAT",
               "ul\u00e1nb\u00e1tori ny\u00e1ri id\u0151",
               "ULAST",
               "ul\u00e1nb\u00e1tori id\u0151",
               "ULAT",
            };
        final String[] America_Central = new String[] {
               "k\u00f6z\u00e9ps\u0151 \u00e1llamokbeli z\u00f3naid\u0151",
               "CST",
               "k\u00f6z\u00e9ps\u0151 \u00e1llamokbeli ny\u00e1ri id\u0151",
               "CDT",
               "k\u00f6z\u00e9ps\u0151 \u00e1llamokbeli id\u0151",
               "CT",
            };
        final String[] Truk = new String[] {
               "truki id\u0151",
               "CHUT",
               "Chuuk Summer Time",
               "CHUST",
               "Chuuk Time",
               "CHUT",
            };
        final String[] Niue = new String[] {
               "niuei id\u0151",
               "NUT",
               "Niue Summer Time",
               "NUST",
               "Niue Time",
               "NUT",
            };
        final String[] Wake = new String[] {
               "wake-szigeti id\u0151",
               "WAKT",
               "Wake Summer Time",
               "WAKST",
               "Wake Time",
               "WAKT",
            };
        final String[] Falkland = new String[] {
               "falkland-szigeteki t\u00e9li id\u0151",
               "FKT",
               "falkland-szigeteki ny\u00e1ri id\u0151",
               "FKST",
               "falkland-szigeteki id\u0151",
               "FKT",
            };
        final String[] Vanuatu = new String[] {
               "vanuatui t\u00e9li id\u0151",
               "VUT",
               "vanuatui ny\u00e1ri id\u0151",
               "VUST",
               "vanuatui id\u0151",
               "VUT",
            };
        final String[] Novosibirsk = new String[] {
               "novoszibirszki t\u00e9li id\u0151",
               "NOVT",
               "novoszibirszki ny\u00e1ri id\u0151",
               "NOVST",
               "novoszibirszki id\u0151",
               "NOVT",
            };
        final String[] Singapore = new String[] {
               "szingap\u00fari t\u00e9li id\u0151",
               "SRET",
               "Srednekolymsk Daylight Time",
               "SREDT",
               "Srednekolymsk Time",
               "SRET",
            };
        final String[] Azores = new String[] {
               "azori t\u00e9li id\u0151",
               "AZOT",
               "azori ny\u00e1ri id\u0151",
               "AZOST",
               "azori id\u0151z\u00f3na",
               "AZOT",
            };
        final String[] Apia = new String[] {
               "apiai t\u00e9li id\u0151",
               "WSST",
               "apiai ny\u00e1ri id\u0151",
               "WSDT",
               "apiai id\u0151",
               "WST",
            };
        final String[] Bhutan = new String[] {
               "but\u00e1ni id\u0151",
               "BTT",
               "Bhutan Summer Time",
               "BTST",
               "Bhutan Time",
               "BTT",
            };
        final String[] Suriname = new String[] {
               "szurin\u00e1mi id\u0151",
               "SRT",
               "Suriname Summer Time",
               "SRST",
               "Suriname Time",
               "SRT",
            };
        final String[] Nauru = new String[] {
               "naurui id\u0151",
               "NRT",
               "Nauru Summer Time",
               "NRST",
               "Nauru Time",
               "NRT",
            };
        final String[] Krasnoyarsk = new String[] {
               "krasznojarszki t\u00e9li id\u0151",
               "KRAT",
               "krasznojarszki ny\u00e1ri id\u0151",
               "KRAST",
               "krasznojarszki id\u0151",
               "KRAT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "nyugat-kazahszt\u00e1ni id\u0151",
               "AQTT",
               "Aqtau Summer Time",
               "AQTST",
               "Aqtau Time",
               "AQTT",
            };
        final String[] Myanmar = new String[] {
               "mianmari id\u0151",
               "MMT",
               "Myanmar Summer Time",
               "MMST",
               "Myanmar Time",
               "MMT",
            };
        final String[] Christmas = new String[] {
               "kar\u00e1csony-szigeti t\u00e9li id\u0151",
               "CXT",
               "Christmas Island Summer Time",
               "CXST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Amazon = new String[] {
               "amaz\u00f3niai t\u00e9li id\u0151",
               "AMT",
               "amaz\u00f3niai ny\u00e1ri id\u0151",
               "AMST",
               "amaz\u00f3niai id\u0151",
               "AMT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "kelet-kazahszt\u00e1ni id\u0151",
               "ALMT",
               "Alma-Ata Summer Time",
               "ALMST",
               "Alma-Ata Time",
               "ALMT",
            };
        final String[] Fiji = new String[] {
               "fidzsi t\u00e9li id\u0151",
               "FJT",
               "fidzsi ny\u00e1ri id\u0151",
               "FJST",
               "fidzsi id\u0151",
               "FJT",
            };
        final String[] Reunion = new String[] {
               "r\u00e9unioni id\u0151",
               "RET",
               "Reunion Summer Time",
               "REST",
               "Reunion Time",
               "RET",
            };
        final String[] Cocos = new String[] {
               "k\u00f3kusz-szigeteki t\u00e9li id\u0151",
               "CCT",
               "Cocos Islands Summer Time",
               "CCST",
               "Cocos Islands Time",
               "CCT",
            };
        final String[] Chatham = new String[] {
               "chathami t\u00e9li id\u0151",
               "CHAST",
               "chathami ny\u00e1ri id\u0151",
               "CHADT",
               "chathami id\u0151",
               "CHAT",
            };
        final String[] Vostok = new String[] {
               "vosztoki id\u0151",
               "VOST",
               "Vostok Summer Time",
               "VOSST",
               "Vostok Time",
               "VOST",
            };
        final String[] Argentina = new String[] {
               "argent\u00ednai t\u00e9li id\u0151",
               "ART",
               "Argent\u00ednai ny\u00e1ri id\u0151",
               "ARST",
               "argent\u00ednai id\u0151",
               "ART",
            };
        final String[] Gambier = new String[] {
               "gambieri id\u0151",
               "GAMT",
               "Gambier Summer Time",
               "GAMST",
               "Gambier Time",
               "GAMT",
            };
        final String[] Kamchatka = new String[] {
               "Petropavlovszk-kamcsatkai z\u00f3naid\u0151",
               "PETT",
               "Petropavlovszk-kamcsatkai ny\u00e1ri id\u0151",
               "PETST",
               "Petropavlovszk-kamcsatkai id\u0151",
               "PETT",
            };
        final String[] Tuvalu = new String[] {
               "tuvalui id\u0151",
               "TVT",
               "Tuvalu Summer Time",
               "TVST",
               "Tuvalu Time",
               "TVT",
            };
        final String[] Galapagos = new String[] {
               "gal\u00e1pagosi t\u00e9li id\u0151",
               "GALT",
               "Galapagos Summer Time",
               "GALST",
               "Galapagos Time",
               "GALT",
            };
        final String[] Macquarie = new String[] {
               "macquarie-szigeti t\u00e9li id\u0151",
               "MIST",
               "Macquarie Island Daylight Time",
               "MIDT",
               "Macquarie Island Time",
               "MIST",
            };
        final String[] Venezuela = new String[] {
               "venezuelai id\u0151",
               "VET",
               "Venezuela Summer Time",
               "VEST",
               "Venezuela Time",
               "VET",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "hawaii-aleuti t\u00e9li id\u0151",
               "HAST",
               "hawaii-aleuti ny\u00e1ri id\u0151",
               "HADT",
               "hawaii-aleut id\u0151z\u00f3na",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "k\u00f6z\u00e9p-ausztr\u00e1liai t\u00e9li id\u0151",
               "ACST",
               "k\u00f6z\u00e9p-ausztr\u00e1liai ny\u00e1ri id\u0151",
               "ACDT",
               "k\u00f6z\u00e9p-ausztr\u00e1liai id\u0151",
               "ACT",
            };
        final String[] America_Pacific = new String[] {
               "csendes-\u00f3ce\u00e1ni z\u00f3naid\u0151",
               "PST",
               "csendes-\u00f3ce\u00e1ni ny\u00e1ri id\u0151",
               "PDT",
               "csendes-\u00f3ce\u00e1ni id\u0151",
               "PT",
            };
        final String[] Phoenix_Islands = new String[] {
               "phoenix-szigeteki t\u00e9li id\u0151",
               "PHOT",
               "Phoenix Is. Summer Time",
               "PHOST",
               "Phoenix Is. Time",
               "PHOT",
            };
        final String[] Turkmenistan = new String[] {
               "t\u00fcrkmeniszt\u00e1ni t\u00e9li id\u0151",
               "TMT",
               "t\u00fcrkmeniszt\u00e1ni ny\u00e1ri id\u0151",
               "TMST",
               "t\u00fcrkmeniszt\u00e1ni id\u0151",
               "TMT",
            };
        final String[] Europe_Western = new String[] {
               "nyugat-eur\u00f3pai t\u00e9li id\u0151",
               "WET",
               "nyugat-eur\u00f3pai ny\u00e1ri id\u0151",
               "WEST",
               "nyugat-eur\u00f3pai id\u0151z\u00f3na",
               "WET",
            };
        final String[] Cape_Verde = new String[] {
               "z\u00f6ld-foki-szigeteki t\u00e9li id\u0151",
               "CVT",
               "z\u00f6ld-foki-szigeteki ny\u00e1ri id\u0151",
               "CVST",
               "z\u00f6ld-foki-szigeteki id\u0151z\u00f3na",
               "CVT",
            };
        final String[] Norfolk = new String[] {
               "norfolk-szigeteki id\u0151",
               "NFT",
               "Norfolk Summer Time",
               "NFST",
               "Norfolk Time",
               "NFT",
            };
        final String[] Guyana = new String[] {
               "guyanai t\u00e9li id\u0151",
               "GYT",
               "Guyana Summer Time",
               "GYST",
               "Guyana Time",
               "GYT",
            };
        final String[] Pitcairn = new String[] {
               "pitcairn-szigeteki id\u0151",
               "PST",
               "Pitcairn Daylight Time",
               "PDT",
               "Pitcairn Time",
               "PT",
            };
        final String[] Rothera = new String[] {
               "rotherai id\u0151",
               "ROTT",
               "Rothera Summer Time",
               "ROTST",
               "Rothera Time",
               "ROTT",
            };
        final String[] Samoa = new String[] {
               "szamoai t\u00e9li id\u0151",
               "SST",
               "szamoai ny\u00e1ri id\u0151",
               "SDT",
               "szamoai id\u0151",
               "ST",
            };
        final String[] Palau = new String[] {
               "palaui id\u0151",
               "PWT",
               "Palau Summer Time",
               "PWST",
               "Palau Time",
               "PWT",
            };
        final String[] Europe_Further_Eastern = new String[] {
               "minszki id\u0151",
               "MSK",
               "Moscow Daylight Time",
               "MSD",
               "Moscow Time",
               "MT",
            };
        final String[] Azerbaijan = new String[] {
               "azerbajdzs\u00e1ni t\u00e9li id\u0151",
               "AZT",
               "azerbajdzs\u00e1ni ny\u00e1ri id\u0151",
               "AZST",
               "Azerbajdzs\u00e1ni id\u0151",
               "AZT",
            };
        final String[] Mawson = new String[] {
               "mawsoni id\u0151",
               "MAWT",
               "Mawson Summer Time",
               "MAWST",
               "Mawson Time",
               "MAWT",
            };
        final String[] Mexico_Pacific = new String[] {
               "mexik\u00f3i csendes-\u00f3ce\u00e1ni z\u00f3naid\u0151",
               "MST",
               "mexik\u00f3i csendes-\u00f3ce\u00e1ni ny\u00e1ri id\u0151",
               "MDT",
               "mexik\u00f3i csendes-\u00f3ce\u00e1ni id\u0151",
               "MT",
            };
        final String[] Davis = new String[] {
               "davisi id\u0151",
               "DAVT",
               "Davis Summer Time",
               "DAVST",
               "Davis Time",
               "DAVT",
            };
        final String[] Cuba = new String[] {
               "kubai t\u00e9li id\u0151",
               "CST",
               "kubai ny\u00e1ri id\u0151",
               "CDT",
               "kubai id\u0151z\u00f3na",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "nyugat-afrikai t\u00e9li id\u0151",
               "CAT",
               "nyugat-afrikai ny\u00e1ri id\u0151",
               "CAST",
               "nyugat-afrikai id\u0151z\u00f3na",
               "CAT",
            };
        final String[] GMT = new String[] {
               "greenwichi k\u00f6z\u00e9pid\u0151, t\u00e9li id\u0151",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
            };
        final String[] Philippines = new String[] {
               "f\u00fcl\u00f6p-szigeteki t\u00e9li id\u0151",
               "PHT",
               "f\u00fcl\u00f6p-szigeteki ny\u00e1ri id\u0151",
               "PHST",
               "f\u00fcl\u00f6p-szigeteki id\u0151",
               "PHT",
            };
        final String[] French_Southern = new String[] {
               "francia d\u00e9li \u00e9s antarktiszi id\u0151",
               "TFT",
               "French Southern & Antarctic Lands Summer Time",
               "TFST",
               "French Southern & Antarctic Lands Time",
               "TFT",
            };
        final String[] South_Georgia = new String[] {
               "d\u00e9li-georgiai id\u0151",
               "GST",
               "South Georgia Daylight Time",
               "GDT",
               "South Georgia Time",
               "GT",
            };
        final String[] New_Caledonia = new String[] {
               "\u00faj-kaled\u00f3niai t\u00e9li id\u0151",
               "NCT",
               "\u00faj-kaled\u00f3niai ny\u00e1ri id\u0151",
               "NCST",
               "\u00faj-kaled\u00f3niai id\u0151",
               "NCT",
            };
        final String[] Brunei = new String[] {
               "Brunei Darussalam-i id\u0151",
               "BNT",
               "Brunei Summer Time",
               "BNST",
               "Brunei Time",
               "BNT",
            };
        final String[] Iran = new String[] {
               "ir\u00e1ni t\u00e9li id\u0151",
               "IRST",
               "ir\u00e1ni ny\u00e1ri id\u0151",
               "IRDT",
               "ir\u00e1ni id\u0151",
               "IRT",
            };
        final String[] Easter = new String[] {
               "h\u00fasv\u00e9t-szigeti t\u00e9li id\u0151",
               "EAST",
               "h\u00fasv\u00e9t-szigeti ny\u00e1ri id\u0151",
               "EASST",
               "h\u00fasv\u00e9t-szigeti id\u0151z\u00f3na",
               "EAST",
            };
        final String[] Mexico_Northwest = new String[] {
               "\u00e9szaknyugat-mexik\u00f3i z\u00f3naid\u0151",
               "PST",
               "\u00e9szaknyugat-mexik\u00f3i ny\u00e1ri id\u0151",
               "PDT",
               "\u00e9szaknyugat-mexik\u00f3i id\u0151",
               "PT",
            };
        final String[] DumontDUrville = new String[] {
               "dumont-d\u2019Urville-i id\u0151",
               "DDUT",
               "Dumont-d'Urville Summer Time",
               "DDUST",
               "Dumont-d'Urville Time",
               "DDUT",
            };
        final String[] Tajikistan = new String[] {
               "t\u00e1dzsikiszt\u00e1ni id\u0151",
               "TJT",
               "Tajikistan Summer Time",
               "TJST",
               "Tajikistan Time",
               "TJT",
            };
        final String[] Tonga = new String[] {
               "tongai t\u00e9li id\u0151",
               "TOT",
               "tongai ny\u00e1ri id\u0151",
               "TOST",
               "tongai id\u0151",
               "TOT",
            };
        final String[] Bangladesh = new String[] {
               "bangladesi t\u00e9li id\u0151",
               "BDT",
               "bangladesi ny\u00e1ri id\u0151",
               "BDST",
               "bangladesi id\u0151",
               "BDT",
            };
        final String[] Peru = new String[] {
               "perui t\u00e9li id\u0151",
               "PET",
               "perui ny\u00e1ri id\u0151",
               "PEST",
               "perui id\u0151",
               "PET",
            };
        final String[] Greenland_Western = new String[] {
               "nyugat-gr\u00f6nlandi t\u00e9li id\u0151",
               "WGT",
               "nyugat-gr\u00f6nlandi ny\u00e1ri id\u0151",
               "WGST",
               "nyugat-gr\u00f6nlandi id\u0151z\u00f3na",
               "WGT",
            };
        final String[] Ecuador = new String[] {
               "ecuadori t\u00e9li id\u0151",
               "ECT",
               "Ecuador Summer Time",
               "ECST",
               "Ecuador Time",
               "ECT",
            };
        final String[] Greenland_Eastern = new String[] {
               "kelet-gr\u00f6nlandi t\u00e9li id\u0151",
               "EGT",
               "kelet-gr\u00f6nlandi ny\u00e1ri id\u0151",
               "EGST",
               "kelet-gr\u00f6nlandi id\u0151z\u00f3na",
               "EGT",
            };
        final String[] Gulf = new String[] {
               "\u00f6b\u00f6lbeli t\u00e9li id\u0151",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "kelet-indon\u00e9ziai id\u0151",
               "WIT",
               "East Indonesia Summer Time",
               "EIST",
               "East Indonesia Time",
               "WIT",
            };
        final String[] Korea = new String[] {
               "koreai t\u00e9li id\u0151",
               "KST",
               "koreai ny\u00e1ri id\u0151",
               "KDT",
               "koreai id\u0151",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "nyugat-ausztr\u00e1liai t\u00e9li id\u0151",
               "AWST",
               "nyugat-ausztr\u00e1liai ny\u00e1ri id\u0151",
               "AWDT",
               "nyugat-ausztr\u00e1liai id\u0151",
               "AWT",
            };
        final String[] Kyrgystan = new String[] {
               "kirgiziszt\u00e1ni id\u0151",
               "KGT",
               "Kirgizstan Summer Time",
               "KGST",
               "Kirgizstan Time",
               "KGT",
            };
        final String[] Indonesia_Western = new String[] {
               "nyugat-indon\u00e9ziai t\u00e9li id\u0151",
               "WIB",
               "West Indonesia Summer Time",
               "WIST",
               "West Indonesia Time",
               "WIB",
            };
        final String[] Australia_Eastern = new String[] {
               "kelet-ausztr\u00e1liai t\u00e9li id\u0151",
               "AEST",
               "kelet-ausztr\u00e1liai ny\u00e1ri id\u0151",
               "AEDT",
               "kelet-ausztr\u00e1liai id\u0151",
               "AET",
            };
        final String[] French_Guiana = new String[] {
               "francia-guianai id\u0151",
               "GFT",
               "French Guiana Summer Time",
               "GFST",
               "French Guiana Time",
               "GFT",
            };
        final String[] Colombia = new String[] {
               "kolumbiai t\u00e9li id\u0151",
               "COT",
               "kolumbiai ny\u00e1ri id\u0151",
               "COST",
               "kolumbiai id\u0151",
               "COT",
            };
        final String[] Chile = new String[] {
               "chilei t\u00e9li id\u0151",
               "CLT",
               "chilei ny\u00e1ri id\u0151",
               "CLST",
               "chilei id\u0151z\u00f3na",
               "CLT",
            };
        final String[] Gilbert_Islands = new String[] {
               "gilbert-szigeteki id\u0151",
               "GILT",
               "Gilbert Is. Summer Time",
               "GILST",
               "Gilbert Is. Time",
               "GILT",
            };
        final String[] America_Mountain = new String[] {
               "hegyvid\u00e9ki z\u00f3naid\u0151",
               "MST",
               "hegyvid\u00e9ki ny\u00e1ri id\u0151",
               "MDT",
               "hegyvid\u00e9ki id\u0151",
               "MT",
            };
        final String[] Marquesas = new String[] {
               "marquises-szigeteki id\u0151",
               "MART",
               "Marquesas Summer Time",
               "MARST",
               "Marquesas Time",
               "MART",
            };
        final String[] Arabian = new String[] {
               "arab t\u00e9li id\u0151",
               "AST",
               "arab ny\u00e1ri id\u0151",
               "ADT",
               "arab id\u0151",
               "AT",
            };
        final String[] Alaska = new String[] {
               "alaszkai z\u00f3naid\u0151",
               "AKST",
               "alaszkai ny\u00e1ri id\u0151",
               "AKDT",
               "alaszkai id\u0151",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "vlagyivosztoki t\u00e9li id\u0151",
               "VLAT",
               "vlagyivosztoki ny\u00e1ri id\u0151",
               "VLAST",
               "vlagyivosztoki id\u0151",
               "VLAT",
            };
        final String[] Chamorro = new String[] {
               "chamorr\u00f3i t\u00e9li id\u0151",
               "ChST",
               "Chamorro Daylight Time",
               "ChDT",
               "Chamorro Time",
               "ChT",
            };
        final String[] Irkutsk = new String[] {
               "irkutszki t\u00e9li id\u0151",
               "IRKT",
               "irkutszki ny\u00e1ri id\u0151",
               "IRKST",
               "irkutszki id\u0151",
               "IRKT",
            };
        final String[] Georgia = new String[] {
               "gr\u00faziai t\u00e9li id\u0151",
               "GET",
               "gr\u00faziai ny\u00e1ri id\u0151",
               "GEST",
               "gr\u00faziai id\u0151",
               "GET",
            };
        final String[] Tokelau = new String[] {
               "tokelaui id\u0151",
               "TKT",
               "Tokelau Summer Time",
               "TKST",
               "Tokelau Time",
               "TKT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "p\u00e1pua \u00faj-guineai id\u0151",
               "PGT",
               "Papua New Guinea Summer Time",
               "PGST",
               "Papua New Guinea Time",
               "PGT",
            };
        final String[] Noronha = new String[] {
               "Fernando de Noronha-i t\u00e9li id\u0151",
               "FNT",
               "Fernando de Noronha-i ny\u00e1ri id\u0151",
               "FNST",
               "Fernando de Noronha-i id\u0151",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "csojbalszani t\u00e9li id\u0151",
               "CHOT",
               "csojbalszani ny\u00e1ri id\u0151",
               "CHOST",
               "csojbalszani id\u0151",
               "CHOT",
            };
        final String[] Brasilia = new String[] {
               "braz\u00edliai t\u00e9li id\u0151",
               "BRT",
               "braz\u00edliai ny\u00e1ri id\u0151",
               "BRST",
               "braz\u00edliai id\u0151",
               "BRT",
            };
        final String[] China = new String[] {
               "k\u00ednai t\u00e9li id\u0151",
               "CST",
               "k\u00ednai ny\u00e1ri id\u0151",
               "CDT",
               "k\u00ednai id\u0151",
               "CT",
            };
        final String[] Armenia = new String[] {
               "\u00f6rm\u00e9nyorsz\u00e1gi t\u00e9li id\u0151",
               "AMT",
               "\u00f6rm\u00e9nyorsz\u00e1gi ny\u00e1ri id\u0151",
               "AMST",
               "\u00f6rm\u00e9nyorsz\u00e1gi id\u0151",
               "AMT",
            };
        final String[] Samara = new String[] {
               "Szamarai z\u00f3naid\u0151",
               "SAMT",
               "Szamarai ny\u00e1ri id\u0151",
               "SAMST",
               "Szamarai id\u0151",
               "SAMT",
            };
        final String[] India = new String[] {
               "indiai t\u00e9li id\u0151",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Cook = new String[] {
               "cook-szigeteki t\u00e9li id\u0151",
               "CKT",
               "cook-szigeteki f\u00e9l ny\u00e1ri id\u0151",
               "CKHST",
               "cook-szigeteki id\u0151",
               "CKT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London",
                new String[] {
                    "greenwichi k\u00f6z\u00e9pid\u0151, t\u00e9li id\u0151",
                    "GMT",
                    "brit ny\u00e1ri id\u0151",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Eirunepe", Acre },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", Atlantic },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Antarctica/Syowa", Syowa },
            { "Indian/Reunion", Reunion },
            { "Pacific/Palau", Palau },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Western },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Africa/Bamako", GMT },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Pacific/Bougainville", New_Zealand },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", Alaska },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Antarctica/Troll", GMT },
            { "Europe/Samara", Samara },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "greenwichi k\u00f6z\u00e9pid\u0151, t\u00e9li id\u0151",
                    "GMT",
                    "\u00edr ny\u00e1ri id\u0151",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "Pacific/Truk", Truk },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Saipan", Chamorro },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Taipei", Taipei },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Further_Eastern },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Cancun", America_Eastern },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Rio_Branco", Acre },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Kamchatka },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Tehran", Iran },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "Asia/Srednekolymsk", Singapore },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "Australia/Lindeman", Australia_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
