/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_is extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "Mi\u00f0-Afr\u00edkut\u00edmi",
               "CAT",
               "Central African Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Moskvu",
               "MSK",
               "Sumart\u00edmi \u00ed Moskvu",
               "MSD",
               "Moskvut\u00edmi",
               "MT",
            };
        final String[] Japan = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Japan",
               "JST",
               "Sumart\u00edmi \u00ed Japan",
               "JDT",
               "Japanst\u00edmi",
               "JT",
            };
        final String[] Pakistan = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Pakistan",
               "PKT",
               "Sumart\u00edmi \u00ed Pakistan",
               "PKST",
               "Pakistant\u00edmi",
               "PKT",
            };
        final String[] Taipei = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Taipei",
               "CST",
               "Sumart\u00edmi \u00ed Taipei",
               "CDT",
               "Taipei-t\u00edmi",
               "CT",
            };
        final String[] Hovd = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Hovd",
               "HOVT",
               "Sumart\u00edmi \u00ed Hovd",
               "HOVST",
               "Hovd-t\u00edmi",
               "HOVT",
            };
        final String[] Magadan = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Magadan",
               "MAGT",
               "Sumart\u00edmi \u00ed Magadan",
               "MAGST",
               "T\u00edmi \u00ed Magadan",
               "MAGT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed mi\u00f0vesturhluta \u00c1stral\u00edu",
               "ACWST",
               "Sumart\u00edmi \u00ed mi\u00f0vesturhluta \u00c1stral\u00edu",
               "ACWDT",
               "T\u00edmi \u00ed mi\u00f0vesturhluta \u00c1stral\u00edu",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Mi\u00f0-Evr\u00f3pu",
               "CET",
               "Sumart\u00edmi \u00ed Mi\u00f0-Evr\u00f3pu",
               "CEST",
               "Mi\u00f0-Evr\u00f3put\u00edmi",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Sakhalin",
               "SAKT",
               "Sumart\u00edmi \u00ed Sakhalin",
               "SAKST",
               "T\u00edmi \u00ed Sakhalin",
               "SAKT",
            };
        final String[] Paraguay = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Paragv\u00e6",
               "PYT",
               "Sumart\u00edmi \u00ed Paragv\u00e6",
               "PYST",
               "Paragv\u00e6t\u00edmi",
               "PYT",
            };
        final String[] Malaysia = new String[] {
               "Malas\u00edut\u00edmi",
               "MYT",
               "Malaysia Summer Time",
               "MYST",
               "Malaysia Time",
               "MYT",
            };
        final String[] America_Eastern = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed austurhluta Bandar\u00edkjanna og Kanada",
               "EST",
               "Sumart\u00edmi \u00ed austurhluta Bandar\u00edkjanna og Kanada",
               "EDT",
               "T\u00edmi \u00ed austurhluta Bandar\u00edkjanna og Kanada",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 Lord Howe-eyju",
               "LHST",
               "Sumart\u00edmi \u00e1 Lord Howe-eyju",
               "LHDT",
               "T\u00edmi \u00e1 Lord Howe-eyju",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 N\u00fdja-Sj\u00e1landi",
               "NZST",
               "Sumart\u00edmi \u00e1 N\u00fdja-Sj\u00e1landi",
               "NZDT",
               "T\u00edmi \u00e1 N\u00fdja-Sj\u00e1landi",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "Indlandshafst\u00edmi",
               "IOT",
               "Indian Ocean Territory Summer Time",
               "IOST",
               "Indian Ocean Territory Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Yakutsk",
               "YAKT",
               "Sumart\u00edmi \u00ed Yakutsk",
               "YAKST",
               "T\u00edminn \u00ed Yakutsk",
               "YAKT",
            };
        final String[] Mauritius = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 M\u00e1rit\u00edus",
               "MUT",
               "Sumart\u00edmi \u00e1 M\u00e1rit\u00edus",
               "MUST",
               "M\u00e1rit\u00edust\u00edmi",
               "MUT",
            };
        final String[] Africa_Eastern = new String[] {
               "Austur-Afr\u00edkut\u00edmi",
               "EAT",
               "Eastern African Summer Time",
               "EAST",
               "Eastern Africa Time",
               "EAT",
            };
        final String[] East_Timor = new String[] {
               "T\u00edminn \u00e1 T\u00edmor-Leste",
               "TLT",
               "Timor-Leste Summer Time",
               "TLST",
               "Timor-Leste Time",
               "TLT",
            };
        final String[] Solomon = new String[] {
               "Sal\u00f3monseyjat\u00edmi",
               "SBT",
               "Solomon Is. Summer Time",
               "SBST",
               "Solomon Is. Time",
               "SBT",
            };
        final String[] Kosrae = new String[] {
               "Kosrae-t\u00edmi",
               "KOST",
               "Kosrae Summer Time",
               "KOSST",
               "Kosrae Time",
               "KOST",
            };
        final String[] Marshall_Islands = new String[] {
               "T\u00edmi \u00e1 Marshall-eyjum",
               "MHT",
               "Marshall Islands Summer Time",
               "MHST",
               "Marshall Islands Time",
               "MHT",
            };
        final String[] Europe_Eastern = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Austur-Evr\u00f3pu",
               "EET",
               "Sumart\u00edmi \u00ed Austur-Evr\u00f3pu",
               "EEST",
               "Austur-Evr\u00f3put\u00edmi",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 N\u00fdfundnalandi",
               "NST",
               "Sumart\u00edmi \u00e1 N\u00fdfundnalandi",
               "NDT",
               "T\u00edmi \u00e1 N\u00fdfundnalandi",
               "NT",
            };
        final String[] Afghanistan = new String[] {
               "Afganistant\u00edmi",
               "AFT",
               "Afghanistan Summer Time",
               "AFST",
               "Afghanistan Time",
               "AFT",
            };
        final String[] Hong_Kong = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Hong Kong",
               "HKT",
               "Sumart\u00edmi \u00ed Hong Kong",
               "HKST",
               "Hong Kong-t\u00edmi",
               "HKT",
            };
        final String[] Argentina_Western = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Vestur-Argent\u00ednu",
               "ART",
               "Sumart\u00edmi \u00ed Vestur-Argent\u00ednu",
               "ARST",
               "Vestur-Argent\u00ednut\u00edmi",
               "ART",
            };
        final String[] Atlantic = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 Atlantshafssv\u00e6\u00f0inu",
               "AST",
               "Sumart\u00edmi \u00e1 Atlantshafssv\u00e6\u00f0inu",
               "ADT",
               "T\u00edmi \u00e1 Atlantshafssv\u00e6\u00f0inu",
               "AT",
            };
        final String[] Ponape = new String[] {
               "Ponape-t\u00edmi",
               "PONT",
               "Pohnpei Summer Time",
               "PONST",
               "Ponape Time",
               "PONT",
            };
        final String[] Bolivia = new String[] {
               "B\u00f3liv\u00edut\u00edmi",
               "BOT",
               "Bolivia Summer Time",
               "BOST",
               "Bolivia Time",
               "BOT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 Sankti Pierre og Miquelon",
               "PMST",
               "Sumart\u00edmi \u00e1 Sankti Pierre og Miquelon",
               "PMDT",
               "T\u00edmi \u00e1 Sankti Pierre og Miquelon",
               "PMT",
            };
        final String[] Indochina = new String[] {
               "Ind\u00f3k\u00ednat\u00edmi",
               "ICT",
               "Indochina Summer Time",
               "ICST",
               "Indochina Time",
               "ICT",
            };
        final String[] Yekaterinburg = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Yekaterinborg",
               "YEKT",
               "Sumart\u00edmi \u00ed Yekaterinburg",
               "YEKST",
               "T\u00edmi \u00ed Yekaterinburg",
               "YEKT",
            };
        final String[] Maldives = new String[] {
               "Mald\u00edveyja-t\u00edmi",
               "MVT",
               "Maldives Summer Time",
               "MVST",
               "Maldives Time",
               "MVT",
            };
        final String[] Tahiti = new String[] {
               "Tah\u00edt\u00ed-t\u00edmi",
               "TAHT",
               "Tahiti Summer Time",
               "TAHST",
               "Tahiti Time",
               "TAHT",
            };
        final String[] Israel = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed \u00cdsrael",
               "IST",
               "Sumart\u00edmi \u00ed \u00cdsrael",
               "IDT",
               "\u00cdsraelst\u00edmi",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "Mi\u00f0-Ind\u00f3nes\u00edut\u00edmi",
               "WITA",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "WITA",
            };
        final String[] Wallis = new String[] {
               "T\u00edmi \u00e1 Wallis- og F\u00fat\u00fanaeyjum",
               "WFT",
               "Wallis & Futuna Summer Time",
               "WFST",
               "Wallis & Futuna Time",
               "WFT",
            };
        final String[] Africa_Southern = new String[] {
               "Su\u00f0ur-Afr\u00edkut\u00edmi",
               "SAST",
               "South Africa Summer Time",
               "SAST",
               "South Africa Time",
               "SAT",
            };
        final String[] Syowa = new String[] {
               "Syowa-t\u00edmi",
               "SYOT",
               "Syowa Summer Time",
               "SYOST",
               "Syowa Time",
               "SYOT",
            };
        final String[] Line_Islands = new String[] {
               "L\u00ednueyja-t\u00edmi",
               "LINT",
               "Line Is. Summer Time",
               "LINST",
               "Line Is. Time",
               "LINT",
            };
        final String[] Uzbekistan = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed \u00dasbekistan",
               "UZT",
               "Sumart\u00edmi \u00ed \u00dasbekistan",
               "UZST",
               "\u00dasbekistan-t\u00edmi",
               "UZT",
            };
        final String[] Omsk = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Omsk",
               "OMST",
               "Sumart\u00edmi \u00ed Omsk",
               "OMSST",
               "T\u00edminn \u00ed Omsk",
               "OMST",
            };
        final String[] Seychelles = new String[] {
               "Seychelles-eyjat\u00edmi",
               "SCT",
               "Seychelles Summer Time",
               "SCST",
               "Seychelles Time",
               "SCT",
            };
        final String[] Uruguay = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed \u00dar\u00fagv\u00e6",
               "UYT",
               "Sumart\u00edmi \u00ed \u00dar\u00fagv\u00e6",
               "UYST",
               "\u00dar\u00fagv\u00e6t\u00edmi",
               "UYT",
            };
        final String[] Nepal = new String[] {
               "Nepalt\u00edmi",
               "NPT",
               "Nepal Summer Time",
               "NPST",
               "Nepal Time",
               "NPT",
            };
        final String[] Mongolia = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed \u00dalan Bator",
               "ULAT",
               "Sumart\u00edmi \u00ed \u00dalan Bator",
               "ULAST",
               "T\u00edmi \u00ed \u00dalan Bator",
               "ULAT",
            };
        final String[] America_Central = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed mi\u00f0hluta Bandar\u00edkjanna og Kanada",
               "CST",
               "Sumart\u00edmi \u00ed mi\u00f0hluta Bandar\u00edkjanna og Kanada",
               "CDT",
               "T\u00edmi \u00ed mi\u00f0hluta Bandar\u00edkjanna og Kanada",
               "CT",
            };
        final String[] Truk = new String[] {
               "Chuuk-t\u00edmi",
               "CHUT",
               "Chuuk Summer Time",
               "CHUST",
               "Chuuk Time",
               "CHUT",
            };
        final String[] Niue = new String[] {
               "Niue-t\u00edmi",
               "NUT",
               "Niue Summer Time",
               "NUST",
               "Niue Time",
               "NUT",
            };
        final String[] Wake = new String[] {
               "T\u00edmi \u00e1 Wake-eyju",
               "WAKT",
               "Wake Summer Time",
               "WAKST",
               "Wake Time",
               "WAKT",
            };
        final String[] Falkland = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 Falklandseyjum",
               "FKT",
               "Sumart\u00edmi \u00e1 Falklandseyjum",
               "FKST",
               "Falklandseyjat\u00edmi",
               "FKT",
            };
        final String[] Vanuatu = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 Van\u00faat\u00fa",
               "VUT",
               "Sumart\u00edmi \u00e1 Van\u00faat\u00fa",
               "VUST",
               "Van\u00faat\u00fa-t\u00edmi",
               "VUT",
            };
        final String[] Novosibirsk = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Novosibirsk",
               "NOVT",
               "Sumart\u00edmi \u00ed Novosibirsk",
               "NOVST",
               "T\u00edmi \u00ed Novosibirsk",
               "NOVT",
            };
        final String[] Singapore = new String[] {
               "Singap\u00fart\u00edmi",
               "SRET",
               "Srednekolymsk Daylight Time",
               "SREDT",
               "Srednekolymsk Time",
               "SRET",
            };
        final String[] Azores = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 As\u00f3reyjum",
               "AZOT",
               "Sumart\u00edmi \u00e1 As\u00f3reyjum",
               "AZOST",
               "As\u00f3reyjat\u00edmi",
               "AZOT",
            };
        final String[] Apia = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Ap\u00eda",
               "WSST",
               "Sumart\u00edmi \u00ed Ap\u00eda",
               "WSDT",
               "T\u00edmi \u00ed Ap\u00eda",
               "WST",
            };
        final String[] Bhutan = new String[] {
               "B\u00fatant\u00edmi",
               "BTT",
               "Bhutan Summer Time",
               "BTST",
               "Bhutan Time",
               "BTT",
            };
        final String[] Suriname = new String[] {
               "S\u00farinamt\u00edmi",
               "SRT",
               "Suriname Summer Time",
               "SRST",
               "Suriname Time",
               "SRT",
            };
        final String[] Nauru = new String[] {
               "N\u00e1r\u00fa-t\u00edmi",
               "NRT",
               "Nauru Summer Time",
               "NRST",
               "Nauru Time",
               "NRT",
            };
        final String[] Krasnoyarsk = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Krasnoyarsk",
               "KRAT",
               "Sumart\u00edmi \u00ed Krasnoyarsk",
               "KRAST",
               "T\u00edmi \u00ed Krasnoyarsk",
               "KRAT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "T\u00edmi \u00ed Vestur-Kasakstan",
               "AQTT",
               "Aqtau Summer Time",
               "AQTST",
               "Aqtau Time",
               "AQTT",
            };
        final String[] Myanmar = new String[] {
               "Mjanmar-t\u00edmi",
               "MMT",
               "Myanmar Summer Time",
               "MMST",
               "Myanmar Time",
               "MMT",
            };
        final String[] Christmas = new String[] {
               "J\u00f3laeyjart\u00edmi",
               "CXT",
               "Christmas Island Summer Time",
               "CXST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Amazon = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 Amas\u00f3nsv\u00e6\u00f0inu",
               "AMT",
               "Sumart\u00edmi \u00e1 Amas\u00f3nsv\u00e6\u00f0inu",
               "AMST",
               "Amas\u00f3nt\u00edmi",
               "AMT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "T\u00edmi \u00ed Austur-Kasakstan",
               "ALMT",
               "Alma-Ata Summer Time",
               "ALMST",
               "Alma-Ata Time",
               "ALMT",
            };
        final String[] Fiji = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 F\u00eddj\u00edeyjum",
               "FJT",
               "Sumart\u00edmi \u00e1 F\u00eddj\u00edeyjum",
               "FJST",
               "F\u00eddj\u00edeyjat\u00edmi",
               "FJT",
            };
        final String[] Reunion = new String[] {
               "R\u00e9union-t\u00edmi",
               "RET",
               "Reunion Summer Time",
               "REST",
               "Reunion Time",
               "RET",
            };
        final String[] Cocos = new String[] {
               "K\u00f3koseyjat\u00edmi",
               "CCT",
               "Cocos Islands Summer Time",
               "CCST",
               "Cocos Islands Time",
               "CCT",
            };
        final String[] Chatham = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Chatham",
               "CHAST",
               "Sumart\u00edmi \u00ed Chatham",
               "CHADT",
               "Chatham-t\u00edmi",
               "CHAT",
            };
        final String[] Vostok = new String[] {
               "Vostok-t\u00edmi",
               "VOST",
               "Vostok Summer Time",
               "VOSST",
               "Vostok Time",
               "VOST",
            };
        final String[] Argentina = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Argent\u00ednu",
               "ART",
               "Sumart\u00edmi \u00ed Argent\u00ednu",
               "ARST",
               "Argent\u00ednut\u00edmi",
               "ART",
            };
        final String[] Gambier = new String[] {
               "Gambier-t\u00edmi",
               "GAMT",
               "Gambier Summer Time",
               "GAMST",
               "Gambier Time",
               "GAMT",
            };
        final String[] Kamchatka = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Petropavlovsk-Kamchatski",
               "PETT",
               "Sumart\u00edmi \u00ed Petropavlovsk-Kamchatski",
               "PETST",
               "T\u00edmi \u00ed Petropavlovsk-Kamchatski",
               "PETT",
            };
        final String[] Tuvalu = new String[] {
               "T\u00faval\u00fat\u00edmi",
               "TVT",
               "Tuvalu Summer Time",
               "TVST",
               "Tuvalu Time",
               "TVT",
            };
        final String[] Galapagos = new String[] {
               "Galapagos-t\u00edmi",
               "GALT",
               "Galapagos Summer Time",
               "GALST",
               "Galapagos Time",
               "GALT",
            };
        final String[] Macquarie = new String[] {
               "Macquarie-eyjart\u00edmi",
               "MIST",
               "Macquarie Island Daylight Time",
               "MIDT",
               "Macquarie Island Time",
               "MIST",
            };
        final String[] Venezuela = new String[] {
               "Venes\u00faelat\u00edmi",
               "VET",
               "Venezuela Summer Time",
               "VEST",
               "Venezuela Time",
               "VET",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 Hava\u00ed og Ale\u00fata",
               "HAST",
               "Sumart\u00edmi \u00e1 Hava\u00ed og Ale\u00fata",
               "HADT",
               "T\u00edmi \u00e1 Hava\u00ed og Ale\u00fata",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Mi\u00f0-\u00c1stral\u00edu",
               "ACST",
               "Sumart\u00edmi \u00ed Mi\u00f0-\u00c1stral\u00edu",
               "ACDT",
               "T\u00edmi \u00ed Mi\u00f0-\u00c1stral\u00edu",
               "ACT",
            };
        final String[] America_Pacific = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 Kyrrahafssv\u00e6\u00f0inu",
               "PST",
               "Sumart\u00edmi \u00e1 Kyrrahafssv\u00e6\u00f0inu",
               "PDT",
               "T\u00edmi \u00e1 Kyrrahafssv\u00e6\u00f0inu",
               "PT",
            };
        final String[] Phoenix_Islands = new String[] {
               "F\u00f6nixeyjat\u00edmi",
               "PHOT",
               "Phoenix Is. Summer Time",
               "PHOST",
               "Phoenix Is. Time",
               "PHOT",
            };
        final String[] Turkmenistan = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed T\u00farkmenistan",
               "TMT",
               "Sumart\u00edmi \u00ed T\u00farkmenistan",
               "TMST",
               "T\u00farkmenistan-t\u00edmi",
               "TMT",
            };
        final String[] Europe_Western = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Vestur-Evr\u00f3pu",
               "WET",
               "Sumart\u00edmi \u00ed Vestur-Evr\u00f3pu",
               "WEST",
               "Vestur-Evr\u00f3put\u00edmi",
               "WET",
            };
        final String[] Cape_Verde = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 Gr\u00e6nh\u00f6f\u00f0aeyjum",
               "CVT",
               "Sumart\u00edmi \u00e1 Gr\u00e6nh\u00f6f\u00f0aeyjum",
               "CVST",
               "Gr\u00e6nh\u00f6f\u00f0aeyjat\u00edmi",
               "CVT",
            };
        final String[] Norfolk = new String[] {
               "T\u00edmi \u00e1 Norfolk-eyju",
               "NFT",
               "Norfolk Summer Time",
               "NFST",
               "Norfolk Time",
               "NFT",
            };
        final String[] Guyana = new String[] {
               "Gv\u00e6janat\u00edmi",
               "GYT",
               "Guyana Summer Time",
               "GYST",
               "Guyana Time",
               "GYT",
            };
        final String[] Pitcairn = new String[] {
               "Pitcairn-t\u00edmi",
               "PST",
               "Pitcairn Daylight Time",
               "PDT",
               "Pitcairn Time",
               "PT",
            };
        final String[] Rothera = new String[] {
               "Rothera-t\u00edmi",
               "ROTT",
               "Rothera Summer Time",
               "ROTST",
               "Rothera Time",
               "ROTT",
            };
        final String[] Samoa = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 Sam\u00f3a",
               "SST",
               "Sumart\u00edmi \u00e1 Sam\u00f3a",
               "SDT",
               "Sam\u00f3a-t\u00edmi",
               "ST",
            };
        final String[] Palau = new String[] {
               "Pal\u00e1t\u00edmi",
               "PWT",
               "Palau Summer Time",
               "PWST",
               "Palau Time",
               "PWT",
            };
        final String[] Europe_Further_Eastern = new String[] {
               "Sta\u00f0art\u00edmi Kal\u00edn\u00edngrad",
               "MSK",
               "Moscow Daylight Time",
               "MSD",
               "Moscow Time",
               "MT",
            };
        final String[] Azerbaijan = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Aserba\u00eddsjan",
               "AZT",
               "Sumart\u00edmi \u00ed Aserba\u00eddsjan",
               "AZST",
               "Aserba\u00eddsjant\u00edmi",
               "AZT",
            };
        final String[] Mawson = new String[] {
               "Mawson-t\u00edmi",
               "MAWT",
               "Mawson Summer Time",
               "MAWST",
               "Mawson Time",
               "MAWT",
            };
        final String[] Mexico_Pacific = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Mex\u00edk\u00f3 \u00e1 Kyrrahafssv\u00e6\u00f0inu",
               "MST",
               "Sumart\u00edmi \u00ed Mex\u00edk\u00f3 \u00e1 Kyrrahafssv\u00e6\u00f0inu",
               "MDT",
               "Kyrrahafst\u00edmi \u00ed Mex\u00edk\u00f3",
               "MT",
            };
        final String[] Davis = new String[] {
               "Davis-t\u00edmi",
               "DAVT",
               "Davis Summer Time",
               "DAVST",
               "Davis Time",
               "DAVT",
            };
        final String[] Cuba = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 K\u00fabu",
               "CST",
               "Sumart\u00edmi \u00e1 K\u00fabu",
               "CDT",
               "K\u00fabut\u00edmi",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Vestur-Afr\u00edku",
               "CAT",
               "Sumart\u00edmi \u00ed Vestur-Afr\u00edku",
               "CAST",
               "Vestur-Afr\u00edkut\u00edmi",
               "CAT",
            };
        final String[] GMT = new String[] {
               "Greenwich-sta\u00f0alt\u00edmi",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
            };
        final String[] Philippines = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 Filippseyjum",
               "PHT",
               "Sumart\u00edmi \u00e1 Filippseyjum",
               "PHST",
               "Filippseyjat\u00edmi",
               "PHT",
            };
        final String[] French_Southern = new String[] {
               "T\u00edmi \u00e1 fr\u00f6nsku su\u00f0urhafssv\u00e6\u00f0um og Su\u00f0urskautslandssv\u00e6\u00f0i",
               "TFT",
               "French Southern & Antarctic Lands Summer Time",
               "TFST",
               "French Southern & Antarctic Lands Time",
               "TFT",
            };
        final String[] South_Georgia = new String[] {
               "Su\u00f0ur-Georg\u00edut\u00edmi",
               "GST",
               "South Georgia Daylight Time",
               "GDT",
               "South Georgia Time",
               "GT",
            };
        final String[] New_Caledonia = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed N\u00fdju-Kaled\u00f3n\u00edu",
               "NCT",
               "Sumart\u00edmi \u00ed N\u00fdju-Kaled\u00f3n\u00edu",
               "NCST",
               "T\u00edmi \u00ed N\u00fdju-Kaled\u00f3n\u00edu",
               "NCT",
            };
        final String[] Brunei = new String[] {
               "Br\u00faneit\u00edmi",
               "BNT",
               "Brunei Summer Time",
               "BNST",
               "Brunei Time",
               "BNT",
            };
        final String[] Iran = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed \u00cdran",
               "IRST",
               "Sumart\u00edmi \u00ed \u00cdran",
               "IRDT",
               "\u00cdranst\u00edmi",
               "IRT",
            };
        final String[] Easter = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 P\u00e1skaeyju",
               "EAST",
               "Sumart\u00edmi \u00e1 P\u00e1skaeyju",
               "EASST",
               "P\u00e1skaeyjut\u00edmi",
               "EAST",
            };
        final String[] Mexico_Northwest = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Nor\u00f0vestur-Mex\u00edk\u00f3",
               "PST",
               "Sumart\u00edmi \u00ed Nor\u00f0vestur-Mex\u00edk\u00f3",
               "PDT",
               "T\u00edmi \u00ed Nor\u00f0vestur-Mex\u00edk\u00f3",
               "PT",
            };
        final String[] DumontDUrville = new String[] {
               "T\u00edmi \u00e1 Dumont-d\u2019Urville",
               "DDUT",
               "Dumont-d'Urville Summer Time",
               "DDUST",
               "Dumont-d'Urville Time",
               "DDUT",
            };
        final String[] Tajikistan = new String[] {
               "Tadsj\u00edkistan-t\u00edmi",
               "TJT",
               "Tajikistan Summer Time",
               "TJST",
               "Tajikistan Time",
               "TJT",
            };
        final String[] Tonga = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 Tonga",
               "TOT",
               "Sumart\u00edmi \u00e1 Tonga",
               "TOST",
               "Tongat\u00edmi",
               "TOT",
            };
        final String[] Bangladesh = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Bangladess",
               "BDT",
               "Sumart\u00edmi \u00ed Bangladess",
               "BDST",
               "Bangladess-t\u00edmi",
               "BDT",
            };
        final String[] Peru = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Per\u00fa",
               "PET",
               "Sumart\u00edmi \u00ed Per\u00fa",
               "PEST",
               "Per\u00fat\u00edmi",
               "PET",
            };
        final String[] Greenland_Western = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 Vestur-Gr\u00e6nlandi",
               "WGT",
               "Sumart\u00edmi \u00e1 Vestur-Gr\u00e6nlandi",
               "WGST",
               "Vestur-Gr\u00e6nlandst\u00edmi",
               "WGT",
            };
        final String[] Ecuador = new String[] {
               "Ekvadort\u00edmi",
               "ECT",
               "Ecuador Summer Time",
               "ECST",
               "Ecuador Time",
               "ECT",
            };
        final String[] Greenland_Eastern = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 Austur-Gr\u00e6nlandi",
               "EGT",
               "Sumart\u00edmi \u00e1 Austur-Gr\u00e6nlandi",
               "EGST",
               "Austur-Gr\u00e6nlandst\u00edmi",
               "EGT",
            };
        final String[] Gulf = new String[] {
               "Sta\u00f0alt\u00edmi vi\u00f0 Persafl\u00f3a",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Austur-Ind\u00f3nes\u00edut\u00edmi",
               "WIT",
               "East Indonesia Summer Time",
               "EIST",
               "East Indonesia Time",
               "WIT",
            };
        final String[] Korea = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed K\u00f3reu",
               "KST",
               "Sumart\u00edmi \u00ed K\u00f3reu",
               "KDT",
               "K\u00f3reut\u00edmi",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Vestur-\u00c1stral\u00edu",
               "AWST",
               "Sumart\u00edmi \u00ed Vestur-\u00c1stral\u00edu",
               "AWDT",
               "T\u00edmi \u00ed Vestur-\u00c1stral\u00edu",
               "AWT",
            };
        final String[] Kyrgystan = new String[] {
               "Kirgistan-t\u00edmi",
               "KGT",
               "Kirgizstan Summer Time",
               "KGST",
               "Kirgizstan Time",
               "KGT",
            };
        final String[] Indonesia_Western = new String[] {
               "Vestur-Ind\u00f3nes\u00edut\u00edmi",
               "WIB",
               "West Indonesia Summer Time",
               "WIST",
               "West Indonesia Time",
               "WIB",
            };
        final String[] Australia_Eastern = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Austur-\u00c1stral\u00edu",
               "AEST",
               "Sumart\u00edmi \u00ed Austur-\u00c1stral\u00edu",
               "AEDT",
               "T\u00edmi \u00ed Austur-\u00c1stral\u00edu",
               "AET",
            };
        final String[] French_Guiana = new String[] {
               "T\u00edmi \u00ed Fr\u00f6nsku Gv\u00e6jana",
               "GFT",
               "French Guiana Summer Time",
               "GFST",
               "French Guiana Time",
               "GFT",
            };
        final String[] Colombia = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed K\u00f3lumb\u00edu",
               "COT",
               "Sumart\u00edmi \u00ed K\u00f3lumb\u00edu",
               "COST",
               "K\u00f3lumb\u00edut\u00edmi",
               "COT",
            };
        final String[] Chile = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed S\u00edle",
               "CLT",
               "Sumart\u00edmi \u00ed S\u00edle",
               "CLST",
               "S\u00edlet\u00edmi",
               "CLT",
            };
        final String[] Gilbert_Islands = new String[] {
               "T\u00edmi \u00e1 Gilbert-eyjum",
               "GILT",
               "Gilbert Is. Summer Time",
               "GILST",
               "Gilbert Is. Time",
               "GILT",
            };
        final String[] America_Mountain = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Klettafj\u00f6llum",
               "MST",
               "Sumart\u00edmi \u00ed Klettafj\u00f6llum",
               "MDT",
               "T\u00edmi \u00ed Klettafj\u00f6llum",
               "MT",
            };
        final String[] Marquesas = new String[] {
               "T\u00edmi \u00e1 Markgreifafr\u00fareyjum",
               "MART",
               "Marquesas Summer Time",
               "MARST",
               "Marquesas Time",
               "MART",
            };
        final String[] Arabian = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Arab\u00edu",
               "AST",
               "Sumart\u00edmi \u00ed Arab\u00edu",
               "ADT",
               "Arab\u00edut\u00edmi",
               "AT",
            };
        final String[] Alaska = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Alaska",
               "AKST",
               "Sumart\u00edmi \u00ed Alaska",
               "AKDT",
               "T\u00edmi \u00ed Alaska",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Vladivostok",
               "VLAT",
               "Sumart\u00edmi \u00ed Vladivostok",
               "VLAST",
               "T\u00edmi \u00ed Vladivostok",
               "VLAT",
            };
        final String[] Chamorro = new String[] {
               "Chamorro-sta\u00f0alt\u00edmi",
               "ChST",
               "Chamorro Daylight Time",
               "ChDT",
               "Chamorro Time",
               "ChT",
            };
        final String[] Irkutsk = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Irkutsk",
               "IRKT",
               "Sumart\u00edmi \u00ed Irkutsk",
               "IRKST",
               "T\u00edmi \u00ed Irkutsk",
               "IRKT",
            };
        final String[] Georgia = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Georg\u00edu",
               "GET",
               "Sumart\u00edmi \u00ed Georg\u00edu",
               "GEST",
               "Georg\u00edut\u00edmi",
               "GET",
            };
        final String[] Tokelau = new String[] {
               "T\u00f3kel\u00e1-t\u00edmi",
               "TKT",
               "Tokelau Summer Time",
               "TKST",
               "Tokelau Time",
               "TKT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "T\u00edmi \u00e1 Pap\u00faa N\u00fdju-G\u00edneu",
               "PGT",
               "Papua New Guinea Summer Time",
               "PGST",
               "Papua New Guinea Time",
               "PGT",
            };
        final String[] Noronha = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Fernando de Noronha",
               "FNT",
               "Sumart\u00edmi \u00ed Fernando de Noronha",
               "FNST",
               "T\u00edmi \u00ed Fernando de Noronha",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Choibalsan",
               "CHOT",
               "Sumart\u00edmi \u00ed Choibalsan",
               "CHOST",
               "T\u00edmi \u00ed Choibalsan",
               "CHOT",
            };
        final String[] Brasilia = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Brasil\u00edu",
               "BRT",
               "Sumart\u00edmi \u00ed Brasil\u00edu",
               "BRST",
               "Brasil\u00edut\u00edmi",
               "BRT",
            };
        final String[] China = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed K\u00edna",
               "CST",
               "Sumart\u00edmi \u00ed K\u00edna",
               "CDT",
               "K\u00ednat\u00edmi",
               "CT",
            };
        final String[] Armenia = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Armen\u00edu",
               "AMT",
               "Sumart\u00edmi \u00ed Armen\u00edu",
               "AMST",
               "Armen\u00edut\u00edmi",
               "AMT",
            };
        final String[] Samara = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Samara",
               "SAMT",
               "Sumart\u00edmi \u00ed Samara",
               "SAMST",
               "T\u00edmi \u00ed Samara",
               "SAMT",
            };
        final String[] India = new String[] {
               "Indlandst\u00edmi",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Cook = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 Cooks-eyjum",
               "CKT",
               "H\u00e1lfsumart\u00edmi \u00e1 Cooks-eyjum",
               "CKHST",
               "Cooks-eyjat\u00edmi",
               "CKT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London",
                new String[] {
                    "Greenwich-sta\u00f0alt\u00edmi",
                    "GMT",
                    "Sumart\u00edmi \u00ed Bretlandi",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", Atlantic },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Antarctica/Syowa", Syowa },
            { "Indian/Reunion", Reunion },
            { "Pacific/Palau", Palau },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Western },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Africa/Bamako", GMT },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Pacific/Bougainville", New_Zealand },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", Alaska },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Antarctica/Troll", GMT },
            { "Europe/Samara", Samara },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "Greenwich-sta\u00f0alt\u00edmi",
                    "GMT",
                    "Sumart\u00edmi \u00e1 \u00cdrlandi",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "Pacific/Truk", Truk },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Saipan", Chamorro },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Taipei", Taipei },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Further_Eastern },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Cancun", America_Eastern },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Kamchatka },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Tehran", Iran },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "Asia/Srednekolymsk", Singapore },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "Australia/Lindeman", Australia_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
