/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_pt extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "Hor\u00e1rio da \u00c1frica Central",
               "CAT",
               "Central African Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Moscou",
               "MSK",
               "Hor\u00e1rio de Ver\u00e3o de Moscou",
               "MSD",
               "Hor\u00e1rio de Moscou",
               "MT",
            };
        final String[] Japan = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Jap\u00e3o",
               "JST",
               "Hor\u00e1rio de Ver\u00e3o do Jap\u00e3o",
               "JDT",
               "Hor\u00e1rio do Jap\u00e3o",
               "JT",
            };
        final String[] Pakistan = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Paquist\u00e3o",
               "PKT",
               "Hor\u00e1rio de Ver\u00e3o do Paquist\u00e3o",
               "PKST",
               "Hor\u00e1rio do Paquist\u00e3o",
               "PKT",
            };
        final String[] Taipei = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Taipei",
               "CST",
               "Hor\u00e1rio de Ver\u00e3o de Taipei",
               "CDT",
               "Hor\u00e1rio de Taipei",
               "CT",
            };
        final String[] Hovd = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Hovd",
               "HOVT",
               "Hor\u00e1rio de Ver\u00e3o de Hovd",
               "HOVST",
               "Hor\u00e1rio de Hovd",
               "HOVT",
            };
        final String[] Magadan = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Magadan",
               "MAGT",
               "Hor\u00e1rio de Ver\u00e3o de Magadan",
               "MAGST",
               "Hor\u00e1rio de Magadan",
               "MAGT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Austr\u00e1lia Centro-Ocidental",
               "ACWST",
               "Hor\u00e1rio de Ver\u00e3o da Austr\u00e1lia Centro-Ocidental",
               "ACWDT",
               "Hor\u00e1rio da Austr\u00e1lia Centro-Ocidental",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Europa Central",
               "CET",
               "Hor\u00e1rio de Ver\u00e3o da Europa Central",
               "CEST",
               "Hor\u00e1rio da Europa Central",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Sacalina",
               "SAKT",
               "Hor\u00e1rio de Ver\u00e3o de Sacalina",
               "SAKST",
               "Hor\u00e1rio de Sacalina",
               "SAKT",
            };
        final String[] Paraguay = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Paraguai",
               "PYT",
               "Hor\u00e1rio de Ver\u00e3o do Paraguai",
               "PYST",
               "Hor\u00e1rio do Paraguai",
               "PYT",
            };
        final String[] Acre = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Acre",
               "ACT",
               "Hor\u00e1rio de Ver\u00e3o do Acre",
               "ACST",
               "Hor\u00e1rio do Acre",
               "ACT",
            };
        final String[] Malaysia = new String[] {
               "Hor\u00e1rio da Mal\u00e1sia",
               "MYT",
               "Malaysia Summer Time",
               "MYST",
               "Malaysia Time",
               "MYT",
            };
        final String[] America_Eastern = new String[] {
               "Hor\u00e1rio Padr\u00e3o Oriental",
               "EST",
               "Hor\u00e1rio de Ver\u00e3o Oriental",
               "EDT",
               "Hor\u00e1rio Oriental",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Lord Howe",
               "LHST",
               "Hor\u00e1rio de Ver\u00e3o de Lord Howe",
               "LHDT",
               "Hor\u00e1rio de Lord Howe",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Nova Zel\u00e2ndia",
               "NZST",
               "Hor\u00e1rio de Ver\u00e3o da Nova Zel\u00e2ndia",
               "NZDT",
               "Hor\u00e1rio da Nova Zel\u00e2ndia",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "Hor\u00e1rio do Oceano \u00cdndico",
               "IOT",
               "Indian Ocean Territory Summer Time",
               "IOST",
               "Indian Ocean Territory Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Yakutsk",
               "YAKT",
               "Hor\u00e1rio de Ver\u00e3o de Yakutsk",
               "YAKST",
               "Hor\u00e1rio de Yakutsk",
               "YAKT",
            };
        final String[] Mauritius = new String[] {
               "Hor\u00e1rio Padr\u00e3o das Ilhas Maur\u00edcio",
               "MUT",
               "Hor\u00e1rio de Ver\u00e3o das Ilhas Maur\u00edcio",
               "MUST",
               "Hor\u00e1rio das Ilhas Maur\u00edcio",
               "MUT",
            };
        final String[] Africa_Eastern = new String[] {
               "Hor\u00e1rio da \u00c1frica Oriental",
               "EAT",
               "Eastern African Summer Time",
               "EAST",
               "Eastern Africa Time",
               "EAT",
            };
        final String[] East_Timor = new String[] {
               "Hor\u00e1rio do Timor-Leste",
               "TLT",
               "Timor-Leste Summer Time",
               "TLST",
               "Timor-Leste Time",
               "TLT",
            };
        final String[] Solomon = new String[] {
               "Hor\u00e1rio das Ilhas Salom\u00e3o",
               "SBT",
               "Solomon Is. Summer Time",
               "SBST",
               "Solomon Is. Time",
               "SBT",
            };
        final String[] Kosrae = new String[] {
               "Hor\u00e1rio de Kosrae",
               "KOST",
               "Kosrae Summer Time",
               "KOSST",
               "Kosrae Time",
               "KOST",
            };
        final String[] Marshall_Islands = new String[] {
               "Hor\u00e1rio das Ilhas Marshall",
               "MHT",
               "Marshall Islands Summer Time",
               "MHST",
               "Marshall Islands Time",
               "MHT",
            };
        final String[] Europe_Eastern = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Europa Oriental",
               "EET",
               "Hor\u00e1rio de Ver\u00e3o da Europa Oriental",
               "EEST",
               "Hor\u00e1rio da Europa Oriental",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Terra Nova",
               "NST",
               "Hor\u00e1rio de Ver\u00e3o de Terra Nova",
               "NDT",
               "Hor\u00e1rio de Terra Nova",
               "NT",
            };
        final String[] Afghanistan = new String[] {
               "Hor\u00e1rio do Afeganist\u00e3o",
               "AFT",
               "Afghanistan Summer Time",
               "AFST",
               "Afghanistan Time",
               "AFT",
            };
        final String[] Hong_Kong = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Hong Kong",
               "HKT",
               "Hor\u00e1rio de Ver\u00e3o de Hong Kong",
               "HKST",
               "Hor\u00e1rio de Hong Kong",
               "HKT",
            };
        final String[] Argentina_Western = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Argentina Ocidental",
               "ART",
               "Hor\u00e1rio de Ver\u00e3o da Argentina Ocidental",
               "ARST",
               "Hor\u00e1rio da Argentina Ocidental",
               "ART",
            };
        final String[] Atlantic = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Atl\u00e2ntico",
               "AST",
               "Hor\u00e1rio de Ver\u00e3o do Atl\u00e2ntico",
               "ADT",
               "Hor\u00e1rio do Atl\u00e2ntico",
               "AT",
            };
        final String[] Ponape = new String[] {
               "Hor\u00e1rio de Ponape",
               "PONT",
               "Pohnpei Summer Time",
               "PONST",
               "Ponape Time",
               "PONT",
            };
        final String[] Bolivia = new String[] {
               "Hor\u00e1rio da Bol\u00edvia",
               "BOT",
               "Bolivia Summer Time",
               "BOST",
               "Bolivia Time",
               "BOT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Saint Pierre e Miquelon",
               "PMST",
               "Hor\u00e1rio de Ver\u00e3o de Saint Pierre e Miquelon",
               "PMDT",
               "Hor\u00e1rio de Saint Pierre e Miquelon",
               "PMT",
            };
        final String[] Indochina = new String[] {
               "Hor\u00e1rio da Indochina",
               "ICT",
               "Indochina Summer Time",
               "ICST",
               "Indochina Time",
               "ICT",
            };
        final String[] Yekaterinburg = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Ecaterimburgo",
               "YEKT",
               "Hor\u00e1rio de Ver\u00e3o de Ecaterimburgo",
               "YEKST",
               "Hor\u00e1rio de Ecaterimburgo",
               "YEKT",
            };
        final String[] Maldives = new String[] {
               "Hor\u00e1rio das Ilhas Maldivas",
               "MVT",
               "Maldives Summer Time",
               "MVST",
               "Maldives Time",
               "MVT",
            };
        final String[] Tahiti = new String[] {
               "Hor\u00e1rio do Taiti",
               "TAHT",
               "Tahiti Summer Time",
               "TAHST",
               "Tahiti Time",
               "TAHT",
            };
        final String[] Israel = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Israel",
               "IST",
               "Hor\u00e1rio de Ver\u00e3o de Israel",
               "IDT",
               "Hor\u00e1rio de Israel",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "Hor\u00e1rio da Indon\u00e9sia Central",
               "WITA",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "WITA",
            };
        final String[] Wallis = new String[] {
               "Hor\u00e1rio de Wallis e Futuna",
               "WFT",
               "Wallis & Futuna Summer Time",
               "WFST",
               "Wallis & Futuna Time",
               "WFT",
            };
        final String[] Africa_Southern = new String[] {
               "Hor\u00e1rio da \u00c1frica do Sul",
               "SAST",
               "South Africa Summer Time",
               "SAST",
               "South Africa Time",
               "SAT",
            };
        final String[] Syowa = new String[] {
               "Hor\u00e1rio de Syowa",
               "SYOT",
               "Syowa Summer Time",
               "SYOST",
               "Syowa Time",
               "SYOT",
            };
        final String[] Line_Islands = new String[] {
               "Hor\u00e1rio das Ilhas Line",
               "LINT",
               "Line Is. Summer Time",
               "LINST",
               "Line Is. Time",
               "LINT",
            };
        final String[] Uzbekistan = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Uzbequist\u00e3o",
               "UZT",
               "Hor\u00e1rio de Ver\u00e3o do Uzbequist\u00e3o",
               "UZST",
               "Hor\u00e1rio do Uzbequist\u00e3o",
               "UZT",
            };
        final String[] Omsk = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Omsk",
               "OMST",
               "Hor\u00e1rio de Ver\u00e3o de Omsk",
               "OMSST",
               "Hor\u00e1rio de Omsk",
               "OMST",
            };
        final String[] Seychelles = new String[] {
               "Hor\u00e1rio das Ilhas Seychelles",
               "SCT",
               "Seychelles Summer Time",
               "SCST",
               "Seychelles Time",
               "SCT",
            };
        final String[] Uruguay = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Uruguai",
               "UYT",
               "Hor\u00e1rio de Ver\u00e3o do Uruguai",
               "UYST",
               "Hor\u00e1rio do Uruguai",
               "UYT",
            };
        final String[] Nepal = new String[] {
               "Hor\u00e1rio do Nepal",
               "NPT",
               "Nepal Summer Time",
               "NPST",
               "Nepal Time",
               "NPT",
            };
        final String[] Mongolia = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Ulan Bator",
               "ULAT",
               "Hor\u00e1rio de Ver\u00e3o de Ulan Bator",
               "ULAST",
               "Hor\u00e1rio de Ulan Bator",
               "ULAT",
            };
        final String[] America_Central = new String[] {
               "Hor\u00e1rio Padr\u00e3o Central",
               "CST",
               "Hor\u00e1rio de Ver\u00e3o Central",
               "CDT",
               "Hor\u00e1rio Central",
               "CT",
            };
        final String[] Truk = new String[] {
               "Hor\u00e1rio de Chuuk",
               "CHUT",
               "Chuuk Summer Time",
               "CHUST",
               "Chuuk Time",
               "CHUT",
            };
        final String[] Niue = new String[] {
               "Hor\u00e1rio de Niue",
               "NUT",
               "Niue Summer Time",
               "NUST",
               "Niue Time",
               "NUT",
            };
        final String[] Wake = new String[] {
               "Hor\u00e1rio das Ilhas Wake",
               "WAKT",
               "Wake Summer Time",
               "WAKST",
               "Wake Time",
               "WAKT",
            };
        final String[] Falkland = new String[] {
               "Hor\u00e1rio Padr\u00e3o das Ilhas Falkland",
               "FKT",
               "Hor\u00e1rio de Ver\u00e3o das Ilhas Falkland",
               "FKST",
               "Hor\u00e1rio das Ilhas Falkland",
               "FKT",
            };
        final String[] Vanuatu = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Vanuatu",
               "VUT",
               "Hor\u00e1rio de Ver\u00e3o de Vanuatu",
               "VUST",
               "Hor\u00e1rio de Vanuatu",
               "VUT",
            };
        final String[] Novosibirsk = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Novosibirsk",
               "NOVT",
               "Hor\u00e1rio de Ver\u00e3o de Novosibirsk",
               "NOVST",
               "Hor\u00e1rio de Novosibirsk",
               "NOVT",
            };
        final String[] Singapore = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Cingapura",
               "SRET",
               "Srednekolymsk Daylight Time",
               "SREDT",
               "Srednekolymsk Time",
               "SRET",
            };
        final String[] Azores = new String[] {
               "Hor\u00e1rio Padr\u00e3o dos A\u00e7ores",
               "AZOT",
               "Hor\u00e1rio de Ver\u00e3o dos A\u00e7ores",
               "AZOST",
               "Hor\u00e1rio dos A\u00e7ores",
               "AZOT",
            };
        final String[] Apia = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Apia",
               "WSST",
               "Hor\u00e1rio de Ver\u00e3o de Apia",
               "WSDT",
               "Hor\u00e1rio de Apia",
               "WST",
            };
        final String[] Bhutan = new String[] {
               "Hor\u00e1rio do But\u00e3o",
               "BTT",
               "Bhutan Summer Time",
               "BTST",
               "Bhutan Time",
               "BTT",
            };
        final String[] Suriname = new String[] {
               "Hor\u00e1rio do Suriname",
               "SRT",
               "Suriname Summer Time",
               "SRST",
               "Suriname Time",
               "SRT",
            };
        final String[] Nauru = new String[] {
               "Hor\u00e1rio de Nauru",
               "NRT",
               "Nauru Summer Time",
               "NRST",
               "Nauru Time",
               "NRT",
            };
        final String[] Krasnoyarsk = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Krasnoyarsk",
               "KRAT",
               "Hor\u00e1rio de Ver\u00e3o de Krasnoyarsk",
               "KRAST",
               "Hor\u00e1rio de Krasnoyarsk",
               "KRAT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Hor\u00e1rio do Casaquist\u00e3o Ocidental",
               "AQTT",
               "Aqtau Summer Time",
               "AQTST",
               "Aqtau Time",
               "AQTT",
            };
        final String[] Myanmar = new String[] {
               "Hor\u00e1rio de Mianmar",
               "MMT",
               "Myanmar Summer Time",
               "MMST",
               "Myanmar Time",
               "MMT",
            };
        final String[] Christmas = new String[] {
               "Hor\u00e1rio das Ilhas Natal",
               "CXT",
               "Christmas Island Summer Time",
               "CXST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Amazon = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Amazonas",
               "AMT",
               "Hor\u00e1rio de Ver\u00e3o do Amazonas",
               "AMST",
               "Hor\u00e1rio do Amazonas",
               "AMT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Hor\u00e1rio do Casaquist\u00e3o Oriental",
               "ALMT",
               "Alma-Ata Summer Time",
               "ALMST",
               "Alma-Ata Time",
               "ALMT",
            };
        final String[] Fiji = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Fiji",
               "FJT",
               "Hor\u00e1rio de Ver\u00e3o de Fiji",
               "FJST",
               "Hor\u00e1rio de Fiji",
               "FJT",
            };
        final String[] Reunion = new String[] {
               "Hor\u00e1rio das Ilhas Reuni\u00e3o",
               "RET",
               "Reunion Summer Time",
               "REST",
               "Reunion Time",
               "RET",
            };
        final String[] Cocos = new String[] {
               "Hor\u00e1rio das Ilhas Coco",
               "CCT",
               "Cocos Islands Summer Time",
               "CCST",
               "Cocos Islands Time",
               "CCT",
            };
        final String[] Chatham = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Chatham",
               "CHAST",
               "Hor\u00e1rio de Ver\u00e3o de Chatham",
               "CHADT",
               "Hor\u00e1rio de Chatham",
               "CHAT",
            };
        final String[] Vostok = new String[] {
               "Hor\u00e1rio de Vostok",
               "VOST",
               "Vostok Summer Time",
               "VOSST",
               "Vostok Time",
               "VOST",
            };
        final String[] Argentina = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Argentina",
               "ART",
               "Hor\u00e1rio de Ver\u00e3o da Argentina",
               "ARST",
               "Hor\u00e1rio da Argentina",
               "ART",
            };
        final String[] Gambier = new String[] {
               "Hor\u00e1rio de Gambier",
               "GAMT",
               "Gambier Summer Time",
               "GAMST",
               "Gambier Time",
               "GAMT",
            };
        final String[] Kamchatka = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Petropavlovsk-Kamchatski",
               "PETT",
               "Hor\u00e1rio de Ver\u00e3o de Petropavlovsk-Kamchatski",
               "PETST",
               "Hor\u00e1rio de Petropavlovsk-Kamchatski",
               "PETT",
            };
        final String[] Tuvalu = new String[] {
               "Hor\u00e1rio de Tuvalu",
               "TVT",
               "Tuvalu Summer Time",
               "TVST",
               "Tuvalu Time",
               "TVT",
            };
        final String[] Galapagos = new String[] {
               "Hor\u00e1rio de Gal\u00e1pagos",
               "GALT",
               "Galapagos Summer Time",
               "GALST",
               "Galapagos Time",
               "GALT",
            };
        final String[] Macquarie = new String[] {
               "Hor\u00e1rio da Ilha Macquarie",
               "MIST",
               "Macquarie Island Daylight Time",
               "MIDT",
               "Macquarie Island Time",
               "MIST",
            };
        final String[] Venezuela = new String[] {
               "Hor\u00e1rio da Venezuela",
               "VET",
               "Venezuela Summer Time",
               "VEST",
               "Venezuela Time",
               "VET",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Hava\u00ed e Ilhas Aleutas",
               "HAST",
               "Hor\u00e1rio de Ver\u00e3o do Hava\u00ed e Ilhas Aleutas",
               "HADT",
               "Hor\u00e1rio do Hava\u00ed e Ilhas Aleutas",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Austr\u00e1lia Central",
               "ACST",
               "Hor\u00e1rio de Ver\u00e3o da Austr\u00e1lia Central",
               "ACDT",
               "Hor\u00e1rio da Austr\u00e1lia Central",
               "ACT",
            };
        final String[] America_Pacific = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Pac\u00edfico",
               "PST",
               "Hor\u00e1rio de Ver\u00e3o do Pac\u00edfico",
               "PDT",
               "Hor\u00e1rio do Pac\u00edfico",
               "PT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Hor\u00e1rio das Ilhas F\u00eanix",
               "PHOT",
               "Phoenix Is. Summer Time",
               "PHOST",
               "Phoenix Is. Time",
               "PHOT",
            };
        final String[] Turkmenistan = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Turcomenist\u00e3o",
               "TMT",
               "Hor\u00e1rio de Ver\u00e3o do Turcomenist\u00e3o",
               "TMST",
               "Hor\u00e1rio do Turcomenist\u00e3o",
               "TMT",
            };
        final String[] Europe_Western = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Europa Ocidental",
               "WET",
               "Hor\u00e1rio de Ver\u00e3o da Europa Ocidental",
               "WEST",
               "Hor\u00e1rio da Europa Ocidental",
               "WET",
            };
        final String[] Cape_Verde = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Cabo Verde",
               "CVT",
               "Hor\u00e1rio de Ver\u00e3o do Cabo Verde",
               "CVST",
               "Hor\u00e1rio do Cabo Verde",
               "CVT",
            };
        final String[] Norfolk = new String[] {
               "Hor\u00e1rio da Ilha Norfolk",
               "NFT",
               "Norfolk Summer Time",
               "NFST",
               "Norfolk Time",
               "NFT",
            };
        final String[] Guyana = new String[] {
               "Hor\u00e1rio da Guiana",
               "GYT",
               "Guyana Summer Time",
               "GYST",
               "Guyana Time",
               "GYT",
            };
        final String[] Pitcairn = new String[] {
               "Hor\u00e1rio de Pitcairn",
               "PST",
               "Pitcairn Daylight Time",
               "PDT",
               "Pitcairn Time",
               "PT",
            };
        final String[] Rothera = new String[] {
               "Hor\u00e1rio de Rothera",
               "ROTT",
               "Rothera Summer Time",
               "ROTST",
               "Rothera Time",
               "ROTT",
            };
        final String[] Samoa = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Samoa",
               "SST",
               "Hor\u00e1rio de Ver\u00e3o de Samoa",
               "SDT",
               "Hor\u00e1rio de Samoa",
               "ST",
            };
        final String[] Palau = new String[] {
               "Hor\u00e1rio de Palau",
               "PWT",
               "Palau Summer Time",
               "PWST",
               "Palau Time",
               "PWT",
            };
        final String[] Europe_Further_Eastern = new String[] {
               "Hor\u00e1rio de Kaliningrado",
               "MSK",
               "Moscow Daylight Time",
               "MSD",
               "Moscow Time",
               "MT",
            };
        final String[] Azerbaijan = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Arzeibaij\u00e3o",
               "AZT",
               "Hor\u00e1rio de Ver\u00e3o do Arzeibaij\u00e3o",
               "AZST",
               "Hor\u00e1rio do Arzeibaij\u00e3o",
               "AZT",
            };
        final String[] Mawson = new String[] {
               "Hor\u00e1rio de Mawson",
               "MAWT",
               "Mawson Summer Time",
               "MAWST",
               "Mawson Time",
               "MAWT",
            };
        final String[] Mexico_Pacific = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Pac\u00edfico do M\u00e9xico",
               "MST",
               "Hor\u00e1rio de Ver\u00e3o do Pac\u00edfico do M\u00e9xico",
               "MDT",
               "Hor\u00e1rio do Pac\u00edfico do M\u00e9xico",
               "MT",
            };
        final String[] Davis = new String[] {
               "Hor\u00e1rio de Davis",
               "DAVT",
               "Davis Summer Time",
               "DAVST",
               "Davis Time",
               "DAVT",
            };
        final String[] Cuba = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Cuba",
               "CST",
               "Hor\u00e1rio de Ver\u00e3o de Cuba",
               "CDT",
               "Hor\u00e1rio de Cuba",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "Hor\u00e1rio Padr\u00e3o da \u00c1frica Ocidental",
               "CAT",
               "Hor\u00e1rio de Ver\u00e3o da \u00c1frica Ocidental",
               "CAST",
               "Hor\u00e1rio da \u00c1frica Ocidental",
               "CAT",
            };
        final String[] GMT = new String[] {
               "Hor\u00e1rio do Meridiano de Greenwich",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
            };
        final String[] Philippines = new String[] {
               "Hor\u00e1rio Padr\u00e3o das Filipinas",
               "PHT",
               "Hor\u00e1rio de Ver\u00e3o das Filipinas",
               "PHST",
               "Hor\u00e1rio das Filipinas",
               "PHT",
            };
        final String[] French_Southern = new String[] {
               "Hor\u00e1rio da Ant\u00e1rtida e do Sul da Fran\u00e7a",
               "TFT",
               "French Southern & Antarctic Lands Summer Time",
               "TFST",
               "French Southern & Antarctic Lands Time",
               "TFT",
            };
        final String[] South_Georgia = new String[] {
               "Hor\u00e1rio da Ge\u00f3rgia do Sul",
               "GST",
               "South Georgia Daylight Time",
               "GDT",
               "South Georgia Time",
               "GT",
            };
        final String[] New_Caledonia = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Nova Caled\u00f4nia",
               "NCT",
               "Hor\u00e1rio de Ver\u00e3o da Nova Caled\u00f4nia",
               "NCST",
               "Hor\u00e1rio da Nova Caled\u00f4nia",
               "NCT",
            };
        final String[] Brunei = new String[] {
               "Hor\u00e1rio de Brunei Darussalam",
               "BNT",
               "Brunei Summer Time",
               "BNST",
               "Brunei Time",
               "BNT",
            };
        final String[] Iran = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Ir\u00e3",
               "IRST",
               "Hor\u00e1rio de Ver\u00e3o do Ir\u00e3",
               "IRDT",
               "Hor\u00e1rio do Ir\u00e3",
               "IRT",
            };
        final String[] Easter = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Ilha de P\u00e1scoa",
               "EAST",
               "Hor\u00e1rio de Ver\u00e3o da Ilha de P\u00e1scoa",
               "EASST",
               "Hor\u00e1rio da Ilha de P\u00e1scoa",
               "EAST",
            };
        final String[] Mexico_Northwest = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Noroeste do M\u00e9xico",
               "PST",
               "Hor\u00e1rio de Ver\u00e3o do Noroeste do M\u00e9xico",
               "PDT",
               "Hor\u00e1rio do Noroeste do M\u00e9xico",
               "PT",
            };
        final String[] DumontDUrville = new String[] {
               "Hor\u00e1rio de Dumont-d\u2019Urville",
               "DDUT",
               "Dumont-d'Urville Summer Time",
               "DDUST",
               "Dumont-d'Urville Time",
               "DDUT",
            };
        final String[] Tajikistan = new String[] {
               "Hor\u00e1rio do Tajiquist\u00e3o",
               "TJT",
               "Tajikistan Summer Time",
               "TJST",
               "Tajikistan Time",
               "TJT",
            };
        final String[] Tonga = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Tonga",
               "TOT",
               "Hor\u00e1rio de Ver\u00e3o de Tonga",
               "TOST",
               "Hor\u00e1rio de Tonga",
               "TOT",
            };
        final String[] Bangladesh = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Bangladesh",
               "BDT",
               "Hor\u00e1rio de Ver\u00e3o de Bangladesh",
               "BDST",
               "Hor\u00e1rio de Bangladesh",
               "BDT",
            };
        final String[] Peru = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Peru",
               "PET",
               "Hor\u00e1rio de Ver\u00e3o do Peru",
               "PEST",
               "Hor\u00e1rio do Peru",
               "PET",
            };
        final String[] Greenland_Western = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Groenl\u00e2ndia Ocidental",
               "WGT",
               "Hor\u00e1rio de Ver\u00e3o da Groenl\u00e2ndia Ocidental",
               "WGST",
               "Hor\u00e1rio da Groenl\u00e2ndia Ocidental",
               "WGT",
            };
        final String[] Ecuador = new String[] {
               "Hor\u00e1rio do Equador",
               "ECT",
               "Ecuador Summer Time",
               "ECST",
               "Ecuador Time",
               "ECT",
            };
        final String[] Greenland_Eastern = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Groel\u00e2ndia Oriental",
               "EGT",
               "Hor\u00e1rio de Ver\u00e3o da Groel\u00e2ndia Oriental",
               "EGST",
               "Hor\u00e1rio da Groel\u00e2ndia Oriental",
               "EGT",
            };
        final String[] Gulf = new String[] {
               "Hor\u00e1rio do Golfo",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Hor\u00e1rio da Indon\u00e9sia Oriental",
               "WIT",
               "East Indonesia Summer Time",
               "EIST",
               "East Indonesia Time",
               "WIT",
            };
        final String[] Korea = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Coreia",
               "KST",
               "Hor\u00e1rio de Ver\u00e3o da Coreia",
               "KDT",
               "Hor\u00e1rio da Coreia",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Austr\u00e1lia Ocidental",
               "AWST",
               "Hor\u00e1rio de Ver\u00e3o da Austr\u00e1lia Ocidental",
               "AWDT",
               "Hor\u00e1rio da Austr\u00e1lia Ocidental",
               "AWT",
            };
        final String[] Kyrgystan = new String[] {
               "Hor\u00e1rio do Quirguist\u00e3o",
               "KGT",
               "Kirgizstan Summer Time",
               "KGST",
               "Kirgizstan Time",
               "KGT",
            };
        final String[] Indonesia_Western = new String[] {
               "Hor\u00e1rio da Indon\u00e9sia Ocidental",
               "WIB",
               "West Indonesia Summer Time",
               "WIST",
               "West Indonesia Time",
               "WIB",
            };
        final String[] Australia_Eastern = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Austr\u00e1lia Oriental",
               "AEST",
               "Hor\u00e1rio de Ver\u00e3o da Austr\u00e1lia Oriental",
               "AEDT",
               "Hor\u00e1rio da Austr\u00e1lia Oriental",
               "AET",
            };
        final String[] French_Guiana = new String[] {
               "Hor\u00e1rio da Guiana Francesa",
               "GFT",
               "French Guiana Summer Time",
               "GFST",
               "French Guiana Time",
               "GFT",
            };
        final String[] Colombia = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Col\u00f4mbia",
               "COT",
               "Hor\u00e1rio de Ver\u00e3o da Col\u00f4mbia",
               "COST",
               "Hor\u00e1rio da Col\u00f4mbia",
               "COT",
            };
        final String[] Chile = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Chile",
               "CLT",
               "Hor\u00e1rio de Ver\u00e3o do Chile",
               "CLST",
               "Hor\u00e1rio do Chile",
               "CLT",
            };
        final String[] Gilbert_Islands = new String[] {
               "Hor\u00e1rio das Ilhas Gilberto",
               "GILT",
               "Gilbert Is. Summer Time",
               "GILST",
               "Gilbert Is. Time",
               "GILT",
            };
        final String[] America_Mountain = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Montanha",
               "MST",
               "Hor\u00e1rio de Ver\u00e3o da Montanha",
               "MDT",
               "Hor\u00e1rio da Montanha",
               "MT",
            };
        final String[] Marquesas = new String[] {
               "Hor\u00e1rio das Marquesas",
               "MART",
               "Marquesas Summer Time",
               "MARST",
               "Marquesas Time",
               "MART",
            };
        final String[] Arabian = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Ar\u00e1bia",
               "AST",
               "Hor\u00e1rio de Ver\u00e3o da Ar\u00e1bia",
               "ADT",
               "Hor\u00e1rio da Ar\u00e1bia",
               "AT",
            };
        final String[] Alaska = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Alasca",
               "AKST",
               "Hor\u00e1rio de Ver\u00e3o do Alasca",
               "AKDT",
               "Hor\u00e1rio do Alasca",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Vladivostok",
               "VLAT",
               "Hor\u00e1rio de Ver\u00e3o de Vladivostok",
               "VLAST",
               "Hor\u00e1rio de Vladivostok",
               "VLAT",
            };
        final String[] Chamorro = new String[] {
               "Hor\u00e1rio de Chamorro",
               "ChST",
               "Chamorro Daylight Time",
               "ChDT",
               "Chamorro Time",
               "ChT",
            };
        final String[] Irkutsk = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Irkutsk",
               "IRKT",
               "Hor\u00e1rio de Ver\u00e3o de Irkutsk",
               "IRKST",
               "Hor\u00e1rio de Irkutsk",
               "IRKT",
            };
        final String[] Georgia = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Ge\u00f3rgia",
               "GET",
               "Hor\u00e1rio de Ver\u00e3o da Ge\u00f3rgia",
               "GEST",
               "Hor\u00e1rio da Ge\u00f3rgia",
               "GET",
            };
        final String[] Tokelau = new String[] {
               "Hor\u00e1rio de Tokelau",
               "TKT",
               "Tokelau Summer Time",
               "TKST",
               "Tokelau Time",
               "TKT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Hor\u00e1rio de Papua Nova Guin\u00e9",
               "PGT",
               "Papua New Guinea Summer Time",
               "PGST",
               "Papua New Guinea Time",
               "PGT",
            };
        final String[] Noronha = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Fernando de Noronha",
               "FNT",
               "Hor\u00e1rio de Ver\u00e3o de Fernando de Noronha",
               "FNST",
               "Hor\u00e1rio de Fernando de Noronha",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Choibalsan",
               "CHOT",
               "Hor\u00e1rio de Ver\u00e3o de Choibalsan",
               "CHOST",
               "Hor\u00e1rio de Choibalsan",
               "CHOT",
            };
        final String[] Brasilia = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Bras\u00edlia",
               "BRT",
               "Hor\u00e1rio de Ver\u00e3o de Bras\u00edlia",
               "BRST",
               "Hor\u00e1rio de Bras\u00edlia",
               "BRT",
            };
        final String[] China = new String[] {
               "Hor\u00e1rio Padr\u00e3o da China",
               "CST",
               "Hor\u00e1rio de Ver\u00e3o da China",
               "CDT",
               "Hor\u00e1rio da China",
               "CT",
            };
        final String[] Armenia = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Arm\u00eania",
               "AMT",
               "Hor\u00e1rio de Ver\u00e3o da Arm\u00eania",
               "AMST",
               "Hor\u00e1rio da Arm\u00eania",
               "AMT",
            };
        final String[] Samara = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Samara",
               "SAMT",
               "Hor\u00e1rio de Ver\u00e3o de Samara",
               "SAMST",
               "Hor\u00e1rio de Samara",
               "SAMT",
            };
        final String[] India = new String[] {
               "Hor\u00e1rio Padr\u00e3o da \u00cdndia",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Cook = new String[] {
               "Hor\u00e1rio Padr\u00e3o das Ilhas Cook",
               "CKT",
               "Meio Hor\u00e1rio de Ver\u00e3o das Ilhas Cook",
               "CKHST",
               "Hor\u00e1rio das Ilhas Cook",
               "CKT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London",
                new String[] {
                    "Hor\u00e1rio do Meridiano de Greenwich",
                    "GMT",
                    "Hor\u00e1rio de Ver\u00e3o Brit\u00e2nico",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Eirunepe", Acre },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", Atlantic },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Antarctica/Syowa", Syowa },
            { "Indian/Reunion", Reunion },
            { "Pacific/Palau", Palau },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Western },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Africa/Bamako", GMT },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Pacific/Bougainville", New_Zealand },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", Alaska },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Antarctica/Troll", GMT },
            { "Europe/Samara", Samara },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "Hor\u00e1rio do Meridiano de Greenwich",
                    "GMT",
                    "Hor\u00e1rio Padr\u00e3o da Irlanda",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "Pacific/Truk", Truk },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Saipan", Chamorro },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Taipei", Taipei },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Further_Eastern },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Cancun", America_Eastern },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Rio_Branco", Acre },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Kamchatka },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Tehran", Iran },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "Asia/Srednekolymsk", Singapore },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "Australia/Lindeman", Australia_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
