/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_sk extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "stredoafrick\u00fd \u010das",
               "CAT",
               "Central African Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "moskovsk\u00fd \u0161tandardn\u00fd \u010das",
               "MSK",
               "moskovsk\u00fd letn\u00fd \u010das",
               "MSD",
               "moskovsk\u00fd \u010das",
               "MT",
            };
        final String[] Japan = new String[] {
               "japonsk\u00fd \u0161tandardn\u00fd \u010das",
               "JST",
               "japonsk\u00fd letn\u00fd \u010das",
               "JDT",
               "japonsk\u00fd \u010das",
               "JT",
            };
        final String[] Pakistan = new String[] {
               "pakistansk\u00fd \u0161tandardn\u00fd \u010das",
               "PKT",
               "pakistansk\u00fd letn\u00fd \u010das",
               "PKST",
               "pakistansk\u00fd \u010das",
               "PKT",
            };
        final String[] Taipei = new String[] {
               "tchajpejsk\u00fd \u0161tandardn\u00fd \u010das",
               "CST",
               "tchajpejsk\u00fd letn\u00fd \u010das",
               "CDT",
               "tchajpejsk\u00fd \u010das",
               "CT",
            };
        final String[] Hovd = new String[] {
               "chovdsk\u00fd \u0161tandardn\u00fd \u010das",
               "HOVT",
               "chovdsk\u00fd letn\u00fd \u010das",
               "HOVST",
               "chovdsk\u00fd \u010das",
               "HOVT",
            };
        final String[] Magadan = new String[] {
               "magadansk\u00fd \u0161tandardn\u00fd \u010das",
               "MAGT",
               "magadansk\u00fd letn\u00fd \u010das",
               "MAGST",
               "magadansk\u00fd \u010das",
               "MAGT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "stredoz\u00e1padn\u00fd austr\u00e1lsky \u0161tandardn\u00fd \u010das",
               "ACWST",
               "stredoz\u00e1padn\u00fd austr\u00e1lsky letn\u00fd \u010das",
               "ACWDT",
               "stredoz\u00e1padn\u00fd austr\u00e1lsky \u010das",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "stredoeur\u00f3psky \u0161tandardn\u00fd \u010das",
               "SE\u010c",
               "stredoeur\u00f3psky letn\u00fd \u010das",
               "SEL\u010c",
               "stredoeur\u00f3psky \u010das",
               "SE\u010c",
            };
        final String[] Sakhalin = new String[] {
               "sachalinsk\u00fd \u0161tandardn\u00fd \u010das",
               "SAKT",
               "sachalinsk\u00fd letn\u00fd \u010das",
               "SAKST",
               "sachalinsk\u00fd \u010das",
               "SAKT",
            };
        final String[] Paraguay = new String[] {
               "paraguajsk\u00fd \u0161tandardn\u00fd \u010das",
               "PYT",
               "paraguajsk\u00fd letn\u00fd \u010das",
               "PYST",
               "paraguajsk\u00fd \u010das",
               "PYT",
            };
        final String[] Malaysia = new String[] {
               "malajzijsk\u00fd \u010das",
               "MYT",
               "Malaysia Summer Time",
               "MYST",
               "Malaysia Time",
               "MYT",
            };
        final String[] America_Eastern = new String[] {
               "severoamerick\u00fd v\u00fdchodn\u00fd \u0161tandardn\u00fd \u010das",
               "EST",
               "severoamerick\u00fd v\u00fdchodn\u00fd letn\u00fd \u010das",
               "EDT",
               "severoamerick\u00fd v\u00fdchodn\u00fd \u010das",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "\u0161tandardn\u00fd \u010das ostrova lorda Howa",
               "LHST",
               "letn\u00fd \u010das ostrova lorda Howa",
               "LHDT",
               "\u010das ostrova lorda Howa",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "novoz\u00e9landsk\u00fd \u0161tandardn\u00fd \u010das",
               "NZST",
               "novoz\u00e9landsk\u00fd letn\u00fd \u010das",
               "NZDT",
               "novoz\u00e9landsk\u00fd \u010das",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "indickooce\u00e1nsky \u010das",
               "IOT",
               "Indian Ocean Territory Summer Time",
               "IOST",
               "Indian Ocean Territory Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "jakutsk\u00fd \u0161tandardn\u00fd \u010das",
               "YAKT",
               "jakutsk\u00fd letn\u00fd \u010das",
               "YAKST",
               "jakutsk\u00fd \u010das",
               "YAKT",
            };
        final String[] Mauritius = new String[] {
               "maur\u00edcijsk\u00fd \u0161tandardn\u00fd \u010das",
               "MUT",
               "maur\u00edcijsk\u00fd letn\u00fd \u010das",
               "MUST",
               "maur\u00edcijsk\u00fd \u010das",
               "MUT",
            };
        final String[] Africa_Eastern = new String[] {
               "v\u00fdchodoafrick\u00fd \u010das",
               "EAT",
               "Eastern African Summer Time",
               "EAST",
               "Eastern Africa Time",
               "EAT",
            };
        final String[] East_Timor = new String[] {
               "v\u00fdchodotimorsk\u00fd \u010das",
               "TLT",
               "Timor-Leste Summer Time",
               "TLST",
               "Timor-Leste Time",
               "TLT",
            };
        final String[] Solomon = new String[] {
               "\u010das \u0160alam\u00fanov\u00fdch ostrovov",
               "SBT",
               "Solomon Is. Summer Time",
               "SBST",
               "Solomon Is. Time",
               "SBT",
            };
        final String[] Kosrae = new String[] {
               "kosrajsk\u00fd \u010das",
               "KOST",
               "Kosrae Summer Time",
               "KOSST",
               "Kosrae Time",
               "KOST",
            };
        final String[] Marshall_Islands = new String[] {
               "\u010das Marshallov\u00fdch ostrovov",
               "MHT",
               "Marshall Islands Summer Time",
               "MHST",
               "Marshall Islands Time",
               "MHT",
            };
        final String[] Europe_Eastern = new String[] {
               "v\u00fdchodoeur\u00f3psky \u0161tandardn\u00fd \u010das",
               "EET",
               "v\u00fdchodoeur\u00f3psky letn\u00fd \u010das",
               "EEST",
               "v\u00fdchodoeur\u00f3psky \u010das",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "newfoundlandsk\u00fd \u0161tandardn\u00fd \u010das",
               "NST",
               "newfoundlandsk\u00fd letn\u00fd \u010das",
               "NDT",
               "newfoundlandsk\u00fd \u010das",
               "NT",
            };
        final String[] Afghanistan = new String[] {
               "afgansk\u00fd \u010das",
               "AFT",
               "Afghanistan Summer Time",
               "AFST",
               "Afghanistan Time",
               "AFT",
            };
        final String[] Hong_Kong = new String[] {
               "hongkonsk\u00fd \u0161tandardn\u00fd \u010das",
               "HKT",
               "hongkonsk\u00fd letn\u00fd \u010das",
               "HKST",
               "hongkonsk\u00fd \u010das",
               "HKT",
            };
        final String[] Argentina_Western = new String[] {
               "z\u00e1padoargent\u00ednsky \u0161tandardn\u00fd \u010das",
               "ART",
               "z\u00e1padoargent\u00ednsky letn\u00fd \u010das",
               "ARST",
               "z\u00e1padoargent\u00ednsky \u010das",
               "ART",
            };
        final String[] Atlantic = new String[] {
               "atlantick\u00fd \u0161tandardn\u00fd \u010das",
               "AST",
               "atlantick\u00fd letn\u00fd \u010das",
               "ADT",
               "atlantick\u00fd \u010das",
               "AT",
            };
        final String[] Ponape = new String[] {
               "ponapsk\u00fd \u010das",
               "PONT",
               "Pohnpei Summer Time",
               "PONST",
               "Ponape Time",
               "PONT",
            };
        final String[] Bolivia = new String[] {
               "bol\u00edvijsk\u00fd \u010das",
               "BOT",
               "Bolivia Summer Time",
               "BOST",
               "Bolivia Time",
               "BOT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "pierre-miquelonsk\u00fd \u0161tandardn\u00fd \u010das",
               "PMST",
               "pierre-miquelonsk\u00fd letn\u00fd \u010das",
               "PMDT",
               "pierre-miquelonsk\u00fd \u010das",
               "PMT",
            };
        final String[] Indochina = new String[] {
               "indo\u010d\u00ednsky \u010das",
               "ICT",
               "Indochina Summer Time",
               "ICST",
               "Indochina Time",
               "ICT",
            };
        final String[] Yekaterinburg = new String[] {
               "jekaterinbursk\u00fd \u0161tandardn\u00fd \u010das",
               "YEKT",
               "jekaterinbursk\u00fd letn\u00fd \u010das",
               "YEKST",
               "jekaterinbursk\u00fd \u010das",
               "YEKT",
            };
        final String[] Maldives = new String[] {
               "maldivsk\u00fd \u010das",
               "MVT",
               "Maldives Summer Time",
               "MVST",
               "Maldives Time",
               "MVT",
            };
        final String[] Tahiti = new String[] {
               "tahitsk\u00fd \u010das",
               "TAHT",
               "Tahiti Summer Time",
               "TAHST",
               "Tahiti Time",
               "TAHT",
            };
        final String[] Israel = new String[] {
               "izraelsk\u00fd \u0161tandardn\u00fd \u010das",
               "IST",
               "izraelsk\u00fd letn\u00fd \u010das",
               "IDT",
               "izraelsk\u00fd \u010das",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "stredoindon\u00e9zsky \u010das",
               "WITA",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "WITA",
            };
        final String[] Wallis = new String[] {
               "\u010das ostrovov Wallis a Futuna",
               "WFT",
               "Wallis & Futuna Summer Time",
               "WFST",
               "Wallis & Futuna Time",
               "WFT",
            };
        final String[] Africa_Southern = new String[] {
               "juhoafrick\u00fd \u010das",
               "SAST",
               "South Africa Summer Time",
               "SAST",
               "South Africa Time",
               "SAT",
            };
        final String[] Syowa = new String[] {
               "\u010das stanice \u0160\u00f3wa",
               "SYOT",
               "Syowa Summer Time",
               "SYOST",
               "Syowa Time",
               "SYOT",
            };
        final String[] Line_Islands = new String[] {
               "\u010das Rovn\u00edkov\u00fdch ostrovov",
               "LINT",
               "Line Is. Summer Time",
               "LINST",
               "Line Is. Time",
               "LINT",
            };
        final String[] Uzbekistan = new String[] {
               "uzbeck\u00fd \u0161tandardn\u00fd \u010das",
               "UZT",
               "uzbeck\u00fd letn\u00fd \u010das",
               "UZST",
               "uzbeck\u00fd \u010das",
               "UZT",
            };
        final String[] Omsk = new String[] {
               "omsk\u00fd \u0161tandardn\u00fd \u010das",
               "OMST",
               "omsk\u00fd letn\u00fd \u010das",
               "OMSST",
               "omsk\u00fd \u010das",
               "OMST",
            };
        final String[] Seychelles = new String[] {
               "seychelsk\u00fd \u010das",
               "SCT",
               "Seychelles Summer Time",
               "SCST",
               "Seychelles Time",
               "SCT",
            };
        final String[] Uruguay = new String[] {
               "uruguajsk\u00fd \u0161tandardn\u00fd \u010das",
               "UYT",
               "uruguajsk\u00fd letn\u00fd \u010das",
               "UYST",
               "uruguajsk\u00fd \u010das",
               "UYT",
            };
        final String[] Nepal = new String[] {
               "nep\u00e1lsky \u010das",
               "NPT",
               "Nepal Summer Time",
               "NPST",
               "Nepal Time",
               "NPT",
            };
        final String[] Mongolia = new String[] {
               "ulanb\u00e1tarsk\u00fd \u0161tandardn\u00fd \u010das",
               "ULAT",
               "ulanb\u00e1tarsk\u00fd letn\u00fd \u010das",
               "ULAST",
               "ulanb\u00e1tarsk\u00fd \u010das",
               "ULAT",
            };
        final String[] America_Central = new String[] {
               "severoamerick\u00fd centr\u00e1lny \u0161tandardn\u00fd \u010das",
               "CST",
               "severoamerick\u00fd centr\u00e1lny letn\u00fd \u010das",
               "CDT",
               "severoamerick\u00fd centr\u00e1lny \u010das",
               "CT",
            };
        final String[] Truk = new String[] {
               "chuuksk\u00fd \u010das",
               "CHUT",
               "Chuuk Summer Time",
               "CHUST",
               "Chuuk Time",
               "CHUT",
            };
        final String[] Niue = new String[] {
               "niuejsk\u00fd \u010das",
               "NUT",
               "Niue Summer Time",
               "NUST",
               "Niue Time",
               "NUT",
            };
        final String[] Wake = new String[] {
               "\u010das ostrova Wake",
               "WAKT",
               "Wake Summer Time",
               "WAKST",
               "Wake Time",
               "WAKT",
            };
        final String[] Falkland = new String[] {
               "falklandsk\u00fd \u0161tandardn\u00fd \u010das",
               "FKT",
               "falklandsk\u00fd letn\u00fd \u010das",
               "FKST",
               "falklandsk\u00fd \u010das",
               "FKT",
            };
        final String[] Vanuatu = new String[] {
               "vanuatsk\u00fd \u0161tandardn\u00fd \u010das",
               "VUT",
               "vanuatsk\u00fd letn\u00fd \u010das",
               "VUST",
               "vanuatsk\u00fd \u010das",
               "VUT",
            };
        final String[] Novosibirsk = new String[] {
               "novosibirsk\u00fd \u0161tandardn\u00fd \u010das",
               "NOVT",
               "novosibirsk\u00fd letn\u00fd \u010das",
               "NOVST",
               "novosibirsk\u00fd \u010das",
               "NOVT",
            };
        final String[] Singapore = new String[] {
               "singapursk\u00fd \u0161tandardn\u00fd \u010das",
               "SRET",
               "Srednekolymsk Daylight Time",
               "SREDT",
               "Srednekolymsk Time",
               "SRET",
            };
        final String[] Azores = new String[] {
               "azorsk\u00fd \u0161tandardn\u00fd \u010das",
               "AZOT",
               "azorsk\u00fd letn\u00fd \u010das",
               "AZOST",
               "azorsk\u00fd \u010das",
               "AZOT",
            };
        final String[] Apia = new String[] {
               "apijsk\u00fd \u0161tandardn\u00fd \u010das",
               "WSST",
               "apijsk\u00fd letn\u00fd \u010das",
               "WSDT",
               "apijsk\u00fd \u010das",
               "WST",
            };
        final String[] Bhutan = new String[] {
               "bhut\u00e1nsky \u010das",
               "BTT",
               "Bhutan Summer Time",
               "BTST",
               "Bhutan Time",
               "BTT",
            };
        final String[] Suriname = new String[] {
               "surinamsk\u00fd \u010das",
               "SRT",
               "Suriname Summer Time",
               "SRST",
               "Suriname Time",
               "SRT",
            };
        final String[] Nauru = new String[] {
               "naurusk\u00fd \u010das",
               "NRT",
               "Nauru Summer Time",
               "NRST",
               "Nauru Time",
               "NRT",
            };
        final String[] Krasnoyarsk = new String[] {
               "krasnojarsk\u00fd \u0161tandardn\u00fd \u010das",
               "KRAT",
               "krasnojarsk\u00fd letn\u00fd \u010das",
               "KRAST",
               "krasnojarsk\u00fd \u010das",
               "KRAT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "z\u00e1padokazachstansk\u00fd \u010das",
               "AQTT",
               "Aqtau Summer Time",
               "AQTST",
               "Aqtau Time",
               "AQTT",
            };
        final String[] Myanmar = new String[] {
               "mjanmarsk\u00fd \u010das",
               "MMT",
               "Myanmar Summer Time",
               "MMST",
               "Myanmar Time",
               "MMT",
            };
        final String[] Christmas = new String[] {
               "\u010das Viano\u010dn\u00e9ho ostrova",
               "CXT",
               "Christmas Island Summer Time",
               "CXST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Amazon = new String[] {
               "amazonsk\u00fd \u0161tandardn\u00fd \u010das",
               "AMT",
               "amazonsk\u00fd letn\u00fd \u010das",
               "AMST",
               "amazonsk\u00fd \u010das",
               "AMT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "v\u00fdchodokazachstansk\u00fd \u010das",
               "ALMT",
               "Alma-Ata Summer Time",
               "ALMST",
               "Alma-Ata Time",
               "ALMT",
            };
        final String[] Fiji = new String[] {
               "fid\u017eijsk\u00fd \u0161tandardn\u00fd \u010das",
               "FJT",
               "fid\u017eijsk\u00fd letn\u00fd \u010das",
               "FJST",
               "fid\u017eijsk\u00fd \u010das",
               "FJT",
            };
        final String[] Reunion = new String[] {
               "r\u00e9unionsk\u00fd \u010das",
               "RET",
               "Reunion Summer Time",
               "REST",
               "Reunion Time",
               "RET",
            };
        final String[] Cocos = new String[] {
               "\u010das Kokosov\u00fdch ostrovov",
               "CCT",
               "Cocos Islands Summer Time",
               "CCST",
               "Cocos Islands Time",
               "CCT",
            };
        final String[] Chatham = new String[] {
               "chathamsk\u00fd \u0161tandardn\u00fd \u010das",
               "CHAST",
               "chathamsk\u00fd letn\u00fd \u010das",
               "CHADT",
               "chathamsk\u00fd \u010das",
               "CHAT",
            };
        final String[] Vostok = new String[] {
               "\u010das stanice Vostok",
               "VOST",
               "Vostok Summer Time",
               "VOSST",
               "Vostok Time",
               "VOST",
            };
        final String[] Argentina = new String[] {
               "argent\u00ednsky \u0161tandardn\u00fd \u010das",
               "ART",
               "argent\u00ednsky letn\u00fd \u010das",
               "ARST",
               "argent\u00ednsky \u010das",
               "ART",
            };
        final String[] Gambier = new String[] {
               "gambiersk\u00fd \u010das",
               "GAMT",
               "Gambier Summer Time",
               "GAMST",
               "Gambier Time",
               "GAMT",
            };
        final String[] Kamchatka = new String[] {
               "Petropavlovsk-Kam\u010datsk\u00fd \u0161tandardn\u00fd \u010das",
               "PETT",
               "Petropavlovsk-Kam\u010datskijsk\u00fd letn\u00fd \u010das",
               "PETST",
               "Petropavlovsk-Kam\u010datsk\u00fd \u010das",
               "PETT",
            };
        final String[] Tuvalu = new String[] {
               "tuvalsk\u00fd \u010das",
               "TVT",
               "Tuvalu Summer Time",
               "TVST",
               "Tuvalu Time",
               "TVT",
            };
        final String[] Galapagos = new String[] {
               "galap\u00e1gsky \u010das",
               "GALT",
               "Galapagos Summer Time",
               "GALST",
               "Galapagos Time",
               "GALT",
            };
        final String[] Macquarie = new String[] {
               "\u010das ostrova Macquarie",
               "MIST",
               "Macquarie Island Daylight Time",
               "MIDT",
               "Macquarie Island Time",
               "MIST",
            };
        final String[] Venezuela = new String[] {
               "venezuelsk\u00fd \u010das",
               "VET",
               "Venezuela Summer Time",
               "VEST",
               "Venezuela Time",
               "VET",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "havajsko-aleutsk\u00fd \u0161tandardn\u00fd \u010das",
               "HAST",
               "havajsko-aleutsk\u00fd letn\u00fd \u010das",
               "HADT",
               "havajsko-aleutsk\u00fd \u010das",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "stredoaustr\u00e1lsky \u0161tandardn\u00fd \u010das",
               "ACST",
               "stredoaustr\u00e1lsky letn\u00fd \u010das",
               "ACDT",
               "stredoaustr\u00e1lsky \u010das",
               "ACT",
            };
        final String[] America_Pacific = new String[] {
               "severoamerick\u00fd tichomorsk\u00fd \u0161tandardn\u00fd \u010das",
               "PST",
               "severoamerick\u00fd tichomorsk\u00fd letn\u00fd \u010das",
               "PDT",
               "severoamerick\u00fd tichomorsk\u00fd \u010das",
               "PT",
            };
        final String[] Phoenix_Islands = new String[] {
               "\u010das F\u00e9nixov\u00fdch ostrovov",
               "PHOT",
               "Phoenix Is. Summer Time",
               "PHOST",
               "Phoenix Is. Time",
               "PHOT",
            };
        final String[] Turkmenistan = new String[] {
               "turkm\u00e9nsky \u0161tandardn\u00fd \u010das",
               "TMT",
               "turkm\u00e9nsky letn\u00fd \u010das",
               "TMST",
               "turkm\u00e9nsky \u010das",
               "TMT",
            };
        final String[] Europe_Western = new String[] {
               "z\u00e1padoeur\u00f3psky \u0161tandardn\u00fd \u010das",
               "WET",
               "z\u00e1padoeur\u00f3psky letn\u00fd \u010das",
               "WEST",
               "z\u00e1padoeur\u00f3psky \u010das",
               "WET",
            };
        final String[] Cape_Verde = new String[] {
               "kapverdsk\u00fd \u0161tandardn\u00fd \u010das",
               "CVT",
               "kapverdsk\u00fd letn\u00fd \u010das",
               "CVST",
               "kapverdsk\u00fd \u010das",
               "CVT",
            };
        final String[] Norfolk = new String[] {
               "norfolsk\u00fd \u010das",
               "NFT",
               "Norfolk Summer Time",
               "NFST",
               "Norfolk Time",
               "NFT",
            };
        final String[] Guyana = new String[] {
               "guyansk\u00fd \u010das",
               "GYT",
               "Guyana Summer Time",
               "GYST",
               "Guyana Time",
               "GYT",
            };
        final String[] Pitcairn = new String[] {
               "\u010das Pitcairnov\u00fdch ostrovov",
               "PST",
               "Pitcairn Daylight Time",
               "PDT",
               "Pitcairn Time",
               "PT",
            };
        final String[] Rothera = new String[] {
               "\u010das Rotherovej stanice",
               "ROTT",
               "Rothera Summer Time",
               "ROTST",
               "Rothera Time",
               "ROTT",
            };
        final String[] Samoa = new String[] {
               "samojsk\u00fd \u0161tandardn\u00fd \u010das",
               "SST",
               "samojsk\u00fd letn\u00fd \u010das",
               "SDT",
               "samojsk\u00fd \u010das",
               "ST",
            };
        final String[] Palau = new String[] {
               "palausk\u00fd \u010das",
               "PWT",
               "Palau Summer Time",
               "PWST",
               "Palau Time",
               "PWT",
            };
        final String[] Europe_Further_Eastern = new String[] {
               "minsk\u00fd \u010das",
               "MSK",
               "Moscow Daylight Time",
               "MSD",
               "Moscow Time",
               "MT",
            };
        final String[] Azerbaijan = new String[] {
               "azerbajd\u017eansk\u00fd \u0161tandardn\u00fd \u010das",
               "AZT",
               "azerbajd\u017eansk\u00fd letn\u00fd \u010das",
               "AZST",
               "azerbajd\u017eansk\u00fd \u010das",
               "AZT",
            };
        final String[] Mawson = new String[] {
               "\u010das Mawsonovej stanice",
               "MAWT",
               "Mawson Summer Time",
               "MAWST",
               "Mawson Time",
               "MAWT",
            };
        final String[] Mexico_Pacific = new String[] {
               "mexick\u00fd tichomorsk\u00fd \u0161tandardn\u00fd \u010das",
               "MST",
               "mexick\u00fd tichomorsk\u00fd letn\u00fd \u010das",
               "MDT",
               "mexick\u00fd tichomorsk\u00fd \u010das",
               "MT",
            };
        final String[] Davis = new String[] {
               "\u010das Davisovej stanice",
               "DAVT",
               "Davis Summer Time",
               "DAVST",
               "Davis Time",
               "DAVT",
            };
        final String[] Cuba = new String[] {
               "kub\u00e1nsky \u0161tandardn\u00fd \u010das",
               "CST",
               "kub\u00e1nsky letn\u00fd \u010das",
               "CDT",
               "kub\u00e1nsky \u010das",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "z\u00e1padoafrick\u00fd \u0161tandardn\u00fd \u010das",
               "CAT",
               "z\u00e1padoafrick\u00fd letn\u00fd \u010das",
               "CAST",
               "z\u00e1padoafrick\u00fd \u010das",
               "CAT",
            };
        final String[] GMT = new String[] {
               "greenwichsk\u00fd \u010das",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
            };
        final String[] Philippines = new String[] {
               "filip\u00ednsky \u0161tandardn\u00fd \u010das",
               "PHT",
               "filip\u00ednsky letn\u00fd \u010das",
               "PHST",
               "filip\u00ednsky \u010das",
               "PHT",
            };
        final String[] French_Southern = new String[] {
               "\u010das Franc\u00fazskych ju\u017en\u00fdch a antarktick\u00fdch \u00fazem\u00ed",
               "TFT",
               "French Southern & Antarctic Lands Summer Time",
               "TFST",
               "French Southern & Antarctic Lands Time",
               "TFT",
            };
        final String[] South_Georgia = new String[] {
               "\u010das Ju\u017enej Georgie",
               "GST",
               "South Georgia Daylight Time",
               "GDT",
               "South Georgia Time",
               "GT",
            };
        final String[] New_Caledonia = new String[] {
               "novokaled\u00f3nsky \u0161tandardn\u00fd \u010das",
               "NCT",
               "novokaled\u00f3nsky letn\u00fd \u010das",
               "NCST",
               "novokaled\u00f3nsky \u010das",
               "NCT",
            };
        final String[] Brunei = new String[] {
               "brunejsk\u00fd \u010das",
               "BNT",
               "Brunei Summer Time",
               "BNST",
               "Brunei Time",
               "BNT",
            };
        final String[] Iran = new String[] {
               "ir\u00e1nsky \u0161tandardn\u00fd \u010das",
               "IRST",
               "ir\u00e1nsky letn\u00fd \u010das",
               "IRDT",
               "ir\u00e1nsky \u010das",
               "IRT",
            };
        final String[] Easter = new String[] {
               "\u0161tandardn\u00fd \u010das Ve\u013ekono\u010dn\u00e9ho ostrova",
               "EAST",
               "letn\u00fd \u010das Ve\u013ekono\u010dn\u00e9ho ostrova",
               "EASST",
               "\u010das Ve\u013ekono\u010dn\u00e9ho ostrova",
               "EAST",
            };
        final String[] Mexico_Northwest = new String[] {
               "severoz\u00e1padn\u00fd mexick\u00fd \u0161tandardn\u00fd \u010das",
               "PST",
               "severoz\u00e1padn\u00fd mexick\u00fd letn\u00fd \u010das",
               "PDT",
               "severoz\u00e1padn\u00fd mexick\u00fd \u010das",
               "PT",
            };
        final String[] DumontDUrville = new String[] {
               "\u010das stanice Dumonta d\u2019Urvillea",
               "DDUT",
               "Dumont-d'Urville Summer Time",
               "DDUST",
               "Dumont-d'Urville Time",
               "DDUT",
            };
        final String[] Tajikistan = new String[] {
               "tad\u017eick\u00fd \u010das",
               "TJT",
               "Tajikistan Summer Time",
               "TJST",
               "Tajikistan Time",
               "TJT",
            };
        final String[] Tonga = new String[] {
               "ton\u017esk\u00fd \u0161tandardn\u00fd \u010das",
               "TOT",
               "ton\u017esk\u00fd letn\u00fd \u010das",
               "TOST",
               "ton\u017esk\u00fd \u010das",
               "TOT",
            };
        final String[] Bangladesh = new String[] {
               "banglad\u00e9\u0161sky \u0161tandardn\u00fd \u010das",
               "BDT",
               "banglad\u00e9\u0161sky letn\u00fd \u010das",
               "BDST",
               "banglad\u00e9\u0161sky \u010das",
               "BDT",
            };
        final String[] Peru = new String[] {
               "peru\u00e1nsky \u0161tandardn\u00fd \u010das",
               "PET",
               "peru\u00e1nsky letn\u00fd \u010das",
               "PEST",
               "peru\u00e1nsky \u010das",
               "PET",
            };
        final String[] Greenland_Western = new String[] {
               "z\u00e1padogr\u00f3nsky \u0161tandardn\u00fd \u010das",
               "WGT",
               "z\u00e1padogr\u00f3nsky letn\u00fd \u010das",
               "WGST",
               "z\u00e1padogr\u00f3nsky \u010das",
               "WGT",
            };
        final String[] Ecuador = new String[] {
               "ekv\u00e1dorsk\u00fd \u010das",
               "ECT",
               "Ecuador Summer Time",
               "ECST",
               "Ecuador Time",
               "ECT",
            };
        final String[] Greenland_Eastern = new String[] {
               "v\u00fdchodogr\u00f3nsky \u0161tandardn\u00fd \u010das",
               "EGT",
               "v\u00fdchodogr\u00f3nsky letn\u00fd \u010das",
               "EGST",
               "v\u00fdchodogr\u00f3nsky \u010das",
               "EGT",
            };
        final String[] Gulf = new String[] {
               "\u0161tandardn\u00fd \u010das Perzsk\u00e9ho z\u00e1livu",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "v\u00fdchodoindon\u00e9zsky \u010das",
               "WIT",
               "East Indonesia Summer Time",
               "EIST",
               "East Indonesia Time",
               "WIT",
            };
        final String[] Korea = new String[] {
               "k\u00f3rejsk\u00fd \u0161tandardn\u00fd \u010das",
               "KST",
               "k\u00f3rejsk\u00fd letn\u00fd \u010das",
               "KDT",
               "k\u00f3rejsk\u00fd \u010das",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "z\u00e1padoaustr\u00e1lsky \u0161tandardn\u00fd \u010das",
               "AWST",
               "z\u00e1padoaustr\u00e1lsky letn\u00fd \u010das",
               "AWDT",
               "z\u00e1padoaustr\u00e1lsky \u010das",
               "AWT",
            };
        final String[] Kyrgystan = new String[] {
               "kirgizsk\u00fd \u010das",
               "KGT",
               "Kirgizstan Summer Time",
               "KGST",
               "Kirgizstan Time",
               "KGT",
            };
        final String[] Indonesia_Western = new String[] {
               "z\u00e1padoindon\u00e9zsky \u010das",
               "WIB",
               "West Indonesia Summer Time",
               "WIST",
               "West Indonesia Time",
               "WIB",
            };
        final String[] Australia_Eastern = new String[] {
               "v\u00fdchodoaustr\u00e1lsky \u0161tandardn\u00fd \u010das",
               "AEST",
               "v\u00fdchodoaustr\u00e1lsky letn\u00fd \u010das",
               "AEDT",
               "v\u00fdchodoaustr\u00e1lsky \u010das",
               "AET",
            };
        final String[] French_Guiana = new String[] {
               "franc\u00fazskoguyansk\u00fd \u010das",
               "GFT",
               "French Guiana Summer Time",
               "GFST",
               "French Guiana Time",
               "GFT",
            };
        final String[] Colombia = new String[] {
               "kolumbijsk\u00fd \u0161tandardn\u00fd \u010das",
               "COT",
               "kolumbijsk\u00fd letn\u00fd \u010das",
               "COST",
               "kolumbijsk\u00fd \u010das",
               "COT",
            };
        final String[] Chile = new String[] {
               "\u010dilsk\u00fd \u0161tandardn\u00fd \u010das",
               "CLT",
               "\u010dilsk\u00fd letn\u00fd \u010das",
               "CLST",
               "\u010dilsk\u00fd \u010das",
               "CLT",
            };
        final String[] Gilbert_Islands = new String[] {
               "\u010das Gilbertov\u00fdch ostrovov",
               "GILT",
               "Gilbert Is. Summer Time",
               "GILST",
               "Gilbert Is. Time",
               "GILT",
            };
        final String[] America_Mountain = new String[] {
               "severoamerick\u00fd horsk\u00fd \u0161tandardn\u00fd \u010das",
               "MST",
               "severoamerick\u00fd horsk\u00fd letn\u00fd \u010das",
               "MDT",
               "severoamerick\u00fd horsk\u00fd \u010das",
               "MT",
            };
        final String[] Marquesas = new String[] {
               "mark\u00e9zsky \u010das",
               "MART",
               "Marquesas Summer Time",
               "MARST",
               "Marquesas Time",
               "MART",
            };
        final String[] Arabian = new String[] {
               "arabsk\u00fd \u0161tandardn\u00fd \u010das",
               "AST",
               "arabsk\u00fd letn\u00fd \u010das",
               "ADT",
               "arabsk\u00fd \u010das",
               "AT",
            };
        final String[] Alaska = new String[] {
               "alja\u0161sk\u00fd \u0161tandardn\u00fd \u010das",
               "AKST",
               "alja\u0161sk\u00fd letn\u00fd \u010das",
               "AKDT",
               "alja\u0161sk\u00fd \u010das",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "vladivostock\u00fd \u0161tandardn\u00fd \u010das",
               "VLAT",
               "vladivostock\u00fd letn\u00fd \u010das",
               "VLAST",
               "vladivostock\u00fd \u010das",
               "VLAT",
            };
        final String[] Chamorro = new String[] {
               "chamorrsk\u00fd \u0161tandardn\u00fd \u010das",
               "ChST",
               "Chamorro Daylight Time",
               "ChDT",
               "Chamorro Time",
               "ChT",
            };
        final String[] Irkutsk = new String[] {
               "irkutsk\u00fd \u0161tandardn\u00fd \u010das",
               "IRKT",
               "irkutsk\u00fd letn\u00fd \u010das",
               "IRKST",
               "irkutsk\u00fd \u010das",
               "IRKT",
            };
        final String[] Georgia = new String[] {
               "gruz\u00ednsky \u0161tandardn\u00fd \u010das",
               "GET",
               "gruz\u00ednsky letn\u00fd \u010das",
               "GEST",
               "gruz\u00ednsky \u010das",
               "GET",
            };
        final String[] Tokelau = new String[] {
               "tokelausk\u00fd \u010das",
               "TKT",
               "Tokelau Summer Time",
               "TKST",
               "Tokelau Time",
               "TKT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "\u010das Papuy-Novej Guiney",
               "PGT",
               "Papua New Guinea Summer Time",
               "PGST",
               "Papua New Guinea Time",
               "PGT",
            };
        final String[] Noronha = new String[] {
               "\u0161tandardn\u00fd \u010das s\u00faostrovia Fernando de Noronha",
               "FNT",
               "letn\u00fd \u010das s\u00faostrovia Fernando de Noronha",
               "FNST",
               "\u010das s\u00faostrovia Fernando de Noronha",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "\u010dojbalsansk\u00fd \u0161tandardn\u00fd \u010das",
               "CHOT",
               "\u010dojbalsansk\u00fd letn\u00fd \u010das",
               "CHOST",
               "\u010dojbalsansk\u00fd \u010das",
               "CHOT",
            };
        final String[] Brasilia = new String[] {
               "braz\u00edlsky \u0161tandardn\u00fd \u010das",
               "BRT",
               "braz\u00edlsky letn\u00fd \u010das",
               "BRST",
               "braz\u00edlsky \u010das",
               "BRT",
            };
        final String[] China = new String[] {
               "\u010d\u00ednsky \u0161tandardn\u00fd \u010das",
               "CST",
               "\u010d\u00ednsky letn\u00fd \u010das",
               "CDT",
               "\u010d\u00ednsky \u010das",
               "CT",
            };
        final String[] Armenia = new String[] {
               "arm\u00e9nsky \u0161tandardn\u00fd \u010das",
               "AMT",
               "arm\u00e9nsky letn\u00fd \u010das",
               "AMST",
               "arm\u00e9nsky \u010das",
               "AMT",
            };
        final String[] Samara = new String[] {
               "Samarsk\u00fd \u0161tandardn\u00fd \u010das",
               "SAMT",
               "Samarsk\u00fd letn\u00fd \u010das",
               "SAMST",
               "Samarsk\u00fd \u010das",
               "SAMT",
            };
        final String[] India = new String[] {
               "indick\u00fd \u010das",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Cook = new String[] {
               "\u0161tandardn\u00fd \u010das Cookov\u00fdch ostrovov",
               "CKT",
               "letn\u00fd \u010das Cookov\u00fdch ostrovov",
               "CKHST",
               "\u010das Cookov\u00fdch ostrovov",
               "CKT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London",
                new String[] {
                    "greenwichsk\u00fd \u010das",
                    "GMT",
                    "britsk\u00fd letn\u00fd \u010das",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", Atlantic },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Antarctica/Syowa", Syowa },
            { "Indian/Reunion", Reunion },
            { "Pacific/Palau", Palau },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Western },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Africa/Bamako", GMT },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Pacific/Bougainville", New_Zealand },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", Alaska },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Antarctica/Troll", GMT },
            { "Europe/Samara", Samara },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "greenwichsk\u00fd \u010das",
                    "GMT",
                    "\u00edrsky \u0161tandardn\u00fd \u010das",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "Pacific/Truk", Truk },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Saipan", Chamorro },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Taipei", Taipei },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Further_Eastern },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Cancun", America_Eastern },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Kamchatka },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Tehran", Iran },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "Asia/Srednekolymsk", Singapore },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "Australia/Lindeman", Australia_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
