/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_sr_Latn extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "Centralno-afri\u010dko vreme",
               "CAT",
               "Central African Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "Moskva standardno vreme",
               "MSK",
               "Moskva letnje ra\u010dunanje vremena",
               "MSD",
               "Moskva vreme",
               "MT",
            };
        final String[] Japan = new String[] {
               "Japansko standardno vreme",
               "JST",
               "Japansko letnje ra\u010dunanje vremena",
               "JDT",
               "Japansko vreme",
               "JT",
            };
        final String[] Pakistan = new String[] {
               "Pakistan standardno vreme",
               "PKT",
               "Pakistan letnje ra\u010dunanje vremena",
               "PKST",
               "Pakistan vreme",
               "PKT",
            };
        final String[] Taipei = new String[] {
               "Taipei standardno vreme",
               "CST",
               "Taipei letnje ra\u010dunanje vremena",
               "CDT",
               "Taipei vreme",
               "CT",
            };
        final String[] Hovd = new String[] {
               "Hovd standardno vreme",
               "HOVT",
               "Hovd letnje ra\u010dunanje vremena",
               "HOVST",
               "Hovd vreme",
               "HOVT",
            };
        final String[] Magadan = new String[] {
               "Magadan standardno vreme",
               "MAGT",
               "Magadan letnje ra\u010dunanje vremena",
               "MAGST",
               "Magadan vreme",
               "MAGT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Australijsko centralno zapadno standardno vreme",
               "ACWST",
               "Australijsko centralno zapadno letnje ra\u010dunanje vremena",
               "ACWDT",
               "Australijsko centralno zapadno vreme",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "Srednjeevropsko standardno vreme",
               "CET",
               "Srednjeevropsko letnje ra\u010dunanje vremena",
               "CEST",
               "Srednjeevropsko vreme",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "Sahalin standardno vreme",
               "SAKT",
               "Sahalin letnje ra\u010dunanje vremena",
               "SAKST",
               "Sahalin vreme",
               "SAKT",
            };
        final String[] Paraguay = new String[] {
               "Paragvaj standardno vreme",
               "PYT",
               "Paragvaj letnje ra\u010dunanje vremena",
               "PYST",
               "Paragvaj vreme",
               "PYT",
            };
        final String[] Acre = new String[] {
               "Akre standardno vreme",
               "ACT",
               "Akre letnje ra\u010dunanje vremena",
               "ACST",
               "Akre vreme",
               "ACT",
            };
        final String[] Malaysia = new String[] {
               "Malezija vreme",
               "MYT",
               "Malaysia Summer Time",
               "MYST",
               "Malaysia Time",
               "MYT",
            };
        final String[] America_Eastern = new String[] {
               "Severnoameri\u010dki Isto\u010dno standardno vreme",
               "EST",
               "Severnoameri\u010dki Isto\u010dno letnje ra\u010dunanje vremena",
               "EDT",
               "Severnoameri\u010dki Isto\u010dno vreme",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "Lord Hov standardno vreme",
               "LHST",
               "Lord Hov letnje ra\u010dunanje vremena",
               "LHDT",
               "Lord Hov vreme",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "Novi Zeland standardno vreme",
               "NZST",
               "Novi Zeland letnje ra\u010dunanje vremena",
               "NZDT",
               "Novi Zeland vreme",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "Indijsko okeansko vreme",
               "IOT",
               "Indian Ocean Territory Summer Time",
               "IOST",
               "Indian Ocean Territory Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "Jakutsk standardno vreme",
               "YAKT",
               "Jakutsk letnje ra\u010dunanje vremena",
               "YAKST",
               "Jakutsk vreme",
               "YAKT",
            };
        final String[] Mauritius = new String[] {
               "Mauricijus standardno vreme",
               "MUT",
               "Mauricijus letnje ra\u010dunanje vremena",
               "MUST",
               "Mauricijus vreme",
               "MUT",
            };
        final String[] Africa_Eastern = new String[] {
               "Isto\u010dno-afri\u010dko vreme",
               "EAT",
               "Eastern African Summer Time",
               "EAST",
               "Eastern Africa Time",
               "EAT",
            };
        final String[] East_Timor = new String[] {
               "Isto\u010dni timor vreme",
               "TLT",
               "Timor-Leste Summer Time",
               "TLST",
               "Timor-Leste Time",
               "TLT",
            };
        final String[] Solomon = new String[] {
               "Solomonska Ostrva vreme",
               "SBT",
               "Solomon Is. Summer Time",
               "SBST",
               "Solomon Is. Time",
               "SBT",
            };
        final String[] Kosrae = new String[] {
               "Ko\u0161re vreme",
               "KOST",
               "Kosrae Summer Time",
               "KOSST",
               "Kosrae Time",
               "KOST",
            };
        final String[] Marshall_Islands = new String[] {
               "Mar\u0161alska Ostrva vreme",
               "MHT",
               "Marshall Islands Summer Time",
               "MHST",
               "Marshall Islands Time",
               "MHT",
            };
        final String[] Europe_Eastern = new String[] {
               "Isto\u010dnoevropsko standardno vreme",
               "EET",
               "Isto\u010dnoevropsko letnje ra\u010dunanje vremena",
               "EEST",
               "Isto\u010dnoevropsko vreme",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "Njufaundlend standardno vreme",
               "NST",
               "Njufaundlend letnje ra\u010dunanje vremena",
               "NDT",
               "Njufaundlend vreme",
               "NT",
            };
        final String[] Afghanistan = new String[] {
               "Avganistan vreme",
               "AFT",
               "Afghanistan Summer Time",
               "AFST",
               "Afghanistan Time",
               "AFT",
            };
        final String[] Hong_Kong = new String[] {
               "Hong Kong standardno vreme",
               "HKT",
               "Hong Kong letnje ra\u010dunanje vremena",
               "HKST",
               "Hong Kong vreme",
               "HKT",
            };
        final String[] Argentina_Western = new String[] {
               "Zapadna Argentina standardno vreme",
               "ART",
               "Zapadna Argentina letnje ra\u010dunanje vremena",
               "ARST",
               "Zapadna Argentina vreme",
               "ART",
            };
        final String[] Atlantic = new String[] {
               "Atlansko standardno vreme",
               "AST",
               "Atlansko ltnje ra\u010dunanje vremena",
               "ADT",
               "Atlansko vreme",
               "AT",
            };
        final String[] Ponape = new String[] {
               "Ponpej vreme",
               "PONT",
               "Pohnpei Summer Time",
               "PONST",
               "Ponape Time",
               "PONT",
            };
        final String[] Bolivia = new String[] {
               "Bolivija vreme",
               "BOT",
               "Bolivia Summer Time",
               "BOST",
               "Bolivia Time",
               "BOT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Sen Pjer i Mikelon standardno vreme",
               "PMST",
               "Sen Pjer i Mikelon letnje ra\u010dunanje vremena",
               "PMDT",
               "Sen Pjer i Mikelon vreme",
               "PMT",
            };
        final String[] Indochina = new String[] {
               "Indokina vreme",
               "ICT",
               "Indochina Summer Time",
               "ICST",
               "Indochina Time",
               "ICT",
            };
        final String[] Yekaterinburg = new String[] {
               "Jekaterinburg standardno vreme",
               "YEKT",
               "Jekaterinburg letnje ra\u010dunanje vremena",
               "YEKST",
               "Jekaterinburg vreme",
               "YEKT",
            };
        final String[] Maldives = new String[] {
               "Maldivi vreme",
               "MVT",
               "Maldives Summer Time",
               "MVST",
               "Maldives Time",
               "MVT",
            };
        final String[] Tahiti = new String[] {
               "Tahiti vreme",
               "TAHT",
               "Tahiti Summer Time",
               "TAHST",
               "Tahiti Time",
               "TAHT",
            };
        final String[] Israel = new String[] {
               "Izraelsko standardno vreme",
               "IST",
               "Izraelsko letnje ra\u010dunanje vremena",
               "IDT",
               "Izraelsko vreme",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "Centralno-indonezijsko vreme",
               "WITA",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "WITA",
            };
        final String[] Wallis = new String[] {
               "Valis i Futuna Ostrva vreme",
               "WFT",
               "Wallis & Futuna Summer Time",
               "WFST",
               "Wallis & Futuna Time",
               "WFT",
            };
        final String[] Africa_Southern = new String[] {
               "Ju\u017eno-afri\u010dko vreme",
               "SAST",
               "South Africa Summer Time",
               "SAST",
               "South Africa Time",
               "SAT",
            };
        final String[] Syowa = new String[] {
               "\u0160ova vreme",
               "SYOT",
               "Syowa Summer Time",
               "SYOST",
               "Syowa Time",
               "SYOT",
            };
        final String[] Line_Islands = new String[] {
               "Ostrva Lajn vreme",
               "LINT",
               "Line Is. Summer Time",
               "LINST",
               "Line Is. Time",
               "LINT",
            };
        final String[] Uzbekistan = new String[] {
               "Uzbekistan standardno vreme",
               "UZT",
               "Uzbekistan letnje ra\u010dunanje vremena",
               "UZST",
               "Uzbekistan vreme",
               "UZT",
            };
        final String[] Omsk = new String[] {
               "Omsk standardno vreme",
               "OMST",
               "Omsk letnje ra\u010dunanje vremena",
               "OMSST",
               "Omsk vreme",
               "OMST",
            };
        final String[] Seychelles = new String[] {
               "Sej\u0161eli vreme",
               "SCT",
               "Seychelles Summer Time",
               "SCST",
               "Seychelles Time",
               "SCT",
            };
        final String[] Uruguay = new String[] {
               "Urugvaj standardno vreme",
               "UYT",
               "Urugvaj letnje ra\u010dunanje vremena",
               "UYST",
               "Urugvaj vreme",
               "UYT",
            };
        final String[] Nepal = new String[] {
               "Nepal vreme",
               "NPT",
               "Nepal Summer Time",
               "NPST",
               "Nepal Time",
               "NPT",
            };
        final String[] Mongolia = new String[] {
               "Ulan Bator standardno vreme",
               "ULAT",
               "Ulan Bator letnje ra\u010dunanje vremena",
               "ULAST",
               "Ulan Bator vreme",
               "ULAT",
            };
        final String[] America_Central = new String[] {
               "Severnoameri\u010dki Centralno standardno vreme",
               "CST",
               "Severnoameri\u010dki Centralno letnje ra\u010dunanje vremena",
               "CDT",
               "Severnoameri\u010dki Centralno vreme",
               "CT",
            };
        final String[] Truk = new String[] {
               "\u010cuuk vreme",
               "CHUT",
               "Chuuk Summer Time",
               "CHUST",
               "Chuuk Time",
               "CHUT",
            };
        final String[] Niue = new String[] {
               "Niue vreme",
               "NUT",
               "Niue Summer Time",
               "NUST",
               "Niue Time",
               "NUT",
            };
        final String[] Wake = new String[] {
               "Vejk ostrvo vreme",
               "WAKT",
               "Wake Summer Time",
               "WAKST",
               "Wake Time",
               "WAKT",
            };
        final String[] Falkland = new String[] {
               "Folklandska Ostrva standardno vreme",
               "FKT",
               "Folklandska Ostrva letnje ra\u010dunanje vremena",
               "FKST",
               "Folklandska Ostrva vreme",
               "FKT",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatu standardno vreme",
               "VUT",
               "Vanuatu letnje ra\u010dunanje vremena",
               "VUST",
               "Vanuatu vreme",
               "VUT",
            };
        final String[] Novosibirsk = new String[] {
               "Novosibirsk standardno vreme",
               "NOVT",
               "Novosibirsk letnje ra\u010dunanje vremena",
               "NOVST",
               "Novosibirsk vreme",
               "NOVT",
            };
        final String[] Singapore = new String[] {
               "Singapur standardno vreme",
               "SRET",
               "Srednekolymsk Daylight Time",
               "SREDT",
               "Srednekolymsk Time",
               "SRET",
            };
        final String[] Azores = new String[] {
               "Azori standardno vreme",
               "AZOT",
               "Azori letnje ra\u010dunanje vremena",
               "AZOST",
               "Azori vreme",
               "AZOT",
            };
        final String[] Apia = new String[] {
               "Apija standardno vreme",
               "WSST",
               "Apija letnje ra\u010dunanje vremena",
               "WSDT",
               "Apija vreme",
               "WST",
            };
        final String[] Bhutan = new String[] {
               "Butan vreme",
               "BTT",
               "Bhutan Summer Time",
               "BTST",
               "Bhutan Time",
               "BTT",
            };
        final String[] Suriname = new String[] {
               "Surinam vreme",
               "SRT",
               "Suriname Summer Time",
               "SRST",
               "Suriname Time",
               "SRT",
            };
        final String[] Nauru = new String[] {
               "Nauru vreme",
               "NRT",
               "Nauru Summer Time",
               "NRST",
               "Nauru Time",
               "NRT",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnojarsk standardno vreme",
               "KRAT",
               "Krasnojarsk letnje ra\u010dunanje vremena",
               "KRAST",
               "Krasnojarsk vreme",
               "KRAT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Zapadno-kazahstansko vreme",
               "AQTT",
               "Aqtau Summer Time",
               "AQTST",
               "Aqtau Time",
               "AQTT",
            };
        final String[] Myanmar = new String[] {
               "Mijanmar vreme",
               "MMT",
               "Myanmar Summer Time",
               "MMST",
               "Myanmar Time",
               "MMT",
            };
        final String[] Christmas = new String[] {
               "Bo\u017ei\u0107no ostrvo vreme",
               "CXT",
               "Christmas Island Summer Time",
               "CXST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Amazon = new String[] {
               "Amazon standardno vreme",
               "AMT",
               "Amazon letnje ra\u010dunanje vremena",
               "AMST",
               "Amazon vreme",
               "AMT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Isto\u010dno-kazahstansko vreme",
               "ALMT",
               "Alma-Ata Summer Time",
               "ALMST",
               "Alma-Ata Time",
               "ALMT",
            };
        final String[] Fiji = new String[] {
               "Fid\u017ei standardno vreme",
               "FJT",
               "Fid\u017ei letnje ra\u010dunanje vremena",
               "FJST",
               "Fid\u017ei vreme",
               "FJT",
            };
        final String[] Reunion = new String[] {
               "Reinion vreme",
               "RET",
               "Reunion Summer Time",
               "REST",
               "Reunion Time",
               "RET",
            };
        final String[] Cocos = new String[] {
               "Kokos (Keling) Ostrva vreme",
               "CCT",
               "Cocos Islands Summer Time",
               "CCST",
               "Cocos Islands Time",
               "CCT",
            };
        final String[] Chatham = new String[] {
               "\u010catam standardno vreme",
               "CHAST",
               "\u010catam letnje ra\u010dunanje vremena",
               "CHADT",
               "\u010catam vreme",
               "CHAT",
            };
        final String[] Vostok = new String[] {
               "Vostok vreme",
               "VOST",
               "Vostok Summer Time",
               "VOSST",
               "Vostok Time",
               "VOST",
            };
        final String[] Argentina = new String[] {
               "Argentina standardno vreme",
               "ART",
               "Argentina letnje ra\u010dunanje vremena",
               "ARST",
               "Argentina vreme",
               "ART",
            };
        final String[] Gambier = new String[] {
               "Gambije vreme",
               "GAMT",
               "Gambier Summer Time",
               "GAMST",
               "Gambier Time",
               "GAMT",
            };
        final String[] Kamchatka = new String[] {
               "Petropavlovsko-kam\u010datsko standardno vreme",
               "PETT",
               "Petropavlovsko-kam\u010datsko letnje ra\u010dunanje vremena",
               "PETST",
               "Petropavlovsko-kam\u010datsko vreme",
               "PETT",
            };
        final String[] Tuvalu = new String[] {
               "Tuvalu vreme",
               "TVT",
               "Tuvalu Summer Time",
               "TVST",
               "Tuvalu Time",
               "TVT",
            };
        final String[] Galapagos = new String[] {
               "Galapagos vreme",
               "GALT",
               "Galapagos Summer Time",
               "GALST",
               "Galapagos Time",
               "GALT",
            };
        final String[] Macquarie = new String[] {
               "Ostrvo Makveri vreme",
               "MIST",
               "Macquarie Island Daylight Time",
               "MIDT",
               "Macquarie Island Time",
               "MIST",
            };
        final String[] Venezuela = new String[] {
               "Venecuela vreme",
               "VET",
               "Venezuela Summer Time",
               "VEST",
               "Venezuela Time",
               "VET",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Havajsko-aleutsko standardno vreme",
               "HAST",
               "Havajsko-aleutsko letnje ra\u010dunanje vremena",
               "HADT",
               "Havajsko-aleutsko vreme",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "Australijsko centralno standardno vreme",
               "ACST",
               "Australijsko centralno letnje ra\u010dunanje vremena",
               "ACDT",
               "Australijsko centralno vreme",
               "ACT",
            };
        final String[] America_Pacific = new String[] {
               "Severnoameri\u010dki Pacifi\u010dko standardno vreme",
               "PST",
               "Severnoameri\u010dki Pacifi\u010dko letnje ra\u010dunanje vremena",
               "PDT",
               "Severnoameri\u010dki Pacifi\u010dko vreme",
               "PT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Feniks ostrva vreme",
               "PHOT",
               "Phoenix Is. Summer Time",
               "PHOST",
               "Phoenix Is. Time",
               "PHOT",
            };
        final String[] Turkmenistan = new String[] {
               "Turkmenistan standardno vreme",
               "TMT",
               "Turkmenistan letnje ra\u010dunanje vremena",
               "TMST",
               "Turkmenistan vreme",
               "TMT",
            };
        final String[] Europe_Western = new String[] {
               "Zapadnoevropsko standardno vreme",
               "WET",
               "Zapadnoevropsko letnje ra\u010dunanje vremena",
               "WEST",
               "Zapadnoevropsko vreme",
               "WET",
            };
        final String[] Cape_Verde = new String[] {
               "Zelenortska Ostrva standardno vreme",
               "CVT",
               "Zelenortska Ostrva letnje ra\u010dunanje vremena",
               "CVST",
               "Zelenortska Ostrva vreme",
               "CVT",
            };
        final String[] Norfolk = new String[] {
               "Norfolk Ostrvo vreme",
               "NFT",
               "Norfolk Summer Time",
               "NFST",
               "Norfolk Time",
               "NFT",
            };
        final String[] Guyana = new String[] {
               "Gvajana vreme",
               "GYT",
               "Guyana Summer Time",
               "GYST",
               "Guyana Time",
               "GYT",
            };
        final String[] Pitcairn = new String[] {
               "Pitkern vreme",
               "PST",
               "Pitcairn Daylight Time",
               "PDT",
               "Pitcairn Time",
               "PT",
            };
        final String[] Rothera = new String[] {
               "Rotera vreme",
               "ROTT",
               "Rothera Summer Time",
               "ROTST",
               "Rothera Time",
               "ROTT",
            };
        final String[] Samoa = new String[] {
               "Samoa standardno vreme",
               "SST",
               "Samoa letnje ra\u010dunanje vremena",
               "SDT",
               "Samoa vreme",
               "ST",
            };
        final String[] Palau = new String[] {
               "Palau vreme",
               "PWT",
               "Palau Summer Time",
               "PWST",
               "Palau Time",
               "PWT",
            };
        final String[] Europe_Further_Eastern = new String[] {
               "dalji istok Evrope",
               "MSK",
               "Moscow Daylight Time",
               "MSD",
               "Moscow Time",
               "MT",
            };
        final String[] Azerbaijan = new String[] {
               "Azerbejd\u017ean standardno vreme",
               "AZT",
               "Azerbejd\u017ean letnje ra\u010dunanje vremena",
               "AZST",
               "Azerbejd\u017ean vreme",
               "AZT",
            };
        final String[] Mawson = new String[] {
               "Moson vreme",
               "MAWT",
               "Mawson Summer Time",
               "MAWST",
               "Mawson Time",
               "MAWT",
            };
        final String[] Mexico_Pacific = new String[] {
               "Meksi\u010dki Pacifik standardno vreme",
               "MST",
               "Meksi\u010dki Pacifik letnje ra\u010dunanje vremena",
               "MDT",
               "Meksi\u010dki Pacifik",
               "MT",
            };
        final String[] Davis = new String[] {
               "Dejvis vreme",
               "DAVT",
               "Davis Summer Time",
               "DAVST",
               "Davis Time",
               "DAVT",
            };
        final String[] Cuba = new String[] {
               "Kuba standardno vreme",
               "CST",
               "Kuba letnje ra\u010dunanje vremena",
               "CDT",
               "Kuba vreme",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "Zapadno-afri\u010dko standardno vreme",
               "CAT",
               "Zapadno-afri\u010dko letnje ra\u010dunanje vremena",
               "CAST",
               "Zapadno-afri\u010dko vreme",
               "CAT",
            };
        final String[] GMT = new String[] {
               "Srednje vreme po Grini\u010du",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
            };
        final String[] Philippines = new String[] {
               "Filipini standardno vreme",
               "PHT",
               "Filipini letnje ra\u010dunanje vremena",
               "PHST",
               "Filipini vreme",
               "PHT",
            };
        final String[] French_Southern = new String[] {
               "Francusko ju\u017eno i antarkti\u010dko vreme",
               "TFT",
               "French Southern & Antarctic Lands Summer Time",
               "TFST",
               "French Southern & Antarctic Lands Time",
               "TFT",
            };
        final String[] South_Georgia = new String[] {
               "Ju\u017ena D\u017eord\u017eija vreme",
               "GST",
               "South Georgia Daylight Time",
               "GDT",
               "South Georgia Time",
               "GT",
            };
        final String[] New_Caledonia = new String[] {
               "Nova Kaledonija standardno vreme",
               "NCT",
               "Nova Kaledonija letnje ra\u010dunanje vremena",
               "NCST",
               "Nova Kaledonija vreme",
               "NCT",
            };
        final String[] Brunei = new String[] {
               "Brunej Darusalum vreme",
               "BNT",
               "Brunei Summer Time",
               "BNST",
               "Brunei Time",
               "BNT",
            };
        final String[] Iran = new String[] {
               "Iran standardno vreme",
               "IRST",
               "Iran letnje ra\u010dunanje vremena",
               "IRDT",
               "Iran vreme",
               "IRT",
            };
        final String[] Easter = new String[] {
               "Uskr\u0161nja ostrva standardno vreme",
               "EAST",
               "Uskr\u0161nja ostrva letnje ra\u010dunanje vremena",
               "EASST",
               "Uskr\u0161nja ostrva vreme",
               "EAST",
            };
        final String[] Mexico_Northwest = new String[] {
               "Severozapadni Meksiko standardno vreme",
               "PST",
               "Severozapadni Meksiko letnje ra\u010dunanje vremena",
               "PDT",
               "Severni Meksiko",
               "PT",
            };
        final String[] DumontDUrville = new String[] {
               "Dimon d\u2019Urvil vreme",
               "DDUT",
               "Dumont-d'Urville Summer Time",
               "DDUST",
               "Dumont-d'Urville Time",
               "DDUT",
            };
        final String[] Tajikistan = new String[] {
               "Tad\u017eikistan vreme",
               "TJT",
               "Tajikistan Summer Time",
               "TJST",
               "Tajikistan Time",
               "TJT",
            };
        final String[] Tonga = new String[] {
               "Tonga standardno vreme",
               "TOT",
               "Tonga letnje ra\u010dunanje vremena",
               "TOST",
               "Tonga vreme",
               "TOT",
            };
        final String[] Bangladesh = new String[] {
               "Banglade\u0161 standardno vreme",
               "BDT",
               "Banglade\u0161 letnje ra\u010dunanje vremena",
               "BDST",
               "Banglade\u0161 vreme",
               "BDT",
            };
        final String[] Peru = new String[] {
               "Peru standardno vreme",
               "PET",
               "Peru letnje ra\u010dunanje vremena",
               "PEST",
               "Peru vreme",
               "PET",
            };
        final String[] Greenland_Western = new String[] {
               "Zapadni Grenland standardno vreme",
               "WGT",
               "Zapadni Grenland letnje ra\u010dunanje vremena",
               "WGST",
               "Zapadni Grenland vreme",
               "WGT",
            };
        final String[] Ecuador = new String[] {
               "Ekvador vreme",
               "ECT",
               "Ecuador Summer Time",
               "ECST",
               "Ecuador Time",
               "ECT",
            };
        final String[] Greenland_Eastern = new String[] {
               "Isto\u010dni Grenland standardno vreme",
               "EGT",
               "Isto\u010dni Grenland letnje ra\u010dunanje vremena",
               "EGST",
               "Isto\u010dni Grenland vreme",
               "EGT",
            };
        final String[] Gulf = new String[] {
               "Zalivsko vreme",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Isto\u010dno-indonezijsko vreme",
               "WIT",
               "East Indonesia Summer Time",
               "EIST",
               "East Indonesia Time",
               "WIT",
            };
        final String[] Korea = new String[] {
               "Korejsko standardno vreme",
               "KST",
               "Korejsko letnje ra\u010dunanje vremena",
               "KDT",
               "Korejsko vreme",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "Australijsko zapadno standardno vreme",
               "AWST",
               "Australijsko zapadno letnje ra\u010dunanje vremena",
               "AWDT",
               "Australijsko zapadno vreme",
               "AWT",
            };
        final String[] Kyrgystan = new String[] {
               "Kirgizstan vreme",
               "KGT",
               "Kirgizstan Summer Time",
               "KGST",
               "Kirgizstan Time",
               "KGT",
            };
        final String[] Indonesia_Western = new String[] {
               "Zapadno-indonezijsko vreme",
               "WIB",
               "West Indonesia Summer Time",
               "WIST",
               "West Indonesia Time",
               "WIB",
            };
        final String[] Australia_Eastern = new String[] {
               "Australijsko isto\u010dno standardno vreme",
               "AEST",
               "Australijsko isto\u010dno letnje ra\u010dunanje vremena",
               "AEDT",
               "Australijsko isto\u010dno vreme",
               "AET",
            };
        final String[] French_Guiana = new String[] {
               "Francuska Gvajana vreme",
               "GFT",
               "French Guiana Summer Time",
               "GFST",
               "French Guiana Time",
               "GFT",
            };
        final String[] Colombia = new String[] {
               "Kolumbija standardno vreme",
               "COT",
               "Kolumbija letnje ra\u010dunanje vremena",
               "COST",
               "Kolumbija vreme",
               "COT",
            };
        final String[] Chile = new String[] {
               "\u010cile standardno vreme",
               "CLT",
               "\u010cile letnje ra\u010dunanje vremena",
               "CLST",
               "\u010cile vreme",
               "CLT",
            };
        final String[] Gilbert_Islands = new String[] {
               "Gilbert ostrva vreme",
               "GILT",
               "Gilbert Is. Summer Time",
               "GILST",
               "Gilbert Is. Time",
               "GILT",
            };
        final String[] America_Mountain = new String[] {
               "Severnoameri\u010dki Planinsko standardno vreme",
               "MST",
               "Severnoameri\u010dki Planinsko letnje ra\u010dunanje vremena",
               "MDT",
               "Severnoameri\u010dki Planinsko vreme",
               "MT",
            };
        final String[] Marquesas = new String[] {
               "Markiz vreme",
               "MART",
               "Marquesas Summer Time",
               "MARST",
               "Marquesas Time",
               "MART",
            };
        final String[] Arabian = new String[] {
               "Arabijsko standardno vreme",
               "AST",
               "Arabijsko letnje ra\u010dunanje vremena",
               "ADT",
               "Arabijsko vreme",
               "AT",
            };
        final String[] Alaska = new String[] {
               "Aljaska, standardno vreme",
               "AKST",
               "Aljaska, letnje ra\u010dunanje vremena",
               "AKDT",
               "Aljaska",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "Vladivostok standardno vreme",
               "VLAT",
               "Vladivostok letnje ra\u010dunanje vremena",
               "VLAST",
               "Vladivostok vreme",
               "VLAT",
            };
        final String[] Chamorro = new String[] {
               "\u010camoro vreme",
               "ChST",
               "Chamorro Daylight Time",
               "ChDT",
               "Chamorro Time",
               "ChT",
            };
        final String[] Irkutsk = new String[] {
               "Irkuck standardno vreme",
               "IRKT",
               "Irkuck letnje ra\u010dunanje vremena",
               "IRKST",
               "Irkuck vreme",
               "IRKT",
            };
        final String[] Georgia = new String[] {
               "Gruzija standardno vreme",
               "GET",
               "Gruzija letnje ra\u010dunanje vremena",
               "GEST",
               "Gruzija vreme",
               "GET",
            };
        final String[] Tokelau = new String[] {
               "Tokelau vreme",
               "TKT",
               "Tokelau Summer Time",
               "TKST",
               "Tokelau Time",
               "TKT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Papua Nova Gvineja vreme",
               "PGT",
               "Papua New Guinea Summer Time",
               "PGST",
               "Papua New Guinea Time",
               "PGT",
            };
        final String[] Noronha = new String[] {
               "Fernando de Noronja standardno vreme",
               "FNT",
               "Fernando de Noronja letnje ra\u010dunanje vremena",
               "FNST",
               "Fernando de Noronja vreme",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "\u010cojbalsan standardno vreme",
               "CHOT",
               "\u010cojbalsan letnje ra\u010dunanje vremena",
               "CHOST",
               "\u010cojbalsan vreme",
               "CHOT",
            };
        final String[] Brasilia = new String[] {
               "Brazilija standardno vreme",
               "BRT",
               "Brazilija letnje ra\u010dunanje vremena",
               "BRST",
               "Brazilija vreme",
               "BRT",
            };
        final String[] China = new String[] {
               "Kinesko standardno vreme",
               "CST",
               "Kina letnje ra\u010dunanje vremena",
               "CDT",
               "Kina vreme",
               "CT",
            };
        final String[] Armenia = new String[] {
               "Jermenija standardno vreme",
               "AMT",
               "Jermenija letnje ra\u010dunanje vremena",
               "AMST",
               "Jermenija vreme",
               "AMT",
            };
        final String[] Samara = new String[] {
               "Samara standardno vreme",
               "SAMT",
               "Samara letnje ra\u010dunanje vremena",
               "SAMST",
               "Samara vreme",
               "SAMT",
            };
        final String[] India = new String[] {
               "Indijsko standardno vreme",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Cook = new String[] {
               "Kukova ostrva standardno vreme",
               "CKT",
               "Kukova ostrva polu-letnje ra\u010dunanje vremena",
               "CKHST",
               "Kukova ostrva vreme",
               "CKT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London",
                new String[] {
                    "Srednje vreme po Grini\u010du",
                    "GMT",
                    "Britanija letnje ra\u010dunanje vremena",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Eirunepe", Acre },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", Atlantic },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Antarctica/Syowa", Syowa },
            { "Indian/Reunion", Reunion },
            { "Pacific/Palau", Palau },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Western },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Africa/Bamako", GMT },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Pacific/Bougainville", New_Zealand },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", Alaska },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Antarctica/Troll", GMT },
            { "Europe/Samara", Samara },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "Srednje vreme po Grini\u010du",
                    "GMT",
                    "Irska standardno vreme",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "Pacific/Truk", Truk },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Saipan", Chamorro },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Taipei", Taipei },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Further_Eastern },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Cancun", America_Eastern },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Rio_Branco", Acre },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Kamchatka },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Tehran", Iran },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "Asia/Srednekolymsk", Singapore },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "Australia/Lindeman", Australia_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
