/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_sw extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "Saa za Afrika ya Kati",
               "CAT",
               "Central African Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "Saa za Wastani za Moscow",
               "MSK",
               "Saa za Majira ya joto za Moscow",
               "MSD",
               "Saa za Moscow",
               "MT",
            };
        final String[] Japan = new String[] {
               "Saa Wastani za Japani",
               "JST",
               "Saa za Mchana za Japani",
               "JDT",
               "Saa za Japani",
               "JT",
            };
        final String[] Pakistan = new String[] {
               "Saa Wastani za Pakistani",
               "PKT",
               "Saa za Majira ya joto za Pakistani",
               "PKST",
               "Saa za Pakistani",
               "PKT",
            };
        final String[] Taipei = new String[] {
               "Saa Wastani za Taipei",
               "CST",
               "Saa za Mchana za Taipei",
               "CDT",
               "Saa za Taipei",
               "CT",
            };
        final String[] Hovd = new String[] {
               "Saa Wastani za Hovd",
               "HOVT",
               "Saa za Majira ya joto za Hovd",
               "HOVST",
               "Saa za Hovd",
               "HOVT",
            };
        final String[] Magadan = new String[] {
               "Saa Wastani za Magadani",
               "MAGT",
               "Saa za Majira ya joto za Magadan",
               "MAGST",
               "Saa za Magadan",
               "MAGT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Saa Wastani za Magharibi ya Kati ya Australia",
               "ACWST",
               "Saa za Mchana za Magharibi ya Kati ya Australia",
               "ACWDT",
               "Saa za Magharibi ya Kati ya Australia",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "Saa Wastani za Ulaya ya kati",
               "CET",
               "Saa za Majira ya joto za Ulaya ya Kati",
               "CEST",
               "Saa za Ulaya ya Kati",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "Saa Wastani za Sakhalin",
               "SAKT",
               "Saa za Majira ya joto za Sakhalin",
               "SAKST",
               "Saa za Sakhalin",
               "SAKT",
            };
        final String[] Paraguay = new String[] {
               "Saa Wastani za Paragwai",
               "PYT",
               "Saa za Majira ya joto za Paragwai",
               "PYST",
               "Saa za Paragwai",
               "PYT",
            };
        final String[] Malaysia = new String[] {
               "Saa za Malaysia",
               "MYT",
               "Malaysia Summer Time",
               "MYST",
               "Malaysia Time",
               "MYT",
            };
        final String[] America_Eastern = new String[] {
               "Saa za Wastani za Mashariki",
               "EST",
               "Saa za Mchana za Mashariki",
               "EDT",
               "Saa za Mashariki",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "Saa Wastani za Lord Howe",
               "LHST",
               "Saa za Mchana za Lord Howe",
               "LHDT",
               "Saa za Lord Howe",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "Saa Wastani za Nyuzilandi",
               "NZST",
               "Saa za Mchana za Nyuzilandi",
               "NZDT",
               "Saa za Nyuzilandi",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "Saa za Bahari Hindi",
               "IOT",
               "Indian Ocean Territory Summer Time",
               "IOST",
               "Indian Ocean Territory Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "Saa Wastani za Yakutsk",
               "YAKT",
               "Saa za Majira ya joto za Yakutsk",
               "YAKST",
               "Saa za Yakutsk",
               "YAKT",
            };
        final String[] Mauritius = new String[] {
               "Saa Wastani za Mauritius",
               "MUT",
               "Saa za Majira ya joto za Mauritius",
               "MUST",
               "Saa za Mauritius",
               "MUT",
            };
        final String[] Africa_Eastern = new String[] {
               "Saa za Afrika Mashariki",
               "EAT",
               "Eastern African Summer Time",
               "EAST",
               "Eastern Africa Time",
               "EAT",
            };
        final String[] East_Timor = new String[] {
               "Saa za Timor Mashariki",
               "TLT",
               "Timor-Leste Summer Time",
               "TLST",
               "Timor-Leste Time",
               "TLT",
            };
        final String[] Solomon = new String[] {
               "Saa za Visiwa vya Suleimani",
               "SBT",
               "Solomon Is. Summer Time",
               "SBST",
               "Solomon Is. Time",
               "SBT",
            };
        final String[] Kosrae = new String[] {
               "Saa za Kosrae",
               "KOST",
               "Kosrae Summer Time",
               "KOSST",
               "Kosrae Time",
               "KOST",
            };
        final String[] Marshall_Islands = new String[] {
               "Saa za Visiwa vya Marshall",
               "MHT",
               "Marshall Islands Summer Time",
               "MHST",
               "Marshall Islands Time",
               "MHT",
            };
        final String[] Europe_Eastern = new String[] {
               "Saa Wastani za Mashariki mwa Ulaya",
               "EET",
               "Saa za Majira ya joto za Mashariki mwa Ulaya",
               "EEST",
               "Saa za Mashariki mwa Ulaya",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "Saa za Wastani za Newfoundland",
               "NST",
               "Saa za Mchana za Newfoundland",
               "NDT",
               "Saa za Newfoundland",
               "NT",
            };
        final String[] Afghanistan = new String[] {
               "Saa za Afghanistani",
               "AFT",
               "Afghanistan Summer Time",
               "AFST",
               "Afghanistan Time",
               "AFT",
            };
        final String[] Hong_Kong = new String[] {
               "Saa Wastani za Hong Kong",
               "HKT",
               "Saa za Majira ya joto za Hong Kong",
               "HKST",
               "Saa za Hong Kong",
               "HKT",
            };
        final String[] Argentina_Western = new String[] {
               "Saa Wastani za Magharibi mwa Ajentina",
               "ART",
               "Saa za Majira ya joto za Magharibi mwa Ajentina",
               "ARST",
               "Saa za Magharibi mwa Ajentina",
               "ART",
            };
        final String[] Atlantic = new String[] {
               "Saa za Wastani za Atlantiki",
               "AST",
               "Saa za Mchana za Atlantiki",
               "ADT",
               "Saa za Atlantiki",
               "AT",
            };
        final String[] Ponape = new String[] {
               "Saa za Ponape",
               "PONT",
               "Pohnpei Summer Time",
               "PONST",
               "Ponape Time",
               "PONT",
            };
        final String[] Bolivia = new String[] {
               "Saa za Bolivia",
               "BOT",
               "Bolivia Summer Time",
               "BOST",
               "Bolivia Time",
               "BOT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Saa za Wastani ya Saint-Pierre na Miquelon",
               "PMST",
               "Saa za Mchana za Saint-Pierre na Miquelon",
               "PMDT",
               "Saa za Saint-Pierre na Miquelon",
               "PMT",
            };
        final String[] Indochina = new String[] {
               "Saa za Indochina",
               "ICT",
               "Indochina Summer Time",
               "ICST",
               "Indochina Time",
               "ICT",
            };
        final String[] Yekaterinburg = new String[] {
               "Saa Wastani za Yekaterinburg",
               "YEKT",
               "Saa za Majira ya joto za Yekaterinburg",
               "YEKST",
               "Saa za Yekaterinburg",
               "YEKT",
            };
        final String[] Maldives = new String[] {
               "Saa za Maldives",
               "MVT",
               "Maldives Summer Time",
               "MVST",
               "Maldives Time",
               "MVT",
            };
        final String[] Tahiti = new String[] {
               "Saa za Tahiti",
               "TAHT",
               "Tahiti Summer Time",
               "TAHST",
               "Tahiti Time",
               "TAHT",
            };
        final String[] Israel = new String[] {
               "Saa Wastani za Israeli",
               "IST",
               "Saa za Mchana za Israeli",
               "IDT",
               "Saa za Israeli",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "Saa za Indonesia ya Kati",
               "WITA",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "WITA",
            };
        final String[] Wallis = new String[] {
               "Saa za Wallis na Futuna",
               "WFT",
               "Wallis & Futuna Summer Time",
               "WFST",
               "Wallis & Futuna Time",
               "WFT",
            };
        final String[] Africa_Southern = new String[] {
               "Saa Wastani za Afrika Kusini",
               "SAST",
               "South Africa Summer Time",
               "SAST",
               "South Africa Time",
               "SAT",
            };
        final String[] Syowa = new String[] {
               "Saa za Syowa",
               "SYOT",
               "Syowa Summer Time",
               "SYOST",
               "Syowa Time",
               "SYOT",
            };
        final String[] Line_Islands = new String[] {
               "Saa za Visiwa vya Line",
               "LINT",
               "Line Is. Summer Time",
               "LINST",
               "Line Is. Time",
               "LINT",
            };
        final String[] Uzbekistan = new String[] {
               "Saa Wastani za Uzbekistani",
               "UZT",
               "Saa za Majira ya joto za Uzbekistani",
               "UZST",
               "Saa za Uzbekistani",
               "UZT",
            };
        final String[] Omsk = new String[] {
               "Saa Wastani za Omsk",
               "OMST",
               "Saa za Majira ya joto za Omsk",
               "OMSST",
               "Saa za Omsk",
               "OMST",
            };
        final String[] Seychelles = new String[] {
               "Saa za Ushelisheli",
               "SCT",
               "Seychelles Summer Time",
               "SCST",
               "Seychelles Time",
               "SCT",
            };
        final String[] Uruguay = new String[] {
               "Saa Wastani za Urugwai",
               "UYT",
               "Saa za Majira ya joto za Urugwai",
               "UYST",
               "Saa za Urugwai",
               "UYT",
            };
        final String[] Nepal = new String[] {
               "Saa za Nepali",
               "NPT",
               "Nepal Summer Time",
               "NPST",
               "Nepal Time",
               "NPT",
            };
        final String[] Mongolia = new String[] {
               "Saa Wastani za Ulan Bator",
               "ULAT",
               "Saa za Majira ya joto za Ulan Bator",
               "ULAST",
               "Saa za Ulan Bator",
               "ULAT",
            };
        final String[] America_Central = new String[] {
               "Saa za Wastani za Kati",
               "CST",
               "Saa za Mchana za Kati",
               "CDT",
               "Saa za Kati",
               "CT",
            };
        final String[] Truk = new String[] {
               "Saa za Chuuk",
               "CHUT",
               "Chuuk Summer Time",
               "CHUST",
               "Chuuk Time",
               "CHUT",
            };
        final String[] Niue = new String[] {
               "Saa za Niue",
               "NUT",
               "Niue Summer Time",
               "NUST",
               "Niue Time",
               "NUT",
            };
        final String[] Wake = new String[] {
               "Saa za Kisiwa cha Wake",
               "WAKT",
               "Wake Summer Time",
               "WAKST",
               "Wake Time",
               "WAKT",
            };
        final String[] Falkland = new String[] {
               "Saa Wastani za Visiwa vya Falkland",
               "FKT",
               "Saa za Majira ya joto za Visiwa vya Falkland",
               "FKST",
               "Saa za Visiwa vya Falkland",
               "FKT",
            };
        final String[] Vanuatu = new String[] {
               "Saa Wastani za Vanuatu",
               "VUT",
               "Saa za Majira ya joto za Vanuatu",
               "VUST",
               "Saa za Vanuatu",
               "VUT",
            };
        final String[] Novosibirsk = new String[] {
               "Saa Wastani za Novosibirsk",
               "NOVT",
               "Saa za Majira ya joto za Novosibirsk",
               "NOVST",
               "Saa za Novosibirsk",
               "NOVT",
            };
        final String[] Singapore = new String[] {
               "Saa Wastani za Singapore",
               "SRET",
               "Srednekolymsk Daylight Time",
               "SREDT",
               "Srednekolymsk Time",
               "SRET",
            };
        final String[] Azores = new String[] {
               "Saa Wastani za Azores",
               "AZOT",
               "Saa za Majira ya joto za Azores",
               "AZOST",
               "Saa za Azores",
               "AZOT",
            };
        final String[] Apia = new String[] {
               "Saa Wastani za Apia",
               "WSST",
               "Saa za Mchana za Apia",
               "WSDT",
               "Saa za Apia",
               "WST",
            };
        final String[] Bhutan = new String[] {
               "Saa za Bhutan",
               "BTT",
               "Bhutan Summer Time",
               "BTST",
               "Bhutan Time",
               "BTT",
            };
        final String[] Suriname = new String[] {
               "Saa za Suriname",
               "SRT",
               "Suriname Summer Time",
               "SRST",
               "Suriname Time",
               "SRT",
            };
        final String[] Nauru = new String[] {
               "Saa za Nauru",
               "NRT",
               "Nauru Summer Time",
               "NRST",
               "Nauru Time",
               "NRT",
            };
        final String[] Krasnoyarsk = new String[] {
               "Saa Wastani za Krasnoyaski",
               "KRAT",
               "Saa za Majira ya joto za Krasnoyarsk",
               "KRAST",
               "Saa za Krasnoyarsk",
               "KRAT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Saa za Kazakistani Magharibi",
               "AQTT",
               "Aqtau Summer Time",
               "AQTST",
               "Aqtau Time",
               "AQTT",
            };
        final String[] Myanmar = new String[] {
               "Saa za Myanmar",
               "MMT",
               "Myanmar Summer Time",
               "MMST",
               "Myanmar Time",
               "MMT",
            };
        final String[] Christmas = new String[] {
               "Saa za Kisiwa cha Krisimasi",
               "CXT",
               "Christmas Island Summer Time",
               "CXST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Amazon = new String[] {
               "Saa Wastani za Amazon",
               "AMT",
               "Saa za Majira ya joto za Amazon",
               "AMST",
               "Saa za Amazon",
               "AMT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Saa za Kazakistani Mashariki",
               "ALMT",
               "Alma-Ata Summer Time",
               "ALMST",
               "Alma-Ata Time",
               "ALMT",
            };
        final String[] Fiji = new String[] {
               "Saa Wastani za Fiji",
               "FJT",
               "Saa za Majira ya joto za Fiji",
               "FJST",
               "Saa za Fiji",
               "FJT",
            };
        final String[] Reunion = new String[] {
               "Saa za Reunion",
               "RET",
               "Reunion Summer Time",
               "REST",
               "Reunion Time",
               "RET",
            };
        final String[] Cocos = new String[] {
               "Saa za Visiwa vya Cocos",
               "CCT",
               "Cocos Islands Summer Time",
               "CCST",
               "Cocos Islands Time",
               "CCT",
            };
        final String[] Chatham = new String[] {
               "Saa Wastani za Chatham",
               "CHAST",
               "Saa za Mchana za Chatham",
               "CHADT",
               "Saa za Chatham",
               "CHAT",
            };
        final String[] Vostok = new String[] {
               "Saa za Vostok",
               "VOST",
               "Vostok Summer Time",
               "VOSST",
               "Vostok Time",
               "VOST",
            };
        final String[] Argentina = new String[] {
               "Saa Wastani za Ajentina",
               "ART",
               "Saa za Majira ya joto za Ajentina",
               "ARST",
               "Saa za Ajentina",
               "ART",
            };
        final String[] Gambier = new String[] {
               "Saa za Gambier",
               "GAMT",
               "Gambier Summer Time",
               "GAMST",
               "Gambier Time",
               "GAMT",
            };
        final String[] Kamchatka = new String[] {
               "Saa za Wastani za Petropavlovsk-Kamchatski",
               "PETT",
               "Saa za Kiangazi za Petropavlovsk-Kamchatski",
               "PETST",
               "Saa za Petropavlovsk-Kamchatski",
               "PETT",
            };
        final String[] Tuvalu = new String[] {
               "Saa za Tuvalu",
               "TVT",
               "Tuvalu Summer Time",
               "TVST",
               "Tuvalu Time",
               "TVT",
            };
        final String[] Galapagos = new String[] {
               "Saa za Galapagos",
               "GALT",
               "Galapagos Summer Time",
               "GALST",
               "Galapagos Time",
               "GALT",
            };
        final String[] Macquarie = new String[] {
               "Saa za kisiwa cha Macquarie",
               "MIST",
               "Macquarie Island Daylight Time",
               "MIDT",
               "Macquarie Island Time",
               "MIST",
            };
        final String[] Venezuela = new String[] {
               "Saa za Venezuela",
               "VET",
               "Venezuela Summer Time",
               "VEST",
               "Venezuela Time",
               "VET",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Saa za Wastani za Hawaii-Aleutian",
               "HAST",
               "Saa za Mchana za Hawaii-Aleutian",
               "HADT",
               "Saa za Hawaii-Aleutian",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "Saa Wastani za Australia ya Kati",
               "ACST",
               "Saa za Mchana za Australia ya Kati",
               "ACDT",
               "Saa za Australia ya Kati",
               "ACT",
            };
        final String[] America_Pacific = new String[] {
               "Saa za Wastani za Pasifiki",
               "PST",
               "Saa za Mchana za Pasifiki",
               "PDT",
               "Saa za Pasifiki",
               "PT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Saa za Visiwa vya Phoenix",
               "PHOT",
               "Phoenix Is. Summer Time",
               "PHOST",
               "Phoenix Is. Time",
               "PHOT",
            };
        final String[] Turkmenistan = new String[] {
               "Saa Wastani za Turkmenistan",
               "TMT",
               "Saa za Majira ya joto za Turkmenistan",
               "TMST",
               "Saa za Turkmenistan",
               "TMT",
            };
        final String[] Europe_Western = new String[] {
               "Saa Wastani za Magharibi mwa Ulaya",
               "WET",
               "Saa za Majira ya joto za Magharibi mwa Ulaya",
               "WEST",
               "Saa za Magharibi mwa Ulaya",
               "WET",
            };
        final String[] Cape_Verde = new String[] {
               "Saa Wastani za Cape Verde",
               "CVT",
               "Saa za Majira ya joto za Cape Verde",
               "CVST",
               "Saa za Cape Verde",
               "CVT",
            };
        final String[] Norfolk = new String[] {
               "Saa za Kisiwa cha Norfolk",
               "NFT",
               "Norfolk Summer Time",
               "NFST",
               "Norfolk Time",
               "NFT",
            };
        final String[] Guyana = new String[] {
               "Saa za Guyana",
               "GYT",
               "Guyana Summer Time",
               "GYST",
               "Guyana Time",
               "GYT",
            };
        final String[] Pitcairn = new String[] {
               "Saa za Pitcairn",
               "PST",
               "Pitcairn Daylight Time",
               "PDT",
               "Pitcairn Time",
               "PT",
            };
        final String[] Rothera = new String[] {
               "Saa za Rothera",
               "ROTT",
               "Rothera Summer Time",
               "ROTST",
               "Rothera Time",
               "ROTT",
            };
        final String[] Samoa = new String[] {
               "Saa Wastani za Samoa",
               "SST",
               "Saa za Majira ya joto za Samoa",
               "SDT",
               "Saa za Samoa",
               "ST",
            };
        final String[] Palau = new String[] {
               "Saa za Palau",
               "PWT",
               "Palau Summer Time",
               "PWST",
               "Palau Time",
               "PWT",
            };
        final String[] Europe_Further_Eastern = new String[] {
               "Saa za Further-eastern European Time",
               "MSK",
               "Moscow Daylight Time",
               "MSD",
               "Moscow Time",
               "MT",
            };
        final String[] Azerbaijan = new String[] {
               "Saa Wastani za Azeribaijani",
               "AZT",
               "Saa za Majira ya joto za Azeribaijani",
               "AZST",
               "Saa za Azeribaijani",
               "AZT",
            };
        final String[] Mawson = new String[] {
               "Saa za Mawson",
               "MAWT",
               "Mawson Summer Time",
               "MAWST",
               "Mawson Time",
               "MAWT",
            };
        final String[] Mexico_Pacific = new String[] {
               "Saa za wastani za pasifiki za Meksiko",
               "MST",
               "Saa za mchana za pasifiki za Meksiko",
               "MDT",
               "Saa za pasifiki za Meksiko",
               "MT",
            };
        final String[] Davis = new String[] {
               "Saa za Davis",
               "DAVT",
               "Davis Summer Time",
               "DAVST",
               "Davis Time",
               "DAVT",
            };
        final String[] Cuba = new String[] {
               "Saa za Wastani ya Cuba",
               "CST",
               "Saa za Mchana za Cuba",
               "CDT",
               "Saa za Cuba",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "Saa Wastani za Afrika Magharibi",
               "CAT",
               "Saa za Majira ya joto za Afrika Magharibi",
               "CAST",
               "Saa za Afrika Magharibi",
               "CAT",
            };
        final String[] GMT = new String[] {
               "Saa za Greenwich",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
            };
        final String[] Philippines = new String[] {
               "Saa Wastani za Ufilipino",
               "PHT",
               "Saa za Majira ya joto za Ufilipino",
               "PHST",
               "Saa za Ufilipino",
               "PHT",
            };
        final String[] French_Southern = new String[] {
               "Saa za Kusini mwa Ufaransa na Antaktiki",
               "TFT",
               "French Southern & Antarctic Lands Summer Time",
               "TFST",
               "French Southern & Antarctic Lands Time",
               "TFT",
            };
        final String[] South_Georgia = new String[] {
               "Saa za Jojia Kusini",
               "GST",
               "South Georgia Daylight Time",
               "GDT",
               "South Georgia Time",
               "GT",
            };
        final String[] New_Caledonia = new String[] {
               "Saa Wastani za New Caledonia",
               "NCT",
               "Saa za Majira ya joto za New Caledonia",
               "NCST",
               "Saa za New Caledonia",
               "NCT",
            };
        final String[] Brunei = new String[] {
               "Saa za Brunei Darussalam",
               "BNT",
               "Brunei Summer Time",
               "BNST",
               "Brunei Time",
               "BNT",
            };
        final String[] Iran = new String[] {
               "Saa Wastani za Iran",
               "IRST",
               "Saa za Mchana za Iran",
               "IRDT",
               "Saa za Iran",
               "IRT",
            };
        final String[] Easter = new String[] {
               "Saa Wastani za Kisiwa cha Pasaka",
               "EAST",
               "Saa za Majira ya joto za Kisiwa cha Pasaka",
               "EASST",
               "Saa za Kisiwa cha Pasaka",
               "EAST",
            };
        final String[] Mexico_Northwest = new String[] {
               "Saa za wastani za Meksiko Kaskazini Magharibi",
               "PST",
               "Saa za mchana za Meksiko Kaskazini Magharibi",
               "PDT",
               "Saa za Meksiko Kaskazini Magharibi",
               "PT",
            };
        final String[] DumontDUrville = new String[] {
               "Saa za Dumont-d\u2019Urville",
               "DDUT",
               "Dumont-d'Urville Summer Time",
               "DDUST",
               "Dumont-d'Urville Time",
               "DDUT",
            };
        final String[] Tajikistan = new String[] {
               "Saa za Tajikistani",
               "TJT",
               "Tajikistan Summer Time",
               "TJST",
               "Tajikistan Time",
               "TJT",
            };
        final String[] Tonga = new String[] {
               "Saa Wastani za Tonga",
               "TOT",
               "Saa za Majira ya joto za Tonga",
               "TOST",
               "Saa za Tonga",
               "TOT",
            };
        final String[] Bangladesh = new String[] {
               "Saa Wastani za Bangladeshi",
               "BDT",
               "Saa za Majira ya joto za Bangladeshi",
               "BDST",
               "Saa za Bangladeshi",
               "BDT",
            };
        final String[] Peru = new String[] {
               "Saa Wastani za Peru",
               "PET",
               "Saa za Majira ya joto za Peru",
               "PEST",
               "Saa za Peru",
               "PET",
            };
        final String[] Greenland_Western = new String[] {
               "Saa za Wastani za Greenland Magharibi",
               "WGT",
               "Saa za Majira ya joto za Greenland Magharibi",
               "WGST",
               "Saa za Greenland Magharibi",
               "WGT",
            };
        final String[] Ecuador = new String[] {
               "Saa za Ekwado",
               "ECT",
               "Ecuador Summer Time",
               "ECST",
               "Ecuador Time",
               "ECT",
            };
        final String[] Greenland_Eastern = new String[] {
               "Saa za Wastani za Greenland Mashariki",
               "EGT",
               "Saa za Majira ya joto za Greenland Mashariki",
               "EGST",
               "Saa za Greenland Mashariki",
               "EGT",
            };
        final String[] Gulf = new String[] {
               "Saa Wastani za Gulf",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Saa za Mashariki mwa Indonesia",
               "WIT",
               "East Indonesia Summer Time",
               "EIST",
               "East Indonesia Time",
               "WIT",
            };
        final String[] Korea = new String[] {
               "Saa Wastani za Korea",
               "KST",
               "Saa za Mchana za Korea",
               "KDT",
               "Saa za Korea",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "Saa Wastani za Australia Magharibi",
               "AWST",
               "Saa za Mchana za Australia Magharibi",
               "AWDT",
               "Saa za Australia Magharibi",
               "AWT",
            };
        final String[] Kyrgystan = new String[] {
               "Saa za Kyrgystan",
               "KGT",
               "Kirgizstan Summer Time",
               "KGST",
               "Kirgizstan Time",
               "KGT",
            };
        final String[] Indonesia_Western = new String[] {
               "Saa za Magharibi mwa Indonesia",
               "WIB",
               "West Indonesia Summer Time",
               "WIST",
               "West Indonesia Time",
               "WIB",
            };
        final String[] Australia_Eastern = new String[] {
               "Saa Wastani za Mashariki mwa Australia",
               "AEST",
               "Saa za Mchana za Mashariki mwa Australia",
               "AEDT",
               "Saa za Australia Mashariki",
               "AET",
            };
        final String[] French_Guiana = new String[] {
               "Saa za Guiana ya Ufaransa",
               "GFT",
               "French Guiana Summer Time",
               "GFST",
               "French Guiana Time",
               "GFT",
            };
        final String[] Colombia = new String[] {
               "Saa Wastani za Kolombia",
               "COT",
               "Saa za Majira ya joto za Kolombia",
               "COST",
               "Saa za Kolombia",
               "COT",
            };
        final String[] Chile = new String[] {
               "Saa Wastani za Chile",
               "CLT",
               "Saa za Majira ya joto za Chile",
               "CLST",
               "Saa za Chile",
               "CLT",
            };
        final String[] Gilbert_Islands = new String[] {
               "Saa za Visiwa vya Gilbert",
               "GILT",
               "Gilbert Is. Summer Time",
               "GILST",
               "Gilbert Is. Time",
               "GILT",
            };
        final String[] America_Mountain = new String[] {
               "Saa za Wastani za Mountain",
               "MST",
               "Saa za Mchana za Mountain",
               "MDT",
               "Saa za Mountain",
               "MT",
            };
        final String[] Marquesas = new String[] {
               "Saa za Marquesas",
               "MART",
               "Marquesas Summer Time",
               "MARST",
               "Marquesas Time",
               "MART",
            };
        final String[] Arabian = new String[] {
               "Saa Wastani za Uarabuni",
               "AST",
               "Saa za Mchana za Arabiani",
               "ADT",
               "Saa za Uarabuni",
               "AT",
            };
        final String[] Alaska = new String[] {
               "Saa za Wastani za Alaska",
               "AKST",
               "Saa za Mchana za Alaska",
               "AKDT",
               "Saa za Alaska",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "Saa Wastani za Vladivostok",
               "VLAT",
               "Saa za Majira ya joto za Vladivostok",
               "VLAST",
               "Saa za Vladivostok",
               "VLAT",
            };
        final String[] Chamorro = new String[] {
               "Saa Wastani za Chamorro",
               "ChST",
               "Chamorro Daylight Time",
               "ChDT",
               "Chamorro Time",
               "ChT",
            };
        final String[] Irkutsk = new String[] {
               "Saa Wastani za Irkutsk",
               "IRKT",
               "Saa za Majira ya joto za Irkutsk",
               "IRKST",
               "Saa za Irkutsk",
               "IRKT",
            };
        final String[] Georgia = new String[] {
               "Saa Wastani za Jojia",
               "GET",
               "Saa za Majira ya joto za Jojia",
               "GEST",
               "Saa za Jojia",
               "GET",
            };
        final String[] Tokelau = new String[] {
               "Saa za Tokelau",
               "TKT",
               "Tokelau Summer Time",
               "TKST",
               "Tokelau Time",
               "TKT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Saa za Papua New Guinea",
               "PGT",
               "Papua New Guinea Summer Time",
               "PGST",
               "Papua New Guinea Time",
               "PGT",
            };
        final String[] Noronha = new String[] {
               "Saa Wastani za Fernando de Noronha",
               "FNT",
               "Saa za Majira ya joto za Fernando de Noronha",
               "FNST",
               "Saa za Fernando de Noronha",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "Saa Wastani za Choibalsan",
               "CHOT",
               "Saa za Majira ya joto za Choibalsan",
               "CHOST",
               "Saa za Choibalsan",
               "CHOT",
            };
        final String[] Brasilia = new String[] {
               "Saa Wastani za Brasilia",
               "BRT",
               "Saa za Majira ya joto za Brasilia",
               "BRST",
               "Saa za Brasilia",
               "BRT",
            };
        final String[] China = new String[] {
               "Saa Wastani za Uchina",
               "CST",
               "Saa za Mchana za Uchina",
               "CDT",
               "Saa za Uchina",
               "CT",
            };
        final String[] Armenia = new String[] {
               "Saa Wastani za Armenia",
               "AMT",
               "Saa za Majira ya joto za Armenia",
               "AMST",
               "Saa za Armenia",
               "AMT",
            };
        final String[] Samara = new String[] {
               "Saa za Wastani za Samara",
               "SAMT",
               "Saa za Kiangazi za Samara",
               "SAMST",
               "Saa za Samara",
               "SAMT",
            };
        final String[] India = new String[] {
               "Saa Wastani za India",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Cook = new String[] {
               "Saa Wastani za Visiwa vya Cook",
               "CKT",
               "Saa za Majira nusu ya joto za Visiwa Cook",
               "CKHST",
               "Saa za Visiwa vya Cook",
               "CKT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London",
                new String[] {
                    "Saa za Greenwich",
                    "GMT",
                    "Muda wa Majira ya Joto wa Uingereza",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", Atlantic },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Antarctica/Syowa", Syowa },
            { "Indian/Reunion", Reunion },
            { "Pacific/Palau", Palau },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Western },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Africa/Bamako", GMT },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Pacific/Bougainville", New_Zealand },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", Alaska },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Antarctica/Troll", GMT },
            { "Europe/Samara", Samara },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "Saa za Greenwich",
                    "GMT",
                    "Muda wa Majira ya Joto wa Ayalandi",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "Pacific/Truk", Truk },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Saipan", Chamorro },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Taipei", Taipei },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Further_Eastern },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Cancun", America_Eastern },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Kamchatka },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Tehran", Iran },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "Asia/Srednekolymsk", Singapore },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "Australia/Lindeman", Australia_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
