/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_tr extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "Orta Afrika Saati",
               "CAT",
               "Central African Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "Moskova Standart Saati",
               "MSK",
               "Moskova Yaz Saati",
               "MSD",
               "Moskova Saati",
               "MT",
            };
        final String[] Japan = new String[] {
               "Japonya Standart Saati",
               "JST",
               "Japonya Yaz Saati",
               "JDT",
               "Japonya Saati",
               "JT",
            };
        final String[] Pakistan = new String[] {
               "Pakistan Standart Saati",
               "PKT",
               "Pakistan Yaz Saati",
               "PKST",
               "Pakistan Saati",
               "PKT",
            };
        final String[] Taipei = new String[] {
               "Taipei Standart Saati",
               "CST",
               "Taipei Yaz Saati",
               "CDT",
               "Taipei Saati",
               "CT",
            };
        final String[] Hovd = new String[] {
               "Hovd Standart Saati",
               "HOVT",
               "Hovd Yaz Saati",
               "HOVST",
               "Hovd Saati",
               "HOVT",
            };
        final String[] Magadan = new String[] {
               "Magadan Standart Saati",
               "MAGT",
               "Magadan Yaz Saati",
               "MAGST",
               "Magadan Saati",
               "MAGT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "\u0130\u00e7bat\u0131 Avustralya Standart Saati",
               "ACWST",
               "\u0130\u00e7bat\u0131 Avustralya Yaz Saati",
               "ACWDT",
               "\u0130\u00e7bat\u0131 Avustralya Saati",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "Orta Avrupa Standart Saati",
               "CET",
               "Orta Avrupa Yaz Saati",
               "CEST",
               "Orta Avrupa Saati",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "Sahalin Standart Saati",
               "SAKT",
               "Sahalin Yaz Saati",
               "SAKST",
               "Sahalin Saati",
               "SAKT",
            };
        final String[] Paraguay = new String[] {
               "Paraguay Standart Saati",
               "PYT",
               "Paraguay Yaz Saati",
               "PYST",
               "Paraguay Saati",
               "PYT",
            };
        final String[] Acre = new String[] {
               "Acre Standart Saati",
               "ACT",
               "Acre Yaz Saati",
               "ACST",
               "Acre Saati",
               "ACT",
            };
        final String[] Malaysia = new String[] {
               "Malezya Saati",
               "MYT",
               "Malaysia Summer Time",
               "MYST",
               "Malaysia Time",
               "MYT",
            };
        final String[] America_Eastern = new String[] {
               "Kuzey Amerika Do\u011fu Standart Saati",
               "EST",
               "Kuzey Amerika Do\u011fu Yaz Saati",
               "EDT",
               "Kuzey Amerika Do\u011fu Saati",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "Lord Howe Standart Saati",
               "LHST",
               "Lord Howe Yaz Saati",
               "LHDT",
               "Lord Howe Saati",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "Yeni Zelanda Standart Saati",
               "NZST",
               "Yeni Zelanda Yaz Saati",
               "NZDT",
               "Yeni Zelanda Saati",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "Hint Okyanusu Saati",
               "IOT",
               "Indian Ocean Territory Summer Time",
               "IOST",
               "Indian Ocean Territory Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "Yakutsk Standart Saati",
               "YAKT",
               "Yakutsk Yaz Saati",
               "YAKST",
               "Yakutsk Saati",
               "YAKT",
            };
        final String[] Mauritius = new String[] {
               "Mauritius Standart Saati",
               "MUT",
               "Mauritius Yaz Saati",
               "MUST",
               "Mauritius Saati",
               "MUT",
            };
        final String[] Africa_Eastern = new String[] {
               "Do\u011fu Afrika Saati",
               "EAT",
               "Eastern African Summer Time",
               "EAST",
               "Eastern Africa Time",
               "EAT",
            };
        final String[] East_Timor = new String[] {
               "Do\u011fu Timor Saati",
               "TLT",
               "Timor-Leste Summer Time",
               "TLST",
               "Timor-Leste Time",
               "TLT",
            };
        final String[] Solomon = new String[] {
               "Solomon Adalar\u0131 Saati",
               "SBT",
               "Solomon Is. Summer Time",
               "SBST",
               "Solomon Is. Time",
               "SBT",
            };
        final String[] Kosrae = new String[] {
               "Kosrae Saati",
               "KOST",
               "Kosrae Summer Time",
               "KOSST",
               "Kosrae Time",
               "KOST",
            };
        final String[] Marshall_Islands = new String[] {
               "Marshall Adalar\u0131 Saati",
               "MHT",
               "Marshall Islands Summer Time",
               "MHST",
               "Marshall Islands Time",
               "MHT",
            };
        final String[] Europe_Eastern = new String[] {
               "Do\u011fu Avrupa Standart Saati",
               "EET",
               "Do\u011fu Avrupa Yaz Saati",
               "EEST",
               "Do\u011fu Avrupa Saati",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "Newfoundland Standart Saati",
               "NST",
               "Newfoundland Yaz Saati",
               "NDT",
               "Newfoundland Saati",
               "NT",
            };
        final String[] Afghanistan = new String[] {
               "Afganistan Saati",
               "AFT",
               "Afghanistan Summer Time",
               "AFST",
               "Afghanistan Time",
               "AFT",
            };
        final String[] Hong_Kong = new String[] {
               "Hong Kong Standart Saati",
               "HKT",
               "Hong Kong Yaz Saati",
               "HKST",
               "Hong Kong Saati",
               "HKT",
            };
        final String[] Argentina_Western = new String[] {
               "Bat\u0131 Arjantin Standart Saati",
               "ART",
               "Bat\u0131 Arjantin Yaz Saati",
               "ARST",
               "Bat\u0131 Arjantin Saati",
               "ART",
            };
        final String[] Atlantic = new String[] {
               "Atlantik Standart Saati",
               "AST",
               "Atlantik Yaz Saati",
               "ADT",
               "Atlantik Saati",
               "AT",
            };
        final String[] Ponape = new String[] {
               "Ponape Saati",
               "PONT",
               "Pohnpei Summer Time",
               "PONST",
               "Ponape Time",
               "PONT",
            };
        final String[] Bolivia = new String[] {
               "Bolivya Saati",
               "BOT",
               "Bolivia Summer Time",
               "BOST",
               "Bolivia Time",
               "BOT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Saint Pierre ve Miquelon Standart Saati",
               "PMST",
               "Saint Pierre ve Miquelon Yaz Saati",
               "PMDT",
               "Saint Pierre ve Miquelon Saati",
               "PMT",
            };
        final String[] Indochina = new String[] {
               "Hindi\u00e7in Saati",
               "ICT",
               "Indochina Summer Time",
               "ICST",
               "Indochina Time",
               "ICT",
            };
        final String[] Yekaterinburg = new String[] {
               "Yekaterinburg Standart Saati",
               "YEKT",
               "Yekaterinburg Yaz Saati",
               "YEKST",
               "Yekaterinburg Saati",
               "YEKT",
            };
        final String[] Maldives = new String[] {
               "Maldivler Saati",
               "MVT",
               "Maldives Summer Time",
               "MVST",
               "Maldives Time",
               "MVT",
            };
        final String[] Tahiti = new String[] {
               "Tahiti Saati",
               "TAHT",
               "Tahiti Summer Time",
               "TAHST",
               "Tahiti Time",
               "TAHT",
            };
        final String[] Israel = new String[] {
               "\u0130srail Standart Saati",
               "IST",
               "\u0130srail Yaz Saati",
               "IDT",
               "\u0130srail Saati",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "Orta Endonezya Saati",
               "WITA",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "WITA",
            };
        final String[] Wallis = new String[] {
               "Wallis ve Futuna Saati",
               "WFT",
               "Wallis & Futuna Summer Time",
               "WFST",
               "Wallis & Futuna Time",
               "WFT",
            };
        final String[] Africa_Southern = new String[] {
               "G\u00fcney Afrika Standart Saati",
               "SAST",
               "South Africa Summer Time",
               "SAST",
               "South Africa Time",
               "SAT",
            };
        final String[] Syowa = new String[] {
               "Showa Saati",
               "SYOT",
               "Syowa Summer Time",
               "SYOST",
               "Syowa Time",
               "SYOT",
            };
        final String[] Line_Islands = new String[] {
               "Line Adalar\u0131 Saati",
               "LINT",
               "Line Is. Summer Time",
               "LINST",
               "Line Is. Time",
               "LINT",
            };
        final String[] Uzbekistan = new String[] {
               "\u00d6zbekistan Standart Saati",
               "UZT",
               "\u00d6zbekistan Yaz Saati",
               "UZST",
               "\u00d6zbekistan Saati",
               "UZT",
            };
        final String[] Omsk = new String[] {
               "Omsk Standart Saati",
               "OMST",
               "Omsk Yaz Saati",
               "OMSST",
               "Omsk Saati",
               "OMST",
            };
        final String[] Seychelles = new String[] {
               "Sey\u015feller Saati",
               "SCT",
               "Seychelles Summer Time",
               "SCST",
               "Seychelles Time",
               "SCT",
            };
        final String[] Uruguay = new String[] {
               "Uruguay Standart Saati",
               "UYT",
               "Uruguay Yaz Saati",
               "UYST",
               "Uruguay Saati",
               "UYT",
            };
        final String[] Nepal = new String[] {
               "Nepal Saati",
               "NPT",
               "Nepal Summer Time",
               "NPST",
               "Nepal Time",
               "NPT",
            };
        final String[] Mongolia = new String[] {
               "Ulan Batur Standart Saati",
               "ULAT",
               "Ulan Batur Yaz Saati",
               "ULAST",
               "Ulan Batur Saati",
               "ULAT",
            };
        final String[] America_Central = new String[] {
               "Kuzey Amerika Merkezi Standart Saati",
               "CST",
               "Kuzey Amerika Merkezi Yaz Saati",
               "CDT",
               "Kuzey Amerika Merkezi Saati",
               "CT",
            };
        final String[] Truk = new String[] {
               "Chuuk Saati",
               "CHUT",
               "Chuuk Summer Time",
               "CHUST",
               "Chuuk Time",
               "CHUT",
            };
        final String[] Niue = new String[] {
               "Niue Saati",
               "NUT",
               "Niue Summer Time",
               "NUST",
               "Niue Time",
               "NUT",
            };
        final String[] Wake = new String[] {
               "Wake Adas\u0131 Saati",
               "WAKT",
               "Wake Summer Time",
               "WAKST",
               "Wake Time",
               "WAKT",
            };
        final String[] Falkland = new String[] {
               "Falkland Adalar\u0131 Standart Saati",
               "FKT",
               "Falkland Adalar\u0131 Yaz Saati",
               "FKST",
               "Falkland Adalar\u0131 Saati",
               "FKT",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatu Standart Saati",
               "VUT",
               "Vanuatu Yaz Saati",
               "VUST",
               "Vanuatu Saati",
               "VUT",
            };
        final String[] Novosibirsk = new String[] {
               "Novosibirsk Standart Saati",
               "NOVT",
               "Novosibirsk Yaz Saati",
               "NOVST",
               "Novosibirsk Saati",
               "NOVT",
            };
        final String[] Singapore = new String[] {
               "Singapur Standart Saati",
               "SRET",
               "Srednekolymsk Daylight Time",
               "SREDT",
               "Srednekolymsk Time",
               "SRET",
            };
        final String[] Azores = new String[] {
               "Azorlar Standart Saati",
               "AZOT",
               "Azorlar Yaz Saati",
               "AZOST",
               "Azorlar Saati",
               "AZOT",
            };
        final String[] Apia = new String[] {
               "Apia Standart Saati",
               "WSST",
               "Apia Yaz Saati",
               "WSDT",
               "Apia Saati",
               "WST",
            };
        final String[] Bhutan = new String[] {
               "Bhutan Saati",
               "BTT",
               "Bhutan Summer Time",
               "BTST",
               "Bhutan Time",
               "BTT",
            };
        final String[] Suriname = new String[] {
               "Surinam Saati",
               "SRT",
               "Suriname Summer Time",
               "SRST",
               "Suriname Time",
               "SRT",
            };
        final String[] Nauru = new String[] {
               "Nauru Saati",
               "NRT",
               "Nauru Summer Time",
               "NRST",
               "Nauru Time",
               "NRT",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnoyarsk Standart Saati",
               "KRAT",
               "Krasnoyarsk Yaz Saati",
               "KRAST",
               "Krasnoyarsk Saati",
               "KRAT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Bat\u0131 Kazakistan Saati",
               "AQTT",
               "Aqtau Summer Time",
               "AQTST",
               "Aqtau Time",
               "AQTT",
            };
        final String[] Myanmar = new String[] {
               "Myanmar Saati",
               "MMT",
               "Myanmar Summer Time",
               "MMST",
               "Myanmar Time",
               "MMT",
            };
        final String[] Christmas = new String[] {
               "Christmas Adas\u0131 Saati",
               "CXT",
               "Christmas Island Summer Time",
               "CXST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Amazon = new String[] {
               "Amazon Standart Saati",
               "AMT",
               "Amazon Yaz Saati",
               "AMST",
               "Amazon Saati",
               "AMT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Do\u011fu Kazakistan Saati",
               "ALMT",
               "Alma-Ata Summer Time",
               "ALMST",
               "Alma-Ata Time",
               "ALMT",
            };
        final String[] Fiji = new String[] {
               "Fiji Standart Saati",
               "FJT",
               "Fiji Yaz Saati",
               "FJST",
               "Fiji Saati",
               "FJT",
            };
        final String[] Reunion = new String[] {
               "Reunion Saati",
               "RET",
               "Reunion Summer Time",
               "REST",
               "Reunion Time",
               "RET",
            };
        final String[] Cocos = new String[] {
               "Cocos Adalar\u0131 Saati",
               "CCT",
               "Cocos Islands Summer Time",
               "CCST",
               "Cocos Islands Time",
               "CCT",
            };
        final String[] Chatham = new String[] {
               "Chatham Standart Saati",
               "CHAST",
               "Chatham Yaz Saati",
               "CHADT",
               "Chatham Saati",
               "CHAT",
            };
        final String[] Vostok = new String[] {
               "Vostok Saati",
               "VOST",
               "Vostok Summer Time",
               "VOSST",
               "Vostok Time",
               "VOST",
            };
        final String[] Argentina = new String[] {
               "Arjantin Standart Saati",
               "ART",
               "Arjantin Yaz Saati",
               "ARST",
               "Arjantin Saati",
               "ART",
            };
        final String[] Gambier = new String[] {
               "Gambier Saati",
               "GAMT",
               "Gambier Summer Time",
               "GAMST",
               "Gambier Time",
               "GAMT",
            };
        final String[] Kamchatka = new String[] {
               "Petropavlovsk-Kam\u00e7atski Standart Saati",
               "PETT",
               "Petropavlovsk-Kam\u00e7atski Yaz Saati",
               "PETST",
               "Petropavlovsk-Kam\u00e7atski Saati",
               "PETT",
            };
        final String[] Tuvalu = new String[] {
               "Tuvalu Saati",
               "TVT",
               "Tuvalu Summer Time",
               "TVST",
               "Tuvalu Time",
               "TVT",
            };
        final String[] Galapagos = new String[] {
               "Galapagos Saati",
               "GALT",
               "Galapagos Summer Time",
               "GALST",
               "Galapagos Time",
               "GALT",
            };
        final String[] Macquarie = new String[] {
               "Macquarie Adas\u0131 Saati",
               "MIST",
               "Macquarie Island Daylight Time",
               "MIDT",
               "Macquarie Island Time",
               "MIST",
            };
        final String[] Venezuela = new String[] {
               "Venezuela Saati",
               "VET",
               "Venezuela Summer Time",
               "VEST",
               "Venezuela Time",
               "VET",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hawaii-Aleut Standart Saati",
               "HAST",
               "Hawaii-Aleut Yaz Saati",
               "HADT",
               "Hawaii-Aleut Saati",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "Orta Avustralya Standart Saati",
               "ACST",
               "Orta Avustralya Yaz Saati",
               "ACDT",
               "Orta Avustralya Saati",
               "ACT",
            };
        final String[] America_Pacific = new String[] {
               "Kuzey Amerika Pasifik Standart Saati",
               "PST",
               "Kuzey Amerika Pasifik Yaz Saati",
               "PDT",
               "Kuzey Amerika Pasifik Saati",
               "PT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Phoenix Adalar\u0131 Saati",
               "PHOT",
               "Phoenix Is. Summer Time",
               "PHOST",
               "Phoenix Is. Time",
               "PHOT",
            };
        final String[] Turkmenistan = new String[] {
               "T\u00fcrkmenistan Standart Saati",
               "TMT",
               "T\u00fcrkmenistan Yaz Saati",
               "TMST",
               "T\u00fcrkmenistan Saati",
               "TMT",
            };
        final String[] Europe_Western = new String[] {
               "Bat\u0131 Avrupa Standart Saati",
               "WET",
               "Bat\u0131 Avrupa Yaz Saati",
               "WEST",
               "Bat\u0131 Avrupa Saati",
               "WET",
            };
        final String[] Cape_Verde = new String[] {
               "Cape Verde Standart Saati",
               "CVT",
               "Cape Verde Yaz Saati",
               "CVST",
               "Cape Verde Saati",
               "CVT",
            };
        final String[] Norfolk = new String[] {
               "Norfolk Adas\u0131 Saati",
               "NFT",
               "Norfolk Summer Time",
               "NFST",
               "Norfolk Time",
               "NFT",
            };
        final String[] Guyana = new String[] {
               "Guyana Saati",
               "GYT",
               "Guyana Summer Time",
               "GYST",
               "Guyana Time",
               "GYT",
            };
        final String[] Pitcairn = new String[] {
               "Pitcairn Saati",
               "PST",
               "Pitcairn Daylight Time",
               "PDT",
               "Pitcairn Time",
               "PT",
            };
        final String[] Rothera = new String[] {
               "Rothera Saati",
               "ROTT",
               "Rothera Summer Time",
               "ROTST",
               "Rothera Time",
               "ROTT",
            };
        final String[] Samoa = new String[] {
               "Samoa Standart Saati",
               "SST",
               "Samoa Yaz Saati",
               "SDT",
               "Samoa Saati",
               "ST",
            };
        final String[] Palau = new String[] {
               "Palau Saati",
               "PWT",
               "Palau Summer Time",
               "PWST",
               "Palau Time",
               "PWT",
            };
        final String[] Europe_Further_Eastern = new String[] {
               "Daha Do\u011fu Avrupa Saati",
               "MSK",
               "Moscow Daylight Time",
               "MSD",
               "Moscow Time",
               "MT",
            };
        final String[] Azerbaijan = new String[] {
               "Azerbaycan Standart Saati",
               "AZT",
               "Azerbaycan Yaz Saati",
               "AZST",
               "Azerbaycan Saati",
               "AZT",
            };
        final String[] Mawson = new String[] {
               "Mawson Saati",
               "MAWT",
               "Mawson Summer Time",
               "MAWST",
               "Mawson Time",
               "MAWT",
            };
        final String[] Mexico_Pacific = new String[] {
               "Meksika Pasifik K\u0131y\u0131s\u0131 Standart Saati",
               "MST",
               "Meksika Pasifik K\u0131y\u0131s\u0131 Yaz Saati",
               "MDT",
               "Meksika Pasifik K\u0131y\u0131s\u0131 Saati",
               "MT",
            };
        final String[] Davis = new String[] {
               "Davis Saati",
               "DAVT",
               "Davis Summer Time",
               "DAVST",
               "Davis Time",
               "DAVT",
            };
        final String[] Cuba = new String[] {
               "K\u00fcba Standart Saati",
               "CST",
               "K\u00fcba Yaz Saati",
               "CDT",
               "K\u00fcba Saati",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "Bat\u0131 Afrika Standart Saati",
               "CAT",
               "Bat\u0131 Afrika Yaz Saati",
               "CAST",
               "Bat\u0131 Afrika Saati",
               "CAT",
            };
        final String[] GMT = new String[] {
               "Greenwich Ortalama Saati",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
            };
        final String[] Philippines = new String[] {
               "Filipinler Standart Saati",
               "PHT",
               "Filipinler Yaz Saati",
               "PHST",
               "Filipinler Saati",
               "PHT",
            };
        final String[] French_Southern = new String[] {
               "Frans\u0131z G\u00fcney ve Antarktika Saati",
               "TFT",
               "French Southern & Antarctic Lands Summer Time",
               "TFST",
               "French Southern & Antarctic Lands Time",
               "TFT",
            };
        final String[] South_Georgia = new String[] {
               "G\u00fcney Georgia Saati",
               "GST",
               "South Georgia Daylight Time",
               "GDT",
               "South Georgia Time",
               "GT",
            };
        final String[] New_Caledonia = new String[] {
               "Yeni Kaledonya Standart Saati",
               "NCT",
               "Yeni Kaledonya Yaz Saati",
               "NCST",
               "Yeni Kaledonya Saati",
               "NCT",
            };
        final String[] Brunei = new String[] {
               "Brunei Dar\u00fc\u2019s-Selam Saati",
               "BNT",
               "Brunei Summer Time",
               "BNST",
               "Brunei Time",
               "BNT",
            };
        final String[] Iran = new String[] {
               "\u0130ran Standart Saati",
               "IRST",
               "\u0130ran Yaz Saati",
               "IRDT",
               "\u0130ran Saati",
               "IRT",
            };
        final String[] Easter = new String[] {
               "Paskalya Adas\u0131 Standart Saati",
               "EAST",
               "Paskalya Adas\u0131 Yaz Saati",
               "EASST",
               "Paskalya Adas\u0131 Saati",
               "EAST",
            };
        final String[] Mexico_Northwest = new String[] {
               "Kuzeybat\u0131 Meksika Standart Saati",
               "PST",
               "Kuzeybat\u0131 Meksika Yaz Saati",
               "PDT",
               "Kuzeybat\u0131 Meksika Saati",
               "PT",
            };
        final String[] DumontDUrville = new String[] {
               "Dumont-d\u2019Urville Saati",
               "DDUT",
               "Dumont-d'Urville Summer Time",
               "DDUST",
               "Dumont-d'Urville Time",
               "DDUT",
            };
        final String[] Tajikistan = new String[] {
               "Tacikistan Saati",
               "TJT",
               "Tajikistan Summer Time",
               "TJST",
               "Tajikistan Time",
               "TJT",
            };
        final String[] Tonga = new String[] {
               "Tonga Standart Saati",
               "TOT",
               "Tonga Yaz Saati",
               "TOST",
               "Tonga Saati",
               "TOT",
            };
        final String[] Bangladesh = new String[] {
               "Banglade\u015f Standart Saati",
               "BDT",
               "Banglade\u015f Yaz Saati",
               "BDST",
               "Banglade\u015f Saati",
               "BDT",
            };
        final String[] Peru = new String[] {
               "Peru Standart Saati",
               "PET",
               "Peru Yaz Saati",
               "PEST",
               "Peru Saati",
               "PET",
            };
        final String[] Greenland_Western = new String[] {
               "Bat\u0131 Gr\u00f6nland Standart Saati",
               "WGT",
               "Bat\u0131 Gr\u00f6nland Yaz Saati",
               "WGST",
               "Bat\u0131 Gr\u00f6nland Saati",
               "WGT",
            };
        final String[] Ecuador = new String[] {
               "Ekvador Saati",
               "ECT",
               "Ecuador Summer Time",
               "ECST",
               "Ecuador Time",
               "ECT",
            };
        final String[] Greenland_Eastern = new String[] {
               "Do\u011fu Gr\u00f6nland Standart Saati",
               "EGT",
               "Do\u011fu Gr\u00f6nland Yaz Saati",
               "EGST",
               "Do\u011fu Gr\u00f6nland Saati",
               "EGT",
            };
        final String[] Gulf = new String[] {
               "K\u00f6rfez Saati",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Do\u011fu Endonezya Saati",
               "WIT",
               "East Indonesia Summer Time",
               "EIST",
               "East Indonesia Time",
               "WIT",
            };
        final String[] Korea = new String[] {
               "Kore Standart Saati",
               "KST",
               "Kore Yaz Saati",
               "KDT",
               "Kore Saati",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "Bat\u0131 Avustralya Standart Saati",
               "AWST",
               "Bat\u0131 Avustralya Yaz Saati",
               "AWDT",
               "Bat\u0131 Avustralya Saati",
               "AWT",
            };
        final String[] Kyrgystan = new String[] {
               "K\u0131rg\u0131zistan Saati",
               "KGT",
               "Kirgizstan Summer Time",
               "KGST",
               "Kirgizstan Time",
               "KGT",
            };
        final String[] Indonesia_Western = new String[] {
               "Bat\u0131 Endonezya Saati",
               "WIB",
               "West Indonesia Summer Time",
               "WIST",
               "West Indonesia Time",
               "WIB",
            };
        final String[] Australia_Eastern = new String[] {
               "Do\u011fu Avustralya Standart Saati",
               "AEST",
               "Do\u011fu Avustralya Yaz Saati",
               "AEDT",
               "Do\u011fu Avustralya Saati",
               "AET",
            };
        final String[] French_Guiana = new String[] {
               "Frans\u0131z Guyanas\u0131 Saati",
               "GFT",
               "French Guiana Summer Time",
               "GFST",
               "French Guiana Time",
               "GFT",
            };
        final String[] Colombia = new String[] {
               "Kolombiya Standart Saati",
               "COT",
               "Kolombiya Yaz Saati",
               "COST",
               "Kolombiya Saati",
               "COT",
            };
        final String[] Chile = new String[] {
               "\u015eili Standart Saati",
               "CLT",
               "\u015eili Yaz Saati",
               "CLST",
               "\u015eili Saati",
               "CLT",
            };
        final String[] Gilbert_Islands = new String[] {
               "Gilbert Adalar\u0131 Saati",
               "GILT",
               "Gilbert Is. Summer Time",
               "GILST",
               "Gilbert Is. Time",
               "GILT",
            };
        final String[] America_Mountain = new String[] {
               "Kuzey Amerika Da\u011f Standart Saati",
               "MST",
               "Kuzey Amerika Da\u011f Yaz Saati",
               "MDT",
               "Kuzey Amerika Da\u011f Saati",
               "MT",
            };
        final String[] Marquesas = new String[] {
               "Markiz Adalar\u0131 Saati",
               "MART",
               "Marquesas Summer Time",
               "MARST",
               "Marquesas Time",
               "MART",
            };
        final String[] Arabian = new String[] {
               "Arabistan Standart Saati",
               "AST",
               "Arabistan Yaz Saati",
               "ADT",
               "Arabistan Saati",
               "AT",
            };
        final String[] Alaska = new String[] {
               "Alaska Standart Saati",
               "AKST",
               "Alaska Yaz Saati",
               "AKDT",
               "Alaska Saati",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "Vladivostok Standart Saati",
               "VLAT",
               "Vladivostok Yaz Saati",
               "VLAST",
               "Vladivostok Saati",
               "VLAT",
            };
        final String[] Chamorro = new String[] {
               "Chamorro Saati",
               "ChST",
               "Chamorro Daylight Time",
               "ChDT",
               "Chamorro Time",
               "ChT",
            };
        final String[] Irkutsk = new String[] {
               "\u0130rkutsk Standart Saati",
               "IRKT",
               "\u0130rkutsk Yaz Saati",
               "IRKST",
               "\u0130rkutsk Saati",
               "IRKT",
            };
        final String[] Georgia = new String[] {
               "G\u00fcrcistan Standart Saati",
               "GET",
               "G\u00fcrcistan Yaz Saati",
               "GEST",
               "G\u00fcrcistan Saati",
               "GET",
            };
        final String[] Tokelau = new String[] {
               "Tokelau Saati",
               "TKT",
               "Tokelau Summer Time",
               "TKST",
               "Tokelau Time",
               "TKT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Papua Yeni Gine Saati",
               "PGT",
               "Papua New Guinea Summer Time",
               "PGST",
               "Papua New Guinea Time",
               "PGT",
            };
        final String[] Noronha = new String[] {
               "Fernando de Noronha Standart Saati",
               "FNT",
               "Fernando de Noronha Yaz Saati",
               "FNST",
               "Fernando de Noronha Saati",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "\u00c7oybalsan Standart Saati",
               "CHOT",
               "\u00c7oybalsan Yaz Saati",
               "CHOST",
               "\u00c7oybalsan Saati",
               "CHOT",
            };
        final String[] Brasilia = new String[] {
               "Brasilia Standart Saati",
               "BRT",
               "Brasilia Yaz Saati",
               "BRST",
               "Brasilia Saati",
               "BRT",
            };
        final String[] China = new String[] {
               "\u00c7in Standart Saati",
               "CST",
               "\u00c7in Yaz Saati",
               "CDT",
               "\u00c7in Saati",
               "CT",
            };
        final String[] Armenia = new String[] {
               "Ermenistan Standart Saati",
               "AMT",
               "Ermenistan Yaz Saati",
               "AMST",
               "Ermenistan Saati",
               "AMT",
            };
        final String[] Samara = new String[] {
               "Samara Standart Saati",
               "SAMT",
               "Samara Yaz Saati",
               "SAMST",
               "Samara Saati",
               "SAMT",
            };
        final String[] India = new String[] {
               "Hindistan Standart Saati",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Cook = new String[] {
               "Cook Adalar\u0131 Standart Saati",
               "CKT",
               "Cook Adalar\u0131 Yar\u0131 Yaz Saati",
               "CKHST",
               "Cook Adalar\u0131 Saati",
               "CKT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London",
                new String[] {
                    "Greenwich Ortalama Saati",
                    "GMT",
                    "\u0130ngiltere Yaz Saati",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Eirunepe", Acre },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", Atlantic },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Antarctica/Syowa", Syowa },
            { "Indian/Reunion", Reunion },
            { "Pacific/Palau", Palau },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Western },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Africa/Bamako", GMT },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Pacific/Bougainville", New_Zealand },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", Alaska },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Antarctica/Troll", GMT },
            { "Europe/Samara", Samara },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "Greenwich Ortalama Saati",
                    "GMT",
                    "\u0130rlanda Standart Saati",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "Pacific/Truk", Truk },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Saipan", Chamorro },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Taipei", Taipei },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Further_Eastern },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Cancun", America_Eastern },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Rio_Branco", Acre },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Kamchatka },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Tehran", Iran },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "Asia/Srednekolymsk", Singapore },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "Australia/Lindeman", Australia_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
