/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_zh_Hant_HK extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] New_Caledonia = new String[] {
               "\u65b0\u5580\u91cc\u591a\u5c3c\u4e9e\u6a19\u6e96\u6642\u9593",
               "NCT",
               "\u65b0\u5580\u91cc\u591a\u5c3c\u4e9e\u590f\u4ee4\u6642\u9593",
               "NCST",
               "\u65b0\u5580\u91cc\u591a\u5c3c\u4e9e\u6642\u9593",
               "NCT",
            };
        final String[] Cocos = new String[] {
               "\u53ef\u53ef\u65af\u7fa4\u5cf6\u6642\u9593",
               "CCT",
               "Cocos Islands Summer Time",
               "CCST",
               "Cocos Islands Time",
               "CCT",
            };
        final String[] DumontDUrville = new String[] {
               "\u8fea\u8499\u8fea\u7dad\u723e\u6642\u9593",
               "DDUT",
               "Dumont-d'Urville Summer Time",
               "DDUST",
               "Dumont-d'Urville Time",
               "DDUT",
            };
        final String[] Maldives = new String[] {
               "\u99ac\u723e\u4ee3\u592b\u6642\u9593",
               "MVT",
               "Maldives Summer Time",
               "MVST",
               "Maldives Time",
               "MVT",
            };
        final String[] Tonga = new String[] {
               "\u6e6f\u52a0\u6a19\u6e96\u6642\u9593",
               "TOT",
               "\u6e6f\u52a0\u590f\u4ee4\u6642\u9593",
               "TOST",
               "\u6e6f\u52a0\u6642\u9593",
               "TOT",
            };
        final String[] Ecuador = new String[] {
               "\u5384\u74dc\u591a\u723e\u6642\u9593",
               "ECT",
               "Ecuador Summer Time",
               "ECST",
               "Ecuador Time",
               "ECT",
            };
        final String[] Tuvalu = new String[] {
               "\u5716\u74e6\u76e7\u6642\u9593",
               "TVT",
               "Tuvalu Summer Time",
               "TVST",
               "Tuvalu Time",
               "TVT",
            };
        final String[] Africa_Southern = new String[] {
               "\u5357\u975e\u6642\u9593",
               "SAST",
               "South Africa Summer Time",
               "SAST",
               "South Africa Time",
               "SAT",
            };
        final String[] Galapagos = new String[] {
               "\u52a0\u62c9\u5e15\u6208\u7fa4\u5cf6\u6642\u9593",
               "GALT",
               "Galapagos Summer Time",
               "GALST",
               "Galapagos Time",
               "GALT",
            };
        final String[] Gulf = new String[] {
               "\u6ce2\u65af\u7063\u6d77\u57df\u6642\u9593",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Macquarie = new String[] {
               "\u9ea5\u5938\u91cc\u7fa4\u5cf6\u6642\u9593",
               "MIST",
               "Macquarie Island Daylight Time",
               "MIDT",
               "Macquarie Island Time",
               "MIST",
            };
        final String[] America_Eastern = new String[] {
               "\u5317\u7f8e\u6771\u90e8\u6a19\u6e96\u6642\u9593",
               "EST",
               "\u5317\u7f8e\u6771\u90e8\u590f\u4ee4\u6642\u9593",
               "EDT",
               "\u5317\u7f8e\u6771\u90e8\u6642\u9593",
               "ET",
            };
        final String[] Seychelles = new String[] {
               "\u585e\u820c\u723e\u6642\u9593",
               "SCT",
               "Seychelles Summer Time",
               "SCST",
               "Seychelles Time",
               "SCT",
            };
        final String[] America_Central = new String[] {
               "\u5317\u7f8e\u4e2d\u90e8\u6a19\u6e96\u6642\u9593",
               "CST",
               "\u4e2d\u90e8\u590f\u4ee4\u6642\u9593",
               "CDT",
               "\u5317\u7f8e\u4e2d\u90e8\u6642\u9593",
               "CT",
            };
        final String[] Yakutsk = new String[] {
               "\u96c5\u5eab\u8328\u514b\u6a19\u6e96\u6642\u9593",
               "YAKT",
               "\u96c5\u5eab\u8328\u514b\u590f\u4ee4\u6642\u9593",
               "YAKST",
               "\u96c5\u5eab\u8328\u514b\u6642\u9593",
               "YAKT",
            };
        final String[] America_Mountain = new String[] {
               "\u5317\u7f8e\u5c71\u5340\u6a19\u6e96\u6642\u9593",
               "MST",
               "\u5317\u7f8e\u5c71\u5340\u590f\u4ee4\u6642\u9593",
               "MDT",
               "\u5317\u7f8e\u5c71\u5340\u6642\u9593",
               "MT",
            };
        final String[] Marquesas = new String[] {
               "\u99ac\u514b\u85a9\u65af\u6642\u9593",
               "MART",
               "Marquesas Summer Time",
               "MARST",
               "Marquesas Time",
               "MART",
            };
        final String[] America_Pacific = new String[] {
               "\u5317\u7f8e\u592a\u5e73\u6d0b\u6a19\u6e96\u6642\u9593",
               "PST",
               "\u5317\u7f8e\u592a\u5e73\u6d0b\u590f\u4ee4\u6642\u9593",
               "PDT",
               "\u5317\u7f8e\u592a\u5e73\u6d0b\u6642\u9593",
               "PT",
            };
        final String[] Mauritius = new String[] {
               "\u6bdb\u91cc\u88d8\u65af\u6a19\u6e96\u6642\u9593",
               "MUT",
               "\u6bdb\u91cc\u88d8\u65af\u590f\u4ee4\u6642\u9593",
               "MUST",
               "\u6bdb\u91cc\u88d8\u65af\u6642\u9593",
               "MUT",
            };
        final String[] Cape_Verde = new String[] {
               "\u4f5b\u5f97\u89d2\u6a19\u6e96\u6642\u9593",
               "CVT",
               "\u4f5b\u5f97\u89d2\u590f\u4ee4\u6642\u9593",
               "CVST",
               "\u4f5b\u5f97\u89d2\u6642\u9593",
               "CVT",
            };
        final String[] Vanuatu = new String[] {
               "\u74e6\u52aa\u963f\u5716\u6a19\u6e96\u6642\u9593",
               "VUT",
               "\u74e6\u52aa\u963f\u5716\u590f\u4ee4\u6642\u9593",
               "VUST",
               "\u74e6\u52aa\u963f\u5716\u6642\u9593",
               "VUT",
            };
        final String[] Solomon = new String[] {
               "\u6240\u7f85\u9580\u7fa4\u5cf6\u6642\u9593",
               "SBT",
               "Solomon Is. Summer Time",
               "SBST",
               "Solomon Is. Time",
               "SBT",
            };
        final String[] Guyana = new String[] {
               "\u572d\u4e9e\u90a3\u6642\u9593",
               "GYT",
               "Guyana Summer Time",
               "GYST",
               "Guyana Time",
               "GYT",
            };
        final String[] Kosrae = new String[] {
               "\u79d1\u65af\u96f7\u6642\u9593",
               "KOST",
               "Kosrae Summer Time",
               "KOSST",
               "Kosrae Time",
               "KOST",
            };
        final String[] Singapore = new String[] {
               "\u65b0\u52a0\u5761\u6642\u9593",
               "SRET",
               "Srednekolymsk Daylight Time",
               "SREDT",
               "Srednekolymsk Time",
               "SRET",
            };
        final String[] Irkutsk = new String[] {
               "\u4f0a\u723e\u5eab\u8328\u514b\u6a19\u6e96\u6642\u9593",
               "IRKT",
               "\u4f0a\u723e\u5eab\u8328\u514b\u590f\u4ee4\u6642\u9593",
               "IRKST",
               "\u4f0a\u723e\u5eab\u8328\u514b\u6642\u9593",
               "IRKT",
            };
        final String[] Georgia = new String[] {
               "\u683c\u9b6f\u5409\u4e9e\u6a19\u6e96\u6642\u9593",
               "GET",
               "\u683c\u9b6f\u5409\u4e9e\u590f\u4ee4\u6642\u9593",
               "GEST",
               "\u683c\u9b6f\u5409\u4e9e\u6642\u9593",
               "GET",
            };
        final String[] Pitcairn = new String[] {
               "\u76ae\u7279\u5eb7\u6642\u9593",
               "PST",
               "Pitcairn Daylight Time",
               "PDT",
               "Pitcairn Time",
               "PT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "\u5df4\u5e03\u4e9e\u65b0\u757f\u5167\u4e9e\u6642\u9593",
               "PGT",
               "Papua New Guinea Summer Time",
               "PGST",
               "Papua New Guinea Time",
               "PGT",
            };
        final String[] Noronha = new String[] {
               "\u8cbb\u723e\u5357\u591a\u8fea\u8afe\u7f85\u5c3c\u4e9e\u6a19\u6e96\u6642\u9593",
               "FNT",
               "\u8cbb\u723e\u5357\u591a\u8fea\u8afe\u7f85\u5c3c\u4e9e\u590f\u4ee4\u6642\u9593",
               "FNST",
               "\u8cbb\u723e\u5357\u591a\u8fea\u8afe\u7f85\u5c3c\u4e9e\u6642\u9593",
               "FNT",
            };
        final String[] Suriname = new String[] {
               "\u8607\u91cc\u5357\u6642\u9593",
               "SRT",
               "Suriname Summer Time",
               "SRST",
               "Suriname Time",
               "SRT",
            };
        final String[] Nauru = new String[] {
               "\u7459\u9b6f\u6642\u9593",
               "NRT",
               "Nauru Summer Time",
               "NRST",
               "Nauru Time",
               "NRT",
            };
        final String[] Azerbaijan = new String[] {
               "\u4e9e\u585e\u62dc\u7586\u6a19\u6e96\u6642\u9593",
               "AZT",
               "\u4e9e\u585e\u62dc\u7586\u590f\u4ee4\u6642\u9593",
               "AZST",
               "\u4e9e\u585e\u62dc\u7586\u6642\u9593",
               "AZT",
            };
        final String[] Indochina = new String[] {
               "\u4e2d\u5357\u534a\u5cf6\u6642\u9593",
               "ICT",
               "Indochina Summer Time",
               "ICST",
               "Indochina Time",
               "ICT",
            };
        final String[] India = new String[] {
               "\u5370\u5ea6\u6642\u9593",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Indian/Mahe", Seychelles },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/El_Salvador", America_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "Africa/Mbabane", Africa_Southern },
            { "America/North_Dakota/Center", America_Central },
            { "America/Guatemala", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Cayman", America_Eastern },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/Tegucigalpa", America_Central },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "Asia/Baku", Azerbaijan },
            { "America/Yellowknife", America_Mountain },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Bangkok", Indochina },
            { "Asia/Saigon", Indochina },
            { "America/Noronha", Noronha },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Swift_Current", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Paramaribo", Suriname },
            { "Asia/Phnom_Penh", Indochina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "Asia/Dubai", Gulf },
            { "America/Indiana/Vincennes", America_Eastern },
            { "America/Whitehorse", America_Pacific },
            { "America/Mexico_City", America_Central },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Asia/Vientiane", Indochina },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Matamoros", America_Central },
            { "America/Indiana/Winamac", America_Eastern },
            { "PST8PDT", America_Pacific },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Chita", Yakutsk },
            { "CST6CDT", America_Central },
            { "Pacific/Efate", Vanuatu },
            { "America/Menominee", America_Central },
            { "Asia/Calcutta", India },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "America/Resolute", America_Central },
            { "America/Merida", America_Central },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Edmonton", America_Mountain },
            { "Pacific/Nauru", Nauru },
            { "America/Fort_Nelson", America_Mountain },
            { "Indian/Mauritius", Mauritius },
            { "America/Port-au-Prince", America_Eastern },
            { "America/Nipigon", America_Eastern },
            { "America/Regina", America_Central },
            { "Asia/Srednekolymsk", Singapore },
            { "America/Boise", America_Mountain },
            { "EST5EDT", America_Eastern },
            { "America/North_Dakota/New_Salem", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Muscat", Gulf },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "America/Winnipeg", America_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/Cancun", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "America/Bahia_Banderas", America_Central },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "America/Jamaica", America_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "America/Louisville", America_Eastern },
            { "America/Vancouver", America_Pacific },
            { "America/Detroit", America_Eastern },
        };
        return data;
    }
}
