#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 postgrest
version:              7.0.1
visibility:           public
id:                   postgrest-7.0.1-DrEydOsaXrIBCAStXue43d
key:                  postgrest-7.0.1-DrEydOsaXrIBCAStXue43d
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for the tables and views, supporting all HTTP verbs that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  6a4f6b9594bcbe91a8e61f3938d635bd
exposed:              True
exposed-modules:
    PostgREST.ApiRequest PostgREST.App PostgREST.Auth PostgREST.Config
    PostgREST.DbRequestBuilder PostgREST.DbStructure PostgREST.Error
    PostgREST.Middleware PostgREST.OpenAPI PostgREST.Parsers
    PostgREST.QueryBuilder PostgREST.RangeQuery PostgREST.Statements
    PostgREST.Types

hidden-modules:
    Paths_postgrest PostgREST.Private.Common
    PostgREST.Private.QueryFragment

import-dirs:          /usr/lib/ghc-8.10.5/site-local/postgrest-7.0.1
library-dirs:         /usr/lib/ghc-8.10.5/site-local/postgrest-7.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/postgrest-7.0.1
hs-libraries:         HSpostgrest-7.0.1-DrEydOsaXrIBCAStXue43d
depends:
    HTTP-4000.3.16-9bOTWxBD0bVEOf31VXrvWZ
    Ranged-sets-0.4.0-L1YwgTXWiTPDN7LsYzmt5C
    aeson-1.5.6.0-CVfeYccFVpdCde0UrZZZdZ
    ansi-wl-pprint-0.6.9-18xfpSFHwXcSLsLHaSUhO base-4.14.2.0
    base64-bytestring-1.2.0.1-9folcSD81CwJ7ibR6pZE7R
    bytestring-0.10.12.0
    case-insensitive-1.2.1.0-G5jOpOHgp1lAnadtJPMHHB
    cassava-0.5.2.0-FpXofBWgsV62kpj4lNFzd
    configurator-pg-0.2.5-9rKa3wDCQ5fJhIgiO5f3At containers-0.6.4.1
    contravariant-1.5.3-KWoYE9wiUjmElzHNq2wj10
    contravariant-extras-0.3.5.2-3BpyB8faCZ4p3SlrfyDcp
    cookie-0.4.5-DRjKUovO6l159RRdguKqPl
    either-5.0.1.1-LPXXSlC1FQ7DVSChfgPjER
    gitrev-1.3.1-IeAYO8QUG62LW4J3MUanQA
    hasql-1.4.5.1-8AHTB1S21Q1IJZf9AL7OcY
    hasql-pool-0.5.2-3uW7UuEJL01DXOhE0HZdVG
    hasql-transaction-1.0.0.2-CkO9JUVIz1XFFMR26CAbcW
    heredoc-0.2.0.0-1fHEYXo5Sno3wcFmeoc81p
    http-types-0.12.3-JSCBEGU6f6MIPS3hXwEPIB
    insert-ordered-containers-0.2.5-2SyqL4YkK326MBCs83asXO
    interpolatedstring-perl6-1.0.2-3heIlgAH5B8JvkRyvtxvve
    jose-0.8.4-5mE5EECmroT9L9wdRgvhOJ lens-5.0.1-9j09gzxg2dR5Wmd3U39g28
    lens-aeson-1.1.1-6gIBhxBSp7UK9bxNmK4XN0
    network-uri-2.6.4.1-4m8gp52oIfHLdE9VhQrWxs
    optparse-applicative-0.16.1.0-ARX6qDeExVWDKYrQ55nL8e
    parsec-3.1.14.0 protolude-0.3.0-8VNSZGgbnh692HOX5sIHnz
    regex-tdfa-1.3.1.1-GKHvEQcFLVkJ8X6kzhWyIo
    scientific-0.3.7.0-Fi0gRGhsiJ35wgbCjOXuHX
    swagger2-2.6-9hf8hG1jsbj6FshbNzKCyV text-1.2.4.1 time-1.9.3
    unordered-containers-0.2.14.0-JpdjDmlqBJN4PAu3jIj4Ya
    vector-0.12.3.0-K9OZS5OCy7cE2QKQqSO9mp
    wai-3.2.3-6NrdunSiuKK6vnccK2cwty
    wai-cors-0.2.7-DepLhfPh3hjCzFTL7eCI8S
    wai-extra-3.1.6-FKz4MHJx3sl2f6Nl0w7kAe
    wai-middleware-static-0.9.0-A4Hg1CUqeubEtK3iWLssRo

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

