13.3 Sound Out

# Sound Out

So far in this section we've looked at how to get multiple streams of
audio into Sonic Pi - either through the use of the `:sound_in` synth or via the
powerful `live_audio` system. In addition to working with multiple
streams of input audio, Sonic Pi can also output multiple streams of
audio. This is achieved via the `:sound_out` FX.

## Output contexts

Let's quickly recap on how Sonic Pi's synths and FX output their audio to their
current FX context. For example, consider the following:

```
with_fx :reverb do    # C
  with_fx :echo do    # B
    sample :bd_haus   # A
  end
end
```

The simplest way to understand what's happening with the audio stream is
to start at the innermost audio context and work our way out. In this
case, the innermost context is labelled `A` and is the `:bd_haus` sample being
triggered. The audio for this goes directly into its context which is
`B` - the `:echo` FX. This then adds echo to the incoming audio and
outputs it to its context which is `C` - the `:reverb` FX. This then
adds reverb to the incoming audio and outputs to its context which is
the top level - the left and right speakers (outputs 1 and 2 in your
audio card). The audio flows outwards with a stereo signal all the way
through.

## Sound Out FX

The above behaviour is true for all synths (including `live_audio`) and
the majority of FX with the exception of `:sound_out`. The `:sound_out` FX
does two things. Firstly it outputs its audio to its external context as
described above. Secondly it *also* outputs its audio directly to an
output on your sound card. Let's take a look:

```
with_fx :reverb do      # C
  with_fx :sound_out, output: 3 do # B
    sample :bd_haus     # A
  end
end
```

In this example, our `:bd_haus` sample outputs its audio to its external
context which is the `:sound_out` FX. This in turn outputs its audio to
its external context the `:reverb` FX (as expected). However, it *also* outputs
a mono mix to the 3rd output of the system's soundcard. The audio
generated within `:sound_out` therefore has two destinations - the
`:reverb` FX and audio card output 3.

## Mono and Stereo out

As we've seen, by default, the `:sound_out` FX outputs a mono mix of the
stereo input to a specific channel in addition to passing the stereo
feed to the outer context (as expected). If outputting a mono mix isn't
precisely what you want to do, there are a number of alternative
options. Firstly, by using the `mode:` opt you can choose to output just
the left or just the right input signal to the audio card. Or you can
use the `:sound_out_stereo` FX to output to two consecutive sound card
outputs. See the function documentation for more information and
examples.

## Direct Out

As we have also seen, the default behaviour for `:sound_out` and
`:sound_out_stereo` is to send the audio both to their external context (as
is typical of all FX) *and* to the specified output on your
soundcard. However, occasionally you may wish to *only* send to the
output on your soundcard and not to the external context (and therefore
not have any chance of the sound being mixed and sent to the standard
output channels 1 and 2). This is possible by using the standard FX opt
`amp:` which operates on the audio *after* the FX has been able to
manipulate the audio:

```
with_fx :sound_out, output: 3, amp: 0 do # B
  sample :loop_amen                      # A
end
```

In the above example, the `:loop_amen` sample is sent to its outer
context, the `:sound_out` FX. This then sends a mono mix to audio card
output 3 and then multiplies the audio by 0 which essentially silences
it. It is this silenced signal which is then sent out to the
`:sound_out`'s outer context which is the standard output. Therefore with
this code, the default output channels will not receive any audio, and
channel 3 will receive a mono mix of the amen drum break.
