/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.glossaries;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.GenericCommand;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.latex.LaTeXSyntaxException;
import com.dickimawbooks.texparserlib.latex.glossaries.AbstractGlsCommand;
import com.dickimawbooks.texparserlib.latex.glossaries.GlossariesSty;
import com.dickimawbooks.texparserlib.latex.glossaries.GlossaryEntry;
import com.dickimawbooks.texparserlib.latex.glossaries.GlsLabel;
import java.io.IOException;

public class GlsFieldFetch
extends AbstractGlsCommand {
    public GlsFieldFetch(GlossariesSty glossariesSty) {
        this("glsfieldfetch", glossariesSty);
    }

    public GlsFieldFetch(String string, GlossariesSty glossariesSty) {
        super(string, glossariesSty);
    }

    @Override
    public Object clone() {
        return new GlsFieldFetch(this.getName(), this.getSty());
    }

    @Override
    public boolean canExpand() {
        return false;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return null;
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        GlsLabel glsLabel = this.popEntryLabel(teXParser, teXObjectList);
        String string = this.sty.getFieldName(this.popLabelString(teXParser, teXObjectList));
        ControlSequence controlSequence = this.popControlSequence(teXParser, teXObjectList);
        GlossaryEntry glossaryEntry = glsLabel.getEntry();
        if (glossaryEntry == null) {
            this.sty.undefWarnOrError(teXObjectList, "glossaries.entry.not.defined", glsLabel.getLabel());
        } else {
            TeXObject teXObject = glossaryEntry.get(string);
            if (teXObject == null) {
                throw new LaTeXSyntaxException(teXParser, "glossaries.field.not.defined", string);
            }
            teXParser.putControlSequence(true, new GenericCommand(true, controlSequence.getName(), null, (TeXObject)teXObject.clone()));
        }
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }
}

