/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http2;

import java.util.Map;
import org.apache.coyote.http2.ByteUtil;
import org.apache.coyote.http2.ConnectionSettingsBase;
import org.apache.coyote.http2.FrameType;
import org.apache.coyote.http2.Http2Error;
import org.apache.coyote.http2.Setting;

class ConnectionSettingsLocal
extends ConnectionSettingsBase<IllegalArgumentException> {
    private static final String ENDPOINT_NAME = "Local(client->server)";
    private boolean sendInProgress = false;

    ConnectionSettingsLocal(String string) {
        super(string);
    }

    @Override
    final synchronized void set(Setting setting, Long l) {
        this.checkSend();
        if (((Long)this.current.get((Object)setting)).longValue() == l.longValue()) {
            this.pending.remove((Object)setting);
        } else {
            this.pending.put(setting, l);
        }
    }

    final synchronized byte[] getSettingsFrameForPending() {
        this.checkSend();
        int n = this.pending.size() * 6;
        byte[] byArray = new byte[9 + n];
        ByteUtil.setThreeBytes(byArray, 0, n);
        byArray[3] = FrameType.SETTINGS.getIdByte();
        int n2 = 9;
        for (Map.Entry entry : this.pending.entrySet()) {
            ByteUtil.setTwoBytes(byArray, n2, ((Setting)((Object)entry.getKey())).getId());
            ByteUtil.setFourBytes(byArray, n2 += 2, (Long)entry.getValue());
            n2 += 4;
        }
        this.sendInProgress = true;
        return byArray;
    }

    final synchronized boolean ack() {
        if (this.sendInProgress) {
            this.sendInProgress = false;
            this.current.putAll(this.pending);
            this.pending.clear();
            return true;
        }
        return false;
    }

    private void checkSend() {
        if (this.sendInProgress) {
            throw new IllegalStateException();
        }
    }

    @Override
    final void throwException(String string, Http2Error http2Error) throws IllegalArgumentException {
        throw new IllegalArgumentException(string);
    }

    @Override
    final String getEndpointName() {
        return ENDPOINT_NAME;
    }
}

