/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.tomcat.util.buf.UriUtil;
import org.apache.tomcat.util.file.ConfigurationSource;
import org.apache.tomcat.util.res.StringManager;

public class CatalinaBaseConfigurationSource
implements ConfigurationSource {
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.startup");
    private final String serverXmlPath;
    private final File catalinaBaseFile;
    private final URI catalinaBaseUri;

    public CatalinaBaseConfigurationSource(File file, String string) {
        this.catalinaBaseFile = file;
        this.catalinaBaseUri = file.toURI();
        this.serverXmlPath = string;
    }

    public ConfigurationSource.Resource getServerXml() throws IOException {
        InputStream inputStream;
        IOException iOException = null;
        ConfigurationSource.Resource resource = null;
        try {
            resource = this.serverXmlPath == null || this.serverXmlPath.equals("conf/server.xml") ? super.getServerXml() : this.getResource(this.serverXmlPath);
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        if (resource == null && (inputStream = this.getClass().getClassLoader().getResourceAsStream("server-embed.xml")) != null) {
            try {
                resource = new ConfigurationSource.Resource(inputStream, this.getClass().getClassLoader().getResource("server-embed.xml").toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                inputStream.close();
            }
        }
        if (resource == null && iOException != null) {
            throw iOException;
        }
        return resource;
    }

    public ConfigurationSource.Resource getResource(String string) throws IOException {
        Object object;
        Comparable<File> comparable;
        if (!UriUtil.isAbsoluteURI((String)string)) {
            comparable = new File(string);
            if (!((File)comparable).isAbsolute()) {
                comparable = new File(this.catalinaBaseFile, string);
            }
            if (((File)comparable).isFile()) {
                FileInputStream fileInputStream = new FileInputStream((File)comparable);
                return new ConfigurationSource.Resource((InputStream)fileInputStream, ((File)comparable).toURI());
            }
            object = null;
            try {
                object = this.getClass().getClassLoader().getResourceAsStream(string);
                if (object != null) {
                    return new ConfigurationSource.Resource((InputStream)object, this.getClass().getClassLoader().getResource(string).toURI());
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                ((InputStream)object).close();
                throw new IOException(sm.getString("catalinaConfigurationSource.cannotObtainURL", new Object[]{string}), uRISyntaxException);
            }
        }
        comparable = null;
        try {
            comparable = this.getURIInternal(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException(sm.getString("catalinaConfigurationSource.cannotObtainURL", new Object[]{string}));
        }
        try {
            object = ((URI)comparable).toURL();
            return new ConfigurationSource.Resource(((URL)object).openConnection().getInputStream(), comparable);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IOException(sm.getString("catalinaConfigurationSource.cannotObtainURL", new Object[]{string}), malformedURLException);
        }
    }

    public URI getURI(String string) {
        if (!UriUtil.isAbsoluteURI((String)string)) {
            File file = new File(string);
            if (!file.isAbsolute()) {
                file = new File(this.catalinaBaseFile, string);
            }
            if (file.isFile()) {
                return file.toURI();
            }
            try {
                URL uRL = this.getClass().getClassLoader().getResource(string);
                if (uRL != null) {
                    return uRL.toURI();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.getURIInternal(string);
    }

    private URI getURIInternal(String string) {
        URI uRI = this.catalinaBaseUri != null ? this.catalinaBaseUri.resolve(string) : URI.create(string);
        return uRI;
    }
}

