# does local adaptions needed to build for Archlinux32
# (this should be held in sync with builder/lib/common-functions mangle_pkgbuild)
#
# mangle_pkgbuild $PKGBUILD [$sub_pkgrel]
#  
#  append $sub_pkgrel to the pkgrel
#  remove $pkgrel from {make,check,opt,}depends
pkgctl_repo_patch_arch32() {
  local pkgname="$1"

  #~ local PKGBUILD="$1"
  #~ local sub_pkgrel="$2"
  
  # add the remote branch with our patches
  git -C "${pkgname}" remote add -m master archlinux32 git://git.archlinux32.org/packages
  git -C "${pkgname}" fetch --depth 1 archlinux32

  #~ if [ -n "${sub_pkgrel}" ]; then
    #~ sub_pkgrel=".${sub_pkgrel}"
  #~ fi

  # extend architecture with our architecture
  awk -i inplace '!/^arch=[^#]*any/ {gsub(/^arch=\(/,"arch=(i486 i686 pentium4 ")}; {print}' \
    "${pkgname}/PKGBUILD"

  #~ if grep -q '^\s*pkgname=["'"'"']\?lib32-' "${pkgname}/${PKGBUILD}"; then
    #~ sed -i '
      #~ s/^\(\s*pkgrel=\)['"'"'"]\?\([0-9]\+\)\.[0-9]*['"'"'"]\?\s*\(#.*\)\?$/\1"\2"/
    #~ ' "${pkgname}/PKGBUILD"
  #~ fi

  #~ sed -i '
    #~ s/^\(\s*pkgrel=\)['"'"'"]\?\([0-9]\+\)\(\.[0-9.]*\)\?['"'"'"]\?\s*\(#.*\)\?$/\1"\2'"${sub_pkgrel:-\\3}"'"/
  #~ ' "${pkgname}/PKGBUILD"

  #  remove "lib32-" and "gcc-multilib" from {make,check,opt,}depends
  # shellcheck disable=SC2016
  sed -i '
    /^\s*\(make\|check\|opt\|\)depends\(_[^=[:space:]]\+\)\?=(/ {
      :a
        /^\s*\(\S[^=]*\)=(\(\([^()"'"'"']\|"[^"]*"\|['"'"'][^'"'"']*['"'"']\s*\)*\(#[^\n]*\n\)\?\)*)/! {
          $b
          N
          ba
        }
      :b
        s/\(=.*["'"'"'([:space:]]\)lib32-/\1/g
        s/\(=.*["'"'"'([:space:]]\)gcc-multilib\(["'"'"')[:space:]]\)/\1gcc\2/g
        s/\(=.*["'"'"'([:space:]][^[:space:]$]\+[<=>]\S\+\)-[^:"'"'"')[:space:]]\+\([:"'"'"')[:space:]]\)/\1\2/g
      tb
    }
  ' "${pkgname}/PKGBUILD"
  
  # iterate the arch32 diffs in the archlinux32/master branch (we don't know
  # the destination repo, so we just scan both 'core' and 'extra' as well as
  # 'build-support')
  listfile=$(mktemp --tmpdir="${WORKDIR}" pkgctl-arch32.XXXXXXXXXX)
  >"${listfile}"
  for repo in core extra build-support; do
    git -C "${pkgname}" ls-tree -r --name-only archlinux32/master "${repo}/${pkgname}" >>"${listfile}"
  done
  for file in $(cat "${listfile}"); do
    if [[ "${file##*/}" = "PKGBUILD" ]]; then
      if [ -f "${pkgname}/PKGBUILD" ]; then
        printf "\n\n# -- Arch32 specific --\n\n" >> "${pkgname}/PKGBUILD"
        git -C "${pkgname}" show archlinux32/master:"${file}" >> "${pkgname}/PKGBUILD"
      else
        git -C "${pkgname}" show archlinux32/master:"${file}" > "${pkgname}/PKGBUILD"
      fi
    else
      git -C "${pkgname}" show archlinux32/master:"${file}" > "${pkgname}/${file##*/}"
    fi
  done
}
