/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.settings;

import java.awt.Rectangle;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JFileChooser;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.config.Config;
import tim.prune.config.ConfigPaths;
import tim.prune.data.DoubleRange;
import tim.prune.data.Track;

public class SaveConfig
extends GenericFunction {
    public SaveConfig(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.saveconfig";
    }

    @Override
    public void begin() {
        File file = this.getConfig().getConfigFile();
        if (file == null) {
            file = ConfigPaths.getSuggestedConfigFile();
        }
        JFileChooser jFileChooser = new JFileChooser(file.getAbsoluteFile().getParent());
        jFileChooser.setSelectedFile(file);
        int n = jFileChooser.showSaveDialog(this._parentFrame);
        if (n == 0) {
            File file2 = jFileChooser.getSelectedFile();
            this.saveConfig(this.getConfig(), file2);
            if (!file2.getName().equals(ConfigPaths.getDefaultFilename())) {
                this._app.showTip(5);
            }
        }
    }

    public boolean silentSave() {
        return this.saveConfig(this.getConfig(), this.getConfig().getConfigFile());
    }

    public void autosaveSwitched(boolean bl) {
        File file = this.getConfig().getConfigFile();
        if (bl && file == null) {
            this.begin();
        } else if (!bl && file != null) {
            this.silentSave();
        }
    }

    private boolean saveConfig(Config config, File file) {
        Rectangle rectangle = this._app.getFrame().getBounds();
        String string = rectangle.x + "x" + rectangle.y + "x" + rectangle.width + "x" + rectangle.height;
        config.setConfigString("prune.windowbounds", string);
        String string2 = this.createLatLonStringForConfig();
        if (string2 != null) {
            config.setConfigString("prune.latlonrange", string2);
        }
        boolean bl = false;
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                config.getAllConfig().store(fileOutputStream, "GpsPrune config file");
                bl = true;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            this._app.showErrorMessageNoLookup(this.getNameKey(), String.valueOf(I18nManager.getText("error.save.failed")) + " : " + iOException.getMessage());
        }
        catch (NullPointerException nullPointerException) {}
        config.setConfigFile(file);
        return bl;
    }

    private String createLatLonStringForConfig() {
        Track track = this._app.getTrackInfo().getTrack();
        if (track.getNumPoints() >= 2) {
            DoubleRange doubleRange = track.getLatRange();
            DoubleRange doubleRange2 = track.getLonRange();
            if (doubleRange.getRange() > 0.0 && doubleRange2.getRange() > 0.0) {
                return String.valueOf(doubleRange.getMinimum()) + ";" + doubleRange.getMaximum() + ";" + doubleRange2.getMinimum() + ";" + doubleRange2.getMaximum();
            }
        }
        return null;
    }
}

