/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Constant;
import com.sun.org.apache.bcel.internal.classfile.ConstantObject;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ConstantInteger
extends Constant
implements ConstantObject {
    private int bytes;

    public ConstantInteger(int bytes) {
        super((byte)3);
        this.bytes = bytes;
    }

    public ConstantInteger(ConstantInteger c) {
        this(c.getBytes());
    }

    ConstantInteger(DataInputStream file) throws IOException {
        this(file.readInt());
    }

    @Override
    public void accept(Visitor v) {
        v.visitConstantInteger(this);
    }

    @Override
    public final void dump(DataOutputStream file) throws IOException {
        file.writeByte(this.tag);
        file.writeInt(this.bytes);
    }

    public final int getBytes() {
        return this.bytes;
    }

    public final void setBytes(int bytes) {
        this.bytes = bytes;
    }

    @Override
    public final String toString() {
        return super.toString() + "(bytes = " + this.bytes + ")";
    }

    @Override
    public Object getConstantValue(ConstantPool cp) {
        return new Integer(this.bytes);
    }
}

