/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.swing;

import java.awt.GraphicsEnvironment;
import java.awt.Shape;
import java.awt.font.TextLayout;
import java.awt.geom.PathIterator;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.xml.transform.TransformerException;
import net.atmp.ImageBuilder;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.drawing.LimitFinder;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.drawing.svg.SvgGraphics;
import net.sourceforge.plantuml.klimt.drawing.svg.SvgOption;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.UFont;
import net.sourceforge.plantuml.klimt.font.UFontContext;
import net.sourceforge.plantuml.klimt.shape.UDrawable;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.klimt.shape.UText;
import net.sourceforge.plantuml.security.SFile;
import net.sourceforge.plantuml.security.SImageIO;

public class FontChecker {
    private final UFont font;
    private static final Set<String> SQUARE = new HashSet<String>(Arrays.asList("MI=I=XM=I=IX", "MI=I=XM=I=IXMI=I=XM=I=IX"));

    public FontChecker(UFont font) {
        this.font = font;
    }

    public boolean isCharOk(char c) {
        return !SQUARE.contains(this.getCharDesc(c));
    }

    private static String getType(int type, double oldX, double oldY, double x, double y) {
        if (type == 4) {
            return "X";
        }
        if (type == 1) {
            if (oldX == x) {
                return "I";
            }
            if (oldY == y) {
                return "=";
            }
            return "L";
        }
        if (type == 0) {
            return "M";
        }
        if (type == 2) {
            return "Q";
        }
        if (type == 3) {
            return "C";
        }
        throw new IllegalArgumentException();
    }

    public String getCharDesc(char c) {
        TextLayout t2 = UFontContext.G2D.createTextLayout(this.font, "" + c);
        Shape sh = t2.getOutline(null);
        double[] current = new double[6];
        PathIterator it = sh.getPathIterator(null);
        int sum = 0;
        StringBuilder result = new StringBuilder();
        while (!it.isDone()) {
            double oldX = current[0];
            double oldY = current[1];
            int nb = it.currentSegment(current);
            sum += nb;
            result.append(FontChecker.getType(nb, oldX, oldY, current[0], current[1]));
            it.next();
        }
        return result.toString();
    }

    public String getCharDescVerbose(char c) {
        TextLayout t2 = UFontContext.G2D.createTextLayout(this.font, "" + c);
        Shape sh = t2.getOutline(null);
        double[] current = new double[6];
        PathIterator it = sh.getPathIterator(null);
        int sum = 0;
        StringBuilder result = new StringBuilder();
        while (!it.isDone()) {
            double oldX = current[0];
            double oldY = current[1];
            int nb = it.currentSegment(current);
            sum += nb;
            result.append(FontChecker.getType(nb, oldX, oldY, current[0], current[1]));
            this.appendValue(result, current);
            it.next();
        }
        return result.toString();
    }

    private void appendValue(StringBuilder result, double[] current) {
        for (double v : current) {
            int i = (int)(v * 100.0);
            result.append(i);
            result.append(":");
        }
    }

    public void printChar(PrintWriter pw, char c) throws IOException, TransformerException {
        pw.println("<p>");
        char ascii = c;
        pw.println(ascii + " - " + Integer.toHexString(ascii) + " - ");
        pw.println("&#" + ascii + ";");
        String svg = this.getSvgImage(c);
        pw.println(svg);
    }

    private String getSvgImage(char c) throws IOException, TransformerException {
        SvgGraphics svg = new SvgGraphics(42L, SvgOption.basic());
        svg.setStrokeColor("black");
        svg.svgImage(this.getBufferedImage(c), 0.0, 0.0);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        svg.createXml(os);
        os.close();
        return new String(os.toByteArray());
    }

    public BufferedImage getBufferedImage(final char c) throws IOException {
        assert (c != '\t');
        double dim = 20.0;
        UDrawable drawable = new UDrawable(){
            final /* synthetic */ FontChecker this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void drawU(UGraphic ug) {
                ug = ug.apply(HColors.BLACK);
                ug.draw(URectangle.build(19.0, 19.0));
                if (!(ug instanceof LimitFinder)) {
                    ug = ug.apply(new UTranslate(6.666666666666667, 13.333333333333334));
                    UText text = UText.build("" + c, FontConfiguration.blackBlueTrue(this.this$0.font));
                    ug.draw(text);
                }
            }
        };
        byte[] bytes = ImageBuilder.create(new FileFormatOption(FileFormat.PNG), drawable).writeByteArray();
        return SImageIO.read(bytes);
    }

    public static void main(String[] args) throws IOException, TransformerException {
        String name = args[0];
        int size = Integer.parseInt(args[1]);
        int v1 = Integer.parseInt(args[2]);
        int v2 = Integer.parseInt(args[3]);
        SFile f = new SFile("fontchecker-" + name + "-" + v1 + "-" + v2 + ".html");
        FontChecker fc = new FontChecker(UFont.build(name, 0, size));
        PrintWriter pw = f.createPrintWriter();
        pw.println("<html>");
        pw.println("<h1>PROBLEM</h1>");
        for (int i = v1; i <= v2; ++i) {
            char c = (char)i;
            boolean ok = fc.isCharOk(c);
            if (ok) continue;
            fc.printChar(pw, c);
            pw.println("</p>");
        }
        pw.println("<h1>OK</h1>");
        String[] allFontNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        for (int i = v1; i <= v2; ++i) {
            char c = (char)i;
            boolean ok = fc.isCharOk(c);
            if (!ok) continue;
            fc.printChar(pw, c);
            String desc = fc.getCharDescVerbose(c);
            for (String n : allFontNames) {
                FontChecker other = new FontChecker(UFont.build(n, 0, size));
                String descOther = other.getCharDescVerbose(c);
                if (!desc.equals(descOther)) continue;
                pw.println("&nbsp;");
                pw.println(n);
            }
            pw.println("</p>");
        }
        pw.println("</html>");
        pw.close();
    }
}

