/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import tim.prune.data.Coordinate;

public abstract class Longitude {
    public static Coordinate make(double d) {
        if (Math.abs(d) > 180.0) {
            return Longitude.make(Longitude.wrapTo180(d));
        }
        return new Coordinate(d, d >= 0.0 ? Coordinate.Cardinal.EAST : Coordinate.Cardinal.WEST);
    }

    static double wrapTo180(double d) {
        double d2 = d + 180.0;
        while (d2 < 0.0) {
            d2 += 360.0;
        }
        return d2 % 360.0 - 180.0;
    }

    public static Coordinate make(String string) {
        Coordinate coordinate = Coordinate.parse(string, Coordinate.Cardinal.EAST, Coordinate.Cardinal.WEST);
        if (coordinate != null && Math.abs(coordinate.getDouble()) > 180.0) {
            return coordinate.wrapTo180Degrees();
        }
        return coordinate;
    }

    public static Coordinate interpolate(Coordinate coordinate, Coordinate coordinate2, double d) {
        return Coordinate.interpolate(coordinate, coordinate2, d, Coordinate.Cardinal.EAST, Coordinate.Cardinal.WEST);
    }

    public static Coordinate interpolate(Coordinate coordinate, Coordinate coordinate2, int n, int n2) {
        return Longitude.interpolate(coordinate, coordinate2, 1.0 * (double)(n + 1) / (double)(n2 + 1));
    }

    public static boolean hasCardinal(String string) {
        Coordinate.Cardinal cardinal = Coordinate.getCardinal(string, Coordinate.Cardinal.EAST, Coordinate.Cardinal.WEST);
        return cardinal != Coordinate.Cardinal.NO_CARDINAL;
    }
}

