/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.dialogs.apptrustwarningpanel;

import java.awt.Component;
import java.awt.Dimension;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.SecurityDialog;
import net.sourceforge.jnlp.security.appletextendedsecurity.UnsignedAppletActionEntry;
import net.sourceforge.jnlp.security.appletextendedsecurity.UnsignedAppletTrustConfirmation;
import net.sourceforge.jnlp.security.dialogs.apptrustwarningpanel.AppTrustWarningPanel;
import net.sourceforge.jnlp.security.dialogs.remember.ExecuteAppletAction;

public class UnsignedAppletTrustWarningPanel
extends AppTrustWarningPanel {
    public UnsignedAppletTrustWarningPanel(SecurityDialog securityDialog, JNLPFile file) {
        super(file, securityDialog);
        this.INFO_PANEL_HEIGHT = 250;
        this.addComponents();
        if (securityDialog != null) {
            securityDialog.getViwableDialog().setMinimumSize(new Dimension(600, 400));
        }
    }

    @Override
    protected ImageIcon getInfoImage() {
        String location = "net/sourceforge/jnlp/resources/info-small.png";
        return new ImageIcon(ClassLoader.getSystemClassLoader().getResource("net/sourceforge/jnlp/resources/info-small.png"));
    }

    protected static String getTopPanelTextKey() {
        return "SUnsignedSummary";
    }

    protected static String getInfoPanelTextKey() {
        return "SUnsignedDetail";
    }

    protected static String getQuestionPanelTextKey() {
        return "SUnsignedQuestion";
    }

    @Override
    protected String getTopPanelText() {
        return UnsignedAppletTrustWarningPanel.htmlWrap(Translator.R(UnsignedAppletTrustWarningPanel.getTopPanelTextKey()));
    }

    @Override
    protected String getInfoPanelText() {
        String text = Translator.R(UnsignedAppletTrustWarningPanel.getInfoPanelTextKey(), this.file.getCodeBase(), this.file.getSourceLocation());
        UnsignedAppletActionEntry rememberedEntry = UnsignedAppletTrustConfirmation.getStoredEntry(this.file, this.getClass());
        if (rememberedEntry != null) {
            ExecuteAppletAction rememberedAction = rememberedEntry.getAppletSecurityActions().getAction(this.getClass());
            if (rememberedAction == ExecuteAppletAction.YES) {
                text = text + "<br>" + Translator.R("SUnsignedAllowedBefore", rememberedEntry.getLocalisedTimeStamp());
            } else if (rememberedAction == ExecuteAppletAction.NO) {
                text = text + "<br>" + Translator.R("SUnsignedRejectedBefore", rememberedEntry.getLocalisedTimeStamp());
            }
        }
        return UnsignedAppletTrustWarningPanel.htmlWrap(text);
    }

    @Override
    protected String getQuestionPanelText() {
        return UnsignedAppletTrustWarningPanel.htmlWrap(Translator.R(UnsignedAppletTrustWarningPanel.getQuestionPanelTextKey()));
    }

    public static void main(String[] args) throws Exception {
        UnsignedAppletTrustWarningPanel w = new UnsignedAppletTrustWarningPanel(null, new JNLPFile(new URL("http://www.geogebra.org/webstart/geogebra.jnlp")));
        JFrame f = new JFrame();
        f.setSize(600, 400);
        f.add((Component)w, "Center");
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
    }
}

