/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.janocchio;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import org.jmol.i18n.GT;
import org.openscience.jmol.app.janocchio.FrameDeltaDisplay;
import org.openscience.jmol.app.janocchio.Measure;
import org.openscience.jmol.app.janocchio.MeasureDist;
import org.openscience.jmol.app.janocchio.MeasureNoe;
import org.openscience.jmol.app.janocchio.NMRTableCellRenderer;
import org.openscience.jmol.app.janocchio.NMR_JmolPanel;
import org.openscience.jmol.app.janocchio.NMR_Viewer;
import org.openscience.jmol.app.janocchio.NmrMolecule;
import org.openscience.jmol.app.janocchio.NoeColourSelectionPanel;
import org.openscience.jmol.app.janocchio.NoeParameterSelectionPanel;

public class NoeTable
extends JTabbedPane {
    NMR_JmolPanel nmrPanel;
    NMR_Viewer viewer;
    String[] labelArray;
    boolean molCDKuptodate = false;
    int natomsPerModel;
    String[][] expNoes;
    String[][] expDists;
    boolean lexpNoes = true;
    NmrMolecule calcProps;
    double freq = 400.0;
    double tau = 80.0;
    double tMix = 0.5;
    double cutoff = 10.0;
    double rhoStar = 0.1;
    boolean noesy = true;
    double yellowValue = 0.2;
    double redValue = 0.4;
    FrameDeltaDisplay frameDeltaDisplay;
    NMRTableCellRenderer colorCellRenderer = new NMRTableCellRenderer();
    JTable noeTable;
    private NoeTableModel noeTableModel;
    private ListSelectionModel noeSelection;
    int[] selectedNoeRow = new int[2];
    JButton noedeleteButton;
    private JButton noedeleteAllButton;
    JButton noesetRefButton;
    JComboBox<String> expOrDistButton;
    double noeNPrefValue = 1.0;
    int[] noeNPrefIndices = new int[2];
    double noeExprefValue = 1.0;
    boolean lrefSingle = true;
    public NoeParameterSelectionPanel noeParameterSelectionPanel;
    public NoeColourSelectionPanel noeColourSelectionPanel;

    public NoeTable(NMR_JmolPanel nmrPanel, JFrame parentFrame) {
        this.nmrPanel = nmrPanel;
        this.viewer = (NMR_Viewer)nmrPanel.vwr;
        JPanel mainTable = new JPanel();
        mainTable.setLayout(new BorderLayout());
        mainTable.add((Component)this.constructNoeTable(), "Center");
        JPanel foo = new JPanel();
        foo.setLayout(new BorderLayout());
        foo.add((Component)this.constructNoeButtonPanel(), "Center");
        mainTable.add((Component)foo, "South");
        this.addTab("Table", null, mainTable, "Table of Selected NOEs");
        this.noeParameterSelectionPanel = new NoeParameterSelectionPanel(this);
        this.addTab("Parameters", null, this.noeParameterSelectionPanel, "Parameter Setting");
        this.noeColourSelectionPanel = new NoeColourSelectionPanel(this);
        this.addTab("Cell Colours", null, this.noeColourSelectionPanel, "Cell Colour Setting");
        this.selectedNoeRow[1] = -1;
        this.selectedNoeRow[0] = -1;
        this.noeNPrefIndices[1] = -1;
        this.noeNPrefIndices[0] = -1;
    }

    JComponent constructNoeTable() {
        this.noeTableModel = new NoeTableModel();
        this.noeTable = new JTable(this.noeTableModel);
        TableColumn tc = this.noeTable.getColumnModel().getColumn(1);
        this.setYellowValue(this.yellowValue);
        this.setRedValue(this.redValue);
        tc.setCellRenderer(this.colorCellRenderer);
        tc = this.noeTable.getColumnModel().getColumn(0);
        tc.setCellRenderer(this.colorCellRenderer);
        this.noeTable.setPreferredScrollableViewportSize(new Dimension(300, 100));
        this.noeTable.getColumnModel().getColumn(0).setPreferredWidth(50);
        int i = 5;
        while (--i > 0) {
            this.noeTable.getColumnModel().getColumn(i).setPreferredWidth(15);
        }
        this.noeTable.setSelectionMode(1);
        this.noeTable.setRowSelectionAllowed(true);
        this.noeTable.setColumnSelectionAllowed(false);
        this.noeSelection = this.noeTable.getSelectionModel();
        this.noeSelection.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (lsm.isSelectionEmpty()) {
                    NoeTable.this.selectedNoeRow[1] = -1;
                    NoeTable.this.selectedNoeRow[0] = -1;
                    NoeTable.this.noedeleteButton.setEnabled(false);
                } else if (lsm.getMinSelectionIndex() != lsm.getMaxSelectionIndex()) {
                    NoeTable.this.selectedNoeRow[0] = lsm.getMinSelectionIndex();
                    NoeTable.this.selectedNoeRow[1] = lsm.getMaxSelectionIndex();
                    NoeTable.this.noesetRefButton.setEnabled(false);
                } else {
                    NoeTable.this.selectedNoeRow[0] = lsm.getMinSelectionIndex();
                    NoeTable.this.selectedNoeRow[1] = lsm.getMaxSelectionIndex();
                    NoeTable.this.noedeleteButton.setEnabled(true);
                    NoeTable.this.noesetRefButton.setEnabled(true);
                }
            }
        });
        return new JScrollPane(this.noeTable);
    }

    JComponent constructNoeButtonPanel() {
        JPanel noeButtonPanel = new JPanel();
        noeButtonPanel.setLayout(new FlowLayout(0));
        this.noedeleteButton = new JButton(GT.$("Del"));
        this.noedeleteButton.setToolTipText("Delete Selected NOEs");
        this.noedeleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int ndelete = NoeTable.this.selectedNoeRow[1] - NoeTable.this.selectedNoeRow[0] + 1;
                int[] deletevRows = new int[ndelete];
                int pt = 0;
                int n = NoeTable.this.selectedNoeRow[1];
                for (int i = NoeTable.this.selectedNoeRow[0]; i <= n; ++i) {
                    int vRow;
                    deletevRows[pt] = vRow = NoeTable.this.getViewerRow(i);
                    ++pt;
                }
                Arrays.sort(deletevRows);
                for (int i = ndelete - 1; i >= 0; --i) {
                    NoeTable.this.viewer.deleteMeasurement(deletevRows[i]);
                }
                NoeTable.this.updateNoeTableData();
                NoeTable.this.viewer.script("background white");
            }
        });
        this.noedeleteButton.setEnabled(false);
        this.noesetRefButton = new JButton(GT.$("Ref"));
        this.noesetRefButton.setToolTipText("Set Reference NOE");
        this.noesetRefButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int vRow = NoeTable.this.getViewerRow(NoeTable.this.selectedNoeRow[0]);
                int[] countPlusIndices = NoeTable.this.viewer.getMeasurementCountPlusIndices(vRow);
                NoeTable.this.noeNPrefIndices[0] = countPlusIndices[1];
                NoeTable.this.noeNPrefIndices[1] = countPlusIndices[2];
                NoeTable.this.noeNPrefValue = NoeTable.this.calcProps.getJmolNoe(countPlusIndices[1], countPlusIndices[2]);
                String val = NoeTable.this.expNoes[countPlusIndices[1]][countPlusIndices[2]];
                if (val == null) {
                    NoeTable.this.noeExprefValue = 1.0;
                } else {
                    NoeTable.this.noeExprefValue = Double.valueOf(val);
                    if (!(NoeTable.this.noeExprefValue < 0.0) && !(NoeTable.this.noeExprefValue > 0.0)) {
                        NoeTable.this.noeExprefValue = 1.0;
                    }
                }
                NoeTable.this.updateNoeTableData();
            }
        });
        this.noesetRefButton.setEnabled(false);
        this.noedeleteAllButton = new JButton(GT.$("Del All"));
        this.noedeleteAllButton.setToolTipText("Delete All NOEs");
        this.noedeleteAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int i = NoeTable.this.noeTable.getRowCount() - 1; i >= 0; --i) {
                    int vRow = NoeTable.this.getViewerRow(i);
                    NoeTable.this.viewer.deleteMeasurement(vRow);
                }
                NoeTable.this.updateNoeTableData();
            }
        });
        this.noedeleteAllButton.setEnabled(false);
        String[] labels = new String[]{"Exp NOEs", "Exp Dists"};
        this.expOrDistButton = new JComboBox<String>(labels);
        this.expOrDistButton.setToolTipText("Choose either experimental NOEs or experimental distances to display and enter");
        this.expOrDistButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                int sel = cb.getSelectedIndex();
                NoeTable.this.lexpNoes = sel == 0;
                NoeTable.this.updateNoeTableStructure();
                NoeTable.this.updateNoeTableData();
            }
        });
        noeButtonPanel.add(this.noesetRefButton);
        noeButtonPanel.add(this.noedeleteButton);
        noeButtonPanel.add(this.noedeleteAllButton);
        noeButtonPanel.add(this.expOrDistButton);
        return noeButtonPanel;
    }

    JComponent constructDismissButtonPanel() {
        JPanel dismissButtonPanel = new JPanel();
        dismissButtonPanel.setLayout(new FlowLayout(2));
        JButton dismissButton = new JButton(GT.$("Dismiss"));
        dismissButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NoeTable.this.close();
            }
        });
        dismissButtonPanel.add(dismissButton);
        return dismissButtonPanel;
    }

    protected void centerDialog() {
        Dimension screenSize = this.getToolkit().getScreenSize();
        Dimension size = this.getSize();
        screenSize.height /= 2;
        screenSize.width /= 2;
        size.height /= 2;
        size.width /= 2;
        int y = screenSize.height - size.height;
        int x = screenSize.width - size.width;
        this.setLocation(x, y);
    }

    public void close() {
        this.setVisible(false);
    }

    public void activate() {
        this.updateNoeTableData();
        this.setVisible(true);
    }

    void updateNoeTableData() {
        this.noedeleteAllButton.setEnabled(this.viewer.getMeasurementCount() > 0);
        this.noeTableModel.fireTableDataChanged();
        this.calcFrameDelta();
        this.nmrPanel.clearViewerSelection();
    }

    void updateNoeTableStructure() {
        this.noeTableModel.fireTableStructureChanged();
        TableColumn tc = this.noeTable.getColumnModel().getColumn(1);
        tc.setCellRenderer(this.colorCellRenderer);
        tc = this.noeTable.getColumnModel().getColumn(0);
        tc.setCellRenderer(this.colorCellRenderer);
    }

    public int getRowCount() {
        return this.noeTableModel.getRowCount();
    }

    public int[] getMeasurementCountPlusIndices(int row) {
        return this.noeTableModel.getMeasurementCountPlusIndices(row);
    }

    private void calcFrameDelta() {
        int n = this.noeTableModel.getRowCount();
        double frameDelta = 0.0;
        for (int i = 0; i < n; ++i) {
            if (this.lexpNoes) {
                frameDelta += ((Measure)this.noeTableModel.getValueAt(i, 1)).getDiff();
                continue;
            }
            frameDelta += ((Measure)this.noeTableModel.getValueAt(i, 0)).getDiff();
        }
        this.frameDeltaDisplay.setFrameDeltaNoe(frameDelta);
    }

    public void updateTables() {
        this.updateNoeTableData();
    }

    protected int getViewerRow(int i) {
        return this.nmrPanel.getViewerRow(i, 8);
    }

    boolean checkNoe(int i) {
        return this.nmrPanel.getViewerMeasurement(i, 8) != null;
    }

    int calcNatomsPerModel() {
        int nmodel = this.viewer.getModelCount();
        return nmodel > 0 ? this.viewer.getAtomCount() / nmodel : 0;
    }

    public void addMol() {
        this.calcProps = this.nmrPanel.getDistanceJMolecule(null, this.labelArray, true);
        this.calcProps.setCorrelationTimeTauPS(this.tau);
        this.calcProps.setMixingTimeSec(this.tMix);
        this.calcProps.setNMRfreqMHz(this.freq);
        this.calcProps.setCutoffAng(this.cutoff);
        this.calcProps.setRhoStar(this.rhoStar);
        this.calcProps.setNoesy(this.noesy);
        this.calcProps.calcNOEs();
        this.molCDKuptodate = true;
    }

    public void setmolCDKuptodate(boolean value) {
        this.molCDKuptodate = value;
    }

    public void allocateLabelArray(int numAtoms) {
        this.labelArray = new String[numAtoms];
    }

    public void allocateExpNoes(int numAtoms) {
        this.expNoes = new String[numAtoms][numAtoms];
        this.expDists = new String[numAtoms][numAtoms];
    }

    public String getExpNoe(int i, int j) {
        return this.expNoes[i][j];
    }

    public String getExpDist(int i, int j) {
        return this.expDists[i][j];
    }

    public void setExpNoe(String value, int i, int j) {
        if (value.trim().length() == 0) {
            value = null;
        }
        this.expNoes[i][j] = value;
        this.expNoes[j][i] = value;
    }

    public void setExpDist(String value, int i, int j) {
        if (value.trim().length() == 0) {
            value = null;
        }
        this.expDists[i][j] = value;
        this.expDists[j][i] = value;
    }

    public void setLabelArray(String[] labelArray) {
        this.labelArray = labelArray;
    }

    public void setCorrelationTime(double t) {
        this.tau = t;
        this.setmolCDKuptodate(false);
    }

    public void setMixingTime(double t) {
        this.tMix = t;
        this.setmolCDKuptodate(false);
    }

    public void setNMRfreq(double f) {
        this.freq = f;
        this.setmolCDKuptodate(false);
    }

    public void setCutoff(double c) {
        this.cutoff = c;
        this.setmolCDKuptodate(false);
    }

    public void setRhoStar(double c) {
        this.rhoStar = c;
        this.setmolCDKuptodate(false);
    }

    public void setNoesy(boolean b) {
        this.noesy = b;
        this.setmolCDKuptodate(false);
    }

    public void setlrefSingle(boolean l) {
        this.lrefSingle = l;
    }

    public double getCorrelationTime() {
        return this.tau;
    }

    public double getMixingTime() {
        return this.tMix;
    }

    public double getNMRfreq() {
        return this.freq;
    }

    public double getCutoff() {
        return this.cutoff;
    }

    public double getRhoStar() {
        return this.rhoStar;
    }

    public boolean getNoesy() {
        return this.noesy;
    }

    public void setRedValue(double value) {
        this.redValue = value;
        this.colorCellRenderer.setRedLevel(this.redValue);
    }

    public void setYellowValue(double value) {
        this.yellowValue = value;
        this.colorCellRenderer.setYellowLevel(this.yellowValue);
    }

    public double getRedValue() {
        return this.redValue;
    }

    public double getYellowValue() {
        return this.yellowValue;
    }

    public int[] getnoeNPrefIndices() {
        return this.noeNPrefIndices;
    }

    public void setNoeNPrefIndices(int[] noeNPrefIndices) {
        this.noeNPrefIndices = noeNPrefIndices;
    }

    public double getNoeExprefValue() {
        return this.noeExprefValue;
    }

    public void setNoeExprefValue(double value) {
        this.noeExprefValue = value;
    }

    public void setFrameDeltaDisplay(FrameDeltaDisplay frameDeltaDisplay) {
        this.frameDeltaDisplay = frameDeltaDisplay;
    }

    public boolean getlexpNoes() {
        return this.lexpNoes;
    }

    class NoeTableModel
    extends AbstractTableModel {
        final String[] noeHeaders = new String[]{GT.$("Distance/A"), GT.$("NOE"), "Atom 1", "Atom 2", "Exp NOE", "Exp Distance/A"};

        NoeTableModel() {
        }

        @Override
        public String getColumnName(int col) {
            if (col < 4) {
                return this.noeHeaders[col];
            }
            if (NoeTable.this.lexpNoes) {
                return this.noeHeaders[4];
            }
            return this.noeHeaders[5];
        }

        @Override
        public int getRowCount() {
            NoeTable.this.natomsPerModel = NoeTable.this.nmrPanel.getFrameAtomCount();
            int rowCount = 0;
            for (int i = 0; i < NoeTable.this.viewer.getMeasurementCount(); ++i) {
                if (!NoeTable.this.checkNoe(i)) continue;
                ++rowCount;
            }
            return rowCount;
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public Class<?> getColumnClass(int col) {
            return String.class;
        }

        public int[] getMeasurementCountPlusIndices(int row) {
            int vRow = NoeTable.this.getViewerRow(row);
            int[] countPlusIndices = NoeTable.this.viewer.getMeasurementCountPlusIndices(vRow);
            return countPlusIndices;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (!NoeTable.this.molCDKuptodate) {
                NoeTable.this.addMol();
            }
            int vRow = NoeTable.this.getViewerRow(row);
            int[] m = NoeTable.this.viewer.getMeasurementCountPlusIndices(vRow);
            int a1 = m[1];
            int a2 = m[2];
            double noeNP = NoeTable.this.calcProps.getJmolNoe(a1, a2);
            double noeNPref = 1.0;
            int base = NoeTable.this.viewer.getFrameBase(a1);
            int f1 = a1 - base;
            int f2 = a2 - base;
            if (NoeTable.this.lrefSingle) {
                if (NoeTable.this.noeNPrefIndices[0] != -1 && NoeTable.this.noeNPrefIndices[1] != -1) {
                    noeNPref = NoeTable.this.calcProps.getJmolNoe(NoeTable.this.noeNPrefIndices[0], NoeTable.this.noeNPrefIndices[1]);
                }
            } else {
                noeNPref = noeNP;
            }
            noeNP /= noeNPref;
            String expNOE = NoeTable.this.expNoes[f1][f2];
            String expDist = NoeTable.this.expDists[f1][f2];
            try {
                double dExpNOE = Double.valueOf(expNOE);
                if (NoeTable.this.lrefSingle) {
                    dExpNOE /= NoeTable.this.noeExprefValue;
                }
                expNOE = Measure.formatExpNOE(dExpNOE);
            }
            catch (Exception exception) {
                // empty catch block
            }
            double distNP = NoeTable.this.calcProps.getJmolDistance(a1, a2);
            MeasureNoe measure = new MeasureNoe(expNOE, noeNP);
            MeasureDist measured = new MeasureDist(expDist, distNP);
            if (col == 0) {
                return measured;
            }
            if (col == 1) {
                return measure;
            }
            if (col == 4) {
                if (NoeTable.this.lexpNoes) {
                    return measure.getExpValue();
                }
                return measured.getExpValue();
            }
            if (col >= m[0] + 2) {
                return null;
            }
            int atomIndex = m[col - 1];
            String name = NoeTable.this.labelArray[atomIndex];
            String reserve = "" + NoeTable.this.viewer.getAtomNumber(atomIndex) + " " + NoeTable.this.viewer.getAtomName(atomIndex);
            return name == null || name.trim().length() == 0 ? reserve : name.trim();
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 4) {
                String val = (String)value;
                if (val.trim().length() == 0) {
                    val = null;
                }
                try {
                    Double.valueOf(val);
                }
                catch (Exception e) {
                    val = null;
                }
                int vRow = NoeTable.this.getViewerRow(row);
                int[] m = NoeTable.this.viewer.getMeasurementCountPlusIndices(vRow);
                if (NoeTable.this.lexpNoes) {
                    NoeTable.this.expNoes[m[1]][m[2]] = val;
                    NoeTable.this.expNoes[m[2]][m[1]] = val;
                } else {
                    NoeTable.this.expDists[m[1]][m[2]] = val;
                    NoeTable.this.expDists[m[2]][m[1]] = val;
                }
                NoeTable.this.updateNoeTableData();
            }
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 4;
        }
    }

    class NoeListWindowListener
    extends WindowAdapter {
        NoeListWindowListener() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            NoeTable.this.close();
        }
    }
}

