/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.T4CConnection;

class T4CInputStream
extends OracleInputStream {
    T4CInputStream(OracleStatement stmt, int index, Accessor a) {
        super(stmt, index, a);
    }

    @Override
    public boolean isNull() throws IOException {
        if (!this.statement.isFetchStreams) {
            return super.isNull();
        }
        boolean result = false;
        try {
            int currentRow = this.statement.currentResultSet.getRow();
            if (currentRow < 0) {
                currentRow = 0;
            }
            if ((long)currentRow >= this.statement.validRows) {
                return true;
            }
            result = this.statement.isNull(currentRow, this.columnIndex);
        }
        catch (SQLException exc) {
            throw (IOException)DatabaseError.createIOException(exc).fillInStackTrace();
        }
        return result;
    }

    @Override
    public int getBytes(int howMany, byte[] buffer) throws IOException {
        this.statement.connection.assertLockHeldByCurrentThread();
        int ret = -1;
        try {
            if (this.statement.connection.getLifecycle() == 1 || this.statement.connection.getLifecycle() == 2) {
                ret = this.accessor.readStream(buffer, howMany);
            }
        }
        catch (SQLException e) {
            throw new IOException(e.getMessage());
        }
        catch (IOException ea) {
            try {
                ((T4CConnection)this.statement.connection).handleIOException(ea);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw ea;
        }
        return ret;
    }
}

