/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.creole.atom;

import net.sourceforge.plantuml.emoji.Emoji;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.atom.AbstractAtom;
import net.sourceforge.plantuml.klimt.creole.atom.Atom;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;

public class AtomEmoji
extends AbstractAtom
implements Atom {
    private static final double MAGIC = 24.0;
    private final Emoji emoji;
    private final double factor;
    private final HColor color;

    public AtomEmoji(Emoji emoji, double scale, double size2D, HColor color) {
        this.emoji = emoji;
        this.factor = scale * size2D / 24.0;
        this.color = color;
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        double size = 36.0 * this.factor;
        return new XDimension2D(size, size);
    }

    @Override
    public double getStartingAltitude(StringBounder stringBounder) {
        return -3.0 * this.factor;
    }

    @Override
    public void drawU(UGraphic ug) {
        this.emoji.drawU(ug, this.factor, this.color);
    }
}

