/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene70;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.lucene70.IndexedDISI;
import org.apache.lucene.index.BaseTermsEnum;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.ImpactsEnum;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.RandomAccessInput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.LongValues;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.DirectMonotonicReader;
import org.apache.lucene.util.packed.DirectReader;

final class Lucene70DocValuesProducer
extends DocValuesProducer
implements Closeable {
    private final Map<String, NumericEntry> numerics;
    private final Map<String, BinaryEntry> binaries;
    private final Map<String, SortedEntry> sorted;
    private final Map<String, SortedSetEntry> sortedSets;
    private final Map<String, SortedNumericEntry> sortedNumerics;
    private long ramBytesUsed;
    private final IndexInput data;
    private final int maxDoc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Lucene70DocValuesProducer(SegmentReadState state, String dataCodec, String dataExtension, String metaCodec, String metaExtension) throws IOException {
        int version;
        block14: {
            this.numerics = new HashMap<String, NumericEntry>();
            this.binaries = new HashMap<String, BinaryEntry>();
            this.sorted = new HashMap<String, SortedEntry>();
            this.sortedSets = new HashMap<String, SortedSetEntry>();
            this.sortedNumerics = new HashMap<String, SortedNumericEntry>();
            String metaName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)metaExtension);
            this.maxDoc = state.segmentInfo.maxDoc();
            this.ramBytesUsed = RamUsageEstimator.shallowSizeOfInstance(this.getClass());
            version = -1;
            try (ChecksumIndexInput in = state.directory.openChecksumInput(metaName, state.context);){
                Throwable priorE = null;
                try {
                    version = CodecUtil.checkIndexHeader((DataInput)in, (String)metaCodec, (int)0, (int)0, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
                    this.readFields(in, state.fieldInfos);
                }
                catch (Throwable exception) {
                    try {
                        priorE = exception;
                        break block14;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        CodecUtil.checkFooter((ChecksumIndexInput)in, (Throwable)priorE);
                    }
                }
                CodecUtil.checkFooter((ChecksumIndexInput)in, (Throwable)priorE);
            }
        }
        String dataName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)dataExtension);
        this.data = state.directory.openInput(dataName, state.context);
        boolean success = false;
        try {
            int version2 = CodecUtil.checkIndexHeader((DataInput)this.data, (String)dataCodec, (int)0, (int)0, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
            if (version != version2) {
                throw new CorruptIndexException("Format versions mismatch: meta=" + version + ", data=" + version2, (DataInput)this.data);
            }
            CodecUtil.retrieveChecksum((IndexInput)this.data);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.data});
            throw throwable;
        }
    }

    private void readFields(ChecksumIndexInput meta, FieldInfos infos) throws IOException {
        int fieldNumber = meta.readInt();
        while (fieldNumber != -1) {
            FieldInfo info = infos.fieldInfo(fieldNumber);
            if (info == null) {
                throw new CorruptIndexException("Invalid field number: " + fieldNumber, (DataInput)meta);
            }
            byte type = meta.readByte();
            if (type == 0) {
                this.numerics.put(info.name, this.readNumeric(meta));
            } else if (type == 1) {
                this.binaries.put(info.name, this.readBinary(meta));
            } else if (type == 2) {
                this.sorted.put(info.name, this.readSorted(meta));
            } else if (type == 3) {
                this.sortedSets.put(info.name, this.readSortedSet(meta));
            } else if (type == 4) {
                this.sortedNumerics.put(info.name, this.readSortedNumeric(meta));
            } else {
                throw new CorruptIndexException("invalid type: " + type, (DataInput)meta);
            }
            fieldNumber = meta.readInt();
        }
    }

    private NumericEntry readNumeric(ChecksumIndexInput meta) throws IOException {
        NumericEntry entry = new NumericEntry();
        this.readNumeric(meta, entry);
        return entry;
    }

    private void readNumeric(ChecksumIndexInput meta, NumericEntry entry) throws IOException {
        entry.docsWithFieldOffset = meta.readLong();
        entry.docsWithFieldLength = meta.readLong();
        entry.numValues = meta.readLong();
        int tableSize = meta.readInt();
        if (tableSize > 256) {
            throw new CorruptIndexException("invalid table size: " + tableSize, (DataInput)meta);
        }
        if (tableSize >= 0) {
            entry.table = new long[tableSize];
            this.ramBytesUsed += RamUsageEstimator.sizeOf((long[])entry.table);
            for (int i = 0; i < tableSize; ++i) {
                entry.table[i] = meta.readLong();
            }
        }
        entry.blockShift = tableSize < -1 ? -2 - tableSize : -1;
        entry.bitsPerValue = meta.readByte();
        entry.minValue = meta.readLong();
        entry.gcd = meta.readLong();
        entry.valuesOffset = meta.readLong();
        entry.valuesLength = meta.readLong();
    }

    private BinaryEntry readBinary(ChecksumIndexInput meta) throws IOException {
        BinaryEntry entry = new BinaryEntry();
        entry.dataOffset = meta.readLong();
        entry.dataLength = meta.readLong();
        entry.docsWithFieldOffset = meta.readLong();
        entry.docsWithFieldLength = meta.readLong();
        entry.numDocsWithField = meta.readInt();
        entry.minLength = meta.readInt();
        entry.maxLength = meta.readInt();
        if (entry.minLength < entry.maxLength) {
            entry.addressesOffset = meta.readLong();
            int blockShift = meta.readVInt();
            entry.addressesMeta = DirectMonotonicReader.loadMeta((IndexInput)meta, (long)((long)entry.numDocsWithField + 1L), (int)blockShift);
            this.ramBytesUsed += entry.addressesMeta.ramBytesUsed();
            entry.addressesLength = meta.readLong();
        }
        return entry;
    }

    private SortedEntry readSorted(ChecksumIndexInput meta) throws IOException {
        SortedEntry entry = new SortedEntry();
        entry.docsWithFieldOffset = meta.readLong();
        entry.docsWithFieldLength = meta.readLong();
        entry.numDocsWithField = meta.readInt();
        entry.bitsPerValue = meta.readByte();
        entry.ordsOffset = meta.readLong();
        entry.ordsLength = meta.readLong();
        Lucene70DocValuesProducer.readTermDict(meta, entry);
        return entry;
    }

    private SortedSetEntry readSortedSet(ChecksumIndexInput meta) throws IOException {
        SortedSetEntry entry = new SortedSetEntry();
        byte multiValued = meta.readByte();
        switch (multiValued) {
            case 0: {
                entry.singleValueEntry = this.readSorted(meta);
                return entry;
            }
            case 1: {
                break;
            }
            default: {
                throw new CorruptIndexException("Invalid multiValued flag: " + multiValued, (DataInput)meta);
            }
        }
        entry.docsWithFieldOffset = meta.readLong();
        entry.docsWithFieldLength = meta.readLong();
        entry.bitsPerValue = meta.readByte();
        entry.ordsOffset = meta.readLong();
        entry.ordsLength = meta.readLong();
        entry.numDocsWithField = meta.readInt();
        entry.addressesOffset = meta.readLong();
        int blockShift = meta.readVInt();
        entry.addressesMeta = DirectMonotonicReader.loadMeta((IndexInput)meta, (long)(entry.numDocsWithField + 1), (int)blockShift);
        this.ramBytesUsed += entry.addressesMeta.ramBytesUsed();
        entry.addressesLength = meta.readLong();
        Lucene70DocValuesProducer.readTermDict(meta, entry);
        return entry;
    }

    private static void readTermDict(ChecksumIndexInput meta, TermsDictEntry entry) throws IOException {
        entry.termsDictSize = meta.readVLong();
        entry.termsDictBlockShift = meta.readInt();
        int blockShift = meta.readInt();
        long addressesSize = entry.termsDictSize + (1L << entry.termsDictBlockShift) - 1L >>> entry.termsDictBlockShift;
        entry.termsAddressesMeta = DirectMonotonicReader.loadMeta((IndexInput)meta, (long)addressesSize, (int)blockShift);
        entry.maxTermLength = meta.readInt();
        entry.termsDataOffset = meta.readLong();
        entry.termsDataLength = meta.readLong();
        entry.termsAddressesOffset = meta.readLong();
        entry.termsAddressesLength = meta.readLong();
        entry.termsDictIndexShift = meta.readInt();
        long indexSize = entry.termsDictSize + (1L << entry.termsDictIndexShift) - 1L >>> entry.termsDictIndexShift;
        entry.termsIndexAddressesMeta = DirectMonotonicReader.loadMeta((IndexInput)meta, (long)(1L + indexSize), (int)blockShift);
        entry.termsIndexOffset = meta.readLong();
        entry.termsIndexLength = meta.readLong();
        entry.termsIndexAddressesOffset = meta.readLong();
        entry.termsIndexAddressesLength = meta.readLong();
    }

    private SortedNumericEntry readSortedNumeric(ChecksumIndexInput meta) throws IOException {
        SortedNumericEntry entry = new SortedNumericEntry();
        this.readNumeric(meta, entry);
        entry.numDocsWithField = meta.readInt();
        if ((long)entry.numDocsWithField != entry.numValues) {
            entry.addressesOffset = meta.readLong();
            int blockShift = meta.readVInt();
            entry.addressesMeta = DirectMonotonicReader.loadMeta((IndexInput)meta, (long)(entry.numDocsWithField + 1), (int)blockShift);
            this.ramBytesUsed += entry.addressesMeta.ramBytesUsed();
            entry.addressesLength = meta.readLong();
        }
        return entry;
    }

    @Override
    public void close() throws IOException {
        this.data.close();
    }

    public long ramBytesUsed() {
        return this.ramBytesUsed;
    }

    public NumericDocValues getNumeric(FieldInfo field) throws IOException {
        NumericEntry entry = this.numerics.get(field.name);
        return this.getNumeric(entry);
    }

    private NumericDocValues getNumeric(final NumericEntry entry) throws IOException {
        if (entry.docsWithFieldOffset == -2L) {
            return DocValues.emptyNumeric();
        }
        if (entry.docsWithFieldOffset == -1L) {
            if (entry.bitsPerValue == 0) {
                return new DenseNumericDocValues(this.maxDoc){

                    public long longValue() throws IOException {
                        return entry.minValue;
                    }
                };
            }
            final RandomAccessInput slice = this.data.randomAccessSlice(entry.valuesOffset, entry.valuesLength);
            if (entry.blockShift >= 0) {
                final int shift = entry.blockShift;
                final long mul = entry.gcd;
                final int mask = (1 << shift) - 1;
                return new DenseNumericDocValues(this.maxDoc){
                    int block;
                    long delta;
                    long offset;
                    long blockEndOffset;
                    LongValues values;
                    {
                        super(maxDoc);
                        this.block = -1;
                    }

                    public long longValue() throws IOException {
                        int block = this.doc >>> shift;
                        if (this.block != block) {
                            byte bitsPerValue;
                            do {
                                this.offset = this.blockEndOffset;
                                bitsPerValue = slice.readByte(this.offset++);
                                this.delta = slice.readLong(this.offset);
                                this.offset += 8L;
                                if (bitsPerValue == 0) {
                                    this.blockEndOffset = this.offset;
                                } else {
                                    int length = slice.readInt(this.offset);
                                    this.offset += 4L;
                                    this.blockEndOffset = this.offset + (long)length;
                                }
                                ++this.block;
                            } while (this.block != block);
                            this.values = bitsPerValue == 0 ? LongValues.ZEROES : DirectReader.getInstance((RandomAccessInput)slice, (int)bitsPerValue, (long)this.offset);
                        }
                        return mul * this.values.get((long)(this.doc & mask)) + this.delta;
                    }
                };
            }
            final LongValues values = DirectReader.getInstance((RandomAccessInput)slice, (int)entry.bitsPerValue);
            if (entry.table != null) {
                final long[] table = entry.table;
                return new DenseNumericDocValues(this.maxDoc){

                    public long longValue() throws IOException {
                        return table[(int)values.get((long)this.doc)];
                    }
                };
            }
            final long mul = entry.gcd;
            final long delta = entry.minValue;
            return new DenseNumericDocValues(this.maxDoc){

                public long longValue() throws IOException {
                    return mul * values.get((long)this.doc) + delta;
                }
            };
        }
        IndexedDISI disi = new IndexedDISI(this.data, entry.docsWithFieldOffset, entry.docsWithFieldLength, entry.numValues);
        if (entry.bitsPerValue == 0) {
            return new SparseNumericDocValues(disi){

                public long longValue() throws IOException {
                    return entry.minValue;
                }
            };
        }
        final RandomAccessInput slice = this.data.randomAccessSlice(entry.valuesOffset, entry.valuesLength);
        if (entry.blockShift >= 0) {
            final int shift = entry.blockShift;
            final long mul = entry.gcd;
            final int mask = (1 << shift) - 1;
            return new SparseNumericDocValues(disi){
                int block;
                long delta;
                long offset;
                long blockEndOffset;
                LongValues values;
                {
                    super(disi);
                    this.block = -1;
                }

                public long longValue() throws IOException {
                    int index = this.disi.index();
                    int block = index >>> shift;
                    if (this.block != block) {
                        byte bitsPerValue;
                        do {
                            this.offset = this.blockEndOffset;
                            bitsPerValue = slice.readByte(this.offset++);
                            this.delta = slice.readLong(this.offset);
                            this.offset += 8L;
                            if (bitsPerValue == 0) {
                                this.blockEndOffset = this.offset;
                            } else {
                                int length = slice.readInt(this.offset);
                                this.offset += 4L;
                                this.blockEndOffset = this.offset + (long)length;
                            }
                            ++this.block;
                        } while (this.block != block);
                        this.values = bitsPerValue == 0 ? LongValues.ZEROES : DirectReader.getInstance((RandomAccessInput)slice, (int)bitsPerValue, (long)this.offset);
                    }
                    return mul * this.values.get((long)(index & mask)) + this.delta;
                }
            };
        }
        final LongValues values = DirectReader.getInstance((RandomAccessInput)slice, (int)entry.bitsPerValue);
        if (entry.table != null) {
            final long[] table = entry.table;
            return new SparseNumericDocValues(disi){

                public long longValue() throws IOException {
                    return table[(int)values.get((long)this.disi.index())];
                }
            };
        }
        final long mul = entry.gcd;
        final long delta = entry.minValue;
        return new SparseNumericDocValues(disi){

            public long longValue() throws IOException {
                return mul * values.get((long)this.disi.index()) + delta;
            }
        };
    }

    private LongValues getNumericValues(final NumericEntry entry) throws IOException {
        if (entry.bitsPerValue == 0) {
            return new LongValues(){

                public long get(long index) {
                    return entry.minValue;
                }
            };
        }
        final RandomAccessInput slice = this.data.randomAccessSlice(entry.valuesOffset, entry.valuesLength);
        if (entry.blockShift >= 0) {
            final int shift = entry.blockShift;
            final long mul = entry.gcd;
            final long mask = (1L << shift) - 1L;
            return new LongValues(){
                long block = -1L;
                long delta;
                long offset;
                long blockEndOffset;
                LongValues values;

                public long get(long index) {
                    long block = index >>> shift;
                    if (this.block != block) {
                        byte bitsPerValue;
                        assert (block > this.block) : "Reading backwards is illegal: " + this.block + " < " + block;
                        do {
                            this.offset = this.blockEndOffset;
                            try {
                                bitsPerValue = slice.readByte(this.offset++);
                                this.delta = slice.readLong(this.offset);
                                this.offset += 8L;
                                if (bitsPerValue == 0) {
                                    this.blockEndOffset = this.offset;
                                } else {
                                    int length = slice.readInt(this.offset);
                                    this.offset += 4L;
                                    this.blockEndOffset = this.offset + (long)length;
                                }
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                            ++this.block;
                        } while (this.block != block);
                        this.values = bitsPerValue == 0 ? LongValues.ZEROES : DirectReader.getInstance((RandomAccessInput)slice, (int)bitsPerValue, (long)this.offset);
                    }
                    return mul * this.values.get(index & mask) + this.delta;
                }
            };
        }
        final LongValues values = DirectReader.getInstance((RandomAccessInput)slice, (int)entry.bitsPerValue);
        if (entry.table != null) {
            final long[] table = entry.table;
            return new LongValues(){

                public long get(long index) {
                    return table[(int)values.get(index)];
                }
            };
        }
        if (entry.gcd != 1L) {
            final long gcd = entry.gcd;
            final long minValue = entry.minValue;
            return new LongValues(){

                public long get(long index) {
                    return values.get(index) * gcd + minValue;
                }
            };
        }
        if (entry.minValue != 0L) {
            final long minValue = entry.minValue;
            return new LongValues(){

                public long get(long index) {
                    return values.get(index) + minValue;
                }
            };
        }
        return values;
    }

    public BinaryDocValues getBinary(FieldInfo field) throws IOException {
        final BinaryEntry entry = this.binaries.get(field.name);
        if (entry.docsWithFieldOffset == -2L) {
            return DocValues.emptyBinary();
        }
        final IndexInput bytesSlice = this.data.slice("fixed-binary", entry.dataOffset, entry.dataLength);
        if (entry.docsWithFieldOffset == -1L) {
            if (entry.minLength == entry.maxLength) {
                final int length = entry.maxLength;
                return new DenseBinaryDocValues(this.maxDoc){
                    final BytesRef bytes;
                    {
                        super(maxDoc);
                        this.bytes = new BytesRef(new byte[length], 0, length);
                    }

                    public BytesRef binaryValue() throws IOException {
                        bytesSlice.seek((long)this.doc * (long)length);
                        bytesSlice.readBytes(this.bytes.bytes, 0, length);
                        return this.bytes;
                    }
                };
            }
            RandomAccessInput addressesData = this.data.randomAccessSlice(entry.addressesOffset, entry.addressesLength);
            DirectMonotonicReader addresses = DirectMonotonicReader.getInstance((DirectMonotonicReader.Meta)entry.addressesMeta, (RandomAccessInput)addressesData);
            return new DenseBinaryDocValues(this.maxDoc, (LongValues)addresses, bytesSlice){
                final BytesRef bytes;
                final /* synthetic */ LongValues val$addresses;
                final /* synthetic */ IndexInput val$bytesSlice;
                {
                    this.val$addresses = longValues;
                    this.val$bytesSlice = indexInput;
                    super(maxDoc);
                    this.bytes = new BytesRef(new byte[entry.maxLength], 0, entry.maxLength);
                }

                public BytesRef binaryValue() throws IOException {
                    long startOffset = this.val$addresses.get((long)this.doc);
                    this.bytes.length = (int)(this.val$addresses.get((long)this.doc + 1L) - startOffset);
                    this.val$bytesSlice.seek(startOffset);
                    this.val$bytesSlice.readBytes(this.bytes.bytes, 0, this.bytes.length);
                    return this.bytes;
                }
            };
        }
        IndexedDISI disi = new IndexedDISI(this.data, entry.docsWithFieldOffset, entry.docsWithFieldLength, entry.numDocsWithField);
        if (entry.minLength == entry.maxLength) {
            final int length = entry.maxLength;
            return new SparseBinaryDocValues(disi){
                final BytesRef bytes;
                {
                    super(disi);
                    this.bytes = new BytesRef(new byte[length], 0, length);
                }

                public BytesRef binaryValue() throws IOException {
                    bytesSlice.seek((long)this.disi.index() * (long)length);
                    bytesSlice.readBytes(this.bytes.bytes, 0, length);
                    return this.bytes;
                }
            };
        }
        RandomAccessInput addressesData = this.data.randomAccessSlice(entry.addressesOffset, entry.addressesLength);
        DirectMonotonicReader addresses = DirectMonotonicReader.getInstance((DirectMonotonicReader.Meta)entry.addressesMeta, (RandomAccessInput)addressesData);
        return new SparseBinaryDocValues(disi, (LongValues)addresses, bytesSlice){
            final BytesRef bytes;
            final /* synthetic */ LongValues val$addresses;
            final /* synthetic */ IndexInput val$bytesSlice;
            {
                this.val$addresses = longValues;
                this.val$bytesSlice = indexInput;
                super(disi);
                this.bytes = new BytesRef(new byte[entry.maxLength], 0, entry.maxLength);
            }

            public BytesRef binaryValue() throws IOException {
                int index = this.disi.index();
                long startOffset = this.val$addresses.get((long)index);
                this.bytes.length = (int)(this.val$addresses.get((long)index + 1L) - startOffset);
                this.val$bytesSlice.seek(startOffset);
                this.val$bytesSlice.readBytes(this.bytes.bytes, 0, this.bytes.length);
                return this.bytes;
            }
        };
    }

    public SortedDocValues getSorted(FieldInfo field) throws IOException {
        SortedEntry entry = this.sorted.get(field.name);
        return this.getSorted(entry);
    }

    private SortedDocValues getSorted(SortedEntry entry) throws IOException {
        LongValues ords;
        if (entry.docsWithFieldOffset == -2L) {
            return DocValues.emptySorted();
        }
        if (entry.bitsPerValue == 0) {
            ords = new LongValues(){

                public long get(long index) {
                    return 0L;
                }
            };
        } else {
            RandomAccessInput slice = this.data.randomAccessSlice(entry.ordsOffset, entry.ordsLength);
            ords = DirectReader.getInstance((RandomAccessInput)slice, (int)entry.bitsPerValue);
        }
        if (entry.docsWithFieldOffset == -1L) {
            return new BaseSortedDocValues(entry, this.data){
                int doc;
                {
                    super(entry, data);
                    this.doc = -1;
                }

                public int nextDoc() throws IOException {
                    return this.advance(this.doc + 1);
                }

                public int docID() {
                    return this.doc;
                }

                public long cost() {
                    return Lucene70DocValuesProducer.this.maxDoc;
                }

                public int advance(int target) throws IOException {
                    if (target >= Lucene70DocValuesProducer.this.maxDoc) {
                        this.doc = Integer.MAX_VALUE;
                        return Integer.MAX_VALUE;
                    }
                    this.doc = target;
                    return this.doc;
                }

                public boolean advanceExact(int target) {
                    this.doc = target;
                    return true;
                }

                public int ordValue() {
                    return (int)ords.get((long)this.doc);
                }
            };
        }
        final IndexedDISI disi = new IndexedDISI(this.data, entry.docsWithFieldOffset, entry.docsWithFieldLength, entry.numDocsWithField);
        return new BaseSortedDocValues(entry, this.data){

            public int nextDoc() throws IOException {
                return disi.nextDoc();
            }

            public int docID() {
                return disi.docID();
            }

            public long cost() {
                return disi.cost();
            }

            public int advance(int target) throws IOException {
                return disi.advance(target);
            }

            public boolean advanceExact(int target) throws IOException {
                return disi.advanceExact(target);
            }

            public int ordValue() {
                return (int)ords.get((long)disi.index());
            }
        };
    }

    public SortedNumericDocValues getSortedNumeric(FieldInfo field) throws IOException {
        SortedNumericEntry entry = this.sortedNumerics.get(field.name);
        if (entry.numValues == (long)entry.numDocsWithField) {
            return DocValues.singleton((NumericDocValues)this.getNumeric(entry));
        }
        RandomAccessInput addressesInput = this.data.randomAccessSlice(entry.addressesOffset, entry.addressesLength);
        DirectMonotonicReader addresses = DirectMonotonicReader.getInstance((DirectMonotonicReader.Meta)entry.addressesMeta, (RandomAccessInput)addressesInput);
        final LongValues values = this.getNumericValues(entry);
        if (entry.docsWithFieldOffset == -1L) {
            return new SortedNumericDocValues((LongValues)addresses, values){
                int doc = -1;
                long start;
                long end;
                int count;
                final /* synthetic */ LongValues val$addresses;
                final /* synthetic */ LongValues val$values;
                {
                    this.val$addresses = longValues;
                    this.val$values = longValues2;
                }

                public int nextDoc() throws IOException {
                    return this.advance(this.doc + 1);
                }

                public int docID() {
                    return this.doc;
                }

                public long cost() {
                    return Lucene70DocValuesProducer.this.maxDoc;
                }

                public int advance(int target) throws IOException {
                    if (target >= Lucene70DocValuesProducer.this.maxDoc) {
                        this.doc = Integer.MAX_VALUE;
                        return Integer.MAX_VALUE;
                    }
                    this.start = this.val$addresses.get((long)target);
                    this.end = this.val$addresses.get((long)target + 1L);
                    this.count = (int)(this.end - this.start);
                    this.doc = target;
                    return this.doc;
                }

                public boolean advanceExact(int target) throws IOException {
                    this.start = this.val$addresses.get((long)target);
                    this.end = this.val$addresses.get((long)target + 1L);
                    this.count = (int)(this.end - this.start);
                    this.doc = target;
                    return true;
                }

                public long nextValue() throws IOException {
                    return this.val$values.get(this.start++);
                }

                public int docValueCount() {
                    return this.count;
                }
            };
        }
        final IndexedDISI disi = new IndexedDISI(this.data, entry.docsWithFieldOffset, entry.docsWithFieldLength, entry.numDocsWithField);
        return new SortedNumericDocValues((LongValues)addresses){
            boolean set;
            long start;
            long end;
            int count;
            final /* synthetic */ LongValues val$addresses;
            {
                this.val$addresses = longValues2;
            }

            public int nextDoc() throws IOException {
                this.set = false;
                return disi.nextDoc();
            }

            public int docID() {
                return disi.docID();
            }

            public long cost() {
                return disi.cost();
            }

            public int advance(int target) throws IOException {
                this.set = false;
                return disi.advance(target);
            }

            public boolean advanceExact(int target) throws IOException {
                this.set = false;
                return disi.advanceExact(target);
            }

            public long nextValue() throws IOException {
                this.set();
                return values.get(this.start++);
            }

            public int docValueCount() {
                this.set();
                return this.count;
            }

            private void set() {
                if (!this.set) {
                    int index = disi.index();
                    this.start = this.val$addresses.get((long)index);
                    this.end = this.val$addresses.get((long)index + 1L);
                    this.count = (int)(this.end - this.start);
                    this.set = true;
                }
            }
        };
    }

    public SortedSetDocValues getSortedSet(FieldInfo field) throws IOException {
        SortedSetEntry entry = this.sortedSets.get(field.name);
        if (entry.singleValueEntry != null) {
            return DocValues.singleton((SortedDocValues)this.getSorted(entry.singleValueEntry));
        }
        RandomAccessInput slice = this.data.randomAccessSlice(entry.ordsOffset, entry.ordsLength);
        LongValues ords = DirectReader.getInstance((RandomAccessInput)slice, (int)entry.bitsPerValue);
        RandomAccessInput addressesInput = this.data.randomAccessSlice(entry.addressesOffset, entry.addressesLength);
        DirectMonotonicReader addresses = DirectMonotonicReader.getInstance((DirectMonotonicReader.Meta)entry.addressesMeta, (RandomAccessInput)addressesInput);
        if (entry.docsWithFieldOffset == -1L) {
            return new BaseSortedSetDocValues(entry, this.data, (LongValues)addresses, ords){
                int doc;
                long start;
                long end;
                final /* synthetic */ LongValues val$addresses;
                final /* synthetic */ LongValues val$ords;
                {
                    this.val$addresses = longValues;
                    this.val$ords = longValues2;
                    super(entry, data);
                    this.doc = -1;
                }

                public int nextDoc() throws IOException {
                    return this.advance(this.doc + 1);
                }

                public int docID() {
                    return this.doc;
                }

                public long cost() {
                    return Lucene70DocValuesProducer.this.maxDoc;
                }

                public int advance(int target) throws IOException {
                    if (target >= Lucene70DocValuesProducer.this.maxDoc) {
                        this.doc = Integer.MAX_VALUE;
                        return Integer.MAX_VALUE;
                    }
                    this.start = this.val$addresses.get((long)target);
                    this.end = this.val$addresses.get((long)target + 1L);
                    this.doc = target;
                    return this.doc;
                }

                public boolean advanceExact(int target) throws IOException {
                    this.start = this.val$addresses.get((long)target);
                    this.end = this.val$addresses.get((long)target + 1L);
                    this.doc = target;
                    return true;
                }

                public long nextOrd() throws IOException {
                    if (this.start == this.end) {
                        return -1L;
                    }
                    return this.val$ords.get(this.start++);
                }
            };
        }
        final IndexedDISI disi = new IndexedDISI(this.data, entry.docsWithFieldOffset, entry.docsWithFieldLength, entry.numDocsWithField);
        return new BaseSortedSetDocValues(entry, this.data, (LongValues)addresses, ords){
            boolean set;
            long start;
            long end;
            final /* synthetic */ LongValues val$addresses;
            final /* synthetic */ LongValues val$ords;
            {
                this.val$addresses = longValues;
                this.val$ords = longValues2;
                super(entry, data);
                this.end = 0L;
            }

            public int nextDoc() throws IOException {
                this.set = false;
                return disi.nextDoc();
            }

            public int docID() {
                return disi.docID();
            }

            public long cost() {
                return disi.cost();
            }

            public int advance(int target) throws IOException {
                this.set = false;
                return disi.advance(target);
            }

            public boolean advanceExact(int target) throws IOException {
                this.set = false;
                return disi.advanceExact(target);
            }

            public long nextOrd() throws IOException {
                if (!this.set) {
                    int index = disi.index();
                    long start = this.val$addresses.get((long)index);
                    this.start = start + 1L;
                    this.end = this.val$addresses.get((long)index + 1L);
                    this.set = true;
                    return this.val$ords.get(start);
                }
                if (this.start == this.end) {
                    return -1L;
                }
                return this.val$ords.get(this.start++);
            }
        };
    }

    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile((IndexInput)this.data);
    }

    private static class NumericEntry {
        long[] table;
        int blockShift;
        byte bitsPerValue;
        long docsWithFieldOffset;
        long docsWithFieldLength;
        long numValues;
        long minValue;
        long gcd;
        long valuesOffset;
        long valuesLength;

        private NumericEntry() {
        }
    }

    private static class BinaryEntry {
        long dataOffset;
        long dataLength;
        long docsWithFieldOffset;
        long docsWithFieldLength;
        int numDocsWithField;
        int minLength;
        int maxLength;
        long addressesOffset;
        long addressesLength;
        DirectMonotonicReader.Meta addressesMeta;

        private BinaryEntry() {
        }
    }

    private static class SortedEntry
    extends TermsDictEntry {
        long docsWithFieldOffset;
        long docsWithFieldLength;
        int numDocsWithField;
        byte bitsPerValue;
        long ordsOffset;
        long ordsLength;

        private SortedEntry() {
        }
    }

    private static class SortedSetEntry
    extends TermsDictEntry {
        SortedEntry singleValueEntry;
        long docsWithFieldOffset;
        long docsWithFieldLength;
        int numDocsWithField;
        byte bitsPerValue;
        long ordsOffset;
        long ordsLength;
        DirectMonotonicReader.Meta addressesMeta;
        long addressesOffset;
        long addressesLength;

        private SortedSetEntry() {
        }
    }

    private static class SortedNumericEntry
    extends NumericEntry {
        int numDocsWithField;
        DirectMonotonicReader.Meta addressesMeta;
        long addressesOffset;
        long addressesLength;

        private SortedNumericEntry() {
        }
    }

    private static class TermsDictEntry {
        long termsDictSize;
        int termsDictBlockShift;
        DirectMonotonicReader.Meta termsAddressesMeta;
        int maxTermLength;
        long termsDataOffset;
        long termsDataLength;
        long termsAddressesOffset;
        long termsAddressesLength;
        int termsDictIndexShift;
        DirectMonotonicReader.Meta termsIndexAddressesMeta;
        long termsIndexOffset;
        long termsIndexLength;
        long termsIndexAddressesOffset;
        long termsIndexAddressesLength;

        private TermsDictEntry() {
        }
    }

    private static class TermsDict
    extends BaseTermsEnum {
        final TermsDictEntry entry;
        final LongValues blockAddresses;
        final IndexInput bytes;
        final long blockMask;
        final LongValues indexAddresses;
        final IndexInput indexBytes;
        final BytesRef term;
        long ord = -1L;

        TermsDict(TermsDictEntry entry, IndexInput data) throws IOException {
            this.entry = entry;
            RandomAccessInput addressesSlice = data.randomAccessSlice(entry.termsAddressesOffset, entry.termsAddressesLength);
            this.blockAddresses = DirectMonotonicReader.getInstance((DirectMonotonicReader.Meta)entry.termsAddressesMeta, (RandomAccessInput)addressesSlice);
            this.bytes = data.slice("terms", entry.termsDataOffset, entry.termsDataLength);
            this.blockMask = (1L << entry.termsDictBlockShift) - 1L;
            RandomAccessInput indexAddressesSlice = data.randomAccessSlice(entry.termsIndexAddressesOffset, entry.termsIndexAddressesLength);
            this.indexAddresses = DirectMonotonicReader.getInstance((DirectMonotonicReader.Meta)entry.termsIndexAddressesMeta, (RandomAccessInput)indexAddressesSlice);
            this.indexBytes = data.slice("terms-index", entry.termsIndexOffset, entry.termsIndexLength);
            this.term = new BytesRef(entry.maxTermLength);
        }

        public BytesRef next() throws IOException {
            if (++this.ord >= this.entry.termsDictSize) {
                return null;
            }
            if ((this.ord & this.blockMask) == 0L) {
                this.term.length = this.bytes.readVInt();
                this.bytes.readBytes(this.term.bytes, 0, this.term.length);
            } else {
                int token = Byte.toUnsignedInt(this.bytes.readByte());
                int prefixLength = token & 0xF;
                int suffixLength = 1 + (token >>> 4);
                if (prefixLength == 15) {
                    prefixLength += this.bytes.readVInt();
                }
                if (suffixLength == 16) {
                    suffixLength += this.bytes.readVInt();
                }
                this.term.length = prefixLength + suffixLength;
                this.bytes.readBytes(this.term.bytes, prefixLength, suffixLength);
            }
            return this.term;
        }

        public void seekExact(long ord) throws IOException {
            if (ord < 0L || ord >= this.entry.termsDictSize) {
                throw new IndexOutOfBoundsException();
            }
            long blockIndex = ord >>> this.entry.termsDictBlockShift;
            long blockAddress = this.blockAddresses.get(blockIndex);
            this.bytes.seek(blockAddress);
            this.ord = (blockIndex << this.entry.termsDictBlockShift) - 1L;
            do {
                this.next();
            } while (this.ord < ord);
        }

        private BytesRef getTermFromIndex(long index) throws IOException {
            assert (index >= 0L && index <= this.entry.termsDictSize - 1L >>> this.entry.termsDictIndexShift);
            long start = this.indexAddresses.get(index);
            this.term.length = (int)(this.indexAddresses.get(index + 1L) - start);
            this.indexBytes.seek(start);
            this.indexBytes.readBytes(this.term.bytes, 0, this.term.length);
            return this.term;
        }

        private long seekTermsIndex(BytesRef text) throws IOException {
            long lo = 0L;
            long hi = this.entry.termsDictSize - 1L >>> this.entry.termsDictIndexShift;
            while (lo <= hi) {
                long mid = lo + hi >>> 1;
                this.getTermFromIndex(mid);
                int cmp = this.term.compareTo(text);
                if (cmp <= 0) {
                    lo = mid + 1L;
                    continue;
                }
                hi = mid - 1L;
            }
            assert (hi < 0L || this.getTermFromIndex(hi).compareTo(text) <= 0);
            assert (hi == this.entry.termsDictSize - 1L >>> this.entry.termsDictIndexShift || this.getTermFromIndex(hi + 1L).compareTo(text) > 0);
            return hi;
        }

        private BytesRef getFirstTermFromBlock(long block) throws IOException {
            assert (block >= 0L && block <= this.entry.termsDictSize - 1L >>> this.entry.termsDictBlockShift);
            long blockAddress = this.blockAddresses.get(block);
            this.bytes.seek(blockAddress);
            this.term.length = this.bytes.readVInt();
            this.bytes.readBytes(this.term.bytes, 0, this.term.length);
            return this.term;
        }

        private long seekBlock(BytesRef text) throws IOException {
            long index = this.seekTermsIndex(text);
            if (index == -1L) {
                return -1L;
            }
            long ordLo = index << this.entry.termsDictIndexShift;
            long ordHi = Math.min(this.entry.termsDictSize, ordLo + (1L << this.entry.termsDictIndexShift)) - 1L;
            long blockLo = ordLo >>> this.entry.termsDictBlockShift;
            long blockHi = ordHi >>> this.entry.termsDictBlockShift;
            while (blockLo <= blockHi) {
                long blockMid = blockLo + blockHi >>> 1;
                this.getFirstTermFromBlock(blockMid);
                int cmp = this.term.compareTo(text);
                if (cmp <= 0) {
                    blockLo = blockMid + 1L;
                    continue;
                }
                blockHi = blockMid - 1L;
            }
            assert (blockHi < 0L || this.getFirstTermFromBlock(blockHi).compareTo(text) <= 0);
            assert (blockHi == this.entry.termsDictSize - 1L >>> this.entry.termsDictBlockShift || this.getFirstTermFromBlock(blockHi + 1L).compareTo(text) > 0);
            return blockHi;
        }

        public TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
            long block = this.seekBlock(text);
            if (block == -1L) {
                this.seekExact(0L);
                return TermsEnum.SeekStatus.NOT_FOUND;
            }
            long blockAddress = this.blockAddresses.get(block);
            this.ord = block << this.entry.termsDictBlockShift;
            this.bytes.seek(blockAddress);
            this.term.length = this.bytes.readVInt();
            this.bytes.readBytes(this.term.bytes, 0, this.term.length);
            do {
                int cmp;
                if ((cmp = this.term.compareTo(text)) == 0) {
                    return TermsEnum.SeekStatus.FOUND;
                }
                if (cmp <= 0) continue;
                return TermsEnum.SeekStatus.NOT_FOUND;
            } while (this.next() != null);
            return TermsEnum.SeekStatus.END;
        }

        public BytesRef term() throws IOException {
            return this.term;
        }

        public long ord() throws IOException {
            return this.ord;
        }

        public long totalTermFreq() throws IOException {
            return -1L;
        }

        public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
            throw new UnsupportedOperationException();
        }

        public ImpactsEnum impacts(int flags) throws IOException {
            throw new UnsupportedOperationException();
        }

        public int docFreq() throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    private static abstract class BaseSortedSetDocValues
    extends SortedSetDocValues {
        final SortedSetEntry entry;
        final IndexInput data;
        final TermsEnum termsEnum;

        BaseSortedSetDocValues(SortedSetEntry entry, IndexInput data) throws IOException {
            this.entry = entry;
            this.data = data;
            this.termsEnum = this.termsEnum();
        }

        public long getValueCount() {
            return this.entry.termsDictSize;
        }

        public BytesRef lookupOrd(long ord) throws IOException {
            this.termsEnum.seekExact(ord);
            return this.termsEnum.term();
        }

        public long lookupTerm(BytesRef key) throws IOException {
            TermsEnum.SeekStatus status = this.termsEnum.seekCeil(key);
            switch (status) {
                case FOUND: {
                    return this.termsEnum.ord();
                }
            }
            return -1L - this.termsEnum.ord();
        }

        public TermsEnum termsEnum() throws IOException {
            return new TermsDict(this.entry, this.data);
        }
    }

    private static abstract class BaseSortedDocValues
    extends SortedDocValues {
        final SortedEntry entry;
        final IndexInput data;
        final TermsEnum termsEnum;

        BaseSortedDocValues(SortedEntry entry, IndexInput data) throws IOException {
            this.entry = entry;
            this.data = data;
            this.termsEnum = this.termsEnum();
        }

        public int getValueCount() {
            return Math.toIntExact(this.entry.termsDictSize);
        }

        public BytesRef lookupOrd(int ord) throws IOException {
            this.termsEnum.seekExact((long)ord);
            return this.termsEnum.term();
        }

        public int lookupTerm(BytesRef key) throws IOException {
            TermsEnum.SeekStatus status = this.termsEnum.seekCeil(key);
            switch (status) {
                case FOUND: {
                    return Math.toIntExact(this.termsEnum.ord());
                }
            }
            return Math.toIntExact(-1L - this.termsEnum.ord());
        }

        public TermsEnum termsEnum() throws IOException {
            return new TermsDict(this.entry, this.data);
        }
    }

    private static abstract class SparseBinaryDocValues
    extends BinaryDocValues {
        final IndexedDISI disi;

        SparseBinaryDocValues(IndexedDISI disi) {
            this.disi = disi;
        }

        public int nextDoc() throws IOException {
            return this.disi.nextDoc();
        }

        public int docID() {
            return this.disi.docID();
        }

        public long cost() {
            return this.disi.cost();
        }

        public int advance(int target) throws IOException {
            return this.disi.advance(target);
        }

        public boolean advanceExact(int target) throws IOException {
            return this.disi.advanceExact(target);
        }
    }

    private static abstract class DenseBinaryDocValues
    extends BinaryDocValues {
        final int maxDoc;
        int doc = -1;

        DenseBinaryDocValues(int maxDoc) {
            this.maxDoc = maxDoc;
        }

        public int nextDoc() throws IOException {
            return this.advance(this.doc + 1);
        }

        public int docID() {
            return this.doc;
        }

        public long cost() {
            return this.maxDoc;
        }

        public int advance(int target) throws IOException {
            if (target >= this.maxDoc) {
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            this.doc = target;
            return this.doc;
        }

        public boolean advanceExact(int target) throws IOException {
            this.doc = target;
            return true;
        }
    }

    private static abstract class SparseNumericDocValues
    extends NumericDocValues {
        final IndexedDISI disi;

        SparseNumericDocValues(IndexedDISI disi) {
            this.disi = disi;
        }

        public int advance(int target) throws IOException {
            return this.disi.advance(target);
        }

        public boolean advanceExact(int target) throws IOException {
            return this.disi.advanceExact(target);
        }

        public int nextDoc() throws IOException {
            return this.disi.nextDoc();
        }

        public int docID() {
            return this.disi.docID();
        }

        public long cost() {
            return this.disi.cost();
        }
    }

    private static abstract class DenseNumericDocValues
    extends NumericDocValues {
        final int maxDoc;
        int doc = -1;

        DenseNumericDocValues(int maxDoc) {
            this.maxDoc = maxDoc;
        }

        public int docID() {
            return this.doc;
        }

        public int nextDoc() throws IOException {
            return this.advance(this.doc + 1);
        }

        public int advance(int target) throws IOException {
            if (target >= this.maxDoc) {
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            this.doc = target;
            return this.doc;
        }

        public boolean advanceExact(int target) {
            this.doc = target;
            return true;
        }

        public long cost() {
            return this.maxDoc;
        }
    }
}

