/* this file was generated by the MCOP idl compiler - DO NOT EDIT */

#include "kmedia2.h"

// Implementation
Arts::poTime::poTime()
{
}

Arts::poTime::poTime(long _a_seconds, long _a_ms, float _a_custom, const std::string& _a_customUnit)
{
	this->seconds = _a_seconds;
	this->ms = _a_ms;
	this->custom = _a_custom;
	this->customUnit = _a_customUnit;
}

Arts::poTime::poTime(Arts::Buffer& stream)
{
	readType(stream);
}

Arts::poTime::poTime(const Arts::poTime& copyType) : Arts::Type(copyType)
{
	Arts::Buffer buffer;
	copyType.writeType(buffer);
	readType(buffer);
}

Arts::poTime& Arts::poTime::operator=(const Arts::poTime& assignType)
{
	Arts::Buffer buffer;
	assignType.writeType(buffer);
	readType(buffer);
	return *this;
}

void Arts::poTime::readType(Arts::Buffer& stream)
{
	seconds = stream.readLong();
	ms = stream.readLong();
	custom = stream.readFloat();
	stream.readString(customUnit);
}

void Arts::poTime::writeType(Arts::Buffer& stream) const
{
	stream.writeLong(seconds);
	stream.writeLong(ms);
	stream.writeFloat(custom);
	stream.writeString(customUnit);
}

std::string Arts::poTime::_typeName() const
{
	return "Arts::poTime";
}

Arts::PlayObject_private_base *Arts::PlayObject_private_base::_create(const std::string& subClass)
{
	Arts::Object_skel *skel = Arts::ObjectManager::the()->create(subClass);
	assert(skel);
	Arts::PlayObject_private_base *castedObject = (Arts::PlayObject_private_base *)skel->_cast(Arts::PlayObject_private_base::_IID);
	assert(castedObject);
	return castedObject;
}

Arts::PlayObject_private_base *Arts::PlayObject_private_base::_fromString(const std::string& objectref)
{
	Arts::ObjectReference r;

	if(Arts::Dispatcher::the()->stringToObjectReference(r,objectref))
		return Arts::PlayObject_private_base::_fromReference(r,true);
	return 0;
}

Arts::PlayObject_private_base *Arts::PlayObject_private_base::_fromDynamicCast(const Arts::Object& object)
{
	if(object.isNull()) return 0;

	Arts::PlayObject_private_base *castedObject = (Arts::PlayObject_private_base *)object._base()->_cast(Arts::PlayObject_private_base::_IID);
	if(castedObject) return castedObject->_copy();

	return _fromString(object._toString());
}

Arts::PlayObject_private_base *Arts::PlayObject_private_base::_fromReference(Arts::ObjectReference r, bool needcopy)
{
	Arts::PlayObject_private_base *result;
	result = (Arts::PlayObject_private_base *)Arts::Dispatcher::the()->connectObjectLocal(r,"Arts::PlayObject_private");
	if(result)
	{
		if(!needcopy)
			result->_cancelCopyRemote();
	}
	else
	{
		Arts::Connection *conn = Arts::Dispatcher::the()->connectObjectRemote(r);
		if(conn)
		{
			result = new Arts::PlayObject_private_stub(conn,r.objectID);
			if(needcopy) result->_copyRemote();
			result->_useRemote();
			if (!result->_isCompatibleWith("Arts::PlayObject_private")) {
				result->_release();
				return 0;
			}
		}
	}
	return result;
}

std::vector<std::string> Arts::PlayObject_private_base::_defaultPortsIn() const {
	std::vector<std::string> ret;
	return ret;
}
std::vector<std::string> Arts::PlayObject_private_base::_defaultPortsOut() const {
	std::vector<std::string> ret;
	return ret;
}

void *Arts::PlayObject_private_base::_cast(unsigned long iid)
{
	if(iid == Arts::PlayObject_private_base::_IID) return (Arts::PlayObject_private_base *)this;
	if(iid == Arts::Object_base::_IID) return (Arts::Object_base *)this;
	return 0;
}

Arts::PlayObject_private_stub::PlayObject_private_stub()
{
	// constructor for subclasses (don't use directly)
}

Arts::PlayObject_private_stub::PlayObject_private_stub(Arts::Connection *connection, long objectID)
	: Arts::Object_stub(connection, objectID)
{
	// constructor to create a stub for an object
}

bool Arts::PlayObject_private_stub::loadMedia(const std::string& filename)
{
	long methodID = _lookupMethodFast("method:0000000a6c6f61644d656469610000000008626f6f6c65616e00000000020000000100000007737472696e67000000000966696c656e616d65000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeString(filename);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return false; // error occurred
	bool returnCode = result->readBool();
	delete result;
	return returnCode;
}

std::string Arts::PlayObject_private_skel::_interfaceName()
{
	return "Arts::PlayObject_private";
}

bool Arts::PlayObject_private_skel::_isCompatibleWith(const std::string& interfacename)
{
	if (interfacename == "Arts::PlayObject_private") return true;
	if (interfacename == "Arts::Object") return true;
	return false;
}

std::string Arts::PlayObject_private_skel::_interfaceNameSkel()
{
	return "Arts::PlayObject_private";
}

// loadMedia
static void _dispatch_Arts_PlayObject_private_00(void *object, Arts::Buffer *request, Arts::Buffer *result)
{
	std::string filename;
	request->readString(filename);
	result->writeBool(((Arts::PlayObject_private_skel *)object)->loadMedia(filename));
}

void Arts::PlayObject_private_skel::_buildMethodTable()
{
	Arts::Buffer m;
	m.fromString(
        "MethodTable:0000000a6c6f61644d656469610000000008626f6f6c65616e0000"
        "0000020000000100000007737472696e67000000000966696c656e616d65000000"
        "000000000000",
		"MethodTable"
	);
	_addMethod(_dispatch_Arts_PlayObject_private_00,this,Arts::MethodDef(m));
}

Arts::PlayObject_private_skel::PlayObject_private_skel()
{
}

Arts::Object_base* Arts::PlayObject_private::_Creator() {
	return Arts::PlayObject_private_base::_create();
}

unsigned long Arts::PlayObject_private_base::_IID = Arts::MCOPUtils::makeIID("Arts::PlayObject_private");

Arts::PlayObject_base *Arts::PlayObject_base::_create(const std::string& subClass)
{
	Arts::Object_skel *skel = Arts::ObjectManager::the()->create(subClass);
	assert(skel);
	Arts::PlayObject_base *castedObject = (Arts::PlayObject_base *)skel->_cast(Arts::PlayObject_base::_IID);
	assert(castedObject);
	return castedObject;
}

Arts::PlayObject_base *Arts::PlayObject_base::_fromString(const std::string& objectref)
{
	Arts::ObjectReference r;

	if(Arts::Dispatcher::the()->stringToObjectReference(r,objectref))
		return Arts::PlayObject_base::_fromReference(r,true);
	return 0;
}

Arts::PlayObject_base *Arts::PlayObject_base::_fromDynamicCast(const Arts::Object& object)
{
	if(object.isNull()) return 0;

	Arts::PlayObject_base *castedObject = (Arts::PlayObject_base *)object._base()->_cast(Arts::PlayObject_base::_IID);
	if(castedObject) return castedObject->_copy();

	return _fromString(object._toString());
}

Arts::PlayObject_base *Arts::PlayObject_base::_fromReference(Arts::ObjectReference r, bool needcopy)
{
	Arts::PlayObject_base *result;
	result = (Arts::PlayObject_base *)Arts::Dispatcher::the()->connectObjectLocal(r,"Arts::PlayObject");
	if(result)
	{
		if(!needcopy)
			result->_cancelCopyRemote();
	}
	else
	{
		Arts::Connection *conn = Arts::Dispatcher::the()->connectObjectRemote(r);
		if(conn)
		{
			result = new Arts::PlayObject_stub(conn,r.objectID);
			if(needcopy) result->_copyRemote();
			result->_useRemote();
			if (!result->_isCompatibleWith("Arts::PlayObject")) {
				result->_release();
				return 0;
			}
		}
	}
	return result;
}

std::vector<std::string> Arts::PlayObject_base::_defaultPortsIn() const {
	std::vector<std::string> ret;
	return ret;
}
std::vector<std::string> Arts::PlayObject_base::_defaultPortsOut() const {
	std::vector<std::string> ret;
	return ret;
}

void *Arts::PlayObject_base::_cast(unsigned long iid)
{
	if(iid == Arts::PlayObject_base::_IID) return (Arts::PlayObject_base *)this;
	if(iid == Arts::PlayObject_private_base::_IID) return (Arts::PlayObject_private_base *)this;
	if(iid == Arts::Object_base::_IID) return (Arts::Object_base *)this;
	return 0;
}

Arts::PlayObject_stub::PlayObject_stub()
{
	// constructor for subclasses (don't use directly)
}

Arts::PlayObject_stub::PlayObject_stub(Arts::Connection *connection, long objectID)
	: Arts::Object_stub(connection, objectID)
{
	// constructor to create a stub for an object
}

void Arts::PlayObject_stub::play()
{
	long methodID = _lookupMethodFast("method:00000005706c61790000000005766f696400000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

void Arts::PlayObject_stub::seek(const Arts::poTime& newTime)
{
	long methodID = _lookupMethodFast("method:000000057365656b0000000005766f69640000000002000000010000000d417274733a3a706f54696d6500000000086e657754696d65000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	newTime.writeType(*request);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

void Arts::PlayObject_stub::pause()
{
	long methodID = _lookupMethodFast("method:0000000670617573650000000005766f696400000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

void Arts::PlayObject_stub::halt()
{
	long methodID = _lookupMethodFast("method:0000000568616c740000000005766f696400000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

std::string Arts::PlayObject_stub::description()
{
	long methodID = _lookupMethodFast("method:000000115f6765745f6465736372697074696f6e0000000007737472696e6700000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return""; // error occurred
	std::string returnCode;
	result->readString(returnCode);
	delete result;
	return returnCode;
}

Arts::poTime Arts::PlayObject_stub::currentTime()
{
	long methodID = _lookupMethodFast("method:000000115f6765745f63757272656e7454696d65000000000d417274733a3a706f54696d6500000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return Arts::poTime(); // error occurred
	Arts::poTime _returnCode(*result);
	delete result;
	return _returnCode;
}

Arts::poTime Arts::PlayObject_stub::overallTime()
{
	long methodID = _lookupMethodFast("method:000000115f6765745f6f766572616c6c54696d65000000000d417274733a3a706f54696d6500000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return Arts::poTime(); // error occurred
	Arts::poTime _returnCode(*result);
	delete result;
	return _returnCode;
}

Arts::poCapabilities Arts::PlayObject_stub::capabilities()
{
	long methodID = _lookupMethodFast("method:000000125f6765745f6361706162696c69746965730000000015417274733a3a706f4361706162696c697469657300000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return (Arts::poCapabilities)0; // error occurred
	Arts::poCapabilities returnCode = (Arts::poCapabilities)result->readLong();
	delete result;
	return returnCode;
}

std::string Arts::PlayObject_stub::mediaName()
{
	long methodID = _lookupMethodFast("method:0000000f5f6765745f6d656469614e616d650000000007737472696e6700000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return""; // error occurred
	std::string returnCode;
	result->readString(returnCode);
	delete result;
	return returnCode;
}

Arts::poState Arts::PlayObject_stub::state()
{
	long methodID = _lookupMethodFast("method:0000000b5f6765745f7374617465000000000e417274733a3a706f537461746500000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return (Arts::poState)0; // error occurred
	Arts::poState returnCode = (Arts::poState)result->readLong();
	delete result;
	return returnCode;
}

std::string Arts::PlayObject_skel::_interfaceName()
{
	return "Arts::PlayObject";
}

bool Arts::PlayObject_skel::_isCompatibleWith(const std::string& interfacename)
{
	if (interfacename == "Arts::PlayObject") return true;
	if (interfacename == "Arts::PlayObject_private") return true;
	if (interfacename == "Arts::Object") return true;
	return false;
}

std::string Arts::PlayObject_skel::_interfaceNameSkel()
{
	return "Arts::PlayObject";
}

// play
static void _dispatch_Arts_PlayObject_00(void *object, Arts::Buffer *, Arts::Buffer *)
{
	((Arts::PlayObject_skel *)object)->play();
}

// seek
static void _dispatch_Arts_PlayObject_01(void *object, Arts::Buffer *request, Arts::Buffer *)
{
	Arts::poTime newTime(*request);
	((Arts::PlayObject_skel *)object)->seek(newTime);
}

// pause
static void _dispatch_Arts_PlayObject_02(void *object, Arts::Buffer *, Arts::Buffer *)
{
	((Arts::PlayObject_skel *)object)->pause();
}

// halt
static void _dispatch_Arts_PlayObject_03(void *object, Arts::Buffer *, Arts::Buffer *)
{
	((Arts::PlayObject_skel *)object)->halt();
}

// _get_description
static void _dispatch_Arts_PlayObject_04(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeString(((Arts::PlayObject_skel *)object)->description());
}

// _get_currentTime
static void _dispatch_Arts_PlayObject_05(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	Arts::poTime _returnCode = ((Arts::PlayObject_skel *)object)->currentTime();
	_returnCode.writeType(*result);
}

// _get_overallTime
static void _dispatch_Arts_PlayObject_06(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	Arts::poTime _returnCode = ((Arts::PlayObject_skel *)object)->overallTime();
	_returnCode.writeType(*result);
}

// _get_capabilities
static void _dispatch_Arts_PlayObject_07(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeLong(((Arts::PlayObject_skel *)object)->capabilities());
}

// _get_mediaName
static void _dispatch_Arts_PlayObject_08(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeString(((Arts::PlayObject_skel *)object)->mediaName());
}

// _get_state
static void _dispatch_Arts_PlayObject_09(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeLong(((Arts::PlayObject_skel *)object)->state());
}

void Arts::PlayObject_skel::_buildMethodTable()
{
	Arts::Buffer m;
	m.fromString(
        "MethodTable:00000005706c61790000000005766f696400000000020000000000"
        "000000000000057365656b0000000005766f69640000000002000000010000000d"
        "417274733a3a706f54696d6500000000086e657754696d65000000000000000000"
        "0000000670617573650000000005766f6964000000000200000000000000000000"
        "000568616c740000000005766f696400000000020000000000000000000000115f"
        "6765745f6465736372697074696f6e0000000007737472696e6700000000020000"
        "000000000000000000115f6765745f63757272656e7454696d65000000000d4172"
        "74733a3a706f54696d6500000000020000000000000000000000115f6765745f6f"
        "766572616c6c54696d65000000000d417274733a3a706f54696d65000000000200"
        "00000000000000000000125f6765745f6361706162696c69746965730000000015"
        "417274733a3a706f4361706162696c697469657300000000020000000000000000"
        "0000000f5f6765745f6d656469614e616d650000000007737472696e6700000000"
        "0200000000000000000000000b5f6765745f7374617465000000000e417274733a"
        "3a706f537461746500000000020000000000000000",
		"MethodTable"
	);
	_addMethod(_dispatch_Arts_PlayObject_00,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_PlayObject_01,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_PlayObject_02,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_PlayObject_03,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_PlayObject_04,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_PlayObject_05,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_PlayObject_06,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_PlayObject_07,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_PlayObject_08,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_PlayObject_09,this,Arts::MethodDef(m));
	Arts::PlayObject_private_skel::_buildMethodTable();
}

Arts::PlayObject_skel::PlayObject_skel()
{
}

Arts::Object_base* Arts::PlayObject::_Creator() {
	return Arts::PlayObject_base::_create();
}

unsigned long Arts::PlayObject_base::_IID = Arts::MCOPUtils::makeIID("Arts::PlayObject");

Arts::PlayObjectFactory_base *Arts::PlayObjectFactory_base::_create(const std::string& subClass)
{
	Arts::Object_skel *skel = Arts::ObjectManager::the()->create(subClass);
	assert(skel);
	Arts::PlayObjectFactory_base *castedObject = (Arts::PlayObjectFactory_base *)skel->_cast(Arts::PlayObjectFactory_base::_IID);
	assert(castedObject);
	return castedObject;
}

Arts::PlayObjectFactory_base *Arts::PlayObjectFactory_base::_fromString(const std::string& objectref)
{
	Arts::ObjectReference r;

	if(Arts::Dispatcher::the()->stringToObjectReference(r,objectref))
		return Arts::PlayObjectFactory_base::_fromReference(r,true);
	return 0;
}

Arts::PlayObjectFactory_base *Arts::PlayObjectFactory_base::_fromDynamicCast(const Arts::Object& object)
{
	if(object.isNull()) return 0;

	Arts::PlayObjectFactory_base *castedObject = (Arts::PlayObjectFactory_base *)object._base()->_cast(Arts::PlayObjectFactory_base::_IID);
	if(castedObject) return castedObject->_copy();

	return _fromString(object._toString());
}

Arts::PlayObjectFactory_base *Arts::PlayObjectFactory_base::_fromReference(Arts::ObjectReference r, bool needcopy)
{
	Arts::PlayObjectFactory_base *result;
	result = (Arts::PlayObjectFactory_base *)Arts::Dispatcher::the()->connectObjectLocal(r,"Arts::PlayObjectFactory");
	if(result)
	{
		if(!needcopy)
			result->_cancelCopyRemote();
	}
	else
	{
		Arts::Connection *conn = Arts::Dispatcher::the()->connectObjectRemote(r);
		if(conn)
		{
			result = new Arts::PlayObjectFactory_stub(conn,r.objectID);
			if(needcopy) result->_copyRemote();
			result->_useRemote();
			if (!result->_isCompatibleWith("Arts::PlayObjectFactory")) {
				result->_release();
				return 0;
			}
		}
	}
	return result;
}

std::vector<std::string> Arts::PlayObjectFactory_base::_defaultPortsIn() const {
	std::vector<std::string> ret;
	return ret;
}
std::vector<std::string> Arts::PlayObjectFactory_base::_defaultPortsOut() const {
	std::vector<std::string> ret;
	return ret;
}

void *Arts::PlayObjectFactory_base::_cast(unsigned long iid)
{
	if(iid == Arts::PlayObjectFactory_base::_IID) return (Arts::PlayObjectFactory_base *)this;
	if(iid == Arts::Object_base::_IID) return (Arts::Object_base *)this;
	return 0;
}

Arts::PlayObjectFactory_stub::PlayObjectFactory_stub()
{
	// constructor for subclasses (don't use directly)
}

Arts::PlayObjectFactory_stub::PlayObjectFactory_stub(Arts::Connection *connection, long objectID)
	: Arts::Object_stub(connection, objectID)
{
	// constructor to create a stub for an object
}

Arts::PlayObject Arts::PlayObjectFactory_stub::createPlayObject(const std::string& filename)
{
	long methodID = _lookupMethodFast("method:00000011637265617465506c61794f626a6563740000000011417274733a3a506c61794f626a65637400000000020000000100000007737472696e67000000000966696c656e616d65000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeString(filename);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if (!result) return Arts::PlayObject::null();
	Arts::PlayObject_base* returnCode;
	Arts::readObject(*result,returnCode);
	delete result;
	return Arts::PlayObject::_from_base(returnCode);
}

std::string Arts::PlayObjectFactory_skel::_interfaceName()
{
	return "Arts::PlayObjectFactory";
}

bool Arts::PlayObjectFactory_skel::_isCompatibleWith(const std::string& interfacename)
{
	if (interfacename == "Arts::PlayObjectFactory") return true;
	if (interfacename == "Arts::Object") return true;
	return false;
}

std::string Arts::PlayObjectFactory_skel::_interfaceNameSkel()
{
	return "Arts::PlayObjectFactory";
}

// createPlayObject
static void _dispatch_Arts_PlayObjectFactory_00(void *object, Arts::Buffer *request, Arts::Buffer *result)
{
	std::string filename;
	request->readString(filename);
	Arts::PlayObject returnCode = ((Arts::PlayObjectFactory_skel *)object)->createPlayObject(filename);
	Arts::writeObject(*result,returnCode._base());
}

void Arts::PlayObjectFactory_skel::_buildMethodTable()
{
	Arts::Buffer m;
	m.fromString(
        "MethodTable:00000011637265617465506c61794f626a65637400000000114172"
        "74733a3a506c61794f626a65637400000000020000000100000007737472696e67"
        "000000000966696c656e616d65000000000000000000",
		"MethodTable"
	);
	_addMethod(_dispatch_Arts_PlayObjectFactory_00,this,Arts::MethodDef(m));
}

Arts::PlayObjectFactory_skel::PlayObjectFactory_skel()
{
}

Arts::Object_base* Arts::PlayObjectFactory::_Creator() {
	return Arts::PlayObjectFactory_base::_create();
}

unsigned long Arts::PlayObjectFactory_base::_IID = Arts::MCOPUtils::makeIID("Arts::PlayObjectFactory");

Arts::InputStream_base *Arts::InputStream_base::_create(const std::string& subClass)
{
	Arts::Object_skel *skel = Arts::ObjectManager::the()->create(subClass);
	assert(skel);
	Arts::InputStream_base *castedObject = (Arts::InputStream_base *)skel->_cast(Arts::InputStream_base::_IID);
	assert(castedObject);
	return castedObject;
}

Arts::InputStream_base *Arts::InputStream_base::_fromString(const std::string& objectref)
{
	Arts::ObjectReference r;

	if(Arts::Dispatcher::the()->stringToObjectReference(r,objectref))
		return Arts::InputStream_base::_fromReference(r,true);
	return 0;
}

Arts::InputStream_base *Arts::InputStream_base::_fromDynamicCast(const Arts::Object& object)
{
	if(object.isNull()) return 0;

	Arts::InputStream_base *castedObject = (Arts::InputStream_base *)object._base()->_cast(Arts::InputStream_base::_IID);
	if(castedObject) return castedObject->_copy();

	return _fromString(object._toString());
}

Arts::InputStream_base *Arts::InputStream_base::_fromReference(Arts::ObjectReference r, bool needcopy)
{
	Arts::InputStream_base *result;
	result = (Arts::InputStream_base *)Arts::Dispatcher::the()->connectObjectLocal(r,"Arts::InputStream");
	if(result)
	{
		if(!needcopy)
			result->_cancelCopyRemote();
	}
	else
	{
		Arts::Connection *conn = Arts::Dispatcher::the()->connectObjectRemote(r);
		if(conn)
		{
			result = new Arts::InputStream_stub(conn,r.objectID);
			if(needcopy) result->_copyRemote();
			result->_useRemote();
			if (!result->_isCompatibleWith("Arts::InputStream")) {
				result->_release();
				return 0;
			}
		}
	}
	return result;
}

std::vector<std::string> Arts::InputStream_base::_defaultPortsIn() const {
	std::vector<std::string> ret;
	return ret;
}
std::vector<std::string> Arts::InputStream_base::_defaultPortsOut() const {
	std::vector<std::string> ret;
	ret.push_back("outdata");
	return ret;
}

void *Arts::InputStream_base::_cast(unsigned long iid)
{
	if(iid == Arts::InputStream_base::_IID) return (Arts::InputStream_base *)this;
	if(iid == Arts::SynthModule_base::_IID) return (Arts::SynthModule_base *)this;
	if(iid == Arts::Object_base::_IID) return (Arts::Object_base *)this;
	return 0;
}

Arts::InputStream_stub::InputStream_stub()
{
	// constructor for subclasses (don't use directly)
}

Arts::InputStream_stub::InputStream_stub(Arts::Connection *connection, long objectID)
	: Arts::Object_stub(connection, objectID)
{
	// constructor to create a stub for an object
}

long Arts::InputStream_stub::seek(long position)
{
	long methodID = _lookupMethodFast("method:000000057365656b00000000056c6f6e67000000000200000001000000056c6f6e670000000009706f736974696f6e000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeLong(position);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return 0; // error occurred
	long returnCode = result->readLong();
	delete result;
	return returnCode;
}

bool Arts::InputStream_stub::eof()
{
	long methodID = _lookupMethodFast("method:000000095f6765745f656f660000000008626f6f6c65616e00000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return false; // error occurred
	bool returnCode = result->readBool();
	delete result;
	return returnCode;
}

long Arts::InputStream_stub::size()
{
	long methodID = _lookupMethodFast("method:0000000a5f6765745f73697a6500000000056c6f6e6700000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return 0; // error occurred
	long returnCode = result->readLong();
	delete result;
	return returnCode;
}

bool Arts::InputStream_stub::seekOk()
{
	long methodID = _lookupMethodFast("method:0000000c5f6765745f7365656b4f6b0000000008626f6f6c65616e00000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return false; // error occurred
	bool returnCode = result->readBool();
	delete result;
	return returnCode;
}

std::string Arts::InputStream_skel::_interfaceName()
{
	return "Arts::InputStream";
}

bool Arts::InputStream_skel::_isCompatibleWith(const std::string& interfacename)
{
	if (interfacename == "Arts::InputStream") return true;
	if (interfacename == "Arts::SynthModule") return true;
	if (interfacename == "Arts::Object") return true;
	return false;
}

std::string Arts::InputStream_skel::_interfaceNameSkel()
{
	return "Arts::InputStream";
}

// seek
static void _dispatch_Arts_InputStream_00(void *object, Arts::Buffer *request, Arts::Buffer *result)
{
	long position = request->readLong();
	result->writeLong(((Arts::InputStream_skel *)object)->seek(position));
}

// _get_eof
static void _dispatch_Arts_InputStream_01(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeBool(((Arts::InputStream_skel *)object)->eof());
}

// _get_size
static void _dispatch_Arts_InputStream_02(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeLong(((Arts::InputStream_skel *)object)->size());
}

// _get_seekOk
static void _dispatch_Arts_InputStream_03(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeBool(((Arts::InputStream_skel *)object)->seekOk());
}

void Arts::InputStream_skel::_buildMethodTable()
{
	Arts::Buffer m;
	m.fromString(
        "MethodTable:000000057365656b00000000056c6f6e6700000000020000000100"
        "0000056c6f6e670000000009706f736974696f6e00000000000000000000000009"
        "5f6765745f656f660000000008626f6f6c65616e00000000020000000000000000"
        "0000000a5f6765745f73697a6500000000056c6f6e670000000002000000000000"
        "00000000000c5f6765745f7365656b4f6b0000000008626f6f6c65616e00000000"
        "020000000000000000",
		"MethodTable"
	);
	_addMethod(_dispatch_Arts_InputStream_00,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_InputStream_01,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_InputStream_02,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_InputStream_03,this,Arts::MethodDef(m));
	Arts::SynthModule_skel::_buildMethodTable();
}

Arts::InputStream_skel::InputStream_skel()
{
	_initStream("outdata",&outdata,42);
}

void Arts::InputStream_skel::notify(const Arts::Notification &notification)
{
	if(outdata.notifyID() == notification.ID)
		request_outdata((Arts::DataPacket<Arts::mcopbyte> *)notification.data);
}

void Arts::InputStream_skel::request_outdata(Arts::DataPacket<Arts::mcopbyte> *)
{
	assert(false); // this default is for modules who don't want requesting
}

Arts::Object_base* Arts::InputStream::_Creator() {
	return Arts::InputStream_base::_create();
}

unsigned long Arts::InputStream_base::_IID = Arts::MCOPUtils::makeIID("Arts::InputStream");

Arts::FileInputStream_base *Arts::FileInputStream_base::_create(const std::string& subClass)
{
	Arts::Object_skel *skel = Arts::ObjectManager::the()->create(subClass);
	assert(skel);
	Arts::FileInputStream_base *castedObject = (Arts::FileInputStream_base *)skel->_cast(Arts::FileInputStream_base::_IID);
	assert(castedObject);
	return castedObject;
}

Arts::FileInputStream_base *Arts::FileInputStream_base::_fromString(const std::string& objectref)
{
	Arts::ObjectReference r;

	if(Arts::Dispatcher::the()->stringToObjectReference(r,objectref))
		return Arts::FileInputStream_base::_fromReference(r,true);
	return 0;
}

Arts::FileInputStream_base *Arts::FileInputStream_base::_fromDynamicCast(const Arts::Object& object)
{
	if(object.isNull()) return 0;

	Arts::FileInputStream_base *castedObject = (Arts::FileInputStream_base *)object._base()->_cast(Arts::FileInputStream_base::_IID);
	if(castedObject) return castedObject->_copy();

	return _fromString(object._toString());
}

Arts::FileInputStream_base *Arts::FileInputStream_base::_fromReference(Arts::ObjectReference r, bool needcopy)
{
	Arts::FileInputStream_base *result;
	result = (Arts::FileInputStream_base *)Arts::Dispatcher::the()->connectObjectLocal(r,"Arts::FileInputStream");
	if(result)
	{
		if(!needcopy)
			result->_cancelCopyRemote();
	}
	else
	{
		Arts::Connection *conn = Arts::Dispatcher::the()->connectObjectRemote(r);
		if(conn)
		{
			result = new Arts::FileInputStream_stub(conn,r.objectID);
			if(needcopy) result->_copyRemote();
			result->_useRemote();
			if (!result->_isCompatibleWith("Arts::FileInputStream")) {
				result->_release();
				return 0;
			}
		}
	}
	return result;
}

std::vector<std::string> Arts::FileInputStream_base::_defaultPortsIn() const {
	std::vector<std::string> ret;
	return ret;
}
std::vector<std::string> Arts::FileInputStream_base::_defaultPortsOut() const {
	std::vector<std::string> ret;
	ret.push_back("outdata");
	return ret;
}

void *Arts::FileInputStream_base::_cast(unsigned long iid)
{
	if(iid == Arts::FileInputStream_base::_IID) return (Arts::FileInputStream_base *)this;
	if(iid == Arts::InputStream_base::_IID) return (Arts::InputStream_base *)this;
	if(iid == Arts::SynthModule_base::_IID) return (Arts::SynthModule_base *)this;
	if(iid == Arts::Object_base::_IID) return (Arts::Object_base *)this;
	return 0;
}

Arts::FileInputStream_stub::FileInputStream_stub()
{
	// constructor for subclasses (don't use directly)
}

Arts::FileInputStream_stub::FileInputStream_stub(Arts::Connection *connection, long objectID)
	: Arts::Object_stub(connection, objectID)
{
	// constructor to create a stub for an object
}

bool Arts::FileInputStream_stub::open(const std::string& filename)
{
	long methodID = _lookupMethodFast("method:000000056f70656e0000000008626f6f6c65616e00000000020000000100000007737472696e67000000000966696c656e616d65000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeString(filename);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return false; // error occurred
	bool returnCode = result->readBool();
	delete result;
	return returnCode;
}

std::string Arts::FileInputStream_stub::filename()
{
	long methodID = _lookupMethodFast("method:0000000e5f6765745f66696c656e616d650000000007737472696e6700000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return""; // error occurred
	std::string returnCode;
	result->readString(returnCode);
	delete result;
	return returnCode;
}

void Arts::FileInputStream_stub::filename(const std::string& newValue)
{
	long methodID = _lookupMethodFast("method:0000000e5f7365745f66696c656e616d650000000005766f696400000000020000000100000007737472696e6700000000096e657756616c7565000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeString(newValue);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

std::string Arts::FileInputStream_skel::_interfaceName()
{
	return "Arts::FileInputStream";
}

bool Arts::FileInputStream_skel::_isCompatibleWith(const std::string& interfacename)
{
	if (interfacename == "Arts::FileInputStream") return true;
	if (interfacename == "Arts::InputStream") return true;
	if (interfacename == "Arts::SynthModule") return true;
	if (interfacename == "Arts::Object") return true;
	return false;
}

std::string Arts::FileInputStream_skel::_interfaceNameSkel()
{
	return "Arts::FileInputStream";
}

// open
static void _dispatch_Arts_FileInputStream_00(void *object, Arts::Buffer *request, Arts::Buffer *result)
{
	std::string filename;
	request->readString(filename);
	result->writeBool(((Arts::FileInputStream_skel *)object)->open(filename));
}

// _get_filename
static void _dispatch_Arts_FileInputStream_01(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeString(((Arts::FileInputStream_skel *)object)->filename());
}

// _set_filename
static void _dispatch_Arts_FileInputStream_02(void *object, Arts::Buffer *request, Arts::Buffer *)
{
	std::string newValue;
	request->readString(newValue);
	((Arts::FileInputStream_skel *)object)->filename(newValue);
}

void Arts::FileInputStream_skel::_buildMethodTable()
{
	Arts::Buffer m;
	m.fromString(
        "MethodTable:000000056f70656e0000000008626f6f6c65616e00000000020000"
        "000100000007737472696e67000000000966696c656e616d650000000000000000"
        "000000000e5f6765745f66696c656e616d650000000007737472696e6700000000"
        "0200000000000000000000000e5f7365745f66696c656e616d650000000005766f"
        "696400000000020000000100000007737472696e6700000000096e657756616c75"
        "65000000000000000000",
		"MethodTable"
	);
	_addMethod(_dispatch_Arts_FileInputStream_00,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_FileInputStream_01,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_FileInputStream_02,this,Arts::MethodDef(m));
	Arts::InputStream_skel::_buildMethodTable();
}

Arts::FileInputStream_skel::FileInputStream_skel()
{
}

Arts::Object_base* Arts::FileInputStream::_Creator() {
	return Arts::FileInputStream_base::_create();
}

unsigned long Arts::FileInputStream_base::_IID = Arts::MCOPUtils::makeIID("Arts::FileInputStream");

Arts::StdoutWriter_base *Arts::StdoutWriter_base::_create(const std::string& subClass)
{
	Arts::Object_skel *skel = Arts::ObjectManager::the()->create(subClass);
	assert(skel);
	Arts::StdoutWriter_base *castedObject = (Arts::StdoutWriter_base *)skel->_cast(Arts::StdoutWriter_base::_IID);
	assert(castedObject);
	return castedObject;
}

Arts::StdoutWriter_base *Arts::StdoutWriter_base::_fromString(const std::string& objectref)
{
	Arts::ObjectReference r;

	if(Arts::Dispatcher::the()->stringToObjectReference(r,objectref))
		return Arts::StdoutWriter_base::_fromReference(r,true);
	return 0;
}

Arts::StdoutWriter_base *Arts::StdoutWriter_base::_fromDynamicCast(const Arts::Object& object)
{
	if(object.isNull()) return 0;

	Arts::StdoutWriter_base *castedObject = (Arts::StdoutWriter_base *)object._base()->_cast(Arts::StdoutWriter_base::_IID);
	if(castedObject) return castedObject->_copy();

	return _fromString(object._toString());
}

Arts::StdoutWriter_base *Arts::StdoutWriter_base::_fromReference(Arts::ObjectReference r, bool needcopy)
{
	Arts::StdoutWriter_base *result;
	result = (Arts::StdoutWriter_base *)Arts::Dispatcher::the()->connectObjectLocal(r,"Arts::StdoutWriter");
	if(result)
	{
		if(!needcopy)
			result->_cancelCopyRemote();
	}
	else
	{
		Arts::Connection *conn = Arts::Dispatcher::the()->connectObjectRemote(r);
		if(conn)
		{
			result = new Arts::StdoutWriter_stub(conn,r.objectID);
			if(needcopy) result->_copyRemote();
			result->_useRemote();
			if (!result->_isCompatibleWith("Arts::StdoutWriter")) {
				result->_release();
				return 0;
			}
		}
	}
	return result;
}

std::vector<std::string> Arts::StdoutWriter_base::_defaultPortsIn() const {
	std::vector<std::string> ret;
	ret.push_back("indata");
	return ret;
}
std::vector<std::string> Arts::StdoutWriter_base::_defaultPortsOut() const {
	std::vector<std::string> ret;
	return ret;
}

void *Arts::StdoutWriter_base::_cast(unsigned long iid)
{
	if(iid == Arts::StdoutWriter_base::_IID) return (Arts::StdoutWriter_base *)this;
	if(iid == Arts::SynthModule_base::_IID) return (Arts::SynthModule_base *)this;
	if(iid == Arts::Object_base::_IID) return (Arts::Object_base *)this;
	return 0;
}

Arts::StdoutWriter_stub::StdoutWriter_stub()
{
	// constructor for subclasses (don't use directly)
}

Arts::StdoutWriter_stub::StdoutWriter_stub(Arts::Connection *connection, long objectID)
	: Arts::Object_stub(connection, objectID)
{
	// constructor to create a stub for an object
}

std::string Arts::StdoutWriter_skel::_interfaceName()
{
	return "Arts::StdoutWriter";
}

bool Arts::StdoutWriter_skel::_isCompatibleWith(const std::string& interfacename)
{
	if (interfacename == "Arts::StdoutWriter") return true;
	if (interfacename == "Arts::SynthModule") return true;
	if (interfacename == "Arts::Object") return true;
	return false;
}

std::string Arts::StdoutWriter_skel::_interfaceNameSkel()
{
	return "Arts::StdoutWriter";
}

void Arts::StdoutWriter_skel::_buildMethodTable()
{
	Arts::Buffer m;
	m.fromString(
        "MethodTable:",
		"MethodTable"
	);
	Arts::SynthModule_skel::_buildMethodTable();
}

Arts::StdoutWriter_skel::StdoutWriter_skel()
{
	_initStream("indata",&indata,41);
}

void Arts::StdoutWriter_skel::notify(const Arts::Notification &notification)
{
	if(indata.notifyID() == notification.ID)
		process_indata((Arts::DataPacket<Arts::mcopbyte> *)notification.data);
}

Arts::Object_base* Arts::StdoutWriter::_Creator() {
	return Arts::StdoutWriter_base::_create();
}

unsigned long Arts::StdoutWriter_base::_IID = Arts::MCOPUtils::makeIID("Arts::StdoutWriter");

Arts::StreamPlayObject_base *Arts::StreamPlayObject_base::_create(const std::string& subClass)
{
	Arts::Object_skel *skel = Arts::ObjectManager::the()->create(subClass);
	assert(skel);
	Arts::StreamPlayObject_base *castedObject = (Arts::StreamPlayObject_base *)skel->_cast(Arts::StreamPlayObject_base::_IID);
	assert(castedObject);
	return castedObject;
}

Arts::StreamPlayObject_base *Arts::StreamPlayObject_base::_fromString(const std::string& objectref)
{
	Arts::ObjectReference r;

	if(Arts::Dispatcher::the()->stringToObjectReference(r,objectref))
		return Arts::StreamPlayObject_base::_fromReference(r,true);
	return 0;
}

Arts::StreamPlayObject_base *Arts::StreamPlayObject_base::_fromDynamicCast(const Arts::Object& object)
{
	if(object.isNull()) return 0;

	Arts::StreamPlayObject_base *castedObject = (Arts::StreamPlayObject_base *)object._base()->_cast(Arts::StreamPlayObject_base::_IID);
	if(castedObject) return castedObject->_copy();

	return _fromString(object._toString());
}

Arts::StreamPlayObject_base *Arts::StreamPlayObject_base::_fromReference(Arts::ObjectReference r, bool needcopy)
{
	Arts::StreamPlayObject_base *result;
	result = (Arts::StreamPlayObject_base *)Arts::Dispatcher::the()->connectObjectLocal(r,"Arts::StreamPlayObject");
	if(result)
	{
		if(!needcopy)
			result->_cancelCopyRemote();
	}
	else
	{
		Arts::Connection *conn = Arts::Dispatcher::the()->connectObjectRemote(r);
		if(conn)
		{
			result = new Arts::StreamPlayObject_stub(conn,r.objectID);
			if(needcopy) result->_copyRemote();
			result->_useRemote();
			if (!result->_isCompatibleWith("Arts::StreamPlayObject")) {
				result->_release();
				return 0;
			}
		}
	}
	return result;
}

std::vector<std::string> Arts::StreamPlayObject_base::_defaultPortsIn() const {
	std::vector<std::string> ret;
	return ret;
}
std::vector<std::string> Arts::StreamPlayObject_base::_defaultPortsOut() const {
	std::vector<std::string> ret;
	return ret;
}

void *Arts::StreamPlayObject_base::_cast(unsigned long iid)
{
	if(iid == Arts::StreamPlayObject_base::_IID) return (Arts::StreamPlayObject_base *)this;
	if(iid == Arts::PlayObject_base::_IID) return (Arts::PlayObject_base *)this;
	if(iid == Arts::PlayObject_private_base::_IID) return (Arts::PlayObject_private_base *)this;
	if(iid == Arts::Object_base::_IID) return (Arts::Object_base *)this;
	return 0;
}

Arts::StreamPlayObject_stub::StreamPlayObject_stub()
{
	// constructor for subclasses (don't use directly)
}

Arts::StreamPlayObject_stub::StreamPlayObject_stub(Arts::Connection *connection, long objectID)
	: Arts::Object_stub(connection, objectID)
{
	// constructor to create a stub for an object
}

bool Arts::StreamPlayObject_stub::streamMedia(Arts::InputStream instream)
{
	long methodID = _lookupMethodFast("method:0000000c73747265616d4d656469610000000008626f6f6c65616e00000000020000000100000012417274733a3a496e70757453747265616d0000000009696e73747265616d000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	Arts::writeObject(*request,instream._base());
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return false; // error occurred
	bool returnCode = result->readBool();
	delete result;
	return returnCode;
}

Arts::InputStream Arts::StreamPlayObject_stub::inputStream()
{
	long methodID = _lookupMethodFast("method:0000000c696e70757453747265616d0000000012417274733a3a496e70757453747265616d00000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if (!result) return Arts::InputStream::null();
	Arts::InputStream_base* returnCode;
	Arts::readObject(*result,returnCode);
	delete result;
	return Arts::InputStream::_from_base(returnCode);
}

std::string Arts::StreamPlayObject_skel::_interfaceName()
{
	return "Arts::StreamPlayObject";
}

bool Arts::StreamPlayObject_skel::_isCompatibleWith(const std::string& interfacename)
{
	if (interfacename == "Arts::StreamPlayObject") return true;
	if (interfacename == "Arts::PlayObject") return true;
	if (interfacename == "Arts::PlayObject_private") return true;
	if (interfacename == "Arts::Object") return true;
	return false;
}

std::string Arts::StreamPlayObject_skel::_interfaceNameSkel()
{
	return "Arts::StreamPlayObject";
}

// streamMedia
static void _dispatch_Arts_StreamPlayObject_00(void *object, Arts::Buffer *request, Arts::Buffer *result)
{
	Arts::InputStream_base* _temp_instream;
	Arts::readObject(*request,_temp_instream);
	Arts::InputStream instream = Arts::InputStream::_from_base(_temp_instream);
	result->writeBool(((Arts::StreamPlayObject_skel *)object)->streamMedia(instream));
}

// inputStream
static void _dispatch_Arts_StreamPlayObject_01(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	Arts::InputStream returnCode = ((Arts::StreamPlayObject_skel *)object)->inputStream();
	Arts::writeObject(*result,returnCode._base());
}

void Arts::StreamPlayObject_skel::_buildMethodTable()
{
	Arts::Buffer m;
	m.fromString(
        "MethodTable:0000000c73747265616d4d656469610000000008626f6f6c65616e"
        "00000000020000000100000012417274733a3a496e70757453747265616d000000"
        "0009696e73747265616d0000000000000000000000000c696e7075745374726561"
        "6d0000000012417274733a3a496e70757453747265616d00000000020000000000"
        "000000",
		"MethodTable"
	);
	_addMethod(_dispatch_Arts_StreamPlayObject_00,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_StreamPlayObject_01,this,Arts::MethodDef(m));
	Arts::PlayObject_skel::_buildMethodTable();
}

Arts::StreamPlayObject_skel::StreamPlayObject_skel()
{
}

Arts::Object_base* Arts::StreamPlayObject::_Creator() {
	return Arts::StreamPlayObject_base::_create();
}

unsigned long Arts::StreamPlayObject_base::_IID = Arts::MCOPUtils::makeIID("Arts::StreamPlayObject");

Arts::PitchablePlayObject_base *Arts::PitchablePlayObject_base::_create(const std::string& subClass)
{
	Arts::Object_skel *skel = Arts::ObjectManager::the()->create(subClass);
	assert(skel);
	Arts::PitchablePlayObject_base *castedObject = (Arts::PitchablePlayObject_base *)skel->_cast(Arts::PitchablePlayObject_base::_IID);
	assert(castedObject);
	return castedObject;
}

Arts::PitchablePlayObject_base *Arts::PitchablePlayObject_base::_fromString(const std::string& objectref)
{
	Arts::ObjectReference r;

	if(Arts::Dispatcher::the()->stringToObjectReference(r,objectref))
		return Arts::PitchablePlayObject_base::_fromReference(r,true);
	return 0;
}

Arts::PitchablePlayObject_base *Arts::PitchablePlayObject_base::_fromDynamicCast(const Arts::Object& object)
{
	if(object.isNull()) return 0;

	Arts::PitchablePlayObject_base *castedObject = (Arts::PitchablePlayObject_base *)object._base()->_cast(Arts::PitchablePlayObject_base::_IID);
	if(castedObject) return castedObject->_copy();

	return _fromString(object._toString());
}

Arts::PitchablePlayObject_base *Arts::PitchablePlayObject_base::_fromReference(Arts::ObjectReference r, bool needcopy)
{
	Arts::PitchablePlayObject_base *result;
	result = (Arts::PitchablePlayObject_base *)Arts::Dispatcher::the()->connectObjectLocal(r,"Arts::PitchablePlayObject");
	if(result)
	{
		if(!needcopy)
			result->_cancelCopyRemote();
	}
	else
	{
		Arts::Connection *conn = Arts::Dispatcher::the()->connectObjectRemote(r);
		if(conn)
		{
			result = new Arts::PitchablePlayObject_stub(conn,r.objectID);
			if(needcopy) result->_copyRemote();
			result->_useRemote();
			if (!result->_isCompatibleWith("Arts::PitchablePlayObject")) {
				result->_release();
				return 0;
			}
		}
	}
	return result;
}

std::vector<std::string> Arts::PitchablePlayObject_base::_defaultPortsIn() const {
	std::vector<std::string> ret;
	return ret;
}
std::vector<std::string> Arts::PitchablePlayObject_base::_defaultPortsOut() const {
	std::vector<std::string> ret;
	return ret;
}

void *Arts::PitchablePlayObject_base::_cast(unsigned long iid)
{
	if(iid == Arts::PitchablePlayObject_base::_IID) return (Arts::PitchablePlayObject_base *)this;
	if(iid == Arts::Object_base::_IID) return (Arts::Object_base *)this;
	return 0;
}

Arts::PitchablePlayObject_stub::PitchablePlayObject_stub()
{
	// constructor for subclasses (don't use directly)
}

Arts::PitchablePlayObject_stub::PitchablePlayObject_stub(Arts::Connection *connection, long objectID)
	: Arts::Object_stub(connection, objectID)
{
	// constructor to create a stub for an object
}

float Arts::PitchablePlayObject_stub::speed()
{
	long methodID = _lookupMethodFast("method:0000000b5f6765745f73706565640000000006666c6f617400000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return 0.0; // error occurred
	float returnCode = result->readFloat();
	delete result;
	return returnCode;
}

void Arts::PitchablePlayObject_stub::speed(float newValue)
{
	long methodID = _lookupMethodFast("method:0000000b5f7365745f73706565640000000005766f696400000000020000000100000006666c6f617400000000096e657756616c7565000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeFloat(newValue);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

std::string Arts::PitchablePlayObject_skel::_interfaceName()
{
	return "Arts::PitchablePlayObject";
}

bool Arts::PitchablePlayObject_skel::_isCompatibleWith(const std::string& interfacename)
{
	if (interfacename == "Arts::PitchablePlayObject") return true;
	if (interfacename == "Arts::Object") return true;
	return false;
}

std::string Arts::PitchablePlayObject_skel::_interfaceNameSkel()
{
	return "Arts::PitchablePlayObject";
}

// _get_speed
static void _dispatch_Arts_PitchablePlayObject_00(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeFloat(((Arts::PitchablePlayObject_skel *)object)->speed());
}

// _set_speed
static void _dispatch_Arts_PitchablePlayObject_01(void *object, Arts::Buffer *request, Arts::Buffer *)
{
	float newValue = request->readFloat();
	((Arts::PitchablePlayObject_skel *)object)->speed(newValue);
}

void Arts::PitchablePlayObject_skel::_buildMethodTable()
{
	Arts::Buffer m;
	m.fromString(
        "MethodTable:0000000b5f6765745f73706565640000000006666c6f6174000000"
        "000200000000000000000000000b5f7365745f73706565640000000005766f6964"
        "00000000020000000100000006666c6f617400000000096e657756616c75650000"
        "00000000000000",
		"MethodTable"
	);
	_addMethod(_dispatch_Arts_PitchablePlayObject_00,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_PitchablePlayObject_01,this,Arts::MethodDef(m));
}

Arts::PitchablePlayObject_skel::PitchablePlayObject_skel()
{
}

Arts::Object_base* Arts::PitchablePlayObject::_Creator() {
	return Arts::PitchablePlayObject_base::_create();
}

unsigned long Arts::PitchablePlayObject_base::_IID = Arts::MCOPUtils::makeIID("Arts::PitchablePlayObject");

Arts::VideoPlayObject_base *Arts::VideoPlayObject_base::_create(const std::string& subClass)
{
	Arts::Object_skel *skel = Arts::ObjectManager::the()->create(subClass);
	assert(skel);
	Arts::VideoPlayObject_base *castedObject = (Arts::VideoPlayObject_base *)skel->_cast(Arts::VideoPlayObject_base::_IID);
	assert(castedObject);
	return castedObject;
}

Arts::VideoPlayObject_base *Arts::VideoPlayObject_base::_fromString(const std::string& objectref)
{
	Arts::ObjectReference r;

	if(Arts::Dispatcher::the()->stringToObjectReference(r,objectref))
		return Arts::VideoPlayObject_base::_fromReference(r,true);
	return 0;
}

Arts::VideoPlayObject_base *Arts::VideoPlayObject_base::_fromDynamicCast(const Arts::Object& object)
{
	if(object.isNull()) return 0;

	Arts::VideoPlayObject_base *castedObject = (Arts::VideoPlayObject_base *)object._base()->_cast(Arts::VideoPlayObject_base::_IID);
	if(castedObject) return castedObject->_copy();

	return _fromString(object._toString());
}

Arts::VideoPlayObject_base *Arts::VideoPlayObject_base::_fromReference(Arts::ObjectReference r, bool needcopy)
{
	Arts::VideoPlayObject_base *result;
	result = (Arts::VideoPlayObject_base *)Arts::Dispatcher::the()->connectObjectLocal(r,"Arts::VideoPlayObject");
	if(result)
	{
		if(!needcopy)
			result->_cancelCopyRemote();
	}
	else
	{
		Arts::Connection *conn = Arts::Dispatcher::the()->connectObjectRemote(r);
		if(conn)
		{
			result = new Arts::VideoPlayObject_stub(conn,r.objectID);
			if(needcopy) result->_copyRemote();
			result->_useRemote();
			if (!result->_isCompatibleWith("Arts::VideoPlayObject")) {
				result->_release();
				return 0;
			}
		}
	}
	return result;
}

std::vector<std::string> Arts::VideoPlayObject_base::_defaultPortsIn() const {
	std::vector<std::string> ret;
	return ret;
}
std::vector<std::string> Arts::VideoPlayObject_base::_defaultPortsOut() const {
	std::vector<std::string> ret;
	return ret;
}

void *Arts::VideoPlayObject_base::_cast(unsigned long iid)
{
	if(iid == Arts::VideoPlayObject_base::_IID) return (Arts::VideoPlayObject_base *)this;
	if(iid == Arts::Object_base::_IID) return (Arts::Object_base *)this;
	return 0;
}

Arts::VideoPlayObject_stub::VideoPlayObject_stub()
{
	// constructor for subclasses (don't use directly)
}

Arts::VideoPlayObject_stub::VideoPlayObject_stub(Arts::Connection *connection, long objectID)
	: Arts::Object_stub(connection, objectID)
{
	// constructor to create a stub for an object
}

long Arts::VideoPlayObject_stub::x11Snapshot()
{
	long methodID = _lookupMethodFast("method:0000000c783131536e617073686f7400000000056c6f6e6700000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return 0; // error occurred
	long returnCode = result->readLong();
	delete result;
	return returnCode;
}

long Arts::VideoPlayObject_stub::x11WindowId()
{
	long methodID = _lookupMethodFast("method:000000115f6765745f78313157696e646f77496400000000056c6f6e6700000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return 0; // error occurred
	long returnCode = result->readLong();
	delete result;
	return returnCode;
}

void Arts::VideoPlayObject_stub::x11WindowId(long newValue)
{
	long methodID = _lookupMethodFast("method:000000115f7365745f78313157696e646f7749640000000005766f6964000000000200000001000000056c6f6e6700000000096e657756616c7565000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeLong(newValue);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

std::string Arts::VideoPlayObject_skel::_interfaceName()
{
	return "Arts::VideoPlayObject";
}

bool Arts::VideoPlayObject_skel::_isCompatibleWith(const std::string& interfacename)
{
	if (interfacename == "Arts::VideoPlayObject") return true;
	if (interfacename == "Arts::Object") return true;
	return false;
}

std::string Arts::VideoPlayObject_skel::_interfaceNameSkel()
{
	return "Arts::VideoPlayObject";
}

// x11Snapshot
static void _dispatch_Arts_VideoPlayObject_00(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeLong(((Arts::VideoPlayObject_skel *)object)->x11Snapshot());
}

// _get_x11WindowId
static void _dispatch_Arts_VideoPlayObject_01(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeLong(((Arts::VideoPlayObject_skel *)object)->x11WindowId());
}

// _set_x11WindowId
static void _dispatch_Arts_VideoPlayObject_02(void *object, Arts::Buffer *request, Arts::Buffer *)
{
	long newValue = request->readLong();
	((Arts::VideoPlayObject_skel *)object)->x11WindowId(newValue);
}

void Arts::VideoPlayObject_skel::_buildMethodTable()
{
	Arts::Buffer m;
	m.fromString(
        "MethodTable:0000000c783131536e617073686f7400000000056c6f6e67000000"
        "00020000000000000000000000115f6765745f78313157696e646f774964000000"
        "00056c6f6e6700000000020000000000000000000000115f7365745f7831315769"
        "6e646f7749640000000005766f6964000000000200000001000000056c6f6e6700"
        "000000096e657756616c7565000000000000000000",
		"MethodTable"
	);
	_addMethod(_dispatch_Arts_VideoPlayObject_00,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_VideoPlayObject_01,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_VideoPlayObject_02,this,Arts::MethodDef(m));
}

Arts::VideoPlayObject_skel::VideoPlayObject_skel()
{
}

Arts::Object_base* Arts::VideoPlayObject::_Creator() {
	return Arts::VideoPlayObject_base::_create();
}

unsigned long Arts::VideoPlayObject_base::_IID = Arts::MCOPUtils::makeIID("Arts::VideoPlayObject");

Arts::PlayObjectFactoryV2_base *Arts::PlayObjectFactoryV2_base::_create(const std::string& subClass)
{
	Arts::Object_skel *skel = Arts::ObjectManager::the()->create(subClass);
	assert(skel);
	Arts::PlayObjectFactoryV2_base *castedObject = (Arts::PlayObjectFactoryV2_base *)skel->_cast(Arts::PlayObjectFactoryV2_base::_IID);
	assert(castedObject);
	return castedObject;
}

Arts::PlayObjectFactoryV2_base *Arts::PlayObjectFactoryV2_base::_fromString(const std::string& objectref)
{
	Arts::ObjectReference r;

	if(Arts::Dispatcher::the()->stringToObjectReference(r,objectref))
		return Arts::PlayObjectFactoryV2_base::_fromReference(r,true);
	return 0;
}

Arts::PlayObjectFactoryV2_base *Arts::PlayObjectFactoryV2_base::_fromDynamicCast(const Arts::Object& object)
{
	if(object.isNull()) return 0;

	Arts::PlayObjectFactoryV2_base *castedObject = (Arts::PlayObjectFactoryV2_base *)object._base()->_cast(Arts::PlayObjectFactoryV2_base::_IID);
	if(castedObject) return castedObject->_copy();

	return _fromString(object._toString());
}

Arts::PlayObjectFactoryV2_base *Arts::PlayObjectFactoryV2_base::_fromReference(Arts::ObjectReference r, bool needcopy)
{
	Arts::PlayObjectFactoryV2_base *result;
	result = (Arts::PlayObjectFactoryV2_base *)Arts::Dispatcher::the()->connectObjectLocal(r,"Arts::PlayObjectFactoryV2");
	if(result)
	{
		if(!needcopy)
			result->_cancelCopyRemote();
	}
	else
	{
		Arts::Connection *conn = Arts::Dispatcher::the()->connectObjectRemote(r);
		if(conn)
		{
			result = new Arts::PlayObjectFactoryV2_stub(conn,r.objectID);
			if(needcopy) result->_copyRemote();
			result->_useRemote();
			if (!result->_isCompatibleWith("Arts::PlayObjectFactoryV2")) {
				result->_release();
				return 0;
			}
		}
	}
	return result;
}

std::vector<std::string> Arts::PlayObjectFactoryV2_base::_defaultPortsIn() const {
	std::vector<std::string> ret;
	return ret;
}
std::vector<std::string> Arts::PlayObjectFactoryV2_base::_defaultPortsOut() const {
	std::vector<std::string> ret;
	return ret;
}

void *Arts::PlayObjectFactoryV2_base::_cast(unsigned long iid)
{
	if(iid == Arts::PlayObjectFactoryV2_base::_IID) return (Arts::PlayObjectFactoryV2_base *)this;
	if(iid == Arts::PlayObjectFactory_base::_IID) return (Arts::PlayObjectFactory_base *)this;
	if(iid == Arts::Object_base::_IID) return (Arts::Object_base *)this;
	return 0;
}

Arts::PlayObjectFactoryV2_stub::PlayObjectFactoryV2_stub()
{
	// constructor for subclasses (don't use directly)
}

Arts::PlayObjectFactoryV2_stub::PlayObjectFactoryV2_stub(Arts::Connection *connection, long objectID)
	: Arts::Object_stub(connection, objectID)
{
	// constructor to create a stub for an object
}

Arts::PlayObject Arts::PlayObjectFactoryV2_stub::createPlayObjectForURL(const std::string& url, const std::string& mimetype, bool createBUS)
{
	long methodID = _lookupMethodFast("method:00000017637265617465506c61794f626a656374466f7255524c0000000011417274733a3a506c61794f626a65637400000000020000000300000007737472696e67000000000475726c000000000000000007737472696e6700000000096d696d6574797065000000000000000008626f6f6c65616e000000000a637265617465425553000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeString(url);
	request->writeString(mimetype);
	request->writeBool(createBUS);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if (!result) return Arts::PlayObject::null();
	Arts::PlayObject_base* returnCode;
	Arts::readObject(*result,returnCode);
	delete result;
	return Arts::PlayObject::_from_base(returnCode);
}

Arts::PlayObject Arts::PlayObjectFactoryV2_stub::createPlayObjectForStream(Arts::InputStream instream, const std::string& mimetype, bool createBUS)
{
	long methodID = _lookupMethodFast("method:0000001a637265617465506c61794f626a656374466f7253747265616d0000000011417274733a3a506c61794f626a65637400000000020000000300000012417274733a3a496e70757453747265616d0000000009696e73747265616d000000000000000007737472696e6700000000096d696d6574797065000000000000000008626f6f6c65616e000000000a637265617465425553000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	Arts::writeObject(*request,instream._base());
	request->writeString(mimetype);
	request->writeBool(createBUS);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if (!result) return Arts::PlayObject::null();
	Arts::PlayObject_base* returnCode;
	Arts::readObject(*result,returnCode);
	delete result;
	return Arts::PlayObject::_from_base(returnCode);
}

std::string Arts::PlayObjectFactoryV2_skel::_interfaceName()
{
	return "Arts::PlayObjectFactoryV2";
}

bool Arts::PlayObjectFactoryV2_skel::_isCompatibleWith(const std::string& interfacename)
{
	if (interfacename == "Arts::PlayObjectFactoryV2") return true;
	if (interfacename == "Arts::PlayObjectFactory") return true;
	if (interfacename == "Arts::Object") return true;
	return false;
}

std::string Arts::PlayObjectFactoryV2_skel::_interfaceNameSkel()
{
	return "Arts::PlayObjectFactoryV2";
}

// createPlayObjectForURL
static void _dispatch_Arts_PlayObjectFactoryV2_00(void *object, Arts::Buffer *request, Arts::Buffer *result)
{
	std::string url;
	request->readString(url);
	std::string mimetype;
	request->readString(mimetype);
	bool createBUS = request->readBool();
	Arts::PlayObject returnCode = ((Arts::PlayObjectFactoryV2_skel *)object)->createPlayObjectForURL(url,mimetype,createBUS);
	Arts::writeObject(*result,returnCode._base());
}

// createPlayObjectForStream
static void _dispatch_Arts_PlayObjectFactoryV2_01(void *object, Arts::Buffer *request, Arts::Buffer *result)
{
	Arts::InputStream_base* _temp_instream;
	Arts::readObject(*request,_temp_instream);
	Arts::InputStream instream = Arts::InputStream::_from_base(_temp_instream);
	std::string mimetype;
	request->readString(mimetype);
	bool createBUS = request->readBool();
	Arts::PlayObject returnCode = ((Arts::PlayObjectFactoryV2_skel *)object)->createPlayObjectForStream(instream,mimetype,createBUS);
	Arts::writeObject(*result,returnCode._base());
}

void Arts::PlayObjectFactoryV2_skel::_buildMethodTable()
{
	Arts::Buffer m;
	m.fromString(
        "MethodTable:00000017637265617465506c61794f626a656374466f7255524c00"
        "00000011417274733a3a506c61794f626a65637400000000020000000300000007"
        "737472696e67000000000475726c000000000000000007737472696e6700000000"
        "096d696d6574797065000000000000000008626f6f6c65616e000000000a637265"
        "6174654255530000000000000000000000001a637265617465506c61794f626a65"
        "6374466f7253747265616d0000000011417274733a3a506c61794f626a65637400"
        "000000020000000300000012417274733a3a496e70757453747265616d00000000"
        "09696e73747265616d000000000000000007737472696e6700000000096d696d65"
        "74797065000000000000000008626f6f6c65616e000000000a6372656174654255"
        "53000000000000000000",
		"MethodTable"
	);
	_addMethod(_dispatch_Arts_PlayObjectFactoryV2_00,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_PlayObjectFactoryV2_01,this,Arts::MethodDef(m));
	Arts::PlayObjectFactory_skel::_buildMethodTable();
}

Arts::PlayObjectFactoryV2_skel::PlayObjectFactoryV2_skel()
{
}

Arts::Object_base* Arts::PlayObjectFactoryV2::_Creator() {
	return Arts::PlayObjectFactoryV2_base::_create();
}

unsigned long Arts::PlayObjectFactoryV2_base::_IID = Arts::MCOPUtils::makeIID("Arts::PlayObjectFactoryV2");

static Arts::IDLFileReg IDLFileReg_kmedia2("kmedia2",
    "IDLFile:0000000100000000020000000e417274733a3a706f53746174650000000003"
    "00000008706f7349646c650000000000000000000000000b706f73506c6179696e6700"
    "00000001000000000000000a706f735061757365640000000002000000000000000000"
    "000015417274733a3a706f4361706162696c6974696573000000000200000008636170"
    "5365656b00000000010000000000000009636170506175736500000000020000000000"
    "000000000000010000000d417274733a3a706f54696d650000000004000000056c6f6e"
    "6700000000087365636f6e64730000000000000000056c6f6e6700000000036d730000"
    "00000000000006666c6f61740000000007637573746f6d000000000000000007737472"
    "696e67000000000b637573746f6d556e69740000000000000000000000000a00000019"
    "417274733a3a506c61794f626a6563745f707269766174650000000000000000010000"
    "000a6c6f61644d656469610000000008626f6f6c65616e000000000200000001000000"
    "07737472696e67000000000966696c656e616d65000000000000000000000000000000"
    "00000000000000000011417274733a3a506c61794f626a656374000000000100000019"
    "417274733a3a506c61794f626a6563745f70726976617465000000000400000005706c"
    "61790000000005766f696400000000020000000000000000000000057365656b000000"
    "0005766f69640000000002000000010000000d417274733a3a706f54696d6500000000"
    "086e657754696d650000000000000000000000000670617573650000000005766f6964"
    "000000000200000000000000000000000568616c740000000005766f69640000000002"
    "0000000000000000000000060000000c6465736372697074696f6e0000000007737472"
    "696e670000000012000000000000000c63757272656e7454696d65000000000d417274"
    "733a3a706f54696d650000000012000000000000000c6f766572616c6c54696d650000"
    "00000d417274733a3a706f54696d650000000012000000000000000d6361706162696c"
    "69746965730000000015417274733a3a706f4361706162696c69746965730000000012"
    "000000000000000a6d656469614e616d650000000007737472696e6700000000120000"
    "0000000000067374617465000000000e417274733a3a706f5374617465000000001200"
    "000000000000000000000000000018417274733a3a506c61794f626a65637446616374"
    "6f727900000000000000000100000011637265617465506c61794f626a656374000000"
    "0011417274733a3a506c61794f626a6563740000000002000000010000000773747269"
    "6e67000000000966696c656e616d650000000000000000000000000000000000000000"
    "0000000012417274733a3a496e70757453747265616d00000000010000001241727473"
    "3a3a53796e74684d6f64756c650000000001000000057365656b00000000056c6f6e67"
    "000000000200000001000000056c6f6e670000000009706f736974696f6e0000000000"
    "000000000000000400000004656f660000000008626f6f6c65616e0000000012000000"
    "000000000573697a6500000000056c6f6e67000000001200000000000000077365656b"
    "4f6b0000000008626f6f6c65616e000000001200000000000000086f75746461746100"
    "0000000562797465000000002a00000000000000000000000000000016417274733a3a"
    "46696c65496e70757453747265616d000000000100000012417274733a3a496e707574"
    "53747265616d0000000001000000056f70656e0000000008626f6f6c65616e00000000"
    "020000000100000007737472696e67000000000966696c656e616d6500000000000000"
    "0000000000010000000966696c656e616d650000000007737472696e67000000001300"
    "000000000000000000000000000013417274733a3a5374646f75745772697465720000"
    "00000100000012417274733a3a53796e74684d6f64756c650000000000000000010000"
    "0007696e64617461000000000562797465000000002900000000000000000000000000"
    "000017417274733a3a53747265616d506c61794f626a65637400000000010000001141"
    "7274733a3a506c61794f626a65637400000000020000000c73747265616d4d65646961"
    "0000000008626f6f6c65616e00000000020000000100000012417274733a3a496e7075"
    "7453747265616d0000000009696e73747265616d0000000000000000000000000c696e"
    "70757453747265616d0000000012417274733a3a496e70757453747265616d00000000"
    "0200000000000000000000000000000000000000000000001a417274733a3a50697463"
    "6861626c65506c61794f626a6563740000000000000000000000000100000006737065"
    "65640000000006666c6f61740000000013000000000000000000000000000000164172"
    "74733a3a566964656f506c61794f626a6563740000000000000000010000000c783131"
    "536e617073686f7400000000056c6f6e67000000000200000000000000000000000100"
    "00000c78313157696e646f77496400000000056c6f6e67000000001300000000000000"
    "00000000000000001a417274733a3a506c61794f626a656374466163746f7279563200"
    "0000000100000018417274733a3a506c61794f626a656374466163746f727900000000"
    "0200000017637265617465506c61794f626a656374466f7255524c0000000011417274"
    "733a3a506c61794f626a65637400000000020000000300000007737472696e67000000"
    "000475726c000000000000000007737472696e6700000000096d696d65747970650000"
    "00000000000008626f6f6c65616e000000000a63726561746542555300000000000000"
    "00000000001a637265617465506c61794f626a656374466f7253747265616d00000000"
    "11417274733a3a506c61794f626a65637400000000020000000300000012417274733a"
    "3a496e70757453747265616d0000000009696e73747265616d00000000000000000773"
    "7472696e6700000000096d696d6574797065000000000000000008626f6f6c65616e00"
    "0000000a63726561746542555300000000000000000000000000000000000000000000"
    "000000"
);
