; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+e -verify-machineinstrs -filetype=obj < %s \
; RUN:   -o /dev/null 2>&1
; RUN: llc -mtriple=riscv32 -mattr=+e -relocation-model=pic -verify-machineinstrs \
; RUN:   -filetype=obj < %s -o /dev/null 2>&1
; RUN: llc -mtriple=riscv32 -mattr=+e -verify-machineinstrs < %s \
; RUN:   | FileCheck %s
; RUN: llc -mtriple=riscv32 -mattr=+e -relocation-model=pic -verify-machineinstrs < %s \
; RUN:   | FileCheck %s

define void @relax_bcc(i1 %a) nounwind {
; CHECK-LABEL: relax_bcc:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andi a0, a0, 1
; CHECK-NEXT:    bnez a0, .LBB0_1
; CHECK-NEXT:    j .LBB0_2
; CHECK-NEXT:  .LBB0_1: # %iftrue
; CHECK-NEXT:    #APP
; CHECK-NEXT:    .zero 4096
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:  .LBB0_2: # %tail
; CHECK-NEXT:    ret
  br i1 %a, label %iftrue, label %tail

iftrue:
  call void asm sideeffect ".space 4096", ""()
  br label %tail

tail:
  ret void
}

define i32 @relax_jal(i1 %a) nounwind {
; CHECK-LABEL: relax_jal:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -4
; CHECK-NEXT:    andi a0, a0, 1
; CHECK-NEXT:    bnez a0, .LBB1_1
; CHECK-NEXT:  # %bb.4:
; CHECK-NEXT:    jump .LBB1_2, a0
; CHECK-NEXT:  .LBB1_1: # %iftrue
; CHECK-NEXT:    #APP
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    .zero 1048576
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    j .LBB1_3
; CHECK-NEXT:  .LBB1_2: # %jmp
; CHECK-NEXT:    #APP
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:  .LBB1_3: # %tail
; CHECK-NEXT:    li a0, 1
; CHECK-NEXT:    addi sp, sp, 4
; CHECK-NEXT:    ret
  br i1 %a, label %iftrue, label %jmp

jmp:
  call void asm sideeffect "", ""()
  br label %tail

iftrue:
  call void asm sideeffect "", ""()
  br label %space

space:
  call void asm sideeffect ".space 1048576", ""()
  br label %tail

tail:
  ret i32 1
}

define void @relax_jal_spill_32() {
; CHECK-LABEL: relax_jal_spill_32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; CHECK-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; CHECK-NEXT:    .cfi_offset ra, -4
; CHECK-NEXT:    .cfi_offset s0, -8
; CHECK-NEXT:    .cfi_offset s1, -12
; CHECK-NEXT:    #APP
; CHECK-NEXT:    li ra, 1
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    li t0, 5
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    li t1, 6
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    li t2, 7
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    li s0, 8
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    li s1, 9
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    li a0, 10
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    li a1, 11
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    li a2, 12
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    li a3, 13
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    li a4, 14
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    li a5, 15
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    beq a4, a5, .LBB2_1
; CHECK-NEXT:  # %bb.3:
; CHECK-NEXT:    sw s1, 0(sp) # 4-byte Folded Spill
; CHECK-NEXT:    jump .LBB2_4, s1
; CHECK-NEXT:  .LBB2_1: # %branch_1
; CHECK-NEXT:    #APP
; CHECK-NEXT:    .zero 1048576
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    j .LBB2_2
; CHECK-NEXT:  .LBB2_4: # %branch_2
; CHECK-NEXT:    lw s1, 0(sp) # 4-byte Folded Reload
; CHECK-NEXT:  .LBB2_2: # %branch_2
; CHECK-NEXT:    #APP
; CHECK-NEXT:    # reg use ra
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    # reg use t0
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    # reg use t1
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    # reg use t2
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    # reg use s0
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    # reg use s1
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    # reg use a0
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    # reg use a1
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    # reg use a2
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    # reg use a3
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    # reg use a4
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    # reg use a5
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; CHECK-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; CHECK-NEXT:    .cfi_restore ra
; CHECK-NEXT:    .cfi_restore s0
; CHECK-NEXT:    .cfi_restore s1
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    ret
  %ra = call i32 asm sideeffect "addi ra, x0, 1", "={ra}"()
  %t0 = call i32 asm sideeffect "addi t0, x0, 5", "={t0}"()
  %t1 = call i32 asm sideeffect "addi t1, x0, 6", "={t1}"()
  %t2 = call i32 asm sideeffect "addi t2, x0, 7", "={t2}"()
  %s0 = call i32 asm sideeffect "addi s0, x0, 8", "={s0}"()
  %s1 = call i32 asm sideeffect "addi s1, x0, 9", "={s1}"()
  %a0 = call i32 asm sideeffect "addi a0, x0, 10", "={a0}"()
  %a1 = call i32 asm sideeffect "addi a1, x0, 11", "={a1}"()
  %a2 = call i32 asm sideeffect "addi a2, x0, 12", "={a2}"()
  %a3 = call i32 asm sideeffect "addi a3, x0, 13", "={a3}"()
  %a4 = call i32 asm sideeffect "addi a4, x0, 14", "={a4}"()
  %a5 = call i32 asm sideeffect "addi a5, x0, 15", "={a5}"()

  %cmp = icmp eq i32 %a4, %a5
  br i1 %cmp, label %branch_1, label %branch_2

branch_1:
  call void asm sideeffect ".space 1048576", ""()
  br label %branch_2

branch_2:
  call void asm sideeffect "# reg use $0", "{ra}"(i32 %ra)
  call void asm sideeffect "# reg use $0", "{t0}"(i32 %t0)
  call void asm sideeffect "# reg use $0", "{t1}"(i32 %t1)
  call void asm sideeffect "# reg use $0", "{t2}"(i32 %t2)
  call void asm sideeffect "# reg use $0", "{s0}"(i32 %s0)
  call void asm sideeffect "# reg use $0", "{s1}"(i32 %s1)
  call void asm sideeffect "# reg use $0", "{a0}"(i32 %a0)
  call void asm sideeffect "# reg use $0", "{a1}"(i32 %a1)
  call void asm sideeffect "# reg use $0", "{a2}"(i32 %a2)
  call void asm sideeffect "# reg use $0", "{a3}"(i32 %a3)
  call void asm sideeffect "# reg use $0", "{a4}"(i32 %a4)
  call void asm sideeffect "# reg use $0", "{a5}"(i32 %a5)

  ret void
}

define void @relax_jal_spill_32_adjust_spill_slot() {
  ; If the stack is large and the offset of BranchRelaxationScratchFrameIndex
  ; is out the range of 12-bit signed integer, check whether the spill slot is
  ; adjusted to close to the stack base register.
; CHECK-LABEL: relax_jal_spill_32_adjust_spill_slot:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -2044
; CHECK-NEXT:    .cfi_def_cfa_offset 2044
; CHECK-NEXT:    sw ra, 2040(sp) # 4-byte Folded Spill
; CHECK-NEXT:    sw s0, 2036(sp) # 4-byte Folded Spill
; CHECK-NEXT:    sw s1, 2032(sp) # 4-byte Folded Spill
; CHECK-NEXT:    .cfi_offset ra, -4
; CHECK-NEXT:    .cfi_offset s0, -8
; CHECK-NEXT:    .cfi_offset s1, -12
; CHECK-NEXT:    addi s0, sp, 2044
; CHECK-NEXT:    .cfi_def_cfa s0, 0
; CHECK-NEXT:    lui a0, 2
; CHECK-NEXT:    addi a0, a0, -2044
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    srli a0, sp, 12
; CHECK-NEXT:    slli sp, a0, 12
; CHECK-NEXT:    #APP
; CHECK-NEXT:    li ra, 1
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    li t0, 5
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    li t1, 6
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    li t2, 7
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    li s0, 8
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    li s1, 9
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    li a0, 10
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    li a1, 11
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    li a2, 12
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    li a3, 13
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    li a4, 14
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    li a5, 15
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    beq a4, a5, .LBB3_1
; CHECK-NEXT:  # %bb.3:
; CHECK-NEXT:    sw s1, 0(sp) # 4-byte Folded Spill
; CHECK-NEXT:    jump .LBB3_4, s1
; CHECK-NEXT:  .LBB3_1: # %branch_1
; CHECK-NEXT:    #APP
; CHECK-NEXT:    .zero 1048576
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    j .LBB3_2
; CHECK-NEXT:  .LBB3_4: # %branch_2
; CHECK-NEXT:    lw s1, 0(sp) # 4-byte Folded Reload
; CHECK-NEXT:  .LBB3_2: # %branch_2
; CHECK-NEXT:    #APP
; CHECK-NEXT:    # reg use ra
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    # reg use t0
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    # reg use t1
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    # reg use t2
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    # reg use s0
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    # reg use s1
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    # reg use a0
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    # reg use a1
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    # reg use a2
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    # reg use a3
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    # reg use a4
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    # reg use a5
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    addi sp, s0, -2044
; CHECK-NEXT:    .cfi_def_cfa sp, 2044
; CHECK-NEXT:    lw ra, 2040(sp) # 4-byte Folded Reload
; CHECK-NEXT:    lw s0, 2036(sp) # 4-byte Folded Reload
; CHECK-NEXT:    lw s1, 2032(sp) # 4-byte Folded Reload
; CHECK-NEXT:    .cfi_restore ra
; CHECK-NEXT:    .cfi_restore s0
; CHECK-NEXT:    .cfi_restore s1
; CHECK-NEXT:    addi sp, sp, 2044
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    ret
  %stack_obj = alloca i32, align 4096

  %ra = call i32 asm sideeffect "addi ra, x0, 1", "={ra}"()
  %t0 = call i32 asm sideeffect "addi t0, x0, 5", "={t0}"()
  %t1 = call i32 asm sideeffect "addi t1, x0, 6", "={t1}"()
  %t2 = call i32 asm sideeffect "addi t2, x0, 7", "={t2}"()
  %s0 = call i32 asm sideeffect "addi s0, x0, 8", "={s0}"()
  %s1 = call i32 asm sideeffect "addi s1, x0, 9", "={s1}"()
  %a0 = call i32 asm sideeffect "addi a0, x0, 10", "={a0}"()
  %a1 = call i32 asm sideeffect "addi a1, x0, 11", "={a1}"()
  %a2 = call i32 asm sideeffect "addi a2, x0, 12", "={a2}"()
  %a3 = call i32 asm sideeffect "addi a3, x0, 13", "={a3}"()
  %a4 = call i32 asm sideeffect "addi a4, x0, 14", "={a4}"()
  %a5 = call i32 asm sideeffect "addi a5, x0, 15", "={a5}"()

  %cmp = icmp eq i32 %a4, %a5
  br i1 %cmp, label %branch_1, label %branch_2

branch_1:
  call void asm sideeffect ".space 1048576", ""()
  br label %branch_2

branch_2:
  call void asm sideeffect "# reg use $0", "{ra}"(i32 %ra)
  call void asm sideeffect "# reg use $0", "{t0}"(i32 %t0)
  call void asm sideeffect "# reg use $0", "{t1}"(i32 %t1)
  call void asm sideeffect "# reg use $0", "{t2}"(i32 %t2)
  call void asm sideeffect "# reg use $0", "{s0}"(i32 %s0)
  call void asm sideeffect "# reg use $0", "{s1}"(i32 %s1)
  call void asm sideeffect "# reg use $0", "{a0}"(i32 %a0)
  call void asm sideeffect "# reg use $0", "{a1}"(i32 %a1)
  call void asm sideeffect "# reg use $0", "{a2}"(i32 %a2)
  call void asm sideeffect "# reg use $0", "{a3}"(i32 %a3)
  call void asm sideeffect "# reg use $0", "{a4}"(i32 %a4)
  call void asm sideeffect "# reg use $0", "{a5}"(i32 %a5)

  ret void
}

define void @relax_jal_spill_32_restore_block_correspondence() {
; CHECK-LABEL: relax_jal_spill_32_restore_block_correspondence:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; CHECK-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; CHECK-NEXT:    .cfi_offset ra, -4
; CHECK-NEXT:    .cfi_offset s0, -8
; CHECK-NEXT:    .cfi_offset s1, -12
; CHECK-NEXT:    .cfi_remember_state
; CHECK-NEXT:    #APP
; CHECK-NEXT:    li ra, 1
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    li t0, 5
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    li t1, 6
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    li t2, 7
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    li s0, 8
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    li s1, 9
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    li a0, 10
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    li a1, 11
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    li a2, 12
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    li a3, 13
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    li a4, 14
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    li a5, 15
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    bne a4, a5, .LBB4_2
; CHECK-NEXT:    j .LBB4_1
; CHECK-NEXT:  .LBB4_8: # %dest_1
; CHECK-NEXT:    lw s1, 0(sp) # 4-byte Folded Reload
; CHECK-NEXT:  .LBB4_1: # %dest_1
; CHECK-NEXT:    #APP
; CHECK-NEXT:    # dest 1
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    j .LBB4_3
; CHECK-NEXT:  .LBB4_2: # %cond_2
; CHECK-NEXT:    bne a2, a3, .LBB4_5
; CHECK-NEXT:  .LBB4_3: # %dest_2
; CHECK-NEXT:    #APP
; CHECK-NEXT:    # dest 2
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:  .LBB4_4: # %dest_3
; CHECK-NEXT:    #APP
; CHECK-NEXT:    # dest 3
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    # reg use ra
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    # reg use t0
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    # reg use t1
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    # reg use t2
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    # reg use s0
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    # reg use s1
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    # reg use a0
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    # reg use a1
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    # reg use a2
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    # reg use a3
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    # reg use a4
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    # reg use a5
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; CHECK-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; CHECK-NEXT:    .cfi_restore ra
; CHECK-NEXT:    .cfi_restore s0
; CHECK-NEXT:    .cfi_restore s1
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB4_5: # %cond_3
; CHECK-NEXT:    .cfi_restore_state
; CHECK-NEXT:    beq t1, t2, .LBB4_4
; CHECK-NEXT:  # %bb.6: # %space
; CHECK-NEXT:    #APP
; CHECK-NEXT:    .zero 1048576
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:  # %bb.7: # %space
; CHECK-NEXT:    sw s1, 0(sp) # 4-byte Folded Spill
; CHECK-NEXT:    jump .LBB4_8, s1
entry:
  %ra = call i32 asm sideeffect "addi ra, x0, 1", "={ra}"()
  %t0 = call i32 asm sideeffect "addi t0, x0, 5", "={t0}"()
  %t1 = call i32 asm sideeffect "addi t1, x0, 6", "={t1}"()
  %t2 = call i32 asm sideeffect "addi t2, x0, 7", "={t2}"()
  %s0 = call i32 asm sideeffect "addi s0, x0, 8", "={s0}"()
  %s1 = call i32 asm sideeffect "addi s1, x0, 9", "={s1}"()
  %a0 = call i32 asm sideeffect "addi a0, x0, 10", "={a0}"()
  %a1 = call i32 asm sideeffect "addi a1, x0, 11", "={a1}"()
  %a2 = call i32 asm sideeffect "addi a2, x0, 12", "={a2}"()
  %a3 = call i32 asm sideeffect "addi a3, x0, 13", "={a3}"()
  %a4 = call i32 asm sideeffect "addi a4, x0, 14", "={a4}"()
  %a5 = call i32 asm sideeffect "addi a5, x0, 15", "={a5}"()

  br label %cond_1

cond_1:
  %cmp1 = icmp eq i32 %a4, %a5
  br i1 %cmp1, label %dest_1, label %cond_2

cond_2:
  %cmp2 = icmp eq i32 %a2, %a3
  br i1 %cmp2, label %dest_2, label %cond_3

cond_3:
  %cmp3 = icmp eq i32 %t1, %t2
  br i1 %cmp3, label %dest_3, label %space

space:
  call void asm sideeffect ".space 1048576", ""()
  br label %dest_1

dest_1:
  call void asm sideeffect "# dest 1", ""()
  br label %dest_2

dest_2:
  call void asm sideeffect "# dest 2", ""()
  br label %dest_3

dest_3:
  call void asm sideeffect "# dest 3", ""()
  br label %tail

tail:
  call void asm sideeffect "# reg use $0", "{ra}"(i32 %ra)
  call void asm sideeffect "# reg use $0", "{t0}"(i32 %t0)
  call void asm sideeffect "# reg use $0", "{t1}"(i32 %t1)
  call void asm sideeffect "# reg use $0", "{t2}"(i32 %t2)
  call void asm sideeffect "# reg use $0", "{s0}"(i32 %s0)
  call void asm sideeffect "# reg use $0", "{s1}"(i32 %s1)
  call void asm sideeffect "# reg use $0", "{a0}"(i32 %a0)
  call void asm sideeffect "# reg use $0", "{a1}"(i32 %a1)
  call void asm sideeffect "# reg use $0", "{a2}"(i32 %a2)
  call void asm sideeffect "# reg use $0", "{a3}"(i32 %a3)
  call void asm sideeffect "# reg use $0", "{a4}"(i32 %a4)
  call void asm sideeffect "# reg use $0", "{a5}"(i32 %a5)

  ret void
}

