; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -verify-machineinstrs -mtriple=x86_64-unknown-unknown -mattr=+avx512fp16,+avx512vl | FileCheck %s

declare half @llvm.minimum.f16(half, half)
declare half @llvm.maximum.f16(half, half)
declare <8 x half> @llvm.minimum.v8f16(<8 x half>, <8 x half>)
declare <8 x half> @llvm.maximum.v8f16(<8 x half>, <8 x half>)
declare <16 x half> @llvm.minimum.v16f16(<16 x half>, <16 x half>)
declare <16 x half> @llvm.maximum.v16f16(<16 x half>, <16 x half>)
declare <32 x half> @llvm.minimum.v32f16(<32 x half>, <32 x half>)
declare <32 x half> @llvm.maximum.v32f16(<32 x half>, <32 x half>)

define half @test_fminimum(half %x, half %y) {
; CHECK-LABEL: test_fminimum:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmovw %xmm0, %eax
; CHECK-NEXT:    testw %ax, %ax
; CHECK-NEXT:    sets %al
; CHECK-NEXT:    kmovd %eax, %k1
; CHECK-NEXT:    vmovaps %xmm1, %xmm2
; CHECK-NEXT:    vmovsh %xmm0, %xmm0, %xmm2 {%k1}
; CHECK-NEXT:    vmovsh %xmm1, %xmm0, %xmm0 {%k1}
; CHECK-NEXT:    vminsh %xmm2, %xmm0, %xmm1
; CHECK-NEXT:    vcmpunordsh %xmm0, %xmm0, %k1
; CHECK-NEXT:    vmovsh %xmm0, %xmm0, %xmm1 {%k1}
; CHECK-NEXT:    vmovaps %xmm1, %xmm0
; CHECK-NEXT:    retq
  %z = call half @llvm.minimum.f16(half %x, half %y)
  ret half %z
}

define <8 x half> @test_fminimum_v8f16(<8 x half> %x, <8 x half> %y) "no-nans-fp-math"="true" "no-signed-zeros-fp-math"="true" {
; CHECK-LABEL: test_fminimum_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vminph %xmm1, %xmm0, %xmm0
; CHECK-NEXT:    retq
  %r = call <8 x half> @llvm.minimum.v8f16(<8 x half> %x, <8 x half> %y)
  ret <8 x half> %r
}

define half @test_fminimum_nnan(half %x, half %y) "no-nans-fp-math"="true" {
; CHECK-LABEL: test_fminimum_nnan:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfpclasssh $5, %xmm1, %k1 # k1 = isQuietNaN(xmm1) | isNegativeZero(xmm1)
; CHECK-NEXT:    vmovaps %xmm0, %xmm2
; CHECK-NEXT:    vmovsh %xmm1, %xmm0, %xmm2 {%k1}
; CHECK-NEXT:    vmovsh %xmm0, %xmm0, %xmm1 {%k1}
; CHECK-NEXT:    vminsh %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %1 = tail call half @llvm.minimum.f16(half %x, half %y)
  ret half %1
}

define half @test_fminimum_zero(half %x, half %y) {
; CHECK-LABEL: test_fminimum_zero:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcmpunordsh %xmm1, %xmm1, %k1
; CHECK-NEXT:    vminsh {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm0
; CHECK-NEXT:    vmovsh %xmm1, %xmm0, %xmm0 {%k1}
; CHECK-NEXT:    retq
  %1 = tail call half @llvm.minimum.f16(half -0.0, half %y)
  ret half %1
}

define half @test_fminimum_nsz(half %x, half %y) {
; CHECK-LABEL: test_fminimum_nsz:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vminsh %xmm1, %xmm0, %xmm1
; CHECK-NEXT:    vcmpunordsh %xmm0, %xmm0, %k1
; CHECK-NEXT:    vmovsh %xmm0, %xmm0, %xmm1 {%k1}
; CHECK-NEXT:    vmovaps %xmm1, %xmm0
; CHECK-NEXT:    retq
  %1 = tail call nsz half @llvm.minimum.f16(half %x, half %y)
  ret half %1
}

define half @test_fminimum_combine_cmps(half %x, half %y) {
; CHECK-LABEL: test_fminimum_combine_cmps:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vdivsh %xmm0, %xmm1, %xmm1
; CHECK-NEXT:    vfpclasssh $5, %xmm0, %k1 # k1 = isQuietNaN(xmm0) | isNegativeZero(xmm0)
; CHECK-NEXT:    vmovaps %xmm1, %xmm2
; CHECK-NEXT:    vmovsh %xmm0, %xmm0, %xmm2 {%k1}
; CHECK-NEXT:    vmovsh %xmm1, %xmm0, %xmm0 {%k1}
; CHECK-NEXT:    vminsh %xmm2, %xmm0, %xmm0
; CHECK-NEXT:    retq
  %1 = fdiv nnan half %y, %x
  %2 = tail call half @llvm.minimum.f16(half %x, half %1)
  ret half %2
}

define half @test_fmaximum(half %x, half %y) {
; CHECK-LABEL: test_fmaximum:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmovw %xmm0, %eax
; CHECK-NEXT:    testw %ax, %ax
; CHECK-NEXT:    sets %al
; CHECK-NEXT:    kmovd %eax, %k1
; CHECK-NEXT:    vmovaps %xmm0, %xmm2
; CHECK-NEXT:    vmovsh %xmm1, %xmm0, %xmm2 {%k1}
; CHECK-NEXT:    vmovsh %xmm0, %xmm0, %xmm1 {%k1}
; CHECK-NEXT:    vmaxsh %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    vcmpunordsh %xmm1, %xmm1, %k1
; CHECK-NEXT:    vmovsh %xmm1, %xmm0, %xmm0 {%k1}
; CHECK-NEXT:    retq
  %r = call half @llvm.maximum.f16(half %x, half %y)
  ret half %r
}

define <8 x half> @test_fmaximum_v8f16(<8 x half> %x, <8 x half> %y) "no-nans-fp-math"="true" "no-signed-zeros-fp-math"="true" {
; CHECK-LABEL: test_fmaximum_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmaxph %xmm1, %xmm0, %xmm0
; CHECK-NEXT:    retq
  %r = call <8 x half> @llvm.maximum.v8f16(<8 x half> %x, <8 x half> %y)
  ret <8 x half> %r
}

define half @test_fmaximum_nnan(half %x, half %y) {
; CHECK-LABEL: test_fmaximum_nnan:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vaddsh %xmm1, %xmm0, %xmm2
; CHECK-NEXT:    vsubsh %xmm1, %xmm0, %xmm0
; CHECK-NEXT:    vfpclasssh $3, %xmm0, %k1 # k1 = isQuietNaN(xmm0) | isPositiveZero(xmm0)
; CHECK-NEXT:    vmovaps %xmm2, %xmm1
; CHECK-NEXT:    vmovsh %xmm0, %xmm0, %xmm1 {%k1}
; CHECK-NEXT:    vmovsh %xmm2, %xmm0, %xmm0 {%k1}
; CHECK-NEXT:    vmaxsh %xmm1, %xmm0, %xmm0
; CHECK-NEXT:    retq
  %1 = fadd nnan half %x, %y
  %2 = fsub nnan half %x, %y
  %3 = tail call half @llvm.maximum.f16(half %1, half %2)
  ret half %3
}

define half @test_fmaximum_zero(half %x, half %y) {
; CHECK-LABEL: test_fmaximum_zero:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm0, %xmm0, %xmm0
; CHECK-NEXT:    vmaxsh %xmm0, %xmm1, %xmm0
; CHECK-NEXT:    vcmpunordsh %xmm1, %xmm1, %k1
; CHECK-NEXT:    vmovsh %xmm1, %xmm0, %xmm0 {%k1}
; CHECK-NEXT:    retq
  %1 = tail call half @llvm.maximum.f16(half 0.0, half %y)
  ret half %1
}

define half @test_fmaximum_nsz(half %x, half %y) "no-signed-zeros-fp-math"="true" {
; CHECK-LABEL: test_fmaximum_nsz:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmaxsh %xmm1, %xmm0, %xmm1
; CHECK-NEXT:    vcmpunordsh %xmm0, %xmm0, %k1
; CHECK-NEXT:    vmovsh %xmm0, %xmm0, %xmm1 {%k1}
; CHECK-NEXT:    vmovaps %xmm1, %xmm0
; CHECK-NEXT:    retq
  %1 = tail call half @llvm.maximum.f16(half %x, half %y)
  ret half %1
}

define half @test_fmaximum_combine_cmps(half %x, half %y) {
; CHECK-LABEL: test_fmaximum_combine_cmps:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vdivsh %xmm0, %xmm1, %xmm1
; CHECK-NEXT:    vfpclasssh $3, %xmm0, %k1 # k1 = isQuietNaN(xmm0) | isPositiveZero(xmm0)
; CHECK-NEXT:    vmovaps %xmm1, %xmm2
; CHECK-NEXT:    vmovsh %xmm0, %xmm0, %xmm2 {%k1}
; CHECK-NEXT:    vmovsh %xmm1, %xmm0, %xmm0 {%k1}
; CHECK-NEXT:    vmaxsh %xmm2, %xmm0, %xmm0
; CHECK-NEXT:    retq
  %1 = fdiv nnan half %y, %x
  %2 = tail call half @llvm.maximum.f16(half %x, half %1)
  ret half %2
}

define <16 x half> @test_fminimum_v16f16(<16 x half> %x, <16 x half> %y) "no-nans-fp-math"="true" "no-signed-zeros-fp-math"="true" {
; CHECK-LABEL: test_fminimum_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vminph %ymm1, %ymm0, %ymm0
; CHECK-NEXT:    retq
  %r = call <16 x half> @llvm.minimum.v16f16(<16 x half> %x, <16 x half> %y)
  ret <16 x half> %r
}

define <16 x half> @test_fmaximum_v16f16_nans(<16 x half> %x, <16 x half> %y) "no-signed-zeros-fp-math"="true" {
; CHECK-LABEL: test_fmaximum_v16f16_nans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmaxph %ymm1, %ymm0, %ymm1
; CHECK-NEXT:    vcmpunordph %ymm0, %ymm0, %k1
; CHECK-NEXT:    vmovdqu16 %ymm0, %ymm1 {%k1}
; CHECK-NEXT:    vmovdqa %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = call <16 x half> @llvm.maximum.v16f16(<16 x half> %x, <16 x half> %y)
  ret <16 x half> %r
}

define <32 x half> @test_fminimum_v32f16_szero(<32 x half> %x, <32 x half> %y) "no-nans-fp-math"="true" {
; CHECK-LABEL: test_fminimum_v32f16_szero:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpmovw2m %zmm0, %k1
; CHECK-NEXT:    vpblendmw %zmm0, %zmm1, %zmm2 {%k1}
; CHECK-NEXT:    vmovdqu16 %zmm1, %zmm0 {%k1}
; CHECK-NEXT:    vminph %zmm2, %zmm0, %zmm0
; CHECK-NEXT:    retq
  %r = call <32 x half> @llvm.minimum.v32f16(<32 x half> %x, <32 x half> %y)
  ret <32 x half> %r
}

define <32 x half> @test_fmaximum_v32f16_nans_szero(<32 x half> %x, <32 x half> %y) {
; CHECK-LABEL: test_fmaximum_v32f16_nans_szero:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpmovw2m %zmm0, %k1
; CHECK-NEXT:    vpblendmw %zmm1, %zmm0, %zmm2 {%k1}
; CHECK-NEXT:    vmovdqu16 %zmm0, %zmm1 {%k1}
; CHECK-NEXT:    vmaxph %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    vcmpunordph %zmm1, %zmm1, %k1
; CHECK-NEXT:    vmovdqu16 %zmm1, %zmm0 {%k1}
; CHECK-NEXT:    retq
  %r = call <32 x half> @llvm.maximum.v32f16(<32 x half> %x, <32 x half> %y)
  ret <32 x half> %r
}
