; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512f,+avx512vl | FileCheck %s --check-prefixes=AVX512
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx | FileCheck %s --check-prefixes=AVX,AVX1
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2 | FileCheck %s --check-prefixes=AVX,AVX2
; RUN: llc < %s -mtriple=x86_64-- -mattr=+sse4.1 | FileCheck %s --check-prefixes=SSE41
; RUN: llc < %s -mtriple=x86_64-- -mattr=+sse2 | FileCheck %s --check-prefixes=SSE2

declare void @use.v4.i32(<4 x i32>)

define <4 x i32> @eq_or_eq_ult_2(<4 x i32> %x) {
; AVX512-LABEL: eq_or_eq_ult_2:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %xmm0, %xmm0
; AVX512-NEXT:    vpcmpltud {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %xmm0, %k1
; AVX512-NEXT:    vpcmpeqd %xmm0, %xmm0, %xmm0
; AVX512-NEXT:    vmovdqa32 %xmm0, %xmm0 {%k1} {z}
; AVX512-NEXT:    retq
;
; AVX1-LABEL: eq_or_eq_ult_2:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpcmpeqd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm1
; AVX1-NEXT:    vpcmpeqd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: eq_or_eq_ult_2:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastd {{.*#+}} xmm1 = [6,6,6,6]
; AVX2-NEXT:    vpcmpeqd %xmm1, %xmm0, %xmm1
; AVX2-NEXT:    vpbroadcastd {{.*#+}} xmm2 = [5,5,5,5]
; AVX2-NEXT:    vpcmpeqd %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; SSE41-LABEL: eq_or_eq_ult_2:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovsxbd {{.*#+}} xmm1 = [6,6,6,6]
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm1
; SSE41-NEXT:    pcmpeqd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE41-NEXT:    por %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; SSE2-LABEL: eq_or_eq_ult_2:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa {{.*#+}} xmm1 = [6,6,6,6]
; SSE2-NEXT:    pcmpeqd %xmm0, %xmm1
; SSE2-NEXT:    pcmpeqd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE2-NEXT:    por %xmm1, %xmm0
; SSE2-NEXT:    retq
  %x_adj = add <4 x i32> %x, <i32 -5, i32 -5, i32 -5, i32 -5>
  %cmp = icmp ult <4 x i32> %x_adj, <i32 2, i32 2, i32 2, i32 2>
  %r = sext <4 x i1> %cmp to <4 x i32>
  ret <4 x i32> %r
}

define <4 x i32> @eq_or_eq_ult_2_only_transform_sse2(<4 x i32> %x) {
; AVX512-LABEL: eq_or_eq_ult_2_only_transform_sse2:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; AVX512-NEXT:    vpaddd %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    vpcmpltud {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %xmm0, %k1
; AVX512-NEXT:    vmovdqa32 %xmm1, %xmm0 {%k1} {z}
; AVX512-NEXT:    retq
;
; AVX1-LABEL: eq_or_eq_ult_2_only_transform_sse2:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpaddd %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpminud {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm1
; AVX1-NEXT:    vpcmpeqd %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: eq_or_eq_ult_2_only_transform_sse2:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpaddd %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} xmm1 = [1,1,1,1]
; AVX2-NEXT:    vpminud %xmm1, %xmm0, %xmm1
; AVX2-NEXT:    vpcmpeqd %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; SSE41-LABEL: eq_or_eq_ult_2_only_transform_sse2:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE41-NEXT:    paddd %xmm1, %xmm0
; SSE41-NEXT:    pmovsxbd {{.*#+}} xmm1 = [1,1,1,1]
; SSE41-NEXT:    pminud %xmm0, %xmm1
; SSE41-NEXT:    pcmpeqd %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; SSE2-LABEL: eq_or_eq_ult_2_only_transform_sse2:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa {{.*#+}} xmm1 = [2,2,2,2]
; SSE2-NEXT:    pcmpeqd %xmm0, %xmm1
; SSE2-NEXT:    pcmpeqd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE2-NEXT:    por %xmm1, %xmm0
; SSE2-NEXT:    retq
  %x_adj = add <4 x i32> %x, <i32 -1, i32 -1, i32 -1, i32 -1>
  %cmp = icmp ult <4 x i32> %x_adj, <i32 2, i32 2, i32 2, i32 2>
  %r = sext <4 x i1> %cmp to <4 x i32>
  ret <4 x i32> %r
}

define <4 x i32> @eq_or_eq_ult_2_fail_multiuse(<4 x i32> %x) {
; AVX512-LABEL: eq_or_eq_ult_2_fail_multiuse:
; AVX512:       # %bb.0:
; AVX512-NEXT:    subq $24, %rsp
; AVX512-NEXT:    .cfi_def_cfa_offset 32
; AVX512-NEXT:    vpaddd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %xmm0, %xmm0
; AVX512-NEXT:    vmovdqa %xmm0, (%rsp) # 16-byte Spill
; AVX512-NEXT:    callq use.v4.i32@PLT
; AVX512-NEXT:    vmovdqa (%rsp), %xmm0 # 16-byte Reload
; AVX512-NEXT:    vpcmpltud {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %xmm0, %k1
; AVX512-NEXT:    vpcmpeqd %xmm0, %xmm0, %xmm0
; AVX512-NEXT:    vmovdqa32 %xmm0, %xmm0 {%k1} {z}
; AVX512-NEXT:    addq $24, %rsp
; AVX512-NEXT:    .cfi_def_cfa_offset 8
; AVX512-NEXT:    retq
;
; AVX1-LABEL: eq_or_eq_ult_2_fail_multiuse:
; AVX1:       # %bb.0:
; AVX1-NEXT:    subq $24, %rsp
; AVX1-NEXT:    .cfi_def_cfa_offset 32
; AVX1-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpaddd %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vmovdqa %xmm0, (%rsp) # 16-byte Spill
; AVX1-NEXT:    callq use.v4.i32@PLT
; AVX1-NEXT:    vmovdqa (%rsp), %xmm1 # 16-byte Reload
; AVX1-NEXT:    vpminud {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm0
; AVX1-NEXT:    vpcmpeqd %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    addq $24, %rsp
; AVX1-NEXT:    .cfi_def_cfa_offset 8
; AVX1-NEXT:    retq
;
; AVX2-LABEL: eq_or_eq_ult_2_fail_multiuse:
; AVX2:       # %bb.0:
; AVX2-NEXT:    subq $24, %rsp
; AVX2-NEXT:    .cfi_def_cfa_offset 32
; AVX2-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpaddd %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vmovdqa %xmm0, (%rsp) # 16-byte Spill
; AVX2-NEXT:    callq use.v4.i32@PLT
; AVX2-NEXT:    vpbroadcastd {{.*#+}} xmm0 = [1,1,1,1]
; AVX2-NEXT:    vmovdqa (%rsp), %xmm1 # 16-byte Reload
; AVX2-NEXT:    vpminud %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    vpcmpeqd %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    addq $24, %rsp
; AVX2-NEXT:    .cfi_def_cfa_offset 8
; AVX2-NEXT:    retq
;
; SSE41-LABEL: eq_or_eq_ult_2_fail_multiuse:
; SSE41:       # %bb.0:
; SSE41-NEXT:    subq $24, %rsp
; SSE41-NEXT:    .cfi_def_cfa_offset 32
; SSE41-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE41-NEXT:    paddd %xmm1, %xmm0
; SSE41-NEXT:    movdqa %xmm0, (%rsp) # 16-byte Spill
; SSE41-NEXT:    callq use.v4.i32@PLT
; SSE41-NEXT:    pmovsxbd {{.*#+}} xmm0 = [1,1,1,1]
; SSE41-NEXT:    movdqa (%rsp), %xmm1 # 16-byte Reload
; SSE41-NEXT:    pminud %xmm1, %xmm0
; SSE41-NEXT:    pcmpeqd %xmm1, %xmm0
; SSE41-NEXT:    addq $24, %rsp
; SSE41-NEXT:    .cfi_def_cfa_offset 8
; SSE41-NEXT:    retq
;
; SSE2-LABEL: eq_or_eq_ult_2_fail_multiuse:
; SSE2:       # %bb.0:
; SSE2-NEXT:    subq $24, %rsp
; SSE2-NEXT:    .cfi_def_cfa_offset 32
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE2-NEXT:    paddd %xmm0, %xmm1
; SSE2-NEXT:    movdqa %xmm1, (%rsp) # 16-byte Spill
; SSE2-NEXT:    movdqa %xmm1, %xmm0
; SSE2-NEXT:    callq use.v4.i32@PLT
; SSE2-NEXT:    movdqa (%rsp), %xmm1 # 16-byte Reload
; SSE2-NEXT:    pxor {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; SSE2-NEXT:    movdqa {{.*#+}} xmm0 = [2147483650,2147483650,2147483650,2147483650]
; SSE2-NEXT:    pcmpgtd %xmm1, %xmm0
; SSE2-NEXT:    addq $24, %rsp
; SSE2-NEXT:    .cfi_def_cfa_offset 8
; SSE2-NEXT:    retq
  %x_adj = add <4 x i32> %x, <i32 -1, i32 -1, i32 -1, i32 -1>
  call void @use.v4.i32(<4 x i32> %x_adj)
  %cmp = icmp ult <4 x i32> %x_adj, <i32 2, i32 2, i32 2, i32 2>
  %r = sext <4 x i1> %cmp to <4 x i32>
  ret <4 x i32> %r
}

define <4 x i32> @eq_or_eq_ult_3_fail(<4 x i32> %x) {
; AVX512-LABEL: eq_or_eq_ult_3_fail:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; AVX512-NEXT:    vpaddd %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    vpcmpltud {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %xmm0, %k1
; AVX512-NEXT:    vmovdqa32 %xmm1, %xmm0 {%k1} {z}
; AVX512-NEXT:    retq
;
; AVX1-LABEL: eq_or_eq_ult_3_fail:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpaddd %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpminud {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm1
; AVX1-NEXT:    vpcmpeqd %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: eq_or_eq_ult_3_fail:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpaddd %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} xmm1 = [2,2,2,2]
; AVX2-NEXT:    vpminud %xmm1, %xmm0, %xmm1
; AVX2-NEXT:    vpcmpeqd %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; SSE41-LABEL: eq_or_eq_ult_3_fail:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE41-NEXT:    paddd %xmm1, %xmm0
; SSE41-NEXT:    pmovsxbd {{.*#+}} xmm1 = [2,2,2,2]
; SSE41-NEXT:    pminud %xmm0, %xmm1
; SSE41-NEXT:    pcmpeqd %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; SSE2-LABEL: eq_or_eq_ult_3_fail:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE2-NEXT:    paddd %xmm0, %xmm1
; SSE2-NEXT:    pxor {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; SSE2-NEXT:    movdqa {{.*#+}} xmm0 = [2147483651,2147483651,2147483651,2147483651]
; SSE2-NEXT:    pcmpgtd %xmm1, %xmm0
; SSE2-NEXT:    retq
  %x_adj = add <4 x i32> %x, <i32 -1, i32 -1, i32 -1, i32 -1>
  %cmp = icmp ult <4 x i32> %x_adj, <i32 3, i32 3, i32 3, i32 3>
  %r = sext <4 x i1> %cmp to <4 x i32>
  ret <4 x i32> %r
}

define <4 x i32> @eq_or_eq_ugt_m3(<4 x i32> %x) {
; AVX512-LABEL: eq_or_eq_ugt_m3:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX512-NEXT:    vpcmpnleud {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %xmm0, %k1
; AVX512-NEXT:    vpcmpeqd %xmm0, %xmm0, %xmm0
; AVX512-NEXT:    vmovdqa32 %xmm0, %xmm0 {%k1} {z}
; AVX512-NEXT:    retq
;
; AVX-LABEL: eq_or_eq_ugt_m3:
; AVX:       # %bb.0:
; AVX-NEXT:    vpcmpeqd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm1
; AVX-NEXT:    vpcmpeqd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
;
; SSE41-LABEL: eq_or_eq_ugt_m3:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovsxbd {{.*#+}} xmm1 = [9,12,9,9]
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm1
; SSE41-NEXT:    pcmpeqd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE41-NEXT:    por %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; SSE2-LABEL: eq_or_eq_ugt_m3:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa {{.*#+}} xmm1 = [9,12,9,9]
; SSE2-NEXT:    pcmpeqd %xmm0, %xmm1
; SSE2-NEXT:    pcmpeqd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE2-NEXT:    por %xmm1, %xmm0
; SSE2-NEXT:    retq
  %x_adj = add <4 x i32> %x, <i32 -11, i32 -14, i32 -11, i32 -11>
  %cmp = icmp ugt <4 x i32> %x_adj, <i32 -3, i32 -3, i32 -3, i32 -3>
  %r = sext <4 x i1> %cmp to <4 x i32>
  ret <4 x i32> %r
}

define <4 x i32> @eq_or_eq_ule_1(<4 x i32> %x) {
; AVX512-LABEL: eq_or_eq_ule_1:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX512-NEXT:    vpcmpleud {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %xmm0, %k1
; AVX512-NEXT:    vpcmpeqd %xmm0, %xmm0, %xmm0
; AVX512-NEXT:    vmovdqa32 %xmm0, %xmm0 {%k1} {z}
; AVX512-NEXT:    retq
;
; AVX-LABEL: eq_or_eq_ule_1:
; AVX:       # %bb.0:
; AVX-NEXT:    vpcmpeqd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm1
; AVX-NEXT:    vpcmpeqd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
;
; SSE41-LABEL: eq_or_eq_ule_1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovsxbd {{.*#+}} xmm1 = [0,4294967295,4294967294,4294967293]
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm1
; SSE41-NEXT:    pcmpeqd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE41-NEXT:    por %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; SSE2-LABEL: eq_or_eq_ule_1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa {{.*#+}} xmm1 = [0,4294967295,4294967294,4294967293]
; SSE2-NEXT:    pcmpeqd %xmm0, %xmm1
; SSE2-NEXT:    pcmpeqd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE2-NEXT:    por %xmm1, %xmm0
; SSE2-NEXT:    retq
  %x_adj = add <4 x i32> %x, <i32 1, i32 2, i32 3, i32 4>
  %cmp = icmp ule <4 x i32> %x_adj, <i32 1, i32 1, i32 1, i32 1>
  %r = sext <4 x i1> %cmp to <4 x i32>
  ret <4 x i32> %r
}

define <2 x i64> @eq_or_eq_uge_m2_i64(<2 x i64> %x) {
; AVX512-LABEL: eq_or_eq_uge_m2_i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX512-NEXT:    vpcmpnltuq {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to2}, %xmm0, %k1
; AVX512-NEXT:    vpcmpeqd %xmm0, %xmm0, %xmm0
; AVX512-NEXT:    vmovdqa64 %xmm0, %xmm0 {%k1} {z}
; AVX512-NEXT:    retq
;
; AVX-LABEL: eq_or_eq_uge_m2_i64:
; AVX:       # %bb.0:
; AVX-NEXT:    vpcmpeqq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm1
; AVX-NEXT:    vpcmpeqq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
;
; SSE41-LABEL: eq_or_eq_uge_m2_i64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovsxbq {{.*#+}} xmm1 = [18446744073709551613,18446744073709551612]
; SSE41-NEXT:    pcmpeqq %xmm0, %xmm1
; SSE41-NEXT:    pcmpeqq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE41-NEXT:    por %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; SSE2-LABEL: eq_or_eq_uge_m2_i64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa {{.*#+}} xmm1 = [18446744073709551613,18446744073709551612]
; SSE2-NEXT:    pcmpeqd %xmm0, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[1,0,3,2]
; SSE2-NEXT:    pand %xmm1, %xmm2
; SSE2-NEXT:    pcmpeqd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[1,0,3,2]
; SSE2-NEXT:    pand %xmm1, %xmm0
; SSE2-NEXT:    por %xmm2, %xmm0
; SSE2-NEXT:    retq
  %x_adj = add <2 x i64> %x, <i64 1, i64 2>
  %cmp = icmp uge <2 x i64> %x_adj, <i64 -2, i64 -2>
  %r = sext <2 x i1> %cmp to <2 x i64>
  ret <2 x i64> %r
}


define <2 x i64> @eq_or_eq_uge_m2_i64_m1(<2 x i64> %x) {
; AVX512-LABEL: eq_or_eq_uge_m2_i64_m1:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; AVX512-NEXT:    vpaddq %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    vpcmpnltuq {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to2}, %xmm0, %k1
; AVX512-NEXT:    vmovdqa64 %xmm1, %xmm0 {%k1} {z}
; AVX512-NEXT:    retq
;
; AVX-LABEL: eq_or_eq_uge_m2_i64_m1:
; AVX:       # %bb.0:
; AVX-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; AVX-NEXT:    vpcmpeqq %xmm1, %xmm0, %xmm1
; AVX-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX-NEXT:    vpcmpeqq %xmm2, %xmm0, %xmm0
; AVX-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
;
; SSE41-LABEL: eq_or_eq_uge_m2_i64_m1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE41-NEXT:    pcmpeqq %xmm0, %xmm1
; SSE41-NEXT:    pxor %xmm2, %xmm2
; SSE41-NEXT:    pcmpeqq %xmm2, %xmm0
; SSE41-NEXT:    por %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; SSE2-LABEL: eq_or_eq_uge_m2_i64_m1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE2-NEXT:    pcmpeqd %xmm0, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[1,0,3,2]
; SSE2-NEXT:    pand %xmm1, %xmm2
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[1,0,3,2]
; SSE2-NEXT:    pand %xmm1, %xmm0
; SSE2-NEXT:    por %xmm2, %xmm0
; SSE2-NEXT:    retq
  %x_adj = add <2 x i64> %x, <i64 -1, i64 -1>
  %cmp = icmp uge <2 x i64> %x_adj, <i64 -2, i64 -2>
  %r = sext <2 x i1> %cmp to <2 x i64>
  ret <2 x i64> %r
}

define <4 x i32> @eq_or_eq_uge_2_fail_(<4 x i32> %x) {
; AVX512-LABEL: eq_or_eq_uge_2_fail_:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX512-NEXT:    vpcmpnltud {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %xmm0, %k1
; AVX512-NEXT:    vpcmpeqd %xmm0, %xmm0, %xmm0
; AVX512-NEXT:    vmovdqa32 %xmm0, %xmm0 {%k1} {z}
; AVX512-NEXT:    retq
;
; AVX1-LABEL: eq_or_eq_uge_2_fail_:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpaddd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vpmaxud {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm1
; AVX1-NEXT:    vpcmpeqd %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: eq_or_eq_uge_2_fail_:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} xmm1 = [2,2,2,2]
; AVX2-NEXT:    vpmaxud %xmm1, %xmm0, %xmm1
; AVX2-NEXT:    vpcmpeqd %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; SSE41-LABEL: eq_or_eq_uge_2_fail_:
; SSE41:       # %bb.0:
; SSE41-NEXT:    paddd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE41-NEXT:    pmovsxbd {{.*#+}} xmm1 = [2,2,2,2]
; SSE41-NEXT:    pmaxud %xmm0, %xmm1
; SSE41-NEXT:    pcmpeqd %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; SSE2-LABEL: eq_or_eq_uge_2_fail_:
; SSE2:       # %bb.0:
; SSE2-NEXT:    paddd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE2-NEXT:    pxor {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE2-NEXT:    movdqa {{.*#+}} xmm1 = [2147483650,2147483650,2147483650,2147483650]
; SSE2-NEXT:    pcmpgtd %xmm0, %xmm1
; SSE2-NEXT:    pcmpeqd %xmm0, %xmm0
; SSE2-NEXT:    pxor %xmm1, %xmm0
; SSE2-NEXT:    retq
  %x_adj = add <4 x i32> %x, <i32 1, i32 2, i32 3, i32 4>
  %cmp = icmp uge <4 x i32> %x_adj, <i32 2, i32 2, i32 2, i32 2>
  %r = sext <4 x i1> %cmp to <4 x i32>
  ret <4 x i32> %r
}


define <8 x i32> @eq_or_eq_ult_2_256(<8 x i32> %x) {
; AVX512-LABEL: eq_or_eq_ult_2_256:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm0, %ymm0
; AVX512-NEXT:    vpcmpltud {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm0, %k1
; AVX512-NEXT:    vpcmpeqd %ymm0, %ymm0, %ymm0
; AVX512-NEXT:    vmovdqa32 %ymm0, %ymm0 {%k1} {z}
; AVX512-NEXT:    retq
;
; AVX1-LABEL: eq_or_eq_ult_2_256:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [4294967291,4294967291,4294967291,4294967291]
; AVX1-NEXT:    vpaddd %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpaddd %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [1,1,1,1]
; AVX1-NEXT:    vpminud %xmm1, %xmm0, %xmm3
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpminud %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpcmpeqd %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: eq_or_eq_ult_2_256:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [6,6,6,6,6,6,6,6]
; AVX2-NEXT:    vpcmpeqd %ymm1, %ymm0, %ymm1
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm2 = [5,5,5,5,5,5,5,5]
; AVX2-NEXT:    vpcmpeqd %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; SSE41-LABEL: eq_or_eq_ult_2_256:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovsxbd {{.*#+}} xmm2 = [6,6,6,6]
; SSE41-NEXT:    movdqa %xmm0, %xmm3
; SSE41-NEXT:    pcmpeqd %xmm2, %xmm3
; SSE41-NEXT:    pmovsxbd {{.*#+}} xmm4 = [5,5,5,5]
; SSE41-NEXT:    pcmpeqd %xmm4, %xmm0
; SSE41-NEXT:    por %xmm3, %xmm0
; SSE41-NEXT:    pcmpeqd %xmm1, %xmm2
; SSE41-NEXT:    pcmpeqd %xmm4, %xmm1
; SSE41-NEXT:    por %xmm2, %xmm1
; SSE41-NEXT:    retq
;
; SSE2-LABEL: eq_or_eq_ult_2_256:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [6,6,6,6]
; SSE2-NEXT:    movdqa %xmm0, %xmm3
; SSE2-NEXT:    pcmpeqd %xmm2, %xmm3
; SSE2-NEXT:    movdqa {{.*#+}} xmm4 = [5,5,5,5]
; SSE2-NEXT:    pcmpeqd %xmm4, %xmm0
; SSE2-NEXT:    por %xmm3, %xmm0
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm2
; SSE2-NEXT:    pcmpeqd %xmm4, %xmm1
; SSE2-NEXT:    por %xmm2, %xmm1
; SSE2-NEXT:    retq
  %x_adj = add <8 x i32> %x, <i32 -5, i32 -5, i32 -5, i32 -5, i32 -5, i32 -5, i32 -5, i32 -5>
  %cmp = icmp ult <8 x i32> %x_adj, <i32 2, i32 2, i32 2, i32 2, i32 2, i32 2, i32 2, i32 2>
  %r = sext <8 x i1> %cmp to <8 x i32>
  ret <8 x i32> %r
}


define <8 x i32> @eq_or_eq_ult_2_256_m1(<8 x i32> %x) {
; AVX512-LABEL: eq_or_eq_ult_2_256_m1:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX512-NEXT:    vpaddd %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vpcmpltud {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm0, %k1
; AVX512-NEXT:    vmovdqa32 %ymm1, %ymm0 {%k1} {z}
; AVX512-NEXT:    retq
;
; AVX1-LABEL: eq_or_eq_ult_2_256_m1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpaddd %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpaddd %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [1,1,1,1]
; AVX1-NEXT:    vpminud %xmm1, %xmm0, %xmm3
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpminud %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpcmpeqd %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: eq_or_eq_ult_2_256_m1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    vpaddd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [1,1,1,1,1,1,1,1]
; AVX2-NEXT:    vpminud %ymm1, %ymm0, %ymm1
; AVX2-NEXT:    vpcmpeqd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; SSE41-LABEL: eq_or_eq_ult_2_256_m1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovsxbd {{.*#+}} xmm2 = [2,2,2,2]
; SSE41-NEXT:    movdqa %xmm0, %xmm3
; SSE41-NEXT:    pcmpeqd %xmm2, %xmm3
; SSE41-NEXT:    pmovsxbd {{.*#+}} xmm4 = [1,1,1,1]
; SSE41-NEXT:    pcmpeqd %xmm4, %xmm0
; SSE41-NEXT:    por %xmm3, %xmm0
; SSE41-NEXT:    pcmpeqd %xmm1, %xmm2
; SSE41-NEXT:    pcmpeqd %xmm4, %xmm1
; SSE41-NEXT:    por %xmm2, %xmm1
; SSE41-NEXT:    retq
;
; SSE2-LABEL: eq_or_eq_ult_2_256_m1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [2,2,2,2]
; SSE2-NEXT:    movdqa %xmm0, %xmm3
; SSE2-NEXT:    pcmpeqd %xmm2, %xmm3
; SSE2-NEXT:    movdqa {{.*#+}} xmm4 = [1,1,1,1]
; SSE2-NEXT:    pcmpeqd %xmm4, %xmm0
; SSE2-NEXT:    por %xmm3, %xmm0
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm2
; SSE2-NEXT:    pcmpeqd %xmm4, %xmm1
; SSE2-NEXT:    por %xmm2, %xmm1
; SSE2-NEXT:    retq
  %x_adj = add <8 x i32> %x, <i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1>
  %cmp = icmp ult <8 x i32> %x_adj, <i32 2, i32 2, i32 2, i32 2, i32 2, i32 2, i32 2, i32 2>
  %r = sext <8 x i1> %cmp to <8 x i32>
  ret <8 x i32> %r
}


define <32 x i8> @eq_or_eq_ult_2_256_i8_m1(<32 x i8> %x) {
; AVX512-LABEL: eq_or_eq_ult_2_256_i8_m1:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX512-NEXT:    vpaddb %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vpminub {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm1
; AVX512-NEXT:    vpcmpeqb %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    retq
;
; AVX1-LABEL: eq_or_eq_ult_2_256_i8_m1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpaddb %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpaddb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; AVX1-NEXT:    vpminub %xmm1, %xmm0, %xmm3
; AVX1-NEXT:    vpcmpeqb %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpminub %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpcmpeqb %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: eq_or_eq_ult_2_256_i8_m1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    vpaddb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpminub {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm1
; AVX2-NEXT:    vpcmpeqb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; SSE41-LABEL: eq_or_eq_ult_2_256_i8_m1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa {{.*#+}} xmm2 = [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2]
; SSE41-NEXT:    movdqa %xmm0, %xmm3
; SSE41-NEXT:    pcmpeqb %xmm2, %xmm3
; SSE41-NEXT:    movdqa {{.*#+}} xmm4 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; SSE41-NEXT:    pcmpeqb %xmm4, %xmm0
; SSE41-NEXT:    por %xmm3, %xmm0
; SSE41-NEXT:    pcmpeqb %xmm1, %xmm2
; SSE41-NEXT:    pcmpeqb %xmm4, %xmm1
; SSE41-NEXT:    por %xmm2, %xmm1
; SSE41-NEXT:    retq
;
; SSE2-LABEL: eq_or_eq_ult_2_256_i8_m1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2]
; SSE2-NEXT:    movdqa %xmm0, %xmm3
; SSE2-NEXT:    pcmpeqb %xmm2, %xmm3
; SSE2-NEXT:    movdqa {{.*#+}} xmm4 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; SSE2-NEXT:    pcmpeqb %xmm4, %xmm0
; SSE2-NEXT:    por %xmm3, %xmm0
; SSE2-NEXT:    pcmpeqb %xmm1, %xmm2
; SSE2-NEXT:    pcmpeqb %xmm4, %xmm1
; SSE2-NEXT:    por %xmm2, %xmm1
; SSE2-NEXT:    retq
  %x_adj = add <32 x i8> %x, <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>
  %cmp = icmp ult <32 x i8> %x_adj, <i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2>
  %r = sext <32 x i1> %cmp to <32 x i8>
  ret <32 x i8> %r
}


define <16 x i8> @eq_or_eq_ult_2_128_i8_m1(<16 x i8> %x) {
; AVX512-LABEL: eq_or_eq_ult_2_128_i8_m1:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; AVX512-NEXT:    vpaddb %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    vpminub {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm1
; AVX512-NEXT:    vpcmpeqb %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    retq
;
; AVX-LABEL: eq_or_eq_ult_2_128_i8_m1:
; AVX:       # %bb.0:
; AVX-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; AVX-NEXT:    vpaddb %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vpminub {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm1
; AVX-NEXT:    vpcmpeqb %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
;
; SSE41-LABEL: eq_or_eq_ult_2_128_i8_m1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE41-NEXT:    paddb %xmm1, %xmm0
; SSE41-NEXT:    movdqa {{.*#+}} xmm1 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; SSE41-NEXT:    pminub %xmm0, %xmm1
; SSE41-NEXT:    pcmpeqb %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; SSE2-LABEL: eq_or_eq_ult_2_128_i8_m1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE2-NEXT:    paddb %xmm1, %xmm0
; SSE2-NEXT:    movdqa {{.*#+}} xmm1 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; SSE2-NEXT:    pminub %xmm0, %xmm1
; SSE2-NEXT:    pcmpeqb %xmm1, %xmm0
; SSE2-NEXT:    retq
  %x_adj = add <16 x i8> %x, <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>
  %cmp = icmp ult <16 x i8> %x_adj, <i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2>
  %r = sext <16 x i1> %cmp to <16 x i8>
  ret <16 x i8> %r
}


define <16 x i8> @eq_or_eq_ult_2_128_i8(<16 x i8> %x) {
; AVX512-LABEL: eq_or_eq_ult_2_128_i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX512-NEXT:    vpminub {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm1
; AVX512-NEXT:    vpcmpeqb %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    retq
;
; AVX-LABEL: eq_or_eq_ult_2_128_i8:
; AVX:       # %bb.0:
; AVX-NEXT:    vpcmpeqb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm1
; AVX-NEXT:    vpcmpeqb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
;
; SSE41-LABEL: eq_or_eq_ult_2_128_i8:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa {{.*#+}} xmm1 = [232,232,232,232,232,232,232,232,232,232,232,232,232,232,232,232]
; SSE41-NEXT:    pcmpeqb %xmm0, %xmm1
; SSE41-NEXT:    pcmpeqb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE41-NEXT:    por %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; SSE2-LABEL: eq_or_eq_ult_2_128_i8:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa {{.*#+}} xmm1 = [232,232,232,232,232,232,232,232,232,232,232,232,232,232,232,232]
; SSE2-NEXT:    pcmpeqb %xmm0, %xmm1
; SSE2-NEXT:    pcmpeqb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE2-NEXT:    por %xmm1, %xmm0
; SSE2-NEXT:    retq
  %x_adj = add <16 x i8> %x, <i8 25, i8 25, i8 25, i8 25, i8 25, i8 25, i8 25, i8 25, i8 25, i8 25, i8 25, i8 25, i8 25, i8 25, i8 25, i8 25>
  %cmp = icmp ult <16 x i8> %x_adj, <i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2>
  %r = sext <16 x i1> %cmp to <16 x i8>
  ret <16 x i8> %r
}
