; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 2
; RUN: opt < %s -passes=ipsccp -S | FileCheck %s

declare void @llvm.assume(i1)
declare i8 @llvm.ctpop.i8(i8)

; https://alive2.llvm.org/ce/z/LV_8xy
define i8 @and_add_shl(i8 %x) {
; CHECK-LABEL: define i8 @and_add_shl
; CHECK-SAME: (i8 [[X:%.*]]) {
; CHECK-NEXT:    [[OP1_P2:%.*]] = icmp ule i8 [[X]], 5
; CHECK-NEXT:    call void @llvm.assume(i1 [[OP1_P2]])
; CHECK-NEXT:    [[SHIFT:%.*]] = shl nuw nsw i8 1, [[X]]
; CHECK-NEXT:    [[SUB:%.*]] = add nsw i8 [[SHIFT]], -1
; CHECK-NEXT:    ret i8 0
;
  %op1_p2 = icmp ule i8 %x, 5
  call void @llvm.assume(i1 %op1_p2)
  %shift = shl i8 1, %x
  %sub = add i8 %shift, -1
  %r = and i8 %sub, 32
  ret i8 %r
}

; https://alive2.llvm.org/ce/z/YNYYdV
define i8 @and_not_shl(i8 %x) {
; CHECK-LABEL: define i8 @and_not_shl
; CHECK-SAME: (i8 [[X:%.*]]) {
; CHECK-NEXT:    [[OP1_P2:%.*]] = icmp ule i8 [[X]], 5
; CHECK-NEXT:    call void @llvm.assume(i1 [[OP1_P2]])
; CHECK-NEXT:    [[SHIFT:%.*]] = shl nsw i8 -1, [[X]]
; CHECK-NEXT:    [[NOT:%.*]] = xor i8 [[SHIFT]], -1
; CHECK-NEXT:    ret i8 0
;
  %op1_p2 = icmp ule i8 %x, 5
  call void @llvm.assume(i1 %op1_p2)
  %shift = shl i8 -1, %x
  %not = xor i8 %shift, -1
  %r = and i8 %not, 32
  ret i8 %r
}

define i8 @and_not_shl_1(i8 %x) {
; CHECK-LABEL: define i8 @and_not_shl_1
; CHECK-SAME: (i8 [[X:%.*]]) {
; CHECK-NEXT:    [[OP1_P2:%.*]] = icmp ule i8 [[X]], 4
; CHECK-NEXT:    call void @llvm.assume(i1 [[OP1_P2]])
; CHECK-NEXT:    [[SHIFT:%.*]] = shl nsw i8 -1, [[X]]
; CHECK-NEXT:    [[NOT:%.*]] = xor i8 [[SHIFT]], -1
; CHECK-NEXT:    ret i8 0
;
  %op1_p2 = icmp ule i8 %x, 4
  call void @llvm.assume(i1 %op1_p2)
  %shift = shl i8 -1, %x
  %not = xor i8 %shift, -1
  %r = and i8 %not, 48 ;    3 * 16
  ret i8 %r
}

; Negative test: https://alive2.llvm.org/ce/z/Zv4Pyu
define i8 @and_add_shl_overlap(i8 %x) {
; CHECK-LABEL: define range(i8 0, 33) i8 @and_add_shl_overlap
; CHECK-SAME: (i8 [[X:%.*]]) {
; CHECK-NEXT:    [[OP1_P2:%.*]] = icmp ule i8 [[X]], 6
; CHECK-NEXT:    call void @llvm.assume(i1 [[OP1_P2]])
; CHECK-NEXT:    [[SHIFT:%.*]] = shl nuw nsw i8 1, [[X]]
; CHECK-NEXT:    [[SUB:%.*]] = add nsw i8 [[SHIFT]], -1
; CHECK-NEXT:    [[R:%.*]] = and i8 [[SUB]], 32
; CHECK-NEXT:    ret i8 [[R]]
;
  %op1_p2 = icmp ule i8 %x, 6
  call void @llvm.assume(i1 %op1_p2)
  %shift = shl i8 1, %x
  %sub = add i8 %shift, -1
  %r = and i8 %sub, 32  ; expect 64
  ret i8 %r
}

define i8 @and_not_shl_overlap(i8 %x) {
; CHECK-LABEL: define range(i8 0, 5) i8 @and_not_shl_overlap
; CHECK-SAME: (i8 [[X:%.*]]) {
; CHECK-NEXT:    [[OP1_P2:%.*]] = icmp ule i8 [[X]], 3
; CHECK-NEXT:    call void @llvm.assume(i1 [[OP1_P2]])
; CHECK-NEXT:    [[SHIFT:%.*]] = shl nsw i8 -1, [[X]]
; CHECK-NEXT:    [[NOT:%.*]] = xor i8 [[SHIFT]], -1
; CHECK-NEXT:    [[R:%.*]] = and i8 [[NOT]], 4
; CHECK-NEXT:    ret i8 [[R]]
;
  %op1_p2 = icmp ule i8 %x, 3
  call void @llvm.assume(i1 %op1_p2)
  %shift = shl i8 -1, %x
  %not = xor i8 %shift, -1
  %r = and i8 %not, 4   ; expect 8
  ret i8 %r
}
