/* TweetListBox.c generated by valac 0.34.6, the Vala compiler
 * generated from TweetListBox.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include "CbTweet.h"


#define TYPE_TWEET_LIST_BOX (tweet_list_box_get_type ())
#define TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_BOX, TweetListBox))
#define TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_BOX, TweetListBoxClass))
#define IS_TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_BOX))
#define IS_TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_BOX))
#define TWEET_LIST_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_BOX, TweetListBoxClass))

typedef struct _TweetListBox TweetListBox;
typedef struct _TweetListBoxClass TweetListBoxClass;
typedef struct _TweetListBoxPrivate TweetListBoxPrivate;

#define TYPE_DELTA_UPDATER (delta_updater_get_type ())
#define DELTA_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DELTA_UPDATER, DeltaUpdater))
#define DELTA_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DELTA_UPDATER, DeltaUpdaterClass))
#define IS_DELTA_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DELTA_UPDATER))
#define IS_DELTA_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DELTA_UPDATER))
#define DELTA_UPDATER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DELTA_UPDATER, DeltaUpdaterClass))

typedef struct _DeltaUpdater DeltaUpdater;
typedef struct _DeltaUpdaterClass DeltaUpdaterClass;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_TWEET_MODEL (tweet_model_get_type ())
#define TWEET_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_MODEL, TweetModel))
#define TWEET_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_MODEL, TweetModelClass))
#define IS_TWEET_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_MODEL))
#define IS_TWEET_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_MODEL))
#define TWEET_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_MODEL, TweetModelClass))

typedef struct _TweetModel TweetModel;
typedef struct _TweetModelClass TweetModelClass;

#define TYPE_TWEET_LIST_ENTRY (tweet_list_entry_get_type ())
#define TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntry))
#define TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))
#define IS_TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_ENTRY))
#define IS_TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_ENTRY))
#define TWEET_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))

typedef struct _TweetListEntry TweetListEntry;
typedef struct _TweetListEntryClass TweetListEntryClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_ITWITTER_ITEM (itwitter_item_get_type ())
#define ITWITTER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ITWITTER_ITEM, ITwitterItem))
#define IS_ITWITTER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ITWITTER_ITEM))
#define ITWITTER_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ITWITTER_ITEM, ITwitterItemIface))

typedef struct _ITwitterItem ITwitterItem;
typedef struct _ITwitterItemIface ITwitterItemIface;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _TweetListBox {
	GtkListBox parent_instance;
	TweetListBoxPrivate * priv;
	DeltaUpdater* delta_updater;
	Account* account;
	TweetModel* model;
};

struct _TweetListBoxClass {
	GtkListBoxClass parent_class;
};

struct _TweetListBoxPrivate {
	GtkStack* placeholder;
	GtkLabel* no_entries_label;
	GtkBox* error_box;
	GtkLabel* error_label;
	GtkButton* retry_button;
	TweetListEntry* _action_entry;
};

struct _ITwitterItemIface {
	GTypeInterface parent_iface;
	gint (*update_time_delta) (ITwitterItem* self, GDateTime* now);
	gint64 (*get_sort_factor) (ITwitterItem* self);
};


static gpointer tweet_list_box_parent_class = NULL;

GType tweet_list_box_get_type (void) G_GNUC_CONST;
GType delta_updater_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
GType tweet_model_get_type (void) G_GNUC_CONST;
GType tweet_list_entry_get_type (void) G_GNUC_CONST;
#define TWEET_LIST_BOX_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TWEET_LIST_BOX, TweetListBoxPrivate))
enum  {
	TWEET_LIST_BOX_DUMMY_PROPERTY,
	TWEET_LIST_BOX_ACTION_ENTRY
};
TweetModel* tweet_model_new (void);
TweetModel* tweet_model_construct (GType object_type);
TweetListBox* tweet_list_box_new (gboolean show_placeholder);
TweetListBox* tweet_list_box_construct (GType object_type, gboolean show_placeholder);
static void tweet_list_box_add_placeholder (TweetListBox* self);
static gboolean tweet_list_box_button_press_cb (TweetListBox* self, GdkEventButton* evt);
gboolean tweet_list_entry_get_shows_actions (TweetListEntry* self);
void tweet_list_entry_toggle_mode (TweetListEntry* self);
static void __lambda30_ (TweetListBox* self);
static void ___lambda30__gtk_button_clicked (GtkButton* _sender, gpointer self);
void tweet_list_box_set_empty (TweetListBox* self);
void tweet_list_box_set_unempty (TweetListBox* self);
void tweet_list_box_set_error (TweetListBox* self, const gchar* err_msg);
GtkStack* tweet_list_box_get_placeholder (TweetListBox* self);
void tweet_list_box_set_placeholder_text (TweetListBox* self, const gchar* text);
void tweet_list_box_reset_placeholder_text (TweetListBox* self);
void tweet_list_box_remove_all (TweetListBox* self);
static void __lambda31_ (TweetListBox* self, GtkWidget* w);
static void ___lambda31__gtk_callback (GtkWidget* widget, gpointer self);
GtkWidget* tweet_list_box_get_first_visible_row (TweetListBox* self);
TweetListEntry* tweet_list_box_get_action_entry (TweetListBox* self);
static GObject * tweet_list_box_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gboolean _tweet_list_box_button_press_cb_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
GSettings* settings_get (void);
static GtkWidget* _tweet_list_box___lambda32_ (TweetListBox* self, GObject* obj);
GType main_window_get_type (void) G_GNUC_CONST;
TweetListEntry* tweet_list_entry_new (CbTweet* tweet, MainWindow* main_window, Account* account, gboolean restrict_height);
TweetListEntry* tweet_list_entry_construct (GType object_type, CbTweet* tweet, MainWindow* main_window, Account* account, gboolean restrict_height);
GType itwitter_item_get_type (void) G_GNUC_CONST;
void delta_updater_add (DeltaUpdater* self, ITwitterItem* entry);
void tweet_list_entry_fade_in (TweetListEntry* self);
static GtkWidget* __tweet_list_box___lambda32__gtk_list_box_create_widget_func (GObject* item, gpointer self);
static void tweet_list_box_finalize (GObject* obj);
static void _vala_tweet_list_box_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


TweetListBox* tweet_list_box_construct (GType object_type, gboolean show_placeholder) {
	TweetListBox * self = NULL;
	gboolean _tmp0_ = FALSE;
	self = (TweetListBox*) g_object_new (object_type, NULL);
	_tmp0_ = show_placeholder;
	if (_tmp0_) {
		tweet_list_box_add_placeholder (self);
	}
	return self;
}


TweetListBox* tweet_list_box_new (gboolean show_placeholder) {
	return tweet_list_box_construct (TYPE_TWEET_LIST_BOX, show_placeholder);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean tweet_list_box_button_press_cb (TweetListBox* self, GdkEventButton* evt) {
	gboolean result = FALSE;
	GdkEventButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (IS_TWEET_LIST_BOX (self), FALSE);
	g_return_val_if_fail (evt != NULL, FALSE);
	_tmp0_ = evt;
	_tmp1_ = gdk_event_triggers_context_menu ((GdkEvent*) _tmp0_);
	if (_tmp1_) {
		GdkWindow* event_window = NULL;
		GdkEventButton* _tmp2_ = NULL;
		GdkWindow* _tmp3_ = NULL;
		GdkWindow* _tmp4_ = NULL;
		GdkWindow* window = NULL;
		GdkWindow* _tmp5_ = NULL;
		GdkWindow* _tmp6_ = NULL;
		gdouble relative_y = 0.0;
		GdkEventButton* _tmp7_ = NULL;
		gdouble _tmp8_ = 0.0;
		gdouble parent_y = 0.0;
		GtkWidget* row = NULL;
		gdouble _tmp20_ = 0.0;
		GtkListBoxRow* _tmp21_ = NULL;
		GtkWidget* _tmp22_ = NULL;
		gboolean _tmp23_ = FALSE;
		GtkWidget* _tmp24_ = NULL;
		_tmp2_ = evt;
		_tmp3_ = _tmp2_->window;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		event_window = _tmp4_;
		_tmp5_ = gtk_widget_get_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		_tmp6_ = _g_object_ref0 (_tmp5_);
		window = _tmp6_;
		_tmp7_ = evt;
		_tmp8_ = _tmp7_->y;
		relative_y = _tmp8_;
		while (TRUE) {
			gboolean _tmp9_ = FALSE;
			GdkWindow* _tmp10_ = NULL;
			GdkWindow* _tmp13_ = NULL;
			gdouble _tmp14_ = 0.0;
			gdouble _tmp15_ = 0.0;
			gdouble _tmp16_ = 0.0;
			GdkWindow* _tmp17_ = NULL;
			GdkWindow* _tmp18_ = NULL;
			GdkWindow* _tmp19_ = NULL;
			_tmp10_ = event_window;
			if (_tmp10_ != NULL) {
				GdkWindow* _tmp11_ = NULL;
				GdkWindow* _tmp12_ = NULL;
				_tmp11_ = event_window;
				_tmp12_ = window;
				_tmp9_ = _tmp11_ != _tmp12_;
			} else {
				_tmp9_ = FALSE;
			}
			if (!_tmp9_) {
				break;
			}
			_tmp13_ = event_window;
			_tmp14_ = relative_y;
			gdk_window_coords_to_parent (_tmp13_, (gdouble) 0, _tmp14_, NULL, &_tmp15_);
			parent_y = _tmp15_;
			_tmp16_ = parent_y;
			relative_y = _tmp16_;
			_tmp17_ = event_window;
			_tmp18_ = gdk_window_get_effective_parent (_tmp17_);
			_tmp19_ = _g_object_ref0 (_tmp18_);
			_g_object_unref0 (event_window);
			event_window = _tmp19_;
		}
		_tmp20_ = relative_y;
		_tmp21_ = gtk_list_box_get_row_at_y (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_list_box_get_type (), GtkListBox), (gint) _tmp20_);
		_tmp22_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_widget_get_type (), GtkWidget));
		row = _tmp22_;
		_tmp24_ = row;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, TYPE_TWEET_LIST_ENTRY)) {
			GtkWidget* _tmp25_ = NULL;
			gboolean _tmp26_ = FALSE;
			gboolean _tmp27_ = FALSE;
			_tmp25_ = row;
			_tmp26_ = gtk_widget_get_sensitive (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp23_ = _tmp27_;
		} else {
			_tmp23_ = FALSE;
		}
		if (_tmp23_) {
			TweetListEntry* tle = NULL;
			GtkWidget* _tmp28_ = NULL;
			TweetListEntry* _tmp29_ = NULL;
			gboolean _tmp30_ = FALSE;
			gboolean _tmp31_ = FALSE;
			TweetListEntry* _tmp32_ = NULL;
			TweetListEntry* _tmp33_ = NULL;
			TweetListEntry* _tmp39_ = NULL;
			TweetListEntry* _tmp40_ = NULL;
			gboolean _tmp41_ = FALSE;
			gboolean _tmp42_ = FALSE;
			_tmp28_ = row;
			_tmp29_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, TYPE_TWEET_LIST_ENTRY, TweetListEntry));
			tle = _tmp29_;
			_tmp32_ = tle;
			_tmp33_ = self->priv->_action_entry;
			if (_tmp32_ != _tmp33_) {
				TweetListEntry* _tmp34_ = NULL;
				_tmp34_ = self->priv->_action_entry;
				_tmp31_ = _tmp34_ != NULL;
			} else {
				_tmp31_ = FALSE;
			}
			if (_tmp31_) {
				TweetListEntry* _tmp35_ = NULL;
				gboolean _tmp36_ = FALSE;
				gboolean _tmp37_ = FALSE;
				_tmp35_ = self->priv->_action_entry;
				_tmp36_ = tweet_list_entry_get_shows_actions (_tmp35_);
				_tmp37_ = _tmp36_;
				_tmp30_ = _tmp37_;
			} else {
				_tmp30_ = FALSE;
			}
			if (_tmp30_) {
				TweetListEntry* _tmp38_ = NULL;
				_tmp38_ = self->priv->_action_entry;
				tweet_list_entry_toggle_mode (_tmp38_);
			}
			_tmp39_ = tle;
			tweet_list_entry_toggle_mode (_tmp39_);
			_tmp40_ = tle;
			_tmp41_ = tweet_list_entry_get_shows_actions (_tmp40_);
			_tmp42_ = _tmp41_;
			if (_tmp42_) {
				TweetListEntry* _tmp43_ = NULL;
				TweetListEntry* _tmp44_ = NULL;
				_tmp43_ = tle;
				_tmp44_ = _g_object_ref0 (_tmp43_);
				_g_object_unref0 (self->priv->_action_entry);
				self->priv->_action_entry = _tmp44_;
			} else {
				_g_object_unref0 (self->priv->_action_entry);
				self->priv->_action_entry = NULL;
			}
			result = TRUE;
			_g_object_unref0 (tle);
			_g_object_unref0 (row);
			_g_object_unref0 (window);
			_g_object_unref0 (event_window);
			return result;
		}
		_g_object_unref0 (row);
		_g_object_unref0 (window);
		_g_object_unref0 (event_window);
	}
	result = FALSE;
	return result;
}


static void __lambda30_ (TweetListBox* self) {
	GtkStack* _tmp0_ = NULL;
	_tmp0_ = self->priv->placeholder;
	gtk_stack_set_visible_child_name (_tmp0_, "spinner");
	g_signal_emit_by_name (self, "retry-button-clicked");
}


static void ___lambda30__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda30_ ((TweetListBox*) self);
}


static void tweet_list_box_add_placeholder (TweetListBox* self) {
	GtkStack* _tmp0_ = NULL;
	GtkStack* _tmp1_ = NULL;
	GtkLabel* loading_label = NULL;
	const gchar* _tmp2_ = NULL;
	GtkLabel* _tmp3_ = NULL;
	GtkStyleContext* _tmp4_ = NULL;
	GtkStack* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	GtkLabel* _tmp7_ = NULL;
	GtkLabel* _tmp8_ = NULL;
	GtkStyleContext* _tmp9_ = NULL;
	GtkLabel* _tmp10_ = NULL;
	GtkStack* _tmp11_ = NULL;
	GtkLabel* _tmp12_ = NULL;
	GtkBox* _tmp13_ = NULL;
	GtkLabel* _tmp14_ = NULL;
	GtkLabel* _tmp15_ = NULL;
	GtkStyleContext* _tmp16_ = NULL;
	GtkLabel* _tmp17_ = NULL;
	GtkLabel* _tmp18_ = NULL;
	GtkLabel* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	GtkButton* _tmp21_ = NULL;
	GtkButton* _tmp22_ = NULL;
	GtkButton* _tmp23_ = NULL;
	GtkBox* _tmp24_ = NULL;
	GtkLabel* _tmp25_ = NULL;
	GtkBox* _tmp26_ = NULL;
	GtkButton* _tmp27_ = NULL;
	GtkStack* _tmp28_ = NULL;
	GtkBox* _tmp29_ = NULL;
	GtkStack* _tmp30_ = NULL;
	GtkStack* _tmp31_ = NULL;
	GtkStack* _tmp32_ = NULL;
	GtkStack* _tmp33_ = NULL;
	GtkStack* _tmp34_ = NULL;
	g_return_if_fail (IS_TWEET_LIST_BOX (self));
	_tmp0_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->placeholder);
	self->priv->placeholder = _tmp0_;
	_tmp1_ = self->priv->placeholder;
	gtk_stack_set_transition_type (_tmp1_, GTK_STACK_TRANSITION_TYPE_CROSSFADE);
	_tmp2_ = _ ("Loading...");
	_tmp3_ = (GtkLabel*) gtk_label_new (_tmp2_);
	g_object_ref_sink (_tmp3_);
	loading_label = _tmp3_;
	_tmp4_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (loading_label, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp4_, "dim-label");
	_tmp5_ = self->priv->placeholder;
	gtk_stack_add_named (_tmp5_, G_TYPE_CHECK_INSTANCE_CAST (loading_label, gtk_widget_get_type (), GtkWidget), "spinner");
	_tmp6_ = _ ("No entries found");
	_tmp7_ = (GtkLabel*) gtk_label_new (_tmp6_);
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->no_entries_label);
	self->priv->no_entries_label = _tmp7_;
	_tmp8_ = self->priv->no_entries_label;
	_tmp9_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp9_, "dim-label");
	_tmp10_ = self->priv->no_entries_label;
	g_object_set (_tmp10_, "wrap-mode", PANGO_WRAP_WORD_CHAR, NULL);
	_tmp11_ = self->priv->placeholder;
	_tmp12_ = self->priv->no_entries_label;
	gtk_stack_add_named (_tmp11_, G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_widget_get_type (), GtkWidget), "no-entries");
	_tmp13_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 12);
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->priv->error_box);
	self->priv->error_box = _tmp13_;
	_tmp14_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp14_);
	_g_object_unref0 (self->priv->error_label);
	self->priv->error_label = _tmp14_;
	_tmp15_ = self->priv->error_label;
	_tmp16_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp16_, "dim-label");
	_tmp17_ = self->priv->error_label;
	g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_widget_get_type (), GtkWidget), "margin", 12, NULL);
	_tmp18_ = self->priv->error_label;
	gtk_label_set_selectable (_tmp18_, TRUE);
	_tmp19_ = self->priv->error_label;
	g_object_set (_tmp19_, "wrap", TRUE, NULL);
	_tmp20_ = _ ("Retry");
	_tmp21_ = (GtkButton*) gtk_button_new_with_label (_tmp20_);
	g_object_ref_sink (_tmp21_);
	_g_object_unref0 (self->priv->retry_button);
	self->priv->retry_button = _tmp21_;
	_tmp22_ = self->priv->retry_button;
	gtk_widget_set_halign (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_CENTER);
	_tmp23_ = self->priv->retry_button;
	g_signal_connect_object (_tmp23_, "clicked", (GCallback) ___lambda30__gtk_button_clicked, self, 0);
	_tmp24_ = self->priv->error_box;
	_tmp25_ = self->priv->error_label;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, gtk_widget_get_type (), GtkWidget));
	_tmp26_ = self->priv->error_box;
	_tmp27_ = self->priv->retry_button;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, gtk_widget_get_type (), GtkWidget));
	_tmp28_ = self->priv->placeholder;
	_tmp29_ = self->priv->error_box;
	gtk_stack_add_named (_tmp28_, G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, gtk_widget_get_type (), GtkWidget), "error");
	_tmp30_ = self->priv->placeholder;
	gtk_stack_set_visible_child_name (_tmp30_, "spinner");
	_tmp31_ = self->priv->placeholder;
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, gtk_widget_get_type (), GtkWidget));
	_tmp32_ = self->priv->placeholder;
	gtk_widget_set_valign (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_CENTER);
	_tmp33_ = self->priv->placeholder;
	gtk_widget_set_halign (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_CENTER);
	_tmp34_ = self->priv->placeholder;
	gtk_list_box_set_placeholder (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_list_box_get_type (), GtkListBox), G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (loading_label);
}


void tweet_list_box_set_empty (TweetListBox* self) {
	GtkStack* _tmp0_ = NULL;
	g_return_if_fail (IS_TWEET_LIST_BOX (self));
	_tmp0_ = self->priv->placeholder;
	gtk_stack_set_visible_child_name (_tmp0_, "no-entries");
}


void tweet_list_box_set_unempty (TweetListBox* self) {
	GtkStack* _tmp0_ = NULL;
	g_return_if_fail (IS_TWEET_LIST_BOX (self));
	_tmp0_ = self->priv->placeholder;
	gtk_stack_set_visible_child_name (_tmp0_, "spinner");
}


void tweet_list_box_set_error (TweetListBox* self, const gchar* err_msg) {
	GtkLabel* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkStack* _tmp2_ = NULL;
	g_return_if_fail (IS_TWEET_LIST_BOX (self));
	g_return_if_fail (err_msg != NULL);
	_tmp0_ = self->priv->error_label;
	_tmp1_ = err_msg;
	gtk_label_set_label (_tmp0_, _tmp1_);
	_tmp2_ = self->priv->placeholder;
	gtk_stack_set_visible_child_name (_tmp2_, "error");
}


GtkStack* tweet_list_box_get_placeholder (TweetListBox* self) {
	GtkStack* result = NULL;
	GtkStack* _tmp0_ = NULL;
	GtkStack* _tmp1_ = NULL;
	g_return_val_if_fail (IS_TWEET_LIST_BOX (self), NULL);
	_tmp0_ = self->priv->placeholder;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


void tweet_list_box_set_placeholder_text (TweetListBox* self, const gchar* text) {
	GtkLabel* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (IS_TWEET_LIST_BOX (self));
	g_return_if_fail (text != NULL);
	_tmp0_ = self->priv->no_entries_label;
	_tmp1_ = text;
	gtk_label_set_label (_tmp0_, _tmp1_);
}


void tweet_list_box_reset_placeholder_text (TweetListBox* self) {
	GtkLabel* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (IS_TWEET_LIST_BOX (self));
	_tmp0_ = self->priv->no_entries_label;
	_tmp1_ = _ ("No entries found");
	gtk_label_set_label (_tmp0_, _tmp1_);
}


static void __lambda31_ (TweetListBox* self, GtkWidget* w) {
	GtkWidget* _tmp0_ = NULL;
	g_return_if_fail (GTK_IS_WIDGET (w));
	_tmp0_ = w;
	gtk_container_remove (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), _tmp0_);
}


static void ___lambda31__gtk_callback (GtkWidget* widget, gpointer self) {
	__lambda31_ ((TweetListBox*) self, widget);
}


void tweet_list_box_remove_all (TweetListBox* self) {
	g_return_if_fail (IS_TWEET_LIST_BOX (self));
	gtk_container_foreach (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), ___lambda31__gtk_callback, self);
}


GtkWidget* tweet_list_box_get_first_visible_row (TweetListBox* self) {
	GtkWidget* result = NULL;
	gint i = 0;
	GtkWidget* row = NULL;
	GtkListBoxRow* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	g_return_val_if_fail (IS_TWEET_LIST_BOX (self), NULL);
	i = 0;
	_tmp0_ = gtk_list_box_get_row_at_index (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_list_box_get_type (), GtkListBox), 0);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget));
	row = _tmp1_;
	while (TRUE) {
		gboolean _tmp2_ = FALSE;
		GtkWidget* _tmp3_ = NULL;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		GtkListBoxRow* _tmp9_ = NULL;
		GtkWidget* _tmp10_ = NULL;
		_tmp3_ = row;
		if (_tmp3_ != NULL) {
			GtkWidget* _tmp4_ = NULL;
			gboolean _tmp5_ = FALSE;
			gboolean _tmp6_ = FALSE;
			_tmp4_ = row;
			_tmp5_ = gtk_widget_get_visible (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp2_ = !_tmp6_;
		} else {
			_tmp2_ = FALSE;
		}
		if (!_tmp2_) {
			break;
		}
		_tmp7_ = i;
		i = _tmp7_ + 1;
		_tmp8_ = i;
		_tmp9_ = gtk_list_box_get_row_at_index (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_list_box_get_type (), GtkListBox), _tmp8_);
		_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget));
		_g_object_unref0 (row);
		row = _tmp10_;
	}
	result = row;
	return result;
}


TweetListEntry* tweet_list_box_get_action_entry (TweetListBox* self) {
	TweetListEntry* result;
	TweetListEntry* _tmp0_ = NULL;
	g_return_val_if_fail (IS_TWEET_LIST_BOX (self), NULL);
	_tmp0_ = self->priv->_action_entry;
	result = _tmp0_;
	return result;
}


static gboolean _tweet_list_box_button_press_cb_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = tweet_list_box_button_press_cb ((TweetListBox*) self, event);
	return result;
}


static GtkWidget* _tweet_list_box___lambda32_ (TweetListBox* self, GObject* obj) {
	GtkWidget* result = NULL;
	GObject* _tmp0_ = NULL;
	TweetListEntry* row = NULL;
	GObject* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	Account* _tmp3_ = NULL;
	TweetListEntry* _tmp4_ = NULL;
	DeltaUpdater* _tmp5_ = NULL;
	TweetListEntry* _tmp6_ = NULL;
	TweetListEntry* _tmp7_ = NULL;
	g_return_val_if_fail (G_IS_OBJECT (obj), NULL);
	_tmp0_ = obj;
	_vala_assert (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, CB_TYPE_TWEET), "obj is Cb.Tweet");
	_tmp1_ = obj;
	_tmp2_ = gtk_widget_get_toplevel (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp3_ = self->account;
	_tmp4_ = tweet_list_entry_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, CB_TYPE_TWEET, CbTweet), G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_MAIN_WINDOW, MainWindow), _tmp3_, FALSE);
	g_object_ref_sink (_tmp4_);
	row = _tmp4_;
	_tmp5_ = self->delta_updater;
	_tmp6_ = row;
	delta_updater_add (_tmp5_, G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_ITWITTER_ITEM, ITwitterItem));
	_tmp7_ = row;
	tweet_list_entry_fade_in (_tmp7_);
	result = G_TYPE_CHECK_INSTANCE_CAST (row, gtk_widget_get_type (), GtkWidget);
	return result;
}


static GtkWidget* __tweet_list_box___lambda32__gtk_list_box_create_widget_func (GObject* item, gpointer self) {
	GtkWidget* result;
	result = _tweet_list_box___lambda32_ ((TweetListBox*) self, item);
	return result;
}


static GObject * tweet_list_box_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	TweetListBox * self;
	GSettings* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	TweetModel* _tmp2_ = NULL;
	parent_class = G_OBJECT_CLASS (tweet_list_box_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TWEET_LIST_BOX, TweetListBox);
	tweet_list_box_add_placeholder (self);
	gtk_list_box_set_selection_mode (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_list_box_get_type (), GtkListBox), GTK_SELECTION_NONE);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "button-press-event", (GCallback) _tweet_list_box_button_press_cb_gtk_widget_button_press_event, self, 0);
	_tmp0_ = settings_get ();
	_tmp1_ = _tmp0_;
	g_settings_bind (_tmp1_, "double-click-activation", G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), "activate-on-single-click", G_SETTINGS_BIND_INVERT_BOOLEAN);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = self->model;
	gtk_list_box_bind_model (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_list_box_get_type (), GtkListBox), G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, g_list_model_get_type (), GListModel), __tweet_list_box___lambda32__gtk_list_box_create_widget_func, g_object_ref (self), g_object_unref);
	return obj;
}


static void tweet_list_box_class_init (TweetListBoxClass * klass) {
	tweet_list_box_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TweetListBoxPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_tweet_list_box_get_property;
	G_OBJECT_CLASS (klass)->constructor = tweet_list_box_constructor;
	G_OBJECT_CLASS (klass)->finalize = tweet_list_box_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TWEET_LIST_BOX_ACTION_ENTRY, g_param_spec_object ("action-entry", "action-entry", "action-entry", TYPE_TWEET_LIST_ENTRY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("retry_button_clicked", TYPE_TWEET_LIST_BOX, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void tweet_list_box_instance_init (TweetListBox * self) {
	TweetModel* _tmp0_ = NULL;
	self->priv = TWEET_LIST_BOX_GET_PRIVATE (self);
	self->priv->placeholder = NULL;
	_tmp0_ = tweet_model_new ();
	self->model = _tmp0_;
}


static void tweet_list_box_finalize (GObject* obj) {
	TweetListBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TWEET_LIST_BOX, TweetListBox);
	_g_object_unref0 (self->priv->placeholder);
	_g_object_unref0 (self->priv->no_entries_label);
	_g_object_unref0 (self->priv->error_box);
	_g_object_unref0 (self->priv->error_label);
	_g_object_unref0 (self->priv->retry_button);
	_g_object_unref0 (self->priv->_action_entry);
	_g_object_unref0 (self->model);
	G_OBJECT_CLASS (tweet_list_box_parent_class)->finalize (obj);
}


GType tweet_list_box_get_type (void) {
	static volatile gsize tweet_list_box_type_id__volatile = 0;
	if (g_once_init_enter (&tweet_list_box_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TweetListBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tweet_list_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TweetListBox), 0, (GInstanceInitFunc) tweet_list_box_instance_init, NULL };
		GType tweet_list_box_type_id;
		tweet_list_box_type_id = g_type_register_static (gtk_list_box_get_type (), "TweetListBox", &g_define_type_info, 0);
		g_once_init_leave (&tweet_list_box_type_id__volatile, tweet_list_box_type_id);
	}
	return tweet_list_box_type_id__volatile;
}


static void _vala_tweet_list_box_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TweetListBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TWEET_LIST_BOX, TweetListBox);
	switch (property_id) {
		case TWEET_LIST_BOX_ACTION_ENTRY:
		g_value_set_object (value, tweet_list_box_get_action_entry (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



