/* ProfilePage.c generated by valac 0.36.4, the Vala compiler
 * generated from ProfilePage.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "CbBundle.h"
#include <stdlib.h>
#include <string.h>
#include "CbMessageReceiver.h"
#include <gio/gio.h>
#include <json-glib/json-glib.h>
#include "CbDeltaUpdater.h"
#include "CbTweetModel.h"
#include "CbTwitterItem.h"
#include "CbTweet.h"
#include "rest/oauth-proxy.h"
#include "CbUserStream.h"
#include "CbUserCounter.h"
#include "CbFilter.h"
#include <gdk-pixbuf/gdk-pixbuf.h>
#include "CbTypes.h"
#include "rest/rest-proxy-call.h"
#include "rest/rest-proxy.h"
#include "CbUtils.h"
#include <cairo.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include "CbTextTransform.h"


#define TYPE_SCROLL_WIDGET (scroll_widget_get_type ())
#define SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCROLL_WIDGET, ScrollWidget))
#define SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCROLL_WIDGET, ScrollWidgetClass))
#define IS_SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCROLL_WIDGET))
#define IS_SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCROLL_WIDGET))
#define SCROLL_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCROLL_WIDGET, ScrollWidgetClass))

typedef struct _ScrollWidget ScrollWidget;
typedef struct _ScrollWidgetClass ScrollWidgetClass;
typedef struct _ScrollWidgetPrivate ScrollWidgetPrivate;

#define TYPE_IPAGE (ipage_get_type ())
#define IPAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IPAGE, IPage))
#define IS_IPAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IPAGE))
#define IPAGE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IPAGE, IPageIface))

typedef struct _IPage IPage;
typedef struct _IPageIface IPageIface;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_PROFILE_PAGE (profile_page_get_type ())
#define PROFILE_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROFILE_PAGE, ProfilePage))
#define PROFILE_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROFILE_PAGE, ProfilePageClass))
#define IS_PROFILE_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROFILE_PAGE))
#define IS_PROFILE_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROFILE_PAGE))
#define PROFILE_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROFILE_PAGE, ProfilePageClass))

typedef struct _ProfilePage ProfilePage;
typedef struct _ProfilePageClass ProfilePageClass;
typedef struct _ProfilePagePrivate ProfilePagePrivate;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_ASPECT_IMAGE (aspect_image_get_type ())
#define ASPECT_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASPECT_IMAGE, AspectImage))
#define ASPECT_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASPECT_IMAGE, AspectImageClass))
#define IS_ASPECT_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASPECT_IMAGE))
#define IS_ASPECT_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASPECT_IMAGE))
#define ASPECT_IMAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASPECT_IMAGE, AspectImageClass))

typedef struct _AspectImage AspectImage;
typedef struct _AspectImageClass AspectImageClass;

#define TYPE_AVATAR_WIDGET (avatar_widget_get_type ())
#define AVATAR_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AVATAR_WIDGET, AvatarWidget))
#define AVATAR_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AVATAR_WIDGET, AvatarWidgetClass))
#define IS_AVATAR_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AVATAR_WIDGET))
#define IS_AVATAR_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AVATAR_WIDGET))
#define AVATAR_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AVATAR_WIDGET, AvatarWidgetClass))

typedef struct _AvatarWidget AvatarWidget;
typedef struct _AvatarWidgetClass AvatarWidgetClass;

#define TYPE_FOLLOW_BUTTON (follow_button_get_type ())
#define FOLLOW_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FOLLOW_BUTTON, FollowButton))
#define FOLLOW_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FOLLOW_BUTTON, FollowButtonClass))
#define IS_FOLLOW_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FOLLOW_BUTTON))
#define IS_FOLLOW_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FOLLOW_BUTTON))
#define FOLLOW_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FOLLOW_BUTTON, FollowButtonClass))

typedef struct _FollowButton FollowButton;
typedef struct _FollowButtonClass FollowButtonClass;

#define TYPE_TWEET_LIST_BOX (tweet_list_box_get_type ())
#define TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_BOX, TweetListBox))
#define TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_BOX, TweetListBoxClass))
#define IS_TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_BOX))
#define IS_TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_BOX))
#define TWEET_LIST_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_BOX, TweetListBoxClass))

typedef struct _TweetListBox TweetListBox;
typedef struct _TweetListBoxClass TweetListBoxClass;

#define TYPE_USER_LISTS_WIDGET (user_lists_widget_get_type ())
#define USER_LISTS_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_LISTS_WIDGET, UserListsWidget))
#define USER_LISTS_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_LISTS_WIDGET, UserListsWidgetClass))
#define IS_USER_LISTS_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_LISTS_WIDGET))
#define IS_USER_LISTS_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_LISTS_WIDGET))
#define USER_LISTS_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_LISTS_WIDGET, UserListsWidgetClass))

typedef struct _UserListsWidget UserListsWidget;
typedef struct _UserListsWidgetClass UserListsWidgetClass;

#define TYPE_CURSOR (cursor_get_type ())
typedef struct _Cursor Cursor;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cursor_free0(var) ((var == NULL) ? NULL : (var = (cursor_free (var), NULL)))
typedef struct _TweetListBoxPrivate TweetListBoxPrivate;

#define TYPE_TWEET_LIST_ENTRY (tweet_list_entry_get_type ())
#define TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntry))
#define TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))
#define IS_TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_ENTRY))
#define IS_TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_ENTRY))
#define TWEET_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))

typedef struct _TweetListEntry TweetListEntry;
typedef struct _TweetListEntryClass TweetListEntryClass;
typedef struct _TweetListEntryPrivate TweetListEntryPrivate;
typedef struct _MainWindowPrivate MainWindowPrivate;

#define TYPE_MAIN_WIDGET (main_widget_get_type ())
#define MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WIDGET, MainWidget))
#define MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WIDGET, MainWidgetClass))
#define IS_MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WIDGET))
#define IS_MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WIDGET))
#define MAIN_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WIDGET, MainWidgetClass))

typedef struct _MainWidget MainWidget;
typedef struct _MainWidgetClass MainWidgetClass;

#define TYPE_PAGE (page_get_type ())

#define TYPE_USER_LIST_ENTRY (user_list_entry_get_type ())
#define USER_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_LIST_ENTRY, UserListEntry))
#define USER_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_LIST_ENTRY, UserListEntryClass))
#define IS_USER_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_LIST_ENTRY))
#define IS_USER_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_LIST_ENTRY))
#define USER_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_LIST_ENTRY, UserListEntryClass))

typedef struct _UserListEntry UserListEntry;
typedef struct _UserListEntryClass UserListEntryClass;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _AccountPrivate AccountPrivate;

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define TYPE_NOTIFICATION_MANAGER (notification_manager_get_type ())
#define NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManager))
#define NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))
#define IS_NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATION_MANAGER))
#define IS_NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATION_MANAGER))
#define NOTIFICATION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))

typedef struct _NotificationManager NotificationManager;
typedef struct _NotificationManagerClass NotificationManagerClass;
typedef struct _ProfilePageLoadFriendshipData ProfilePageLoadFriendshipData;
typedef struct _Block23Data Block23Data;
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
typedef struct _ProfilePageLoadProfileDataData ProfilePageLoadProfileDataData;
typedef struct _ProfilePageLoadTweetsData ProfilePageLoadTweetsData;
typedef struct _ProfilePageLoadOlderTweetsData ProfilePageLoadOlderTweetsData;
typedef struct _ProfilePageLoadFollowersData ProfilePageLoadFollowersData;
typedef struct _ProfilePageLoadFollowingData ProfilePageLoadFollowingData;
typedef struct _Block24Data Block24Data;

#define TYPE_DEFAULT_TIMELINE (default_timeline_get_type ())
#define DEFAULT_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEFAULT_TIMELINE, DefaultTimeline))
#define DEFAULT_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEFAULT_TIMELINE, DefaultTimelineClass))
#define IS_DEFAULT_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEFAULT_TIMELINE))
#define IS_DEFAULT_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEFAULT_TIMELINE))
#define DEFAULT_TIMELINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEFAULT_TIMELINE, DefaultTimelineClass))

typedef struct _DefaultTimeline DefaultTimeline;
typedef struct _DefaultTimelineClass DefaultTimelineClass;

#define TYPE_HOME_TIMELINE (home_timeline_get_type ())
#define HOME_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HOME_TIMELINE, HomeTimeline))
#define HOME_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HOME_TIMELINE, HomeTimelineClass))
#define IS_HOME_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HOME_TIMELINE))
#define IS_HOME_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HOME_TIMELINE))
#define HOME_TIMELINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HOME_TIMELINE, HomeTimelineClass))

typedef struct _HomeTimeline HomeTimeline;
typedef struct _HomeTimelineClass HomeTimelineClass;

#define TYPE_COMPOSE_TWEET_WINDOW (compose_tweet_window_get_type ())
#define COMPOSE_TWEET_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindow))
#define COMPOSE_TWEET_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindowClass))
#define IS_COMPOSE_TWEET_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPOSE_TWEET_WINDOW))
#define IS_COMPOSE_TWEET_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPOSE_TWEET_WINDOW))
#define COMPOSE_TWEET_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindowClass))

typedef struct _ComposeTweetWindow ComposeTweetWindow;
typedef struct _ComposeTweetWindowClass ComposeTweetWindowClass;

#define COMPOSE_TWEET_WINDOW_TYPE_MODE (compose_tweet_window_mode_get_type ())

#define TYPE_USER_LIST_DIALOG (user_list_dialog_get_type ())
#define USER_LIST_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_LIST_DIALOG, UserListDialog))
#define USER_LIST_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_LIST_DIALOG, UserListDialogClass))
#define IS_USER_LIST_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_LIST_DIALOG))
#define IS_USER_LIST_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_LIST_DIALOG))
#define USER_LIST_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_LIST_DIALOG, UserListDialogClass))

typedef struct _UserListDialog UserListDialog;
typedef struct _UserListDialogClass UserListDialogClass;
typedef struct _Block25Data Block25Data;
typedef struct _Block26Data Block26Data;
typedef struct _Block27Data Block27Data;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

struct _ScrollWidget {
	GtkScrolledWindow parent_instance;
	ScrollWidgetPrivate * priv;
};

struct _ScrollWidgetClass {
	GtkScrolledWindowClass parent_class;
};

struct _IPageIface {
	GTypeInterface parent_iface;
	void (*on_join) (IPage* self, gint page_id, CbBundle* args);
	void (*on_leave) (IPage* self);
	void (*create_radio_button) (IPage* self, GtkRadioButton* group);
	GtkRadioButton* (*get_radio_button) (IPage* self);
	gchar* (*get_title) (IPage* self);
	gboolean (*handles_double_open) (IPage* self);
	void (*double_open) (IPage* self);
	gint (*get_id) (IPage* self);
	void (*set_id) (IPage* self, gint value);
	void (*set_window) (IPage* self, MainWindow* value);
};

struct _ProfilePage {
	ScrollWidget parent_instance;
	ProfilePagePrivate * priv;
	Account* account;
};

struct _ProfilePageClass {
	ScrollWidgetClass parent_class;
};

struct _Cursor {
	gint64 next_cursor;
	gboolean full;
	JsonNode* json_object;
};

struct _ProfilePagePrivate {
	MainWindow* main_window;
	gint _id;
	AspectImage* banner_image;
	AvatarWidget* avatar_image;
	GtkLabel* name_label;
	GtkLabel* screen_name_label;
	GtkLabel* description_label;
	GtkLabel* url_label;
	GtkLabel* tweets_label;
	GtkLabel* following_label;
	GtkLabel* followers_label;
	GtkLabel* location_label;
	FollowButton* follow_button;
	TweetListBox* tweet_list;
	TweetListBox* followers_list;
	TweetListBox* following_list;
	GtkSpinner* progress_spinner;
	GtkLabel* follows_you_label;
	UserListsWidget* user_lists;
	GtkStack* user_stack;
	GtkMenuButton* more_button;
	GtkStack* loading_stack;
	GtkRadioButton* tweets_button;
	gint64 user_id;
	gchar* name;
	gchar* screen_name;
	gchar* avatar_url;
	gint follower_count;
	GCancellable* data_cancellable;
	gboolean lists_page_inited;
	gboolean block_item_blocked;
	gboolean retweet_item_blocked;
	gboolean mute_item_blocked;
	gboolean tweets_loading;
	gboolean followers_loading;
	Cursor* followers_cursor;
	gboolean following_loading;
	Cursor* following_cursor;
	GSimpleActionGroup* actions;
};

struct _TweetListBox {
	GtkListBox parent_instance;
	TweetListBoxPrivate * priv;
	CbDeltaUpdater* delta_updater;
	Account* account;
	CbTweetModel* model;
};

struct _TweetListBoxClass {
	GtkListBoxClass parent_class;
};

struct _TweetListEntry {
	GtkListBoxRow parent_instance;
	TweetListEntryPrivate * priv;
	CbTweet* tweet;
};

struct _TweetListEntryClass {
	GtkListBoxRowClass parent_class;
};

struct _MainWindow {
	GtkApplicationWindow parent_instance;
	MainWindowPrivate * priv;
	GtkButton* back_button;
	GtkToggleButton* compose_tweet_button;
	MainWidget* main_widget;
	Account* account;
};

struct _MainWindowClass {
	GtkApplicationWindowClass parent_class;
};

typedef enum  {
	PAGE_STREAM = 0,
	PAGE_MENTIONS,
	PAGE_FAVORITES,
	PAGE_DM_THREADS,
	PAGE_LISTS,
	PAGE_FILTERS,
	PAGE_SEARCH,
	PAGE_PROFILE,
	PAGE_TWEET_INFO,
	PAGE_DM,
	PAGE_LIST_STATUSES,
	PAGE_PREVIOUS = 1024,
	PAGE_NEXT = 2048
} Page;

struct _Account {
	GObject parent_instance;
	AccountPrivate * priv;
	gint64 id;
	SqlDatabase* db;
	gchar* screen_name;
	gchar* name;
	gchar* avatar_url;
	gchar* banner_url;
	gchar* website;
	gchar* description;
	OAuthProxy* proxy;
	CbUserStream* user_stream;
	CbUserCounter* user_counter;
	NotificationManager* notifications;
	gint64* friends;
	gint friends_length1;
	gint64* blocked;
	gint blocked_length1;
	gint64* muted;
	gint muted_length1;
	gint64* disabled_rts;
	gint disabled_rts_length1;
	GPtrArray* filters;
};

struct _AccountClass {
	GObjectClass parent_class;
};

struct _ProfilePageLoadFriendshipData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ProfilePage* self;
	Account* _tmp0_;
	gint64 _tmp1_;
	gboolean _tmp2_;
	Account* _tmp3_;
	gint64 _tmp4_;
	gboolean _tmp5_;
	GSimpleActionGroup* _tmp6_;
	GAction* _tmp7_;
	GSimpleActionGroup* _tmp8_;
	GAction* _tmp9_;
	gint64 _tmp10_;
	Account* _tmp11_;
	gint64 _tmp12_;
	GSimpleActionGroup* _tmp13_;
	GAction* _tmp14_;
	gint64 _tmp15_;
	Account* _tmp16_;
	gint64 _tmp17_;
	GSimpleActionGroup* _tmp18_;
	GAction* _tmp19_;
	gint64 _tmp20_;
	Account* _tmp21_;
	gint64 _tmp22_;
	GSimpleActionGroup* _tmp23_;
	GAction* _tmp24_;
	gint64 _tmp25_;
	Account* _tmp26_;
	gint64 _tmp27_;
	guint fr;
	Account* _tmp28_;
	gint64 _tmp29_;
	guint _tmp30_;
	GtkLabel* _tmp31_;
	guint _tmp32_;
	guint _tmp33_;
	gboolean _tmp34_;
	guint _tmp35_;
	guint _tmp36_;
	guint _tmp37_;
	GSimpleActionGroup* _tmp38_;
	GAction* _tmp39_;
	GSimpleActionGroup* _tmp40_;
	GAction* _tmp41_;
	guint _tmp42_;
};

struct _Block23Data {
	int _ref_count_;
	ProfilePage* self;
	gint scale;
	CbTextEntity* text_urls;
	gint text_urls_length1;
	gint _text_urls_size_;
	gpointer _async_data_;
};

struct _ProfilePageLoadProfileDataData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ProfilePage* self;
	gint64 user_id;
	Block23Data* _data23_;
	FollowButton* _tmp0_;
	RestProxyCall* call;
	Account* _tmp1_;
	OAuthProxy* _tmp2_;
	RestProxyCall* _tmp3_;
	RestProxyCall* _tmp4_;
	RestProxyCall* _tmp5_;
	RestProxyCall* _tmp6_;
	gint64 _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	RestProxyCall* _tmp10_;
	JsonNode* root_node;
	JsonNode* _tmp11_;
	RestProxyCall* _tmp12_;
	GCancellable* _tmp13_;
	JsonNode* _tmp14_;
	JsonNode* _tmp15_;
	GError* e;
	GError* _tmp16_;
	const gchar* _tmp17_;
	JsonNode* _tmp18_;
	JsonObject* root;
	JsonNode* _tmp19_;
	JsonObject* _tmp20_;
	JsonObject* _tmp21_;
	gint64 id;
	JsonObject* _tmp22_;
	gint64 _tmp23_;
	gchar* avatar_url;
	JsonObject* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	gint _tmp27_;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	const gchar* _tmp30_;
	gint _tmp31_;
	GCancellable* _tmp32_;
	gchar* name;
	JsonObject* _tmp33_;
	const gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* screen_name;
	JsonObject* _tmp39_;
	const gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* description;
	JsonObject* _tmp42_;
	const gchar* _tmp43_;
	gchar* _tmp44_;
	gint followers;
	JsonObject* _tmp45_;
	gint64 _tmp46_;
	gint following;
	JsonObject* _tmp47_;
	gint64 _tmp48_;
	gint tweets;
	JsonObject* _tmp49_;
	gint64 _tmp50_;
	gboolean is_following;
	JsonObject* _tmp51_;
	gboolean _tmp52_;
	JsonObject* _tmp53_;
	gboolean _tmp54_;
	gboolean has_url;
	JsonObject* _tmp55_;
	JsonObject* _tmp56_;
	gboolean _tmp57_;
	gboolean verified;
	JsonObject* _tmp58_;
	gboolean _tmp59_;
	gboolean protected_user;
	JsonObject* _tmp60_;
	gboolean _tmp61_;
	gboolean _tmp62_;
	TweetListBox* _tmp63_;
	gchar* color;
	JsonObject* _tmp64_;
	const gchar* _tmp65_;
	gchar* _tmp66_;
	AspectImage* _tmp67_;
	const gchar* _tmp68_;
	gchar* _tmp69_;
	gchar* _tmp70_;
	JsonObject* _tmp71_;
	gboolean _tmp72_;
	gchar* banner_base_url;
	JsonObject* _tmp73_;
	const gchar* _tmp74_;
	gchar* _tmp75_;
	const gchar* _tmp76_;
	gchar* display_url;
	gchar* _tmp77_;
	JsonObject* entities;
	JsonObject* _tmp78_;
	JsonObject* _tmp79_;
	JsonObject* _tmp80_;
	gboolean _tmp81_;
	JsonObject* urls_object;
	JsonObject* _tmp82_;
	JsonObject* _tmp83_;
	JsonArray* _tmp84_;
	JsonNode* _tmp85_;
	JsonObject* _tmp86_;
	JsonObject* _tmp87_;
	gchar* url;
	JsonObject* _tmp88_;
	const gchar* _tmp89_;
	gchar* _tmp90_;
	JsonObject* _tmp91_;
	gboolean _tmp92_;
	JsonObject* _tmp93_;
	const gchar* _tmp94_;
	gchar* _tmp95_;
	JsonObject* _tmp96_;
	const gchar* _tmp97_;
	gchar* _tmp98_;
	const gchar* _tmp99_;
	gchar* _tmp100_;
	gchar* location;
	JsonObject* _tmp101_;
	gboolean _tmp102_;
	JsonObject* _tmp103_;
	const gchar* _tmp104_;
	gchar* _tmp105_;
	JsonObject* _tmp106_;
	gboolean _tmp107_;
	JsonArray* urls;
	JsonObject* _tmp108_;
	JsonObject* _tmp109_;
	JsonArray* _tmp110_;
	JsonArray* _tmp111_;
	JsonArray* _tmp112_;
	guint _tmp113_;
	CbTextEntity* _tmp114_;
	JsonArray* _tmp115_;
	Account* _tmp116_;
	CbUserCounter* _tmp117_;
	gint64 _tmp118_;
	const gchar* _tmp119_;
	const gchar* _tmp120_;
	FollowButton* _tmp121_;
	gboolean _tmp122_;
	FollowButton* _tmp123_;
	gint64 _tmp124_;
	Account* _tmp125_;
	gint64 _tmp126_;
	GMenu* section;
	GtkMenuButton* _tmp127_;
	GMenuModel* _tmp128_;
	GMenuModel* _tmp129_;
	GMenuModel* _tmp130_;
	GMenuItem* user_item;
	const gchar* _tmp131_;
	gchar* _tmp132_;
	gchar* _tmp133_;
	gchar* _tmp134_;
	gchar* _tmp135_;
	GMenuItem* _tmp136_;
	GMenuItem* _tmp137_;
	GMenu* _tmp138_;
	GMenu* _tmp139_;
	GMenuItem* _tmp140_;
	GtkLabel* _tmp141_;
	const gchar* _tmp142_;
	gchar* _tmp143_;
	gchar* _tmp144_;
	GtkLabel* _tmp145_;
	const gchar* _tmp146_;
	gchar* _tmp147_;
	gchar* _tmp148_;
	gchar* desc;
	const gchar* _tmp149_;
	gchar* _tmp150_;
	CbTextEntity* _tmp151_;
	gint _tmp151__length1;
	const gchar* _tmp152_;
	CbTextEntity* _tmp153_;
	gint _tmp153__length1;
	gchar* _tmp154_;
	gint _tmp155_;
	GtkLabel* _tmp156_;
	const gchar* _tmp157_;
	gchar* _tmp158_;
	gchar* _tmp159_;
	gchar* _tmp160_;
	gchar* _tmp161_;
	GtkLabel* _tmp162_;
	gint _tmp163_;
	gchar* _tmp164_;
	gchar* _tmp165_;
	GtkLabel* _tmp166_;
	gint _tmp167_;
	gchar* _tmp168_;
	gchar* _tmp169_;
	gboolean _tmp170_;
	const gchar* _tmp171_;
	const gchar* _tmp172_;
	GtkLabel* _tmp173_;
	GtkLabel* _tmp174_;
	const gchar* _tmp175_;
	GtkLabel* _tmp176_;
	AvatarWidget* _tmp177_;
	gboolean _tmp178_;
	const gchar* _tmp179_;
	gint _tmp180_;
	gint _tmp181_;
	GtkLabel* _tmp182_;
	GtkLabel* _tmp183_;
	const gchar* _tmp184_;
	const gchar* _tmp185_;
	gchar* _tmp186_;
	gchar* _tmp187_;
	GtkLabel* _tmp188_;
	GtkLabel* _tmp189_;
	GtkLabel* _tmp190_;
	const gchar* _tmp191_;
	gchar* _tmp192_;
	const gchar* _tmp193_;
	gchar* _tmp194_;
	const gchar* _tmp195_;
	gchar* _tmp196_;
	GError * _inner_error_;
};

struct _ProfilePageLoadTweetsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ProfilePage* self;
	TweetListBox* _tmp0_;
	gint requested_tweet_count;
	RestProxyCall* call;
	Account* _tmp1_;
	OAuthProxy* _tmp2_;
	RestProxyCall* _tmp3_;
	RestProxyCall* _tmp4_;
	RestProxyCall* _tmp5_;
	RestProxyCall* _tmp6_;
	gint64 _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	RestProxyCall* _tmp10_;
	gint _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	RestProxyCall* _tmp14_;
	RestProxyCall* _tmp15_;
	RestProxyCall* _tmp16_;
	JsonNode* root;
	JsonNode* _tmp17_;
	RestProxyCall* _tmp18_;
	GCancellable* _tmp19_;
	JsonNode* _tmp20_;
	JsonNode* _tmp21_;
	GError* e;
	GError* _tmp22_;
	const gchar* _tmp23_;
	TweetListBox* _tmp24_;
	JsonNode* _tmp25_;
	JsonArray* root_array;
	JsonNode* _tmp26_;
	JsonArray* _tmp27_;
	JsonArray* _tmp28_;
	JsonArray* _tmp29_;
	guint _tmp30_;
	TweetListBox* _tmp31_;
	JsonArray* _tmp32_;
	TweetListBox* _tmp33_;
	Account* _tmp34_;
	GError * _inner_error_;
};

struct _ProfilePageLoadOlderTweetsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ProfilePage* self;
	gboolean _tmp0_;
	GtkStack* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	TweetListBox* _tmp4_;
	gint requested_tweet_count;
	RestProxyCall* call;
	Account* _tmp5_;
	OAuthProxy* _tmp6_;
	RestProxyCall* _tmp7_;
	RestProxyCall* _tmp8_;
	RestProxyCall* _tmp9_;
	RestProxyCall* _tmp10_;
	gint64 _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	RestProxyCall* _tmp14_;
	gint _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	RestProxyCall* _tmp18_;
	RestProxyCall* _tmp19_;
	RestProxyCall* _tmp20_;
	RestProxyCall* _tmp21_;
	TweetListBox* _tmp22_;
	CbTweetModel* _tmp23_;
	gint64 _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	JsonNode* root;
	JsonNode* _tmp27_;
	RestProxyCall* _tmp28_;
	GCancellable* _tmp29_;
	JsonNode* _tmp30_;
	JsonNode* _tmp31_;
	GError* e;
	GError* _tmp32_;
	const gchar* _tmp33_;
	JsonNode* _tmp34_;
	JsonArray* root_arr;
	JsonNode* _tmp35_;
	JsonArray* _tmp36_;
	JsonArray* _tmp37_;
	JsonArray* _tmp38_;
	TweetListBox* _tmp39_;
	Account* _tmp40_;
	GError * _inner_error_;
};

struct _ProfilePageLoadFollowersData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ProfilePage* self;
	gboolean _tmp0_;
	Cursor* _tmp1_;
	Cursor* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	Account* _tmp5_;
	gint64 _tmp6_;
	Cursor* _tmp7_;
	Cursor* _tmp8_;
	Cursor* _tmp9_;
	JsonArray* users_array;
	Cursor* _tmp10_;
	JsonNode* _tmp11_;
	JsonArray* _tmp12_;
	JsonArray* _tmp13_;
	JsonArray* _tmp14_;
};

struct _ProfilePageLoadFollowingData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ProfilePage* self;
	gboolean _tmp0_;
	Cursor* _tmp1_;
	Cursor* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	Account* _tmp5_;
	gint64 _tmp6_;
	Cursor* _tmp7_;
	Cursor* _tmp8_;
	Cursor* _tmp9_;
	JsonArray* users_array;
	Cursor* _tmp10_;
	JsonNode* _tmp11_;
	JsonArray* _tmp12_;
	JsonArray* _tmp13_;
	JsonArray* _tmp14_;
};

struct _Block24Data {
	int _ref_count_;
	ProfilePage* self;
	RestProxyCall* call;
};

typedef enum  {
	COMPOSE_TWEET_WINDOW_MODE_NORMAL,
	COMPOSE_TWEET_WINDOW_MODE_REPLY,
	COMPOSE_TWEET_WINDOW_MODE_QUOTE
} ComposeTweetWindowMode;

struct _Block25Data {
	int _ref_count_;
	ProfilePage* self;
	gboolean current_state;
	RestProxyCall* call;
	GSimpleAction* a;
};

struct _Block26Data {
	int _ref_count_;
	ProfilePage* self;
	gboolean setting;
};

struct _Block27Data {
	int _ref_count_;
	ProfilePage* self;
	gboolean current_state;
	RestProxyCall* call;
	GSimpleAction* a;
};


static gpointer profile_page_parent_class = NULL;
extern cairo_surface_t* twitter_no_avatar;
extern GdkPixbuf* twitter_no_banner;
static IPageIface * profile_page_ipage_parent_iface = NULL;
static CbMessageReceiverInterface * profile_page_cb_message_receiver_parent_iface = NULL;

GType scroll_widget_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
GType ipage_get_type (void) G_GNUC_CONST;
GType profile_page_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
GType aspect_image_get_type (void) G_GNUC_CONST;
GType avatar_widget_get_type (void) G_GNUC_CONST;
GType follow_button_get_type (void) G_GNUC_CONST;
GType tweet_list_box_get_type (void) G_GNUC_CONST;
GType user_lists_widget_get_type (void) G_GNUC_CONST;
GType cursor_get_type (void) G_GNUC_CONST;
Cursor* cursor_dup (const Cursor* self);
void cursor_free (Cursor* self);
void cursor_copy (const Cursor* self, Cursor* dest);
void cursor_destroy (Cursor* self);
#define PROFILE_PAGE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PROFILE_PAGE, ProfilePagePrivate))
enum  {
	PROFILE_PAGE_DUMMY_PROPERTY,
	PROFILE_PAGE_UNREAD_COUNT,
	PROFILE_PAGE_WINDOW,
	PROFILE_PAGE_ID
};
static void profile_page_write_dm_activated (ProfilePage* self, GSimpleAction* a, GVariant* v);
static void _profile_page_write_dm_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void profile_page_tweet_to_activated (ProfilePage* self, GSimpleAction* a, GVariant* v);
static void _profile_page_tweet_to_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void profile_page_add_remove_list_activated (ProfilePage* self, GSimpleAction* a, GVariant* v);
static void _profile_page_add_remove_list_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
#define PROFILE_PAGE_KEY_SCREEN_NAME 0
#define PROFILE_PAGE_KEY_USER_ID 1
ProfilePage* profile_page_new (gint id, Account* account);
ProfilePage* profile_page_construct (GType object_type, gint id, Account* account);
ScrollWidget* scroll_widget_new (void);
ScrollWidget* scroll_widget_construct (GType object_type);
void ipage_set_id (IPage* self, gint value);
void user_lists_widget_set_account (UserListsWidget* self, Account* value);
static void __lambda121_ (ProfilePage* self);
static void profile_page_load_older_tweets (ProfilePage* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void profile_page_load_older_tweets_finish (ProfilePage* self, GAsyncResult* _res_);
static void profile_page_load_followers (ProfilePage* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void profile_page_load_followers_finish (ProfilePage* self, GAsyncResult* _res_);
static void profile_page_load_following (ProfilePage* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void profile_page_load_following_finish (ProfilePage* self, GAsyncResult* _res_);
static void ___lambda121__scroll_widget_scrolled_to_end (ScrollWidget* _sender, gpointer self);
static void __lambda140_ (ProfilePage* self, GtkListBoxRow* row);
#define TWEET_INFO_PAGE_KEY_MODE 0
#define TWEET_INFO_PAGE_BY_INSTANCE 1
#define TWEET_INFO_PAGE_KEY_TWEET 1
GType tweet_list_entry_get_type (void) G_GNUC_CONST;
GType main_widget_get_type (void) G_GNUC_CONST;
void main_widget_switch_page (MainWidget* self, gint page_id, CbBundle* args);
GType page_get_type (void) G_GNUC_CONST;
static void ___lambda140__gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self);
static void __lambda141_ (ProfilePage* self, GtkListBoxRow* row);
GType user_list_entry_get_type (void) G_GNUC_CONST;
gint64 user_list_entry_get_user_id (UserListEntry* self);
gchar* user_list_entry_get_screen_name (UserListEntry* self);
static void ___lambda141__gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self);
static void __lambda142_ (ProfilePage* self, GtkListBoxRow* row);
static void ___lambda142__gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self);
void user_lists_widget_hide_user_list_entry (UserListsWidget* self);
static void profile_page_toggle_blocked_activated (ProfilePage* self, GSimpleAction* a, GVariant* v);
static void _profile_page_toggle_blocked_activated_g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self);
static void profile_page_toggle_muted_activated (ProfilePage* self, GSimpleAction* a, GVariant* v);
static void _profile_page_toggle_muted_activated_g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self);
static void profile_page_retweet_action_activated (ProfilePage* self, GSimpleAction* a, GVariant* v);
static void _profile_page_retweet_action_activated_g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self);
static void profile_page_set_user_id (ProfilePage* self, gint64 user_id);
GType sql_database_get_type (void) G_GNUC_CONST;
GType notification_manager_get_type (void) G_GNUC_CONST;
static inline void profile_page_set_banner (ProfilePage* self, GdkPixbuf* banner);
static void profile_page_load_friendship (ProfilePage* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void profile_page_load_friendship_finish (ProfilePage* self, GAsyncResult* _res_);
static void profile_page_load_profile_data (ProfilePage* self, gint64 user_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void profile_page_load_profile_data_finish (ProfilePage* self, GAsyncResult* _res_);
static void profile_page_load_friendship_data_free (gpointer _data);
static gboolean profile_page_load_friendship_co (ProfilePageLoadFriendshipData* _data_);
static void profile_page_set_user_blocked (ProfilePage* self, gboolean blocked);
gboolean account_is_blocked (Account* self, gint64 user_id);
static void profile_page_set_user_muted (ProfilePage* self, gboolean muted);
gboolean account_is_muted (Account* self, gint64 user_id);
void user_utils_load_friendship (Account* account, gint64 user_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
guint user_utils_load_friendship_finish (GAsyncResult* _res_);
static void profile_page_load_friendship_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
#define FRIENDSHIP_FOLLOWED_BY ((guint) (1 << 0))
#define FRIENDSHIP_BLOCKING ((guint) (1 << 3))
#define FRIENDSHIP_FOLLOWING ((guint) (1 << 1))
#define FRIENDSHIP_WANT_RETWEETS ((guint) (1 << 2))
static void profile_page_set_retweets_disabled (ProfilePage* self, gboolean disabled);
#define FRIENDSHIP_CAN_DM ((guint) (1 << 4))
static void profile_page_load_profile_data_data_free (gpointer _data);
static gboolean profile_page_load_profile_data_co (ProfilePageLoadProfileDataData* _data_);
static Block23Data* block23_data_ref (Block23Data* _data23_);
static void _vala_CbTextEntity_array_free (CbTextEntity * array, gint array_length);
static void block23_data_unref (void * _userdata_);
static void profile_page_load_profile_data_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _vala_JsonNode_free (JsonNode* self);
void tweet_utils_download_avatar (const gchar* avatar_url, gint size, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GdkPixbuf* tweet_utils_download_avatar_finish (GAsyncResult* _res_, GError** error);
static void __lambda146_ (Block23Data* _data23_, GObject* obj, GAsyncResult* res);
cairo_surface_t* scale_surface (cairo_surface_t* input, gint output_width, gint output_height);
void avatar_widget_set_surface (AvatarWidget* self, cairo_surface_t* value);
static void ___lambda146__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
gboolean utils_usable_json_value (JsonObject* node, const gchar* value_name);
void tweet_list_box_set_placeholder_text (TweetListBox* self, const gchar* text);
void aspect_image_set_color_string (AspectImage* self, const gchar* value);
static void profile_page_load_profile_banner (ProfilePage* self, const gchar* base_url);
static void ___lambda148_ (Block23Data* _data23_, JsonArray* arr, guint i, JsonNode* node);
static void ____lambda148__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
void follow_button_set_following (FollowButton* self, gboolean value);
void tweet_utils_sort_entities (CbTextEntity** entities, int* entities_length1);
static void profile_page_update_follower_label (ProfilePage* self);
void avatar_widget_set_verified (AvatarWidget* self, gboolean value);
static void profile_page_load_tweets_data_free (gpointer _data);
static void profile_page_load_tweets (ProfilePage* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void profile_page_load_tweets_finish (ProfilePage* self, GAsyncResult* _res_);
static gboolean profile_page_load_tweets_co (ProfilePageLoadTweetsData* _data_);
void tweet_list_box_set_unempty (TweetListBox* self);
static void profile_page_load_tweets_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void tweet_list_box_set_empty (TweetListBox* self);
void tweet_utils_work_array (JsonArray* json_array, TweetListBox* tweet_list, Account* account);
static void profile_page_load_older_tweets_data_free (gpointer _data);
static gboolean profile_page_load_older_tweets_co (ProfilePageLoadOlderTweetsData* _data_);
static void profile_page_load_older_tweets_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void profile_page_load_followers_data_free (gpointer _data);
static gboolean profile_page_load_followers_co (ProfilePageLoadFollowersData* _data_);
void user_utils_load_followers (Account* account, gint64 user_id, Cursor* old_cursor, GAsyncReadyCallback _callback_, gpointer _user_data_);
Cursor* user_utils_load_followers_finish (GAsyncResult* _res_);
static void profile_page_load_followers_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void __lambda122_ (ProfilePage* self, JsonArray* array, guint index, JsonNode* node);
UserListEntry* user_list_entry_new (void);
UserListEntry* user_list_entry_construct (GType object_type);
void user_list_entry_set_show_settings (UserListEntry* self, gboolean value);
void user_list_entry_set_user_id (UserListEntry* self, gint64 value);
void user_list_entry_set_screen_name (UserListEntry* self, const gchar* sn);
void user_list_entry_set_name (UserListEntry* self, const gchar* value);
void user_list_entry_set_avatar_url (UserListEntry* self, const gchar* value);
static void ___lambda122__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
static void profile_page_load_following_data_free (gpointer _data);
static gboolean profile_page_load_following_co (ProfilePageLoadFollowingData* _data_);
void user_utils_load_following (Account* account, gint64 user_id, Cursor* old_cursor, GAsyncReadyCallback _callback_, gpointer _user_data_);
Cursor* user_utils_load_following_finish (GAsyncResult* _res_);
static void profile_page_load_following_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void __lambda139_ (ProfilePage* self, JsonArray* array, guint index, JsonNode* node);
static void ___lambda139__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
void utils_download_pixbuf (const gchar* url, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GdkPixbuf* utils_download_pixbuf_finish (GAsyncResult* _res_);
static void __lambda147_ (ProfilePage* self, GObject* obj, GAsyncResult* res);
static void ___lambda147__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void profile_page_follow_button_clicked_cb (ProfilePage* self);
static Block24Data* block24_data_ref (Block24Data* _data24_);
static void block24_data_unref (void * _userdata_);
GType default_timeline_get_type (void) G_GNUC_CONST;
GType home_timeline_get_type (void) G_GNUC_CONST;
IPage* main_window_get_page (MainWindow* self, gint page_id);
gboolean follow_button_get_following (FollowButton* self);
void home_timeline_hide_tweets_from (HomeTimeline* self, gint64 user_id, CbTweetState reason);
void home_timeline_hide_retweets_from (HomeTimeline* self, gint64 user_id, CbTweetState reason);
void account_unfollow_id (Account* self, gint64 user_id);
void home_timeline_show_tweets_from (HomeTimeline* self, gint64 user_id, CbTweetState reason);
void home_timeline_show_retweets_from (HomeTimeline* self, gint64 user_id, CbTweetState reason);
void account_follow_id (Account* self, gint64 user_id);
static void __lambda149_ (Block24Data* _data24_, GObject* obj, GAsyncResult* res);
static void ___lambda149__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _profile_page_follow_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static gboolean profile_page_activate_link (ProfilePage* self, const gchar* uri);
gboolean tweet_utils_activate_link (const gchar* uri, MainWindow* window);
static gboolean _profile_page_activate_link_gtk_label_activate_link (GtkLabel* _sender, const gchar* uri, gpointer self);
void aspect_image_set_pixbuf (AspectImage* self, GdkPixbuf* value);
static void profile_page_real_on_join (IPage* base, gint page_id, CbBundle* args);
static void profile_page_reset_data (ProfilePage* self);
void tweet_list_box_remove_all (TweetListBox* self);
gboolean account_follows_id (Account* self, gint64 user_id);
void user_lists_widget_clear_lists (UserListsWidget* self);
void tweet_list_box_reset_placeholder_text (TweetListBox* self);
static void profile_page_real_on_leave (IPage* base);
static void profile_page_real_create_radio_button (IPage* base, GtkRadioButton* group);
static gchar* profile_page_real_get_title (IPage* base);
static GtkRadioButton* profile_page_real_get_radio_button (IPage* base);
#define DM_PAGE_KEY_SENDER_ID 0
#define DM_PAGE_KEY_SCREEN_NAME 1
#define DM_PAGE_KEY_USER_NAME 2
#define DM_PAGE_KEY_AVATAR_URL 3
GType compose_tweet_window_get_type (void) G_GNUC_CONST;
GType compose_tweet_window_mode_get_type (void) G_GNUC_CONST;
ComposeTweetWindow* compose_tweet_window_new (MainWindow* parent, Account* acc, CbTweet* reply_to, ComposeTweetWindowMode mode);
ComposeTweetWindow* compose_tweet_window_construct (GType object_type, MainWindow* parent, Account* acc, CbTweet* reply_to, ComposeTweetWindowMode mode);
void compose_tweet_window_set_text (ComposeTweetWindow* self, const gchar* text);
GType user_list_dialog_get_type (void) G_GNUC_CONST;
UserListDialog* user_list_dialog_new (MainWindow* parent, Account* account, gint64 user_id);
UserListDialog* user_list_dialog_construct (GType object_type, MainWindow* parent, Account* account, gint64 user_id);
void user_list_dialog_load_lists (UserListDialog* self);
static Block25Data* block25_data_ref (Block25Data* _data25_);
static void block25_data_unref (void * _userdata_);
static gboolean profile_page_get_user_blocked (ProfilePage* self);
static void __lambda143_ (Block25Data* _data25_, GObject* obj, GAsyncResult* res);
void utils_show_error_object (const gchar* json_data, const gchar* alternative, gint line, const gchar* file, GtkWindow* transient_for);
static void ___lambda143__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static Block26Data* block26_data_ref (Block26Data* _data26_);
static void block26_data_unref (void * _userdata_);
static gboolean profile_page_get_user_muted (ProfilePage* self);
static GVariant* _variant_new5 (gboolean value);
void user_utils_mute_user (Account* account, gint64 to_block, gboolean setting, GAsyncReadyCallback _callback_, gpointer _user_data_);
void user_utils_mute_user_finish (GAsyncResult* _res_);
static void __lambda144_ (Block26Data* _data26_, GObject* obj, GAsyncResult* res);
static void ___lambda144__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static Block27Data* block27_data_ref (Block27Data* _data27_);
static void block27_data_unref (void * _userdata_);
void account_remove_disabled_rts_id (Account* self, gint64 user_id);
void account_add_disabled_rts_id (Account* self, gint64 user_id);
static void __lambda145_ (Block27Data* _data27_, GObject* obj, GAsyncResult* res);
static void ___lambda145__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void profile_page_real_stream_message_received (CbMessageReceiver* base, CbStreamMessageType type, JsonNode* root_node);
static void profile_page_tweets_button_toggled_cb (ProfilePage* self, GObject* source);
void scroll_widget_balance_next_upper_change (ScrollWidget* self, gint mode);
#define BOTTOM 2
static void _profile_page_tweets_button_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void profile_page_followers_button_toggled_cb (ProfilePage* self, GObject* source);
static void _profile_page_followers_button_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void profile_page_following_button_toggled_cb (ProfilePage* self, GObject* source);
static void _profile_page_following_button_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void profile_page_lists_button_toggled_cb (ProfilePage* self, GObject* source);
void user_lists_widget_load_lists (UserListsWidget* self, gint64 user_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void user_lists_widget_load_lists_finish (UserListsWidget* self, GAsyncResult* _res_);
static void _profile_page_lists_button_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
gint profile_page_get_unread_count (ProfilePage* self);
void user_lists_widget_set_main_window (UserListsWidget* self, MainWindow* value);
static void profile_page_finalize (GObject * obj);
gint ipage_get_id (IPage* self);
static void _vala_profile_page_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void ipage_set_window (IPage* self, MainWindow* value);
static void _vala_profile_page_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

static const GActionEntry PROFILE_PAGE_action_entries[3] = {{"write-dm", _profile_page_write_dm_activated_gsimple_action_activate_callback}, {"tweet-to", _profile_page_tweet_to_activated_gsimple_action_activate_callback}, {"add-remove-list", _profile_page_add_remove_list_activated_gsimple_action_activate_callback}};

static void _profile_page_write_dm_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	profile_page_write_dm_activated ((ProfilePage*) self, action, parameter);
}


static void _profile_page_tweet_to_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	profile_page_tweet_to_activated ((ProfilePage*) self, action, parameter);
}


static void _profile_page_add_remove_list_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	profile_page_add_remove_list_activated ((ProfilePage*) self, action, parameter);
}


static void __lambda121_ (ProfilePage* self) {
	GtkStack* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	TweetListBox* _tmp3_;
	_tmp0_ = self->priv->user_stack;
	_tmp1_ = gtk_stack_get_visible_child (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->tweet_list;
	if (_tmp2_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget)) {
		profile_page_load_older_tweets (self, NULL, NULL);
	} else {
		GtkStack* _tmp4_;
		GtkWidget* _tmp5_;
		GtkWidget* _tmp6_;
		TweetListBox* _tmp7_;
		_tmp4_ = self->priv->user_stack;
		_tmp5_ = gtk_stack_get_visible_child (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = self->priv->followers_list;
		if (_tmp6_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget)) {
			profile_page_load_followers (self, NULL, NULL);
		} else {
			GtkStack* _tmp8_;
			GtkWidget* _tmp9_;
			GtkWidget* _tmp10_;
			TweetListBox* _tmp11_;
			_tmp8_ = self->priv->user_stack;
			_tmp9_ = gtk_stack_get_visible_child (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = self->priv->following_list;
			if (_tmp10_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_widget_get_type (), GtkWidget)) {
				profile_page_load_following (self, NULL, NULL);
			}
		}
	}
}


static void ___lambda121__scroll_widget_scrolled_to_end (ScrollWidget* _sender, gpointer self) {
	__lambda121_ ((ProfilePage*) self);
}


static void __lambda140_ (ProfilePage* self, GtkListBoxRow* row) {
	CbBundle* bundle = NULL;
	CbBundle* _tmp0_;
	GtkListBoxRow* _tmp1_;
	CbTweet* _tmp2_;
	MainWindow* _tmp3_;
	MainWidget* _tmp4_;
	g_return_if_fail (GTK_IS_LIST_BOX_ROW (row));
	_tmp0_ = cb_bundle_new ();
	bundle = _tmp0_;
	cb_bundle_put_int (bundle, TWEET_INFO_PAGE_KEY_MODE, TWEET_INFO_PAGE_BY_INSTANCE);
	_tmp1_ = row;
	_tmp2_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_TWEET_LIST_ENTRY, TweetListEntry)->tweet;
	cb_bundle_put_object (bundle, TWEET_INFO_PAGE_KEY_TWEET, G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, G_TYPE_OBJECT, GObject));
	_tmp3_ = self->priv->main_window;
	_tmp4_ = _tmp3_->main_widget;
	main_widget_switch_page (_tmp4_, (gint) PAGE_TWEET_INFO, bundle);
	_g_object_unref0 (bundle);
}


static void ___lambda140__gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self) {
	__lambda140_ ((ProfilePage*) self, row);
}


static void __lambda141_ (ProfilePage* self, GtkListBoxRow* row) {
	CbBundle* bundle = NULL;
	CbBundle* _tmp0_;
	GtkListBoxRow* _tmp1_;
	gint64 _tmp2_;
	gint64 _tmp3_;
	GtkListBoxRow* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	MainWindow* _tmp8_;
	MainWidget* _tmp9_;
	g_return_if_fail (GTK_IS_LIST_BOX_ROW (row));
	_tmp0_ = cb_bundle_new ();
	bundle = _tmp0_;
	_tmp1_ = row;
	_tmp2_ = user_list_entry_get_user_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_USER_LIST_ENTRY, UserListEntry));
	_tmp3_ = _tmp2_;
	cb_bundle_put_int64 (bundle, PROFILE_PAGE_KEY_USER_ID, _tmp3_);
	_tmp4_ = row;
	_tmp5_ = user_list_entry_get_screen_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_USER_LIST_ENTRY, UserListEntry));
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_;
	cb_bundle_put_string (bundle, PROFILE_PAGE_KEY_SCREEN_NAME, _tmp7_);
	_g_free0 (_tmp7_);
	_tmp8_ = self->priv->main_window;
	_tmp9_ = _tmp8_->main_widget;
	main_widget_switch_page (_tmp9_, (gint) PAGE_PROFILE, bundle);
	_g_object_unref0 (bundle);
}


static void ___lambda141__gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self) {
	__lambda141_ ((ProfilePage*) self, row);
}


static void __lambda142_ (ProfilePage* self, GtkListBoxRow* row) {
	CbBundle* bundle = NULL;
	CbBundle* _tmp0_;
	GtkListBoxRow* _tmp1_;
	gint64 _tmp2_;
	gint64 _tmp3_;
	GtkListBoxRow* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	MainWindow* _tmp8_;
	MainWidget* _tmp9_;
	g_return_if_fail (GTK_IS_LIST_BOX_ROW (row));
	_tmp0_ = cb_bundle_new ();
	bundle = _tmp0_;
	_tmp1_ = row;
	_tmp2_ = user_list_entry_get_user_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_USER_LIST_ENTRY, UserListEntry));
	_tmp3_ = _tmp2_;
	cb_bundle_put_int64 (bundle, PROFILE_PAGE_KEY_USER_ID, _tmp3_);
	_tmp4_ = row;
	_tmp5_ = user_list_entry_get_screen_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_USER_LIST_ENTRY, UserListEntry));
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_;
	cb_bundle_put_string (bundle, PROFILE_PAGE_KEY_SCREEN_NAME, _tmp7_);
	_g_free0 (_tmp7_);
	_tmp8_ = self->priv->main_window;
	_tmp9_ = _tmp8_->main_widget;
	main_widget_switch_page (_tmp9_, (gint) PAGE_PROFILE, bundle);
	_g_object_unref0 (bundle);
}


static void ___lambda142__gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self) {
	__lambda142_ ((ProfilePage*) self, row);
}


static void _profile_page_toggle_blocked_activated_g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self) {
	profile_page_toggle_blocked_activated ((ProfilePage*) self, _sender, parameter);
}


static void _profile_page_toggle_muted_activated_g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self) {
	profile_page_toggle_muted_activated ((ProfilePage*) self, _sender, parameter);
}


static void _profile_page_retweet_action_activated_g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self) {
	profile_page_retweet_action_activated ((ProfilePage*) self, _sender, parameter);
}


ProfilePage* profile_page_construct (GType object_type, gint id, Account* account) {
	ProfilePage * self = NULL;
	gint _tmp0_;
	Account* _tmp1_;
	UserListsWidget* _tmp2_;
	Account* _tmp3_;
	TweetListBox* _tmp4_;
	Account* _tmp5_;
	TweetListBox* _tmp6_;
	TweetListBox* _tmp7_;
	TweetListBox* _tmp8_;
	UserListsWidget* _tmp9_;
	GSimpleActionGroup* _tmp10_;
	GSimpleActionGroup* _tmp11_;
	GSimpleAction* block_action = NULL;
	GVariant* _tmp12_;
	GVariant* _tmp13_;
	GSimpleAction* _tmp14_;
	GSimpleAction* _tmp15_;
	GSimpleActionGroup* _tmp16_;
	GSimpleAction* mute_action = NULL;
	GVariant* _tmp17_;
	GVariant* _tmp18_;
	GSimpleAction* _tmp19_;
	GSimpleAction* _tmp20_;
	GSimpleActionGroup* _tmp21_;
	GSimpleAction* rt_action = NULL;
	GVariant* _tmp22_;
	GVariant* _tmp23_;
	GSimpleAction* _tmp24_;
	GSimpleAction* _tmp25_;
	GSimpleActionGroup* _tmp26_;
	GSimpleActionGroup* _tmp27_;
	g_return_val_if_fail (IS_ACCOUNT (account), NULL);
	self = (ProfilePage*) scroll_widget_construct (object_type);
	_tmp0_ = id;
	ipage_set_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), _tmp0_);
	_tmp1_ = account;
	self->account = _tmp1_;
	_tmp2_ = self->priv->user_lists;
	_tmp3_ = account;
	user_lists_widget_set_account (_tmp2_, _tmp3_);
	_tmp4_ = self->priv->tweet_list;
	_tmp5_ = account;
	_tmp4_->account = _tmp5_;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SCROLL_WIDGET, ScrollWidget), "scrolled-to-end", (GCallback) ___lambda121__scroll_widget_scrolled_to_end, self, 0);
	_tmp6_ = self->priv->tweet_list;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_list_box_get_type (), GtkListBox), "row-activated", (GCallback) ___lambda140__gtk_list_box_row_activated, self, 0);
	_tmp7_ = self->priv->followers_list;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_list_box_get_type (), GtkListBox), "row-activated", (GCallback) ___lambda141__gtk_list_box_row_activated, self, 0);
	_tmp8_ = self->priv->following_list;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_list_box_get_type (), GtkListBox), "row-activated", (GCallback) ___lambda142__gtk_list_box_row_activated, self, 0);
	_tmp9_ = self->priv->user_lists;
	user_lists_widget_hide_user_list_entry (_tmp9_);
	_tmp10_ = g_simple_action_group_new ();
	_g_object_unref0 (self->priv->actions);
	self->priv->actions = _tmp10_;
	_tmp11_ = self->priv->actions;
	g_action_map_add_action_entries (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, g_action_map_get_type (), GActionMap), PROFILE_PAGE_action_entries, G_N_ELEMENTS (PROFILE_PAGE_action_entries), self);
	_tmp12_ = g_variant_new_boolean (FALSE);
	g_variant_ref_sink (_tmp12_);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_simple_action_new_stateful ("toggle-blocked", NULL, _tmp13_);
	_tmp15_ = _tmp14_;
	_g_variant_unref0 (_tmp13_);
	block_action = _tmp15_;
	g_signal_connect_object (block_action, "activate", (GCallback) _profile_page_toggle_blocked_activated_g_simple_action_activate, self, 0);
	_tmp16_ = self->priv->actions;
	g_action_map_add_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, g_action_map_get_type (), GActionMap), G_TYPE_CHECK_INSTANCE_CAST (block_action, g_action_get_type (), GAction));
	_tmp17_ = g_variant_new_boolean (FALSE);
	g_variant_ref_sink (_tmp17_);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_simple_action_new_stateful ("toggle-muted", NULL, _tmp18_);
	_tmp20_ = _tmp19_;
	_g_variant_unref0 (_tmp18_);
	mute_action = _tmp20_;
	g_signal_connect_object (mute_action, "activate", (GCallback) _profile_page_toggle_muted_activated_g_simple_action_activate, self, 0);
	_tmp21_ = self->priv->actions;
	g_action_map_add_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, g_action_map_get_type (), GActionMap), G_TYPE_CHECK_INSTANCE_CAST (mute_action, g_action_get_type (), GAction));
	_tmp22_ = g_variant_new_boolean (FALSE);
	g_variant_ref_sink (_tmp22_);
	_tmp23_ = _tmp22_;
	_tmp24_ = g_simple_action_new_stateful ("toggle-retweets", NULL, _tmp23_);
	_tmp25_ = _tmp24_;
	_g_variant_unref0 (_tmp23_);
	rt_action = _tmp25_;
	g_signal_connect_object (rt_action, "activate", (GCallback) _profile_page_retweet_action_activated_g_simple_action_activate, self, 0);
	_tmp26_ = self->priv->actions;
	g_action_map_add_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, g_action_map_get_type (), GActionMap), G_TYPE_CHECK_INSTANCE_CAST (rt_action, g_action_get_type (), GAction));
	_tmp27_ = self->priv->actions;
	gtk_widget_insert_action_group (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "user", G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, g_action_group_get_type (), GActionGroup));
	_g_object_unref0 (rt_action);
	_g_object_unref0 (mute_action);
	_g_object_unref0 (block_action);
	return self;
}


ProfilePage* profile_page_new (gint id, Account* account) {
	return profile_page_construct (TYPE_PROFILE_PAGE, id, account);
}


static void profile_page_set_user_id (ProfilePage* self, gint64 user_id) {
	gint64 _tmp0_;
	FollowButton* _tmp1_;
	gint64 _tmp2_;
	Account* _tmp3_;
	gint64 _tmp4_;
	GtkStack* _tmp5_;
	GtkSpinner* _tmp6_;
	gint64 _tmp7_;
	g_return_if_fail (IS_PROFILE_PAGE (self));
	_tmp0_ = user_id;
	self->priv->user_id = _tmp0_;
	_tmp1_ = self->priv->follow_button;
	_tmp2_ = user_id;
	_tmp3_ = self->account;
	_tmp4_ = _tmp3_->id;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget), _tmp2_ != _tmp4_);
	_tmp5_ = self->priv->loading_stack;
	gtk_stack_set_visible_child_name (_tmp5_, "progress");
	_tmp6_ = self->priv->progress_spinner;
	gtk_spinner_start (_tmp6_);
	profile_page_set_banner (self, NULL);
	profile_page_load_friendship (self, NULL, NULL);
	_tmp7_ = user_id;
	profile_page_load_profile_data (self, _tmp7_, NULL, NULL);
}


static void profile_page_load_friendship_data_free (gpointer _data) {
	ProfilePageLoadFriendshipData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ProfilePageLoadFriendshipData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void profile_page_load_friendship (ProfilePage* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ProfilePageLoadFriendshipData* _data_;
	ProfilePage* _tmp0_;
	_data_ = g_slice_new0 (ProfilePageLoadFriendshipData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, profile_page_load_friendship_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	profile_page_load_friendship_co (_data_);
}


static void profile_page_load_friendship_finish (ProfilePage* self, GAsyncResult* _res_) {
	ProfilePageLoadFriendshipData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}


static void profile_page_load_friendship_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ProfilePageLoadFriendshipData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	profile_page_load_friendship_co (_data_);
}


static gboolean profile_page_load_friendship_co (ProfilePageLoadFriendshipData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->account;
	_data_->_tmp1_ = _data_->self->priv->user_id;
	_data_->_tmp2_ = account_is_blocked (_data_->_tmp0_, _data_->_tmp1_);
	profile_page_set_user_blocked (_data_->self, _data_->_tmp2_);
	_data_->_tmp3_ = _data_->self->account;
	_data_->_tmp4_ = _data_->self->priv->user_id;
	_data_->_tmp5_ = account_is_muted (_data_->_tmp3_, _data_->_tmp4_);
	profile_page_set_user_muted (_data_->self, _data_->_tmp5_);
	_data_->_tmp6_ = _data_->self->priv->actions;
	_data_->_tmp7_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp6_, g_action_map_get_type (), GActionMap), "toggle-retweets");
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp7_, g_simple_action_get_type (), GSimpleAction), FALSE);
	_data_->_tmp8_ = _data_->self->priv->actions;
	_data_->_tmp9_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp8_, g_action_map_get_type (), GActionMap), "add-remove-list");
	_data_->_tmp10_ = _data_->self->priv->user_id;
	_data_->_tmp11_ = _data_->self->account;
	_data_->_tmp12_ = _data_->_tmp11_->id;
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp9_, g_simple_action_get_type (), GSimpleAction), _data_->_tmp10_ != _data_->_tmp12_);
	_data_->_tmp13_ = _data_->self->priv->actions;
	_data_->_tmp14_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp13_, g_action_map_get_type (), GActionMap), "write-dm");
	_data_->_tmp15_ = _data_->self->priv->user_id;
	_data_->_tmp16_ = _data_->self->account;
	_data_->_tmp17_ = _data_->_tmp16_->id;
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp14_, g_simple_action_get_type (), GSimpleAction), _data_->_tmp15_ != _data_->_tmp17_);
	_data_->_tmp18_ = _data_->self->priv->actions;
	_data_->_tmp19_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp18_, g_action_map_get_type (), GActionMap), "toggle-blocked");
	_data_->_tmp20_ = _data_->self->priv->user_id;
	_data_->_tmp21_ = _data_->self->account;
	_data_->_tmp22_ = _data_->_tmp21_->id;
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp19_, g_simple_action_get_type (), GSimpleAction), _data_->_tmp20_ != _data_->_tmp22_);
	_data_->_tmp23_ = _data_->self->priv->actions;
	_data_->_tmp24_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp23_, g_action_map_get_type (), GActionMap), "toggle-muted");
	_data_->_tmp25_ = _data_->self->priv->user_id;
	_data_->_tmp26_ = _data_->self->account;
	_data_->_tmp27_ = _data_->_tmp26_->id;
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp24_, g_simple_action_get_type (), GSimpleAction), _data_->_tmp25_ != _data_->_tmp27_);
	_data_->_tmp28_ = _data_->self->account;
	_data_->_tmp29_ = _data_->self->priv->user_id;
	_data_->_state_ = 1;
	user_utils_load_friendship (_data_->_tmp28_, _data_->_tmp29_, profile_page_load_friendship_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp30_ = user_utils_load_friendship_finish (_data_->_res_);
	_data_->fr = _data_->_tmp30_;
	_data_->_tmp31_ = _data_->self->priv->follows_you_label;
	_data_->_tmp32_ = _data_->fr;
	gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp31_, gtk_widget_get_type (), GtkWidget), (_data_->_tmp32_ & FRIENDSHIP_FOLLOWED_BY) > ((guint) 0));
	_data_->_tmp33_ = _data_->fr;
	profile_page_set_user_blocked (_data_->self, (_data_->_tmp33_ & FRIENDSHIP_BLOCKING) > ((guint) 0));
	_data_->_tmp35_ = _data_->fr;
	if ((_data_->_tmp35_ & FRIENDSHIP_FOLLOWING) > ((guint) 0)) {
		_data_->_tmp36_ = _data_->fr;
		_data_->_tmp34_ = (_data_->_tmp36_ & FRIENDSHIP_WANT_RETWEETS) == ((guint) 0);
	} else {
		_data_->_tmp34_ = FALSE;
	}
	profile_page_set_retweets_disabled (_data_->self, _data_->_tmp34_);
	_data_->_tmp37_ = _data_->fr;
	if ((_data_->_tmp37_ & FRIENDSHIP_CAN_DM) == ((guint) 0)) {
		_data_->_tmp38_ = _data_->self->priv->actions;
		_data_->_tmp39_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp38_, g_action_map_get_type (), GActionMap), "write-dm");
		g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp39_, g_simple_action_get_type (), GSimpleAction), FALSE);
	}
	_data_->_tmp40_ = _data_->self->priv->actions;
	_data_->_tmp41_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp40_, g_action_map_get_type (), GActionMap), "toggle-retweets");
	_data_->_tmp42_ = _data_->fr;
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp41_, g_simple_action_get_type (), GSimpleAction), (_data_->_tmp42_ & FRIENDSHIP_FOLLOWING) > ((guint) 0));
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void profile_page_load_profile_data_data_free (gpointer _data) {
	ProfilePageLoadProfileDataData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ProfilePageLoadProfileDataData, _data_);
}


static void profile_page_load_profile_data (ProfilePage* self, gint64 user_id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ProfilePageLoadProfileDataData* _data_;
	ProfilePage* _tmp0_;
	gint64 _tmp1_;
	_data_ = g_slice_new0 (ProfilePageLoadProfileDataData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, profile_page_load_profile_data_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = user_id;
	_data_->user_id = _tmp1_;
	profile_page_load_profile_data_co (_data_);
}


static void profile_page_load_profile_data_finish (ProfilePage* self, GAsyncResult* _res_) {
	ProfilePageLoadProfileDataData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}


static Block23Data* block23_data_ref (Block23Data* _data23_) {
	g_atomic_int_inc (&_data23_->_ref_count_);
	return _data23_;
}


static void _vala_CbTextEntity_array_free (CbTextEntity * array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			cb_text_entity_free (&array[i]);
		}
	}
	g_free (array);
}


static void block23_data_unref (void * _userdata_) {
	Block23Data* _data23_;
	_data23_ = (Block23Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data23_->_ref_count_)) {
		ProfilePage* self;
		self = _data23_->self;
		_data23_->text_urls = (_vala_CbTextEntity_array_free (_data23_->text_urls, _data23_->text_urls_length1), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block23Data, _data23_);
	}
}


static void profile_page_load_profile_data_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ProfilePageLoadProfileDataData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	profile_page_load_profile_data_co (_data_);
}


static void _vala_JsonNode_free (JsonNode* self) {
	g_boxed_free (json_node_get_type (), self);
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = old;
		_tmp1_ = (*((gchar*) _tmp2_)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = old;
		_tmp4_ = replacement;
		_tmp0_ = g_strcmp0 (_tmp3_, _tmp4_) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (self);
		result = _tmp5_;
		return result;
	}
	{
		GRegex* regex = NULL;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GRegex* _tmp9_;
		GRegex* _tmp10_;
		gchar* _tmp11_ = NULL;
		GRegex* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp6_ = old;
		_tmp7_ = g_regex_escape_string (_tmp6_, -1);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_regex_new (_tmp8_, 0, 0, &_inner_error_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		regex = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch18_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp12_ = regex;
		_tmp13_ = replacement;
		_tmp14_ = g_regex_replace_literal (_tmp12_, self, (gssize) -1, 0, _tmp13_, 0, &_inner_error_);
		_tmp11_ = _tmp14_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch18_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp15_ = _tmp11_;
		_tmp11_ = NULL;
		result = _tmp15_;
		_g_free0 (_tmp11_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally18;
	__catch18_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally18:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gpointer _cairo_surface_reference0 (gpointer self) {
	return self ? cairo_surface_reference (self) : NULL;
}


static void __lambda146_ (Block23Data* _data23_, GObject* obj, GAsyncResult* res) {
	ProfilePage* self;
	cairo_surface_t* surface = NULL;
	AvatarWidget* _tmp10_;
	cairo_surface_t* _tmp11_;
	GtkSpinner* _tmp12_;
	GtkStack* _tmp13_;
	GError * _inner_error_ = NULL;
	self = _data23_->self;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		GdkPixbuf* pixbuf = NULL;
		GAsyncResult* _tmp0_;
		GdkPixbuf* _tmp1_;
		_tmp0_ = res;
		_tmp1_ = tweet_utils_download_avatar_finish (_tmp0_, &_inner_error_);
		pixbuf = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch19_g_error;
		}
		if (pixbuf == NULL) {
			cairo_surface_t* _tmp2_;
			cairo_surface_t* _tmp3_;
			_tmp2_ = twitter_no_avatar;
			_tmp3_ = scale_surface ((cairo_surface_t*) _tmp2_, 100, 100);
			_cairo_surface_destroy0 (surface);
			surface = _tmp3_;
		} else {
			gint _tmp4_;
			cairo_surface_t* _tmp5_;
			_tmp4_ = _data23_->scale;
			_tmp5_ = gdk_cairo_surface_create_from_pixbuf (pixbuf, _tmp4_, NULL);
			_cairo_surface_destroy0 (surface);
			surface = _tmp5_;
		}
		_g_object_unref0 (pixbuf);
	}
	goto __finally19;
	__catch19_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		cairo_surface_t* _tmp8_;
		cairo_surface_t* _tmp9_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_warning ("ProfilePage.vala:240: %s", _tmp7_);
		_tmp8_ = twitter_no_avatar;
		_tmp9_ = _cairo_surface_reference0 (_tmp8_);
		_cairo_surface_destroy0 (surface);
		surface = _tmp9_;
		_g_error_free0 (e);
	}
	__finally19:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_cairo_surface_destroy0 (surface);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp10_ = self->priv->avatar_image;
	_tmp11_ = surface;
	avatar_widget_set_surface (_tmp10_, _tmp11_);
	_tmp12_ = self->priv->progress_spinner;
	gtk_spinner_stop (_tmp12_);
	_tmp13_ = self->priv->loading_stack;
	gtk_stack_set_visible_child_name (_tmp13_, "data");
	_cairo_surface_destroy0 (surface);
}


static void ___lambda146__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda146_ (self, source_object, res);
	block23_data_unref (self);
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static gpointer _json_array_ref0 (gpointer self) {
	return self ? json_array_ref (self) : NULL;
}


static void ___lambda148_ (Block23Data* _data23_, JsonArray* arr, guint i, JsonNode* node) {
	ProfilePage* self;
	JsonObject* ent = NULL;
	JsonNode* _tmp0_;
	JsonObject* _tmp1_;
	JsonObject* _tmp2_;
	gchar* expanded_url = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	JsonArray* indices = NULL;
	JsonArray* _tmp5_;
	JsonArray* _tmp6_;
	CbTextEntity* _tmp7_;
	gint _tmp7__length1;
	guint _tmp8_;
	gint64 _tmp9_;
	gint64 _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	CbTextEntity _tmp14_ = {0};
	CbTextEntity _tmp15_;
	self = _data23_->self;
	g_return_if_fail (arr != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node;
	_tmp1_ = json_node_get_object (_tmp0_);
	_tmp2_ = _json_object_ref0 (_tmp1_);
	ent = _tmp2_;
	_tmp3_ = json_object_get_string_member (ent, "expanded_url");
	_tmp4_ = g_strdup (_tmp3_);
	expanded_url = _tmp4_;
	_tmp5_ = json_object_get_array_member (ent, "indices");
	_tmp6_ = _json_array_ref0 (_tmp5_);
	indices = _tmp6_;
	_tmp7_ = _data23_->text_urls;
	_tmp7__length1 = _data23_->text_urls_length1;
	_tmp8_ = i;
	_tmp9_ = json_array_get_int_element (indices, (guint) 0);
	_tmp10_ = json_array_get_int_element (indices, (guint) 1);
	_tmp11_ = g_strdup (expanded_url);
	_tmp12_ = json_object_get_string_member (ent, "display_url");
	_tmp13_ = g_strdup (_tmp12_);
	memset (&_tmp14_, 0, sizeof (CbTextEntity));
	_tmp14_.from = (guint) _tmp9_;
	_tmp14_.to = (guint) _tmp10_;
	_g_free0 (_tmp14_.target);
	_tmp14_.target = _tmp11_;
	_g_free0 (_tmp14_.display_text);
	_tmp14_.display_text = _tmp13_;
	cb_text_entity_free (&_tmp7_[_tmp8_]);
	_tmp7_[_tmp8_] = _tmp14_;
	_tmp15_ = _tmp7_[_tmp8_];
	_json_array_unref0 (indices);
	_g_free0 (expanded_url);
	_json_object_unref0 (ent);
}


static void ____lambda148__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	___lambda148_ (self, array, index_, element_node);
}


static gboolean profile_page_load_profile_data_co (ProfilePageLoadProfileDataData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data23_ = g_slice_new0 (Block23Data);
	_data_->_data23_->_ref_count_ = 1;
	_data_->_data23_->self = g_object_ref (_data_->self);
	_data_->_data23_->_async_data_ = _data_;
	_data_->_tmp0_ = _data_->self->priv->follow_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, gtk_widget_get_type (), GtkWidget), FALSE);
	_data_->_tmp1_ = _data_->self->account;
	_data_->_tmp2_ = _data_->_tmp1_->proxy;
	_data_->_tmp3_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp2_, rest_proxy_get_type (), RestProxy));
	_data_->call = _data_->_tmp3_;
	_data_->_tmp4_ = _data_->call;
	rest_proxy_call_set_method (_data_->_tmp4_, "GET");
	_data_->_tmp5_ = _data_->call;
	rest_proxy_call_set_function (_data_->_tmp5_, "1.1/users/show.json");
	_data_->_tmp6_ = _data_->call;
	_data_->_tmp7_ = _data_->user_id;
	_data_->_tmp8_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp7_);
	_data_->_tmp9_ = _data_->_tmp8_;
	rest_proxy_call_add_param (_data_->_tmp6_, "user_id", _data_->_tmp9_);
	_g_free0 (_data_->_tmp9_);
	_data_->_tmp10_ = _data_->call;
	rest_proxy_call_add_param (_data_->_tmp10_, "include_entities", "false");
	_data_->root_node = NULL;
	{
		_data_->_tmp12_ = _data_->call;
		_data_->_tmp13_ = _data_->self->priv->data_cancellable;
		_data_->_state_ = 1;
		cb_utils_load_threaded_async (_data_->_tmp12_, _data_->_tmp13_, profile_page_load_profile_data_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp14_ = cb_utils_load_threaded_finish (_data_->_res_, &_data_->_inner_error_);
		_data_->_tmp11_ = _data_->_tmp14_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch17_g_error;
		}
		_data_->_tmp15_ = _data_->_tmp11_;
		_data_->_tmp11_ = NULL;
		__vala_JsonNode_free0 (_data_->root_node);
		_data_->root_node = _data_->_tmp15_;
		__vala_JsonNode_free0 (_data_->_tmp11_);
	}
	goto __finally17;
	__catch17_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp16_ = _data_->e;
		_data_->_tmp17_ = _data_->_tmp16_->message;
		g_warning ("ProfilePage.vala:212: %s", _data_->_tmp17_);
		_g_error_free0 (_data_->e);
		__vala_JsonNode_free0 (_data_->root_node);
		_g_object_unref0 (_data_->call);
		block23_data_unref (_data_->_data23_);
		_data_->_data23_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (g_task_get_completed (_data_->_async_result) != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally17:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		__vala_JsonNode_free0 (_data_->root_node);
		_g_object_unref0 (_data_->call);
		block23_data_unref (_data_->_data23_);
		_data_->_data23_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp18_ = _data_->root_node;
	if (_data_->_tmp18_ == NULL) {
		__vala_JsonNode_free0 (_data_->root_node);
		_g_object_unref0 (_data_->call);
		block23_data_unref (_data_->_data23_);
		_data_->_data23_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (g_task_get_completed (_data_->_async_result) != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp19_ = _data_->root_node;
	_data_->_tmp20_ = json_node_get_object (_data_->_tmp19_);
	_data_->_tmp21_ = _json_object_ref0 (_data_->_tmp20_);
	_data_->root = _data_->_tmp21_;
	_data_->_tmp22_ = _data_->root;
	_data_->_tmp23_ = json_object_get_int_member (_data_->_tmp22_, "id");
	_data_->id = _data_->_tmp23_;
	_data_->_tmp24_ = _data_->root;
	_data_->_tmp25_ = json_object_get_string_member (_data_->_tmp24_, "profile_image_url");
	_data_->_tmp26_ = g_strdup (_data_->_tmp25_);
	_data_->avatar_url = _data_->_tmp26_;
	_data_->_tmp27_ = gtk_widget_get_scale_factor (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, gtk_widget_get_type (), GtkWidget));
	_data_->_data23_->scale = _data_->_tmp27_;
	_data_->_tmp28_ = _data_->avatar_url;
	_data_->_tmp29_ = string_replace (_data_->_tmp28_, "_normal", "_200x200");
	_g_free0 (_data_->avatar_url);
	_data_->avatar_url = _data_->_tmp29_;
	_data_->_tmp30_ = _data_->avatar_url;
	_data_->_tmp31_ = _data_->_data23_->scale;
	_data_->_tmp32_ = _data_->self->priv->data_cancellable;
	tweet_utils_download_avatar (_data_->_tmp30_, 100 * _data_->_tmp31_, _data_->_tmp32_, ___lambda146__gasync_ready_callback, block23_data_ref (_data_->_data23_));
	_data_->_tmp33_ = _data_->root;
	_data_->_tmp34_ = json_object_get_string_member (_data_->_tmp33_, "name");
	_data_->_tmp35_ = string_replace (_data_->_tmp34_, "&", "&amp;");
	_data_->_tmp36_ = _data_->_tmp35_;
	_data_->_tmp37_ = string_strip (_data_->_tmp36_);
	_data_->_tmp38_ = _data_->_tmp37_;
	_g_free0 (_data_->_tmp36_);
	_data_->name = _data_->_tmp38_;
	_data_->_tmp39_ = _data_->root;
	_data_->_tmp40_ = json_object_get_string_member (_data_->_tmp39_, "screen_name");
	_data_->_tmp41_ = g_strdup (_data_->_tmp40_);
	_data_->screen_name = _data_->_tmp41_;
	_data_->_tmp42_ = _data_->root;
	_data_->_tmp43_ = json_object_get_string_member (_data_->_tmp42_, "description");
	_data_->_tmp44_ = g_strdup (_data_->_tmp43_);
	_data_->description = _data_->_tmp44_;
	_data_->_tmp45_ = _data_->root;
	_data_->_tmp46_ = json_object_get_int_member (_data_->_tmp45_, "followers_count");
	_data_->followers = (gint) _data_->_tmp46_;
	_data_->_tmp47_ = _data_->root;
	_data_->_tmp48_ = json_object_get_int_member (_data_->_tmp47_, "friends_count");
	_data_->following = (gint) _data_->_tmp48_;
	_data_->_tmp49_ = _data_->root;
	_data_->_tmp50_ = json_object_get_int_member (_data_->_tmp49_, "statuses_count");
	_data_->tweets = (gint) _data_->_tmp50_;
	_data_->is_following = FALSE;
	_data_->_tmp51_ = _data_->root;
	_data_->_tmp52_ = utils_usable_json_value (_data_->_tmp51_, "following");
	if (_data_->_tmp52_) {
		_data_->_tmp53_ = _data_->root;
		_data_->_tmp54_ = json_object_get_boolean_member (_data_->_tmp53_, "following");
		_data_->is_following = _data_->_tmp54_;
	}
	_data_->_tmp55_ = _data_->root;
	_data_->_tmp56_ = json_object_get_object_member (_data_->_tmp55_, "entities");
	_data_->_tmp57_ = json_object_has_member (_data_->_tmp56_, "url");
	_data_->has_url = _data_->_tmp57_;
	_data_->_tmp58_ = _data_->root;
	_data_->_tmp59_ = json_object_get_boolean_member (_data_->_tmp58_, "verified");
	_data_->verified = _data_->_tmp59_;
	_data_->_tmp60_ = _data_->root;
	_data_->_tmp61_ = json_object_get_boolean_member (_data_->_tmp60_, "protected");
	_data_->protected_user = _data_->_tmp61_;
	_data_->_tmp62_ = _data_->protected_user;
	if (_data_->_tmp62_) {
		_data_->_tmp63_ = _data_->self->priv->tweet_list;
		tweet_list_box_set_placeholder_text (_data_->_tmp63_, _ ("Protected profile"));
	}
	_data_->_tmp64_ = _data_->root;
	_data_->_tmp65_ = json_object_get_string_member (_data_->_tmp64_, "profile_background_color");
	_data_->_tmp66_ = g_strdup (_data_->_tmp65_);
	_data_->color = _data_->_tmp66_;
	_data_->_tmp67_ = _data_->self->priv->banner_image;
	_data_->_tmp68_ = _data_->color;
	_data_->_tmp69_ = g_strconcat ("#", _data_->_tmp68_, NULL);
	_data_->_tmp70_ = _data_->_tmp69_;
	aspect_image_set_color_string (_data_->_tmp67_, _data_->_tmp70_);
	_g_free0 (_data_->_tmp70_);
	_data_->_tmp71_ = _data_->root;
	_data_->_tmp72_ = json_object_has_member (_data_->_tmp71_, "profile_banner_url");
	if (_data_->_tmp72_) {
		_data_->_tmp73_ = _data_->root;
		_data_->_tmp74_ = json_object_get_string_member (_data_->_tmp73_, "profile_banner_url");
		_data_->_tmp75_ = g_strdup (_data_->_tmp74_);
		_data_->banner_base_url = _data_->_tmp75_;
		_data_->_tmp76_ = _data_->banner_base_url;
		profile_page_load_profile_banner (_data_->self, _data_->_tmp76_);
		_g_free0 (_data_->banner_base_url);
	}
	_data_->_tmp77_ = g_strdup ("");
	_data_->display_url = _data_->_tmp77_;
	_data_->_tmp78_ = _data_->root;
	_data_->_tmp79_ = json_object_get_object_member (_data_->_tmp78_, "entities");
	_data_->_tmp80_ = _json_object_ref0 (_data_->_tmp79_);
	_data_->entities = _data_->_tmp80_;
	_data_->_tmp81_ = _data_->has_url;
	if (_data_->_tmp81_) {
		_data_->_tmp82_ = _data_->entities;
		_data_->_tmp83_ = json_object_get_object_member (_data_->_tmp82_, "url");
		_data_->_tmp84_ = json_object_get_array_member (_data_->_tmp83_, "urls");
		_data_->_tmp85_ = json_array_get_element (_data_->_tmp84_, (guint) 0);
		_data_->_tmp86_ = json_node_get_object (_data_->_tmp85_);
		_data_->_tmp87_ = _json_object_ref0 (_data_->_tmp86_);
		_data_->urls_object = _data_->_tmp87_;
		_data_->_tmp88_ = _data_->urls_object;
		_data_->_tmp89_ = json_object_get_string_member (_data_->_tmp88_, "expanded_url");
		_data_->_tmp90_ = g_strdup (_data_->_tmp89_);
		_data_->url = _data_->_tmp90_;
		_data_->_tmp91_ = _data_->urls_object;
		_data_->_tmp92_ = json_object_has_member (_data_->_tmp91_, "display_url");
		if (_data_->_tmp92_) {
			_data_->_tmp93_ = _data_->urls_object;
			_data_->_tmp94_ = json_object_get_string_member (_data_->_tmp93_, "expanded_url");
			_data_->_tmp95_ = g_strdup (_data_->_tmp94_);
			_g_free0 (_data_->display_url);
			_data_->display_url = _data_->_tmp95_;
		} else {
			_data_->_tmp96_ = _data_->urls_object;
			_data_->_tmp97_ = json_object_get_string_member (_data_->_tmp96_, "url");
			_data_->_tmp98_ = g_strdup (_data_->_tmp97_);
			_g_free0 (_data_->url);
			_data_->url = _data_->_tmp98_;
			_data_->_tmp99_ = _data_->url;
			_data_->_tmp100_ = g_strdup (_data_->_tmp99_);
			_g_free0 (_data_->display_url);
			_data_->display_url = _data_->_tmp100_;
		}
		_g_free0 (_data_->url);
		_json_object_unref0 (_data_->urls_object);
	}
	_data_->location = NULL;
	_data_->_tmp101_ = _data_->root;
	_data_->_tmp102_ = json_object_has_member (_data_->_tmp101_, "location");
	if (_data_->_tmp102_) {
		_data_->_tmp103_ = _data_->root;
		_data_->_tmp104_ = json_object_get_string_member (_data_->_tmp103_, "location");
		_data_->_tmp105_ = g_strdup (_data_->_tmp104_);
		_g_free0 (_data_->location);
		_data_->location = _data_->_tmp105_;
	}
	_data_->_data23_->text_urls = NULL;
	_data_->_data23_->text_urls_length1 = 0;
	_data_->_data23_->_text_urls_size_ = _data_->_data23_->text_urls_length1;
	_data_->_tmp106_ = _data_->root;
	_data_->_tmp107_ = json_object_has_member (_data_->_tmp106_, "description");
	if (_data_->_tmp107_) {
		_data_->_tmp108_ = _data_->entities;
		_data_->_tmp109_ = json_object_get_object_member (_data_->_tmp108_, "description");
		_data_->_tmp110_ = json_object_get_array_member (_data_->_tmp109_, "urls");
		_data_->_tmp111_ = _json_array_ref0 (_data_->_tmp110_);
		_data_->urls = _data_->_tmp111_;
		_data_->_tmp112_ = _data_->urls;
		_data_->_tmp113_ = json_array_get_length (_data_->_tmp112_);
		_data_->_tmp114_ = g_new0 (CbTextEntity, _data_->_tmp113_);
		_data_->_data23_->text_urls = (_vala_CbTextEntity_array_free (_data_->_data23_->text_urls, _data_->_data23_->text_urls_length1), NULL);
		_data_->_data23_->text_urls = _data_->_tmp114_;
		_data_->_data23_->text_urls_length1 = _data_->_tmp113_;
		_data_->_data23_->_text_urls_size_ = _data_->_data23_->text_urls_length1;
		_data_->_tmp115_ = _data_->urls;
		json_array_foreach_element (_data_->_tmp115_, ____lambda148__json_array_foreach, _data_->_data23_);
		_json_array_unref0 (_data_->urls);
	}
	_data_->_tmp116_ = _data_->self->account;
	_data_->_tmp117_ = _data_->_tmp116_->user_counter;
	_data_->_tmp118_ = _data_->id;
	_data_->_tmp119_ = _data_->screen_name;
	_data_->_tmp120_ = _data_->name;
	cb_user_counter_user_seen (_data_->_tmp117_, _data_->_tmp118_, _data_->_tmp119_, _data_->_tmp120_);
	_data_->_tmp121_ = _data_->self->priv->follow_button;
	_data_->_tmp122_ = _data_->is_following;
	follow_button_set_following (_data_->_tmp121_, _data_->_tmp122_);
	_data_->_tmp123_ = _data_->self->priv->follow_button;
	_data_->_tmp124_ = _data_->self->priv->user_id;
	_data_->_tmp125_ = _data_->self->account;
	_data_->_tmp126_ = _data_->_tmp125_->id;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp123_, gtk_widget_get_type (), GtkWidget), _data_->_tmp124_ != _data_->_tmp126_);
	_data_->_tmp127_ = _data_->self->priv->more_button;
	_data_->_tmp128_ = gtk_menu_button_get_menu_model (_data_->_tmp127_);
	_data_->_tmp129_ = _data_->_tmp128_;
	_data_->_tmp130_ = g_menu_model_get_item_link (_data_->_tmp129_, 0, G_MENU_LINK_SECTION);
	_data_->section = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp130_, g_menu_get_type (), GMenu);
	_data_->_tmp131_ = _data_->screen_name;
	_data_->_tmp132_ = string_replace (_data_->_tmp131_, "_", "__");
	_data_->_tmp133_ = _data_->_tmp132_;
	_data_->_tmp134_ = g_strdup_printf (_ ("Tweet to @%s"), _data_->_tmp133_);
	_data_->_tmp135_ = _data_->_tmp134_;
	_data_->_tmp136_ = g_menu_item_new (_data_->_tmp135_, "user.tweet-to");
	_data_->_tmp137_ = _data_->_tmp136_;
	_g_free0 (_data_->_tmp135_);
	_g_free0 (_data_->_tmp133_);
	_data_->user_item = _data_->_tmp137_;
	_data_->_tmp138_ = _data_->section;
	g_menu_remove (_data_->_tmp138_, 1);
	_data_->_tmp139_ = _data_->section;
	_data_->_tmp140_ = _data_->user_item;
	g_menu_insert_item (_data_->_tmp139_, 1, _data_->_tmp140_);
	_data_->_tmp141_ = _data_->self->priv->name_label;
	_data_->_tmp142_ = _data_->name;
	_data_->_tmp143_ = string_strip (_data_->_tmp142_);
	_data_->_tmp144_ = _data_->_tmp143_;
	gtk_label_set_markup (_data_->_tmp141_, _data_->_tmp144_);
	_g_free0 (_data_->_tmp144_);
	_data_->_tmp145_ = _data_->self->priv->screen_name_label;
	_data_->_tmp146_ = _data_->screen_name;
	_data_->_tmp147_ = g_strconcat ("@", _data_->_tmp146_, NULL);
	_data_->_tmp148_ = _data_->_tmp147_;
	gtk_label_set_label (_data_->_tmp145_, _data_->_tmp148_);
	_g_free0 (_data_->_tmp148_);
	_data_->_tmp149_ = _data_->description;
	_data_->_tmp150_ = g_strdup (_data_->_tmp149_);
	_data_->desc = _data_->_tmp150_;
	_data_->_tmp151_ = _data_->_data23_->text_urls;
	_data_->_tmp151__length1 = _data_->_data23_->text_urls_length1;
	if (_data_->_tmp151_ != NULL) {
		tweet_utils_sort_entities (&_data_->_data23_->text_urls, &_data_->_data23_->text_urls_length1);
		_data_->_tmp152_ = _data_->description;
		_data_->_tmp153_ = _data_->_data23_->text_urls;
		_data_->_tmp153__length1 = _data_->_data23_->text_urls_length1;
		_data_->_tmp154_ = cb_text_transform_text (_data_->_tmp152_, _data_->_tmp153_, _data_->_tmp153__length1, (guint) 0, (gsize) 0, (gint64) 0, (guint) 0);
		_g_free0 (_data_->desc);
		_data_->desc = _data_->_tmp154_;
	}
	_data_->_tmp155_ = _data_->followers;
	_data_->self->priv->follower_count = _data_->_tmp155_;
	_data_->_tmp156_ = _data_->self->priv->description_label;
	_data_->_tmp157_ = _data_->desc;
	_data_->_tmp158_ = string_replace (_data_->_tmp157_, "&", "&amp;");
	_data_->_tmp159_ = _data_->_tmp158_;
	_data_->_tmp160_ = g_strdup_printf ("<big>%s</big>", _data_->_tmp159_);
	_data_->_tmp161_ = _data_->_tmp160_;
	gtk_label_set_label (_data_->_tmp156_, _data_->_tmp161_);
	_g_free0 (_data_->_tmp161_);
	_g_free0 (_data_->_tmp159_);
	_data_->_tmp162_ = _data_->self->priv->tweets_label;
	_data_->_tmp163_ = _data_->tweets;
	_data_->_tmp164_ = g_strdup_printf ("%'d", _data_->_tmp163_);
	_data_->_tmp165_ = _data_->_tmp164_;
	gtk_label_set_label (_data_->_tmp162_, _data_->_tmp165_);
	_g_free0 (_data_->_tmp165_);
	_data_->_tmp166_ = _data_->self->priv->following_label;
	_data_->_tmp167_ = _data_->following;
	_data_->_tmp168_ = g_strdup_printf ("%'d", _data_->_tmp167_);
	_data_->_tmp169_ = _data_->_tmp168_;
	gtk_label_set_label (_data_->_tmp166_, _data_->_tmp169_);
	_g_free0 (_data_->_tmp169_);
	profile_page_update_follower_label (_data_->self);
	_data_->_tmp171_ = _data_->location;
	if (_data_->_tmp171_ != NULL) {
		_data_->_tmp172_ = _data_->location;
		_data_->_tmp170_ = g_strcmp0 (_data_->_tmp172_, "") != 0;
	} else {
		_data_->_tmp170_ = FALSE;
	}
	if (_data_->_tmp170_) {
		_data_->_tmp173_ = _data_->self->priv->location_label;
		gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp173_, gtk_widget_get_type (), GtkWidget), TRUE);
		_data_->_tmp174_ = _data_->self->priv->location_label;
		_data_->_tmp175_ = _data_->location;
		gtk_label_set_label (_data_->_tmp174_, _data_->_tmp175_);
	} else {
		_data_->_tmp176_ = _data_->self->priv->location_label;
		gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp176_, gtk_widget_get_type (), GtkWidget), FALSE);
	}
	_data_->_tmp177_ = _data_->self->priv->avatar_image;
	_data_->_tmp178_ = _data_->verified;
	avatar_widget_set_verified (_data_->_tmp177_, _data_->_tmp178_);
	_data_->_tmp179_ = _data_->display_url;
	_data_->_tmp180_ = strlen (_data_->_tmp179_);
	_data_->_tmp181_ = _data_->_tmp180_;
	if (_data_->_tmp181_ > 0) {
		_data_->_tmp182_ = _data_->self->priv->url_label;
		gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp182_, gtk_widget_get_type (), GtkWidget), TRUE);
		_data_->_tmp183_ = _data_->self->priv->url_label;
		_data_->_tmp184_ = _data_->display_url;
		_data_->_tmp185_ = _data_->display_url;
		_data_->_tmp186_ = g_strdup_printf ("<span underline='none'><a href='%s'>%s</a></span>", _data_->_tmp184_, _data_->_tmp185_);
		_data_->_tmp187_ = _data_->_tmp186_;
		gtk_label_set_markup (_data_->_tmp183_, _data_->_tmp187_);
		_g_free0 (_data_->_tmp187_);
		_data_->_tmp188_ = _data_->self->priv->description_label;
		gtk_widget_set_margin_bottom (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp188_, gtk_widget_get_type (), GtkWidget), 6);
	} else {
		_data_->_tmp189_ = _data_->self->priv->url_label;
		gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp189_, gtk_widget_get_type (), GtkWidget), FALSE);
		_data_->_tmp190_ = _data_->self->priv->description_label;
		gtk_widget_set_margin_bottom (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp190_, gtk_widget_get_type (), GtkWidget), 12);
	}
	_data_->_tmp191_ = _data_->name;
	_data_->_tmp192_ = g_strdup (_data_->_tmp191_);
	_g_free0 (_data_->self->priv->name);
	_data_->self->priv->name = _data_->_tmp192_;
	_data_->_tmp193_ = _data_->screen_name;
	_data_->_tmp194_ = g_strdup (_data_->_tmp193_);
	_g_free0 (_data_->self->priv->screen_name);
	_data_->self->priv->screen_name = _data_->_tmp194_;
	_data_->_tmp195_ = _data_->avatar_url;
	_data_->_tmp196_ = g_strdup (_data_->_tmp195_);
	_g_free0 (_data_->self->priv->avatar_url);
	_data_->self->priv->avatar_url = _data_->_tmp196_;
	_g_free0 (_data_->desc);
	_g_object_unref0 (_data_->user_item);
	_g_object_unref0 (_data_->section);
	_g_free0 (_data_->location);
	_json_object_unref0 (_data_->entities);
	_g_free0 (_data_->display_url);
	_g_free0 (_data_->color);
	_g_free0 (_data_->description);
	_g_free0 (_data_->screen_name);
	_g_free0 (_data_->name);
	_g_free0 (_data_->avatar_url);
	_json_object_unref0 (_data_->root);
	__vala_JsonNode_free0 (_data_->root_node);
	_g_object_unref0 (_data_->call);
	block23_data_unref (_data_->_data23_);
	_data_->_data23_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void profile_page_load_tweets_data_free (gpointer _data) {
	ProfilePageLoadTweetsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ProfilePageLoadTweetsData, _data_);
}


static void profile_page_load_tweets (ProfilePage* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ProfilePageLoadTweetsData* _data_;
	ProfilePage* _tmp0_;
	_data_ = g_slice_new0 (ProfilePageLoadTweetsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, profile_page_load_tweets_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	profile_page_load_tweets_co (_data_);
}


static void profile_page_load_tweets_finish (ProfilePage* self, GAsyncResult* _res_) {
	ProfilePageLoadTweetsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}


static void profile_page_load_tweets_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ProfilePageLoadTweetsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	profile_page_load_tweets_co (_data_);
}


static gboolean profile_page_load_tweets_co (ProfilePageLoadTweetsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->tweet_list;
	tweet_list_box_set_unempty (_data_->_tmp0_);
	_data_->self->priv->tweets_loading = TRUE;
	_data_->requested_tweet_count = 10;
	_data_->_tmp1_ = _data_->self->account;
	_data_->_tmp2_ = _data_->_tmp1_->proxy;
	_data_->_tmp3_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp2_, rest_proxy_get_type (), RestProxy));
	_data_->call = _data_->_tmp3_;
	_data_->_tmp4_ = _data_->call;
	rest_proxy_call_set_function (_data_->_tmp4_, "1.1/statuses/user_timeline.json");
	_data_->_tmp5_ = _data_->call;
	rest_proxy_call_set_method (_data_->_tmp5_, "GET");
	_data_->_tmp6_ = _data_->call;
	_data_->_tmp7_ = _data_->self->priv->user_id;
	_data_->_tmp8_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp7_);
	_data_->_tmp9_ = _data_->_tmp8_;
	rest_proxy_call_add_param (_data_->_tmp6_, "user_id", _data_->_tmp9_);
	_g_free0 (_data_->_tmp9_);
	_data_->_tmp10_ = _data_->call;
	_data_->_tmp11_ = _data_->requested_tweet_count;
	_data_->_tmp12_ = g_strdup_printf ("%i", _data_->_tmp11_);
	_data_->_tmp13_ = _data_->_tmp12_;
	rest_proxy_call_add_param (_data_->_tmp10_, "count", _data_->_tmp13_);
	_g_free0 (_data_->_tmp13_);
	_data_->_tmp14_ = _data_->call;
	rest_proxy_call_add_param (_data_->_tmp14_, "contributor_details", "true");
	_data_->_tmp15_ = _data_->call;
	rest_proxy_call_add_param (_data_->_tmp15_, "tweet_mode", "extended");
	_data_->_tmp16_ = _data_->call;
	rest_proxy_call_add_param (_data_->_tmp16_, "include_my_retweet", "true");
	_data_->root = NULL;
	{
		_data_->_tmp18_ = _data_->call;
		_data_->_tmp19_ = _data_->self->priv->data_cancellable;
		_data_->_state_ = 1;
		cb_utils_load_threaded_async (_data_->_tmp18_, _data_->_tmp19_, profile_page_load_tweets_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp20_ = cb_utils_load_threaded_finish (_data_->_res_, &_data_->_inner_error_);
		_data_->_tmp17_ = _data_->_tmp20_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch20_g_error;
		}
		_data_->_tmp21_ = _data_->_tmp17_;
		_data_->_tmp17_ = NULL;
		__vala_JsonNode_free0 (_data_->root);
		_data_->root = _data_->_tmp21_;
		__vala_JsonNode_free0 (_data_->_tmp17_);
	}
	goto __finally20;
	__catch20_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp22_ = _data_->e;
		_data_->_tmp23_ = _data_->_tmp22_->message;
		g_warning ("ProfilePage.vala:385: %s", _data_->_tmp23_);
		_data_->_tmp24_ = _data_->self->priv->tweet_list;
		tweet_list_box_set_empty (_data_->_tmp24_);
		_g_error_free0 (_data_->e);
		__vala_JsonNode_free0 (_data_->root);
		_g_object_unref0 (_data_->call);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (g_task_get_completed (_data_->_async_result) != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally20:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		__vala_JsonNode_free0 (_data_->root);
		_g_object_unref0 (_data_->call);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp25_ = _data_->root;
	if (_data_->_tmp25_ == NULL) {
		__vala_JsonNode_free0 (_data_->root);
		_g_object_unref0 (_data_->call);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (g_task_get_completed (_data_->_async_result) != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp26_ = _data_->root;
	_data_->_tmp27_ = json_node_get_array (_data_->_tmp26_);
	_data_->_tmp28_ = _json_array_ref0 (_data_->_tmp27_);
	_data_->root_array = _data_->_tmp28_;
	_data_->_tmp29_ = _data_->root_array;
	_data_->_tmp30_ = json_array_get_length (_data_->_tmp29_);
	if (_data_->_tmp30_ == ((guint) 0)) {
		_data_->_tmp31_ = _data_->self->priv->tweet_list;
		tweet_list_box_set_empty (_data_->_tmp31_);
		_json_array_unref0 (_data_->root_array);
		__vala_JsonNode_free0 (_data_->root);
		_g_object_unref0 (_data_->call);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (g_task_get_completed (_data_->_async_result) != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp32_ = _data_->root_array;
	_data_->_tmp33_ = _data_->self->priv->tweet_list;
	_data_->_tmp34_ = _data_->self->account;
	tweet_utils_work_array (_data_->_tmp32_, _data_->_tmp33_, _data_->_tmp34_);
	_data_->self->priv->tweets_loading = FALSE;
	_json_array_unref0 (_data_->root_array);
	__vala_JsonNode_free0 (_data_->root);
	_g_object_unref0 (_data_->call);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void profile_page_load_older_tweets_data_free (gpointer _data) {
	ProfilePageLoadOlderTweetsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ProfilePageLoadOlderTweetsData, _data_);
}


static void profile_page_load_older_tweets (ProfilePage* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ProfilePageLoadOlderTweetsData* _data_;
	ProfilePage* _tmp0_;
	_data_ = g_slice_new0 (ProfilePageLoadOlderTweetsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, profile_page_load_older_tweets_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	profile_page_load_older_tweets_co (_data_);
}


static void profile_page_load_older_tweets_finish (ProfilePage* self, GAsyncResult* _res_) {
	ProfilePageLoadOlderTweetsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}


static void profile_page_load_older_tweets_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ProfilePageLoadOlderTweetsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	profile_page_load_older_tweets_co (_data_);
}


static gboolean profile_page_load_older_tweets_co (ProfilePageLoadOlderTweetsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->tweets_loading;
	if (_data_->_tmp0_) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (g_task_get_completed (_data_->_async_result) != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = _data_->self->priv->user_stack;
	_data_->_tmp2_ = gtk_stack_get_visible_child (_data_->_tmp1_);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = _data_->self->priv->tweet_list;
	if (_data_->_tmp3_ != G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp4_, gtk_widget_get_type (), GtkWidget)) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (g_task_get_completed (_data_->_async_result) != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->self->priv->tweets_loading = TRUE;
	_data_->requested_tweet_count = 15;
	_data_->_tmp5_ = _data_->self->account;
	_data_->_tmp6_ = _data_->_tmp5_->proxy;
	_data_->_tmp7_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp6_, rest_proxy_get_type (), RestProxy));
	_data_->call = _data_->_tmp7_;
	_data_->_tmp8_ = _data_->call;
	rest_proxy_call_set_function (_data_->_tmp8_, "1.1/statuses/user_timeline.json");
	_data_->_tmp9_ = _data_->call;
	rest_proxy_call_set_method (_data_->_tmp9_, "GET");
	_data_->_tmp10_ = _data_->call;
	_data_->_tmp11_ = _data_->self->priv->user_id;
	_data_->_tmp12_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp11_);
	_data_->_tmp13_ = _data_->_tmp12_;
	rest_proxy_call_add_param (_data_->_tmp10_, "user_id", _data_->_tmp13_);
	_g_free0 (_data_->_tmp13_);
	_data_->_tmp14_ = _data_->call;
	_data_->_tmp15_ = _data_->requested_tweet_count;
	_data_->_tmp16_ = g_strdup_printf ("%i", _data_->_tmp15_);
	_data_->_tmp17_ = _data_->_tmp16_;
	rest_proxy_call_add_param (_data_->_tmp14_, "count", _data_->_tmp17_);
	_g_free0 (_data_->_tmp17_);
	_data_->_tmp18_ = _data_->call;
	rest_proxy_call_add_param (_data_->_tmp18_, "contributor_details", "true");
	_data_->_tmp19_ = _data_->call;
	rest_proxy_call_add_param (_data_->_tmp19_, "include_my_retweet", "true");
	_data_->_tmp20_ = _data_->call;
	rest_proxy_call_add_param (_data_->_tmp20_, "tweet_mode", "extended");
	_data_->_tmp21_ = _data_->call;
	_data_->_tmp22_ = _data_->self->priv->tweet_list;
	_data_->_tmp23_ = _data_->_tmp22_->model;
	_data_->_tmp24_ = _data_->_tmp23_->min_id;
	_data_->_tmp25_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp24_ - 1);
	_data_->_tmp26_ = _data_->_tmp25_;
	rest_proxy_call_add_param (_data_->_tmp21_, "max_id", _data_->_tmp26_);
	_g_free0 (_data_->_tmp26_);
	_data_->root = NULL;
	{
		_data_->_tmp28_ = _data_->call;
		_data_->_tmp29_ = _data_->self->priv->data_cancellable;
		_data_->_state_ = 1;
		cb_utils_load_threaded_async (_data_->_tmp28_, _data_->_tmp29_, profile_page_load_older_tweets_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp30_ = cb_utils_load_threaded_finish (_data_->_res_, &_data_->_inner_error_);
		_data_->_tmp27_ = _data_->_tmp30_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch21_g_error;
		}
		_data_->_tmp31_ = _data_->_tmp27_;
		_data_->_tmp27_ = NULL;
		__vala_JsonNode_free0 (_data_->root);
		_data_->root = _data_->_tmp31_;
		__vala_JsonNode_free0 (_data_->_tmp27_);
	}
	goto __finally21;
	__catch21_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp32_ = _data_->e;
		_data_->_tmp33_ = _data_->_tmp32_->message;
		g_warning ("ProfilePage.vala:426: %s", _data_->_tmp33_);
		_g_error_free0 (_data_->e);
		__vala_JsonNode_free0 (_data_->root);
		_g_object_unref0 (_data_->call);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (g_task_get_completed (_data_->_async_result) != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally21:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		__vala_JsonNode_free0 (_data_->root);
		_g_object_unref0 (_data_->call);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp34_ = _data_->root;
	if (_data_->_tmp34_ == NULL) {
		__vala_JsonNode_free0 (_data_->root);
		_g_object_unref0 (_data_->call);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (g_task_get_completed (_data_->_async_result) != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp35_ = _data_->root;
	_data_->_tmp36_ = json_node_get_array (_data_->_tmp35_);
	_data_->_tmp37_ = _json_array_ref0 (_data_->_tmp36_);
	_data_->root_arr = _data_->_tmp37_;
	_data_->_tmp38_ = _data_->root_arr;
	_data_->_tmp39_ = _data_->self->priv->tweet_list;
	_data_->_tmp40_ = _data_->self->account;
	tweet_utils_work_array (_data_->_tmp38_, _data_->_tmp39_, _data_->_tmp40_);
	_data_->self->priv->tweets_loading = FALSE;
	_json_array_unref0 (_data_->root_arr);
	__vala_JsonNode_free0 (_data_->root);
	_g_object_unref0 (_data_->call);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void profile_page_load_followers_data_free (gpointer _data) {
	ProfilePageLoadFollowersData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ProfilePageLoadFollowersData, _data_);
}


static void profile_page_load_followers (ProfilePage* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ProfilePageLoadFollowersData* _data_;
	ProfilePage* _tmp0_;
	_data_ = g_slice_new0 (ProfilePageLoadFollowersData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, profile_page_load_followers_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	profile_page_load_followers_co (_data_);
}


static void profile_page_load_followers_finish (ProfilePage* self, GAsyncResult* _res_) {
	ProfilePageLoadFollowersData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}


static void profile_page_load_followers_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ProfilePageLoadFollowersData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	profile_page_load_followers_co (_data_);
}


static void __lambda122_ (ProfilePage* self, JsonArray* array, guint index, JsonNode* node) {
	JsonObject* user_obj = NULL;
	JsonNode* _tmp0_;
	JsonObject* _tmp1_;
	JsonObject* _tmp2_;
	gchar* avatar_url = NULL;
	JsonObject* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gint _tmp6_;
	UserListEntry* entry = NULL;
	UserListEntry* _tmp9_;
	JsonObject* _tmp10_;
	gint64 _tmp11_;
	JsonObject* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	JsonObject* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	GtkStyleContext* _tmp19_;
	TweetListBox* _tmp20_;
	g_return_if_fail (array != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node;
	_tmp1_ = json_node_get_object (_tmp0_);
	_tmp2_ = _json_object_ref0 (_tmp1_);
	user_obj = _tmp2_;
	_tmp3_ = user_obj;
	_tmp4_ = json_object_get_string_member (_tmp3_, "profile_image_url");
	_tmp5_ = g_strdup (_tmp4_);
	avatar_url = _tmp5_;
	_tmp6_ = gtk_widget_get_scale_factor (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	if (_tmp6_ == 2) {
		const gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp7_ = avatar_url;
		_tmp8_ = string_replace (_tmp7_, "_normal", "_bigger");
		_g_free0 (avatar_url);
		avatar_url = _tmp8_;
	}
	_tmp9_ = user_list_entry_new ();
	g_object_ref_sink (_tmp9_);
	entry = _tmp9_;
	user_list_entry_set_show_settings (entry, FALSE);
	_tmp10_ = user_obj;
	_tmp11_ = json_object_get_int_member (_tmp10_, "id");
	user_list_entry_set_user_id (entry, _tmp11_);
	_tmp12_ = user_obj;
	_tmp13_ = json_object_get_string_member (_tmp12_, "screen_name");
	_tmp14_ = g_strconcat ("@", _tmp13_, NULL);
	_tmp15_ = _tmp14_;
	user_list_entry_set_screen_name (entry, _tmp15_);
	_g_free0 (_tmp15_);
	_tmp16_ = user_obj;
	_tmp17_ = json_object_get_string_member (_tmp16_, "name");
	user_list_entry_set_name (entry, _tmp17_);
	_tmp18_ = avatar_url;
	user_list_entry_set_avatar_url (entry, _tmp18_);
	_tmp19_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (entry, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp19_, "tweet");
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (entry, gtk_widget_get_type (), GtkWidget));
	_tmp20_ = self->priv->followers_list;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (entry, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (entry);
	_g_free0 (avatar_url);
	_json_object_unref0 (user_obj);
}


static void ___lambda122__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	__lambda122_ ((ProfilePage*) self, array, index_, element_node);
}


static gboolean profile_page_load_followers_co (ProfilePageLoadFollowersData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = _data_->self->priv->followers_cursor;
	if (_data_->_tmp1_ != NULL) {
		_data_->_tmp2_ = _data_->self->priv->followers_cursor;
		_data_->_tmp3_ = (*_data_->_tmp2_).full;
		_data_->_tmp0_ = _data_->_tmp3_;
	} else {
		_data_->_tmp0_ = FALSE;
	}
	if (_data_->_tmp0_) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (g_task_get_completed (_data_->_async_result) != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = _data_->self->priv->followers_loading;
	if (_data_->_tmp4_) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (g_task_get_completed (_data_->_async_result) != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->self->priv->followers_loading = TRUE;
	_data_->_tmp5_ = _data_->self->account;
	_data_->_tmp6_ = _data_->self->priv->user_id;
	_data_->_tmp7_ = _data_->self->priv->followers_cursor;
	_data_->_state_ = 1;
	user_utils_load_followers (_data_->_tmp5_, _data_->_tmp6_, _data_->_tmp7_, profile_page_load_followers_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp8_ = user_utils_load_followers_finish (_data_->_res_);
	_cursor_free0 (_data_->self->priv->followers_cursor);
	_data_->self->priv->followers_cursor = _data_->_tmp8_;
	_data_->_tmp9_ = _data_->self->priv->followers_cursor;
	if (_data_->_tmp9_ == NULL) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (g_task_get_completed (_data_->_async_result) != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp10_ = _data_->self->priv->followers_cursor;
	_data_->_tmp11_ = (*_data_->_tmp10_).json_object;
	_data_->_tmp12_ = json_node_get_array (_data_->_tmp11_);
	_data_->_tmp13_ = _json_array_ref0 (_data_->_tmp12_);
	_data_->users_array = _data_->_tmp13_;
	_data_->_tmp14_ = _data_->users_array;
	json_array_foreach_element (_data_->_tmp14_, ___lambda122__json_array_foreach, _data_->self);
	_data_->self->priv->followers_loading = FALSE;
	_json_array_unref0 (_data_->users_array);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void profile_page_load_following_data_free (gpointer _data) {
	ProfilePageLoadFollowingData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ProfilePageLoadFollowingData, _data_);
}


static void profile_page_load_following (ProfilePage* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ProfilePageLoadFollowingData* _data_;
	ProfilePage* _tmp0_;
	_data_ = g_slice_new0 (ProfilePageLoadFollowingData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, profile_page_load_following_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	profile_page_load_following_co (_data_);
}


static void profile_page_load_following_finish (ProfilePage* self, GAsyncResult* _res_) {
	ProfilePageLoadFollowingData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}


static void profile_page_load_following_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ProfilePageLoadFollowingData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	profile_page_load_following_co (_data_);
}


static void __lambda139_ (ProfilePage* self, JsonArray* array, guint index, JsonNode* node) {
	JsonObject* user_obj = NULL;
	JsonNode* _tmp0_;
	JsonObject* _tmp1_;
	JsonObject* _tmp2_;
	gchar* avatar_url = NULL;
	JsonObject* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gint _tmp6_;
	UserListEntry* entry = NULL;
	UserListEntry* _tmp9_;
	JsonObject* _tmp10_;
	gint64 _tmp11_;
	JsonObject* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	JsonObject* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	GtkStyleContext* _tmp19_;
	TweetListBox* _tmp20_;
	g_return_if_fail (array != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node;
	_tmp1_ = json_node_get_object (_tmp0_);
	_tmp2_ = _json_object_ref0 (_tmp1_);
	user_obj = _tmp2_;
	_tmp3_ = user_obj;
	_tmp4_ = json_object_get_string_member (_tmp3_, "profile_image_url");
	_tmp5_ = g_strdup (_tmp4_);
	avatar_url = _tmp5_;
	_tmp6_ = gtk_widget_get_scale_factor (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	if (_tmp6_ == 2) {
		const gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp7_ = avatar_url;
		_tmp8_ = string_replace (_tmp7_, "_normal", "_bigger");
		_g_free0 (avatar_url);
		avatar_url = _tmp8_;
	}
	_tmp9_ = user_list_entry_new ();
	g_object_ref_sink (_tmp9_);
	entry = _tmp9_;
	user_list_entry_set_show_settings (entry, FALSE);
	_tmp10_ = user_obj;
	_tmp11_ = json_object_get_int_member (_tmp10_, "id");
	user_list_entry_set_user_id (entry, _tmp11_);
	_tmp12_ = user_obj;
	_tmp13_ = json_object_get_string_member (_tmp12_, "screen_name");
	_tmp14_ = g_strconcat ("@", _tmp13_, NULL);
	_tmp15_ = _tmp14_;
	user_list_entry_set_screen_name (entry, _tmp15_);
	_g_free0 (_tmp15_);
	_tmp16_ = user_obj;
	_tmp17_ = json_object_get_string_member (_tmp16_, "name");
	user_list_entry_set_name (entry, _tmp17_);
	_tmp18_ = avatar_url;
	user_list_entry_set_avatar_url (entry, _tmp18_);
	_tmp19_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (entry, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp19_, "tweet");
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (entry, gtk_widget_get_type (), GtkWidget));
	_tmp20_ = self->priv->following_list;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (entry, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (entry);
	_g_free0 (avatar_url);
	_json_object_unref0 (user_obj);
}


static void ___lambda139__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	__lambda139_ ((ProfilePage*) self, array, index_, element_node);
}


static gboolean profile_page_load_following_co (ProfilePageLoadFollowingData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = _data_->self->priv->following_cursor;
	if (_data_->_tmp1_ != NULL) {
		_data_->_tmp2_ = _data_->self->priv->following_cursor;
		_data_->_tmp3_ = (*_data_->_tmp2_).full;
		_data_->_tmp0_ = _data_->_tmp3_;
	} else {
		_data_->_tmp0_ = FALSE;
	}
	if (_data_->_tmp0_) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (g_task_get_completed (_data_->_async_result) != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = _data_->self->priv->following_loading;
	if (_data_->_tmp4_) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (g_task_get_completed (_data_->_async_result) != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->self->priv->following_loading = TRUE;
	_data_->_tmp5_ = _data_->self->account;
	_data_->_tmp6_ = _data_->self->priv->user_id;
	_data_->_tmp7_ = _data_->self->priv->following_cursor;
	_data_->_state_ = 1;
	user_utils_load_following (_data_->_tmp5_, _data_->_tmp6_, _data_->_tmp7_, profile_page_load_following_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp8_ = user_utils_load_following_finish (_data_->_res_);
	_cursor_free0 (_data_->self->priv->following_cursor);
	_data_->self->priv->following_cursor = _data_->_tmp8_;
	_data_->_tmp9_ = _data_->self->priv->following_cursor;
	if (_data_->_tmp9_ == NULL) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (g_task_get_completed (_data_->_async_result) != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp10_ = _data_->self->priv->following_cursor;
	_data_->_tmp11_ = (*_data_->_tmp10_).json_object;
	_data_->_tmp12_ = json_node_get_array (_data_->_tmp11_);
	_data_->_tmp13_ = _json_array_ref0 (_data_->_tmp12_);
	_data_->users_array = _data_->_tmp13_;
	_data_->_tmp14_ = _data_->users_array;
	json_array_foreach_element (_data_->_tmp14_, ___lambda139__json_array_foreach, _data_->self);
	_data_->self->priv->following_loading = FALSE;
	_json_array_unref0 (_data_->users_array);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void __lambda147_ (ProfilePage* self, GObject* obj, GAsyncResult* res) {
	GdkPixbuf* banner = NULL;
	GAsyncResult* _tmp0_;
	GdkPixbuf* _tmp1_;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	_tmp0_ = res;
	_tmp1_ = utils_download_pixbuf_finish (_tmp0_);
	banner = _tmp1_;
	profile_page_set_banner (self, banner);
	_g_object_unref0 (banner);
}


static void ___lambda147__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda147_ ((ProfilePage*) self, source_object, res);
	g_object_unref (self);
}


static void profile_page_load_profile_banner (ProfilePage* self, const gchar* base_url) {
	gchar* banner_url = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (IS_PROFILE_PAGE (self));
	g_return_if_fail (base_url != NULL);
	_tmp0_ = base_url;
	_tmp1_ = g_strconcat (_tmp0_, "/mobile_retina", NULL);
	banner_url = _tmp1_;
	utils_download_pixbuf (banner_url, NULL, ___lambda147__gasync_ready_callback, g_object_ref (self));
	_g_free0 (banner_url);
}


static Block24Data* block24_data_ref (Block24Data* _data24_) {
	g_atomic_int_inc (&_data24_->_ref_count_);
	return _data24_;
}


static void block24_data_unref (void * _userdata_) {
	Block24Data* _data24_;
	_data24_ = (Block24Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data24_->_ref_count_)) {
		ProfilePage* self;
		self = _data24_->self;
		_g_object_unref0 (_data24_->call);
		_g_object_unref0 (self);
		g_slice_free (Block24Data, _data24_);
	}
}


static void __lambda149_ (Block24Data* _data24_, GObject* obj, GAsyncResult* res) {
	ProfilePage* self;
	FollowButton* _tmp14_;
	GError * _inner_error_ = NULL;
	self = _data24_->self;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		FollowButton* _tmp0_;
		FollowButton* _tmp1_;
		gboolean _tmp2_;
		gboolean _tmp3_;
		FollowButton* _tmp4_;
		gint64 _tmp5_;
		Account* _tmp6_;
		gint64 _tmp7_;
		RestProxyCall* _tmp8_;
		GAsyncResult* _tmp9_;
		_tmp0_ = self->priv->follow_button;
		_tmp1_ = self->priv->follow_button;
		_tmp2_ = follow_button_get_following (_tmp1_);
		_tmp3_ = _tmp2_;
		follow_button_set_following (_tmp0_, !_tmp3_);
		_tmp4_ = self->priv->follow_button;
		_tmp5_ = self->priv->user_id;
		_tmp6_ = self->account;
		_tmp7_ = _tmp6_->id;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget), _tmp5_ != _tmp7_);
		_tmp8_ = _data24_->call;
		_tmp9_ = res;
		rest_proxy_call_invoke_finish (_tmp8_, _tmp9_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch22_g_error;
		}
	}
	goto __finally22;
	__catch22_g_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		RestProxyCall* _tmp12_;
		const gchar* _tmp13_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		g_critical ("ProfilePage.vala:561: %s", _tmp11_);
		_tmp12_ = _data24_->call;
		_tmp13_ = rest_proxy_call_get_payload (_tmp12_);
		g_critical ("ProfilePage.vala:562: %s", _tmp13_);
		_g_error_free0 (e);
	}
	__finally22:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp14_ = self->priv->follow_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_widget_get_type (), GtkWidget), TRUE);
}


static void ___lambda149__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda149_ (self, source_object, res);
	block24_data_unref (self);
}


static void profile_page_follow_button_clicked_cb (ProfilePage* self) {
	Block24Data* _data24_;
	Account* _tmp0_;
	OAuthProxy* _tmp1_;
	RestProxyCall* _tmp2_;
	HomeTimeline* ht = NULL;
	MainWindow* _tmp3_;
	IPage* _tmp4_;
	FollowButton* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	FollowButton* _tmp35_;
	RestProxyCall* _tmp36_;
	RestProxyCall* _tmp37_;
	gint64 _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	RestProxyCall* _tmp41_;
	g_return_if_fail (IS_PROFILE_PAGE (self));
	_data24_ = g_slice_new0 (Block24Data);
	_data24_->_ref_count_ = 1;
	_data24_->self = g_object_ref (self);
	_tmp0_ = self->account;
	_tmp1_ = _tmp0_->proxy;
	_tmp2_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, rest_proxy_get_type (), RestProxy));
	_data24_->call = _tmp2_;
	_tmp3_ = self->priv->main_window;
	_tmp4_ = main_window_get_page (_tmp3_, (gint) PAGE_STREAM);
	ht = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_HOME_TIMELINE, HomeTimeline);
	_tmp5_ = self->priv->follow_button;
	_tmp6_ = follow_button_get_following (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_) {
		RestProxyCall* _tmp8_;
		HomeTimeline* _tmp9_;
		gint64 _tmp10_;
		HomeTimeline* _tmp11_;
		gint64 _tmp12_;
		gint _tmp13_;
		Account* _tmp14_;
		gint64 _tmp15_;
		GSimpleActionGroup* _tmp16_;
		GAction* _tmp17_;
		_tmp8_ = _data24_->call;
		rest_proxy_call_set_function (_tmp8_, "1.1/friendships/destroy.json");
		_tmp9_ = ht;
		_tmp10_ = self->priv->user_id;
		home_timeline_hide_tweets_from (_tmp9_, _tmp10_, CB_TWEET_STATE_HIDDEN_UNFOLLOWED);
		_tmp11_ = ht;
		_tmp12_ = self->priv->user_id;
		home_timeline_hide_retweets_from (_tmp11_, _tmp12_, CB_TWEET_STATE_HIDDEN_UNFOLLOWED);
		_tmp13_ = self->priv->follower_count;
		self->priv->follower_count = _tmp13_ - 1;
		_tmp14_ = self->account;
		_tmp15_ = self->priv->user_id;
		account_unfollow_id (_tmp14_, _tmp15_);
		_tmp16_ = self->priv->actions;
		_tmp17_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, g_action_map_get_type (), GActionMap), "toggle-retweets");
		g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, g_simple_action_get_type (), GSimpleAction), FALSE);
		profile_page_set_retweets_disabled (self, FALSE);
	} else {
		RestProxyCall* _tmp18_;
		RestProxyCall* _tmp19_;
		HomeTimeline* _tmp20_;
		gint64 _tmp21_;
		GSimpleActionGroup* _tmp22_;
		GAction* _tmp23_;
		GVariant* _tmp24_;
		GVariant* _tmp25_;
		gboolean _tmp26_;
		gboolean _tmp27_;
		gint _tmp30_;
		Account* _tmp31_;
		gint64 _tmp32_;
		GSimpleActionGroup* _tmp33_;
		GAction* _tmp34_;
		_tmp18_ = _data24_->call;
		rest_proxy_call_set_function (_tmp18_, "1.1/friendships/create.json");
		_tmp19_ = _data24_->call;
		rest_proxy_call_add_param (_tmp19_, "follow", "false");
		_tmp20_ = ht;
		_tmp21_ = self->priv->user_id;
		home_timeline_show_tweets_from (_tmp20_, _tmp21_, CB_TWEET_STATE_HIDDEN_UNFOLLOWED);
		_tmp22_ = self->priv->actions;
		_tmp23_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, g_action_map_get_type (), GActionMap), "toggle-retweets");
		_tmp24_ = g_action_get_state (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, g_simple_action_get_type (), GSimpleAction), g_action_get_type (), GAction));
		_tmp25_ = _tmp24_;
		_tmp26_ = g_variant_get_boolean (_tmp25_);
		_tmp27_ = !_tmp26_;
		_g_variant_unref0 (_tmp25_);
		if (_tmp27_) {
			HomeTimeline* _tmp28_;
			gint64 _tmp29_;
			_tmp28_ = ht;
			_tmp29_ = self->priv->user_id;
			home_timeline_show_retweets_from (_tmp28_, _tmp29_, CB_TWEET_STATE_HIDDEN_UNFOLLOWED);
		}
		profile_page_set_user_blocked (self, FALSE);
		_tmp30_ = self->priv->follower_count;
		self->priv->follower_count = _tmp30_ + 1;
		_tmp31_ = self->account;
		_tmp32_ = self->priv->user_id;
		account_follow_id (_tmp31_, _tmp32_);
		_tmp33_ = self->priv->actions;
		_tmp34_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, g_action_map_get_type (), GActionMap), "toggle-retweets");
		g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, g_simple_action_get_type (), GSimpleAction), TRUE);
	}
	profile_page_update_follower_label (self);
	_tmp35_ = self->priv->follow_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp36_ = _data24_->call;
	rest_proxy_call_set_method (_tmp36_, "POST");
	_tmp37_ = _data24_->call;
	_tmp38_ = self->priv->user_id;
	_tmp39_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp38_);
	_tmp40_ = _tmp39_;
	rest_proxy_call_add_param (_tmp37_, "id", _tmp40_);
	_g_free0 (_tmp40_);
	_tmp41_ = _data24_->call;
	rest_proxy_call_invoke_async (_tmp41_, NULL, ___lambda149__gasync_ready_callback, block24_data_ref (_data24_));
	_g_object_unref0 (ht);
	block24_data_unref (_data24_);
	_data24_ = NULL;
}


static void _profile_page_follow_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	profile_page_follow_button_clicked_cb ((ProfilePage*) self);
}


static gboolean profile_page_activate_link (ProfilePage* self, const gchar* uri) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	MainWindow* _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (IS_PROFILE_PAGE (self), FALSE);
	g_return_val_if_fail (uri != NULL, FALSE);
	_tmp0_ = uri;
	_tmp1_ = self->priv->main_window;
	_tmp2_ = tweet_utils_activate_link (_tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


static gboolean _profile_page_activate_link_gtk_label_activate_link (GtkLabel* _sender, const gchar* uri, gpointer self) {
	gboolean result;
	result = profile_page_activate_link ((ProfilePage*) self, uri);
	return result;
}


static inline void profile_page_set_banner (ProfilePage* self, GdkPixbuf* banner) {
	GdkPixbuf* _tmp0_;
	g_return_if_fail (IS_PROFILE_PAGE (self));
	g_return_if_fail ((banner == NULL) || GDK_IS_PIXBUF (banner));
	_tmp0_ = banner;
	if (_tmp0_ == NULL) {
		AspectImage* _tmp1_;
		GdkPixbuf* _tmp2_;
		_tmp1_ = self->priv->banner_image;
		_tmp2_ = twitter_no_banner;
		aspect_image_set_pixbuf (_tmp1_, _tmp2_);
	} else {
		AspectImage* _tmp3_;
		GdkPixbuf* _tmp4_;
		_tmp3_ = self->priv->banner_image;
		_tmp4_ = banner;
		aspect_image_set_pixbuf (_tmp3_, _tmp4_);
	}
}


/**
   * see IPage#onJoin
   */
static void profile_page_real_on_join (IPage* base, gint page_id, CbBundle* args) {
	ProfilePage * self;
	gint64 user_id = 0LL;
	CbBundle* _tmp0_;
	gint64 _tmp1_;
	gint64 _tmp2_;
	gchar* screen_name = NULL;
	CbBundle* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	GCancellable* _tmp9_;
	gint64 _tmp10_;
	gint64 _tmp11_;
	TweetListBox* _tmp23_;
	TweetListBox* _tmp24_;
	TweetListBox* _tmp25_;
	GtkRadioButton* _tmp26_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PROFILE_PAGE, ProfilePage);
	g_return_if_fail ((args == NULL) || CB_IS_BUNDLE (args));
	_tmp0_ = args;
	_tmp1_ = cb_bundle_get_int64 (_tmp0_, PROFILE_PAGE_KEY_USER_ID);
	user_id = _tmp1_;
	_tmp2_ = user_id;
	if (_tmp2_ == ((gint64) -1)) {
		return;
	}
	_tmp3_ = args;
	_tmp4_ = cb_bundle_get_string (_tmp3_, PROFILE_PAGE_KEY_SCREEN_NAME);
	_tmp5_ = g_strdup (_tmp4_);
	screen_name = _tmp5_;
	_tmp6_ = screen_name;
	if (_tmp6_ != NULL) {
		const gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp7_ = screen_name;
		_tmp8_ = g_strdup (_tmp7_);
		_g_free0 (self->priv->screen_name);
		self->priv->screen_name = _tmp8_;
	}
	_tmp9_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->data_cancellable);
	self->priv->data_cancellable = _tmp9_;
	_tmp10_ = user_id;
	_tmp11_ = self->priv->user_id;
	if (_tmp10_ != _tmp11_) {
		TweetListBox* _tmp12_;
		TweetListBox* _tmp13_;
		gint64 _tmp14_;
		Account* _tmp15_;
		gint64 _tmp16_;
		gboolean _tmp17_;
		TweetListBox* _tmp20_;
		CbTweetModel* _tmp21_;
		UserListsWidget* _tmp22_;
		profile_page_reset_data (self);
		_cursor_free0 (self->priv->followers_cursor);
		self->priv->followers_cursor = NULL;
		_tmp12_ = self->priv->followers_list;
		tweet_list_box_remove_all (_tmp12_);
		_cursor_free0 (self->priv->following_cursor);
		self->priv->following_cursor = NULL;
		_tmp13_ = self->priv->following_list;
		tweet_list_box_remove_all (_tmp13_);
		_tmp14_ = user_id;
		profile_page_set_user_id (self, _tmp14_);
		_tmp15_ = self->account;
		_tmp16_ = user_id;
		_tmp17_ = account_follows_id (_tmp15_, _tmp16_);
		if (_tmp17_) {
			FollowButton* _tmp18_;
			FollowButton* _tmp19_;
			_tmp18_ = self->priv->follow_button;
			follow_button_set_following (_tmp18_, TRUE);
			_tmp19_ = self->priv->follow_button;
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_widget_get_type (), GtkWidget), TRUE);
		}
		_tmp20_ = self->priv->tweet_list;
		_tmp21_ = _tmp20_->model;
		cb_tweet_model_clear (_tmp21_);
		_tmp22_ = self->priv->user_lists;
		user_lists_widget_clear_lists (_tmp22_);
		self->priv->lists_page_inited = FALSE;
		profile_page_load_tweets (self, NULL, NULL);
	} else {
		profile_page_load_friendship (self, NULL, NULL);
	}
	_tmp23_ = self->priv->tweet_list;
	tweet_list_box_reset_placeholder_text (_tmp23_);
	_tmp24_ = self->priv->followers_list;
	tweet_list_box_reset_placeholder_text (_tmp24_);
	_tmp25_ = self->priv->following_list;
	tweet_list_box_reset_placeholder_text (_tmp25_);
	_tmp26_ = self->priv->tweets_button;
	gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, gtk_toggle_button_get_type (), GtkToggleButton), TRUE);
	_g_free0 (screen_name);
}


static void profile_page_real_on_leave (IPage* base) {
	ProfilePage * self;
	GCancellable* _tmp0_;
	GtkMenuButton* _tmp1_;
	GtkPopover* _tmp2_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PROFILE_PAGE, ProfilePage);
	_tmp0_ = self->priv->data_cancellable;
	g_cancellable_cancel (_tmp0_);
	_tmp1_ = self->priv->more_button;
	_tmp2_ = gtk_menu_button_get_popover (_tmp1_);
	gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget));
}


static void profile_page_reset_data (ProfilePage* self) {
	GtkLabel* _tmp0_;
	GtkLabel* _tmp1_;
	GtkLabel* _tmp2_;
	GtkLabel* _tmp3_;
	GtkLabel* _tmp4_;
	GtkLabel* _tmp5_;
	GtkLabel* _tmp6_;
	GtkLabel* _tmp7_;
	AvatarWidget* _tmp8_;
	g_return_if_fail (IS_PROFILE_PAGE (self));
	_tmp0_ = self->priv->name_label;
	gtk_label_set_label (_tmp0_, " ");
	_tmp1_ = self->priv->screen_name_label;
	gtk_label_set_label (_tmp1_, " ");
	_tmp2_ = self->priv->description_label;
	gtk_label_set_label (_tmp2_, " ");
	_tmp3_ = self->priv->url_label;
	gtk_label_set_label (_tmp3_, " ");
	_tmp4_ = self->priv->location_label;
	gtk_label_set_label (_tmp4_, " ");
	_tmp5_ = self->priv->tweets_label;
	gtk_label_set_label (_tmp5_, " ");
	_tmp6_ = self->priv->following_label;
	gtk_label_set_label (_tmp6_, " ");
	_tmp7_ = self->priv->followers_label;
	gtk_label_set_label (_tmp7_, " ");
	_tmp8_ = self->priv->avatar_image;
	avatar_widget_set_surface (_tmp8_, NULL);
}


static void profile_page_real_create_radio_button (IPage* base, GtkRadioButton* group) {
	ProfilePage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PROFILE_PAGE, ProfilePage);
	g_return_if_fail ((group == NULL) || GTK_IS_RADIO_BUTTON (group));
}


static gchar* profile_page_real_get_title (IPage* base) {
	ProfilePage * self;
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PROFILE_PAGE, ProfilePage);
	_tmp0_ = self->priv->screen_name;
	_tmp1_ = g_strconcat ("@", _tmp0_, NULL);
	result = _tmp1_;
	return result;
}


static GtkRadioButton* profile_page_real_get_radio_button (IPage* base) {
	ProfilePage * self;
	GtkRadioButton* result = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PROFILE_PAGE, ProfilePage);
	result = NULL;
	return result;
}


static void profile_page_write_dm_activated (ProfilePage* self, GSimpleAction* a, GVariant* v) {
	CbBundle* bundle = NULL;
	CbBundle* _tmp0_;
	gint64 _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	MainWindow* _tmp7_;
	MainWidget* _tmp8_;
	g_return_if_fail (IS_PROFILE_PAGE (self));
	g_return_if_fail (G_IS_SIMPLE_ACTION (a));
	_tmp0_ = cb_bundle_new ();
	bundle = _tmp0_;
	_tmp1_ = self->priv->user_id;
	cb_bundle_put_int64 (bundle, DM_PAGE_KEY_SENDER_ID, _tmp1_);
	_tmp2_ = self->priv->screen_name;
	cb_bundle_put_string (bundle, DM_PAGE_KEY_SCREEN_NAME, _tmp2_);
	_tmp3_ = self->priv->name;
	cb_bundle_put_string (bundle, DM_PAGE_KEY_USER_NAME, _tmp3_);
	_tmp4_ = self->priv->avatar_url;
	_tmp5_ = string_replace (_tmp4_, "_bigger", "_normal");
	_tmp6_ = _tmp5_;
	cb_bundle_put_string (bundle, DM_PAGE_KEY_AVATAR_URL, _tmp6_);
	_g_free0 (_tmp6_);
	_tmp7_ = self->priv->main_window;
	_tmp8_ = _tmp7_->main_widget;
	main_widget_switch_page (_tmp8_, (gint) PAGE_DM, bundle);
	_g_object_unref0 (bundle);
}


static void profile_page_tweet_to_activated (ProfilePage* self, GSimpleAction* a, GVariant* v) {
	ComposeTweetWindow* cw = NULL;
	MainWindow* _tmp0_;
	Account* _tmp1_;
	ComposeTweetWindow* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	g_return_if_fail (IS_PROFILE_PAGE (self));
	g_return_if_fail (G_IS_SIMPLE_ACTION (a));
	_tmp0_ = self->priv->main_window;
	_tmp1_ = self->account;
	_tmp2_ = compose_tweet_window_new (_tmp0_, _tmp1_, NULL, COMPOSE_TWEET_WINDOW_MODE_NORMAL);
	g_object_ref_sink (_tmp2_);
	cw = _tmp2_;
	_tmp3_ = self->priv->screen_name;
	_tmp4_ = g_strconcat ("@", _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (_tmp5_, " ", NULL);
	_tmp7_ = _tmp6_;
	compose_tweet_window_set_text (cw, _tmp7_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (cw, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (cw);
}


static void profile_page_add_remove_list_activated (ProfilePage* self, GSimpleAction* a, GVariant* v) {
	UserListDialog* uld = NULL;
	MainWindow* _tmp0_;
	Account* _tmp1_;
	gint64 _tmp2_;
	UserListDialog* _tmp3_;
	g_return_if_fail (IS_PROFILE_PAGE (self));
	g_return_if_fail (G_IS_SIMPLE_ACTION (a));
	_tmp0_ = self->priv->main_window;
	_tmp1_ = self->account;
	_tmp2_ = self->priv->user_id;
	_tmp3_ = user_list_dialog_new (_tmp0_, _tmp1_, _tmp2_);
	g_object_ref_sink (_tmp3_);
	uld = _tmp3_;
	user_list_dialog_load_lists (uld);
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (uld, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (uld);
}


static Block25Data* block25_data_ref (Block25Data* _data25_) {
	g_atomic_int_inc (&_data25_->_ref_count_);
	return _data25_;
}


static void block25_data_unref (void * _userdata_) {
	Block25Data* _data25_;
	_data25_ = (Block25Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data25_->_ref_count_)) {
		ProfilePage* self;
		self = _data25_->self;
		_g_object_unref0 (_data25_->call);
		_g_object_unref0 (_data25_->a);
		_g_object_unref0 (self);
		g_slice_free (Block25Data, _data25_);
	}
}


static void __lambda143_ (Block25Data* _data25_, GObject* obj, GAsyncResult* res) {
	ProfilePage* self;
	GError * _inner_error_ = NULL;
	self = _data25_->self;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		RestProxyCall* _tmp0_;
		GAsyncResult* _tmp1_;
		_tmp0_ = _data25_->call;
		_tmp1_ = res;
		rest_proxy_call_invoke_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch23_g_error;
		}
	}
	goto __finally23;
	__catch23_g_error:
	{
		GError* e = NULL;
		RestProxyCall* _tmp2_;
		const gchar* _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
		MainWindow* _tmp6_;
		GSimpleAction* _tmp7_;
		gboolean _tmp8_;
		GVariant* _tmp9_;
		GVariant* _tmp10_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = _data25_->call;
		_tmp3_ = rest_proxy_call_get_payload (_tmp2_);
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		_tmp6_ = self->priv->main_window;
		utils_show_error_object (_tmp3_, _tmp5_, 700, "ProfilePage.vala", G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_window_get_type (), GtkWindow));
		_tmp7_ = _data25_->a;
		_tmp8_ = _data25_->current_state;
		_tmp9_ = g_variant_new_boolean (_tmp8_);
		g_variant_ref_sink (_tmp9_);
		_tmp10_ = _tmp9_;
		g_simple_action_set_state (_tmp7_, _tmp10_);
		_g_variant_unref0 (_tmp10_);
		_g_error_free0 (e);
	}
	__finally23:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	self->priv->block_item_blocked = FALSE;
}


static void ___lambda143__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda143_ (self, source_object, res);
	block25_data_unref (self);
}


static void profile_page_toggle_blocked_activated (ProfilePage* self, GSimpleAction* a, GVariant* v) {
	Block25Data* _data25_;
	GSimpleAction* _tmp0_;
	GSimpleAction* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	HomeTimeline* ht = NULL;
	MainWindow* _tmp4_;
	IPage* _tmp5_;
	Account* _tmp6_;
	OAuthProxy* _tmp7_;
	RestProxyCall* _tmp8_;
	RestProxyCall* _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp22_;
	RestProxyCall* _tmp23_;
	gint64 _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	RestProxyCall* _tmp27_;
	g_return_if_fail (IS_PROFILE_PAGE (self));
	g_return_if_fail (G_IS_SIMPLE_ACTION (a));
	_data25_ = g_slice_new0 (Block25Data);
	_data25_->_ref_count_ = 1;
	_data25_->self = g_object_ref (self);
	_tmp0_ = a;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data25_->a);
	_data25_->a = _tmp1_;
	_tmp2_ = self->priv->block_item_blocked;
	if (_tmp2_) {
		block25_data_unref (_data25_);
		_data25_ = NULL;
		return;
	}
	self->priv->block_item_blocked = TRUE;
	_tmp3_ = profile_page_get_user_blocked (self);
	_data25_->current_state = _tmp3_;
	_tmp4_ = self->priv->main_window;
	_tmp5_ = main_window_get_page (_tmp4_, (gint) PAGE_STREAM);
	ht = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_HOME_TIMELINE, HomeTimeline);
	_tmp6_ = self->account;
	_tmp7_ = _tmp6_->proxy;
	_tmp8_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, rest_proxy_get_type (), RestProxy));
	_data25_->call = _tmp8_;
	_tmp9_ = _data25_->call;
	rest_proxy_call_set_method (_tmp9_, "POST");
	_tmp10_ = _data25_->current_state;
	if (_tmp10_) {
		RestProxyCall* _tmp11_;
		HomeTimeline* _tmp12_;
		gint64 _tmp13_;
		_tmp11_ = _data25_->call;
		rest_proxy_call_set_function (_tmp11_, "1.1/blocks/destroy.json");
		_tmp12_ = ht;
		_tmp13_ = self->priv->user_id;
		home_timeline_show_tweets_from (_tmp12_, _tmp13_, CB_TWEET_STATE_HIDDEN_AUTHOR_BLOCKED);
	} else {
		RestProxyCall* _tmp14_;
		FollowButton* _tmp15_;
		FollowButton* _tmp16_;
		gint64 _tmp17_;
		Account* _tmp18_;
		gint64 _tmp19_;
		HomeTimeline* _tmp20_;
		gint64 _tmp21_;
		_tmp14_ = _data25_->call;
		rest_proxy_call_set_function (_tmp14_, "1.1/blocks/create.json");
		_tmp15_ = self->priv->follow_button;
		follow_button_set_following (_tmp15_, FALSE);
		_tmp16_ = self->priv->follow_button;
		_tmp17_ = self->priv->user_id;
		_tmp18_ = self->account;
		_tmp19_ = _tmp18_->id;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_widget_get_type (), GtkWidget), _tmp17_ != _tmp19_);
		_tmp20_ = ht;
		_tmp21_ = self->priv->user_id;
		home_timeline_hide_tweets_from (_tmp20_, _tmp21_, CB_TWEET_STATE_HIDDEN_AUTHOR_BLOCKED);
	}
	_tmp22_ = _data25_->current_state;
	profile_page_set_user_blocked (self, !_tmp22_);
	_tmp23_ = _data25_->call;
	_tmp24_ = self->priv->user_id;
	_tmp25_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp24_);
	_tmp26_ = _tmp25_;
	rest_proxy_call_add_param (_tmp23_, "user_id", _tmp26_);
	_g_free0 (_tmp26_);
	_tmp27_ = _data25_->call;
	rest_proxy_call_invoke_async (_tmp27_, NULL, ___lambda143__gasync_ready_callback, block25_data_ref (_data25_));
	_g_object_unref0 (ht);
	block25_data_unref (_data25_);
	_data25_ = NULL;
}


static Block26Data* block26_data_ref (Block26Data* _data26_) {
	g_atomic_int_inc (&_data26_->_ref_count_);
	return _data26_;
}


static void block26_data_unref (void * _userdata_) {
	Block26Data* _data26_;
	_data26_ = (Block26Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data26_->_ref_count_)) {
		ProfilePage* self;
		self = _data26_->self;
		_g_object_unref0 (self);
		g_slice_free (Block26Data, _data26_);
	}
}


static GVariant* _variant_new5 (gboolean value) {
	return g_variant_ref_sink (g_variant_new_boolean (value));
}


static void __lambda144_ (Block26Data* _data26_, GObject* obj, GAsyncResult* res) {
	ProfilePage* self;
	GAsyncResult* _tmp0_;
	HomeTimeline* ht = NULL;
	MainWindow* _tmp1_;
	IPage* _tmp2_;
	self = _data26_->self;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	_tmp0_ = res;
	user_utils_mute_user_finish (_tmp0_);
	self->priv->mute_item_blocked = FALSE;
	_tmp1_ = self->priv->main_window;
	_tmp2_ = main_window_get_page (_tmp1_, (gint) PAGE_STREAM);
	ht = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_HOME_TIMELINE, HomeTimeline);
	if (_data26_->setting) {
		HomeTimeline* _tmp3_;
		gint64 _tmp4_;
		HomeTimeline* _tmp5_;
		gint64 _tmp6_;
		_tmp3_ = ht;
		_tmp4_ = self->priv->user_id;
		home_timeline_show_tweets_from (_tmp3_, _tmp4_, CB_TWEET_STATE_HIDDEN_AUTHOR_MUTED);
		_tmp5_ = ht;
		_tmp6_ = self->priv->user_id;
		home_timeline_show_retweets_from (_tmp5_, _tmp6_, CB_TWEET_STATE_HIDDEN_RETWEETER_MUTED);
	} else {
		HomeTimeline* _tmp7_;
		gint64 _tmp8_;
		HomeTimeline* _tmp9_;
		gint64 _tmp10_;
		_tmp7_ = ht;
		_tmp8_ = self->priv->user_id;
		home_timeline_hide_tweets_from (_tmp7_, _tmp8_, CB_TWEET_STATE_HIDDEN_AUTHOR_MUTED);
		_tmp9_ = ht;
		_tmp10_ = self->priv->user_id;
		home_timeline_hide_retweets_from (_tmp9_, _tmp10_, CB_TWEET_STATE_HIDDEN_RETWEETER_MUTED);
	}
	_g_object_unref0 (ht);
}


static void ___lambda144__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda144_ (self, source_object, res);
	block26_data_unref (self);
}


static void profile_page_toggle_muted_activated (ProfilePage* self, GSimpleAction* a, GVariant* v) {
	Block26Data* _data26_;
	gboolean _tmp0_;
	GSimpleAction* _tmp1_;
	GVariant* _tmp2_;
	Account* _tmp3_;
	gint64 _tmp4_;
	g_return_if_fail (IS_PROFILE_PAGE (self));
	g_return_if_fail (G_IS_SIMPLE_ACTION (a));
	_data26_ = g_slice_new0 (Block26Data);
	_data26_->_ref_count_ = 1;
	_data26_->self = g_object_ref (self);
	_tmp0_ = profile_page_get_user_muted (self);
	_data26_->setting = _tmp0_;
	self->priv->mute_item_blocked = TRUE;
	_tmp1_ = a;
	_tmp2_ = _variant_new5 (!_data26_->setting);
	g_simple_action_set_state (_tmp1_, _tmp2_);
	_g_variant_unref0 (_tmp2_);
	_tmp3_ = self->account;
	_tmp4_ = self->priv->user_id;
	user_utils_mute_user (_tmp3_, _tmp4_, !_data26_->setting, ___lambda144__gasync_ready_callback, block26_data_ref (_data26_));
	block26_data_unref (_data26_);
	_data26_ = NULL;
}


static Block27Data* block27_data_ref (Block27Data* _data27_) {
	g_atomic_int_inc (&_data27_->_ref_count_);
	return _data27_;
}


static void block27_data_unref (void * _userdata_) {
	Block27Data* _data27_;
	_data27_ = (Block27Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data27_->_ref_count_)) {
		ProfilePage* self;
		self = _data27_->self;
		_g_object_unref0 (_data27_->call);
		_g_object_unref0 (_data27_->a);
		_g_object_unref0 (self);
		g_slice_free (Block27Data, _data27_);
	}
}


static gchar* bool_to_string (gboolean self) {
	gchar* result = NULL;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}


static void __lambda145_ (Block27Data* _data27_, GObject* obj, GAsyncResult* res) {
	ProfilePage* self;
	GError * _inner_error_ = NULL;
	self = _data27_->self;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		RestProxyCall* _tmp0_;
		GAsyncResult* _tmp1_;
		_tmp0_ = _data27_->call;
		_tmp1_ = res;
		rest_proxy_call_invoke_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch24_g_error;
		}
	}
	goto __finally24;
	__catch24_g_error:
	{
		GError* e = NULL;
		RestProxyCall* _tmp2_;
		const gchar* _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
		MainWindow* _tmp6_;
		GSimpleAction* _tmp7_;
		gboolean _tmp8_;
		GVariant* _tmp9_;
		GVariant* _tmp10_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = _data27_->call;
		_tmp3_ = rest_proxy_call_get_payload (_tmp2_);
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		_tmp6_ = self->priv->main_window;
		utils_show_error_object (_tmp3_, _tmp5_, 752, "ProfilePage.vala", G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_window_get_type (), GtkWindow));
		_tmp7_ = _data27_->a;
		_tmp8_ = _data27_->current_state;
		_tmp9_ = g_variant_new_boolean (_tmp8_);
		g_variant_ref_sink (_tmp9_);
		_tmp10_ = _tmp9_;
		g_simple_action_set_state (_tmp7_, _tmp10_);
		_g_variant_unref0 (_tmp10_);
		_g_error_free0 (e);
	}
	__finally24:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	self->priv->retweet_item_blocked = FALSE;
}


static void ___lambda145__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda145_ (self, source_object, res);
	block27_data_unref (self);
}


static void profile_page_retweet_action_activated (ProfilePage* self, GSimpleAction* a, GVariant* v) {
	Block27Data* _data27_;
	GSimpleAction* _tmp0_;
	GSimpleAction* _tmp1_;
	gboolean _tmp2_;
	GSimpleAction* _tmp3_;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	GSimpleAction* _tmp8_;
	gboolean _tmp9_;
	GVariant* _tmp10_;
	GVariant* _tmp11_;
	Account* _tmp12_;
	OAuthProxy* _tmp13_;
	RestProxyCall* _tmp14_;
	RestProxyCall* _tmp15_;
	RestProxyCall* _tmp16_;
	RestProxyCall* _tmp17_;
	gint64 _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	RestProxyCall* _tmp21_;
	gboolean _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	HomeTimeline* ht = NULL;
	MainWindow* _tmp25_;
	IPage* _tmp26_;
	gboolean _tmp27_;
	RestProxyCall* _tmp36_;
	g_return_if_fail (IS_PROFILE_PAGE (self));
	g_return_if_fail (G_IS_SIMPLE_ACTION (a));
	_data27_ = g_slice_new0 (Block27Data);
	_data27_->_ref_count_ = 1;
	_data27_->self = g_object_ref (self);
	_tmp0_ = a;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data27_->a);
	_data27_->a = _tmp1_;
	_tmp2_ = self->priv->retweet_item_blocked;
	if (_tmp2_) {
		block27_data_unref (_data27_);
		_data27_ = NULL;
		return;
	}
	self->priv->retweet_item_blocked = TRUE;
	_tmp3_ = _data27_->a;
	_tmp4_ = g_action_get_state (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, g_action_get_type (), GAction));
	_tmp5_ = _tmp4_;
	_tmp6_ = g_variant_get_boolean (_tmp5_);
	_tmp7_ = _tmp6_;
	_g_variant_unref0 (_tmp5_);
	_data27_->current_state = _tmp7_;
	_tmp8_ = _data27_->a;
	_tmp9_ = _data27_->current_state;
	_tmp10_ = g_variant_new_boolean (!_tmp9_);
	g_variant_ref_sink (_tmp10_);
	_tmp11_ = _tmp10_;
	g_simple_action_set_state (_tmp8_, _tmp11_);
	_g_variant_unref0 (_tmp11_);
	_tmp12_ = self->account;
	_tmp13_ = _tmp12_->proxy;
	_tmp14_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, rest_proxy_get_type (), RestProxy));
	_data27_->call = _tmp14_;
	_tmp15_ = _data27_->call;
	rest_proxy_call_set_function (_tmp15_, "1.1/friendships/update.json");
	_tmp16_ = _data27_->call;
	rest_proxy_call_set_method (_tmp16_, "POST");
	_tmp17_ = _data27_->call;
	_tmp18_ = self->priv->user_id;
	_tmp19_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp18_);
	_tmp20_ = _tmp19_;
	rest_proxy_call_add_param (_tmp17_, "user_id", _tmp20_);
	_g_free0 (_tmp20_);
	_tmp21_ = _data27_->call;
	_tmp22_ = _data27_->current_state;
	_tmp23_ = bool_to_string (_tmp22_);
	_tmp24_ = _tmp23_;
	rest_proxy_call_add_param (_tmp21_, "retweets", _tmp24_);
	_g_free0 (_tmp24_);
	_tmp25_ = self->priv->main_window;
	_tmp26_ = main_window_get_page (_tmp25_, (gint) PAGE_STREAM);
	ht = G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, TYPE_HOME_TIMELINE, HomeTimeline);
	_tmp27_ = _data27_->current_state;
	if (_tmp27_) {
		HomeTimeline* _tmp28_;
		gint64 _tmp29_;
		Account* _tmp30_;
		gint64 _tmp31_;
		_tmp28_ = ht;
		_tmp29_ = self->priv->user_id;
		home_timeline_show_retweets_from (_tmp28_, _tmp29_, CB_TWEET_STATE_HIDDEN_RTS_DISABLED);
		_tmp30_ = self->account;
		_tmp31_ = self->priv->user_id;
		account_remove_disabled_rts_id (_tmp30_, _tmp31_);
	} else {
		HomeTimeline* _tmp32_;
		gint64 _tmp33_;
		Account* _tmp34_;
		gint64 _tmp35_;
		_tmp32_ = ht;
		_tmp33_ = self->priv->user_id;
		home_timeline_hide_retweets_from (_tmp32_, _tmp33_, CB_TWEET_STATE_HIDDEN_RTS_DISABLED);
		_tmp34_ = self->account;
		_tmp35_ = self->priv->user_id;
		account_add_disabled_rts_id (_tmp34_, _tmp35_);
	}
	_tmp36_ = _data27_->call;
	rest_proxy_call_invoke_async (_tmp36_, NULL, ___lambda145__gasync_ready_callback, block27_data_ref (_data27_));
	_g_object_unref0 (ht);
	block27_data_unref (_data27_);
	_data27_ = NULL;
}


static void profile_page_set_user_blocked (ProfilePage* self, gboolean blocked) {
	GSimpleActionGroup* _tmp0_;
	GAction* _tmp1_;
	gboolean _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	g_return_if_fail (IS_PROFILE_PAGE (self));
	_tmp0_ = self->priv->actions;
	_tmp1_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_action_map_get_type (), GActionMap), "toggle-blocked");
	_tmp2_ = blocked;
	_tmp3_ = g_variant_new_boolean (_tmp2_);
	g_variant_ref_sink (_tmp3_);
	_tmp4_ = _tmp3_;
	g_simple_action_set_state (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_simple_action_get_type (), GSimpleAction), _tmp4_);
	_g_variant_unref0 (_tmp4_);
}


static gboolean profile_page_get_user_blocked (ProfilePage* self) {
	gboolean result = FALSE;
	GSimpleActionGroup* _tmp0_;
	GAction* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	g_return_val_if_fail (IS_PROFILE_PAGE (self), FALSE);
	_tmp0_ = self->priv->actions;
	_tmp1_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_action_map_get_type (), GActionMap), "toggle-blocked");
	_tmp2_ = g_action_get_state (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_simple_action_get_type (), GSimpleAction), g_action_get_type (), GAction));
	_tmp3_ = _tmp2_;
	_tmp4_ = g_variant_get_boolean (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_variant_unref0 (_tmp3_);
	result = _tmp5_;
	return result;
}


static void profile_page_set_user_muted (ProfilePage* self, gboolean muted) {
	GSimpleActionGroup* _tmp0_;
	GAction* _tmp1_;
	gboolean _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	g_return_if_fail (IS_PROFILE_PAGE (self));
	_tmp0_ = self->priv->actions;
	_tmp1_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_action_map_get_type (), GActionMap), "toggle-muted");
	_tmp2_ = muted;
	_tmp3_ = g_variant_new_boolean (_tmp2_);
	g_variant_ref_sink (_tmp3_);
	_tmp4_ = _tmp3_;
	g_simple_action_set_state (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_simple_action_get_type (), GSimpleAction), _tmp4_);
	_g_variant_unref0 (_tmp4_);
}


static gboolean profile_page_get_user_muted (ProfilePage* self) {
	gboolean result = FALSE;
	GSimpleActionGroup* _tmp0_;
	GAction* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	g_return_val_if_fail (IS_PROFILE_PAGE (self), FALSE);
	_tmp0_ = self->priv->actions;
	_tmp1_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_action_map_get_type (), GActionMap), "toggle-muted");
	_tmp2_ = g_action_get_state (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_simple_action_get_type (), GSimpleAction), g_action_get_type (), GAction));
	_tmp3_ = _tmp2_;
	_tmp4_ = g_variant_get_boolean (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_variant_unref0 (_tmp3_);
	result = _tmp5_;
	return result;
}


static void profile_page_set_retweets_disabled (ProfilePage* self, gboolean disabled) {
	GSimpleActionGroup* _tmp0_;
	GAction* _tmp1_;
	gboolean _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	g_return_if_fail (IS_PROFILE_PAGE (self));
	_tmp0_ = self->priv->actions;
	_tmp1_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_action_map_get_type (), GActionMap), "toggle-retweets");
	_tmp2_ = disabled;
	_tmp3_ = g_variant_new_boolean (_tmp2_);
	g_variant_ref_sink (_tmp3_);
	_tmp4_ = _tmp3_;
	g_simple_action_set_state (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_simple_action_get_type (), GSimpleAction), _tmp4_);
	_g_variant_unref0 (_tmp4_);
}


static void profile_page_update_follower_label (ProfilePage* self) {
	GtkLabel* _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (IS_PROFILE_PAGE (self));
	_tmp0_ = self->priv->followers_label;
	_tmp1_ = self->priv->follower_count;
	_tmp2_ = g_strdup_printf ("%'d", _tmp1_);
	_tmp3_ = _tmp2_;
	gtk_label_set_label (_tmp0_, _tmp3_);
	_g_free0 (_tmp3_);
}


static void profile_page_real_stream_message_received (CbMessageReceiver* base, CbStreamMessageType type, JsonNode* root_node) {
	ProfilePage * self;
	CbStreamMessageType _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PROFILE_PAGE, ProfilePage);
	g_return_if_fail (root_node != NULL);
	_tmp0_ = type;
	if (_tmp0_ == CB_STREAM_MESSAGE_TWEET) {
		JsonObject* obj = NULL;
		JsonNode* _tmp1_;
		JsonObject* _tmp2_;
		JsonObject* _tmp3_;
		JsonObject* user = NULL;
		JsonObject* _tmp4_;
		JsonObject* _tmp5_;
		JsonObject* _tmp6_;
		JsonObject* _tmp7_;
		gint64 _tmp8_;
		gint64 _tmp9_;
		CbTweet* tweet = NULL;
		CbTweet* _tmp10_;
		CbTweet* _tmp11_;
		JsonNode* _tmp12_;
		Account* _tmp13_;
		gint64 _tmp14_;
		GDateTime* _tmp15_;
		GDateTime* _tmp16_;
		TweetListBox* _tmp17_;
		CbTweetModel* _tmp18_;
		CbTweet* _tmp19_;
		_tmp1_ = root_node;
		_tmp2_ = json_node_get_object (_tmp1_);
		_tmp3_ = _json_object_ref0 (_tmp2_);
		obj = _tmp3_;
		_tmp4_ = obj;
		_tmp5_ = json_object_get_object_member (_tmp4_, "user");
		_tmp6_ = _json_object_ref0 (_tmp5_);
		user = _tmp6_;
		_tmp7_ = user;
		_tmp8_ = json_object_get_int_member (_tmp7_, "id");
		_tmp9_ = self->priv->user_id;
		if (_tmp8_ != _tmp9_) {
			_json_object_unref0 (user);
			_json_object_unref0 (obj);
			return;
		}
		_tmp10_ = cb_tweet_new ();
		tweet = _tmp10_;
		_tmp11_ = tweet;
		_tmp12_ = root_node;
		_tmp13_ = self->account;
		_tmp14_ = _tmp13_->id;
		_tmp15_ = g_date_time_new_now_local ();
		_tmp16_ = _tmp15_;
		cb_tweet_load_from_json (_tmp11_, _tmp12_, _tmp14_, _tmp16_);
		_g_date_time_unref0 (_tmp16_);
		_tmp17_ = self->priv->tweet_list;
		_tmp18_ = _tmp17_->model;
		_tmp19_ = tweet;
		cb_tweet_model_add (_tmp18_, _tmp19_);
		_g_object_unref0 (tweet);
		_json_object_unref0 (user);
		_json_object_unref0 (obj);
	}
}


static void profile_page_tweets_button_toggled_cb (ProfilePage* self, GObject* source) {
	GObject* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (IS_PROFILE_PAGE (self));
	g_return_if_fail (G_IS_OBJECT (source));
	_tmp0_ = source;
	_tmp1_ = gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_radio_button_get_type (), GtkRadioButton), gtk_toggle_button_get_type (), GtkToggleButton));
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GtkStack* _tmp3_;
		TweetListBox* _tmp4_;
		scroll_widget_balance_next_upper_change (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SCROLL_WIDGET, ScrollWidget), BOTTOM);
		_tmp3_ = self->priv->user_stack;
		_tmp4_ = self->priv->tweet_list;
		gtk_stack_set_visible_child (_tmp3_, G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget));
	}
}


static void _profile_page_tweets_button_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	profile_page_tweets_button_toggled_cb ((ProfilePage*) self, _sender);
}


static void profile_page_followers_button_toggled_cb (ProfilePage* self, GObject* source) {
	GObject* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (IS_PROFILE_PAGE (self));
	g_return_if_fail (G_IS_OBJECT (source));
	_tmp0_ = source;
	_tmp1_ = gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_radio_button_get_type (), GtkRadioButton), gtk_toggle_button_get_type (), GtkToggleButton));
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		Cursor* _tmp3_;
		GtkStack* _tmp4_;
		TweetListBox* _tmp5_;
		_tmp3_ = self->priv->followers_cursor;
		if (_tmp3_ == NULL) {
			profile_page_load_followers (self, NULL, NULL);
		}
		scroll_widget_balance_next_upper_change (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SCROLL_WIDGET, ScrollWidget), BOTTOM);
		_tmp4_ = self->priv->user_stack;
		_tmp5_ = self->priv->followers_list;
		gtk_stack_set_visible_child (_tmp4_, G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget));
	}
}


static void _profile_page_followers_button_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	profile_page_followers_button_toggled_cb ((ProfilePage*) self, _sender);
}


static void profile_page_following_button_toggled_cb (ProfilePage* self, GObject* source) {
	GObject* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (IS_PROFILE_PAGE (self));
	g_return_if_fail (G_IS_OBJECT (source));
	_tmp0_ = source;
	_tmp1_ = gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_radio_button_get_type (), GtkRadioButton), gtk_toggle_button_get_type (), GtkToggleButton));
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		Cursor* _tmp3_;
		GtkStack* _tmp4_;
		TweetListBox* _tmp5_;
		_tmp3_ = self->priv->following_cursor;
		if (_tmp3_ == NULL) {
			profile_page_load_following (self, NULL, NULL);
		}
		scroll_widget_balance_next_upper_change (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SCROLL_WIDGET, ScrollWidget), BOTTOM);
		_tmp4_ = self->priv->user_stack;
		_tmp5_ = self->priv->following_list;
		gtk_stack_set_visible_child (_tmp4_, G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget));
	}
}


static void _profile_page_following_button_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	profile_page_following_button_toggled_cb ((ProfilePage*) self, _sender);
}


static void profile_page_lists_button_toggled_cb (ProfilePage* self, GObject* source) {
	GObject* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (IS_PROFILE_PAGE (self));
	g_return_if_fail (G_IS_OBJECT (source));
	_tmp0_ = source;
	_tmp1_ = gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_radio_button_get_type (), GtkRadioButton), gtk_toggle_button_get_type (), GtkToggleButton));
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		gboolean _tmp3_;
		GtkStack* _tmp6_;
		UserListsWidget* _tmp7_;
		_tmp3_ = self->priv->lists_page_inited;
		if (!_tmp3_) {
			UserListsWidget* _tmp4_;
			gint64 _tmp5_;
			_tmp4_ = self->priv->user_lists;
			_tmp5_ = self->priv->user_id;
			user_lists_widget_load_lists (_tmp4_, _tmp5_, NULL, NULL);
			self->priv->lists_page_inited = TRUE;
		}
		scroll_widget_balance_next_upper_change (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SCROLL_WIDGET, ScrollWidget), BOTTOM);
		_tmp6_ = self->priv->user_stack;
		_tmp7_ = self->priv->user_lists;
		gtk_stack_set_visible_child (_tmp6_, G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget));
	}
}


static void _profile_page_lists_button_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	profile_page_lists_button_toggled_cb ((ProfilePage*) self, _sender);
}


gint profile_page_get_unread_count (ProfilePage* self) {
	gint result;
	g_return_val_if_fail (IS_PROFILE_PAGE (self), 0);
	result = 0;
	return result;
}


static void profile_page_real_set_window (IPage* base, MainWindow* value) {
	ProfilePage* self;
	MainWindow* _tmp0_;
	UserListsWidget* _tmp1_;
	MainWindow* _tmp2_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PROFILE_PAGE, ProfilePage);
	_tmp0_ = value;
	self->priv->main_window = _tmp0_;
	_tmp1_ = self->priv->user_lists;
	_tmp2_ = value;
	user_lists_widget_set_main_window (_tmp1_, _tmp2_);
	g_object_notify ((GObject *) self, "window");
}


static gint profile_page_real_get_id (IPage* base) {
	gint result;
	ProfilePage* self;
	gint _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PROFILE_PAGE, ProfilePage);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}


static void profile_page_real_set_id (IPage* base, gint value) {
	ProfilePage* self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PROFILE_PAGE, ProfilePage);
	if (profile_page_real_get_id (base) != value) {
		gint _tmp0_;
		_tmp0_ = value;
		self->priv->_id = _tmp0_;
		g_object_notify ((GObject *) self, "id");
	}
}


static void profile_page_class_init (ProfilePageClass * klass) {
	gint ProfilePage_private_offset;
	profile_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ProfilePagePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_profile_page_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_profile_page_set_property;
	G_OBJECT_CLASS (klass)->finalize = profile_page_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PROFILE_PAGE_UNREAD_COUNT, g_param_spec_int ("unread-count", "unread-count", "unread-count", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PROFILE_PAGE_WINDOW, g_param_spec_object ("window", "window", "window", TYPE_MAIN_WINDOW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PROFILE_PAGE_ID, g_param_spec_int ("id", "id", "id", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	ProfilePage_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/baedert/corebird/ui/profile-page.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "banner_image", FALSE, ProfilePage_private_offset + G_STRUCT_OFFSET (ProfilePagePrivate, banner_image));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "avatar_image", FALSE, ProfilePage_private_offset + G_STRUCT_OFFSET (ProfilePagePrivate, avatar_image));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "name_label", FALSE, ProfilePage_private_offset + G_STRUCT_OFFSET (ProfilePagePrivate, name_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "screen_name_label", FALSE, ProfilePage_private_offset + G_STRUCT_OFFSET (ProfilePagePrivate, screen_name_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "description_label", FALSE, ProfilePage_private_offset + G_STRUCT_OFFSET (ProfilePagePrivate, description_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "url_label", FALSE, ProfilePage_private_offset + G_STRUCT_OFFSET (ProfilePagePrivate, url_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "tweets_label", FALSE, ProfilePage_private_offset + G_STRUCT_OFFSET (ProfilePagePrivate, tweets_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "following_label", FALSE, ProfilePage_private_offset + G_STRUCT_OFFSET (ProfilePagePrivate, following_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "followers_label", FALSE, ProfilePage_private_offset + G_STRUCT_OFFSET (ProfilePagePrivate, followers_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "location_label", FALSE, ProfilePage_private_offset + G_STRUCT_OFFSET (ProfilePagePrivate, location_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "follow_button", FALSE, ProfilePage_private_offset + G_STRUCT_OFFSET (ProfilePagePrivate, follow_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "tweet_list", FALSE, ProfilePage_private_offset + G_STRUCT_OFFSET (ProfilePagePrivate, tweet_list));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "followers_list", FALSE, ProfilePage_private_offset + G_STRUCT_OFFSET (ProfilePagePrivate, followers_list));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "following_list", FALSE, ProfilePage_private_offset + G_STRUCT_OFFSET (ProfilePagePrivate, following_list));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "progress_spinner", FALSE, ProfilePage_private_offset + G_STRUCT_OFFSET (ProfilePagePrivate, progress_spinner));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "follows_you_label", FALSE, ProfilePage_private_offset + G_STRUCT_OFFSET (ProfilePagePrivate, follows_you_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "user_lists", FALSE, ProfilePage_private_offset + G_STRUCT_OFFSET (ProfilePagePrivate, user_lists));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "user_stack", FALSE, ProfilePage_private_offset + G_STRUCT_OFFSET (ProfilePagePrivate, user_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "more_button", FALSE, ProfilePage_private_offset + G_STRUCT_OFFSET (ProfilePagePrivate, more_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "loading_stack", FALSE, ProfilePage_private_offset + G_STRUCT_OFFSET (ProfilePagePrivate, loading_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "tweets_button", FALSE, ProfilePage_private_offset + G_STRUCT_OFFSET (ProfilePagePrivate, tweets_button));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "follow_button_clicked_cb", G_CALLBACK(_profile_page_follow_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "activate_link", G_CALLBACK(_profile_page_activate_link_gtk_label_activate_link));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "tweets_button_toggled_cb", G_CALLBACK(_profile_page_tweets_button_toggled_cb_gtk_toggle_button_toggled));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "followers_button_toggled_cb", G_CALLBACK(_profile_page_followers_button_toggled_cb_gtk_toggle_button_toggled));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "following_button_toggled_cb", G_CALLBACK(_profile_page_following_button_toggled_cb_gtk_toggle_button_toggled));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "lists_button_toggled_cb", G_CALLBACK(_profile_page_lists_button_toggled_cb_gtk_toggle_button_toggled));
}


static void profile_page_ipage_interface_init (IPageIface * iface) {
	profile_page_ipage_parent_iface = g_type_interface_peek_parent (iface);
	iface->on_join = (void (*) (IPage *, gint, CbBundle*)) profile_page_real_on_join;
	iface->on_leave = (void (*) (IPage *)) profile_page_real_on_leave;
	iface->create_radio_button = (void (*) (IPage *, GtkRadioButton*)) profile_page_real_create_radio_button;
	iface->get_title = (gchar* (*) (IPage *)) profile_page_real_get_title;
	iface->get_radio_button = (GtkRadioButton* (*) (IPage *)) profile_page_real_get_radio_button;
	iface->set_window = profile_page_real_set_window;
	iface->get_id = profile_page_real_get_id;
	iface->set_id = profile_page_real_set_id;
}


static void profile_page_cb_message_receiver_interface_init (CbMessageReceiverInterface * iface) {
	profile_page_cb_message_receiver_parent_iface = g_type_interface_peek_parent (iface);
	iface->stream_message_received = (void (*) (CbMessageReceiver *, CbStreamMessageType, JsonNode*)) profile_page_real_stream_message_received;
}


static void profile_page_instance_init (ProfilePage * self) {
	self->priv = PROFILE_PAGE_GET_PRIVATE (self);
	self->priv->follower_count = -1;
	self->priv->lists_page_inited = FALSE;
	self->priv->block_item_blocked = FALSE;
	self->priv->retweet_item_blocked = FALSE;
	self->priv->mute_item_blocked = FALSE;
	self->priv->tweets_loading = FALSE;
	self->priv->followers_loading = FALSE;
	self->priv->followers_cursor = NULL;
	self->priv->following_loading = FALSE;
	self->priv->following_cursor = NULL;
	g_type_ensure (TYPE_ASPECT_IMAGE);
	g_type_ensure (TYPE_AVATAR_WIDGET);
	g_type_ensure (TYPE_FOLLOW_BUTTON);
	g_type_ensure (TYPE_TWEET_LIST_BOX);
	g_type_ensure (TYPE_TWEET_LIST_BOX);
	g_type_ensure (TYPE_TWEET_LIST_BOX);
	g_type_ensure (TYPE_USER_LISTS_WIDGET);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void profile_page_finalize (GObject * obj) {
	ProfilePage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PROFILE_PAGE, ProfilePage);
	_g_object_unref0 (self->priv->banner_image);
	_g_object_unref0 (self->priv->avatar_image);
	_g_object_unref0 (self->priv->name_label);
	_g_object_unref0 (self->priv->screen_name_label);
	_g_object_unref0 (self->priv->description_label);
	_g_object_unref0 (self->priv->url_label);
	_g_object_unref0 (self->priv->tweets_label);
	_g_object_unref0 (self->priv->following_label);
	_g_object_unref0 (self->priv->followers_label);
	_g_object_unref0 (self->priv->location_label);
	_g_object_unref0 (self->priv->follow_button);
	_g_object_unref0 (self->priv->tweet_list);
	_g_object_unref0 (self->priv->followers_list);
	_g_object_unref0 (self->priv->following_list);
	_g_object_unref0 (self->priv->progress_spinner);
	_g_object_unref0 (self->priv->follows_you_label);
	_g_object_unref0 (self->priv->user_lists);
	_g_object_unref0 (self->priv->user_stack);
	_g_object_unref0 (self->priv->more_button);
	_g_object_unref0 (self->priv->loading_stack);
	_g_object_unref0 (self->priv->tweets_button);
	_g_free0 (self->priv->name);
	_g_free0 (self->priv->screen_name);
	_g_free0 (self->priv->avatar_url);
	_g_object_unref0 (self->priv->data_cancellable);
	_cursor_free0 (self->priv->followers_cursor);
	_cursor_free0 (self->priv->following_cursor);
	_g_object_unref0 (self->priv->actions);
	G_OBJECT_CLASS (profile_page_parent_class)->finalize (obj);
}


GType profile_page_get_type (void) {
	static volatile gsize profile_page_type_id__volatile = 0;
	if (g_once_init_enter (&profile_page_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ProfilePageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) profile_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ProfilePage), 0, (GInstanceInitFunc) profile_page_instance_init, NULL };
		static const GInterfaceInfo ipage_info = { (GInterfaceInitFunc) profile_page_ipage_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo cb_message_receiver_info = { (GInterfaceInitFunc) profile_page_cb_message_receiver_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType profile_page_type_id;
		profile_page_type_id = g_type_register_static (TYPE_SCROLL_WIDGET, "ProfilePage", &g_define_type_info, 0);
		g_type_add_interface_static (profile_page_type_id, TYPE_IPAGE, &ipage_info);
		g_type_add_interface_static (profile_page_type_id, CB_TYPE_MESSAGE_RECEIVER, &cb_message_receiver_info);
		g_once_init_leave (&profile_page_type_id__volatile, profile_page_type_id);
	}
	return profile_page_type_id__volatile;
}


static void _vala_profile_page_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ProfilePage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PROFILE_PAGE, ProfilePage);
	switch (property_id) {
		case PROFILE_PAGE_UNREAD_COUNT:
		g_value_set_int (value, profile_page_get_unread_count (self));
		break;
		case PROFILE_PAGE_ID:
		g_value_set_int (value, ipage_get_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage)));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_profile_page_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ProfilePage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PROFILE_PAGE, ProfilePage);
	switch (property_id) {
		case PROFILE_PAGE_WINDOW:
		ipage_set_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_object (value));
		break;
		case PROFILE_PAGE_ID:
		ipage_set_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



