/* TweetUtils.c generated by valac 0.36.4, the Vala compiler
 * generated from TweetUtils.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include "CbTweet.h"
#include "rest/rest-proxy-call.h"
#include "rest/oauth-proxy.h"
#include "CbUserStream.h"
#include "CbUserCounter.h"
#include "CbFilter.h"
#include "rest/rest-proxy.h"
#include <gtk/gtk.h>
#include "CbUtils.h"
#include <json-glib/json-glib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <libsoup/soup.h>
#include "CbBundle.h"
#include "CbDeltaUpdater.h"
#include "CbTweetModel.h"
#include <float.h>
#include <math.h>
#include "CbSnippetManager.h"
#include "CbTypes.h"

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;
typedef struct _Block53Data Block53Data;
typedef struct _AccountPrivate AccountPrivate;

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define TYPE_NOTIFICATION_MANAGER (notification_manager_get_type ())
#define NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManager))
#define NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))
#define IS_NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATION_MANAGER))
#define IS_NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATION_MANAGER))
#define NOTIFICATION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))

typedef struct _NotificationManager NotificationManager;
typedef struct _NotificationManagerClass NotificationManagerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _TweetUtilsDeleteTweetData TweetUtilsDeleteTweetData;
typedef struct _Block54Data Block54Data;
typedef struct _TweetUtilsSetFavoriteStatusData TweetUtilsSetFavoriteStatusData;
typedef struct _Block55Data Block55Data;
typedef struct _TweetUtilsSetRetweetStatusData TweetUtilsSetRetweetStatusData;
typedef struct _Block56Data Block56Data;
typedef struct _TweetUtilsDownloadAvatarData TweetUtilsDownloadAvatarData;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
typedef struct _MainWindowPrivate MainWindowPrivate;

#define TYPE_MAIN_WIDGET (main_widget_get_type ())
#define MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WIDGET, MainWidget))
#define MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WIDGET, MainWidgetClass))
#define IS_MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WIDGET))
#define IS_MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WIDGET))
#define MAIN_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WIDGET, MainWidgetClass))

typedef struct _MainWidget MainWidget;
typedef struct _MainWidgetClass MainWidgetClass;

#define TYPE_PAGE (page_get_type ())

#define TYPE_TWEET_LIST_BOX (tweet_list_box_get_type ())
#define TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_BOX, TweetListBox))
#define TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_BOX, TweetListBoxClass))
#define IS_TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_BOX))
#define IS_TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_BOX))
#define TWEET_LIST_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_BOX, TweetListBoxClass))

typedef struct _TweetListBox TweetListBox;
typedef struct _TweetListBoxClass TweetListBoxClass;
typedef struct _TweetListBoxPrivate TweetListBoxPrivate;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

#define TYPE_MEDIA_DIALOG (media_dialog_get_type ())
#define MEDIA_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_DIALOG, MediaDialog))
#define MEDIA_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_DIALOG, MediaDialogClass))
#define IS_MEDIA_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_DIALOG))
#define IS_MEDIA_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_DIALOG))
#define MEDIA_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_DIALOG, MediaDialogClass))

typedef struct _MediaDialog MediaDialog;
typedef struct _MediaDialogClass MediaDialogClass;

struct _Block53Data {
	int _ref_count_;
	RestProxyCall* call;
	gpointer _async_data_;
};

struct _Account {
	GObject parent_instance;
	AccountPrivate * priv;
	gint64 id;
	SqlDatabase* db;
	gchar* screen_name;
	gchar* name;
	gchar* avatar_url;
	gchar* banner_url;
	gchar* website;
	gchar* description;
	OAuthProxy* proxy;
	CbUserStream* user_stream;
	CbUserCounter* user_counter;
	NotificationManager* notifications;
	gint64* friends;
	gint friends_length1;
	gint64* blocked;
	gint blocked_length1;
	gint64* muted;
	gint muted_length1;
	gint64* disabled_rts;
	gint disabled_rts_length1;
	GPtrArray* filters;
};

struct _AccountClass {
	GObjectClass parent_class;
};

struct _TweetUtilsDeleteTweetData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	Account* account;
	CbTweet* tweet;
	Block53Data* _data53_;
	Account* _tmp0_;
	OAuthProxy* _tmp1_;
	RestProxyCall* _tmp2_;
	CbTweet* _tmp3_;
	gint64 _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	CbTweet* _tmp11_;
	gint64 _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
};

struct _Block54Data {
	int _ref_count_;
	RestProxyCall* call;
	CbTweet* tweet;
	gboolean status;
	gpointer _async_data_;
};

struct _TweetUtilsSetFavoriteStatusData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	Account* account;
	CbTweet* tweet;
	gboolean status;
	Block54Data* _data54_;
	CbTweet* _tmp0_;
	gboolean _tmp1_;
	Account* _tmp2_;
	OAuthProxy* _tmp3_;
	RestProxyCall* _tmp4_;
	gboolean _tmp5_;
	RestProxyCall* _tmp6_;
	RestProxyCall* _tmp7_;
	RestProxyCall* _tmp8_;
	RestProxyCall* _tmp9_;
	CbTweet* _tmp10_;
	gint64 _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	RestProxyCall* _tmp14_;
};

struct _Block55Data {
	int _ref_count_;
	RestProxyCall* call;
	CbTweet* tweet;
	gboolean status;
	gpointer _async_data_;
};

struct _TweetUtilsSetRetweetStatusData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	Account* account;
	CbTweet* tweet;
	gboolean status;
	Block55Data* _data55_;
	CbTweet* _tmp0_;
	gboolean _tmp1_;
	Account* _tmp2_;
	OAuthProxy* _tmp3_;
	RestProxyCall* _tmp4_;
	RestProxyCall* _tmp5_;
	gboolean _tmp6_;
	RestProxyCall* _tmp7_;
	CbTweet* _tmp8_;
	gint64 _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	RestProxyCall* _tmp14_;
	CbTweet* _tmp15_;
	gint64 _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	RestProxyCall* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	RestProxyCall* _tmp24_;
};

struct _Block56Data {
	int _ref_count_;
	GdkPixbuf* avatar;
	SoupMessage* msg;
	GError* err;
	gint size;
	gpointer _async_data_;
};

struct _TweetUtilsDownloadAvatarData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	gchar* avatar_url;
	gint size;
	GCancellable* cancellable;
	GdkPixbuf* result;
	Block56Data* _data56_;
	gint _tmp0_;
	const gchar* _tmp1_;
	SoupMessage* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	SoupSession* _tmp5_;
	SoupMessage* _tmp6_;
	SoupMessage* _tmp7_;
	GError* _tmp8_;
	GError* _tmp9_;
	GError* _tmp10_;
	GdkPixbuf* _tmp11_;
	GdkPixbuf* _tmp12_;
	GError * _inner_error_;
};

struct _MainWindow {
	GtkApplicationWindow parent_instance;
	MainWindowPrivate * priv;
	GtkButton* back_button;
	GtkToggleButton* compose_tweet_button;
	MainWidget* main_widget;
	Account* account;
};

struct _MainWindowClass {
	GtkApplicationWindowClass parent_class;
};

typedef enum  {
	PAGE_STREAM = 0,
	PAGE_MENTIONS,
	PAGE_FAVORITES,
	PAGE_DM_THREADS,
	PAGE_LISTS,
	PAGE_FILTERS,
	PAGE_SEARCH,
	PAGE_PROFILE,
	PAGE_TWEET_INFO,
	PAGE_DM,
	PAGE_LIST_STATUSES,
	PAGE_PREVIOUS = 1024,
	PAGE_NEXT = 2048
} Page;

struct _TweetListBox {
	GtkListBox parent_instance;
	TweetListBoxPrivate * priv;
	CbDeltaUpdater* delta_updater;
	Account* account;
	CbTweetModel* model;
};

struct _TweetListBoxClass {
	GtkListBoxClass parent_class;
};


extern SoupSession* SOUP_SESSION;
extern CbSnippetManager* corebird_snippet_manager;

#define TWEET_UTILS_NO_SPELL_CHECK "gtksourceview:context-classes:no-spell-check"
static void tweet_utils_delete_tweet_data_free (gpointer _data);
GType account_get_type (void) G_GNUC_CONST;
void tweet_utils_delete_tweet (Account* account, CbTweet* tweet, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tweet_utils_delete_tweet_finish (GAsyncResult* _res_);
static gboolean tweet_utils_delete_tweet_co (TweetUtilsDeleteTweetData* _data_);
static Block53Data* block53_data_ref (Block53Data* _data53_);
static void block53_data_unref (void * _userdata_);
GType sql_database_get_type (void) G_GNUC_CONST;
GType notification_manager_get_type (void) G_GNUC_CONST;
static void __lambda48_ (Block53Data* _data53_, GObject* obj, GAsyncResult* res);
static void ___lambda48__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void tweet_utils_set_favorite_status_data_free (gpointer _data);
void tweet_utils_set_favorite_status (Account* account, CbTweet* tweet, gboolean status, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tweet_utils_set_favorite_status_finish (GAsyncResult* _res_);
static gboolean tweet_utils_set_favorite_status_co (TweetUtilsSetFavoriteStatusData* _data_);
static Block54Data* block54_data_ref (Block54Data* _data54_);
static void block54_data_unref (void * _userdata_);
static void __lambda45_ (Block54Data* _data54_, GObject* obj, GAsyncResult* res);
void utils_show_error_object (const gchar* json_data, const gchar* alternative, gint line, const gchar* file, GtkWindow* transient_for);
static void ___lambda45__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void tweet_utils_set_retweet_status_data_free (gpointer _data);
void tweet_utils_set_retweet_status (Account* account, CbTweet* tweet, gboolean status, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tweet_utils_set_retweet_status_finish (GAsyncResult* _res_);
static gboolean tweet_utils_set_retweet_status_co (TweetUtilsSetRetweetStatusData* _data_);
static Block55Data* block55_data_ref (Block55Data* _data55_);
static void block55_data_unref (void * _userdata_);
static void __lambda62_ (Block55Data* _data55_, GObject* obj, GAsyncResult* res);
static void ___lambda62__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void tweet_utils_download_avatar_data_free (gpointer _data);
void tweet_utils_download_avatar (const gchar* avatar_url, gint size, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GdkPixbuf* tweet_utils_download_avatar_finish (GAsyncResult* _res_, GError** error);
static gboolean tweet_utils_download_avatar_co (TweetUtilsDownloadAvatarData* _data_);
static Block56Data* block56_data_ref (Block56Data* _data56_);
static void block56_data_unref (void * _userdata_);
static void ___lambda54_ (Block56Data* _data56_);
static void ____lambda54__g_cancellable_cancelled (GCancellable* _sender, gpointer self);
static void __lambda55_ (Block56Data* _data56_, SoupSession* s, SoupMessage* _msg);
static guint8* _vala_array_dup7 (guint8* self, int length);
static void ___lambda55__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self);
gint tweet_utils_calc_tweet_length (const gchar* text, gint media_count);
gint tweet_utils_get_word_length (const gchar* s);
#define TWITTER_short_url_length 23
GType main_window_get_type (void) G_GNUC_CONST;
gboolean tweet_utils_activate_link (const gchar* uri, MainWindow* window);
#define PROFILE_PAGE_KEY_USER_ID 1
GType main_widget_get_type (void) G_GNUC_CONST;
void main_widget_switch_page (MainWidget* self, gint page_id, CbBundle* args);
GType page_get_type (void) G_GNUC_CONST;
#define PROFILE_PAGE_KEY_SCREEN_NAME 0
#define SEARCH_PAGE_KEY_QUERY 0
#define TWEET_INFO_PAGE_KEY_MODE 0
#define TWEET_INFO_PAGE_BY_ID 2
#define TWEET_INFO_PAGE_KEY_TWEET_ID 3
#define TWEET_INFO_PAGE_KEY_SCREEN_NAME 4
GType tweet_list_box_get_type (void) G_GNUC_CONST;
void tweet_utils_work_array (JsonArray* json_array, TweetListBox* tweet_list, Account* account);
gboolean account_filter_matches (Account* self, CbTweet* t);
void tweet_utils_handle_media_click (CbTweet* t, MainWindow* window, gint index, gdouble px, gdouble py);
GType media_dialog_get_type (void) G_GNUC_CONST;
MediaDialog* media_dialog_new (CbTweet* tweet, gint start_media_index, gdouble px, gdouble py);
MediaDialog* media_dialog_construct (GType object_type, CbTweet* tweet, gint start_media_index, gdouble px, gdouble py);
gboolean tweet_utils_is_link (const gchar* word);
gboolean tweet_utils_is_mention (const gchar* word, gint* at_pos);
static gboolean _vala_unichar_array_contains (gunichar * stack, int stack_length, gunichar needle);
gboolean tweet_utils_is_hashtag (const gchar* word);
void tweet_utils_highlight_link (GtkTextBuffer* buffer, GtkTextIter* word_start, GtkTextIter* word_end);
static GtkTextIter* _gtk_text_iter_dup (GtkTextIter* self);
void tweet_utils_highlight_mention (GtkTextBuffer* buffer, GtkTextIter* word_start, GtkTextIter* word_end);
void tweet_utils_highlight_hashtag (GtkTextBuffer* buffer, GtkTextIter* word_start, GtkTextIter* word_end);
void tweet_utils_maybe_highlight_snippet (GtkTextBuffer* buffer, GtkTextIter* word_start, GtkTextIter* word_end);
void tweet_utils_annotate_text (GtkTextBuffer* buffer);
void tweet_utils_sort_entities (CbTextEntity** entities, int* entities_length1);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

const gchar* TWEET_UTILS_DOMAINS[24] = {".com", ".net", ".org", ".xxx", ".sexy", ".pro", ".biz", ".name", ".info", ".arpa", ".gov", ".aero", ".asia", ".cat", ".coop", ".edu", ".int", ".jobs", ".mil", ".mobi", ".museum", ".post", ".tel", ".travel"};
const gunichar TWEET_UTILS_non_mention_chars[15] = {8220U, (gunichar) '"', (gunichar) '-', (gunichar) '`', (gunichar) ',', (gunichar) '.', (gunichar) '^', (gunichar) '(', (gunichar) ')', (gunichar) '[', (gunichar) ']', (gunichar) '{', (gunichar) '}', (gunichar) '+', (gunichar) '='};

static void tweet_utils_delete_tweet_data_free (gpointer _data) {
	TweetUtilsDeleteTweetData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->account);
	_g_object_unref0 (_data_->tweet);
	g_slice_free (TweetUtilsDeleteTweetData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void tweet_utils_delete_tweet (Account* account, CbTweet* tweet, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TweetUtilsDeleteTweetData* _data_;
	Account* _tmp0_;
	Account* _tmp1_;
	CbTweet* _tmp2_;
	CbTweet* _tmp3_;
	_data_ = g_slice_new0 (TweetUtilsDeleteTweetData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, tweet_utils_delete_tweet_data_free);
	_tmp0_ = account;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data_->account);
	_data_->account = _tmp1_;
	_tmp2_ = tweet;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_data_->tweet);
	_data_->tweet = _tmp3_;
	tweet_utils_delete_tweet_co (_data_);
}


void tweet_utils_delete_tweet_finish (GAsyncResult* _res_) {
	TweetUtilsDeleteTweetData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}


/**
   * Deletes the given tweet.
   *
   * @param account The account to delete the tweet from
   * @param tweet the tweet to delete
   */
static Block53Data* block53_data_ref (Block53Data* _data53_) {
	g_atomic_int_inc (&_data53_->_ref_count_);
	return _data53_;
}


static void block53_data_unref (void * _userdata_) {
	Block53Data* _data53_;
	_data53_ = (Block53Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data53_->_ref_count_)) {
		_g_object_unref0 (_data53_->call);
		g_slice_free (Block53Data, _data53_);
	}
}


static void __lambda48_ (Block53Data* _data53_, GObject* obj, GAsyncResult* res) {
	GError * _inner_error_ = NULL;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		GAsyncResult* _tmp0_;
		_tmp0_ = res;
		rest_proxy_call_invoke_finish (_data53_->call, _tmp0_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch59_g_error;
		}
	}
	goto __finally59;
	__catch59_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_critical ("TweetUtils.vala:39: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally59:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	tweet_utils_delete_tweet_co (_data53_->_async_data_);
}


static void ___lambda48__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda48_ (self, source_object, res);
	block53_data_unref (self);
}


static gboolean tweet_utils_delete_tweet_co (TweetUtilsDeleteTweetData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data53_ = g_slice_new0 (Block53Data);
	_data_->_data53_->_ref_count_ = 1;
	_data_->_data53_->_async_data_ = _data_;
	_data_->_tmp0_ = _data_->account;
	_data_->_tmp1_ = _data_->_tmp0_->proxy;
	_data_->_tmp2_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, rest_proxy_get_type (), RestProxy));
	_data_->_data53_->call = _data_->_tmp2_;
	rest_proxy_call_set_method (_data_->_data53_->call, "POST");
	_data_->_tmp3_ = _data_->tweet;
	_data_->_tmp4_ = _data_->_tmp3_->id;
	_data_->_tmp5_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp4_);
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_tmp7_ = g_strconcat ("1.1/statuses/destroy/", _data_->_tmp6_, NULL);
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp9_ = g_strconcat (_data_->_tmp8_, ".json", NULL);
	_data_->_tmp10_ = _data_->_tmp9_;
	rest_proxy_call_set_function (_data_->_data53_->call, _data_->_tmp10_);
	_g_free0 (_data_->_tmp10_);
	_g_free0 (_data_->_tmp8_);
	_g_free0 (_data_->_tmp6_);
	_data_->_tmp11_ = _data_->tweet;
	_data_->_tmp12_ = _data_->_tmp11_->id;
	_data_->_tmp13_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp12_);
	_data_->_tmp14_ = _data_->_tmp13_;
	rest_proxy_call_add_param (_data_->_data53_->call, "id", _data_->_tmp14_);
	_g_free0 (_data_->_tmp14_);
	rest_proxy_call_invoke_async (_data_->_data53_->call, NULL, ___lambda48__gasync_ready_callback, block53_data_ref (_data_->_data53_));
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	block53_data_unref (_data_->_data53_);
	_data_->_data53_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void tweet_utils_set_favorite_status_data_free (gpointer _data) {
	TweetUtilsSetFavoriteStatusData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->account);
	g_slice_free (TweetUtilsSetFavoriteStatusData, _data_);
}


void tweet_utils_set_favorite_status (Account* account, CbTweet* tweet, gboolean status, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TweetUtilsSetFavoriteStatusData* _data_;
	Account* _tmp0_;
	Account* _tmp1_;
	CbTweet* _tmp2_;
	CbTweet* _tmp3_;
	gboolean _tmp4_;
	_data_ = g_slice_new0 (TweetUtilsSetFavoriteStatusData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, tweet_utils_set_favorite_status_data_free);
	_tmp0_ = account;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data_->account);
	_data_->account = _tmp1_;
	_tmp2_ = tweet;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_data_->tweet);
	_data_->tweet = _tmp3_;
	_tmp4_ = status;
	_data_->status = _tmp4_;
	tweet_utils_set_favorite_status_co (_data_);
}


void tweet_utils_set_favorite_status_finish (GAsyncResult* _res_) {
	TweetUtilsSetFavoriteStatusData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}


/**
   * (Un)favorites the given tweet.
   *
   * @param account The account to (un)favorite from
   * @param tweet The tweet to (un)favorite
   * @param status %true to favorite the tweet, %false to unfavorite it.
   */
static Block54Data* block54_data_ref (Block54Data* _data54_) {
	g_atomic_int_inc (&_data54_->_ref_count_);
	return _data54_;
}


static void block54_data_unref (void * _userdata_) {
	Block54Data* _data54_;
	_data54_ = (Block54Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data54_->_ref_count_)) {
		_g_object_unref0 (_data54_->call);
		_g_object_unref0 (_data54_->tweet);
		g_slice_free (Block54Data, _data54_);
	}
}


static void __lambda45_ (Block54Data* _data54_, GObject* obj, GAsyncResult* res) {
	gboolean _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		RestProxyCall* _tmp0_;
		GAsyncResult* _tmp1_;
		_tmp0_ = _data54_->call;
		_tmp1_ = res;
		rest_proxy_call_invoke_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch60_g_error;
		}
	}
	goto __finally60;
	__catch60_g_error:
	{
		GError* e = NULL;
		RestProxyCall* _tmp2_;
		const gchar* _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = _data54_->call;
		_tmp3_ = rest_proxy_call_get_payload (_tmp2_);
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		utils_show_error_object (_tmp3_, _tmp5_, 66, "TweetUtils.vala", NULL);
		_g_error_free0 (e);
	}
	__finally60:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp6_ = _data54_->status;
	if (_tmp6_) {
		CbTweet* _tmp7_;
		_tmp7_ = _data54_->tweet;
		cb_tweet_set_flag (_tmp7_, (guint) CB_TWEET_STATE_FAVORITED);
	} else {
		CbTweet* _tmp8_;
		_tmp8_ = _data54_->tweet;
		cb_tweet_unset_flag (_tmp8_, (guint) CB_TWEET_STATE_FAVORITED);
	}
	tweet_utils_set_favorite_status_co (_data54_->_async_data_);
}


static void ___lambda45__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda45_ (self, source_object, res);
	block54_data_unref (self);
}


static gboolean tweet_utils_set_favorite_status_co (TweetUtilsSetFavoriteStatusData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data54_ = g_slice_new0 (Block54Data);
	_data_->_data54_->_ref_count_ = 1;
	_data_->_tmp0_ = _data_->tweet;
	_g_object_unref0 (_data_->_data54_->tweet);
	_data_->_data54_->tweet = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->status;
	_data_->_data54_->status = _data_->_tmp1_;
	_data_->_data54_->_async_data_ = _data_;
	_data_->_tmp2_ = _data_->account;
	_data_->_tmp3_ = _data_->_tmp2_->proxy;
	_data_->_tmp4_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp3_, rest_proxy_get_type (), RestProxy));
	_data_->_data54_->call = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->_data54_->status;
	if (_data_->_tmp5_) {
		_data_->_tmp6_ = _data_->_data54_->call;
		rest_proxy_call_set_function (_data_->_tmp6_, "1.1/favorites/create.json");
	} else {
		_data_->_tmp7_ = _data_->_data54_->call;
		rest_proxy_call_set_function (_data_->_tmp7_, "1.1/favorites/destroy.json");
	}
	_data_->_tmp8_ = _data_->_data54_->call;
	rest_proxy_call_set_method (_data_->_tmp8_, "POST");
	_data_->_tmp9_ = _data_->_data54_->call;
	_data_->_tmp10_ = _data_->_data54_->tweet;
	_data_->_tmp11_ = _data_->_tmp10_->id;
	_data_->_tmp12_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp11_);
	_data_->_tmp13_ = _data_->_tmp12_;
	rest_proxy_call_add_param (_data_->_tmp9_, "id", _data_->_tmp13_);
	_g_free0 (_data_->_tmp13_);
	_data_->_tmp14_ = _data_->_data54_->call;
	rest_proxy_call_invoke_async (_data_->_tmp14_, NULL, ___lambda45__gasync_ready_callback, block54_data_ref (_data_->_data54_));
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	block54_data_unref (_data_->_data54_);
	_data_->_data54_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void tweet_utils_set_retweet_status_data_free (gpointer _data) {
	TweetUtilsSetRetweetStatusData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->account);
	g_slice_free (TweetUtilsSetRetweetStatusData, _data_);
}


void tweet_utils_set_retweet_status (Account* account, CbTweet* tweet, gboolean status, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TweetUtilsSetRetweetStatusData* _data_;
	Account* _tmp0_;
	Account* _tmp1_;
	CbTweet* _tmp2_;
	CbTweet* _tmp3_;
	gboolean _tmp4_;
	_data_ = g_slice_new0 (TweetUtilsSetRetweetStatusData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, tweet_utils_set_retweet_status_data_free);
	_tmp0_ = account;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data_->account);
	_data_->account = _tmp1_;
	_tmp2_ = tweet;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_data_->tweet);
	_data_->tweet = _tmp3_;
	_tmp4_ = status;
	_data_->status = _tmp4_;
	tweet_utils_set_retweet_status_co (_data_);
}


void tweet_utils_set_retweet_status_finish (GAsyncResult* _res_) {
	TweetUtilsSetRetweetStatusData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}


/**
   * (Un)retweets the given tweet.
   *
   * @param account The account to (un)retweet from
   * @param tweet The tweet to (un)retweet
   * @param status %true to retweet it, false to unretweet it.
   */
static Block55Data* block55_data_ref (Block55Data* _data55_) {
	g_atomic_int_inc (&_data55_->_ref_count_);
	return _data55_;
}


static void block55_data_unref (void * _userdata_) {
	Block55Data* _data55_;
	_data55_ = (Block55Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data55_->_ref_count_)) {
		_g_object_unref0 (_data55_->call);
		_g_object_unref0 (_data55_->tweet);
		g_slice_free (Block55Data, _data55_);
	}
}


static void __lambda62_ (Block55Data* _data55_, GObject* obj, GAsyncResult* res) {
	const gchar* back = NULL;
	RestProxyCall* _tmp6_;
	const gchar* _tmp7_;
	JsonParser* parser = NULL;
	JsonParser* _tmp8_;
	GError * _inner_error_ = NULL;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		RestProxyCall* _tmp0_;
		GAsyncResult* _tmp1_;
		_tmp0_ = _data55_->call;
		_tmp1_ = res;
		rest_proxy_call_invoke_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch61_g_error;
		}
	}
	goto __finally61;
	__catch61_g_error:
	{
		GError* e = NULL;
		RestProxyCall* _tmp2_;
		const gchar* _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = _data55_->call;
		_tmp3_ = rest_proxy_call_get_payload (_tmp2_);
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		utils_show_error_object (_tmp3_, _tmp5_, 99, "TweetUtils.vala", NULL);
		_g_error_free0 (e);
	}
	__finally61:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp6_ = _data55_->call;
	_tmp7_ = rest_proxy_call_get_payload (_tmp6_);
	back = _tmp7_;
	_tmp8_ = json_parser_new ();
	parser = _tmp8_;
	{
		gboolean _tmp9_;
		gboolean _tmp16_;
		json_parser_load_from_data (parser, back, (gssize) -1, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch62_g_error;
		}
		_tmp9_ = _data55_->status;
		if (_tmp9_) {
			gint64 new_id = 0LL;
			JsonNode* _tmp10_;
			JsonObject* _tmp11_;
			gint64 _tmp12_;
			CbTweet* _tmp13_;
			gint64 _tmp14_;
			_tmp10_ = json_parser_get_root (parser);
			_tmp11_ = json_node_get_object (_tmp10_);
			_tmp12_ = json_object_get_int_member (_tmp11_, "id");
			new_id = _tmp12_;
			_tmp13_ = _data55_->tweet;
			_tmp14_ = new_id;
			_tmp13_->my_retweet = _tmp14_;
		} else {
			CbTweet* _tmp15_;
			_tmp15_ = _data55_->tweet;
			_tmp15_->my_retweet = (gint64) 0;
		}
		_tmp16_ = _data55_->status;
		if (_tmp16_) {
			CbTweet* _tmp17_;
			_tmp17_ = _data55_->tweet;
			cb_tweet_set_flag (_tmp17_, (guint) CB_TWEET_STATE_RETWEETED);
		} else {
			CbTweet* _tmp18_;
			_tmp18_ = _data55_->tweet;
			cb_tweet_unset_flag (_tmp18_, (guint) CB_TWEET_STATE_RETWEETED);
		}
	}
	goto __finally62;
	__catch62_g_error:
	{
		GError* e = NULL;
		GError* _tmp19_;
		const gchar* _tmp20_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp19_ = e;
		_tmp20_ = _tmp19_->message;
		g_critical ("TweetUtils.vala:116: %s", _tmp20_);
		g_critical ("TweetUtils.vala:117: %s", back);
		_g_error_free0 (e);
	}
	__finally62:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (parser);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	tweet_utils_set_retweet_status_co (_data55_->_async_data_);
	_g_object_unref0 (parser);
}


static void ___lambda62__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda62_ (self, source_object, res);
	block55_data_unref (self);
}


static gboolean tweet_utils_set_retweet_status_co (TweetUtilsSetRetweetStatusData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data55_ = g_slice_new0 (Block55Data);
	_data_->_data55_->_ref_count_ = 1;
	_data_->_tmp0_ = _data_->tweet;
	_g_object_unref0 (_data_->_data55_->tweet);
	_data_->_data55_->tweet = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->status;
	_data_->_data55_->status = _data_->_tmp1_;
	_data_->_data55_->_async_data_ = _data_;
	_data_->_tmp2_ = _data_->account;
	_data_->_tmp3_ = _data_->_tmp2_->proxy;
	_data_->_tmp4_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp3_, rest_proxy_get_type (), RestProxy));
	_data_->_data55_->call = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->_data55_->call;
	rest_proxy_call_set_method (_data_->_tmp5_, "POST");
	_data_->_tmp6_ = _data_->_data55_->status;
	if (_data_->_tmp6_) {
		_data_->_tmp7_ = _data_->_data55_->call;
		_data_->_tmp8_ = _data_->_data55_->tweet;
		_data_->_tmp9_ = _data_->_tmp8_->id;
		_data_->_tmp10_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp9_);
		_data_->_tmp11_ = _data_->_tmp10_;
		_data_->_tmp12_ = g_strconcat ("1.1/statuses/retweet/", _data_->_tmp11_, ".json", NULL);
		_data_->_tmp13_ = _data_->_tmp12_;
		rest_proxy_call_set_function (_data_->_tmp7_, _data_->_tmp13_);
		_g_free0 (_data_->_tmp13_);
		_g_free0 (_data_->_tmp11_);
	} else {
		_data_->_tmp14_ = _data_->_data55_->call;
		_data_->_tmp15_ = _data_->_data55_->tweet;
		_data_->_tmp16_ = _data_->_tmp15_->my_retweet;
		_data_->_tmp17_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp16_);
		_data_->_tmp18_ = _data_->_tmp17_;
		_data_->_tmp19_ = g_strconcat ("1.1/statuses/destroy/", _data_->_tmp18_, ".json", NULL);
		_data_->_tmp20_ = _data_->_tmp19_;
		rest_proxy_call_set_function (_data_->_tmp14_, _data_->_tmp20_);
		_g_free0 (_data_->_tmp20_);
		_g_free0 (_data_->_tmp18_);
	}
	_data_->_tmp21_ = _data_->_data55_->call;
	_data_->_tmp22_ = cb_utils_rest_proxy_call_to_string (_data_->_tmp21_);
	_data_->_tmp23_ = _data_->_tmp22_;
	g_debug ("TweetUtils.vala:93: %s", _data_->_tmp23_);
	_g_free0 (_data_->_tmp23_);
	_data_->_tmp24_ = _data_->_data55_->call;
	rest_proxy_call_invoke_async (_data_->_tmp24_, NULL, ___lambda62__gasync_ready_callback, block55_data_ref (_data_->_data55_));
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	block55_data_unref (_data_->_data55_);
	_data_->_data55_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void tweet_utils_download_avatar_data_free (gpointer _data) {
	TweetUtilsDownloadAvatarData* _data_;
	_data_ = _data;
	_g_free0 (_data_->avatar_url);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	g_slice_free (TweetUtilsDownloadAvatarData, _data_);
}


void tweet_utils_download_avatar (const gchar* avatar_url, gint size, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TweetUtilsDownloadAvatarData* _data_;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	_data_ = g_slice_new0 (TweetUtilsDownloadAvatarData);
	_data_->_async_result = g_task_new (NULL, cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, tweet_utils_download_avatar_data_free);
	_tmp0_ = avatar_url;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (_data_->avatar_url);
	_data_->avatar_url = _tmp1_;
	_tmp2_ = size;
	_data_->size = _tmp2_;
	_tmp3_ = cancellable;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp4_;
	tweet_utils_download_avatar_co (_data_);
}


GdkPixbuf* tweet_utils_download_avatar_finish (GAsyncResult* _res_, GError** error) {
	GdkPixbuf* result;
	TweetUtilsDownloadAvatarData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
   * Downloads the avatar from the given url.
   *
   * @param avatar_url The avatar url to download
   *
   * @return The loaded avatar.
   */
static Block56Data* block56_data_ref (Block56Data* _data56_) {
	g_atomic_int_inc (&_data56_->_ref_count_);
	return _data56_;
}


static void block56_data_unref (void * _userdata_) {
	Block56Data* _data56_;
	_data56_ = (Block56Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data56_->_ref_count_)) {
		_g_error_free0 (_data56_->err);
		_g_object_unref0 (_data56_->msg);
		_g_object_unref0 (_data56_->avatar);
		g_slice_free (Block56Data, _data56_);
	}
}


static void ___lambda54_ (Block56Data* _data56_) {
	SoupSession* _tmp0_;
	SoupMessage* _tmp1_;
	_tmp0_ = SOUP_SESSION;
	_tmp1_ = _data56_->msg;
	soup_session_cancel_message (_tmp0_, _tmp1_, (guint) SOUP_STATUS_CANCELLED);
}


static void ____lambda54__g_cancellable_cancelled (GCancellable* _sender, gpointer self) {
	___lambda54_ (self);
}


static guint8* _vala_array_dup7 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static void __lambda55_ (Block56Data* _data56_, SoupSession* s, SoupMessage* _msg) {
	SoupMessage* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	GMemoryInputStream* memory_stream = NULL;
	SoupMessage* _tmp3_;
	SoupMessageBody* _tmp4_;
	guint8* _tmp5_;
	gint _tmp5__length1;
	guint8* _tmp6_;
	gint _tmp6__length1;
	GDestroyNotify _tmp7_;
	GMemoryInputStream* _tmp8_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (SOUP_IS_SESSION (s));
	g_return_if_fail (SOUP_IS_MESSAGE (_msg));
	_tmp0_ = _msg;
	g_object_get (_tmp0_, "status-code", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != ((guint) SOUP_STATUS_OK)) {
		_g_object_unref0 (_data56_->avatar);
		_data56_->avatar = NULL;
		tweet_utils_download_avatar_co (_data56_->_async_data_);
		return;
	}
	_tmp3_ = _msg;
	_tmp4_ = _tmp3_->response_body;
	_tmp5_ = _tmp4_->data;
	_tmp5__length1 = (gint) _tmp4_->length;
	_tmp6_ = (_tmp5_ != NULL) ? _vala_array_dup7 (_tmp5_, _tmp5__length1) : ((gpointer) _tmp5_);
	_tmp6__length1 = _tmp5__length1;
	_tmp7_ = g_free;
	_tmp8_ = (GMemoryInputStream*) g_memory_input_stream_new_from_data (_tmp6_, _tmp6__length1, _tmp7_);
	memory_stream = _tmp8_;
	{
		GdkPixbuf* _tmp9_ = NULL;
		GMemoryInputStream* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		GdkPixbuf* _tmp13_;
		GdkPixbuf* _tmp14_;
		_tmp10_ = memory_stream;
		_tmp11_ = _data56_->size;
		_tmp12_ = _data56_->size;
		_tmp13_ = gdk_pixbuf_new_from_stream_at_scale (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, g_input_stream_get_type (), GInputStream), _tmp11_, _tmp12_, FALSE, NULL, &_inner_error_);
		_tmp9_ = _tmp13_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch63_g_error;
		}
		_tmp14_ = _tmp9_;
		_tmp9_ = NULL;
		_g_object_unref0 (_data56_->avatar);
		_data56_->avatar = _tmp14_;
		_g_object_unref0 (_tmp9_);
	}
	goto __finally63;
	__catch63_g_error:
	{
		GError* e = NULL;
		GError* _tmp15_;
		GError* _tmp16_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp15_ = e;
		_tmp16_ = _g_error_copy0 (_tmp15_);
		_g_error_free0 (_data56_->err);
		_data56_->err = _tmp16_;
		_g_error_free0 (e);
	}
	__finally63:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (memory_stream);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	tweet_utils_download_avatar_co (_data56_->_async_data_);
	_g_object_unref0 (memory_stream);
}


static void ___lambda55__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self) {
	__lambda55_ (self, session, msg);
	block56_data_unref (self);
}


static gboolean tweet_utils_download_avatar_co (TweetUtilsDownloadAvatarData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data56_ = g_slice_new0 (Block56Data);
	_data_->_data56_->_ref_count_ = 1;
	_data_->_tmp0_ = _data_->size;
	_data_->_data56_->size = _data_->_tmp0_;
	_data_->_data56_->_async_data_ = _data_;
	_data_->_data56_->avatar = NULL;
	_data_->_tmp1_ = _data_->avatar_url;
	_data_->_tmp2_ = soup_message_new ("GET", _data_->_tmp1_);
	_data_->_data56_->msg = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->cancellable;
	if (_data_->_tmp3_ != NULL) {
		_data_->_tmp4_ = _data_->cancellable;
		g_signal_connect_data (_data_->_tmp4_, "cancelled", (GCallback) ____lambda54__g_cancellable_cancelled, block56_data_ref (_data_->_data56_), (GClosureNotify) block56_data_unref, 0);
	}
	_data_->_data56_->err = NULL;
	_data_->_tmp5_ = SOUP_SESSION;
	_data_->_tmp6_ = _data_->_data56_->msg;
	_data_->_tmp7_ = _g_object_ref0 (_data_->_tmp6_);
	soup_session_queue_message (_data_->_tmp5_, _data_->_tmp7_, ___lambda55__soup_session_callback, block56_data_ref (_data_->_data56_));
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp8_ = _data_->_data56_->err;
	if (_data_->_tmp8_ != NULL) {
		_data_->_tmp9_ = _data_->_data56_->err;
		_data_->_tmp10_ = _g_error_copy0 (_data_->_tmp9_);
		_data_->_inner_error_ = _data_->_tmp10_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		block56_data_unref (_data_->_data56_);
		_data_->_data56_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp11_ = _data_->_data56_->avatar;
	_data_->_tmp12_ = _g_object_ref0 (_data_->_tmp11_);
	_data_->result = _data_->_tmp12_;
	block56_data_unref (_data_->_data56_);
	_data_->_data56_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
   * Calculates the length of a tweet.
   *
   * @param text The text to calculate the length for
   *
   * @return The length of the tweet, taking Twitter's rules for
   *         tweet length into account.
   */
static gboolean string_get_next_char (const gchar* self, gint* index, gunichar* c) {
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	gint _tmp0_;
	gunichar _tmp1_;
	gunichar _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = *index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	_vala_c = _tmp1_;
	_tmp2_ = _vala_c;
	if (_tmp2_ != ((gunichar) 0)) {
		gint _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = *index;
		_tmp4_ = g_utf8_next_char (((gchar*) self) + _tmp3_);
		*index = (gint) (_tmp4_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
	if (c) {
		*c = _vala_c;
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	glong _tmp8_;
	glong _tmp14_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	gchar* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_;
		glong _tmp4_;
		glong _tmp5_;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_;
		gint _tmp7_;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_;
		glong _tmp10_;
		glong _tmp11_;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_;
		glong _tmp13_;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


gint tweet_utils_calc_tweet_length (const gchar* text, gint media_count) {
	gint result = 0;
	gint length = 0;
	gunichar c = 0U;
	gint last_word_start = 0;
	gint n_chars = 0;
	const gchar* _tmp0_;
	gint _tmp1_;
	gint cur = 0;
	g_return_val_if_fail (text != NULL, 0);
	length = 0;
	last_word_start = 0;
	_tmp0_ = text;
	_tmp1_ = g_utf8_strlen (_tmp0_, (gssize) -1);
	n_chars = _tmp1_;
	cur = 0;
	{
		gint next = 0;
		gint c_n = 0;
		next = 0;
		c_n = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				const gchar* _tmp4_;
				gunichar _tmp5_ = 0U;
				gboolean _tmp6_;
				gboolean _tmp7_ = FALSE;
				gboolean _tmp8_ = FALSE;
				gboolean _tmp9_ = FALSE;
				gboolean _tmp10_ = FALSE;
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
				gboolean _tmp13_ = FALSE;
				gunichar _tmp14_;
				gboolean splits = FALSE;
				gboolean _tmp22_ = FALSE;
				gboolean _tmp23_;
				gint _tmp45_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = c_n;
					c_n = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = text;
				_tmp6_ = string_get_next_char (_tmp4_, &next, &_tmp5_);
				c = _tmp5_;
				if (!_tmp6_) {
					break;
				}
				_tmp14_ = c;
				if (_tmp14_ == ((gunichar) ' ')) {
					_tmp13_ = TRUE;
				} else {
					gunichar _tmp15_;
					_tmp15_ = c;
					_tmp13_ = _tmp15_ == ((gunichar) '\n');
				}
				if (_tmp13_) {
					_tmp12_ = TRUE;
				} else {
					gunichar _tmp16_;
					_tmp16_ = c;
					_tmp12_ = _tmp16_ == ((gunichar) '(');
				}
				if (_tmp12_) {
					_tmp11_ = TRUE;
				} else {
					gunichar _tmp17_;
					_tmp17_ = c;
					_tmp11_ = _tmp17_ == ((gunichar) ')');
				}
				if (_tmp11_) {
					_tmp10_ = TRUE;
				} else {
					gunichar _tmp18_;
					_tmp18_ = c;
					_tmp10_ = _tmp18_ == ((gunichar) '[');
				}
				if (_tmp10_) {
					_tmp9_ = TRUE;
				} else {
					gunichar _tmp19_;
					_tmp19_ = c;
					_tmp9_ = _tmp19_ == ((gunichar) ']');
				}
				if (_tmp9_) {
					_tmp8_ = TRUE;
				} else {
					gunichar _tmp20_;
					_tmp20_ = c;
					_tmp8_ = _tmp20_ == ((gunichar) '{');
				}
				if (_tmp8_) {
					_tmp7_ = TRUE;
				} else {
					gunichar _tmp21_;
					_tmp21_ = c;
					_tmp7_ = _tmp21_ == ((gunichar) '}');
				}
				splits = _tmp7_;
				_tmp23_ = splits;
				if (_tmp23_) {
					_tmp22_ = TRUE;
				} else {
					gint _tmp24_;
					gint _tmp25_;
					_tmp24_ = c_n;
					_tmp25_ = n_chars;
					_tmp22_ = _tmp24_ == (_tmp25_ - 1);
				}
				if (_tmp22_) {
					gboolean _tmp26_ = FALSE;
					gboolean _tmp27_;
					gchar* word = NULL;
					const gchar* _tmp31_;
					gint _tmp32_;
					gint _tmp33_;
					gint _tmp34_;
					gchar* _tmp35_;
					const gchar* _tmp36_;
					gint _tmp37_;
					gint _tmp38_;
					gboolean _tmp42_;
					gint _tmp44_;
					_tmp27_ = splits;
					if (!_tmp27_) {
						gint _tmp28_;
						gint _tmp29_;
						_tmp28_ = c_n;
						_tmp29_ = n_chars;
						_tmp26_ = _tmp28_ == (_tmp29_ - 1);
					} else {
						_tmp26_ = FALSE;
					}
					if (_tmp26_) {
						gint _tmp30_;
						_tmp30_ = next;
						cur = _tmp30_;
					}
					_tmp31_ = text;
					_tmp32_ = last_word_start;
					_tmp33_ = cur;
					_tmp34_ = last_word_start;
					_tmp35_ = string_substring (_tmp31_, (glong) _tmp32_, (glong) (_tmp33_ - _tmp34_));
					word = _tmp35_;
					_tmp36_ = word;
					_tmp37_ = strlen (_tmp36_);
					_tmp38_ = _tmp37_;
					if (_tmp38_ > 0) {
						gint _tmp39_;
						const gchar* _tmp40_;
						gint _tmp41_;
						_tmp39_ = length;
						_tmp40_ = word;
						_tmp41_ = tweet_utils_get_word_length (_tmp40_);
						length = _tmp39_ + _tmp41_;
					}
					_tmp42_ = splits;
					if (_tmp42_) {
						gint _tmp43_;
						_tmp43_ = length;
						length = _tmp43_ + 1;
					}
					_tmp44_ = cur;
					last_word_start = _tmp44_ + 1;
					_g_free0 (word);
				}
				_tmp45_ = next;
				cur = _tmp45_;
			}
		}
	}
	result = length;
	return result;
}


gint tweet_utils_get_word_length (const gchar* s) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gboolean _tmp3_;
	gchar** parts = NULL;
	const gchar* _tmp8_;
	gchar** _tmp9_;
	gchar** _tmp10_;
	gint parts_length1;
	gint _parts_size_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	const gchar* _tmp16_;
	gint _tmp17_;
	g_return_val_if_fail (s != NULL, 0);
	_tmp2_ = s;
	_tmp3_ = g_str_has_prefix (_tmp2_, "www.");
	if (_tmp3_) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp4_;
		gboolean _tmp5_;
		_tmp4_ = s;
		_tmp5_ = g_str_has_prefix (_tmp4_, "http://");
		_tmp1_ = _tmp5_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp6_;
		gboolean _tmp7_;
		_tmp6_ = s;
		_tmp7_ = g_str_has_prefix (_tmp6_, "https://");
		_tmp0_ = _tmp7_;
	}
	if (_tmp0_) {
		result = TWITTER_short_url_length;
		return result;
	}
	_tmp8_ = s;
	_tmp10_ = _tmp9_ = g_strsplit (_tmp8_, "/", 0);
	parts = _tmp10_;
	parts_length1 = _vala_array_length (_tmp9_);
	_parts_size_ = parts_length1;
	_tmp11_ = parts;
	_tmp11__length1 = parts_length1;
	if (_tmp11__length1 > 0) {
		{
			const gchar** tld_collection = NULL;
			gint tld_collection_length1 = 0;
			gint _tld_collection_size_ = 0;
			gint tld_it = 0;
			tld_collection = TWEET_UTILS_DOMAINS;
			tld_collection_length1 = G_N_ELEMENTS (TWEET_UTILS_DOMAINS);
			for (tld_it = 0; tld_it < G_N_ELEMENTS (TWEET_UTILS_DOMAINS); tld_it = tld_it + 1) {
				const gchar* tld = NULL;
				tld = tld_collection[tld_it];
				{
					gchar** _tmp12_;
					gint _tmp12__length1;
					const gchar* _tmp13_;
					const gchar* _tmp14_;
					gboolean _tmp15_;
					_tmp12_ = parts;
					_tmp12__length1 = parts_length1;
					_tmp13_ = _tmp12_[0];
					_tmp14_ = tld;
					_tmp15_ = g_str_has_suffix (_tmp13_, _tmp14_);
					if (_tmp15_) {
						result = TWITTER_short_url_length;
						parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
						return result;
					}
				}
			}
		}
	}
	_tmp16_ = s;
	_tmp17_ = g_utf8_strlen (_tmp16_, (gssize) -1);
	result = _tmp17_;
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gint64 int64_parse (const gchar* str) {
	gint64 result = 0LL;
	const gchar* _tmp0_;
	gint64 _tmp1_;
	g_return_val_if_fail (str != NULL, 0LL);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtoll (_tmp0_, NULL, (guint) 0);
	result = _tmp1_;
	return result;
}


gboolean tweet_utils_activate_link (const gchar* uri, MainWindow* window) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* term = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gboolean _tmp6_;
	g_return_val_if_fail (uri != NULL, FALSE);
	g_return_val_if_fail (IS_MAIN_WINDOW (window), FALSE);
	_tmp0_ = uri;
	g_debug ("TweetUtils.vala:225: Activating '%s'", _tmp0_);
	_tmp1_ = uri;
	_tmp2_ = g_strstrip (_tmp1_);
	uri = _tmp2_;
	_tmp3_ = uri;
	_tmp4_ = string_substring (_tmp3_, (glong) 1, (glong) -1);
	term = _tmp4_;
	_tmp5_ = uri;
	_tmp6_ = g_str_has_prefix (_tmp5_, "@");
	if (_tmp6_) {
		gint slash_index = 0;
		const gchar* _tmp7_;
		gint _tmp8_;
		CbBundle* bundle = NULL;
		CbBundle* _tmp9_;
		gint _tmp10_;
		_tmp7_ = uri;
		_tmp8_ = string_index_of (_tmp7_, "/", 0);
		slash_index = _tmp8_;
		_tmp9_ = cb_bundle_new ();
		bundle = _tmp9_;
		_tmp10_ = slash_index;
		if (_tmp10_ == -1) {
			CbBundle* _tmp11_;
			const gchar* _tmp12_;
			gint64 _tmp13_;
			MainWindow* _tmp14_;
			MainWidget* _tmp15_;
			CbBundle* _tmp16_;
			_tmp11_ = bundle;
			_tmp12_ = term;
			_tmp13_ = int64_parse (_tmp12_);
			cb_bundle_put_int64 (_tmp11_, PROFILE_PAGE_KEY_USER_ID, _tmp13_);
			_tmp14_ = window;
			_tmp15_ = _tmp14_->main_widget;
			_tmp16_ = bundle;
			main_widget_switch_page (_tmp15_, (gint) PAGE_PROFILE, _tmp16_);
		} else {
			CbBundle* _tmp17_;
			const gchar* _tmp18_;
			gint _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			gint64 _tmp22_;
			CbBundle* _tmp23_;
			const gchar* _tmp24_;
			gint _tmp25_;
			const gchar* _tmp26_;
			gint _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			MainWindow* _tmp32_;
			MainWidget* _tmp33_;
			CbBundle* _tmp34_;
			_tmp17_ = bundle;
			_tmp18_ = term;
			_tmp19_ = slash_index;
			_tmp20_ = string_substring (_tmp18_, (glong) 0, (glong) (_tmp19_ - 1));
			_tmp21_ = _tmp20_;
			_tmp22_ = int64_parse (_tmp21_);
			cb_bundle_put_int64 (_tmp17_, PROFILE_PAGE_KEY_USER_ID, _tmp22_);
			_g_free0 (_tmp21_);
			_tmp23_ = bundle;
			_tmp24_ = term;
			_tmp25_ = slash_index;
			_tmp26_ = term;
			_tmp27_ = strlen (_tmp26_);
			_tmp28_ = _tmp27_;
			_tmp29_ = slash_index;
			_tmp30_ = string_substring (_tmp24_, (glong) (_tmp25_ + 1), (glong) ((_tmp28_ - _tmp29_) - 1));
			_tmp31_ = _tmp30_;
			cb_bundle_put_string (_tmp23_, PROFILE_PAGE_KEY_SCREEN_NAME, _tmp31_);
			_g_free0 (_tmp31_);
			_tmp32_ = window;
			_tmp33_ = _tmp32_->main_widget;
			_tmp34_ = bundle;
			main_widget_switch_page (_tmp33_, (gint) PAGE_PROFILE, _tmp34_);
		}
		result = TRUE;
		_g_object_unref0 (bundle);
		_g_free0 (term);
		return result;
	} else {
		const gchar* _tmp35_;
		gboolean _tmp36_;
		_tmp35_ = uri;
		_tmp36_ = g_str_has_prefix (_tmp35_, "#");
		if (_tmp36_) {
			CbBundle* bundle = NULL;
			CbBundle* _tmp37_;
			CbBundle* _tmp38_;
			const gchar* _tmp39_;
			MainWindow* _tmp40_;
			MainWidget* _tmp41_;
			CbBundle* _tmp42_;
			_tmp37_ = cb_bundle_new ();
			bundle = _tmp37_;
			_tmp38_ = bundle;
			_tmp39_ = uri;
			cb_bundle_put_string (_tmp38_, SEARCH_PAGE_KEY_QUERY, _tmp39_);
			_tmp40_ = window;
			_tmp41_ = _tmp40_->main_widget;
			_tmp42_ = bundle;
			main_widget_switch_page (_tmp41_, (gint) PAGE_SEARCH, _tmp42_);
			result = TRUE;
			_g_object_unref0 (bundle);
			_g_free0 (term);
			return result;
		} else {
			const gchar* _tmp43_;
			gboolean _tmp44_;
			_tmp43_ = uri;
			_tmp44_ = g_str_has_prefix (_tmp43_, "https://twitter.com/");
			if (_tmp44_) {
				gchar** parts = NULL;
				const gchar* _tmp45_;
				gchar** _tmp46_;
				gchar** _tmp47_;
				gint parts_length1;
				gint _parts_size_;
				gchar** _tmp48_;
				gint _tmp48__length1;
				const gchar* _tmp49_;
				_tmp45_ = uri;
				_tmp47_ = _tmp46_ = g_strsplit (_tmp45_, "/", 0);
				parts = _tmp47_;
				parts_length1 = _vala_array_length (_tmp46_);
				_parts_size_ = parts_length1;
				_tmp48_ = parts;
				_tmp48__length1 = parts_length1;
				_tmp49_ = _tmp48_[4];
				if (g_strcmp0 (_tmp49_, "status") == 0) {
					gint64 tweet_id = 0LL;
					gchar** _tmp50_;
					gint _tmp50__length1;
					const gchar* _tmp51_;
					gint64 _tmp52_;
					CbBundle* bundle = NULL;
					CbBundle* _tmp53_;
					CbBundle* _tmp54_;
					CbBundle* _tmp55_;
					gint64 _tmp56_;
					CbBundle* _tmp57_;
					gchar** _tmp58_;
					gint _tmp58__length1;
					const gchar* _tmp59_;
					MainWindow* _tmp60_;
					MainWidget* _tmp61_;
					CbBundle* _tmp62_;
					_tmp50_ = parts;
					_tmp50__length1 = parts_length1;
					_tmp51_ = _tmp50_[5];
					_tmp52_ = int64_parse (_tmp51_);
					tweet_id = _tmp52_;
					_tmp53_ = cb_bundle_new ();
					bundle = _tmp53_;
					_tmp54_ = bundle;
					cb_bundle_put_int (_tmp54_, TWEET_INFO_PAGE_KEY_MODE, TWEET_INFO_PAGE_BY_ID);
					_tmp55_ = bundle;
					_tmp56_ = tweet_id;
					cb_bundle_put_int64 (_tmp55_, TWEET_INFO_PAGE_KEY_TWEET_ID, _tmp56_);
					_tmp57_ = bundle;
					_tmp58_ = parts;
					_tmp58__length1 = parts_length1;
					_tmp59_ = _tmp58_[3];
					cb_bundle_put_string (_tmp57_, TWEET_INFO_PAGE_KEY_SCREEN_NAME, _tmp59_);
					_tmp60_ = window;
					_tmp61_ = _tmp60_->main_widget;
					_tmp62_ = bundle;
					main_widget_switch_page (_tmp61_, (gint) PAGE_TWEET_INFO, _tmp62_);
					result = TRUE;
					_g_object_unref0 (bundle);
					parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (term);
					return result;
				}
				parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
			}
		}
	}
	result = FALSE;
	_g_free0 (term);
	return result;
}


void tweet_utils_work_array (JsonArray* json_array, TweetListBox* tweet_list, Account* account) {
	guint n_tweets = 0U;
	JsonArray* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	GDateTime* now = NULL;
	GDateTime* _tmp3_;
	g_return_if_fail (json_array != NULL);
	g_return_if_fail (IS_TWEET_LIST_BOX (tweet_list));
	g_return_if_fail (IS_ACCOUNT (account));
	_tmp0_ = json_array;
	_tmp1_ = json_array_get_length (_tmp0_);
	n_tweets = _tmp1_;
	_tmp2_ = n_tweets;
	if (_tmp2_ == ((guint) 0)) {
		return;
	}
	_tmp3_ = g_date_time_new_now_local ();
	now = _tmp3_;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				guint _tmp6_;
				guint _tmp7_;
				CbTweet* tweet = NULL;
				CbTweet* _tmp8_;
				CbTweet* _tmp9_;
				JsonArray* _tmp10_;
				guint _tmp11_;
				JsonNode* _tmp12_;
				Account* _tmp13_;
				gint64 _tmp14_;
				GDateTime* _tmp15_;
				gboolean _tmp16_ = FALSE;
				gboolean _tmp17_ = FALSE;
				Account* _tmp18_;
				CbUserCounter* _tmp19_;
				Account* _tmp23_;
				CbUserCounter* _tmp24_;
				CbTweet* _tmp25_;
				CbTweet* _tmp26_;
				CbMiniTweet* _tmp27_;
				Account* _tmp32_;
				CbTweet* _tmp33_;
				gboolean _tmp34_;
				TweetListBox* _tmp36_;
				CbTweetModel* _tmp37_;
				CbTweet* _tmp38_;
				if (!_tmp4_) {
					guint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = i;
				_tmp7_ = n_tweets;
				if (!(_tmp6_ < _tmp7_)) {
					break;
				}
				_tmp8_ = cb_tweet_new ();
				tweet = _tmp8_;
				_tmp9_ = tweet;
				_tmp10_ = json_array;
				_tmp11_ = i;
				_tmp12_ = json_array_get_element (_tmp10_, _tmp11_);
				_tmp13_ = account;
				_tmp14_ = _tmp13_->id;
				_tmp15_ = now;
				cb_tweet_load_from_json (_tmp9_, _tmp12_, _tmp14_, _tmp15_);
				_tmp18_ = account;
				_tmp19_ = _tmp18_->user_counter;
				if (_tmp19_ == NULL) {
					_tmp17_ = TRUE;
				} else {
					TweetListBox* _tmp20_;
					_tmp20_ = tweet_list;
					_tmp17_ = _tmp20_ == NULL;
				}
				if (_tmp17_) {
					_tmp16_ = TRUE;
				} else {
					TweetListBox* _tmp21_;
					GtkWidget* _tmp22_;
					_tmp21_ = tweet_list;
					_tmp22_ = gtk_widget_get_toplevel (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_widget_get_type (), GtkWidget));
					_tmp16_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp22_, gtk_window_get_type ());
				}
				if (_tmp16_) {
					_g_object_unref0 (tweet);
					break;
				}
				_tmp23_ = account;
				_tmp24_ = _tmp23_->user_counter;
				_tmp25_ = tweet;
				cb_user_counter_id_seen (_tmp24_, &_tmp25_->source_tweet.author);
				_tmp26_ = tweet;
				_tmp27_ = _tmp26_->retweeted_tweet;
				if (_tmp27_ != NULL) {
					Account* _tmp28_;
					CbUserCounter* _tmp29_;
					CbTweet* _tmp30_;
					CbMiniTweet* _tmp31_;
					_tmp28_ = account;
					_tmp29_ = _tmp28_->user_counter;
					_tmp30_ = tweet;
					_tmp31_ = _tmp30_->retweeted_tweet;
					cb_user_counter_id_seen (_tmp29_, &(*_tmp31_).author);
				}
				_tmp32_ = account;
				_tmp33_ = tweet;
				_tmp34_ = account_filter_matches (_tmp32_, _tmp33_);
				if (_tmp34_) {
					CbTweet* _tmp35_;
					_tmp35_ = tweet;
					cb_tweet_set_flag (_tmp35_, (guint) CB_TWEET_STATE_HIDDEN_FILTERED);
				}
				_tmp36_ = tweet_list;
				_tmp37_ = _tmp36_->model;
				_tmp38_ = tweet;
				cb_tweet_model_add (_tmp37_, _tmp38_);
				_g_object_unref0 (tweet);
			}
		}
	}
	_g_date_time_unref0 (now);
}


void tweet_utils_handle_media_click (CbTweet* t, MainWindow* window, gint index, gdouble px, gdouble py) {
	MediaDialog* media_dialog = NULL;
	CbTweet* _tmp0_;
	gint _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	MediaDialog* _tmp4_;
	MainWindow* _tmp5_;
	g_return_if_fail (CB_IS_TWEET (t));
	g_return_if_fail (IS_MAIN_WINDOW (window));
	_tmp0_ = t;
	_tmp1_ = index;
	_tmp2_ = px;
	_tmp3_ = py;
	_tmp4_ = media_dialog_new (_tmp0_, _tmp1_, _tmp2_, _tmp3_);
	g_object_ref_sink (_tmp4_);
	media_dialog = _tmp4_;
	_tmp5_ = window;
	gtk_window_set_transient_for (G_TYPE_CHECK_INSTANCE_CAST (media_dialog, gtk_window_get_type (), GtkWindow), G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_window_get_type (), GtkWindow));
	gtk_window_set_modal (G_TYPE_CHECK_INSTANCE_CAST (media_dialog, gtk_window_get_type (), GtkWindow), TRUE);
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (media_dialog, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (media_dialog);
}


gboolean tweet_utils_is_link (const gchar* word) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_;
	gboolean _tmp8_;
	g_return_val_if_fail (word != NULL, FALSE);
	_tmp1_ = word;
	_tmp2_ = g_str_has_prefix (_tmp1_, "http://");
	if (_tmp2_) {
		const gchar* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		_tmp3_ = word;
		_tmp4_ = strlen (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp0_ = _tmp5_ > 7;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	_tmp7_ = word;
	_tmp8_ = g_str_has_prefix (_tmp7_, "https://");
	if (_tmp8_) {
		const gchar* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		_tmp9_ = word;
		_tmp10_ = strlen (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp6_ = _tmp11_ > 8;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		result = TRUE;
		return result;
	}
	{
		const gchar** tld_collection = NULL;
		gint tld_collection_length1 = 0;
		gint _tld_collection_size_ = 0;
		gint tld_it = 0;
		tld_collection = TWEET_UTILS_DOMAINS;
		tld_collection_length1 = G_N_ELEMENTS (TWEET_UTILS_DOMAINS);
		for (tld_it = 0; tld_it < G_N_ELEMENTS (TWEET_UTILS_DOMAINS); tld_it = tld_it + 1) {
			const gchar* tld = NULL;
			tld = tld_collection[tld_it];
			{
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				gboolean _tmp14_;
				_tmp12_ = word;
				_tmp13_ = tld;
				_tmp14_ = g_str_has_suffix (_tmp12_, _tmp13_);
				if (_tmp14_) {
					result = TRUE;
					return result;
				}
			}
		}
	}
	result = FALSE;
	return result;
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_;
	gunichar _tmp1_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	result = _tmp1_;
	return result;
}


static gboolean _vala_unichar_array_contains (gunichar * stack, int stack_length, gunichar needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (needle == stack[i]) {
			return TRUE;
		}
	}
	return FALSE;
}


static gint string_index_of_nth_char (const gchar* self, glong c) {
	gint result = 0;
	glong _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = c;
	_tmp1_ = g_utf8_offset_to_pointer (self, _tmp0_);
	result = (gint) (_tmp1_ - ((gchar*) self));
	return result;
}


gboolean tweet_utils_is_mention (const gchar* word, gint* at_pos) {
	gint _vala_at_pos = 0;
	gboolean result = FALSE;
	gint k = 0;
	gint _tmp4_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gunichar _tmp11_;
	g_return_val_if_fail (word != NULL, FALSE);
	k = 0;
	while (TRUE) {
		const gchar* _tmp0_;
		gint _tmp1_;
		gunichar _tmp2_;
		gint _tmp3_;
		_tmp0_ = word;
		_tmp1_ = k;
		_tmp2_ = string_get_char (_tmp0_, (glong) _tmp1_);
		if (!_vala_unichar_array_contains (TWEET_UTILS_non_mention_chars, G_N_ELEMENTS (TWEET_UTILS_non_mention_chars), _tmp2_)) {
			break;
		}
		_tmp3_ = k;
		k = _tmp3_ + 1;
	}
	_tmp4_ = k;
	_vala_at_pos = _tmp4_;
	_tmp7_ = word;
	_tmp8_ = word;
	_tmp9_ = k;
	_tmp10_ = string_index_of_nth_char (_tmp8_, (glong) _tmp9_);
	_tmp11_ = string_get_char (_tmp7_, (glong) _tmp10_);
	if (_tmp11_ == ((gunichar) '@')) {
		const gchar* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		_tmp12_ = word;
		_tmp13_ = strlen (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp6_ = _tmp14_ > 1;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		const gchar* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		_tmp15_ = word;
		_tmp16_ = strlen (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = k;
		_tmp5_ = (_tmp17_ - _tmp18_) > 1;
	} else {
		_tmp5_ = FALSE;
	}
	result = _tmp5_;
	if (at_pos) {
		*at_pos = _vala_at_pos;
	}
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


gboolean tweet_utils_is_hashtag (const gchar* word) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gchar _tmp2_;
	g_return_val_if_fail (word != NULL, FALSE);
	_tmp1_ = word;
	_tmp2_ = string_get (_tmp1_, (glong) 0);
	if (_tmp2_ == '#') {
		const gchar* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		_tmp3_ = word;
		_tmp4_ = strlen (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp0_ = _tmp5_ > 1;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static GtkTextIter* _gtk_text_iter_dup (GtkTextIter* self) {
	GtkTextIter* dup;
	dup = g_new0 (GtkTextIter, 1);
	memcpy (dup, self, sizeof (GtkTextIter));
	return dup;
}


static gpointer __gtk_text_iter_dup0 (gpointer self) {
	return self ? _gtk_text_iter_dup (self) : NULL;
}


void tweet_utils_highlight_link (GtkTextBuffer* buffer, GtkTextIter* word_start, GtkTextIter* word_end) {
	GtkTextIter* iter1 = NULL;
	GtkTextIter* _tmp0_;
	GtkTextIter* _tmp1_;
	GtkTextIter* iter2 = NULL;
	GtkTextIter* _tmp2_;
	GtkTextIter* _tmp3_;
	GtkTextIter* _tmp4_;
	GtkTextIter* _tmp5_;
	GtkTextBuffer* _tmp23_;
	GtkTextIter* _tmp24_;
	GtkTextIter* _tmp25_;
	GtkTextIter _tmp26_;
	GtkTextIter _tmp27_;
	GtkTextBuffer* _tmp28_;
	GtkTextIter* _tmp29_;
	GtkTextIter* _tmp30_;
	GtkTextIter _tmp31_;
	GtkTextIter _tmp32_;
	g_return_if_fail (GTK_IS_TEXT_BUFFER (buffer));
	_tmp0_ = word_start;
	_tmp1_ = __gtk_text_iter_dup0 (_tmp0_);
	iter1 = _tmp1_;
	_tmp2_ = word_start;
	_tmp3_ = __gtk_text_iter_dup0 (_tmp2_);
	iter2 = _tmp3_;
	_tmp4_ = iter1;
	gtk_text_iter_forward_char (_tmp4_);
	_tmp5_ = iter2;
	gtk_text_iter_forward_chars (_tmp5_, 2);
	while (TRUE) {
		GtkTextIter* _tmp6_;
		GtkTextIter* _tmp7_;
		GtkTextIter _tmp8_;
		gint _tmp9_;
		gchar* t = NULL;
		GtkTextBuffer* _tmp10_;
		GtkTextIter* _tmp11_;
		GtkTextIter* _tmp12_;
		GtkTextIter _tmp13_;
		GtkTextIter _tmp14_;
		gchar* _tmp15_;
		gunichar c = 0U;
		const gchar* _tmp16_;
		gunichar _tmp17_;
		gboolean _tmp18_ = FALSE;
		gunichar _tmp19_;
		GtkTextIter* _tmp21_;
		GtkTextIter* _tmp22_;
		_tmp6_ = iter1;
		_tmp7_ = word_end;
		_tmp8_ = *_tmp7_;
		_tmp9_ = gtk_text_iter_compare (_tmp6_, &_tmp8_);
		if (!(_tmp9_ < 0)) {
			break;
		}
		_tmp10_ = buffer;
		_tmp11_ = iter1;
		_tmp12_ = iter2;
		_tmp13_ = *_tmp11_;
		_tmp14_ = *_tmp12_;
		_tmp15_ = gtk_text_buffer_get_text (_tmp10_, &_tmp13_, &_tmp14_, FALSE);
		t = _tmp15_;
		_tmp16_ = t;
		_tmp17_ = string_get_char (_tmp16_, (glong) 0);
		c = _tmp17_;
		_tmp19_ = c;
		if (_tmp19_ == ((gunichar) '"')) {
			_tmp18_ = TRUE;
		} else {
			gunichar _tmp20_;
			_tmp20_ = c;
			_tmp18_ = _tmp20_ == 8220U;
		}
		if (_tmp18_) {
			_g_free0 (t);
			break;
		}
		_tmp21_ = iter1;
		gtk_text_iter_forward_char (_tmp21_);
		_tmp22_ = iter2;
		gtk_text_iter_forward_char (_tmp22_);
		_g_free0 (t);
	}
	_tmp23_ = buffer;
	_tmp24_ = word_start;
	_tmp25_ = iter1;
	_tmp26_ = *_tmp24_;
	_tmp27_ = *_tmp25_;
	gtk_text_buffer_apply_tag_by_name (_tmp23_, "link", &_tmp26_, &_tmp27_);
	_tmp28_ = buffer;
	_tmp29_ = word_start;
	_tmp30_ = iter1;
	_tmp31_ = *_tmp29_;
	_tmp32_ = *_tmp30_;
	gtk_text_buffer_apply_tag_by_name (_tmp28_, TWEET_UTILS_NO_SPELL_CHECK, &_tmp31_, &_tmp32_);
	_g_free0 (iter2);
	_g_free0 (iter1);
}


/** Invariant: The word passed to this function starts with a @ */
void tweet_utils_highlight_mention (GtkTextBuffer* buffer, GtkTextIter* word_start, GtkTextIter* word_end) {
	GtkTextIter* iter1 = NULL;
	GtkTextIter* _tmp0_;
	GtkTextIter* _tmp1_;
	GtkTextIter* iter2 = NULL;
	GtkTextIter* _tmp2_;
	GtkTextIter* _tmp3_;
	GtkTextIter* _tmp4_;
	GtkTextIter* _tmp5_;
	GtkTextBuffer* _tmp28_;
	GtkTextIter* _tmp29_;
	GtkTextIter* _tmp30_;
	GtkTextIter _tmp31_;
	GtkTextIter _tmp32_;
	GtkTextBuffer* _tmp33_;
	GtkTextIter* _tmp34_;
	GtkTextIter* _tmp35_;
	GtkTextIter _tmp36_;
	GtkTextIter _tmp37_;
	g_return_if_fail (GTK_IS_TEXT_BUFFER (buffer));
	_tmp0_ = word_start;
	_tmp1_ = __gtk_text_iter_dup0 (_tmp0_);
	iter1 = _tmp1_;
	_tmp2_ = word_start;
	_tmp3_ = __gtk_text_iter_dup0 (_tmp2_);
	iter2 = _tmp3_;
	_tmp4_ = iter1;
	gtk_text_iter_forward_char (_tmp4_);
	_tmp5_ = iter2;
	gtk_text_iter_forward_chars (_tmp5_, 2);
	while (TRUE) {
		GtkTextIter* _tmp6_;
		GtkTextIter* _tmp7_;
		GtkTextIter _tmp8_;
		gint _tmp9_;
		gchar* t = NULL;
		GtkTextBuffer* _tmp10_;
		GtkTextIter* _tmp11_;
		GtkTextIter* _tmp12_;
		GtkTextIter _tmp13_;
		GtkTextIter _tmp14_;
		gchar* _tmp15_;
		gunichar c = 0U;
		const gchar* _tmp16_;
		gunichar _tmp17_;
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
		gboolean _tmp20_ = FALSE;
		gunichar _tmp21_;
		gboolean _tmp22_;
		GtkTextIter* _tmp26_;
		GtkTextIter* _tmp27_;
		_tmp6_ = iter1;
		_tmp7_ = word_end;
		_tmp8_ = *_tmp7_;
		_tmp9_ = gtk_text_iter_compare (_tmp6_, &_tmp8_);
		if (!(_tmp9_ < 0)) {
			break;
		}
		_tmp10_ = buffer;
		_tmp11_ = iter1;
		_tmp12_ = iter2;
		_tmp13_ = *_tmp11_;
		_tmp14_ = *_tmp12_;
		_tmp15_ = gtk_text_buffer_get_text (_tmp10_, &_tmp13_, &_tmp14_, FALSE);
		t = _tmp15_;
		_tmp16_ = t;
		_tmp17_ = string_get_char (_tmp16_, (glong) 0);
		c = _tmp17_;
		_tmp21_ = c;
		_tmp22_ = g_unichar_ispunct (_tmp21_);
		if (_tmp22_) {
			gunichar _tmp23_;
			_tmp23_ = c;
			_tmp20_ = _tmp23_ != ((gunichar) '_');
		} else {
			_tmp20_ = FALSE;
		}
		if (_tmp20_) {
			_tmp19_ = TRUE;
		} else {
			gunichar _tmp24_;
			_tmp24_ = c;
			_tmp19_ = _tmp24_ == ((gunichar) '"');
		}
		if (_tmp19_) {
			_tmp18_ = TRUE;
		} else {
			gunichar _tmp25_;
			_tmp25_ = c;
			_tmp18_ = _tmp25_ == 8220U;
		}
		if (_tmp18_) {
			_g_free0 (t);
			break;
		}
		_tmp26_ = iter1;
		gtk_text_iter_forward_char (_tmp26_);
		_tmp27_ = iter2;
		gtk_text_iter_forward_char (_tmp27_);
		_g_free0 (t);
	}
	_tmp28_ = buffer;
	_tmp29_ = word_start;
	_tmp30_ = iter1;
	_tmp31_ = *_tmp29_;
	_tmp32_ = *_tmp30_;
	gtk_text_buffer_apply_tag_by_name (_tmp28_, "mention", &_tmp31_, &_tmp32_);
	_tmp33_ = buffer;
	_tmp34_ = word_start;
	_tmp35_ = iter1;
	_tmp36_ = *_tmp34_;
	_tmp37_ = *_tmp35_;
	gtk_text_buffer_apply_tag_by_name (_tmp33_, TWEET_UTILS_NO_SPELL_CHECK, &_tmp36_, &_tmp37_);
	_g_free0 (iter2);
	_g_free0 (iter1);
}


/** Invariant: the word passed to this function starts with a # */
void tweet_utils_highlight_hashtag (GtkTextBuffer* buffer, GtkTextIter* word_start, GtkTextIter* word_end) {
	GtkTextIter* iter1 = NULL;
	GtkTextIter* _tmp0_;
	GtkTextIter* _tmp1_;
	GtkTextIter* iter2 = NULL;
	GtkTextIter* _tmp2_;
	GtkTextIter* _tmp3_;
	GtkTextIter* _tmp4_;
	GtkTextIter* _tmp5_;
	GtkTextBuffer* _tmp26_;
	GtkTextIter* _tmp27_;
	GtkTextIter* _tmp28_;
	GtkTextIter _tmp29_;
	GtkTextIter _tmp30_;
	GtkTextBuffer* _tmp31_;
	GtkTextIter* _tmp32_;
	GtkTextIter* _tmp33_;
	GtkTextIter _tmp34_;
	GtkTextIter _tmp35_;
	g_return_if_fail (GTK_IS_TEXT_BUFFER (buffer));
	_tmp0_ = word_start;
	_tmp1_ = __gtk_text_iter_dup0 (_tmp0_);
	iter1 = _tmp1_;
	_tmp2_ = word_start;
	_tmp3_ = __gtk_text_iter_dup0 (_tmp2_);
	iter2 = _tmp3_;
	_tmp4_ = iter1;
	gtk_text_iter_forward_char (_tmp4_);
	_tmp5_ = iter2;
	gtk_text_iter_forward_chars (_tmp5_, 2);
	while (TRUE) {
		GtkTextIter* _tmp6_;
		GtkTextIter* _tmp7_;
		GtkTextIter _tmp8_;
		gint _tmp9_;
		gchar* t = NULL;
		GtkTextBuffer* _tmp10_;
		GtkTextIter* _tmp11_;
		GtkTextIter* _tmp12_;
		GtkTextIter _tmp13_;
		GtkTextIter _tmp14_;
		gchar* _tmp15_;
		gunichar c = 0U;
		const gchar* _tmp16_;
		gunichar _tmp17_;
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
		gunichar _tmp20_;
		gboolean _tmp21_;
		GtkTextIter* _tmp24_;
		GtkTextIter* _tmp25_;
		_tmp6_ = iter1;
		_tmp7_ = word_end;
		_tmp8_ = *_tmp7_;
		_tmp9_ = gtk_text_iter_compare (_tmp6_, &_tmp8_);
		if (!(_tmp9_ < 0)) {
			break;
		}
		_tmp10_ = buffer;
		_tmp11_ = iter1;
		_tmp12_ = iter2;
		_tmp13_ = *_tmp11_;
		_tmp14_ = *_tmp12_;
		_tmp15_ = gtk_text_buffer_get_text (_tmp10_, &_tmp13_, &_tmp14_, FALSE);
		t = _tmp15_;
		_tmp16_ = t;
		_tmp17_ = string_get_char (_tmp16_, (glong) 0);
		c = _tmp17_;
		_tmp20_ = c;
		_tmp21_ = g_unichar_ispunct (_tmp20_);
		if (_tmp21_) {
			gunichar _tmp22_;
			_tmp22_ = c;
			_tmp19_ = _tmp22_ != ((gunichar) '_');
		} else {
			_tmp19_ = FALSE;
		}
		if (_tmp19_) {
			_tmp18_ = TRUE;
		} else {
			gunichar _tmp23_;
			_tmp23_ = c;
			_tmp18_ = _tmp23_ == 8221U;
		}
		if (_tmp18_) {
			_g_free0 (t);
			break;
		}
		_tmp24_ = iter1;
		gtk_text_iter_forward_char (_tmp24_);
		_tmp25_ = iter2;
		gtk_text_iter_forward_char (_tmp25_);
		_g_free0 (t);
	}
	_tmp26_ = buffer;
	_tmp27_ = word_start;
	_tmp28_ = iter1;
	_tmp29_ = *_tmp27_;
	_tmp30_ = *_tmp28_;
	gtk_text_buffer_apply_tag_by_name (_tmp26_, "hashtag", &_tmp29_, &_tmp30_);
	_tmp31_ = buffer;
	_tmp32_ = word_start;
	_tmp33_ = iter1;
	_tmp34_ = *_tmp32_;
	_tmp35_ = *_tmp33_;
	gtk_text_buffer_apply_tag_by_name (_tmp31_, TWEET_UTILS_NO_SPELL_CHECK, &_tmp34_, &_tmp35_);
	_g_free0 (iter2);
	_g_free0 (iter1);
}


void tweet_utils_maybe_highlight_snippet (GtkTextBuffer* buffer, GtkTextIter* word_start, GtkTextIter* word_end) {
	gchar* word = NULL;
	GtkTextBuffer* _tmp0_;
	GtkTextIter* _tmp1_;
	GtkTextIter* _tmp2_;
	GtkTextIter _tmp3_;
	GtkTextIter _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gchar* snippet = NULL;
	CbSnippetManager* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	g_return_if_fail (GTK_IS_TEXT_BUFFER (buffer));
	_tmp0_ = buffer;
	_tmp1_ = word_start;
	_tmp2_ = word_end;
	_tmp3_ = *_tmp1_;
	_tmp4_ = *_tmp2_;
	_tmp5_ = gtk_text_buffer_get_text (_tmp0_, &_tmp3_, &_tmp4_, FALSE);
	word = _tmp5_;
	_tmp6_ = word;
	_tmp7_ = strlen (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ == 0) {
		_g_free0 (word);
		return;
	}
	_tmp9_ = corebird_snippet_manager;
	_tmp10_ = word;
	_tmp11_ = cb_snippet_manager_get_snippet (_tmp9_, _tmp10_);
	_tmp12_ = g_strdup (_tmp11_);
	_g_free0 (snippet);
	snippet = _tmp12_;
	_tmp13_ = snippet;
	if (_tmp13_ != NULL) {
		GtkTextBuffer* _tmp14_;
		GtkTextIter* _tmp15_;
		GtkTextIter* _tmp16_;
		GtkTextIter _tmp17_;
		GtkTextIter _tmp18_;
		GtkTextBuffer* _tmp19_;
		GtkTextIter* _tmp20_;
		GtkTextIter* _tmp21_;
		GtkTextIter _tmp22_;
		GtkTextIter _tmp23_;
		_tmp14_ = buffer;
		_tmp15_ = word_start;
		_tmp16_ = word_end;
		_tmp17_ = *_tmp15_;
		_tmp18_ = *_tmp16_;
		gtk_text_buffer_apply_tag_by_name (_tmp14_, "snippet", &_tmp17_, &_tmp18_);
		_tmp19_ = buffer;
		_tmp20_ = word_start;
		_tmp21_ = word_end;
		_tmp22_ = *_tmp20_;
		_tmp23_ = *_tmp21_;
		gtk_text_buffer_apply_tag_by_name (_tmp19_, TWEET_UTILS_NO_SPELL_CHECK, &_tmp22_, &_tmp23_);
	}
	_g_free0 (snippet);
	_g_free0 (word);
}


void tweet_utils_annotate_text (GtkTextBuffer* buffer) {
	GtkTextIter* start_iter = NULL;
	GtkTextIter* cur_iter = NULL;
	GtkTextIter* word_start_iter = NULL;
	GtkTextIter* next_iter = NULL;
	GtkTextBuffer* _tmp0_;
	GtkTextIter _tmp1_ = {0};
	GtkTextIter _tmp2_;
	GtkTextIter* _tmp3_;
	GtkTextIter* _tmp4_;
	GtkTextIter* _tmp5_;
	GtkTextIter* _tmp6_;
	GtkTextIter* _tmp7_;
	g_return_if_fail (GTK_IS_TEXT_BUFFER (buffer));
	_tmp0_ = buffer;
	gtk_text_buffer_get_start_iter (_tmp0_, &_tmp1_);
	_g_free0 (start_iter);
	_tmp2_ = _tmp1_;
	_tmp3_ = __gtk_text_iter_dup0 (&_tmp2_);
	start_iter = _tmp3_;
	_tmp4_ = start_iter;
	_tmp5_ = __gtk_text_iter_dup0 (_tmp4_);
	_g_free0 (cur_iter);
	cur_iter = _tmp5_;
	_tmp6_ = cur_iter;
	_tmp7_ = __gtk_text_iter_dup0 (_tmp6_);
	_g_free0 (word_start_iter);
	word_start_iter = _tmp7_;
	while (TRUE) {
		GtkTextIter* _tmp8_;
		gunichar _tmp9_;
		gboolean _tmp10_;
		GtkTextIter* _tmp14_;
		GtkTextIter* _tmp15_;
		gboolean done = FALSE;
		GtkTextIter* _tmp16_;
		gboolean _tmp17_;
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_;
		gboolean word_end = FALSE;
		gboolean _tmp27_;
		gboolean _tmp55_;
		GtkTextIter* _tmp56_;
		GtkTextIter* _tmp57_;
		_tmp8_ = cur_iter;
		_tmp9_ = gtk_text_iter_get_char (_tmp8_);
		_tmp10_ = g_unichar_isspace (_tmp9_);
		if (_tmp10_) {
			GtkTextIter* _tmp11_;
			GtkTextIter* _tmp12_;
			GtkTextIter* _tmp13_;
			_tmp11_ = cur_iter;
			_tmp12_ = __gtk_text_iter_dup0 (_tmp11_);
			_g_free0 (word_start_iter);
			word_start_iter = _tmp12_;
			_tmp13_ = word_start_iter;
			gtk_text_iter_forward_char (_tmp13_);
		}
		_tmp14_ = cur_iter;
		_tmp15_ = __gtk_text_iter_dup0 (_tmp14_);
		_g_free0 (next_iter);
		next_iter = _tmp15_;
		_tmp16_ = next_iter;
		_tmp17_ = gtk_text_iter_forward_char (_tmp16_);
		done = !_tmp17_;
		_tmp19_ = done;
		if (_tmp19_) {
			_tmp18_ = TRUE;
		} else {
			gboolean _tmp20_ = FALSE;
			GtkTextIter* _tmp21_;
			gunichar _tmp22_;
			gboolean _tmp23_;
			_tmp21_ = next_iter;
			_tmp22_ = gtk_text_iter_get_char (_tmp21_);
			_tmp23_ = g_unichar_isspace (_tmp22_);
			if (_tmp23_) {
				GtkTextIter* _tmp24_;
				gunichar _tmp25_;
				gboolean _tmp26_;
				_tmp24_ = cur_iter;
				_tmp25_ = gtk_text_iter_get_char (_tmp24_);
				_tmp26_ = g_unichar_isspace (_tmp25_);
				_tmp20_ = !_tmp26_;
			} else {
				_tmp20_ = FALSE;
			}
			_tmp18_ = _tmp20_;
		}
		word_end = _tmp18_;
		_tmp27_ = word_end;
		if (_tmp27_) {
			gint k = 0;
			gchar* w = NULL;
			GtkTextBuffer* _tmp28_;
			GtkTextIter* _tmp29_;
			GtkTextIter* _tmp30_;
			GtkTextIter _tmp31_;
			GtkTextIter _tmp32_;
			gchar* _tmp33_;
			const gchar* _tmp34_;
			gboolean _tmp35_;
			_tmp28_ = buffer;
			_tmp29_ = word_start_iter;
			_tmp30_ = next_iter;
			_tmp31_ = *_tmp29_;
			_tmp32_ = *_tmp30_;
			_tmp33_ = gtk_text_buffer_get_text (_tmp28_, &_tmp31_, &_tmp32_, FALSE);
			w = _tmp33_;
			_tmp34_ = w;
			_tmp35_ = tweet_utils_is_link (_tmp34_);
			if (_tmp35_) {
				GtkTextBuffer* _tmp36_;
				GtkTextIter* _tmp37_;
				GtkTextIter* _tmp38_;
				_tmp36_ = buffer;
				_tmp37_ = word_start_iter;
				_tmp38_ = next_iter;
				tweet_utils_highlight_link (_tmp36_, _tmp37_, _tmp38_);
			} else {
				const gchar* _tmp39_;
				gint _tmp40_ = 0;
				gboolean _tmp41_;
				_tmp39_ = w;
				_tmp41_ = tweet_utils_is_mention (_tmp39_, &_tmp40_);
				k = _tmp40_;
				if (_tmp41_) {
					GtkTextIter* _tmp42_;
					gint _tmp43_;
					GtkTextBuffer* _tmp44_;
					GtkTextIter* _tmp45_;
					GtkTextIter* _tmp46_;
					_tmp42_ = word_start_iter;
					_tmp43_ = k;
					gtk_text_iter_forward_chars (_tmp42_, _tmp43_);
					_tmp44_ = buffer;
					_tmp45_ = word_start_iter;
					_tmp46_ = next_iter;
					tweet_utils_highlight_mention (_tmp44_, _tmp45_, _tmp46_);
				} else {
					const gchar* _tmp47_;
					gboolean _tmp48_;
					_tmp47_ = w;
					_tmp48_ = tweet_utils_is_hashtag (_tmp47_);
					if (_tmp48_) {
						GtkTextBuffer* _tmp49_;
						GtkTextIter* _tmp50_;
						GtkTextIter* _tmp51_;
						_tmp49_ = buffer;
						_tmp50_ = word_start_iter;
						_tmp51_ = next_iter;
						tweet_utils_highlight_hashtag (_tmp49_, _tmp50_, _tmp51_);
					} else {
						GtkTextBuffer* _tmp52_;
						GtkTextIter* _tmp53_;
						GtkTextIter* _tmp54_;
						_tmp52_ = buffer;
						_tmp53_ = word_start_iter;
						_tmp54_ = next_iter;
						tweet_utils_maybe_highlight_snippet (_tmp52_, _tmp53_, _tmp54_);
					}
				}
			}
			_g_free0 (w);
		}
		_tmp55_ = done;
		if (_tmp55_) {
			break;
		}
		_tmp56_ = next_iter;
		_tmp57_ = __gtk_text_iter_dup0 (_tmp56_);
		_g_free0 (cur_iter);
		cur_iter = _tmp57_;
	}
	_g_free0 (next_iter);
	_g_free0 (word_start_iter);
	_g_free0 (cur_iter);
	_g_free0 (start_iter);
}


void tweet_utils_sort_entities (CbTextEntity** entities, int* entities_length1) {
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				CbTextEntity* _tmp3_;
				gint _tmp3__length1;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = *entities;
				_tmp3__length1 = *entities_length1;
				if (!(_tmp2_ < _tmp3__length1)) {
					break;
				}
				{
					gint k = 0;
					k = 0;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							gint _tmp6_;
							CbTextEntity* _tmp7_;
							gint _tmp7__length1;
							CbTextEntity* _tmp8_;
							gint _tmp8__length1;
							gint _tmp9_;
							CbTextEntity _tmp10_;
							guint _tmp11_;
							CbTextEntity* _tmp12_;
							gint _tmp12__length1;
							gint _tmp13_;
							CbTextEntity _tmp14_;
							guint _tmp15_;
							if (!_tmp4_) {
								gint _tmp5_;
								_tmp5_ = k;
								k = _tmp5_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp6_ = k;
							_tmp7_ = *entities;
							_tmp7__length1 = *entities_length1;
							if (!(_tmp6_ < _tmp7__length1)) {
								break;
							}
							_tmp8_ = *entities;
							_tmp8__length1 = *entities_length1;
							_tmp9_ = i;
							_tmp10_ = _tmp8_[_tmp9_];
							_tmp11_ = _tmp10_.from;
							_tmp12_ = *entities;
							_tmp12__length1 = *entities_length1;
							_tmp13_ = k;
							_tmp14_ = _tmp12_[_tmp13_];
							_tmp15_ = _tmp14_.from;
							if (_tmp11_ < _tmp15_) {
								CbTextEntity c = {0};
								CbTextEntity* _tmp16_;
								gint _tmp16__length1;
								gint _tmp17_;
								CbTextEntity _tmp18_;
								CbTextEntity _tmp19_ = {0};
								CbTextEntity* _tmp20_;
								gint _tmp20__length1;
								gint _tmp21_;
								CbTextEntity* _tmp22_;
								gint _tmp22__length1;
								gint _tmp23_;
								CbTextEntity _tmp24_;
								CbTextEntity _tmp25_ = {0};
								CbTextEntity _tmp26_;
								CbTextEntity* _tmp27_;
								gint _tmp27__length1;
								gint _tmp28_;
								CbTextEntity _tmp29_;
								CbTextEntity _tmp30_ = {0};
								CbTextEntity _tmp31_;
								_tmp16_ = *entities;
								_tmp16__length1 = *entities_length1;
								_tmp17_ = i;
								_tmp18_ = _tmp16_[_tmp17_];
								cb_text_entity_copy (&_tmp18_, &_tmp19_);
								c = _tmp19_;
								_tmp20_ = *entities;
								_tmp20__length1 = *entities_length1;
								_tmp21_ = i;
								_tmp22_ = *entities;
								_tmp22__length1 = *entities_length1;
								_tmp23_ = k;
								_tmp24_ = _tmp22_[_tmp23_];
								cb_text_entity_copy (&_tmp24_, &_tmp25_);
								cb_text_entity_free (&_tmp20_[_tmp21_]);
								_tmp20_[_tmp21_] = _tmp25_;
								_tmp26_ = _tmp20_[_tmp21_];
								_tmp27_ = *entities;
								_tmp27__length1 = *entities_length1;
								_tmp28_ = k;
								_tmp29_ = c;
								cb_text_entity_copy (&_tmp29_, &_tmp30_);
								cb_text_entity_free (&_tmp27_[_tmp28_]);
								_tmp27_[_tmp28_] = _tmp30_;
								_tmp31_ = _tmp27_[_tmp28_];
								cb_text_entity_free (&c);
							}
						}
					}
				}
			}
		}
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



