/* TweetInfoPage.c generated by valac 0.38.7, the Vala compiler
 * generated from TweetInfoPage.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "CbBundle.h"
#include <stdlib.h>
#include <string.h>
#include "CbMessageReceiver.h"
#include "CbTweet.h"
#include <gio/gio.h>
#include "CbDeltaUpdater.h"
#include "CbTweetModel.h"
#include "CbMedia.h"
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include "CbTwitterItem.h"
#include <cairo.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include "rest/rest-proxy-call.h"
#include "rest/oauth-proxy.h"
#include "CbUserStream.h"
#include "CbUserCounter.h"
#include "CbFilter.h"
#include "rest/rest-proxy.h"
#include "CbUtils.h"
#include <json-glib/json-glib.h>
#include <glib/gi18n-lib.h>
#include "CbTypes.h"


#define TYPE_SCROLL_WIDGET (scroll_widget_get_type ())
#define SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCROLL_WIDGET, ScrollWidget))
#define SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCROLL_WIDGET, ScrollWidgetClass))
#define IS_SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCROLL_WIDGET))
#define IS_SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCROLL_WIDGET))
#define SCROLL_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCROLL_WIDGET, ScrollWidgetClass))

typedef struct _ScrollWidget ScrollWidget;
typedef struct _ScrollWidgetClass ScrollWidgetClass;
typedef struct _ScrollWidgetPrivate ScrollWidgetPrivate;

#define TYPE_IPAGE (ipage_get_type ())
#define IPAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IPAGE, IPage))
#define IS_IPAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IPAGE))
#define IPAGE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IPAGE, IPageIface))

typedef struct _IPage IPage;
typedef struct _IPageIface IPageIface;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_TWEET_INFO_PAGE (tweet_info_page_get_type ())
#define TWEET_INFO_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_INFO_PAGE, TweetInfoPage))
#define TWEET_INFO_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_INFO_PAGE, TweetInfoPageClass))
#define IS_TWEET_INFO_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_INFO_PAGE))
#define IS_TWEET_INFO_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_INFO_PAGE))
#define TWEET_INFO_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_INFO_PAGE, TweetInfoPageClass))

typedef struct _TweetInfoPage TweetInfoPage;
typedef struct _TweetInfoPageClass TweetInfoPageClass;
typedef struct _TweetInfoPagePrivate TweetInfoPagePrivate;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_MULTI_MEDIA_WIDGET (multi_media_widget_get_type ())
#define MULTI_MEDIA_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MULTI_MEDIA_WIDGET, MultiMediaWidget))
#define MULTI_MEDIA_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MULTI_MEDIA_WIDGET, MultiMediaWidgetClass))
#define IS_MULTI_MEDIA_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MULTI_MEDIA_WIDGET))
#define IS_MULTI_MEDIA_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MULTI_MEDIA_WIDGET))
#define MULTI_MEDIA_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MULTI_MEDIA_WIDGET, MultiMediaWidgetClass))

typedef struct _MultiMediaWidget MultiMediaWidget;
typedef struct _MultiMediaWidgetClass MultiMediaWidgetClass;

#define TYPE_TEXT_BUTTON (text_button_get_type ())
#define TEXT_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEXT_BUTTON, TextButton))
#define TEXT_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEXT_BUTTON, TextButtonClass))
#define IS_TEXT_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEXT_BUTTON))
#define IS_TEXT_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEXT_BUTTON))
#define TEXT_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEXT_BUTTON, TextButtonClass))

typedef struct _TextButton TextButton;
typedef struct _TextButtonClass TextButtonClass;

#define TYPE_AVATAR_WIDGET (avatar_widget_get_type ())
#define AVATAR_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AVATAR_WIDGET, AvatarWidget))
#define AVATAR_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AVATAR_WIDGET, AvatarWidgetClass))
#define IS_AVATAR_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AVATAR_WIDGET))
#define IS_AVATAR_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AVATAR_WIDGET))
#define AVATAR_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AVATAR_WIDGET, AvatarWidgetClass))

typedef struct _AvatarWidget AvatarWidget;
typedef struct _AvatarWidgetClass AvatarWidgetClass;

#define TYPE_TWEET_LIST_BOX (tweet_list_box_get_type ())
#define TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_BOX, TweetListBox))
#define TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_BOX, TweetListBoxClass))
#define IS_TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_BOX))
#define IS_TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_BOX))
#define TWEET_LIST_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_BOX, TweetListBoxClass))

typedef struct _TweetListBox TweetListBox;
typedef struct _TweetListBoxClass TweetListBoxClass;

#define TYPE_MAX_SIZE_CONTAINER (max_size_container_get_type ())
#define MAX_SIZE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAX_SIZE_CONTAINER, MaxSizeContainer))
#define MAX_SIZE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAX_SIZE_CONTAINER, MaxSizeContainerClass))
#define IS_MAX_SIZE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAX_SIZE_CONTAINER))
#define IS_MAX_SIZE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAX_SIZE_CONTAINER))
#define MAX_SIZE_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAX_SIZE_CONTAINER, MaxSizeContainerClass))

typedef struct _MaxSizeContainer MaxSizeContainer;
typedef struct _MaxSizeContainerClass MaxSizeContainerClass;

#define TYPE_REPLY_INDICATOR (reply_indicator_get_type ())
#define REPLY_INDICATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REPLY_INDICATOR, ReplyIndicator))
#define REPLY_INDICATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REPLY_INDICATOR, ReplyIndicatorClass))
#define IS_REPLY_INDICATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REPLY_INDICATOR))
#define IS_REPLY_INDICATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REPLY_INDICATOR))
#define REPLY_INDICATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REPLY_INDICATOR, ReplyIndicatorClass))

typedef struct _ReplyIndicator ReplyIndicator;
typedef struct _ReplyIndicatorClass ReplyIndicatorClass;
enum  {
	TWEET_INFO_PAGE_0_PROPERTY,
	TWEET_INFO_PAGE_UNREAD_COUNT_PROPERTY,
	TWEET_INFO_PAGE_ID_PROPERTY,
	TWEET_INFO_PAGE_WINDOW_PROPERTY,
	TWEET_INFO_PAGE_NUM_PROPERTIES
};
static GParamSpec* tweet_info_page_properties[TWEET_INFO_PAGE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _TweetListBoxPrivate TweetListBoxPrivate;

#define TYPE_TWEET_LIST_ENTRY (tweet_list_entry_get_type ())
#define TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntry))
#define TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))
#define IS_TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_ENTRY))
#define IS_TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_ENTRY))
#define TWEET_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))

typedef struct _TweetListEntry TweetListEntry;
typedef struct _TweetListEntryClass TweetListEntryClass;
typedef struct _TweetListEntryPrivate TweetListEntryPrivate;
typedef struct _MainWindowPrivate MainWindowPrivate;

#define TYPE_MAIN_WIDGET (main_widget_get_type ())
#define MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WIDGET, MainWidget))
#define MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WIDGET, MainWidgetClass))
#define IS_MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WIDGET))
#define IS_MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WIDGET))
#define MAIN_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WIDGET, MainWidgetClass))

typedef struct _MainWidget MainWidget;
typedef struct _MainWidgetClass MainWidgetClass;

#define TYPE_PAGE (page_get_type ())

#define TYPE_MEDIA_VISIBILITY (media_visibility_get_type ())

#define TYPE_TWITTER (twitter_get_type ())
#define TWITTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWITTER, Twitter))
#define TWITTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWITTER, TwitterClass))
#define IS_TWITTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWITTER))
#define IS_TWITTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWITTER))
#define TWITTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWITTER, TwitterClass))

typedef struct _Twitter Twitter;
typedef struct _TwitterClass TwitterClass;
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
typedef struct _Block28Data Block28Data;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_COMPOSE_TWEET_WINDOW (compose_tweet_window_get_type ())
#define COMPOSE_TWEET_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindow))
#define COMPOSE_TWEET_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindowClass))
#define IS_COMPOSE_TWEET_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPOSE_TWEET_WINDOW))
#define IS_COMPOSE_TWEET_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPOSE_TWEET_WINDOW))
#define COMPOSE_TWEET_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindowClass))

typedef struct _ComposeTweetWindow ComposeTweetWindow;
typedef struct _ComposeTweetWindowClass ComposeTweetWindowClass;

#define COMPOSE_TWEET_WINDOW_TYPE_MODE (compose_tweet_window_mode_get_type ())
typedef struct _Block29Data Block29Data;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _AccountPrivate AccountPrivate;

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define TYPE_NOTIFICATION_MANAGER (notification_manager_get_type ())
#define NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManager))
#define NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))
#define IS_NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATION_MANAGER))
#define IS_NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATION_MANAGER))
#define NOTIFICATION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))

typedef struct _NotificationManager NotificationManager;
typedef struct _NotificationManagerClass NotificationManagerClass;
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
typedef struct _Block30Data Block30Data;
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
typedef struct _Block31Data Block31Data;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _Block32Data Block32Data;

struct _ScrollWidget {
	GtkScrolledWindow parent_instance;
	ScrollWidgetPrivate * priv;
};

struct _ScrollWidgetClass {
	GtkScrolledWindowClass parent_class;
};

struct _IPageIface {
	GTypeInterface parent_iface;
	void (*on_join) (IPage* self, gint page_id, CbBundle* args);
	void (*on_leave) (IPage* self);
	void (*create_radio_button) (IPage* self, GtkRadioButton* group);
	GtkRadioButton* (*get_radio_button) (IPage* self);
	gchar* (*get_title) (IPage* self);
	gboolean (*handles_double_open) (IPage* self);
	void (*double_open) (IPage* self);
	gint (*get_id) (IPage* self);
	void (*set_id) (IPage* self, gint value);
	void (*set_window) (IPage* self, MainWindow* value);
};

struct _TweetInfoPage {
	ScrollWidget parent_instance;
	TweetInfoPagePrivate * priv;
	Account* account;
};

struct _TweetInfoPageClass {
	ScrollWidgetClass parent_class;
};

struct _TweetInfoPagePrivate {
	gint _id;
	gint64 tweet_id;
	gchar* screen_name;
	gboolean values_set;
	CbTweet* tweet;
	GSimpleActionGroup* actions;
	MainWindow* main_window;
	GCancellable* cancellable;
	GtkGrid* grid;
	GtkBox* main_box;
	MultiMediaWidget* mm_widget;
	GtkLabel* text_label;
	TextButton* name_button;
	GtkLabel* screen_name_label;
	AvatarWidget* avatar_image;
	GtkLabel* rt_label;
	GtkLabel* fav_label;
	TweetListBox* bottom_list_box;
	TweetListBox* top_list_box;
	GtkToggleButton* favorite_button;
	GtkToggleButton* retweet_button;
	GtkLabel* time_label;
	GtkLabel* source_label;
	MaxSizeContainer* max_size_container;
	ReplyIndicator* reply_indicator;
	GtkStack* main_stack;
	GtkLabel* error_label;
	GtkLabel* reply_label;
	GtkBox* reply_box;
};

struct _TweetListBox {
	GtkListBox parent_instance;
	TweetListBoxPrivate * priv;
	CbDeltaUpdater* delta_updater;
	Account* account;
	CbTweetModel* model;
};

struct _TweetListBoxClass {
	GtkListBoxClass parent_class;
};

struct _TweetListEntry {
	GtkListBoxRow parent_instance;
	TweetListEntryPrivate * priv;
	CbTweet* tweet;
};

struct _TweetListEntryClass {
	GtkListBoxRowClass parent_class;
};

struct _MainWindow {
	GtkApplicationWindow parent_instance;
	MainWindowPrivate * priv;
	GtkButton* back_button;
	GtkToggleButton* compose_tweet_button;
	MainWidget* main_widget;
	Account* account;
};

struct _MainWindowClass {
	GtkApplicationWindowClass parent_class;
};

typedef enum  {
	PAGE_STREAM = 0,
	PAGE_MENTIONS,
	PAGE_FAVORITES,
	PAGE_DM_THREADS,
	PAGE_LISTS,
	PAGE_FILTERS,
	PAGE_SEARCH,
	PAGE_PROFILE,
	PAGE_TWEET_INFO,
	PAGE_DM,
	PAGE_LIST_STATUSES,
	PAGE_PREVIOUS = 1024,
	PAGE_NEXT = 2048
} Page;

typedef enum  {
	MEDIA_VISIBILITY_SHOW = 1,
	MEDIA_VISIBILITY_HIDE = 2,
	MEDIA_VISIBILITY_HIDE_IN_TIMELINES = 3
} MediaVisibility;

struct _Block28Data {
	int _ref_count_;
	TweetInfoPage* self;
	gint scale;
};

typedef enum  {
	COMPOSE_TWEET_WINDOW_MODE_NORMAL,
	COMPOSE_TWEET_WINDOW_MODE_REPLY,
	COMPOSE_TWEET_WINDOW_MODE_QUOTE
} ComposeTweetWindowMode;

struct _Block29Data {
	int _ref_count_;
	TweetInfoPage* self;
	GDateTime* now;
	gboolean existing;
};

struct _Account {
	GObject parent_instance;
	AccountPrivate * priv;
	gint64 id;
	SqlDatabase* db;
	gchar* screen_name;
	gchar* name;
	gchar* avatar_url;
	gchar* banner_url;
	gchar* website;
	gchar* description;
	OAuthProxy* proxy;
	CbUserStream* user_stream;
	CbUserCounter* user_counter;
	NotificationManager* notifications;
	gint64* friends;
	gint friends_length1;
	gint64* blocked;
	gint blocked_length1;
	gint64* muted;
	gint muted_length1;
	gint64* disabled_rts;
	gint disabled_rts_length1;
	GPtrArray* filters;
};

struct _AccountClass {
	GObjectClass parent_class;
};

struct _Block30Data {
	int _ref_count_;
	Block29Data * _data29_;
	gint64 previous_tweet_id;
	gint n_replies;
};

struct _Block31Data {
	int _ref_count_;
	TweetInfoPage* self;
	RestProxyCall* call;
};

struct _Block32Data {
	int _ref_count_;
	TweetInfoPage* self;
	gboolean favoriting;
};


static gpointer tweet_info_page_parent_class = NULL;
extern cairo_surface_t* twitter_no_avatar;
static IPageIface * tweet_info_page_ipage_parent_iface = NULL;
static CbMessageReceiverInterface * tweet_info_page_cb_message_receiver_parent_iface = NULL;

GType scroll_widget_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
GType ipage_get_type (void) G_GNUC_CONST;
GType tweet_info_page_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
GType multi_media_widget_get_type (void) G_GNUC_CONST;
GType text_button_get_type (void) G_GNUC_CONST;
GType avatar_widget_get_type (void) G_GNUC_CONST;
GType tweet_list_box_get_type (void) G_GNUC_CONST;
GType max_size_container_get_type (void) G_GNUC_CONST;
GType reply_indicator_get_type (void) G_GNUC_CONST;
#define TWEET_INFO_PAGE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TWEET_INFO_PAGE, TweetInfoPagePrivate))
#define TWEET_INFO_PAGE_KEY_MODE 0
#define TWEET_INFO_PAGE_KEY_TWEET 1
#define TWEET_INFO_PAGE_KEY_EXISTING 2
#define TWEET_INFO_PAGE_KEY_TWEET_ID 3
#define TWEET_INFO_PAGE_KEY_SCREEN_NAME 4
#define TWEET_INFO_PAGE_BY_INSTANCE 1
#define TWEET_INFO_PAGE_BY_ID 2
static void tweet_info_page_quote_activated (TweetInfoPage* self);
static void _tweet_info_page_quote_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void tweet_info_page_reply_activated (TweetInfoPage* self);
static void _tweet_info_page_reply_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void tweet_info_page_favorite_activated (TweetInfoPage* self);
static void _tweet_info_page_favorite_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void tweet_info_page_delete_activated (TweetInfoPage* self);
static void _tweet_info_page_delete_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
TweetInfoPage* tweet_info_page_new (gint id, Account* account);
TweetInfoPage* tweet_info_page_construct (GType object_type, gint id, Account* account);
ScrollWidget* scroll_widget_new (void);
ScrollWidget* scroll_widget_construct (GType object_type);
void ipage_set_id (IPage* self, gint value);
static void __lambda54_ (TweetInfoPage* self, CbMedia* m, gint i);
void tweet_utils_handle_media_click (CbTweet* t, MainWindow* window, gint index, gdouble px, gdouble py);
static void ___lambda54__multi_media_widget_media_clicked (MultiMediaWidget* _sender, CbMedia* m, gint index, gdouble px, gdouble py, gpointer self);
static gboolean __lambda55_ (TweetInfoPage* self, GdkEventScroll* evt);
gboolean reply_indicator_get_replies_available (ReplyIndicator* self);
gint max_size_container_get_max_size (MaxSizeContainer* self);
void max_size_container_set_max_size (MaxSizeContainer* self, gint value);
static gboolean ___lambda55__gtk_widget_scroll_event (GtkWidget* _sender, GdkEventScroll* event, gpointer self);
static void __lambda56_ (TweetInfoPage* self, GtkListBoxRow* row);
GType tweet_list_entry_get_type (void) G_GNUC_CONST;
GType main_widget_get_type (void) G_GNUC_CONST;
void main_widget_switch_page (MainWidget* self, gint page_id, CbBundle* args);
GType page_get_type (void) G_GNUC_CONST;
static void ___lambda56__gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self);
static void __lambda57_ (TweetInfoPage* self, GtkListBoxRow* row);
static void ___lambda57__gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self);
GSettings* settings_get (void);
static void tweet_info_page_media_visiblity_changed_cb (TweetInfoPage* self);
static void _tweet_info_page_media_visiblity_changed_cb_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
GType media_visibility_get_type (void) G_GNUC_CONST;
MediaVisibility settings_get_media_visiblity (void);
static void tweet_info_page_real_on_join (IPage* base, gint page_id, CbBundle* args);
void reply_indicator_set_replies_available (ReplyIndicator* self, gboolean value);
GType twitter_get_type (void) G_GNUC_CONST;
Twitter* twitter_get (void);
gboolean twitter_has_avatar (Twitter* self, gint64 user_id);
cairo_surface_t* twitter_get_cached_avatar (Twitter* self, gint64 user_id);
void avatar_widget_set_surface (AvatarWidget* self, cairo_surface_t* value);
static void tweet_info_page_rearrange_tweets (TweetInfoPage* self, gint64 new_id);
static void tweet_info_page_set_tweet_data (TweetInfoPage* self, CbTweet* tweet, const gchar* with);
static void tweet_info_page_query_tweet_info (TweetInfoPage* self, gboolean existing);
static void tweet_info_page_load_user_avatar (TweetInfoPage* self, const gchar* url);
static Block28Data* block28_data_ref (Block28Data* _data28_);
static void block28_data_unref (void * _userdata_);
void tweet_utils_download_avatar (const gchar* avatar_url, gint size, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GdkPixbuf* tweet_utils_download_avatar_finish (GAsyncResult* _res_, GError** error);
static void __lambda60_ (Block28Data* _data28_, GObject* obj, GAsyncResult* res);
cairo_surface_t* scale_surface (cairo_surface_t* input, gint output_width, gint output_height);
static void ___lambda60__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void tweet_info_page_real_on_leave (IPage* base);
static void tweet_info_page_favorite_button_toggled_cb (TweetInfoPage* self);
static void tweet_info_page_update_rt_fav_labels (TweetInfoPage* self);
void tweet_utils_set_favorite_status (Account* account, CbTweet* tweet, gboolean status, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tweet_utils_set_favorite_status_finish (GAsyncResult* _res_);
static void __lambda65_ (TweetInfoPage* self);
static void ___lambda65__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _tweet_info_page_favorite_button_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void tweet_info_page_retweet_button_toggled_cb (TweetInfoPage* self);
void tweet_utils_set_retweet_status (Account* account, CbTweet* tweet, gboolean status, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tweet_utils_set_retweet_status_finish (GAsyncResult* _res_);
static void __lambda67_ (TweetInfoPage* self);
static void ___lambda67__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _tweet_info_page_retweet_button_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void tweet_info_page_reply_button_clicked_cb (TweetInfoPage* self);
GType compose_tweet_window_get_type (void) G_GNUC_CONST;
GType compose_tweet_window_mode_get_type (void) G_GNUC_CONST;
ComposeTweetWindow* compose_tweet_window_new (MainWindow* parent, Account* acc, CbTweet* reply_to, ComposeTweetWindowMode mode);
ComposeTweetWindow* compose_tweet_window_construct (GType object_type, MainWindow* parent, Account* acc, CbTweet* reply_to, ComposeTweetWindowMode mode);
static void _tweet_info_page_reply_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static gboolean tweet_info_page_link_activated_cb (TweetInfoPage* self, const gchar* uri);
gboolean tweet_utils_activate_link (const gchar* uri, MainWindow* window);
static gboolean _tweet_info_page_link_activated_cb_gtk_label_activate_link (GtkLabel* _sender, const gchar* uri, gpointer self);
static void tweet_info_page_name_button_clicked_cb (TweetInfoPage* self);
#define PROFILE_PAGE_KEY_USER_ID 1
#define PROFILE_PAGE_KEY_SCREEN_NAME 0
static void _tweet_info_page_name_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static Block29Data* block29_data_ref (Block29Data* _data29_);
static void block29_data_unref (void * _userdata_);
GType sql_database_get_type (void) G_GNUC_CONST;
GType notification_manager_get_type (void) G_GNUC_CONST;
static void __lambda61_ (Block29Data* _data29_, GObject* __, GAsyncResult* res);
static void _vala_JsonNode_free (JsonNode* self);
static gchar* tweet_info_page_extract_source (TweetInfoPage* self, const gchar* source_str);
static void tweet_info_page_load_replied_to_tweet (TweetInfoPage* self, gint64 reply_id);
static void ___lambda61__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void __lambda63_ (Block29Data* _data29_, GObject* _, GAsyncResult* res);
static Block30Data* block30_data_ref (Block30Data* _data30_);
static void block30_data_unref (void * _userdata_);
static void __lambda64_ (Block30Data* _data30_, JsonArray* arr, guint index, JsonNode* node);
static void ___lambda64__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
static void ___lambda63__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static Block31Data* block31_data_ref (Block31Data* _data31_);
static void block31_data_unref (void * _userdata_);
static void __lambda62_ (Block31Data* _data31_, GObject* obj, GAsyncResult* res);
void utils_show_error_object (const gchar* json_data, const gchar* alternative, gint line, const gchar* file, GtkWindow* transient_for);
static void ___lambda62__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
void text_button_set_markup (TextButton* self, const gchar* text);
void avatar_widget_set_verified (AvatarWidget* self, gboolean value);
static void tweet_info_page_set_source_link (TweetInfoPage* self, gint64 id, const gchar* screen_name);
static CbUserIdentity* _vala_array_dup6 (CbUserIdentity* self, int length);
static void _vala_CbUserIdentity_array_free (CbUserIdentity * array, gint array_length);
void multi_media_widget_set_all_media (MultiMediaWidget* self, CbMedia** medias, int medias_length1);
static Block32Data* block32_data_ref (Block32Data* _data32_);
static void block32_data_unref (void * _userdata_);
static void __lambda51_ (Block32Data* _data32_);
static void ___lambda51__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
void main_widget_remove_current_page (MainWidget* self);
void tweet_utils_delete_tweet (Account* account, CbTweet* tweet, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tweet_utils_delete_tweet_finish (GAsyncResult* _res_);
static void __lambda53_ (TweetInfoPage* self);
static void ___lambda53__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static gchar* tweet_info_page_real_get_title (IPage* base);
static void tweet_info_page_real_create_radio_button (IPage* base, GtkRadioButton* group);
static GtkRadioButton* tweet_info_page_real_get_radio_button (IPage* base);
static void tweet_info_page_real_stream_message_received (CbMessageReceiver* base, CbStreamMessageType type, JsonNode* root);
gboolean utils_usable_json_value (JsonObject* node, const gchar* value_name);
gint main_window_get_cur_page_id (MainWindow* self);
gint ipage_get_id (IPage* self);
gint tweet_info_page_get_unread_count (TweetInfoPage* self);
static void tweet_info_page_finalize (GObject * obj);
static void _vala_tweet_info_page_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void ipage_set_window (IPage* self, MainWindow* value);
static void _vala_tweet_info_page_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

static const GActionEntry TWEET_INFO_PAGE_action_entries[4] = {{"quote", _tweet_info_page_quote_activated_gsimple_action_activate_callback}, {"reply", _tweet_info_page_reply_activated_gsimple_action_activate_callback}, {"favorite", _tweet_info_page_favorite_activated_gsimple_action_activate_callback}, {"delete", _tweet_info_page_delete_activated_gsimple_action_activate_callback}};

static void _tweet_info_page_quote_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	tweet_info_page_quote_activated ((TweetInfoPage*) self);
}


static void _tweet_info_page_reply_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	tweet_info_page_reply_activated ((TweetInfoPage*) self);
}


static void _tweet_info_page_favorite_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	tweet_info_page_favorite_activated ((TweetInfoPage*) self);
}


static void _tweet_info_page_delete_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	tweet_info_page_delete_activated ((TweetInfoPage*) self);
}


static void __lambda54_ (TweetInfoPage* self, CbMedia* m, gint i) {
	CbTweet* _tmp0_;
	MainWindow* _tmp1_;
	gint _tmp2_;
	g_return_if_fail (CB_IS_MEDIA (m));
	_tmp0_ = self->priv->tweet;
	_tmp1_ = self->priv->main_window;
	_tmp2_ = i;
	tweet_utils_handle_media_click (_tmp0_, _tmp1_, _tmp2_, 0.0, 0.0);
}


static void ___lambda54__multi_media_widget_media_clicked (MultiMediaWidget* _sender, CbMedia* m, gint index, gdouble px, gdouble py, gpointer self) {
	__lambda54_ ((TweetInfoPage*) self, m, index);
}


static gboolean __lambda55_ (TweetInfoPage* self, GdkEventScroll* evt) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GdkEventScroll* _tmp2_;
	gdouble _tmp3_;
	g_return_val_if_fail (evt != NULL, FALSE);
	_tmp2_ = evt;
	_tmp3_ = _tmp2_->delta_y;
	if (_tmp3_ < ((gdouble) 0)) {
		GtkAdjustment* _tmp4_;
		GtkAdjustment* _tmp5_;
		gdouble _tmp6_;
		gdouble _tmp7_;
		_tmp4_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
		_tmp5_ = _tmp4_;
		_tmp6_ = gtk_adjustment_get_value (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp1_ = _tmp7_ == ((gdouble) 0);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		ReplyIndicator* _tmp8_;
		gboolean _tmp9_;
		gboolean _tmp10_;
		_tmp8_ = self->priv->reply_indicator;
		_tmp9_ = reply_indicator_get_replies_available (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp0_ = _tmp10_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint inc = 0;
		GtkAdjustment* _tmp11_;
		GtkAdjustment* _tmp12_;
		gdouble _tmp13_;
		gdouble _tmp14_;
		GdkEventScroll* _tmp15_;
		gdouble _tmp16_;
		MaxSizeContainer* _tmp17_;
		MaxSizeContainer* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		_tmp11_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
		_tmp12_ = _tmp11_;
		_tmp13_ = gtk_adjustment_get_step_increment (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = evt;
		_tmp16_ = _tmp15_->delta_y;
		inc = (gint) (_tmp14_ * (-_tmp16_));
		_tmp17_ = self->priv->max_size_container;
		_tmp18_ = self->priv->max_size_container;
		_tmp19_ = max_size_container_get_max_size (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = inc;
		max_size_container_set_max_size (_tmp18_, _tmp20_ + _tmp21_);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean ___lambda55__gtk_widget_scroll_event (GtkWidget* _sender, GdkEventScroll* event, gpointer self) {
	gboolean result;
	result = __lambda55_ ((TweetInfoPage*) self, event);
	return result;
}


static void __lambda56_ (TweetInfoPage* self, GtkListBoxRow* row) {
	CbBundle* bundle = NULL;
	CbBundle* _tmp0_;
	GtkListBoxRow* _tmp1_;
	CbTweet* _tmp2_;
	MainWindow* _tmp3_;
	MainWidget* _tmp4_;
	g_return_if_fail (GTK_IS_LIST_BOX_ROW (row));
	_tmp0_ = cb_bundle_new ();
	bundle = _tmp0_;
	cb_bundle_put_int (bundle, TWEET_INFO_PAGE_KEY_MODE, TWEET_INFO_PAGE_BY_INSTANCE);
	_tmp1_ = row;
	_tmp2_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_TWEET_LIST_ENTRY, TweetListEntry)->tweet;
	cb_bundle_put_object (bundle, TWEET_INFO_PAGE_KEY_TWEET, G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, G_TYPE_OBJECT, GObject));
	cb_bundle_put_bool (bundle, TWEET_INFO_PAGE_KEY_EXISTING, TRUE);
	_tmp3_ = self->priv->main_window;
	_tmp4_ = _tmp3_->main_widget;
	main_widget_switch_page (_tmp4_, (gint) PAGE_TWEET_INFO, bundle);
	_g_object_unref0 (bundle);
}


static void ___lambda56__gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self) {
	__lambda56_ ((TweetInfoPage*) self, row);
}


static void __lambda57_ (TweetInfoPage* self, GtkListBoxRow* row) {
	CbBundle* bundle = NULL;
	CbBundle* _tmp0_;
	GtkListBoxRow* _tmp1_;
	CbTweet* _tmp2_;
	MainWindow* _tmp3_;
	MainWidget* _tmp4_;
	g_return_if_fail (GTK_IS_LIST_BOX_ROW (row));
	_tmp0_ = cb_bundle_new ();
	bundle = _tmp0_;
	cb_bundle_put_int (bundle, TWEET_INFO_PAGE_KEY_MODE, TWEET_INFO_PAGE_BY_INSTANCE);
	_tmp1_ = row;
	_tmp2_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_TWEET_LIST_ENTRY, TweetListEntry)->tweet;
	cb_bundle_put_object (bundle, TWEET_INFO_PAGE_KEY_TWEET, G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, G_TYPE_OBJECT, GObject));
	cb_bundle_put_bool (bundle, TWEET_INFO_PAGE_KEY_EXISTING, TRUE);
	_tmp3_ = self->priv->main_window;
	_tmp4_ = _tmp3_->main_widget;
	main_widget_switch_page (_tmp4_, (gint) PAGE_TWEET_INFO, bundle);
	_g_object_unref0 (bundle);
}


static void ___lambda57__gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self) {
	__lambda57_ ((TweetInfoPage*) self, row);
}


static void _tweet_info_page_media_visiblity_changed_cb_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	tweet_info_page_media_visiblity_changed_cb ((TweetInfoPage*) self);
}


TweetInfoPage* tweet_info_page_construct (GType object_type, gint id, Account* account) {
	TweetInfoPage * self = NULL;
	gint _tmp0_;
	Account* _tmp1_;
	TweetListBox* _tmp2_;
	Account* _tmp3_;
	TweetListBox* _tmp4_;
	Account* _tmp5_;
	GtkGrid* _tmp6_;
	MultiMediaWidget* _tmp7_;
	TweetListBox* _tmp8_;
	TweetListBox* _tmp9_;
	GSimpleActionGroup* _tmp10_;
	GSimpleActionGroup* _tmp11_;
	GSimpleActionGroup* _tmp12_;
	GSettings* _tmp13_;
	GSettings* _tmp14_;
	MultiMediaWidget* _tmp15_;
	MediaVisibility _tmp16_;
	g_return_val_if_fail (IS_ACCOUNT (account), NULL);
	self = (TweetInfoPage*) scroll_widget_construct (object_type);
	_tmp0_ = id;
	ipage_set_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), _tmp0_);
	_tmp1_ = account;
	self->account = _tmp1_;
	_tmp2_ = self->priv->top_list_box;
	_tmp3_ = account;
	_tmp2_->account = _tmp3_;
	_tmp4_ = self->priv->bottom_list_box;
	_tmp5_ = account;
	_tmp4_->account = _tmp5_;
	_tmp6_ = self->priv->grid;
	gtk_widget_set_redraw_on_allocate (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget), TRUE);
	_tmp7_ = self->priv->mm_widget;
	g_signal_connect_object (_tmp7_, "media-clicked", (GCallback) ___lambda54__multi_media_widget_media_clicked, self, 0);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "scroll-event", (GCallback) ___lambda55__gtk_widget_scroll_event, self, 0);
	_tmp8_ = self->priv->bottom_list_box;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_list_box_get_type (), GtkListBox), "row-activated", (GCallback) ___lambda56__gtk_list_box_row_activated, self, 0);
	_tmp9_ = self->priv->top_list_box;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_list_box_get_type (), GtkListBox), "row-activated", (GCallback) ___lambda57__gtk_list_box_row_activated, self, 0);
	_tmp10_ = g_simple_action_group_new ();
	_g_object_unref0 (self->priv->actions);
	self->priv->actions = _tmp10_;
	_tmp11_ = self->priv->actions;
	g_action_map_add_action_entries (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, g_action_map_get_type (), GActionMap), TWEET_INFO_PAGE_action_entries, G_N_ELEMENTS (TWEET_INFO_PAGE_action_entries), self);
	_tmp12_ = self->priv->actions;
	gtk_widget_insert_action_group (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "tweet", G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, g_action_group_get_type (), GActionGroup));
	_tmp13_ = settings_get ();
	_tmp14_ = _tmp13_;
	g_signal_connect_object (_tmp14_, "changed::media-visibility", (GCallback) _tweet_info_page_media_visiblity_changed_cb_g_settings_changed, self, 0);
	_g_object_unref0 (_tmp14_);
	_tmp15_ = self->priv->mm_widget;
	_tmp16_ = settings_get_media_visiblity ();
	gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_widget_get_type (), GtkWidget), _tmp16_ != MEDIA_VISIBILITY_HIDE);
	return self;
}


TweetInfoPage* tweet_info_page_new (gint id, Account* account) {
	return tweet_info_page_construct (TYPE_TWEET_INFO_PAGE, id, account);
}


static void tweet_info_page_media_visiblity_changed_cb (TweetInfoPage* self) {
	MediaVisibility _tmp0_;
	g_return_if_fail (IS_TWEET_INFO_PAGE (self));
	_tmp0_ = settings_get_media_visiblity ();
	if (_tmp0_ == MEDIA_VISIBILITY_HIDE) {
		MultiMediaWidget* _tmp1_;
		_tmp1_ = self->priv->mm_widget;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget));
	} else {
		MultiMediaWidget* _tmp2_;
		_tmp2_ = self->priv->mm_widget;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget));
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void tweet_info_page_real_on_join (IPage* base, gint page_id, CbBundle* args) {
	TweetInfoPage * self;
	gint mode = 0;
	CbBundle* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gboolean existing = FALSE;
	CbBundle* _tmp3_;
	gboolean _tmp4_;
	ReplyIndicator* _tmp5_;
	MaxSizeContainer* _tmp6_;
	GtkStack* _tmp7_;
	GtkBox* _tmp8_;
	gboolean _tmp9_;
	gint _tmp34_;
	gboolean _tmp70_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TWEET_INFO_PAGE, TweetInfoPage);
	g_return_if_fail ((args == NULL) || CB_IS_BUNDLE (args));
	_tmp0_ = args;
	_tmp1_ = cb_bundle_get_int (_tmp0_, TWEET_INFO_PAGE_KEY_MODE);
	mode = _tmp1_;
	_tmp2_ = mode;
	if (_tmp2_ == 0) {
		return;
	}
	self->priv->values_set = FALSE;
	_tmp3_ = args;
	_tmp4_ = cb_bundle_get_bool (_tmp3_, TWEET_INFO_PAGE_KEY_EXISTING);
	existing = _tmp4_;
	_tmp5_ = self->priv->reply_indicator;
	reply_indicator_set_replies_available (_tmp5_, FALSE);
	_tmp6_ = self->priv->max_size_container;
	max_size_container_set_max_size (_tmp6_, 0);
	_tmp7_ = self->priv->main_stack;
	_tmp8_ = self->priv->main_box;
	gtk_stack_set_visible_child (_tmp7_, G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget));
	_tmp9_ = existing;
	if (_tmp9_) {
		CbTweet* tweet = NULL;
		CbBundle* _tmp10_;
		GObject* _tmp11_;
		CbTweet* _tmp12_;
		Twitter* _tmp13_;
		Twitter* _tmp14_;
		CbTweet* _tmp15_;
		gint64 _tmp16_;
		gboolean _tmp17_;
		gboolean _tmp18_;
		CbTweet* _tmp26_;
		gint64 _tmp27_;
		_tmp10_ = args;
		_tmp11_ = cb_bundle_get_object (_tmp10_, TWEET_INFO_PAGE_KEY_TWEET);
		_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, CB_TYPE_TWEET, CbTweet));
		tweet = _tmp12_;
		_tmp13_ = twitter_get ();
		_tmp14_ = _tmp13_;
		_tmp15_ = tweet;
		_tmp16_ = cb_tweet_get_user_id (_tmp15_);
		_tmp17_ = twitter_has_avatar (_tmp14_, _tmp16_);
		_tmp18_ = _tmp17_;
		_g_object_unref0 (_tmp14_);
		if (_tmp18_) {
			AvatarWidget* _tmp19_;
			Twitter* _tmp20_;
			Twitter* _tmp21_;
			CbTweet* _tmp22_;
			gint64 _tmp23_;
			cairo_surface_t* _tmp24_;
			cairo_surface_t* _tmp25_;
			_tmp19_ = self->priv->avatar_image;
			_tmp20_ = twitter_get ();
			_tmp21_ = _tmp20_;
			_tmp22_ = tweet;
			_tmp23_ = cb_tweet_get_user_id (_tmp22_);
			_tmp24_ = twitter_get_cached_avatar (_tmp21_, _tmp23_);
			_tmp25_ = _tmp24_;
			avatar_widget_set_surface (_tmp19_, _tmp25_);
			_cairo_surface_destroy0 (_tmp25_);
			_g_object_unref0 (_tmp21_);
		}
		_tmp26_ = tweet;
		_tmp27_ = _tmp26_->id;
		tweet_info_page_rearrange_tweets (self, _tmp27_);
		_g_object_unref0 (tweet);
	} else {
		TweetListBox* _tmp28_;
		CbTweetModel* _tmp29_;
		TweetListBox* _tmp30_;
		TweetListBox* _tmp31_;
		CbTweetModel* _tmp32_;
		TweetListBox* _tmp33_;
		_tmp28_ = self->priv->bottom_list_box;
		_tmp29_ = _tmp28_->model;
		cb_tweet_model_clear (_tmp29_);
		_tmp30_ = self->priv->bottom_list_box;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, gtk_widget_get_type (), GtkWidget));
		_tmp31_ = self->priv->top_list_box;
		_tmp32_ = _tmp31_->model;
		cb_tweet_model_clear (_tmp32_);
		_tmp33_ = self->priv->top_list_box;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, gtk_widget_get_type (), GtkWidget));
	}
	_tmp34_ = mode;
	if (_tmp34_ == TWEET_INFO_PAGE_BY_INSTANCE) {
		CbTweet* tweet = NULL;
		CbBundle* _tmp35_;
		GObject* _tmp36_;
		CbTweet* _tmp37_;
		Twitter* _tmp38_;
		Twitter* _tmp39_;
		CbTweet* _tmp40_;
		gint64 _tmp41_;
		gboolean _tmp42_;
		gboolean _tmp43_;
		CbTweet* _tmp51_;
		CbMiniTweet* _tmp52_;
		CbTweet* _tmp58_;
		const gchar* _tmp59_;
		gchar* _tmp60_;
		CbTweet* _tmp61_;
		CbTweet* _tmp62_;
		CbTweet* _tmp63_;
		_tmp35_ = args;
		_tmp36_ = cb_bundle_get_object (_tmp35_, TWEET_INFO_PAGE_KEY_TWEET);
		_tmp37_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, CB_TYPE_TWEET, CbTweet));
		tweet = _tmp37_;
		_tmp38_ = twitter_get ();
		_tmp39_ = _tmp38_;
		_tmp40_ = tweet;
		_tmp41_ = cb_tweet_get_user_id (_tmp40_);
		_tmp42_ = twitter_has_avatar (_tmp39_, _tmp41_);
		_tmp43_ = _tmp42_;
		_g_object_unref0 (_tmp39_);
		if (_tmp43_) {
			AvatarWidget* _tmp44_;
			Twitter* _tmp45_;
			Twitter* _tmp46_;
			CbTweet* _tmp47_;
			gint64 _tmp48_;
			cairo_surface_t* _tmp49_;
			cairo_surface_t* _tmp50_;
			_tmp44_ = self->priv->avatar_image;
			_tmp45_ = twitter_get ();
			_tmp46_ = _tmp45_;
			_tmp47_ = tweet;
			_tmp48_ = cb_tweet_get_user_id (_tmp47_);
			_tmp49_ = twitter_get_cached_avatar (_tmp46_, _tmp48_);
			_tmp50_ = _tmp49_;
			avatar_widget_set_surface (_tmp44_, _tmp50_);
			_cairo_surface_destroy0 (_tmp50_);
			_g_object_unref0 (_tmp46_);
		}
		_tmp51_ = tweet;
		_tmp52_ = _tmp51_->retweeted_tweet;
		if (_tmp52_ != NULL) {
			CbTweet* _tmp53_;
			CbMiniTweet* _tmp54_;
			gint64 _tmp55_;
			_tmp53_ = tweet;
			_tmp54_ = _tmp53_->retweeted_tweet;
			_tmp55_ = (*_tmp54_).id;
			self->priv->tweet_id = _tmp55_;
		} else {
			CbTweet* _tmp56_;
			gint64 _tmp57_;
			_tmp56_ = tweet;
			_tmp57_ = _tmp56_->id;
			self->priv->tweet_id = _tmp57_;
		}
		_tmp58_ = tweet;
		_tmp59_ = cb_tweet_get_screen_name (_tmp58_);
		_tmp60_ = g_strdup (_tmp59_);
		_g_free0 (self->priv->screen_name);
		self->priv->screen_name = _tmp60_;
		_tmp61_ = tweet;
		_tmp62_ = _g_object_ref0 (_tmp61_);
		_g_object_unref0 (self->priv->tweet);
		self->priv->tweet = _tmp62_;
		_tmp63_ = tweet;
		tweet_info_page_set_tweet_data (self, _tmp63_, NULL);
		_g_object_unref0 (tweet);
	} else {
		gint _tmp64_;
		_tmp64_ = mode;
		if (_tmp64_ == TWEET_INFO_PAGE_BY_ID) {
			CbBundle* _tmp65_;
			gint64 _tmp66_;
			CbBundle* _tmp67_;
			const gchar* _tmp68_;
			gchar* _tmp69_;
			_g_object_unref0 (self->priv->tweet);
			self->priv->tweet = NULL;
			_tmp65_ = args;
			_tmp66_ = cb_bundle_get_int64 (_tmp65_, TWEET_INFO_PAGE_KEY_TWEET_ID);
			self->priv->tweet_id = _tmp66_;
			_tmp67_ = args;
			_tmp68_ = cb_bundle_get_string (_tmp67_, TWEET_INFO_PAGE_KEY_SCREEN_NAME);
			_tmp69_ = g_strdup (_tmp68_);
			_g_free0 (self->priv->screen_name);
			self->priv->screen_name = _tmp69_;
		}
	}
	_tmp70_ = existing;
	tweet_info_page_query_tweet_info (self, _tmp70_);
}


static Block28Data* block28_data_ref (Block28Data* _data28_) {
	g_atomic_int_inc (&_data28_->_ref_count_);
	return _data28_;
}


static void block28_data_unref (void * _userdata_) {
	Block28Data* _data28_;
	_data28_ = (Block28Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data28_->_ref_count_)) {
		TweetInfoPage* self;
		self = _data28_->self;
		_g_object_unref0 (self);
		g_slice_free (Block28Data, _data28_);
	}
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = old;
		_tmp1_ = (*((gchar*) _tmp2_)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = old;
		_tmp4_ = replacement;
		_tmp0_ = g_strcmp0 (_tmp3_, _tmp4_) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (self);
		result = _tmp5_;
		return result;
	}
	{
		GRegex* regex = NULL;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GRegex* _tmp9_;
		GRegex* _tmp10_;
		gchar* _tmp11_ = NULL;
		GRegex* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp6_ = old;
		_tmp7_ = g_regex_escape_string (_tmp6_, -1);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_regex_new (_tmp8_, 0, 0, &_inner_error_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		regex = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch25_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp12_ = regex;
		_tmp13_ = replacement;
		_tmp14_ = g_regex_replace_literal (_tmp12_, self, (gssize) -1, 0, _tmp13_, 0, &_inner_error_);
		_tmp11_ = _tmp14_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch25_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp15_ = _tmp11_;
		_tmp11_ = NULL;
		result = _tmp15_;
		_g_free0 (_tmp11_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally25;
	__catch25_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally25:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gpointer _cairo_surface_reference0 (gpointer self) {
	return self ? cairo_surface_reference (self) : NULL;
}


static void __lambda60_ (Block28Data* _data28_, GObject* obj, GAsyncResult* res) {
	TweetInfoPage* self;
	cairo_surface_t* surface = NULL;
	AvatarWidget* _tmp10_;
	cairo_surface_t* _tmp11_;
	GError * _inner_error_ = NULL;
	self = _data28_->self;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		GdkPixbuf* pixbuf = NULL;
		GAsyncResult* _tmp0_;
		GdkPixbuf* _tmp1_;
		_tmp0_ = res;
		_tmp1_ = tweet_utils_download_avatar_finish (_tmp0_, &_inner_error_);
		pixbuf = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch26_g_error;
		}
		if (pixbuf == NULL) {
			cairo_surface_t* _tmp2_;
			cairo_surface_t* _tmp3_;
			_tmp2_ = twitter_no_avatar;
			_tmp3_ = scale_surface ((cairo_surface_t*) _tmp2_, 73, 73);
			_cairo_surface_destroy0 (surface);
			surface = _tmp3_;
		} else {
			gint _tmp4_;
			cairo_surface_t* _tmp5_;
			_tmp4_ = _data28_->scale;
			_tmp5_ = gdk_cairo_surface_create_from_pixbuf (pixbuf, _tmp4_, NULL);
			_cairo_surface_destroy0 (surface);
			surface = _tmp5_;
		}
		_g_object_unref0 (pixbuf);
	}
	goto __finally26;
	__catch26_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		cairo_surface_t* _tmp8_;
		cairo_surface_t* _tmp9_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_warning ("TweetInfoPage.vala:216: %s", _tmp7_);
		_tmp8_ = twitter_no_avatar;
		_tmp9_ = _cairo_surface_reference0 (_tmp8_);
		_cairo_surface_destroy0 (surface);
		surface = _tmp9_;
		_g_error_free0 (e);
	}
	__finally26:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_cairo_surface_destroy0 (surface);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp10_ = self->priv->avatar_image;
	_tmp11_ = surface;
	avatar_widget_set_surface (_tmp10_, _tmp11_);
	_cairo_surface_destroy0 (surface);
}


static void ___lambda60__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda60_ (self, source_object, res);
	block28_data_unref (self);
}


static void tweet_info_page_load_user_avatar (TweetInfoPage* self, const gchar* url) {
	Block28Data* _data28_;
	gchar* avatar_url = NULL;
	gint _tmp0_;
	gint _tmp1_;
	const gchar* _tmp6_;
	gint _tmp7_;
	GCancellable* _tmp8_;
	g_return_if_fail (IS_TWEET_INFO_PAGE (self));
	g_return_if_fail (url != NULL);
	_data28_ = g_slice_new0 (Block28Data);
	_data28_->_ref_count_ = 1;
	_data28_->self = g_object_ref (self);
	_tmp0_ = gtk_widget_get_scale_factor (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_data28_->scale = _tmp0_;
	_tmp1_ = _data28_->scale;
	if (_tmp1_ == 1) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = url;
		_tmp3_ = string_replace (_tmp2_, "_normal", "_bigger");
		_g_free0 (avatar_url);
		avatar_url = _tmp3_;
	} else {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = url;
		_tmp5_ = string_replace (_tmp4_, "_normal", "_200x200");
		_g_free0 (avatar_url);
		avatar_url = _tmp5_;
	}
	_tmp6_ = avatar_url;
	_tmp7_ = _data28_->scale;
	_tmp8_ = self->priv->cancellable;
	tweet_utils_download_avatar (_tmp6_, 73 * _tmp7_, _tmp8_, ___lambda60__gasync_ready_callback, block28_data_ref (_data28_));
	_g_free0 (avatar_url);
	block28_data_unref (_data28_);
	_data28_ = NULL;
}


static void tweet_info_page_rearrange_tweets (TweetInfoPage* self, gint64 new_id) {
	TweetListBox* _tmp0_;
	CbTweetModel* _tmp1_;
	gint64 _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (IS_TWEET_INFO_PAGE (self));
	_tmp0_ = self->priv->top_list_box;
	_tmp1_ = _tmp0_->model;
	_tmp2_ = new_id;
	_tmp3_ = cb_tweet_model_contains_id (_tmp1_, _tmp2_);
	if (_tmp3_) {
		TweetListBox* _tmp4_;
		CbTweetModel* _tmp5_;
		CbTweet* _tmp6_;
		TweetListBox* _tmp7_;
		TweetListBox* _tmp8_;
		CbTweetModel* _tmp9_;
		TweetListBox* _tmp10_;
		_tmp4_ = self->priv->bottom_list_box;
		_tmp5_ = _tmp4_->model;
		_tmp6_ = self->priv->tweet;
		cb_tweet_model_add (_tmp5_, _tmp6_);
		_tmp7_ = self->priv->bottom_list_box;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget));
		_tmp8_ = self->priv->top_list_box;
		_tmp9_ = _tmp8_->model;
		cb_tweet_model_clear (_tmp9_);
		_tmp10_ = self->priv->top_list_box;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget));
	} else {
		TweetListBox* _tmp11_;
		CbTweetModel* _tmp12_;
		gint64 _tmp13_;
		gboolean _tmp14_;
		_tmp11_ = self->priv->bottom_list_box;
		_tmp12_ = _tmp11_->model;
		_tmp13_ = new_id;
		_tmp14_ = cb_tweet_model_contains_id (_tmp12_, _tmp13_);
		if (_tmp14_) {
			TweetListBox* _tmp15_;
			CbTweetModel* _tmp16_;
			TweetListBox* _tmp17_;
			CbTweet* t = NULL;
			TweetListBox* _tmp18_;
			CbTweetModel* _tmp19_;
			gint64 _tmp20_;
			CbTweet* _tmp21_;
			CbTweet* _tmp22_;
			CbTweet* _tmp23_;
			ReplyIndicator* _tmp30_;
			TweetListBox* _tmp31_;
			CbTweetModel* _tmp32_;
			gint64 _tmp33_;
			TweetListBox* _tmp34_;
			CbTweetModel* _tmp35_;
			guint _tmp36_;
			_tmp15_ = self->priv->top_list_box;
			_tmp16_ = _tmp15_->model;
			cb_tweet_model_clear (_tmp16_);
			_tmp17_ = self->priv->top_list_box;
			gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_widget_get_type (), GtkWidget));
			_tmp18_ = self->priv->bottom_list_box;
			_tmp19_ = _tmp18_->model;
			_tmp20_ = new_id;
			_tmp21_ = cb_tweet_model_get_for_id (_tmp19_, _tmp20_, -1);
			_tmp22_ = _g_object_ref0 (_tmp21_);
			t = _tmp22_;
			_tmp23_ = t;
			if (_tmp23_ != NULL) {
				TweetListBox* _tmp24_;
				CbTweetModel* _tmp25_;
				CbTweet* _tmp26_;
				_tmp24_ = self->priv->top_list_box;
				_tmp25_ = _tmp24_->model;
				_tmp26_ = t;
				cb_tweet_model_add (_tmp25_, _tmp26_);
			} else {
				TweetListBox* _tmp27_;
				CbTweetModel* _tmp28_;
				CbTweet* _tmp29_;
				_tmp27_ = self->priv->top_list_box;
				_tmp28_ = _tmp27_->model;
				_tmp29_ = self->priv->tweet;
				cb_tweet_model_add (_tmp28_, _tmp29_);
			}
			_tmp30_ = self->priv->reply_indicator;
			reply_indicator_set_replies_available (_tmp30_, TRUE);
			_tmp31_ = self->priv->bottom_list_box;
			_tmp32_ = _tmp31_->model;
			_tmp33_ = new_id;
			cb_tweet_model_remove_tweets_above (_tmp32_, _tmp33_);
			_tmp34_ = self->priv->bottom_list_box;
			_tmp35_ = _tmp34_->model;
			_tmp36_ = g_list_model_get_n_items (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, g_list_model_get_type (), GListModel));
			if (_tmp36_ == ((guint) 0)) {
				TweetListBox* _tmp37_;
				_tmp37_ = self->priv->bottom_list_box;
				gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, gtk_widget_get_type (), GtkWidget));
			}
			_g_object_unref0 (t);
		}
	}
}


static void tweet_info_page_real_on_leave (IPage* base) {
	TweetInfoPage * self;
	GCancellable* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TWEET_INFO_PAGE, TweetInfoPage);
	_tmp0_ = self->priv->cancellable;
	if (_tmp0_ != NULL) {
		GCancellable* _tmp1_;
		_tmp1_ = self->priv->cancellable;
		g_cancellable_cancel (_tmp1_);
		_g_object_unref0 (self->priv->cancellable);
		self->priv->cancellable = NULL;
	}
}


static void __lambda65_ (TweetInfoPage* self) {
	GtkToggleButton* _tmp0_;
	_tmp0_ = self->priv->favorite_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget), TRUE);
}


static void ___lambda65__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda65_ ((TweetInfoPage*) self);
	g_object_unref (self);
}


static void tweet_info_page_favorite_button_toggled_cb (TweetInfoPage* self) {
	gboolean _tmp0_;
	GtkToggleButton* _tmp1_;
	Account* _tmp2_;
	CbTweet* _tmp3_;
	GtkToggleButton* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	g_return_if_fail (IS_TWEET_INFO_PAGE (self));
	_tmp0_ = self->priv->values_set;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->favorite_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget), FALSE);
	tweet_info_page_update_rt_fav_labels (self);
	_tmp2_ = self->account;
	_tmp3_ = self->priv->tweet;
	_tmp4_ = self->priv->favorite_button;
	_tmp5_ = gtk_toggle_button_get_active (_tmp4_);
	_tmp6_ = _tmp5_;
	tweet_utils_set_favorite_status (_tmp2_, _tmp3_, _tmp6_, ___lambda65__gasync_ready_callback, g_object_ref (self));
}


static void _tweet_info_page_favorite_button_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	tweet_info_page_favorite_button_toggled_cb ((TweetInfoPage*) self);
}


static void __lambda67_ (TweetInfoPage* self) {
	GtkToggleButton* _tmp0_;
	_tmp0_ = self->priv->retweet_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget), TRUE);
}


static void ___lambda67__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda67_ ((TweetInfoPage*) self);
	g_object_unref (self);
}


static void tweet_info_page_retweet_button_toggled_cb (TweetInfoPage* self) {
	gboolean _tmp0_;
	GtkToggleButton* _tmp1_;
	GtkToggleButton* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	Account* _tmp9_;
	CbTweet* _tmp10_;
	GtkToggleButton* _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	g_return_if_fail (IS_TWEET_INFO_PAGE (self));
	_tmp0_ = self->priv->values_set;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->retweet_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp2_ = self->priv->retweet_button;
	_tmp3_ = gtk_toggle_button_get_active (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		CbTweet* _tmp5_;
		gint _tmp6_;
		_tmp5_ = self->priv->tweet;
		_tmp6_ = _tmp5_->retweet_count;
		_tmp5_->retweet_count = _tmp6_ + 1;
	} else {
		CbTweet* _tmp7_;
		gint _tmp8_;
		_tmp7_ = self->priv->tweet;
		_tmp8_ = _tmp7_->retweet_count;
		_tmp7_->retweet_count = _tmp8_ - 1;
	}
	tweet_info_page_update_rt_fav_labels (self);
	_tmp9_ = self->account;
	_tmp10_ = self->priv->tweet;
	_tmp11_ = self->priv->retweet_button;
	_tmp12_ = gtk_toggle_button_get_active (_tmp11_);
	_tmp13_ = _tmp12_;
	tweet_utils_set_retweet_status (_tmp9_, _tmp10_, _tmp13_, ___lambda67__gasync_ready_callback, g_object_ref (self));
}


static void _tweet_info_page_retweet_button_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	tweet_info_page_retweet_button_toggled_cb ((TweetInfoPage*) self);
}


static void tweet_info_page_reply_button_clicked_cb (TweetInfoPage* self) {
	ComposeTweetWindow* ctw = NULL;
	MainWindow* _tmp0_;
	Account* _tmp1_;
	CbTweet* _tmp2_;
	ComposeTweetWindow* _tmp3_;
	g_return_if_fail (IS_TWEET_INFO_PAGE (self));
	_tmp0_ = self->priv->main_window;
	_tmp1_ = self->account;
	_tmp2_ = self->priv->tweet;
	_tmp3_ = compose_tweet_window_new (_tmp0_, _tmp1_, _tmp2_, COMPOSE_TWEET_WINDOW_MODE_REPLY);
	g_object_ref_sink (_tmp3_);
	ctw = _tmp3_;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (ctw, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (ctw);
}


static void _tweet_info_page_reply_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	tweet_info_page_reply_button_clicked_cb ((TweetInfoPage*) self);
}


static gboolean tweet_info_page_link_activated_cb (TweetInfoPage* self, const gchar* uri) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	MainWindow* _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (IS_TWEET_INFO_PAGE (self), FALSE);
	g_return_val_if_fail (uri != NULL, FALSE);
	_tmp0_ = uri;
	_tmp1_ = self->priv->main_window;
	_tmp2_ = tweet_utils_activate_link (_tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


static gboolean _tweet_info_page_link_activated_cb_gtk_label_activate_link (GtkLabel* _sender, const gchar* uri, gpointer self) {
	gboolean result;
	result = tweet_info_page_link_activated_cb ((TweetInfoPage*) self, uri);
	return result;
}


static void tweet_info_page_name_button_clicked_cb (TweetInfoPage* self) {
	gint64 id = 0LL;
	gchar* screen_name = NULL;
	CbTweet* _tmp0_;
	CbMiniTweet* _tmp1_;
	CbBundle* bundle = NULL;
	CbBundle* _tmp20_;
	gint64 _tmp21_;
	const gchar* _tmp22_;
	MainWindow* _tmp23_;
	MainWidget* _tmp24_;
	g_return_if_fail (IS_TWEET_INFO_PAGE (self));
	_tmp0_ = self->priv->tweet;
	_tmp1_ = _tmp0_->retweeted_tweet;
	if (_tmp1_ != NULL) {
		CbTweet* _tmp2_;
		CbMiniTweet* _tmp3_;
		CbUserIdentity _tmp4_;
		gint64 _tmp5_;
		CbTweet* _tmp6_;
		CbMiniTweet* _tmp7_;
		CbUserIdentity _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp2_ = self->priv->tweet;
		_tmp3_ = _tmp2_->retweeted_tweet;
		_tmp4_ = (*_tmp3_).author;
		_tmp5_ = _tmp4_.id;
		id = _tmp5_;
		_tmp6_ = self->priv->tweet;
		_tmp7_ = _tmp6_->retweeted_tweet;
		_tmp8_ = (*_tmp7_).author;
		_tmp9_ = _tmp8_.screen_name;
		_tmp10_ = g_strdup (_tmp9_);
		_g_free0 (screen_name);
		screen_name = _tmp10_;
	} else {
		CbTweet* _tmp11_;
		CbMiniTweet _tmp12_;
		CbUserIdentity _tmp13_;
		gint64 _tmp14_;
		CbTweet* _tmp15_;
		CbMiniTweet _tmp16_;
		CbUserIdentity _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp11_ = self->priv->tweet;
		_tmp12_ = _tmp11_->source_tweet;
		_tmp13_ = _tmp12_.author;
		_tmp14_ = _tmp13_.id;
		id = _tmp14_;
		_tmp15_ = self->priv->tweet;
		_tmp16_ = _tmp15_->source_tweet;
		_tmp17_ = _tmp16_.author;
		_tmp18_ = _tmp17_.screen_name;
		_tmp19_ = g_strdup (_tmp18_);
		_g_free0 (screen_name);
		screen_name = _tmp19_;
	}
	_tmp20_ = cb_bundle_new ();
	bundle = _tmp20_;
	_tmp21_ = id;
	cb_bundle_put_int64 (bundle, PROFILE_PAGE_KEY_USER_ID, _tmp21_);
	_tmp22_ = screen_name;
	cb_bundle_put_string (bundle, PROFILE_PAGE_KEY_SCREEN_NAME, _tmp22_);
	_tmp23_ = self->priv->main_window;
	_tmp24_ = _tmp23_->main_widget;
	main_widget_switch_page (_tmp24_, (gint) PAGE_PROFILE, bundle);
	_g_object_unref0 (bundle);
	_g_free0 (screen_name);
}


static void _tweet_info_page_name_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	tweet_info_page_name_button_clicked_cb ((TweetInfoPage*) self);
}


static Block29Data* block29_data_ref (Block29Data* _data29_) {
	g_atomic_int_inc (&_data29_->_ref_count_);
	return _data29_;
}


static void block29_data_unref (void * _userdata_) {
	Block29Data* _data29_;
	_data29_ = (Block29Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data29_->_ref_count_)) {
		TweetInfoPage* self;
		self = _data29_->self;
		_g_date_time_unref0 (_data29_->now);
		_g_object_unref0 (self);
		g_slice_free (Block29Data, _data29_);
	}
}


static void _vala_JsonNode_free (JsonNode* self) {
	g_boxed_free (json_node_get_type (), self);
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


static void __lambda61_ (Block29Data* _data29_, GObject* __, GAsyncResult* res) {
	TweetInfoPage* self;
	JsonNode* root = NULL;
	JsonNode* _tmp11_;
	JsonObject* root_object = NULL;
	JsonNode* _tmp12_;
	JsonObject* _tmp13_;
	JsonObject* _tmp14_;
	CbTweet* _tmp15_;
	gchar* with = NULL;
	JsonObject* _tmp29_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	const gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	CbTweet* _tmp38_;
	const gchar* _tmp39_;
	gboolean _tmp40_;
	GError * _inner_error_ = NULL;
	self = _data29_->self;
	g_return_if_fail ((__ == NULL) || G_IS_OBJECT (__));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	root = NULL;
	{
		JsonNode* _tmp0_ = NULL;
		GAsyncResult* _tmp1_;
		JsonNode* _tmp2_;
		JsonNode* _tmp3_;
		_tmp1_ = res;
		_tmp2_ = cb_utils_load_threaded_finish (_tmp1_, &_inner_error_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch27_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		__vala_JsonNode_free0 (root);
		root = _tmp3_;
		__vala_JsonNode_free0 (_tmp0_);
	}
	goto __finally27;
	__catch27_g_error:
	{
		GError* e = NULL;
		GtkLabel* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GtkStack* _tmp9_;
		GtkLabel* _tmp10_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = self->priv->error_label;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		_tmp7_ = g_strdup_printf ("%s: %s", _ ("Could not show tweet"), _tmp6_);
		_tmp8_ = _tmp7_;
		gtk_label_set_label (_tmp4_, _tmp8_);
		_g_free0 (_tmp8_);
		_tmp9_ = self->priv->main_stack;
		_tmp10_ = self->priv->error_label;
		gtk_stack_set_visible_child (_tmp9_, G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget));
		_g_error_free0 (e);
		__vala_JsonNode_free0 (root);
		return;
	}
	__finally27:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		__vala_JsonNode_free0 (root);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp11_ = root;
	if (_tmp11_ == NULL) {
		__vala_JsonNode_free0 (root);
		return;
	}
	_tmp12_ = root;
	_tmp13_ = json_node_get_object (_tmp12_);
	_tmp14_ = _json_object_ref0 (_tmp13_);
	root_object = _tmp14_;
	_tmp15_ = self->priv->tweet;
	if (_tmp15_ != NULL) {
		gint n_retweets = 0;
		JsonObject* _tmp16_;
		gint64 _tmp17_;
		gint n_favorites = 0;
		JsonObject* _tmp18_;
		gint64 _tmp19_;
		CbTweet* _tmp20_;
		gint _tmp21_;
		CbTweet* _tmp22_;
		gint _tmp23_;
		_tmp16_ = root_object;
		_tmp17_ = json_object_get_int_member (_tmp16_, "retweet_count");
		n_retweets = (gint) _tmp17_;
		_tmp18_ = root_object;
		_tmp19_ = json_object_get_int_member (_tmp18_, "favorite_count");
		n_favorites = (gint) _tmp19_;
		_tmp20_ = self->priv->tweet;
		_tmp21_ = n_retweets;
		_tmp20_->retweet_count = _tmp21_;
		_tmp22_ = self->priv->tweet;
		_tmp23_ = n_favorites;
		_tmp22_->favorite_count = _tmp23_;
	} else {
		CbTweet* _tmp24_;
		CbTweet* _tmp25_;
		JsonNode* _tmp26_;
		Account* _tmp27_;
		gint64 _tmp28_;
		_tmp24_ = cb_tweet_new ();
		_g_object_unref0 (self->priv->tweet);
		self->priv->tweet = _tmp24_;
		_tmp25_ = self->priv->tweet;
		_tmp26_ = root;
		_tmp27_ = self->account;
		_tmp28_ = _tmp27_->id;
		cb_tweet_load_from_json (_tmp25_, _tmp26_, _tmp28_, _data29_->now);
	}
	_tmp29_ = root_object;
	_tmp30_ = json_object_get_string_member (_tmp29_, "source");
	_tmp31_ = g_strdup (_tmp30_);
	with = _tmp31_;
	_tmp32_ = with;
	_tmp33_ = tweet_info_page_extract_source (self, _tmp32_);
	_tmp34_ = _tmp33_;
	_tmp35_ = g_strconcat ("<span underline='none'>", _tmp34_, NULL);
	_tmp36_ = _tmp35_;
	_tmp37_ = g_strconcat (_tmp36_, "</span>", NULL);
	_g_free0 (with);
	with = _tmp37_;
	_g_free0 (_tmp36_);
	_g_free0 (_tmp34_);
	_tmp38_ = self->priv->tweet;
	_tmp39_ = with;
	tweet_info_page_set_tweet_data (self, _tmp38_, _tmp39_);
	_tmp40_ = _data29_->existing;
	if (!_tmp40_) {
		CbTweet* _tmp41_;
		CbMiniTweet* _tmp42_;
		_tmp41_ = self->priv->tweet;
		_tmp42_ = _tmp41_->retweeted_tweet;
		if (_tmp42_ == NULL) {
			CbTweet* _tmp43_;
			CbMiniTweet _tmp44_;
			gint64 _tmp45_;
			_tmp43_ = self->priv->tweet;
			_tmp44_ = _tmp43_->source_tweet;
			_tmp45_ = _tmp44_.reply_id;
			tweet_info_page_load_replied_to_tweet (self, _tmp45_);
		} else {
			CbTweet* _tmp46_;
			CbMiniTweet* _tmp47_;
			gint64 _tmp48_;
			_tmp46_ = self->priv->tweet;
			_tmp47_ = _tmp46_->retweeted_tweet;
			_tmp48_ = (*_tmp47_).reply_id;
			tweet_info_page_load_replied_to_tweet (self, _tmp48_);
		}
	}
	self->priv->values_set = TRUE;
	_g_free0 (with);
	_json_object_unref0 (root_object);
	__vala_JsonNode_free0 (root);
}


static void ___lambda61__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda61_ (self, source_object, res);
	block29_data_unref (self);
}


static Block30Data* block30_data_ref (Block30Data* _data30_) {
	g_atomic_int_inc (&_data30_->_ref_count_);
	return _data30_;
}


static void block30_data_unref (void * _userdata_) {
	Block30Data* _data30_;
	_data30_ = (Block30Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data30_->_ref_count_)) {
		TweetInfoPage* self;
		self = _data30_->_data29_->self;
		block29_data_unref (_data30_->_data29_);
		_data30_->_data29_ = NULL;
		g_slice_free (Block30Data, _data30_);
	}
}


static gpointer _json_array_ref0 (gpointer self) {
	return self ? json_array_ref (self) : NULL;
}


static void __lambda64_ (Block30Data* _data30_, JsonArray* arr, guint index, JsonNode* node) {
	Block29Data* _data29_;
	TweetInfoPage* self;
	gint _tmp0_;
	JsonObject* obj = NULL;
	JsonNode* _tmp1_;
	JsonObject* _tmp2_;
	JsonObject* _tmp3_;
	gboolean _tmp4_ = FALSE;
	JsonObject* _tmp5_;
	gboolean _tmp6_;
	gint64 reply_id = 0LL;
	JsonObject* _tmp9_;
	gint64 _tmp10_;
	gint64 _tmp11_;
	gint64 _tmp12_;
	CbTweet* t = NULL;
	CbTweet* _tmp13_;
	CbTweet* _tmp14_;
	JsonNode* _tmp15_;
	Account* _tmp16_;
	gint64 _tmp17_;
	CbTweet* _tmp18_;
	gint64 _tmp19_;
	gint64 _tmp20_;
	_data29_ = _data30_->_data29_;
	self = _data29_->self;
	g_return_if_fail (arr != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = _data30_->n_replies;
	if (_tmp0_ >= 5) {
		return;
	}
	_tmp1_ = node;
	_tmp2_ = json_node_get_object (_tmp1_);
	_tmp3_ = _json_object_ref0 (_tmp2_);
	obj = _tmp3_;
	_tmp5_ = obj;
	_tmp6_ = json_object_has_member (_tmp5_, "in_reply_to_status_id");
	if (!_tmp6_) {
		_tmp4_ = TRUE;
	} else {
		JsonObject* _tmp7_;
		gboolean _tmp8_;
		_tmp7_ = obj;
		_tmp8_ = json_object_get_null_member (_tmp7_, "in_reply_to_status_id");
		_tmp4_ = _tmp8_;
	}
	if (_tmp4_) {
		_json_object_unref0 (obj);
		return;
	}
	_tmp9_ = obj;
	_tmp10_ = json_object_get_int_member (_tmp9_, "in_reply_to_status_id");
	reply_id = _tmp10_;
	_tmp11_ = reply_id;
	_tmp12_ = self->priv->tweet_id;
	if (_tmp11_ != _tmp12_) {
		_json_object_unref0 (obj);
		return;
	}
	_tmp13_ = cb_tweet_new ();
	t = _tmp13_;
	_tmp14_ = t;
	_tmp15_ = node;
	_tmp16_ = self->account;
	_tmp17_ = _tmp16_->id;
	cb_tweet_load_from_json (_tmp14_, _tmp15_, _tmp17_, _data29_->now);
	_tmp18_ = t;
	_tmp19_ = _tmp18_->id;
	_tmp20_ = _data30_->previous_tweet_id;
	if (_tmp19_ != _tmp20_) {
		TweetListBox* _tmp21_;
		CbTweetModel* _tmp22_;
		CbTweet* _tmp23_;
		gint _tmp24_;
		_tmp21_ = self->priv->top_list_box;
		_tmp22_ = _tmp21_->model;
		_tmp23_ = t;
		cb_tweet_model_add (_tmp22_, _tmp23_);
		_tmp24_ = _data30_->n_replies;
		_data30_->n_replies = _tmp24_ + 1;
	}
	_g_object_unref0 (t);
	_json_object_unref0 (obj);
}


static void ___lambda64__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	__lambda64_ (self, array, index_, element_node);
}


static void __lambda63_ (Block29Data* _data29_, GObject* _, GAsyncResult* res) {
	TweetInfoPage* self;
	Block30Data* _data30_;
	JsonNode* root = NULL;
	JsonNode* _tmp7_;
	JsonArray* statuses_node = NULL;
	JsonNode* _tmp8_;
	JsonObject* _tmp9_;
	JsonArray* _tmp10_;
	JsonArray* _tmp11_;
	TweetListBox* _tmp12_;
	CbTweetModel* _tmp13_;
	guint _tmp14_;
	JsonArray* _tmp20_;
	gint _tmp21_;
	GError * _inner_error_ = NULL;
	self = _data29_->self;
	g_return_if_fail ((_ == NULL) || G_IS_OBJECT (_));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	_data30_ = g_slice_new0 (Block30Data);
	_data30_->_ref_count_ = 1;
	_data30_->_data29_ = block29_data_ref (_data29_);
	root = NULL;
	{
		JsonNode* _tmp0_ = NULL;
		GAsyncResult* _tmp1_;
		JsonNode* _tmp2_;
		JsonNode* _tmp3_;
		_tmp1_ = res;
		_tmp2_ = cb_utils_load_threaded_finish (_tmp1_, &_inner_error_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch28_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		__vala_JsonNode_free0 (root);
		root = _tmp3_;
		__vala_JsonNode_free0 (_tmp0_);
	}
	goto __finally28;
	__catch28_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		if (!g_error_matches (_tmp4_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
			GError* _tmp5_;
			const gchar* _tmp6_;
			_tmp5_ = e;
			_tmp6_ = _tmp5_->message;
			g_warning ("TweetInfoPage.vala:394: %s", _tmp6_);
		}
		_g_error_free0 (e);
		__vala_JsonNode_free0 (root);
		block30_data_unref (_data30_);
		_data30_ = NULL;
		return;
	}
	__finally28:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		__vala_JsonNode_free0 (root);
		block30_data_unref (_data30_);
		_data30_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp7_ = root;
	if (_tmp7_ == NULL) {
		__vala_JsonNode_free0 (root);
		block30_data_unref (_data30_);
		_data30_ = NULL;
		return;
	}
	_tmp8_ = root;
	_tmp9_ = json_node_get_object (_tmp8_);
	_tmp10_ = json_object_get_array_member (_tmp9_, "statuses");
	_tmp11_ = _json_array_ref0 (_tmp10_);
	statuses_node = _tmp11_;
	_data30_->previous_tweet_id = (gint64) -1;
	_tmp12_ = self->priv->top_list_box;
	_tmp13_ = _tmp12_->model;
	_tmp14_ = g_list_model_get_n_items (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, g_list_model_get_type (), GListModel));
	if (_tmp14_ > ((guint) 0)) {
		TweetListBox* _tmp15_;
		CbTweetModel* _tmp16_;
		GObject* _tmp17_;
		CbTweet* _tmp18_;
		gint64 _tmp19_;
		_tmp15_ = self->priv->top_list_box;
		_tmp16_ = _tmp15_->model;
		_tmp17_ = g_list_model_get_item (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, g_list_model_get_type (), GListModel), (guint) 0);
		_tmp18_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, CB_TYPE_TWEET, CbTweet);
		_tmp19_ = _tmp18_->id;
		_data30_->previous_tweet_id = _tmp19_;
		_g_object_unref0 (_tmp18_);
	}
	_data30_->n_replies = 0;
	_tmp20_ = statuses_node;
	json_array_foreach_element (_tmp20_, ___lambda64__json_array_foreach, _data30_);
	_tmp21_ = _data30_->n_replies;
	if (_tmp21_ > 0) {
		TweetListBox* _tmp22_;
		ReplyIndicator* _tmp23_;
		_tmp22_ = self->priv->top_list_box;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, gtk_widget_get_type (), GtkWidget));
		_tmp23_ = self->priv->reply_indicator;
		reply_indicator_set_replies_available (_tmp23_, TRUE);
	} else {
	}
	_json_array_unref0 (statuses_node);
	__vala_JsonNode_free0 (root);
	block30_data_unref (_data30_);
	_data30_ = NULL;
}


static void ___lambda63__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda63_ (self, source_object, res);
	block29_data_unref (self);
}


static void tweet_info_page_query_tweet_info (TweetInfoPage* self, gboolean existing) {
	Block29Data* _data29_;
	gboolean _tmp0_;
	GCancellable* _tmp1_;
	GCancellable* _tmp3_;
	GDateTime* _tmp4_;
	RestProxyCall* call = NULL;
	Account* _tmp5_;
	OAuthProxy* _tmp6_;
	RestProxyCall* _tmp7_;
	gint64 _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GCancellable* _tmp11_;
	RestProxyCall* reply_call = NULL;
	Account* _tmp12_;
	OAuthProxy* _tmp13_;
	RestProxyCall* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gint64 _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	GCancellable* _tmp21_;
	g_return_if_fail (IS_TWEET_INFO_PAGE (self));
	_data29_ = g_slice_new0 (Block29Data);
	_data29_->_ref_count_ = 1;
	_data29_->self = g_object_ref (self);
	_tmp0_ = existing;
	_data29_->existing = _tmp0_;
	_tmp1_ = self->priv->cancellable;
	if (_tmp1_ != NULL) {
		GCancellable* _tmp2_;
		_tmp2_ = self->priv->cancellable;
		g_cancellable_cancel (_tmp2_);
	}
	_tmp3_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp3_;
	_tmp4_ = g_date_time_new_now_local ();
	_data29_->now = _tmp4_;
	_tmp5_ = self->account;
	_tmp6_ = _tmp5_->proxy;
	_tmp7_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, rest_proxy_get_type (), RestProxy));
	call = _tmp7_;
	rest_proxy_call_set_method (call, "GET");
	rest_proxy_call_set_function (call, "1.1/statuses/show.json");
	_tmp8_ = self->priv->tweet_id;
	_tmp9_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp8_);
	_tmp10_ = _tmp9_;
	rest_proxy_call_add_param (call, "id", _tmp10_);
	_g_free0 (_tmp10_);
	rest_proxy_call_add_param (call, "include_my_retweet", "true");
	rest_proxy_call_add_param (call, "tweet_mode", "extended");
	_tmp11_ = self->priv->cancellable;
	cb_utils_load_threaded_async (call, _tmp11_, ___lambda61__gasync_ready_callback, block29_data_ref (_data29_));
	_tmp12_ = self->account;
	_tmp13_ = _tmp12_->proxy;
	_tmp14_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, rest_proxy_get_type (), RestProxy));
	reply_call = _tmp14_;
	rest_proxy_call_set_method (reply_call, "GET");
	rest_proxy_call_set_function (reply_call, "1.1/search/tweets.json");
	_tmp15_ = self->priv->screen_name;
	_tmp16_ = g_strconcat ("to:", _tmp15_, NULL);
	_tmp17_ = _tmp16_;
	rest_proxy_call_add_param (reply_call, "q", _tmp17_);
	_g_free0 (_tmp17_);
	_tmp18_ = self->priv->tweet_id;
	_tmp19_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp18_);
	_tmp20_ = _tmp19_;
	rest_proxy_call_add_param (reply_call, "since_id", _tmp20_);
	_g_free0 (_tmp20_);
	rest_proxy_call_add_param (reply_call, "count", "200");
	rest_proxy_call_add_param (reply_call, "tweet_mode", "extended");
	_tmp21_ = self->priv->cancellable;
	cb_utils_load_threaded_async (reply_call, _tmp21_, ___lambda63__gasync_ready_callback, block29_data_ref (_data29_));
	_g_object_unref0 (reply_call);
	_g_object_unref0 (call);
	block29_data_unref (_data29_);
	_data29_ = NULL;
}


/**
   * Loads the tweet this tweet is a reply to.
   * This will recursively call itself until the end of the chain is reached.
   *
   * @param reply_id The id of the tweet the previous tweet was a reply to.
   */
static Block31Data* block31_data_ref (Block31Data* _data31_) {
	g_atomic_int_inc (&_data31_->_ref_count_);
	return _data31_;
}


static void block31_data_unref (void * _userdata_) {
	Block31Data* _data31_;
	_data31_ = (Block31Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data31_->_ref_count_)) {
		TweetInfoPage* self;
		self = _data31_->self;
		_g_object_unref0 (_data31_->call);
		_g_object_unref0 (self);
		g_slice_free (Block31Data, _data31_);
	}
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static void __lambda62_ (Block31Data* _data31_, GObject* obj, GAsyncResult* res) {
	TweetInfoPage* self;
	JsonParser* parser = NULL;
	JsonParser* _tmp28_;
	CbTweet* tweet = NULL;
	CbTweet* _tmp34_;
	CbTweet* _tmp35_;
	JsonParser* _tmp36_;
	JsonNode* _tmp37_;
	Account* _tmp38_;
	gint64 _tmp39_;
	GDateTime* _tmp40_;
	GDateTime* _tmp41_;
	TweetListBox* _tmp42_;
	CbTweetModel* _tmp43_;
	CbTweet* _tmp44_;
	CbTweet* _tmp45_;
	CbMiniTweet* _tmp46_;
	GError * _inner_error_ = NULL;
	self = _data31_->self;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		RestProxyCall* _tmp0_;
		GAsyncResult* _tmp1_;
		_tmp0_ = _data31_->call;
		_tmp1_ = res;
		rest_proxy_call_invoke_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch29_g_error;
		}
	}
	goto __finally29;
	__catch29_g_error:
	{
		GError* e = NULL;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		GError* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gboolean _tmp8_;
		TweetListBox* _tmp23_;
		TweetListBox* _tmp24_;
		GList* _tmp25_;
		GList* _tmp26_;
		guint _tmp27_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		_tmp6_ = string_strip (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strcmp0 (_tmp7_, "Forbidden") != 0;
		_g_free0 (_tmp7_);
		if (_tmp8_) {
			GError* _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			_tmp9_ = e;
			_tmp10_ = _tmp9_->message;
			_tmp11_ = string_strip (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = g_utf8_strdown (_tmp12_, (gssize) -1);
			_tmp14_ = _tmp13_;
			_tmp3_ = g_strcmp0 (_tmp14_, "not found") != 0;
			_g_free0 (_tmp14_);
			_g_free0 (_tmp12_);
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			GError* _tmp15_;
			_tmp15_ = e;
			_tmp2_ = !g_error_matches (_tmp15_, G_IO_ERROR, G_IO_ERROR_CANCELLED);
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			GError* _tmp16_;
			const gchar* _tmp17_;
			RestProxyCall* _tmp18_;
			const gchar* _tmp19_;
			GError* _tmp20_;
			const gchar* _tmp21_;
			MainWindow* _tmp22_;
			_tmp16_ = e;
			_tmp17_ = _tmp16_->message;
			g_critical ("TweetInfoPage.vala:466: %s", _tmp17_);
			_tmp18_ = _data31_->call;
			_tmp19_ = rest_proxy_call_get_payload (_tmp18_);
			_tmp20_ = e;
			_tmp21_ = _tmp20_->message;
			_tmp22_ = self->priv->main_window;
			utils_show_error_object (_tmp19_, _tmp21_, 468, "TweetInfoPage.vala", G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, gtk_window_get_type (), GtkWindow));
		}
		_tmp23_ = self->priv->bottom_list_box;
		_tmp24_ = self->priv->bottom_list_box;
		_tmp25_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, gtk_container_get_type (), GtkContainer));
		_tmp26_ = _tmp25_;
		_tmp27_ = g_list_length (_tmp26_);
		gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, gtk_widget_get_type (), GtkWidget), _tmp27_ > ((guint) 0));
		_g_list_free0 (_tmp26_);
		_g_error_free0 (e);
		return;
	}
	__finally29:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp28_ = json_parser_new ();
	parser = _tmp28_;
	{
		JsonParser* _tmp29_;
		RestProxyCall* _tmp30_;
		const gchar* _tmp31_;
		_tmp29_ = parser;
		_tmp30_ = _data31_->call;
		_tmp31_ = rest_proxy_call_get_payload (_tmp30_);
		json_parser_load_from_data (_tmp29_, _tmp31_, (gssize) -1, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch30_g_error;
		}
	}
	goto __finally30;
	__catch30_g_error:
	{
		GError* e = NULL;
		GError* _tmp32_;
		const gchar* _tmp33_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp32_ = e;
		_tmp33_ = _tmp32_->message;
		g_critical ("TweetInfoPage.vala:478: %s", _tmp33_);
		_g_error_free0 (e);
		_g_object_unref0 (parser);
		return;
	}
	__finally30:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (parser);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp34_ = cb_tweet_new ();
	tweet = _tmp34_;
	_tmp35_ = tweet;
	_tmp36_ = parser;
	_tmp37_ = json_parser_get_root (_tmp36_);
	_tmp38_ = self->account;
	_tmp39_ = _tmp38_->id;
	_tmp40_ = g_date_time_new_now_local ();
	_tmp41_ = _tmp40_;
	cb_tweet_load_from_json (_tmp35_, _tmp37_, _tmp39_, _tmp41_);
	_g_date_time_unref0 (_tmp41_);
	_tmp42_ = self->priv->bottom_list_box;
	_tmp43_ = _tmp42_->model;
	_tmp44_ = tweet;
	cb_tweet_model_add (_tmp43_, _tmp44_);
	_tmp45_ = tweet;
	_tmp46_ = _tmp45_->retweeted_tweet;
	if (_tmp46_ == NULL) {
		CbTweet* _tmp47_;
		CbMiniTweet _tmp48_;
		gint64 _tmp49_;
		_tmp47_ = tweet;
		_tmp48_ = _tmp47_->source_tweet;
		_tmp49_ = _tmp48_.reply_id;
		tweet_info_page_load_replied_to_tweet (self, _tmp49_);
	} else {
		CbTweet* _tmp50_;
		CbMiniTweet* _tmp51_;
		gint64 _tmp52_;
		_tmp50_ = tweet;
		_tmp51_ = _tmp50_->retweeted_tweet;
		_tmp52_ = (*_tmp51_).reply_id;
		tweet_info_page_load_replied_to_tweet (self, _tmp52_);
	}
	_g_object_unref0 (tweet);
	_g_object_unref0 (parser);
}


static void ___lambda62__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda62_ (self, source_object, res);
	block31_data_unref (self);
}


static void tweet_info_page_load_replied_to_tweet (TweetInfoPage* self, gint64 reply_id) {
	Block31Data* _data31_;
	gint64 _tmp0_;
	TweetListBox* _tmp1_;
	Account* _tmp2_;
	OAuthProxy* _tmp3_;
	RestProxyCall* _tmp4_;
	RestProxyCall* _tmp5_;
	RestProxyCall* _tmp6_;
	RestProxyCall* _tmp7_;
	gint64 _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	RestProxyCall* _tmp11_;
	RestProxyCall* _tmp12_;
	GCancellable* _tmp13_;
	g_return_if_fail (IS_TWEET_INFO_PAGE (self));
	_data31_ = g_slice_new0 (Block31Data);
	_data31_->_ref_count_ = 1;
	_data31_->self = g_object_ref (self);
	_tmp0_ = reply_id;
	if (_tmp0_ == ((gint64) 0)) {
		block31_data_unref (_data31_);
		_data31_ = NULL;
		return;
	}
	_tmp1_ = self->priv->bottom_list_box;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget));
	_tmp2_ = self->account;
	_tmp3_ = _tmp2_->proxy;
	_tmp4_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, rest_proxy_get_type (), RestProxy));
	_data31_->call = _tmp4_;
	_tmp5_ = _data31_->call;
	rest_proxy_call_set_function (_tmp5_, "1.1/statuses/show.json");
	_tmp6_ = _data31_->call;
	rest_proxy_call_set_method (_tmp6_, "GET");
	_tmp7_ = _data31_->call;
	_tmp8_ = reply_id;
	_tmp9_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp8_);
	_tmp10_ = _tmp9_;
	rest_proxy_call_add_param (_tmp7_, "id", _tmp10_);
	_g_free0 (_tmp10_);
	_tmp11_ = _data31_->call;
	rest_proxy_call_add_param (_tmp11_, "tweet_mode", "extended");
	_tmp12_ = _data31_->call;
	_tmp13_ = self->priv->cancellable;
	rest_proxy_call_invoke_async (_tmp12_, _tmp13_, ___lambda62__gasync_ready_callback, block31_data_ref (_data31_));
	block31_data_unref (_data31_);
	_data31_ = NULL;
}


/**
   *
   */
static CbUserIdentity* _vala_array_dup6 (CbUserIdentity* self, int length) {
	CbUserIdentity* result;
	int i;
	result = g_new0 (CbUserIdentity, length);
	for (i = 0; i < length; i++) {
		CbUserIdentity _tmp0_ = {0};
		cb_user_identity_copy (&self[i], &_tmp0_);
		result[i] = _tmp0_;
	}
	return result;
}


static void _vala_CbUserIdentity_array_free (CbUserIdentity * array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			cb_user_identity_free (&array[i]);
		}
	}
	g_free (array);
}


static void tweet_info_page_set_tweet_data (TweetInfoPage* self, CbTweet* tweet, const gchar* with) {
	Account* _tmp0_;
	CbUserCounter* _tmp1_;
	CbTweet* _tmp2_;
	gint64 _tmp3_;
	CbTweet* _tmp4_;
	const gchar* _tmp5_;
	CbTweet* _tmp6_;
	const gchar* _tmp7_;
	gint64 _tmp8_ = 0LL;
	CbTweet* _tmp9_;
	CbMiniTweet* _tmp10_;
	GDateTime* created_at = NULL;
	GDateTime* _tmp17_;
	gchar* time_format = NULL;
	GDateTime* _tmp18_;
	gchar* _tmp19_;
	const gchar* _tmp20_;
	GtkLabel* _tmp26_;
	CbTweet* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	TextButton* _tmp30_;
	CbTweet* _tmp31_;
	const gchar* _tmp32_;
	GtkLabel* _tmp33_;
	CbTweet* _tmp34_;
	const gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	CbTweet* _tmp38_;
	const gchar* _tmp39_;
	GtkLabel* _tmp40_;
	const gchar* _tmp41_;
	GtkToggleButton* _tmp42_;
	CbTweet* _tmp43_;
	gboolean _tmp44_;
	GtkToggleButton* _tmp45_;
	CbTweet* _tmp46_;
	gboolean _tmp47_;
	AvatarWidget* _tmp48_;
	CbTweet* _tmp49_;
	gboolean _tmp50_;
	CbTweet* _tmp51_;
	gint64 _tmp52_;
	CbTweet* _tmp53_;
	const gchar* _tmp54_;
	gboolean _tmp55_ = FALSE;
	gboolean _tmp56_ = FALSE;
	CbTweet* _tmp57_;
	CbMiniTweet* _tmp58_;
	CbTweet* _tmp94_;
	gboolean _tmp95_;
	GSimpleActionGroup* _tmp103_;
	GAction* _tmp104_;
	CbTweet* _tmp105_;
	gint64 _tmp106_;
	Account* _tmp107_;
	gint64 _tmp108_;
	CbTweet* _tmp109_;
	gboolean _tmp110_;
	g_return_if_fail (IS_TWEET_INFO_PAGE (self));
	g_return_if_fail (CB_IS_TWEET (tweet));
	_tmp0_ = self->account;
	_tmp1_ = _tmp0_->user_counter;
	_tmp2_ = tweet;
	_tmp3_ = cb_tweet_get_user_id (_tmp2_);
	_tmp4_ = tweet;
	_tmp5_ = cb_tweet_get_screen_name (_tmp4_);
	_tmp6_ = tweet;
	_tmp7_ = cb_tweet_get_user_name (_tmp6_);
	cb_user_counter_user_seen (_tmp1_, _tmp3_, _tmp5_, _tmp7_);
	_tmp9_ = tweet;
	_tmp10_ = _tmp9_->retweeted_tweet;
	if (_tmp10_ != NULL) {
		CbTweet* _tmp11_;
		CbMiniTweet* _tmp12_;
		gint64 _tmp13_;
		_tmp11_ = tweet;
		_tmp12_ = _tmp11_->retweeted_tweet;
		_tmp13_ = (*_tmp12_).created_at;
		_tmp8_ = _tmp13_;
	} else {
		CbTweet* _tmp14_;
		CbMiniTweet _tmp15_;
		gint64 _tmp16_;
		_tmp14_ = tweet;
		_tmp15_ = _tmp14_->source_tweet;
		_tmp16_ = _tmp15_.created_at;
		_tmp8_ = _tmp16_;
	}
	_tmp17_ = g_date_time_new_from_unix_local (_tmp8_);
	created_at = _tmp17_;
	_tmp18_ = created_at;
	_tmp19_ = g_date_time_format (_tmp18_, "%x, %X");
	time_format = _tmp19_;
	_tmp20_ = with;
	if (_tmp20_ != NULL) {
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		_tmp21_ = time_format;
		_tmp22_ = with;
		_tmp23_ = g_strconcat (" via ", _tmp22_, NULL);
		_tmp24_ = _tmp23_;
		_tmp25_ = g_strconcat (_tmp21_, _tmp24_, NULL);
		_g_free0 (time_format);
		time_format = _tmp25_;
		_g_free0 (_tmp24_);
	}
	_tmp26_ = self->priv->text_label;
	_tmp27_ = tweet;
	_tmp28_ = cb_tweet_get_formatted_text (_tmp27_);
	_tmp29_ = _tmp28_;
	gtk_label_set_label (_tmp26_, _tmp29_);
	_g_free0 (_tmp29_);
	_tmp30_ = self->priv->name_button;
	_tmp31_ = tweet;
	_tmp32_ = cb_tweet_get_user_name (_tmp31_);
	text_button_set_markup (_tmp30_, _tmp32_);
	_tmp33_ = self->priv->screen_name_label;
	_tmp34_ = tweet;
	_tmp35_ = cb_tweet_get_screen_name (_tmp34_);
	_tmp36_ = g_strconcat ("@", _tmp35_, NULL);
	_tmp37_ = _tmp36_;
	gtk_label_set_label (_tmp33_, _tmp37_);
	_g_free0 (_tmp37_);
	_tmp38_ = tweet;
	_tmp39_ = _tmp38_->avatar_url;
	tweet_info_page_load_user_avatar (self, _tmp39_);
	tweet_info_page_update_rt_fav_labels (self);
	_tmp40_ = self->priv->time_label;
	_tmp41_ = time_format;
	gtk_label_set_label (_tmp40_, _tmp41_);
	_tmp42_ = self->priv->retweet_button;
	_tmp43_ = tweet;
	_tmp44_ = cb_tweet_is_flag_set (_tmp43_, (guint) CB_TWEET_STATE_RETWEETED);
	gtk_toggle_button_set_active (_tmp42_, _tmp44_);
	_tmp45_ = self->priv->favorite_button;
	_tmp46_ = tweet;
	_tmp47_ = cb_tweet_is_flag_set (_tmp46_, (guint) CB_TWEET_STATE_FAVORITED);
	gtk_toggle_button_set_active (_tmp45_, _tmp47_);
	_tmp48_ = self->priv->avatar_image;
	_tmp49_ = tweet;
	_tmp50_ = cb_tweet_is_flag_set (_tmp49_, (guint) CB_TWEET_STATE_VERIFIED);
	avatar_widget_set_verified (_tmp48_, _tmp50_);
	_tmp51_ = tweet;
	_tmp52_ = _tmp51_->id;
	_tmp53_ = tweet;
	_tmp54_ = cb_tweet_get_screen_name (_tmp53_);
	tweet_info_page_set_source_link (self, _tmp52_, _tmp54_);
	_tmp57_ = tweet;
	_tmp58_ = _tmp57_->retweeted_tweet;
	if (_tmp58_ != NULL) {
		CbTweet* _tmp59_;
		CbMiniTweet* _tmp60_;
		gint64 _tmp61_;
		_tmp59_ = tweet;
		_tmp60_ = _tmp59_->retweeted_tweet;
		_tmp61_ = (*_tmp60_).reply_id;
		_tmp56_ = _tmp61_ != ((gint64) 0);
	} else {
		_tmp56_ = FALSE;
	}
	if (_tmp56_) {
		_tmp55_ = TRUE;
	} else {
		CbTweet* _tmp62_;
		CbMiniTweet _tmp63_;
		gint64 _tmp64_;
		_tmp62_ = tweet;
		_tmp63_ = _tmp62_->source_tweet;
		_tmp64_ = _tmp63_.reply_id;
		_tmp55_ = _tmp64_ != ((gint64) 0);
	}
	if (_tmp55_) {
		CbUserIdentity* reply_users = NULL;
		CbTweet* _tmp65_;
		gint _tmp66_;
		CbUserIdentity* _tmp67_;
		CbUserIdentity* _tmp68_;
		gint _tmp68__length1;
		gint reply_users_length1;
		gint _reply_users_size_;
		GtkBox* _tmp69_;
		GString* buff = NULL;
		GString* _tmp70_;
		GString* _tmp71_;
		GString* _tmp72_;
		CbUserIdentity* _tmp73_;
		gint _tmp73__length1;
		GString* _tmp74_;
		CbUserIdentity* _tmp83_;
		gint _tmp83__length1;
		GtkLabel* _tmp90_;
		GString* _tmp91_;
		const gchar* _tmp92_;
		_tmp65_ = tweet;
		_tmp67_ = cb_tweet_get_reply_users (_tmp65_, &_tmp66_);
		_tmp68_ = (_tmp67_ != NULL) ? _vala_array_dup6 (_tmp67_, _tmp66_) : ((gpointer) _tmp67_);
		_tmp68__length1 = _tmp66_;
		reply_users = _tmp68_;
		reply_users_length1 = _tmp68__length1;
		_reply_users_size_ = reply_users_length1;
		_tmp69_ = self->priv->reply_box;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, gtk_widget_get_type (), GtkWidget));
		_tmp70_ = g_string_new ("");
		buff = _tmp70_;
		_tmp71_ = buff;
		g_string_append (_tmp71_, _ ("Replying to"));
		_tmp72_ = buff;
		g_string_append_c (_tmp72_, ' ');
		_tmp73_ = reply_users;
		_tmp73__length1 = reply_users_length1;
		_tmp74_ = buff;
		cb_utils_linkify_user (&_tmp73_[0], _tmp74_);
		{
			gint i = 0;
			i = 1;
			{
				gboolean _tmp75_ = FALSE;
				_tmp75_ = TRUE;
				while (TRUE) {
					gint _tmp77_;
					CbUserIdentity* _tmp78_;
					gint _tmp78__length1;
					GString* _tmp79_;
					CbUserIdentity* _tmp80_;
					gint _tmp80__length1;
					gint _tmp81_;
					GString* _tmp82_;
					if (!_tmp75_) {
						gint _tmp76_;
						_tmp76_ = i;
						i = _tmp76_ + 1;
					}
					_tmp75_ = FALSE;
					_tmp77_ = i;
					_tmp78_ = reply_users;
					_tmp78__length1 = reply_users_length1;
					if (!(_tmp77_ < (_tmp78__length1 - 1))) {
						break;
					}
					_tmp79_ = buff;
					g_string_append (_tmp79_, ", ");
					_tmp80_ = reply_users;
					_tmp80__length1 = reply_users_length1;
					_tmp81_ = i;
					_tmp82_ = buff;
					cb_utils_linkify_user (&_tmp80_[_tmp81_], _tmp82_);
				}
			}
		}
		_tmp83_ = reply_users;
		_tmp83__length1 = reply_users_length1;
		if (_tmp83__length1 > 1) {
			GString* _tmp84_;
			GString* _tmp85_;
			GString* _tmp86_;
			CbUserIdentity* _tmp87_;
			gint _tmp87__length1;
			CbUserIdentity* _tmp88_;
			gint _tmp88__length1;
			GString* _tmp89_;
			_tmp84_ = buff;
			_tmp85_ = g_string_append_c (_tmp84_, ' ');
			_tmp86_ = g_string_append (_tmp85_, _ ("and"));
			g_string_append_c (_tmp86_, ' ');
			_tmp87_ = reply_users;
			_tmp87__length1 = reply_users_length1;
			_tmp88_ = reply_users;
			_tmp88__length1 = reply_users_length1;
			_tmp89_ = buff;
			cb_utils_linkify_user (&_tmp87_[_tmp88__length1 - 1], _tmp89_);
		}
		_tmp90_ = self->priv->reply_label;
		_tmp91_ = buff;
		_tmp92_ = _tmp91_->str;
		gtk_label_set_label (_tmp90_, _tmp92_);
		_g_string_free0 (buff);
		reply_users = (_vala_CbUserIdentity_array_free (reply_users, reply_users_length1), NULL);
	} else {
		GtkBox* _tmp93_;
		_tmp93_ = self->priv->reply_box;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp93_, gtk_widget_get_type (), GtkWidget));
	}
	_tmp94_ = tweet;
	_tmp95_ = cb_tweet_has_inline_media (_tmp94_);
	if (_tmp95_) {
		MultiMediaWidget* _tmp96_;
		MediaVisibility _tmp97_;
		MultiMediaWidget* _tmp98_;
		CbTweet* _tmp99_;
		gint _tmp100_;
		CbMedia** _tmp101_;
		_tmp96_ = self->priv->mm_widget;
		_tmp97_ = settings_get_media_visiblity ();
		gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp96_, gtk_widget_get_type (), GtkWidget), _tmp97_ != MEDIA_VISIBILITY_HIDE);
		_tmp98_ = self->priv->mm_widget;
		_tmp99_ = tweet;
		_tmp101_ = cb_tweet_get_medias (_tmp99_, &_tmp100_);
		multi_media_widget_set_all_media (_tmp98_, _tmp101_, _tmp100_);
	} else {
		MultiMediaWidget* _tmp102_;
		_tmp102_ = self->priv->mm_widget;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp102_, gtk_widget_get_type (), GtkWidget));
	}
	_tmp103_ = self->priv->actions;
	_tmp104_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp103_, g_action_map_get_type (), GActionMap), "delete");
	_tmp105_ = tweet;
	_tmp106_ = cb_tweet_get_user_id (_tmp105_);
	_tmp107_ = self->account;
	_tmp108_ = _tmp107_->id;
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp104_, g_simple_action_get_type (), GSimpleAction), _tmp106_ == _tmp108_);
	_tmp109_ = tweet;
	_tmp110_ = cb_tweet_is_flag_set (_tmp109_, (guint) CB_TWEET_STATE_PROTECTED);
	if (_tmp110_) {
		GtkToggleButton* _tmp111_;
		GSimpleActionGroup* _tmp112_;
		GAction* _tmp113_;
		_tmp111_ = self->priv->retweet_button;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp111_, gtk_widget_get_type (), GtkWidget));
		_tmp112_ = self->priv->actions;
		_tmp113_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp112_, g_action_map_get_type (), GActionMap), "quote");
		g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp113_, g_simple_action_get_type (), GSimpleAction), FALSE);
	} else {
		GtkToggleButton* _tmp114_;
		GSimpleActionGroup* _tmp115_;
		GAction* _tmp116_;
		_tmp114_ = self->priv->retweet_button;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp114_, gtk_widget_get_type (), GtkWidget));
		_tmp115_ = self->priv->actions;
		_tmp116_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp115_, g_action_map_get_type (), GActionMap), "quote");
		g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp116_, g_simple_action_get_type (), GSimpleAction), TRUE);
	}
	_g_free0 (time_format);
	_g_date_time_unref0 (created_at);
}


static void tweet_info_page_update_rt_fav_labels (TweetInfoPage* self) {
	GtkLabel* _tmp0_;
	CbTweet* _tmp1_;
	gint _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GtkLabel* _tmp5_;
	CbTweet* _tmp6_;
	gint _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	g_return_if_fail (IS_TWEET_INFO_PAGE (self));
	_tmp0_ = self->priv->rt_label;
	_tmp1_ = self->priv->tweet;
	_tmp2_ = _tmp1_->retweet_count;
	_tmp3_ = g_strdup_printf ("<big><b>%'d</b></big> %s", _tmp2_, _ ("Retweets"));
	_tmp4_ = _tmp3_;
	gtk_label_set_label (_tmp0_, _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = self->priv->fav_label;
	_tmp6_ = self->priv->tweet;
	_tmp7_ = _tmp6_->favorite_count;
	_tmp8_ = g_strdup_printf ("<big><b>%'d</b></big> %s", _tmp7_, _ ("Favorites"));
	_tmp9_ = _tmp8_;
	gtk_label_set_label (_tmp5_, _tmp9_);
	_g_free0 (_tmp9_);
}


static void tweet_info_page_set_source_link (TweetInfoPage* self, gint64 id, const gchar* screen_name) {
	gchar* link = NULL;
	const gchar* _tmp0_;
	gint64 _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GtkLabel* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	g_return_if_fail (IS_TWEET_INFO_PAGE (self));
	g_return_if_fail (screen_name != NULL);
	_tmp0_ = screen_name;
	_tmp1_ = id;
	_tmp2_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("https://twitter.com/%s/status/%s", _tmp0_, _tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	link = _tmp5_;
	_tmp6_ = self->priv->source_label;
	_tmp7_ = g_strdup_printf ("<span underline='none'><a href='%s' title='%s'>%s</a></span>", link, _ ("Open in Browser"), _ ("Source"));
	_tmp8_ = _tmp7_;
	gtk_label_set_label (_tmp6_, _tmp8_);
	_g_free0 (_tmp8_);
	_g_free0 (link);
}


static void tweet_info_page_quote_activated (TweetInfoPage* self) {
	ComposeTweetWindow* ctw = NULL;
	MainWindow* _tmp0_;
	Account* _tmp1_;
	CbTweet* _tmp2_;
	ComposeTweetWindow* _tmp3_;
	g_return_if_fail (IS_TWEET_INFO_PAGE (self));
	_tmp0_ = self->priv->main_window;
	_tmp1_ = self->account;
	_tmp2_ = self->priv->tweet;
	_tmp3_ = compose_tweet_window_new (_tmp0_, _tmp1_, _tmp2_, COMPOSE_TWEET_WINDOW_MODE_QUOTE);
	g_object_ref_sink (_tmp3_);
	ctw = _tmp3_;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (ctw, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (ctw);
}


static void tweet_info_page_reply_activated (TweetInfoPage* self) {
	ComposeTweetWindow* ctw = NULL;
	MainWindow* _tmp0_;
	Account* _tmp1_;
	CbTweet* _tmp2_;
	ComposeTweetWindow* _tmp3_;
	g_return_if_fail (IS_TWEET_INFO_PAGE (self));
	_tmp0_ = self->priv->main_window;
	_tmp1_ = self->account;
	_tmp2_ = self->priv->tweet;
	_tmp3_ = compose_tweet_window_new (_tmp0_, _tmp1_, _tmp2_, COMPOSE_TWEET_WINDOW_MODE_REPLY);
	g_object_ref_sink (_tmp3_);
	ctw = _tmp3_;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (ctw, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (ctw);
}


static Block32Data* block32_data_ref (Block32Data* _data32_) {
	g_atomic_int_inc (&_data32_->_ref_count_);
	return _data32_;
}


static void block32_data_unref (void * _userdata_) {
	Block32Data* _data32_;
	_data32_ = (Block32Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data32_->_ref_count_)) {
		TweetInfoPage* self;
		self = _data32_->self;
		_g_object_unref0 (self);
		g_slice_free (Block32Data, _data32_);
	}
}


static void __lambda51_ (Block32Data* _data32_) {
	TweetInfoPage* self;
	GtkToggleButton* _tmp0_;
	GtkToggleButton* _tmp1_;
	gboolean _tmp2_;
	self = _data32_->self;
	_tmp0_ = self->priv->favorite_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget), TRUE);
	self->priv->values_set = FALSE;
	_tmp1_ = self->priv->favorite_button;
	_tmp2_ = _data32_->favoriting;
	gtk_toggle_button_set_active (_tmp1_, _tmp2_);
	self->priv->values_set = TRUE;
}


static void ___lambda51__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda51_ (self);
	block32_data_unref (self);
}


static void tweet_info_page_favorite_activated (TweetInfoPage* self) {
	Block32Data* _data32_;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	GtkToggleButton* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	GtkToggleButton* _tmp8_;
	Account* _tmp9_;
	CbTweet* _tmp10_;
	gboolean _tmp11_;
	g_return_if_fail (IS_TWEET_INFO_PAGE (self));
	_data32_ = g_slice_new0 (Block32Data);
	_data32_->_ref_count_ = 1;
	_data32_->self = g_object_ref (self);
	_tmp1_ = self->priv->values_set;
	if (!_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		GtkToggleButton* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = self->priv->favorite_button;
		_tmp3_ = gtk_widget_get_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget));
		_tmp4_ = _tmp3_;
		_tmp0_ = !_tmp4_;
	}
	if (_tmp0_) {
		block32_data_unref (_data32_);
		_data32_ = NULL;
		return;
	}
	_tmp5_ = self->priv->favorite_button;
	_tmp6_ = gtk_toggle_button_get_active (_tmp5_);
	_tmp7_ = _tmp6_;
	_data32_->favoriting = !_tmp7_;
	_tmp8_ = self->priv->favorite_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget), FALSE);
	tweet_info_page_update_rt_fav_labels (self);
	_tmp9_ = self->account;
	_tmp10_ = self->priv->tweet;
	_tmp11_ = _data32_->favoriting;
	tweet_utils_set_favorite_status (_tmp9_, _tmp10_, _tmp11_, ___lambda51__gasync_ready_callback, block32_data_ref (_data32_));
	block32_data_unref (_data32_);
	_data32_ = NULL;
}


static void __lambda53_ (TweetInfoPage* self) {
}


static void ___lambda53__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda53_ ((TweetInfoPage*) self);
	g_object_unref (self);
}


static void tweet_info_page_delete_activated (TweetInfoPage* self) {
	gboolean _tmp0_ = FALSE;
	CbTweet* _tmp1_;
	MainWindow* _tmp6_;
	MainWidget* _tmp7_;
	Account* _tmp8_;
	CbTweet* _tmp9_;
	g_return_if_fail (IS_TWEET_INFO_PAGE (self));
	_tmp1_ = self->priv->tweet;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		CbTweet* _tmp2_;
		gint64 _tmp3_;
		Account* _tmp4_;
		gint64 _tmp5_;
		_tmp2_ = self->priv->tweet;
		_tmp3_ = cb_tweet_get_user_id (_tmp2_);
		_tmp4_ = self->account;
		_tmp5_ = _tmp4_->id;
		_tmp0_ = _tmp3_ != _tmp5_;
	}
	if (_tmp0_) {
		return;
	}
	_tmp6_ = self->priv->main_window;
	_tmp7_ = _tmp6_->main_widget;
	main_widget_remove_current_page (_tmp7_);
	_tmp8_ = self->account;
	_tmp9_ = self->priv->tweet;
	tweet_utils_delete_tweet (_tmp8_, _tmp9_, ___lambda53__gasync_ready_callback, g_object_ref (self));
}


static gchar* tweet_info_page_real_get_title (IPage* base) {
	TweetInfoPage * self;
	gchar* result = NULL;
	gchar* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TWEET_INFO_PAGE, TweetInfoPage);
	_tmp0_ = g_strdup (_ ("Tweet Details"));
	result = _tmp0_;
	return result;
}


/**
   * Twitter's source parameter of tweets includes a 'rel' parameter
   * that doesn't work as pango markup, so we just remove it here.
   *
   * Example string:
   *   <a href=\"http://www.tweetdeck.com\" rel=\"nofollow\">TweetDeck</a>
   *
   * @param source_str The source string from twitter
   *
   * @return The #source_string without the rel parameter
   */
static gint string_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_;
	gunichar _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strchr (((gchar*) self) + _tmp0_, (gssize) -1, _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	glong _tmp8_;
	glong _tmp14_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	gchar* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_;
		glong _tmp4_;
		glong _tmp5_;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_;
		gint _tmp7_;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_;
		glong _tmp10_;
		glong _tmp11_;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_;
		glong _tmp13_;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gchar* tweet_info_page_extract_source (TweetInfoPage* self, const gchar* source_str) {
	gchar* result = NULL;
	gint from = 0;
	gint to = 0;
	gint tmp = 0;
	const gchar* _tmp0_;
	gint _tmp1_;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	const gchar* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	const gchar* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gboolean _tmp11_ = FALSE;
	gint _tmp12_;
	const gchar* _tmp16_;
	gint _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	const gchar* _tmp20_;
	gint _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	g_return_val_if_fail (IS_TWEET_INFO_PAGE (self), NULL);
	g_return_val_if_fail (source_str != NULL, NULL);
	tmp = 0;
	_tmp0_ = source_str;
	_tmp1_ = string_index_of_char (_tmp0_, (gunichar) '"', 0);
	tmp = _tmp1_;
	_tmp2_ = source_str;
	_tmp3_ = tmp;
	_tmp4_ = string_index_of_char (_tmp2_, (gunichar) '"', _tmp3_ + 1);
	tmp = _tmp4_;
	_tmp5_ = source_str;
	_tmp6_ = tmp;
	_tmp7_ = string_index_of_char (_tmp5_, (gunichar) '"', _tmp6_ + 1);
	from = _tmp7_;
	_tmp8_ = source_str;
	_tmp9_ = from;
	_tmp10_ = string_index_of_char (_tmp8_, (gunichar) '"', _tmp9_ + 1);
	to = _tmp10_;
	_tmp12_ = to;
	if (_tmp12_ == -1) {
		_tmp11_ = TRUE;
	} else {
		gint _tmp13_;
		_tmp13_ = from;
		_tmp11_ = _tmp13_ == -1;
	}
	if (_tmp11_) {
		const gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp14_ = source_str;
		_tmp15_ = g_strdup (_tmp14_);
		result = _tmp15_;
		return result;
	}
	_tmp16_ = source_str;
	_tmp17_ = from;
	_tmp18_ = string_substring (_tmp16_, (glong) 0, (glong) (_tmp17_ - 5));
	_tmp19_ = _tmp18_;
	_tmp20_ = source_str;
	_tmp21_ = to;
	_tmp22_ = string_substring (_tmp20_, (glong) (_tmp21_ + 1), (glong) -1);
	_tmp23_ = _tmp22_;
	_tmp24_ = g_strconcat (_tmp19_, _tmp23_, NULL);
	_tmp25_ = _tmp24_;
	_g_free0 (_tmp23_);
	_g_free0 (_tmp19_);
	result = _tmp25_;
	return result;
}


static void tweet_info_page_real_create_radio_button (IPage* base, GtkRadioButton* group) {
	TweetInfoPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TWEET_INFO_PAGE, TweetInfoPage);
	g_return_if_fail ((group == NULL) || GTK_IS_RADIO_BUTTON (group));
}


static GtkRadioButton* tweet_info_page_real_get_radio_button (IPage* base) {
	TweetInfoPage * self;
	GtkRadioButton* result = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TWEET_INFO_PAGE, TweetInfoPage);
	result = NULL;
	return result;
}


static void tweet_info_page_real_stream_message_received (CbMessageReceiver* base, CbStreamMessageType type, JsonNode* root) {
	TweetInfoPage * self;
	CbStreamMessageType _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TWEET_INFO_PAGE, TweetInfoPage);
	g_return_if_fail (root != NULL);
	_tmp0_ = type;
	if (_tmp0_ == CB_STREAM_MESSAGE_TWEET) {
		JsonObject* root_obj = NULL;
		JsonNode* _tmp1_;
		JsonObject* _tmp2_;
		JsonObject* _tmp3_;
		JsonObject* _tmp4_;
		gboolean _tmp5_;
		_tmp1_ = root;
		_tmp2_ = json_node_get_object (_tmp1_);
		_tmp3_ = _json_object_ref0 (_tmp2_);
		root_obj = _tmp3_;
		_tmp4_ = root_obj;
		_tmp5_ = utils_usable_json_value (_tmp4_, "in_reply_to_status_id");
		if (_tmp5_) {
			gint64 reply_id = 0LL;
			JsonObject* _tmp6_;
			gint64 _tmp7_;
			gint64 _tmp8_;
			gint64 _tmp9_;
			_tmp6_ = root_obj;
			_tmp7_ = json_object_get_int_member (_tmp6_, "in_reply_to_status_id");
			reply_id = _tmp7_;
			_tmp8_ = reply_id;
			_tmp9_ = self->priv->tweet_id;
			if (_tmp8_ == _tmp9_) {
				CbTweet* t = NULL;
				CbTweet* _tmp10_;
				CbTweet* _tmp11_;
				JsonNode* _tmp12_;
				Account* _tmp13_;
				gint64 _tmp14_;
				GDateTime* _tmp15_;
				GDateTime* _tmp16_;
				TweetListBox* _tmp17_;
				CbTweetModel* _tmp18_;
				CbTweet* _tmp19_;
				TweetListBox* _tmp20_;
				ReplyIndicator* _tmp21_;
				_tmp10_ = cb_tweet_new ();
				t = _tmp10_;
				_tmp11_ = t;
				_tmp12_ = root;
				_tmp13_ = self->account;
				_tmp14_ = _tmp13_->id;
				_tmp15_ = g_date_time_new_now_local ();
				_tmp16_ = _tmp15_;
				cb_tweet_load_from_json (_tmp11_, _tmp12_, _tmp14_, _tmp16_);
				_g_date_time_unref0 (_tmp16_);
				_tmp17_ = self->priv->top_list_box;
				_tmp18_ = _tmp17_->model;
				_tmp19_ = t;
				cb_tweet_model_add (_tmp18_, _tmp19_);
				_tmp20_ = self->priv->top_list_box;
				gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_widget_get_type (), GtkWidget));
				_tmp21_ = self->priv->reply_indicator;
				reply_indicator_set_replies_available (_tmp21_, TRUE);
				_g_object_unref0 (t);
			}
		}
		_json_object_unref0 (root_obj);
	} else {
		CbStreamMessageType _tmp22_;
		_tmp22_ = type;
		if (_tmp22_ == CB_STREAM_MESSAGE_DELETE) {
			gint64 tweet_id = 0LL;
			JsonNode* _tmp23_;
			JsonObject* _tmp24_;
			JsonObject* _tmp25_;
			JsonObject* _tmp26_;
			gint64 _tmp27_;
			gboolean _tmp28_ = FALSE;
			gint64 _tmp29_;
			gint64 _tmp30_;
			_tmp23_ = root;
			_tmp24_ = json_node_get_object (_tmp23_);
			_tmp25_ = json_object_get_object_member (_tmp24_, "delete");
			_tmp26_ = json_object_get_object_member (_tmp25_, "status");
			_tmp27_ = json_object_get_int_member (_tmp26_, "id");
			tweet_id = _tmp27_;
			_tmp29_ = tweet_id;
			_tmp30_ = self->priv->tweet_id;
			if (_tmp29_ == _tmp30_) {
				MainWindow* _tmp31_;
				gint _tmp32_;
				gint _tmp33_;
				gint _tmp34_;
				gint _tmp35_;
				_tmp31_ = self->priv->main_window;
				_tmp32_ = main_window_get_cur_page_id (_tmp31_);
				_tmp33_ = _tmp32_;
				_tmp34_ = ipage_get_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
				_tmp35_ = _tmp34_;
				_tmp28_ = _tmp33_ == _tmp35_;
			} else {
				_tmp28_ = FALSE;
			}
			if (_tmp28_) {
				gint64 _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				MainWindow* _tmp39_;
				MainWidget* _tmp40_;
				_tmp36_ = tweet_id;
				_tmp37_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp36_);
				_tmp38_ = _tmp37_;
				g_debug ("TweetInfoPage.vala:674: Current tweet with id %s deleted!", _tmp38_);
				_g_free0 (_tmp38_);
				_tmp39_ = self->priv->main_window;
				_tmp40_ = _tmp39_->main_widget;
				main_widget_remove_current_page (_tmp40_);
			}
		} else {
			CbStreamMessageType _tmp41_;
			_tmp41_ = type;
			if (_tmp41_ == CB_STREAM_MESSAGE_EVENT_FAVORITE) {
				gint64 id = 0LL;
				JsonNode* _tmp42_;
				JsonObject* _tmp43_;
				JsonObject* _tmp44_;
				gint64 _tmp45_;
				gint64 source_id = 0LL;
				JsonNode* _tmp46_;
				JsonObject* _tmp47_;
				JsonObject* _tmp48_;
				gint64 _tmp49_;
				gboolean _tmp50_ = FALSE;
				gint64 _tmp51_;
				Account* _tmp52_;
				gint64 _tmp53_;
				_tmp42_ = root;
				_tmp43_ = json_node_get_object (_tmp42_);
				_tmp44_ = json_object_get_object_member (_tmp43_, "target_object");
				_tmp45_ = json_object_get_int_member (_tmp44_, "id");
				id = _tmp45_;
				_tmp46_ = root;
				_tmp47_ = json_node_get_object (_tmp46_);
				_tmp48_ = json_object_get_object_member (_tmp47_, "source");
				_tmp49_ = json_object_get_int_member (_tmp48_, "id");
				source_id = _tmp49_;
				_tmp51_ = source_id;
				_tmp52_ = self->account;
				_tmp53_ = _tmp52_->id;
				if (_tmp51_ == _tmp53_) {
					gint64 _tmp54_;
					gint64 _tmp55_;
					_tmp54_ = id;
					_tmp55_ = self->priv->tweet_id;
					_tmp50_ = _tmp54_ == _tmp55_;
				} else {
					_tmp50_ = FALSE;
				}
				if (_tmp50_) {
					GtkToggleButton* _tmp56_;
					CbTweet* _tmp57_;
					gint _tmp58_;
					self->priv->values_set = FALSE;
					_tmp56_ = self->priv->favorite_button;
					gtk_toggle_button_set_active (_tmp56_, TRUE);
					_tmp57_ = self->priv->tweet;
					_tmp58_ = _tmp57_->favorite_count;
					_tmp57_->favorite_count = _tmp58_ + 1;
					tweet_info_page_update_rt_fav_labels (self);
					self->priv->values_set = TRUE;
				}
			} else {
				CbStreamMessageType _tmp59_;
				_tmp59_ = type;
				if (_tmp59_ == CB_STREAM_MESSAGE_EVENT_UNFAVORITE) {
					gint64 id = 0LL;
					JsonNode* _tmp60_;
					JsonObject* _tmp61_;
					JsonObject* _tmp62_;
					gint64 _tmp63_;
					gint64 source_id = 0LL;
					JsonNode* _tmp64_;
					JsonObject* _tmp65_;
					JsonObject* _tmp66_;
					gint64 _tmp67_;
					gboolean _tmp68_ = FALSE;
					gint64 _tmp69_;
					Account* _tmp70_;
					gint64 _tmp71_;
					_tmp60_ = root;
					_tmp61_ = json_node_get_object (_tmp60_);
					_tmp62_ = json_object_get_object_member (_tmp61_, "target_object");
					_tmp63_ = json_object_get_int_member (_tmp62_, "id");
					id = _tmp63_;
					_tmp64_ = root;
					_tmp65_ = json_node_get_object (_tmp64_);
					_tmp66_ = json_object_get_object_member (_tmp65_, "source");
					_tmp67_ = json_object_get_int_member (_tmp66_, "id");
					source_id = _tmp67_;
					_tmp69_ = source_id;
					_tmp70_ = self->account;
					_tmp71_ = _tmp70_->id;
					if (_tmp69_ == _tmp71_) {
						gint64 _tmp72_;
						gint64 _tmp73_;
						_tmp72_ = id;
						_tmp73_ = self->priv->tweet_id;
						_tmp68_ = _tmp72_ == _tmp73_;
					} else {
						_tmp68_ = FALSE;
					}
					if (_tmp68_) {
						GtkToggleButton* _tmp74_;
						CbTweet* _tmp75_;
						gint _tmp76_;
						self->priv->values_set = FALSE;
						_tmp74_ = self->priv->favorite_button;
						gtk_toggle_button_set_active (_tmp74_, FALSE);
						_tmp75_ = self->priv->tweet;
						_tmp76_ = _tmp75_->favorite_count;
						_tmp75_->favorite_count = _tmp76_ - 1;
						tweet_info_page_update_rt_fav_labels (self);
						self->priv->values_set = TRUE;
					}
				}
			}
		}
	}
}


gint tweet_info_page_get_unread_count (TweetInfoPage* self) {
	gint result;
	g_return_val_if_fail (IS_TWEET_INFO_PAGE (self), 0);
	result = 0;
	return result;
}


static gint tweet_info_page_real_get_id (IPage* base) {
	gint result;
	TweetInfoPage* self;
	gint _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TWEET_INFO_PAGE, TweetInfoPage);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}


static void tweet_info_page_real_set_id (IPage* base, gint value) {
	TweetInfoPage* self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TWEET_INFO_PAGE, TweetInfoPage);
	if (tweet_info_page_real_get_id (base) != value) {
		gint _tmp0_;
		_tmp0_ = value;
		self->priv->_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, tweet_info_page_properties[TWEET_INFO_PAGE_ID_PROPERTY]);
	}
}


static void tweet_info_page_real_set_window (IPage* base, MainWindow* value) {
	TweetInfoPage* self;
	MainWindow* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TWEET_INFO_PAGE, TweetInfoPage);
	_tmp0_ = value;
	self->priv->main_window = _tmp0_;
	g_object_notify_by_pspec ((GObject *) self, tweet_info_page_properties[TWEET_INFO_PAGE_WINDOW_PROPERTY]);
}


static void tweet_info_page_class_init (TweetInfoPageClass * klass) {
	gint TweetInfoPage_private_offset;
	tweet_info_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TweetInfoPagePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_tweet_info_page_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tweet_info_page_set_property;
	G_OBJECT_CLASS (klass)->finalize = tweet_info_page_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TWEET_INFO_PAGE_UNREAD_COUNT_PROPERTY, tweet_info_page_properties[TWEET_INFO_PAGE_UNREAD_COUNT_PROPERTY] = g_param_spec_int ("unread-count", "unread-count", "unread-count", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TWEET_INFO_PAGE_ID_PROPERTY, tweet_info_page_properties[TWEET_INFO_PAGE_ID_PROPERTY] = g_param_spec_int ("id", "id", "id", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TWEET_INFO_PAGE_WINDOW_PROPERTY, tweet_info_page_properties[TWEET_INFO_PAGE_WINDOW_PROPERTY] = g_param_spec_object ("window", "window", "window", TYPE_MAIN_WINDOW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	TweetInfoPage_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/baedert/corebird/ui/tweet-info-page.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "grid", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, grid));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "main_box", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, main_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "mm_widget", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, mm_widget));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "text_label", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, text_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "name_button", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, name_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "screen_name_label", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, screen_name_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "avatar_image", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, avatar_image));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "rt_label", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, rt_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "fav_label", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, fav_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "bottom_list_box", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, bottom_list_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "top_list_box", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, top_list_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "favorite_button", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, favorite_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "retweet_button", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, retweet_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "time_label", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, time_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "source_label", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, source_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "max_size_container", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, max_size_container));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "reply_indicator", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, reply_indicator));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "main_stack", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, main_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "error_label", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, error_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "reply_label", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, reply_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "reply_box", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, reply_box));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "favorite_button_toggled_cb", G_CALLBACK(_tweet_info_page_favorite_button_toggled_cb_gtk_toggle_button_toggled));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "retweet_button_toggled_cb", G_CALLBACK(_tweet_info_page_retweet_button_toggled_cb_gtk_toggle_button_toggled));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "reply_button_clicked_cb", G_CALLBACK(_tweet_info_page_reply_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "link_activated_cb", G_CALLBACK(_tweet_info_page_link_activated_cb_gtk_label_activate_link));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "name_button_clicked_cb", G_CALLBACK(_tweet_info_page_name_button_clicked_cb_gtk_button_clicked));
}


static void tweet_info_page_ipage_interface_init (IPageIface * iface) {
	tweet_info_page_ipage_parent_iface = g_type_interface_peek_parent (iface);
	iface->on_join = (void (*) (IPage *, gint, CbBundle*)) tweet_info_page_real_on_join;
	iface->on_leave = (void (*) (IPage *)) tweet_info_page_real_on_leave;
	iface->get_title = (gchar* (*) (IPage *)) tweet_info_page_real_get_title;
	iface->create_radio_button = (void (*) (IPage *, GtkRadioButton*)) tweet_info_page_real_create_radio_button;
	iface->get_radio_button = (GtkRadioButton* (*) (IPage *)) tweet_info_page_real_get_radio_button;
	iface->get_id = tweet_info_page_real_get_id;
	iface->set_id = tweet_info_page_real_set_id;
	iface->set_window = tweet_info_page_real_set_window;
}


static void tweet_info_page_cb_message_receiver_interface_init (CbMessageReceiverInterface * iface) {
	tweet_info_page_cb_message_receiver_parent_iface = g_type_interface_peek_parent (iface);
	iface->stream_message_received = (void (*) (CbMessageReceiver *, CbStreamMessageType, JsonNode*)) tweet_info_page_real_stream_message_received;
}


static void tweet_info_page_instance_init (TweetInfoPage * self) {
	self->priv = TWEET_INFO_PAGE_GET_PRIVATE (self);
	self->priv->values_set = FALSE;
	self->priv->cancellable = NULL;
	g_type_ensure (TYPE_MULTI_MEDIA_WIDGET);
	g_type_ensure (TYPE_TEXT_BUTTON);
	g_type_ensure (TYPE_AVATAR_WIDGET);
	g_type_ensure (TYPE_TWEET_LIST_BOX);
	g_type_ensure (TYPE_TWEET_LIST_BOX);
	g_type_ensure (TYPE_MAX_SIZE_CONTAINER);
	g_type_ensure (TYPE_REPLY_INDICATOR);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void tweet_info_page_finalize (GObject * obj) {
	TweetInfoPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TWEET_INFO_PAGE, TweetInfoPage);
	_g_free0 (self->priv->screen_name);
	_g_object_unref0 (self->priv->tweet);
	_g_object_unref0 (self->priv->actions);
	_g_object_unref0 (self->priv->cancellable);
	_g_object_unref0 (self->priv->grid);
	_g_object_unref0 (self->priv->main_box);
	_g_object_unref0 (self->priv->mm_widget);
	_g_object_unref0 (self->priv->text_label);
	_g_object_unref0 (self->priv->name_button);
	_g_object_unref0 (self->priv->screen_name_label);
	_g_object_unref0 (self->priv->avatar_image);
	_g_object_unref0 (self->priv->rt_label);
	_g_object_unref0 (self->priv->fav_label);
	_g_object_unref0 (self->priv->bottom_list_box);
	_g_object_unref0 (self->priv->top_list_box);
	_g_object_unref0 (self->priv->favorite_button);
	_g_object_unref0 (self->priv->retweet_button);
	_g_object_unref0 (self->priv->time_label);
	_g_object_unref0 (self->priv->source_label);
	_g_object_unref0 (self->priv->max_size_container);
	_g_object_unref0 (self->priv->reply_indicator);
	_g_object_unref0 (self->priv->main_stack);
	_g_object_unref0 (self->priv->error_label);
	_g_object_unref0 (self->priv->reply_label);
	_g_object_unref0 (self->priv->reply_box);
	G_OBJECT_CLASS (tweet_info_page_parent_class)->finalize (obj);
}


GType tweet_info_page_get_type (void) {
	static volatile gsize tweet_info_page_type_id__volatile = 0;
	if (g_once_init_enter (&tweet_info_page_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TweetInfoPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tweet_info_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TweetInfoPage), 0, (GInstanceInitFunc) tweet_info_page_instance_init, NULL };
		static const GInterfaceInfo ipage_info = { (GInterfaceInitFunc) tweet_info_page_ipage_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo cb_message_receiver_info = { (GInterfaceInitFunc) tweet_info_page_cb_message_receiver_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType tweet_info_page_type_id;
		tweet_info_page_type_id = g_type_register_static (TYPE_SCROLL_WIDGET, "TweetInfoPage", &g_define_type_info, 0);
		g_type_add_interface_static (tweet_info_page_type_id, TYPE_IPAGE, &ipage_info);
		g_type_add_interface_static (tweet_info_page_type_id, CB_TYPE_MESSAGE_RECEIVER, &cb_message_receiver_info);
		g_once_init_leave (&tweet_info_page_type_id__volatile, tweet_info_page_type_id);
	}
	return tweet_info_page_type_id__volatile;
}


static void _vala_tweet_info_page_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TweetInfoPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TWEET_INFO_PAGE, TweetInfoPage);
	switch (property_id) {
		case TWEET_INFO_PAGE_UNREAD_COUNT_PROPERTY:
		g_value_set_int (value, tweet_info_page_get_unread_count (self));
		break;
		case TWEET_INFO_PAGE_ID_PROPERTY:
		g_value_set_int (value, ipage_get_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage)));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_tweet_info_page_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TweetInfoPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TWEET_INFO_PAGE, TweetInfoPage);
	switch (property_id) {
		case TWEET_INFO_PAGE_ID_PROPERTY:
		ipage_set_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_int (value));
		break;
		case TWEET_INFO_PAGE_WINDOW_PROPERTY:
		ipage_set_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



