// auto generated tests from cfg/windows.cfg
//
// Generated by command:
// ./generate_cfg_tests cfg/windows.cfg > generated-cfg-tests-windows.cpp
//
// Recommended cppcheck command line:
// $ cppcheck --enable=warning,information --inline-suppr --platform=unix64 generated-cfg-tests-windows.cpp
// => 'unmatched suppression' warnings are false negatives.
//

void test__RtlCompareMemory__noreturn() {
  int x = 1;
  if (cond) { x=100; result = RtlCompareMemory(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__RtlCompareMemory__useretval() {
  // cppcheck-suppress ignoredReturnValue
  RtlCompareMemory(arg1, arg2, arg3);
}

void test__RtlCompareMemory__leakignore() {
  char *p = malloc(10); *p=0;
  result = RtlCompareMemory(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__RtlCompareMemory__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = RtlCompareMemory(NULL, arg2, arg3);
}

void test__RtlCompareMemory__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = RtlCompareMemory(x, arg2, arg3);
}

void test__RtlCompareMemory__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = RtlCompareMemory(arg1, NULL, arg3);
}

void test__RtlCompareMemory__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = RtlCompareMemory(arg1, x, arg3);
}

void test__RtlCompareMemory__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  result = RtlCompareMemory(arg1, arg2, !x);
}

void test__RtlCopyBytes__noreturn() {
  int x = 1;
  if (cond) { x=100; RtlCopyBytes(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__RtlCopyBytes__leakignore() {
  char *p = malloc(10); *p=0;
  RtlCopyBytes(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__RtlCopyBytes__arg1__notnull() {
  // cppcheck-suppress nullPointer
  RtlCopyBytes(NULL, arg2, arg3);
}

void test__RtlCopyBytes__arg2__notnull() {
  // cppcheck-suppress nullPointer
  RtlCopyBytes(arg1, NULL, arg3);
}

void test__RtlCopyBytes__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  RtlCopyBytes(arg1, x, arg3);
}

void test__RtlCopyBytes__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  RtlCopyBytes(arg1, arg2, !x);
}

void test__RtlFillBytes__noreturn() {
  int x = 1;
  if (cond) { x=100; RtlFillBytes(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__RtlFillBytes__leakignore() {
  char *p = malloc(10); *p=0;
  RtlFillBytes(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__RtlFillBytes__arg1__notnull() {
  // cppcheck-suppress nullPointer
  RtlFillBytes(NULL, arg2, arg3);
}

void test__RtlFillBytes__arg2__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  RtlFillBytes(arg1, !x, arg3);
}

void test__RtlFillBytes__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  RtlFillBytes(arg1, arg2, x);
}

void test__RtlSecureZeroMemory__noreturn() {
  int x = 1;
  if (cond) { x=100; RtlSecureZeroMemory(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__RtlSecureZeroMemory__leakignore() {
  char *p = malloc(10); *p=0;
  RtlSecureZeroMemory(p, arg2);
  // cppcheck-suppress memleak
}

void test__RtlSecureZeroMemory__arg1__notnull() {
  // cppcheck-suppress nullPointer
  RtlSecureZeroMemory(NULL, arg2);
}

void test__RtlSecureZeroMemory__arg2__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  RtlSecureZeroMemory(arg1, !x);
}

void test__RtlZeroBytes__noreturn() {
  int x = 1;
  if (cond) { x=100; RtlZeroBytes(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__RtlZeroBytes__leakignore() {
  char *p = malloc(10); *p=0;
  RtlZeroBytes(p, arg2);
  // cppcheck-suppress memleak
}

void test__RtlZeroBytes__arg1__notnull() {
  // cppcheck-suppress nullPointer
  RtlZeroBytes(NULL, arg2);
}

void test__RtlZeroBytes__arg2__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  RtlZeroBytes(arg1, !x);
}

void test__KeBugCheck__noreturn() {
  int x = 1;
  if (cond) { x=100; KeBugCheck(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__KeBugCheckEx__noreturn() {
  int x = 1;
  if (cond) { x=100; KeBugCheckEx(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__CString__Format__noreturn() {
  int x = 1;
  if (cond) { x=100; CString::Format(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__CString__Format__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CString::Format(x);
}

void test__CString__AppendFormat__noreturn() {
  int x = 1;
  if (cond) { x=100; CString::AppendFormat(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__CString__AppendFormat__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CString::AppendFormat(x);
}

void test__printf_s__noreturn() {
  int x = 1;
  if (cond) { x=100; printf_s(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__printf_s__leakignore() {
  char *p = malloc(10); *p=0;
  printf_s(p);
  // cppcheck-suppress memleak
}

void test__printf_s__arg1__notnull() {
  // cppcheck-suppress nullPointer
  printf_s(NULL);
}

void test__printf_s__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  printf_s(x);
}

void test__wprintf_s__noreturn() {
  int x = 1;
  if (cond) { x=100; wprintf_s(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__wprintf_s__leakignore() {
  char *p = malloc(10); *p=0;
  wprintf_s(p);
  // cppcheck-suppress memleak
}

void test__wprintf_s__arg1__notnull() {
  // cppcheck-suppress nullPointer
  wprintf_s(NULL);
}

void test__wprintf_s__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  wprintf_s(x);
}

void test__fprintf_s__noreturn() {
  int x = 1;
  if (cond) { x=100; fprintf_s(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fprintf_s__leakignore() {
  char *p = malloc(10); *p=0;
  fprintf_s(p, arg2);
  // cppcheck-suppress memleak
}

void test__fprintf_s__arg2__notnull() {
  // cppcheck-suppress nullPointer
  fprintf_s(arg1, NULL);
}

void test__fprintf_s__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  fprintf_s(arg1, x);
}

void test__fwprintf_s__noreturn() {
  int x = 1;
  if (cond) { x=100; fwprintf_s(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fwprintf_s__leakignore() {
  char *p = malloc(10); *p=0;
  fwprintf_s(p, arg2);
  // cppcheck-suppress memleak
}

void test__fwprintf_s__arg2__notnull() {
  // cppcheck-suppress nullPointer
  fwprintf_s(arg1, NULL);
}

void test__fwprintf_s__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  fwprintf_s(arg1, x);
}

void test___snprintf_s__noreturn() {
  int x = 1;
  if (cond) { x=100; _snprintf_s(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___snprintf_s__leakignore() {
  char *p = malloc(10); *p=0;
  _snprintf_s(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test___snprintf_s__arg4__notnull() {
  // cppcheck-suppress nullPointer
  _snprintf_s(arg1, arg2, arg3, NULL);
}

void test___snprintf_s__arg4__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _snprintf_s(arg1, arg2, arg3, x);
}

void test___snwprintf_s__noreturn() {
  int x = 1;
  if (cond) { x=100; _snwprintf_s(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___snwprintf_s__leakignore() {
  char *p = malloc(10); *p=0;
  _snwprintf_s(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test___snwprintf_s__arg4__notnull() {
  // cppcheck-suppress nullPointer
  _snwprintf_s(arg1, arg2, arg3, NULL);
}

void test___snwprintf_s__arg4__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _snwprintf_s(arg1, arg2, arg3, x);
}

void test__DbgPrint__noreturn() {
  int x = 1;
  if (cond) { x=100; DbgPrint(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__DbgPrint__leakignore() {
  char *p = malloc(10); *p=0;
  DbgPrint(p);
  // cppcheck-suppress memleak
}

void test__DbgPrint__arg1__notnull() {
  // cppcheck-suppress nullPointer
  DbgPrint(NULL);
}

void test__DbgPrint__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  DbgPrint(x);
}

void test__DbgPrintEx__noreturn() {
  int x = 1;
  if (cond) { x=100; DbgPrintEx(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__DbgPrintEx__leakignore() {
  char *p = malloc(10); *p=0;
  DbgPrintEx(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__DbgPrintEx__arg3__notnull() {
  // cppcheck-suppress nullPointer
  DbgPrintEx(arg1, arg2, NULL);
}

void test__DbgPrintEx__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  DbgPrintEx(arg1, arg2, x);
}

void test__vDbgPrintEx__noreturn() {
  int x = 1;
  if (cond) { x=100; vDbgPrintEx(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__vDbgPrintEx__leakignore() {
  char *p = malloc(10); *p=0;
  vDbgPrintEx(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__vDbgPrintEx__arg3__notnull() {
  // cppcheck-suppress nullPointer
  vDbgPrintEx(arg1, arg2, NULL);
}

void test__vDbgPrintEx__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  vDbgPrintEx(arg1, arg2, x);
}

void test__vDbgPrintExWithPrefix__noreturn() {
  int x = 1;
  if (cond) { x=100; vDbgPrintExWithPrefix(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__vDbgPrintExWithPrefix__leakignore() {
  char *p = malloc(10); *p=0;
  vDbgPrintExWithPrefix(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test__vDbgPrintExWithPrefix__arg4__notnull() {
  // cppcheck-suppress nullPointer
  vDbgPrintExWithPrefix(arg1, arg2, arg3, NULL);
}

void test__vDbgPrintExWithPrefix__arg4__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  vDbgPrintExWithPrefix(arg1, arg2, arg3, x);
}

void test__scanf_s__noreturn() {
  int x = 1;
  if (cond) { x=100; scanf_s(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__scanf_s__arg1__notnull() {
  // cppcheck-suppress nullPointer
  scanf_s(NULL);
}

void test__scanf_s__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  scanf_s(x);
}

void test__wscanf_s__noreturn() {
  int x = 1;
  if (cond) { x=100; wscanf_s(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__wscanf_s__arg1__notnull() {
  // cppcheck-suppress nullPointer
  wscanf_s(NULL);
}

void test__wscanf_s__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  wscanf_s(x);
}

void test__sscanf_s__noreturn() {
  int x = 1;
  if (cond) { x=100; sscanf_s(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__sscanf_s__arg2__notnull() {
  // cppcheck-suppress nullPointer
  sscanf_s(arg1, NULL);
}

void test__sscanf_s__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  sscanf_s(arg1, x);
}

void test__fscanf_s__noreturn() {
  int x = 1;
  if (cond) { x=100; fscanf_s(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fscanf_s__arg2__notnull() {
  // cppcheck-suppress nullPointer
  fscanf_s(arg1, NULL);
}

void test__fscanf_s__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  fscanf_s(arg1, x);
}

void test__fwscanf_s__noreturn() {
  int x = 1;
  if (cond) { x=100; fwscanf_s(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fwscanf_s__arg2__notnull() {
  // cppcheck-suppress nullPointer
  fwscanf_s(arg1, NULL);
}

void test__fwscanf_s__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  fwscanf_s(arg1, x);
}

void test__swscanf_s__noreturn() {
  int x = 1;
  if (cond) { x=100; swscanf_s(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__swscanf_s__arg2__notnull() {
  // cppcheck-suppress nullPointer
  swscanf_s(arg1, NULL);
}

void test__swscanf_s__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  swscanf_s(arg1, x);
}

void test__CloseHandle__noreturn() {
  int x = 1;
  if (cond) { x=100; CloseHandle(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__CloseHandle__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CloseHandle(x);
}

void test__OpenFile__noreturn() {
  int x = 1;
  if (cond) { x=100; OpenFile(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__OpenFile__arg1__notnull() {
  // cppcheck-suppress nullPointer
  OpenFile(NULL, arg2, arg3);
}

void test__OpenFile__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  OpenFile(x, arg2, arg3);
}

void test__OpenFile__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  OpenFile(arg1, arg2, x);
}

void test__BuildCommDCB__noreturn() {
  int x = 1;
  if (cond) { x=100; BuildCommDCB(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__BuildCommDCB__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  BuildCommDCB(x, arg2);
}

void test__BuildCommDCBAndTimeouts__noreturn() {
  int x = 1;
  if (cond) { x=100; BuildCommDCBAndTimeouts(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__BuildCommDCBAndTimeouts__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  BuildCommDCBAndTimeouts(x, arg2, arg3);
}

void test__WriteFile__noreturn() {
  int x = 1;
  if (cond) { x=100; WriteFile(arg1, arg2, arg3, arg4, arg5); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__WriteFile__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  WriteFile(x, arg2, arg3, arg4, arg5);
}

void test__WriteFile__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  WriteFile(arg1, x, arg3, arg4, arg5);
}

void test__WriteFile__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  WriteFile(arg1, arg2, x, arg4, arg5);
}

void test__ReadFile__noreturn() {
  int x = 1;
  if (cond) { x=100; ReadFile(arg1, arg2, arg3, arg4, arg5); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__ReadFile__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  ReadFile(x, arg2, arg3, arg4, arg5);
}

void test__ReadFile__arg2__notnull() {
  // cppcheck-suppress nullPointer
  ReadFile(arg1, NULL, arg3, arg4, arg5);
}

void test__ReadFile__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  ReadFile(arg1, arg2, x, arg4, arg5);
}

void test__CreateFile__noreturn() {
  int x = 1;
  if (cond) { x=100; CreateFile(arg1, arg2, arg3, arg4, arg5, arg6, arg7); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__CreateFile__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateFile(x, arg2, arg3, arg4, arg5, arg6, arg7);
}

void test__CreateFile__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateFile(arg1, x, arg3, arg4, arg5, arg6, arg7);
}

void test__CreateFile__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateFile(arg1, arg2, x, arg4, arg5, arg6, arg7);
}

void test__CreateFile__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateFile(arg1, arg2, arg3, x, arg5, arg6, arg7);
}

void test__CreateFile__arg5__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateFile(arg1, arg2, arg3, arg4, x, arg6, arg7);
}

void test__CreateFile__arg6__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateFile(arg1, arg2, arg3, arg4, arg5, x, arg7);
}

void test__CreateFile__arg7__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateFile(arg1, arg2, arg3, arg4, arg5, arg6, x);
}

void test__SetCommTimeouts__noreturn() {
  int x = 1;
  if (cond) { x=100; SetCommTimeouts(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__SetCommTimeouts__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  SetCommTimeouts(x, arg2);
}

void test__SetCommTimeouts__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  SetCommTimeouts(arg1, x);
}

void test__SetCommState__noreturn() {
  int x = 1;
  if (cond) { x=100; SetCommState(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__SetCommState__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  SetCommState(x, arg2);
}

void test__SetCommState__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  SetCommState(arg1, x);
}

void test___mbstok__noreturn() {
  int x = 1;
  if (cond) { x=100; _mbstok(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___mbstok__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((_mbstok(arg1, arg2) > 10) || (_mbstok(arg1, arg2) < 100)) {}
}

void test___mbstok__leakignore() {
  char *p = malloc(10); *p=0;
  _mbstok(p, arg2);
  // cppcheck-suppress memleak
}

void test___mbstok__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _mbstok(x, arg2);
}

void test___mbstok__arg2__notnull() {
  // cppcheck-suppress nullPointer
  _mbstok(arg1, NULL);
}

void test___mbstok__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _mbstok(arg1, x);
}

void test___tcstok__noreturn() {
  int x = 1;
  if (cond) { x=100; _tcstok(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___tcstok__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((_tcstok(arg1, arg2) > 10) || (_tcstok(arg1, arg2) < 100)) {}
}

void test___tcstok__leakignore() {
  char *p = malloc(10); *p=0;
  _tcstok(p, arg2);
  // cppcheck-suppress memleak
}

void test___tcstok__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _tcstok(x, arg2);
}

void test___tcstok__arg2__notnull() {
  // cppcheck-suppress nullPointer
  _tcstok(arg1, NULL);
}

void test___tcstok__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _tcstok(arg1, x);
}

void test___mbstok_l__noreturn() {
  int x = 1;
  if (cond) { x=100; _mbstok_l(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___mbstok_l__pure(int arg1,int arg2,int arg3) {
  // cppcheck-suppress incorrectLogicOperator
  if ((_mbstok_l(arg1, arg2, arg3) > 10) || (_mbstok_l(arg1, arg2, arg3) < 100)) {}
}

void test___mbstok_l__leakignore() {
  char *p = malloc(10); *p=0;
  _mbstok_l(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test___mbstok_l__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _mbstok_l(x, arg2, arg3);
}

void test___mbstok_l__arg2__notnull() {
  // cppcheck-suppress nullPointer
  _mbstok_l(arg1, NULL, arg3);
}

void test___mbstok_l__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _mbstok_l(arg1, x, arg3);
}

void test___mbstok_l__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _mbstok_l(arg1, arg2, x);
}

void test___strtok_s_l__noreturn() {
  int x = 1;
  if (cond) { x=100; _strtok_s_l(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___strtok_s_l__pure(int arg1,int arg2,int arg3,int arg4) {
  // cppcheck-suppress incorrectLogicOperator
  if ((_strtok_s_l(arg1, arg2, arg3, arg4) > 10) || (_strtok_s_l(arg1, arg2, arg3, arg4) < 100)) {}
}

void test___strtok_s_l__leakignore() {
  char *p = malloc(10); *p=0;
  _strtok_s_l(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test___strtok_s_l__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _strtok_s_l(x, arg2, arg3, arg4);
}

void test___strtok_s_l__arg2__notnull() {
  // cppcheck-suppress nullPointer
  _strtok_s_l(arg1, NULL, arg3, arg4);
}

void test___strtok_s_l__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _strtok_s_l(arg1, x, arg3, arg4);
}

void test___strtok_s_l__arg3__notnull() {
  // cppcheck-suppress nullPointer
  _strtok_s_l(arg1, arg2, NULL, arg4);
}

void test___strtok_s_l__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _strtok_s_l(arg1, arg2, arg3, x);
}

void test___wcstok_s_l__noreturn() {
  int x = 1;
  if (cond) { x=100; _wcstok_s_l(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___wcstok_s_l__pure(int arg1,int arg2,int arg3,int arg4) {
  // cppcheck-suppress incorrectLogicOperator
  if ((_wcstok_s_l(arg1, arg2, arg3, arg4) > 10) || (_wcstok_s_l(arg1, arg2, arg3, arg4) < 100)) {}
}

void test___wcstok_s_l__leakignore() {
  char *p = malloc(10); *p=0;
  _wcstok_s_l(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test___wcstok_s_l__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _wcstok_s_l(x, arg2, arg3, arg4);
}

void test___wcstok_s_l__arg2__notnull() {
  // cppcheck-suppress nullPointer
  _wcstok_s_l(arg1, NULL, arg3, arg4);
}

void test___wcstok_s_l__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _wcstok_s_l(arg1, x, arg3, arg4);
}

void test___wcstok_s_l__arg3__notnull() {
  // cppcheck-suppress nullPointer
  _wcstok_s_l(arg1, arg2, NULL, arg4);
}

void test___wcstok_s_l__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _wcstok_s_l(arg1, arg2, arg3, x);
}

void test___mbstok_s_l__noreturn() {
  int x = 1;
  if (cond) { x=100; _mbstok_s_l(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___mbstok_s_l__pure(int arg1,int arg2,int arg3,int arg4) {
  // cppcheck-suppress incorrectLogicOperator
  if ((_mbstok_s_l(arg1, arg2, arg3, arg4) > 10) || (_mbstok_s_l(arg1, arg2, arg3, arg4) < 100)) {}
}

void test___mbstok_s_l__leakignore() {
  char *p = malloc(10); *p=0;
  _mbstok_s_l(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test___mbstok_s_l__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _mbstok_s_l(x, arg2, arg3, arg4);
}

void test___mbstok_s_l__arg2__notnull() {
  // cppcheck-suppress nullPointer
  _mbstok_s_l(arg1, NULL, arg3, arg4);
}

void test___mbstok_s_l__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _mbstok_s_l(arg1, x, arg3, arg4);
}

void test___mbstok_s_l__arg3__notnull() {
  // cppcheck-suppress nullPointer
  _mbstok_s_l(arg1, arg2, NULL, arg4);
}

void test___mbstok_s_l__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _mbstok_s_l(arg1, arg2, arg3, x);
}

void test___tcstok_s_l__noreturn() {
  int x = 1;
  if (cond) { x=100; _tcstok_s_l(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___tcstok_s_l__pure(int arg1,int arg2,int arg3,int arg4) {
  // cppcheck-suppress incorrectLogicOperator
  if ((_tcstok_s_l(arg1, arg2, arg3, arg4) > 10) || (_tcstok_s_l(arg1, arg2, arg3, arg4) < 100)) {}
}

void test___tcstok_s_l__leakignore() {
  char *p = malloc(10); *p=0;
  _tcstok_s_l(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test___tcstok_s_l__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _tcstok_s_l(x, arg2, arg3, arg4);
}

void test___tcstok_s_l__arg2__notnull() {
  // cppcheck-suppress nullPointer
  _tcstok_s_l(arg1, NULL, arg3, arg4);
}

void test___tcstok_s_l__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _tcstok_s_l(arg1, x, arg3, arg4);
}

void test___tcstok_s_l__arg3__notnull() {
  // cppcheck-suppress nullPointer
  _tcstok_s_l(arg1, arg2, NULL, arg4);
}

void test___tcstok_s_l__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _tcstok_s_l(arg1, arg2, arg3, x);
}

void test__strtok_s__noreturn() {
  int x = 1;
  if (cond) { x=100; strtok_s(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__strtok_s__pure(int arg1,int arg2,int arg3) {
  // cppcheck-suppress incorrectLogicOperator
  if ((strtok_s(arg1, arg2, arg3) > 10) || (strtok_s(arg1, arg2, arg3) < 100)) {}
}

void test__strtok_s__leakignore() {
  char *p = malloc(10); *p=0;
  strtok_s(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__strtok_s__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  strtok_s(x, arg2, arg3);
}

void test__strtok_s__arg2__notnull() {
  // cppcheck-suppress nullPointer
  strtok_s(arg1, NULL, arg3);
}

void test__strtok_s__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  strtok_s(arg1, x, arg3);
}

void test__strtok_s__arg3__notnull() {
  // cppcheck-suppress nullPointer
  strtok_s(arg1, arg2, NULL);
}

void test__wcstok_s__noreturn() {
  int x = 1;
  if (cond) { x=100; wcstok_s(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__wcstok_s__pure(int arg1,int arg2,int arg3) {
  // cppcheck-suppress incorrectLogicOperator
  if ((wcstok_s(arg1, arg2, arg3) > 10) || (wcstok_s(arg1, arg2, arg3) < 100)) {}
}

void test__wcstok_s__leakignore() {
  char *p = malloc(10); *p=0;
  wcstok_s(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__wcstok_s__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  wcstok_s(x, arg2, arg3);
}

void test__wcstok_s__arg2__notnull() {
  // cppcheck-suppress nullPointer
  wcstok_s(arg1, NULL, arg3);
}

void test__wcstok_s__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  wcstok_s(arg1, x, arg3);
}

void test__wcstok_s__arg3__notnull() {
  // cppcheck-suppress nullPointer
  wcstok_s(arg1, arg2, NULL);
}

void test___mbstok_s__noreturn() {
  int x = 1;
  if (cond) { x=100; _mbstok_s(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___mbstok_s__pure(int arg1,int arg2,int arg3) {
  // cppcheck-suppress incorrectLogicOperator
  if ((_mbstok_s(arg1, arg2, arg3) > 10) || (_mbstok_s(arg1, arg2, arg3) < 100)) {}
}

void test___mbstok_s__leakignore() {
  char *p = malloc(10); *p=0;
  _mbstok_s(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test___mbstok_s__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _mbstok_s(x, arg2, arg3);
}

void test___mbstok_s__arg2__notnull() {
  // cppcheck-suppress nullPointer
  _mbstok_s(arg1, NULL, arg3);
}

void test___mbstok_s__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _mbstok_s(arg1, x, arg3);
}

void test___mbstok_s__arg3__notnull() {
  // cppcheck-suppress nullPointer
  _mbstok_s(arg1, arg2, NULL);
}

void test___tcstok_s__noreturn() {
  int x = 1;
  if (cond) { x=100; _tcstok_s(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___tcstok_s__pure(int arg1,int arg2,int arg3) {
  // cppcheck-suppress incorrectLogicOperator
  if ((_tcstok_s(arg1, arg2, arg3) > 10) || (_tcstok_s(arg1, arg2, arg3) < 100)) {}
}

void test___tcstok_s__leakignore() {
  char *p = malloc(10); *p=0;
  _tcstok_s(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test___tcstok_s__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _tcstok_s(x, arg2, arg3);
}

void test___tcstok_s__arg2__notnull() {
  // cppcheck-suppress nullPointer
  _tcstok_s(arg1, NULL, arg3);
}

void test___tcstok_s__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _tcstok_s(arg1, x, arg3);
}

void test___tcstok_s__arg3__notnull() {
  // cppcheck-suppress nullPointer
  _tcstok_s(arg1, arg2, NULL);
}

void test___getcwd__noreturn() {
  int x = 1;
  if (cond) { x=100; _getcwd(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___getcwd__leakignore() {
  char *p = malloc(10); *p=0;
  _getcwd(p, arg2);
  // cppcheck-suppress memleak
}

void test___getcwd__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _getcwd(x, arg2);
}

void test___getcwd__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _getcwd(arg1, x);
}

void test___wgetcwd__noreturn() {
  int x = 1;
  if (cond) { x=100; _wgetcwd(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___wgetcwd__leakignore() {
  char *p = malloc(10); *p=0;
  _wgetcwd(p, arg2);
  // cppcheck-suppress memleak
}

void test___wgetcwd__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _wgetcwd(x, arg2);
}

void test___wgetcwd__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _wgetcwd(arg1, x);
}

void test__SHGetFolderPath__noreturn() {
  int x = 1;
  if (cond) { x=100; SHGetFolderPath(arg1, arg2, arg3, arg4, arg5); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__SHGetFolderPath__leakignore() {
  char *p = malloc(10); *p=0;
  SHGetFolderPath(p, arg2, arg3, arg4, arg5);
  // cppcheck-suppress memleak
}

void test__SHGetFolderPath__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  SHGetFolderPath(x, arg2, arg3, arg4, arg5);
}

void test__SHGetFolderPath__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  SHGetFolderPath(arg1, x, arg3, arg4, arg5);
}

void test__SHGetFolderPath__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  SHGetFolderPath(arg1, arg2, x, arg4, arg5);
}

void test__SHGetFolderPath__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  SHGetFolderPath(arg1, arg2, arg3, x, arg5);
}

void test__SHGetFolderPath__arg5__notnull() {
  // cppcheck-suppress nullPointer
  SHGetFolderPath(arg1, arg2, arg3, arg4, NULL);
}

void test__SHGetFolderPathA__noreturn() {
  int x = 1;
  if (cond) { x=100; SHGetFolderPathA(arg1, arg2, arg3, arg4, arg5); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__SHGetFolderPathA__leakignore() {
  char *p = malloc(10); *p=0;
  SHGetFolderPathA(p, arg2, arg3, arg4, arg5);
  // cppcheck-suppress memleak
}

void test__SHGetFolderPathA__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  SHGetFolderPathA(x, arg2, arg3, arg4, arg5);
}

void test__SHGetFolderPathA__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  SHGetFolderPathA(arg1, x, arg3, arg4, arg5);
}

void test__SHGetFolderPathA__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  SHGetFolderPathA(arg1, arg2, x, arg4, arg5);
}

void test__SHGetFolderPathA__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  SHGetFolderPathA(arg1, arg2, arg3, x, arg5);
}

void test__SHGetFolderPathA__arg5__notnull() {
  // cppcheck-suppress nullPointer
  SHGetFolderPathA(arg1, arg2, arg3, arg4, NULL);
}

void test__SHGetFolderPathW__noreturn() {
  int x = 1;
  if (cond) { x=100; SHGetFolderPathW(arg1, arg2, arg3, arg4, arg5); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__SHGetFolderPathW__leakignore() {
  char *p = malloc(10); *p=0;
  SHGetFolderPathW(p, arg2, arg3, arg4, arg5);
  // cppcheck-suppress memleak
}

void test__SHGetFolderPathW__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  SHGetFolderPathW(x, arg2, arg3, arg4, arg5);
}

void test__SHGetFolderPathW__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  SHGetFolderPathW(arg1, x, arg3, arg4, arg5);
}

void test__SHGetFolderPathW__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  SHGetFolderPathW(arg1, arg2, x, arg4, arg5);
}

void test__SHGetFolderPathW__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  SHGetFolderPathW(arg1, arg2, arg3, x, arg5);
}

void test__SHGetFolderPathW__arg5__notnull() {
  // cppcheck-suppress nullPointer
  SHGetFolderPathW(arg1, arg2, arg3, arg4, NULL);
}

void test__RegQueryValueEx__noreturn() {
  int x = 1;
  if (cond) { x=100; RegQueryValueEx(arg1, arg2, arg3, arg4, arg5, arg6); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__RegQueryValueEx__leakignore() {
  char *p = malloc(10); *p=0;
  RegQueryValueEx(p, arg2, arg3, arg4, arg5, arg6);
  // cppcheck-suppress memleak
}

void test__RegQueryValueEx__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  RegQueryValueEx(x, arg2, arg3, arg4, arg5, arg6);
}

void test__RegQueryValueEx__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  RegQueryValueEx(arg1, arg2, x, arg4, arg5, arg6);
}

void test__RegQueryValueEx__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  RegQueryValueEx(arg1, arg2, arg3, x, arg5, arg6);
}

void test__RegQueryValueExA__noreturn() {
  int x = 1;
  if (cond) { x=100; RegQueryValueExA(arg1, arg2, arg3, arg4, arg5, arg6); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__RegQueryValueExA__leakignore() {
  char *p = malloc(10); *p=0;
  RegQueryValueExA(p, arg2, arg3, arg4, arg5, arg6);
  // cppcheck-suppress memleak
}

void test__RegQueryValueExA__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  RegQueryValueExA(x, arg2, arg3, arg4, arg5, arg6);
}

void test__RegQueryValueExA__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  RegQueryValueExA(arg1, arg2, x, arg4, arg5, arg6);
}

void test__RegQueryValueExA__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  RegQueryValueExA(arg1, arg2, arg3, x, arg5, arg6);
}

void test__RegQueryValueExW__noreturn() {
  int x = 1;
  if (cond) { x=100; RegQueryValueExW(arg1, arg2, arg3, arg4, arg5, arg6); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__RegQueryValueExW__leakignore() {
  char *p = malloc(10); *p=0;
  RegQueryValueExW(p, arg2, arg3, arg4, arg5, arg6);
  // cppcheck-suppress memleak
}

void test__RegQueryValueExW__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  RegQueryValueExW(x, arg2, arg3, arg4, arg5, arg6);
}

void test__RegQueryValueExW__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  RegQueryValueExW(arg1, arg2, x, arg4, arg5, arg6);
}

void test__RegQueryValueExW__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  RegQueryValueExW(arg1, arg2, arg3, x, arg5, arg6);
}

void test__RegCloseKey__noreturn() {
  int x = 1;
  if (cond) { x=100; RegCloseKey(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__RegCloseKey__leakignore() {
  char *p = malloc(10); *p=0;
  RegCloseKey(p);
  // cppcheck-suppress memleak
}

void test__RegCloseKey__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  RegCloseKey(x);
}

void test___stricmp_l__noreturn() {
  int x = 1;
  if (cond) { x=100; _stricmp_l(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___stricmp_l__leakignore() {
  char *p = malloc(10); *p=0;
  _stricmp_l(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test___stricmp_l__arg1__notnull() {
  // cppcheck-suppress nullPointer
  _stricmp_l(NULL, arg2, arg3);
}

void test___stricmp_l__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _stricmp_l(x, arg2, arg3);
}

void test___stricmp_l__arg2__notnull() {
  // cppcheck-suppress nullPointer
  _stricmp_l(arg1, NULL, arg3);
}

void test___stricmp_l__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _stricmp_l(arg1, x, arg3);
}

void test___stricmp_l__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _stricmp_l(arg1, arg2, x);
}

void test___wcsicmp_l__noreturn() {
  int x = 1;
  if (cond) { x=100; _wcsicmp_l(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___wcsicmp_l__leakignore() {
  char *p = malloc(10); *p=0;
  _wcsicmp_l(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test___wcsicmp_l__arg1__notnull() {
  // cppcheck-suppress nullPointer
  _wcsicmp_l(NULL, arg2, arg3);
}

void test___wcsicmp_l__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _wcsicmp_l(x, arg2, arg3);
}

void test___wcsicmp_l__arg2__notnull() {
  // cppcheck-suppress nullPointer
  _wcsicmp_l(arg1, NULL, arg3);
}

void test___wcsicmp_l__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _wcsicmp_l(arg1, x, arg3);
}

void test___wcsicmp_l__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _wcsicmp_l(arg1, arg2, x);
}

void test___mbsicmp_l__noreturn() {
  int x = 1;
  if (cond) { x=100; _mbsicmp_l(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___mbsicmp_l__leakignore() {
  char *p = malloc(10); *p=0;
  _mbsicmp_l(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test___mbsicmp_l__arg1__notnull() {
  // cppcheck-suppress nullPointer
  _mbsicmp_l(NULL, arg2, arg3);
}

void test___mbsicmp_l__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _mbsicmp_l(x, arg2, arg3);
}

void test___mbsicmp_l__arg2__notnull() {
  // cppcheck-suppress nullPointer
  _mbsicmp_l(arg1, NULL, arg3);
}

void test___mbsicmp_l__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _mbsicmp_l(arg1, x, arg3);
}

void test___mbsicmp_l__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _mbsicmp_l(arg1, arg2, x);
}

void test__stricmp__noreturn() {
  int x = 1;
  if (cond) { x=100; stricmp(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__stricmp__leakignore() {
  char *p = malloc(10); *p=0;
  stricmp(p, arg2);
  // cppcheck-suppress memleak
}

void test__stricmp__arg1__notnull() {
  // cppcheck-suppress nullPointer
  stricmp(NULL, arg2);
}

void test__stricmp__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  stricmp(x, arg2);
}

void test__stricmp__arg2__notnull() {
  // cppcheck-suppress nullPointer
  stricmp(arg1, NULL);
}

void test__stricmp__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  stricmp(arg1, x);
}

void test___stricmp__noreturn() {
  int x = 1;
  if (cond) { x=100; _stricmp(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___stricmp__leakignore() {
  char *p = malloc(10); *p=0;
  _stricmp(p, arg2);
  // cppcheck-suppress memleak
}

void test___stricmp__arg1__notnull() {
  // cppcheck-suppress nullPointer
  _stricmp(NULL, arg2);
}

void test___stricmp__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _stricmp(x, arg2);
}

void test___stricmp__arg2__notnull() {
  // cppcheck-suppress nullPointer
  _stricmp(arg1, NULL);
}

void test___stricmp__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _stricmp(arg1, x);
}

void test__wcsicmp__noreturn() {
  int x = 1;
  if (cond) { x=100; wcsicmp(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__wcsicmp__leakignore() {
  char *p = malloc(10); *p=0;
  wcsicmp(p, arg2);
  // cppcheck-suppress memleak
}

void test__wcsicmp__arg1__notnull() {
  // cppcheck-suppress nullPointer
  wcsicmp(NULL, arg2);
}

void test__wcsicmp__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  wcsicmp(x, arg2);
}

void test__wcsicmp__arg2__notnull() {
  // cppcheck-suppress nullPointer
  wcsicmp(arg1, NULL);
}

void test__wcsicmp__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  wcsicmp(arg1, x);
}

void test___wcsicmp__noreturn() {
  int x = 1;
  if (cond) { x=100; _wcsicmp(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___wcsicmp__leakignore() {
  char *p = malloc(10); *p=0;
  _wcsicmp(p, arg2);
  // cppcheck-suppress memleak
}

void test___wcsicmp__arg1__notnull() {
  // cppcheck-suppress nullPointer
  _wcsicmp(NULL, arg2);
}

void test___wcsicmp__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _wcsicmp(x, arg2);
}

void test___wcsicmp__arg2__notnull() {
  // cppcheck-suppress nullPointer
  _wcsicmp(arg1, NULL);
}

void test___wcsicmp__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _wcsicmp(arg1, x);
}

void test___mbsicmp__noreturn() {
  int x = 1;
  if (cond) { x=100; _mbsicmp(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___mbsicmp__leakignore() {
  char *p = malloc(10); *p=0;
  _mbsicmp(p, arg2);
  // cppcheck-suppress memleak
}

void test___mbsicmp__arg1__notnull() {
  // cppcheck-suppress nullPointer
  _mbsicmp(NULL, arg2);
}

void test___mbsicmp__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _mbsicmp(x, arg2);
}

void test___mbsicmp__arg2__notnull() {
  // cppcheck-suppress nullPointer
  _mbsicmp(arg1, NULL);
}

void test___mbsicmp__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _mbsicmp(arg1, x);
}

void test___tcsicmp__noreturn() {
  int x = 1;
  if (cond) { x=100; _tcsicmp(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___tcsicmp__leakignore() {
  char *p = malloc(10); *p=0;
  _tcsicmp(p, arg2);
  // cppcheck-suppress memleak
}

void test___tcsicmp__arg1__notnull() {
  // cppcheck-suppress nullPointer
  _tcsicmp(NULL, arg2);
}

void test___tcsicmp__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _tcsicmp(x, arg2);
}

void test___tcsicmp__arg2__notnull() {
  // cppcheck-suppress nullPointer
  _tcsicmp(arg1, NULL);
}

void test___tcsicmp__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _tcsicmp(arg1, x);
}

void test__GetFileAttributes__noreturn() {
  int x = 1;
  if (cond) { x=100; GetFileAttributes(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__GetFileAttributes__leakignore() {
  char *p = malloc(10); *p=0;
  GetFileAttributes(p);
  // cppcheck-suppress memleak
}

void test__GetFileAttributes__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  GetFileAttributes(x);
}

void test__GetFileAttributesA__noreturn() {
  int x = 1;
  if (cond) { x=100; GetFileAttributesA(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__GetFileAttributesA__leakignore() {
  char *p = malloc(10); *p=0;
  GetFileAttributesA(p);
  // cppcheck-suppress memleak
}

void test__GetFileAttributesA__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  GetFileAttributesA(x);
}

void test__GetFileAttributesW__noreturn() {
  int x = 1;
  if (cond) { x=100; GetFileAttributesW(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__GetFileAttributesW__leakignore() {
  char *p = malloc(10); *p=0;
  GetFileAttributesW(p);
  // cppcheck-suppress memleak
}

void test__GetFileAttributesW__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  GetFileAttributesW(x);
}

void test__RegOpenKeyEx__noreturn() {
  int x = 1;
  if (cond) { x=100; RegOpenKeyEx(arg1, arg2, arg3, arg4, arg5); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__RegOpenKeyEx__leakignore() {
  char *p = malloc(10); *p=0;
  RegOpenKeyEx(p, arg2, arg3, arg4, arg5);
  // cppcheck-suppress memleak
}

void test__RegOpenKeyEx__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  RegOpenKeyEx(x, arg2, arg3, arg4, arg5);
}

void test__RegOpenKeyEx__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  RegOpenKeyEx(arg1, arg2, x, arg4, arg5);
}

void test__RegOpenKeyEx__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  RegOpenKeyEx(arg1, arg2, arg3, x, arg5);
}

void test__RegOpenKeyExA__noreturn() {
  int x = 1;
  if (cond) { x=100; RegOpenKeyExA(arg1, arg2, arg3, arg4, arg5); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__RegOpenKeyExA__leakignore() {
  char *p = malloc(10); *p=0;
  RegOpenKeyExA(p, arg2, arg3, arg4, arg5);
  // cppcheck-suppress memleak
}

void test__RegOpenKeyExA__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  RegOpenKeyExA(x, arg2, arg3, arg4, arg5);
}

void test__RegOpenKeyExA__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  RegOpenKeyExA(arg1, arg2, x, arg4, arg5);
}

void test__RegOpenKeyExA__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  RegOpenKeyExA(arg1, arg2, arg3, x, arg5);
}

void test__RegOpenKeyExW__noreturn() {
  int x = 1;
  if (cond) { x=100; RegOpenKeyExW(arg1, arg2, arg3, arg4, arg5); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__RegOpenKeyExW__leakignore() {
  char *p = malloc(10); *p=0;
  RegOpenKeyExW(p, arg2, arg3, arg4, arg5);
  // cppcheck-suppress memleak
}

void test__RegOpenKeyExW__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  RegOpenKeyExW(x, arg2, arg3, arg4, arg5);
}

void test__RegOpenKeyExW__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  RegOpenKeyExW(arg1, arg2, x, arg4, arg5);
}

void test__RegOpenKeyExW__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  RegOpenKeyExW(arg1, arg2, arg3, x, arg5);
}

void test__wsprintf__noreturn() {
  int x = 1;
  if (cond) { x=100; wsprintf(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__wsprintf__leakignore() {
  char *p = malloc(10); *p=0;
  wsprintf(p, arg2);
  // cppcheck-suppress memleak
}

void test__wsprintf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  wsprintf(x, arg2);
}

void test__wsprintf__arg2__notnull() {
  // cppcheck-suppress nullPointer
  wsprintf(arg1, NULL);
}

void test__wsprintf__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  wsprintf(arg1, x);
}

void test__wsprintfA__noreturn() {
  int x = 1;
  if (cond) { x=100; wsprintfA(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__wsprintfA__leakignore() {
  char *p = malloc(10); *p=0;
  wsprintfA(p, arg2);
  // cppcheck-suppress memleak
}

void test__wsprintfA__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  wsprintfA(x, arg2);
}

void test__wsprintfA__arg2__notnull() {
  // cppcheck-suppress nullPointer
  wsprintfA(arg1, NULL);
}

void test__wsprintfA__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  wsprintfA(arg1, x);
}

void test__wsprintfW__noreturn() {
  int x = 1;
  if (cond) { x=100; wsprintfW(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__wsprintfW__leakignore() {
  char *p = malloc(10); *p=0;
  wsprintfW(p, arg2);
  // cppcheck-suppress memleak
}

void test__wsprintfW__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  wsprintfW(x, arg2);
}

void test__wsprintfW__arg2__notnull() {
  // cppcheck-suppress nullPointer
  wsprintfW(arg1, NULL);
}

void test__wsprintfW__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  wsprintfW(arg1, x);
}

void test__sprintf_s__noreturn() {
  int x = 1;
  if (cond) { x=100; sprintf_s(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__sprintf_s__leakignore() {
  char *p = malloc(10); *p=0;
  sprintf_s();
  // cppcheck-suppress memleak
}

void test__swprintf_s__noreturn() {
  int x = 1;
  if (cond) { x=100; swprintf_s(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__swprintf_s__leakignore() {
  char *p = malloc(10); *p=0;
  swprintf_s();
  // cppcheck-suppress memleak
}

void test___sprintf_s_l__noreturn() {
  int x = 1;
  if (cond) { x=100; _sprintf_s_l(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___sprintf_s_l__leakignore() {
  char *p = malloc(10); *p=0;
  _sprintf_s_l(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test___sprintf_s_l__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _sprintf_s_l(arg1, x, arg3, arg4);
}

void test___sprintf_s_l__arg3__notnull() {
  // cppcheck-suppress nullPointer
  _sprintf_s_l(arg1, arg2, NULL, arg4);
}

void test___sprintf_s_l__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _sprintf_s_l(arg1, arg2, x, arg4);
}

void test___sprintf_s_l__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _sprintf_s_l(arg1, arg2, arg3, x);
}

void test___swprintf_s_l__noreturn() {
  int x = 1;
  if (cond) { x=100; _swprintf_s_l(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___swprintf_s_l__leakignore() {
  char *p = malloc(10); *p=0;
  _swprintf_s_l(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test___swprintf_s_l__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _swprintf_s_l(arg1, x, arg3, arg4);
}

void test___swprintf_s_l__arg3__notnull() {
  // cppcheck-suppress nullPointer
  _swprintf_s_l(arg1, arg2, NULL, arg4);
}

void test___swprintf_s_l__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _swprintf_s_l(arg1, arg2, x, arg4);
}

void test___swprintf_s_l__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _swprintf_s_l(arg1, arg2, arg3, x);
}

void test__RegEnumKeyEx__noreturn() {
  int x = 1;
  if (cond) { x=100; RegEnumKeyEx(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__RegEnumKeyEx__leakignore() {
  char *p = malloc(10); *p=0;
  RegEnumKeyEx(p, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
  // cppcheck-suppress memleak
}

void test__RegEnumKeyEx__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  RegEnumKeyEx(x, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
}

void test__RegEnumKeyEx__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  RegEnumKeyEx(arg1, x, arg3, arg4, arg5, arg6, arg7, arg8);
}

void test__RegEnumKeyExA__noreturn() {
  int x = 1;
  if (cond) { x=100; RegEnumKeyExA(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__RegEnumKeyExA__leakignore() {
  char *p = malloc(10); *p=0;
  RegEnumKeyExA(p, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
  // cppcheck-suppress memleak
}

void test__RegEnumKeyExA__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  RegEnumKeyExA(x, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
}

void test__RegEnumKeyExA__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  RegEnumKeyExA(arg1, x, arg3, arg4, arg5, arg6, arg7, arg8);
}

void test__RegEnumKeyExW__noreturn() {
  int x = 1;
  if (cond) { x=100; RegEnumKeyExW(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__RegEnumKeyExW__leakignore() {
  char *p = malloc(10); *p=0;
  RegEnumKeyExW(p, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
  // cppcheck-suppress memleak
}

void test__RegEnumKeyExW__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  RegEnumKeyExW(x, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
}

void test__RegEnumKeyExW__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  RegEnumKeyExW(arg1, x, arg3, arg4, arg5, arg6, arg7, arg8);
}

void test__CreateFont__noreturn() {
  int x = 1;
  if (cond) { x=100; CreateFont(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__CaptureStackBackTrace__noreturn() {
  int x = 1;
  if (cond) { x=100; CaptureStackBackTrace(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__CaptureStackBackTrace__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CaptureStackBackTrace(x, arg2, arg3, arg4);
}

void test__CaptureStackBackTrace__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CaptureStackBackTrace(arg1, x, arg3, arg4);
}

void test___vsnprintf__noreturn() {
  int x = 1;
  if (cond) { x=100; _vsnprintf(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___vsnprintf__leakignore() {
  char *p = malloc(10); *p=0;
  _vsnprintf(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test___vsnprintf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _vsnprintf(x, arg2, arg3, arg4);
}

void test___vsnprintf__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _vsnprintf(arg1, x, arg3, arg4);
}

void test___vsnprintf__arg3__notnull() {
  // cppcheck-suppress nullPointer
  _vsnprintf(arg1, arg2, NULL, arg4);
}

void test___vsnprintf__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _vsnprintf(arg1, arg2, x, arg4);
}

void test___vsnwprintf__noreturn() {
  int x = 1;
  if (cond) { x=100; _vsnwprintf(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___vsnwprintf__leakignore() {
  char *p = malloc(10); *p=0;
  _vsnwprintf(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test___vsnwprintf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _vsnwprintf(x, arg2, arg3, arg4);
}

void test___vsnwprintf__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _vsnwprintf(arg1, x, arg3, arg4);
}

void test___vsnwprintf__arg3__notnull() {
  // cppcheck-suppress nullPointer
  _vsnwprintf(arg1, arg2, NULL, arg4);
}

void test___vsnwprintf__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _vsnwprintf(arg1, arg2, x, arg4);
}

void test___vsnprintf_l__noreturn() {
  int x = 1;
  if (cond) { x=100; _vsnprintf_l(arg1, arg2, arg3, arg4, arg5); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___vsnprintf_l__leakignore() {
  char *p = malloc(10); *p=0;
  _vsnprintf_l(p, arg2, arg3, arg4, arg5);
  // cppcheck-suppress memleak
}

void test___vsnprintf_l__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _vsnprintf_l(x, arg2, arg3, arg4, arg5);
}

void test___vsnprintf_l__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _vsnprintf_l(arg1, x, arg3, arg4, arg5);
}

void test___vsnprintf_l__arg3__notnull() {
  // cppcheck-suppress nullPointer
  _vsnprintf_l(arg1, arg2, NULL, arg4, arg5);
}

void test___vsnprintf_l__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _vsnprintf_l(arg1, arg2, x, arg4, arg5);
}

void test___vsnprintf_l__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _vsnprintf_l(arg1, arg2, arg3, x, arg5);
}

void test___vsnwprintf_l__noreturn() {
  int x = 1;
  if (cond) { x=100; _vsnwprintf_l(arg1, arg2, arg3, arg4, arg5); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___vsnwprintf_l__leakignore() {
  char *p = malloc(10); *p=0;
  _vsnwprintf_l(p, arg2, arg3, arg4, arg5);
  // cppcheck-suppress memleak
}

void test___vsnwprintf_l__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _vsnwprintf_l(x, arg2, arg3, arg4, arg5);
}

void test___vsnwprintf_l__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _vsnwprintf_l(arg1, x, arg3, arg4, arg5);
}

void test___vsnwprintf_l__arg3__notnull() {
  // cppcheck-suppress nullPointer
  _vsnwprintf_l(arg1, arg2, NULL, arg4, arg5);
}

void test___vsnwprintf_l__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _vsnwprintf_l(arg1, arg2, x, arg4, arg5);
}

void test___vsnwprintf_l__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _vsnwprintf_l(arg1, arg2, arg3, x, arg5);
}

void test___vswprintf_l__noreturn() {
  int x = 1;
  if (cond) { x=100; _vswprintf_l(arg1, arg2, arg3, arg4, arg5); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___vswprintf_l__leakignore() {
  char *p = malloc(10); *p=0;
  _vswprintf_l(p, arg2, arg3, arg4, arg5);
  // cppcheck-suppress memleak
}

void test___vswprintf_l__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _vswprintf_l(x, arg2, arg3, arg4, arg5);
}

void test___vswprintf_l__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _vswprintf_l(arg1, x, arg3, arg4, arg5);
}

void test___vswprintf_l__arg3__notnull() {
  // cppcheck-suppress nullPointer
  _vswprintf_l(arg1, arg2, NULL, arg4, arg5);
}

void test___vswprintf_l__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _vswprintf_l(arg1, arg2, x, arg4, arg5);
}

void test___vswprintf_l__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _vswprintf_l(arg1, arg2, arg3, x, arg5);
}

void test__vsnprintf_s__noreturn() {
  int x = 1;
  if (cond) { x=100; vsnprintf_s(arg1, arg2, arg3, arg4, arg5); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__vsnprintf_s__leakignore() {
  char *p = malloc(10); *p=0;
  vsnprintf_s(p, arg2, arg3, arg4, arg5);
  // cppcheck-suppress memleak
}

void test__vsnprintf_s__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  vsnprintf_s(x, arg2, arg3, arg4, arg5);
}

void test__vsnprintf_s__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  vsnprintf_s(arg1, x, arg3, arg4, arg5);
}

void test__vsnprintf_s__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  vsnprintf_s(arg1, arg2, x, arg4, arg5);
}

void test__vsnprintf_s__arg4__notnull() {
  // cppcheck-suppress nullPointer
  vsnprintf_s(arg1, arg2, arg3, NULL, arg5);
}

void test__vsnprintf_s__arg4__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  vsnprintf_s(arg1, arg2, arg3, x, arg5);
}

void test___vsnprintf_s__noreturn() {
  int x = 1;
  if (cond) { x=100; _vsnprintf_s(arg1, arg2, arg3, arg4, arg5); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___vsnprintf_s__leakignore() {
  char *p = malloc(10); *p=0;
  _vsnprintf_s(p, arg2, arg3, arg4, arg5);
  // cppcheck-suppress memleak
}

void test___vsnprintf_s__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _vsnprintf_s(x, arg2, arg3, arg4, arg5);
}

void test___vsnprintf_s__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _vsnprintf_s(arg1, x, arg3, arg4, arg5);
}

void test___vsnprintf_s__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _vsnprintf_s(arg1, arg2, x, arg4, arg5);
}

void test___vsnprintf_s__arg4__notnull() {
  // cppcheck-suppress nullPointer
  _vsnprintf_s(arg1, arg2, arg3, NULL, arg5);
}

void test___vsnprintf_s__arg4__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _vsnprintf_s(arg1, arg2, arg3, x, arg5);
}

void test___vsnwprintf_s__noreturn() {
  int x = 1;
  if (cond) { x=100; _vsnwprintf_s(arg1, arg2, arg3, arg4, arg5); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___vsnwprintf_s__leakignore() {
  char *p = malloc(10); *p=0;
  _vsnwprintf_s(p, arg2, arg3, arg4, arg5);
  // cppcheck-suppress memleak
}

void test___vsnwprintf_s__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _vsnwprintf_s(x, arg2, arg3, arg4, arg5);
}

void test___vsnwprintf_s__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _vsnwprintf_s(arg1, x, arg3, arg4, arg5);
}

void test___vsnwprintf_s__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _vsnwprintf_s(arg1, arg2, x, arg4, arg5);
}

void test___vsnwprintf_s__arg4__notnull() {
  // cppcheck-suppress nullPointer
  _vsnwprintf_s(arg1, arg2, arg3, NULL, arg5);
}

void test___vsnwprintf_s__arg4__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _vsnwprintf_s(arg1, arg2, arg3, x, arg5);
}

void test___vsnprintf_s_l__noreturn() {
  int x = 1;
  if (cond) { x=100; _vsnprintf_s_l(arg1, arg2, arg3, arg4, arg5, arg6); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___vsnprintf_s_l__leakignore() {
  char *p = malloc(10); *p=0;
  _vsnprintf_s_l(p, arg2, arg3, arg4, arg5, arg6);
  // cppcheck-suppress memleak
}

void test___vsnprintf_s_l__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _vsnprintf_s_l(x, arg2, arg3, arg4, arg5, arg6);
}

void test___vsnprintf_s_l__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _vsnprintf_s_l(arg1, x, arg3, arg4, arg5, arg6);
}

void test___vsnprintf_s_l__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _vsnprintf_s_l(arg1, arg2, x, arg4, arg5, arg6);
}

void test___vsnprintf_s_l__arg4__notnull() {
  // cppcheck-suppress nullPointer
  _vsnprintf_s_l(arg1, arg2, arg3, NULL, arg5, arg6);
}

void test___vsnprintf_s_l__arg4__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _vsnprintf_s_l(arg1, arg2, arg3, x, arg5, arg6);
}

void test___vsnprintf_s_l__arg5__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _vsnprintf_s_l(arg1, arg2, arg3, arg4, x, arg6);
}

void test___vsnwprintf_s_l__noreturn() {
  int x = 1;
  if (cond) { x=100; _vsnwprintf_s_l(arg1, arg2, arg3, arg4, arg5, arg6); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___vsnwprintf_s_l__leakignore() {
  char *p = malloc(10); *p=0;
  _vsnwprintf_s_l(p, arg2, arg3, arg4, arg5, arg6);
  // cppcheck-suppress memleak
}

void test___vsnwprintf_s_l__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _vsnwprintf_s_l(x, arg2, arg3, arg4, arg5, arg6);
}

void test___vsnwprintf_s_l__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _vsnwprintf_s_l(arg1, x, arg3, arg4, arg5, arg6);
}

void test___vsnwprintf_s_l__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _vsnwprintf_s_l(arg1, arg2, x, arg4, arg5, arg6);
}

void test___vsnwprintf_s_l__arg4__notnull() {
  // cppcheck-suppress nullPointer
  _vsnwprintf_s_l(arg1, arg2, arg3, NULL, arg5, arg6);
}

void test___vsnwprintf_s_l__arg4__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _vsnwprintf_s_l(arg1, arg2, arg3, x, arg5, arg6);
}

void test___vsnwprintf_s_l__arg5__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _vsnwprintf_s_l(arg1, arg2, arg3, arg4, x, arg6);
}

void test___vsprintf_l__noreturn() {
  int x = 1;
  if (cond) { x=100; _vsprintf_l(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___vsprintf_l__leakignore() {
  char *p = malloc(10); *p=0;
  _vsprintf_l(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test___vsprintf_l__arg1__notnull() {
  // cppcheck-suppress nullPointer
  _vsprintf_l(NULL, arg2, arg3, arg4);
}

void test___vsprintf_l__arg2__notnull() {
  // cppcheck-suppress nullPointer
  _vsprintf_l(arg1, NULL, arg3, arg4);
}

void test___vsprintf_l__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _vsprintf_l(arg1, arg2, x, arg4);
}

void test____vswprintf_l__noreturn() {
  int x = 1;
  if (cond) { x=100; __vswprintf_l(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test____vswprintf_l__leakignore() {
  char *p = malloc(10); *p=0;
  __vswprintf_l(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test____vswprintf_l__arg1__notnull() {
  // cppcheck-suppress nullPointer
  __vswprintf_l(NULL, arg2, arg3, arg4);
}

void test____vswprintf_l__arg2__notnull() {
  // cppcheck-suppress nullPointer
  __vswprintf_l(arg1, NULL, arg3, arg4);
}

void test____vswprintf_l__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  __vswprintf_l(arg1, arg2, x, arg4);
}

void test___strdup__noreturn() {
  int x = 1;
  if (cond) { x=100; _strdup(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___strdup__arg1__notnull() {
  // cppcheck-suppress nullPointer
  _strdup(NULL);
}

void test___strdup__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _strdup(x);
}

void test___wcsdup__noreturn() {
  int x = 1;
  if (cond) { x=100; _wcsdup(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___wcsdup__arg1__notnull() {
  // cppcheck-suppress nullPointer
  _wcsdup(NULL);
}

void test___wcsdup__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _wcsdup(x);
}

void test___mbsdup__noreturn() {
  int x = 1;
  if (cond) { x=100; _mbsdup(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___mbsdup__arg1__notnull() {
  // cppcheck-suppress nullPointer
  _mbsdup(NULL);
}

void test___mbsdup__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _mbsdup(x);
}

void test___tcsdup__noreturn() {
  int x = 1;
  if (cond) { x=100; _tcsdup(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___tcsdup__arg1__notnull() {
  // cppcheck-suppress nullPointer
  _tcsdup(NULL);
}

void test___tcsdup__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _tcsdup(x);
}

void test___strdup_dbg__noreturn() {
  int x = 1;
  if (cond) { x=100; _strdup_dbg(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___strdup_dbg__arg1__notnull() {
  // cppcheck-suppress nullPointer
  _strdup_dbg(NULL, arg2, arg3, arg4);
}

void test___strdup_dbg__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _strdup_dbg(x, arg2, arg3, arg4);
}

void test___strdup_dbg__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _strdup_dbg(arg1, x, arg3, arg4);
}

void test___strdup_dbg__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _strdup_dbg(arg1, arg2, x, arg4);
}

void test___strdup_dbg__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _strdup_dbg(arg1, arg2, arg3, x);
}

void test___wcsdup_dbg__noreturn() {
  int x = 1;
  if (cond) { x=100; _wcsdup_dbg(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___wcsdup_dbg__arg1__notnull() {
  // cppcheck-suppress nullPointer
  _wcsdup_dbg(NULL, arg2, arg3, arg4);
}

void test___wcsdup_dbg__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _wcsdup_dbg(x, arg2, arg3, arg4);
}

void test___wcsdup_dbg__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _wcsdup_dbg(arg1, x, arg3, arg4);
}

void test___wcsdup_dbg__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _wcsdup_dbg(arg1, arg2, x, arg4);
}

void test___wcsdup_dbg__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _wcsdup_dbg(arg1, arg2, arg3, x);
}

void test___tcsdup_dbg__noreturn() {
  int x = 1;
  if (cond) { x=100; _tcsdup_dbg(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___tcsdup_dbg__arg1__notnull() {
  // cppcheck-suppress nullPointer
  _tcsdup_dbg(NULL, arg2, arg3, arg4);
}

void test___tcsdup_dbg__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _tcsdup_dbg(x, arg2, arg3, arg4);
}

void test___tcsdup_dbg__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _tcsdup_dbg(arg1, x, arg3, arg4);
}

void test___tcsdup_dbg__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _tcsdup_dbg(arg1, arg2, x, arg4);
}

void test___tcsdup_dbg__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _tcsdup_dbg(arg1, arg2, arg3, x);
}

void test___mbscmp__noreturn() {
  int x = 1;
  if (cond) { x=100; result = _mbscmp(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___mbscmp__useretval() {
  // cppcheck-suppress ignoredReturnValue
  _mbscmp(arg1, arg2);
}

void test___mbscmp__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((_mbscmp(arg1, arg2) > 10) || (_mbscmp(arg1, arg2) < 100)) {}
}

void test___mbscmp__leakignore() {
  char *p = malloc(10); *p=0;
  result = _mbscmp(p, arg2);
  // cppcheck-suppress memleak
}

void test___mbscmp__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = _mbscmp(NULL, arg2);
}

void test___mbscmp__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _mbscmp(x, arg2);
}

void test___mbscmp__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = _mbscmp(arg1, NULL);
}

void test___mbscmp__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _mbscmp(arg1, x);
}

void test___tcscmp__noreturn() {
  int x = 1;
  if (cond) { x=100; result = _tcscmp(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___tcscmp__useretval() {
  // cppcheck-suppress ignoredReturnValue
  _tcscmp(arg1, arg2);
}

void test___tcscmp__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((_tcscmp(arg1, arg2) > 10) || (_tcscmp(arg1, arg2) < 100)) {}
}

void test___tcscmp__leakignore() {
  char *p = malloc(10); *p=0;
  result = _tcscmp(p, arg2);
  // cppcheck-suppress memleak
}

void test___tcscmp__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = _tcscmp(NULL, arg2);
}

void test___tcscmp__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _tcscmp(x, arg2);
}

void test___tcscmp__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = _tcscmp(arg1, NULL);
}

void test___tcscmp__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _tcscmp(arg1, x);
}

void test___snprintf__noreturn() {
  int x = 1;
  if (cond) { x=100; _snprintf(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___snprintf__leakignore() {
  char *p = malloc(10); *p=0;
  _snprintf(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test___snprintf__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _snprintf(arg1, x, arg3);
}

void test___snprintf__arg3__notnull() {
  // cppcheck-suppress nullPointer
  _snprintf(arg1, arg2, NULL);
}

void test___snprintf__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _snprintf(arg1, arg2, x);
}

void test___snwprintf__noreturn() {
  int x = 1;
  if (cond) { x=100; _snwprintf(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___snwprintf__leakignore() {
  char *p = malloc(10); *p=0;
  _snwprintf(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test___snwprintf__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _snwprintf(arg1, x, arg3);
}

void test___snwprintf__arg3__notnull() {
  // cppcheck-suppress nullPointer
  _snwprintf(arg1, arg2, NULL);
}

void test___snwprintf__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _snwprintf(arg1, arg2, x);
}

void test___sntprintf__noreturn() {
  int x = 1;
  if (cond) { x=100; _sntprintf(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___sntprintf__leakignore() {
  char *p = malloc(10); *p=0;
  _sntprintf(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test___sntprintf__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _sntprintf(arg1, x, arg3);
}

void test___sntprintf__arg3__notnull() {
  // cppcheck-suppress nullPointer
  _sntprintf(arg1, arg2, NULL);
}

void test___sntprintf__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _sntprintf(arg1, arg2, x);
}

void test__strcpy_s__noreturn() {
  int x = 1;
  if (cond) { x=100; strcpy_s(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__strcpy_s__leakignore() {
  char *p = malloc(10); *p=0;
  strcpy_s(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__strcpy_s__arg1__notnull() {
  // cppcheck-suppress nullPointer
  strcpy_s(NULL, arg2, arg3);
}

void test__strcpy_s__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  strcpy_s(arg1, x, arg3);
}

void test__strcpy_s__arg3__notnull() {
  // cppcheck-suppress nullPointer
  strcpy_s(arg1, arg2, NULL);
}

void test__strcpy_s__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  strcpy_s(arg1, arg2, x);
}

void test__wcscpy_s__noreturn() {
  int x = 1;
  if (cond) { x=100; wcscpy_s(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__wcscpy_s__leakignore() {
  char *p = malloc(10); *p=0;
  wcscpy_s(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__wcscpy_s__arg1__notnull() {
  // cppcheck-suppress nullPointer
  wcscpy_s(NULL, arg2, arg3);
}

void test__wcscpy_s__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  wcscpy_s(arg1, x, arg3);
}

void test__wcscpy_s__arg3__notnull() {
  // cppcheck-suppress nullPointer
  wcscpy_s(arg1, arg2, NULL);
}

void test__wcscpy_s__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  wcscpy_s(arg1, arg2, x);
}

void test___mbscpy_s__noreturn() {
  int x = 1;
  if (cond) { x=100; _mbscpy_s(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___mbscpy_s__leakignore() {
  char *p = malloc(10); *p=0;
  _mbscpy_s(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test___mbscpy_s__arg1__notnull() {
  // cppcheck-suppress nullPointer
  _mbscpy_s(NULL, arg2, arg3);
}

void test___mbscpy_s__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _mbscpy_s(arg1, x, arg3);
}

void test___mbscpy_s__arg3__notnull() {
  // cppcheck-suppress nullPointer
  _mbscpy_s(arg1, arg2, NULL);
}

void test___mbscpy_s__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _mbscpy_s(arg1, arg2, x);
}

void test___tcscpy_s__noreturn() {
  int x = 1;
  if (cond) { x=100; _tcscpy_s(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___tcscpy_s__leakignore() {
  char *p = malloc(10); *p=0;
  _tcscpy_s(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test___tcscpy_s__arg1__notnull() {
  // cppcheck-suppress nullPointer
  _tcscpy_s(NULL, arg2, arg3);
}

void test___tcscpy_s__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _tcscpy_s(arg1, x, arg3);
}

void test___tcscpy_s__arg3__notnull() {
  // cppcheck-suppress nullPointer
  _tcscpy_s(arg1, arg2, NULL);
}

void test___tcscpy_s__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _tcscpy_s(arg1, arg2, x);
}

void test___CrtSetDbgFlag__noreturn() {
  int x = 1;
  if (cond) { x=100; _CrtSetDbgFlag(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___CrtSetDbgFlag__leakignore() {
  char *p = malloc(10); *p=0;
  _CrtSetDbgFlag(p);
  // cppcheck-suppress memleak
}

void test___CrtSetDbgFlag__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _CrtSetDbgFlag(x);
}

void test___stat__noreturn() {
  int x = 1;
  if (cond) { x=100; _stat(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___stat__leakignore() {
  char *p = malloc(10); *p=0;
  _stat(p, arg2);
  // cppcheck-suppress memleak
}

void test___stat__arg1__notnull() {
  // cppcheck-suppress nullPointer
  _stat(NULL, arg2);
}

void test___stat__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _stat(x, arg2);
}

void test___stat__arg2__notnull() {
  // cppcheck-suppress nullPointer
  _stat(arg1, NULL);
}

void test___tstat__noreturn() {
  int x = 1;
  if (cond) { x=100; _tstat(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___tstat__leakignore() {
  char *p = malloc(10); *p=0;
  _tstat(p, arg2);
  // cppcheck-suppress memleak
}

void test___tstat__arg1__notnull() {
  // cppcheck-suppress nullPointer
  _tstat(NULL, arg2);
}

void test___tstat__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _tstat(x, arg2);
}

void test___tstat__arg2__notnull() {
  // cppcheck-suppress nullPointer
  _tstat(arg1, NULL);
}

void test___stat32__noreturn() {
  int x = 1;
  if (cond) { x=100; _stat32(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___stat32__leakignore() {
  char *p = malloc(10); *p=0;
  _stat32(p, arg2);
  // cppcheck-suppress memleak
}

void test___stat32__arg1__notnull() {
  // cppcheck-suppress nullPointer
  _stat32(NULL, arg2);
}

void test___stat32__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _stat32(x, arg2);
}

void test___stat32__arg2__notnull() {
  // cppcheck-suppress nullPointer
  _stat32(arg1, NULL);
}

void test___stat64__noreturn() {
  int x = 1;
  if (cond) { x=100; _stat64(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___stat64__leakignore() {
  char *p = malloc(10); *p=0;
  _stat64(p, arg2);
  // cppcheck-suppress memleak
}

void test___stat64__arg1__notnull() {
  // cppcheck-suppress nullPointer
  _stat64(NULL, arg2);
}

void test___stat64__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _stat64(x, arg2);
}

void test___stat64__arg2__notnull() {
  // cppcheck-suppress nullPointer
  _stat64(arg1, NULL);
}

void test___tstat64__noreturn() {
  int x = 1;
  if (cond) { x=100; _tstat64(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___tstat64__leakignore() {
  char *p = malloc(10); *p=0;
  _tstat64(p, arg2);
  // cppcheck-suppress memleak
}

void test___tstat64__arg1__notnull() {
  // cppcheck-suppress nullPointer
  _tstat64(NULL, arg2);
}

void test___tstat64__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _tstat64(x, arg2);
}

void test___tstat64__arg2__notnull() {
  // cppcheck-suppress nullPointer
  _tstat64(arg1, NULL);
}

void test___stati64__noreturn() {
  int x = 1;
  if (cond) { x=100; _stati64(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___stati64__leakignore() {
  char *p = malloc(10); *p=0;
  _stati64(p, arg2);
  // cppcheck-suppress memleak
}

void test___stati64__arg1__notnull() {
  // cppcheck-suppress nullPointer
  _stati64(NULL, arg2);
}

void test___stati64__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _stati64(x, arg2);
}

void test___stati64__arg2__notnull() {
  // cppcheck-suppress nullPointer
  _stati64(arg1, NULL);
}

void test___tstati64__noreturn() {
  int x = 1;
  if (cond) { x=100; _tstati64(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___tstati64__leakignore() {
  char *p = malloc(10); *p=0;
  _tstati64(p, arg2);
  // cppcheck-suppress memleak
}

void test___tstati64__arg1__notnull() {
  // cppcheck-suppress nullPointer
  _tstati64(NULL, arg2);
}

void test___tstati64__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _tstati64(x, arg2);
}

void test___tstati64__arg2__notnull() {
  // cppcheck-suppress nullPointer
  _tstati64(arg1, NULL);
}

void test___stat32i64__noreturn() {
  int x = 1;
  if (cond) { x=100; _stat32i64(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___stat32i64__leakignore() {
  char *p = malloc(10); *p=0;
  _stat32i64(p, arg2);
  // cppcheck-suppress memleak
}

void test___stat32i64__arg1__notnull() {
  // cppcheck-suppress nullPointer
  _stat32i64(NULL, arg2);
}

void test___stat32i64__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _stat32i64(x, arg2);
}

void test___stat32i64__arg2__notnull() {
  // cppcheck-suppress nullPointer
  _stat32i64(arg1, NULL);
}

void test___tstat32i64__noreturn() {
  int x = 1;
  if (cond) { x=100; _tstat32i64(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___tstat32i64__leakignore() {
  char *p = malloc(10); *p=0;
  _tstat32i64(p, arg2);
  // cppcheck-suppress memleak
}

void test___tstat32i64__arg1__notnull() {
  // cppcheck-suppress nullPointer
  _tstat32i64(NULL, arg2);
}

void test___tstat32i64__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _tstat32i64(x, arg2);
}

void test___tstat32i64__arg2__notnull() {
  // cppcheck-suppress nullPointer
  _tstat32i64(arg1, NULL);
}

void test___stat64i32__noreturn() {
  int x = 1;
  if (cond) { x=100; _stat64i32(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___stat64i32__leakignore() {
  char *p = malloc(10); *p=0;
  _stat64i32(p, arg2);
  // cppcheck-suppress memleak
}

void test___stat64i32__arg1__notnull() {
  // cppcheck-suppress nullPointer
  _stat64i32(NULL, arg2);
}

void test___stat64i32__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _stat64i32(x, arg2);
}

void test___stat64i32__arg2__notnull() {
  // cppcheck-suppress nullPointer
  _stat64i32(arg1, NULL);
}

void test___tstat64i32__noreturn() {
  int x = 1;
  if (cond) { x=100; _tstat64i32(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___tstat64i32__leakignore() {
  char *p = malloc(10); *p=0;
  _tstat64i32(p, arg2);
  // cppcheck-suppress memleak
}

void test___tstat64i32__arg1__notnull() {
  // cppcheck-suppress nullPointer
  _tstat64i32(NULL, arg2);
}

void test___tstat64i32__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _tstat64i32(x, arg2);
}

void test___tstat64i32__arg2__notnull() {
  // cppcheck-suppress nullPointer
  _tstat64i32(arg1, NULL);
}

void test___wstat__noreturn() {
  int x = 1;
  if (cond) { x=100; _wstat(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___wstat__leakignore() {
  char *p = malloc(10); *p=0;
  _wstat(p, arg2);
  // cppcheck-suppress memleak
}

void test___wstat__arg1__notnull() {
  // cppcheck-suppress nullPointer
  _wstat(NULL, arg2);
}

void test___wstat__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _wstat(x, arg2);
}

void test___wstat__arg2__notnull() {
  // cppcheck-suppress nullPointer
  _wstat(arg1, NULL);
}

void test___wstat32__noreturn() {
  int x = 1;
  if (cond) { x=100; _wstat32(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___wstat32__leakignore() {
  char *p = malloc(10); *p=0;
  _wstat32(p, arg2);
  // cppcheck-suppress memleak
}

void test___wstat32__arg1__notnull() {
  // cppcheck-suppress nullPointer
  _wstat32(NULL, arg2);
}

void test___wstat32__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _wstat32(x, arg2);
}

void test___wstat32__arg2__notnull() {
  // cppcheck-suppress nullPointer
  _wstat32(arg1, NULL);
}

void test___wstat64__noreturn() {
  int x = 1;
  if (cond) { x=100; _wstat64(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___wstat64__leakignore() {
  char *p = malloc(10); *p=0;
  _wstat64(p, arg2);
  // cppcheck-suppress memleak
}

void test___wstat64__arg1__notnull() {
  // cppcheck-suppress nullPointer
  _wstat64(NULL, arg2);
}

void test___wstat64__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _wstat64(x, arg2);
}

void test___wstat64__arg2__notnull() {
  // cppcheck-suppress nullPointer
  _wstat64(arg1, NULL);
}

void test___wstati64__noreturn() {
  int x = 1;
  if (cond) { x=100; _wstati64(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___wstati64__leakignore() {
  char *p = malloc(10); *p=0;
  _wstati64(p, arg2);
  // cppcheck-suppress memleak
}

void test___wstati64__arg1__notnull() {
  // cppcheck-suppress nullPointer
  _wstati64(NULL, arg2);
}

void test___wstati64__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _wstati64(x, arg2);
}

void test___wstati64__arg2__notnull() {
  // cppcheck-suppress nullPointer
  _wstati64(arg1, NULL);
}

void test___wstat32i64__noreturn() {
  int x = 1;
  if (cond) { x=100; _wstat32i64(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___wstat32i64__leakignore() {
  char *p = malloc(10); *p=0;
  _wstat32i64(p, arg2);
  // cppcheck-suppress memleak
}

void test___wstat32i64__arg1__notnull() {
  // cppcheck-suppress nullPointer
  _wstat32i64(NULL, arg2);
}

void test___wstat32i64__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _wstat32i64(x, arg2);
}

void test___wstat32i64__arg2__notnull() {
  // cppcheck-suppress nullPointer
  _wstat32i64(arg1, NULL);
}

void test___wstat64i32__noreturn() {
  int x = 1;
  if (cond) { x=100; _wstat64i32(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___wstat64i32__leakignore() {
  char *p = malloc(10); *p=0;
  _wstat64i32(p, arg2);
  // cppcheck-suppress memleak
}

void test___wstat64i32__arg1__notnull() {
  // cppcheck-suppress nullPointer
  _wstat64i32(NULL, arg2);
}

void test___wstat64i32__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _wstat64i32(x, arg2);
}

void test___wstat64i32__arg2__notnull() {
  // cppcheck-suppress nullPointer
  _wstat64i32(arg1, NULL);
}

void test___fstat__noreturn() {
  int x = 1;
  if (cond) { x=100; _fstat(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___fstat__leakignore() {
  char *p = malloc(10); *p=0;
  _fstat(p, arg2);
  // cppcheck-suppress memleak
}

void test___fstat__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _fstat(x, arg2);
}

void test___fstat__arg2__notnull() {
  // cppcheck-suppress nullPointer
  _fstat(arg1, NULL);
}

void test___fstat32__noreturn() {
  int x = 1;
  if (cond) { x=100; _fstat32(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___fstat32__leakignore() {
  char *p = malloc(10); *p=0;
  _fstat32(p, arg2);
  // cppcheck-suppress memleak
}

void test___fstat32__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _fstat32(x, arg2);
}

void test___fstat32__arg2__notnull() {
  // cppcheck-suppress nullPointer
  _fstat32(arg1, NULL);
}

void test___fstat64__noreturn() {
  int x = 1;
  if (cond) { x=100; _fstat64(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___fstat64__leakignore() {
  char *p = malloc(10); *p=0;
  _fstat64(p, arg2);
  // cppcheck-suppress memleak
}

void test___fstat64__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _fstat64(x, arg2);
}

void test___fstat64__arg2__notnull() {
  // cppcheck-suppress nullPointer
  _fstat64(arg1, NULL);
}

void test___fstati64__noreturn() {
  int x = 1;
  if (cond) { x=100; _fstati64(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___fstati64__leakignore() {
  char *p = malloc(10); *p=0;
  _fstati64(p, arg2);
  // cppcheck-suppress memleak
}

void test___fstati64__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _fstati64(x, arg2);
}

void test___fstati64__arg2__notnull() {
  // cppcheck-suppress nullPointer
  _fstati64(arg1, NULL);
}

void test___fstat32i64__noreturn() {
  int x = 1;
  if (cond) { x=100; _fstat32i64(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___fstat32i64__leakignore() {
  char *p = malloc(10); *p=0;
  _fstat32i64(p, arg2);
  // cppcheck-suppress memleak
}

void test___fstat32i64__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _fstat32i64(x, arg2);
}

void test___fstat32i64__arg2__notnull() {
  // cppcheck-suppress nullPointer
  _fstat32i64(arg1, NULL);
}

void test___fstat64i32__noreturn() {
  int x = 1;
  if (cond) { x=100; _fstat64i32(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___fstat64i32__leakignore() {
  char *p = malloc(10); *p=0;
  _fstat64i32(p, arg2);
  // cppcheck-suppress memleak
}

void test___fstat64i32__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _fstat64i32(x, arg2);
}

void test___fstat64i32__arg2__notnull() {
  // cppcheck-suppress nullPointer
  _fstat64i32(arg1, NULL);
}

void test___fseeki64__noreturn() {
  int x = 1;
  if (cond) { x=100; _fseeki64(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___fseeki64__leakignore() {
  char *p = malloc(10); *p=0;
  _fseeki64(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test___fseeki64__arg1__notnull() {
  // cppcheck-suppress nullPointer
  _fseeki64(NULL, arg2, arg3);
}

void test___fseeki64__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _fseeki64(x, arg2, arg3);
}

void test___fseeki64__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _fseeki64(arg1, x, arg3);
}

void test___fseeki64__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _fseeki64(arg1, arg2, x);
}

void test___ftelli64__noreturn() {
  int x = 1;
  if (cond) { x=100; result = _ftelli64(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___ftelli64__useretval() {
  // cppcheck-suppress ignoredReturnValue
  _ftelli64(arg1);
}

void test___ftelli64__leakignore() {
  char *p = malloc(10); *p=0;
  result = _ftelli64(p);
  // cppcheck-suppress memleak
}

void test___ftelli64__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = _ftelli64(NULL);
}

void test___ftelli64__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _ftelli64(x);
}

void test___ftell_nolock__noreturn() {
  int x = 1;
  if (cond) { x=100; result = _ftell_nolock(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___ftell_nolock__useretval() {
  // cppcheck-suppress ignoredReturnValue
  _ftell_nolock(arg1);
}

void test___ftell_nolock__leakignore() {
  char *p = malloc(10); *p=0;
  result = _ftell_nolock(p);
  // cppcheck-suppress memleak
}

void test___ftell_nolock__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = _ftell_nolock(NULL);
}

void test___ftell_nolock__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _ftell_nolock(x);
}

void test___ftelli64_nolock__noreturn() {
  int x = 1;
  if (cond) { x=100; result = _ftelli64_nolock(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___ftelli64_nolock__useretval() {
  // cppcheck-suppress ignoredReturnValue
  _ftelli64_nolock(arg1);
}

void test___ftelli64_nolock__leakignore() {
  char *p = malloc(10); *p=0;
  result = _ftelli64_nolock(p);
  // cppcheck-suppress memleak
}

void test___ftelli64_nolock__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = _ftelli64_nolock(NULL);
}

void test___ftelli64_nolock__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _ftelli64_nolock(x);
}

void test___wfopen__noreturn() {
  int x = 1;
  if (cond) { x=100; result = _wfopen(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___wfopen__useretval() {
  // cppcheck-suppress ignoredReturnValue
  _wfopen(arg1, arg2);
}

void test___wfopen__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = _wfopen(NULL, arg2);
}

void test___wfopen__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _wfopen(x, arg2);
}

void test___wfopen__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = _wfopen(arg1, NULL);
}

void test___wfopen__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _wfopen(arg1, x);
}

void test___tfopen__noreturn() {
  int x = 1;
  if (cond) { x=100; result = _tfopen(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___tfopen__useretval() {
  // cppcheck-suppress ignoredReturnValue
  _tfopen(arg1, arg2);
}

void test___tfopen__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = _tfopen(NULL, arg2);
}

void test___tfopen__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _tfopen(x, arg2);
}

void test___tfopen__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = _tfopen(arg1, NULL);
}

void test___tfopen__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _tfopen(arg1, x);
}

void test__strnlen_s__noreturn() {
  int x = 1;
  if (cond) { x=100; result = strnlen_s(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__strnlen_s__useretval() {
  // cppcheck-suppress ignoredReturnValue
  strnlen_s(arg1, arg2);
}

void test__strnlen_s__leakignore() {
  char *p = malloc(10); *p=0;
  result = strnlen_s(p, arg2);
  // cppcheck-suppress memleak
}

void test__strnlen_s__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = strnlen_s(NULL, arg2);
}

void test__strnlen_s__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = strnlen_s(x, arg2);
}

void test__strnlen_s__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = strnlen_s(arg1, x);
}

void test__wcsnlen_s__noreturn() {
  int x = 1;
  if (cond) { x=100; result = wcsnlen_s(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__wcsnlen_s__useretval() {
  // cppcheck-suppress ignoredReturnValue
  wcsnlen_s(arg1, arg2);
}

void test__wcsnlen_s__leakignore() {
  char *p = malloc(10); *p=0;
  result = wcsnlen_s(p, arg2);
  // cppcheck-suppress memleak
}

void test__wcsnlen_s__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = wcsnlen_s(NULL, arg2);
}

void test__wcsnlen_s__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = wcsnlen_s(x, arg2);
}

void test__wcsnlen_s__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = wcsnlen_s(arg1, x);
}

void test___mbsnlen__noreturn() {
  int x = 1;
  if (cond) { x=100; result = _mbsnlen(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___mbsnlen__useretval() {
  // cppcheck-suppress ignoredReturnValue
  _mbsnlen(arg1, arg2);
}

void test___mbsnlen__leakignore() {
  char *p = malloc(10); *p=0;
  result = _mbsnlen(p, arg2);
  // cppcheck-suppress memleak
}

void test___mbsnlen__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = _mbsnlen(NULL, arg2);
}

void test___mbsnlen__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _mbsnlen(x, arg2);
}

void test___mbsnlen__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = _mbsnlen(arg1, x);
}

void test___mbstrnlen__noreturn() {
  int x = 1;
  if (cond) { x=100; result = _mbstrnlen(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___mbstrnlen__useretval() {
  // cppcheck-suppress ignoredReturnValue
  _mbstrnlen(arg1, arg2);
}

void test___mbstrnlen__leakignore() {
  char *p = malloc(10); *p=0;
  result = _mbstrnlen(p, arg2);
  // cppcheck-suppress memleak
}

void test___mbstrnlen__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = _mbstrnlen(NULL, arg2);
}

void test___mbstrnlen__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _mbstrnlen(x, arg2);
}

void test___mbstrnlen__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = _mbstrnlen(arg1, x);
}

void test___mbsnlen_l__noreturn() {
  int x = 1;
  if (cond) { x=100; result = _mbsnlen_l(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___mbsnlen_l__useretval() {
  // cppcheck-suppress ignoredReturnValue
  _mbsnlen_l(arg1, arg2, arg3);
}

void test___mbsnlen_l__leakignore() {
  char *p = malloc(10); *p=0;
  result = _mbsnlen_l(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test___mbsnlen_l__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = _mbsnlen_l(NULL, arg2, arg3);
}

void test___mbsnlen_l__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _mbsnlen_l(x, arg2, arg3);
}

void test___mbsnlen_l__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = _mbsnlen_l(arg1, x, arg3);
}

void test___mbsnlen_l__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = _mbsnlen_l(arg1, arg2, x);
}

void test___mbstrnlen_l__noreturn() {
  int x = 1;
  if (cond) { x=100; result = _mbstrnlen_l(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___mbstrnlen_l__useretval() {
  // cppcheck-suppress ignoredReturnValue
  _mbstrnlen_l(arg1, arg2, arg3);
}

void test___mbstrnlen_l__leakignore() {
  char *p = malloc(10); *p=0;
  result = _mbstrnlen_l(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test___mbstrnlen_l__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = _mbstrnlen_l(NULL, arg2, arg3);
}

void test___mbstrnlen_l__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _mbstrnlen_l(x, arg2, arg3);
}

void test___mbstrnlen_l__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = _mbstrnlen_l(arg1, x, arg3);
}

void test___mbstrnlen_l__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = _mbstrnlen_l(arg1, arg2, x);
}

void test__WideCharToMultiByte__noreturn() {
  int x = 1;
  if (cond) { x=100; WideCharToMultiByte(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__WideCharToMultiByte__leakignore() {
  char *p = malloc(10); *p=0;
  WideCharToMultiByte(p, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
  // cppcheck-suppress memleak
}

void test__WideCharToMultiByte__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  WideCharToMultiByte(x, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
}

void test__WideCharToMultiByte__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  WideCharToMultiByte(arg1, x, arg3, arg4, arg5, arg6, arg7, arg8);
}

void test__WideCharToMultiByte__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  WideCharToMultiByte(arg1, arg2, x, arg4, arg5, arg6, arg7, arg8);
}

void test__WideCharToMultiByte__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  WideCharToMultiByte(arg1, arg2, arg3, x, arg5, arg6, arg7, arg8);
}

void test__WideCharToMultiByte__arg6__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  WideCharToMultiByte(arg1, arg2, arg3, arg4, arg5, x, arg7, arg8);
}

void test__WideCharToMultiByte__arg7__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  WideCharToMultiByte(arg1, arg2, arg3, arg4, arg5, arg6, x, arg8);
}

void test__PathIsDirectory__noreturn() {
  int x = 1;
  if (cond) { x=100; result = PathIsDirectory(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__PathIsDirectory__useretval() {
  // cppcheck-suppress ignoredReturnValue
  PathIsDirectory(arg1);
}

void test__PathIsDirectory__leakignore() {
  char *p = malloc(10); *p=0;
  result = PathIsDirectory(p);
  // cppcheck-suppress memleak
}

void test__PathIsDirectory__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = PathIsDirectory(x);
}

void test__PathIsDirectoryA__noreturn() {
  int x = 1;
  if (cond) { x=100; result = PathIsDirectoryA(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__PathIsDirectoryA__useretval() {
  // cppcheck-suppress ignoredReturnValue
  PathIsDirectoryA(arg1);
}

void test__PathIsDirectoryA__leakignore() {
  char *p = malloc(10); *p=0;
  result = PathIsDirectoryA(p);
  // cppcheck-suppress memleak
}

void test__PathIsDirectoryA__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = PathIsDirectoryA(x);
}

void test__PathIsDirectoryW__noreturn() {
  int x = 1;
  if (cond) { x=100; result = PathIsDirectoryW(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__PathIsDirectoryW__useretval() {
  // cppcheck-suppress ignoredReturnValue
  PathIsDirectoryW(arg1);
}

void test__PathIsDirectoryW__leakignore() {
  char *p = malloc(10); *p=0;
  result = PathIsDirectoryW(p);
  // cppcheck-suppress memleak
}

void test__PathIsDirectoryW__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = PathIsDirectoryW(x);
}

void test__SetConsoleTextAttribute__noreturn() {
  int x = 1;
  if (cond) { x=100; SetConsoleTextAttribute(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__SetConsoleTextAttribute__leakignore() {
  char *p = malloc(10); *p=0;
  SetConsoleTextAttribute(p, arg2);
  // cppcheck-suppress memleak
}

void test__SetConsoleTextAttribute__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  SetConsoleTextAttribute(x, arg2);
}

void test__SetConsoleTextAttribute__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  SetConsoleTextAttribute(arg1, x);
}

void test___wfopen_s__noreturn() {
  int x = 1;
  if (cond) { x=100; _wfopen_s(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___wfopen_s__arg1__notnull() {
  // cppcheck-suppress nullPointer
  _wfopen_s(NULL, arg2, arg3);
}

void test___wfopen_s__arg2__notnull() {
  // cppcheck-suppress nullPointer
  _wfopen_s(arg1, NULL, arg3);
}

void test___wfopen_s__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _wfopen_s(arg1, x, arg3);
}

void test___wfopen_s__arg3__notnull() {
  // cppcheck-suppress nullPointer
  _wfopen_s(arg1, arg2, NULL);
}

void test___wfopen_s__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _wfopen_s(arg1, arg2, x);
}

void test___tfopen_s__noreturn() {
  int x = 1;
  if (cond) { x=100; _tfopen_s(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___tfopen_s__arg1__notnull() {
  // cppcheck-suppress nullPointer
  _tfopen_s(NULL, arg2, arg3);
}

void test___tfopen_s__arg2__notnull() {
  // cppcheck-suppress nullPointer
  _tfopen_s(arg1, NULL, arg3);
}

void test___tfopen_s__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _tfopen_s(arg1, x, arg3);
}

void test___tfopen_s__arg3__notnull() {
  // cppcheck-suppress nullPointer
  _tfopen_s(arg1, arg2, NULL);
}

void test___tfopen_s__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _tfopen_s(arg1, arg2, x);
}

void test__DeleteFile__noreturn() {
  int x = 1;
  if (cond) { x=100; DeleteFile(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__DeleteFile__leakignore() {
  char *p = malloc(10); *p=0;
  DeleteFile(p);
  // cppcheck-suppress memleak
}

void test__DeleteFile__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  DeleteFile(x);
}

void test__DeleteFileA__noreturn() {
  int x = 1;
  if (cond) { x=100; DeleteFileA(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__DeleteFileA__leakignore() {
  char *p = malloc(10); *p=0;
  DeleteFileA(p);
  // cppcheck-suppress memleak
}

void test__DeleteFileA__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  DeleteFileA(x);
}

void test__DeleteFileW__noreturn() {
  int x = 1;
  if (cond) { x=100; DeleteFileW(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__DeleteFileW__leakignore() {
  char *p = malloc(10); *p=0;
  DeleteFileW(p);
  // cppcheck-suppress memleak
}

void test__DeleteFileW__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  DeleteFileW(x);
}

void test__GetStdHandle__noreturn() {
  int x = 1;
  if (cond) { x=100; result = GetStdHandle(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__GetStdHandle__useretval() {
  // cppcheck-suppress ignoredReturnValue
  GetStdHandle(arg1);
}

void test__GetStdHandle__leakignore() {
  char *p = malloc(10); *p=0;
  result = GetStdHandle(p);
  // cppcheck-suppress memleak
}

void test__GetStdHandle__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = GetStdHandle(x);
}

void test__SetStdHandle__noreturn() {
  int x = 1;
  if (cond) { x=100; SetStdHandle(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__SetStdHandle__leakignore() {
  char *p = malloc(10); *p=0;
  SetStdHandle(p, arg2);
  // cppcheck-suppress memleak
}

void test__SetStdHandle__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  SetStdHandle(x, arg2);
}

void test__SetStdHandle__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  SetStdHandle(arg1, x);
}

void test___access__noreturn() {
  int x = 1;
  if (cond) { x=100; _access(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___access__leakignore() {
  char *p = malloc(10); *p=0;
  _access(p, arg2);
  // cppcheck-suppress memleak
}

void test___access__arg1__notnull() {
  // cppcheck-suppress nullPointer
  _access(NULL, arg2);
}

void test___access__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _access(x, arg2);
}

void test___access__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _access(arg1, x);
}

void test___waccess__noreturn() {
  int x = 1;
  if (cond) { x=100; _waccess(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___waccess__leakignore() {
  char *p = malloc(10); *p=0;
  _waccess(p, arg2);
  // cppcheck-suppress memleak
}

void test___waccess__arg1__notnull() {
  // cppcheck-suppress nullPointer
  _waccess(NULL, arg2);
}

void test___waccess__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _waccess(x, arg2);
}

void test___waccess__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _waccess(arg1, x);
}

void test___taccess__noreturn() {
  int x = 1;
  if (cond) { x=100; _taccess(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___taccess__leakignore() {
  char *p = malloc(10); *p=0;
  _taccess(p, arg2);
  // cppcheck-suppress memleak
}

void test___taccess__arg1__notnull() {
  // cppcheck-suppress nullPointer
  _taccess(NULL, arg2);
}

void test___taccess__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _taccess(x, arg2);
}

void test___taccess__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _taccess(arg1, x);
}

void test__PeekMessage__noreturn() {
  int x = 1;
  if (cond) { x=100; PeekMessage(arg1, arg2, arg3, arg4, arg5); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__PeekMessage__leakignore() {
  char *p = malloc(10); *p=0;
  PeekMessage(p, arg2, arg3, arg4, arg5);
  // cppcheck-suppress memleak
}

void test__PeekMessage__arg1__notnull() {
  // cppcheck-suppress nullPointer
  PeekMessage(NULL, arg2, arg3, arg4, arg5);
}

void test__PeekMessage__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  PeekMessage(arg1, x, arg3, arg4, arg5);
}

void test__PeekMessage__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  PeekMessage(arg1, arg2, x, arg4, arg5);
}

void test__PeekMessage__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  PeekMessage(arg1, arg2, arg3, x, arg5);
}

void test__PeekMessage__arg5__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  PeekMessage(arg1, arg2, arg3, arg4, x);
}

void test__PeekMessageA__noreturn() {
  int x = 1;
  if (cond) { x=100; PeekMessageA(arg1, arg2, arg3, arg4, arg5); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__PeekMessageA__leakignore() {
  char *p = malloc(10); *p=0;
  PeekMessageA(p, arg2, arg3, arg4, arg5);
  // cppcheck-suppress memleak
}

void test__PeekMessageA__arg1__notnull() {
  // cppcheck-suppress nullPointer
  PeekMessageA(NULL, arg2, arg3, arg4, arg5);
}

void test__PeekMessageA__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  PeekMessageA(arg1, x, arg3, arg4, arg5);
}

void test__PeekMessageA__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  PeekMessageA(arg1, arg2, x, arg4, arg5);
}

void test__PeekMessageA__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  PeekMessageA(arg1, arg2, arg3, x, arg5);
}

void test__PeekMessageA__arg5__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  PeekMessageA(arg1, arg2, arg3, arg4, x);
}

void test__PeekMessageW__noreturn() {
  int x = 1;
  if (cond) { x=100; PeekMessageW(arg1, arg2, arg3, arg4, arg5); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__PeekMessageW__leakignore() {
  char *p = malloc(10); *p=0;
  PeekMessageW(p, arg2, arg3, arg4, arg5);
  // cppcheck-suppress memleak
}

void test__PeekMessageW__arg1__notnull() {
  // cppcheck-suppress nullPointer
  PeekMessageW(NULL, arg2, arg3, arg4, arg5);
}

void test__PeekMessageW__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  PeekMessageW(arg1, x, arg3, arg4, arg5);
}

void test__PeekMessageW__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  PeekMessageW(arg1, arg2, x, arg4, arg5);
}

void test__PeekMessageW__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  PeekMessageW(arg1, arg2, arg3, x, arg5);
}

void test__PeekMessageW__arg5__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  PeekMessageW(arg1, arg2, arg3, arg4, x);
}

void test__GetMessage__noreturn() {
  int x = 1;
  if (cond) { x=100; GetMessage(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__GetMessage__leakignore() {
  char *p = malloc(10); *p=0;
  GetMessage(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test__GetMessage__arg1__notnull() {
  // cppcheck-suppress nullPointer
  GetMessage(NULL, arg2, arg3, arg4);
}

void test__GetMessage__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  GetMessage(arg1, x, arg3, arg4);
}

void test__GetMessage__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  GetMessage(arg1, arg2, x, arg4);
}

void test__GetMessage__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  GetMessage(arg1, arg2, arg3, x);
}

void test__GetMessageA__noreturn() {
  int x = 1;
  if (cond) { x=100; GetMessageA(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__GetMessageA__leakignore() {
  char *p = malloc(10); *p=0;
  GetMessageA(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test__GetMessageA__arg1__notnull() {
  // cppcheck-suppress nullPointer
  GetMessageA(NULL, arg2, arg3, arg4);
}

void test__GetMessageA__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  GetMessageA(arg1, x, arg3, arg4);
}

void test__GetMessageA__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  GetMessageA(arg1, arg2, x, arg4);
}

void test__GetMessageA__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  GetMessageA(arg1, arg2, arg3, x);
}

void test__GetMessageW__noreturn() {
  int x = 1;
  if (cond) { x=100; GetMessageW(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__GetMessageW__leakignore() {
  char *p = malloc(10); *p=0;
  GetMessageW(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test__GetMessageW__arg1__notnull() {
  // cppcheck-suppress nullPointer
  GetMessageW(NULL, arg2, arg3, arg4);
}

void test__GetMessageW__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  GetMessageW(arg1, x, arg3, arg4);
}

void test__GetMessageW__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  GetMessageW(arg1, arg2, x, arg4);
}

void test__GetMessageW__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  GetMessageW(arg1, arg2, arg3, x);
}

void test__TranslateMessage__noreturn() {
  int x = 1;
  if (cond) { x=100; TranslateMessage(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__TranslateMessage__leakignore() {
  char *p = malloc(10); *p=0;
  TranslateMessage(p);
  // cppcheck-suppress memleak
}

void test__TranslateMessage__arg1__notnull() {
  // cppcheck-suppress nullPointer
  TranslateMessage(NULL);
}

void test__TranslateMessage__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  TranslateMessage(x);
}

void test__DispatchMessage__noreturn() {
  int x = 1;
  if (cond) { x=100; DispatchMessage(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__DispatchMessage__leakignore() {
  char *p = malloc(10); *p=0;
  DispatchMessage(p);
  // cppcheck-suppress memleak
}

void test__DispatchMessage__arg1__notnull() {
  // cppcheck-suppress nullPointer
  DispatchMessage(NULL);
}

void test__DispatchMessage__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  DispatchMessage(x);
}

void test__DispatchMessageA__noreturn() {
  int x = 1;
  if (cond) { x=100; DispatchMessageA(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__DispatchMessageA__leakignore() {
  char *p = malloc(10); *p=0;
  DispatchMessageA(p);
  // cppcheck-suppress memleak
}

void test__DispatchMessageA__arg1__notnull() {
  // cppcheck-suppress nullPointer
  DispatchMessageA(NULL);
}

void test__DispatchMessageA__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  DispatchMessageA(x);
}

void test__DispatchMessageW__noreturn() {
  int x = 1;
  if (cond) { x=100; DispatchMessageW(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__DispatchMessageW__leakignore() {
  char *p = malloc(10); *p=0;
  DispatchMessageW(p);
  // cppcheck-suppress memleak
}

void test__DispatchMessageW__arg1__notnull() {
  // cppcheck-suppress nullPointer
  DispatchMessageW(NULL);
}

void test__DispatchMessageW__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  DispatchMessageW(x);
}

void test__SendMessage__noreturn() {
  int x = 1;
  if (cond) { x=100; SendMessage(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__SendMessage__arg1__notnull() {
  // cppcheck-suppress nullPointer
  SendMessage(NULL, arg2, arg3, arg4);
}

void test__SendMessage__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  SendMessage(x, arg2, arg3, arg4);
}

void test__SendMessage__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  SendMessage(arg1, x, arg3, arg4);
}

void test__SendMessage__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  SendMessage(arg1, arg2, x, arg4);
}

void test__SendMessage__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  SendMessage(arg1, arg2, arg3, x);
}

void test__SendMessageA__noreturn() {
  int x = 1;
  if (cond) { x=100; SendMessageA(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__SendMessageA__arg1__notnull() {
  // cppcheck-suppress nullPointer
  SendMessageA(NULL, arg2, arg3, arg4);
}

void test__SendMessageA__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  SendMessageA(x, arg2, arg3, arg4);
}

void test__SendMessageA__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  SendMessageA(arg1, x, arg3, arg4);
}

void test__SendMessageA__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  SendMessageA(arg1, arg2, x, arg4);
}

void test__SendMessageA__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  SendMessageA(arg1, arg2, arg3, x);
}

void test__SendMessageW__noreturn() {
  int x = 1;
  if (cond) { x=100; SendMessageW(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__SendMessageW__arg1__notnull() {
  // cppcheck-suppress nullPointer
  SendMessageW(NULL, arg2, arg3, arg4);
}

void test__SendMessageW__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  SendMessageW(x, arg2, arg3, arg4);
}

void test__SendMessageW__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  SendMessageW(arg1, x, arg3, arg4);
}

void test__SendMessageW__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  SendMessageW(arg1, arg2, x, arg4);
}

void test__SendMessageW__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  SendMessageW(arg1, arg2, arg3, x);
}

void test__PostMessage__noreturn() {
  int x = 1;
  if (cond) { x=100; PostMessage(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__PostMessage__arg1__notnull() {
  // cppcheck-suppress nullPointer
  PostMessage(NULL, arg2, arg3, arg4);
}

void test__PostMessage__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  PostMessage(x, arg2, arg3, arg4);
}

void test__PostMessage__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  PostMessage(arg1, x, arg3, arg4);
}

void test__PostMessage__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  PostMessage(arg1, arg2, x, arg4);
}

void test__PostMessage__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  PostMessage(arg1, arg2, arg3, x);
}

void test__PostMessageA__noreturn() {
  int x = 1;
  if (cond) { x=100; PostMessageA(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__PostMessageA__arg1__notnull() {
  // cppcheck-suppress nullPointer
  PostMessageA(NULL, arg2, arg3, arg4);
}

void test__PostMessageA__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  PostMessageA(x, arg2, arg3, arg4);
}

void test__PostMessageA__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  PostMessageA(arg1, x, arg3, arg4);
}

void test__PostMessageA__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  PostMessageA(arg1, arg2, x, arg4);
}

void test__PostMessageA__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  PostMessageA(arg1, arg2, arg3, x);
}

void test__PostMessageW__noreturn() {
  int x = 1;
  if (cond) { x=100; PostMessageW(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__PostMessageW__arg1__notnull() {
  // cppcheck-suppress nullPointer
  PostMessageW(NULL, arg2, arg3, arg4);
}

void test__PostMessageW__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  PostMessageW(x, arg2, arg3, arg4);
}

void test__PostMessageW__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  PostMessageW(arg1, x, arg3, arg4);
}

void test__PostMessageW__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  PostMessageW(arg1, arg2, x, arg4);
}

void test__PostMessageW__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  PostMessageW(arg1, arg2, arg3, x);
}

void test__PostQuitMessage__noreturn() {
  int x = 1;
  if (cond) { x=100; PostQuitMessage(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__PostQuitMessage__leakignore() {
  char *p = malloc(10); *p=0;
  PostQuitMessage(p);
  // cppcheck-suppress memleak
}

void test__PostQuitMessage__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  PostQuitMessage(x);
}

void test__DefWindowProc__noreturn() {
  int x = 1;
  if (cond) { x=100; DefWindowProc(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__DefWindowProc__leakignore() {
  char *p = malloc(10); *p=0;
  DefWindowProc(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test__DefWindowProc__arg1__notnull() {
  // cppcheck-suppress nullPointer
  DefWindowProc(NULL, arg2, arg3, arg4);
}

void test__DefWindowProc__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  DefWindowProc(x, arg2, arg3, arg4);
}

void test__DefWindowProc__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  DefWindowProc(arg1, x, arg3, arg4);
}

void test__DefWindowProc__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  DefWindowProc(arg1, arg2, x, arg4);
}

void test__DefWindowProc__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  DefWindowProc(arg1, arg2, arg3, x);
}

void test__DefWindowProcA__noreturn() {
  int x = 1;
  if (cond) { x=100; DefWindowProcA(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__DefWindowProcA__leakignore() {
  char *p = malloc(10); *p=0;
  DefWindowProcA(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test__DefWindowProcA__arg1__notnull() {
  // cppcheck-suppress nullPointer
  DefWindowProcA(NULL, arg2, arg3, arg4);
}

void test__DefWindowProcA__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  DefWindowProcA(x, arg2, arg3, arg4);
}

void test__DefWindowProcA__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  DefWindowProcA(arg1, x, arg3, arg4);
}

void test__DefWindowProcA__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  DefWindowProcA(arg1, arg2, x, arg4);
}

void test__DefWindowProcA__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  DefWindowProcA(arg1, arg2, arg3, x);
}

void test__DefWindowProcW__noreturn() {
  int x = 1;
  if (cond) { x=100; DefWindowProcW(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__DefWindowProcW__leakignore() {
  char *p = malloc(10); *p=0;
  DefWindowProcW(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test__DefWindowProcW__arg1__notnull() {
  // cppcheck-suppress nullPointer
  DefWindowProcW(NULL, arg2, arg3, arg4);
}

void test__DefWindowProcW__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  DefWindowProcW(x, arg2, arg3, arg4);
}

void test__DefWindowProcW__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  DefWindowProcW(arg1, x, arg3, arg4);
}

void test__DefWindowProcW__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  DefWindowProcW(arg1, arg2, x, arg4);
}

void test__DefWindowProcW__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  DefWindowProcW(arg1, arg2, arg3, x);
}

void test__GetPrivateProfileInt__noreturn() {
  int x = 1;
  if (cond) { x=100; result = GetPrivateProfileInt(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__GetPrivateProfileInt__useretval() {
  // cppcheck-suppress ignoredReturnValue
  GetPrivateProfileInt(arg1, arg2, arg3, arg4);
}

void test__GetPrivateProfileInt__leakignore() {
  char *p = malloc(10); *p=0;
  result = GetPrivateProfileInt(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test__GetPrivateProfileInt__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = GetPrivateProfileInt(NULL, arg2, arg3, arg4);
}

void test__GetPrivateProfileInt__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = GetPrivateProfileInt(x, arg2, arg3, arg4);
}

void test__GetPrivateProfileInt__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = GetPrivateProfileInt(arg1, NULL, arg3, arg4);
}

void test__GetPrivateProfileInt__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = GetPrivateProfileInt(arg1, x, arg3, arg4);
}

void test__GetPrivateProfileInt__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = GetPrivateProfileInt(arg1, arg2, x, arg4);
}

void test__GetPrivateProfileInt__arg4__notnull() {
  // cppcheck-suppress nullPointer
  result = GetPrivateProfileInt(arg1, arg2, arg3, NULL);
}

void test__GetPrivateProfileInt__arg4__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = GetPrivateProfileInt(arg1, arg2, arg3, x);
}

void test__GetPrivateProfileIntA__noreturn() {
  int x = 1;
  if (cond) { x=100; result = GetPrivateProfileIntA(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__GetPrivateProfileIntA__useretval() {
  // cppcheck-suppress ignoredReturnValue
  GetPrivateProfileIntA(arg1, arg2, arg3, arg4);
}

void test__GetPrivateProfileIntA__leakignore() {
  char *p = malloc(10); *p=0;
  result = GetPrivateProfileIntA(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test__GetPrivateProfileIntA__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = GetPrivateProfileIntA(NULL, arg2, arg3, arg4);
}

void test__GetPrivateProfileIntA__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = GetPrivateProfileIntA(x, arg2, arg3, arg4);
}

void test__GetPrivateProfileIntA__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = GetPrivateProfileIntA(arg1, NULL, arg3, arg4);
}

void test__GetPrivateProfileIntA__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = GetPrivateProfileIntA(arg1, x, arg3, arg4);
}

void test__GetPrivateProfileIntA__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = GetPrivateProfileIntA(arg1, arg2, x, arg4);
}

void test__GetPrivateProfileIntA__arg4__notnull() {
  // cppcheck-suppress nullPointer
  result = GetPrivateProfileIntA(arg1, arg2, arg3, NULL);
}

void test__GetPrivateProfileIntA__arg4__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = GetPrivateProfileIntA(arg1, arg2, arg3, x);
}

void test__GetPrivateProfileIntW__noreturn() {
  int x = 1;
  if (cond) { x=100; result = GetPrivateProfileIntW(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__GetPrivateProfileIntW__useretval() {
  // cppcheck-suppress ignoredReturnValue
  GetPrivateProfileIntW(arg1, arg2, arg3, arg4);
}

void test__GetPrivateProfileIntW__leakignore() {
  char *p = malloc(10); *p=0;
  result = GetPrivateProfileIntW(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test__GetPrivateProfileIntW__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = GetPrivateProfileIntW(NULL, arg2, arg3, arg4);
}

void test__GetPrivateProfileIntW__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = GetPrivateProfileIntW(x, arg2, arg3, arg4);
}

void test__GetPrivateProfileIntW__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = GetPrivateProfileIntW(arg1, NULL, arg3, arg4);
}

void test__GetPrivateProfileIntW__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = GetPrivateProfileIntW(arg1, x, arg3, arg4);
}

void test__GetPrivateProfileIntW__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = GetPrivateProfileIntW(arg1, arg2, x, arg4);
}

void test__GetPrivateProfileIntW__arg4__notnull() {
  // cppcheck-suppress nullPointer
  result = GetPrivateProfileIntW(arg1, arg2, arg3, NULL);
}

void test__GetPrivateProfileIntW__arg4__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = GetPrivateProfileIntW(arg1, arg2, arg3, x);
}

void test__GetPrivateProfileSection__noreturn() {
  int x = 1;
  if (cond) { x=100; GetPrivateProfileSection(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__GetPrivateProfileSection__leakignore() {
  char *p = malloc(10); *p=0;
  GetPrivateProfileSection(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test__GetPrivateProfileSection__arg1__notnull() {
  // cppcheck-suppress nullPointer
  GetPrivateProfileSection(NULL, arg2, arg3, arg4);
}

void test__GetPrivateProfileSection__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  GetPrivateProfileSection(x, arg2, arg3, arg4);
}

void test__GetPrivateProfileSection__arg2__notnull() {
  // cppcheck-suppress nullPointer
  GetPrivateProfileSection(arg1, NULL, arg3, arg4);
}

void test__GetPrivateProfileSection__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  GetPrivateProfileSection(arg1, arg2, x, arg4);
}

void test__GetPrivateProfileSection__arg4__notnull() {
  // cppcheck-suppress nullPointer
  GetPrivateProfileSection(arg1, arg2, arg3, NULL);
}

void test__GetPrivateProfileSection__arg4__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  GetPrivateProfileSection(arg1, arg2, arg3, x);
}

void test__GetPrivateProfileSectionA__noreturn() {
  int x = 1;
  if (cond) { x=100; GetPrivateProfileSectionA(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__GetPrivateProfileSectionA__leakignore() {
  char *p = malloc(10); *p=0;
  GetPrivateProfileSectionA(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test__GetPrivateProfileSectionA__arg1__notnull() {
  // cppcheck-suppress nullPointer
  GetPrivateProfileSectionA(NULL, arg2, arg3, arg4);
}

void test__GetPrivateProfileSectionA__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  GetPrivateProfileSectionA(x, arg2, arg3, arg4);
}

void test__GetPrivateProfileSectionA__arg2__notnull() {
  // cppcheck-suppress nullPointer
  GetPrivateProfileSectionA(arg1, NULL, arg3, arg4);
}

void test__GetPrivateProfileSectionA__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  GetPrivateProfileSectionA(arg1, arg2, x, arg4);
}

void test__GetPrivateProfileSectionA__arg4__notnull() {
  // cppcheck-suppress nullPointer
  GetPrivateProfileSectionA(arg1, arg2, arg3, NULL);
}

void test__GetPrivateProfileSectionA__arg4__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  GetPrivateProfileSectionA(arg1, arg2, arg3, x);
}

void test__GetPrivateProfileSectionW__noreturn() {
  int x = 1;
  if (cond) { x=100; GetPrivateProfileSectionW(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__GetPrivateProfileSectionW__leakignore() {
  char *p = malloc(10); *p=0;
  GetPrivateProfileSectionW(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test__GetPrivateProfileSectionW__arg1__notnull() {
  // cppcheck-suppress nullPointer
  GetPrivateProfileSectionW(NULL, arg2, arg3, arg4);
}

void test__GetPrivateProfileSectionW__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  GetPrivateProfileSectionW(x, arg2, arg3, arg4);
}

void test__GetPrivateProfileSectionW__arg2__notnull() {
  // cppcheck-suppress nullPointer
  GetPrivateProfileSectionW(arg1, NULL, arg3, arg4);
}

void test__GetPrivateProfileSectionW__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  GetPrivateProfileSectionW(arg1, arg2, x, arg4);
}

void test__GetPrivateProfileSectionW__arg4__notnull() {
  // cppcheck-suppress nullPointer
  GetPrivateProfileSectionW(arg1, arg2, arg3, NULL);
}

void test__GetPrivateProfileSectionW__arg4__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  GetPrivateProfileSectionW(arg1, arg2, arg3, x);
}

void test__GetPrivateProfileSectionNames__noreturn() {
  int x = 1;
  if (cond) { x=100; GetPrivateProfileSectionNames(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__GetPrivateProfileSectionNames__leakignore() {
  char *p = malloc(10); *p=0;
  GetPrivateProfileSectionNames(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__GetPrivateProfileSectionNames__arg1__notnull() {
  // cppcheck-suppress nullPointer
  GetPrivateProfileSectionNames(NULL, arg2, arg3);
}

void test__GetPrivateProfileSectionNames__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  GetPrivateProfileSectionNames(arg1, x, arg3);
}

void test__GetPrivateProfileSectionNames__arg3__notnull() {
  // cppcheck-suppress nullPointer
  GetPrivateProfileSectionNames(arg1, arg2, NULL);
}

void test__GetPrivateProfileSectionNames__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  GetPrivateProfileSectionNames(arg1, arg2, x);
}

void test__GetPrivateProfileSectionNamesA__noreturn() {
  int x = 1;
  if (cond) { x=100; GetPrivateProfileSectionNamesA(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__GetPrivateProfileSectionNamesA__leakignore() {
  char *p = malloc(10); *p=0;
  GetPrivateProfileSectionNamesA(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__GetPrivateProfileSectionNamesA__arg1__notnull() {
  // cppcheck-suppress nullPointer
  GetPrivateProfileSectionNamesA(NULL, arg2, arg3);
}

void test__GetPrivateProfileSectionNamesA__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  GetPrivateProfileSectionNamesA(arg1, x, arg3);
}

void test__GetPrivateProfileSectionNamesA__arg3__notnull() {
  // cppcheck-suppress nullPointer
  GetPrivateProfileSectionNamesA(arg1, arg2, NULL);
}

void test__GetPrivateProfileSectionNamesA__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  GetPrivateProfileSectionNamesA(arg1, arg2, x);
}

void test__GetPrivateProfileSectionNamesW__noreturn() {
  int x = 1;
  if (cond) { x=100; GetPrivateProfileSectionNamesW(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__GetPrivateProfileSectionNamesW__leakignore() {
  char *p = malloc(10); *p=0;
  GetPrivateProfileSectionNamesW(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__GetPrivateProfileSectionNamesW__arg1__notnull() {
  // cppcheck-suppress nullPointer
  GetPrivateProfileSectionNamesW(NULL, arg2, arg3);
}

void test__GetPrivateProfileSectionNamesW__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  GetPrivateProfileSectionNamesW(arg1, x, arg3);
}

void test__GetPrivateProfileSectionNamesW__arg3__notnull() {
  // cppcheck-suppress nullPointer
  GetPrivateProfileSectionNamesW(arg1, arg2, NULL);
}

void test__GetPrivateProfileSectionNamesW__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  GetPrivateProfileSectionNamesW(arg1, arg2, x);
}

void test__GetPrivateProfileString__noreturn() {
  int x = 1;
  if (cond) { x=100; GetPrivateProfileString(arg1, arg2, arg3, arg4, arg5, arg6); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__GetPrivateProfileString__leakignore() {
  char *p = malloc(10); *p=0;
  GetPrivateProfileString(p, arg2, arg3, arg4, arg5, arg6);
  // cppcheck-suppress memleak
}

void test__GetPrivateProfileString__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  GetPrivateProfileString(x, arg2, arg3, arg4, arg5, arg6);
}

void test__GetPrivateProfileString__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  GetPrivateProfileString(arg1, x, arg3, arg4, arg5, arg6);
}

void test__GetPrivateProfileString__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  GetPrivateProfileString(arg1, arg2, x, arg4, arg5, arg6);
}

void test__GetPrivateProfileString__arg4__notnull() {
  // cppcheck-suppress nullPointer
  GetPrivateProfileString(arg1, arg2, arg3, NULL, arg5, arg6);
}

void test__GetPrivateProfileString__arg5__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  GetPrivateProfileString(arg1, arg2, arg3, arg4, x, arg6);
}

void test__GetPrivateProfileString__arg6__notnull() {
  // cppcheck-suppress nullPointer
  GetPrivateProfileString(arg1, arg2, arg3, arg4, arg5, NULL);
}

void test__GetPrivateProfileString__arg6__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  GetPrivateProfileString(arg1, arg2, arg3, arg4, arg5, x);
}

void test__GetPrivateProfileStringA__noreturn() {
  int x = 1;
  if (cond) { x=100; GetPrivateProfileStringA(arg1, arg2, arg3, arg4, arg5, arg6); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__GetPrivateProfileStringA__leakignore() {
  char *p = malloc(10); *p=0;
  GetPrivateProfileStringA(p, arg2, arg3, arg4, arg5, arg6);
  // cppcheck-suppress memleak
}

void test__GetPrivateProfileStringA__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  GetPrivateProfileStringA(x, arg2, arg3, arg4, arg5, arg6);
}

void test__GetPrivateProfileStringA__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  GetPrivateProfileStringA(arg1, x, arg3, arg4, arg5, arg6);
}

void test__GetPrivateProfileStringA__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  GetPrivateProfileStringA(arg1, arg2, x, arg4, arg5, arg6);
}

void test__GetPrivateProfileStringA__arg4__notnull() {
  // cppcheck-suppress nullPointer
  GetPrivateProfileStringA(arg1, arg2, arg3, NULL, arg5, arg6);
}

void test__GetPrivateProfileStringA__arg5__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  GetPrivateProfileStringA(arg1, arg2, arg3, arg4, x, arg6);
}

void test__GetPrivateProfileStringA__arg6__notnull() {
  // cppcheck-suppress nullPointer
  GetPrivateProfileStringA(arg1, arg2, arg3, arg4, arg5, NULL);
}

void test__GetPrivateProfileStringA__arg6__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  GetPrivateProfileStringA(arg1, arg2, arg3, arg4, arg5, x);
}

void test__GetPrivateProfileStringW__noreturn() {
  int x = 1;
  if (cond) { x=100; GetPrivateProfileStringW(arg1, arg2, arg3, arg4, arg5, arg6); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__GetPrivateProfileStringW__leakignore() {
  char *p = malloc(10); *p=0;
  GetPrivateProfileStringW(p, arg2, arg3, arg4, arg5, arg6);
  // cppcheck-suppress memleak
}

void test__GetPrivateProfileStringW__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  GetPrivateProfileStringW(x, arg2, arg3, arg4, arg5, arg6);
}

void test__GetPrivateProfileStringW__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  GetPrivateProfileStringW(arg1, x, arg3, arg4, arg5, arg6);
}

void test__GetPrivateProfileStringW__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  GetPrivateProfileStringW(arg1, arg2, x, arg4, arg5, arg6);
}

void test__GetPrivateProfileStringW__arg4__notnull() {
  // cppcheck-suppress nullPointer
  GetPrivateProfileStringW(arg1, arg2, arg3, NULL, arg5, arg6);
}

void test__GetPrivateProfileStringW__arg5__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  GetPrivateProfileStringW(arg1, arg2, arg3, arg4, x, arg6);
}

void test__GetPrivateProfileStringW__arg6__notnull() {
  // cppcheck-suppress nullPointer
  GetPrivateProfileStringW(arg1, arg2, arg3, arg4, arg5, NULL);
}

void test__GetPrivateProfileStringW__arg6__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  GetPrivateProfileStringW(arg1, arg2, arg3, arg4, arg5, x);
}

void test__GetPrivateProfileStruct__noreturn() {
  int x = 1;
  if (cond) { x=100; GetPrivateProfileStruct(arg1, arg2, arg3, arg4, arg5); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__GetPrivateProfileStruct__leakignore() {
  char *p = malloc(10); *p=0;
  GetPrivateProfileStruct(p, arg2, arg3, arg4, arg5);
  // cppcheck-suppress memleak
}

void test__GetPrivateProfileStruct__arg1__notnull() {
  // cppcheck-suppress nullPointer
  GetPrivateProfileStruct(NULL, arg2, arg3, arg4, arg5);
}

void test__GetPrivateProfileStruct__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  GetPrivateProfileStruct(x, arg2, arg3, arg4, arg5);
}

void test__GetPrivateProfileStruct__arg2__notnull() {
  // cppcheck-suppress nullPointer
  GetPrivateProfileStruct(arg1, NULL, arg3, arg4, arg5);
}

void test__GetPrivateProfileStruct__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  GetPrivateProfileStruct(arg1, x, arg3, arg4, arg5);
}

void test__GetPrivateProfileStruct__arg3__notnull() {
  // cppcheck-suppress nullPointer
  GetPrivateProfileStruct(arg1, arg2, NULL, arg4, arg5);
}

void test__GetPrivateProfileStruct__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  GetPrivateProfileStruct(arg1, arg2, arg3, x, arg5);
}

void test__GetPrivateProfileStruct__arg5__notnull() {
  // cppcheck-suppress nullPointer
  GetPrivateProfileStruct(arg1, arg2, arg3, arg4, NULL);
}

void test__GetPrivateProfileStruct__arg5__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  GetPrivateProfileStruct(arg1, arg2, arg3, arg4, x);
}

void test__GetPrivateProfileStructA__noreturn() {
  int x = 1;
  if (cond) { x=100; GetPrivateProfileStructA(arg1, arg2, arg3, arg4, arg5); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__GetPrivateProfileStructA__leakignore() {
  char *p = malloc(10); *p=0;
  GetPrivateProfileStructA(p, arg2, arg3, arg4, arg5);
  // cppcheck-suppress memleak
}

void test__GetPrivateProfileStructA__arg1__notnull() {
  // cppcheck-suppress nullPointer
  GetPrivateProfileStructA(NULL, arg2, arg3, arg4, arg5);
}

void test__GetPrivateProfileStructA__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  GetPrivateProfileStructA(x, arg2, arg3, arg4, arg5);
}

void test__GetPrivateProfileStructA__arg2__notnull() {
  // cppcheck-suppress nullPointer
  GetPrivateProfileStructA(arg1, NULL, arg3, arg4, arg5);
}

void test__GetPrivateProfileStructA__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  GetPrivateProfileStructA(arg1, x, arg3, arg4, arg5);
}

void test__GetPrivateProfileStructA__arg3__notnull() {
  // cppcheck-suppress nullPointer
  GetPrivateProfileStructA(arg1, arg2, NULL, arg4, arg5);
}

void test__GetPrivateProfileStructA__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  GetPrivateProfileStructA(arg1, arg2, arg3, x, arg5);
}

void test__GetPrivateProfileStructA__arg5__notnull() {
  // cppcheck-suppress nullPointer
  GetPrivateProfileStructA(arg1, arg2, arg3, arg4, NULL);
}

void test__GetPrivateProfileStructA__arg5__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  GetPrivateProfileStructA(arg1, arg2, arg3, arg4, x);
}

void test__GetPrivateProfileStructW__noreturn() {
  int x = 1;
  if (cond) { x=100; GetPrivateProfileStructW(arg1, arg2, arg3, arg4, arg5); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__GetPrivateProfileStructW__leakignore() {
  char *p = malloc(10); *p=0;
  GetPrivateProfileStructW(p, arg2, arg3, arg4, arg5);
  // cppcheck-suppress memleak
}

void test__GetPrivateProfileStructW__arg1__notnull() {
  // cppcheck-suppress nullPointer
  GetPrivateProfileStructW(NULL, arg2, arg3, arg4, arg5);
}

void test__GetPrivateProfileStructW__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  GetPrivateProfileStructW(x, arg2, arg3, arg4, arg5);
}

void test__GetPrivateProfileStructW__arg2__notnull() {
  // cppcheck-suppress nullPointer
  GetPrivateProfileStructW(arg1, NULL, arg3, arg4, arg5);
}

void test__GetPrivateProfileStructW__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  GetPrivateProfileStructW(arg1, x, arg3, arg4, arg5);
}

void test__GetPrivateProfileStructW__arg3__notnull() {
  // cppcheck-suppress nullPointer
  GetPrivateProfileStructW(arg1, arg2, NULL, arg4, arg5);
}

void test__GetPrivateProfileStructW__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  GetPrivateProfileStructW(arg1, arg2, arg3, x, arg5);
}

void test__GetPrivateProfileStructW__arg5__notnull() {
  // cppcheck-suppress nullPointer
  GetPrivateProfileStructW(arg1, arg2, arg3, arg4, NULL);
}

void test__GetPrivateProfileStructW__arg5__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  GetPrivateProfileStructW(arg1, arg2, arg3, arg4, x);
}

void test__BeginPaint__noreturn() {
  int x = 1;
  if (cond) { x=100; BeginPaint(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__BeginPaint__leakignore() {
  char *p = malloc(10); *p=0;
  BeginPaint(p, arg2);
  // cppcheck-suppress memleak
}

void test__BeginPaint__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  BeginPaint(x, arg2);
}

void test__BeginPaint__arg2__notnull() {
  // cppcheck-suppress nullPointer
  BeginPaint(arg1, NULL);
}

void test__EndPaint__noreturn() {
  int x = 1;
  if (cond) { x=100; EndPaint(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__EndPaint__leakignore() {
  char *p = malloc(10); *p=0;
  EndPaint(p, arg2);
  // cppcheck-suppress memleak
}

void test__EndPaint__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  EndPaint(x, arg2);
}

void test__EndPaint__arg2__notnull() {
  // cppcheck-suppress nullPointer
  EndPaint(arg1, NULL);
}

void test__GetStockObject__noreturn() {
  int x = 1;
  if (cond) { x=100; result = GetStockObject(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__GetStockObject__useretval() {
  // cppcheck-suppress ignoredReturnValue
  GetStockObject(arg1);
}

void test__GetStockObject__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((GetStockObject(arg1) > 10) || (GetStockObject(arg1) < 100)) {}
}

void test__GetStockObject__leakignore() {
  char *p = malloc(10); *p=0;
  result = GetStockObject(p);
  // cppcheck-suppress memleak
}

void test__GetStockObject__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = GetStockObject(x);
}

void test__LoadIcon__noreturn() {
  int x = 1;
  if (cond) { x=100; result = LoadIcon(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__LoadIcon__useretval() {
  // cppcheck-suppress ignoredReturnValue
  LoadIcon(arg1, arg2);
}

void test__LoadIcon__leakignore() {
  char *p = malloc(10); *p=0;
  result = LoadIcon(p, arg2);
  // cppcheck-suppress memleak
}

void test__LoadIcon__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = LoadIcon(x, arg2);
}

void test__LoadIcon__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = LoadIcon(arg1, NULL);
}

void test__LoadIcon__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = LoadIcon(arg1, x);
}

void test__LoadIconA__noreturn() {
  int x = 1;
  if (cond) { x=100; result = LoadIconA(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__LoadIconA__useretval() {
  // cppcheck-suppress ignoredReturnValue
  LoadIconA(arg1, arg2);
}

void test__LoadIconA__leakignore() {
  char *p = malloc(10); *p=0;
  result = LoadIconA(p, arg2);
  // cppcheck-suppress memleak
}

void test__LoadIconA__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = LoadIconA(x, arg2);
}

void test__LoadIconA__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = LoadIconA(arg1, NULL);
}

void test__LoadIconA__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = LoadIconA(arg1, x);
}

void test__LoadIconW__noreturn() {
  int x = 1;
  if (cond) { x=100; result = LoadIconW(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__LoadIconW__useretval() {
  // cppcheck-suppress ignoredReturnValue
  LoadIconW(arg1, arg2);
}

void test__LoadIconW__leakignore() {
  char *p = malloc(10); *p=0;
  result = LoadIconW(p, arg2);
  // cppcheck-suppress memleak
}

void test__LoadIconW__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = LoadIconW(x, arg2);
}

void test__LoadIconW__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = LoadIconW(arg1, NULL);
}

void test__LoadIconW__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = LoadIconW(arg1, x);
}

void test__CreateSolidBrush__noreturn() {
  int x = 1;
  if (cond) { x=100; result = CreateSolidBrush(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__CreateSolidBrush__useretval() {
  // cppcheck-suppress ignoredReturnValue
  CreateSolidBrush(arg1);
}

void test__CreateSolidBrush__leakignore() {
  char *p = malloc(10); *p=0;
  result = CreateSolidBrush(p);
  // cppcheck-suppress memleak
}

void test__CreateSolidBrush__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateSolidBrush(x);
}

void test__UpdateWindow__noreturn() {
  int x = 1;
  if (cond) { x=100; UpdateWindow(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__UpdateWindow__leakignore() {
  char *p = malloc(10); *p=0;
  UpdateWindow(p);
  // cppcheck-suppress memleak
}

void test__UpdateWindow__arg1__notnull() {
  // cppcheck-suppress nullPointer
  UpdateWindow(NULL);
}

void test__UpdateWindow__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  UpdateWindow(x);
}

void test__EnableWindow__noreturn() {
  int x = 1;
  if (cond) { x=100; EnableWindow(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__EnableWindow__leakignore() {
  char *p = malloc(10); *p=0;
  EnableWindow(p, arg2);
  // cppcheck-suppress memleak
}

void test__EnableWindow__arg1__notnull() {
  // cppcheck-suppress nullPointer
  EnableWindow(NULL, arg2);
}

void test__EnableWindow__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  EnableWindow(x, arg2);
}

void test__EnableWindow__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  EnableWindow(arg1, x);
}

void test__CreateWindow__noreturn() {
  int x = 1;
  if (cond) { x=100; result = CreateWindow(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__CreateWindow__useretval() {
  // cppcheck-suppress ignoredReturnValue
  CreateWindow(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11);
}

void test__CreateWindow__leakignore() {
  char *p = malloc(10); *p=0;
  result = CreateWindow(p, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11);
  // cppcheck-suppress memleak
}

void test__CreateWindow__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindow(x, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11);
}

void test__CreateWindow__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindow(arg1, x, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11);
}

void test__CreateWindow__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindow(arg1, arg2, x, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11);
}

void test__CreateWindow__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindow(arg1, arg2, arg3, x, arg5, arg6, arg7, arg8, arg9, arg10, arg11);
}

void test__CreateWindow__arg5__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindow(arg1, arg2, arg3, arg4, x, arg6, arg7, arg8, arg9, arg10, arg11);
}

void test__CreateWindow__arg6__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindow(arg1, arg2, arg3, arg4, arg5, x, arg7, arg8, arg9, arg10, arg11);
}

void test__CreateWindow__arg7__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindow(arg1, arg2, arg3, arg4, arg5, arg6, x, arg8, arg9, arg10, arg11);
}

void test__CreateWindow__arg8__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindow(arg1, arg2, arg3, arg4, arg5, arg6, arg7, x, arg9, arg10, arg11);
}

void test__CreateWindow__arg9__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindow(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, x, arg10, arg11);
}

void test__CreateWindow__arg10__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindow(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, x, arg11);
}

void test__CreateWindow__arg11__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindow(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, x);
}

void test__CreateWindowA__noreturn() {
  int x = 1;
  if (cond) { x=100; result = CreateWindowA(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__CreateWindowA__useretval() {
  // cppcheck-suppress ignoredReturnValue
  CreateWindowA(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11);
}

void test__CreateWindowA__leakignore() {
  char *p = malloc(10); *p=0;
  result = CreateWindowA(p, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11);
  // cppcheck-suppress memleak
}

void test__CreateWindowA__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindowA(x, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11);
}

void test__CreateWindowA__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindowA(arg1, x, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11);
}

void test__CreateWindowA__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindowA(arg1, arg2, x, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11);
}

void test__CreateWindowA__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindowA(arg1, arg2, arg3, x, arg5, arg6, arg7, arg8, arg9, arg10, arg11);
}

void test__CreateWindowA__arg5__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindowA(arg1, arg2, arg3, arg4, x, arg6, arg7, arg8, arg9, arg10, arg11);
}

void test__CreateWindowA__arg6__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindowA(arg1, arg2, arg3, arg4, arg5, x, arg7, arg8, arg9, arg10, arg11);
}

void test__CreateWindowA__arg7__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindowA(arg1, arg2, arg3, arg4, arg5, arg6, x, arg8, arg9, arg10, arg11);
}

void test__CreateWindowA__arg8__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindowA(arg1, arg2, arg3, arg4, arg5, arg6, arg7, x, arg9, arg10, arg11);
}

void test__CreateWindowA__arg9__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindowA(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, x, arg10, arg11);
}

void test__CreateWindowA__arg10__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindowA(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, x, arg11);
}

void test__CreateWindowA__arg11__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindowA(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, x);
}

void test__CreateWindowW__noreturn() {
  int x = 1;
  if (cond) { x=100; result = CreateWindowW(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__CreateWindowW__useretval() {
  // cppcheck-suppress ignoredReturnValue
  CreateWindowW(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11);
}

void test__CreateWindowW__leakignore() {
  char *p = malloc(10); *p=0;
  result = CreateWindowW(p, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11);
  // cppcheck-suppress memleak
}

void test__CreateWindowW__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindowW(x, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11);
}

void test__CreateWindowW__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindowW(arg1, x, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11);
}

void test__CreateWindowW__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindowW(arg1, arg2, x, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11);
}

void test__CreateWindowW__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindowW(arg1, arg2, arg3, x, arg5, arg6, arg7, arg8, arg9, arg10, arg11);
}

void test__CreateWindowW__arg5__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindowW(arg1, arg2, arg3, arg4, x, arg6, arg7, arg8, arg9, arg10, arg11);
}

void test__CreateWindowW__arg6__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindowW(arg1, arg2, arg3, arg4, arg5, x, arg7, arg8, arg9, arg10, arg11);
}

void test__CreateWindowW__arg7__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindowW(arg1, arg2, arg3, arg4, arg5, arg6, x, arg8, arg9, arg10, arg11);
}

void test__CreateWindowW__arg8__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindowW(arg1, arg2, arg3, arg4, arg5, arg6, arg7, x, arg9, arg10, arg11);
}

void test__CreateWindowW__arg9__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindowW(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, x, arg10, arg11);
}

void test__CreateWindowW__arg10__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindowW(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, x, arg11);
}

void test__CreateWindowW__arg11__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindowW(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, x);
}

void test__CreateWindowEx__noreturn() {
  int x = 1;
  if (cond) { x=100; result = CreateWindowEx(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__CreateWindowEx__useretval() {
  // cppcheck-suppress ignoredReturnValue
  CreateWindowEx(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12);
}

void test__CreateWindowEx__leakignore() {
  char *p = malloc(10); *p=0;
  result = CreateWindowEx(p, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12);
  // cppcheck-suppress memleak
}

void test__CreateWindowEx__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindowEx(x, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12);
}

void test__CreateWindowEx__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindowEx(arg1, x, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12);
}

void test__CreateWindowEx__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindowEx(arg1, arg2, x, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12);
}

void test__CreateWindowEx__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindowEx(arg1, arg2, arg3, x, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12);
}

void test__CreateWindowEx__arg5__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindowEx(arg1, arg2, arg3, arg4, x, arg6, arg7, arg8, arg9, arg10, arg11, arg12);
}

void test__CreateWindowEx__arg6__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindowEx(arg1, arg2, arg3, arg4, arg5, x, arg7, arg8, arg9, arg10, arg11, arg12);
}

void test__CreateWindowEx__arg7__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindowEx(arg1, arg2, arg3, arg4, arg5, arg6, x, arg8, arg9, arg10, arg11, arg12);
}

void test__CreateWindowEx__arg8__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindowEx(arg1, arg2, arg3, arg4, arg5, arg6, arg7, x, arg9, arg10, arg11, arg12);
}

void test__CreateWindowEx__arg9__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindowEx(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, x, arg10, arg11, arg12);
}

void test__CreateWindowEx__arg10__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindowEx(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, x, arg11, arg12);
}

void test__CreateWindowEx__arg11__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindowEx(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, x, arg12);
}

void test__CreateWindowEx__arg12__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindowEx(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, x);
}

void test__CreateWindowExA__noreturn() {
  int x = 1;
  if (cond) { x=100; result = CreateWindowExA(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__CreateWindowExA__useretval() {
  // cppcheck-suppress ignoredReturnValue
  CreateWindowExA(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12);
}

void test__CreateWindowExA__leakignore() {
  char *p = malloc(10); *p=0;
  result = CreateWindowExA(p, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12);
  // cppcheck-suppress memleak
}

void test__CreateWindowExA__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindowExA(x, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12);
}

void test__CreateWindowExA__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindowExA(arg1, x, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12);
}

void test__CreateWindowExA__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindowExA(arg1, arg2, x, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12);
}

void test__CreateWindowExA__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindowExA(arg1, arg2, arg3, x, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12);
}

void test__CreateWindowExA__arg5__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindowExA(arg1, arg2, arg3, arg4, x, arg6, arg7, arg8, arg9, arg10, arg11, arg12);
}

void test__CreateWindowExA__arg6__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindowExA(arg1, arg2, arg3, arg4, arg5, x, arg7, arg8, arg9, arg10, arg11, arg12);
}

void test__CreateWindowExA__arg7__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindowExA(arg1, arg2, arg3, arg4, arg5, arg6, x, arg8, arg9, arg10, arg11, arg12);
}

void test__CreateWindowExA__arg8__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindowExA(arg1, arg2, arg3, arg4, arg5, arg6, arg7, x, arg9, arg10, arg11, arg12);
}

void test__CreateWindowExA__arg9__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindowExA(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, x, arg10, arg11, arg12);
}

void test__CreateWindowExA__arg10__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindowExA(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, x, arg11, arg12);
}

void test__CreateWindowExA__arg11__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindowExA(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, x, arg12);
}

void test__CreateWindowExA__arg12__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindowExA(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, x);
}

void test__CreateWindowExW__noreturn() {
  int x = 1;
  if (cond) { x=100; result = CreateWindowExW(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__CreateWindowExW__useretval() {
  // cppcheck-suppress ignoredReturnValue
  CreateWindowExW(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12);
}

void test__CreateWindowExW__leakignore() {
  char *p = malloc(10); *p=0;
  result = CreateWindowExW(p, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12);
  // cppcheck-suppress memleak
}

void test__CreateWindowExW__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindowExW(x, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12);
}

void test__CreateWindowExW__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindowExW(arg1, x, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12);
}

void test__CreateWindowExW__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindowExW(arg1, arg2, x, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12);
}

void test__CreateWindowExW__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindowExW(arg1, arg2, arg3, x, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12);
}

void test__CreateWindowExW__arg5__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindowExW(arg1, arg2, arg3, arg4, x, arg6, arg7, arg8, arg9, arg10, arg11, arg12);
}

void test__CreateWindowExW__arg6__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindowExW(arg1, arg2, arg3, arg4, arg5, x, arg7, arg8, arg9, arg10, arg11, arg12);
}

void test__CreateWindowExW__arg7__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindowExW(arg1, arg2, arg3, arg4, arg5, arg6, x, arg8, arg9, arg10, arg11, arg12);
}

void test__CreateWindowExW__arg8__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindowExW(arg1, arg2, arg3, arg4, arg5, arg6, arg7, x, arg9, arg10, arg11, arg12);
}

void test__CreateWindowExW__arg9__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindowExW(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, x, arg10, arg11, arg12);
}

void test__CreateWindowExW__arg10__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindowExW(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, x, arg11, arg12);
}

void test__CreateWindowExW__arg11__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindowExW(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, x, arg12);
}

void test__CreateWindowExW__arg12__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWindowExW(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, x);
}

void test__SetWindowText__noreturn() {
  int x = 1;
  if (cond) { x=100; SetWindowText(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__SetWindowText__leakignore() {
  char *p = malloc(10); *p=0;
  SetWindowText(p, arg2);
  // cppcheck-suppress memleak
}

void test__SetWindowText__arg1__notnull() {
  // cppcheck-suppress nullPointer
  SetWindowText(NULL, arg2);
}

void test__SetWindowText__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  SetWindowText(x, arg2);
}

void test__SetWindowText__arg2__notnull() {
  // cppcheck-suppress nullPointer
  SetWindowText(arg1, NULL);
}

void test__SetWindowText__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  SetWindowText(arg1, x);
}

void test__SetWindowTextA__noreturn() {
  int x = 1;
  if (cond) { x=100; SetWindowTextA(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__SetWindowTextA__leakignore() {
  char *p = malloc(10); *p=0;
  SetWindowTextA(p, arg2);
  // cppcheck-suppress memleak
}

void test__SetWindowTextA__arg1__notnull() {
  // cppcheck-suppress nullPointer
  SetWindowTextA(NULL, arg2);
}

void test__SetWindowTextA__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  SetWindowTextA(x, arg2);
}

void test__SetWindowTextA__arg2__notnull() {
  // cppcheck-suppress nullPointer
  SetWindowTextA(arg1, NULL);
}

void test__SetWindowTextA__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  SetWindowTextA(arg1, x);
}

void test__SetWindowTextW__noreturn() {
  int x = 1;
  if (cond) { x=100; SetWindowTextW(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__SetWindowTextW__leakignore() {
  char *p = malloc(10); *p=0;
  SetWindowTextW(p, arg2);
  // cppcheck-suppress memleak
}

void test__SetWindowTextW__arg1__notnull() {
  // cppcheck-suppress nullPointer
  SetWindowTextW(NULL, arg2);
}

void test__SetWindowTextW__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  SetWindowTextW(x, arg2);
}

void test__SetWindowTextW__arg2__notnull() {
  // cppcheck-suppress nullPointer
  SetWindowTextW(arg1, NULL);
}

void test__SetWindowTextW__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  SetWindowTextW(arg1, x);
}

void test__RegisterClass__noreturn() {
  int x = 1;
  if (cond) { x=100; RegisterClass(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__RegisterClass__leakignore() {
  char *p = malloc(10); *p=0;
  RegisterClass(p);
  // cppcheck-suppress memleak
}

void test__RegisterClass__arg1__notnull() {
  // cppcheck-suppress nullPointer
  RegisterClass(NULL);
}

void test__RegisterClass__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  RegisterClass(x);
}

void test__RegisterClassEx__noreturn() {
  int x = 1;
  if (cond) { x=100; RegisterClassEx(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__RegisterClassEx__leakignore() {
  char *p = malloc(10); *p=0;
  RegisterClassEx(p);
  // cppcheck-suppress memleak
}

void test__RegisterClassEx__arg1__notnull() {
  // cppcheck-suppress nullPointer
  RegisterClassEx(NULL);
}

void test__RegisterClassEx__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  RegisterClassEx(x);
}

void test__UnregisterClass__noreturn() {
  int x = 1;
  if (cond) { x=100; UnregisterClass(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__UnregisterClass__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  UnregisterClass(x, arg2);
}

void test__UnregisterClass__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  UnregisterClass(arg1, x);
}

void test__UnregisterClassA__noreturn() {
  int x = 1;
  if (cond) { x=100; UnregisterClassA(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__UnregisterClassA__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  UnregisterClassA(x, arg2);
}

void test__UnregisterClassA__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  UnregisterClassA(arg1, x);
}

void test__UnregisterClassW__noreturn() {
  int x = 1;
  if (cond) { x=100; UnregisterClassW(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__UnregisterClassW__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  UnregisterClassW(x, arg2);
}

void test__UnregisterClassW__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  UnregisterClassW(arg1, x);
}

void test__MessageBox__noreturn() {
  int x = 1;
  if (cond) { x=100; MessageBox(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__MessageBox__leakignore() {
  char *p = malloc(10); *p=0;
  MessageBox(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test__MessageBox__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  MessageBox(x, arg2, arg3, arg4);
}

void test__MessageBox__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  MessageBox(arg1, x, arg3, arg4);
}

void test__MessageBox__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  MessageBox(arg1, arg2, x, arg4);
}

void test__MessageBox__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  MessageBox(arg1, arg2, arg3, x);
}

void test__MessageBoxA__noreturn() {
  int x = 1;
  if (cond) { x=100; MessageBoxA(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__MessageBoxA__leakignore() {
  char *p = malloc(10); *p=0;
  MessageBoxA(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test__MessageBoxA__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  MessageBoxA(x, arg2, arg3, arg4);
}

void test__MessageBoxA__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  MessageBoxA(arg1, x, arg3, arg4);
}

void test__MessageBoxA__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  MessageBoxA(arg1, arg2, x, arg4);
}

void test__MessageBoxA__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  MessageBoxA(arg1, arg2, arg3, x);
}

void test__MessageBoxW__noreturn() {
  int x = 1;
  if (cond) { x=100; MessageBoxW(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__MessageBoxW__leakignore() {
  char *p = malloc(10); *p=0;
  MessageBoxW(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test__MessageBoxW__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  MessageBoxW(x, arg2, arg3, arg4);
}

void test__MessageBoxW__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  MessageBoxW(arg1, x, arg3, arg4);
}

void test__MessageBoxW__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  MessageBoxW(arg1, arg2, x, arg4);
}

void test__MessageBoxW__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  MessageBoxW(arg1, arg2, arg3, x);
}

void test__GlobalLock__noreturn() {
  int x = 1;
  if (cond) { x=100; GlobalLock(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__GlobalLock__leakignore() {
  char *p = malloc(10); *p=0;
  GlobalLock(p);
  // cppcheck-suppress memleak
}

void test__GlobalLock__arg1__notnull() {
  // cppcheck-suppress nullPointer
  GlobalLock(NULL);
}

void test__GlobalLock__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  GlobalLock(x);
}

void test__GlobalUnlock__noreturn() {
  int x = 1;
  if (cond) { x=100; GlobalUnlock(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__GlobalUnlock__leakignore() {
  char *p = malloc(10); *p=0;
  GlobalUnlock(p);
  // cppcheck-suppress memleak
}

void test__GlobalUnlock__arg1__notnull() {
  // cppcheck-suppress nullPointer
  GlobalUnlock(NULL);
}

void test__GlobalUnlock__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  GlobalUnlock(x);
}

void test__OpenClipboard__noreturn() {
  int x = 1;
  if (cond) { x=100; OpenClipboard(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__OpenClipboard__leakignore() {
  char *p = malloc(10); *p=0;
  OpenClipboard(p);
  // cppcheck-suppress memleak
}

void test__OpenClipboard__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  OpenClipboard(x);
}

void test__EmptyClipboard__noreturn() {
  int x = 1;
  if (cond) { x=100; EmptyClipboard(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__EmptyClipboard__leakignore() {
  char *p = malloc(10); *p=0;
  EmptyClipboard();
  // cppcheck-suppress memleak
}

void test__CloseClipboard__noreturn() {
  int x = 1;
  if (cond) { x=100; CloseClipboard(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__CloseClipboard__leakignore() {
  char *p = malloc(10); *p=0;
  CloseClipboard();
  // cppcheck-suppress memleak
}

void test__SetClipboardData__noreturn() {
  int x = 1;
  if (cond) { x=100; SetClipboardData(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__SetClipboardData__leakignore() {
  char *p = malloc(10); *p=0;
  SetClipboardData(p, arg2);
  // cppcheck-suppress memleak
}

void test__SetClipboardData__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  SetClipboardData(x, arg2);
}

void test__SetClipboardData__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  SetClipboardData(arg1, x);
}

void test___rmdir__noreturn() {
  int x = 1;
  if (cond) { x=100; _rmdir(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___rmdir__leakignore() {
  char *p = malloc(10); *p=0;
  _rmdir(p);
  // cppcheck-suppress memleak
}

void test___rmdir__arg1__notnull() {
  // cppcheck-suppress nullPointer
  _rmdir(NULL);
}

void test___rmdir__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _rmdir(x);
}

void test___wrmdir__noreturn() {
  int x = 1;
  if (cond) { x=100; _wrmdir(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___wrmdir__leakignore() {
  char *p = malloc(10); *p=0;
  _wrmdir(p);
  // cppcheck-suppress memleak
}

void test___wrmdir__arg1__notnull() {
  // cppcheck-suppress nullPointer
  _wrmdir(NULL);
}

void test___wrmdir__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _wrmdir(x);
}

void test___mkdir__noreturn() {
  int x = 1;
  if (cond) { x=100; _mkdir(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___mkdir__leakignore() {
  char *p = malloc(10); *p=0;
  _mkdir(p);
  // cppcheck-suppress memleak
}

void test___mkdir__arg1__notnull() {
  // cppcheck-suppress nullPointer
  _mkdir(NULL);
}

void test___mkdir__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _mkdir(x);
}

void test___wmkdir__noreturn() {
  int x = 1;
  if (cond) { x=100; _wmkdir(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___wmkdir__leakignore() {
  char *p = malloc(10); *p=0;
  _wmkdir(p);
  // cppcheck-suppress memleak
}

void test___wmkdir__arg1__notnull() {
  // cppcheck-suppress nullPointer
  _wmkdir(NULL);
}

void test___wmkdir__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _wmkdir(x);
}

void test___abs64__noreturn() {
  int x = 1;
  if (cond) { x=100; result = _abs64(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___abs64__useretval() {
  // cppcheck-suppress ignoredReturnValue
  _abs64(arg1);
}

void test___abs64__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((_abs64(arg1) > 10) || (_abs64(arg1) < 100)) {}
}

void test___abs64__leakignore() {
  char *p = malloc(10); *p=0;
  result = _abs64(p);
  // cppcheck-suppress memleak
}

void test___abs64__arg1__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  result = _abs64(!x);
}

void test___abs64__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = _abs64(x);
}

void test__CreateWaitableTimer__noreturn() {
  int x = 1;
  if (cond) { x=100; result = CreateWaitableTimer(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__CreateWaitableTimer__useretval() {
  // cppcheck-suppress ignoredReturnValue
  CreateWaitableTimer(arg1, arg2, arg3);
}

void test__CreateWaitableTimer__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWaitableTimer(x, arg2, arg3);
}

void test__CreateWaitableTimer__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWaitableTimer(arg1, x, arg3);
}

void test__CreateWaitableTimer__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateWaitableTimer(arg1, arg2, x);
}

void test__SetWaitableTimer__noreturn() {
  int x = 1;
  if (cond) { x=100; SetWaitableTimer(arg1, arg2, arg3, arg4, arg5, arg6); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__SetWaitableTimer__leakignore() {
  char *p = malloc(10); *p=0;
  SetWaitableTimer(p, arg2, arg3, arg4, arg5, arg6);
  // cppcheck-suppress memleak
}

void test__SetWaitableTimer__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  SetWaitableTimer(x, arg2, arg3, arg4, arg5, arg6);
}

void test__SetWaitableTimer__arg2__notnull() {
  // cppcheck-suppress nullPointer
  SetWaitableTimer(arg1, NULL, arg3, arg4, arg5, arg6);
}

void test__SetWaitableTimer__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  SetWaitableTimer(arg1, x, arg3, arg4, arg5, arg6);
}

void test__SetWaitableTimer__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  SetWaitableTimer(arg1, arg2, x, arg4, arg5, arg6);
}

void test__SetWaitableTimer__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  SetWaitableTimer(arg1, arg2, arg3, x, arg5, arg6);
}

void test__SetWaitableTimer__arg5__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  SetWaitableTimer(arg1, arg2, arg3, arg4, x, arg6);
}

void test__SetWaitableTimer__arg6__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  SetWaitableTimer(arg1, arg2, arg3, arg4, arg5, x);
}

void test__WaitForSingleObject__noreturn() {
  int x = 1;
  if (cond) { x=100; WaitForSingleObject(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__WaitForSingleObject__leakignore() {
  char *p = malloc(10); *p=0;
  WaitForSingleObject(p, arg2);
  // cppcheck-suppress memleak
}

void test__WaitForSingleObject__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  WaitForSingleObject(x, arg2);
}

void test__WaitForSingleObject__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  WaitForSingleObject(arg1, x);
}

void test___pclose__noreturn() {
  int x = 1;
  if (cond) { x=100; _pclose(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___pclose__arg1__notnull() {
  // cppcheck-suppress nullPointer
  _pclose(NULL);
}

void test___pclose__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _pclose(x);
}

void test___popen__noreturn() {
  int x = 1;
  if (cond) { x=100; result = _popen(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___popen__useretval() {
  // cppcheck-suppress ignoredReturnValue
  _popen(arg1, arg2);
}

void test___popen__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = _popen(NULL, arg2);
}

void test___popen__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _popen(x, arg2);
}

void test___popen__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = _popen(arg1, NULL);
}

void test___popen__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _popen(arg1, x);
}

void test___wpopen__noreturn() {
  int x = 1;
  if (cond) { x=100; result = _wpopen(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___wpopen__useretval() {
  // cppcheck-suppress ignoredReturnValue
  _wpopen(arg1, arg2);
}

void test___wpopen__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = _wpopen(NULL, arg2);
}

void test___wpopen__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _wpopen(x, arg2);
}

void test___wpopen__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = _wpopen(arg1, NULL);
}

void test___wpopen__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _wpopen(arg1, x);
}

void test___tpopen__noreturn() {
  int x = 1;
  if (cond) { x=100; result = _tpopen(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___tpopen__useretval() {
  // cppcheck-suppress ignoredReturnValue
  _tpopen(arg1, arg2);
}

void test___tpopen__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = _tpopen(NULL, arg2);
}

void test___tpopen__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _tpopen(x, arg2);
}

void test___tpopen__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = _tpopen(arg1, NULL);
}

void test___tpopen__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _tpopen(arg1, x);
}

void test___mktemp__noreturn() {
  int x = 1;
  if (cond) { x=100; result = _mktemp(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___mktemp__useretval() {
  // cppcheck-suppress ignoredReturnValue
  _mktemp(arg1);
}

void test___mktemp__leakignore() {
  char *p = malloc(10); *p=0;
  result = _mktemp(p);
  // cppcheck-suppress memleak
}

void test___mktemp__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = _mktemp(NULL);
}

void test___mktemp__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _mktemp(x);
}

void test___wmktemp__noreturn() {
  int x = 1;
  if (cond) { x=100; result = _wmktemp(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___wmktemp__useretval() {
  // cppcheck-suppress ignoredReturnValue
  _wmktemp(arg1);
}

void test___wmktemp__leakignore() {
  char *p = malloc(10); *p=0;
  result = _wmktemp(p);
  // cppcheck-suppress memleak
}

void test___wmktemp__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = _wmktemp(NULL);
}

void test___wmktemp__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _wmktemp(x);
}

void test__FindFirstFileEx__noreturn() {
  int x = 1;
  if (cond) { x=100; result = FindFirstFileEx(arg1, arg2, arg3, arg4, arg5, arg6); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__FindFirstFileEx__useretval() {
  // cppcheck-suppress ignoredReturnValue
  FindFirstFileEx(arg1, arg2, arg3, arg4, arg5, arg6);
}

void test__FindFirstFileEx__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = FindFirstFileEx(NULL, arg2, arg3, arg4, arg5, arg6);
}

void test__FindFirstFileEx__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = FindFirstFileEx(x, arg2, arg3, arg4, arg5, arg6);
}

void test__FindFirstFileEx__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = FindFirstFileEx(arg1, x, arg3, arg4, arg5, arg6);
}

void test__FindFirstFileEx__arg3__notnull() {
  // cppcheck-suppress nullPointer
  result = FindFirstFileEx(arg1, arg2, NULL, arg4, arg5, arg6);
}

void test__FindFirstFileEx__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = FindFirstFileEx(arg1, arg2, arg3, x, arg5, arg6);
}

void test__FindFirstFileEx__arg6__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = FindFirstFileEx(arg1, arg2, arg3, arg4, arg5, x);
}

void test__FindFirstFileExA__noreturn() {
  int x = 1;
  if (cond) { x=100; result = FindFirstFileExA(arg1, arg2, arg3, arg4, arg5, arg6); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__FindFirstFileExA__useretval() {
  // cppcheck-suppress ignoredReturnValue
  FindFirstFileExA(arg1, arg2, arg3, arg4, arg5, arg6);
}

void test__FindFirstFileExA__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = FindFirstFileExA(NULL, arg2, arg3, arg4, arg5, arg6);
}

void test__FindFirstFileExA__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = FindFirstFileExA(x, arg2, arg3, arg4, arg5, arg6);
}

void test__FindFirstFileExA__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = FindFirstFileExA(arg1, x, arg3, arg4, arg5, arg6);
}

void test__FindFirstFileExA__arg3__notnull() {
  // cppcheck-suppress nullPointer
  result = FindFirstFileExA(arg1, arg2, NULL, arg4, arg5, arg6);
}

void test__FindFirstFileExA__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = FindFirstFileExA(arg1, arg2, arg3, x, arg5, arg6);
}

void test__FindFirstFileExA__arg6__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = FindFirstFileExA(arg1, arg2, arg3, arg4, arg5, x);
}

void test__FindFirstFileExW__noreturn() {
  int x = 1;
  if (cond) { x=100; result = FindFirstFileExW(arg1, arg2, arg3, arg4, arg5, arg6); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__FindFirstFileExW__useretval() {
  // cppcheck-suppress ignoredReturnValue
  FindFirstFileExW(arg1, arg2, arg3, arg4, arg5, arg6);
}

void test__FindFirstFileExW__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = FindFirstFileExW(NULL, arg2, arg3, arg4, arg5, arg6);
}

void test__FindFirstFileExW__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = FindFirstFileExW(x, arg2, arg3, arg4, arg5, arg6);
}

void test__FindFirstFileExW__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = FindFirstFileExW(arg1, x, arg3, arg4, arg5, arg6);
}

void test__FindFirstFileExW__arg3__notnull() {
  // cppcheck-suppress nullPointer
  result = FindFirstFileExW(arg1, arg2, NULL, arg4, arg5, arg6);
}

void test__FindFirstFileExW__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = FindFirstFileExW(arg1, arg2, arg3, x, arg5, arg6);
}

void test__FindFirstFileExW__arg6__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = FindFirstFileExW(arg1, arg2, arg3, arg4, arg5, x);
}

void test__FindFirstFile__noreturn() {
  int x = 1;
  if (cond) { x=100; result = FindFirstFile(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__FindFirstFile__useretval() {
  // cppcheck-suppress ignoredReturnValue
  FindFirstFile(arg1, arg2);
}

void test__FindFirstFile__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = FindFirstFile(NULL, arg2);
}

void test__FindFirstFile__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = FindFirstFile(x, arg2);
}

void test__FindFirstFile__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = FindFirstFile(arg1, NULL);
}

void test__FindFirstFileW__noreturn() {
  int x = 1;
  if (cond) { x=100; result = FindFirstFileW(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__FindFirstFileW__useretval() {
  // cppcheck-suppress ignoredReturnValue
  FindFirstFileW(arg1, arg2);
}

void test__FindFirstFileW__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = FindFirstFileW(NULL, arg2);
}

void test__FindFirstFileW__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = FindFirstFileW(x, arg2);
}

void test__FindFirstFileW__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = FindFirstFileW(arg1, NULL);
}

void test__FindFirstFileA__noreturn() {
  int x = 1;
  if (cond) { x=100; result = FindFirstFileA(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__FindFirstFileA__useretval() {
  // cppcheck-suppress ignoredReturnValue
  FindFirstFileA(arg1, arg2);
}

void test__FindFirstFileA__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = FindFirstFileA(NULL, arg2);
}

void test__FindFirstFileA__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = FindFirstFileA(x, arg2);
}

void test__FindFirstFileA__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = FindFirstFileA(arg1, NULL);
}

void test__FindClose__noreturn() {
  int x = 1;
  if (cond) { x=100; FindClose(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__FindClose__arg1__notnull() {
  // cppcheck-suppress nullPointer
  FindClose(NULL);
}

void test__FindClose__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  FindClose(x);
}

void test__CreateThread__noreturn() {
  int x = 1;
  if (cond) { x=100; result = CreateThread(arg1, arg2, arg3, arg4, arg5, arg6); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__CreateThread__useretval() {
  // cppcheck-suppress ignoredReturnValue
  CreateThread(arg1, arg2, arg3, arg4, arg5, arg6);
}

void test__CreateThread__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateThread(x, arg2, arg3, arg4, arg5, arg6);
}

void test__CreateThread__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateThread(arg1, x, arg3, arg4, arg5, arg6);
}

void test__CreateThread__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateThread(arg1, arg2, x, arg4, arg5, arg6);
}

void test__CreateThread__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateThread(arg1, arg2, arg3, x, arg5, arg6);
}

void test__CreateThread__arg5__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = CreateThread(arg1, arg2, arg3, arg4, x, arg6);
}

void test__FindNextFile__noreturn() {
  int x = 1;
  if (cond) { x=100; result = FindNextFile(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__FindNextFile__useretval() {
  // cppcheck-suppress ignoredReturnValue
  FindNextFile(arg1, arg2);
}

void test__FindNextFile__leakignore() {
  char *p = malloc(10); *p=0;
  result = FindNextFile(p, arg2);
  // cppcheck-suppress memleak
}

void test__FindNextFile__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = FindNextFile(NULL, arg2);
}

void test__FindNextFile__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = FindNextFile(x, arg2);
}

void test__FindNextFile__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = FindNextFile(arg1, NULL);
}

void test__FindNextFileW__noreturn() {
  int x = 1;
  if (cond) { x=100; result = FindNextFileW(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__FindNextFileW__useretval() {
  // cppcheck-suppress ignoredReturnValue
  FindNextFileW(arg1, arg2);
}

void test__FindNextFileW__leakignore() {
  char *p = malloc(10); *p=0;
  result = FindNextFileW(p, arg2);
  // cppcheck-suppress memleak
}

void test__FindNextFileW__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = FindNextFileW(NULL, arg2);
}

void test__FindNextFileW__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = FindNextFileW(x, arg2);
}

void test__FindNextFileW__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = FindNextFileW(arg1, NULL);
}

void test__FindNextFileA__noreturn() {
  int x = 1;
  if (cond) { x=100; result = FindNextFileA(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__FindNextFileA__useretval() {
  // cppcheck-suppress ignoredReturnValue
  FindNextFileA(arg1, arg2);
}

void test__FindNextFileA__leakignore() {
  char *p = malloc(10); *p=0;
  result = FindNextFileA(p, arg2);
  // cppcheck-suppress memleak
}

void test__FindNextFileA__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = FindNextFileA(NULL, arg2);
}

void test__FindNextFileA__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = FindNextFileA(x, arg2);
}

void test__FindNextFileA__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = FindNextFileA(arg1, NULL);
}

void test__SetEnvironmentVariable__noreturn() {
  int x = 1;
  if (cond) { x=100; SetEnvironmentVariable(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__SetEnvironmentVariable__leakignore() {
  char *p = malloc(10); *p=0;
  SetEnvironmentVariable(p, arg2);
  // cppcheck-suppress memleak
}

void test__SetEnvironmentVariable__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  SetEnvironmentVariable(x, arg2);
}

void test__SetEnvironmentVariableW__noreturn() {
  int x = 1;
  if (cond) { x=100; SetEnvironmentVariableW(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__SetEnvironmentVariableW__leakignore() {
  char *p = malloc(10); *p=0;
  SetEnvironmentVariableW(p, arg2);
  // cppcheck-suppress memleak
}

void test__SetEnvironmentVariableW__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  SetEnvironmentVariableW(x, arg2);
}

void test__SetEnvironmentVariableA__noreturn() {
  int x = 1;
  if (cond) { x=100; SetEnvironmentVariableA(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__SetEnvironmentVariableA__leakignore() {
  char *p = malloc(10); *p=0;
  SetEnvironmentVariableA(p, arg2);
  // cppcheck-suppress memleak
}

void test__SetEnvironmentVariableA__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  SetEnvironmentVariableA(x, arg2);
}

void test__QueryDosDevice__noreturn() {
  int x = 1;
  if (cond) { x=100; result = QueryDosDevice(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__QueryDosDevice__useretval() {
  // cppcheck-suppress ignoredReturnValue
  QueryDosDevice(arg1, arg2, arg3);
}

void test__QueryDosDevice__leakignore() {
  char *p = malloc(10); *p=0;
  result = QueryDosDevice(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__QueryDosDevice__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = QueryDosDevice(x, arg2, arg3);
}

void test__QueryDosDevice__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = QueryDosDevice(arg1, arg2, x);
}

void test__QueryDosDeviceW__noreturn() {
  int x = 1;
  if (cond) { x=100; result = QueryDosDeviceW(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__QueryDosDeviceW__useretval() {
  // cppcheck-suppress ignoredReturnValue
  QueryDosDeviceW(arg1, arg2, arg3);
}

void test__QueryDosDeviceW__leakignore() {
  char *p = malloc(10); *p=0;
  result = QueryDosDeviceW(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__QueryDosDeviceW__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = QueryDosDeviceW(x, arg2, arg3);
}

void test__QueryDosDeviceW__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = QueryDosDeviceW(arg1, arg2, x);
}

void test__QueryDosDeviceA__noreturn() {
  int x = 1;
  if (cond) { x=100; result = QueryDosDeviceA(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__QueryDosDeviceA__useretval() {
  // cppcheck-suppress ignoredReturnValue
  QueryDosDeviceA(arg1, arg2, arg3);
}

void test__QueryDosDeviceA__leakignore() {
  char *p = malloc(10); *p=0;
  result = QueryDosDeviceA(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__QueryDosDeviceA__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = QueryDosDeviceA(x, arg2, arg3);
}

void test__QueryDosDeviceA__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = QueryDosDeviceA(arg1, arg2, x);
}

void test__GetDefaultCommConfig__noreturn() {
  int x = 1;
  if (cond) { x=100; result = GetDefaultCommConfig(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__GetDefaultCommConfig__useretval() {
  // cppcheck-suppress ignoredReturnValue
  GetDefaultCommConfig(arg1, arg2, arg3);
}

void test__GetDefaultCommConfig__leakignore() {
  char *p = malloc(10); *p=0;
  result = GetDefaultCommConfig(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__GetDefaultCommConfig__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = GetDefaultCommConfig(x, arg2, arg3);
}

void test__GetDefaultCommConfig__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = GetDefaultCommConfig(arg1, NULL, arg3);
}

void test__GetDefaultCommConfigW__noreturn() {
  int x = 1;
  if (cond) { x=100; result = GetDefaultCommConfigW(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__GetDefaultCommConfigW__useretval() {
  // cppcheck-suppress ignoredReturnValue
  GetDefaultCommConfigW(arg1, arg2, arg3);
}

void test__GetDefaultCommConfigW__leakignore() {
  char *p = malloc(10); *p=0;
  result = GetDefaultCommConfigW(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__GetDefaultCommConfigW__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = GetDefaultCommConfigW(x, arg2, arg3);
}

void test__GetDefaultCommConfigW__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = GetDefaultCommConfigW(arg1, NULL, arg3);
}

void test__GetDefaultCommConfigA__noreturn() {
  int x = 1;
  if (cond) { x=100; result = GetDefaultCommConfigA(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__GetDefaultCommConfigA__useretval() {
  // cppcheck-suppress ignoredReturnValue
  GetDefaultCommConfigA(arg1, arg2, arg3);
}

void test__GetDefaultCommConfigA__leakignore() {
  char *p = malloc(10); *p=0;
  result = GetDefaultCommConfigA(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__GetDefaultCommConfigA__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = GetDefaultCommConfigA(x, arg2, arg3);
}

void test__GetDefaultCommConfigA__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = GetDefaultCommConfigA(arg1, NULL, arg3);
}

void test__GetTempPath__noreturn() {
  int x = 1;
  if (cond) { x=100; GetTempPath(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__GetTempPath__leakignore() {
  char *p = malloc(10); *p=0;
  GetTempPath(p, arg2);
  // cppcheck-suppress memleak
}

void test__GetTempPath__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  GetTempPath(x, arg2);
}

void test__GetTempPathW__noreturn() {
  int x = 1;
  if (cond) { x=100; GetTempPathW(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__GetTempPathW__leakignore() {
  char *p = malloc(10); *p=0;
  GetTempPathW(p, arg2);
  // cppcheck-suppress memleak
}

void test__GetTempPathW__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  GetTempPathW(x, arg2);
}

void test__GetTempPathA__noreturn() {
  int x = 1;
  if (cond) { x=100; GetTempPathA(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__GetTempPathA__leakignore() {
  char *p = malloc(10); *p=0;
  GetTempPathA(p, arg2);
  // cppcheck-suppress memleak
}

void test__GetTempPathA__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  GetTempPathA(x, arg2);
}

void test__SetupDiDestroyDeviceInfoList__noreturn() {
  int x = 1;
  if (cond) { x=100; SetupDiDestroyDeviceInfoList(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__SetupDiDestroyDeviceInfoList__leakignore() {
  char *p = malloc(10); *p=0;
  SetupDiDestroyDeviceInfoList(p);
  // cppcheck-suppress memleak
}

void test__SetupDiDestroyDeviceInfoList__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  SetupDiDestroyDeviceInfoList(x);
}

void test__SetupDiGetDeviceInstanceId__noreturn() {
  int x = 1;
  if (cond) { x=100; SetupDiGetDeviceInstanceId(arg1, arg2, arg3, arg4, arg5); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__SetupDiGetDeviceInstanceId__leakignore() {
  char *p = malloc(10); *p=0;
  SetupDiGetDeviceInstanceId(p, arg2, arg3, arg4, arg5);
  // cppcheck-suppress memleak
}

void test__SetupDiGetDeviceInstanceId__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  SetupDiGetDeviceInstanceId(x, arg2, arg3, arg4, arg5);
}

void test__SetupDiGetDeviceInstanceId__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  SetupDiGetDeviceInstanceId(arg1, x, arg3, arg4, arg5);
}

void test__SetupDiGetDeviceInstanceId__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  SetupDiGetDeviceInstanceId(arg1, arg2, arg3, x, arg5);
}

void test__SetupDiEnumDeviceInfo__noreturn() {
  int x = 1;
  if (cond) { x=100; SetupDiEnumDeviceInfo(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__SetupDiEnumDeviceInfo__leakignore() {
  char *p = malloc(10); *p=0;
  SetupDiEnumDeviceInfo(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__SetupDiEnumDeviceInfo__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  SetupDiEnumDeviceInfo(x, arg2, arg3);
}

void test__SetupDiEnumDeviceInfo__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  SetupDiEnumDeviceInfo(arg1, x, arg3);
}

void test__SetupDiGetClassDevs__noreturn() {
  int x = 1;
  if (cond) { x=100; SetupDiGetClassDevs(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__SetupDiGetClassDevs__leakignore() {
  char *p = malloc(10); *p=0;
  SetupDiGetClassDevs(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test__SetupDiGetClassDevs__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  SetupDiGetClassDevs(arg1, x, arg3, arg4);
}

void test__SetupDiGetClassDevs__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  SetupDiGetClassDevs(arg1, arg2, x, arg4);
}

void test__SetupDiGetClassDevs__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  SetupDiGetClassDevs(arg1, arg2, arg3, x);
}

void test___mbsstr__noreturn() {
  int x = 1;
  if (cond) { x=100; result = _mbsstr(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___mbsstr__useretval() {
  // cppcheck-suppress ignoredReturnValue
  _mbsstr(arg1, arg2);
}

void test___mbsstr__leakignore() {
  char *p = malloc(10); *p=0;
  result = _mbsstr(p, arg2);
  // cppcheck-suppress memleak
}

void test___mbsstr__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = _mbsstr(NULL, arg2);
}

void test___mbsstr__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _mbsstr(x, arg2);
}

void test___mbsstr__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = _mbsstr(arg1, NULL);
}

void test___mbsstr__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _mbsstr(arg1, x);
}

void test___tcsstr__noreturn() {
  int x = 1;
  if (cond) { x=100; result = _tcsstr(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___tcsstr__useretval() {
  // cppcheck-suppress ignoredReturnValue
  _tcsstr(arg1, arg2);
}

void test___tcsstr__leakignore() {
  char *p = malloc(10); *p=0;
  result = _tcsstr(p, arg2);
  // cppcheck-suppress memleak
}

void test___tcsstr__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = _tcsstr(NULL, arg2);
}

void test___tcsstr__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _tcsstr(x, arg2);
}

void test___tcsstr__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = _tcsstr(arg1, NULL);
}

void test___tcsstr__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _tcsstr(arg1, x);
}

void test___mbsstr_l__noreturn() {
  int x = 1;
  if (cond) { x=100; result = _mbsstr_l(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___mbsstr_l__useretval() {
  // cppcheck-suppress ignoredReturnValue
  _mbsstr_l(arg1, arg2, arg3);
}

void test___mbsstr_l__leakignore() {
  char *p = malloc(10); *p=0;
  result = _mbsstr_l(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test___mbsstr_l__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = _mbsstr_l(NULL, arg2, arg3);
}

void test___mbsstr_l__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _mbsstr_l(x, arg2, arg3);
}

void test___mbsstr_l__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = _mbsstr_l(arg1, NULL, arg3);
}

void test___mbsstr_l__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _mbsstr_l(arg1, x, arg3);
}

void test___mbsstr_l__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = _mbsstr_l(arg1, arg2, x);
}

void test___memccpy__noreturn() {
  int x = 1;
  if (cond) { x=100; _memccpy(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___memccpy__leakignore() {
  char *p = malloc(10); *p=0;
  _memccpy(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test___memccpy__arg1__notnull() {
  // cppcheck-suppress nullPointer
  _memccpy(NULL, arg2, arg3, arg4);
}

void test___memccpy__arg2__notnull() {
  // cppcheck-suppress nullPointer
  _memccpy(arg1, NULL, arg3, arg4);
}

void test___memccpy__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _memccpy(arg1, x, arg3, arg4);
}

void test___memccpy__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _memccpy(arg1, arg2, x, arg4);
}

void test___memccpy__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _memccpy(arg1, arg2, arg3, x);
}

void test___fcloseall__noreturn() {
  int x = 1;
  if (cond) { x=100; _fcloseall(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___open__noreturn() {
  int x = 1;
  if (cond) { x=100; result = _open(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___open__useretval() {
  // cppcheck-suppress ignoredReturnValue
  _open(arg1, arg2, arg3);
}

void test___open__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = _open(NULL, arg2, arg3);
}

void test___open__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _open(x, arg2, arg3);
}

void test___open__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = _open(arg1, x, arg3);
}

void test___open__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = _open(arg1, arg2, x);
}

void test___wopen__noreturn() {
  int x = 1;
  if (cond) { x=100; result = _wopen(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___wopen__useretval() {
  // cppcheck-suppress ignoredReturnValue
  _wopen(arg1, arg2, arg3);
}

void test___wopen__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = _wopen(NULL, arg2, arg3);
}

void test___wopen__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _wopen(x, arg2, arg3);
}

void test___wopen__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = _wopen(arg1, x, arg3);
}

void test___wopen__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = _wopen(arg1, arg2, x);
}

void test___topen__noreturn() {
  int x = 1;
  if (cond) { x=100; result = _topen(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___topen__useretval() {
  // cppcheck-suppress ignoredReturnValue
  _topen(arg1, arg2, arg3);
}

void test___topen__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = _topen(NULL, arg2, arg3);
}

void test___topen__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _topen(x, arg2, arg3);
}

void test___topen__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = _topen(arg1, x, arg3);
}

void test___topen__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = _topen(arg1, arg2, x);
}

void test___close__noreturn() {
  int x = 1;
  if (cond) { x=100; _close(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___close__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _close(x);
}

void test___swab__noreturn() {
  int x = 1;
  if (cond) { x=100; _swab(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___swab__leakignore() {
  char *p = malloc(10); *p=0;
  _swab(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test___swab__arg1__notnull() {
  // cppcheck-suppress nullPointer
  _swab(NULL, arg2, arg3);
}

void test___swab__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _swab(x, arg2, arg3);
}

void test___swab__arg2__notnull() {
  // cppcheck-suppress nullPointer
  _swab(arg1, NULL, arg3);
}

void test___swab__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  _swab(arg1, arg2, !x);
}

void test___swab__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _swab(arg1, arg2, x);
}

void test___strnicmp__noreturn() {
  int x = 1;
  if (cond) { x=100; result = _strnicmp(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___strnicmp__useretval() {
  // cppcheck-suppress ignoredReturnValue
  _strnicmp(arg1, arg2, arg3);
}

void test___strnicmp__leakignore() {
  char *p = malloc(10); *p=0;
  result = _strnicmp(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test___strnicmp__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = _strnicmp(NULL, arg2, arg3);
}

void test___strnicmp__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _strnicmp(x, arg2, arg3);
}

void test___strnicmp__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = _strnicmp(arg1, NULL, arg3);
}

void test___strnicmp__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _strnicmp(arg1, x, arg3);
}

void test___strnicmp__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  result = _strnicmp(arg1, arg2, !x);
}

void test___strnicmp__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = _strnicmp(arg1, arg2, x);
}

void test___wcsnicmp__noreturn() {
  int x = 1;
  if (cond) { x=100; result = _wcsnicmp(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___wcsnicmp__useretval() {
  // cppcheck-suppress ignoredReturnValue
  _wcsnicmp(arg1, arg2, arg3);
}

void test___wcsnicmp__leakignore() {
  char *p = malloc(10); *p=0;
  result = _wcsnicmp(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test___wcsnicmp__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = _wcsnicmp(NULL, arg2, arg3);
}

void test___wcsnicmp__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _wcsnicmp(x, arg2, arg3);
}

void test___wcsnicmp__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = _wcsnicmp(arg1, NULL, arg3);
}

void test___wcsnicmp__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _wcsnicmp(arg1, x, arg3);
}

void test___wcsnicmp__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  result = _wcsnicmp(arg1, arg2, !x);
}

void test___wcsnicmp__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = _wcsnicmp(arg1, arg2, x);
}

void test___mbsnicmp__noreturn() {
  int x = 1;
  if (cond) { x=100; result = _mbsnicmp(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___mbsnicmp__useretval() {
  // cppcheck-suppress ignoredReturnValue
  _mbsnicmp(arg1, arg2, arg3);
}

void test___mbsnicmp__leakignore() {
  char *p = malloc(10); *p=0;
  result = _mbsnicmp(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test___mbsnicmp__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = _mbsnicmp(NULL, arg2, arg3);
}

void test___mbsnicmp__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _mbsnicmp(x, arg2, arg3);
}

void test___mbsnicmp__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = _mbsnicmp(arg1, NULL, arg3);
}

void test___mbsnicmp__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _mbsnicmp(arg1, x, arg3);
}

void test___mbsnicmp__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  result = _mbsnicmp(arg1, arg2, !x);
}

void test___mbsnicmp__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = _mbsnicmp(arg1, arg2, x);
}

void test___tcsncicmp__noreturn() {
  int x = 1;
  if (cond) { x=100; result = _tcsncicmp(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___tcsncicmp__useretval() {
  // cppcheck-suppress ignoredReturnValue
  _tcsncicmp(arg1, arg2, arg3);
}

void test___tcsncicmp__leakignore() {
  char *p = malloc(10); *p=0;
  result = _tcsncicmp(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test___tcsncicmp__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = _tcsncicmp(NULL, arg2, arg3);
}

void test___tcsncicmp__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _tcsncicmp(x, arg2, arg3);
}

void test___tcsncicmp__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = _tcsncicmp(arg1, NULL, arg3);
}

void test___tcsncicmp__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _tcsncicmp(arg1, x, arg3);
}

void test___tcsncicmp__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  result = _tcsncicmp(arg1, arg2, !x);
}

void test___tcsncicmp__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = _tcsncicmp(arg1, arg2, x);
}

void test___tcsnicmp__noreturn() {
  int x = 1;
  if (cond) { x=100; result = _tcsnicmp(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___tcsnicmp__useretval() {
  // cppcheck-suppress ignoredReturnValue
  _tcsnicmp(arg1, arg2, arg3);
}

void test___tcsnicmp__leakignore() {
  char *p = malloc(10); *p=0;
  result = _tcsnicmp(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test___tcsnicmp__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = _tcsnicmp(NULL, arg2, arg3);
}

void test___tcsnicmp__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _tcsnicmp(x, arg2, arg3);
}

void test___tcsnicmp__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = _tcsnicmp(arg1, NULL, arg3);
}

void test___tcsnicmp__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _tcsnicmp(arg1, x, arg3);
}

void test___tcsnicmp__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  result = _tcsnicmp(arg1, arg2, !x);
}

void test___tcsnicmp__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = _tcsnicmp(arg1, arg2, x);
}

void test___strnicmp_l__noreturn() {
  int x = 1;
  if (cond) { x=100; result = _strnicmp_l(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___strnicmp_l__useretval() {
  // cppcheck-suppress ignoredReturnValue
  _strnicmp_l(arg1, arg2, arg3, arg4);
}

void test___strnicmp_l__leakignore() {
  char *p = malloc(10); *p=0;
  result = _strnicmp_l(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test___strnicmp_l__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = _strnicmp_l(NULL, arg2, arg3, arg4);
}

void test___strnicmp_l__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _strnicmp_l(x, arg2, arg3, arg4);
}

void test___strnicmp_l__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = _strnicmp_l(arg1, NULL, arg3, arg4);
}

void test___strnicmp_l__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _strnicmp_l(arg1, x, arg3, arg4);
}

void test___strnicmp_l__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  result = _strnicmp_l(arg1, arg2, !x, arg4);
}

void test___strnicmp_l__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = _strnicmp_l(arg1, arg2, x, arg4);
}

void test___strnicmp_l__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = _strnicmp_l(arg1, arg2, arg3, x);
}

void test___wcsnicmp_l__noreturn() {
  int x = 1;
  if (cond) { x=100; result = _wcsnicmp_l(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___wcsnicmp_l__useretval() {
  // cppcheck-suppress ignoredReturnValue
  _wcsnicmp_l(arg1, arg2, arg3, arg4);
}

void test___wcsnicmp_l__leakignore() {
  char *p = malloc(10); *p=0;
  result = _wcsnicmp_l(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test___wcsnicmp_l__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = _wcsnicmp_l(NULL, arg2, arg3, arg4);
}

void test___wcsnicmp_l__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _wcsnicmp_l(x, arg2, arg3, arg4);
}

void test___wcsnicmp_l__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = _wcsnicmp_l(arg1, NULL, arg3, arg4);
}

void test___wcsnicmp_l__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _wcsnicmp_l(arg1, x, arg3, arg4);
}

void test___wcsnicmp_l__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  result = _wcsnicmp_l(arg1, arg2, !x, arg4);
}

void test___wcsnicmp_l__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = _wcsnicmp_l(arg1, arg2, x, arg4);
}

void test___wcsnicmp_l__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = _wcsnicmp_l(arg1, arg2, arg3, x);
}

void test___mbsnicmp_l__noreturn() {
  int x = 1;
  if (cond) { x=100; result = _mbsnicmp_l(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___mbsnicmp_l__useretval() {
  // cppcheck-suppress ignoredReturnValue
  _mbsnicmp_l(arg1, arg2, arg3, arg4);
}

void test___mbsnicmp_l__leakignore() {
  char *p = malloc(10); *p=0;
  result = _mbsnicmp_l(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test___mbsnicmp_l__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = _mbsnicmp_l(NULL, arg2, arg3, arg4);
}

void test___mbsnicmp_l__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _mbsnicmp_l(x, arg2, arg3, arg4);
}

void test___mbsnicmp_l__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = _mbsnicmp_l(arg1, NULL, arg3, arg4);
}

void test___mbsnicmp_l__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _mbsnicmp_l(arg1, x, arg3, arg4);
}

void test___mbsnicmp_l__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  result = _mbsnicmp_l(arg1, arg2, !x, arg4);
}

void test___mbsnicmp_l__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = _mbsnicmp_l(arg1, arg2, x, arg4);
}

void test___mbsnicmp_l__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = _mbsnicmp_l(arg1, arg2, arg3, x);
}

void test___tcsncicmp_l__noreturn() {
  int x = 1;
  if (cond) { x=100; result = _tcsncicmp_l(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___tcsncicmp_l__useretval() {
  // cppcheck-suppress ignoredReturnValue
  _tcsncicmp_l(arg1, arg2, arg3, arg4);
}

void test___tcsncicmp_l__leakignore() {
  char *p = malloc(10); *p=0;
  result = _tcsncicmp_l(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test___tcsncicmp_l__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = _tcsncicmp_l(NULL, arg2, arg3, arg4);
}

void test___tcsncicmp_l__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _tcsncicmp_l(x, arg2, arg3, arg4);
}

void test___tcsncicmp_l__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = _tcsncicmp_l(arg1, NULL, arg3, arg4);
}

void test___tcsncicmp_l__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _tcsncicmp_l(arg1, x, arg3, arg4);
}

void test___tcsncicmp_l__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  result = _tcsncicmp_l(arg1, arg2, !x, arg4);
}

void test___tcsncicmp_l__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = _tcsncicmp_l(arg1, arg2, x, arg4);
}

void test___tcsncicmp_l__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = _tcsncicmp_l(arg1, arg2, arg3, x);
}

void test___malloc_dbg__noreturn() {
  int x = 1;
  if (cond) { x=100; result = _malloc_dbg(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___malloc_dbg__useretval() {
  // cppcheck-suppress ignoredReturnValue
  _malloc_dbg(arg1, arg2, arg3, arg4);
}

void test___malloc_dbg__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = _malloc_dbg(x, arg2, arg3, arg4);
}

void test___malloc_dbg__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = _malloc_dbg(arg1, x, arg3, arg4);
}

void test___malloc_dbg__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = _malloc_dbg(arg1, arg2, x, arg4);
}

void test___malloc_dbg__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = _malloc_dbg(arg1, arg2, arg3, x);
}

void test___aligned_malloc_dbg__noreturn() {
  int x = 1;
  if (cond) { x=100; result = _aligned_malloc_dbg(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___aligned_malloc_dbg__useretval() {
  // cppcheck-suppress ignoredReturnValue
  _aligned_malloc_dbg(arg1, arg2, arg3, arg4);
}

void test___aligned_malloc_dbg__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = _aligned_malloc_dbg(x, arg2, arg3, arg4);
}

void test___aligned_malloc_dbg__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = _aligned_malloc_dbg(arg1, x, arg3, arg4);
}

void test___aligned_malloc_dbg__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = _aligned_malloc_dbg(arg1, arg2, x, arg4);
}

void test___aligned_malloc_dbg__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = _aligned_malloc_dbg(arg1, arg2, arg3, x);
}

void test___aligned_malloc__noreturn() {
  int x = 1;
  if (cond) { x=100; result = _aligned_malloc(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___aligned_malloc__useretval() {
  // cppcheck-suppress ignoredReturnValue
  _aligned_malloc(arg1, arg2);
}

void test___aligned_malloc__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = _aligned_malloc(x, arg2);
}

void test___aligned_malloc__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = _aligned_malloc(arg1, x);
}

void test___mbslen_l__noreturn() {
  int x = 1;
  if (cond) { x=100; result = _mbslen_l(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___mbslen_l__useretval() {
  // cppcheck-suppress ignoredReturnValue
  _mbslen_l(arg1, arg2);
}

void test___mbslen_l__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((_mbslen_l(arg1, arg2) > 10) || (_mbslen_l(arg1, arg2) < 100)) {}
}

void test___mbslen_l__leakignore() {
  char *p = malloc(10); *p=0;
  result = _mbslen_l(p, arg2);
  // cppcheck-suppress memleak
}

void test___mbslen_l__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = _mbslen_l(NULL, arg2);
}

void test___mbslen_l__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _mbslen_l(x, arg2);
}

void test___mbslen_l__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = _mbslen_l(arg1, x);
}

void test___mbstrlen_l__noreturn() {
  int x = 1;
  if (cond) { x=100; result = _mbstrlen_l(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___mbstrlen_l__useretval() {
  // cppcheck-suppress ignoredReturnValue
  _mbstrlen_l(arg1, arg2);
}

void test___mbstrlen_l__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((_mbstrlen_l(arg1, arg2) > 10) || (_mbstrlen_l(arg1, arg2) < 100)) {}
}

void test___mbstrlen_l__leakignore() {
  char *p = malloc(10); *p=0;
  result = _mbstrlen_l(p, arg2);
  // cppcheck-suppress memleak
}

void test___mbstrlen_l__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = _mbstrlen_l(NULL, arg2);
}

void test___mbstrlen_l__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _mbstrlen_l(x, arg2);
}

void test___mbstrlen_l__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = _mbstrlen_l(arg1, x);
}

void test___tcsclen_l__noreturn() {
  int x = 1;
  if (cond) { x=100; result = _tcsclen_l(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___tcsclen_l__useretval() {
  // cppcheck-suppress ignoredReturnValue
  _tcsclen_l(arg1, arg2);
}

void test___tcsclen_l__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((_tcsclen_l(arg1, arg2) > 10) || (_tcsclen_l(arg1, arg2) < 100)) {}
}

void test___tcsclen_l__leakignore() {
  char *p = malloc(10); *p=0;
  result = _tcsclen_l(p, arg2);
  // cppcheck-suppress memleak
}

void test___tcsclen_l__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = _tcsclen_l(NULL, arg2);
}

void test___tcsclen_l__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _tcsclen_l(x, arg2);
}

void test___tcsclen_l__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = _tcsclen_l(arg1, x);
}

void test___mbslen__noreturn() {
  int x = 1;
  if (cond) { x=100; result = _mbslen(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___mbslen__useretval() {
  // cppcheck-suppress ignoredReturnValue
  _mbslen(arg1);
}

void test___mbslen__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((_mbslen(arg1) > 10) || (_mbslen(arg1) < 100)) {}
}

void test___mbslen__leakignore() {
  char *p = malloc(10); *p=0;
  result = _mbslen(p);
  // cppcheck-suppress memleak
}

void test___mbslen__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = _mbslen(NULL);
}

void test___mbslen__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _mbslen(x);
}

void test___mbstrlen__noreturn() {
  int x = 1;
  if (cond) { x=100; result = _mbstrlen(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___mbstrlen__useretval() {
  // cppcheck-suppress ignoredReturnValue
  _mbstrlen(arg1);
}

void test___mbstrlen__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((_mbstrlen(arg1) > 10) || (_mbstrlen(arg1) < 100)) {}
}

void test___mbstrlen__leakignore() {
  char *p = malloc(10); *p=0;
  result = _mbstrlen(p);
  // cppcheck-suppress memleak
}

void test___mbstrlen__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = _mbstrlen(NULL);
}

void test___mbstrlen__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _mbstrlen(x);
}

void test___tcslen__noreturn() {
  int x = 1;
  if (cond) { x=100; result = _tcslen(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___tcslen__useretval() {
  // cppcheck-suppress ignoredReturnValue
  _tcslen(arg1);
}

void test___tcslen__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((_tcslen(arg1) > 10) || (_tcslen(arg1) < 100)) {}
}

void test___tcslen__leakignore() {
  char *p = malloc(10); *p=0;
  result = _tcslen(p);
  // cppcheck-suppress memleak
}

void test___tcslen__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = _tcslen(NULL);
}

void test___tcslen__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _tcslen(x);
}

void test___tcsclen__noreturn() {
  int x = 1;
  if (cond) { x=100; result = _tcsclen(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___tcsclen__useretval() {
  // cppcheck-suppress ignoredReturnValue
  _tcsclen(arg1);
}

void test___tcsclen__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((_tcsclen(arg1) > 10) || (_tcsclen(arg1) < 100)) {}
}

void test___tcsclen__leakignore() {
  char *p = malloc(10); *p=0;
  result = _tcsclen(p);
  // cppcheck-suppress memleak
}

void test___tcsclen__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = _tcsclen(NULL);
}

void test___tcsclen__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _tcsclen(x);
}

void test___mbsrchr_l__noreturn() {
  int x = 1;
  if (cond) { x=100; result = _mbsrchr_l(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___mbsrchr_l__useretval() {
  // cppcheck-suppress ignoredReturnValue
  _mbsrchr_l(arg1, arg2, arg3);
}

void test___mbsrchr_l__leakignore() {
  char *p = malloc(10); *p=0;
  result = _mbsrchr_l(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test___mbsrchr_l__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = _mbsrchr_l(NULL, arg2, arg3);
}

void test___mbsrchr_l__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _mbsrchr_l(x, arg2, arg3);
}

void test___mbsrchr_l__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = _mbsrchr_l(arg1, x, arg3);
}

void test___mbsrchr_l__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = _mbsrchr_l(arg1, arg2, x);
}

void test___mbsrchr__noreturn() {
  int x = 1;
  if (cond) { x=100; result = _mbsrchr(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___mbsrchr__useretval() {
  // cppcheck-suppress ignoredReturnValue
  _mbsrchr(arg1, arg2);
}

void test___mbsrchr__leakignore() {
  char *p = malloc(10); *p=0;
  result = _mbsrchr(p, arg2);
  // cppcheck-suppress memleak
}

void test___mbsrchr__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = _mbsrchr(NULL, arg2);
}

void test___mbsrchr__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _mbsrchr(x, arg2);
}

void test___mbsrchr__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = _mbsrchr(arg1, x);
}

void test___tcsrchr__noreturn() {
  int x = 1;
  if (cond) { x=100; result = _tcsrchr(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___tcsrchr__useretval() {
  // cppcheck-suppress ignoredReturnValue
  _tcsrchr(arg1, arg2);
}

void test___tcsrchr__leakignore() {
  char *p = malloc(10); *p=0;
  result = _tcsrchr(p, arg2);
  // cppcheck-suppress memleak
}

void test___tcsrchr__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = _tcsrchr(NULL, arg2);
}

void test___tcsrchr__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _tcsrchr(x, arg2);
}

void test___tcsrchr__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = _tcsrchr(arg1, x);
}

void test___strftime_l__noreturn() {
  int x = 1;
  if (cond) { x=100; _strftime_l(arg1, arg2, arg3, arg4, arg5); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___strftime_l__leakignore() {
  char *p = malloc(10); *p=0;
  _strftime_l(p, arg2, arg3, arg4, arg5);
  // cppcheck-suppress memleak
}

void test___strftime_l__arg1__notnull() {
  // cppcheck-suppress nullPointer
  _strftime_l(NULL, arg2, arg3, arg4, arg5);
}

void test___strftime_l__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _strftime_l(arg1, x, arg3, arg4, arg5);
}

void test___strftime_l__arg3__notnull() {
  // cppcheck-suppress nullPointer
  _strftime_l(arg1, arg2, NULL, arg4, arg5);
}

void test___strftime_l__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _strftime_l(arg1, arg2, x, arg4, arg5);
}

void test___strftime_l__arg4__notnull() {
  // cppcheck-suppress nullPointer
  _strftime_l(arg1, arg2, arg3, NULL, arg5);
}

void test___strftime_l__arg4__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _strftime_l(arg1, arg2, arg3, x, arg5);
}

void test___strftime_l__arg5__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _strftime_l(arg1, arg2, arg3, arg4, x);
}

void test___wcsftime_l__noreturn() {
  int x = 1;
  if (cond) { x=100; _wcsftime_l(arg1, arg2, arg3, arg4, arg5); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___wcsftime_l__leakignore() {
  char *p = malloc(10); *p=0;
  _wcsftime_l(p, arg2, arg3, arg4, arg5);
  // cppcheck-suppress memleak
}

void test___wcsftime_l__arg1__notnull() {
  // cppcheck-suppress nullPointer
  _wcsftime_l(NULL, arg2, arg3, arg4, arg5);
}

void test___wcsftime_l__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _wcsftime_l(arg1, x, arg3, arg4, arg5);
}

void test___wcsftime_l__arg3__notnull() {
  // cppcheck-suppress nullPointer
  _wcsftime_l(arg1, arg2, NULL, arg4, arg5);
}

void test___wcsftime_l__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _wcsftime_l(arg1, arg2, x, arg4, arg5);
}

void test___wcsftime_l__arg4__notnull() {
  // cppcheck-suppress nullPointer
  _wcsftime_l(arg1, arg2, arg3, NULL, arg5);
}

void test___wcsftime_l__arg4__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _wcsftime_l(arg1, arg2, arg3, x, arg5);
}

void test___wcsftime_l__arg5__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _wcsftime_l(arg1, arg2, arg3, arg4, x);
}

void test___tcsftime__noreturn() {
  int x = 1;
  if (cond) { x=100; _tcsftime(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___tcsftime__leakignore() {
  char *p = malloc(10); *p=0;
  _tcsftime(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test___tcsftime__arg1__notnull() {
  // cppcheck-suppress nullPointer
  _tcsftime(NULL, arg2, arg3, arg4);
}

void test___tcsftime__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _tcsftime(arg1, x, arg3, arg4);
}

void test___tcsftime__arg3__notnull() {
  // cppcheck-suppress nullPointer
  _tcsftime(arg1, arg2, NULL, arg4);
}

void test___tcsftime__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _tcsftime(arg1, arg2, x, arg4);
}

void test___tcsftime__arg4__notnull() {
  // cppcheck-suppress nullPointer
  _tcsftime(arg1, arg2, arg3, NULL);
}

void test___tcsftime__arg4__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _tcsftime(arg1, arg2, arg3, x);
}

void test___wfreopen_s__noreturn() {
  int x = 1;
  if (cond) { x=100; result = _wfreopen_s(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___wfreopen_s__useretval() {
  // cppcheck-suppress ignoredReturnValue
  _wfreopen_s(arg1, arg2, arg3, arg4);
}

void test___wfreopen_s__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = _wfreopen_s(x, arg2, arg3, arg4);
}

void test___wfreopen_s__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = _wfreopen_s(arg1, x, arg3, arg4);
}

void test___wfreopen_s__arg3__notnull() {
  // cppcheck-suppress nullPointer
  result = _wfreopen_s(arg1, arg2, NULL, arg4);
}

void test___wfreopen_s__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _wfreopen_s(arg1, arg2, x, arg4);
}

void test___wfreopen_s__arg4__notnull() {
  // cppcheck-suppress nullPointer
  result = _wfreopen_s(arg1, arg2, arg3, NULL);
}

void test___wfreopen_s__arg4__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _wfreopen_s(arg1, arg2, arg3, x);
}

void test___tfreopen_s__noreturn() {
  int x = 1;
  if (cond) { x=100; result = _tfreopen_s(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___tfreopen_s__useretval() {
  // cppcheck-suppress ignoredReturnValue
  _tfreopen_s(arg1, arg2, arg3, arg4);
}

void test___tfreopen_s__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = _tfreopen_s(x, arg2, arg3, arg4);
}

void test___tfreopen_s__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = _tfreopen_s(arg1, x, arg3, arg4);
}

void test___tfreopen_s__arg3__notnull() {
  // cppcheck-suppress nullPointer
  result = _tfreopen_s(arg1, arg2, NULL, arg4);
}

void test___tfreopen_s__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _tfreopen_s(arg1, arg2, x, arg4);
}

void test___tfreopen_s__arg4__notnull() {
  // cppcheck-suppress nullPointer
  result = _tfreopen_s(arg1, arg2, arg3, NULL);
}

void test___tfreopen_s__arg4__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _tfreopen_s(arg1, arg2, arg3, x);
}

void test___wfreopen__noreturn() {
  int x = 1;
  if (cond) { x=100; result = _wfreopen(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___wfreopen__useretval() {
  // cppcheck-suppress ignoredReturnValue
  _wfreopen(arg1, arg2, arg3);
}

void test___wfreopen__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = _wfreopen(x, arg2, arg3);
}

void test___wfreopen__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = _wfreopen(arg1, NULL, arg3);
}

void test___wfreopen__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _wfreopen(arg1, x, arg3);
}

void test___wfreopen__arg3__notnull() {
  // cppcheck-suppress nullPointer
  result = _wfreopen(arg1, arg2, NULL);
}

void test___wfreopen__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _wfreopen(arg1, arg2, x);
}

void test___tfreopen__noreturn() {
  int x = 1;
  if (cond) { x=100; result = _tfreopen(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___tfreopen__useretval() {
  // cppcheck-suppress ignoredReturnValue
  _tfreopen(arg1, arg2, arg3);
}

void test___tfreopen__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = _tfreopen(x, arg2, arg3);
}

void test___tfreopen__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = _tfreopen(arg1, NULL, arg3);
}

void test___tfreopen__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _tfreopen(arg1, x, arg3);
}

void test___tfreopen__arg3__notnull() {
  // cppcheck-suppress nullPointer
  result = _tfreopen(arg1, arg2, NULL);
}

void test___tfreopen__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _tfreopen(arg1, arg2, x);
}

void test___mbsncpy__noreturn() {
  int x = 1;
  if (cond) { x=100; _mbsncpy(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___mbsncpy__leakignore() {
  char *p = malloc(10); *p=0;
  _mbsncpy(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test___mbsncpy__arg1__notnull() {
  // cppcheck-suppress nullPointer
  _mbsncpy(NULL, arg2, arg3);
}

void test___mbsncpy__arg2__notnull() {
  // cppcheck-suppress nullPointer
  _mbsncpy(arg1, NULL, arg3);
}

void test___mbsncpy__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _mbsncpy(arg1, x, arg3);
}

void test___mbsncpy__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  _mbsncpy(arg1, arg2, !x);
}

void test___mbsncpy__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _mbsncpy(arg1, arg2, x);
}

void test___mbsnbcpy__noreturn() {
  int x = 1;
  if (cond) { x=100; _mbsnbcpy(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___mbsnbcpy__leakignore() {
  char *p = malloc(10); *p=0;
  _mbsnbcpy(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test___mbsnbcpy__arg1__notnull() {
  // cppcheck-suppress nullPointer
  _mbsnbcpy(NULL, arg2, arg3);
}

void test___mbsnbcpy__arg2__notnull() {
  // cppcheck-suppress nullPointer
  _mbsnbcpy(arg1, NULL, arg3);
}

void test___mbsnbcpy__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _mbsnbcpy(arg1, x, arg3);
}

void test___mbsnbcpy__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  _mbsnbcpy(arg1, arg2, !x);
}

void test___mbsnbcpy__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _mbsnbcpy(arg1, arg2, x);
}

void test___tcsncpy__noreturn() {
  int x = 1;
  if (cond) { x=100; _tcsncpy(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___tcsncpy__leakignore() {
  char *p = malloc(10); *p=0;
  _tcsncpy(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test___tcsncpy__arg1__notnull() {
  // cppcheck-suppress nullPointer
  _tcsncpy(NULL, arg2, arg3);
}

void test___tcsncpy__arg2__notnull() {
  // cppcheck-suppress nullPointer
  _tcsncpy(arg1, NULL, arg3);
}

void test___tcsncpy__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _tcsncpy(arg1, x, arg3);
}

void test___tcsncpy__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  _tcsncpy(arg1, arg2, !x);
}

void test___tcsncpy__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _tcsncpy(arg1, arg2, x);
}

void test___strncpy_l__noreturn() {
  int x = 1;
  if (cond) { x=100; _strncpy_l(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___strncpy_l__leakignore() {
  char *p = malloc(10); *p=0;
  _strncpy_l(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test___strncpy_l__arg1__notnull() {
  // cppcheck-suppress nullPointer
  _strncpy_l(NULL, arg2, arg3, arg4);
}

void test___strncpy_l__arg2__notnull() {
  // cppcheck-suppress nullPointer
  _strncpy_l(arg1, NULL, arg3, arg4);
}

void test___strncpy_l__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _strncpy_l(arg1, x, arg3, arg4);
}

void test___strncpy_l__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  _strncpy_l(arg1, arg2, !x, arg4);
}

void test___strncpy_l__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _strncpy_l(arg1, arg2, x, arg4);
}

void test___strncpy_l__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _strncpy_l(arg1, arg2, arg3, x);
}

void test___wcsncpy_l__noreturn() {
  int x = 1;
  if (cond) { x=100; _wcsncpy_l(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___wcsncpy_l__leakignore() {
  char *p = malloc(10); *p=0;
  _wcsncpy_l(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test___wcsncpy_l__arg1__notnull() {
  // cppcheck-suppress nullPointer
  _wcsncpy_l(NULL, arg2, arg3, arg4);
}

void test___wcsncpy_l__arg2__notnull() {
  // cppcheck-suppress nullPointer
  _wcsncpy_l(arg1, NULL, arg3, arg4);
}

void test___wcsncpy_l__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _wcsncpy_l(arg1, x, arg3, arg4);
}

void test___wcsncpy_l__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  _wcsncpy_l(arg1, arg2, !x, arg4);
}

void test___wcsncpy_l__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _wcsncpy_l(arg1, arg2, x, arg4);
}

void test___wcsncpy_l__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _wcsncpy_l(arg1, arg2, arg3, x);
}

void test___mbsncpy_l__noreturn() {
  int x = 1;
  if (cond) { x=100; _mbsncpy_l(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___mbsncpy_l__leakignore() {
  char *p = malloc(10); *p=0;
  _mbsncpy_l(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test___mbsncpy_l__arg1__notnull() {
  // cppcheck-suppress nullPointer
  _mbsncpy_l(NULL, arg2, arg3, arg4);
}

void test___mbsncpy_l__arg2__notnull() {
  // cppcheck-suppress nullPointer
  _mbsncpy_l(arg1, NULL, arg3, arg4);
}

void test___mbsncpy_l__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _mbsncpy_l(arg1, x, arg3, arg4);
}

void test___mbsncpy_l__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  _mbsncpy_l(arg1, arg2, !x, arg4);
}

void test___mbsncpy_l__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _mbsncpy_l(arg1, arg2, x, arg4);
}

void test___mbsncpy_l__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _mbsncpy_l(arg1, arg2, arg3, x);
}

void test___tcsncpy_l__noreturn() {
  int x = 1;
  if (cond) { x=100; _tcsncpy_l(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___tcsncpy_l__leakignore() {
  char *p = malloc(10); *p=0;
  _tcsncpy_l(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test___tcsncpy_l__arg1__notnull() {
  // cppcheck-suppress nullPointer
  _tcsncpy_l(NULL, arg2, arg3, arg4);
}

void test___tcsncpy_l__arg2__notnull() {
  // cppcheck-suppress nullPointer
  _tcsncpy_l(arg1, NULL, arg3, arg4);
}

void test___tcsncpy_l__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  _tcsncpy_l(arg1, x, arg3, arg4);
}

void test___tcsncpy_l__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  _tcsncpy_l(arg1, arg2, !x, arg4);
}

void test___tcsncpy_l__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _tcsncpy_l(arg1, arg2, x, arg4);
}

void test___tcsncpy_l__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _tcsncpy_l(arg1, arg2, arg3, x);
}

void test___localtime32_s__noreturn() {
  int x = 1;
  if (cond) { x=100; _localtime32_s(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___localtime32_s__leakignore() {
  char *p = malloc(10); *p=0;
  _localtime32_s(p, arg2);
  // cppcheck-suppress memleak
}

void test___localtime32_s__arg1__notnull() {
  // cppcheck-suppress nullPointer
  _localtime32_s(NULL, arg2);
}

void test___localtime32_s__arg2__notnull() {
  // cppcheck-suppress nullPointer
  _localtime32_s(arg1, NULL);
}

void test___localtime64_s__noreturn() {
  int x = 1;
  if (cond) { x=100; _localtime64_s(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___localtime64_s__leakignore() {
  char *p = malloc(10); *p=0;
  _localtime64_s(p, arg2);
  // cppcheck-suppress memleak
}

void test___localtime64_s__arg1__notnull() {
  // cppcheck-suppress nullPointer
  _localtime64_s(NULL, arg2);
}

void test___localtime64_s__arg2__notnull() {
  // cppcheck-suppress nullPointer
  _localtime64_s(arg1, NULL);
}

void test__CreateDirectory__noreturn() {
  int x = 1;
  if (cond) { x=100; CreateDirectory(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__CreateDirectory__leakignore() {
  char *p = malloc(10); *p=0;
  CreateDirectory(p, arg2);
  // cppcheck-suppress memleak
}

void test__CreateDirectory__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateDirectory(x, arg2);
}

void test__CreateDirectory__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateDirectory(arg1, x);
}

void test__CreateDirectoryA__noreturn() {
  int x = 1;
  if (cond) { x=100; CreateDirectoryA(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__CreateDirectoryA__leakignore() {
  char *p = malloc(10); *p=0;
  CreateDirectoryA(p, arg2);
  // cppcheck-suppress memleak
}

void test__CreateDirectoryA__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateDirectoryA(x, arg2);
}

void test__CreateDirectoryA__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateDirectoryA(arg1, x);
}

void test__CreateDirectoryW__noreturn() {
  int x = 1;
  if (cond) { x=100; CreateDirectoryW(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__CreateDirectoryW__leakignore() {
  char *p = malloc(10); *p=0;
  CreateDirectoryW(p, arg2);
  // cppcheck-suppress memleak
}

void test__CreateDirectoryW__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateDirectoryW(x, arg2);
}

void test__CreateDirectoryW__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateDirectoryW(arg1, x);
}

void test__RemoveDirectory__noreturn() {
  int x = 1;
  if (cond) { x=100; RemoveDirectory(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__RemoveDirectory__leakignore() {
  char *p = malloc(10); *p=0;
  RemoveDirectory(p);
  // cppcheck-suppress memleak
}

void test__RemoveDirectory__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  RemoveDirectory(x);
}

void test__RemoveDirectoryA__noreturn() {
  int x = 1;
  if (cond) { x=100; RemoveDirectoryA(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__RemoveDirectoryA__leakignore() {
  char *p = malloc(10); *p=0;
  RemoveDirectoryA(p);
  // cppcheck-suppress memleak
}

void test__RemoveDirectoryA__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  RemoveDirectoryA(x);
}

void test__RemoveDirectoryW__noreturn() {
  int x = 1;
  if (cond) { x=100; RemoveDirectoryW(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__RemoveDirectoryW__leakignore() {
  char *p = malloc(10); *p=0;
  RemoveDirectoryW(p);
  // cppcheck-suppress memleak
}

void test__RemoveDirectoryW__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  RemoveDirectoryW(x);
}

void test____isascii__noreturn() {
  int x = 1;
  if (cond) { x=100; __isascii(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test____isascii__leakignore() {
  char *p = malloc(10); *p=0;
  __isascii(p);
  // cppcheck-suppress memleak
}

void test____isascii__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  __isascii(x);
}

void test__iswascii__noreturn() {
  int x = 1;
  if (cond) { x=100; iswascii(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__iswascii__leakignore() {
  char *p = malloc(10); *p=0;
  iswascii(p);
  // cppcheck-suppress memleak
}

void test__iswascii__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  iswascii(x);
}

void test___getchar__noreturn() {
  int x = 1;
  if (cond) { x=100; _getchar(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___getchar__leakignore() {
  char *p = malloc(10); *p=0;
  _getchar();
  // cppcheck-suppress memleak
}

void test___getch_nolock__noreturn() {
  int x = 1;
  if (cond) { x=100; _getch_nolock(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___getch_nolock__leakignore() {
  char *p = malloc(10); *p=0;
  _getch_nolock();
  // cppcheck-suppress memleak
}

void test___getwch__noreturn() {
  int x = 1;
  if (cond) { x=100; _getwch(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___getwch__leakignore() {
  char *p = malloc(10); *p=0;
  _getwch();
  // cppcheck-suppress memleak
}

void test___getwch_nolock__noreturn() {
  int x = 1;
  if (cond) { x=100; _getwch_nolock(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___getwch_nolock__leakignore() {
  char *p = malloc(10); *p=0;
  _getwch_nolock();
  // cppcheck-suppress memleak
}

void test__Sleep__noreturn() {
  int x = 1;
  if (cond) { x=100; Sleep(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__Sleep__leakignore() {
  char *p = malloc(10); *p=0;
  Sleep(p);
  // cppcheck-suppress memleak
}

void test__Sleep__arg1__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  Sleep(!x);
}

void test__Sleep__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  Sleep(x);
}

void test__SleepEx__noreturn() {
  int x = 1;
  if (cond) { x=100; SleepEx(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__SleepEx__leakignore() {
  char *p = malloc(10); *p=0;
  SleepEx(p, arg2);
  // cppcheck-suppress memleak
}

void test__SleepEx__arg1__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  SleepEx(!x, arg2);
}

void test__SleepEx__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  SleepEx(x, arg2);
}

void test__SleepEx__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  SleepEx(arg1, x);
}

void test__LoadLibrary__noreturn() {
  int x = 1;
  if (cond) { x=100; LoadLibrary(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__LoadLibrary__arg1__notnull() {
  // cppcheck-suppress nullPointer
  LoadLibrary(NULL);
}

void test__LoadLibrary__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  LoadLibrary(x);
}

void test__LoadLibraryA__noreturn() {
  int x = 1;
  if (cond) { x=100; LoadLibraryA(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__LoadLibraryA__arg1__notnull() {
  // cppcheck-suppress nullPointer
  LoadLibraryA(NULL);
}

void test__LoadLibraryA__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  LoadLibraryA(x);
}

void test__LoadLibraryW__noreturn() {
  int x = 1;
  if (cond) { x=100; LoadLibraryW(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__LoadLibraryW__arg1__notnull() {
  // cppcheck-suppress nullPointer
  LoadLibraryW(NULL);
}

void test__LoadLibraryW__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  LoadLibraryW(x);
}

void test__LoadLibraryEx__noreturn() {
  int x = 1;
  if (cond) { x=100; LoadLibraryEx(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__LoadLibraryEx__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  LoadLibraryEx(x, arg2, arg3);
}

void test__LoadLibraryEx__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  LoadLibraryEx(arg1, arg2, x);
}

void test__LoadLibraryExA__noreturn() {
  int x = 1;
  if (cond) { x=100; LoadLibraryExA(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__LoadLibraryExA__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  LoadLibraryExA(x, arg2, arg3);
}

void test__LoadLibraryExA__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  LoadLibraryExA(arg1, arg2, x);
}

void test__LoadLibraryExW__noreturn() {
  int x = 1;
  if (cond) { x=100; LoadLibraryExW(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__LoadLibraryExW__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  LoadLibraryExW(x, arg2, arg3);
}

void test__LoadLibraryExW__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  LoadLibraryExW(arg1, arg2, x);
}

void test__GetModuleHandle__noreturn() {
  int x = 1;
  if (cond) { x=100; result = GetModuleHandle(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__GetModuleHandle__useretval() {
  // cppcheck-suppress ignoredReturnValue
  GetModuleHandle(arg1);
}

void test__GetModuleHandle__leakignore() {
  char *p = malloc(10); *p=0;
  result = GetModuleHandle(p);
  // cppcheck-suppress memleak
}

void test__GetModuleHandle__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = GetModuleHandle(x);
}

void test__GetModuleHandleA__noreturn() {
  int x = 1;
  if (cond) { x=100; result = GetModuleHandleA(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__GetModuleHandleA__useretval() {
  // cppcheck-suppress ignoredReturnValue
  GetModuleHandleA(arg1);
}

void test__GetModuleHandleA__leakignore() {
  char *p = malloc(10); *p=0;
  result = GetModuleHandleA(p);
  // cppcheck-suppress memleak
}

void test__GetModuleHandleA__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = GetModuleHandleA(x);
}

void test__GetModuleHandleW__noreturn() {
  int x = 1;
  if (cond) { x=100; result = GetModuleHandleW(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__GetModuleHandleW__useretval() {
  // cppcheck-suppress ignoredReturnValue
  GetModuleHandleW(arg1);
}

void test__GetModuleHandleW__leakignore() {
  char *p = malloc(10); *p=0;
  result = GetModuleHandleW(p);
  // cppcheck-suppress memleak
}

void test__GetModuleHandleW__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = GetModuleHandleW(x);
}

void test__GetModuleHandleEx__noreturn() {
  int x = 1;
  if (cond) { x=100; GetModuleHandleEx(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__GetModuleHandleEx__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  GetModuleHandleEx(x, arg2, arg3);
}

void test__GetModuleHandleEx__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  GetModuleHandleEx(arg1, x, arg3);
}

void test__GetModuleHandleEx__arg3__notnull() {
  // cppcheck-suppress nullPointer
  GetModuleHandleEx(arg1, arg2, NULL);
}

void test__GetModuleHandleExA__noreturn() {
  int x = 1;
  if (cond) { x=100; GetModuleHandleExA(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__GetModuleHandleExA__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  GetModuleHandleExA(x, arg2, arg3);
}

void test__GetModuleHandleExA__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  GetModuleHandleExA(arg1, x, arg3);
}

void test__GetModuleHandleExA__arg3__notnull() {
  // cppcheck-suppress nullPointer
  GetModuleHandleExA(arg1, arg2, NULL);
}

void test__GetModuleHandleExW__noreturn() {
  int x = 1;
  if (cond) { x=100; GetModuleHandleExW(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__GetModuleHandleExW__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  GetModuleHandleExW(x, arg2, arg3);
}

void test__GetModuleHandleExW__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  GetModuleHandleExW(arg1, x, arg3);
}

void test__GetModuleHandleExW__arg3__notnull() {
  // cppcheck-suppress nullPointer
  GetModuleHandleExW(arg1, arg2, NULL);
}

void test__FreeLibrary__noreturn() {
  int x = 1;
  if (cond) { x=100; FreeLibrary(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__FreeLibrary__arg1__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  FreeLibrary(!x);
}

void test__FreeLibrary__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  FreeLibrary(x);
}

void test__FreeLibraryAndExitThread__noreturn() {
  int x = 1;
  if (cond) { x=100; FreeLibraryAndExitThread(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__FreeLibraryAndExitThread__arg1__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  FreeLibraryAndExitThread(!x, arg2);
}

void test__FreeLibraryAndExitThread__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  FreeLibraryAndExitThread(x, arg2);
}

void test__FreeLibraryAndExitThread__arg2__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  FreeLibraryAndExitThread(arg1, !x);
}

void test__FreeLibraryAndExitThread__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  FreeLibraryAndExitThread(arg1, x);
}

void test__GetProcAddress__noreturn() {
  int x = 1;
  if (cond) { x=100; result = GetProcAddress(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__GetProcAddress__useretval() {
  // cppcheck-suppress ignoredReturnValue
  GetProcAddress(arg1, arg2);
}

void test__GetProcAddress__leakignore() {
  char *p = malloc(10); *p=0;
  result = GetProcAddress(p, arg2);
  // cppcheck-suppress memleak
}

void test__GetProcAddress__arg1__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  result = GetProcAddress(!x, arg2);
}

void test__GetProcAddress__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = GetProcAddress(NULL, arg2);
}

void test__GetProcAddress__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = GetProcAddress(x, arg2);
}

void test__GetProcAddress__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = GetProcAddress(arg1, x);
}

void test__CreateEvent__noreturn() {
  int x = 1;
  if (cond) { x=100; CreateEvent(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__CreateEvent__arg1__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  CreateEvent(!x, arg2, arg3, arg4);
}

void test__CreateEvent__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateEvent(x, arg2, arg3, arg4);
}

void test__CreateEvent__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateEvent(arg1, x, arg3, arg4);
}

void test__CreateEvent__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateEvent(arg1, arg2, x, arg4);
}

void test__CreateEvent__arg4__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  CreateEvent(arg1, arg2, arg3, !x);
}

void test__CreateEvent__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateEvent(arg1, arg2, arg3, x);
}

void test__CreateEventA__noreturn() {
  int x = 1;
  if (cond) { x=100; CreateEventA(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__CreateEventA__arg1__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  CreateEventA(!x, arg2, arg3, arg4);
}

void test__CreateEventA__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateEventA(x, arg2, arg3, arg4);
}

void test__CreateEventA__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateEventA(arg1, x, arg3, arg4);
}

void test__CreateEventA__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateEventA(arg1, arg2, x, arg4);
}

void test__CreateEventA__arg4__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  CreateEventA(arg1, arg2, arg3, !x);
}

void test__CreateEventA__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateEventA(arg1, arg2, arg3, x);
}

void test__CreateEventW__noreturn() {
  int x = 1;
  if (cond) { x=100; CreateEventW(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__CreateEventW__arg1__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  CreateEventW(!x, arg2, arg3, arg4);
}

void test__CreateEventW__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateEventW(x, arg2, arg3, arg4);
}

void test__CreateEventW__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateEventW(arg1, x, arg3, arg4);
}

void test__CreateEventW__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateEventW(arg1, arg2, x, arg4);
}

void test__CreateEventW__arg4__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  CreateEventW(arg1, arg2, arg3, !x);
}

void test__CreateEventW__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateEventW(arg1, arg2, arg3, x);
}

void test__CreateEventEx__noreturn() {
  int x = 1;
  if (cond) { x=100; CreateEventEx(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__CreateEventEx__arg1__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  CreateEventEx(!x, arg2, arg3, arg4);
}

void test__CreateEventEx__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateEventEx(x, arg2, arg3, arg4);
}

void test__CreateEventEx__arg2__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  CreateEventEx(arg1, !x, arg3, arg4);
}

void test__CreateEventEx__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateEventEx(arg1, x, arg3, arg4);
}

void test__CreateEventEx__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  CreateEventEx(arg1, arg2, !x, arg4);
}

void test__CreateEventEx__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateEventEx(arg1, arg2, x, arg4);
}

void test__CreateEventEx__arg4__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  CreateEventEx(arg1, arg2, arg3, !x);
}

void test__CreateEventEx__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateEventEx(arg1, arg2, arg3, x);
}

void test__CreateEventExA__noreturn() {
  int x = 1;
  if (cond) { x=100; CreateEventExA(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__CreateEventExA__arg1__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  CreateEventExA(!x, arg2, arg3, arg4);
}

void test__CreateEventExA__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateEventExA(x, arg2, arg3, arg4);
}

void test__CreateEventExA__arg2__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  CreateEventExA(arg1, !x, arg3, arg4);
}

void test__CreateEventExA__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateEventExA(arg1, x, arg3, arg4);
}

void test__CreateEventExA__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  CreateEventExA(arg1, arg2, !x, arg4);
}

void test__CreateEventExA__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateEventExA(arg1, arg2, x, arg4);
}

void test__CreateEventExA__arg4__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  CreateEventExA(arg1, arg2, arg3, !x);
}

void test__CreateEventExA__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateEventExA(arg1, arg2, arg3, x);
}

void test__CreateEventExW__noreturn() {
  int x = 1;
  if (cond) { x=100; CreateEventExW(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__CreateEventExW__arg1__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  CreateEventExW(!x, arg2, arg3, arg4);
}

void test__CreateEventExW__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateEventExW(x, arg2, arg3, arg4);
}

void test__CreateEventExW__arg2__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  CreateEventExW(arg1, !x, arg3, arg4);
}

void test__CreateEventExW__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateEventExW(arg1, x, arg3, arg4);
}

void test__CreateEventExW__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  CreateEventExW(arg1, arg2, !x, arg4);
}

void test__CreateEventExW__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateEventExW(arg1, arg2, x, arg4);
}

void test__CreateEventExW__arg4__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  CreateEventExW(arg1, arg2, arg3, !x);
}

void test__CreateEventExW__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateEventExW(arg1, arg2, arg3, x);
}

void test__OpenEvent__noreturn() {
  int x = 1;
  if (cond) { x=100; OpenEvent(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__OpenEvent__arg1__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  OpenEvent(!x, arg2, arg3);
}

void test__OpenEvent__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  OpenEvent(x, arg2, arg3);
}

void test__OpenEvent__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  OpenEvent(arg1, x, arg3);
}

void test__OpenEvent__arg3__notnull() {
  // cppcheck-suppress nullPointer
  OpenEvent(arg1, arg2, NULL);
}

void test__OpenEvent__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  OpenEvent(arg1, arg2, x);
}

void test__OpenEventA__noreturn() {
  int x = 1;
  if (cond) { x=100; OpenEventA(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__OpenEventA__arg1__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  OpenEventA(!x, arg2, arg3);
}

void test__OpenEventA__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  OpenEventA(x, arg2, arg3);
}

void test__OpenEventA__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  OpenEventA(arg1, x, arg3);
}

void test__OpenEventA__arg3__notnull() {
  // cppcheck-suppress nullPointer
  OpenEventA(arg1, arg2, NULL);
}

void test__OpenEventA__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  OpenEventA(arg1, arg2, x);
}

void test__OpenEventW__noreturn() {
  int x = 1;
  if (cond) { x=100; OpenEventW(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__OpenEventW__arg1__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  OpenEventW(!x, arg2, arg3);
}

void test__OpenEventW__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  OpenEventW(x, arg2, arg3);
}

void test__OpenEventW__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  OpenEventW(arg1, x, arg3);
}

void test__OpenEventW__arg3__notnull() {
  // cppcheck-suppress nullPointer
  OpenEventW(arg1, arg2, NULL);
}

void test__OpenEventW__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  OpenEventW(arg1, arg2, x);
}

void test__PulseEvent__noreturn() {
  int x = 1;
  if (cond) { x=100; PulseEvent(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__PulseEvent__leakignore() {
  char *p = malloc(10); *p=0;
  PulseEvent(p);
  // cppcheck-suppress memleak
}

void test__PulseEvent__arg1__notnull() {
  // cppcheck-suppress nullPointer
  PulseEvent(NULL);
}

void test__PulseEvent__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  PulseEvent(x);
}

void test__ResetEvent__noreturn() {
  int x = 1;
  if (cond) { x=100; ResetEvent(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__ResetEvent__leakignore() {
  char *p = malloc(10); *p=0;
  ResetEvent(p);
  // cppcheck-suppress memleak
}

void test__ResetEvent__arg1__notnull() {
  // cppcheck-suppress nullPointer
  ResetEvent(NULL);
}

void test__ResetEvent__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  ResetEvent(x);
}

void test__SetEvent__noreturn() {
  int x = 1;
  if (cond) { x=100; SetEvent(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__SetEvent__leakignore() {
  char *p = malloc(10); *p=0;
  SetEvent(p);
  // cppcheck-suppress memleak
}

void test__SetEvent__arg1__notnull() {
  // cppcheck-suppress nullPointer
  SetEvent(NULL);
}

void test__SetEvent__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  SetEvent(x);
}

void test__InitializeCriticalSection__noreturn() {
  int x = 1;
  if (cond) { x=100; InitializeCriticalSection(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__InitializeCriticalSection__arg1__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  InitializeCriticalSection(!x);
}

void test__InitializeCriticalSection__arg1__notnull() {
  // cppcheck-suppress nullPointer
  InitializeCriticalSection(NULL);
}

void test__InitializeCriticalSectionAndSpinCount__noreturn() {
  int x = 1;
  if (cond) { x=100; InitializeCriticalSectionAndSpinCount(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__InitializeCriticalSectionAndSpinCount__arg1__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  InitializeCriticalSectionAndSpinCount(!x, arg2);
}

void test__InitializeCriticalSectionAndSpinCount__arg1__notnull() {
  // cppcheck-suppress nullPointer
  InitializeCriticalSectionAndSpinCount(NULL, arg2);
}

void test__InitializeCriticalSectionAndSpinCount__arg2__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  InitializeCriticalSectionAndSpinCount(arg1, !x);
}

void test__InitializeCriticalSectionAndSpinCount__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  InitializeCriticalSectionAndSpinCount(arg1, x);
}

void test__InitializeCriticalSectionEx__noreturn() {
  int x = 1;
  if (cond) { x=100; InitializeCriticalSectionEx(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__InitializeCriticalSectionEx__arg1__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  InitializeCriticalSectionEx(!x, arg2, arg3);
}

void test__InitializeCriticalSectionEx__arg1__notnull() {
  // cppcheck-suppress nullPointer
  InitializeCriticalSectionEx(NULL, arg2, arg3);
}

void test__InitializeCriticalSectionEx__arg2__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  InitializeCriticalSectionEx(arg1, !x, arg3);
}

void test__InitializeCriticalSectionEx__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  InitializeCriticalSectionEx(arg1, x, arg3);
}

void test__InitializeCriticalSectionEx__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  InitializeCriticalSectionEx(arg1, arg2, !x);
}

void test__InitializeCriticalSectionEx__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  InitializeCriticalSectionEx(arg1, arg2, x);
}

void test__SetCriticalSectionSpinCount__noreturn() {
  int x = 1;
  if (cond) { x=100; SetCriticalSectionSpinCount(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__SetCriticalSectionSpinCount__leakignore() {
  char *p = malloc(10); *p=0;
  SetCriticalSectionSpinCount(p, arg2);
  // cppcheck-suppress memleak
}

void test__SetCriticalSectionSpinCount__arg1__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  SetCriticalSectionSpinCount(!x, arg2);
}

void test__SetCriticalSectionSpinCount__arg1__notnull() {
  // cppcheck-suppress nullPointer
  SetCriticalSectionSpinCount(NULL, arg2);
}

void test__SetCriticalSectionSpinCount__arg2__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  SetCriticalSectionSpinCount(arg1, !x);
}

void test__SetCriticalSectionSpinCount__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  SetCriticalSectionSpinCount(arg1, x);
}

void test__DeleteCriticalSection__noreturn() {
  int x = 1;
  if (cond) { x=100; DeleteCriticalSection(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__DeleteCriticalSection__arg1__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  DeleteCriticalSection(!x);
}

void test__DeleteCriticalSection__arg1__notnull() {
  // cppcheck-suppress nullPointer
  DeleteCriticalSection(NULL);
}

void test__DeleteCriticalSection__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  DeleteCriticalSection(x);
}

void test__EnterCriticalSection__noreturn() {
  int x = 1;
  if (cond) { x=100; EnterCriticalSection(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__EnterCriticalSection__leakignore() {
  char *p = malloc(10); *p=0;
  EnterCriticalSection(p);
  // cppcheck-suppress memleak
}

void test__EnterCriticalSection__arg1__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  EnterCriticalSection(!x);
}

void test__EnterCriticalSection__arg1__notnull() {
  // cppcheck-suppress nullPointer
  EnterCriticalSection(NULL);
}

void test__EnterCriticalSection__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  EnterCriticalSection(x);
}

void test__TryEnterCriticalSection__noreturn() {
  int x = 1;
  if (cond) { x=100; TryEnterCriticalSection(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__TryEnterCriticalSection__leakignore() {
  char *p = malloc(10); *p=0;
  TryEnterCriticalSection(p);
  // cppcheck-suppress memleak
}

void test__TryEnterCriticalSection__arg1__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  TryEnterCriticalSection(!x);
}

void test__TryEnterCriticalSection__arg1__notnull() {
  // cppcheck-suppress nullPointer
  TryEnterCriticalSection(NULL);
}

void test__TryEnterCriticalSection__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  TryEnterCriticalSection(x);
}

void test__LeaveCriticalSection__noreturn() {
  int x = 1;
  if (cond) { x=100; LeaveCriticalSection(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__LeaveCriticalSection__leakignore() {
  char *p = malloc(10); *p=0;
  LeaveCriticalSection(p);
  // cppcheck-suppress memleak
}

void test__LeaveCriticalSection__arg1__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  LeaveCriticalSection(!x);
}

void test__LeaveCriticalSection__arg1__notnull() {
  // cppcheck-suppress nullPointer
  LeaveCriticalSection(NULL);
}

void test__LeaveCriticalSection__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  LeaveCriticalSection(x);
}

void test__lstrcat__noreturn() {
  int x = 1;
  if (cond) { x=100; lstrcat(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__lstrcat__leakignore() {
  char *p = malloc(10); *p=0;
  lstrcat(p, arg2);
  // cppcheck-suppress memleak
}

void test__lstrcat__arg1__notnull() {
  // cppcheck-suppress nullPointer
  lstrcat(NULL, arg2);
}

void test__lstrcat__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  lstrcat(x, arg2);
}

void test__lstrcat__arg2__notnull() {
  // cppcheck-suppress nullPointer
  lstrcat(arg1, NULL);
}

void test__lstrcat__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  lstrcat(arg1, x);
}

void test__CreateSemaphore__noreturn() {
  int x = 1;
  if (cond) { x=100; CreateSemaphore(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__CreateSemaphore__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateSemaphore(x, arg2, arg3, arg4);
}

void test__CreateSemaphore__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateSemaphore(arg1, x, arg3, arg4);
}

void test__CreateSemaphore__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateSemaphore(arg1, arg2, x, arg4);
}

void test__CreateSemaphore__arg4__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  CreateSemaphore(arg1, arg2, arg3, !x);
}

void test__CreateSemaphore__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateSemaphore(arg1, arg2, arg3, x);
}

void test__CreateSemaphoreA__noreturn() {
  int x = 1;
  if (cond) { x=100; CreateSemaphoreA(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__CreateSemaphoreA__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateSemaphoreA(x, arg2, arg3, arg4);
}

void test__CreateSemaphoreA__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateSemaphoreA(arg1, x, arg3, arg4);
}

void test__CreateSemaphoreA__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateSemaphoreA(arg1, arg2, x, arg4);
}

void test__CreateSemaphoreA__arg4__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  CreateSemaphoreA(arg1, arg2, arg3, !x);
}

void test__CreateSemaphoreA__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateSemaphoreA(arg1, arg2, arg3, x);
}

void test__CreateSemaphoreW__noreturn() {
  int x = 1;
  if (cond) { x=100; CreateSemaphoreW(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__CreateSemaphoreW__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateSemaphoreW(x, arg2, arg3, arg4);
}

void test__CreateSemaphoreW__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateSemaphoreW(arg1, x, arg3, arg4);
}

void test__CreateSemaphoreW__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateSemaphoreW(arg1, arg2, x, arg4);
}

void test__CreateSemaphoreW__arg4__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  CreateSemaphoreW(arg1, arg2, arg3, !x);
}

void test__CreateSemaphoreW__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateSemaphoreW(arg1, arg2, arg3, x);
}

void test__CreateSemaphoreEx__noreturn() {
  int x = 1;
  if (cond) { x=100; CreateSemaphoreEx(arg1, arg2, arg3, arg4, arg5, arg6); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__CreateSemaphoreEx__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateSemaphoreEx(x, arg2, arg3, arg4, arg5, arg6);
}

void test__CreateSemaphoreEx__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateSemaphoreEx(arg1, x, arg3, arg4, arg5, arg6);
}

void test__CreateSemaphoreEx__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateSemaphoreEx(arg1, arg2, x, arg4, arg5, arg6);
}

void test__CreateSemaphoreEx__arg4__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  CreateSemaphoreEx(arg1, arg2, arg3, !x, arg5, arg6);
}

void test__CreateSemaphoreEx__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateSemaphoreEx(arg1, arg2, arg3, x, arg5, arg6);
}

void test__CreateSemaphoreEx__arg5__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateSemaphoreEx(arg1, arg2, arg3, arg4, x, arg6);
}

void test__CreateSemaphoreEx__arg6__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateSemaphoreEx(arg1, arg2, arg3, arg4, arg5, x);
}

void test__CreateSemaphoreExA__noreturn() {
  int x = 1;
  if (cond) { x=100; CreateSemaphoreExA(arg1, arg2, arg3, arg4, arg5, arg6); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__CreateSemaphoreExA__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateSemaphoreExA(x, arg2, arg3, arg4, arg5, arg6);
}

void test__CreateSemaphoreExA__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateSemaphoreExA(arg1, x, arg3, arg4, arg5, arg6);
}

void test__CreateSemaphoreExA__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateSemaphoreExA(arg1, arg2, x, arg4, arg5, arg6);
}

void test__CreateSemaphoreExA__arg4__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  CreateSemaphoreExA(arg1, arg2, arg3, !x, arg5, arg6);
}

void test__CreateSemaphoreExA__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateSemaphoreExA(arg1, arg2, arg3, x, arg5, arg6);
}

void test__CreateSemaphoreExA__arg5__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateSemaphoreExA(arg1, arg2, arg3, arg4, x, arg6);
}

void test__CreateSemaphoreExA__arg6__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateSemaphoreExA(arg1, arg2, arg3, arg4, arg5, x);
}

void test__CreateSemaphoreExW__noreturn() {
  int x = 1;
  if (cond) { x=100; CreateSemaphoreExW(arg1, arg2, arg3, arg4, arg5, arg6); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__CreateSemaphoreExW__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateSemaphoreExW(x, arg2, arg3, arg4, arg5, arg6);
}

void test__CreateSemaphoreExW__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateSemaphoreExW(arg1, x, arg3, arg4, arg5, arg6);
}

void test__CreateSemaphoreExW__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateSemaphoreExW(arg1, arg2, x, arg4, arg5, arg6);
}

void test__CreateSemaphoreExW__arg4__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  CreateSemaphoreExW(arg1, arg2, arg3, !x, arg5, arg6);
}

void test__CreateSemaphoreExW__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateSemaphoreExW(arg1, arg2, arg3, x, arg5, arg6);
}

void test__CreateSemaphoreExW__arg5__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateSemaphoreExW(arg1, arg2, arg3, arg4, x, arg6);
}

void test__CreateSemaphoreExW__arg6__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateSemaphoreExW(arg1, arg2, arg3, arg4, arg5, x);
}

void test__OpenSemaphore__noreturn() {
  int x = 1;
  if (cond) { x=100; OpenSemaphore(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__OpenSemaphore__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  OpenSemaphore(x, arg2, arg3);
}

void test__OpenSemaphore__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  OpenSemaphore(arg1, x, arg3);
}

void test__OpenSemaphore__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  OpenSemaphore(arg1, arg2, !x);
}

void test__OpenSemaphore__arg3__notnull() {
  // cppcheck-suppress nullPointer
  OpenSemaphore(arg1, arg2, NULL);
}

void test__OpenSemaphore__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  OpenSemaphore(arg1, arg2, x);
}

void test__OpenSemaphoreA__noreturn() {
  int x = 1;
  if (cond) { x=100; OpenSemaphoreA(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__OpenSemaphoreA__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  OpenSemaphoreA(x, arg2, arg3);
}

void test__OpenSemaphoreA__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  OpenSemaphoreA(arg1, x, arg3);
}

void test__OpenSemaphoreA__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  OpenSemaphoreA(arg1, arg2, !x);
}

void test__OpenSemaphoreA__arg3__notnull() {
  // cppcheck-suppress nullPointer
  OpenSemaphoreA(arg1, arg2, NULL);
}

void test__OpenSemaphoreA__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  OpenSemaphoreA(arg1, arg2, x);
}

void test__OpenSemaphoreW__noreturn() {
  int x = 1;
  if (cond) { x=100; OpenSemaphoreW(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__OpenSemaphoreW__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  OpenSemaphoreW(x, arg2, arg3);
}

void test__OpenSemaphoreW__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  OpenSemaphoreW(arg1, x, arg3);
}

void test__OpenSemaphoreW__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  OpenSemaphoreW(arg1, arg2, !x);
}

void test__OpenSemaphoreW__arg3__notnull() {
  // cppcheck-suppress nullPointer
  OpenSemaphoreW(arg1, arg2, NULL);
}

void test__OpenSemaphoreW__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  OpenSemaphoreW(arg1, arg2, x);
}

void test__ReleaseSemaphore__noreturn() {
  int x = 1;
  if (cond) { x=100; ReleaseSemaphore(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__ReleaseSemaphore__arg1__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  ReleaseSemaphore(!x, arg2, arg3);
}

void test__ReleaseSemaphore__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  ReleaseSemaphore(x, arg2, arg3);
}

void test__ReleaseSemaphore__arg2__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  ReleaseSemaphore(arg1, !x, arg3);
}

void test__ReleaseSemaphore__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  ReleaseSemaphore(arg1, x, arg3);
}

void test__ReleaseSemaphore__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  ReleaseSemaphore(arg1, arg2, !x);
}

void test__ReleaseSemaphore__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  ReleaseSemaphore(arg1, arg2, x);
}

void test__CreateMutex__noreturn() {
  int x = 1;
  if (cond) { x=100; CreateMutex(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__CreateMutex__arg1__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  CreateMutex(!x, arg2, arg3);
}

void test__CreateMutex__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateMutex(x, arg2, arg3);
}

void test__CreateMutex__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateMutex(arg1, x, arg3);
}

void test__CreateMutex__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  CreateMutex(arg1, arg2, !x);
}

void test__CreateMutex__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateMutex(arg1, arg2, x);
}

void test__CreateMutexA__noreturn() {
  int x = 1;
  if (cond) { x=100; CreateMutexA(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__CreateMutexA__arg1__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  CreateMutexA(!x, arg2, arg3);
}

void test__CreateMutexA__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateMutexA(x, arg2, arg3);
}

void test__CreateMutexA__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateMutexA(arg1, x, arg3);
}

void test__CreateMutexA__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  CreateMutexA(arg1, arg2, !x);
}

void test__CreateMutexA__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateMutexA(arg1, arg2, x);
}

void test__CreateMutexW__noreturn() {
  int x = 1;
  if (cond) { x=100; CreateMutexW(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__CreateMutexW__arg1__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  CreateMutexW(!x, arg2, arg3);
}

void test__CreateMutexW__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateMutexW(x, arg2, arg3);
}

void test__CreateMutexW__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateMutexW(arg1, x, arg3);
}

void test__CreateMutexW__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  CreateMutexW(arg1, arg2, !x);
}

void test__CreateMutexW__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateMutexW(arg1, arg2, x);
}

void test__CreateMutexEx__noreturn() {
  int x = 1;
  if (cond) { x=100; CreateMutexEx(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__CreateMutexEx__arg1__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  CreateMutexEx(!x, arg2, arg3, arg4);
}

void test__CreateMutexEx__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateMutexEx(x, arg2, arg3, arg4);
}

void test__CreateMutexEx__arg2__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  CreateMutexEx(arg1, !x, arg3, arg4);
}

void test__CreateMutexEx__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateMutexEx(arg1, x, arg3, arg4);
}

void test__CreateMutexEx__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateMutexEx(arg1, arg2, x, arg4);
}

void test__CreateMutexEx__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateMutexEx(arg1, arg2, arg3, x);
}

void test__CreateMutexExA__noreturn() {
  int x = 1;
  if (cond) { x=100; CreateMutexExA(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__CreateMutexExA__arg1__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  CreateMutexExA(!x, arg2, arg3, arg4);
}

void test__CreateMutexExA__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateMutexExA(x, arg2, arg3, arg4);
}

void test__CreateMutexExA__arg2__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  CreateMutexExA(arg1, !x, arg3, arg4);
}

void test__CreateMutexExA__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateMutexExA(arg1, x, arg3, arg4);
}

void test__CreateMutexExA__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateMutexExA(arg1, arg2, x, arg4);
}

void test__CreateMutexExA__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateMutexExA(arg1, arg2, arg3, x);
}

void test__CreateMutexExW__noreturn() {
  int x = 1;
  if (cond) { x=100; CreateMutexExW(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__CreateMutexExW__arg1__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  CreateMutexExW(!x, arg2, arg3, arg4);
}

void test__CreateMutexExW__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateMutexExW(x, arg2, arg3, arg4);
}

void test__CreateMutexExW__arg2__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  CreateMutexExW(arg1, !x, arg3, arg4);
}

void test__CreateMutexExW__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateMutexExW(arg1, x, arg3, arg4);
}

void test__CreateMutexExW__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateMutexExW(arg1, arg2, x, arg4);
}

void test__CreateMutexExW__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  CreateMutexExW(arg1, arg2, arg3, x);
}

void test__OpenMutex__noreturn() {
  int x = 1;
  if (cond) { x=100; OpenMutex(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__OpenMutex__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  OpenMutex(x, arg2, arg3);
}

void test__OpenMutex__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  OpenMutex(arg1, x, arg3);
}

void test__OpenMutex__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  OpenMutex(arg1, arg2, !x);
}

void test__OpenMutex__arg3__notnull() {
  // cppcheck-suppress nullPointer
  OpenMutex(arg1, arg2, NULL);
}

void test__OpenMutex__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  OpenMutex(arg1, arg2, x);
}

void test__OpenMutexA__noreturn() {
  int x = 1;
  if (cond) { x=100; OpenMutexA(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__OpenMutexA__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  OpenMutexA(x, arg2, arg3);
}

void test__OpenMutexA__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  OpenMutexA(arg1, x, arg3);
}

void test__OpenMutexA__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  OpenMutexA(arg1, arg2, !x);
}

void test__OpenMutexA__arg3__notnull() {
  // cppcheck-suppress nullPointer
  OpenMutexA(arg1, arg2, NULL);
}

void test__OpenMutexA__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  OpenMutexA(arg1, arg2, x);
}

void test__OpenMutexW__noreturn() {
  int x = 1;
  if (cond) { x=100; OpenMutexW(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__OpenMutexW__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  OpenMutexW(x, arg2, arg3);
}

void test__OpenMutexW__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  OpenMutexW(arg1, x, arg3);
}

void test__OpenMutexW__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  OpenMutexW(arg1, arg2, !x);
}

void test__OpenMutexW__arg3__notnull() {
  // cppcheck-suppress nullPointer
  OpenMutexW(arg1, arg2, NULL);
}

void test__OpenMutexW__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  OpenMutexW(arg1, arg2, x);
}

void test__ReleaseMutex__noreturn() {
  int x = 1;
  if (cond) { x=100; ReleaseMutex(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__ReleaseMutex__leakignore() {
  char *p = malloc(10); *p=0;
  ReleaseMutex(p);
  // cppcheck-suppress memleak
}

void test__ReleaseMutex__arg1__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  ReleaseMutex(!x);
}

void test__ReleaseMutex__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  ReleaseMutex(x);
}

void test___malloca__noreturn() {
  int x = 1;
  if (cond) { x=100; _malloca(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___malloca__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _malloca(x);
}

void test___alloca__noreturn() {
  int x = 1;
  if (cond) { x=100; result = _alloca(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___alloca__useretval() {
  // cppcheck-suppress ignoredReturnValue
  _alloca(arg1);
}

void test___alloca__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = _alloca(x);
}

void test___freea__noreturn() {
  int x = 1;
  if (cond) { x=100; _freea(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___freea__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _freea(x);
}

void test__strlwr__noreturn() {
  int x = 1;
  if (cond) { x=100; strlwr(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__strlwr__arg1__notnull() {
  // cppcheck-suppress nullPointer
  strlwr(NULL);
}

void test__strlwr__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  strlwr(x);
}

void test__strupr__noreturn() {
  int x = 1;
  if (cond) { x=100; strupr(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__strupr__arg1__notnull() {
  // cppcheck-suppress nullPointer
  strupr(NULL);
}

void test__strupr__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  strupr(x);
}

void test__GetLocalTime__noreturn() {
  int x = 1;
  if (cond) { x=100; GetLocalTime(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__GetLocalTime__leakignore() {
  char *p = malloc(10); *p=0;
  GetLocalTime(p);
  // cppcheck-suppress memleak
}

void test__GetLocalTime__arg1__notnull() {
  // cppcheck-suppress nullPointer
  GetLocalTime(NULL);
}

void test__GetSystemTime__noreturn() {
  int x = 1;
  if (cond) { x=100; GetSystemTime(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__GetSystemTime__leakignore() {
  char *p = malloc(10); *p=0;
  GetSystemTime(p);
  // cppcheck-suppress memleak
}

void test__GetSystemTime__arg1__notnull() {
  // cppcheck-suppress nullPointer
  GetSystemTime(NULL);
}

void test__GetLastError__noreturn() {
  int x = 1;
  if (cond) { x=100; result = GetLastError(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__GetLastError__useretval() {
  // cppcheck-suppress ignoredReturnValue
  GetLastError();
}

void test__SetLastError__noreturn() {
  int x = 1;
  if (cond) { x=100; SetLastError(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__SetLastError__leakignore() {
  char *p = malloc(10); *p=0;
  SetLastError(p);
  // cppcheck-suppress memleak
}

void test__SetLastError__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  SetLastError(x);
}

void test__AllocateAndInitializeSid__noreturn() {
  int x = 1;
  if (cond) { x=100; AllocateAndInitializeSid(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__AllocateAndInitializeSid__arg1__notnull() {
  // cppcheck-suppress nullPointer
  AllocateAndInitializeSid(NULL, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11);
}

void test__AllocateAndInitializeSid__arg11__notnull() {
  // cppcheck-suppress nullPointer
  AllocateAndInitializeSid(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, NULL);
}

void test__FreeSid__noreturn() {
  int x = 1;
  if (cond) { x=100; FreeSid(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__FreeSid__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  FreeSid(x);
}

void test__HeapAlloc__noreturn() {
  int x = 1;
  if (cond) { x=100; HeapAlloc(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__HeapAlloc__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  HeapAlloc(x, arg2, arg3);
}

void test__HeapAlloc__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  HeapAlloc(arg1, x, arg3);
}

void test__HeapAlloc__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  HeapAlloc(arg1, arg2, x);
}

void test__HeapReAlloc__noreturn() {
  int x = 1;
  if (cond) { x=100; HeapReAlloc(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__HeapReAlloc__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  HeapReAlloc(x, arg2, arg3, arg4);
}

void test__HeapReAlloc__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  HeapReAlloc(arg1, x, arg3, arg4);
}

void test__HeapReAlloc__arg3__notnull() {
  // cppcheck-suppress nullPointer
  HeapReAlloc(arg1, arg2, NULL, arg4);
}

void test__HeapReAlloc__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  HeapReAlloc(arg1, arg2, x, arg4);
}

void test__HeapReAlloc__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  HeapReAlloc(arg1, arg2, arg3, x);
}

void test__HeapFree__noreturn() {
  int x = 1;
  if (cond) { x=100; HeapFree(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__HeapFree__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  HeapFree(x, arg2, arg3);
}

void test__HeapFree__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  HeapFree(arg1, x, arg3);
}

void test__HeapFree__arg3__notnull() {
  // cppcheck-suppress nullPointer
  HeapFree(arg1, arg2, NULL);
}

void test__HeapFree__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  HeapFree(arg1, arg2, x);
}

void test__HeapSize__noreturn() {
  int x = 1;
  if (cond) { x=100; result = HeapSize(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__HeapSize__useretval() {
  // cppcheck-suppress ignoredReturnValue
  HeapSize(arg1, arg2, arg3);
}

void test__HeapSize__leakignore() {
  char *p = malloc(10); *p=0;
  result = HeapSize(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__HeapSize__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = HeapSize(x, arg2, arg3);
}

void test__HeapSize__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = HeapSize(arg1, x, arg3);
}

void test__HeapSize__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = HeapSize(arg1, arg2, x);
}

void test__HeapValidate__noreturn() {
  int x = 1;
  if (cond) { x=100; HeapValidate(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__HeapValidate__leakignore() {
  char *p = malloc(10); *p=0;
  HeapValidate(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__HeapValidate__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  HeapValidate(x, arg2, arg3);
}

void test__HeapValidate__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  HeapValidate(arg1, x, arg3);
}

void test__HeapValidate__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  HeapValidate(arg1, arg2, x);
}

void test__GetProcessHeap__noreturn() {
  int x = 1;
  if (cond) { x=100; result = GetProcessHeap(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__GetProcessHeap__useretval() {
  // cppcheck-suppress ignoredReturnValue
  GetProcessHeap();
}

void test__GetUserName__noreturn() {
  int x = 1;
  if (cond) { x=100; GetUserName(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__GetUserName__leakignore() {
  char *p = malloc(10); *p=0;
  GetUserName(p, arg2);
  // cppcheck-suppress memleak
}

void test__GetUserName__arg2__notnull() {
  // cppcheck-suppress nullPointer
  GetUserName(arg1, NULL);
}

void test__GetUserName__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  GetUserName(arg1, x);
}

void test__GetUserNameA__noreturn() {
  int x = 1;
  if (cond) { x=100; GetUserNameA(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__GetUserNameA__leakignore() {
  char *p = malloc(10); *p=0;
  GetUserNameA(p, arg2);
  // cppcheck-suppress memleak
}

void test__GetUserNameA__arg2__notnull() {
  // cppcheck-suppress nullPointer
  GetUserNameA(arg1, NULL);
}

void test__GetUserNameA__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  GetUserNameA(arg1, x);
}

void test__GetUserNameW__noreturn() {
  int x = 1;
  if (cond) { x=100; GetUserNameW(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__GetUserNameW__leakignore() {
  char *p = malloc(10); *p=0;
  GetUserNameW(p, arg2);
  // cppcheck-suppress memleak
}

void test__GetUserNameW__arg2__notnull() {
  // cppcheck-suppress nullPointer
  GetUserNameW(arg1, NULL);
}

void test__GetUserNameW__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  GetUserNameW(arg1, x);
}

void test__GetWindowText__noreturn() {
  int x = 1;
  if (cond) { x=100; GetWindowText(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__GetWindowText__leakignore() {
  char *p = malloc(10); *p=0;
  GetWindowText(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__GetWindowText__arg1__notnull() {
  // cppcheck-suppress nullPointer
  GetWindowText(NULL, arg2, arg3);
}

void test__GetWindowText__arg2__notnull() {
  // cppcheck-suppress nullPointer
  GetWindowText(arg1, NULL, arg3);
}

void test__GetWindowText__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  GetWindowText(arg1, arg2, x);
}

void test__GetWindowTextA__noreturn() {
  int x = 1;
  if (cond) { x=100; GetWindowTextA(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__GetWindowTextA__leakignore() {
  char *p = malloc(10); *p=0;
  GetWindowTextA(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__GetWindowTextA__arg1__notnull() {
  // cppcheck-suppress nullPointer
  GetWindowTextA(NULL, arg2, arg3);
}

void test__GetWindowTextA__arg2__notnull() {
  // cppcheck-suppress nullPointer
  GetWindowTextA(arg1, NULL, arg3);
}

void test__GetWindowTextA__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  GetWindowTextA(arg1, arg2, x);
}

void test__GetWindowTextW__noreturn() {
  int x = 1;
  if (cond) { x=100; GetWindowTextW(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__GetWindowTextW__leakignore() {
  char *p = malloc(10); *p=0;
  GetWindowTextW(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__GetWindowTextW__arg1__notnull() {
  // cppcheck-suppress nullPointer
  GetWindowTextW(NULL, arg2, arg3);
}

void test__GetWindowTextW__arg2__notnull() {
  // cppcheck-suppress nullPointer
  GetWindowTextW(arg1, NULL, arg3);
}

void test__GetWindowTextW__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  GetWindowTextW(arg1, arg2, x);
}

void test__socket__noreturn() {
  int x = 1;
  if (cond) { x=100; socket(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__socket__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  socket(x, arg2, arg3);
}

void test__socket__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  socket(arg1, x, arg3);
}

void test__socket__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  socket(arg1, arg2, x);
}

void test__closesocket__noreturn() {
  int x = 1;
  if (cond) { x=100; closesocket(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__closesocket__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  closesocket(x);
}

void test__accept__noreturn() {
  int x = 1;
  if (cond) { x=100; accept(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__accept__leakignore() {
  char *p = malloc(10); *p=0;
  accept(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__accept__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  accept(x, arg2, arg3);
}

void test__accept__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  accept(arg1, x, arg3);
}

void test__accept__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  accept(arg1, arg2, x);
}

void test__bind__noreturn() {
  int x = 1;
  if (cond) { x=100; bind(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__bind__leakignore() {
  char *p = malloc(10); *p=0;
  bind(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__bind__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  bind(x, arg2, arg3);
}

void test__bind__arg2__notnull() {
  // cppcheck-suppress nullPointer
  bind(arg1, NULL, arg3);
}

void test__bind__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  bind(arg1, arg2, x);
}

void test__connect__noreturn() {
  int x = 1;
  if (cond) { x=100; connect(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__connect__leakignore() {
  char *p = malloc(10); *p=0;
  connect(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__connect__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  connect(x, arg2, arg3);
}

void test__connect__arg2__notnull() {
  // cppcheck-suppress nullPointer
  connect(arg1, NULL, arg3);
}

void test__connect__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  connect(arg1, arg2, x);
}

void test__getpeername__noreturn() {
  int x = 1;
  if (cond) { x=100; getpeername(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__getpeername__leakignore() {
  char *p = malloc(10); *p=0;
  getpeername(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__getpeername__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  getpeername(x, arg2, arg3);
}

void test__getpeername__arg2__notnull() {
  // cppcheck-suppress nullPointer
  getpeername(arg1, NULL, arg3);
}

void test__getpeername__arg3__notnull() {
  // cppcheck-suppress nullPointer
  getpeername(arg1, arg2, NULL);
}

void test__getpeername__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  getpeername(arg1, arg2, x);
}

void test__getsockname__noreturn() {
  int x = 1;
  if (cond) { x=100; getsockname(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__getsockname__leakignore() {
  char *p = malloc(10); *p=0;
  getsockname(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__getsockname__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  getsockname(x, arg2, arg3);
}

void test__getsockname__arg2__notnull() {
  // cppcheck-suppress nullPointer
  getsockname(arg1, NULL, arg3);
}

void test__getsockname__arg3__notnull() {
  // cppcheck-suppress nullPointer
  getsockname(arg1, arg2, NULL);
}

void test__getsockname__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  getsockname(arg1, arg2, x);
}

void test__getsockopt__noreturn() {
  int x = 1;
  if (cond) { x=100; getsockopt(arg1, arg2, arg3, arg4, arg5); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__getsockopt__leakignore() {
  char *p = malloc(10); *p=0;
  getsockopt(p, arg2, arg3, arg4, arg5);
  // cppcheck-suppress memleak
}

void test__getsockopt__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  getsockopt(x, arg2, arg3, arg4, arg5);
}

void test__getsockopt__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  getsockopt(arg1, x, arg3, arg4, arg5);
}

void test__getsockopt__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  getsockopt(arg1, arg2, x, arg4, arg5);
}

void test__getsockopt__arg4__notnull() {
  // cppcheck-suppress nullPointer
  getsockopt(arg1, arg2, arg3, NULL, arg5);
}

void test__getsockopt__arg5__notnull() {
  // cppcheck-suppress nullPointer
  getsockopt(arg1, arg2, arg3, arg4, NULL);
}

void test__getsockopt__arg5__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  getsockopt(arg1, arg2, arg3, arg4, x);
}

void test__htonl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = htonl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__htonl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  htonl(arg1);
}

void test__htonl__leakignore() {
  char *p = malloc(10); *p=0;
  result = htonl(p);
  // cppcheck-suppress memleak
}

void test__htonl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = htonl(x);
}

void test__htons__noreturn() {
  int x = 1;
  if (cond) { x=100; result = htons(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__htons__useretval() {
  // cppcheck-suppress ignoredReturnValue
  htons(arg1);
}

void test__htons__leakignore() {
  char *p = malloc(10); *p=0;
  result = htons(p);
  // cppcheck-suppress memleak
}

void test__htons__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = htons(x);
}

void test__inet_addr__noreturn() {
  int x = 1;
  if (cond) { x=100; result = inet_addr(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__inet_addr__useretval() {
  // cppcheck-suppress ignoredReturnValue
  inet_addr(arg1);
}

void test__inet_addr__leakignore() {
  char *p = malloc(10); *p=0;
  result = inet_addr(p);
  // cppcheck-suppress memleak
}

void test__inet_addr__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = inet_addr(NULL);
}

void test__inet_addr__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = inet_addr(x);
}

void test__inet_ntoa__noreturn() {
  int x = 1;
  if (cond) { x=100; result = inet_ntoa(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__inet_ntoa__useretval() {
  // cppcheck-suppress ignoredReturnValue
  inet_ntoa(arg1);
}

void test__inet_ntoa__leakignore() {
  char *p = malloc(10); *p=0;
  result = inet_ntoa(p);
  // cppcheck-suppress memleak
}

void test__inet_ntoa__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = inet_ntoa(x);
}

void test__ioctlsocket__noreturn() {
  int x = 1;
  if (cond) { x=100; ioctlsocket(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__ioctlsocket__leakignore() {
  char *p = malloc(10); *p=0;
  ioctlsocket(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__ioctlsocket__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  ioctlsocket(x, arg2, arg3);
}

void test__ioctlsocket__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  ioctlsocket(arg1, x, arg3);
}

void test__ioctlsocket__arg3__notnull() {
  // cppcheck-suppress nullPointer
  ioctlsocket(arg1, arg2, NULL);
}

void test__listen__noreturn() {
  int x = 1;
  if (cond) { x=100; listen(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__listen__leakignore() {
  char *p = malloc(10); *p=0;
  listen(p, arg2);
  // cppcheck-suppress memleak
}

void test__listen__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  listen(x, arg2);
}

void test__listen__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  listen(arg1, x);
}

void test__ntohl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = ntohl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__ntohl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  ntohl(arg1);
}

void test__ntohl__leakignore() {
  char *p = malloc(10); *p=0;
  result = ntohl(p);
  // cppcheck-suppress memleak
}

void test__ntohl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = ntohl(x);
}

void test__ntohs__noreturn() {
  int x = 1;
  if (cond) { x=100; result = ntohs(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__ntohs__useretval() {
  // cppcheck-suppress ignoredReturnValue
  ntohs(arg1);
}

void test__ntohs__leakignore() {
  char *p = malloc(10); *p=0;
  result = ntohs(p);
  // cppcheck-suppress memleak
}

void test__ntohs__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = ntohs(x);
}

void test__recv__noreturn() {
  int x = 1;
  if (cond) { x=100; recv(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__recv__leakignore() {
  char *p = malloc(10); *p=0;
  recv(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test__recv__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  recv(x, arg2, arg3, arg4);
}

void test__recv__arg2__notnull() {
  // cppcheck-suppress nullPointer
  recv(arg1, NULL, arg3, arg4);
}

void test__recv__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  recv(arg1, arg2, x, arg4);
}

void test__recv__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  recv(arg1, arg2, arg3, x);
}

void test__recvfrom__noreturn() {
  int x = 1;
  if (cond) { x=100; recvfrom(arg1, arg2, arg3, arg4, arg5, arg6); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__recvfrom__leakignore() {
  char *p = malloc(10); *p=0;
  recvfrom(p, arg2, arg3, arg4, arg5, arg6);
  // cppcheck-suppress memleak
}

void test__recvfrom__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  recvfrom(x, arg2, arg3, arg4, arg5, arg6);
}

void test__recvfrom__arg2__notnull() {
  // cppcheck-suppress nullPointer
  recvfrom(arg1, NULL, arg3, arg4, arg5, arg6);
}

void test__recvfrom__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  recvfrom(arg1, arg2, x, arg4, arg5, arg6);
}

void test__recvfrom__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  recvfrom(arg1, arg2, arg3, x, arg5, arg6);
}

void test__select__noreturn() {
  int x = 1;
  if (cond) { x=100; select(arg1, arg2, arg3, arg4, arg5); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__select__leakignore() {
  char *p = malloc(10); *p=0;
  select(p, arg2, arg3, arg4, arg5);
  // cppcheck-suppress memleak
}

void test__select__arg5__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  select(arg1, arg2, arg3, arg4, x);
}

void test__send__noreturn() {
  int x = 1;
  if (cond) { x=100; send(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__send__leakignore() {
  char *p = malloc(10); *p=0;
  send(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test__send__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  send(x, arg2, arg3, arg4);
}

void test__send__arg2__notnull() {
  // cppcheck-suppress nullPointer
  send(arg1, NULL, arg3, arg4);
}

void test__send__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  send(arg1, arg2, x, arg4);
}

void test__send__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  send(arg1, arg2, arg3, x);
}

void test__sendto__noreturn() {
  int x = 1;
  if (cond) { x=100; sendto(arg1, arg2, arg3, arg4, arg5, arg6); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__sendto__leakignore() {
  char *p = malloc(10); *p=0;
  sendto(p, arg2, arg3, arg4, arg5, arg6);
  // cppcheck-suppress memleak
}

void test__sendto__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  sendto(x, arg2, arg3, arg4, arg5, arg6);
}

void test__sendto__arg2__notnull() {
  // cppcheck-suppress nullPointer
  sendto(arg1, NULL, arg3, arg4, arg5, arg6);
}

void test__sendto__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  sendto(arg1, arg2, x, arg4, arg5, arg6);
}

void test__sendto__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  sendto(arg1, arg2, arg3, x, arg5, arg6);
}

void test__sendto__arg5__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  sendto(arg1, arg2, arg3, arg4, x, arg6);
}

void test__sendto__arg6__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  sendto(arg1, arg2, arg3, arg4, arg5, x);
}

void test__setsockopt__noreturn() {
  int x = 1;
  if (cond) { x=100; setsockopt(arg1, arg2, arg3, arg4, arg5); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__setsockopt__leakignore() {
  char *p = malloc(10); *p=0;
  setsockopt(p, arg2, arg3, arg4, arg5);
  // cppcheck-suppress memleak
}

void test__setsockopt__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  setsockopt(x, arg2, arg3, arg4, arg5);
}

void test__setsockopt__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  setsockopt(arg1, x, arg3, arg4, arg5);
}

void test__setsockopt__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  setsockopt(arg1, arg2, x, arg4, arg5);
}

void test__setsockopt__arg4__notnull() {
  // cppcheck-suppress nullPointer
  setsockopt(arg1, arg2, arg3, NULL, arg5);
}

void test__setsockopt__arg5__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  setsockopt(arg1, arg2, arg3, arg4, x);
}

void test__shutdown__noreturn() {
  int x = 1;
  if (cond) { x=100; shutdown(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__shutdown__leakignore() {
  char *p = malloc(10); *p=0;
  shutdown(p, arg2);
  // cppcheck-suppress memleak
}

void test__shutdown__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  shutdown(x, arg2);
}

void test__shutdown__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  shutdown(arg1, x);
}

void test__WSAStartup__noreturn() {
  int x = 1;
  if (cond) { x=100; WSAStartup(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__WSAStartup__leakignore() {
  char *p = malloc(10); *p=0;
  WSAStartup(p, arg2);
  // cppcheck-suppress memleak
}

void test__WSAStartup__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  WSAStartup(x, arg2);
}

void test__WSAStartup__arg2__notnull() {
  // cppcheck-suppress nullPointer
  WSAStartup(arg1, NULL);
}

void test__WSACleanup__noreturn() {
  int x = 1;
  if (cond) { x=100; WSACleanup(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__WSAGetLastError__noreturn() {
  int x = 1;
  if (cond) { x=100; result = WSAGetLastError(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__WSAGetLastError__useretval() {
  // cppcheck-suppress ignoredReturnValue
  WSAGetLastError();
}

void test__WSASetLastError__noreturn() {
  int x = 1;
  if (cond) { x=100; WSASetLastError(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__WSASetLastError__leakignore() {
  char *p = malloc(10); *p=0;
  WSASetLastError(p);
  // cppcheck-suppress memleak
}

void test__WSASetLastError__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  WSASetLastError(x);
}

void test___fileno__noreturn() {
  int x = 1;
  if (cond) { x=100; result = _fileno(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___fileno__useretval() {
  // cppcheck-suppress ignoredReturnValue
  _fileno(arg1);
}

void test___fileno__leakignore() {
  char *p = malloc(10); *p=0;
  result = _fileno(p);
  // cppcheck-suppress memleak
}

void test___fileno__arg1__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  result = _fileno(!x);
}

void test___fileno__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = _fileno(NULL);
}

void test___fileno__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = _fileno(x);
}

void test___tolower__noreturn() {
  int x = 1;
  if (cond) { x=100; result = _tolower(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___tolower__useretval() {
  // cppcheck-suppress ignoredReturnValue
  _tolower(arg1);
}

void test___tolower__leakignore() {
  char *p = malloc(10); *p=0;
  result = _tolower(p);
  // cppcheck-suppress memleak
}

void test___tolower__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = _tolower(x);
}

void test___tolower_l__noreturn() {
  int x = 1;
  if (cond) { x=100; result = _tolower_l(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___tolower_l__useretval() {
  // cppcheck-suppress ignoredReturnValue
  _tolower_l(arg1, arg2);
}

void test___tolower_l__leakignore() {
  char *p = malloc(10); *p=0;
  result = _tolower_l(p, arg2);
  // cppcheck-suppress memleak
}

void test___tolower_l__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = _tolower_l(x, arg2);
}

void test___tolower_l__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = _tolower_l(arg1, x);
}

void test___towlower_l__noreturn() {
  int x = 1;
  if (cond) { x=100; result = _towlower_l(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___towlower_l__useretval() {
  // cppcheck-suppress ignoredReturnValue
  _towlower_l(arg1, arg2);
}

void test___towlower_l__leakignore() {
  char *p = malloc(10); *p=0;
  result = _towlower_l(p, arg2);
  // cppcheck-suppress memleak
}

void test___towlower_l__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = _towlower_l(x, arg2);
}

void test___towlower_l__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = _towlower_l(arg1, x);
}

void test___toupper__noreturn() {
  int x = 1;
  if (cond) { x=100; result = _toupper(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___toupper__useretval() {
  // cppcheck-suppress ignoredReturnValue
  _toupper(arg1);
}

void test___toupper__leakignore() {
  char *p = malloc(10); *p=0;
  result = _toupper(p);
  // cppcheck-suppress memleak
}

void test___toupper__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = _toupper(x);
}

void test___toupper_l__noreturn() {
  int x = 1;
  if (cond) { x=100; result = _toupper_l(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___toupper_l__useretval() {
  // cppcheck-suppress ignoredReturnValue
  _toupper_l(arg1, arg2);
}

void test___toupper_l__leakignore() {
  char *p = malloc(10); *p=0;
  result = _toupper_l(p, arg2);
  // cppcheck-suppress memleak
}

void test___toupper_l__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = _toupper_l(x, arg2);
}

void test___toupper_l__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = _toupper_l(arg1, x);
}

void test___towupper_l__noreturn() {
  int x = 1;
  if (cond) { x=100; result = _towupper_l(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___towupper_l__useretval() {
  // cppcheck-suppress ignoredReturnValue
  _towupper_l(arg1, arg2);
}

void test___towupper_l__leakignore() {
  char *p = malloc(10); *p=0;
  result = _towupper_l(p, arg2);
  // cppcheck-suppress memleak
}

void test___towupper_l__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = _towupper_l(x, arg2);
}

void test___towupper_l__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = _towupper_l(arg1, x);
}

void test____noop__noreturn() {
  int x = 1;
  if (cond) { x=100; __noop(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test____noop__leakignore() {
  char *p = malloc(10); *p=0;
  __noop();
  // cppcheck-suppress memleak
}

void test____nop__noreturn() {
  int x = 1;
  if (cond) { x=100; __nop(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

