/* game.c generated by valac 0.38.1.9-3e35a, the Vala compiler
 * generated from game.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This file is part of Iagno.
 *
 * Iagno is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Iagno is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Iagno. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
typedef struct _GamePrivate GamePrivate;

#define TYPE_PLAYER (player_get_type ())
enum  {
	GAME_DUMMY_PROPERTY,
	GAME_SIZE_PROPERTY,
	GAME_CURRENT_COLOR_PROPERTY,
	GAME_NUMBER_OF_MOVES_PROPERTY,
	GAME_CURRENT_PLAYER_CAN_MOVE_PROPERTY,
	GAME_IS_COMPLETE_PROPERTY,
	GAME_INITIAL_NUMBER_OF_TILES_PROPERTY,
	GAME_N_TILES_PROPERTY,
	GAME_N_LIGHT_TILES_PROPERTY,
	GAME_N_DARK_TILES_PROPERTY,
	GAME_N_CURRENT_TILES_PROPERTY,
	GAME_N_OPPONENT_TILES_PROPERTY,
	GAME_LAST_PROPERTY
};
static GParamSpec* game_properties[GAME_LAST_PROPERTY];
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	GAME_TURN_ENDED_SIGNAL,
	GAME_SQUARE_CHANGED_SIGNAL,
	GAME_LAST_SIGNAL
};
static guint game_signals[GAME_LAST_SIGNAL] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Game {
	GObject parent_instance;
	GamePrivate * priv;
};

struct _GameClass {
	GObjectClass parent_class;
};

typedef enum  {
	PLAYER_NONE,
	PLAYER_DARK,
	PLAYER_LIGHT
} Player;

struct _GamePrivate {
	Player* tiles;
	gint tiles_length1;
	gint tiles_length2;
	gint _size;
	gint** undo_stack;
	gint undo_stack_length1;
	gint _undo_stack_size_;
	gint history_index;
	Player _current_color;
	gint _number_of_moves;
	gboolean _current_player_can_move;
	gboolean _is_complete;
	gint _initial_number_of_tiles;
	gint _n_light_tiles;
	gint _n_dark_tiles;
};


static gpointer game_parent_class = NULL;

GType game_get_type (void) G_GNUC_CONST;
GType player_get_type (void) G_GNUC_CONST;
#define GAME_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GAME, GamePrivate))
Game* game_new (gboolean alternative_start, gint tmp_size);
Game* game_construct (GType object_type, gboolean alternative_start, gint tmp_size);
static void game_set_size (Game* self, gint value);
gint game_get_size (Game* self);
static void game_set_initial_number_of_tiles (Game* self, gint value);
static void game_set_n_current_tiles (Game* self, gint value);
static void game_set_n_opponent_tiles (Game* self, gint value);
Game* game_new_from_strings (gchar** setup, int setup_length1, Player to_move, gint tmp_size);
Game* game_construct_from_strings (GType object_type, gchar** setup, int setup_length1, Player to_move, gint tmp_size);
Player player_from_char (gchar c);
static void game_set_current_color (Game* self, Player value);
gchar* game_to_string (Game* self);
gchar* player_to_string (Player self);
Game* game_new_copy (Game* game);
Game* game_construct_copy (GType object_type, Game* game);
gint game_get_number_of_moves (Game* self);
static void game_set_number_of_moves (Game* self, gint value);
Player game_get_current_color (Game* self);
gint game_get_n_current_tiles (Game* self);
gint game_get_n_opponent_tiles (Game* self);
gboolean game_is_valid_location (Game* self, gint x, gint y);
Player game_get_owner (Game* self, gint x, gint y);
gboolean game_can_place (Game* self, gint x, gint y, Player color);
static gint game_can_flip_tiles (Game* self, gint x, gint y, gint x_step, gint y_step, Player color);
gint game_place_tile (Game* self, gint x, gint y, gboolean apply);
static gint game_flip_tiles (Game* self, gint x, gint y, gint x_step, gint y_step, gboolean apply);
static void game_set_tile (Game* self, gint x, gint y);
static void game_end_of_turn (Game* self);
void game_pass (Game* self);
gboolean game_get_current_player_can_move (Game* self);
Player player_flip_color (Player p);
static void game_update_who_can_move (Game* self);
static void game_set_current_player_can_move (Game* self, gboolean value);
static void game_set_is_complete (Game* self, gboolean value);
static gint* _int_dup (gint* self);
void game_undo (Game* self, gint count);
static void game_unset_tile (Game* self, gint tile_number, Player replacement_color);
gboolean game_get_is_complete (Game* self);
gint game_get_initial_number_of_tiles (Game* self);
gint game_get_n_tiles (Game* self);
gint game_get_n_dark_tiles (Game* self);
gint game_get_n_light_tiles (Game* self);
static void g_cclosure_user_marshal_VOID__INT_INT_ENUM (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void game_finalize (GObject * obj);
static void _vala_game_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_game_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


Game* game_construct (GType object_type, gboolean alternative_start, gint tmp_size) {
	Game * self = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	Player* _tmp6_;
	gint _tmp21_;
	gint _tmp22_;
	gint** _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	_tmp0_ = tmp_size;
	_vala_return_val_if_fail (_tmp0_ >= 4, "tmp_size >= 4", NULL);
	self = (Game*) g_object_new (object_type, NULL);
	_tmp1_ = tmp_size;
	game_set_size (self, _tmp1_);
	_tmp2_ = game_get_size (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = game_get_size (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_new0 (Player, _tmp3_ * _tmp5_);
	self->priv->tiles = (g_free (self->priv->tiles), NULL);
	self->priv->tiles = _tmp6_;
	self->priv->tiles_length1 = _tmp3_;
	self->priv->tiles_length2 = _tmp5_;
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				gint _tmp9_;
				gint _tmp10_;
				gint _tmp11_;
				if (!_tmp7_) {
					gint _tmp8_;
					_tmp8_ = x;
					x = _tmp8_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp9_ = x;
				_tmp10_ = game_get_size (self);
				_tmp11_ = _tmp10_;
				if (!(_tmp9_ < _tmp11_)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp12_ = FALSE;
						_tmp12_ = TRUE;
						while (TRUE) {
							gint _tmp14_;
							gint _tmp15_;
							gint _tmp16_;
							Player* _tmp17_;
							gint _tmp17__length1;
							gint _tmp17__length2;
							gint _tmp18_;
							gint _tmp19_;
							Player _tmp20_;
							if (!_tmp12_) {
								gint _tmp13_;
								_tmp13_ = y;
								y = _tmp13_ + 1;
							}
							_tmp12_ = FALSE;
							_tmp14_ = y;
							_tmp15_ = game_get_size (self);
							_tmp16_ = _tmp15_;
							if (!(_tmp14_ < _tmp16_)) {
								break;
							}
							_tmp17_ = self->priv->tiles;
							_tmp17__length1 = self->priv->tiles_length1;
							_tmp17__length2 = self->priv->tiles_length2;
							_tmp18_ = x;
							_tmp19_ = y;
							_tmp17_[(_tmp18_ * _tmp17__length2) + _tmp19_] = PLAYER_NONE;
							_tmp20_ = _tmp17_[(_tmp18_ * _tmp17__length2) + _tmp19_];
						}
					}
				}
			}
		}
	}
	_tmp21_ = game_get_size (self);
	_tmp22_ = _tmp21_;
	_tmp23_ = g_new0 (gint*, 180 * (_tmp22_ - 1));
	self->priv->undo_stack = (_vala_array_free (self->priv->undo_stack, self->priv->undo_stack_length1, (GDestroyNotify) g_free), NULL);
	self->priv->undo_stack = _tmp23_;
	self->priv->undo_stack_length1 = 180 * (_tmp22_ - 1);
	self->priv->_undo_stack_size_ = self->priv->undo_stack_length1;
	_tmp24_ = game_get_size (self);
	_tmp25_ = _tmp24_;
	if ((_tmp25_ % 2) == 0) {
		Player _tmp26_ = 0;
		gboolean _tmp27_;
		Player* _tmp28_;
		gint _tmp28__length1;
		gint _tmp28__length2;
		gint _tmp29_;
		gint _tmp30_;
		gint _tmp31_;
		gint _tmp32_;
		Player _tmp33_;
		Player* _tmp34_;
		gint _tmp34__length1;
		gint _tmp34__length2;
		gint _tmp35_;
		gint _tmp36_;
		gint _tmp37_;
		gint _tmp38_;
		Player _tmp39_;
		Player _tmp40_ = 0;
		gboolean _tmp41_;
		Player* _tmp42_;
		gint _tmp42__length1;
		gint _tmp42__length2;
		gint _tmp43_;
		gint _tmp44_;
		gint _tmp45_;
		gint _tmp46_;
		Player _tmp47_;
		Player* _tmp48_;
		gint _tmp48__length1;
		gint _tmp48__length2;
		gint _tmp49_;
		gint _tmp50_;
		gint _tmp51_;
		gint _tmp52_;
		Player _tmp53_;
		game_set_initial_number_of_tiles (self, 4);
		_tmp27_ = alternative_start;
		if (_tmp27_) {
			_tmp26_ = PLAYER_DARK;
		} else {
			_tmp26_ = PLAYER_LIGHT;
		}
		_tmp28_ = self->priv->tiles;
		_tmp28__length1 = self->priv->tiles_length1;
		_tmp28__length2 = self->priv->tiles_length2;
		_tmp29_ = game_get_size (self);
		_tmp30_ = _tmp29_;
		_tmp31_ = game_get_size (self);
		_tmp32_ = _tmp31_;
		_tmp28_[(((_tmp30_ / 2) - 1) * _tmp28__length2) + ((_tmp32_ / 2) - 1)] = _tmp26_;
		_tmp33_ = _tmp28_[(((_tmp30_ / 2) - 1) * _tmp28__length2) + ((_tmp32_ / 2) - 1)];
		_tmp34_ = self->priv->tiles;
		_tmp34__length1 = self->priv->tiles_length1;
		_tmp34__length2 = self->priv->tiles_length2;
		_tmp35_ = game_get_size (self);
		_tmp36_ = _tmp35_;
		_tmp37_ = game_get_size (self);
		_tmp38_ = _tmp37_;
		_tmp34_[(((_tmp36_ / 2) - 1) * _tmp34__length2) + (_tmp38_ / 2)] = PLAYER_DARK;
		_tmp39_ = _tmp34_[(((_tmp36_ / 2) - 1) * _tmp34__length2) + (_tmp38_ / 2)];
		_tmp41_ = alternative_start;
		if (_tmp41_) {
			_tmp40_ = PLAYER_LIGHT;
		} else {
			_tmp40_ = PLAYER_DARK;
		}
		_tmp42_ = self->priv->tiles;
		_tmp42__length1 = self->priv->tiles_length1;
		_tmp42__length2 = self->priv->tiles_length2;
		_tmp43_ = game_get_size (self);
		_tmp44_ = _tmp43_;
		_tmp45_ = game_get_size (self);
		_tmp46_ = _tmp45_;
		_tmp42_[((_tmp44_ / 2) * _tmp42__length2) + ((_tmp46_ / 2) - 1)] = _tmp40_;
		_tmp47_ = _tmp42_[((_tmp44_ / 2) * _tmp42__length2) + ((_tmp46_ / 2) - 1)];
		_tmp48_ = self->priv->tiles;
		_tmp48__length1 = self->priv->tiles_length1;
		_tmp48__length2 = self->priv->tiles_length2;
		_tmp49_ = game_get_size (self);
		_tmp50_ = _tmp49_;
		_tmp51_ = game_get_size (self);
		_tmp52_ = _tmp51_;
		_tmp48_[((_tmp50_ / 2) * _tmp48__length2) + (_tmp52_ / 2)] = PLAYER_LIGHT;
		_tmp53_ = _tmp48_[((_tmp50_ / 2) * _tmp48__length2) + (_tmp52_ / 2)];
		game_set_n_current_tiles (self, 2);
		game_set_n_opponent_tiles (self, 2);
	} else {
		Player* _tmp54_;
		gint _tmp54__length1;
		gint _tmp54__length2;
		gint _tmp55_;
		gint _tmp56_;
		gint _tmp57_;
		gint _tmp58_;
		Player _tmp59_;
		Player _tmp60_ = 0;
		gboolean _tmp61_;
		Player* _tmp62_;
		gint _tmp62__length1;
		gint _tmp62__length2;
		gint _tmp63_;
		gint _tmp64_;
		gint _tmp65_;
		gint _tmp66_;
		Player _tmp67_;
		Player _tmp68_ = 0;
		gboolean _tmp69_;
		Player* _tmp70_;
		gint _tmp70__length1;
		gint _tmp70__length2;
		gint _tmp71_;
		gint _tmp72_;
		gint _tmp73_;
		gint _tmp74_;
		Player _tmp75_;
		Player* _tmp76_;
		gint _tmp76__length1;
		gint _tmp76__length2;
		gint _tmp77_;
		gint _tmp78_;
		gint _tmp79_;
		gint _tmp80_;
		Player _tmp81_;
		Player _tmp82_ = 0;
		gboolean _tmp83_;
		Player* _tmp84_;
		gint _tmp84__length1;
		gint _tmp84__length2;
		gint _tmp85_;
		gint _tmp86_;
		gint _tmp87_;
		gint _tmp88_;
		Player _tmp89_;
		Player _tmp90_ = 0;
		gboolean _tmp91_;
		Player* _tmp92_;
		gint _tmp92__length1;
		gint _tmp92__length2;
		gint _tmp93_;
		gint _tmp94_;
		gint _tmp95_;
		gint _tmp96_;
		Player _tmp97_;
		Player* _tmp98_;
		gint _tmp98__length1;
		gint _tmp98__length2;
		gint _tmp99_;
		gint _tmp100_;
		gint _tmp101_;
		gint _tmp102_;
		Player _tmp103_;
		game_set_initial_number_of_tiles (self, 7);
		_tmp54_ = self->priv->tiles;
		_tmp54__length1 = self->priv->tiles_length1;
		_tmp54__length2 = self->priv->tiles_length2;
		_tmp55_ = game_get_size (self);
		_tmp56_ = _tmp55_;
		_tmp57_ = game_get_size (self);
		_tmp58_ = _tmp57_;
		_tmp54_[(((_tmp56_ - 1) / 2) * _tmp54__length2) + ((_tmp58_ - 1) / 2)] = PLAYER_DARK;
		_tmp59_ = _tmp54_[(((_tmp56_ - 1) / 2) * _tmp54__length2) + ((_tmp58_ - 1) / 2)];
		_tmp61_ = alternative_start;
		if (_tmp61_) {
			_tmp60_ = PLAYER_LIGHT;
		} else {
			_tmp60_ = PLAYER_DARK;
		}
		_tmp62_ = self->priv->tiles;
		_tmp62__length1 = self->priv->tiles_length1;
		_tmp62__length2 = self->priv->tiles_length2;
		_tmp63_ = game_get_size (self);
		_tmp64_ = _tmp63_;
		_tmp65_ = game_get_size (self);
		_tmp66_ = _tmp65_;
		_tmp62_[(((_tmp64_ + 1) / 2) * _tmp62__length2) + ((_tmp66_ - 3) / 2)] = _tmp60_;
		_tmp67_ = _tmp62_[(((_tmp64_ + 1) / 2) * _tmp62__length2) + ((_tmp66_ - 3) / 2)];
		_tmp69_ = alternative_start;
		if (_tmp69_) {
			_tmp68_ = PLAYER_LIGHT;
		} else {
			_tmp68_ = PLAYER_DARK;
		}
		_tmp70_ = self->priv->tiles;
		_tmp70__length1 = self->priv->tiles_length1;
		_tmp70__length2 = self->priv->tiles_length2;
		_tmp71_ = game_get_size (self);
		_tmp72_ = _tmp71_;
		_tmp73_ = game_get_size (self);
		_tmp74_ = _tmp73_;
		_tmp70_[(((_tmp72_ - 3) / 2) * _tmp70__length2) + ((_tmp74_ + 1) / 2)] = _tmp68_;
		_tmp75_ = _tmp70_[(((_tmp72_ - 3) / 2) * _tmp70__length2) + ((_tmp74_ + 1) / 2)];
		_tmp76_ = self->priv->tiles;
		_tmp76__length1 = self->priv->tiles_length1;
		_tmp76__length2 = self->priv->tiles_length2;
		_tmp77_ = game_get_size (self);
		_tmp78_ = _tmp77_;
		_tmp79_ = game_get_size (self);
		_tmp80_ = _tmp79_;
		_tmp76_[(((_tmp78_ - 1) / 2) * _tmp76__length2) + ((_tmp80_ - 3) / 2)] = PLAYER_LIGHT;
		_tmp81_ = _tmp76_[(((_tmp78_ - 1) / 2) * _tmp76__length2) + ((_tmp80_ - 3) / 2)];
		_tmp83_ = alternative_start;
		if (_tmp83_) {
			_tmp82_ = PLAYER_DARK;
		} else {
			_tmp82_ = PLAYER_LIGHT;
		}
		_tmp84_ = self->priv->tiles;
		_tmp84__length1 = self->priv->tiles_length1;
		_tmp84__length2 = self->priv->tiles_length2;
		_tmp85_ = game_get_size (self);
		_tmp86_ = _tmp85_;
		_tmp87_ = game_get_size (self);
		_tmp88_ = _tmp87_;
		_tmp84_[(((_tmp86_ - 3) / 2) * _tmp84__length2) + ((_tmp88_ - 1) / 2)] = _tmp82_;
		_tmp89_ = _tmp84_[(((_tmp86_ - 3) / 2) * _tmp84__length2) + ((_tmp88_ - 1) / 2)];
		_tmp91_ = alternative_start;
		if (_tmp91_) {
			_tmp90_ = PLAYER_DARK;
		} else {
			_tmp90_ = PLAYER_LIGHT;
		}
		_tmp92_ = self->priv->tiles;
		_tmp92__length1 = self->priv->tiles_length1;
		_tmp92__length2 = self->priv->tiles_length2;
		_tmp93_ = game_get_size (self);
		_tmp94_ = _tmp93_;
		_tmp95_ = game_get_size (self);
		_tmp96_ = _tmp95_;
		_tmp92_[(((_tmp94_ + 1) / 2) * _tmp92__length2) + ((_tmp96_ - 1) / 2)] = _tmp90_;
		_tmp97_ = _tmp92_[(((_tmp94_ + 1) / 2) * _tmp92__length2) + ((_tmp96_ - 1) / 2)];
		_tmp98_ = self->priv->tiles;
		_tmp98__length1 = self->priv->tiles_length1;
		_tmp98__length2 = self->priv->tiles_length2;
		_tmp99_ = game_get_size (self);
		_tmp100_ = _tmp99_;
		_tmp101_ = game_get_size (self);
		_tmp102_ = _tmp101_;
		_tmp98_[(((_tmp100_ - 1) / 2) * _tmp98__length2) + ((_tmp102_ + 1) / 2)] = PLAYER_LIGHT;
		_tmp103_ = _tmp98_[(((_tmp100_ - 1) / 2) * _tmp98__length2) + ((_tmp102_ + 1) / 2)];
		game_set_n_current_tiles (self, 3);
		game_set_n_opponent_tiles (self, 4);
	}
	return self;
}


Game* game_new (gboolean alternative_start, gint tmp_size) {
	return game_construct (TYPE_GAME, alternative_start, tmp_size);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gchar* _vala_g_strjoinv (const gchar* separator, gchar** str_array, int str_array_length1) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar** _tmp3_;
	gint _tmp3__length1;
	_tmp0_ = separator;
	if (_tmp0_ == NULL) {
		separator = "";
	}
	_tmp3_ = str_array;
	_tmp3__length1 = str_array_length1;
	if (_tmp3_ != NULL) {
		_tmp2_ = TRUE;
	} else {
		gchar** _tmp4_;
		gint _tmp4__length1;
		_tmp4_ = str_array;
		_tmp4__length1 = str_array_length1;
		_tmp2_ = _tmp4__length1 > 0;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		gchar** _tmp6_;
		gint _tmp6__length1;
		_tmp6_ = str_array;
		_tmp6__length1 = str_array_length1;
		if (_tmp6__length1 == -1) {
			gchar** _tmp7_;
			gint _tmp7__length1;
			const gchar* _tmp8_;
			_tmp7_ = str_array;
			_tmp7__length1 = str_array_length1;
			_tmp8_ = _tmp7_[0];
			_tmp5_ = _tmp8_ != NULL;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp1_ = _tmp5_;
	}
	if (_tmp1_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp31_;
		gint _tmp33_;
		gint _tmp34_;
		gsize _tmp35_;
		const gchar* _tmp36_;
		gint _tmp37_;
		gint _tmp38_;
		gint _tmp39_;
		const gchar* res = NULL;
		gsize _tmp40_;
		void* _tmp41_;
		void* ptr = NULL;
		const gchar* _tmp42_;
		gchar** _tmp43_;
		gint _tmp43__length1;
		const gchar* _tmp44_;
		void* _tmp45_;
		const gchar* _tmp62_;
		len = (gsize) 1;
		{
			gboolean _tmp9_ = FALSE;
			i = 0;
			_tmp9_ = TRUE;
			while (TRUE) {
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
				gchar** _tmp13_;
				gint _tmp13__length1;
				gint _tmp21_ = 0;
				gchar** _tmp22_;
				gint _tmp22__length1;
				gint _tmp23_;
				const gchar* _tmp24_;
				gsize _tmp30_;
				if (!_tmp9_) {
					gint _tmp10_;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp13_ = str_array;
				_tmp13__length1 = str_array_length1;
				if (_tmp13__length1 != -1) {
					gint _tmp14_;
					gchar** _tmp15_;
					gint _tmp15__length1;
					_tmp14_ = i;
					_tmp15_ = str_array;
					_tmp15__length1 = str_array_length1;
					_tmp12_ = _tmp14_ < _tmp15__length1;
				} else {
					_tmp12_ = FALSE;
				}
				if (_tmp12_) {
					_tmp11_ = TRUE;
				} else {
					gboolean _tmp16_ = FALSE;
					gchar** _tmp17_;
					gint _tmp17__length1;
					_tmp17_ = str_array;
					_tmp17__length1 = str_array_length1;
					if (_tmp17__length1 == -1) {
						gchar** _tmp18_;
						gint _tmp18__length1;
						gint _tmp19_;
						const gchar* _tmp20_;
						_tmp18_ = str_array;
						_tmp18__length1 = str_array_length1;
						_tmp19_ = i;
						_tmp20_ = _tmp18_[_tmp19_];
						_tmp16_ = _tmp20_ != NULL;
					} else {
						_tmp16_ = FALSE;
					}
					_tmp11_ = _tmp16_;
				}
				if (!_tmp11_) {
					break;
				}
				_tmp22_ = str_array;
				_tmp22__length1 = str_array_length1;
				_tmp23_ = i;
				_tmp24_ = _tmp22_[_tmp23_];
				if (_tmp24_ != NULL) {
					gchar** _tmp25_;
					gint _tmp25__length1;
					gint _tmp26_;
					const gchar* _tmp27_;
					gint _tmp28_;
					gint _tmp29_;
					_tmp25_ = str_array;
					_tmp25__length1 = str_array_length1;
					_tmp26_ = i;
					_tmp27_ = _tmp25_[_tmp26_];
					_tmp28_ = strlen ((const gchar*) _tmp27_);
					_tmp29_ = _tmp28_;
					_tmp21_ = _tmp29_;
				} else {
					_tmp21_ = 0;
				}
				_tmp30_ = len;
				len = _tmp30_ + _tmp21_;
			}
		}
		_tmp31_ = i;
		if (_tmp31_ == 0) {
			gchar* _tmp32_;
			_tmp32_ = g_strdup ("");
			result = _tmp32_;
			return result;
		}
		_tmp33_ = i;
		str_array_length1 = _tmp33_;
		_tmp34_ = str_array_length1;
		_tmp35_ = len;
		_tmp36_ = separator;
		_tmp37_ = strlen ((const gchar*) _tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = i;
		len = _tmp35_ + (_tmp38_ * (_tmp39_ - 1));
		_tmp40_ = len;
		_tmp41_ = g_malloc (_tmp40_);
		res = _tmp41_;
		_tmp42_ = res;
		_tmp43_ = str_array;
		_tmp43__length1 = str_array_length1;
		_tmp44_ = _tmp43_[0];
		_tmp45_ = g_stpcpy ((void*) _tmp42_, (const gchar*) _tmp44_);
		ptr = _tmp45_;
		{
			gboolean _tmp46_ = FALSE;
			i = 1;
			_tmp46_ = TRUE;
			while (TRUE) {
				gint _tmp48_;
				gchar** _tmp49_;
				gint _tmp49__length1;
				void* _tmp50_;
				const gchar* _tmp51_;
				void* _tmp52_;
				const gchar* _tmp53_ = NULL;
				gchar** _tmp54_;
				gint _tmp54__length1;
				gint _tmp55_;
				const gchar* _tmp56_;
				void* _tmp60_;
				void* _tmp61_;
				if (!_tmp46_) {
					gint _tmp47_;
					_tmp47_ = i;
					i = _tmp47_ + 1;
				}
				_tmp46_ = FALSE;
				_tmp48_ = i;
				_tmp49_ = str_array;
				_tmp49__length1 = str_array_length1;
				if (!(_tmp48_ < _tmp49__length1)) {
					break;
				}
				_tmp50_ = ptr;
				_tmp51_ = separator;
				_tmp52_ = g_stpcpy (_tmp50_, (const gchar*) _tmp51_);
				ptr = _tmp52_;
				_tmp54_ = str_array;
				_tmp54__length1 = str_array_length1;
				_tmp55_ = i;
				_tmp56_ = _tmp54_[_tmp55_];
				if (_tmp56_ != NULL) {
					gchar** _tmp57_;
					gint _tmp57__length1;
					gint _tmp58_;
					const gchar* _tmp59_;
					_tmp57_ = str_array;
					_tmp57__length1 = str_array_length1;
					_tmp58_ = i;
					_tmp59_ = _tmp57_[_tmp58_];
					_tmp53_ = (const gchar*) _tmp59_;
				} else {
					_tmp53_ = "";
				}
				_tmp60_ = ptr;
				_tmp61_ = g_stpcpy (_tmp60_, _tmp53_);
				ptr = _tmp61_;
			}
		}
		_tmp62_ = res;
		res = NULL;
		result = (gchar*) _tmp62_;
		return result;
	} else {
		gchar* _tmp63_;
		_tmp63_ = g_strdup ("");
		result = _tmp63_;
		return result;
	}
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


Game* game_construct_from_strings (GType object_type, gchar** setup, int setup_length1, Player to_move, gint tmp_size) {
	Game * self = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	Player* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gint** _tmp10_;
	Player _tmp38_;
	gchar** _tmp39_;
	gint _tmp39__length1;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	_tmp0_ = setup;
	_tmp0__length1 = setup_length1;
	_tmp1_ = tmp_size;
	_vala_return_val_if_fail (_tmp0__length1 == _tmp1_, "setup.length == tmp_size", NULL);
	self = (Game*) g_object_new (object_type, NULL);
	_tmp2_ = tmp_size;
	game_set_size (self, _tmp2_);
	_tmp3_ = game_get_size (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = game_get_size (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_new0 (Player, _tmp4_ * _tmp6_);
	self->priv->tiles = (g_free (self->priv->tiles), NULL);
	self->priv->tiles = _tmp7_;
	self->priv->tiles_length1 = _tmp4_;
	self->priv->tiles_length2 = _tmp6_;
	_tmp8_ = game_get_size (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_new0 (gint*, 180 * (_tmp9_ - 1));
	self->priv->undo_stack = (_vala_array_free (self->priv->undo_stack, self->priv->undo_stack_length1, (GDestroyNotify) g_free), NULL);
	self->priv->undo_stack = _tmp10_;
	self->priv->undo_stack_length1 = 180 * (_tmp9_ - 1);
	self->priv->_undo_stack_size_ = self->priv->undo_stack_length1;
	{
		gint y = 0;
		y = 0;
		{
			gboolean _tmp11_ = FALSE;
			_tmp11_ = TRUE;
			while (TRUE) {
				gint _tmp13_;
				gint _tmp14_;
				gint _tmp15_;
				gchar** _tmp16_;
				gint _tmp16__length1;
				gint _tmp17_;
				const gchar* _tmp18_;
				gint _tmp19_;
				gint _tmp20_;
				gint _tmp21_;
				gint _tmp22_;
				if (!_tmp11_) {
					gint _tmp12_;
					_tmp12_ = y;
					y = _tmp12_ + 1;
				}
				_tmp11_ = FALSE;
				_tmp13_ = y;
				_tmp14_ = game_get_size (self);
				_tmp15_ = _tmp14_;
				if (!(_tmp13_ < _tmp15_)) {
					break;
				}
				_tmp16_ = setup;
				_tmp16__length1 = setup_length1;
				_tmp17_ = y;
				_tmp18_ = _tmp16_[_tmp17_];
				_tmp19_ = strlen (_tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = game_get_size (self);
				_tmp22_ = _tmp21_;
				if (_tmp20_ != (_tmp22_ * 2)) {
					g_warn_if_reached ();
				}
				{
					gint x = 0;
					x = 0;
					{
						gboolean _tmp23_ = FALSE;
						_tmp23_ = TRUE;
						while (TRUE) {
							gint _tmp25_;
							gint _tmp26_;
							gint _tmp27_;
							Player* _tmp28_;
							gint _tmp28__length1;
							gint _tmp28__length2;
							gint _tmp29_;
							gint _tmp30_;
							gchar** _tmp31_;
							gint _tmp31__length1;
							gint _tmp32_;
							const gchar* _tmp33_;
							gint _tmp34_;
							gchar _tmp35_;
							Player _tmp36_;
							Player _tmp37_;
							if (!_tmp23_) {
								gint _tmp24_;
								_tmp24_ = x;
								x = _tmp24_ + 1;
							}
							_tmp23_ = FALSE;
							_tmp25_ = x;
							_tmp26_ = game_get_size (self);
							_tmp27_ = _tmp26_;
							if (!(_tmp25_ < _tmp27_)) {
								break;
							}
							_tmp28_ = self->priv->tiles;
							_tmp28__length1 = self->priv->tiles_length1;
							_tmp28__length2 = self->priv->tiles_length2;
							_tmp29_ = x;
							_tmp30_ = y;
							_tmp31_ = setup;
							_tmp31__length1 = setup_length1;
							_tmp32_ = y;
							_tmp33_ = _tmp31_[_tmp32_];
							_tmp34_ = x;
							_tmp35_ = string_get (_tmp33_, (glong) ((_tmp34_ * 2) + 1));
							_tmp36_ = player_from_char (_tmp35_);
							_tmp28_[(_tmp29_ * _tmp28__length2) + _tmp30_] = _tmp36_;
							_tmp37_ = _tmp28_[(_tmp29_ * _tmp28__length2) + _tmp30_];
						}
					}
				}
			}
		}
	}
	_tmp38_ = to_move;
	game_set_current_color (self, _tmp38_);
	_tmp39_ = setup;
	_tmp39__length1 = setup_length1;
	_tmp40_ = _vala_g_strjoinv ("\n", _tmp39_, _tmp39__length1);
	_tmp41_ = _tmp40_;
	_tmp42_ = string_strip (_tmp41_);
	_tmp43_ = _tmp42_;
	_tmp44_ = game_to_string (self);
	_tmp45_ = _tmp44_;
	_tmp46_ = string_strip (_tmp45_);
	_tmp47_ = _tmp46_;
	g_warn_if_fail (g_strcmp0 (_tmp43_, _tmp47_) == 0);
	_g_free0 (_tmp47_);
	_g_free0 (_tmp45_);
	_g_free0 (_tmp43_);
	_g_free0 (_tmp41_);
	return self;
}


Game* game_new_from_strings (gchar** setup, int setup_length1, Player to_move, gint tmp_size) {
	return game_construct_from_strings (TYPE_GAME, setup, setup_length1, to_move, tmp_size);
}


gchar* game_to_string (Game* self) {
	gchar* result = NULL;
	gchar* s = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("\n");
	s = _tmp0_;
	{
		gint y = 0;
		y = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				const gchar* _tmp21_;
				gchar* _tmp22_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = y;
					y = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = y;
				_tmp4_ = game_get_size (self);
				_tmp5_ = _tmp4_;
				if (!(_tmp3_ < _tmp5_)) {
					break;
				}
				{
					gint x = 0;
					x = 0;
					{
						gboolean _tmp6_ = FALSE;
						_tmp6_ = TRUE;
						while (TRUE) {
							gint _tmp8_;
							gint _tmp9_;
							gint _tmp10_;
							const gchar* _tmp11_;
							Player* _tmp12_;
							gint _tmp12__length1;
							gint _tmp12__length2;
							gint _tmp13_;
							gint _tmp14_;
							Player _tmp15_;
							gchar* _tmp16_;
							gchar* _tmp17_;
							gchar* _tmp18_;
							gchar* _tmp19_;
							gchar* _tmp20_;
							if (!_tmp6_) {
								gint _tmp7_;
								_tmp7_ = x;
								x = _tmp7_ + 1;
							}
							_tmp6_ = FALSE;
							_tmp8_ = x;
							_tmp9_ = game_get_size (self);
							_tmp10_ = _tmp9_;
							if (!(_tmp8_ < _tmp10_)) {
								break;
							}
							_tmp11_ = s;
							_tmp12_ = self->priv->tiles;
							_tmp12__length1 = self->priv->tiles_length1;
							_tmp12__length2 = self->priv->tiles_length2;
							_tmp13_ = x;
							_tmp14_ = y;
							_tmp15_ = _tmp12_[(_tmp13_ * _tmp12__length2) + _tmp14_];
							_tmp16_ = player_to_string (_tmp15_);
							_tmp17_ = _tmp16_;
							_tmp18_ = g_strconcat (" ", _tmp17_, NULL);
							_tmp19_ = _tmp18_;
							_tmp20_ = g_strconcat (_tmp11_, _tmp19_, NULL);
							_g_free0 (s);
							s = _tmp20_;
							_g_free0 (_tmp19_);
							_g_free0 (_tmp17_);
						}
					}
				}
				_tmp21_ = s;
				_tmp22_ = g_strconcat (_tmp21_, "\n", NULL);
				_g_free0 (s);
				s = _tmp22_;
			}
		}
	}
	result = s;
	return result;
}


Game* game_construct_copy (GType object_type, Game* game) {
	Game * self = NULL;
	Game* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	Player* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gint** _tmp10_;
	Game* _tmp30_;
	gint _tmp31_;
	Game* _tmp32_;
	Player _tmp33_;
	Game* _tmp34_;
	gint _tmp35_;
	gint _tmp36_;
	Game* _tmp37_;
	gint _tmp38_;
	gint _tmp39_;
	g_return_val_if_fail (game != NULL, NULL);
	self = (Game*) g_object_new (object_type, NULL);
	_tmp0_ = game;
	_tmp1_ = game_get_size (_tmp0_);
	_tmp2_ = _tmp1_;
	game_set_size (self, _tmp2_);
	_tmp3_ = game_get_size (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = game_get_size (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_new0 (Player, _tmp4_ * _tmp6_);
	self->priv->tiles = (g_free (self->priv->tiles), NULL);
	self->priv->tiles = _tmp7_;
	self->priv->tiles_length1 = _tmp4_;
	self->priv->tiles_length2 = _tmp6_;
	_tmp8_ = game_get_size (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_new0 (gint*, 180 * (_tmp9_ - 1));
	self->priv->undo_stack = (_vala_array_free (self->priv->undo_stack, self->priv->undo_stack_length1, (GDestroyNotify) g_free), NULL);
	self->priv->undo_stack = _tmp10_;
	self->priv->undo_stack_length1 = 180 * (_tmp9_ - 1);
	self->priv->_undo_stack_size_ = self->priv->undo_stack_length1;
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp11_ = FALSE;
			_tmp11_ = TRUE;
			while (TRUE) {
				gint _tmp13_;
				gint _tmp14_;
				gint _tmp15_;
				if (!_tmp11_) {
					gint _tmp12_;
					_tmp12_ = x;
					x = _tmp12_ + 1;
				}
				_tmp11_ = FALSE;
				_tmp13_ = x;
				_tmp14_ = game_get_size (self);
				_tmp15_ = _tmp14_;
				if (!(_tmp13_ < _tmp15_)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp16_ = FALSE;
						_tmp16_ = TRUE;
						while (TRUE) {
							gint _tmp18_;
							gint _tmp19_;
							gint _tmp20_;
							Player* _tmp21_;
							gint _tmp21__length1;
							gint _tmp21__length2;
							gint _tmp22_;
							gint _tmp23_;
							Game* _tmp24_;
							Player* _tmp25_;
							gint _tmp25__length1;
							gint _tmp25__length2;
							gint _tmp26_;
							gint _tmp27_;
							Player _tmp28_;
							Player _tmp29_;
							if (!_tmp16_) {
								gint _tmp17_;
								_tmp17_ = y;
								y = _tmp17_ + 1;
							}
							_tmp16_ = FALSE;
							_tmp18_ = y;
							_tmp19_ = game_get_size (self);
							_tmp20_ = _tmp19_;
							if (!(_tmp18_ < _tmp20_)) {
								break;
							}
							_tmp21_ = self->priv->tiles;
							_tmp21__length1 = self->priv->tiles_length1;
							_tmp21__length2 = self->priv->tiles_length2;
							_tmp22_ = x;
							_tmp23_ = y;
							_tmp24_ = game;
							_tmp25_ = _tmp24_->priv->tiles;
							_tmp25__length1 = _tmp24_->priv->tiles_length1;
							_tmp25__length2 = _tmp24_->priv->tiles_length2;
							_tmp26_ = x;
							_tmp27_ = y;
							_tmp28_ = _tmp25_[(_tmp26_ * _tmp25__length2) + _tmp27_];
							_tmp21_[(_tmp22_ * _tmp21__length2) + _tmp23_] = _tmp28_;
							_tmp29_ = _tmp21_[(_tmp22_ * _tmp21__length2) + _tmp23_];
						}
					}
				}
			}
		}
	}
	_tmp30_ = game;
	_tmp31_ = _tmp30_->priv->_number_of_moves;
	game_set_number_of_moves (self, _tmp31_);
	_tmp32_ = game;
	_tmp33_ = _tmp32_->priv->_current_color;
	game_set_current_color (self, _tmp33_);
	_tmp34_ = game;
	_tmp35_ = game_get_n_current_tiles (_tmp34_);
	_tmp36_ = _tmp35_;
	game_set_n_current_tiles (self, _tmp36_);
	_tmp37_ = game;
	_tmp38_ = game_get_n_opponent_tiles (_tmp37_);
	_tmp39_ = _tmp38_;
	game_set_n_opponent_tiles (self, _tmp39_);
	return self;
}


Game* game_new_copy (Game* game) {
	return game_construct_copy (TYPE_GAME, game);
}


gboolean game_is_valid_location (Game* self, gint x, gint y) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp3_ = x;
	if (_tmp3_ >= 0) {
		gint _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		_tmp4_ = x;
		_tmp5_ = game_get_size (self);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp4_ < _tmp6_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gint _tmp7_;
		_tmp7_ = y;
		_tmp1_ = _tmp7_ >= 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gint _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		_tmp8_ = y;
		_tmp9_ = game_get_size (self);
		_tmp10_ = _tmp9_;
		_tmp0_ = _tmp8_ < _tmp10_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


Player game_get_owner (Game* self, gint x, gint y) {
	Player result = 0;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_;
	Player* _tmp3_;
	gint _tmp3__length1;
	gint _tmp3__length2;
	gint _tmp4_;
	gint _tmp5_;
	Player _tmp6_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = x;
	_tmp1_ = y;
	_tmp2_ = game_is_valid_location (self, _tmp0_, _tmp1_);
	_vala_return_val_if_fail (_tmp2_, "is_valid_location (x, y)", 0);
	_tmp3_ = self->priv->tiles;
	_tmp3__length1 = self->priv->tiles_length1;
	_tmp3__length2 = self->priv->tiles_length2;
	_tmp4_ = x;
	_tmp5_ = y;
	_tmp6_ = _tmp3_[(_tmp4_ * _tmp3__length2) + _tmp5_];
	result = _tmp6_;
	return result;
}


gboolean game_can_place (Game* self, gint x, gint y, Player color) {
	gboolean result = FALSE;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_;
	Player _tmp3_;
	Player* _tmp4_;
	gint _tmp4__length1;
	gint _tmp4__length2;
	gint _tmp5_;
	gint _tmp6_;
	Player _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	Player _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	Player _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	Player _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	Player _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	Player _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	Player _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	Player _tmp34_;
	gint _tmp35_;
	gint _tmp36_;
	gint _tmp37_;
	Player _tmp38_;
	gint _tmp39_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = x;
	_tmp1_ = y;
	_tmp2_ = game_is_valid_location (self, _tmp0_, _tmp1_);
	_vala_return_val_if_fail (_tmp2_, "is_valid_location (x, y)", FALSE);
	_tmp3_ = color;
	_vala_return_val_if_fail (_tmp3_ != PLAYER_NONE, "color != Player.NONE", FALSE);
	_tmp4_ = self->priv->tiles;
	_tmp4__length1 = self->priv->tiles_length1;
	_tmp4__length2 = self->priv->tiles_length2;
	_tmp5_ = x;
	_tmp6_ = y;
	_tmp7_ = _tmp4_[(_tmp5_ * _tmp4__length2) + _tmp6_];
	if (_tmp7_ != PLAYER_NONE) {
		result = FALSE;
		return result;
	}
	_tmp8_ = x;
	_tmp9_ = y;
	_tmp10_ = color;
	_tmp11_ = game_can_flip_tiles (self, _tmp8_, _tmp9_, 1, 0, _tmp10_);
	if (_tmp11_ > 0) {
		result = TRUE;
		return result;
	}
	_tmp12_ = x;
	_tmp13_ = y;
	_tmp14_ = color;
	_tmp15_ = game_can_flip_tiles (self, _tmp12_, _tmp13_, 1, 1, _tmp14_);
	if (_tmp15_ > 0) {
		result = TRUE;
		return result;
	}
	_tmp16_ = x;
	_tmp17_ = y;
	_tmp18_ = color;
	_tmp19_ = game_can_flip_tiles (self, _tmp16_, _tmp17_, 0, 1, _tmp18_);
	if (_tmp19_ > 0) {
		result = TRUE;
		return result;
	}
	_tmp20_ = x;
	_tmp21_ = y;
	_tmp22_ = color;
	_tmp23_ = game_can_flip_tiles (self, _tmp20_, _tmp21_, -1, 1, _tmp22_);
	if (_tmp23_ > 0) {
		result = TRUE;
		return result;
	}
	_tmp24_ = x;
	_tmp25_ = y;
	_tmp26_ = color;
	_tmp27_ = game_can_flip_tiles (self, _tmp24_, _tmp25_, -1, 0, _tmp26_);
	if (_tmp27_ > 0) {
		result = TRUE;
		return result;
	}
	_tmp28_ = x;
	_tmp29_ = y;
	_tmp30_ = color;
	_tmp31_ = game_can_flip_tiles (self, _tmp28_, _tmp29_, -1, -1, _tmp30_);
	if (_tmp31_ > 0) {
		result = TRUE;
		return result;
	}
	_tmp32_ = x;
	_tmp33_ = y;
	_tmp34_ = color;
	_tmp35_ = game_can_flip_tiles (self, _tmp32_, _tmp33_, 0, -1, _tmp34_);
	if (_tmp35_ > 0) {
		result = TRUE;
		return result;
	}
	_tmp36_ = x;
	_tmp37_ = y;
	_tmp38_ = color;
	_tmp39_ = game_can_flip_tiles (self, _tmp36_, _tmp37_, 1, -1, _tmp38_);
	if (_tmp39_ > 0) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


gint game_place_tile (Game* self, gint x, gint y, gboolean apply) {
	gint result = 0;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_;
	Player* _tmp3_;
	gint _tmp3__length1;
	gint _tmp3__length2;
	gint _tmp4_;
	gint _tmp5_;
	Player _tmp6_;
	gint tiles_turned = 0;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gboolean _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gboolean _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	gboolean _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	gboolean _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	gboolean _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	gint _tmp34_;
	gboolean _tmp35_;
	gint _tmp36_;
	gint _tmp37_;
	gint _tmp38_;
	gint _tmp39_;
	gboolean _tmp40_;
	gint _tmp41_;
	gint _tmp42_;
	gint _tmp43_;
	gint _tmp44_;
	gboolean _tmp45_;
	gint _tmp46_;
	gint _tmp47_;
	gboolean _tmp48_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = x;
	_tmp1_ = y;
	_tmp2_ = game_is_valid_location (self, _tmp0_, _tmp1_);
	_vala_return_val_if_fail (_tmp2_, "is_valid_location (x, y)", 0);
	_tmp3_ = self->priv->tiles;
	_tmp3__length1 = self->priv->tiles_length1;
	_tmp3__length2 = self->priv->tiles_length2;
	_tmp4_ = x;
	_tmp5_ = y;
	_tmp6_ = _tmp3_[(_tmp4_ * _tmp3__length2) + _tmp5_];
	if (_tmp6_ != PLAYER_NONE) {
		result = 0;
		return result;
	}
	tiles_turned = 0;
	_tmp7_ = tiles_turned;
	_tmp8_ = x;
	_tmp9_ = y;
	_tmp10_ = apply;
	_tmp11_ = game_flip_tiles (self, _tmp8_, _tmp9_, 1, 0, _tmp10_);
	tiles_turned = _tmp7_ + _tmp11_;
	_tmp12_ = tiles_turned;
	_tmp13_ = x;
	_tmp14_ = y;
	_tmp15_ = apply;
	_tmp16_ = game_flip_tiles (self, _tmp13_, _tmp14_, 1, 1, _tmp15_);
	tiles_turned = _tmp12_ + _tmp16_;
	_tmp17_ = tiles_turned;
	_tmp18_ = x;
	_tmp19_ = y;
	_tmp20_ = apply;
	_tmp21_ = game_flip_tiles (self, _tmp18_, _tmp19_, 0, 1, _tmp20_);
	tiles_turned = _tmp17_ + _tmp21_;
	_tmp22_ = tiles_turned;
	_tmp23_ = x;
	_tmp24_ = y;
	_tmp25_ = apply;
	_tmp26_ = game_flip_tiles (self, _tmp23_, _tmp24_, -1, 1, _tmp25_);
	tiles_turned = _tmp22_ + _tmp26_;
	_tmp27_ = tiles_turned;
	_tmp28_ = x;
	_tmp29_ = y;
	_tmp30_ = apply;
	_tmp31_ = game_flip_tiles (self, _tmp28_, _tmp29_, -1, 0, _tmp30_);
	tiles_turned = _tmp27_ + _tmp31_;
	_tmp32_ = tiles_turned;
	_tmp33_ = x;
	_tmp34_ = y;
	_tmp35_ = apply;
	_tmp36_ = game_flip_tiles (self, _tmp33_, _tmp34_, -1, -1, _tmp35_);
	tiles_turned = _tmp32_ + _tmp36_;
	_tmp37_ = tiles_turned;
	_tmp38_ = x;
	_tmp39_ = y;
	_tmp40_ = apply;
	_tmp41_ = game_flip_tiles (self, _tmp38_, _tmp39_, 0, -1, _tmp40_);
	tiles_turned = _tmp37_ + _tmp41_;
	_tmp42_ = tiles_turned;
	_tmp43_ = x;
	_tmp44_ = y;
	_tmp45_ = apply;
	_tmp46_ = game_flip_tiles (self, _tmp43_, _tmp44_, 1, -1, _tmp45_);
	tiles_turned = _tmp42_ + _tmp46_;
	_tmp47_ = tiles_turned;
	if (_tmp47_ == 0) {
		result = 0;
		return result;
	}
	_tmp48_ = apply;
	if (_tmp48_) {
		gint _tmp49_;
		gint _tmp50_;
		_tmp49_ = x;
		_tmp50_ = y;
		game_set_tile (self, _tmp49_, _tmp50_);
		game_end_of_turn (self);
	}
	result = tiles_turned;
	return result;
}


void game_pass (Game* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_current_player_can_move;
	_vala_return_if_fail (!_tmp0_, "!current_player_can_move");
	game_end_of_turn (self);
}


static void game_end_of_turn (Game* self) {
	gint _tmp0_;
	gint _tmp1_;
	gint** _tmp2_;
	gint _tmp2__length1;
	Player _tmp3_;
	Player _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint** _tmp7_;
	gint _tmp7__length1;
	gint _tmp8_;
	gint* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->history_index;
	_tmp1_ = self->priv->history_index;
	_tmp2_ = self->priv->undo_stack;
	_tmp2__length1 = self->priv->undo_stack_length1;
	_vala_return_if_fail ((_tmp0_ >= -1) && (_tmp1_ < (_tmp2__length1 - 2)), "history_index >= -1 && history_index < undo_stack.length - 2");
	_tmp3_ = self->priv->_current_color;
	_tmp4_ = player_flip_color (_tmp3_);
	game_set_current_color (self, _tmp4_);
	_tmp5_ = self->priv->_number_of_moves;
	game_set_number_of_moves (self, _tmp5_ + 1);
	_tmp6_ = self->priv->history_index;
	self->priv->history_index = _tmp6_ + 1;
	_tmp7_ = self->priv->undo_stack;
	_tmp7__length1 = self->priv->undo_stack_length1;
	_tmp8_ = self->priv->history_index;
	_g_free0 (_tmp7_[_tmp8_]);
	_tmp7_[_tmp8_] = NULL;
	_tmp9_ = _tmp7_[_tmp8_];
	game_update_who_can_move (self);
	g_signal_emit (self, game_signals[GAME_TURN_ENDED_SIGNAL], 0);
}


static void game_update_who_can_move (Game* self) {
	Player enemy = 0;
	Player _tmp0_;
	Player _tmp1_;
	gboolean opponent_can_move = FALSE;
	gboolean _tmp20_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_current_color;
	_tmp1_ = player_flip_color (_tmp0_);
	enemy = _tmp1_;
	opponent_can_move = FALSE;
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gint _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = x;
					x = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = x;
				_tmp5_ = game_get_size (self);
				_tmp6_ = _tmp5_;
				if (!(_tmp4_ < _tmp6_)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp7_ = FALSE;
						_tmp7_ = TRUE;
						while (TRUE) {
							gint _tmp9_;
							gint _tmp10_;
							gint _tmp11_;
							gint _tmp12_;
							gint _tmp13_;
							Player _tmp14_;
							gboolean _tmp15_;
							gint _tmp16_;
							gint _tmp17_;
							Player _tmp18_;
							gboolean _tmp19_;
							if (!_tmp7_) {
								gint _tmp8_;
								_tmp8_ = y;
								y = _tmp8_ + 1;
							}
							_tmp7_ = FALSE;
							_tmp9_ = y;
							_tmp10_ = game_get_size (self);
							_tmp11_ = _tmp10_;
							if (!(_tmp9_ < _tmp11_)) {
								break;
							}
							_tmp12_ = x;
							_tmp13_ = y;
							_tmp14_ = self->priv->_current_color;
							_tmp15_ = game_can_place (self, _tmp12_, _tmp13_, _tmp14_);
							if (_tmp15_) {
								game_set_current_player_can_move (self, TRUE);
								return;
							}
							_tmp16_ = x;
							_tmp17_ = y;
							_tmp18_ = enemy;
							_tmp19_ = game_can_place (self, _tmp16_, _tmp17_, _tmp18_);
							if (_tmp19_) {
								opponent_can_move = TRUE;
							}
						}
					}
				}
			}
		}
	}
	game_set_current_player_can_move (self, FALSE);
	_tmp20_ = opponent_can_move;
	if (!_tmp20_) {
		game_set_is_complete (self, TRUE);
	}
}


static gint game_flip_tiles (Game* self, gint x, gint y, gint x_step, gint y_step, gboolean apply) {
	gint result = 0;
	gint enemy_count = 0;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	Player _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gboolean _tmp7_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = x;
	_tmp1_ = y;
	_tmp2_ = x_step;
	_tmp3_ = y_step;
	_tmp4_ = self->priv->_current_color;
	_tmp5_ = game_can_flip_tiles (self, _tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp4_);
	enemy_count = _tmp5_;
	_tmp6_ = enemy_count;
	if (_tmp6_ == 0) {
		result = 0;
		return result;
	}
	_tmp7_ = apply;
	if (_tmp7_) {
		{
			gint i = 0;
			i = 1;
			{
				gboolean _tmp8_ = FALSE;
				_tmp8_ = TRUE;
				while (TRUE) {
					gint _tmp10_;
					gint _tmp11_;
					gint _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					gint _tmp15_;
					gint _tmp16_;
					gint _tmp17_;
					gint _tmp18_;
					gint _tmp19_;
					if (!_tmp8_) {
						gint _tmp9_;
						_tmp9_ = i;
						i = _tmp9_ + 1;
					}
					_tmp8_ = FALSE;
					_tmp10_ = i;
					_tmp11_ = enemy_count;
					if (!(_tmp10_ <= _tmp11_)) {
						break;
					}
					_tmp12_ = game_get_n_opponent_tiles (self);
					_tmp13_ = _tmp12_;
					game_set_n_opponent_tiles (self, _tmp13_ - 1);
					_tmp14_ = x;
					_tmp15_ = i;
					_tmp16_ = x_step;
					_tmp17_ = y;
					_tmp18_ = i;
					_tmp19_ = y_step;
					game_set_tile (self, _tmp14_ + (_tmp15_ * _tmp16_), _tmp17_ + (_tmp18_ * _tmp19_));
				}
			}
		}
	}
	result = enemy_count;
	return result;
}


static gint game_can_flip_tiles (Game* self, gint x, gint y, gint x_step, gint y_step, Player color) {
	gint result = 0;
	Player enemy = 0;
	Player _tmp0_;
	Player _tmp1_;
	gint enemy_count = 0;
	gint xt = 0;
	gint _tmp2_;
	gint yt = 0;
	gint _tmp3_;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_ = FALSE;
	gint _tmp21_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = color;
	_tmp1_ = player_flip_color (_tmp0_);
	enemy = _tmp1_;
	enemy_count = -1;
	_tmp2_ = x;
	xt = _tmp2_;
	_tmp3_ = y;
	yt = _tmp3_;
	{
		gboolean _tmp4_ = FALSE;
		_tmp4_ = TRUE;
		while (TRUE) {
			gint _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			if (!_tmp4_) {
				gboolean _tmp5_ = FALSE;
				gint _tmp6_;
				gint _tmp7_;
				gboolean _tmp8_;
				_tmp6_ = xt;
				_tmp7_ = yt;
				_tmp8_ = game_is_valid_location (self, _tmp6_, _tmp7_);
				if (_tmp8_) {
					Player* _tmp9_;
					gint _tmp9__length1;
					gint _tmp9__length2;
					gint _tmp10_;
					gint _tmp11_;
					Player _tmp12_;
					Player _tmp13_;
					_tmp9_ = self->priv->tiles;
					_tmp9__length1 = self->priv->tiles_length1;
					_tmp9__length2 = self->priv->tiles_length2;
					_tmp10_ = xt;
					_tmp11_ = yt;
					_tmp12_ = _tmp9_[(_tmp10_ * _tmp9__length2) + _tmp11_];
					_tmp13_ = enemy;
					_tmp5_ = _tmp12_ == _tmp13_;
				} else {
					_tmp5_ = FALSE;
				}
				if (!_tmp5_) {
					break;
				}
			}
			_tmp4_ = FALSE;
			_tmp14_ = enemy_count;
			enemy_count = _tmp14_ + 1;
			_tmp15_ = xt;
			_tmp16_ = x_step;
			xt = _tmp15_ + _tmp16_;
			_tmp17_ = yt;
			_tmp18_ = y_step;
			yt = _tmp17_ + _tmp18_;
		}
	}
	_tmp21_ = enemy_count;
	if (_tmp21_ == 0) {
		_tmp20_ = TRUE;
	} else {
		gint _tmp22_;
		gint _tmp23_;
		gboolean _tmp24_;
		_tmp22_ = xt;
		_tmp23_ = yt;
		_tmp24_ = game_is_valid_location (self, _tmp22_, _tmp23_);
		_tmp20_ = !_tmp24_;
	}
	if (_tmp20_) {
		_tmp19_ = TRUE;
	} else {
		Player* _tmp25_;
		gint _tmp25__length1;
		gint _tmp25__length2;
		gint _tmp26_;
		gint _tmp27_;
		Player _tmp28_;
		Player _tmp29_;
		_tmp25_ = self->priv->tiles;
		_tmp25__length1 = self->priv->tiles_length1;
		_tmp25__length2 = self->priv->tiles_length2;
		_tmp26_ = xt;
		_tmp27_ = yt;
		_tmp28_ = _tmp25_[(_tmp26_ * _tmp25__length2) + _tmp27_];
		_tmp29_ = color;
		_tmp19_ = _tmp28_ != _tmp29_;
	}
	if (_tmp19_) {
		result = 0;
		return result;
	}
	result = enemy_count;
	return result;
}


static gint* _int_dup (gint* self) {
	gint* dup;
	dup = g_new0 (gint, 1);
	memcpy (dup, self, sizeof (gint));
	return dup;
}


static gpointer __int_dup0 (gpointer self) {
	return self ? _int_dup (self) : NULL;
}


static void game_set_tile (Game* self, gint x, gint y) {
	gint _tmp0_;
	gint _tmp1_;
	gint** _tmp2_;
	gint _tmp2__length1;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint** _tmp6_;
	gint _tmp6__length1;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gint* _tmp13_;
	gint* _tmp14_;
	Player* _tmp15_;
	gint _tmp15__length1;
	gint _tmp15__length2;
	gint _tmp16_;
	gint _tmp17_;
	Player _tmp18_;
	Player _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	Player _tmp22_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->history_index;
	_tmp1_ = self->priv->history_index;
	_tmp2_ = self->priv->undo_stack;
	_tmp2__length1 = self->priv->undo_stack_length1;
	_vala_return_if_fail ((_tmp0_ >= -1) && (_tmp1_ < (_tmp2__length1 - 2)), "history_index >= -1 && history_index < undo_stack.length - 2");
	_tmp3_ = game_get_n_current_tiles (self);
	_tmp4_ = _tmp3_;
	game_set_n_current_tiles (self, _tmp4_ + 1);
	_tmp5_ = self->priv->history_index;
	self->priv->history_index = _tmp5_ + 1;
	_tmp6_ = self->priv->undo_stack;
	_tmp6__length1 = self->priv->undo_stack_length1;
	_tmp7_ = self->priv->history_index;
	_tmp8_ = x;
	_tmp9_ = y;
	_tmp10_ = game_get_size (self);
	_tmp11_ = _tmp10_;
	_tmp12_ = _tmp8_ + (_tmp9_ * _tmp11_);
	_tmp13_ = __int_dup0 (&_tmp12_);
	_g_free0 (_tmp6_[_tmp7_]);
	_tmp6_[_tmp7_] = _tmp13_;
	_tmp14_ = _tmp6_[_tmp7_];
	_tmp15_ = self->priv->tiles;
	_tmp15__length1 = self->priv->tiles_length1;
	_tmp15__length2 = self->priv->tiles_length2;
	_tmp16_ = x;
	_tmp17_ = y;
	_tmp18_ = self->priv->_current_color;
	_tmp15_[(_tmp16_ * _tmp15__length2) + _tmp17_] = _tmp18_;
	_tmp19_ = _tmp15_[(_tmp16_ * _tmp15__length2) + _tmp17_];
	_tmp20_ = x;
	_tmp21_ = y;
	_tmp22_ = self->priv->_current_color;
	g_signal_emit (self, game_signals[GAME_SQUARE_CHANGED_SIGNAL], 0, _tmp20_, _tmp21_, _tmp22_);
}


void game_undo (Game* self, gint count) {
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint** _tmp5_;
	gint _tmp5__length1;
	Player enemy = 0;
	Player _tmp6_;
	Player _tmp7_;
	Player _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint** _tmp11_;
	gint _tmp11__length1;
	gint _tmp12_;
	gint* _tmp13_;
	gint _tmp28_;
	g_return_if_fail (self != NULL);
	_tmp0_ = count;
	_tmp1_ = count;
	_vala_return_if_fail ((_tmp0_ == 1) || (_tmp1_ == 2), "count == 1 || count == 2");
	_tmp2_ = self->priv->_number_of_moves;
	_tmp3_ = count;
	_vala_return_if_fail (_tmp2_ >= _tmp3_, "number_of_moves >= count");
	_tmp4_ = self->priv->history_index;
	_tmp5_ = self->priv->undo_stack;
	_tmp5__length1 = self->priv->undo_stack_length1;
	_vala_return_if_fail (_tmp4_ < _tmp5__length1, "history_index < undo_stack.length");
	_tmp6_ = self->priv->_current_color;
	enemy = _tmp6_;
	_tmp7_ = self->priv->_current_color;
	_tmp8_ = player_flip_color (_tmp7_);
	game_set_current_color (self, _tmp8_);
	_tmp9_ = self->priv->_number_of_moves;
	game_set_number_of_moves (self, _tmp9_ - 1);
	_tmp10_ = self->priv->history_index;
	self->priv->history_index = _tmp10_ - 1;
	_tmp11_ = self->priv->undo_stack;
	_tmp11__length1 = self->priv->undo_stack_length1;
	_tmp12_ = self->priv->history_index;
	_tmp13_ = _tmp11_[_tmp12_];
	if (_tmp13_ != NULL) {
		gint** _tmp14_;
		gint _tmp14__length1;
		gint _tmp15_;
		gint* _tmp16_;
		_tmp14_ = self->priv->undo_stack;
		_tmp14__length1 = self->priv->undo_stack_length1;
		_tmp15_ = self->priv->history_index;
		_tmp16_ = _tmp14_[_tmp15_];
		game_unset_tile (self, *_tmp16_, PLAYER_NONE);
		while (TRUE) {
			gboolean _tmp17_ = FALSE;
			gint _tmp18_;
			gint _tmp22_;
			gint _tmp23_;
			gint** _tmp24_;
			gint _tmp24__length1;
			gint _tmp25_;
			gint* _tmp26_;
			Player _tmp27_;
			_tmp18_ = self->priv->history_index;
			if (_tmp18_ > -1) {
				gint** _tmp19_;
				gint _tmp19__length1;
				gint _tmp20_;
				gint* _tmp21_;
				_tmp19_ = self->priv->undo_stack;
				_tmp19__length1 = self->priv->undo_stack_length1;
				_tmp20_ = self->priv->history_index;
				_tmp21_ = _tmp19_[_tmp20_];
				_tmp17_ = _tmp21_ != NULL;
			} else {
				_tmp17_ = FALSE;
			}
			if (!_tmp17_) {
				break;
			}
			_tmp22_ = game_get_n_opponent_tiles (self);
			_tmp23_ = _tmp22_;
			game_set_n_opponent_tiles (self, _tmp23_ + 1);
			_tmp24_ = self->priv->undo_stack;
			_tmp24__length1 = self->priv->undo_stack_length1;
			_tmp25_ = self->priv->history_index;
			_tmp26_ = _tmp24_[_tmp25_];
			_tmp27_ = enemy;
			game_unset_tile (self, *_tmp26_, _tmp27_);
		}
	}
	_tmp28_ = count;
	if (_tmp28_ == 1) {
		game_set_is_complete (self, FALSE);
		game_update_who_can_move (self);
	} else {
		gint _tmp29_;
		_tmp29_ = count;
		game_undo (self, _tmp29_ - 1);
	}
}


static void game_unset_tile (Game* self, gint tile_number, Player replacement_color) {
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint x = 0;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint y = 0;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	Player* _tmp9_;
	gint _tmp9__length1;
	gint _tmp9__length2;
	Player _tmp10_;
	Player _tmp11_;
	Player _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = game_get_n_current_tiles (self);
	_tmp1_ = _tmp0_;
	game_set_n_current_tiles (self, _tmp1_ - 1);
	_tmp2_ = self->priv->history_index;
	self->priv->history_index = _tmp2_ - 1;
	_tmp3_ = tile_number;
	_tmp4_ = game_get_size (self);
	_tmp5_ = _tmp4_;
	x = _tmp3_ % _tmp5_;
	_tmp6_ = tile_number;
	_tmp7_ = game_get_size (self);
	_tmp8_ = _tmp7_;
	y = _tmp6_ / _tmp8_;
	_tmp9_ = self->priv->tiles;
	_tmp9__length1 = self->priv->tiles_length1;
	_tmp9__length2 = self->priv->tiles_length2;
	_tmp10_ = replacement_color;
	_tmp9_[(x * _tmp9__length2) + y] = _tmp10_;
	_tmp11_ = _tmp9_[(x * _tmp9__length2) + y];
	_tmp12_ = replacement_color;
	g_signal_emit (self, game_signals[GAME_SQUARE_CHANGED_SIGNAL], 0, x, y, _tmp12_);
}


gint game_get_size (Game* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_size;
	result = _tmp0_;
	return result;
}


static void game_set_size (Game* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_size = _tmp0_;
	g_object_notify_by_pspec ((GObject *) self, game_properties[GAME_SIZE_PROPERTY]);
}


Player game_get_current_color (Game* self) {
	Player result;
	Player _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_current_color;
	result = _tmp0_;
	return result;
}


static void game_set_current_color (Game* self, Player value) {
	g_return_if_fail (self != NULL);
	if (game_get_current_color (self) != value) {
		Player _tmp0_;
		_tmp0_ = value;
		self->priv->_current_color = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, game_properties[GAME_CURRENT_COLOR_PROPERTY]);
	}
}


gint game_get_number_of_moves (Game* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_number_of_moves;
	result = _tmp0_;
	return result;
}


static void game_set_number_of_moves (Game* self, gint value) {
	g_return_if_fail (self != NULL);
	if (game_get_number_of_moves (self) != value) {
		gint _tmp0_;
		_tmp0_ = value;
		self->priv->_number_of_moves = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, game_properties[GAME_NUMBER_OF_MOVES_PROPERTY]);
	}
}


gboolean game_get_current_player_can_move (Game* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_current_player_can_move;
	result = _tmp0_;
	return result;
}


static void game_set_current_player_can_move (Game* self, gboolean value) {
	g_return_if_fail (self != NULL);
	if (game_get_current_player_can_move (self) != value) {
		gboolean _tmp0_;
		_tmp0_ = value;
		self->priv->_current_player_can_move = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, game_properties[GAME_CURRENT_PLAYER_CAN_MOVE_PROPERTY]);
	}
}


gboolean game_get_is_complete (Game* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_complete;
	result = _tmp0_;
	return result;
}


static void game_set_is_complete (Game* self, gboolean value) {
	g_return_if_fail (self != NULL);
	if (game_get_is_complete (self) != value) {
		gboolean _tmp0_;
		_tmp0_ = value;
		self->priv->_is_complete = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, game_properties[GAME_IS_COMPLETE_PROPERTY]);
	}
}


gint game_get_initial_number_of_tiles (Game* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_initial_number_of_tiles;
	result = _tmp0_;
	return result;
}


static void game_set_initial_number_of_tiles (Game* self, gint value) {
	g_return_if_fail (self != NULL);
	if (game_get_initial_number_of_tiles (self) != value) {
		gint _tmp0_;
		_tmp0_ = value;
		self->priv->_initial_number_of_tiles = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, game_properties[GAME_INITIAL_NUMBER_OF_TILES_PROPERTY]);
	}
}


gint game_get_n_tiles (Game* self) {
	gint result;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = game_get_n_dark_tiles (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = game_get_n_light_tiles (self);
	_tmp3_ = _tmp2_;
	result = _tmp1_ + _tmp3_;
	return result;
}


gint game_get_n_light_tiles (Game* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_n_light_tiles;
	result = _tmp0_;
	return result;
}


gint game_get_n_dark_tiles (Game* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_n_dark_tiles;
	result = _tmp0_;
	return result;
}


gint game_get_n_current_tiles (Game* self) {
	gint result;
	gint _tmp0_ = 0;
	Player _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = self->priv->_current_color;
	if (_tmp1_ == PLAYER_LIGHT) {
		gint _tmp2_;
		gint _tmp3_;
		_tmp2_ = game_get_n_light_tiles (self);
		_tmp3_ = _tmp2_;
		_tmp0_ = _tmp3_;
	} else {
		gint _tmp4_;
		gint _tmp5_;
		_tmp4_ = game_get_n_dark_tiles (self);
		_tmp5_ = _tmp4_;
		_tmp0_ = _tmp5_;
	}
	result = _tmp0_;
	return result;
}


static void game_set_n_current_tiles (Game* self, gint value) {
	Player _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_current_color;
	if (_tmp0_ == PLAYER_LIGHT) {
		gint _tmp1_;
		_tmp1_ = value;
		self->priv->_n_light_tiles = _tmp1_;
	} else {
		gint _tmp2_;
		_tmp2_ = value;
		self->priv->_n_dark_tiles = _tmp2_;
	}
	g_object_notify_by_pspec ((GObject *) self, game_properties[GAME_N_CURRENT_TILES_PROPERTY]);
}


gint game_get_n_opponent_tiles (Game* self) {
	gint result;
	gint _tmp0_ = 0;
	Player _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = self->priv->_current_color;
	if (_tmp1_ == PLAYER_DARK) {
		gint _tmp2_;
		gint _tmp3_;
		_tmp2_ = game_get_n_light_tiles (self);
		_tmp3_ = _tmp2_;
		_tmp0_ = _tmp3_;
	} else {
		gint _tmp4_;
		gint _tmp5_;
		_tmp4_ = game_get_n_dark_tiles (self);
		_tmp5_ = _tmp4_;
		_tmp0_ = _tmp5_;
	}
	result = _tmp0_;
	return result;
}


static void game_set_n_opponent_tiles (Game* self, gint value) {
	Player _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_current_color;
	if (_tmp0_ == PLAYER_DARK) {
		gint _tmp1_;
		_tmp1_ = value;
		self->priv->_n_light_tiles = _tmp1_;
	} else {
		gint _tmp2_;
		_tmp2_ = value;
		self->priv->_n_dark_tiles = _tmp2_;
	}
	g_object_notify_by_pspec ((GObject *) self, game_properties[GAME_N_OPPONENT_TILES_PROPERTY]);
}


static void g_cclosure_user_marshal_VOID__INT_INT_ENUM (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__INT_INT_ENUM) (gpointer data1, gint arg_1, gint arg_2, gint arg_3, gpointer data2);
	register GMarshalFunc_VOID__INT_INT_ENUM callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT_INT_ENUM) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), g_value_get_enum (param_values + 3), data2);
}


static void game_class_init (GameClass * klass) {
	game_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GamePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_game_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_game_set_property;
	G_OBJECT_CLASS (klass)->finalize = game_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_SIZE_PROPERTY, game_properties[GAME_SIZE_PROPERTY] = g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_CURRENT_COLOR_PROPERTY, game_properties[GAME_CURRENT_COLOR_PROPERTY] = g_param_spec_enum ("current-color", "current-color", "current-color", TYPE_PLAYER, PLAYER_DARK, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_NUMBER_OF_MOVES_PROPERTY, game_properties[GAME_NUMBER_OF_MOVES_PROPERTY] = g_param_spec_int ("number-of-moves", "number-of-moves", "number-of-moves", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_CURRENT_PLAYER_CAN_MOVE_PROPERTY, game_properties[GAME_CURRENT_PLAYER_CAN_MOVE_PROPERTY] = g_param_spec_boolean ("current-player-can-move", "current-player-can-move", "current-player-can-move", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_IS_COMPLETE_PROPERTY, game_properties[GAME_IS_COMPLETE_PROPERTY] = g_param_spec_boolean ("is-complete", "is-complete", "is-complete", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_INITIAL_NUMBER_OF_TILES_PROPERTY, game_properties[GAME_INITIAL_NUMBER_OF_TILES_PROPERTY] = g_param_spec_int ("initial-number-of-tiles", "initial-number-of-tiles", "initial-number-of-tiles", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_N_TILES_PROPERTY, game_properties[GAME_N_TILES_PROPERTY] = g_param_spec_int ("n-tiles", "n-tiles", "n-tiles", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_N_LIGHT_TILES_PROPERTY, game_properties[GAME_N_LIGHT_TILES_PROPERTY] = g_param_spec_int ("n-light-tiles", "n-light-tiles", "n-light-tiles", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_N_DARK_TILES_PROPERTY, game_properties[GAME_N_DARK_TILES_PROPERTY] = g_param_spec_int ("n-dark-tiles", "n-dark-tiles", "n-dark-tiles", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_N_CURRENT_TILES_PROPERTY, game_properties[GAME_N_CURRENT_TILES_PROPERTY] = g_param_spec_int ("n-current-tiles", "n-current-tiles", "n-current-tiles", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_N_OPPONENT_TILES_PROPERTY, game_properties[GAME_N_OPPONENT_TILES_PROPERTY] = g_param_spec_int ("n-opponent-tiles", "n-opponent-tiles", "n-opponent-tiles", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	game_signals[GAME_TURN_ENDED_SIGNAL] = g_signal_new ("turn-ended", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	game_signals[GAME_SQUARE_CHANGED_SIGNAL] = g_signal_new ("square-changed", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT_ENUM, G_TYPE_NONE, 3, G_TYPE_INT, G_TYPE_INT, TYPE_PLAYER);
}


static void game_instance_init (Game * self) {
	self->priv = GAME_GET_PRIVATE (self);
	self->priv->history_index = -1;
	self->priv->_current_color = PLAYER_DARK;
	self->priv->_number_of_moves = 0;
	self->priv->_current_player_can_move = TRUE;
	self->priv->_is_complete = FALSE;
	self->priv->_n_light_tiles = 2;
	self->priv->_n_dark_tiles = 2;
}


static void game_finalize (GObject * obj) {
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME, Game);
	self->priv->tiles = (g_free (self->priv->tiles), NULL);
	self->priv->undo_stack = (_vala_array_free (self->priv->undo_stack, self->priv->undo_stack_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (game_parent_class)->finalize (obj);
}


GType game_get_type (void) {
	static volatile gsize game_type_id__volatile = 0;
	if (g_once_init_enter (&game_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Game), 0, (GInstanceInitFunc) game_instance_init, NULL };
		GType game_type_id;
		game_type_id = g_type_register_static (G_TYPE_OBJECT, "Game", &g_define_type_info, 0);
		g_once_init_leave (&game_type_id__volatile, game_type_id);
	}
	return game_type_id__volatile;
}


static void _vala_game_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME, Game);
	switch (property_id) {
		case GAME_SIZE_PROPERTY:
		g_value_set_int (value, game_get_size (self));
		break;
		case GAME_CURRENT_COLOR_PROPERTY:
		g_value_set_enum (value, game_get_current_color (self));
		break;
		case GAME_NUMBER_OF_MOVES_PROPERTY:
		g_value_set_int (value, game_get_number_of_moves (self));
		break;
		case GAME_CURRENT_PLAYER_CAN_MOVE_PROPERTY:
		g_value_set_boolean (value, game_get_current_player_can_move (self));
		break;
		case GAME_IS_COMPLETE_PROPERTY:
		g_value_set_boolean (value, game_get_is_complete (self));
		break;
		case GAME_INITIAL_NUMBER_OF_TILES_PROPERTY:
		g_value_set_int (value, game_get_initial_number_of_tiles (self));
		break;
		case GAME_N_TILES_PROPERTY:
		g_value_set_int (value, game_get_n_tiles (self));
		break;
		case GAME_N_LIGHT_TILES_PROPERTY:
		g_value_set_int (value, game_get_n_light_tiles (self));
		break;
		case GAME_N_DARK_TILES_PROPERTY:
		g_value_set_int (value, game_get_n_dark_tiles (self));
		break;
		case GAME_N_CURRENT_TILES_PROPERTY:
		g_value_set_int (value, game_get_n_current_tiles (self));
		break;
		case GAME_N_OPPONENT_TILES_PROPERTY:
		g_value_set_int (value, game_get_n_opponent_tiles (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_game_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME, Game);
	switch (property_id) {
		case GAME_SIZE_PROPERTY:
		game_set_size (self, g_value_get_int (value));
		break;
		case GAME_CURRENT_COLOR_PROPERTY:
		game_set_current_color (self, g_value_get_enum (value));
		break;
		case GAME_NUMBER_OF_MOVES_PROPERTY:
		game_set_number_of_moves (self, g_value_get_int (value));
		break;
		case GAME_CURRENT_PLAYER_CAN_MOVE_PROPERTY:
		game_set_current_player_can_move (self, g_value_get_boolean (value));
		break;
		case GAME_IS_COMPLETE_PROPERTY:
		game_set_is_complete (self, g_value_get_boolean (value));
		break;
		case GAME_INITIAL_NUMBER_OF_TILES_PROPERTY:
		game_set_initial_number_of_tiles (self, g_value_get_int (value));
		break;
		case GAME_N_CURRENT_TILES_PROPERTY:
		game_set_n_current_tiles (self, g_value_get_int (value));
		break;
		case GAME_N_OPPONENT_TILES_PROPERTY:
		game_set_n_opponent_tiles (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



